/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_PAV.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	void cfg_pushArgv(struct Cfg_Getopt *optstru, char **argv
	 , Cfg_FctGetopt getfct)

ob(ject): cfg_pushArgv
su(bsystem): cmdline
ty(pe): LH
sy(nopsis): 
sh(ort description): Push a broken-up command line
he(ader files): 
lo(ng description): Push an already broken-up command line onto the
	input stack. This is a back-end function, which gets passed the
	argument array and the function to read it.
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_pav.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <portable.h>
#include "dynstr.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_PAV.C 1.5 1999/12/13 02:22:01 ska Exp ska $";
#endif

void cfg_pushArgv(struct Cfg_Getopt * const optstru
 , const char * const * const argv, Cfg_FctGetopt getfct)
{	struct Cfg_ArgArgv *p;

	DBG_ENTER("cfg_pushArgv", Suppl_cmdline)

	if(argv && *argv) {
		p = Emalloc(sizeof(struct Cfg_ArgArgv));
		p->cfg_a_p = *(p->cfg_a_argv = argv + 1);
		p->cfg_a_quote = 0;
		cfg_addContext(optstru, (void*)p, getfct, aF(cfg_clFreeArg));
	}
	chkHeap
	DBG_EXIT
}
