/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*  $RCSfile: ENV_PUT.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): putenv
su(bsystem): env
ty(pe): 
sh(ort description): Insert/replace/remove a variable
lo(ng description): Inserts, replaces or removes a variable from the
	default environment.\par
	The passed string must conform to the syntax: "<var>=<value>",
	where "<var>" is the name of the variable and "<value>" its value.
	Both may be empty, however, the equal sign '=' must be present.\par
	If "<value>" is empty, the variable is removed; otherwise, the
	variable is inserted or replaced, if it is already stored within the
	environment.
pr(erequistes): An equal sign must be present in the passed in string.
re(lated to): env_change
se(condary subsystems): 
in(itialized by): 
wa(rning): Unlike other implementations \tok{putenv()} matches the
 name of the variable case-sensitively.
bu(gs): Although the passed string is \tok{(const)}, it is temporarily
	modified during the life-time of this function.
va(lue): \tok{0}: failed to insert the variable
	\item\tok{1}: variable replaced
	\item\tok{2}: variable not found (to be removed)
	\item\tok{3}: variable newly inserted
	\item\tok{-1}: parameter out of range (missing equal sign)
fi(le): env_put.c

 */

#include "initsupl.loc"

#ifndef _MICROC_
#include <dos.h>
#include <string.h>
#endif
#include <portable.h>
#include "environ.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: ENV_PUT.C 2.6 2001/02/27 01:28:59 ska Exp ska $";
#endif

int putenv(const char *var)
{	char *p;		/* Pointer to the '=' sign */
	int err;

	DBG_ENTER("putenv", Suppl_env)
	DBG_ARGUMENTS( ("str=\"%s\"", var) )

	if(var == 0 || (p = strchr(var, '=')) == 0)
		DBG_RETURN_I( -1)		/* ill-formed parameter */

	*p = '\0';			/* mark the end of the name to call chgenv() */

	err = chgenv(var, p[1]? p + 1: 0);
		/* if empty value => remove variable */

	*p = '=';			/* restore original string */

	DBG_RETURN_I( err)
}
