/* original parser id follows */
/* yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93" */
/* (use YYMAJOR/YYMINOR for ifdefs dependent on parser version) */

#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYPATCH 20140715

#define YYEMPTY        (-1)
#define yyclearin      (yychar = YYEMPTY)
#define yyerrok        (yyerrflag = 0)
#define YYRECOVERING() (yyerrflag != 0)
#define YYENOMEM       (-2)
#define YYEOF          0
#define YYPREFIX "yy"

#define YYPURE 0

#line 2 "../../../vice/src/monitor/mon_parse.y"
/* -*- C -*-
 *
 * mon_parse.y - Parser for the VICE built-in monitor.
 *
 * Written by
 *  Daniel Sladic <sladic@eecg.toronto.edu>
 *  Andreas Boose <viceteam@t-online.de>
 *  Thomas Giesel <skoe@directbox.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#include "vice.h"

#if !defined(__minix_vmd) && !defined(MACOS_COMPILE)
#ifdef __GNUC__
#undef alloca
#ifndef ANDROID_COMPILE
#define        alloca(n)       __builtin_alloca (n)
#endif
#else
#ifdef HAVE_ALLOCA_H
#include <alloca.h>
#else  /* Not HAVE_ALLOCA_H.  */
#if !defined(_AIX) && !defined(WINCE)
#ifndef _MSC_VER
extern char *alloca();
#else
#define alloca(n)   _alloca(n)
#endif  /* MSVC */
#endif /* Not AIX and not WINCE.  */
#endif /* HAVE_ALLOCA_H.  */
#endif /* GCC.  */
#endif /* MINIXVMD */

/* SunOS 4.x specific stuff */
#if defined(sun) || defined(__sun)
#  if !defined(__SVR4) && !defined(__svr4__)
#    ifdef __sparc__
#      define YYFREE
#    endif
#  endif
#endif

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "asm.h"
#include "console.h"
#include "lib.h"
#include "machine.h"
#include "mon_breakpoint.h"
#include "mon_command.h"
#include "mon_disassemble.h"
#include "mon_drive.h"
#include "mon_file.h"
#include "mon_memmap.h"
#include "mon_memory.h"
#include "mon_register.h"
#include "mon_util.h"
#include "montypes.h"
#include "resources.h"
#include "types.h"
#include "uimon.h"


#define join_ints(x,y) (LO16_TO_HI16(x)|y)
#define separate_int1(x) (HI16_TO_LO16(x))
#define separate_int2(x) (LO16(x))

static int yyerror(char *s);
static int temp;
static int resolve_datatype(unsigned guess_type, const char *num);
static int resolve_range(enum t_memspace memspace, MON_ADDR range[2],
                         const char *num);

#ifdef __IBMC__
static void __yy_memcpy (char *to, char *from, int count);
#endif

/* Defined in the lexer */
extern int new_cmd, opt_asm;
extern void free_buffer(void);
extern void make_buffer(char *str);
extern int yylex(void);
extern int cur_len, last_len;

#define ERR_ILLEGAL_INPUT 1     /* Generic error as returned by yacc.  */
#define ERR_RANGE_BAD_START 2
#define ERR_RANGE_BAD_END 3
#define ERR_BAD_CMD 4
#define ERR_EXPECT_CHECKNUM 5
#define ERR_EXPECT_END_CMD 6
#define ERR_MISSING_CLOSE_PAREN 7
#define ERR_INCOMPLETE_COMPARE_OP 8
#define ERR_EXPECT_FILENAME 9
#define ERR_ADDR_TOO_BIG 10
#define ERR_IMM_TOO_BIG 11
#define ERR_EXPECT_STRING 12
#define ERR_UNDEFINED_LABEL 13
#define ERR_EXPECT_DEVICE_NUM 14
#define ERR_EXPECT_ADDRESS 15
#define ERR_INVALID_REGISTER 16

#define BAD_ADDR (new_addr(e_invalid_space, 0))
#define CHECK_ADDR(x) ((x) == addr_mask(x))

#define YYDEBUG 1

#line 132 "../../../vice/src/monitor/mon_parse.y"
#ifdef YYSTYPE
#undef  YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
#endif
#ifndef YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
typedef union {
    MON_ADDR a;
    MON_ADDR range[2];
    int i;
    REG_ID reg;
    CONDITIONAL cond_op;
    cond_node_t *cond_node;
    RADIXTYPE rt;
    ACTION action;
    char *str;
    asm_mode_addr_info_t mode;
} YYSTYPE;
#endif /* !YYSTYPE_IS_DECLARED */
#line 170 "../../../vice/src/monitor/mon_parse.c"

/* compatibility with bison */
#ifdef YYPARSE_PARAM
/* compatibility with FreeBSD */
# ifdef YYPARSE_PARAM_TYPE
#  define YYPARSE_DECL() yyparse(YYPARSE_PARAM_TYPE YYPARSE_PARAM)
# else
#  define YYPARSE_DECL() yyparse(void *YYPARSE_PARAM)
# endif
#else
# define YYPARSE_DECL() yyparse(void)
#endif

/* Parameters sent to lex. */
#ifdef YYLEX_PARAM
# define YYLEX_DECL() yylex(void *YYLEX_PARAM)
# define YYLEX yylex(YYLEX_PARAM)
#else
# define YYLEX_DECL() yylex(void)
# define YYLEX yylex()
#endif

/* Parameters sent to yyerror. */
#ifndef YYERROR_DECL
#define YYERROR_DECL() yyerror(const char *s)
#endif
#ifndef YYERROR_CALL
#define YYERROR_CALL(msg) yyerror(msg)
#endif

extern int YYPARSE_DECL();

#define H_NUMBER 257
#define D_NUMBER 258
#define O_NUMBER 259
#define B_NUMBER 260
#define CONVERT_OP 261
#define B_DATA 262
#define H_RANGE_GUESS 263
#define D_NUMBER_GUESS 264
#define O_NUMBER_GUESS 265
#define B_NUMBER_GUESS 266
#define BAD_CMD 267
#define MEM_OP 268
#define IF 269
#define MEM_COMP 270
#define MEM_DISK8 271
#define MEM_DISK9 272
#define MEM_DISK10 273
#define MEM_DISK11 274
#define EQUALS 275
#define TRAIL 276
#define CMD_SEP 277
#define LABEL_ASGN_COMMENT 278
#define CMD_SIDEFX 279
#define CMD_RETURN 280
#define CMD_BLOCK_READ 281
#define CMD_BLOCK_WRITE 282
#define CMD_UP 283
#define CMD_DOWN 284
#define CMD_LOAD 285
#define CMD_SAVE 286
#define CMD_VERIFY 287
#define CMD_IGNORE 288
#define CMD_HUNT 289
#define CMD_FILL 290
#define CMD_MOVE 291
#define CMD_GOTO 292
#define CMD_REGISTERS 293
#define CMD_READSPACE 294
#define CMD_WRITESPACE 295
#define CMD_RADIX 296
#define CMD_MEM_DISPLAY 297
#define CMD_BREAK 298
#define CMD_TRACE 299
#define CMD_IO 300
#define CMD_BRMON 301
#define CMD_COMPARE 302
#define CMD_DUMP 303
#define CMD_UNDUMP 304
#define CMD_EXIT 305
#define CMD_DELETE 306
#define CMD_CONDITION 307
#define CMD_COMMAND 308
#define CMD_ASSEMBLE 309
#define CMD_DISASSEMBLE 310
#define CMD_NEXT 311
#define CMD_STEP 312
#define CMD_PRINT 313
#define CMD_DEVICE 314
#define CMD_HELP 315
#define CMD_WATCH 316
#define CMD_DISK 317
#define CMD_QUIT 318
#define CMD_CHDIR 319
#define CMD_BANK 320
#define CMD_LOAD_LABELS 321
#define CMD_SAVE_LABELS 322
#define CMD_ADD_LABEL 323
#define CMD_DEL_LABEL 324
#define CMD_SHOW_LABELS 325
#define CMD_CLEAR_LABELS 326
#define CMD_RECORD 327
#define CMD_MON_STOP 328
#define CMD_PLAYBACK 329
#define CMD_CHAR_DISPLAY 330
#define CMD_SPRITE_DISPLAY 331
#define CMD_TEXT_DISPLAY 332
#define CMD_SCREENCODE_DISPLAY 333
#define CMD_ENTER_DATA 334
#define CMD_ENTER_BIN_DATA 335
#define CMD_KEYBUF 336
#define CMD_BLOAD 337
#define CMD_BSAVE 338
#define CMD_SCREEN 339
#define CMD_UNTIL 340
#define CMD_CPU 341
#define CMD_YYDEBUG 342
#define CMD_BACKTRACE 343
#define CMD_SCREENSHOT 344
#define CMD_PWD 345
#define CMD_DIR 346
#define CMD_RESOURCE_GET 347
#define CMD_RESOURCE_SET 348
#define CMD_LOAD_RESOURCES 349
#define CMD_SAVE_RESOURCES 350
#define CMD_ATTACH 351
#define CMD_DETACH 352
#define CMD_MON_RESET 353
#define CMD_TAPECTRL 354
#define CMD_CARTFREEZE 355
#define CMD_CPUHISTORY 356
#define CMD_MEMMAPZAP 357
#define CMD_MEMMAPSHOW 358
#define CMD_MEMMAPSAVE 359
#define CMD_COMMENT 360
#define CMD_LIST 361
#define CMD_STOPWATCH 362
#define RESET 363
#define CMD_EXPORT 364
#define CMD_AUTOSTART 365
#define CMD_AUTOLOAD 366
#define CMD_LABEL_ASGN 367
#define L_PAREN 368
#define R_PAREN 369
#define ARG_IMMEDIATE 370
#define REG_A 371
#define REG_X 372
#define REG_Y 373
#define COMMA 374
#define INST_SEP 375
#define L_BRACKET 376
#define R_BRACKET 377
#define LESS_THAN 378
#define REG_U 379
#define REG_S 380
#define REG_PC 381
#define REG_PCR 382
#define REG_B 383
#define REG_C 384
#define REG_D 385
#define REG_E 386
#define REG_H 387
#define REG_L 388
#define REG_AF 389
#define REG_BC 390
#define REG_DE 391
#define REG_HL 392
#define REG_IX 393
#define REG_IY 394
#define REG_SP 395
#define REG_IXH 396
#define REG_IXL 397
#define REG_IYH 398
#define REG_IYL 399
#define PLUS 400
#define MINUS 401
#define STRING 402
#define FILENAME 403
#define R_O_L 404
#define OPCODE 405
#define LABEL 406
#define BANKNAME 407
#define CPUTYPE 408
#define MON_REGISTER 409
#define COMPARE_OP 410
#define RADIX_TYPE 411
#define INPUT_SPEC 412
#define CMD_CHECKPT_ON 413
#define CMD_CHECKPT_OFF 414
#define TOGGLE 415
#define MASK 416
#define YYERRCODE 256
typedef short YYINT;
static const YYINT yylhs[] = {                           -1,
    0,    0,    0,   32,   32,   34,   34,   34,   33,   33,
   33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
   33,   35,   35,   35,   35,   35,   35,   35,   35,   35,
   35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
   35,   35,   35,   35,   35,   35,   48,   48,   48,   36,
   36,   36,   36,   36,   36,   36,   36,   36,   36,   36,
   36,   36,   51,   38,   38,   38,   38,   37,   37,   37,
   37,   37,   37,   37,   37,   37,   37,   37,   37,   37,
   37,   37,   37,   37,   37,   37,   37,   39,   39,   39,
   39,   39,   39,   39,   39,   40,   40,   40,   40,   40,
   40,   40,   40,   40,   40,   40,   41,   41,   41,   41,
   41,   41,   41,   41,   42,   42,   42,   42,   42,   42,
   42,   42,   42,   42,   42,   42,   42,   42,   42,   42,
   42,   42,   42,   42,   42,   42,   42,   43,   43,   43,
   43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
   43,   43,   43,   43,   43,   43,   44,   44,   44,   45,
   45,   46,   22,   23,   23,   26,   26,   12,   12,   17,
   17,   18,   18,   21,   21,   49,   49,   52,   16,   16,
    2,    2,    1,    1,    1,    4,    4,    3,    3,    3,
   47,   47,   13,   13,   13,   13,   13,   14,   15,    9,
    9,    9,    9,    9,    9,    9,    5,    5,    6,    6,
    6,    6,    6,    7,    7,   24,   24,   25,   25,   27,
   27,   28,   28,   28,   19,   19,   10,   10,   10,   10,
   11,   11,   11,    8,    8,    8,    8,    8,   53,   53,
   53,   20,   50,   50,   29,   29,   29,   29,   29,   29,
   29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
   29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
   29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
   29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
   29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
   29,   29,   29,   29,   29,   29,   30,   30,   30,   30,
   31,
};
static const YYINT yylen[] = {                            2,
    1,    2,    1,    1,    2,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    2,    3,    3,    5,    3,    2,    2,    3,    2,
    3,    2,    4,    2,    3,    3,    2,    4,    2,    4,
    2,    4,    2,    4,    2,    1,    2,    3,    3,    5,
    3,    5,    3,    5,    3,    5,    3,    2,    3,    2,
    4,    5,    0,    5,    3,    3,    2,    5,    5,    5,
    5,    5,    3,    2,    3,    2,    3,    2,    3,    2,
    3,    2,    2,    2,    4,    5,    5,    5,    2,    3,
    2,    5,    2,    5,    2,    3,    2,    3,    2,    3,
    5,    3,    2,    5,    5,    4,    3,    2,    3,    2,
    3,    2,    2,    2,    3,    3,    2,    3,    3,    3,
    3,    2,    3,    2,    3,    5,    3,    4,    3,    3,
    2,    4,    4,    2,    3,    3,    2,    5,    5,    5,
    3,    4,    5,    4,    5,    4,    5,    5,    2,    3,
    4,    3,    3,    5,    3,    5,    3,    2,    3,    4,
    2,    2,    1,    1,    0,    1,    1,    1,    1,    2,
    1,    1,    0,    1,    2,    3,    1,    3,    1,    1,
    1,    1,    3,    1,    3,    2,    0,    1,    3,    1,
    1,    0,    1,    1,    1,    1,    1,    1,    1,    3,
    3,    3,    3,    3,    3,    1,    2,    0,    3,    3,
    3,    3,    1,    1,    1,    3,    1,    1,    1,    2,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    3,    3,
    2,    2,    1,    1,    2,    1,    3,    3,    3,    3,
    3,    5,    7,    5,    3,    3,    3,    3,    3,    3,
    5,    5,    5,    5,    0,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    2,    3,    3,    4,    3,    4,    2,
    3,    3,    3,    3,    5,    5,    6,    5,    6,    4,
    5,    5,    5,    5,    3,    5,    1,    1,    1,    1,
    1,
};
static const YYINT yydefred[] = {                         0,
    0,   21,    3,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    4,    9,   10,   11,   12,   13,
   14,   15,   16,   17,   18,   19,   20,   46,  234,  235,
  236,  237,  233,  232,  231,  193,  194,  195,  196,  197,
  174,    0,  225,    0,  238,    0,  206,  226,    8,    7,
    6,    0,  108,   34,    0,    0,  191,   41,    0,   43,
    0,  167,  166,    0,    0,    0,  180,  227,  230,  229,
  228,  179,    0,  184,  190,    0,    0,  199,    0,  188,
  198,    0,    0,    0,    0,   27,    0,    0,   47,    0,
  177,    0,  110,    0,  181,    0,    0,   74,  171,    0,
    0,   89,    0,   95,    0,   28,    0,    0,    0,  114,
    0,    0,  103,    0,    0,    0,    0,   67,   39,    0,
   37,    0,    0,    0,  163,    0,  117,    0,   93,    0,
  113,    0,    0,    0,   22,    0,    0,    0,    0,    0,
    0,    0,    0,   58,    0,   60,    0,  158,    0,    0,
   76,    0,   78,    0,   80,    0,   82,    0,  161,    0,
    0,    0,   45,    0,   91,    0,   30,  162,  122,    0,
  124,  164,    0,    0,    0,    0,    0,    0,    0,  131,
    0,    0,  134,   32,    0,   83,   84,    0,    0,    0,
    0,    0,    0,  149,    0,  137,  112,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  268,    0,  270,
  271,  274,  277,  278,  279,  280,  281,  282,  283,  272,
  275,  273,  276,    0,  242,    0,   97,    0,   99,    2,
    5,    0,    0,    0,    0,    0,  119,  175,  107,    0,
    0,    0,    0,  169,    0,    0,    0,    0,  100,    0,
    0,    0,    0,    0,    0,   26,    0,   48,    0,    0,
   49,  109,    0,   73,  170,    0,    0,   29,    0,   35,
   36,  102,    0,    0,    0,   65,    0,   66,    0,    0,
  116,  111,  118,    0,  115,  120,   24,   23,    0,    0,
   51,    0,   53,    0,   55,    0,   57,   59,  157,  159,
   75,   77,   79,   81,  219,  218,    0,  217,  121,    0,
    0,   90,   31,  125,    0,  123,  127,    0,  129,  130,
    0,  152,    0,    0,    0,    0,    0,  135,  150,  136,
  153,    0,  155,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  245,    0,  307,  308,  311,  310,    0,    0,
  309,    0,    0,    0,    0,    0,  284,    0,    0,    0,
   96,   98,  205,  204,    0,    0,  202,  203,    0,    0,
    0,   42,   44,    0,  142,    0,  146,    0,    0,  224,
  223,  222,    0,  221,  183,  185,  189,    0,    0,  178,
  176,    0,    0,    0,    0,    0,    0,    0,  213,  215,
  214,  106,    0,    0,    0,    0,   40,   38,    0,    0,
    0,    0,    0,    0,  160,    0,    0,  144,    0,    0,
  128,  151,  132,  133,   33,    0,   85,    0,    0,    0,
    0,   61,  255,  256,  257,  258,  259,  260,    0,    0,
  292,    0,  288,    0,    0,    0,    0,    0,    0,    0,
    0,  291,  293,  247,  248,  249,  294,  250,  285,  147,
  186,  148,  138,  140,  145,  101,  220,   71,   70,   68,
   72,    0,   88,   94,   69,    0,    0,  104,  105,    0,
   64,    0,   92,   25,   50,   52,   54,   56,  216,  139,
  143,  126,   86,   87,  154,  156,   62,    0,    0,    0,
  289,  287,    0,    0,    0,  300,    0,    0,    0,    0,
    0,    0,  212,  211,  210,  209,  240,  239,  261,  254,
  262,  263,  264,  252,    0,  302,    0,  298,  296,    0,
  301,  303,  304,  295,  306,    0,  299,  297,  253,
};
static const YYINT yydgoto[] = {                         92,
  175,  176,  177,  449,  474,  478,  479,  158,  272,  152,
  125,  273,  126,  160,  161,  153,  180,  181,  127,   93,
  128,  206,  253,  387,  388,  144,  463,  464,  305,  430,
  431,   94,   95,  133,   96,   97,   98,   99,  100,  101,
  102,  103,  104,  105,  106,  107,  450,  108,  170,  485,
  357,  171,  486,
};
static const YYINT yysindex[] = {                      1359,
  144,    0,    0, -236,   99,  144,  144, -120, -120, -253,
 -253, -253,  576, 1747, 1747, 1747, 1481,  -83, -226,  739,
  316,  316, 1481, 1747, -253, -253,   99,  817,  576,  576,
 1824, 1010, -120, -120,  144,  461, -151,  316, -392,   99,
 -392,  356,  -26,  -26, 1824, -141,  149,  149, -253,   99,
 -253, 1010, 1010, 1010, 1010, 1824,   99, -392, -253, -253,
   99, 1010, -153,   99,   99, -253,   99, -372, -363, -337,
 -253, -253, -253,  144, -120, -298,   99, -120,   99, -120,
 -253, -372,   34,   26,   99, -253, -253, -174, 1867,  817,
  817,    0, -124, 1495,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  144,    0,  -14,    0, -240,    0,    0,    0,    0,
    0,   99,    0,    0,  555,  555,    0,    0,  144,    0,
  144,    0,    0,  176,  317,  176,    0,    0,    0,    0,
    0,    0, -120,    0,    0, -298, -298,    0, -298,    0,
    0, -298, -298,   99, -298,    0, -181, -105,    0,  -95,
    0,   99,    0, -298,    0,   99, -298,    0,    0,  -90,
 1747,    0, 1747,    0,   99,    0, -298,   99,   99,    0,
    0,   99,    0,  -77, -232,   99,   99,    0,    0,  144,
    0,  144,  -14,   99,    0,   99,    0, 1747,    0,   99,
    0,   99,   99, -120,    0, -298,   99, -298,   99, -298,
   99, -298,   99,    0,   99,    0,   99,    0,   99,   99,
    0,   99,    0,   99,    0,   99,    0,  133,    0,   99,
  176,  176,    0,   99,    0,   99,    0,    0,    0, -120,
    0,    0,   99,   99, -207,   99,   99,  144,  -14,    0,
  144,  144,    0,    0,  144,    0,    0,  144, -298,   99,
    0,  664,   99,    0,   99,    0,    0, -120, -120, 1824,
 1338, 1043, -177,  350, 1198, 1043, -176,    0, -171,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, -152,    0,   99,    0,   99,    0,    0,
    0,   12,  144,  144,  144,  144,    0,    0,    0,  -20,
  619,  -14,  -14,    0, -298,    0, 1681, 1724,    0,  144,
 -167, 1824,  838,  133, 1824,    0, 1043,    0, 1043,  278,
    0,    0, 1747,    0,    0,  -69,  -69,    0, 1824,    0,
    0,    0, 1625,   99, -178,    0, -179,    0,  -14,  -14,
    0,    0,    0,  -69,    0,    0,    0,    0, -175, -253,
    0, -253,    0, -170,    0, -168,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -120,    0,    0, -298,
 1700,    0,    0,    0,  144,    0,    0,   99,    0,    0,
  -14,    0,  -14,  -14,  -14,  865,  144,    0,    0,    0,
    0, 1043,    0, 1043,   85, -126, -119, -118, -113, -100,
  -97, -361,    0,  -52,    0,    0,    0,    0,  430, -161,
    0,  -99,  444,  -91,  -88, -210,    0,  -52,  -52,  794,
    0,    0,    0,    0,   25,   25,    0,    0,   99, 1824,
   99,    0,    0,   99,    0,   99,    0,   99,  -14,    0,
    0,    0, -196,    0,    0,    0,    0, -120,   99,    0,
    0,   99, 1625,   99,   99,   99, 1625, -198,    0,    0,
    0,    0,   99, -101,   99,  -98,    0,    0,   99,   99,
   99,   99,   99,   99,    0,  133,   99,    0,   99,  -14,
    0,    0,    0,    0,    0,   99,    0,  -14,   99,   99,
   99,    0,    0,    0,    0,    0,    0,    0,  -85, -225,
    0,  -52,    0,  -84,  -52,  495, -306,  -52,  -52,  274,
  -79,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  -93,    0,    0,    0, -252, 1607,    0,    0, -179,
    0, -179,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  173,  -60,  -51,
    0,    0,  -53,  -52,  -46,    0, -294,  -42,  -34,  -33,
  -30,  -39,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  -24,    0,  -19,    0,    0,  -18,
    0,    0,    0,    0,    0,  -22,    0,    0,    0,
};
static const YYINT yyrindex[] = {                         0,
    0,    0,    0,    0,    0,    0,    0,  599,  599,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1765, 1765,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  599,  599,    0,    0,    0, 1765,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  151,    0,    0,
    0,    0,    0,    0,  599,  599,    0,  599,    0,  599,
    0,  151,    0,    0,    0,    0,    0,    0, -117,    0,
    0,    0,    0,  360,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  599,    0,    0, -150, 1843,    0, 1032,    0,
    0,  724, 1843,    0, 1149,    0,    0,    0,    0,    0,
    0,    0,    0, 1783,    0,    0, 1161,    0,    0, 1803,
    0,    0,    0,    0,    0,    0, 1843,    0,    0,    0,
 1038,    0,    0,    0,  -15,  -36,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   24,    0, -249,    0, -249,    0,  -23,
    0,  -23,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  599,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  599,    0,
 1193,  770,    0,    0,    0,    0,    0, 1149, 1149,    0,
    0,    0,  -43,    0,    0,    0,   20,    0,   63,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   69,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1659,
    0,    0,    0,    0, 1659,  898,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  214,  214,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  214,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  724,    0,    0, 1659,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  229,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  108,  702,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  724,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  256,    0,  330,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  262,    0,
    0,    0,    0,  266,    0,    0,    0,    0,    0,    0,
  338,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  368,    0,    0,    0,    0,    0,    0,    0,  418,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,
};
static const YYINT yygindex[] = {                         0,
   -5,   -6,   21, -304, -201, -336,    0,   -1,  423,    0,
    0, -130,  742, -157,    0,  180,    0,   82,    0, -355,
  -17,   61,  306,  103,  -44, 1550,    0,  -10,    0, -311,
    5,    0,  363,  446,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    9,    0,    0,    0,
    0,  119,    0,
};
#define YYTABLESIZE 2266
static const YYINT yytable[] = {                        123,
  168,  484,  142,  593,  123,  123,  192,  519,  156,  162,
  163,  205,  520,  325,  327,  328,  139,  141,  187,  129,
  454,  315,  313,  354,  314,  197,  316,  315,  313,  129,
  314,  252,  316,  123,  157,  157,  157,  164,  254,  130,
  131,  200,  202,  185,  157,  230,  232,  234,  236,  130,
  131,  196,  444,  315,  313,  244,  314,  129,  316,  129,
  109,  110,  111,  112,  255,  220,  315,  113,  114,  115,
  586,  316,  123,  122,  129,  137,  238,  130,  131,  130,
  131,  123,  609,  261,  262,  497,  265,  304,  268,  109,
  110,  111,  112,  587,  130,  131,  113,  114,  115,  210,
  280,  212,  129,  183,  129,  610,  192,  192,  192,  192,
  390,  391,  521,  192,  192,  192,  594,  523,  240,  208,
  123,  527,  130,  131,  130,  131,  532,  533,  116,  117,
  118,  119,  120,  123,  123,  129,  552,  123,  265,  123,
  556,  137,  123,  123,  123,  475,  579,  200,  200,  143,
  200,  310,  200,  192,  580,  130,  131,  557,  265,  265,
  129,  330,  489,  530,  331,  332,  531,  333,  318,  339,
  334,  335,  129,  337,  346,  467,  347,  345,  132,  467,
  130,  131,  343,  122,  172,  332,  116,  117,  118,  119,
  120,  353,  130,  131,  398,  349,  424,  438,  123,  473,
  123,  364,  439,  355,  597,  460,  598,  192,  194,  195,
  581,  557,  266,  583,  585,  122,  588,  589,  591,  461,
  596,  440,  369,  483,  370,   89,  372,  318,  374,  142,
  376,  490,  266,  266,  460,  493,  386,  494,  524,  123,
  123,  129,  513,  116,  117,  118,  119,  120,  461,  514,
  515,  192,  205,  137,  246,  516,  123,  265,  395,  123,
  123,  130,  131,  123,  221,  192,  123,  443,  517,  306,
  308,  518,  607,  560,  525,  267,  562,  407,  340,  422,
  423,  129,  528,  436,  437,  529,  412,  414,  578,  271,
  109,  110,  111,  112,  592,  267,  267,  113,  114,  115,
  415,  130,  131,  116,  117,  118,  119,  120,  604,  130,
  131,  123,  123,  123,  123,  582,  557,  605,  269,  425,
  426,  456,  168,  606,  246,  121,  427,  428,  123,  462,
  608,  266,  386,  615,  611,  481,  472,  470,  269,  269,
  129,  451,  612,  613,  246,  246,  614,  157,  458,  616,
  619,  480,  465,  137,  129,  469,  122,  617,  618,    1,
  130,  131,  511,  200,  200,  200,  200,  200,   63,  476,
  200,  200,  200,  200,  130,  131,  143,  200,  200,  200,
  200,  200,  192,  200,  200,  499,  192,  270,  275,  109,
  110,  111,  112,  123,  267,  496,  113,  114,  115,  506,
  109,  110,  111,  112,  129,  123,  165,  113,  114,  115,
  509,  157,  510,  116,  117,  118,  119,  120,  116,  117,
  118,  119,  120,  124,  130,  131,  165,  165,  135,  136,
  192,  324,  109,  110,  111,  112,  468,  269,  538,  113,
  114,  115,  121,  246,  539,  116,  117,  118,  119,  120,
  134,  569,  547,  138,  140,  481,  311,  203,  471,  481,
    0,  462,  166,  169,  173,  178,  182,  184,  186,  208,
  541,  480,  190,  193,    0,  480,  496,  198,  199,  201,
    0,  200,  207,  209,  290,  211,    0,  215,    0,  208,
  208,    0,  224,  226,  386,  228,  259,  231,  233,  235,
  237,    0,  239,    0,  290,  290,  243,  245,  247,  248,
  249,  243,  251,  200,    0,    0,  200,  251,    0,    0,
  260,  286,  263,  264,  266,  267,    0,    0,  274,  276,
  277,  243,  243,    0,  385,  307,  309,  251,  251,  481,
    0,  286,  286,  599,  312,  600,    0,  116,  117,  118,
  119,  120,  121,    0,    0,  480,    0,  320,  321,    0,
    0,  322,    0,  323,  601,  602,  603,    0,    0,  317,
    0,  129,  326,  109,  110,  111,  112,  319,    0,    0,
  113,  114,  115,  179,  121,  244,  116,  117,  118,  119,
  120,  130,  131,  305,  122,    0,  315,  313,  329,  314,
    0,  316,    0,  290,    0,  244,  244,    0,    0,  336,
    0,  129,  338,  305,  305,  341,    0,  342,    0,    0,
    0,  344,  359,  207,  360,  116,  117,  118,  119,  120,
  348,  130,  131,  350,  351,    0,  251,  352,  192,    0,
  286,  356,  358,  207,  207,  425,  426,    0,  361,  362,
    0,  363,  427,  428,  590,  365,    0,  366,  367,  368,
  315,  313,  371,  314,  373,  316,  375,    0,  377,    0,
  378,    0,  379,  241,  380,  381,    0,  382,    0,  383,
  401,  384,    0,  403,  404,  389,  121,  405,    0,  392,
  406,  393,    0,  241,  241,  394,    0,    0,  396,  397,
    0,  399,  400,    0,  402,  315,  313,    0,  314,    0,
  316,    0,  305,    0,    0,  408,    0,    0,  409,    0,
  410,  425,  426,  411,  413,  121,    0,    0,  427,  428,
  116,  117,  118,  119,  120,  445,  446,  447,  448,    0,
    0,  201,  201,    0,  201,    0,  201,    0,    0,    0,
  429,  441,  459,  442,    0,  159,  159,  159,  165,  167,
    0,  159,  213,    0,  165,  159,    0,  452,  453,    0,
    0,    0,  165,  159,    0,    0,    0,  204,    0,    0,
    0,    0,    0,  214,  216,  218,  165,  222,  223,  225,
    0,    0,  241,  159,  159,  159,  159,  165,    0,  482,
    0,  425,  426,  159,  487,  488,    0,    0,  427,  428,
    0,  109,  110,  111,  112,  425,  426,  500,  113,  114,
  115,    0,  427,  428,  116,  117,  118,  119,  120,  508,
  522,  147,  495,  148,    0,    0,    0,    0,    0,  149,
  150,  151,    0,  501,  526,    0,  502,    0,  503,  504,
  505,  507,    0,    0,    0,  192,  192,  192,  192,    0,
  512,    0,  192,  192,  192,    0,  425,  426,  192,  192,
  192,  192,  192,  427,  428,  109,  110,  111,  112,    0,
    0,    0,  113,  114,  115,    0,    0,    0,  116,  117,
  118,  119,  120,    0,  540,  584,  542,  141,    0,  543,
    0,  544,    0,  545,  546,    0,  315,  313,  548,  314,
    0,  316,    0,  549,  550,    0,    0,  551,    0,  553,
  554,  555,  159,  558,  159,    0,    0,    0,  559,    0,
  561,    0,    0,    0,  563,  564,  565,  566,  567,  568,
    0,    0,  570,    0,  571,  572,    0,    0,    0,  159,
    0,  573,    0,  574,  575,  576,  577,  201,  201,  201,
  201,  201,    0,  121,  201,  201,  201,  201,    0,    0,
    0,  201,  201,  201,  201,  201,    0,  201,  201,    0,
  192,  192,  192,  192,    0,    0,    0,  192,  192,  192,
    0,    0,    0,    0,  129,  109,  110,  111,  112,    0,
    0,  154,  113,  114,  115,    0,    0,  192,  116,  117,
  118,  119,  120,    0,  130,  131,    0,    0,    0,    0,
    0,  165,    0,    0,  155,  168,  168,  168,  168,  168,
    0,    0,  168,  168,  168,  168,    0,    8,    0,  168,
  168,  168,  168,  168,    0,  168,  168,    0,    0,    0,
  109,  110,  111,  112,    0,    0,    0,  113,  114,  115,
    0,    0,  165,    0,    0,    0,    0,    0,  159,  165,
    0,    0,  191,  165,  148,  201,  165,    0,    0,    0,
  149,  150,  151,    0,  159,    0,    0,    0,    0,    0,
  165,    0,  130,  131,  109,  110,  111,  112,    0,    0,
  466,  113,  114,  115,    0,    0,    0,  201,    0,    0,
  201,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  129,  109,  110,  111,  112,  192,    0,  154,  113,  114,
  115,    0,  159,    0,  116,  117,  118,  119,  120,    0,
  130,  131,    0,  168,  155,    0,    0,  159,    0,  174,
    0,    0,    0,  169,  169,  169,  169,  169,  141,    0,
  169,  169,  169,  169,  141,  534,  535,  169,  169,  169,
  169,  169,  427,  536,  537,  168,  141,  141,  141,  141,
  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,
  141,  165,    8,  141,  141,  141,  141,  141,    0,  141,
  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,
  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,
  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,
  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,
  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,
  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,
    0,  141,  141,  141,  141,  129,  109,  110,  111,  112,
  155,    0,  154,  113,  114,  115,    0,    0,    0,  116,
  117,  118,  119,  120,    0,  130,  131,    0,  192,  192,
  192,  192,    0,  180,  192,  192,  192,  192,    8,  109,
  110,  111,  112,  169,    8,    0,  113,  114,  115,    0,
  141,  141,    0,  180,  180,    0,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    0,    0,    8,    8,    8,    8,    8,    0,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    0,    8,    8,    8,    8,  192,  192,  192,  192,    0,
    0,    0,  192,  192,  192,  155,  182,  192,  192,  192,
  192,    0,    0,    0,  192,  192,  192,    0,    0,  182,
  192,  192,  192,  192,  192,    0,  182,  182,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  169,    0,
    8,    8,    0,    8,  109,  110,  111,  112,    0,    8,
    0,  113,  114,  115,    0,    0,    0,    0,  169,  169,
    0,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    0,    0,    8,    8,
    8,    8,    8,    0,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    0,    8,    8,    8,    8,
  145,  146,    0,    0,    0,    0,  192,    0,  432,    0,
    0,  433,    0,    0,  188,  189,    0,    0,    0,    0,
  434,    0,  435,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  217,  219,  109,  110,  111,  112,  227,    0,
  229,  113,  114,  115,    0,    8,    8,    0,  241,  242,
    0,    0,    0,    0,    0,  250,    0,    0,    0,    1,
  256,  257,  258,    0,    0,    2,    0,    0,    0,    0,
  269,    0,    0,    0,    3,  278,  279,    4,    5,    6,
    7,    8,    9,   10,   11,   12,   13,   14,   15,   16,
   17,   18,    0,    0,   19,   20,   21,   22,   23,    0,
   24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
   44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
   74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
   84,    0,   85,   86,   87,   88,    0,  416,  417,  418,
  419,  420,  421,    0,    0,    0,  129,  109,  110,  111,
  112,    0,    0,    0,  113,  114,  115,    0,    0,    0,
  116,  117,  118,  119,  120,    1,  130,  131,    0,    0,
    0,    2,    0,   89,    0,    0,    0,    0,    0,    0,
    0,   90,   91,    4,    5,    6,    7,    8,    9,   10,
   11,   12,   13,   14,   15,   16,   17,   18,    0,    0,
   19,   20,   21,   22,   23,    0,   24,   25,   26,   27,
   28,   29,   30,   31,   32,   33,   34,   35,   36,   37,
   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,   57,
   58,   59,   60,   61,   62,   63,   64,   65,   66,   67,
   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
   78,   79,   80,   81,   82,   83,   84,    0,   85,   86,
   87,   88,  595,  109,  110,  111,  112,    0,    0,    0,
  113,  114,  115,    0,    0,    0,  116,  117,  118,  119,
  120,  109,  110,  111,  112,    0,  155,    0,  113,  114,
  115,    0,    0,    0,  116,  117,  118,  119,  120,    0,
    0,    0,    0,    0,    0,    0,    0,   90,   91,    0,
    0,    0,    0,    0,  187,  192,  192,  192,  192,  491,
    0,  492,  192,  192,  192,    0,    0,    0,  192,  192,
  192,  192,  192,    0,  187,  187,  455,  109,  110,  111,
  112,    0,    0,  154,  113,  114,  115,    0,    0,    0,
  116,  117,  118,  119,  120,  498,  109,  110,  111,  112,
    0,    0,  154,  113,  114,  115,    0,    0,    0,  116,
  117,  118,  119,  120,  477,    0,    0,    0,    0,  457,
  109,  110,  111,  112,    0,    0,    0,  113,  114,  115,
    0,    0,  477,  116,  117,  118,  119,  120,    0,    0,
    0,    0,    0,  109,  110,  111,  112,    0,    0,  154,
  113,  114,  115,    0,    0,  121,  116,  117,  118,  119,
  120,  173,  173,  173,  173,    0,    0,  173,  173,  173,
  173,    0,    0,  121,  173,  173,  173,  173,  173,  192,
  192,  192,  192,    0,    0,  192,  192,  192,  192,    0,
    0,    0,  192,  192,  192,  192,  192,    0,    0,  172,
  172,  172,  172,    0,  192,  172,  172,  172,  172,    0,
    0,    0,  172,  172,  172,  172,  172,    0,    0,    0,
  109,  110,  111,  112,    0,    0,  155,  113,  114,  115,
    0,    0,    0,  116,  117,  118,  119,  120,    0,  192,
  192,  192,  192,    0,    0,  155,  192,  192,  192,    0,
    0,    0,  192,  192,  192,  192,  192,    0,    0,    0,
    0,    0,    0,  109,  110,  111,  112,    0,    0,  155,
  113,  114,  115,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  155,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  173,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  192,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  172,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  155,
    0,    0,    0,    0,  281,    0,  282,  283,    0,    0,
  284,    0,  285,    0,  286,    0,    0,    0,  192,  287,
  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,
  298,  299,  300,  301,  302,  303,
};
static const YYINT yycheck[] = {                          1,
   18,  357,  256,  256,    6,    7,  256,  369,   14,   15,
   16,  404,  374,  144,  145,  146,    8,    9,   24,  256,
  325,   42,   43,  256,   45,   32,   47,   42,   43,  256,
   45,  404,   47,   35,   14,   15,   16,   17,  402,  276,
  277,   33,   34,   23,   24,   52,   53,   54,   55,  276,
  277,   31,   41,   42,   43,   62,   45,  256,   47,  256,
  257,  258,  259,  260,  402,   45,   42,  264,  265,  266,
  377,   47,   74,   40,  256,  374,   56,  276,  277,  276,
  277,   83,  377,   75,   76,  390,   78,   89,   80,  257,
  258,  259,  260,  400,  276,  277,  264,  265,  266,   39,
  275,   41,  256,   22,  256,  400,  257,  258,  259,  260,
  241,  242,  424,  264,  265,  266,  369,  429,   58,   38,
  122,  433,  276,  277,  276,  277,  438,  439,  270,  271,
  272,  273,  274,  135,  136,  256,  473,  139,  256,  141,
  477,  374,  144,  145,  146,  347,  372,   40,   41,  403,
   43,  276,   45,  403,  380,  276,  277,  410,  276,  277,
  256,  153,  364,  374,  156,  157,  377,  159,  409,  275,
  162,  163,  256,  165,  181,  333,  183,  268,  415,  337,
  276,  277,  174,   40,  411,  177,  270,  271,  272,  273,
  274,  269,  276,  277,  402,  187,  374,  374,  200,  269,
  202,  208,  374,  195,  560,  402,  562,   28,   29,   30,
  522,  410,  256,  525,  526,   40,  528,  529,  530,  416,
  557,  374,  214,  402,  216,  405,  218,  409,  220,  256,
  222,  407,  276,  277,  402,  406,  238,  406,  400,  241,
  242,  256,  369,  270,  271,  272,  273,  274,  416,  369,
  369,  402,  404,  374,  408,  369,  258,  375,  250,  261,
  262,  276,  277,  265,  406,  416,  268,  256,  369,   90,
   91,  369,  584,  375,  374,  256,  375,  269,  374,  281,
  282,  256,  374,  285,  286,  374,  278,  279,  374,  256,
  257,  258,  259,  260,  374,  276,  277,  264,  265,  266,
  280,  276,  277,  270,  271,  272,  273,  274,  369,  276,
  277,  313,  314,  315,  316,  400,  410,  369,  256,  372,
  373,  327,  340,  377,  256,  409,  379,  380,  330,  331,
  377,  375,  334,  373,  377,  353,  343,  339,  276,  277,
  256,  321,  377,  377,  276,  277,  377,  327,  328,  374,
  373,  353,  332,  374,  256,  335,   40,  377,  377,    0,
  276,  277,  278,  256,  257,  258,  259,  260,  405,  349,
  263,  264,  265,  266,  276,  277,  403,  270,  271,  272,
  273,  274,  406,  276,  277,  391,  402,   82,  363,  257,
  258,  259,  260,  395,  375,  387,  264,  265,  266,  406,
  257,  258,  259,  260,  256,  407,  256,  264,  265,  266,
  412,  391,  414,  270,  271,  272,  273,  274,  270,  271,
  272,  273,  274,    1,  276,  277,  276,  277,    6,    7,
  407,  256,  257,  258,  259,  260,  334,  375,  440,  264,
  265,  266,  409,  375,  440,  270,  271,  272,  273,  274,
    5,  496,  463,    8,    9,  473,   94,   35,  340,  477,
   -1,  463,   17,   18,   19,   20,   21,   22,   23,  256,
  450,  473,   27,   28,   -1,  477,  468,   32,   33,   34,
   -1,  374,   37,   38,  256,   40,   -1,   42,   -1,  276,
  277,   -1,   47,   48,  496,   50,   74,   52,   53,   54,
   55,   -1,   57,   -1,  276,  277,   61,   62,   63,   64,
   65,  256,   67,  406,   -1,   -1,  409,  256,   -1,   -1,
   75,  256,   77,   78,   79,   80,   -1,   -1,   83,   84,
   85,  276,  277,   -1,  402,   90,   91,  276,  277,  557,
   -1,  276,  277,  371,  122,  373,   -1,  270,  271,  272,
  273,  274,  409,   -1,   -1,  557,   -1,  135,  136,   -1,
   -1,  139,   -1,  141,  392,  393,  394,   -1,   -1,  124,
   -1,  256,  256,  257,  258,  259,  260,  132,   -1,   -1,
  264,  265,  266,  268,  409,  256,  270,  271,  272,  273,
  274,  276,  277,  256,   40,   -1,   42,   43,  153,   45,
   -1,   47,   -1,  375,   -1,  276,  277,   -1,   -1,  164,
   -1,  256,  167,  276,  277,  170,   -1,  172,   -1,   -1,
   -1,  176,  200,  256,  202,  270,  271,  272,  273,  274,
  185,  276,  277,  188,  189,   -1,  375,  192,   40,   -1,
  375,  196,  197,  276,  277,  372,  373,   -1,  203,  204,
   -1,  206,  379,  380,  381,  210,   -1,  212,  213,  214,
   42,   43,  217,   45,  219,   47,  221,   -1,  223,   -1,
  225,   -1,  227,  256,  229,  230,   -1,  232,   -1,  234,
  258,  236,   -1,  261,  262,  240,  409,  265,   -1,  244,
  268,  246,   -1,  276,  277,  250,   -1,   -1,  253,  254,
   -1,  256,  257,   -1,  259,   42,   43,   -1,   45,   -1,
   47,   -1,  375,   -1,   -1,  270,   -1,   -1,  273,   -1,
  275,  372,  373,  278,  279,  409,   -1,   -1,  379,  380,
  270,  271,  272,  273,  274,  313,  314,  315,  316,   -1,
   -1,   40,   41,   -1,   43,   -1,   45,   -1,   -1,   -1,
  401,  306,  330,  308,   -1,   14,   15,   16,   17,   18,
   -1,   20,  407,   -1,   23,   24,   -1,  322,  323,   -1,
   -1,   -1,   31,   32,   -1,   -1,   -1,   36,   -1,   -1,
   -1,   -1,   -1,   42,   43,   44,   45,   46,   47,   48,
   -1,   -1,  375,   52,   53,   54,   55,   56,   -1,  354,
   -1,  372,  373,   62,  359,  360,   -1,   -1,  379,  380,
   -1,  257,  258,  259,  260,  372,  373,  395,  264,  265,
  266,   -1,  379,  380,  270,  271,  272,  273,  274,  407,
  401,  256,  387,  258,   -1,   -1,   -1,   -1,   -1,  264,
  265,  266,   -1,  398,  401,   -1,  401,   -1,  403,  404,
  405,  406,   -1,   -1,   -1,  257,  258,  259,  260,   -1,
  415,   -1,  264,  265,  266,   -1,  372,  373,  270,  271,
  272,  273,  274,  379,  380,  257,  258,  259,  260,   -1,
   -1,   -1,  264,  265,  266,   -1,   -1,   -1,  270,  271,
  272,  273,  274,   -1,  449,  401,  451,    0,   -1,  454,
   -1,  456,   -1,  458,  459,   -1,   42,   43,  463,   45,
   -1,   47,   -1,  468,  469,   -1,   -1,  472,   -1,  474,
  475,  476,  181,  478,  183,   -1,   -1,   -1,  483,   -1,
  485,   -1,   -1,   -1,  489,  490,  491,  492,  493,  494,
   -1,   -1,  497,   -1,  499,  500,   -1,   -1,   -1,  208,
   -1,  506,   -1,  508,  509,  510,  511,  256,  257,  258,
  259,  260,   -1,  409,  263,  264,  265,  266,   -1,   -1,
   -1,  270,  271,  272,  273,  274,   -1,  276,  277,   -1,
  257,  258,  259,  260,   -1,   -1,   -1,  264,  265,  266,
   -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,   -1,
   -1,  263,  264,  265,  266,   -1,   -1,  409,  270,  271,
  272,  273,  274,   -1,  276,  277,   -1,   -1,   -1,   -1,
   -1,  280,   -1,   -1,  406,  256,  257,  258,  259,  260,
   -1,   -1,  263,  264,  265,  266,   -1,    0,   -1,  270,
  271,  272,  273,  274,   -1,  276,  277,   -1,   -1,   -1,
  257,  258,  259,  260,   -1,   -1,   -1,  264,  265,  266,
   -1,   -1,  321,   -1,   -1,   -1,   -1,   -1,  327,  328,
   -1,   -1,  256,  332,  258,  374,  335,   -1,   -1,   -1,
  264,  265,  266,   -1,  343,   -1,   -1,   -1,   -1,   -1,
  349,   -1,  276,  277,  257,  258,  259,  260,   -1,   -1,
  263,  264,  265,  266,   -1,   -1,   -1,  406,   -1,   -1,
  409,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,  257,  258,  259,  260,  402,   -1,  263,  264,  265,
  266,   -1,  391,   -1,  270,  271,  272,  273,  274,   -1,
  276,  277,   -1,  374,  406,   -1,   -1,  406,   -1,  411,
   -1,   -1,   -1,  256,  257,  258,  259,  260,  261,   -1,
  263,  264,  265,  266,  267,  372,  373,  270,  271,  272,
  273,  274,  379,  380,  381,  406,  279,  280,  281,  282,
  283,  284,  285,  286,  287,  288,  289,  290,  291,  292,
  293,  450,    0,  296,  297,  298,  299,  300,   -1,  302,
  303,  304,  305,  306,  307,  308,  309,  310,  311,  312,
  313,  314,  315,  316,  317,  318,  319,  320,  321,  322,
  323,  324,  325,  326,  327,  328,  329,  330,  331,  332,
  333,  334,  335,  336,  337,  338,  339,  340,  341,  342,
  343,  344,  345,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,  357,  358,  359,  360,  361,  362,
   -1,  364,  365,  366,  367,  256,  257,  258,  259,  260,
  406,   -1,  263,  264,  265,  266,   -1,   -1,   -1,  270,
  271,  272,  273,  274,   -1,  276,  277,   -1,  257,  258,
  259,  260,   -1,  256,  263,  264,  265,  266,  261,  257,
  258,  259,  260,  406,  267,   -1,  264,  265,  266,   -1,
  413,  414,   -1,  276,  277,   -1,  279,  280,  281,  282,
  283,  284,  285,  286,  287,  288,  289,  290,  291,  292,
  293,   -1,   -1,  296,  297,  298,  299,  300,   -1,  302,
  303,  304,  305,  306,  307,  308,  309,  310,  311,  312,
  313,  314,  315,  316,  317,  318,  319,  320,  321,  322,
  323,  324,  325,  326,  327,  328,  329,  330,  331,  332,
  333,  334,  335,  336,  337,  338,  339,  340,  341,  342,
  343,  344,  345,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,  357,  358,  359,  360,  361,  362,
   -1,  364,  365,  366,  367,  257,  258,  259,  260,   -1,
   -1,   -1,  264,  265,  266,  406,  256,  257,  258,  259,
  260,   -1,   -1,   -1,  264,  265,  266,   -1,   -1,  269,
  270,  271,  272,  273,  274,   -1,  276,  277,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
  413,  414,   -1,  261,  257,  258,  259,  260,   -1,  267,
   -1,  264,  265,  266,   -1,   -1,   -1,   -1,  276,  277,
   -1,  279,  280,  281,  282,  283,  284,  285,  286,  287,
  288,  289,  290,  291,  292,  293,   -1,   -1,  296,  297,
  298,  299,  300,   -1,  302,  303,  304,  305,  306,  307,
  308,  309,  310,  311,  312,  313,  314,  315,  316,  317,
  318,  319,  320,  321,  322,  323,  324,  325,  326,  327,
  328,  329,  330,  331,  332,  333,  334,  335,  336,  337,
  338,  339,  340,  341,  342,  343,  344,  345,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,  357,
  358,  359,  360,  361,  362,   -1,  364,  365,  366,  367,
   11,   12,   -1,   -1,   -1,   -1,  406,   -1,  371,   -1,
   -1,  374,   -1,   -1,   25,   26,   -1,   -1,   -1,   -1,
  383,   -1,  385,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   43,   44,  257,  258,  259,  260,   49,   -1,
   51,  264,  265,  266,   -1,  413,  414,   -1,   59,   60,
   -1,   -1,   -1,   -1,   -1,   66,   -1,   -1,   -1,  261,
   71,   72,   73,   -1,   -1,  267,   -1,   -1,   -1,   -1,
   81,   -1,   -1,   -1,  276,   86,   87,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,
  292,  293,   -1,   -1,  296,  297,  298,  299,  300,   -1,
  302,  303,  304,  305,  306,  307,  308,  309,  310,  311,
  312,  313,  314,  315,  316,  317,  318,  319,  320,  321,
  322,  323,  324,  325,  326,  327,  328,  329,  330,  331,
  332,  333,  334,  335,  336,  337,  338,  339,  340,  341,
  342,  343,  344,  345,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,  357,  358,  359,  360,  361,
  362,   -1,  364,  365,  366,  367,   -1,  390,  391,  392,
  393,  394,  395,   -1,   -1,   -1,  256,  257,  258,  259,
  260,   -1,   -1,   -1,  264,  265,  266,   -1,   -1,   -1,
  270,  271,  272,  273,  274,  261,  276,  277,   -1,   -1,
   -1,  267,   -1,  405,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  413,  414,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,   -1,   -1,
  296,  297,  298,  299,  300,   -1,  302,  303,  304,  305,
  306,  307,  308,  309,  310,  311,  312,  313,  314,  315,
  316,  317,  318,  319,  320,  321,  322,  323,  324,  325,
  326,  327,  328,  329,  330,  331,  332,  333,  334,  335,
  336,  337,  338,  339,  340,  341,  342,  343,  344,  345,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,  358,  359,  360,  361,  362,   -1,  364,  365,
  366,  367,  256,  257,  258,  259,  260,   -1,   -1,   -1,
  264,  265,  266,   -1,   -1,   -1,  270,  271,  272,  273,
  274,  257,  258,  259,  260,   -1,  406,   -1,  264,  265,
  266,   -1,   -1,   -1,  270,  271,  272,  273,  274,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  413,  414,   -1,
   -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,  370,
   -1,  372,  264,  265,  266,   -1,   -1,   -1,  270,  271,
  272,  273,  274,   -1,  276,  277,  256,  257,  258,  259,
  260,   -1,   -1,  263,  264,  265,  266,   -1,   -1,   -1,
  270,  271,  272,  273,  274,  256,  257,  258,  259,  260,
   -1,   -1,  263,  264,  265,  266,   -1,   -1,   -1,  270,
  271,  272,  273,  274,  368,   -1,   -1,   -1,   -1,  256,
  257,  258,  259,  260,   -1,   -1,   -1,  264,  265,  266,
   -1,   -1,  368,  270,  271,  272,  273,  274,   -1,   -1,
   -1,   -1,   -1,  257,  258,  259,  260,   -1,   -1,  263,
  264,  265,  266,   -1,   -1,  409,  270,  271,  272,  273,
  274,  257,  258,  259,  260,   -1,   -1,  263,  264,  265,
  266,   -1,   -1,  409,  270,  271,  272,  273,  274,  257,
  258,  259,  260,   -1,   -1,  263,  264,  265,  266,   -1,
   -1,   -1,  270,  271,  272,  273,  274,   -1,   -1,  257,
  258,  259,  260,   -1,  406,  263,  264,  265,  266,   -1,
   -1,   -1,  270,  271,  272,  273,  274,   -1,   -1,   -1,
  257,  258,  259,  260,   -1,   -1,  406,  264,  265,  266,
   -1,   -1,   -1,  270,  271,  272,  273,  274,   -1,  257,
  258,  259,  260,   -1,   -1,  406,  264,  265,  266,   -1,
   -1,   -1,  270,  271,  272,  273,  274,   -1,   -1,   -1,
   -1,   -1,   -1,  257,  258,  259,  260,   -1,   -1,  406,
  264,  265,  266,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  406,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  406,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,
   -1,   -1,   -1,   -1,  368,   -1,  370,  371,   -1,   -1,
  374,   -1,  376,   -1,  378,   -1,   -1,   -1,  406,  383,
  384,  385,  386,  387,  388,  389,  390,  391,  392,  393,
  394,  395,  396,  397,  398,  399,
};
#define YYFINAL 92
#ifndef YYDEBUG
#define YYDEBUG 1
#endif
#define YYMAXTOKEN 416
#define YYUNDFTOKEN 472
#define YYTRANSLATE(a) ((a) > YYMAXTOKEN ? YYUNDFTOKEN : (a))
#if YYDEBUG
static const char *const yyname[] = {

"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,"'('","')'","'*'","'+'",0,"'-'",0,"'/'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
"H_NUMBER","D_NUMBER","O_NUMBER","B_NUMBER","CONVERT_OP","B_DATA",
"H_RANGE_GUESS","D_NUMBER_GUESS","O_NUMBER_GUESS","B_NUMBER_GUESS","BAD_CMD",
"MEM_OP","IF","MEM_COMP","MEM_DISK8","MEM_DISK9","MEM_DISK10","MEM_DISK11",
"EQUALS","TRAIL","CMD_SEP","LABEL_ASGN_COMMENT","CMD_SIDEFX","CMD_RETURN",
"CMD_BLOCK_READ","CMD_BLOCK_WRITE","CMD_UP","CMD_DOWN","CMD_LOAD","CMD_SAVE",
"CMD_VERIFY","CMD_IGNORE","CMD_HUNT","CMD_FILL","CMD_MOVE","CMD_GOTO",
"CMD_REGISTERS","CMD_READSPACE","CMD_WRITESPACE","CMD_RADIX","CMD_MEM_DISPLAY",
"CMD_BREAK","CMD_TRACE","CMD_IO","CMD_BRMON","CMD_COMPARE","CMD_DUMP",
"CMD_UNDUMP","CMD_EXIT","CMD_DELETE","CMD_CONDITION","CMD_COMMAND",
"CMD_ASSEMBLE","CMD_DISASSEMBLE","CMD_NEXT","CMD_STEP","CMD_PRINT","CMD_DEVICE",
"CMD_HELP","CMD_WATCH","CMD_DISK","CMD_QUIT","CMD_CHDIR","CMD_BANK",
"CMD_LOAD_LABELS","CMD_SAVE_LABELS","CMD_ADD_LABEL","CMD_DEL_LABEL",
"CMD_SHOW_LABELS","CMD_CLEAR_LABELS","CMD_RECORD","CMD_MON_STOP","CMD_PLAYBACK",
"CMD_CHAR_DISPLAY","CMD_SPRITE_DISPLAY","CMD_TEXT_DISPLAY",
"CMD_SCREENCODE_DISPLAY","CMD_ENTER_DATA","CMD_ENTER_BIN_DATA","CMD_KEYBUF",
"CMD_BLOAD","CMD_BSAVE","CMD_SCREEN","CMD_UNTIL","CMD_CPU","CMD_YYDEBUG",
"CMD_BACKTRACE","CMD_SCREENSHOT","CMD_PWD","CMD_DIR","CMD_RESOURCE_GET",
"CMD_RESOURCE_SET","CMD_LOAD_RESOURCES","CMD_SAVE_RESOURCES","CMD_ATTACH",
"CMD_DETACH","CMD_MON_RESET","CMD_TAPECTRL","CMD_CARTFREEZE","CMD_CPUHISTORY",
"CMD_MEMMAPZAP","CMD_MEMMAPSHOW","CMD_MEMMAPSAVE","CMD_COMMENT","CMD_LIST",
"CMD_STOPWATCH","RESET","CMD_EXPORT","CMD_AUTOSTART","CMD_AUTOLOAD",
"CMD_LABEL_ASGN","L_PAREN","R_PAREN","ARG_IMMEDIATE","REG_A","REG_X","REG_Y",
"COMMA","INST_SEP","L_BRACKET","R_BRACKET","LESS_THAN","REG_U","REG_S","REG_PC",
"REG_PCR","REG_B","REG_C","REG_D","REG_E","REG_H","REG_L","REG_AF","REG_BC",
"REG_DE","REG_HL","REG_IX","REG_IY","REG_SP","REG_IXH","REG_IXL","REG_IYH",
"REG_IYL","PLUS","MINUS","STRING","FILENAME","R_O_L","OPCODE","LABEL",
"BANKNAME","CPUTYPE","MON_REGISTER","COMPARE_OP","RADIX_TYPE","INPUT_SPEC",
"CMD_CHECKPT_ON","CMD_CHECKPT_OFF","TOGGLE","MASK",0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,"illegal-symbol",
};
static const char *const yyrule[] = {
"$accept : top_level",
"top_level : command_list",
"top_level : assembly_instruction TRAIL",
"top_level : TRAIL",
"command_list : command",
"command_list : command_list command",
"end_cmd : CMD_SEP",
"end_cmd : TRAIL",
"end_cmd : error",
"command : machine_state_rules",
"command : symbol_table_rules",
"command : memory_rules",
"command : asm_rules",
"command : checkpoint_rules",
"command : checkpoint_control_rules",
"command : monitor_state_rules",
"command : monitor_misc_rules",
"command : disk_rules",
"command : cmd_file_rules",
"command : data_entry_rules",
"command : monitor_debug_rules",
"command : BAD_CMD",
"machine_state_rules : CMD_BANK end_cmd",
"machine_state_rules : CMD_BANK memspace end_cmd",
"machine_state_rules : CMD_BANK BANKNAME end_cmd",
"machine_state_rules : CMD_BANK memspace opt_sep BANKNAME end_cmd",
"machine_state_rules : CMD_GOTO address end_cmd",
"machine_state_rules : CMD_GOTO end_cmd",
"machine_state_rules : CMD_IO end_cmd",
"machine_state_rules : CMD_IO address end_cmd",
"machine_state_rules : CMD_CPU end_cmd",
"machine_state_rules : CMD_CPU CPUTYPE end_cmd",
"machine_state_rules : CMD_CPUHISTORY end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep expression end_cmd",
"machine_state_rules : CMD_RETURN end_cmd",
"machine_state_rules : CMD_DUMP filename end_cmd",
"machine_state_rules : CMD_UNDUMP filename end_cmd",
"machine_state_rules : CMD_STEP end_cmd",
"machine_state_rules : CMD_STEP opt_sep expression end_cmd",
"machine_state_rules : CMD_NEXT end_cmd",
"machine_state_rules : CMD_NEXT opt_sep expression end_cmd",
"machine_state_rules : CMD_UP end_cmd",
"machine_state_rules : CMD_UP opt_sep expression end_cmd",
"machine_state_rules : CMD_DOWN end_cmd",
"machine_state_rules : CMD_DOWN opt_sep expression end_cmd",
"machine_state_rules : CMD_SCREEN end_cmd",
"machine_state_rules : register_mod",
"register_mod : CMD_REGISTERS end_cmd",
"register_mod : CMD_REGISTERS memspace end_cmd",
"register_mod : CMD_REGISTERS reg_list end_cmd",
"symbol_table_rules : CMD_LOAD_LABELS memspace opt_sep filename end_cmd",
"symbol_table_rules : CMD_LOAD_LABELS filename end_cmd",
"symbol_table_rules : CMD_SAVE_LABELS memspace opt_sep filename end_cmd",
"symbol_table_rules : CMD_SAVE_LABELS filename end_cmd",
"symbol_table_rules : CMD_ADD_LABEL address opt_sep LABEL end_cmd",
"symbol_table_rules : CMD_DEL_LABEL LABEL end_cmd",
"symbol_table_rules : CMD_DEL_LABEL memspace opt_sep LABEL end_cmd",
"symbol_table_rules : CMD_SHOW_LABELS memspace end_cmd",
"symbol_table_rules : CMD_SHOW_LABELS end_cmd",
"symbol_table_rules : CMD_CLEAR_LABELS memspace end_cmd",
"symbol_table_rules : CMD_CLEAR_LABELS end_cmd",
"symbol_table_rules : CMD_LABEL_ASGN EQUALS address end_cmd",
"symbol_table_rules : CMD_LABEL_ASGN EQUALS address LABEL_ASGN_COMMENT end_cmd",
"$$1 :",
"asm_rules : CMD_ASSEMBLE address $$1 post_assemble end_cmd",
"asm_rules : CMD_ASSEMBLE address end_cmd",
"asm_rules : CMD_DISASSEMBLE address_opt_range end_cmd",
"asm_rules : CMD_DISASSEMBLE end_cmd",
"memory_rules : CMD_MOVE address_range opt_sep address end_cmd",
"memory_rules : CMD_COMPARE address_range opt_sep address end_cmd",
"memory_rules : CMD_FILL address_range opt_sep data_list end_cmd",
"memory_rules : CMD_HUNT address_range opt_sep hunt_list end_cmd",
"memory_rules : CMD_MEM_DISPLAY RADIX_TYPE opt_sep address_opt_range end_cmd",
"memory_rules : CMD_MEM_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_MEM_DISPLAY end_cmd",
"memory_rules : CMD_CHAR_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_CHAR_DISPLAY end_cmd",
"memory_rules : CMD_SPRITE_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_SPRITE_DISPLAY end_cmd",
"memory_rules : CMD_TEXT_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_TEXT_DISPLAY end_cmd",
"memory_rules : CMD_SCREENCODE_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_SCREENCODE_DISPLAY end_cmd",
"memory_rules : CMD_MEMMAPZAP end_cmd",
"memory_rules : CMD_MEMMAPSHOW end_cmd",
"memory_rules : CMD_MEMMAPSHOW opt_sep expression end_cmd",
"memory_rules : CMD_MEMMAPSHOW opt_sep expression address_opt_range end_cmd",
"memory_rules : CMD_MEMMAPSAVE filename opt_sep expression end_cmd",
"checkpoint_rules : CMD_BREAK opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_BREAK end_cmd",
"checkpoint_rules : CMD_UNTIL address_opt_range end_cmd",
"checkpoint_rules : CMD_UNTIL end_cmd",
"checkpoint_rules : CMD_WATCH opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_WATCH end_cmd",
"checkpoint_rules : CMD_TRACE opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_TRACE end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_ON checkpt_num end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_ON end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_OFF checkpt_num end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_OFF end_cmd",
"checkpoint_control_rules : CMD_IGNORE checkpt_num end_cmd",
"checkpoint_control_rules : CMD_IGNORE checkpt_num opt_sep expression end_cmd",
"checkpoint_control_rules : CMD_DELETE checkpt_num end_cmd",
"checkpoint_control_rules : CMD_DELETE end_cmd",
"checkpoint_control_rules : CMD_CONDITION checkpt_num IF cond_expr end_cmd",
"checkpoint_control_rules : CMD_COMMAND checkpt_num opt_sep STRING end_cmd",
"checkpoint_control_rules : CMD_COMMAND checkpt_num error end_cmd",
"monitor_state_rules : CMD_SIDEFX TOGGLE end_cmd",
"monitor_state_rules : CMD_SIDEFX end_cmd",
"monitor_state_rules : CMD_RADIX RADIX_TYPE end_cmd",
"monitor_state_rules : CMD_RADIX end_cmd",
"monitor_state_rules : CMD_DEVICE memspace end_cmd",
"monitor_state_rules : CMD_EXPORT end_cmd",
"monitor_state_rules : CMD_QUIT end_cmd",
"monitor_state_rules : CMD_EXIT end_cmd",
"monitor_misc_rules : CMD_DISK rest_of_line end_cmd",
"monitor_misc_rules : CMD_PRINT expression end_cmd",
"monitor_misc_rules : CMD_HELP end_cmd",
"monitor_misc_rules : CMD_HELP rest_of_line end_cmd",
"monitor_misc_rules : CONVERT_OP expression end_cmd",
"monitor_misc_rules : CMD_CHDIR rest_of_line end_cmd",
"monitor_misc_rules : CMD_KEYBUF rest_of_line end_cmd",
"monitor_misc_rules : CMD_BACKTRACE end_cmd",
"monitor_misc_rules : CMD_DIR opt_rest_of_line end_cmd",
"monitor_misc_rules : CMD_PWD end_cmd",
"monitor_misc_rules : CMD_SCREENSHOT filename end_cmd",
"monitor_misc_rules : CMD_SCREENSHOT filename opt_sep expression end_cmd",
"monitor_misc_rules : CMD_RESOURCE_GET STRING end_cmd",
"monitor_misc_rules : CMD_RESOURCE_SET STRING STRING end_cmd",
"monitor_misc_rules : CMD_LOAD_RESOURCES filename end_cmd",
"monitor_misc_rules : CMD_SAVE_RESOURCES filename end_cmd",
"monitor_misc_rules : CMD_MON_RESET end_cmd",
"monitor_misc_rules : CMD_MON_RESET opt_sep expression end_cmd",
"monitor_misc_rules : CMD_TAPECTRL opt_sep expression end_cmd",
"monitor_misc_rules : CMD_CARTFREEZE end_cmd",
"monitor_misc_rules : CMD_COMMENT opt_rest_of_line end_cmd",
"monitor_misc_rules : CMD_STOPWATCH RESET end_cmd",
"monitor_misc_rules : CMD_STOPWATCH end_cmd",
"disk_rules : CMD_LOAD filename device_num opt_address end_cmd",
"disk_rules : CMD_BLOAD filename device_num opt_address end_cmd",
"disk_rules : CMD_SAVE filename device_num address_range end_cmd",
"disk_rules : CMD_SAVE filename error",
"disk_rules : CMD_SAVE filename device_num error",
"disk_rules : CMD_BSAVE filename device_num address_range end_cmd",
"disk_rules : CMD_BSAVE filename device_num error",
"disk_rules : CMD_VERIFY filename device_num address end_cmd",
"disk_rules : CMD_VERIFY filename device_num error",
"disk_rules : CMD_BLOCK_READ expression expression opt_address end_cmd",
"disk_rules : CMD_BLOCK_WRITE expression expression address end_cmd",
"disk_rules : CMD_LIST end_cmd",
"disk_rules : CMD_LIST device_num end_cmd",
"disk_rules : CMD_ATTACH filename expression end_cmd",
"disk_rules : CMD_DETACH expression end_cmd",
"disk_rules : CMD_AUTOSTART filename end_cmd",
"disk_rules : CMD_AUTOSTART filename opt_sep number end_cmd",
"disk_rules : CMD_AUTOLOAD filename end_cmd",
"disk_rules : CMD_AUTOLOAD filename opt_sep number end_cmd",
"cmd_file_rules : CMD_RECORD filename end_cmd",
"cmd_file_rules : CMD_MON_STOP end_cmd",
"cmd_file_rules : CMD_PLAYBACK filename end_cmd",
"data_entry_rules : CMD_ENTER_DATA address data_list end_cmd",
"data_entry_rules : CMD_ENTER_BIN_DATA end_cmd",
"monitor_debug_rules : CMD_YYDEBUG end_cmd",
"rest_of_line : R_O_L",
"opt_rest_of_line : R_O_L",
"opt_rest_of_line :",
"filename : FILENAME",
"filename : error",
"device_num : expression",
"device_num : error",
"mem_op : mem_op MEM_OP",
"mem_op : MEM_OP",
"opt_mem_op : mem_op",
"opt_mem_op :",
"register : MON_REGISTER",
"register : memspace MON_REGISTER",
"reg_list : reg_list COMMA reg_asgn",
"reg_list : reg_asgn",
"reg_asgn : register EQUALS number",
"checkpt_num : d_number",
"checkpt_num : error",
"address_opt_range : address_range",
"address_opt_range : address",
"address_range : address opt_sep address",
"address_range : H_RANGE_GUESS",
"address_range : memspace opt_sep H_RANGE_GUESS",
"opt_address : opt_sep address",
"opt_address :",
"address : memloc",
"address : memspace opt_sep memloc",
"address : LABEL",
"opt_sep : COMMA",
"opt_sep :",
"memspace : MEM_COMP",
"memspace : MEM_DISK8",
"memspace : MEM_DISK9",
"memspace : MEM_DISK10",
"memspace : MEM_DISK11",
"memloc : memaddr",
"memaddr : number",
"expression : expression '+' expression",
"expression : expression '-' expression",
"expression : expression '*' expression",
"expression : expression '/' expression",
"expression : '(' expression ')'",
"expression : '(' expression error",
"expression : value",
"opt_if_cond_expr : IF cond_expr",
"opt_if_cond_expr :",
"cond_expr : cond_expr COMPARE_OP cond_expr",
"cond_expr : cond_expr COMPARE_OP error",
"cond_expr : L_PAREN cond_expr R_PAREN",
"cond_expr : L_PAREN cond_expr error",
"cond_expr : compare_operand",
"compare_operand : register",
"compare_operand : number",
"data_list : data_list opt_sep data_element",
"data_list : data_element",
"data_element : number",
"data_element : STRING",
"hunt_list : hunt_list hunt_element",
"hunt_list : hunt_element",
"hunt_element : number",
"hunt_element : MASK",
"hunt_element : STRING",
"value : number",
"value : register",
"d_number : D_NUMBER",
"d_number : B_NUMBER_GUESS",
"d_number : O_NUMBER_GUESS",
"d_number : D_NUMBER_GUESS",
"guess_default : B_NUMBER_GUESS",
"guess_default : O_NUMBER_GUESS",
"guess_default : D_NUMBER_GUESS",
"number : H_NUMBER",
"number : D_NUMBER",
"number : O_NUMBER",
"number : B_NUMBER",
"number : guess_default",
"assembly_instr_list : assembly_instr_list INST_SEP assembly_instruction",
"assembly_instr_list : assembly_instruction INST_SEP assembly_instruction",
"assembly_instr_list : assembly_instruction INST_SEP",
"assembly_instruction : OPCODE asm_operand_mode",
"post_assemble : assembly_instruction",
"post_assemble : assembly_instr_list",
"asm_operand_mode : ARG_IMMEDIATE number",
"asm_operand_mode : number",
"asm_operand_mode : number COMMA REG_X",
"asm_operand_mode : number COMMA REG_Y",
"asm_operand_mode : number COMMA REG_S",
"asm_operand_mode : number COMMA number",
"asm_operand_mode : L_PAREN number R_PAREN",
"asm_operand_mode : L_PAREN number COMMA REG_X R_PAREN",
"asm_operand_mode : L_PAREN number COMMA REG_S R_PAREN COMMA REG_Y",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_Y",
"asm_operand_mode : L_PAREN REG_BC R_PAREN",
"asm_operand_mode : L_PAREN REG_DE R_PAREN",
"asm_operand_mode : L_PAREN REG_HL R_PAREN",
"asm_operand_mode : L_PAREN REG_IX R_PAREN",
"asm_operand_mode : L_PAREN REG_IY R_PAREN",
"asm_operand_mode : L_PAREN REG_SP R_PAREN",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_A",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_HL",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_IX",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_IY",
"asm_operand_mode :",
"asm_operand_mode : REG_A",
"asm_operand_mode : REG_B",
"asm_operand_mode : REG_C",
"asm_operand_mode : REG_D",
"asm_operand_mode : REG_E",
"asm_operand_mode : REG_H",
"asm_operand_mode : REG_IXH",
"asm_operand_mode : REG_IYH",
"asm_operand_mode : REG_L",
"asm_operand_mode : REG_IXL",
"asm_operand_mode : REG_IYL",
"asm_operand_mode : REG_AF",
"asm_operand_mode : REG_BC",
"asm_operand_mode : REG_DE",
"asm_operand_mode : REG_HL",
"asm_operand_mode : REG_IX",
"asm_operand_mode : REG_IY",
"asm_operand_mode : REG_SP",
"asm_operand_mode : LESS_THAN number",
"asm_operand_mode : number COMMA index_ureg",
"asm_operand_mode : COMMA index_reg PLUS",
"asm_operand_mode : COMMA index_reg PLUS PLUS",
"asm_operand_mode : COMMA MINUS index_reg",
"asm_operand_mode : COMMA MINUS MINUS index_reg",
"asm_operand_mode : COMMA index_reg",
"asm_operand_mode : REG_B COMMA index_reg",
"asm_operand_mode : REG_A COMMA index_reg",
"asm_operand_mode : REG_D COMMA index_reg",
"asm_operand_mode : number COMMA REG_PC",
"asm_operand_mode : L_BRACKET number COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg PLUS R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg PLUS PLUS R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA MINUS index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA MINUS MINUS index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_B COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_A COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_D COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET number COMMA REG_PC R_BRACKET",
"asm_operand_mode : L_BRACKET number R_BRACKET",
"asm_operand_mode : L_BRACKET number R_BRACKET COMMA REG_Y",
"index_reg : REG_X",
"index_reg : REG_Y",
"index_reg : index_ureg",
"index_reg : REG_S",
"index_ureg : REG_U",

};
#endif

int      yydebug;
int      yynerrs;

int      yyerrflag;
int      yychar;
YYSTYPE  yyval;
YYSTYPE  yylval;

/* define the initial stack-sizes */
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH  YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH  10000
#endif
#endif

#define YYINITSTACKSIZE 200

typedef struct {
    unsigned stacksize;
    YYINT    *s_base;
    YYINT    *s_mark;
    YYINT    *s_last;
    YYSTYPE  *l_base;
    YYSTYPE  *l_mark;
} YYSTACKDATA;
/* variables for the parser stack */
static YYSTACKDATA yystack;
#line 1044 "../../../vice/src/monitor/mon_parse.y"

void parse_and_execute_line(char *input)
{
   char *temp_buf;
   int i, rc;

   temp_buf = lib_malloc(strlen(input) + 3);
   strcpy(temp_buf,input);
   i = (int)strlen(input);
   temp_buf[i++] = '\n';
   temp_buf[i++] = '\0';
   temp_buf[i++] = '\0';

   make_buffer(temp_buf);
   mon_clear_buffer();
   if ( (rc =yyparse()) != 0) {
       mon_out("ERROR -- ");
       switch(rc) {
         case ERR_BAD_CMD:
           mon_out("Bad command:\n");
           break;
         case ERR_RANGE_BAD_START:
           mon_out("Bad first address in range:\n");
           break;
         case ERR_RANGE_BAD_END:
           mon_out("Bad second address in range:\n");
           break;
         case ERR_EXPECT_CHECKNUM:
           mon_out("Checkpoint number expected:\n");
           break;
         case ERR_EXPECT_END_CMD:
           mon_out("Unexpected token:\n");
           break;
         case ERR_MISSING_CLOSE_PAREN:
           mon_out("')' expected:\n");
           break;
         case ERR_INCOMPLETE_COMPARE_OP:
           mon_out("Compare operation missing an operand:\n");
           break;
         case ERR_EXPECT_FILENAME:
           mon_out("Expecting a filename:\n");
           break;
         case ERR_ADDR_TOO_BIG:
           mon_out("Address too large:\n");
           break;
         case ERR_IMM_TOO_BIG:
           mon_out("Immediate argument too large:\n");
           break;
         case ERR_EXPECT_STRING:
           mon_out("Expecting a string.\n");
           break;
         case ERR_UNDEFINED_LABEL:
           mon_out("Found an undefined label.\n");
           break;
         case ERR_EXPECT_DEVICE_NUM:
           mon_out("Expecting a device number.\n");
           break;
         case ERR_EXPECT_ADDRESS:
           mon_out("Expecting an address.\n");
           break;
         case ERR_INVALID_REGISTER:
           mon_out("Invalid register.\n");
           break;
         case ERR_ILLEGAL_INPUT:
         default:
           mon_out("Wrong syntax:\n");
       }
       mon_out("  %s\n", input);
       for (i = 0; i < last_len; i++)
           mon_out(" ");
       mon_out("  ^\n");
       asm_mode = 0;
       new_cmd = 1;
   }
   lib_free(temp_buf);
   free_buffer();
}

static int yyerror(char *s)
{
   fprintf(stderr, "ERR:%s\n", s);
   return 0;
}

static int resolve_datatype(unsigned guess_type, const char *num)
{
   /* FIXME: Handle cases when default type is non-numerical */
   if (default_radix == e_hexadecimal) {
       return strtol(num, NULL, 16);
   }

   if ((guess_type == D_NUMBER) || (default_radix == e_decimal)) {
       return strtol(num, NULL, 10);
   }

   if ((guess_type == O_NUMBER) || (default_radix == e_octal)) {
       return strtol(num, NULL, 8);
   }

   return strtol(num, NULL, 2);
}

/*
 * Resolve a character sequence containing 8 hex digits like "08001000".
 * This could be a lazy version of "0800 1000". If the default radix is not
 * hexadecimal, we handle it like a ordinary number, in the latter case there
 * is only one number in the range.
 */
static int resolve_range(enum t_memspace memspace, MON_ADDR range[2],
                         const char *num)
{
    char start[5];
    char end[5];
    long sa;

    range[1] = BAD_ADDR;

    switch (default_radix)
    {
    case e_hexadecimal:
        /* checked twice, but as the code must have exactly 8 digits: */
        if (strlen(num) == 8) {
            memcpy(start, num, 4);
            start[4] = '\0';
            memcpy(end, num + 4, 4);
            end[4] = '\0';
            sa = strtol(start, NULL, 16);
            range[1] = new_addr(memspace, strtol(end, NULL, 16));
        }
        else
            sa = strtol(num, NULL, 16);
        break;

    case e_decimal:
       sa = strtol(num, NULL, 10);
       break;

    case e_octal:
       sa = strtol(num, NULL, 8);
       break;

    default:
       sa = strtol(num, NULL, 2);
    }

    if (!CHECK_ADDR(sa))
        return ERR_ADDR_TOO_BIG;

    range[0] = new_addr(memspace, sa);
    return 0;
}


#line 1652 "../../../vice/src/monitor/mon_parse.c"

#if YYDEBUG
#include <stdio.h>		/* needed for printf */
#endif

#include <stdlib.h>	/* needed for malloc, etc */
#include <string.h>	/* needed for memset */

/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(YYSTACKDATA *data)
{
    int i;
    unsigned newsize;
    YYINT *newss;
    YYSTYPE *newvs;

    if ((newsize = data->stacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return YYENOMEM;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;

    i = (int) (data->s_mark - data->s_base);
    newss = (YYINT *)realloc(data->s_base, newsize * sizeof(*newss));
    if (newss == 0)
        return YYENOMEM;

    data->s_base = newss;
    data->s_mark = newss + i;

    newvs = (YYSTYPE *)realloc(data->l_base, newsize * sizeof(*newvs));
    if (newvs == 0)
        return YYENOMEM;

    data->l_base = newvs;
    data->l_mark = newvs + i;

    data->stacksize = newsize;
    data->s_last = data->s_base + newsize - 1;
    return 0;
}

#if YYPURE || defined(YY_NO_LEAKS)
static void yyfreestack(YYSTACKDATA *data)
{
    free(data->s_base);
    free(data->l_base);
    memset(data, 0, sizeof(*data));
}
#else
#define yyfreestack(data) /* nothing */
#endif

#define YYABORT  goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR  goto yyerrlab

int
YYPARSE_DECL()
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")) != 0)
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = YYEMPTY;
    yystate = 0;

#if YYPURE
    memset(&yystack, 0, sizeof(yystack));
#endif

    if (yystack.s_base == NULL && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    yystack.s_mark = yystack.s_base;
    yystack.l_mark = yystack.l_base;
    yystate = 0;
    *yystack.s_mark = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = YYLEX) < 0) yychar = YYEOF;
#if YYDEBUG
        if (yydebug)
        {
            yys = yyname[YYTRANSLATE(yychar)];
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM)
        {
            goto yyoverflow;
        }
        yystate = yytable[yyn];
        *++yystack.s_mark = yytable[yyn];
        *++yystack.l_mark = yylval;
        yychar = YYEMPTY;
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;

    YYERROR_CALL("syntax error");

    goto yyerrlab;

yyerrlab:
    ++yynerrs;

yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yystack.s_mark]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yystack.s_mark, yytable[yyn]);
#endif
                if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM)
                {
                    goto yyoverflow;
                }
                yystate = yytable[yyn];
                *++yystack.s_mark = yytable[yyn];
                *++yystack.l_mark = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yystack.s_mark);
#endif
                if (yystack.s_mark <= yystack.s_base) goto yyabort;
                --yystack.s_mark;
                --yystack.l_mark;
            }
        }
    }
    else
    {
        if (yychar == YYEOF) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = yyname[YYTRANSLATE(yychar)];
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = YYEMPTY;
        goto yyloop;
    }

yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym)
        yyval = yystack.l_mark[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
    switch (yyn)
    {
case 1:
#line 196 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = 0; }
break;
case 2:
#line 197 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = 0; }
break;
case 3:
#line 198 "../../../vice/src/monitor/mon_parse.y"
	{ new_cmd = 1; asm_mode = 0;  yyval.i = 0; }
break;
case 8:
#line 207 "../../../vice/src/monitor/mon_parse.y"
	{ return ERR_EXPECT_END_CMD; }
break;
case 21:
#line 222 "../../../vice/src/monitor/mon_parse.y"
	{ return ERR_BAD_CMD; }
break;
case 22:
#line 226 "../../../vice/src/monitor/mon_parse.y"
	{ mon_bank(e_default_space, NULL); }
break;
case 23:
#line 228 "../../../vice/src/monitor/mon_parse.y"
	{ mon_bank(yystack.l_mark[-1].i, NULL); }
break;
case 24:
#line 230 "../../../vice/src/monitor/mon_parse.y"
	{ mon_bank(e_default_space, yystack.l_mark[-1].str); }
break;
case 25:
#line 232 "../../../vice/src/monitor/mon_parse.y"
	{ mon_bank(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
break;
case 26:
#line 234 "../../../vice/src/monitor/mon_parse.y"
	{ mon_jump(yystack.l_mark[-1].a); }
break;
case 27:
#line 236 "../../../vice/src/monitor/mon_parse.y"
	{ mon_go(); }
break;
case 28:
#line 238 "../../../vice/src/monitor/mon_parse.y"
	{ mon_display_io_regs(0); }
break;
case 29:
#line 240 "../../../vice/src/monitor/mon_parse.y"
	{ mon_display_io_regs(yystack.l_mark[-1].a); }
break;
case 30:
#line 242 "../../../vice/src/monitor/mon_parse.y"
	{ monitor_cpu_type_set(""); }
break;
case 31:
#line 244 "../../../vice/src/monitor/mon_parse.y"
	{ monitor_cpu_type_set(yystack.l_mark[-1].str); }
break;
case 32:
#line 246 "../../../vice/src/monitor/mon_parse.y"
	{ mon_cpuhistory(-1); }
break;
case 33:
#line 248 "../../../vice/src/monitor/mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-1].i); }
break;
case 34:
#line 250 "../../../vice/src/monitor/mon_parse.y"
	{ mon_instruction_return(); }
break;
case 35:
#line 252 "../../../vice/src/monitor/mon_parse.y"
	{ machine_write_snapshot(yystack.l_mark[-1].str,0,0,0); /* FIXME */ }
break;
case 36:
#line 254 "../../../vice/src/monitor/mon_parse.y"
	{ machine_read_snapshot(yystack.l_mark[-1].str, 0); }
break;
case 37:
#line 256 "../../../vice/src/monitor/mon_parse.y"
	{ mon_instructions_step(-1); }
break;
case 38:
#line 258 "../../../vice/src/monitor/mon_parse.y"
	{ mon_instructions_step(yystack.l_mark[-1].i); }
break;
case 39:
#line 260 "../../../vice/src/monitor/mon_parse.y"
	{ mon_instructions_next(-1); }
break;
case 40:
#line 262 "../../../vice/src/monitor/mon_parse.y"
	{ mon_instructions_next(yystack.l_mark[-1].i); }
break;
case 41:
#line 264 "../../../vice/src/monitor/mon_parse.y"
	{ mon_stack_up(-1); }
break;
case 42:
#line 266 "../../../vice/src/monitor/mon_parse.y"
	{ mon_stack_up(yystack.l_mark[-1].i); }
break;
case 43:
#line 268 "../../../vice/src/monitor/mon_parse.y"
	{ mon_stack_down(-1); }
break;
case 44:
#line 270 "../../../vice/src/monitor/mon_parse.y"
	{ mon_stack_down(yystack.l_mark[-1].i); }
break;
case 45:
#line 272 "../../../vice/src/monitor/mon_parse.y"
	{ mon_display_screen(); }
break;
case 47:
#line 277 "../../../vice/src/monitor/mon_parse.y"
	{ (monitor_cpu_for_memspace[default_memspace]->mon_register_print)(default_memspace); }
break;
case 48:
#line 279 "../../../vice/src/monitor/mon_parse.y"
	{ (monitor_cpu_for_memspace[yystack.l_mark[-1].i]->mon_register_print)(yystack.l_mark[-1].i); }
break;
case 50:
#line 284 "../../../vice/src/monitor/mon_parse.y"
	{
                        /* What about the memspace? */
                        mon_playback_init(yystack.l_mark[-1].str);
                    }
break;
case 51:
#line 289 "../../../vice/src/monitor/mon_parse.y"
	{
                        /* What about the memspace? */
                        mon_playback_init(yystack.l_mark[-1].str);
                    }
break;
case 52:
#line 294 "../../../vice/src/monitor/mon_parse.y"
	{ mon_save_symbols(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
break;
case 53:
#line 296 "../../../vice/src/monitor/mon_parse.y"
	{ mon_save_symbols(e_default_space, yystack.l_mark[-1].str); }
break;
case 54:
#line 298 "../../../vice/src/monitor/mon_parse.y"
	{ mon_add_name_to_symbol_table(yystack.l_mark[-3].a, yystack.l_mark[-1].str); }
break;
case 55:
#line 300 "../../../vice/src/monitor/mon_parse.y"
	{ mon_remove_name_from_symbol_table(e_default_space, yystack.l_mark[-1].str); }
break;
case 56:
#line 302 "../../../vice/src/monitor/mon_parse.y"
	{ mon_remove_name_from_symbol_table(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
break;
case 57:
#line 304 "../../../vice/src/monitor/mon_parse.y"
	{ mon_print_symbol_table(yystack.l_mark[-1].i); }
break;
case 58:
#line 306 "../../../vice/src/monitor/mon_parse.y"
	{ mon_print_symbol_table(e_default_space); }
break;
case 59:
#line 308 "../../../vice/src/monitor/mon_parse.y"
	{ mon_clear_symbol_table(yystack.l_mark[-1].i); }
break;
case 60:
#line 310 "../../../vice/src/monitor/mon_parse.y"
	{ mon_clear_symbol_table(e_default_space); }
break;
case 61:
#line 312 "../../../vice/src/monitor/mon_parse.y"
	{
                        mon_add_name_to_symbol_table(yystack.l_mark[-1].a, mon_prepend_dot_to_name(yystack.l_mark[-3].str));
                    }
break;
case 62:
#line 316 "../../../vice/src/monitor/mon_parse.y"
	{
                        mon_add_name_to_symbol_table(yystack.l_mark[-2].a, mon_prepend_dot_to_name(yystack.l_mark[-4].str));
                    }
break;
case 63:
#line 322 "../../../vice/src/monitor/mon_parse.y"
	{ mon_start_assemble_mode(yystack.l_mark[0].a, NULL); }
break;
case 64:
#line 323 "../../../vice/src/monitor/mon_parse.y"
	{ }
break;
case 65:
#line 325 "../../../vice/src/monitor/mon_parse.y"
	{ mon_start_assemble_mode(yystack.l_mark[-1].a, NULL); }
break;
case 66:
#line 327 "../../../vice/src/monitor/mon_parse.y"
	{ mon_disassemble_lines(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1]); }
break;
case 67:
#line 329 "../../../vice/src/monitor/mon_parse.y"
	{ mon_disassemble_lines(BAD_ADDR, BAD_ADDR); }
break;
case 68:
#line 333 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memory_move(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1], yystack.l_mark[-1].a); }
break;
case 69:
#line 335 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memory_compare(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1], yystack.l_mark[-1].a); }
break;
case 70:
#line 337 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memory_fill(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1],(unsigned char *)yystack.l_mark[-1].str); }
break;
case 71:
#line 339 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memory_hunt(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1],(unsigned char *)yystack.l_mark[-1].str); }
break;
case 72:
#line 341 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memory_display(yystack.l_mark[-3].rt, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
break;
case 73:
#line 343 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memory_display(default_radix, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
break;
case 74:
#line 345 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memory_display(default_radix, BAD_ADDR, BAD_ADDR, DF_PETSCII); }
break;
case 75:
#line 347 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memory_display_data(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], 8, 8); }
break;
case 76:
#line 349 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memory_display_data(BAD_ADDR, BAD_ADDR, 8, 8); }
break;
case 77:
#line 351 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memory_display_data(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], 24, 21); }
break;
case 78:
#line 353 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memory_display_data(BAD_ADDR, BAD_ADDR, 24, 21); }
break;
case 79:
#line 355 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memory_display(0, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
break;
case 80:
#line 357 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memory_display(0, BAD_ADDR, BAD_ADDR, DF_PETSCII); }
break;
case 81:
#line 359 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memory_display(0, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_SCREEN_CODE); }
break;
case 82:
#line 361 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memory_display(0, BAD_ADDR, BAD_ADDR, DF_SCREEN_CODE); }
break;
case 83:
#line 363 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memmap_zap(); }
break;
case 84:
#line 365 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memmap_show(-1,BAD_ADDR,BAD_ADDR); }
break;
case 85:
#line 367 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memmap_show(yystack.l_mark[-1].i,BAD_ADDR,BAD_ADDR); }
break;
case 86:
#line 369 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memmap_show(yystack.l_mark[-2].i,yystack.l_mark[-1].range[0],yystack.l_mark[-1].range[1]); }
break;
case 87:
#line 371 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memmap_save(yystack.l_mark[-3].str,yystack.l_mark[-1].i); }
break;
case 88:
#line 375 "../../../vice/src/monitor/mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, yystack.l_mark[-3].i, FALSE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, e_exec, FALSE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
break;
case 89:
#line 384 "../../../vice/src/monitor/mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
break;
case 90:
#line 387 "../../../vice/src/monitor/mon_parse.y"
	{
                      mon_breakpoint_add_checkpoint(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], TRUE, e_exec, TRUE);
                  }
break;
case 91:
#line 391 "../../../vice/src/monitor/mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
break;
case 92:
#line 394 "../../../vice/src/monitor/mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, yystack.l_mark[-3].i, FALSE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, e_load | e_store, FALSE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
break;
case 93:
#line 403 "../../../vice/src/monitor/mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
break;
case 94:
#line 406 "../../../vice/src/monitor/mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], FALSE, yystack.l_mark[-3].i, FALSE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], FALSE, e_load | e_store, FALSE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
break;
case 95:
#line 415 "../../../vice/src/monitor/mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
break;
case 96:
#line 420 "../../../vice/src/monitor/mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_ON, yystack.l_mark[-1].i); }
break;
case 97:
#line 422 "../../../vice/src/monitor/mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_ON, -1); }
break;
case 98:
#line 424 "../../../vice/src/monitor/mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_OFF, yystack.l_mark[-1].i); }
break;
case 99:
#line 426 "../../../vice/src/monitor/mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_OFF, -1); }
break;
case 100:
#line 428 "../../../vice/src/monitor/mon_parse.y"
	{ mon_breakpoint_set_ignore_count(yystack.l_mark[-1].i, -1); }
break;
case 101:
#line 430 "../../../vice/src/monitor/mon_parse.y"
	{ mon_breakpoint_set_ignore_count(yystack.l_mark[-3].i, yystack.l_mark[-1].i); }
break;
case 102:
#line 432 "../../../vice/src/monitor/mon_parse.y"
	{ mon_breakpoint_delete_checkpoint(yystack.l_mark[-1].i); }
break;
case 103:
#line 434 "../../../vice/src/monitor/mon_parse.y"
	{ mon_breakpoint_delete_checkpoint(-1); }
break;
case 104:
#line 436 "../../../vice/src/monitor/mon_parse.y"
	{ mon_breakpoint_set_checkpoint_condition(yystack.l_mark[-3].i, yystack.l_mark[-1].cond_node); }
break;
case 105:
#line 438 "../../../vice/src/monitor/mon_parse.y"
	{ mon_breakpoint_set_checkpoint_command(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
break;
case 106:
#line 440 "../../../vice/src/monitor/mon_parse.y"
	{ return ERR_EXPECT_STRING; }
break;
case 107:
#line 444 "../../../vice/src/monitor/mon_parse.y"
	{ sidefx = ((yystack.l_mark[-1].action == e_TOGGLE) ? (sidefx ^ 1) : yystack.l_mark[-1].action); }
break;
case 108:
#line 446 "../../../vice/src/monitor/mon_parse.y"
	{
                         mon_out("I/O side effects are %s\n",
                                   sidefx ? "enabled" : "disabled");
                     }
break;
case 109:
#line 451 "../../../vice/src/monitor/mon_parse.y"
	{ default_radix = yystack.l_mark[-1].rt; }
break;
case 110:
#line 453 "../../../vice/src/monitor/mon_parse.y"
	{
                         const char *p;

                         if (default_radix == e_hexadecimal)
                             p = "Hexadecimal";
                         else if (default_radix == e_decimal)
                             p = "Decimal";
                         else if (default_radix == e_octal)
                             p = "Octal";
                         else if (default_radix == e_binary)
                             p = "Binary";
                         else
                             p = "Unknown";

                         mon_out("Default radix is %s\n", p);
                     }
break;
case 111:
#line 471 "../../../vice/src/monitor/mon_parse.y"
	{ monitor_change_device(yystack.l_mark[-1].i); }
break;
case 112:
#line 473 "../../../vice/src/monitor/mon_parse.y"
	{ mon_export(); }
break;
case 113:
#line 475 "../../../vice/src/monitor/mon_parse.y"
	{ mon_quit(); YYACCEPT; }
break;
case 114:
#line 477 "../../../vice/src/monitor/mon_parse.y"
	{ mon_exit(); YYACCEPT; }
break;
case 115:
#line 481 "../../../vice/src/monitor/mon_parse.y"
	{ mon_drive_execute_disk_cmd(yystack.l_mark[-1].str); }
break;
case 116:
#line 483 "../../../vice/src/monitor/mon_parse.y"
	{ mon_out("\t%d\n",yystack.l_mark[-1].i); }
break;
case 117:
#line 485 "../../../vice/src/monitor/mon_parse.y"
	{ mon_command_print_help(NULL); }
break;
case 118:
#line 487 "../../../vice/src/monitor/mon_parse.y"
	{ mon_command_print_help(yystack.l_mark[-1].str); }
break;
case 119:
#line 489 "../../../vice/src/monitor/mon_parse.y"
	{ mon_print_convert(yystack.l_mark[-1].i); }
break;
case 120:
#line 491 "../../../vice/src/monitor/mon_parse.y"
	{ mon_change_dir(yystack.l_mark[-1].str); }
break;
case 121:
#line 493 "../../../vice/src/monitor/mon_parse.y"
	{ mon_keyboard_feed(yystack.l_mark[-1].str); }
break;
case 122:
#line 495 "../../../vice/src/monitor/mon_parse.y"
	{ mon_backtrace(); }
break;
case 123:
#line 497 "../../../vice/src/monitor/mon_parse.y"
	{ mon_show_dir(yystack.l_mark[-1].str); }
break;
case 124:
#line 499 "../../../vice/src/monitor/mon_parse.y"
	{ mon_show_pwd(); }
break;
case 125:
#line 501 "../../../vice/src/monitor/mon_parse.y"
	{ mon_screenshot_save(yystack.l_mark[-1].str,-1); }
break;
case 126:
#line 503 "../../../vice/src/monitor/mon_parse.y"
	{ mon_screenshot_save(yystack.l_mark[-3].str,yystack.l_mark[-1].i); }
break;
case 127:
#line 505 "../../../vice/src/monitor/mon_parse.y"
	{ mon_resource_get(yystack.l_mark[-1].str); }
break;
case 128:
#line 507 "../../../vice/src/monitor/mon_parse.y"
	{ mon_resource_set(yystack.l_mark[-2].str,yystack.l_mark[-1].str); }
break;
case 129:
#line 509 "../../../vice/src/monitor/mon_parse.y"
	{ resources_load(yystack.l_mark[-1].str); }
break;
case 130:
#line 511 "../../../vice/src/monitor/mon_parse.y"
	{ resources_save(yystack.l_mark[-1].str); }
break;
case 131:
#line 513 "../../../vice/src/monitor/mon_parse.y"
	{ mon_reset_machine(-1); }
break;
case 132:
#line 515 "../../../vice/src/monitor/mon_parse.y"
	{ mon_reset_machine(yystack.l_mark[-1].i); }
break;
case 133:
#line 517 "../../../vice/src/monitor/mon_parse.y"
	{ mon_tape_ctrl(yystack.l_mark[-1].i); }
break;
case 134:
#line 519 "../../../vice/src/monitor/mon_parse.y"
	{ mon_cart_freeze(); }
break;
case 135:
#line 521 "../../../vice/src/monitor/mon_parse.y"
	{ }
break;
case 136:
#line 523 "../../../vice/src/monitor/mon_parse.y"
	{ mon_stopwatch_reset(); }
break;
case 137:
#line 525 "../../../vice/src/monitor/mon_parse.y"
	{ mon_stopwatch_show("Stopwatch: ", "\n"); }
break;
case 138:
#line 529 "../../../vice/src/monitor/mon_parse.y"
	{ mon_file_load(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].a, FALSE); }
break;
case 139:
#line 531 "../../../vice/src/monitor/mon_parse.y"
	{ mon_file_load(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].a, TRUE); }
break;
case 140:
#line 533 "../../../vice/src/monitor/mon_parse.y"
	{ mon_file_save(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], FALSE); }
break;
case 141:
#line 535 "../../../vice/src/monitor/mon_parse.y"
	{ return ERR_EXPECT_DEVICE_NUM; }
break;
case 142:
#line 537 "../../../vice/src/monitor/mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
break;
case 143:
#line 539 "../../../vice/src/monitor/mon_parse.y"
	{ mon_file_save(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], TRUE); }
break;
case 144:
#line 541 "../../../vice/src/monitor/mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
break;
case 145:
#line 543 "../../../vice/src/monitor/mon_parse.y"
	{ mon_file_verify(yystack.l_mark[-3].str,yystack.l_mark[-2].i,yystack.l_mark[-1].a); }
break;
case 146:
#line 545 "../../../vice/src/monitor/mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
break;
case 147:
#line 547 "../../../vice/src/monitor/mon_parse.y"
	{ mon_drive_block_cmd(0,yystack.l_mark[-3].i,yystack.l_mark[-2].i,yystack.l_mark[-1].a); }
break;
case 148:
#line 549 "../../../vice/src/monitor/mon_parse.y"
	{ mon_drive_block_cmd(1,yystack.l_mark[-3].i,yystack.l_mark[-2].i,yystack.l_mark[-1].a); }
break;
case 149:
#line 551 "../../../vice/src/monitor/mon_parse.y"
	{ mon_drive_list(-1); }
break;
case 150:
#line 553 "../../../vice/src/monitor/mon_parse.y"
	{ mon_drive_list(yystack.l_mark[-1].i); }
break;
case 151:
#line 555 "../../../vice/src/monitor/mon_parse.y"
	{ mon_attach(yystack.l_mark[-2].str,yystack.l_mark[-1].i); }
break;
case 152:
#line 557 "../../../vice/src/monitor/mon_parse.y"
	{ mon_detach(yystack.l_mark[-1].i); }
break;
case 153:
#line 559 "../../../vice/src/monitor/mon_parse.y"
	{ mon_autostart(yystack.l_mark[-1].str,0,1); }
break;
case 154:
#line 561 "../../../vice/src/monitor/mon_parse.y"
	{ mon_autostart(yystack.l_mark[-3].str,yystack.l_mark[-1].i,1); }
break;
case 155:
#line 563 "../../../vice/src/monitor/mon_parse.y"
	{ mon_autostart(yystack.l_mark[-1].str,0,0); }
break;
case 156:
#line 565 "../../../vice/src/monitor/mon_parse.y"
	{ mon_autostart(yystack.l_mark[-3].str,yystack.l_mark[-1].i,0); }
break;
case 157:
#line 569 "../../../vice/src/monitor/mon_parse.y"
	{ mon_record_commands(yystack.l_mark[-1].str); }
break;
case 158:
#line 571 "../../../vice/src/monitor/mon_parse.y"
	{ mon_end_recording(); }
break;
case 159:
#line 573 "../../../vice/src/monitor/mon_parse.y"
	{ mon_playback_init(yystack.l_mark[-1].str); }
break;
case 160:
#line 577 "../../../vice/src/monitor/mon_parse.y"
	{ mon_memory_fill(yystack.l_mark[-2].a, BAD_ADDR, (unsigned char *)yystack.l_mark[-1].str); }
break;
case 161:
#line 579 "../../../vice/src/monitor/mon_parse.y"
	{ printf("Not yet.\n"); }
break;
case 162:
#line 583 "../../../vice/src/monitor/mon_parse.y"
	{ yydebug = 1; }
break;
case 163:
#line 586 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.str = yystack.l_mark[0].str; }
break;
case 164:
#line 589 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.str = yystack.l_mark[0].str; }
break;
case 165:
#line 590 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.str = NULL; }
break;
case 167:
#line 594 "../../../vice/src/monitor/mon_parse.y"
	{ return ERR_EXPECT_FILENAME; }
break;
case 169:
#line 598 "../../../vice/src/monitor/mon_parse.y"
	{ return ERR_EXPECT_DEVICE_NUM; }
break;
case 170:
#line 601 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[-1].i | yystack.l_mark[0].i; }
break;
case 171:
#line 602 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 172:
#line 605 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 173:
#line 606 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = 0; }
break;
case 174:
#line 609 "../../../vice/src/monitor/mon_parse.y"
	{
                                    if (!mon_register_valid(default_memspace, yystack.l_mark[0].reg)) {
                                        return ERR_INVALID_REGISTER;
                                    }
                                    yyval.i = new_reg(default_memspace, yystack.l_mark[0].reg);
                                }
break;
case 175:
#line 615 "../../../vice/src/monitor/mon_parse.y"
	{
                                    if (!mon_register_valid(yystack.l_mark[-1].i, yystack.l_mark[0].reg)) {
                                        return ERR_INVALID_REGISTER;
                                    }
                                    yyval.i = new_reg(yystack.l_mark[-1].i, yystack.l_mark[0].reg);
                                }
break;
case 178:
#line 628 "../../../vice/src/monitor/mon_parse.y"
	{ (monitor_cpu_for_memspace[reg_memspace(yystack.l_mark[-2].i)]->mon_register_set_val)(reg_memspace(yystack.l_mark[-2].i), reg_regid(yystack.l_mark[-2].i), (WORD) yystack.l_mark[0].i); }
break;
case 179:
#line 631 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 180:
#line 632 "../../../vice/src/monitor/mon_parse.y"
	{ return ERR_EXPECT_CHECKNUM; }
break;
case 182:
#line 636 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.range[0] = yystack.l_mark[0].a; yyval.range[1] = BAD_ADDR; }
break;
case 183:
#line 639 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.range[0] = yystack.l_mark[-2].a; yyval.range[1] = yystack.l_mark[0].a; }
break;
case 184:
#line 641 "../../../vice/src/monitor/mon_parse.y"
	{ if (resolve_range(e_default_space, yyval.range, yystack.l_mark[0].str)) return ERR_ADDR_TOO_BIG; }
break;
case 185:
#line 643 "../../../vice/src/monitor/mon_parse.y"
	{ if (resolve_range(yystack.l_mark[-2].i, yyval.range, yystack.l_mark[0].str)) return ERR_ADDR_TOO_BIG; }
break;
case 186:
#line 646 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.a = yystack.l_mark[0].a; }
break;
case 187:
#line 647 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.a = BAD_ADDR; }
break;
case 188:
#line 651 "../../../vice/src/monitor/mon_parse.y"
	{
             yyval.a = new_addr(e_default_space,yystack.l_mark[0].i);
             if (opt_asm) new_cmd = asm_mode = 1;
         }
break;
case 189:
#line 656 "../../../vice/src/monitor/mon_parse.y"
	{
             yyval.a = new_addr(yystack.l_mark[-2].i, yystack.l_mark[0].i);
             if (opt_asm) new_cmd = asm_mode = 1;
         }
break;
case 190:
#line 661 "../../../vice/src/monitor/mon_parse.y"
	{
             temp = mon_symbol_table_lookup_addr(e_default_space, yystack.l_mark[0].str);
             if (temp >= 0)
                 yyval.a = new_addr(e_default_space, temp);
             else
                 return ERR_UNDEFINED_LABEL;
         }
break;
case 193:
#line 674 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = e_comp_space; }
break;
case 194:
#line 675 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = e_disk8_space; }
break;
case 195:
#line 676 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = e_disk9_space; }
break;
case 196:
#line 677 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = e_disk10_space; }
break;
case 197:
#line 678 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = e_disk11_space; }
break;
case 198:
#line 681 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; if (!CHECK_ADDR(yystack.l_mark[0].i)) return ERR_ADDR_TOO_BIG; }
break;
case 199:
#line 683 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 200:
#line 685 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i + yystack.l_mark[0].i; }
break;
case 201:
#line 686 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i - yystack.l_mark[0].i; }
break;
case 202:
#line 687 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i * yystack.l_mark[0].i; }
break;
case 203:
#line 688 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = (yystack.l_mark[0].i) ? (yystack.l_mark[-2].i / yystack.l_mark[0].i) : 1; }
break;
case 204:
#line 689 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[-1].i; }
break;
case 205:
#line 690 "../../../vice/src/monitor/mon_parse.y"
	{ return ERR_MISSING_CLOSE_PAREN; }
break;
case 206:
#line 691 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 207:
#line 694 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[0].cond_node; }
break;
case 208:
#line 695 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.cond_node = 0; }
break;
case 209:
#line 698 "../../../vice/src/monitor/mon_parse.y"
	{
               yyval.cond_node = new_cond; yyval.cond_node->is_parenthized = FALSE;
               yyval.cond_node->child1 = yystack.l_mark[-2].cond_node; yyval.cond_node->child2 = yystack.l_mark[0].cond_node; yyval.cond_node->operation = yystack.l_mark[-1].cond_op;
           }
break;
case 210:
#line 703 "../../../vice/src/monitor/mon_parse.y"
	{ return ERR_INCOMPLETE_COMPARE_OP; }
break;
case 211:
#line 705 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[-1].cond_node; yyval.cond_node->is_parenthized = TRUE; }
break;
case 212:
#line 707 "../../../vice/src/monitor/mon_parse.y"
	{ return ERR_MISSING_CLOSE_PAREN; }
break;
case 213:
#line 709 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[0].cond_node; }
break;
case 214:
#line 712 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.cond_node = new_cond;
                            yyval.cond_node->operation = e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->reg_num = yystack.l_mark[0].i; yyval.cond_node->is_reg = TRUE;
                            yyval.cond_node->child1 = NULL; yyval.cond_node->child2 = NULL;
                          }
break;
case 215:
#line 718 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.cond_node = new_cond;
                            yyval.cond_node->operation = e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->value = yystack.l_mark[0].i; yyval.cond_node->is_reg = FALSE;
                            yyval.cond_node->child1 = NULL; yyval.cond_node->child2 = NULL;
                          }
break;
case 218:
#line 730 "../../../vice/src/monitor/mon_parse.y"
	{ mon_add_number_to_buffer(yystack.l_mark[0].i); }
break;
case 219:
#line 731 "../../../vice/src/monitor/mon_parse.y"
	{ mon_add_string_to_buffer(yystack.l_mark[0].str); }
break;
case 222:
#line 738 "../../../vice/src/monitor/mon_parse.y"
	{ mon_add_number_to_buffer(yystack.l_mark[0].i); }
break;
case 223:
#line 739 "../../../vice/src/monitor/mon_parse.y"
	{ mon_add_number_masked_to_buffer(yystack.l_mark[0].i, 0x00); }
break;
case 224:
#line 740 "../../../vice/src/monitor/mon_parse.y"
	{ mon_add_string_to_buffer(yystack.l_mark[0].str); }
break;
case 225:
#line 743 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 226:
#line 744 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = (monitor_cpu_for_memspace[reg_memspace(yystack.l_mark[0].i)]->mon_register_get_val)(reg_memspace(yystack.l_mark[0].i), reg_regid(yystack.l_mark[0].i)); }
break;
case 227:
#line 747 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 228:
#line 748 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = strtol(yystack.l_mark[0].str, NULL, 10); }
break;
case 229:
#line 749 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = strtol(yystack.l_mark[0].str, NULL, 10); }
break;
case 230:
#line 750 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = strtol(yystack.l_mark[0].str, NULL, 10); }
break;
case 231:
#line 753 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = resolve_datatype(B_NUMBER,yystack.l_mark[0].str); }
break;
case 232:
#line 754 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = resolve_datatype(O_NUMBER,yystack.l_mark[0].str); }
break;
case 233:
#line 755 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = resolve_datatype(D_NUMBER,yystack.l_mark[0].str); }
break;
case 234:
#line 758 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 235:
#line 759 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 236:
#line 760 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 237:
#line 761 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 238:
#line 762 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 242:
#line 770 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = 0;
                                                if (yystack.l_mark[-1].str) {
                                                    (monitor_cpu_for_memspace[default_memspace]->mon_assemble_instr)(yystack.l_mark[-1].str, yystack.l_mark[0].mode);
                                                } else {
                                                    new_cmd = 1;
                                                    asm_mode = 0;
                                                }
                                                opt_asm = 0;
                                              }
break;
case 244:
#line 781 "../../../vice/src/monitor/mon_parse.y"
	{ asm_mode = 0; }
break;
case 245:
#line 784 "../../../vice/src/monitor/mon_parse.y"
	{ if (yystack.l_mark[0].i > 0xff) {
                          yyval.mode.addr_mode = ASM_ADDR_MODE_IMMEDIATE_16;
                          yyval.mode.param = yystack.l_mark[0].i;
                        } else {
                          yyval.mode.addr_mode = ASM_ADDR_MODE_IMMEDIATE;
                          yyval.mode.param = yystack.l_mark[0].i;
                        } }
break;
case 246:
#line 791 "../../../vice/src/monitor/mon_parse.y"
	{ if (yystack.l_mark[0].i >= 0x10000) {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_LONG;
               yyval.mode.param = yystack.l_mark[0].i;
             } else if (yystack.l_mark[0].i < 0x100) {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE;
               yyval.mode.param = yystack.l_mark[0].i;
             } else {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE;
               yyval.mode.param = yystack.l_mark[0].i;
             }
           }
break;
case 247:
#line 802 "../../../vice/src/monitor/mon_parse.y"
	{ if (yystack.l_mark[-2].i >= 0x10000) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_LONG_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else if (yystack.l_mark[-2].i < 0x100) { 
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          }
                        }
break;
case 248:
#line 813 "../../../vice/src/monitor/mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE_Y;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_Y;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          }
                        }
break;
case 249:
#line 821 "../../../vice/src/monitor/mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_STACK_RELATIVE;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else { /* 6809 */
                            yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
                            if (yystack.l_mark[-2].i >= -16 && yystack.l_mark[-2].i < 16) {
                                yyval.mode.addr_submode = yystack.l_mark[0].i | (yystack.l_mark[-2].i & 0x1F);
                            } else if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
                                yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF8;
                                yyval.mode.param = yystack.l_mark[-2].i;
                            } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
                                yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF16;
                                yyval.mode.param = yystack.l_mark[-2].i;
                            } else {
                                yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
                                mon_out("offset too large even for 16 bits (signed)\n");
                            }
                          }
                        }
break;
case 250:
#line 840 "../../../vice/src/monitor/mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_DOUBLE;
                            yyval.mode.param = yystack.l_mark[0].i;
                            yyval.mode.addr_submode = yystack.l_mark[-2].i;
                          }
                        }
break;
case 251:
#line 846 "../../../vice/src/monitor/mon_parse.y"
	{ if (yystack.l_mark[-1].i < 0x100) {
                               yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT;
                               yyval.mode.param = yystack.l_mark[-1].i;
                             } else {
                               yyval.mode.addr_mode = ASM_ADDR_MODE_ABS_INDIRECT;
                               yyval.mode.param = yystack.l_mark[-1].i;
                             }
                           }
break;
case 252:
#line 854 "../../../vice/src/monitor/mon_parse.y"
	{ if (yystack.l_mark[-3].i < 0x100) {
                                           yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_X;
                                           yyval.mode.param = yystack.l_mark[-3].i;
                                         } else {
                                           yyval.mode.addr_mode = ASM_ADDR_MODE_ABS_INDIRECT_X;
                                           yyval.mode.param = yystack.l_mark[-3].i;
                                         }
                                       }
break;
case 253:
#line 863 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_STACK_RELATIVE_Y; yyval.mode.param = yystack.l_mark[-5].i; }
break;
case 254:
#line 865 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_Y; yyval.mode.param = yystack.l_mark[-3].i; }
break;
case 255:
#line 866 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_BC; }
break;
case 256:
#line 867 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_DE; }
break;
case 257:
#line 868 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_HL; }
break;
case 258:
#line 869 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_IX; }
break;
case 259:
#line 870 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_IY; }
break;
case 260:
#line 871 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_SP; }
break;
case 261:
#line 873 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_A; yyval.mode.param = yystack.l_mark[-3].i; }
break;
case 262:
#line 875 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_HL; yyval.mode.param = yystack.l_mark[-3].i; }
break;
case 263:
#line 877 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_IX; yyval.mode.param = yystack.l_mark[-3].i; }
break;
case 264:
#line 879 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_IY; yyval.mode.param = yystack.l_mark[-3].i; }
break;
case 265:
#line 880 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_IMPLIED; }
break;
case 266:
#line 881 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ACCUMULATOR; }
break;
case 267:
#line 882 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_B; }
break;
case 268:
#line 883 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_C; }
break;
case 269:
#line 884 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_D; }
break;
case 270:
#line 885 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_E; }
break;
case 271:
#line 886 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_H; }
break;
case 272:
#line 887 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IXH; }
break;
case 273:
#line 888 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IYH; }
break;
case 274:
#line 889 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_L; }
break;
case 275:
#line 890 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IXL; }
break;
case 276:
#line 891 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IYL; }
break;
case 277:
#line 892 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_AF; }
break;
case 278:
#line 893 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_BC; }
break;
case 279:
#line 894 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_DE; }
break;
case 280:
#line 895 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_HL; }
break;
case 281:
#line 896 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IX; }
break;
case 282:
#line 897 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IY; }
break;
case 283:
#line 898 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_SP; }
break;
case 284:
#line 900 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_DIRECT; yyval.mode.param = yystack.l_mark[0].i; }
break;
case 285:
#line 901 "../../../vice/src/monitor/mon_parse.y"
	{    /* Clash with addr,x addr,y addr,s modes! */
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        if (yystack.l_mark[-2].i >= -16 && yystack.l_mark[-2].i < 16) {
            yyval.mode.addr_submode = (3 << 5) | (yystack.l_mark[-2].i & 0x1F);
        } else if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
            yyval.mode.addr_submode = 0x80 | (3 << 5) | ASM_ADDR_MODE_INDEXED_OFF8;
            yyval.mode.param = yystack.l_mark[-2].i;
        } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
            yyval.mode.addr_submode = 0x80 | (3 << 5) | ASM_ADDR_MODE_INDEXED_OFF16;
            yyval.mode.param = yystack.l_mark[-2].i;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
break;
case 286:
#line 916 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_INC1;
        }
break;
case 287:
#line 920 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_INC2;
        }
break;
case 288:
#line 924 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_DEC1;
        }
break;
case 289:
#line 928 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_DEC2;
        }
break;
case 290:
#line 932 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF0;
        }
break;
case 291:
#line 936 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFB;
        }
break;
case 292:
#line 940 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFA;
        }
break;
case 293:
#line 944 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFD;
        }
break;
case 294:
#line 948 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.param = yystack.l_mark[-2].i;
        if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC8;
        } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC16;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
break;
case 295:
#line 960 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        if (yystack.l_mark[-3].i >= -16 && yystack.l_mark[-3].i < 16) {
            yyval.mode.addr_submode = yystack.l_mark[-3].i & 0x1F;
        } else if (yystack.l_mark[-4].i >= -128 && yystack.l_mark[-4].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFF8;
            yyval.mode.param = yystack.l_mark[-3].i;
        } else if (yystack.l_mark[-3].i >= -32768 && yystack.l_mark[-3].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFF16;
            yyval.mode.param = yystack.l_mark[-3].i;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
break;
case 296:
#line 975 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_INC1;
        }
break;
case 297:
#line 979 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-3].i | ASM_ADDR_MODE_INDEXED_INC2;
        }
break;
case 298:
#line 983 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_DEC1;
        }
break;
case 299:
#line 987 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_DEC2;
        }
break;
case 300:
#line 991 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFF0;
        }
break;
case 301:
#line 995 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFB;
        }
break;
case 302:
#line 999 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFA;
        }
break;
case 303:
#line 1003 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFD;
        }
break;
case 304:
#line 1007 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.param = yystack.l_mark[-3].i;
        if (yystack.l_mark[-3].i >= -128 && yystack.l_mark[-3].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC8_IND;
        } else if (yystack.l_mark[-3].i >= -32768 && yystack.l_mark[-3].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC16_IND;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
break;
case 305:
#line 1019 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | ASM_ADDR_MODE_EXTENDED_INDIRECT;
        yyval.mode.param = yystack.l_mark[-1].i;
        }
break;
case 306:
#line 1024 "../../../vice/src/monitor/mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_LONG_Y;
        yyval.mode.param = yystack.l_mark[-3].i;
        }
break;
case 307:
#line 1032 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = (0 << 5); printf("reg_x\n"); }
break;
case 308:
#line 1033 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = (1 << 5); printf("reg_y\n"); }
break;
case 309:
#line 1034 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 310:
#line 1035 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = (3 << 5); printf("reg_s\n"); }
break;
case 311:
#line 1039 "../../../vice/src/monitor/mon_parse.y"
	{ yyval.i = (2 << 5); printf("reg_u\n"); }
break;
#line 3235 "../../../vice/src/monitor/mon_parse.c"
    }
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yystack.s_mark = YYFINAL;
        *++yystack.l_mark = yyval;
        if (yychar < 0)
        {
            if ((yychar = YYLEX) < 0) yychar = YYEOF;
#if YYDEBUG
            if (yydebug)
            {
                yys = yyname[YYTRANSLATE(yychar)];
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == YYEOF) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yystack.s_mark, yystate);
#endif
    if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM)
    {
        goto yyoverflow;
    }
    *++yystack.s_mark = (YYINT) yystate;
    *++yystack.l_mark = yyval;
    goto yyloop;

yyoverflow:
    YYERROR_CALL("yacc stack overflow");

yyabort:
    yyfreestack(&yystack);
    return (1);

yyaccept:
    yyfreestack(&yystack);
    return (0);
}
