/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 14:53:01 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFileWriter;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.GenbankMisc;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class GenbankMisc_ESTest extends GenbankMisc_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      GenbankMisc genbankMisc0 = null;
      try {
        genbankMisc0 = new GenbankMisc((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GenbankMisc", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      PipedInputStream pipedInputStream0 = new PipedInputStream(1076);
      BufferedInputStream bufferedInputStream0 = new BufferedInputStream(pipedInputStream0, 1076);
      Charset charset0 = Charset.defaultCharset();
      InputStreamReader inputStreamReader0 = new InputStreamReader(bufferedInputStream0, charset0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(inputStreamReader0);
      GenbankMisc genbankMisc0 = null;
      try {
        genbankMisc0 = new GenbankMisc(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      StringReader stringReader0 = new StringReader("Property ");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      GenbankMisc genbankMisc0 = new GenbankMisc(linePushBackReader0);
      MockFileWriter mockFileWriter0 = new MockFileWriter("\n");
      genbankMisc0.writeToStream(mockFileWriter0);
      assertEquals("Property ", genbankMisc0.getLine());
  }
}
