/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:19:53 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileNotFoundException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.LogReadListener;
import uk.ac.sanger.artemis.components.filetree.RemoteFileNode;
import uk.ac.sanger.artemis.io.BioJavaEntry;
import uk.ac.sanger.artemis.io.BioJavaFeature;
import uk.ac.sanger.artemis.io.BlastDocumentEntry;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.EmblDocumentEntry;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.MSPcrunchEntryInformation;
import uk.ac.sanger.artemis.io.PublicDBDocumentEntry;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.RemoteFileDocument;
import uk.ac.sanger.artemis.util.ZipFileDocument;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class PublicDBDocumentEntry_ESTest extends PublicDBDocumentEntry_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Key key0 = new Key("", true);
      Key key1 = PublicDBDocumentEntry.mapKeys(key0);
      assertEquals(0, key1.length());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      uk.ac.sanger.artemis.Entry entry0 = uk.ac.sanger.artemis.Entry.newEntry((Bases) null);
      EntryInformation entryInformation0 = entry0.getEntryInformation();
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(entryInformation0);
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      StreamSequence streamSequence0 = publicDBDocumentEntry0.makeNativeSequence(genbankStreamSequence0);
      assertEquals(2, streamSequence0.getFormatType());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(simpleEntryInformation0);
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("4wZ8-l:e(T");
      char[] charArray0 = new char[3];
      charArray0[2] = 'c';
      rawStreamSequence0.setFromChar(charArray0);
      GenbankStreamSequence genbankStreamSequence0 = (GenbankStreamSequence)publicDBDocumentEntry0.makeNativeSequence(rawStreamSequence0);
      assertNull(genbankStreamSequence0.getHeader());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      // Undeclared exception!
      try { 
        PublicDBDocumentEntry.mapKeys((Key) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PublicDBDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(entryInformation0);
      // Undeclared exception!
      try { 
        publicDBDocumentEntry0.makeNativeSequence((Sequence) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GenbankStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      LogReadListener logReadListener0 = new LogReadListener("gWmL?2$");
      PublicDBDocumentEntry publicDBDocumentEntry0 = null;
      try {
        publicDBDocumentEntry0 = new PublicDBDocumentEntry(mSPcrunchEntryInformation0, (Document) null, logReadListener0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      MockFile mockFile0 = new MockFile((File) null, "oP?9e%(TRrv");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, " category\">");
      LogReadListener logReadListener0 = new LogReadListener("oP?9e%(TRrv");
      PublicDBDocumentEntry publicDBDocumentEntry0 = null;
      try {
        publicDBDocumentEntry0 = new PublicDBDocumentEntry(entryInformation0, zipFileDocument0, logReadListener0);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      PublicDBDocumentEntry publicDBDocumentEntry0 = null;
      try {
        publicDBDocumentEntry0 = new PublicDBDocumentEntry((EntryInformation) null, (Entry) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleEntryInformation", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      PublicDBDocumentEntry publicDBDocumentEntry0 = null;
      try {
        publicDBDocumentEntry0 = new PublicDBDocumentEntry((EntryInformation) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleEntryInformation", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(entryInformation0);
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(entryInformation0, blastDocumentEntry0, true);
      assertFalse(publicDBDocumentEntry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(blastEntryInformation0);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("|uz ZA.Z@}YE89}H$");
      EmblStreamSequence emblStreamSequence0 = (EmblStreamSequence)emblDocumentEntry0.makeNativeSequence(fastaStreamSequence0);
      assertNull(emblStreamSequence0.getHeader());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Key key0 = Key.CDS;
      Key key1 = PublicDBDocumentEntry.mapKeys(key0);
      Key key2 = PublicDBDocumentEntry.mapKeys(key1);
      assertSame(key2, key1);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(simpleEntryInformation0);
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      Feature feature0 = emblDocumentEntry0.forcedAdd(emblStreamFeature0);
      assertSame(feature0, emblStreamFeature0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(entryInformation0);
      BioJavaFeature bioJavaFeature0 = new BioJavaFeature((org.biojava.bio.seq.Feature) null, (BioJavaEntry) null);
      // Undeclared exception!
      try { 
        publicDBDocumentEntry0.makeNativeFeature(bioJavaFeature0, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PublicDBDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(blastEntryInformation0);
      // Undeclared exception!
      try { 
        emblDocumentEntry0.makeNativeFeature((Feature) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PublicDBDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(false);
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      LogReadListener logReadListener0 = new LogReadListener(" WHERE ");
      PublicDBDocumentEntry publicDBDocumentEntry0 = null;
      try {
        publicDBDocumentEntry0 = new PublicDBDocumentEntry(mSPcrunchEntryInformation0, remoteFileDocument0, logReadListener0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      PublicDBDocumentEntry.getDatabaseQualifiersToRemove();
  }
}
