/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.build;

import java.io.File;
import java.util.Hashtable;
import org.aspectj.internal.tools.build.Messager;
import org.aspectj.internal.tools.build.Module;
import org.aspectj.internal.tools.build.Util;

public class Modules {
    private final Hashtable<String, Module> modules = new Hashtable();
    public final File baseDir;
    public final File jarDir;
    private final Messager handler;

    public Modules(File baseDir, File jarDir, Messager handler) {
        this.baseDir = baseDir;
        this.jarDir = jarDir;
        this.handler = handler;
        Util.iaxIfNotCanReadDir(baseDir, "baseDir");
        Util.iaxIfNotCanReadDir(jarDir, "jarDir");
        Util.iaxIfNull(handler, "handler");
    }

    public Module getModule(String name) {
        if (null == name) {
            return null;
        }
        Module result = this.modules.get(name);
        if (null == result) {
            File moduleDir = new File(this.baseDir, name);
            if (!Util.canReadDir(moduleDir)) {
                this.handler.error("not a module: " + name);
            } else {
                result = new Module(moduleDir, this.jarDir, name, this, this.handler);
                if (result.valid) {
                    this.modules.put(name, result);
                } else {
                    this.handler.error("invalid module: " + result.toLongString());
                }
            }
        }
        return result;
    }
}

