/* This file is part of the KDE project
   Copyright (C) 2009-2010 Thorsten Zachmann <zachmann@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "KoPATextPage.h"

KoPATextPage::KoPATextPage(int pageNumber, KoPAPageBase * page)
: m_pageNumber(pageNumber)
, m_page(page)
{
}

KoPATextPage::~KoPATextPage()
{
}

int KoPATextPage::pageNumber() const
{
    return m_pageNumber;
}

int KoPATextPage::visiblePageNumber(PageSelection select, int adjustment) const
{
    Q_UNUSED(select);
    return m_pageNumber + adjustment;
}

KoPAPageBase *KoPATextPage::page() const
{
    return m_page;
}

QRectF KoPATextPage::rect() const
{
    return QRectF();
}
