// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chromeos/services/ime/public/cpp/rulebased/def/fa.h"

namespace fa {

const char* kId = "fa";
bool kIs102 = false;
const char* kNormal[] = {
    u8"\u200d",  // BackQuote
    u8"\u06f1",  // Digit1
    u8"\u06f2",  // Digit2
    u8"\u06f3",  // Digit3
    u8"\u06f4",  // Digit4
    u8"\u06f5",  // Digit5
    u8"\u06f6",  // Digit6
    u8"\u06f7",  // Digit7
    u8"\u06f8",  // Digit8
    u8"\u06f9",  // Digit9
    u8"\u06f0",  // Digit0
    u8"-",       // Minus
    u8"=",       // Equal
    u8"\u0636",  // KeyQ
    u8"\u0635",  // KeyW
    u8"\u062b",  // KeyE
    u8"\u0642",  // KeyR
    u8"\u0641",  // KeyT
    u8"\u063a",  // KeyY
    u8"\u0639",  // KeyU
    u8"\u0647",  // KeyI
    u8"\u062e",  // KeyO
    u8"\u062d",  // KeyP
    u8"\u062c",  // BracketLeft
    u8"\u0686",  // BracketRight
    u8"\\",      // Backslash
    u8"\u0634",  // KeyA
    u8"\u0633",  // KeyS
    u8"\u06cc",  // KeyD
    u8"\u0628",  // KeyF
    u8"\u0644",  // KeyG
    u8"\u0627",  // KeyH
    u8"\u062a",  // KeyJ
    u8"\u0646",  // KeyK
    u8"\u0645",  // KeyL
    u8"\u06a9",  // Semicolon
    u8"\u06af",  // Quote
    u8"\u0638",  // KeyZ
    u8"\u0637",  // KeyX
    u8"\u0632",  // KeyC
    u8"\u0631",  // KeyV
    u8"\u0630",  // KeyB
    u8"\u062f",  // KeyN
    u8"\u067e",  // KeyM
    u8"\u0648",  // Comma
    u8".",       // Period
    u8"/",       // Slash
    u8"\u0020",  // Space
};
const char* kShift[] = {
    u8"",                          // BackQuote
    u8"!",                         // Digit1
    u8"\u066c",                    // Digit2
    u8"\u066b",                    // Digit3
    u8"\u0631\u06cc\u0627\u0644",  // Digit4
    u8"\u066a",                    // Digit5
    u8"\u00d7",                    // Digit6
    u8"\u060c",                    // Digit7
    u8"*",                         // Digit8
    u8")",                         // Digit9
    u8"(",                         // Digit0
    u8"\u0640",                    // Minus
    u8"+",                         // Equal
    u8"\u0652",                    // KeyQ
    u8"\u064c",                    // KeyW
    u8"\u064d",                    // KeyE
    u8"\u064b",                    // KeyR
    u8"\u064f",                    // KeyT
    u8"\u0650",                    // KeyY
    u8"\u064e",                    // KeyU
    u8"\u0651",                    // KeyI
    u8"]",                         // KeyO
    u8"[",                         // KeyP
    u8"}",                         // BracketLeft
    u8"{",                         // BracketRight
    u8"|",                         // Backslash
    u8"\u0624",                    // KeyA
    u8"\u0626",                    // KeyS
    u8"\u064a",                    // KeyD
    u8"\u0625",                    // KeyF
    u8"\u0623",                    // KeyG
    u8"\u0622",                    // KeyH
    u8"\u0629",                    // KeyJ
    u8"\u00bb",                    // KeyK
    u8"\u00ab",                    // KeyL
    u8":",                         // Semicolon
    u8"\u061b",                    // Quote
    u8"\u0643",                    // KeyZ
    u8"",                          // KeyX
    u8"\u0698",                    // KeyC
    u8"",                          // KeyV
    u8"\u200c",                    // KeyB
    u8"",                          // KeyN
    u8"\u0621",                    // KeyM
    u8"<",                         // Comma
    u8">",                         // Period
    u8"\u061f",                    // Slash
    u8"\u200c",                    // Space
};
const char* kAltGr[] = {
    u8"~",       // BackQuote
    u8"`",       // Digit1
    u8"@",       // Digit2
    u8"#",       // Digit3
    u8"$",       // Digit4
    u8"%",       // Digit5
    u8"^",       // Digit6
    u8"&",       // Digit7
    u8"\u2022",  // Digit8
    u8"\u200e",  // Digit9
    u8"\u200f",  // Digit0
    u8"_",       // Minus
    u8"\u2212",  // Equal
    u8"\u00b0",  // KeyQ
    u8"",        // KeyW
    u8"\u20ac",  // KeyE
    u8"",        // KeyR
    u8"",        // KeyT
    u8"",        // KeyY
    u8"",        // KeyU
    u8"\u202d",  // KeyI
    u8"\u202e",  // KeyO
    u8"\u202c",  // KeyP
    u8"\u202a",  // BracketLeft
    u8"\u202b",  // BracketRight
    u8"\u2010",  // Backslash
    u8"",        // KeyA
    u8"",        // KeyS
    u8"\u0649",  // KeyD
    u8"",        // KeyF
    u8"",        // KeyG
    u8"\u0671",  // KeyH
    u8"",        // KeyJ
    u8"\ufd3e",  // KeyK
    u8"\ufd3f",  // KeyL
    u8";",       // Semicolon
    u8"\"",      // Quote
    u8"\u00a0",  // KeyZ
    u8"",        // KeyX
    u8"",        // KeyC
    u8"\u0656",  // KeyV
    u8"\u200d",  // KeyB
    u8"\u0655",  // KeyN
    u8"\u2026",  // KeyM
    u8",",       // Comma
    u8"'",       // Period
    u8"?",       // Slash
    u8"\u0020",  // Space
};
const char* kCapslock[] = {
    u8"\u200d",  // BackQuote
    u8"\u06f1",  // Digit1
    u8"\u06f2",  // Digit2
    u8"\u06f3",  // Digit3
    u8"\u06f4",  // Digit4
    u8"\u06f5",  // Digit5
    u8"\u06f6",  // Digit6
    u8"\u06f7",  // Digit7
    u8"\u06f8",  // Digit8
    u8"\u06f9",  // Digit9
    u8"\u06f0",  // Digit0
    u8"-",       // Minus
    u8"=",       // Equal
    u8"\u0636",  // KeyQ
    u8"\u0635",  // KeyW
    u8"\u062b",  // KeyE
    u8"\u0642",  // KeyR
    u8"\u0641",  // KeyT
    u8"\u063a",  // KeyY
    u8"\u0639",  // KeyU
    u8"\u0647",  // KeyI
    u8"\u062e",  // KeyO
    u8"\u062d",  // KeyP
    u8"\u062c",  // BracketLeft
    u8"\u0686",  // BracketRight
    u8"\\",      // Backslash
    u8"\u0634",  // KeyA
    u8"\u0633",  // KeyS
    u8"\u06cc",  // KeyD
    u8"\u0628",  // KeyF
    u8"\u0644",  // KeyG
    u8"\u0627",  // KeyH
    u8"\u062a",  // KeyJ
    u8"\u0646",  // KeyK
    u8"\u0645",  // KeyL
    u8"\u06a9",  // Semicolon
    u8"\u06af",  // Quote
    u8"\u0638",  // KeyZ
    u8"\u0637",  // KeyX
    u8"\u0632",  // KeyC
    u8"\u0631",  // KeyV
    u8"\u0630",  // KeyB
    u8"\u062f",  // KeyN
    u8"\u067e",  // KeyM
    u8"\u0648",  // Comma
    u8".",       // Period
    u8"/",       // Slash
    u8"\u0020",  // Space
};
const char* kShiftCapslock[] = {
    u8"",                          // BackQuote
    u8"!",                         // Digit1
    u8"\u066c",                    // Digit2
    u8"\u066b",                    // Digit3
    u8"\u0631\u06cc\u0627\u0644",  // Digit4
    u8"\u066a",                    // Digit5
    u8"\u00d7",                    // Digit6
    u8"\u060c",                    // Digit7
    u8"*",                         // Digit8
    u8")",                         // Digit9
    u8"(",                         // Digit0
    u8"\u0640",                    // Minus
    u8"+",                         // Equal
    u8"\u0652",                    // KeyQ
    u8"\u064c",                    // KeyW
    u8"\u064d",                    // KeyE
    u8"\u064b",                    // KeyR
    u8"\u064f",                    // KeyT
    u8"\u0650",                    // KeyY
    u8"\u064e",                    // KeyU
    u8"\u0651",                    // KeyI
    u8"]",                         // KeyO
    u8"[",                         // KeyP
    u8"}",                         // BracketLeft
    u8"{",                         // BracketRight
    u8"|",                         // Backslash
    u8"\u0624",                    // KeyA
    u8"\u0626",                    // KeyS
    u8"\u064a",                    // KeyD
    u8"\u0625",                    // KeyF
    u8"\u0623",                    // KeyG
    u8"\u0622",                    // KeyH
    u8"\u0629",                    // KeyJ
    u8"\u00bb",                    // KeyK
    u8"\u00ab",                    // KeyL
    u8":",                         // Semicolon
    u8"\u061b",                    // Quote
    u8"\u0643",                    // KeyZ
    u8"",                          // KeyX
    u8"\u0698",                    // KeyC
    u8"",                          // KeyV
    u8"\u200c",                    // KeyB
    u8"",                          // KeyN
    u8"\u0621",                    // KeyM
    u8"<",                         // Comma
    u8">",                         // Period
    u8"\u061f",                    // Slash
    u8"\u200c",                    // Space
};
const char** kKeyMap[8] = {kNormal,   kShift,         kAltGr, kAltGr,
                           kCapslock, kShiftCapslock, kAltGr, kShiftCapslock};

}  // namespace fa
