/*
 *   This file is part of Clinica.
 *
 *   Clinica is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   Clinica is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Clinica.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Authors: Leonardo Robol <leo@robol.it>
 *            Gianmarco Brocchi <brocchi@poisson.phc.unipi.it>
 */

using Gtk;

namespace Clinica {
    
    public class DoctorListStore : ListStore {
    
    	enum Field {
    		DOCTOR,
    		GIVEN_NAME,
    		SURNAME,
    		COMPLETE_NAME,
    	}
    
        public signal void error (string message);
        
		private ResourceManager resource_manager { get; set; }
       
        public class DoctorListStore (ResourceManager resources) {
            resource_manager = resources;
            error.connect ((t,l) => resources.error_callback (t,l));
            
            /* Column headers doctor object, name, surname, complete name */
            Type [] column_headers = { typeof (Doctor) , typeof (string), 
                                       typeof (string), typeof (string)};
                                       
            set_column_types (column_headers);
            
            /* Asynchronous loading of doctors... */
            Idle.add (() => {
	            foreach (Doctor doc in Doctor.all (resource_manager)) {
    	        	add_doctor (doc);
    	        }
    	        
    	        /* We don't need to execute any more */
    	        return false;
    	    });
        }
        
        public void add_doctor (Doctor doc) {
        	TreeIter it;
            append(out it);
            set_value (it, Field.DOCTOR, doc);
            set_value (it, Field.GIVEN_NAME, doc.given_name);
            set_value (it, Field.SURNAME, doc.surname);
            set_value (it, Field.COMPLETE_NAME, doc.get_complete_name ());
        }
        
        public void reload_doctor (Doctor doc) {
        	TreeIter it;
        	Value doctor;
        	int this_id = doc.get_id ();
        	if (!get_iter_first (out it)) {
        		error (_("Doctors database seems corrupted."));
        	}
        	do {
        		get_value (it, Field.DOCTOR, out doctor);
        		if ((doctor as Doctor).get_id () == this_id) {			
		            set_value (it, Field.DOCTOR, doc);
		            set_value (it, Field.GIVEN_NAME, doc.given_name);
		            set_value (it, Field.SURNAME, doc.surname);
		            set_value (it, Field.COMPLETE_NAME, doc.get_complete_name ());
		            return;
        		}
        	} while (iter_next (ref it));
        	
        	assert_not_reached ();
        }
    }
}
