/* Clutter
 *
 * Copyright (C) 2006, 2007, 2008  OpenedHand Ltd
 * Copyright (C) 2009, 2010  Intel Corp
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses>.
 */

/*
 * Compatibility version of clutter-keysyms.h.
 *
 * Since Clutter 1.4, the key symbol defines have been changed to have
 * a KEY_ prefix. This is a compatibility header that is included when
 * deprecated symbols are enabled. Consider porting to the new names
 * instead.
 */

#ifndef __CLUTTER_KEYSYMS_DEPRECATED_H__
#define __CLUTTER_KEYSYMS_DEPRECATED_H__

#ifndef CLUTTER_DISABLE_DEPRECATED

#define CLUTTER_VoidSymbol 0xffffff
#define CLUTTER_BackSpace 0xff08
#define CLUTTER_Tab 0xff09
#define CLUTTER_Linefeed 0xff0a
#define CLUTTER_Clear 0xff0b
#define CLUTTER_Return 0xff0d
#define CLUTTER_Pause 0xff13
#define CLUTTER_Scroll_Lock 0xff14
#define CLUTTER_Sys_Req 0xff15
#define CLUTTER_Escape 0xff1b
#define CLUTTER_Delete 0xffff
#define CLUTTER_Multi_key 0xff20
#define CLUTTER_Codeinput 0xff37
#define CLUTTER_SingleCandidate 0xff3c
#define CLUTTER_MultipleCandidate 0xff3d
#define CLUTTER_PreviousCandidate 0xff3e
#define CLUTTER_Kanji 0xff21
#define CLUTTER_Muhenkan 0xff22
#define CLUTTER_Henkan_Mode 0xff23
#define CLUTTER_Henkan 0xff23
#define CLUTTER_Romaji 0xff24
#define CLUTTER_Hiragana 0xff25
#define CLUTTER_Katakana 0xff26
#define CLUTTER_Hiragana_Katakana 0xff27
#define CLUTTER_Zenkaku 0xff28
#define CLUTTER_Hankaku 0xff29
#define CLUTTER_Zenkaku_Hankaku 0xff2a
#define CLUTTER_Touroku 0xff2b
#define CLUTTER_Massyo 0xff2c
#define CLUTTER_Kana_Lock 0xff2d
#define CLUTTER_Kana_Shift 0xff2e
#define CLUTTER_Eisu_Shift 0xff2f
#define CLUTTER_Eisu_toggle 0xff30
#define CLUTTER_Kanji_Bangou 0xff37
#define CLUTTER_Zen_Koho 0xff3d
#define CLUTTER_Mae_Koho 0xff3e
#define CLUTTER_Home 0xff50
#define CLUTTER_Left 0xff51
#define CLUTTER_Up 0xff52
#define CLUTTER_Right 0xff53
#define CLUTTER_Down 0xff54
#define CLUTTER_Prior 0xff55
#define CLUTTER_Page_Up 0xff55
#define CLUTTER_Next 0xff56
#define CLUTTER_Page_Down 0xff56
#define CLUTTER_End 0xff57
#define CLUTTER_Begin 0xff58
#define CLUTTER_Select 0xff60
#define CLUTTER_Print 0xff61
#define CLUTTER_Execute 0xff62
#define CLUTTER_Insert 0xff63
#define CLUTTER_Undo 0xff65
#define CLUTTER_Redo 0xff66
#define CLUTTER_Menu 0xff67
#define CLUTTER_Find 0xff68
#define CLUTTER_Cancel 0xff69
#define CLUTTER_Help 0xff6a
#define CLUTTER_Break 0xff6b
#define CLUTTER_Mode_switch 0xff7e
#define CLUTTER_script_switch 0xff7e
#define CLUTTER_Num_Lock 0xff7f
#define CLUTTER_KP_Space 0xff80
#define CLUTTER_KP_Tab 0xff89
#define CLUTTER_KP_Enter 0xff8d
#define CLUTTER_KP_F1 0xff91
#define CLUTTER_KP_F2 0xff92
#define CLUTTER_KP_F3 0xff93
#define CLUTTER_KP_F4 0xff94
#define CLUTTER_KP_Home 0xff95
#define CLUTTER_KP_Left 0xff96
#define CLUTTER_KP_Up 0xff97
#define CLUTTER_KP_Right 0xff98
#define CLUTTER_KP_Down 0xff99
#define CLUTTER_KP_Prior 0xff9a
#define CLUTTER_KP_Page_Up 0xff9a
#define CLUTTER_KP_Next 0xff9b
#define CLUTTER_KP_Page_Down 0xff9b
#define CLUTTER_KP_End 0xff9c
#define CLUTTER_KP_Begin 0xff9d
#define CLUTTER_KP_Insert 0xff9e
#define CLUTTER_KP_Delete 0xff9f
#define CLUTTER_KP_Equal 0xffbd
#define CLUTTER_KP_Multiply 0xffaa
#define CLUTTER_KP_Add 0xffab
#define CLUTTER_KP_Separator 0xffac
#define CLUTTER_KP_Subtract 0xffad
#define CLUTTER_KP_Decimal 0xffae
#define CLUTTER_KP_Divide 0xffaf
#define CLUTTER_KP_0 0xffb0
#define CLUTTER_KP_1 0xffb1
#define CLUTTER_KP_2 0xffb2
#define CLUTTER_KP_3 0xffb3
#define CLUTTER_KP_4 0xffb4
#define CLUTTER_KP_5 0xffb5
#define CLUTTER_KP_6 0xffb6
#define CLUTTER_KP_7 0xffb7
#define CLUTTER_KP_8 0xffb8
#define CLUTTER_KP_9 0xffb9
#define CLUTTER_F1 0xffbe
#define CLUTTER_F2 0xffbf
#define CLUTTER_F3 0xffc0
#define CLUTTER_F4 0xffc1
#define CLUTTER_F5 0xffc2
#define CLUTTER_F6 0xffc3
#define CLUTTER_F7 0xffc4
#define CLUTTER_F8 0xffc5
#define CLUTTER_F9 0xffc6
#define CLUTTER_F10 0xffc7
#define CLUTTER_F11 0xffc8
#define CLUTTER_L1 0xffc8
#define CLUTTER_F12 0xffc9
#define CLUTTER_L2 0xffc9
#define CLUTTER_F13 0xffca
#define CLUTTER_L3 0xffca
#define CLUTTER_F14 0xffcb
#define CLUTTER_L4 0xffcb
#define CLUTTER_F15 0xffcc
#define CLUTTER_L5 0xffcc
#define CLUTTER_F16 0xffcd
#define CLUTTER_L6 0xffcd
#define CLUTTER_F17 0xffce
#define CLUTTER_L7 0xffce
#define CLUTTER_F18 0xffcf
#define CLUTTER_L8 0xffcf
#define CLUTTER_F19 0xffd0
#define CLUTTER_L9 0xffd0
#define CLUTTER_F20 0xffd1
#define CLUTTER_L10 0xffd1
#define CLUTTER_F21 0xffd2
#define CLUTTER_R1 0xffd2
#define CLUTTER_F22 0xffd3
#define CLUTTER_R2 0xffd3
#define CLUTTER_F23 0xffd4
#define CLUTTER_R3 0xffd4
#define CLUTTER_F24 0xffd5
#define CLUTTER_R4 0xffd5
#define CLUTTER_F25 0xffd6
#define CLUTTER_R5 0xffd6
#define CLUTTER_F26 0xffd7
#define CLUTTER_R6 0xffd7
#define CLUTTER_F27 0xffd8
#define CLUTTER_R7 0xffd8
#define CLUTTER_F28 0xffd9
#define CLUTTER_R8 0xffd9
#define CLUTTER_F29 0xffda
#define CLUTTER_R9 0xffda
#define CLUTTER_F30 0xffdb
#define CLUTTER_R10 0xffdb
#define CLUTTER_F31 0xffdc
#define CLUTTER_R11 0xffdc
#define CLUTTER_F32 0xffdd
#define CLUTTER_R12 0xffdd
#define CLUTTER_F33 0xffde
#define CLUTTER_R13 0xffde
#define CLUTTER_F34 0xffdf
#define CLUTTER_R14 0xffdf
#define CLUTTER_F35 0xffe0
#define CLUTTER_R15 0xffe0
#define CLUTTER_Shift_L 0xffe1
#define CLUTTER_Shift_R 0xffe2
#define CLUTTER_Control_L 0xffe3
#define CLUTTER_Control_R 0xffe4
#define CLUTTER_Caps_Lock 0xffe5
#define CLUTTER_Shift_Lock 0xffe6
#define CLUTTER_Meta_L 0xffe7
#define CLUTTER_Meta_R 0xffe8
#define CLUTTER_Alt_L 0xffe9
#define CLUTTER_Alt_R 0xffea
#define CLUTTER_Super_L 0xffeb
#define CLUTTER_Super_R 0xffec
#define CLUTTER_Hyper_L 0xffed
#define CLUTTER_Hyper_R 0xffee
#define CLUTTER_ISO_Lock 0xfe01
#define CLUTTER_ISO_Level2_Latch 0xfe02
#define CLUTTER_ISO_Level3_Shift 0xfe03
#define CLUTTER_ISO_Level3_Latch 0xfe04
#define CLUTTER_ISO_Level3_Lock 0xfe05
#define CLUTTER_ISO_Level5_Shift 0xfe11
#define CLUTTER_ISO_Level5_Latch 0xfe12
#define CLUTTER_ISO_Level5_Lock 0xfe13
#define CLUTTER_ISO_Group_Shift 0xff7e
#define CLUTTER_ISO_Group_Latch 0xfe06
#define CLUTTER_ISO_Group_Lock 0xfe07
#define CLUTTER_ISO_Next_Group 0xfe08
#define CLUTTER_ISO_Next_Group_Lock 0xfe09
#define CLUTTER_ISO_Prev_Group 0xfe0a
#define CLUTTER_ISO_Prev_Group_Lock 0xfe0b
#define CLUTTER_ISO_First_Group 0xfe0c
#define CLUTTER_ISO_First_Group_Lock 0xfe0d
#define CLUTTER_ISO_Last_Group 0xfe0e
#define CLUTTER_ISO_Last_Group_Lock 0xfe0f
#define CLUTTER_ISO_Left_Tab 0xfe20
#define CLUTTER_ISO_Move_Line_Up 0xfe21
#define CLUTTER_ISO_Move_Line_Down 0xfe22
#define CLUTTER_ISO_Partial_Line_Up 0xfe23
#define CLUTTER_ISO_Partial_Line_Down 0xfe24
#define CLUTTER_ISO_Partial_Space_Left 0xfe25
#define CLUTTER_ISO_Partial_Space_Right 0xfe26
#define CLUTTER_ISO_Set_Margin_Left 0xfe27
#define CLUTTER_ISO_Set_Margin_Right 0xfe28
#define CLUTTER_ISO_Release_Margin_Left 0xfe29
#define CLUTTER_ISO_Release_Margin_Right 0xfe2a
#define CLUTTER_ISO_Release_Both_Margins 0xfe2b
#define CLUTTER_ISO_Fast_Cursor_Left 0xfe2c
#define CLUTTER_ISO_Fast_Cursor_Right 0xfe2d
#define CLUTTER_ISO_Fast_Cursor_Up 0xfe2e
#define CLUTTER_ISO_Fast_Cursor_Down 0xfe2f
#define CLUTTER_ISO_Continuous_Underline 0xfe30
#define CLUTTER_ISO_Discontinuous_Underline 0xfe31
#define CLUTTER_ISO_Emphasize 0xfe32
#define CLUTTER_ISO_Center_Object 0xfe33
#define CLUTTER_ISO_Enter 0xfe34
#define CLUTTER_dead_grave 0xfe50
#define CLUTTER_dead_acute 0xfe51
#define CLUTTER_dead_circumflex 0xfe52
#define CLUTTER_dead_tilde 0xfe53
#define CLUTTER_dead_perispomeni 0xfe53
#define CLUTTER_dead_macron 0xfe54
#define CLUTTER_dead_breve 0xfe55
#define CLUTTER_dead_abovedot 0xfe56
#define CLUTTER_dead_diaeresis 0xfe57
#define CLUTTER_dead_abovering 0xfe58
#define CLUTTER_dead_doubleacute 0xfe59
#define CLUTTER_dead_caron 0xfe5a
#define CLUTTER_dead_cedilla 0xfe5b
#define CLUTTER_dead_ogonek 0xfe5c
#define CLUTTER_dead_iota 0xfe5d
#define CLUTTER_dead_voiced_sound 0xfe5e
#define CLUTTER_dead_semivoiced_sound 0xfe5f
#define CLUTTER_dead_belowdot 0xfe60
#define CLUTTER_dead_hook 0xfe61
#define CLUTTER_dead_horn 0xfe62
#define CLUTTER_dead_stroke 0xfe63
#define CLUTTER_dead_abovecomma 0xfe64
#define CLUTTER_dead_psili 0xfe64
#define CLUTTER_dead_abovereversedcomma 0xfe65
#define CLUTTER_dead_dasia 0xfe65
#define CLUTTER_dead_doublegrave 0xfe66
#define CLUTTER_dead_belowring 0xfe67
#define CLUTTER_dead_belowmacron 0xfe68
#define CLUTTER_dead_belowcircumflex 0xfe69
#define CLUTTER_dead_belowtilde 0xfe6a
#define CLUTTER_dead_belowbreve 0xfe6b
#define CLUTTER_dead_belowdiaeresis 0xfe6c
#define CLUTTER_dead_invertedbreve 0xfe6d
#define CLUTTER_dead_belowcomma 0xfe6e
#define CLUTTER_dead_currency 0xfe6f
#define CLUTTER_dead_a 0xfe80
#define CLUTTER_dead_A 0xfe81
#define CLUTTER_dead_e 0xfe82
#define CLUTTER_dead_E 0xfe83
#define CLUTTER_dead_i 0xfe84
#define CLUTTER_dead_I 0xfe85
#define CLUTTER_dead_o 0xfe86
#define CLUTTER_dead_O 0xfe87
#define CLUTTER_dead_u 0xfe88
#define CLUTTER_dead_U 0xfe89
#define CLUTTER_dead_small_schwa 0xfe8a
#define CLUTTER_dead_capital_schwa 0xfe8b
#define CLUTTER_First_Virtual_Screen 0xfed0
#define CLUTTER_Prev_Virtual_Screen 0xfed1
#define CLUTTER_Next_Virtual_Screen 0xfed2
#define CLUTTER_Last_Virtual_Screen 0xfed4
#define CLUTTER_Terminate_Server 0xfed5
#define CLUTTER_AccessX_Enable 0xfe70
#define CLUTTER_AccessX_Feedback_Enable 0xfe71
#define CLUTTER_RepeatKeys_Enable 0xfe72
#define CLUTTER_SlowKeys_Enable 0xfe73
#define CLUTTER_BounceKeys_Enable 0xfe74
#define CLUTTER_StickyKeys_Enable 0xfe75
#define CLUTTER_MouseKeys_Enable 0xfe76
#define CLUTTER_MouseKeys_Accel_Enable 0xfe77
#define CLUTTER_Overlay1_Enable 0xfe78
#define CLUTTER_Overlay2_Enable 0xfe79
#define CLUTTER_AudibleBell_Enable 0xfe7a
#define CLUTTER_Pointer_Left 0xfee0
#define CLUTTER_Pointer_Right 0xfee1
#define CLUTTER_Pointer_Up 0xfee2
#define CLUTTER_Pointer_Down 0xfee3
#define CLUTTER_Pointer_UpLeft 0xfee4
#define CLUTTER_Pointer_UpRight 0xfee5
#define CLUTTER_Pointer_DownLeft 0xfee6
#define CLUTTER_Pointer_DownRight 0xfee7
#define CLUTTER_Pointer_Button_Dflt 0xfee8
#define CLUTTER_Pointer_Button1 0xfee9
#define CLUTTER_Pointer_Button2 0xfeea
#define CLUTTER_Pointer_Button3 0xfeeb
#define CLUTTER_Pointer_Button4 0xfeec
#define CLUTTER_Pointer_Button5 0xfeed
#define CLUTTER_Pointer_DblClick_Dflt 0xfeee
#define CLUTTER_Pointer_DblClick1 0xfeef
#define CLUTTER_Pointer_DblClick2 0xfef0
#define CLUTTER_Pointer_DblClick3 0xfef1
#define CLUTTER_Pointer_DblClick4 0xfef2
#define CLUTTER_Pointer_DblClick5 0xfef3
#define CLUTTER_Pointer_Drag_Dflt 0xfef4
#define CLUTTER_Pointer_Drag1 0xfef5
#define CLUTTER_Pointer_Drag2 0xfef6
#define CLUTTER_Pointer_Drag3 0xfef7
#define CLUTTER_Pointer_Drag4 0xfef8
#define CLUTTER_Pointer_Drag5 0xfefd
#define CLUTTER_Pointer_EnableKeys 0xfef9
#define CLUTTER_Pointer_Accelerate 0xfefa
#define CLUTTER_Pointer_DfltBtnNext 0xfefb
#define CLUTTER_Pointer_DfltBtnPrev 0xfefc
#define CLUTTER_ch 0xfea0
#define CLUTTER_Ch 0xfea1
#define CLUTTER_CH 0xfea2
#define CLUTTER_c_h 0xfea3
#define CLUTTER_C_h 0xfea4
#define CLUTTER_C_H 0xfea5
#define CLUTTER_3270_Duplicate 0xfd01
#define CLUTTER_3270_FieldMark 0xfd02
#define CLUTTER_3270_Right2 0xfd03
#define CLUTTER_3270_Left2 0xfd04
#define CLUTTER_3270_BackTab 0xfd05
#define CLUTTER_3270_EraseEOF 0xfd06
#define CLUTTER_3270_EraseInput 0xfd07
#define CLUTTER_3270_Reset 0xfd08
#define CLUTTER_3270_Quit 0xfd09
#define CLUTTER_3270_PA1 0xfd0a
#define CLUTTER_3270_PA2 0xfd0b
#define CLUTTER_3270_PA3 0xfd0c
#define CLUTTER_3270_Test 0xfd0d
#define CLUTTER_3270_Attn 0xfd0e
#define CLUTTER_3270_CursorBlink 0xfd0f
#define CLUTTER_3270_AltCursor 0xfd10
#define CLUTTER_3270_KeyClick 0xfd11
#define CLUTTER_3270_Jump 0xfd12
#define CLUTTER_3270_Ident 0xfd13
#define CLUTTER_3270_Rule 0xfd14
#define CLUTTER_3270_Copy 0xfd15
#define CLUTTER_3270_Play 0xfd16
#define CLUTTER_3270_Setup 0xfd17
#define CLUTTER_3270_Record 0xfd18
#define CLUTTER_3270_ChangeScreen 0xfd19
#define CLUTTER_3270_DeleteWord 0xfd1a
#define CLUTTER_3270_ExSelect 0xfd1b
#define CLUTTER_3270_CursorSelect 0xfd1c
#define CLUTTER_3270_PrintScreen 0xfd1d
#define CLUTTER_3270_Enter 0xfd1e
#define CLUTTER_space 0x020
#define CLUTTER_exclam 0x021
#define CLUTTER_quotedbl 0x022
#define CLUTTER_numbersign 0x023
#define CLUTTER_dollar 0x024
#define CLUTTER_percent 0x025
#define CLUTTER_ampersand 0x026
#define CLUTTER_apostrophe 0x027
#define CLUTTER_quoteright 0x027
#define CLUTTER_parenleft 0x028
#define CLUTTER_parenright 0x029
#define CLUTTER_asterisk 0x02a
#define CLUTTER_plus 0x02b
#define CLUTTER_comma 0x02c
#define CLUTTER_minus 0x02d
#define CLUTTER_period 0x02e
#define CLUTTER_slash 0x02f
#define CLUTTER_0 0x030
#define CLUTTER_1 0x031
#define CLUTTER_2 0x032
#define CLUTTER_3 0x033
#define CLUTTER_4 0x034
#define CLUTTER_5 0x035
#define CLUTTER_6 0x036
#define CLUTTER_7 0x037
#define CLUTTER_8 0x038
#define CLUTTER_9 0x039
#define CLUTTER_colon 0x03a
#define CLUTTER_semicolon 0x03b
#define CLUTTER_less 0x03c
#define CLUTTER_equal 0x03d
#define CLUTTER_greater 0x03e
#define CLUTTER_question 0x03f
#define CLUTTER_at 0x040
#define CLUTTER_A 0x041
#define CLUTTER_B 0x042
#define CLUTTER_C 0x043
#define CLUTTER_D 0x044
#define CLUTTER_E 0x045
#define CLUTTER_F 0x046
#define CLUTTER_G 0x047
#define CLUTTER_H 0x048
#define CLUTTER_I 0x049
#define CLUTTER_J 0x04a
#define CLUTTER_K 0x04b
#define CLUTTER_L 0x04c
#define CLUTTER_M 0x04d
#define CLUTTER_N 0x04e
#define CLUTTER_O 0x04f
#define CLUTTER_P 0x050
#define CLUTTER_Q 0x051
#define CLUTTER_R 0x052
#define CLUTTER_S 0x053
#define CLUTTER_T 0x054
#define CLUTTER_U 0x055
#define CLUTTER_V 0x056
#define CLUTTER_W 0x057
#define CLUTTER_X 0x058
#define CLUTTER_Y 0x059
#define CLUTTER_Z 0x05a
#define CLUTTER_bracketleft 0x05b
#define CLUTTER_backslash 0x05c
#define CLUTTER_bracketright 0x05d
#define CLUTTER_asciicircum 0x05e
#define CLUTTER_underscore 0x05f
#define CLUTTER_grave 0x060
#define CLUTTER_quoteleft 0x060
#define CLUTTER_a 0x061
#define CLUTTER_b 0x062
#define CLUTTER_c 0x063
#define CLUTTER_d 0x064
#define CLUTTER_e 0x065
#define CLUTTER_f 0x066
#define CLUTTER_g 0x067
#define CLUTTER_h 0x068
#define CLUTTER_i 0x069
#define CLUTTER_j 0x06a
#define CLUTTER_k 0x06b
#define CLUTTER_l 0x06c
#define CLUTTER_m 0x06d
#define CLUTTER_n 0x06e
#define CLUTTER_o 0x06f
#define CLUTTER_p 0x070
#define CLUTTER_q 0x071
#define CLUTTER_r 0x072
#define CLUTTER_s 0x073
#define CLUTTER_t 0x074
#define CLUTTER_u 0x075
#define CLUTTER_v 0x076
#define CLUTTER_w 0x077
#define CLUTTER_x 0x078
#define CLUTTER_y 0x079
#define CLUTTER_z 0x07a
#define CLUTTER_braceleft 0x07b
#define CLUTTER_bar 0x07c
#define CLUTTER_braceright 0x07d
#define CLUTTER_asciitilde 0x07e
#define CLUTTER_nobreakspace 0x0a0
#define CLUTTER_exclamdown 0x0a1
#define CLUTTER_cent 0x0a2
#define CLUTTER_sterling 0x0a3
#define CLUTTER_currency 0x0a4
#define CLUTTER_yen 0x0a5
#define CLUTTER_brokenbar 0x0a6
#define CLUTTER_section 0x0a7
#define CLUTTER_diaeresis 0x0a8
#define CLUTTER_copyright 0x0a9
#define CLUTTER_ordfeminine 0x0aa
#define CLUTTER_guillemotleft 0x0ab
#define CLUTTER_notsign 0x0ac
#define CLUTTER_hyphen 0x0ad
#define CLUTTER_registered 0x0ae
#define CLUTTER_macron 0x0af
#define CLUTTER_degree 0x0b0
#define CLUTTER_plusminus 0x0b1
#define CLUTTER_twosuperior 0x0b2
#define CLUTTER_threesuperior 0x0b3
#define CLUTTER_acute 0x0b4
#define CLUTTER_mu 0x0b5
#define CLUTTER_paragraph 0x0b6
#define CLUTTER_periodcentered 0x0b7
#define CLUTTER_cedilla 0x0b8
#define CLUTTER_onesuperior 0x0b9
#define CLUTTER_masculine 0x0ba
#define CLUTTER_guillemotright 0x0bb
#define CLUTTER_onequarter 0x0bc
#define CLUTTER_onehalf 0x0bd
#define CLUTTER_threequarters 0x0be
#define CLUTTER_questiondown 0x0bf
#define CLUTTER_Agrave 0x0c0
#define CLUTTER_Aacute 0x0c1
#define CLUTTER_Acircumflex 0x0c2
#define CLUTTER_Atilde 0x0c3
#define CLUTTER_Adiaeresis 0x0c4
#define CLUTTER_Aring 0x0c5
#define CLUTTER_AE 0x0c6
#define CLUTTER_Ccedilla 0x0c7
#define CLUTTER_Egrave 0x0c8
#define CLUTTER_Eacute 0x0c9
#define CLUTTER_Ecircumflex 0x0ca
#define CLUTTER_Ediaeresis 0x0cb
#define CLUTTER_Igrave 0x0cc
#define CLUTTER_Iacute 0x0cd
#define CLUTTER_Icircumflex 0x0ce
#define CLUTTER_Idiaeresis 0x0cf
#define CLUTTER_ETH 0x0d0
#define CLUTTER_Eth 0x0d0
#define CLUTTER_Ntilde 0x0d1
#define CLUTTER_Ograve 0x0d2
#define CLUTTER_Oacute 0x0d3
#define CLUTTER_Ocircumflex 0x0d4
#define CLUTTER_Otilde 0x0d5
#define CLUTTER_Odiaeresis 0x0d6
#define CLUTTER_multiply 0x0d7
#define CLUTTER_Oslash 0x0d8
#define CLUTTER_Ooblique 0x0d8
#define CLUTTER_Ugrave 0x0d9
#define CLUTTER_Uacute 0x0da
#define CLUTTER_Ucircumflex 0x0db
#define CLUTTER_Udiaeresis 0x0dc
#define CLUTTER_Yacute 0x0dd
#define CLUTTER_THORN 0x0de
#define CLUTTER_Thorn 0x0de
#define CLUTTER_ssharp 0x0df
#define CLUTTER_agrave 0x0e0
#define CLUTTER_aacute 0x0e1
#define CLUTTER_acircumflex 0x0e2
#define CLUTTER_atilde 0x0e3
#define CLUTTER_adiaeresis 0x0e4
#define CLUTTER_aring 0x0e5
#define CLUTTER_ae 0x0e6
#define CLUTTER_ccedilla 0x0e7
#define CLUTTER_egrave 0x0e8
#define CLUTTER_eacute 0x0e9
#define CLUTTER_ecircumflex 0x0ea
#define CLUTTER_ediaeresis 0x0eb
#define CLUTTER_igrave 0x0ec
#define CLUTTER_iacute 0x0ed
#define CLUTTER_icircumflex 0x0ee
#define CLUTTER_idiaeresis 0x0ef
#define CLUTTER_eth 0x0f0
#define CLUTTER_ntilde 0x0f1
#define CLUTTER_ograve 0x0f2
#define CLUTTER_oacute 0x0f3
#define CLUTTER_ocircumflex 0x0f4
#define CLUTTER_otilde 0x0f5
#define CLUTTER_odiaeresis 0x0f6
#define CLUTTER_division 0x0f7
#define CLUTTER_oslash 0x0f8
#define CLUTTER_ooblique 0x0f8
#define CLUTTER_ugrave 0x0f9
#define CLUTTER_uacute 0x0fa
#define CLUTTER_ucircumflex 0x0fb
#define CLUTTER_udiaeresis 0x0fc
#define CLUTTER_yacute 0x0fd
#define CLUTTER_thorn 0x0fe
#define CLUTTER_ydiaeresis 0x0ff
#define CLUTTER_Aogonek 0x1a1
#define CLUTTER_breve 0x1a2
#define CLUTTER_Lstroke 0x1a3
#define CLUTTER_Lcaron 0x1a5
#define CLUTTER_Sacute 0x1a6
#define CLUTTER_Scaron 0x1a9
#define CLUTTER_Scedilla 0x1aa
#define CLUTTER_Tcaron 0x1ab
#define CLUTTER_Zacute 0x1ac
#define CLUTTER_Zcaron 0x1ae
#define CLUTTER_Zabovedot 0x1af
#define CLUTTER_aogonek 0x1b1
#define CLUTTER_ogonek 0x1b2
#define CLUTTER_lstroke 0x1b3
#define CLUTTER_lcaron 0x1b5
#define CLUTTER_sacute 0x1b6
#define CLUTTER_caron 0x1b7
#define CLUTTER_scaron 0x1b9
#define CLUTTER_scedilla 0x1ba
#define CLUTTER_tcaron 0x1bb
#define CLUTTER_zacute 0x1bc
#define CLUTTER_doubleacute 0x1bd
#define CLUTTER_zcaron 0x1be
#define CLUTTER_zabovedot 0x1bf
#define CLUTTER_Racute 0x1c0
#define CLUTTER_Abreve 0x1c3
#define CLUTTER_Lacute 0x1c5
#define CLUTTER_Cacute 0x1c6
#define CLUTTER_Ccaron 0x1c8
#define CLUTTER_Eogonek 0x1ca
#define CLUTTER_Ecaron 0x1cc
#define CLUTTER_Dcaron 0x1cf
#define CLUTTER_Dstroke 0x1d0
#define CLUTTER_Nacute 0x1d1
#define CLUTTER_Ncaron 0x1d2
#define CLUTTER_Odoubleacute 0x1d5
#define CLUTTER_Rcaron 0x1d8
#define CLUTTER_Uring 0x1d9
#define CLUTTER_Udoubleacute 0x1db
#define CLUTTER_Tcedilla 0x1de
#define CLUTTER_racute 0x1e0
#define CLUTTER_abreve 0x1e3
#define CLUTTER_lacute 0x1e5
#define CLUTTER_cacute 0x1e6
#define CLUTTER_ccaron 0x1e8
#define CLUTTER_eogonek 0x1ea
#define CLUTTER_ecaron 0x1ec
#define CLUTTER_dcaron 0x1ef
#define CLUTTER_dstroke 0x1f0
#define CLUTTER_nacute 0x1f1
#define CLUTTER_ncaron 0x1f2
#define CLUTTER_odoubleacute 0x1f5
#define CLUTTER_rcaron 0x1f8
#define CLUTTER_uring 0x1f9
#define CLUTTER_udoubleacute 0x1fb
#define CLUTTER_tcedilla 0x1fe
#define CLUTTER_abovedot 0x1ff
#define CLUTTER_Hstroke 0x2a1
#define CLUTTER_Hcircumflex 0x2a6
#define CLUTTER_Iabovedot 0x2a9
#define CLUTTER_Gbreve 0x2ab
#define CLUTTER_Jcircumflex 0x2ac
#define CLUTTER_hstroke 0x2b1
#define CLUTTER_hcircumflex 0x2b6
#define CLUTTER_idotless 0x2b9
#define CLUTTER_gbreve 0x2bb
#define CLUTTER_jcircumflex 0x2bc
#define CLUTTER_Cabovedot 0x2c5
#define CLUTTER_Ccircumflex 0x2c6
#define CLUTTER_Gabovedot 0x2d5
#define CLUTTER_Gcircumflex 0x2d8
#define CLUTTER_Ubreve 0x2dd
#define CLUTTER_Scircumflex 0x2de
#define CLUTTER_cabovedot 0x2e5
#define CLUTTER_ccircumflex 0x2e6
#define CLUTTER_gabovedot 0x2f5
#define CLUTTER_gcircumflex 0x2f8
#define CLUTTER_ubreve 0x2fd
#define CLUTTER_scircumflex 0x2fe
#define CLUTTER_kra 0x3a2
#define CLUTTER_kappa 0x3a2
#define CLUTTER_Rcedilla 0x3a3
#define CLUTTER_Itilde 0x3a5
#define CLUTTER_Lcedilla 0x3a6
#define CLUTTER_Emacron 0x3aa
#define CLUTTER_Gcedilla 0x3ab
#define CLUTTER_Tslash 0x3ac
#define CLUTTER_rcedilla 0x3b3
#define CLUTTER_itilde 0x3b5
#define CLUTTER_lcedilla 0x3b6
#define CLUTTER_emacron 0x3ba
#define CLUTTER_gcedilla 0x3bb
#define CLUTTER_tslash 0x3bc
#define CLUTTER_ENG 0x3bd
#define CLUTTER_eng 0x3bf
#define CLUTTER_Amacron 0x3c0
#define CLUTTER_Iogonek 0x3c7
#define CLUTTER_Eabovedot 0x3cc
#define CLUTTER_Imacron 0x3cf
#define CLUTTER_Ncedilla 0x3d1
#define CLUTTER_Omacron 0x3d2
#define CLUTTER_Kcedilla 0x3d3
#define CLUTTER_Uogonek 0x3d9
#define CLUTTER_Utilde 0x3dd
#define CLUTTER_Umacron 0x3de
#define CLUTTER_amacron 0x3e0
#define CLUTTER_iogonek 0x3e7
#define CLUTTER_eabovedot 0x3ec
#define CLUTTER_imacron 0x3ef
#define CLUTTER_ncedilla 0x3f1
#define CLUTTER_omacron 0x3f2
#define CLUTTER_kcedilla 0x3f3
#define CLUTTER_uogonek 0x3f9
#define CLUTTER_utilde 0x3fd
#define CLUTTER_umacron 0x3fe
#define CLUTTER_Wcircumflex 0x1000174
#define CLUTTER_wcircumflex 0x1000175
#define CLUTTER_Ycircumflex 0x1000176
#define CLUTTER_ycircumflex 0x1000177
#define CLUTTER_Babovedot 0x1001e02
#define CLUTTER_babovedot 0x1001e03
#define CLUTTER_Dabovedot 0x1001e0a
#define CLUTTER_dabovedot 0x1001e0b
#define CLUTTER_Fabovedot 0x1001e1e
#define CLUTTER_fabovedot 0x1001e1f
#define CLUTTER_Mabovedot 0x1001e40
#define CLUTTER_mabovedot 0x1001e41
#define CLUTTER_Pabovedot 0x1001e56
#define CLUTTER_pabovedot 0x1001e57
#define CLUTTER_Sabovedot 0x1001e60
#define CLUTTER_sabovedot 0x1001e61
#define CLUTTER_Tabovedot 0x1001e6a
#define CLUTTER_tabovedot 0x1001e6b
#define CLUTTER_Wgrave 0x1001e80
#define CLUTTER_wgrave 0x1001e81
#define CLUTTER_Wacute 0x1001e82
#define CLUTTER_wacute 0x1001e83
#define CLUTTER_Wdiaeresis 0x1001e84
#define CLUTTER_wdiaeresis 0x1001e85
#define CLUTTER_Ygrave 0x1001ef2
#define CLUTTER_ygrave 0x1001ef3
#define CLUTTER_OE 0x13bc
#define CLUTTER_oe 0x13bd
#define CLUTTER_Ydiaeresis 0x13be
#define CLUTTER_overline 0x47e
#define CLUTTER_kana_fullstop 0x4a1
#define CLUTTER_kana_openingbracket 0x4a2
#define CLUTTER_kana_closingbracket 0x4a3
#define CLUTTER_kana_comma 0x4a4
#define CLUTTER_kana_conjunctive 0x4a5
#define CLUTTER_kana_middledot 0x4a5
#define CLUTTER_kana_WO 0x4a6
#define CLUTTER_kana_a 0x4a7
#define CLUTTER_kana_i 0x4a8
#define CLUTTER_kana_u 0x4a9
#define CLUTTER_kana_e 0x4aa
#define CLUTTER_kana_o 0x4ab
#define CLUTTER_kana_ya 0x4ac
#define CLUTTER_kana_yu 0x4ad
#define CLUTTER_kana_yo 0x4ae
#define CLUTTER_kana_tsu 0x4af
#define CLUTTER_kana_tu 0x4af
#define CLUTTER_prolongedsound 0x4b0
#define CLUTTER_kana_A 0x4b1
#define CLUTTER_kana_I 0x4b2
#define CLUTTER_kana_U 0x4b3
#define CLUTTER_kana_E 0x4b4
#define CLUTTER_kana_O 0x4b5
#define CLUTTER_kana_KA 0x4b6
#define CLUTTER_kana_KI 0x4b7
#define CLUTTER_kana_KU 0x4b8
#define CLUTTER_kana_KE 0x4b9
#define CLUTTER_kana_KO 0x4ba
#define CLUTTER_kana_SA 0x4bb
#define CLUTTER_kana_SHI 0x4bc
#define CLUTTER_kana_SU 0x4bd
#define CLUTTER_kana_SE 0x4be
#define CLUTTER_kana_SO 0x4bf
#define CLUTTER_kana_TA 0x4c0
#define CLUTTER_kana_CHI 0x4c1
#define CLUTTER_kana_TI 0x4c1
#define CLUTTER_kana_TSU 0x4c2
#define CLUTTER_kana_TU 0x4c2
#define CLUTTER_kana_TE 0x4c3
#define CLUTTER_kana_TO 0x4c4
#define CLUTTER_kana_NA 0x4c5
#define CLUTTER_kana_NI 0x4c6
#define CLUTTER_kana_NU 0x4c7
#define CLUTTER_kana_NE 0x4c8
#define CLUTTER_kana_NO 0x4c9
#define CLUTTER_kana_HA 0x4ca
#define CLUTTER_kana_HI 0x4cb
#define CLUTTER_kana_FU 0x4cc
#define CLUTTER_kana_HU 0x4cc
#define CLUTTER_kana_HE 0x4cd
#define CLUTTER_kana_HO 0x4ce
#define CLUTTER_kana_MA 0x4cf
#define CLUTTER_kana_MI 0x4d0
#define CLUTTER_kana_MU 0x4d1
#define CLUTTER_kana_ME 0x4d2
#define CLUTTER_kana_MO 0x4d3
#define CLUTTER_kana_YA 0x4d4
#define CLUTTER_kana_YU 0x4d5
#define CLUTTER_kana_YO 0x4d6
#define CLUTTER_kana_RA 0x4d7
#define CLUTTER_kana_RI 0x4d8
#define CLUTTER_kana_RU 0x4d9
#define CLUTTER_kana_RE 0x4da
#define CLUTTER_kana_RO 0x4db
#define CLUTTER_kana_WA 0x4dc
#define CLUTTER_kana_N 0x4dd
#define CLUTTER_voicedsound 0x4de
#define CLUTTER_semivoicedsound 0x4df
#define CLUTTER_kana_switch 0xff7e
#define CLUTTER_Farsi_0 0x10006f0
#define CLUTTER_Farsi_1 0x10006f1
#define CLUTTER_Farsi_2 0x10006f2
#define CLUTTER_Farsi_3 0x10006f3
#define CLUTTER_Farsi_4 0x10006f4
#define CLUTTER_Farsi_5 0x10006f5
#define CLUTTER_Farsi_6 0x10006f6
#define CLUTTER_Farsi_7 0x10006f7
#define CLUTTER_Farsi_8 0x10006f8
#define CLUTTER_Farsi_9 0x10006f9
#define CLUTTER_Arabic_percent 0x100066a
#define CLUTTER_Arabic_superscript_alef 0x1000670
#define CLUTTER_Arabic_tteh 0x1000679
#define CLUTTER_Arabic_peh 0x100067e
#define CLUTTER_Arabic_tcheh 0x1000686
#define CLUTTER_Arabic_ddal 0x1000688
#define CLUTTER_Arabic_rreh 0x1000691
#define CLUTTER_Arabic_comma 0x5ac
#define CLUTTER_Arabic_fullstop 0x10006d4
#define CLUTTER_Arabic_0 0x1000660
#define CLUTTER_Arabic_1 0x1000661
#define CLUTTER_Arabic_2 0x1000662
#define CLUTTER_Arabic_3 0x1000663
#define CLUTTER_Arabic_4 0x1000664
#define CLUTTER_Arabic_5 0x1000665
#define CLUTTER_Arabic_6 0x1000666
#define CLUTTER_Arabic_7 0x1000667
#define CLUTTER_Arabic_8 0x1000668
#define CLUTTER_Arabic_9 0x1000669
#define CLUTTER_Arabic_semicolon 0x5bb
#define CLUTTER_Arabic_question_mark 0x5bf
#define CLUTTER_Arabic_hamza 0x5c1
#define CLUTTER_Arabic_maddaonalef 0x5c2
#define CLUTTER_Arabic_hamzaonalef 0x5c3
#define CLUTTER_Arabic_hamzaonwaw 0x5c4
#define CLUTTER_Arabic_hamzaunderalef 0x5c5
#define CLUTTER_Arabic_hamzaonyeh 0x5c6
#define CLUTTER_Arabic_alef 0x5c7
#define CLUTTER_Arabic_beh 0x5c8
#define CLUTTER_Arabic_tehmarbuta 0x5c9
#define CLUTTER_Arabic_teh 0x5ca
#define CLUTTER_Arabic_theh 0x5cb
#define CLUTTER_Arabic_jeem 0x5cc
#define CLUTTER_Arabic_hah 0x5cd
#define CLUTTER_Arabic_khah 0x5ce
#define CLUTTER_Arabic_dal 0x5cf
#define CLUTTER_Arabic_thal 0x5d0
#define CLUTTER_Arabic_ra 0x5d1
#define CLUTTER_Arabic_zain 0x5d2
#define CLUTTER_Arabic_seen 0x5d3
#define CLUTTER_Arabic_sheen 0x5d4
#define CLUTTER_Arabic_sad 0x5d5
#define CLUTTER_Arabic_dad 0x5d6
#define CLUTTER_Arabic_tah 0x5d7
#define CLUTTER_Arabic_zah 0x5d8
#define CLUTTER_Arabic_ain 0x5d9
#define CLUTTER_Arabic_ghain 0x5da
#define CLUTTER_Arabic_tatweel 0x5e0
#define CLUTTER_Arabic_feh 0x5e1
#define CLUTTER_Arabic_qaf 0x5e2
#define CLUTTER_Arabic_kaf 0x5e3
#define CLUTTER_Arabic_lam 0x5e4
#define CLUTTER_Arabic_meem 0x5e5
#define CLUTTER_Arabic_noon 0x5e6
#define CLUTTER_Arabic_ha 0x5e7
#define CLUTTER_Arabic_heh 0x5e7
#define CLUTTER_Arabic_waw 0x5e8
#define CLUTTER_Arabic_alefmaksura 0x5e9
#define CLUTTER_Arabic_yeh 0x5ea
#define CLUTTER_Arabic_fathatan 0x5eb
#define CLUTTER_Arabic_dammatan 0x5ec
#define CLUTTER_Arabic_kasratan 0x5ed
#define CLUTTER_Arabic_fatha 0x5ee
#define CLUTTER_Arabic_damma 0x5ef
#define CLUTTER_Arabic_kasra 0x5f0
#define CLUTTER_Arabic_shadda 0x5f1
#define CLUTTER_Arabic_sukun 0x5f2
#define CLUTTER_Arabic_madda_above 0x1000653
#define CLUTTER_Arabic_hamza_above 0x1000654
#define CLUTTER_Arabic_hamza_below 0x1000655
#define CLUTTER_Arabic_jeh 0x1000698
#define CLUTTER_Arabic_veh 0x10006a4
#define CLUTTER_Arabic_keheh 0x10006a9
#define CLUTTER_Arabic_gaf 0x10006af
#define CLUTTER_Arabic_noon_ghunna 0x10006ba
#define CLUTTER_Arabic_heh_doachashmee 0x10006be
#define CLUTTER_Farsi_yeh 0x10006cc
#define CLUTTER_Arabic_farsi_yeh 0x10006cc
#define CLUTTER_Arabic_yeh_baree 0x10006d2
#define CLUTTER_Arabic_heh_goal 0x10006c1
#define CLUTTER_Arabic_switch 0xff7e
#define CLUTTER_Cyrillic_GHE_bar 0x1000492
#define CLUTTER_Cyrillic_ghe_bar 0x1000493
#define CLUTTER_Cyrillic_ZHE_descender 0x1000496
#define CLUTTER_Cyrillic_zhe_descender 0x1000497
#define CLUTTER_Cyrillic_KA_descender 0x100049a
#define CLUTTER_Cyrillic_ka_descender 0x100049b
#define CLUTTER_Cyrillic_KA_vertstroke 0x100049c
#define CLUTTER_Cyrillic_ka_vertstroke 0x100049d
#define CLUTTER_Cyrillic_EN_descender 0x10004a2
#define CLUTTER_Cyrillic_en_descender 0x10004a3
#define CLUTTER_Cyrillic_U_straight 0x10004ae
#define CLUTTER_Cyrillic_u_straight 0x10004af
#define CLUTTER_Cyrillic_U_straight_bar 0x10004b0
#define CLUTTER_Cyrillic_u_straight_bar 0x10004b1
#define CLUTTER_Cyrillic_HA_descender 0x10004b2
#define CLUTTER_Cyrillic_ha_descender 0x10004b3
#define CLUTTER_Cyrillic_CHE_descender 0x10004b6
#define CLUTTER_Cyrillic_che_descender 0x10004b7
#define CLUTTER_Cyrillic_CHE_vertstroke 0x10004b8
#define CLUTTER_Cyrillic_che_vertstroke 0x10004b9
#define CLUTTER_Cyrillic_SHHA 0x10004ba
#define CLUTTER_Cyrillic_shha 0x10004bb
#define CLUTTER_Cyrillic_SCHWA 0x10004d8
#define CLUTTER_Cyrillic_schwa 0x10004d9
#define CLUTTER_Cyrillic_I_macron 0x10004e2
#define CLUTTER_Cyrillic_i_macron 0x10004e3
#define CLUTTER_Cyrillic_O_bar 0x10004e8
#define CLUTTER_Cyrillic_o_bar 0x10004e9
#define CLUTTER_Cyrillic_U_macron 0x10004ee
#define CLUTTER_Cyrillic_u_macron 0x10004ef
#define CLUTTER_Serbian_dje 0x6a1
#define CLUTTER_Macedonia_gje 0x6a2
#define CLUTTER_Cyrillic_io 0x6a3
#define CLUTTER_Ukrainian_ie 0x6a4
#define CLUTTER_Ukranian_je 0x6a4
#define CLUTTER_Macedonia_dse 0x6a5
#define CLUTTER_Ukrainian_i 0x6a6
#define CLUTTER_Ukranian_i 0x6a6
#define CLUTTER_Ukrainian_yi 0x6a7
#define CLUTTER_Ukranian_yi 0x6a7
#define CLUTTER_Cyrillic_je 0x6a8
#define CLUTTER_Serbian_je 0x6a8
#define CLUTTER_Cyrillic_lje 0x6a9
#define CLUTTER_Serbian_lje 0x6a9
#define CLUTTER_Cyrillic_nje 0x6aa
#define CLUTTER_Serbian_nje 0x6aa
#define CLUTTER_Serbian_tshe 0x6ab
#define CLUTTER_Macedonia_kje 0x6ac
#define CLUTTER_Ukrainian_ghe_with_upturn 0x6ad
#define CLUTTER_Byelorussian_shortu 0x6ae
#define CLUTTER_Cyrillic_dzhe 0x6af
#define CLUTTER_Serbian_dze 0x6af
#define CLUTTER_numerosign 0x6b0
#define CLUTTER_Serbian_DJE 0x6b1
#define CLUTTER_Macedonia_GJE 0x6b2
#define CLUTTER_Cyrillic_IO 0x6b3
#define CLUTTER_Ukrainian_IE 0x6b4
#define CLUTTER_Ukranian_JE 0x6b4
#define CLUTTER_Macedonia_DSE 0x6b5
#define CLUTTER_Ukrainian_I 0x6b6
#define CLUTTER_Ukranian_I 0x6b6
#define CLUTTER_Ukrainian_YI 0x6b7
#define CLUTTER_Ukranian_YI 0x6b7
#define CLUTTER_Cyrillic_JE 0x6b8
#define CLUTTER_Serbian_JE 0x6b8
#define CLUTTER_Cyrillic_LJE 0x6b9
#define CLUTTER_Serbian_LJE 0x6b9
#define CLUTTER_Cyrillic_NJE 0x6ba
#define CLUTTER_Serbian_NJE 0x6ba
#define CLUTTER_Serbian_TSHE 0x6bb
#define CLUTTER_Macedonia_KJE 0x6bc
#define CLUTTER_Ukrainian_GHE_WITH_UPTURN 0x6bd
#define CLUTTER_Byelorussian_SHORTU 0x6be
#define CLUTTER_Cyrillic_DZHE 0x6bf
#define CLUTTER_Serbian_DZE 0x6bf
#define CLUTTER_Cyrillic_yu 0x6c0
#define CLUTTER_Cyrillic_a 0x6c1
#define CLUTTER_Cyrillic_be 0x6c2
#define CLUTTER_Cyrillic_tse 0x6c3
#define CLUTTER_Cyrillic_de 0x6c4
#define CLUTTER_Cyrillic_ie 0x6c5
#define CLUTTER_Cyrillic_ef 0x6c6
#define CLUTTER_Cyrillic_ghe 0x6c7
#define CLUTTER_Cyrillic_ha 0x6c8
#define CLUTTER_Cyrillic_i 0x6c9
#define CLUTTER_Cyrillic_shorti 0x6ca
#define CLUTTER_Cyrillic_ka 0x6cb
#define CLUTTER_Cyrillic_el 0x6cc
#define CLUTTER_Cyrillic_em 0x6cd
#define CLUTTER_Cyrillic_en 0x6ce
#define CLUTTER_Cyrillic_o 0x6cf
#define CLUTTER_Cyrillic_pe 0x6d0
#define CLUTTER_Cyrillic_ya 0x6d1
#define CLUTTER_Cyrillic_er 0x6d2
#define CLUTTER_Cyrillic_es 0x6d3
#define CLUTTER_Cyrillic_te 0x6d4
#define CLUTTER_Cyrillic_u 0x6d5
#define CLUTTER_Cyrillic_zhe 0x6d6
#define CLUTTER_Cyrillic_ve 0x6d7
#define CLUTTER_Cyrillic_softsign 0x6d8
#define CLUTTER_Cyrillic_yeru 0x6d9
#define CLUTTER_Cyrillic_ze 0x6da
#define CLUTTER_Cyrillic_sha 0x6db
#define CLUTTER_Cyrillic_e 0x6dc
#define CLUTTER_Cyrillic_shcha 0x6dd
#define CLUTTER_Cyrillic_che 0x6de
#define CLUTTER_Cyrillic_hardsign 0x6df
#define CLUTTER_Cyrillic_YU 0x6e0
#define CLUTTER_Cyrillic_A 0x6e1
#define CLUTTER_Cyrillic_BE 0x6e2
#define CLUTTER_Cyrillic_TSE 0x6e3
#define CLUTTER_Cyrillic_DE 0x6e4
#define CLUTTER_Cyrillic_IE 0x6e5
#define CLUTTER_Cyrillic_EF 0x6e6
#define CLUTTER_Cyrillic_GHE 0x6e7
#define CLUTTER_Cyrillic_HA 0x6e8
#define CLUTTER_Cyrillic_I 0x6e9
#define CLUTTER_Cyrillic_SHORTI 0x6ea
#define CLUTTER_Cyrillic_KA 0x6eb
#define CLUTTER_Cyrillic_EL 0x6ec
#define CLUTTER_Cyrillic_EM 0x6ed
#define CLUTTER_Cyrillic_EN 0x6ee
#define CLUTTER_Cyrillic_O 0x6ef
#define CLUTTER_Cyrillic_PE 0x6f0
#define CLUTTER_Cyrillic_YA 0x6f1
#define CLUTTER_Cyrillic_ER 0x6f2
#define CLUTTER_Cyrillic_ES 0x6f3
#define CLUTTER_Cyrillic_TE 0x6f4
#define CLUTTER_Cyrillic_U 0x6f5
#define CLUTTER_Cyrillic_ZHE 0x6f6
#define CLUTTER_Cyrillic_VE 0x6f7
#define CLUTTER_Cyrillic_SOFTSIGN 0x6f8
#define CLUTTER_Cyrillic_YERU 0x6f9
#define CLUTTER_Cyrillic_ZE 0x6fa
#define CLUTTER_Cyrillic_SHA 0x6fb
#define CLUTTER_Cyrillic_E 0x6fc
#define CLUTTER_Cyrillic_SHCHA 0x6fd
#define CLUTTER_Cyrillic_CHE 0x6fe
#define CLUTTER_Cyrillic_HARDSIGN 0x6ff
#define CLUTTER_Greek_ALPHAaccent 0x7a1
#define CLUTTER_Greek_EPSILONaccent 0x7a2
#define CLUTTER_Greek_ETAaccent 0x7a3
#define CLUTTER_Greek_IOTAaccent 0x7a4
#define CLUTTER_Greek_IOTAdieresis 0x7a5
#define CLUTTER_Greek_IOTAdiaeresis 0x7a5
#define CLUTTER_Greek_OMICRONaccent 0x7a7
#define CLUTTER_Greek_UPSILONaccent 0x7a8
#define CLUTTER_Greek_UPSILONdieresis 0x7a9
#define CLUTTER_Greek_OMEGAaccent 0x7ab
#define CLUTTER_Greek_accentdieresis 0x7ae
#define CLUTTER_Greek_horizbar 0x7af
#define CLUTTER_Greek_alphaaccent 0x7b1
#define CLUTTER_Greek_epsilonaccent 0x7b2
#define CLUTTER_Greek_etaaccent 0x7b3
#define CLUTTER_Greek_iotaaccent 0x7b4
#define CLUTTER_Greek_iotadieresis 0x7b5
#define CLUTTER_Greek_iotaaccentdieresis 0x7b6
#define CLUTTER_Greek_omicronaccent 0x7b7
#define CLUTTER_Greek_upsilonaccent 0x7b8
#define CLUTTER_Greek_upsilondieresis 0x7b9
#define CLUTTER_Greek_upsilonaccentdieresis 0x7ba
#define CLUTTER_Greek_omegaaccent 0x7bb
#define CLUTTER_Greek_ALPHA 0x7c1
#define CLUTTER_Greek_BETA 0x7c2
#define CLUTTER_Greek_GAMMA 0x7c3
#define CLUTTER_Greek_DELTA 0x7c4
#define CLUTTER_Greek_EPSILON 0x7c5
#define CLUTTER_Greek_ZETA 0x7c6
#define CLUTTER_Greek_ETA 0x7c7
#define CLUTTER_Greek_THETA 0x7c8
#define CLUTTER_Greek_IOTA 0x7c9
#define CLUTTER_Greek_KAPPA 0x7ca
#define CLUTTER_Greek_LAMDA 0x7cb
#define CLUTTER_Greek_LAMBDA 0x7cb
#define CLUTTER_Greek_MU 0x7cc
#define CLUTTER_Greek_NU 0x7cd
#define CLUTTER_Greek_XI 0x7ce
#define CLUTTER_Greek_OMICRON 0x7cf
#define CLUTTER_Greek_PI 0x7d0
#define CLUTTER_Greek_RHO 0x7d1
#define CLUTTER_Greek_SIGMA 0x7d2
#define CLUTTER_Greek_TAU 0x7d4
#define CLUTTER_Greek_UPSILON 0x7d5
#define CLUTTER_Greek_PHI 0x7d6
#define CLUTTER_Greek_CHI 0x7d7
#define CLUTTER_Greek_PSI 0x7d8
#define CLUTTER_Greek_OMEGA 0x7d9
#define CLUTTER_Greek_alpha 0x7e1
#define CLUTTER_Greek_beta 0x7e2
#define CLUTTER_Greek_gamma 0x7e3
#define CLUTTER_Greek_delta 0x7e4
#define CLUTTER_Greek_epsilon 0x7e5
#define CLUTTER_Greek_zeta 0x7e6
#define CLUTTER_Greek_eta 0x7e7
#define CLUTTER_Greek_theta 0x7e8
#define CLUTTER_Greek_iota 0x7e9
#define CLUTTER_Greek_kappa 0x7ea
#define CLUTTER_Greek_lamda 0x7eb
#define CLUTTER_Greek_lambda 0x7eb
#define CLUTTER_Greek_mu 0x7ec
#define CLUTTER_Greek_nu 0x7ed
#define CLUTTER_Greek_xi 0x7ee
#define CLUTTER_Greek_omicron 0x7ef
#define CLUTTER_Greek_pi 0x7f0
#define CLUTTER_Greek_rho 0x7f1
#define CLUTTER_Greek_sigma 0x7f2
#define CLUTTER_Greek_finalsmallsigma 0x7f3
#define CLUTTER_Greek_tau 0x7f4
#define CLUTTER_Greek_upsilon 0x7f5
#define CLUTTER_Greek_phi 0x7f6
#define CLUTTER_Greek_chi 0x7f7
#define CLUTTER_Greek_psi 0x7f8
#define CLUTTER_Greek_omega 0x7f9
#define CLUTTER_Greek_switch 0xff7e
#define CLUTTER_leftradical 0x8a1
#define CLUTTER_topleftradical 0x8a2
#define CLUTTER_horizconnector 0x8a3
#define CLUTTER_topintegral 0x8a4
#define CLUTTER_botintegral 0x8a5
#define CLUTTER_vertconnector 0x8a6
#define CLUTTER_topleftsqbracket 0x8a7
#define CLUTTER_botleftsqbracket 0x8a8
#define CLUTTER_toprightsqbracket 0x8a9
#define CLUTTER_botrightsqbracket 0x8aa
#define CLUTTER_topleftparens 0x8ab
#define CLUTTER_botleftparens 0x8ac
#define CLUTTER_toprightparens 0x8ad
#define CLUTTER_botrightparens 0x8ae
#define CLUTTER_leftmiddlecurlybrace 0x8af
#define CLUTTER_rightmiddlecurlybrace 0x8b0
#define CLUTTER_topleftsummation 0x8b1
#define CLUTTER_botleftsummation 0x8b2
#define CLUTTER_topvertsummationconnector 0x8b3
#define CLUTTER_botvertsummationconnector 0x8b4
#define CLUTTER_toprightsummation 0x8b5
#define CLUTTER_botrightsummation 0x8b6
#define CLUTTER_rightmiddlesummation 0x8b7
#define CLUTTER_lessthanequal 0x8bc
#define CLUTTER_notequal 0x8bd
#define CLUTTER_greaterthanequal 0x8be
#define CLUTTER_integral 0x8bf
#define CLUTTER_therefore 0x8c0
#define CLUTTER_variation 0x8c1
#define CLUTTER_infinity 0x8c2
#define CLUTTER_nabla 0x8c5
#define CLUTTER_approximate 0x8c8
#define CLUTTER_similarequal 0x8c9
#define CLUTTER_ifonlyif 0x8cd
#define CLUTTER_implies 0x8ce
#define CLUTTER_identical 0x8cf
#define CLUTTER_radical 0x8d6
#define CLUTTER_includedin 0x8da
#define CLUTTER_includes 0x8db
#define CLUTTER_intersection 0x8dc
#define CLUTTER_union 0x8dd
#define CLUTTER_logicaland 0x8de
#define CLUTTER_logicalor 0x8df
#define CLUTTER_partialderivative 0x8ef
#define CLUTTER_function 0x8f6
#define CLUTTER_leftarrow 0x8fb
#define CLUTTER_uparrow 0x8fc
#define CLUTTER_rightarrow 0x8fd
#define CLUTTER_downarrow 0x8fe
#define CLUTTER_blank 0x9df
#define CLUTTER_soliddiamond 0x9e0
#define CLUTTER_checkerboard 0x9e1
#define CLUTTER_ht 0x9e2
#define CLUTTER_ff 0x9e3
#define CLUTTER_cr 0x9e4
#define CLUTTER_lf 0x9e5
#define CLUTTER_nl 0x9e8
#define CLUTTER_vt 0x9e9
#define CLUTTER_lowrightcorner 0x9ea
#define CLUTTER_uprightcorner 0x9eb
#define CLUTTER_upleftcorner 0x9ec
#define CLUTTER_lowleftcorner 0x9ed
#define CLUTTER_crossinglines 0x9ee
#define CLUTTER_horizlinescan1 0x9ef
#define CLUTTER_horizlinescan3 0x9f0
#define CLUTTER_horizlinescan5 0x9f1
#define CLUTTER_horizlinescan7 0x9f2
#define CLUTTER_horizlinescan9 0x9f3
#define CLUTTER_leftt 0x9f4
#define CLUTTER_rightt 0x9f5
#define CLUTTER_bott 0x9f6
#define CLUTTER_topt 0x9f7
#define CLUTTER_vertbar 0x9f8
#define CLUTTER_emspace 0xaa1
#define CLUTTER_enspace 0xaa2
#define CLUTTER_em3space 0xaa3
#define CLUTTER_em4space 0xaa4
#define CLUTTER_digitspace 0xaa5
#define CLUTTER_punctspace 0xaa6
#define CLUTTER_thinspace 0xaa7
#define CLUTTER_hairspace 0xaa8
#define CLUTTER_emdash 0xaa9
#define CLUTTER_endash 0xaaa
#define CLUTTER_signifblank 0xaac
#define CLUTTER_ellipsis 0xaae
#define CLUTTER_doubbaselinedot 0xaaf
#define CLUTTER_onethird 0xab0
#define CLUTTER_twothirds 0xab1
#define CLUTTER_onefifth 0xab2
#define CLUTTER_twofifths 0xab3
#define CLUTTER_threefifths 0xab4
#define CLUTTER_fourfifths 0xab5
#define CLUTTER_onesixth 0xab6
#define CLUTTER_fivesixths 0xab7
#define CLUTTER_careof 0xab8
#define CLUTTER_figdash 0xabb
#define CLUTTER_leftanglebracket 0xabc
#define CLUTTER_decimalpoint 0xabd
#define CLUTTER_rightanglebracket 0xabe
#define CLUTTER_marker 0xabf
#define CLUTTER_oneeighth 0xac3
#define CLUTTER_threeeighths 0xac4
#define CLUTTER_fiveeighths 0xac5
#define CLUTTER_seveneighths 0xac6
#define CLUTTER_trademark 0xac9
#define CLUTTER_signaturemark 0xaca
#define CLUTTER_trademarkincircle 0xacb
#define CLUTTER_leftopentriangle 0xacc
#define CLUTTER_rightopentriangle 0xacd
#define CLUTTER_emopencircle 0xace
#define CLUTTER_emopenrectangle 0xacf
#define CLUTTER_leftsinglequotemark 0xad0
#define CLUTTER_rightsinglequotemark 0xad1
#define CLUTTER_leftdoublequotemark 0xad2
#define CLUTTER_rightdoublequotemark 0xad3
#define CLUTTER_prescription 0xad4
#define CLUTTER_minutes 0xad6
#define CLUTTER_seconds 0xad7
#define CLUTTER_latincross 0xad9
#define CLUTTER_hexagram 0xada
#define CLUTTER_filledrectbullet 0xadb
#define CLUTTER_filledlefttribullet 0xadc
#define CLUTTER_filledrighttribullet 0xadd
#define CLUTTER_emfilledcircle 0xade
#define CLUTTER_emfilledrect 0xadf
#define CLUTTER_enopencircbullet 0xae0
#define CLUTTER_enopensquarebullet 0xae1
#define CLUTTER_openrectbullet 0xae2
#define CLUTTER_opentribulletup 0xae3
#define CLUTTER_opentribulletdown 0xae4
#define CLUTTER_openstar 0xae5
#define CLUTTER_enfilledcircbullet 0xae6
#define CLUTTER_enfilledsqbullet 0xae7
#define CLUTTER_filledtribulletup 0xae8
#define CLUTTER_filledtribulletdown 0xae9
#define CLUTTER_leftpointer 0xaea
#define CLUTTER_rightpointer 0xaeb
#define CLUTTER_club 0xaec
#define CLUTTER_diamond 0xaed
#define CLUTTER_heart 0xaee
#define CLUTTER_maltesecross 0xaf0
#define CLUTTER_dagger 0xaf1
#define CLUTTER_doubledagger 0xaf2
#define CLUTTER_checkmark 0xaf3
#define CLUTTER_ballotcross 0xaf4
#define CLUTTER_musicalsharp 0xaf5
#define CLUTTER_musicalflat 0xaf6
#define CLUTTER_malesymbol 0xaf7
#define CLUTTER_femalesymbol 0xaf8
#define CLUTTER_telephone 0xaf9
#define CLUTTER_telephonerecorder 0xafa
#define CLUTTER_phonographcopyright 0xafb
#define CLUTTER_caret 0xafc
#define CLUTTER_singlelowquotemark 0xafd
#define CLUTTER_doublelowquotemark 0xafe
#define CLUTTER_cursor 0xaff
#define CLUTTER_leftcaret 0xba3
#define CLUTTER_rightcaret 0xba6
#define CLUTTER_downcaret 0xba8
#define CLUTTER_upcaret 0xba9
#define CLUTTER_overbar 0xbc0
#define CLUTTER_downtack 0xbc2
#define CLUTTER_upshoe 0xbc3
#define CLUTTER_downstile 0xbc4
#define CLUTTER_underbar 0xbc6
#define CLUTTER_jot 0xbca
#define CLUTTER_quad 0xbcc
#define CLUTTER_uptack 0xbce
#define CLUTTER_circle 0xbcf
#define CLUTTER_upstile 0xbd3
#define CLUTTER_downshoe 0xbd6
#define CLUTTER_rightshoe 0xbd8
#define CLUTTER_leftshoe 0xbda
#define CLUTTER_lefttack 0xbdc
#define CLUTTER_righttack 0xbfc
#define CLUTTER_hebrew_doublelowline 0xcdf
#define CLUTTER_hebrew_aleph 0xce0
#define CLUTTER_hebrew_bet 0xce1
#define CLUTTER_hebrew_beth 0xce1
#define CLUTTER_hebrew_gimel 0xce2
#define CLUTTER_hebrew_gimmel 0xce2
#define CLUTTER_hebrew_dalet 0xce3
#define CLUTTER_hebrew_daleth 0xce3
#define CLUTTER_hebrew_he 0xce4
#define CLUTTER_hebrew_waw 0xce5
#define CLUTTER_hebrew_zain 0xce6
#define CLUTTER_hebrew_zayin 0xce6
#define CLUTTER_hebrew_chet 0xce7
#define CLUTTER_hebrew_het 0xce7
#define CLUTTER_hebrew_tet 0xce8
#define CLUTTER_hebrew_teth 0xce8
#define CLUTTER_hebrew_yod 0xce9
#define CLUTTER_hebrew_finalkaph 0xcea
#define CLUTTER_hebrew_kaph 0xceb
#define CLUTTER_hebrew_lamed 0xcec
#define CLUTTER_hebrew_finalmem 0xced
#define CLUTTER_hebrew_mem 0xcee
#define CLUTTER_hebrew_finalnun 0xcef
#define CLUTTER_hebrew_nun 0xcf0
#define CLUTTER_hebrew_samech 0xcf1
#define CLUTTER_hebrew_samekh 0xcf1
#define CLUTTER_hebrew_ayin 0xcf2
#define CLUTTER_hebrew_finalpe 0xcf3
#define CLUTTER_hebrew_pe 0xcf4
#define CLUTTER_hebrew_finalzade 0xcf5
#define CLUTTER_hebrew_finalzadi 0xcf5
#define CLUTTER_hebrew_zade 0xcf6
#define CLUTTER_hebrew_zadi 0xcf6
#define CLUTTER_hebrew_qoph 0xcf7
#define CLUTTER_hebrew_kuf 0xcf7
#define CLUTTER_hebrew_resh 0xcf8
#define CLUTTER_hebrew_shin 0xcf9
#define CLUTTER_hebrew_taw 0xcfa
#define CLUTTER_hebrew_taf 0xcfa
#define CLUTTER_Hebrew_switch 0xff7e
#define CLUTTER_Thai_kokai 0xda1
#define CLUTTER_Thai_khokhai 0xda2
#define CLUTTER_Thai_khokhuat 0xda3
#define CLUTTER_Thai_khokhwai 0xda4
#define CLUTTER_Thai_khokhon 0xda5
#define CLUTTER_Thai_khorakhang 0xda6
#define CLUTTER_Thai_ngongu 0xda7
#define CLUTTER_Thai_chochan 0xda8
#define CLUTTER_Thai_choching 0xda9
#define CLUTTER_Thai_chochang 0xdaa
#define CLUTTER_Thai_soso 0xdab
#define CLUTTER_Thai_chochoe 0xdac
#define CLUTTER_Thai_yoying 0xdad
#define CLUTTER_Thai_dochada 0xdae
#define CLUTTER_Thai_topatak 0xdaf
#define CLUTTER_Thai_thothan 0xdb0
#define CLUTTER_Thai_thonangmontho 0xdb1
#define CLUTTER_Thai_thophuthao 0xdb2
#define CLUTTER_Thai_nonen 0xdb3
#define CLUTTER_Thai_dodek 0xdb4
#define CLUTTER_Thai_totao 0xdb5
#define CLUTTER_Thai_thothung 0xdb6
#define CLUTTER_Thai_thothahan 0xdb7
#define CLUTTER_Thai_thothong 0xdb8
#define CLUTTER_Thai_nonu 0xdb9
#define CLUTTER_Thai_bobaimai 0xdba
#define CLUTTER_Thai_popla 0xdbb
#define CLUTTER_Thai_phophung 0xdbc
#define CLUTTER_Thai_fofa 0xdbd
#define CLUTTER_Thai_phophan 0xdbe
#define CLUTTER_Thai_fofan 0xdbf
#define CLUTTER_Thai_phosamphao 0xdc0
#define CLUTTER_Thai_moma 0xdc1
#define CLUTTER_Thai_yoyak 0xdc2
#define CLUTTER_Thai_rorua 0xdc3
#define CLUTTER_Thai_ru 0xdc4
#define CLUTTER_Thai_loling 0xdc5
#define CLUTTER_Thai_lu 0xdc6
#define CLUTTER_Thai_wowaen 0xdc7
#define CLUTTER_Thai_sosala 0xdc8
#define CLUTTER_Thai_sorusi 0xdc9
#define CLUTTER_Thai_sosua 0xdca
#define CLUTTER_Thai_hohip 0xdcb
#define CLUTTER_Thai_lochula 0xdcc
#define CLUTTER_Thai_oang 0xdcd
#define CLUTTER_Thai_honokhuk 0xdce
#define CLUTTER_Thai_paiyannoi 0xdcf
#define CLUTTER_Thai_saraa 0xdd0
#define CLUTTER_Thai_maihanakat 0xdd1
#define CLUTTER_Thai_saraaa 0xdd2
#define CLUTTER_Thai_saraam 0xdd3
#define CLUTTER_Thai_sarai 0xdd4
#define CLUTTER_Thai_saraii 0xdd5
#define CLUTTER_Thai_saraue 0xdd6
#define CLUTTER_Thai_sarauee 0xdd7
#define CLUTTER_Thai_sarau 0xdd8
#define CLUTTER_Thai_sarauu 0xdd9
#define CLUTTER_Thai_phinthu 0xdda
#define CLUTTER_Thai_maihanakat_maitho 0xdde
#define CLUTTER_Thai_baht 0xddf
#define CLUTTER_Thai_sarae 0xde0
#define CLUTTER_Thai_saraae 0xde1
#define CLUTTER_Thai_sarao 0xde2
#define CLUTTER_Thai_saraaimaimuan 0xde3
#define CLUTTER_Thai_saraaimaimalai 0xde4
#define CLUTTER_Thai_lakkhangyao 0xde5
#define CLUTTER_Thai_maiyamok 0xde6
#define CLUTTER_Thai_maitaikhu 0xde7
#define CLUTTER_Thai_maiek 0xde8
#define CLUTTER_Thai_maitho 0xde9
#define CLUTTER_Thai_maitri 0xdea
#define CLUTTER_Thai_maichattawa 0xdeb
#define CLUTTER_Thai_thanthakhat 0xdec
#define CLUTTER_Thai_nikhahit 0xded
#define CLUTTER_Thai_leksun 0xdf0
#define CLUTTER_Thai_leknung 0xdf1
#define CLUTTER_Thai_leksong 0xdf2
#define CLUTTER_Thai_leksam 0xdf3
#define CLUTTER_Thai_leksi 0xdf4
#define CLUTTER_Thai_lekha 0xdf5
#define CLUTTER_Thai_lekhok 0xdf6
#define CLUTTER_Thai_lekchet 0xdf7
#define CLUTTER_Thai_lekpaet 0xdf8
#define CLUTTER_Thai_lekkao 0xdf9
#define CLUTTER_Hangul 0xff31
#define CLUTTER_Hangul_Start 0xff32
#define CLUTTER_Hangul_End 0xff33
#define CLUTTER_Hangul_Hanja 0xff34
#define CLUTTER_Hangul_Jamo 0xff35
#define CLUTTER_Hangul_Romaja 0xff36
#define CLUTTER_Hangul_Codeinput 0xff37
#define CLUTTER_Hangul_Jeonja 0xff38
#define CLUTTER_Hangul_Banja 0xff39
#define CLUTTER_Hangul_PreHanja 0xff3a
#define CLUTTER_Hangul_PostHanja 0xff3b
#define CLUTTER_Hangul_SingleCandidate 0xff3c
#define CLUTTER_Hangul_MultipleCandidate 0xff3d
#define CLUTTER_Hangul_PreviousCandidate 0xff3e
#define CLUTTER_Hangul_Special 0xff3f
#define CLUTTER_Hangul_switch 0xff7e
#define CLUTTER_Hangul_Kiyeog 0xea1
#define CLUTTER_Hangul_SsangKiyeog 0xea2
#define CLUTTER_Hangul_KiyeogSios 0xea3
#define CLUTTER_Hangul_Nieun 0xea4
#define CLUTTER_Hangul_NieunJieuj 0xea5
#define CLUTTER_Hangul_NieunHieuh 0xea6
#define CLUTTER_Hangul_Dikeud 0xea7
#define CLUTTER_Hangul_SsangDikeud 0xea8
#define CLUTTER_Hangul_Rieul 0xea9
#define CLUTTER_Hangul_RieulKiyeog 0xeaa
#define CLUTTER_Hangul_RieulMieum 0xeab
#define CLUTTER_Hangul_RieulPieub 0xeac
#define CLUTTER_Hangul_RieulSios 0xead
#define CLUTTER_Hangul_RieulTieut 0xeae
#define CLUTTER_Hangul_RieulPhieuf 0xeaf
#define CLUTTER_Hangul_RieulHieuh 0xeb0
#define CLUTTER_Hangul_Mieum 0xeb1
#define CLUTTER_Hangul_Pieub 0xeb2
#define CLUTTER_Hangul_SsangPieub 0xeb3
#define CLUTTER_Hangul_PieubSios 0xeb4
#define CLUTTER_Hangul_Sios 0xeb5
#define CLUTTER_Hangul_SsangSios 0xeb6
#define CLUTTER_Hangul_Ieung 0xeb7
#define CLUTTER_Hangul_Jieuj 0xeb8
#define CLUTTER_Hangul_SsangJieuj 0xeb9
#define CLUTTER_Hangul_Cieuc 0xeba
#define CLUTTER_Hangul_Khieuq 0xebb
#define CLUTTER_Hangul_Tieut 0xebc
#define CLUTTER_Hangul_Phieuf 0xebd
#define CLUTTER_Hangul_Hieuh 0xebe
#define CLUTTER_Hangul_A 0xebf
#define CLUTTER_Hangul_AE 0xec0
#define CLUTTER_Hangul_YA 0xec1
#define CLUTTER_Hangul_YAE 0xec2
#define CLUTTER_Hangul_EO 0xec3
#define CLUTTER_Hangul_E 0xec4
#define CLUTTER_Hangul_YEO 0xec5
#define CLUTTER_Hangul_YE 0xec6
#define CLUTTER_Hangul_O 0xec7
#define CLUTTER_Hangul_WA 0xec8
#define CLUTTER_Hangul_WAE 0xec9
#define CLUTTER_Hangul_OE 0xeca
#define CLUTTER_Hangul_YO 0xecb
#define CLUTTER_Hangul_U 0xecc
#define CLUTTER_Hangul_WEO 0xecd
#define CLUTTER_Hangul_WE 0xece
#define CLUTTER_Hangul_WI 0xecf
#define CLUTTER_Hangul_YU 0xed0
#define CLUTTER_Hangul_EU 0xed1
#define CLUTTER_Hangul_YI 0xed2
#define CLUTTER_Hangul_I 0xed3
#define CLUTTER_Hangul_J_Kiyeog 0xed4
#define CLUTTER_Hangul_J_SsangKiyeog 0xed5
#define CLUTTER_Hangul_J_KiyeogSios 0xed6
#define CLUTTER_Hangul_J_Nieun 0xed7
#define CLUTTER_Hangul_J_NieunJieuj 0xed8
#define CLUTTER_Hangul_J_NieunHieuh 0xed9
#define CLUTTER_Hangul_J_Dikeud 0xeda
#define CLUTTER_Hangul_J_Rieul 0xedb
#define CLUTTER_Hangul_J_RieulKiyeog 0xedc
#define CLUTTER_Hangul_J_RieulMieum 0xedd
#define CLUTTER_Hangul_J_RieulPieub 0xede
#define CLUTTER_Hangul_J_RieulSios 0xedf
#define CLUTTER_Hangul_J_RieulTieut 0xee0
#define CLUTTER_Hangul_J_RieulPhieuf 0xee1
#define CLUTTER_Hangul_J_RieulHieuh 0xee2
#define CLUTTER_Hangul_J_Mieum 0xee3
#define CLUTTER_Hangul_J_Pieub 0xee4
#define CLUTTER_Hangul_J_PieubSios 0xee5
#define CLUTTER_Hangul_J_Sios 0xee6
#define CLUTTER_Hangul_J_SsangSios 0xee7
#define CLUTTER_Hangul_J_Ieung 0xee8
#define CLUTTER_Hangul_J_Jieuj 0xee9
#define CLUTTER_Hangul_J_Cieuc 0xeea
#define CLUTTER_Hangul_J_Khieuq 0xeeb
#define CLUTTER_Hangul_J_Tieut 0xeec
#define CLUTTER_Hangul_J_Phieuf 0xeed
#define CLUTTER_Hangul_J_Hieuh 0xeee
#define CLUTTER_Hangul_RieulYeorinHieuh 0xeef
#define CLUTTER_Hangul_SunkyeongeumMieum 0xef0
#define CLUTTER_Hangul_SunkyeongeumPieub 0xef1
#define CLUTTER_Hangul_PanSios 0xef2
#define CLUTTER_Hangul_KkogjiDalrinIeung 0xef3
#define CLUTTER_Hangul_SunkyeongeumPhieuf 0xef4
#define CLUTTER_Hangul_YeorinHieuh 0xef5
#define CLUTTER_Hangul_AraeA 0xef6
#define CLUTTER_Hangul_AraeAE 0xef7
#define CLUTTER_Hangul_J_PanSios 0xef8
#define CLUTTER_Hangul_J_KkogjiDalrinIeung 0xef9
#define CLUTTER_Hangul_J_YeorinHieuh 0xefa
#define CLUTTER_Korean_Won 0xeff
#define CLUTTER_Armenian_ligature_ew 0x1000587
#define CLUTTER_Armenian_full_stop 0x1000589
#define CLUTTER_Armenian_verjaket 0x1000589
#define CLUTTER_Armenian_separation_mark 0x100055d
#define CLUTTER_Armenian_but 0x100055d
#define CLUTTER_Armenian_hyphen 0x100058a
#define CLUTTER_Armenian_yentamna 0x100058a
#define CLUTTER_Armenian_exclam 0x100055c
#define CLUTTER_Armenian_amanak 0x100055c
#define CLUTTER_Armenian_accent 0x100055b
#define CLUTTER_Armenian_shesht 0x100055b
#define CLUTTER_Armenian_question 0x100055e
#define CLUTTER_Armenian_paruyk 0x100055e
#define CLUTTER_Armenian_AYB 0x1000531
#define CLUTTER_Armenian_ayb 0x1000561
#define CLUTTER_Armenian_BEN 0x1000532
#define CLUTTER_Armenian_ben 0x1000562
#define CLUTTER_Armenian_GIM 0x1000533
#define CLUTTER_Armenian_gim 0x1000563
#define CLUTTER_Armenian_DA 0x1000534
#define CLUTTER_Armenian_da 0x1000564
#define CLUTTER_Armenian_YECH 0x1000535
#define CLUTTER_Armenian_yech 0x1000565
#define CLUTTER_Armenian_ZA 0x1000536
#define CLUTTER_Armenian_za 0x1000566
#define CLUTTER_Armenian_E 0x1000537
#define CLUTTER_Armenian_e 0x1000567
#define CLUTTER_Armenian_AT 0x1000538
#define CLUTTER_Armenian_at 0x1000568
#define CLUTTER_Armenian_TO 0x1000539
#define CLUTTER_Armenian_to 0x1000569
#define CLUTTER_Armenian_ZHE 0x100053a
#define CLUTTER_Armenian_zhe 0x100056a
#define CLUTTER_Armenian_INI 0x100053b
#define CLUTTER_Armenian_ini 0x100056b
#define CLUTTER_Armenian_LYUN 0x100053c
#define CLUTTER_Armenian_lyun 0x100056c
#define CLUTTER_Armenian_KHE 0x100053d
#define CLUTTER_Armenian_khe 0x100056d
#define CLUTTER_Armenian_TSA 0x100053e
#define CLUTTER_Armenian_tsa 0x100056e
#define CLUTTER_Armenian_KEN 0x100053f
#define CLUTTER_Armenian_ken 0x100056f
#define CLUTTER_Armenian_HO 0x1000540
#define CLUTTER_Armenian_ho 0x1000570
#define CLUTTER_Armenian_DZA 0x1000541
#define CLUTTER_Armenian_dza 0x1000571
#define CLUTTER_Armenian_GHAT 0x1000542
#define CLUTTER_Armenian_ghat 0x1000572
#define CLUTTER_Armenian_TCHE 0x1000543
#define CLUTTER_Armenian_tche 0x1000573
#define CLUTTER_Armenian_MEN 0x1000544
#define CLUTTER_Armenian_men 0x1000574
#define CLUTTER_Armenian_HI 0x1000545
#define CLUTTER_Armenian_hi 0x1000575
#define CLUTTER_Armenian_NU 0x1000546
#define CLUTTER_Armenian_nu 0x1000576
#define CLUTTER_Armenian_SHA 0x1000547
#define CLUTTER_Armenian_sha 0x1000577
#define CLUTTER_Armenian_VO 0x1000548
#define CLUTTER_Armenian_vo 0x1000578
#define CLUTTER_Armenian_CHA 0x1000549
#define CLUTTER_Armenian_cha 0x1000579
#define CLUTTER_Armenian_PE 0x100054a
#define CLUTTER_Armenian_pe 0x100057a
#define CLUTTER_Armenian_JE 0x100054b
#define CLUTTER_Armenian_je 0x100057b
#define CLUTTER_Armenian_RA 0x100054c
#define CLUTTER_Armenian_ra 0x100057c
#define CLUTTER_Armenian_SE 0x100054d
#define CLUTTER_Armenian_se 0x100057d
#define CLUTTER_Armenian_VEV 0x100054e
#define CLUTTER_Armenian_vev 0x100057e
#define CLUTTER_Armenian_TYUN 0x100054f
#define CLUTTER_Armenian_tyun 0x100057f
#define CLUTTER_Armenian_RE 0x1000550
#define CLUTTER_Armenian_re 0x1000580
#define CLUTTER_Armenian_TSO 0x1000551
#define CLUTTER_Armenian_tso 0x1000581
#define CLUTTER_Armenian_VYUN 0x1000552
#define CLUTTER_Armenian_vyun 0x1000582
#define CLUTTER_Armenian_PYUR 0x1000553
#define CLUTTER_Armenian_pyur 0x1000583
#define CLUTTER_Armenian_KE 0x1000554
#define CLUTTER_Armenian_ke 0x1000584
#define CLUTTER_Armenian_O 0x1000555
#define CLUTTER_Armenian_o 0x1000585
#define CLUTTER_Armenian_FE 0x1000556
#define CLUTTER_Armenian_fe 0x1000586
#define CLUTTER_Armenian_apostrophe 0x100055a
#define CLUTTER_Georgian_an 0x10010d0
#define CLUTTER_Georgian_ban 0x10010d1
#define CLUTTER_Georgian_gan 0x10010d2
#define CLUTTER_Georgian_don 0x10010d3
#define CLUTTER_Georgian_en 0x10010d4
#define CLUTTER_Georgian_vin 0x10010d5
#define CLUTTER_Georgian_zen 0x10010d6
#define CLUTTER_Georgian_tan 0x10010d7
#define CLUTTER_Georgian_in 0x10010d8
#define CLUTTER_Georgian_kan 0x10010d9
#define CLUTTER_Georgian_las 0x10010da
#define CLUTTER_Georgian_man 0x10010db
#define CLUTTER_Georgian_nar 0x10010dc
#define CLUTTER_Georgian_on 0x10010dd
#define CLUTTER_Georgian_par 0x10010de
#define CLUTTER_Georgian_zhar 0x10010df
#define CLUTTER_Georgian_rae 0x10010e0
#define CLUTTER_Georgian_san 0x10010e1
#define CLUTTER_Georgian_tar 0x10010e2
#define CLUTTER_Georgian_un 0x10010e3
#define CLUTTER_Georgian_phar 0x10010e4
#define CLUTTER_Georgian_khar 0x10010e5
#define CLUTTER_Georgian_ghan 0x10010e6
#define CLUTTER_Georgian_qar 0x10010e7
#define CLUTTER_Georgian_shin 0x10010e8
#define CLUTTER_Georgian_chin 0x10010e9
#define CLUTTER_Georgian_can 0x10010ea
#define CLUTTER_Georgian_jil 0x10010eb
#define CLUTTER_Georgian_cil 0x10010ec
#define CLUTTER_Georgian_char 0x10010ed
#define CLUTTER_Georgian_xan 0x10010ee
#define CLUTTER_Georgian_jhan 0x10010ef
#define CLUTTER_Georgian_hae 0x10010f0
#define CLUTTER_Georgian_he 0x10010f1
#define CLUTTER_Georgian_hie 0x10010f2
#define CLUTTER_Georgian_we 0x10010f3
#define CLUTTER_Georgian_har 0x10010f4
#define CLUTTER_Georgian_hoe 0x10010f5
#define CLUTTER_Georgian_fi 0x10010f6
#define CLUTTER_Xabovedot 0x1001e8a
#define CLUTTER_Ibreve 0x100012c
#define CLUTTER_Zstroke 0x10001b5
#define CLUTTER_Gcaron 0x10001e6
#define CLUTTER_Ocaron 0x10001d1
#define CLUTTER_Obarred 0x100019f
#define CLUTTER_xabovedot 0x1001e8b
#define CLUTTER_ibreve 0x100012d
#define CLUTTER_zstroke 0x10001b6
#define CLUTTER_gcaron 0x10001e7
#define CLUTTER_ocaron 0x10001d2
#define CLUTTER_obarred 0x1000275
#define CLUTTER_SCHWA 0x100018f
#define CLUTTER_schwa 0x1000259
#define CLUTTER_Lbelowdot 0x1001e36
#define CLUTTER_lbelowdot 0x1001e37
#define CLUTTER_Abelowdot 0x1001ea0
#define CLUTTER_abelowdot 0x1001ea1
#define CLUTTER_Ahook 0x1001ea2
#define CLUTTER_ahook 0x1001ea3
#define CLUTTER_Acircumflexacute 0x1001ea4
#define CLUTTER_acircumflexacute 0x1001ea5
#define CLUTTER_Acircumflexgrave 0x1001ea6
#define CLUTTER_acircumflexgrave 0x1001ea7
#define CLUTTER_Acircumflexhook 0x1001ea8
#define CLUTTER_acircumflexhook 0x1001ea9
#define CLUTTER_Acircumflextilde 0x1001eaa
#define CLUTTER_acircumflextilde 0x1001eab
#define CLUTTER_Acircumflexbelowdot 0x1001eac
#define CLUTTER_acircumflexbelowdot 0x1001ead
#define CLUTTER_Abreveacute 0x1001eae
#define CLUTTER_abreveacute 0x1001eaf
#define CLUTTER_Abrevegrave 0x1001eb0
#define CLUTTER_abrevegrave 0x1001eb1
#define CLUTTER_Abrevehook 0x1001eb2
#define CLUTTER_abrevehook 0x1001eb3
#define CLUTTER_Abrevetilde 0x1001eb4
#define CLUTTER_abrevetilde 0x1001eb5
#define CLUTTER_Abrevebelowdot 0x1001eb6
#define CLUTTER_abrevebelowdot 0x1001eb7
#define CLUTTER_Ebelowdot 0x1001eb8
#define CLUTTER_ebelowdot 0x1001eb9
#define CLUTTER_Ehook 0x1001eba
#define CLUTTER_ehook 0x1001ebb
#define CLUTTER_Etilde 0x1001ebc
#define CLUTTER_etilde 0x1001ebd
#define CLUTTER_Ecircumflexacute 0x1001ebe
#define CLUTTER_ecircumflexacute 0x1001ebf
#define CLUTTER_Ecircumflexgrave 0x1001ec0
#define CLUTTER_ecircumflexgrave 0x1001ec1
#define CLUTTER_Ecircumflexhook 0x1001ec2
#define CLUTTER_ecircumflexhook 0x1001ec3
#define CLUTTER_Ecircumflextilde 0x1001ec4
#define CLUTTER_ecircumflextilde 0x1001ec5
#define CLUTTER_Ecircumflexbelowdot 0x1001ec6
#define CLUTTER_ecircumflexbelowdot 0x1001ec7
#define CLUTTER_Ihook 0x1001ec8
#define CLUTTER_ihook 0x1001ec9
#define CLUTTER_Ibelowdot 0x1001eca
#define CLUTTER_ibelowdot 0x1001ecb
#define CLUTTER_Obelowdot 0x1001ecc
#define CLUTTER_obelowdot 0x1001ecd
#define CLUTTER_Ohook 0x1001ece
#define CLUTTER_ohook 0x1001ecf
#define CLUTTER_Ocircumflexacute 0x1001ed0
#define CLUTTER_ocircumflexacute 0x1001ed1
#define CLUTTER_Ocircumflexgrave 0x1001ed2
#define CLUTTER_ocircumflexgrave 0x1001ed3
#define CLUTTER_Ocircumflexhook 0x1001ed4
#define CLUTTER_ocircumflexhook 0x1001ed5
#define CLUTTER_Ocircumflextilde 0x1001ed6
#define CLUTTER_ocircumflextilde 0x1001ed7
#define CLUTTER_Ocircumflexbelowdot 0x1001ed8
#define CLUTTER_ocircumflexbelowdot 0x1001ed9
#define CLUTTER_Ohornacute 0x1001eda
#define CLUTTER_ohornacute 0x1001edb
#define CLUTTER_Ohorngrave 0x1001edc
#define CLUTTER_ohorngrave 0x1001edd
#define CLUTTER_Ohornhook 0x1001ede
#define CLUTTER_ohornhook 0x1001edf
#define CLUTTER_Ohorntilde 0x1001ee0
#define CLUTTER_ohorntilde 0x1001ee1
#define CLUTTER_Ohornbelowdot 0x1001ee2
#define CLUTTER_ohornbelowdot 0x1001ee3
#define CLUTTER_Ubelowdot 0x1001ee4
#define CLUTTER_ubelowdot 0x1001ee5
#define CLUTTER_Uhook 0x1001ee6
#define CLUTTER_uhook 0x1001ee7
#define CLUTTER_Uhornacute 0x1001ee8
#define CLUTTER_uhornacute 0x1001ee9
#define CLUTTER_Uhorngrave 0x1001eea
#define CLUTTER_uhorngrave 0x1001eeb
#define CLUTTER_Uhornhook 0x1001eec
#define CLUTTER_uhornhook 0x1001eed
#define CLUTTER_Uhorntilde 0x1001eee
#define CLUTTER_uhorntilde 0x1001eef
#define CLUTTER_Uhornbelowdot 0x1001ef0
#define CLUTTER_uhornbelowdot 0x1001ef1
#define CLUTTER_Ybelowdot 0x1001ef4
#define CLUTTER_ybelowdot 0x1001ef5
#define CLUTTER_Yhook 0x1001ef6
#define CLUTTER_yhook 0x1001ef7
#define CLUTTER_Ytilde 0x1001ef8
#define CLUTTER_ytilde 0x1001ef9
#define CLUTTER_Ohorn 0x10001a0
#define CLUTTER_ohorn 0x10001a1
#define CLUTTER_Uhorn 0x10001af
#define CLUTTER_uhorn 0x10001b0
#define CLUTTER_EcuSign 0x10020a0
#define CLUTTER_ColonSign 0x10020a1
#define CLUTTER_CruzeiroSign 0x10020a2
#define CLUTTER_FFrancSign 0x10020a3
#define CLUTTER_LiraSign 0x10020a4
#define CLUTTER_MillSign 0x10020a5
#define CLUTTER_NairaSign 0x10020a6
#define CLUTTER_PesetaSign 0x10020a7
#define CLUTTER_RupeeSign 0x10020a8
#define CLUTTER_WonSign 0x10020a9
#define CLUTTER_NewSheqelSign 0x10020aa
#define CLUTTER_DongSign 0x10020ab
#define CLUTTER_EuroSign 0x20ac
#define CLUTTER_zerosuperior 0x1002070
#define CLUTTER_foursuperior 0x1002074
#define CLUTTER_fivesuperior 0x1002075
#define CLUTTER_sixsuperior 0x1002076
#define CLUTTER_sevensuperior 0x1002077
#define CLUTTER_eightsuperior 0x1002078
#define CLUTTER_ninesuperior 0x1002079
#define CLUTTER_zerosubscript 0x1002080
#define CLUTTER_onesubscript 0x1002081
#define CLUTTER_twosubscript 0x1002082
#define CLUTTER_threesubscript 0x1002083
#define CLUTTER_foursubscript 0x1002084
#define CLUTTER_fivesubscript 0x1002085
#define CLUTTER_sixsubscript 0x1002086
#define CLUTTER_sevensubscript 0x1002087
#define CLUTTER_eightsubscript 0x1002088
#define CLUTTER_ninesubscript 0x1002089
#define CLUTTER_partdifferential 0x1002202
#define CLUTTER_emptyset 0x1002205
#define CLUTTER_elementof 0x1002208
#define CLUTTER_notelementof 0x1002209
#define CLUTTER_containsas 0x100220b
#define CLUTTER_squareroot 0x100221a
#define CLUTTER_cuberoot 0x100221b
#define CLUTTER_fourthroot 0x100221c
#define CLUTTER_dintegral 0x100222c
#define CLUTTER_tintegral 0x100222d
#define CLUTTER_because 0x1002235
#define CLUTTER_approxeq 0x1002248
#define CLUTTER_notapproxeq 0x1002247
#define CLUTTER_notidentical 0x1002262
#define CLUTTER_stricteq 0x1002263
#define CLUTTER_braille_dot_1 0xfff1
#define CLUTTER_braille_dot_2 0xfff2
#define CLUTTER_braille_dot_3 0xfff3
#define CLUTTER_braille_dot_4 0xfff4
#define CLUTTER_braille_dot_5 0xfff5
#define CLUTTER_braille_dot_6 0xfff6
#define CLUTTER_braille_dot_7 0xfff7
#define CLUTTER_braille_dot_8 0xfff8
#define CLUTTER_braille_dot_9 0xfff9
#define CLUTTER_braille_dot_10 0xfffa
#define CLUTTER_braille_blank 0x1002800
#define CLUTTER_braille_dots_1 0x1002801
#define CLUTTER_braille_dots_2 0x1002802
#define CLUTTER_braille_dots_12 0x1002803
#define CLUTTER_braille_dots_3 0x1002804
#define CLUTTER_braille_dots_13 0x1002805
#define CLUTTER_braille_dots_23 0x1002806
#define CLUTTER_braille_dots_123 0x1002807
#define CLUTTER_braille_dots_4 0x1002808
#define CLUTTER_braille_dots_14 0x1002809
#define CLUTTER_braille_dots_24 0x100280a
#define CLUTTER_braille_dots_124 0x100280b
#define CLUTTER_braille_dots_34 0x100280c
#define CLUTTER_braille_dots_134 0x100280d
#define CLUTTER_braille_dots_234 0x100280e
#define CLUTTER_braille_dots_1234 0x100280f
#define CLUTTER_braille_dots_5 0x1002810
#define CLUTTER_braille_dots_15 0x1002811
#define CLUTTER_braille_dots_25 0x1002812
#define CLUTTER_braille_dots_125 0x1002813
#define CLUTTER_braille_dots_35 0x1002814
#define CLUTTER_braille_dots_135 0x1002815
#define CLUTTER_braille_dots_235 0x1002816
#define CLUTTER_braille_dots_1235 0x1002817
#define CLUTTER_braille_dots_45 0x1002818
#define CLUTTER_braille_dots_145 0x1002819
#define CLUTTER_braille_dots_245 0x100281a
#define CLUTTER_braille_dots_1245 0x100281b
#define CLUTTER_braille_dots_345 0x100281c
#define CLUTTER_braille_dots_1345 0x100281d
#define CLUTTER_braille_dots_2345 0x100281e
#define CLUTTER_braille_dots_12345 0x100281f
#define CLUTTER_braille_dots_6 0x1002820
#define CLUTTER_braille_dots_16 0x1002821
#define CLUTTER_braille_dots_26 0x1002822
#define CLUTTER_braille_dots_126 0x1002823
#define CLUTTER_braille_dots_36 0x1002824
#define CLUTTER_braille_dots_136 0x1002825
#define CLUTTER_braille_dots_236 0x1002826
#define CLUTTER_braille_dots_1236 0x1002827
#define CLUTTER_braille_dots_46 0x1002828
#define CLUTTER_braille_dots_146 0x1002829
#define CLUTTER_braille_dots_246 0x100282a
#define CLUTTER_braille_dots_1246 0x100282b
#define CLUTTER_braille_dots_346 0x100282c
#define CLUTTER_braille_dots_1346 0x100282d
#define CLUTTER_braille_dots_2346 0x100282e
#define CLUTTER_braille_dots_12346 0x100282f
#define CLUTTER_braille_dots_56 0x1002830
#define CLUTTER_braille_dots_156 0x1002831
#define CLUTTER_braille_dots_256 0x1002832
#define CLUTTER_braille_dots_1256 0x1002833
#define CLUTTER_braille_dots_356 0x1002834
#define CLUTTER_braille_dots_1356 0x1002835
#define CLUTTER_braille_dots_2356 0x1002836
#define CLUTTER_braille_dots_12356 0x1002837
#define CLUTTER_braille_dots_456 0x1002838
#define CLUTTER_braille_dots_1456 0x1002839
#define CLUTTER_braille_dots_2456 0x100283a
#define CLUTTER_braille_dots_12456 0x100283b
#define CLUTTER_braille_dots_3456 0x100283c
#define CLUTTER_braille_dots_13456 0x100283d
#define CLUTTER_braille_dots_23456 0x100283e
#define CLUTTER_braille_dots_123456 0x100283f
#define CLUTTER_braille_dots_7 0x1002840
#define CLUTTER_braille_dots_17 0x1002841
#define CLUTTER_braille_dots_27 0x1002842
#define CLUTTER_braille_dots_127 0x1002843
#define CLUTTER_braille_dots_37 0x1002844
#define CLUTTER_braille_dots_137 0x1002845
#define CLUTTER_braille_dots_237 0x1002846
#define CLUTTER_braille_dots_1237 0x1002847
#define CLUTTER_braille_dots_47 0x1002848
#define CLUTTER_braille_dots_147 0x1002849
#define CLUTTER_braille_dots_247 0x100284a
#define CLUTTER_braille_dots_1247 0x100284b
#define CLUTTER_braille_dots_347 0x100284c
#define CLUTTER_braille_dots_1347 0x100284d
#define CLUTTER_braille_dots_2347 0x100284e
#define CLUTTER_braille_dots_12347 0x100284f
#define CLUTTER_braille_dots_57 0x1002850
#define CLUTTER_braille_dots_157 0x1002851
#define CLUTTER_braille_dots_257 0x1002852
#define CLUTTER_braille_dots_1257 0x1002853
#define CLUTTER_braille_dots_357 0x1002854
#define CLUTTER_braille_dots_1357 0x1002855
#define CLUTTER_braille_dots_2357 0x1002856
#define CLUTTER_braille_dots_12357 0x1002857
#define CLUTTER_braille_dots_457 0x1002858
#define CLUTTER_braille_dots_1457 0x1002859
#define CLUTTER_braille_dots_2457 0x100285a
#define CLUTTER_braille_dots_12457 0x100285b
#define CLUTTER_braille_dots_3457 0x100285c
#define CLUTTER_braille_dots_13457 0x100285d
#define CLUTTER_braille_dots_23457 0x100285e
#define CLUTTER_braille_dots_123457 0x100285f
#define CLUTTER_braille_dots_67 0x1002860
#define CLUTTER_braille_dots_167 0x1002861
#define CLUTTER_braille_dots_267 0x1002862
#define CLUTTER_braille_dots_1267 0x1002863
#define CLUTTER_braille_dots_367 0x1002864
#define CLUTTER_braille_dots_1367 0x1002865
#define CLUTTER_braille_dots_2367 0x1002866
#define CLUTTER_braille_dots_12367 0x1002867
#define CLUTTER_braille_dots_467 0x1002868
#define CLUTTER_braille_dots_1467 0x1002869
#define CLUTTER_braille_dots_2467 0x100286a
#define CLUTTER_braille_dots_12467 0x100286b
#define CLUTTER_braille_dots_3467 0x100286c
#define CLUTTER_braille_dots_13467 0x100286d
#define CLUTTER_braille_dots_23467 0x100286e
#define CLUTTER_braille_dots_123467 0x100286f
#define CLUTTER_braille_dots_567 0x1002870
#define CLUTTER_braille_dots_1567 0x1002871
#define CLUTTER_braille_dots_2567 0x1002872
#define CLUTTER_braille_dots_12567 0x1002873
#define CLUTTER_braille_dots_3567 0x1002874
#define CLUTTER_braille_dots_13567 0x1002875
#define CLUTTER_braille_dots_23567 0x1002876
#define CLUTTER_braille_dots_123567 0x1002877
#define CLUTTER_braille_dots_4567 0x1002878
#define CLUTTER_braille_dots_14567 0x1002879
#define CLUTTER_braille_dots_24567 0x100287a
#define CLUTTER_braille_dots_124567 0x100287b
#define CLUTTER_braille_dots_34567 0x100287c
#define CLUTTER_braille_dots_134567 0x100287d
#define CLUTTER_braille_dots_234567 0x100287e
#define CLUTTER_braille_dots_1234567 0x100287f
#define CLUTTER_braille_dots_8 0x1002880
#define CLUTTER_braille_dots_18 0x1002881
#define CLUTTER_braille_dots_28 0x1002882
#define CLUTTER_braille_dots_128 0x1002883
#define CLUTTER_braille_dots_38 0x1002884
#define CLUTTER_braille_dots_138 0x1002885
#define CLUTTER_braille_dots_238 0x1002886
#define CLUTTER_braille_dots_1238 0x1002887
#define CLUTTER_braille_dots_48 0x1002888
#define CLUTTER_braille_dots_148 0x1002889
#define CLUTTER_braille_dots_248 0x100288a
#define CLUTTER_braille_dots_1248 0x100288b
#define CLUTTER_braille_dots_348 0x100288c
#define CLUTTER_braille_dots_1348 0x100288d
#define CLUTTER_braille_dots_2348 0x100288e
#define CLUTTER_braille_dots_12348 0x100288f
#define CLUTTER_braille_dots_58 0x1002890
#define CLUTTER_braille_dots_158 0x1002891
#define CLUTTER_braille_dots_258 0x1002892
#define CLUTTER_braille_dots_1258 0x1002893
#define CLUTTER_braille_dots_358 0x1002894
#define CLUTTER_braille_dots_1358 0x1002895
#define CLUTTER_braille_dots_2358 0x1002896
#define CLUTTER_braille_dots_12358 0x1002897
#define CLUTTER_braille_dots_458 0x1002898
#define CLUTTER_braille_dots_1458 0x1002899
#define CLUTTER_braille_dots_2458 0x100289a
#define CLUTTER_braille_dots_12458 0x100289b
#define CLUTTER_braille_dots_3458 0x100289c
#define CLUTTER_braille_dots_13458 0x100289d
#define CLUTTER_braille_dots_23458 0x100289e
#define CLUTTER_braille_dots_123458 0x100289f
#define CLUTTER_braille_dots_68 0x10028a0
#define CLUTTER_braille_dots_168 0x10028a1
#define CLUTTER_braille_dots_268 0x10028a2
#define CLUTTER_braille_dots_1268 0x10028a3
#define CLUTTER_braille_dots_368 0x10028a4
#define CLUTTER_braille_dots_1368 0x10028a5
#define CLUTTER_braille_dots_2368 0x10028a6
#define CLUTTER_braille_dots_12368 0x10028a7
#define CLUTTER_braille_dots_468 0x10028a8
#define CLUTTER_braille_dots_1468 0x10028a9
#define CLUTTER_braille_dots_2468 0x10028aa
#define CLUTTER_braille_dots_12468 0x10028ab
#define CLUTTER_braille_dots_3468 0x10028ac
#define CLUTTER_braille_dots_13468 0x10028ad
#define CLUTTER_braille_dots_23468 0x10028ae
#define CLUTTER_braille_dots_123468 0x10028af
#define CLUTTER_braille_dots_568 0x10028b0
#define CLUTTER_braille_dots_1568 0x10028b1
#define CLUTTER_braille_dots_2568 0x10028b2
#define CLUTTER_braille_dots_12568 0x10028b3
#define CLUTTER_braille_dots_3568 0x10028b4
#define CLUTTER_braille_dots_13568 0x10028b5
#define CLUTTER_braille_dots_23568 0x10028b6
#define CLUTTER_braille_dots_123568 0x10028b7
#define CLUTTER_braille_dots_4568 0x10028b8
#define CLUTTER_braille_dots_14568 0x10028b9
#define CLUTTER_braille_dots_24568 0x10028ba
#define CLUTTER_braille_dots_124568 0x10028bb
#define CLUTTER_braille_dots_34568 0x10028bc
#define CLUTTER_braille_dots_134568 0x10028bd
#define CLUTTER_braille_dots_234568 0x10028be
#define CLUTTER_braille_dots_1234568 0x10028bf
#define CLUTTER_braille_dots_78 0x10028c0
#define CLUTTER_braille_dots_178 0x10028c1
#define CLUTTER_braille_dots_278 0x10028c2
#define CLUTTER_braille_dots_1278 0x10028c3
#define CLUTTER_braille_dots_378 0x10028c4
#define CLUTTER_braille_dots_1378 0x10028c5
#define CLUTTER_braille_dots_2378 0x10028c6
#define CLUTTER_braille_dots_12378 0x10028c7
#define CLUTTER_braille_dots_478 0x10028c8
#define CLUTTER_braille_dots_1478 0x10028c9
#define CLUTTER_braille_dots_2478 0x10028ca
#define CLUTTER_braille_dots_12478 0x10028cb
#define CLUTTER_braille_dots_3478 0x10028cc
#define CLUTTER_braille_dots_13478 0x10028cd
#define CLUTTER_braille_dots_23478 0x10028ce
#define CLUTTER_braille_dots_123478 0x10028cf
#define CLUTTER_braille_dots_578 0x10028d0
#define CLUTTER_braille_dots_1578 0x10028d1
#define CLUTTER_braille_dots_2578 0x10028d2
#define CLUTTER_braille_dots_12578 0x10028d3
#define CLUTTER_braille_dots_3578 0x10028d4
#define CLUTTER_braille_dots_13578 0x10028d5
#define CLUTTER_braille_dots_23578 0x10028d6
#define CLUTTER_braille_dots_123578 0x10028d7
#define CLUTTER_braille_dots_4578 0x10028d8
#define CLUTTER_braille_dots_14578 0x10028d9
#define CLUTTER_braille_dots_24578 0x10028da
#define CLUTTER_braille_dots_124578 0x10028db
#define CLUTTER_braille_dots_34578 0x10028dc
#define CLUTTER_braille_dots_134578 0x10028dd
#define CLUTTER_braille_dots_234578 0x10028de
#define CLUTTER_braille_dots_1234578 0x10028df
#define CLUTTER_braille_dots_678 0x10028e0
#define CLUTTER_braille_dots_1678 0x10028e1
#define CLUTTER_braille_dots_2678 0x10028e2
#define CLUTTER_braille_dots_12678 0x10028e3
#define CLUTTER_braille_dots_3678 0x10028e4
#define CLUTTER_braille_dots_13678 0x10028e5
#define CLUTTER_braille_dots_23678 0x10028e6
#define CLUTTER_braille_dots_123678 0x10028e7
#define CLUTTER_braille_dots_4678 0x10028e8
#define CLUTTER_braille_dots_14678 0x10028e9
#define CLUTTER_braille_dots_24678 0x10028ea
#define CLUTTER_braille_dots_124678 0x10028eb
#define CLUTTER_braille_dots_34678 0x10028ec
#define CLUTTER_braille_dots_134678 0x10028ed
#define CLUTTER_braille_dots_234678 0x10028ee
#define CLUTTER_braille_dots_1234678 0x10028ef
#define CLUTTER_braille_dots_5678 0x10028f0
#define CLUTTER_braille_dots_15678 0x10028f1
#define CLUTTER_braille_dots_25678 0x10028f2
#define CLUTTER_braille_dots_125678 0x10028f3
#define CLUTTER_braille_dots_35678 0x10028f4
#define CLUTTER_braille_dots_135678 0x10028f5
#define CLUTTER_braille_dots_235678 0x10028f6
#define CLUTTER_braille_dots_1235678 0x10028f7
#define CLUTTER_braille_dots_45678 0x10028f8
#define CLUTTER_braille_dots_145678 0x10028f9
#define CLUTTER_braille_dots_245678 0x10028fa
#define CLUTTER_braille_dots_1245678 0x10028fb
#define CLUTTER_braille_dots_345678 0x10028fc
#define CLUTTER_braille_dots_1345678 0x10028fd
#define CLUTTER_braille_dots_2345678 0x10028fe
#define CLUTTER_braille_dots_12345678 0x10028ff
#define CLUTTER_Sinh_ng 0x1000d82
#define CLUTTER_Sinh_h2 0x1000d83
#define CLUTTER_Sinh_a 0x1000d85
#define CLUTTER_Sinh_aa 0x1000d86
#define CLUTTER_Sinh_ae 0x1000d87
#define CLUTTER_Sinh_aee 0x1000d88
#define CLUTTER_Sinh_i 0x1000d89
#define CLUTTER_Sinh_ii 0x1000d8a
#define CLUTTER_Sinh_u 0x1000d8b
#define CLUTTER_Sinh_uu 0x1000d8c
#define CLUTTER_Sinh_ri 0x1000d8d
#define CLUTTER_Sinh_rii 0x1000d8e
#define CLUTTER_Sinh_lu 0x1000d8f
#define CLUTTER_Sinh_luu 0x1000d90
#define CLUTTER_Sinh_e 0x1000d91
#define CLUTTER_Sinh_ee 0x1000d92
#define CLUTTER_Sinh_ai 0x1000d93
#define CLUTTER_Sinh_o 0x1000d94
#define CLUTTER_Sinh_oo 0x1000d95
#define CLUTTER_Sinh_au 0x1000d96
#define CLUTTER_Sinh_ka 0x1000d9a
#define CLUTTER_Sinh_kha 0x1000d9b
#define CLUTTER_Sinh_ga 0x1000d9c
#define CLUTTER_Sinh_gha 0x1000d9d
#define CLUTTER_Sinh_ng2 0x1000d9e
#define CLUTTER_Sinh_nga 0x1000d9f
#define CLUTTER_Sinh_ca 0x1000da0
#define CLUTTER_Sinh_cha 0x1000da1
#define CLUTTER_Sinh_ja 0x1000da2
#define CLUTTER_Sinh_jha 0x1000da3
#define CLUTTER_Sinh_nya 0x1000da4
#define CLUTTER_Sinh_jnya 0x1000da5
#define CLUTTER_Sinh_nja 0x1000da6
#define CLUTTER_Sinh_tta 0x1000da7
#define CLUTTER_Sinh_ttha 0x1000da8
#define CLUTTER_Sinh_dda 0x1000da9
#define CLUTTER_Sinh_ddha 0x1000daa
#define CLUTTER_Sinh_nna 0x1000dab
#define CLUTTER_Sinh_ndda 0x1000dac
#define CLUTTER_Sinh_tha 0x1000dad
#define CLUTTER_Sinh_thha 0x1000dae
#define CLUTTER_Sinh_dha 0x1000daf
#define CLUTTER_Sinh_dhha 0x1000db0
#define CLUTTER_Sinh_na 0x1000db1
#define CLUTTER_Sinh_ndha 0x1000db3
#define CLUTTER_Sinh_pa 0x1000db4
#define CLUTTER_Sinh_pha 0x1000db5
#define CLUTTER_Sinh_ba 0x1000db6
#define CLUTTER_Sinh_bha 0x1000db7
#define CLUTTER_Sinh_ma 0x1000db8
#define CLUTTER_Sinh_mba 0x1000db9
#define CLUTTER_Sinh_ya 0x1000dba
#define CLUTTER_Sinh_ra 0x1000dbb
#define CLUTTER_Sinh_la 0x1000dbd
#define CLUTTER_Sinh_va 0x1000dc0
#define CLUTTER_Sinh_sha 0x1000dc1
#define CLUTTER_Sinh_ssha 0x1000dc2
#define CLUTTER_Sinh_sa 0x1000dc3
#define CLUTTER_Sinh_ha 0x1000dc4
#define CLUTTER_Sinh_lla 0x1000dc5
#define CLUTTER_Sinh_fa 0x1000dc6
#define CLUTTER_Sinh_al 0x1000dca
#define CLUTTER_Sinh_aa2 0x1000dcf
#define CLUTTER_Sinh_ae2 0x1000dd0
#define CLUTTER_Sinh_aee2 0x1000dd1
#define CLUTTER_Sinh_i2 0x1000dd2
#define CLUTTER_Sinh_ii2 0x1000dd3
#define CLUTTER_Sinh_u2 0x1000dd4
#define CLUTTER_Sinh_uu2 0x1000dd6
#define CLUTTER_Sinh_ru2 0x1000dd8
#define CLUTTER_Sinh_e2 0x1000dd9
#define CLUTTER_Sinh_ee2 0x1000dda
#define CLUTTER_Sinh_ai2 0x1000ddb
#define CLUTTER_Sinh_o2 0x1000ddc
#define CLUTTER_Sinh_oo2 0x1000ddd
#define CLUTTER_Sinh_au2 0x1000dde
#define CLUTTER_Sinh_lu2 0x1000ddf
#define CLUTTER_Sinh_ruu2 0x1000df2
#define CLUTTER_Sinh_luu2 0x1000df3
#define CLUTTER_Sinh_kunddaliya 0x1000df4
#define CLUTTER_ModeLock 0x1008ff01
#define CLUTTER_MonBrightnessUp 0x1008ff02
#define CLUTTER_MonBrightnessDown 0x1008ff03
#define CLUTTER_KbdLightOnOff 0x1008ff04
#define CLUTTER_KbdBrightnessUp 0x1008ff05
#define CLUTTER_KbdBrightnessDown 0x1008ff06
#define CLUTTER_Standby 0x1008ff10
#define CLUTTER_AudioLowerVolume 0x1008ff11
#define CLUTTER_AudioMute 0x1008ff12
#define CLUTTER_AudioRaiseVolume 0x1008ff13
#define CLUTTER_AudioPlay 0x1008ff14
#define CLUTTER_AudioStop 0x1008ff15
#define CLUTTER_AudioPrev 0x1008ff16
#define CLUTTER_AudioNext 0x1008ff17
#define CLUTTER_HomePage 0x1008ff18
#define CLUTTER_Mail 0x1008ff19
#define CLUTTER_Start 0x1008ff1a
#define CLUTTER_Search 0x1008ff1b
#define CLUTTER_AudioRecord 0x1008ff1c
#define CLUTTER_Calculator 0x1008ff1d
#define CLUTTER_Memo 0x1008ff1e
#define CLUTTER_ToDoList 0x1008ff1f
#define CLUTTER_Calendar 0x1008ff20
#define CLUTTER_PowerDown 0x1008ff21
#define CLUTTER_ContrastAdjust 0x1008ff22
#define CLUTTER_RockerUp 0x1008ff23
#define CLUTTER_RockerDown 0x1008ff24
#define CLUTTER_RockerEnter 0x1008ff25
#define CLUTTER_Back 0x1008ff26
#define CLUTTER_Forward 0x1008ff27
#define CLUTTER_Stop 0x1008ff28
#define CLUTTER_Refresh 0x1008ff29
#define CLUTTER_PowerOff 0x1008ff2a
#define CLUTTER_WakeUp 0x1008ff2b
#define CLUTTER_Eject 0x1008ff2c
#define CLUTTER_ScreenSaver 0x1008ff2d
#define CLUTTER_WWW 0x1008ff2e
#define CLUTTER_Sleep 0x1008ff2f
#define CLUTTER_Favorites 0x1008ff30
#define CLUTTER_AudioPause 0x1008ff31
#define CLUTTER_AudioMedia 0x1008ff32
#define CLUTTER_MyComputer 0x1008ff33
#define CLUTTER_VendorHome 0x1008ff34
#define CLUTTER_LightBulb 0x1008ff35
#define CLUTTER_Shop 0x1008ff36
#define CLUTTER_History 0x1008ff37
#define CLUTTER_OpenURL 0x1008ff38
#define CLUTTER_AddFavorite 0x1008ff39
#define CLUTTER_HotLinks 0x1008ff3a
#define CLUTTER_BrightnessAdjust 0x1008ff3b
#define CLUTTER_Finance 0x1008ff3c
#define CLUTTER_Community 0x1008ff3d
#define CLUTTER_AudioRewind 0x1008ff3e
#define CLUTTER_BackForward 0x1008ff3f
#define CLUTTER_Launch0 0x1008ff40
#define CLUTTER_Launch1 0x1008ff41
#define CLUTTER_Launch2 0x1008ff42
#define CLUTTER_Launch3 0x1008ff43
#define CLUTTER_Launch4 0x1008ff44
#define CLUTTER_Launch5 0x1008ff45
#define CLUTTER_Launch6 0x1008ff46
#define CLUTTER_Launch7 0x1008ff47
#define CLUTTER_Launch8 0x1008ff48
#define CLUTTER_Launch9 0x1008ff49
#define CLUTTER_LaunchA 0x1008ff4a
#define CLUTTER_LaunchB 0x1008ff4b
#define CLUTTER_LaunchC 0x1008ff4c
#define CLUTTER_LaunchD 0x1008ff4d
#define CLUTTER_LaunchE 0x1008ff4e
#define CLUTTER_LaunchF 0x1008ff4f
#define CLUTTER_ApplicationLeft 0x1008ff50
#define CLUTTER_ApplicationRight 0x1008ff51
#define CLUTTER_Book 0x1008ff52
#define CLUTTER_CD 0x1008ff53
#define CLUTTER_WindowClear 0x1008ff55
#define CLUTTER_Close 0x1008ff56
#define CLUTTER_Copy 0x1008ff57
#define CLUTTER_Cut 0x1008ff58
#define CLUTTER_Display 0x1008ff59
#define CLUTTER_DOS 0x1008ff5a
#define CLUTTER_Documents 0x1008ff5b
#define CLUTTER_Excel 0x1008ff5c
#define CLUTTER_Explorer 0x1008ff5d
#define CLUTTER_Game 0x1008ff5e
#define CLUTTER_Go 0x1008ff5f
#define CLUTTER_iTouch 0x1008ff60
#define CLUTTER_LogOff 0x1008ff61
#define CLUTTER_Market 0x1008ff62
#define CLUTTER_Meeting 0x1008ff63
#define CLUTTER_MenuKB 0x1008ff65
#define CLUTTER_MenuPB 0x1008ff66
#define CLUTTER_MySites 0x1008ff67
#define CLUTTER_New 0x1008ff68
#define CLUTTER_News 0x1008ff69
#define CLUTTER_OfficeHome 0x1008ff6a
#define CLUTTER_Open 0x1008ff6b
#define CLUTTER_Option 0x1008ff6c
#define CLUTTER_Paste 0x1008ff6d
#define CLUTTER_Phone 0x1008ff6e
#define CLUTTER_Reply 0x1008ff72
#define CLUTTER_Reload 0x1008ff73
#define CLUTTER_RotateWindows 0x1008ff74
#define CLUTTER_RotationPB 0x1008ff75
#define CLUTTER_RotationKB 0x1008ff76
#define CLUTTER_Save 0x1008ff77
#define CLUTTER_ScrollUp 0x1008ff78
#define CLUTTER_ScrollDown 0x1008ff79
#define CLUTTER_ScrollClick 0x1008ff7a
#define CLUTTER_Send 0x1008ff7b
#define CLUTTER_Spell 0x1008ff7c
#define CLUTTER_SplitScreen 0x1008ff7d
#define CLUTTER_Support 0x1008ff7e
#define CLUTTER_TaskPane 0x1008ff7f
#define CLUTTER_Terminal 0x1008ff80
#define CLUTTER_Tools 0x1008ff81
#define CLUTTER_Travel 0x1008ff82
#define CLUTTER_UserPB 0x1008ff84
#define CLUTTER_User1KB 0x1008ff85
#define CLUTTER_User2KB 0x1008ff86
#define CLUTTER_Video 0x1008ff87
#define CLUTTER_WheelButton 0x1008ff88
#define CLUTTER_Word 0x1008ff89
#define CLUTTER_Xfer 0x1008ff8a
#define CLUTTER_ZoomIn 0x1008ff8b
#define CLUTTER_ZoomOut 0x1008ff8c
#define CLUTTER_Away 0x1008ff8d
#define CLUTTER_Messenger 0x1008ff8e
#define CLUTTER_WebCam 0x1008ff8f
#define CLUTTER_MailForward 0x1008ff90
#define CLUTTER_Pictures 0x1008ff91
#define CLUTTER_Music 0x1008ff92
#define CLUTTER_Battery 0x1008ff93
#define CLUTTER_Bluetooth 0x1008ff94
#define CLUTTER_WLAN 0x1008ff95
#define CLUTTER_UWB 0x1008ff96
#define CLUTTER_AudioForward 0x1008ff97
#define CLUTTER_AudioRepeat 0x1008ff98
#define CLUTTER_AudioRandomPlay 0x1008ff99
#define CLUTTER_Subtitle 0x1008ff9a
#define CLUTTER_AudioCycleTrack 0x1008ff9b
#define CLUTTER_CycleAngle 0x1008ff9c
#define CLUTTER_FrameBack 0x1008ff9d
#define CLUTTER_FrameForward 0x1008ff9e
#define CLUTTER_Time 0x1008ff9f
#define CLUTTER_SelectButton 0x1008ffa0
#define CLUTTER_View 0x1008ffa1
#define CLUTTER_TopMenu 0x1008ffa2
#define CLUTTER_Red 0x1008ffa3
#define CLUTTER_Green 0x1008ffa4
#define CLUTTER_Yellow 0x1008ffa5
#define CLUTTER_Blue 0x1008ffa6
#define CLUTTER_Suspend 0x1008ffa7
#define CLUTTER_Hibernate 0x1008ffa8
#define CLUTTER_TouchpadToggle 0x1008ffa9
#define CLUTTER_TouchpadOn 0x1008ffb0
#define CLUTTER_TouchpadOff 0x1008ffb1
#define CLUTTER_Switch_VT_1 0x1008fe01
#define CLUTTER_Switch_VT_2 0x1008fe02
#define CLUTTER_Switch_VT_3 0x1008fe03
#define CLUTTER_Switch_VT_4 0x1008fe04
#define CLUTTER_Switch_VT_5 0x1008fe05
#define CLUTTER_Switch_VT_6 0x1008fe06
#define CLUTTER_Switch_VT_7 0x1008fe07
#define CLUTTER_Switch_VT_8 0x1008fe08
#define CLUTTER_Switch_VT_9 0x1008fe09
#define CLUTTER_Switch_VT_10 0x1008fe0a
#define CLUTTER_Switch_VT_11 0x1008fe0b
#define CLUTTER_Switch_VT_12 0x1008fe0c
#define CLUTTER_Ungrab 0x1008fe20
#define CLUTTER_ClearGrab 0x1008fe21
#define CLUTTER_Next_VMode 0x1008fe22
#define CLUTTER_Prev_VMode 0x1008fe23
#define CLUTTER_LogWindowTree 0x1008fe24
#define CLUTTER_LogGrabInfo 0x1008fe25

#endif /* CLUTTER_DISABLE_DEPRECATED */

#endif /* __CLUTTER_KEYSYMS_DEPRECATED_H__ */
