/*
 * Author: Andrei Zavada <johnhommer@gmail.com>
 *
 * License: GPL-2+
 *
 * Initial version: 2008-11-04
 *
 * CNModel runner
 */

#ifndef CN_RUNNER_H
#define CN_RUNNER_H

#include <vector>
#include <list>
#include <iostream>

#include "libstilton/log-facility.hh"
#include "libstilton/exprparser.hh"

#include "libcn/model.hh"
#include "libcn/sources.hh"

using namespace CNRun;
using namespace Stilton;

enum {
	CN_INTRP_STRICT,
	CN_INTRP_LOOSE
};

struct SCNRunnerOptions {
	bool	listen_1varonly:1,
		listen_deferwrite:1,
		listen_binary:1,
		dump_params:1,
		list_units:1,
		sort_units:1,
		log_dt:1,
		log_spikers:1,
		log_spikers_use_serial_id:1,
		log_sdf:1,
		display_progress_percent:1,
		display_progress_time:1,
		dont_coalesce:1;
	const char *working_dir;
	unsigned precision;
	float	spike_threshold,
		spike_lapse,
		listen_dt;
	double	//discrete_dt,
		integration_dt_max,
		integration_dt_min,
		integration_dt_max_cap;
	float	sxf_start_delay,
		sxf_sample,
		sdf_sigma;
	int	interp_howstrict,
		verbosely;

	SCNRunnerOptions()
	      : listen_1varonly (true), listen_deferwrite (false), listen_binary (false),
		dump_params(false), list_units (false),
		sort_units (false),
		log_dt (false),
		log_spikers (false), log_spikers_use_serial_id (false),
		log_sdf (false),
		display_progress_percent (true),
		display_progress_time (false),
		dont_coalesce (false),
		working_dir ("."),
		precision (8),
		spike_threshold (0.), spike_lapse (3.),
		listen_dt(1.),
		//discrete_dt(.5),
		integration_dt_max (.5), integration_dt_min (1e-5), integration_dt_max_cap (5.),
		sxf_start_delay (0.), sxf_sample (0.), sdf_sigma (0.),
		interp_howstrict (CN_INTRP_LOOSE),
		verbosely (1)
		{}
};

#define CNRUN_DEFAULT_SCRIPT "./Default.cnsh"

extern SCNRunnerOptions Options;

extern Stilton::CLogFacility *Log;



extern CModel *Model;

int interpreter_run( const char *script_fname, int level, int howstrict,
		     bool env_import, bool env_export, list<SVariable> &varlist);


enum {
	CNCMD__noop = -1,
	CNCMD_new_model = 0,
	CNCMD_load_nml,
	CNCMD_merge_nml,
	CNCMD_add_neuron,
	CNCMD_add_synapse,
	CNCMD_reset,
	CNCMD_reset_revert_params,
	CNCMD_reset_state_units,
	CNCMD_advance_until,
	CNCMD_advance,
	CNCMD_putout,
	CNCMD_decimate,
	CNCMD_start_listen,
	CNCMD_stop_listen,
	CNCMD_listen_dt,
	CNCMD_listen_mode,
	CNCMD_integration_dt_min,
	CNCMD_integration_dt_max,
	CNCMD_integration_dt_cap,
	CNCMD_start_log_spikes,
	CNCMD_stop_log_spikes,
	CNCMD_set_sxf_params,
	CNCMD_new_source,
	CNCMD_show_sources,
	CNCMD_connect_source,
	CNCMD_disconnect_source,
	CNCMD_set_parm_neuron,
	CNCMD_set_parm_synapse,
	CNCMD_cull_deaf_synapses,
	CNCMD_describe_model,
	CNCMD_show_units,
	CNCMD_exec,
	CNCMD_verbosity,
	CNCMD_show_vars,
	CNCMD_clear_vars,
	CNCMD_pause,
	CNCMD_exit
};

extern const char* const cnrun_cmd[];

extern bool regenerate_unit_labels;
extern bool regenerate_var_names;
extern bool regenerate_source_ids;

char** cnrun_completion( const char *text, int start, int end);


extern list<SVariable> *current_shell_variables;

#endif

// EOF
