s1tony.CM.showCookieExceptions =
{
    _siteCookiesWindow: "chrome://cookiemonster/content/siteCookies_ff36.xul",
	    
    init: function()
    {
        // Check if this version of FF contains add-on bar
		if (document.getElementById("addon-bar"))
		{
			this._siteCookiesWindow = "chrome://cookiemonster/content/siteCookies.xul";
		}  
    },
    
    onMenuItemCommand: function(evt)
    {
        var bundlePreferences = document.getElementById("cookie-preferences");
        var windowAddress = "chrome://browser/content/preferences/permissions.xul";
        var windowName = "cookieMonster_ShowExceptions";
        var params =
        {
            blockVisible   : true,
            sessionVisible : true,
            allowVisible   : true,
            prefilledHost  : "",
            permissionType : "cookie",
            windowTitle    : bundlePreferences.getString("cookiepermissionstitle"),
            introText      : bundlePreferences.getString("cookiepermissionstext")
        };

        if (evt.target.id == 'show-cookies' || evt.target.id == 'show-cookies-site')
        {
        	//windowAddress = "chrome://browser/content/preferences/cookies.xul";
        	windowAddress = this._siteCookiesWindow;
        	windowName = "cookieMonster_ShowCookies";
        	params = {filterString : "", showSearch: true};
        	
        	if (evt.target.id == 'show-cookies-site')
        	{
        		//windowAddress = "chrome://cookiemonster/content/siteCookies.xul";
        		var currentDomain = document.getElementById(evt.target.id);
        		params = {filterString : currentDomain.getAttribute("name"), showSearch: false};
        	}
        }

        var cookieWindow = window.openDialog(windowAddress, windowName, "chrome=yes,close=yes", params);
    }
};

s1tony.CM.showOverrideGlobal =
{
	// Callback method for overrideGlobal window
	// to add, delete or delete all URI hosts
	// from preference list
	overrideListChange: function(aHost, aListType)
	{
		var domainType = s1tony.CM.cookieMonster.extGetCurrentDomainType();
		
		//alert("Callback Host: " + aHost + "  ListType: " + aListType);
		
        switch (aListType)
        {
            case 0: // Add
                s1tony.CM.cookieInfo.addOverrideGlobal(aHost, domainType);
                break;
            case 1: // Delete
                s1tony.CM.cookieInfo.removeOverrideGlobal(aHost, domainType);
                break;
            case 2: // Delete All and reload page
                s1tony.CM.cookieInfo.removeAllOverrideGlobal();
                break;
            default:
                break;
        }
        
        // If aHost is the current host or if remove all, reload page
        if ((aHost != null) && (s1tony.CM.cookieMonster.extGetCurrentHost() == aHost))
        {
        	s1tony.CM.cookieMonster.extReloadCurrentPage();
        }
	},
	
    onMenuItemCommand: function(evt)
    {
        var bundlePreferences = document.getElementById("cookie-preferences");
        var windowAddress = "chrome://cookiemonster/content/overrideGlobal.xul";
        var windowName = "cookieMonster_ShowOverride";
        var params =
        {
            prefilledHost  : s1tony.CM.cookieMonster.extGetCurrentHost(),
            //aURI		   : cookieMonster.extGetCurrentURI(),
            //windowTitle    : bundlePreferences.getString("cookiepermissionstitle"),
            //introText      : bundlePreferences.getString("cookiepermissionstext"),
            globalOverrideList: s1tony.CM.cookieInfo.getGlobalOverrideList()
        };

        var cookieWindow = window.openDialog(windowAddress, windowName, "modal=yes,chrome=yes,close=yes", params, this.overrideListChange);
    }
};

s1tony.CM.deleteCookies =
{
    onMenuItemCommand: function(evt)
    {
        var menuBundle = document.getElementById("cookie-menu-labels");
    	var currentHost = null;
    	var result = true;
    	
    	if (evt.target.id == 'delete-cookies-site')
    	{
    		currentHost = s1tony.CM.cookieMonster.extGetCurrentHost();
  			
  			// Display confirmation dialog, unless turned off in Options
  			if (!s1tony.CM.nsPreferences.getBoolPref("disabledeletecookieconfirm", false))
  			{
				var prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
				                        .getService(Components.interfaces.nsIPromptService);
				result = prompts.confirm(null, menuBundle.getString("confirmtitle"),
											menuBundle.getFormattedString("confirmtext", [currentHost]));  				
  			}
  			
  			if (result)
  			{
  				s1tony.CM.cookieInfo.deleteHostCookies(currentHost, true);  				
  			}

  			//alert("Cookies Deleted for " + currentHost);
    	}
    }
};

s1tony.CM.showCookiesMenu = 
{
    _popupset: null,
	    
    init: function()
    {
    	// Retrieve original parent node for cookie monster menu
    	this._popupset = document.getElementById("cookiemonster-menu").parentNode;
    	
    	// Set whether or not keyboard shortcut is enabled based on user's preference
    	document.getElementById("cookiemonster-key").setAttribute("disabled", !s1tony.CM.nsPreferences.getBoolPref("enablekeyboardshortcut", true));
    },

    onMenuItemCommand: function(evt)
    {   
    	if (evt.target.id == 'contentAreaContextMenu')
    	{			
    		// Make cookie monster menu item visible in context menu and add
    		// the cookie-access menu popup
    		var menuItem = document.getElementById("cookiemonster-context");
    		var cookieMenu = document.getElementById("cookiemonster-menu");
	        
	        // Only show the context menu if enablecontextmenu is set to true
	        if (s1tony.CM.nsPreferences.getBoolPref("enablecontextmenu", false))
	        {
	    		if (evt.type == 'popupshown')
	    		{
	  				menuItem.hidden = false;
	  				menuItem.setAttribute("image", s1tony.CM.cookieMonsterButton.getIcon());
	  				cookieMenu.setAttribute("position", "end_before");
	  				menuItem.appendChild(cookieMenu);
	    		}
	    		else if (evt.type == 'popuphidden')
	    		{
	   				menuItem.hidden = true;
	  				cookieMenu.setAttribute("position", "before_end");
  					this._popupset.appendChild(cookieMenu);
				}        	
	        }
    	}
    },
    
    onKeyboardShortcut: function(evt)
    {
    	if (evt.target.id == 'cookiemonster-key')
    	{			    		
    		// Check if cookiemonster-menu popup is showing and hide
    		var cookieMenu = document.getElementById("cookiemonster-menu");

    		if (cookieMenu.state == 'open')
    		{
    			cookieMenu.hidePopup();
    		}
    		
    		cookieMenu.openPopup(null, "", 0, 0, false, false);
    	}    	
    }
}

//window.addEventListener("load", function(e) { s1tony.CM.showCookieExceptions.onLoad(e); },
//false);
