#!/usr/local/bin/php-cgi
<?php
/*
 * Copyright (c) 2003-2011
 * Distributed Systems Software.  All rights reserved.
 * See the file LICENSE for redistribution information.
 *
 * $Id: demo_fill_claims.php 2529 2011-09-23 22:19:51Z brachman $
 */

/*
 * This is a prototype implementation of the callback web service for
 * dacs_sts.  Its purpose is to return the claim values requested by the
 * caller.  Internal DACS admin credentials are sent for authorization.
 *
 * Arguments:
 *   CARD_ID:           unique ID assigned to the new InfoCard
 *   CARD_VERSION:      version number assigned to the new InfoCard
 *   DACS_JURISDICTION: name of jurisdiction acting as IP/STS
 *   DACS_FEDERATION:   DACS_JURISDICTION is in this federation
 *   CLAIMS:            a space-separated list of requested claim names
 *
 * Each claim has the format <TYPE>:<NAME>
 * <TYPE> is the word "standard" or "dacs", or a URI (the URI is not
 * dereferenced); this establishes a namespace for <NAME> - "standard"
 * and "dacs" are just short, convenient identifiers for URIs
 * <NAME> is a unique (relative to <TYPE>) name for this claim
 * consisting of alphanumerics and underscores (not beginning with a
 * digit)
 * <LABEL> is a short (fewer than 15 chars) descriptive blurb that the
 * Identity Selector will display to identify the claim
 * (the ic:DisplayTag element in the InfoCard)
 *
 * At minimum, this program needs to do two things:
 * 0) Retrieve the mapping from CARD_ID to DACS_IDENTITY
 * 1) Emit the values of the requested claims
 *
 * Output is an XML document:
 * <!ELEMENT claim_values (claim_value)*>
 * <!ATTLIST claim_values
 *   card_error   CDATA   #IMPLIED
 * >
 * <!ELEMENT claim_value EMPTY>
 * <!ATTLIST claim_value
 *   type         CDATA   #REQUIRED
 *   name         CDATA   #REQUIRED
 *   label        CDATA   #REQUIRED
 *   value        CDATA   #REQUIRED
 * >
 *
 * If an error occurs, the card_error attribute must be present and
 * its value can be an error message.
 *
 * A "dacs" namespace claim is required for DACS authentication:
 * dacs_identity (e.g., "TEST::EXAMPLE:bob").
 *
 * Note that this must not return a value for the PPID claim because it is
 * handled specially within the IP/STS.
 */

/*
 * Configuration - change as desired
 */
$dbfile = "/tmp/defs.db";
$debugfile = "/tmp/defs.log";

/* Set non-zero to enable logging debug info */
$debug = 0;

$db = FALSE;
$fp = FALSE;

function fatal($errmsg)
{

  print "<?xml version='1.0' encoding='US-ASCII'?>\n";
  print "<claim_values card_error='" . $errmsg . "'>\n";
  print "</claim_values>\n";

  if ($fp != FALSE) {
    fclose($fp);
  }

  if ($db != FALSE) {
    dba_close($db);
  }

  exit(0);
}

Header('Content-Type: text/xml');

$card_id = $_POST['CARD_ID'];
$card_version = $_POST['CARD_VERSION'];
$jurisdiction_name = $_POST['DACS_JURISDICTION'];
$federation_name = $_POST['DACS_FEDERATION'];
$claims_list = $_POST['CLAIMS'];
$claims = split(" ", $claims_list);

if ($debug) {
  if (!($fp = fopen($debugfile, 'a+'))) {
      return;
  }
  fprintf($fp, "CLAIMS=$claims_list\n");
  fprintf($fp, "CARD_ID=$card_id\n");
  fprintf($fp, "CARD_VERSION=$card_version\n");
  fprintf($fp, "DACS_JURISDICTION=$jurisdiction_name\n");
  fprintf($fp, "DACS_FEDERATION=$federation_name\n");
  fclose($fp);
}

$db = dba_open($dbfile, "rd", "db4");
if ($db == FALSE) {
  fatal("Cannot open database");
}

/* Map the CardId to the DACS identity.  */
if (($identity = dba_fetch($card_id, $db)) == FALSE) {
    fatal("Cannot fetch existing record for $card_id");
}

/* Extract the DACS username.  */
// list($fed, $junk, $jur, $uname) = split(":", $identity, 4);

dba_close($db);

/* Emit the requested claim values */
print "<?xml version='1.0' encoding='US-ASCII'?>\n";
print "<claim_values>\n";
print "<claim_value type='dacs' name='dacs_identity' label='DACS Identity' value='" . $identity . "' />\n";
print "</claim_values>\n";

exit(0);
?>
