DACS_UPROXY(8)             DACS Web Services Manual             DACS_UPROXY(8)



[1mNAME[0m
       dacs_uproxy - minimal HTTP proxying

[1mSYNOPSIS[0m
       [1mdacs_uproxy [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This web service is part of the [1mDACS [22msuite.

       The [1mdacs_uproxy [22mweb service accepts an incoming HTTP request (the
       initial request), then reissues a nearly identical HTTP request to a
       different URL (the proxied request) and returns its unaltered response.
       The initial request must use either the GET or POST HTTP method; the
       proxied request will use the same method as the initial request. Note
       that the origin server (the web server that receives the proxied
       request) will see a request that originates at the host that runs
       [1mdacs_uproxy[22m, not the host that issues the initial request.

       When run on a firewall host, the program can be useful for forwarding
       incoming requests to interior hosts. An origin server does not need to
       be running [1mDACS[22m. All access control is performed by the jurisdiction
       that runs [1mdacs_uproxy[22m. Similarly, the program can be useful for
       forwarding requests that originate behind the firewall, subject to
       access control permission.

       [1mdacs_uproxy [22mis not a transparent proxy server. A request URL must be
       explicitly addressed to it and include a (partial) name for the target
       resource.

           [1mSecurity[0m
           The program must be configured with care because it can expose
           otherwise inaccessible hosts to arbitrary HTTP requests from any
           source that can connect to [1mdacs_uproxy[22m.

           Particular care must be taken if a program that is invoked by
           [1mdacs_uproxy [22mgenerates a redirect that may be handled internally by
           the program's web server. In this event the new request arising
           from the redirection [4mwill[24m [4mnot[24m [4mautomatically[24m [4mbe[24m [4msubjected[24m [4mto[24m [4maccess[0m
           [4mcontrol[24m because the new request does come through [1mdacs_uproxy[22m.
           Therefore, local redirects must be avoided by proxied web services,
           resources that might be invoked through a local redirect must be
           publicly accessible, or authorization checking must somehow be
           arranged for these resources.

           Access control rules are primarily responsible for expressing
           restrictions on what can be proxied and who can use this service.
           By default, all access to this service is denied. Additionally,
           [34m[1mUPROXY_APPROVED[0m[1m[22m[2] directives must be configured to allow proxying
           to specific origin servers.

           Although in its current form the program has the effect of
           anonymizing the proxied request, this is more of a bug than a
           feature. Future versions may forward an initial request's headers
           and other information.

       With the exception of the Cookie header, most request headers that
       accompany the initial request are sent with the proxied request.
       [1mdacs_uproxy [22mmakes no attempt to "impersonate" the user's host, however.
       Therefore, to the origin server it appears as if the request is coming
       from [1mdacs_uproxy [22mand the IP address from which the forwarded request is
       sent. Any cookies sent with the initial request are interpreted by
       [1mdacs_uproxy [22m(e.g., to identify the user making the request for access
       control purposes). At present, it is not possible to forward cookies
       with the proxied request.

       So that the proxied web service can tell that it is being invoked by
       [1mdacs_uproxy[22m, an extension header named DACS-Uproxy-Via is included with
       the forwarded request. Its value is the URL of [1mdacs_uproxy [22mwith the
       proxied host appended. With Apache, its value can be accessed from the
       environment variable [1mHTTP_DACS_UPROXY_VIA[22m.

       If [1mdacs_uproxy [22mis passed a [34m[1mDACS_APPROVAL[0m[1m[22m[3] value, that value is
       forwarded with the request through the DACS-Uproxy-Approval header and
       made available by Apache in the [1mHTTP_DACS_UPROXY_APPROVAL [22menvironment
       variable. A program invoked indirectly through [1mdacs_uproxy [22mcan use this
       information to confirm that [1mDACS [22mauthorized the request.

       If the forwarded request generates a redirect (a 3xx class HTTP status
       code is returned), it causes [1mdacs_uproxy [22mto return the redirection
       request.

       The program is a minimal or "micro" HTTP proxy, hence the [4mu[24m in
       [1mdacs_uproxy [22mshould really be the Greek letter [4mmu[24m.

   [1mWeb Service Arguments[0m
       With some exceptions, all arguments passed to [1mdacs_uproxy [22mare forwarded
       to the proxied request and are not interpreted by [1mdacs_uproxy[22m. The
       first exception is [34m[1mDACS_ACS[0m[1m[22m[4]. Another exception is [4mDACS_UPROXY[24m; if
       its value is DEBUG, debugging output is produced. Neither of these
       arguments is forwarded with the proxied request.

   [1mOperation[0m
       A specification of the proxied request appears as a component of the
       initial request. It is best to explain this with an example. Let us
       assume that the URL for the [1mdacs_uproxy [22mthat the client wants to use is
       https://example.com/cgi-bin/dacs/dacs_uproxy. Let us also assume that
       the client wants to access a web service at foo.example.com (the
       proxied host) and that this web service can be invoked from example.com
       (the proxying host) as https://foo.example.com/cgi-bin/some_app. To
       achieve this, the client would invoke this URL:

           https://example.com/cgi-bin/dacs/dacs_uproxy/foo.example.com/cgi-bin/some_app

       Note that no scheme is included with the name of the proxied host. A
       port number may follow it, however, and any path components that follow
       are appended (after the mapping specified by UPROXY_APPROVED) to form
       the final proxied URL.

       For this example to be authorized, an access control rule must grant
       the user access to the initial URL. Whether there is additional access
       control enforced at the proxied host is the responsibility of a web
       administrator. A simple rule that grants access to any authenticated
       user looks like this:

           <acl_rule status="enabled">
             <services>
               <service url_expr='"${Conf::dacs_cgi_bin_prefix}/dacs_uproxy"'/>
               <service url_expr='"${Conf::dacs_cgi_bin_prefix}/dacs_uproxy/*"'/>
             </services>

             <rule order="allow,deny">
              <allow>
                user("auth")
              </allow>
             </rule>
           </acl_rule>

       Most sophisticated rules may of course be used to further constrain how
       [1mdacs_uproxy [22mcan be used and by whom.

       The [34m[1mUPROXY_APPROVED[0m[1m[22m[2] directive must be configured before [1mdacs_uproxy[0m
       will do anything, even if otherwise permitted by an access control
       rule.

       If SSL is used for the proxied request, the usual [1mDACS [22mconfiguration
       directives for SSL apply - see [34m[1mdacs.conf(5)[0m[1m[22m[5]. SSL can be used for the
       proxied request independently of whether it is used for the initial
       request.

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mBUGS[0m
       The implementation may not yet fully conform to [34m[1mRFC 2616[0m[1m[22m[6].

[1mSEE ALSO[0m
       [34m[1mRFC 2616[0m[1m[22m[6]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[7])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[8] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. UPROXY_APPROVED
           http://dacs.dss.ca/man/dacs.conf.5.html#UPROXY_APPROVED

        3. DACS_APPROVAL
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_approval

        4. DACS_ACS
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_acs_argument

        5. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        6. RFC 2616
           http://www.rfc-editor.org/rfc/rfc2616.txt

        7. www.dss.ca
           http://www.dss.ca

        8. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012                    DACS_UPROXY(8)
