DACSAUTH(1)                  DACS Commands Manual                  DACSAUTH(1)



[1mNAME[0m
       dacsauth - authentication check

[1mSYNOPSIS[0m
       [1mdacsauth [22m[[1m-m [4m[22mauth-module-spec[24m] [...] [[1m-r [4m[22mroles-module-spec[24m] [...]
                        [[1m-D[4m[22mdirective[24m[1m=[4m[22mvalue[24m] [[1m-aux[22m]
                        [[1m-fj [4m[22mjurname[24m] [[1m-fn [4m[22mfedname[24m] [[1m-h [22m| [1m-help[22m] [[1m-id[22m]
                        [[1m-ll [4m[22mlog_level[24m] [[1m-p [4m[22mpassword[24m]
                        [[1m-pf [4m[22mfile[24m] [[1m-prompt[22m] [[1m-q[22m] [{[1m-u [22m| [1m-user[22m} [4musername[24m] [[1m-v[22m]
                        [1mdacsauth-modules[0m

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacsauth [22mutility tests whether given authentication material
       satisfies authentication requirements and indicates the outcome through
       the process's exit status. It is similar to [34m[1mdacs_authenticate(8)[0m[1m[22m[1] and
       [34m[1mdacscred(1)[0m[1m[22m[2].

       [1mdacsauth [22mprovides a way for scripts and other programs to leverage the
       [1mDACS [22mauthentication infrastructure. They might use successful
       authentication as a coarse form of authorization; only a user that
       provides a correct password might be allowed to run the program, for
       instance. Or they might return some type of credentials after
       successful authentication, or perhaps use [34m[1mdacs_auth_agent(8)[0m[1m[22m[3] to
       return [1mDACS [22mcredentials.

       [1mdacsauth [22mcan also be used to retrieve role information associated with
       a given user.

       [1mdacsauth [22mdoes not read any [1mDACS [22mconfiguration files. Everything needed
       to perform the test must be specified as an argument.

           [1mTip[0m
           If [1mdacsauth [22muses a built-in module to perform authentication, or
           look up roles, [4mno[24m [4mserver[24m [4mcomponent[24m [4mis[24m [4mrequired[24m. This means that you
           can use [1mdacsauth [22mwithout having to access or even configure a web
           server, including Apache.

[1mOPTIONS[0m
       The following command line flags are recognized. At least one [1m-m [22mflag
       (to perform authentication testing), or at least one [1m-r [22mflag must be
       specified (to form a role descriptor string for the identity and print
       it to stdout). A combination of both flags is allowed, in which case a
       role descriptor string is output only if the authentication test is
       successful.

       [1m-D[4m[22mdirective[24m[1m=[4m[22mvalue[0m
           This is equivalent to setting [4mdirective[24m, a general [1mDACS[0m
           configuration directive, to [4mvalue[24m. See [34m[1mdacs.conf(5)[0m[1m[22m[4].

       [1m-aux[0m
           The next string provided by the [1m-p[22m, [1m-pf[22m, or [1m-prompt [22mflag will be
           the value of the [4mAUXILIARY[24m authentication argument. This provides a
           secure way to pass sensitive auxiliary information, such as a PIN,
           to the program. A flag to obtain the password, if any, must precede
           this flag on the command line.

       [1m-fj [4m[22mjurname[0m
           Use [4mjurname[24m, which must be syntactically valid, as the jurisdiction
           name. If required but not provided, a value derived from the host's
           domain name will be used.

       [1m-fn [4m[22mfedname[0m
           Use [4mfedname[24m, which must be syntactically valid, as the federation
           name. If required but not provided, a value derived from the host's
           domain name will be used.

       [1m-h[0m
       [1m-help[0m
           Display a help message and exit.

       [1m-id[0m
           If successful, print the authenticated [1mDACS [22midentity to the
           standard output.

       [1m-ll [4m[22mlog_level[0m
           Set the debugging output level to [4mlog_level[24m (see [34m[1mdacs(1)[0m[1m[22m[5]). The
           default level is warn.

       [1m-m [4m[22mauth-module-spec[0m
           Each type of authentication test that is required is described by
           an [4mauth-module-spec[24m that immediately follows the [1m-m [22mflag. Each
           [4mauth-module-spec[24m is essentially an alternate representation of an
           [34m[1mAuth clause[0m[1m[22m[6] and its directives, which are used by
           [34m[1mdacs_authenticate(8)[0m[1m[22m[1]. Just as the order in which Auth clauses
           appear in a [1mDACS [22mconfiguration file, the order in which the [1m-m[0m
           flags appear may be significant, depending on the [4mcontrol[24m keywords.
           During processing, successive [1m-m [22mcomponents are automatically
           assigned names, auth_module_1, auth_module_2, and so on, mainly for
           error reporting purposes.

           An [4mauth-module-spec[24m has the following syntax:

           The [4mmodule[24m begins with either the name of a built-in module, or a
           valid abbreviation thereof, or the (absolute) URL of an external
           authentication module (equivalent to the [34m[1mURL[0m[1m[22m[7] directive). Next
           must appear a recognized authentication style keyword specifier
           (equivalent to the [34m[1mSTYLE[0m[1m[22m[8] directive). Next, the [4mcontrol[24m keyword
           follows, which is identical to the [34m[1mCONTROL[0m[1m[22m[9] directive in the Auth
           clause. After the [4mcontrol[24m keyword, the flags described below may
           follow, in any order.

           An [4mauth-module-spec[24m ends when the first invalid flag (or the end of
           flags) is encountered.

           The [1m-O [22mflag is equivalent to an [34m[1mOPTION[0m[1m[22m[10] directive.

           The [1m-Of [22mflag is followed by an argument that is the name of a file
           from which to read options, one per line, in the format [4mname[24m=[4mvalue[24m.
           Blank lines and lines beginning with a '#' are ignored; note that
           these lines do not begin with "-O" and quotes are simply copied and
           not interpreted. The [1m-Of [22mflag can be used to avoid putting
           passwords on the command line and makes it easier to write
           expressions that would otherwise have to be carefully escaped to
           prevent interpretation by the shell, for example.

           The [1m-expr [22mflag is equivalent to the [34m[1mEXPR[0m[1m[22m[11] directive. The [1m-vfs[0m
           flag is used to configure [34m[1mVFS[0m[1m[22m[12] directives required by this
           module.

       [1m-modules[0m
           Display a list of built-in authentication modules and roles
           modules, one per line, and then exit. The canonical module name is
           printed, followed by zero or more equivalent abbreviations. For
           authentication modules, the authentication style is shown. To list
           the available modules, run the command:


               % dacsauth -modules

           The set of available (enabled) built-in authentication and roles
           modules is determined when [1mDACS [22mis built.

       [1m-p [4m[22mpassword[0m
           Specify the password to use (equivalent to the [4mPASSWORD[24m argument to
           [1mdacs_authenticate[22m).

               [1mSecurity[0m
               A password given on the command line may be visible to other
               users on the same system.

       [1m-pf [4m[22mfile[0m
           Read the password to use from [4mfile[24m (equivalent to the [4mPASSWORD[0m
           argument to [1mdacs_authenticate[22m). If [4mfile[24m is "-", then the password
           is read from the standard input without prompting.

       [1m-prompt[0m
           Prompt for the password and read it from stdin (equivalent to the
           [4mPASSWORD[24m argument to [1mdacs_authenticate[22m). The password is not
           echoed.

       [1m-q[0m
           Be more quiet by reducing the debugging output level.

       [1m-r [4m[22mrole-module-spec[0m
           Roles for [4musername[24m can be determined by giving this flag, which is
           immediately followed by a [4mroles-module-spec[24m. The [1m-r [22mflag may be
           repeated, and the resulting roles are combined. Each
           [4mroles-module-spec[24m is essentially an alternate representation of a
           Roles clause that is used by [34m[1mdacs_authenticate(8)[0m[1m[22m[13]. Successive
           [1m-r [22mcomponents are assigned names, roles_module_1, roles_module_2,
           and so on, mainly for error reporting purposes.

           A [4mroles-module-spec[24m has the following syntax: The [4mmodule[24m component
           is equivalent to the Roles clause's [34m[1mURL[0m[1m[22m[14] directive and is either
           the name of an available built-in roles module, a valid
           abbreviation thereof, or the (absolute) URL of an external roles
           module.

           Flags may follow the [4mmodule[24m component, in any order. A
           [4mroles-module-spec[24m ends when the first invalid flag (or the end of
           flags) is encountered.

           The [1m-O [22mflag is equivalent to an [34m[1mOPTION[0m[1m[22m[10] directive.

           The [1m-Of [22mflag is followed by an argument that is the name of a file
           from which to read options, one per line, in the format [4mname[24m=[4mvalue[24m.
           Blank lines and lines beginning with a '#' are ignored; note that
           these lines do not begin with "-O" and quotes are simply copied and
           not interpreted. The [1m-Of [22mflag can be used to avoid putting
           passwords on the command line and makes it easier to write
           expressions that would otherwise have to be carefully escaped to
           prevent interpretation by the shell, for example.

           The [1m-expr [22mflag is equivalent to the [34m[1mEXPR[0m[1m[22m[11] directive. The [1m-vfs[0m
           flag is used to configure [34m[1mVFS[0m[1m[22m[12] directives required by [4mmodule[24m.

       [1m-u [4m[22musername[0m
       [1m-user [4m[22musername[0m
           The username to authenticate against (equivalent to the [4mUSERNAME[0m
           argument to [1mdacs_authenticate[22m). This username is implicitly
           associated with the effective federation and jurisdiction (see the
           [34m[1m-fn[0m[1m[22m[15] and [34m[1m-fj[0m[1m[22m[16] flags).

       [1m-v[0m
           The [1m-v [22mflag bumps the debugging output level to debug or (if
           repeated) trace.

[1mEXAMPLES[0m
           [1mSecurity[0m
           If [1mdacsauth [22muses a built-in module to perform authentication, it
           must run setuid or setgid to obtain sufficient privileges to access
           the required password file (the same is true for built-in roles
           modules). If it uses an external module, that module will need to
           execute with sufficient privileges to access [1mDACS [22mcryptographic
           keys, specifically federation_keys and possibly [1mDACS [22mor system
           password files; the external module will then need to execute with
           sufficient privileges to access any files it requires.

           Be sure to use the federation_keys that are correct for your
           federation. Referencing authentication modules in two or more
           federations will probably not work.

           [1mdacsauth [22mshould therefore not ordinarily run as the UID of the user
           that invokes it (unless that happens to be root) because it will
           not be able to access the information it requires. This will also
           prevent a user from "cheating" (e.g., by attaching to the running
           module with a debugger).

       This example authenticates user "bobo" with password "test" against the
       [1mDACS [22mpassword file /usr/local/dacs/conf/passwd:

           % dacsauth -m passwd passwd required
             -vfs "[passwds]dacs-kwv-fs:/usr/local/dacs/conf/passwd" -q -u bobo -p test

       If the command's exit status is zero, the authentication test
       succeeded, otherwise it failed.

       The following example attempts to authenticate "bobo" against her Unix
       password file. The program prompts for the password.

           % dacsauth -m unix passwd required -u bobo -prompt

       In the next example, [1mdacsauth [22mattempts to authenticate "bobo" via NTLM
       on winders.example.com:

           % dacsauth -m ntlm passwd suff -OSAMBA_SERVER="winders.example.com" -prompt -u bobo

       This example is similar to the previous one, except that an external
       authentication module is used and the password is read from a file.
       Because of the external module, additional configuration must be
       provided; in particular, the location of federation_keys and the
       federation and jurisdiction names must be specified.

           % dacsauth -m https://example.example.com/cgi-bin/dacs/local_ntlm_authenticate \
              passwd sufficient -OSAMBA_SERVER="winders.example.com" \
             -fn EXAMPLE -fj FEDROOT -u bobo -pf mypass \
             -DVFS="[federation_keys]dacs-fs:/usr/local/dacs/federations/example/federation_keys"

       To authenticate against the [34m[1mGoogle[0m[1m[22m[17](TM) account nobody@gmail.com,
       one might use:

           % dacsauth -m http passwd suff \
             -OAUTH_URL="https://www.google.com/accounts/ClientLogin" \
             -OUSERNAME_PARAMETER=Email -OPASSWORD_PARAMETER=Passwd \
             -Oservice=xapi -Osource=DSS-DACS-1.4 -prompt -u nobody@gmail.com

       In the following example, an expression is evaluated to determine
       whether authentication should succeed. The user ("bobo") is prompted
       for a password. Only if the string "foo" is given will authentication
       succeed. A more realistic example might call another program to help
       make the determination, for instance.

           % dacsauth -m expr expr suffi \
            -expr '${Args::PASSWORD} eq "foo" ? ${Args::USERNAME} : ""' -user bobo -prompt

       Authentication against an Apache [1mhtdigest [22mpassword file is performed in
       the following example, where the password is read from stdin:

           % echo "test" | dacsauth -m apache digest sufficient \
             -OAUTH_MODULE=mod_auth_digest \
             -OAUTH_FILE=/usr/local/apache2/conf/passwords.digest \
             -OAUTH_REALM="DACS Digest Auth Area" \
             -u bobo -pf -

       Authentication via the PAM module works differently than the other
       modules - and is more complicated to use - because [1mdacsauth [22mmay need to
       be run several times, depending on what information PAM requires.
       Instead of returning a yes/no decision, [1mdacsauth [22mmay print prompts for
       more information to stdout. Please review the operational details
       presented in [34m[1mdacs_authenticate(8)[0m[1m[22m[18] and [34m[1mpamd(8)[0m[1m[22m[19] before attempting
       to use this module.

       The following example demonstrates use of the module from the command
       line. Once the basic ideas are understood, it should be apparent how to
       write a script to performed the necessary iterations. Details in the
       example, such as paths, may need to be adjusted for your environment.
       Note that in this example the username is not specified the first time
       [1mdacsauth [22mis run, although it could be if it were known.

           % dacsauth -m pam prompted suffic \
            -vfs "[federation_keys]dacs-fs:/usr/local/dacs/federations/dss/federation_keys" \
            -OPAMD_HOST=localhost -OPAMD_PORT=dacs-pamd -fj EXAMPLE -fn TEST
           AUTH_PROMPT_VAR1="Login:"
           AUTH_TRANSID="10.0.0.124:57849:85748:9997c5588a6239e3"
           % dacsauth -m pam prompted suffic \
            -vfs "[federation_keys]dacs-fs:/usr/local/dacs/federations/dss/federation_keys" \
            -OAUTH_PROMPT_VAR1="bobo" \
            -OAUTH_TRANSID="10.0.0.124:57849:85748:9997c5588a6239e3"-fj EXAMPLE -fn TEST
           AUTH_PROMPT_VAR2="Password:"
           AUTH_TRANSID="10.0.0.124:52188:88417:5ffb0015f21ea546"
           % dacsauth -m pam prompted suffic \
            -vfs "[federation_keys]dacs-fs:/usr/local/dacs/federations/dss/federation_keys" \
            -OAUTH_PROMPT_VAR2="apassword" \
            -OAUTH_TRANSID="10.0.0.124:57849:85748:9997c5588a6239e3"-fj EXAMPLE -fn TEST

       The first time [1mdacsauth [22mis run in the example it returns a prompt for
       the username ("Login:") that is associated with the transaction
       variable [4mAUTH_PROMPT_VAR1[24m and a transaction identifier ([4mAUTH_TRANSID[24m).
       The latter must be passed to the subsequent executions of [1mdacsauth[22m. The
       second run of [1mdacsauth [22mpasses the username ("bobo") and returns another
       prompt ("Password:") that is associated with the transaction variable
       [4mAUTH_PROMPT_VAR2[24m. The third run passes the password ("apassword") but
       no prompt is returned, indicating that the session is complete and the
       program's exit status reflects the outcome of authentication.

           [1mTip[0m
           Whether [1mdacsauth [22mrequires a password to retrieve roles depends on
           the particular roles module being used. For example, a password is
           not required by [34m[1mlocal_unix_roles[0m[1m[22m[20] or [34m[1mlocal_roles[0m[1m[22m[21] to obtain
           roles, but [34m[1mlocal_ldap_roles[0m[1m[22m[22] will probably need a password to
           bind to the directory and obtain roles.

       This example prints the role string for user "bobo" by calling the
       built-in [34m[1mlocal_unix_roles[0m[1m[22m[20] module:

           % dacsauth -r unix -u bobo
           bobo,wheel,www,users

       The next example is similar to the previous one, except an external
       roles module is used:

           % dacsauth -r https://example.example.com/cgi-bin/dacs/local_unix_roles \
             -DVFS="[federation_keys]dacs-fs:/usr/local/dacs/federations/federation_keys" \
             -fn EXAMPLE -u bobo
           bobo,wheel,www,users

       The external roles module might be executed on a different host than
       the one running [1mdacsauth[22m. Provided [1mdacsauth [22mhas been installed and a
       matching federation_keys file is available on the local host, the local
       host need not be a [1mDACS [22mjurisdiction or have any other [1mDACS[0m
       configuration.

       The following example prints the [34m[1mrole string[0m[1m[22m[23] for user "bobo", known
       within the directory by the Common Name "Bobo Baggins", using the
       (external) [34m[1mlocal_ldap_roles[0m[1m[22m[22] module and the "direct" binding method:

           % dacsauth -r https://example.example.com/cgi-bin/dacs/local_ldap_roles \
               -Of /usr/local/dacs/ldap_roles_options_direct -u "Bobo Baggins" \
               -DVFS="[federation_keys]dacs-fs:/usr/local/dacs/federations/federation_keys" \
                -fn EXAMPLE -fj FEDROOT -prompt
           DnsAdmins,Print_Operators,Domain_Admins,Administrators

       Because there are too many flags to easily and correctly place on the
       command line, the options that are needed to do this are read from a
       file that is specified by the [1m-Of [22mflag. This also provides a more
       secure way to pass passwords to the program; ensure that access to the
       file is restricted appropriately. The file
       /usr/local/dacs/ldap_roles_options_direct might contain configuration
       such as this:

           LDAP_BIND_METHOD=direct
           LDAP_ADMIN_URL*="ldap://winders.example.com/CN=" . encode(url,${Args::DACS_USERNAME}) . ",CN=Users,DC=example,DC=com"

           LDAP_ROLES_SELECTOR*="${LDAP::attrname}" eq "memberOf" ? strtr(ldap(rdn_attrvalue, \
               ldap(dn_index, "${LDAP::attrvalue}", 1)), " ", "_") : ""

       The following example is like the previous one, except that it uses the
       "indirect" binding method and therefore does not need to be given the
       user's Common Name:

           % dacsauth -r https://example.example.com/cgi-bin/dacs/local_ldap_roles \
               -Of /usr/local/dacs/ldap_roles_options_indirect -u bobo \
               -DVFS="[federation_keys]dacs-fs:/usr/local/dacs/federations/federation_keys" \
                -fn EXAMPLE -fj FEDROOT -p bobospassword
           DnsAdmins,Print_Operators,Domain_Admins,Administrators

       The file /usr/local/dacs/ldap_roles_options_indirect might contain
       configuration such as this:

           LDAP_BIND_METHOD=indirect
           LDAP_ADMIN_URL=ldap://winders.example.com/CN=Administrator,CN=Users,DC=example,DC=com

           # Search under Users...
           LDAP_SEARCH_ROOT_DN=CN=Users,DC=example,DC=com

           LDAP_ADMIN_PASSWORD=theSecretAdminPassword
           LDAP_SEARCH_FILTER*="(sAMAccountName=${Args::DACS_USERNAME})"
           LDAP_ROLES_SELECTOR*="${LDAP::attrname}" eq "memberOf" ? strtr(ldap(rdn_attrvalue, \
               ldap(dn_index, "${LDAP::attrvalue}", 1)), " ", "_") : ""

       Suppose one wanted to use [1mdacsauth [22mto authenticate a user via LDAP in a
       way analogous to this dacs.conf configuration:

           <Auth id="ldap">
           URL "http://example.example.com/cgi-bin/dacs/local_ldap_authenticate"
           STYLE "password,add_roles"
           CONTROL "required"
           LDAP_BIND_METHOD "direct"
           LDAP_USERNAME_URL* '"ldap://winders.example.com/cn=" . encode(url, ${Args::USERNAME}) . ",cn=Users,dc=example,dc=local"'
           LDAP_USERNAME_EXPR* '"${LDAP::sAMAccountName}"'
           LDAP_ROLES_SELECTOR* '"${LDAP::attrname}" eq "memberOf" \
               ? strtr(ldap(rdn_attrvalue, ldap(dn_index, "${LDAP::attrvalue}", 1)), " ", "_") : ""'
           </Auth>

       A file like this (e.g., /usr/local/dacs/ldap_auth_options_direct) would
       contain the following directives:

           LDAP_BIND_METHOD=direct
           LDAP_USERNAME_URL*="ldap://winders.example.com/cn=" . encode(url, ${Args::USERNAME}) . ",cn=Users,dc=example,dc=local"
           LDAP_USERNAME_EXPR*="${LDAP::sAMAccountName}"
           LDAP_ROLES_SELECTOR*="${LDAP::attrname}" eq "memberOf" \
               ? strtr(ldap(rdn_attrvalue, ldap(dn_index, "${LDAP::attrvalue}", 1)), " ", "_") : ""

       Authentication could then be performed using a command like this:

           % dacsauth -fj FEDROOT -m http://example.example.com/cgi-bin/dacs/local_ldap_authenticate passwd suff \
             -Of /usr/local/dacs/ldap_auth_options_direct \
             -DVFS="[federation_keys]dacs-fs:/usr/local/dacs/federations/federation_keys" \
             -fn EXAMPLE -u bobo -prompt


[1mDIAGNOSTICS[0m
       The program exits 0 if authentication was successful or with 1 if
       authentication failed or an error occurred.

[1mBUGS[0m
       This command only supplies partial support for interacting with
       [1mdacs_authenticate[22m. It may not be possible for an authentication module
       to return role information, as can be done by [1mdacs_authenticate[22m.

       It would be better if the [1m-m [22mflag were instead [1m-a [22m(for "authenticate").

[1mSEE ALSO[0m
       [34m[1mdacscred(1)[0m[1m[22m[2], [34m[1mdacs_authenticate(8)[0m[1m[22m[1], [34m[1mdacs.exprs(5)[0m[1m[22m[24]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[25])

[1mCOPYING[0m
       Copyright (C) 2003-2013 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[26] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        2. dacscred(1)
           http://dacs.dss.ca/man/dacscred.1.html

        3. dacs_auth_agent(8)
           http://dacs.dss.ca/man/dacs_auth_agent.8.html

        4. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        5. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

        6. Auth clause
           http://dacs.dss.ca/man/dacs_authenticate.html#auth_clause

        7. URL
           http://dacs.dss.ca/man/dacs_authenticate.8.html#URL

        8. STYLE
           http://dacs.dss.ca/man/dacs_authenticate.8.html#STYLE

        9. CONTROL
           http://dacs.dss.ca/man/dacs_authenticate.8.html#CONTROL

       10. OPTION
           http://dacs.dss.ca/man/dacs_authenticate.8.html#OPTION

       11. EXPR
           http://dacs.dss.ca/man/dacs_authenticate.8.html#EXPR

       12. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

       13. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#roles_clause

       14. URL
           http://dacs.dss.ca/man/dacs_authenticate.8.html#r_URL

       15. -fn
           http://dacs.dss.ca/man/#fn_flag

       16. -fj
           http://dacs.dss.ca/man/#fj_flag

       17. Google
           http://www.google.com

       18. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_pam_authenticate

       19. pamd(8)
           http://dacs.dss.ca/man/pamd.8.html

       20. local_unix_roles
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_unix_roles

       21. local_roles
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_roles

       22. local_ldap_roles
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_ldap_roles

       23. role string
           http://dacs.dss.ca/man/dacs.1.html#roles

       24. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html

       25. www.dss.ca
           http://www.dss.ca

       26. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.28b                      03/01/2013                       DACSAUTH(1)
