/*
 * Note: this should be standalone - do not bring in any DACS dependencies.
 */

/*
 * Copyright (c) 2003-2018
 * Distributed Systems Software.  All rights reserved.
 *
 * See crypto_aux.c for applicable open source licensing.
 * $Id: crypto_aux.h 2981 2018-01-23 22:43:42Z brachman $
 */

#ifndef _CRYPTO_AUX_H_
#define _CRYPTO_AUX_H_

#include <stdint.h>

/* The length of an MD5 digest, in bytes. */
#define MD5_DIGEST_LEN		16

typedef struct MD5_ctx {
  uint32_t buf[4];
  uint32_t bits[2];
  uint8_t in[64];
} MD5_ctx;

/* The length of an MD4 digest, in bytes. */
#define MD4_DIGEST_LEN		16

typedef struct RC4_ctx {
  uint8_t perm[256];
  uint8_t index1;
  uint8_t index2;
} RC4_ctx;

/* Any 32-bit or wider unsigned integer data type will do. */
typedef unsigned int MD4_u32plus;

typedef struct {
  MD4_u32plus lo, hi;
  MD4_u32plus a, b, c, d;
  unsigned char buffer[64];
  MD4_u32plus block[16];
} MD4_ctx;

#ifdef __cplusplus
extern "C" {
#endif

extern uint8_t *crypto_hmac_md5(uint8_t *key, size_t key_len, uint8_t *text,
								size_t text_len, uint8_t **inner, size_t *ilen,
								uint8_t **hmac, size_t *hlen);

extern RC4_ctx *rc4_init(RC4_ctx *const state, const uint8_t *key,
						 size_t keylen);
extern void rc4_crypt(RC4_ctx *const state, const uint8_t *inbuf,
					  uint8_t *outbuf, size_t buflen);

extern void MD5_init(MD5_ctx *context);
extern void MD5_update(MD5_ctx *context, const uint8_t *buf, size_t len);
extern uint8_t *MD5_final(MD5_ctx *context, uint8_t *digest);

extern void MD4_init(MD4_ctx *ctx);
extern void MD4_update(MD4_ctx *ctx, const void *data, unsigned long size);
extern void MD4_final(MD4_ctx *ctx, unsigned char *result);

extern unsigned char *ntlm_hmac_md5(const void *key, size_t key_len,
									const void *msg, size_t msg_len, void *hmac);
extern int do_crypto_aux_tests(void);

#ifdef __cplusplus
}
#endif

#endif
