.\" dpkg manual page - update-alternatives(1)
.\"
.\" Copyright © 1997-1998 Charles Briscoe-Smith
.\" Copyright © 1999 Ben Collins <bcollins@debian.org>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2003 Adam Heath <doogie@debian.org>
.\" Copyright © 2005 Scott James Remnant <scott@netsplit.com>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008 Pierre Habouzit <madcoder@debian.org>
.\" Copyright © 2009-2011 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH update\-alternatives 1 %RELEASE_DATE% %VERSION% Dpkg\-sviten
.nh
.SH NAMN
update\-alternatives \- underhåller symboliska länkar för att bestämma
standardkommandon
.
.SH SYNOPS
\fBupdate\-alternatives\fP [\fIflagga\fP...] \fIåtgärd\fP
.
.SH BESKRIVNING
\fBupdate\-alternatives\fP skapar, tar bort, underhåller och visar information
om de symboliska länkar som ingår i Debians alternativsystem.
.PP
Det är möjligt för flera kommandon som tillhandahåller identisk eller
liknande funktionalitet att vara installerade på ett system samtidigt. Till
exempel har många system flera textredigeringsprogram installerade
samtidigt, vilket ger användarna på systemet valmöjligheter, var och en kan
använda olika textredigeringsprogram om de så önskar, men det gör det svårt
för ett program att göra ett bra val av textredigerare att anropa om en
användare inte har gjort ett specifikt val.
.PP
Debians alternativsystem försöker lösa detta problem. Ett generiskt namn i
filsystemet delas av alla filer som tillhandahåller utbytbar
funktionalitet. Alternativsystemet och systemadministratören anger
tillsammans vilken specifik fil som skall refereras av sitt generiska
namn. Till exempel kan alternativsystemet låta det generiska namnet
\fI/usr/bin/editor\fP att peka mot \fI/usr/bin/nvi\fP som standard om både
textredigeringsprogrammet \fBed\fP(1) och \fBnvi\fP(1) båda är installerade på
systemet. Systemadministratören kan överstyra detta och låta det peka på
\fI/usr/bin/ed\fP istället, och alternativsystemet kommer inte ändra denna
inställning förrän det ombeds att göra det.
.PP
Det generiska namnet är inte en direkt symbolisk länk till det valda
alternativet. Istället är det en symbolisk länk till ett namn i katalogen
\fIalternatives\fP, vilket i sin tur är en symbolisk länk till den faktiska fil
det pekar mot. Detta görs så att systemadministratörens ändringar kan
begränsas till katalogen \fI%CONFDIR%\fP: FHS (se detta) ger orsaker till
varför detta är Bra.
.PP
När ett paket som tillhandahåller en fil med en specifik funktionalitet
installeras, ändras eller tas bort, anropas \fBupdate\-alternatives\fP för att
uppdatera information om filen i alternativsystemet. \fBupdate\-alternatives\fP
anropas normalt från \fBpostinst\fP\- (configure) eller \fBprerm\fP\-skripten
(remove och deconfigure) i Debianpaket.
.PP
Det är ofta lämpligt för ett antal alternativ att vara synkroniserade, så
att de ändras i grupp. Till exempel, om det är flera versioner av
textredigeraren \fBvi\fP(1) installerade bör manualsidan som refereras till av
\fI/usr/share/man/man1/vi.1\fP motsvara den binär som refereras till av
\fI/usr/bin/vi\fP. \fBupdate\-alternatives\fP hanterar detta genom \fIhuvud\fP\- och
\fIslav\fP\-länkar. När huvudlänken uppdateras ändras även anslutna
slavlänkar. En huvudlänk och dess anslutna slavar utgör en \fIlänkgrupp\fP.
.PP
En länkgrupp kan vid varje given tidpunkt vara i ett av två lägen:
automatisk eller manuell. När en grupp är i automatiskt läge kommer
alternativsystemet automatiskt att bestämma när och hur länkar skall
uppdateras då paket installeras eller tas bort. I manuellt läge kommer
alternativsystemet att behålla administratörens val och undvika att ändra
länkarna (förutom om något är trasigt).
.PP
Länkgrupper är i automatiskt läge när de först introduceras på systemet. Om
systemadministratören gör ändringar till systemets automatiska inställningar
kommer detta att noteras nästa gång \fBupdate\-alternatives\fP körs på den
ändrade länkens grupp och gruppen kommer automatiskt att växlas till
manuellt läge.
.PP
Varje alternativ har en \fIprioritet\fP kopplad till sig. När en länkgrupp är i
automatiskt läge kommer det alternativ som medlemmar i gruppen pekar mot
vara den med den högsta prioriteten.
.PP
When using the \fB\-\-config\fP option, \fBupdate\-alternatives\fP will list all of
the choices for the link group of which given \fIname\fP is the master
alternative name.  The current choice is marked with a ‘*’.  You will then
be prompted for your choice regarding this link group.  Depending on the
choice made, the link group might no longer be in \fIauto\fP mode. You will
need to use the \fB\-\-auto\fP option in order to return to the automatic mode
(or you can rerun \fB\-\-config\fP and select the entry marked as automatic).
.PP
Om du vill konfigurera icke\-interaktivt kan du använda flaggan \fB\-\-set\fP i
stället (se nedan).
.PP
Olika paket som tillhandahåller samma fil måste göra så i
\fBsamförstånd\fP. Det betyder att det är ett \fBkrav\fP att alla involverade
paket använder sig av \fBupdate\-alternatives\fP. Det är inte möjligt att
överstyra en fil ett paket som inte använder
\fBupdate\-alternatives\fP\-mekanismen.
.
.SH TERMINOLOGI
Efter \fBupdate\-alternatives\fP aktiviteter är ganska komplexa blir det enklare
att förstå hur det fungerar genom att vi förklarar några specifika termer.
.TP 
generiskt namn (eller alternativlänk).
Ett namn, till exempel \fI/usr/bin/editor\fP, som via alternativsystemet pekar
på en av flera filer med liknande funktionalitet.
.TP 
alternativnamn
Namnet på en symbolisk länk i alternativkatalogen.
.TP 
alternativ (eller alternativsökväg)
Namnet på en specifik fil i filsystemet, som kan vara tillgänglig via ett
generiskt namn med hjälp av alternativsystemet.
.TP 
alternativkatalog
En katalog, som standard \fI%CONFDIR%/alternatives\fP, som innehåller de
symboliska länkarna.
.TP 
administrativ katalog
En katalog, som standard \fI%ADMINDIR%/alternatives\fP, som innehåller
tillståndsinformation för \fBupdate\-alternatives\fP.
.TP 
länkgrupp
En uppsättning relaterade symboliska länkar, avsedda att uppdateras som en
grupp.
.TP 
huvudlänk
Alternativlänken i en länkgrupp som bestämmer hur de andra länkarna i
gruppen ställs in.
.TP 
slavlänk
En alternativlänk i en länkgrupp som styrs av hur huvudlänken ställs in.
.TP 
automatiskt läge
När en länkgrupp är i automatiskt läge försäkrar alternativsystemet att
länkarna i gruppen pekar på det högstprioriterade alternativet som är
lämpligt för gruppen.
.TP 
manuellt läge
När en grupp är i manuellt läge kommer inte alternativsystemet att utföra
några ändringar till systemadministratörens inställningar.
.
.SH KOMMANDON
.TP 
\fB\-\-install\fP \fIlänk namn sökväg prioritet\fP [\fB\-\-slave\fP \fIlänk namn sökväg\fP]...
Lägg till en grupp med alternativ till systemet. \fIlänk\fP är det generiska
namnet för huvudlänken, \fInamn\fP är namnet på dess symboliska länk i
alternativkatalogen och \fIsökväg\fP är alternativet som introduceras för
huvudlänken. Argumenten efter \fB\-\-slave\fP är det generiska namnet, namnet på
den symboliska länken i alternativkatalogen och alternativet för
slavlänken. Noll eller flera \fB\-\-slave\fP\-flaggor kan anges, där alla följs av
tre argument. Observera att om ett slavalternativ inte finns kommer
motsvarande slavlänk helt enkelt inte att installeras (en varning kommer
fortfarande att visas). Om en verklig fil är installerad där en
alternativlänk måste installeras behålls den såvida inte \fB\-\-force\fP används.
.IP
Om det angivna alternativnamnet redan finns i alternativsystemets databas
kommer informationen som anges att läggas in som en ny uppsättning av
alternativ för gruppen. Om inte kommer en ny grupp, inställd på automatiskt
läge, att läggas till med given information. Om gruppen är i automatiskt
läge och det alternativ som läggs in har högre prioritet än alla andra
installerade alternativ för gruppen kommer de symboliska länkarna att
uppdateras så att de pekar på de nyligen tillagda alternativen.
.TP 
\fB\-\-set\fP \fInamn sökväg\fP
Sätt programmet \fIsökväg\fP som ett alternativ till \fInamn\fP. Detta motsvarar
\fB\-\-config\fP men är icke\-interaktivt och kan därmed användas i ett skript.
.TP 
\fB\-\-remove\fP \fInamn sökväg\fP
Ta bort ett alternativ och alla dess anknutna slavlänkar. \fInamn\fP är ett
namn i alternativkatalogen och \fIsökväg\fP är ett absolut filnamn till vilket
\fInamn\fP kunde länkas. Om \fInamn\fP faktiskt är länkat till \fIsökväg\fP kommer
\fInamn\fP att uppdateras till att peka på ett annat lämpligt alternativ (och
gruppen ställs tillbaka till automatiskt läge), eller att tas bort om det
inte finns något alternativ kvar. Anknutna slavlänkar kommer uppdateras
eller tas bort på motsvarande vis. Om länken inte för tillfället pekar på
\fIsökväg\fP kommer inga länkar att uppdateras, endast informationen om
alternativet tas bort.
.TP 
\fB\-\-remove\-all\fP \fInamn\fP
Tar bort alla alternativ och alla deras anslutna slavlänkar. \fInamn\fP är ett
namn i alternativkatalogen.
.TP 
\fB\-\-all\fP
Anropar \fB\-\-config\fP på alla alternativ. Kan med framgång kombineras med
\fB\-\-skip\-auto\fP för att gå igenom och konfigurera alla alternativ som inte är
ställda i automatiskt läge. Trasiga alternativ visas också. Ett enkelt sätt
att fixa alla trasiga alternativ är därmed att anropa \fByes \*(rq |
update\-alternatives \-\-force \-\-all\fP.
.TP 
\fB\-\-auto\fP \fInamn\fP
Ställ in länkgruppen bakom alternativet för \fInamn\fP till automatiskt
läge. Detta får till följd att den huvudsakliga symboliska länken och dess
slavar uppdateras till att peka på det högst prioriterade installerade
alternativet.
.TP 
\fB\-\-display\fP \fInamn\fP
Display information about the link group.  Information displayed includes
the group's mode (auto or manual), the master and slave links, which
alternative the master link currently points to, what other alternatives are
available (and their corresponding slave alternatives), and the highest
priority alternative currently installed.
.TP 
\fB\-\-get\-selections\fP
List all master alternative names (those controlling a link group)  and
their status (since version 1.15.0).  Each line contains up to 3 fields
(separated by one or more spaces). The first field is the alternative name,
the second one is the status (either \fBauto\fP or \fBmanual\fP), and the last one
contains the current choice in the alternative (beware: it's a filename and
thus might contain spaces).
.TP 
\fB\-\-set\-selections\fP
Read configuration of alternatives on standard input in the format generated
by \fB\-\-get\-selections\fP and reconfigure them accordingly (since version
1.15.0).
.TP 
\fB\-\-query\fP \fInamn\fP
Display information about the link group like \fB\-\-display\fP does, but in a
machine parseable way (since version 1.15.0, see section \fBQUERY FORMAT\fP
below).
.TP 
\fB\-\-list\fP \fInamn\fP
Visar alla mål för länkgruppen.
.TP 
\fB\-\-config\fP \fInamn\fP
Visa tillgängliga alternativ för en länkgrupp och låt användaren att
interaktivt välja vilken som skall användas. Länkgruppen uppdateras.
.TP 
\fB\-\-help\fP
Visar hjälpskärm och avslutar.
.TP 
\fB\-\-version\fP
Visar version och avslutar.
.
.SH FLAGGOR
.TP 
\fB\-\-altdir\fP\fI katalog\fP
Anger alternativkatalogen om detta inte skall vara standardvärdet.
.TP 
\fB\-\-admindir\fP\fI katalog\fP
Anger den administrativa katalogen om detta inte skall vara standardvärdet.
.TP 
\fB\-\-log\fP \fIfil\fP
Specifies the log file (since version 1.15.0), when this is to be different
from the default (%LOGDIR%/alternatives.log).
.TP 
\fB\-\-force\fP
Allow replacing or dropping any real file that is installed where an
alternative link has to be installed or removed.
.TP 
\fB\-\-skip\-auto\fP
Hoppa över konfigureringsfrågor för alternativ som är korrekt konfigurerade
i automatiskt läge. Denna flagga är endast relevant för \fB\-\-config\fP och
\fB\-\-all\fP.
.TP 
\fB\-\-verbose\fP
Generate more comments about what is being done.
.TP 
\fB\-\-quiet\fP
Skriv inte några kommentarer såvida det inte uppstår ett fel.
.
.SH RETURVÄRDE
.TP 
\fB0\fP
Den önskade funktionen utfördes utan fel.
.TP 
\fB2\fP
Problem uppstod vid tolkning av kommandoraden eller när funktionen skulle
utföras.
.
.SH MILJÖVARIABLER
.TP 
\fBDPKG_ADMINDIR\fP
Om satt och flaggan \fB\-\-admindir\fP inte har angivits används det som
bas\-administrativ katalog.
.
.SH FILER
.TP 
\fI%CONFDIR%/alternatives/\fP
Den förvalda alternativkatalogen. Kan överstyras med flaggan \fB\-\-altdir\fP.
.TP 
\fI%ADMINDIR%/alternatives/\fP
Den förvalda administrativa katalogen. Kan överstyras med flaggan
\fB\-\-admindir\fP.
.
.SH FRÅGEFORMAT
The \fB\-\-query\fP format is using an RFC822\-like flat format. It's made of \fIn\fP
+ 1 blocks where \fIn\fP is the number of alternatives available in the queried
link group. The first block contains the following fields:
.TP 
\fBNamn:\fP \fInamn\fP
Alternativets namn i den alternativa katalogen.
.TP 
\fBLink:\fP\fI länk\fP
Generiskt namn för alternativet.
.TP 
\fBSlaves:\fP\fI lista\-över\-slavar\fP
När detta fält är tillgängligt innehåller \fBnext\fP\-raderna alla slavlänkar
som kopplas till huvudlänken för alternativet. Varje rad beskriver en
slav. Varje rad innehåller ett blanksteg, det generiska namnet på
slavalternativet, ytterligare ett blanksteg, och sökvägen till
slavalternativet.
.TP 
\fBStatus:\fP\fI status\fP
Status för alternativet (\fBauto\fP eller \fBmanual\fP).
.TP 
\fBBest:\fP\fI bästa\-val\fP
Sökvägen till det bästa alternativet i länkgruppen. Tas inte med om inget
alternativ är tillgängligt.
.TP 
\fBValue:\fP\fI för\-närvarande\-valt\-alternativ\fP
Sökvägen till det för närvarande valda alternativet. Kan även ta det magiska
värdet \fBnone\fP (inget). Det används om det inte finns någon länk.
.PP
Övriga block beskriver tillgängliga alternativ i den efterfrågade
länkgruppen:
.TP 
\fBAlternative:\fP\fI sökväg\-till\-alternativet\fP
Sökväg till alternativet som beskrivs i blocket.
.TP 
\fBPriority:\fP\fI prioritetsvärde\fP
Värdet för prioriteten på alternativet.
.TP 
\fBSlaves:\fP\fI lista\-över\-slavar\fP
När detta fält anges innehåller \fBnext\fP\-raderna alla slavalternativ som
kopplas till huvudlänken för alternativet. Varje rad beskriver en
slav. Varje rad innehåller ett blanksteg, det generiska namnet på
slavalternativet, ytterligare ett blanksteg, och sökvägen till
slavalternativet.
.
.SS Example
.nf
$ update\-alternatives \-\-query editor
Name: editor
Link: /usr/bin/editor
Slaves:
 editor.1.gz /usr/share/man/man1/editor.1.gz
 editor.fr.1.gz /usr/share/man/fr/man1/editor.1.gz
 editor.it.1.gz /usr/share/man/it/man1/editor.1.gz
 editor.pl.1.gz /usr/share/man/pl/man1/editor.1.gz
 editor.ru.1.gz /usr/share/man/ru/man1/editor.1.gz
Status: auto
Best: /usr/bin/vim.basic
Value: /usr/bin/vim.basic

Alternative: /bin/ed
Priority: \-100
Slaves:
 editor.1.gz /usr/share/man/man1/ed.1.gz

Alternative: /usr/bin/vim.basic
Priority: 50
Slaves:
 editor.1.gz /usr/share/man/man1/vim.1.gz
 editor.fr.1.gz /usr/share/man/fr/man1/vim.1.gz
 editor.it.1.gz /usr/share/man/it/man1/vim.1.gz
 editor.pl.1.gz /usr/share/man/pl/man1/vim.1.gz
 editor.ru.1.gz /usr/share/man/ru/man1/vim.1.gz
.fi
.
.SH DIAGNOSTIK
Med \fB\-\-verbose\fP kommer \fBupdate\-alternatives\fP att beskriva i det oändliga
vad det gör på sin standard ut\-kanal. Om ett fel uppstår skriver
\fBupdate\-alternatives\fP ut felmeddelanden på sin standard fel\-kanal och
avslutar med felkoden 2. Diagnostikinformationen bör vara självförklarande,
sänd in en felrapport om du inte tycker att den är det.
.
.SH EXEMPEL
Det är flera paket som tillhandahåller en textredigerare kompatibel med
\fBvi\fP, till exempel \fBnvi\fP och \fBvim\fP. Vilken bestäms via länkgruppen \fBvi\fP,
vilken innehåller länkar både för själva programmet och dessa anknutna
manualsida.
.PP
För att visa vilka tillgängliga paket som tillhandahåller \fBvi\fP, samt dess
aktuella inställning, använd kommandot \fB\-\-display\fP:
.PP
.RS
\fBupdate\-alternatives \-\-display vi\fP
.RE
.PP
För att välja en specifik implementation av \fBvi\fP, utför detta kommando som
root och välj sedan ett tal från listan:
.PP
.RS
\fBupdate\-alternatives \-\-config vi\fP
.RE
.PP
För att återgå till att \fBvi\fP\-implementationen väljs automatiskt, utför
detta som root:
.PP
.RS
\fBupdate\-alternatives \-\-auto vi\fP
.RE
.
.SH "SE ÄVEN"
\fBln\fP(1), FHS, Filesystem Hierarchy Standard.
.SH ÖVERSÄTTNING
Peter Krefting och Daniel Nylander.
