/**
 * Copyright (c) 2012 Eclipse contributors and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.emf.ecore.xcore.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.xcore.util.XcoreAdapterFactory;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class XcoreItemProviderAdapterFactory extends XcoreAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable
{
  /**
   * This keeps track of the root adapter factory that delegates to this adapter factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected ComposedAdapterFactory parentAdapterFactory;

  /**
   * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected IChangeNotifier changeNotifier = new ChangeNotifier();

  /**
   * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected Collection<Object> supportedTypes = new ArrayList<Object>();

  /**
   * This constructs an instance.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public XcoreItemProviderAdapterFactory()
  {
    supportedTypes.add(IEditingDomainItemProvider.class);
    supportedTypes.add(IStructuredItemContentProvider.class);
    supportedTypes.add(ITreeItemContentProvider.class);
    supportedTypes.add(IItemLabelProvider.class);
    supportedTypes.add(IItemPropertySource.class);
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.xcore.XAnnotation} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected XAnnotationItemProvider xAnnotationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.xcore.XAnnotation}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createXAnnotationAdapter()
  {
    if (xAnnotationItemProvider == null)
    {
      xAnnotationItemProvider = new XAnnotationItemProvider(this);
    }

    return xAnnotationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.xcore.XAnnotationDirective} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected XAnnotationDirectiveItemProvider xAnnotationDirectiveItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.xcore.XAnnotationDirective}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createXAnnotationDirectiveAdapter()
  {
    if (xAnnotationDirectiveItemProvider == null)
    {
      xAnnotationDirectiveItemProvider = new XAnnotationDirectiveItemProvider(this);
    }

    return xAnnotationDirectiveItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.xcore.XAttribute} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected XAttributeItemProvider xAttributeItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.xcore.XAttribute}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createXAttributeAdapter()
  {
    if (xAttributeItemProvider == null)
    {
      xAttributeItemProvider = new XAttributeItemProvider(this);
    }

    return xAttributeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.xcore.XClass} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected XClassItemProvider xClassItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.xcore.XClass}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createXClassAdapter()
  {
    if (xClassItemProvider == null)
    {
      xClassItemProvider = new XClassItemProvider(this);
    }

    return xClassItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.xcore.XDataType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected XDataTypeItemProvider xDataTypeItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.xcore.XDataType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createXDataTypeAdapter()
  {
    if (xDataTypeItemProvider == null)
    {
      xDataTypeItemProvider = new XDataTypeItemProvider(this);
    }

    return xDataTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.xcore.XEnum} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected XEnumItemProvider xEnumItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.xcore.XEnum}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createXEnumAdapter()
  {
    if (xEnumItemProvider == null)
    {
      xEnumItemProvider = new XEnumItemProvider(this);
    }

    return xEnumItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.xcore.XEnumLiteral} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected XEnumLiteralItemProvider xEnumLiteralItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.xcore.XEnumLiteral}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createXEnumLiteralAdapter()
  {
    if (xEnumLiteralItemProvider == null)
    {
      xEnumLiteralItemProvider = new XEnumLiteralItemProvider(this);
    }

    return xEnumLiteralItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.xcore.XGenericType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected XGenericTypeItemProvider xGenericTypeItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.xcore.XGenericType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createXGenericTypeAdapter()
  {
    if (xGenericTypeItemProvider == null)
    {
      xGenericTypeItemProvider = new XGenericTypeItemProvider(this);
    }

    return xGenericTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.xcore.XImportDirective} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected XImportDirectiveItemProvider xImportDirectiveItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.xcore.XImportDirective}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createXImportDirectiveAdapter()
  {
    if (xImportDirectiveItemProvider == null)
    {
      xImportDirectiveItemProvider = new XImportDirectiveItemProvider(this);
    }

    return xImportDirectiveItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.xcore.XOperation} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected XOperationItemProvider xOperationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.xcore.XOperation}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createXOperationAdapter()
  {
    if (xOperationItemProvider == null)
    {
      xOperationItemProvider = new XOperationItemProvider(this);
    }

    return xOperationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.xcore.XPackage} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected XPackageItemProvider xPackageItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.xcore.XPackage}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createXPackageAdapter()
  {
    if (xPackageItemProvider == null)
    {
      xPackageItemProvider = new XPackageItemProvider(this);
    }

    return xPackageItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.xcore.XParameter} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected XParameterItemProvider xParameterItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.xcore.XParameter}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createXParameterAdapter()
  {
    if (xParameterItemProvider == null)
    {
      xParameterItemProvider = new XParameterItemProvider(this);
    }

    return xParameterItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.xcore.XReference} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected XReferenceItemProvider xReferenceItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.xcore.XReference}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createXReferenceAdapter()
  {
    if (xReferenceItemProvider == null)
    {
      xReferenceItemProvider = new XReferenceItemProvider(this);
    }

    return xReferenceItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected XStringToStringMapEntryItemProvider xStringToStringMapEntryItemProvider;

  /**
   * This creates an adapter for a {@link java.util.Map.Entry}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createXStringToStringMapEntryAdapter()
  {
    if (xStringToStringMapEntryItemProvider == null)
    {
      xStringToStringMapEntryItemProvider = new XStringToStringMapEntryItemProvider(this);
    }

    return xStringToStringMapEntryItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.xcore.XTypeParameter} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected XTypeParameterItemProvider xTypeParameterItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.xcore.XTypeParameter}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createXTypeParameterAdapter()
  {
    if (xTypeParameterItemProvider == null)
    {
      xTypeParameterItemProvider = new XTypeParameterItemProvider(this);
    }

    return xTypeParameterItemProvider;
  }

  /**
   * This returns the root adapter factory that contains this factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ComposeableAdapterFactory getRootAdapterFactory()
  {
    return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
  }

  /**
   * This sets the composed adapter factory that contains this factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory)
  {
    this.parentAdapterFactory = parentAdapterFactory;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public boolean isFactoryForType(Object type)
  {
    return supportedTypes.contains(type) || super.isFactoryForType(type);
  }

  /**
   * This implementation substitutes the factory itself as the key for the adapter.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter adapt(Notifier notifier, Object type)
  {
    return super.adapt(notifier, this);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Object adapt(Object object, Object type)
  {
    if (isFactoryForType(type))
    {
      Object adapter = super.adapt(object, type);
      if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter)))
      {
        return adapter;
      }
    }

    return null;
  }

  /**
   * This adds a listener.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void addListener(INotifyChangedListener notifyChangedListener)
  {
    changeNotifier.addListener(notifyChangedListener);
  }

  /**
   * This removes a listener.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void removeListener(INotifyChangedListener notifyChangedListener)
  {
    changeNotifier.removeListener(notifyChangedListener);
  }

  /**
   * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void fireNotifyChanged(Notification notification)
  {
    changeNotifier.fireNotifyChanged(notification);

    if (parentAdapterFactory != null)
    {
      parentAdapterFactory.fireNotifyChanged(notification);
    }
  }

  /**
   * This disposes all of the item providers created by this factory. 
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void dispose()
  {
    if (xAnnotationItemProvider != null) xAnnotationItemProvider.dispose();
    if (xAnnotationDirectiveItemProvider != null) xAnnotationDirectiveItemProvider.dispose();
    if (xAttributeItemProvider != null) xAttributeItemProvider.dispose();
    if (xClassItemProvider != null) xClassItemProvider.dispose();
    if (xDataTypeItemProvider != null) xDataTypeItemProvider.dispose();
    if (xEnumItemProvider != null) xEnumItemProvider.dispose();
    if (xEnumLiteralItemProvider != null) xEnumLiteralItemProvider.dispose();
    if (xGenericTypeItemProvider != null) xGenericTypeItemProvider.dispose();
    if (xImportDirectiveItemProvider != null) xImportDirectiveItemProvider.dispose();
    if (xOperationItemProvider != null) xOperationItemProvider.dispose();
    if (xPackageItemProvider != null) xPackageItemProvider.dispose();
    if (xParameterItemProvider != null) xParameterItemProvider.dispose();
    if (xReferenceItemProvider != null) xReferenceItemProvider.dispose();
    if (xStringToStringMapEntryItemProvider != null) xStringToStringMapEntryItemProvider.dispose();
    if (xTypeParameterItemProvider != null) xTypeParameterItemProvider.dispose();
  }

}
