/*******************************************************************************
 * Copyright (c) 2010 Tasktop Technologies and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tasktop Technologies - initial API and implementation
 *******************************************************************************/

package org.eclipse.mylyn.internal.commons.repositories;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.mylyn.commons.repositories.auth.ICredentialsStore;

/**
 * @author Steffen Pingel
 * @deprecated use classes in the <code>org.eclipse.mylyn.commons.repositories.core</code> bundle instead
 */
@Deprecated
public class InMemoryCredentialsStore implements ICredentialsStore {

	private final ConcurrentHashMap<String, Object> store;

	private final ICredentialsStore parent;

	public InMemoryCredentialsStore(ICredentialsStore parent) {
		this.parent = parent;
		store = new ConcurrentHashMap<String, Object>();
	}

	public void clear() {
		store.clear();
	}

	public void flush() throws IOException {
		// does nothing
	}

	public String get(String key, String def) throws StorageException {
		String value = (String) store.get(key);
		if (value == null && parent != null) {
			return parent.get(key, def);
		}
		return (value != null) ? value : def;
	}

	public byte[] getByteArray(String key, byte[] def) throws StorageException {
		byte[] value = (byte[]) store.get(key);
		if (value == null && parent != null) {
			return parent.getByteArray(key, def);
		}
		return (value != null) ? value : def;
	}

	public String[] keys() {
		return store.keySet().toArray(new String[0]);
	}

	public void put(String key, String value, boolean encrypt) throws StorageException {
		store.put(key, value);
	}

	public void putByteArray(String key, byte[] value, boolean encrypt) throws StorageException {
		store.put(key, value);
	}

	public void remove(String key) {
		store.remove(key);
	}

	public void copyTo(ICredentialsStore target) throws StorageException {
		for (Map.Entry<String, Object> entry : store.entrySet()) {
			if (entry.getValue() instanceof String) {
				target.put(entry.getKey(), (String) entry.getValue(), true);
			} else if (entry.getValue() instanceof byte[]) {
				target.putByteArray(entry.getKey(), (byte[]) entry.getValue(), true);
			}
		}
	}

}
