(ert-deftest elpy-shell-prefix-key-should-be-changed-when-customized ()
  (elpy-testcase ()
    (python-mode)
    (elpy-mode)
    (customize-set-variable 'elpy-shell-command-prefix-key "C-c C-a")
    (should (equal elpy-shell-command-prefix-key "C-c C-a"))
    (should (equal (key-binding (kbd "C-c C-a")) 'elpy-shell-map))
    (should (equal (key-binding (kbd "C-c C-a b")) 'elpy-shell-send-buffer))
    (should (equal (key-binding (kbd "C-c C-y")) nil))
    ;; Go back to normal
    (customize-set-variable 'elpy-shell-command-prefix-key "C-c C-y")
    (should (equal elpy-shell-command-prefix-key "C-c C-y"))
    (should (equal (key-binding (kbd "C-c C-y")) 'elpy-shell-map))
    (should (equal (key-binding (kbd "C-c C-y b")) 'elpy-shell-send-buffer))
    (should (equal (key-binding (kbd "C-c C-a")) nil))))
