/*
 * $Id: libfaucc.c,v 1.12 2012/02/17 14:17:01 vrsieh Exp $ 
 *
 * Copyright (C) 2008-2009 FAUcc Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <inttypes.h>

uint32_t
__ARCH_div_uint32(uint32_t op1, uint32_t op2)
{
	uint32_t X=0, A=op1;
	uint32_t res=0;
	unsigned char N=0;

	if ((A>>31) == 1) {
		A = 1 << N;
	}

	/* find bit length difference between op1 and op2 */
	X=op2;
	while ((X << 1) <= A) {
		X = X << 1;
		if (X == 0)
			break;
		N++;
	}
	if (N>0) {
		A = (op1 << (32-N));
		X = (op1 >> N);
	} else
		X = op1;
	N++;

	do {
		if (X >= op2) {
			X = X-op2;
			res = res << 1;
			res = res | 0x01;
		} else {
			res = res << 1;
		}
		X = X << 1;
		if ((A>>31) == 1) {
			X = X | 0x01;
		}
		A = A<<1;
		N--;
	} while (N > 0);

	return res;
} 

uint32_t
__ARCH_mod_uint32(uint32_t op1, uint32_t op2)
{
	uint32_t X=0, A=op1;
	unsigned char N=0;
	
	if ((A>>31) == 1) {
		A = 1 << N;
	}

	X=op2;
	while ((X << 1) <= A) {
		X = X << 1;
		if (X == 0)
			break;
		N++;
	}
	if (N>0) {
		A = (op1 << (32-N));
		X = (op1 >> N);
	} else
		X = op1;
	N++;

	do {
		if (X >= op2) {
			X = X-op2;
		}
		X = X << 1;
		if ((A>>31) == 1) {
			X = X | 0x01;
		}
		A = A<<1;
		N--;
	} while (N > 0);

	X = X >> 1;

	return X;
} 

uint32_t
__ARCH_mul_uint32(uint32_t op1, uint32_t op2)
{
	uint32_t X=0, A=0;
	uint32_t res=0;
	unsigned char N=0, I=0;
	
	X=op2;
	while (X != 0) {
		X = X >> 4;
		N++;
	}

	do {
		X=0;
		A=(op2 << (28-4*I)) >> 28;
		if (((A<<31)>>31) == 1) {
			X += op1;
		}
		if (((A<<30)>>31) == 1) {
			X += op1 << 1;
		}
		if (((A<<29)>>31) == 1) {
			X += op1 << 2;
		}
		if (((A<<28)>>31) == 1) {
			X += op1 << 3;
		}
		X = X << 4*I;
		res += X;

		N--; I++;
	} while (N > 0);

	return res;
} 

#if 0
uint64_t
__ARCH_div_uint64(uint64_t op1, uint64_t op2)
{
	uint64_t X=0, A=0;
	uint64_t res=0;
	unsigned char N=0;
	
	X=op2;
	while ((X << 1) < op1) {
		X = X << 1;
		N++;
	}
	A = (op1 << (64-N));
	X = (op1 >> N);
	N++;

	do {
		N--;
		if (X > op2) {
			X = X-op2;
			res = res << 1;
			res = res | 0x01;
		} else {
			res = res << 1;
		}
		X = X << 1;
		if ((A>>63) == 1) {
			X = X | 0x01;
		}
		A = A<<1;
		
	} while (N > 0);

	return res;
} 

uint64_t
__ARCH_mod_uint64(uint64_t op1, uint64_t op2)
{
	uint64_t X=0, A=0;
	unsigned char N=0;
	
	X=op2;
	while ((X << 1) < op1) {
		X = X << 1;
		N++;
	}
	A = (op1 << (64-N));// >> (32-N);
	X = (op1 >> N);
	N++;

	do {
		N--;
		if (X > op2) {
			X = X-op2;
		}
		X = X << 1;
		if ((A>>63) == 1) {
			X = X | 0x01;
		}
		A = A<<1;
	} while (N > 0);

	return X;
}

uint64_t
ARCH_mul_uint64(uint64_t op1, uint64_t op2)
{
	uint64_t X=0, A=0;
	uint64_t res=0;
	unsigned char N=0, I=0;
	
	X=op2;
	while (X != 0) {
		X = X >> 4;
		N++;
	}

	do {
		X=0;
		N--;
		A=(op2 << (60-4*I)) >> 60;
		if (((A<<63)>>63) == 1) {
			X += op1;
		}
		if (((A<<62)>>63) == 1) {
			X += op1 << 1;
		}
		if (((A<<61)>>63) == 1) {
			X += op1 << 2;
		}
		if (((A<<60)>>63) == 1) {
			X += op1 << 3;
		}
		X = X << 4*I;
		res += X;

		I++;
	} while (N > 0);

	return res;
}
#endif
