/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __PREFIXED_NAME_HPP_INCLUDED
#define __PREFIXED_NAME_HPP_INCLUDED

#include "frontend/ast/Name.hpp"

namespace ast {

//! a name with an expression as a prefix.
/** a name with an expression as a prefix.
 */
class PrefixedName : public Name {
public:
	//! c'tor
	/** @param n identifier of the name
	 *  @param pre prefix of the name
	 *  @param cands candidate symbols
	 *  @param loc corresponding location
	 */
	PrefixedName(
		std::string *n,
		Expression *pre,
		std::list<Symbol*> cands,
		Location loc
		) :	Name(n, cands, loc),
			prefix(pre) {}

	//! prefix expression of the name
	Expression *prefix;

protected:
	//! d'tor
	virtual ~PrefixedName() {
		util::MiscUtil::terminate(this->prefix);
	}
};

}; /* namespace ast */

#endif /* __PREFIXED_NAME_HPP_INCLUDED */
