/*
 * Copyright (C) 2007-2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef INCLUDE

#endif /* INCLUDE */
#ifdef STATE

struct {
#if 80386 <= CONFIG_CPU
	paddr_t mask;
#endif
} NAME;

#endif /* STATE */
#ifdef EXPORT

/*forward*/ static void
NAME_(mr)(struct cpssp *cpssp, paddr_t paddr, unsigned int bs, udata_t *valp);
/*forward*/ static void
NAME_(mw)(struct cpssp *cpssp, paddr_t paddr, unsigned int bs, udata_t val);
/*forward*/ static void
NAME_(mx)(struct cpssp *cpssp, paddr_t paddr, unsigned int bs, udata_t *valp);
/*forward*/ static void
NAME_(map_r)(struct cpssp *cpssp, paddr_t paddr,
		int (**cfp)(void *, paddr_t, unsigned int, udata_t *), void **csp, char **haddrp);
/*forward*/ static void
NAME_(map_w)(struct cpssp *cpssp, paddr_t paddr,
		int (**cfp)(void *, paddr_t, unsigned int, udata_t), void **csp, char **haddrp);
/*forward*/ static void
NAME_(map_x)(struct cpssp *cpssp, paddr_t paddr,
		int (**cfp)(void *, paddr_t, unsigned int, udata_t *), void **csp, char **haddrp);

#if 80386 <= CONFIG_CPU
/*forward*/ static void
NAME_(gate_set)(struct cpssp *cpssp, unsigned int val);
#endif

/*forward*/ static void
NAME_(unmap)(struct cpssp *cpssp, paddr_t paddr, paddr_t len);
/*forward*/ static void
NAME_(n_reset_set)(struct cpssp *cpssp, unsigned int val);
/*forward*/ static void
NAME_(create)(struct cpssp *cpssp);
/*forward*/ static void
NAME_(destroy)(struct cpssp *cpssp);

#endif /* EXPORT */
#ifdef BEHAVIOR

static void
NAME_(map_r)(
	struct cpssp *cpssp,
	paddr_t paddr,
	int (**cfp)(void *, paddr_t, unsigned int, udata_t *),
	void **csp,
	char **haddrp
)
{
#if 80386 <= CONFIG_CPU
	paddr &= cpssp->NAME.mask;
#endif
	NAME_(cache2_map_r)(cpssp, paddr, cfp, csp, haddrp);
}

static void
NAME_(map_w)(
	struct cpssp *cpssp,
	paddr_t paddr,
	int (**cfp)(void *, paddr_t, unsigned int, udata_t),
	void **csp,
	char **haddrp
)
{
#if 80386 <= CONFIG_CPU
	paddr &= cpssp->NAME.mask;
#endif
	NAME_(cache2_map_w)(cpssp, paddr, cfp, csp, haddrp);
}

static void
NAME_(map_x)(
	struct cpssp *cpssp,
	paddr_t paddr,
	int (**cfp)(void *, paddr_t, unsigned int, udata_t *),
	void **csp,
	char **haddrp
)
{
#if 80386 <= CONFIG_CPU
	paddr &= cpssp->NAME.mask;
#endif
	NAME_(cache2_map_x)(cpssp, paddr, cfp, csp, haddrp);
}

static void
NAME_(mr)(struct cpssp *cpssp, paddr_t paddr, unsigned int bs, udata_t *valp)
{
#if 80386 <= CONFIG_CPU
	paddr &= cpssp->NAME.mask;
#endif
	NAME_(cache2_mr)(cpssp, paddr, bs, valp);
}

static void
NAME_(mw)(struct cpssp *cpssp, paddr_t paddr, unsigned int bs, udata_t val)
{
#if 80386 <= CONFIG_CPU
	paddr &= cpssp->NAME.mask;
#endif

	NAME_(cache2_mw)(cpssp, paddr, bs, val);
}

static void
NAME_(mx)(struct cpssp *cpssp, paddr_t paddr, unsigned int bs, udata_t *valp)
{
#if 80386 <= CONFIG_CPU
	paddr &= cpssp->NAME.mask;
#endif
	NAME_(cache2_mx)(cpssp, paddr, bs, valp);
}

#if 80386 <= CONFIG_CPU
static void
NAME_(gate_set)(struct cpssp *cpssp, unsigned int val)
{
	if (val != ((cpssp->NAME.mask >> 20) & 1)) {
		/*
		 * When a20 is changed, all the MMU mappings are
		 * invalid, so we must flush everything.
		 */
		cpssp->NAME.mask = (paddr_t) (~(1ULL << 20) | (val << 20));

		NAME_(mmu_flush_all)(cpssp);
	}
}
#endif /* 80386 <= CONFIG_CPU */

static void
NAME_(unmap)(struct cpssp *cpssp, paddr_t paddr, paddr_t len)
{
	NAME_(cache1_unmap)(cpssp, paddr, len);
}

static void
NAME_(n_reset_set)(struct cpssp *cpssp, unsigned int n_val)
{
#if 80386 <= CONFIG_CPU
	cpssp->NAME.mask = ~(paddr_t) 0;
#endif
}

static void
NAME_(create)(struct cpssp *cpssp)
{
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */
