/*
  Copyright (C) 2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef INCLUDE
#endif /* INCLUDE */
#ifdef STATE

struct {
} NAME;

#endif /* STATE */
#ifdef EXPORT

/*forward*/ static void
NAME_(register_trigger)(struct cpssp *cpssp, int channel);

#endif /* EXPORT */
#ifdef BEHAVIOR

static void
NAME_(register_trigger)(struct cpssp *cpssp, int channel)
{
	long long ticks;
	int center_buffer_pos;
	int chan;
	ticks = 0;
	if (cpssp->trigger_channel == channel) {
		cpssp->trigger_armed = false;
		for (chan = 0; chan < NUMBER_ANALOG_CHANNELS; chan++) {
			int dest_buffer_pos;
			long long dest_sample_pos;
			long long remaining_samples;
			center_buffer_pos = cpssp->RLE_buffer_pos[chan];
			cpssp->center_buffer_pos[chan] = center_buffer_pos;
			cpssp->trigger_buffer_pos[chan] = center_buffer_pos;
			struct RLE_buffer_item item =
				cpssp->RLE_buffer[chan][center_buffer_pos];
			if (item.time_stamp != 0) {
				cpssp->center_sample_pos[chan] = item.sample_count;
				cpssp->trigger_sample_pos[chan] = item.sample_count;
				#if 0
				double time_hz_d = (double) TIME_HZ;
				double sample_rate_d = (double) cpssp->sample_rate;
				double time_stamp_d = (double)item.time_stamp;
				double samples_d = (double)cpssp->center_sample_pos[chan];
				double ticks_per_sample = time_hz_d / sample_rate_d;
				long long ticks = ((long long)time_stamp_d
						+ (long long)(samples_d - 1) *(long long) ticks_per_sample);
				#endif
			} else {
				cpssp->center_sample_pos[chan] = 0;
				cpssp->trigger_sample_pos[chan] = 0;
			}
			double skip = (double)cpssp->sweep_time / 2.0;
			skip *= (double)cpssp->sample_rate;
			skip = round(skip);

			subtract_samples(cpssp,
				chan,
				(int) skip,
				cpssp->trigger_buffer_pos[chan],
				&dest_buffer_pos,
				cpssp->trigger_sample_pos[chan],
				&dest_sample_pos,
				&remaining_samples);

			cpssp->number_samples_total = (long long)skip - remaining_samples;
			cpssp->first_buffer_pos[chan] = dest_buffer_pos;
			cpssp->first_sample_pos[chan] = dest_sample_pos;
			item = cpssp->RLE_buffer[chan][dest_buffer_pos];
			if (item.time_stamp != 0) {
				/*TODO move up*/
				double time_hz_d = (double) TIME_HZ;
				double sample_rate_d = (double) cpssp->sample_rate;
				double time_stamp_d = (double)item.time_stamp;
				double samples_d = (double)cpssp->first_sample_pos[chan];
				double ticks_per_sample = time_hz_d / sample_rate_d;
				ticks = ((long long)time_stamp_d
						+ (long long)(samples_d - 1) * (long long) ticks_per_sample);
			}

		}
		for (chan = 0; chan < NUMBER_DIGITAL_CHANNELS; chan++) {
			/* calculate cut-off event timestamp */
			int event_pos = 0;
			struct event_measure_point event = cpssp->event_buffer[chan][event_pos];
			while (event.time_stamp != 0) {
				if (ticks <= event.time_stamp) {
					break;
				}
				event_pos++;
				event = cpssp->event_buffer[chan][event_pos];
			}
			cpssp->first_event_buffer_pos[chan] = event_pos;
		}
	}
}

#endif /* BEHAVIOUR */
