/*
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __KEYDEFS_H_INCLUDED
#define __KEYDEFS_H_INCLUDED

/*
 * the struct used to pass keyboard events from frontend to terminal emulator
 */
struct vt_key {
        char shift, ctrl, alt;
        unsigned char value;
};

/*
 * #defines for "special keys"
 *
 * the GUI sends us keycodes, which we map to keyvalues in keyboard.c. this
 * obviously only works for keys *having* a value, not for "special keys"
 * (cursor keys, numeric keypad keys, set-up key and the like).
 *
 * the mapping from keycodes to keyvalues uses only 128 entries in the mapping
 * table, nevertheless. so we just define special "keyvalues" >128 for the
 * special keys.
 */

/* set-up key */
#define KEY_SETUP		129
/* break-key */
#define KEY_BREAK		130
/* cursor keys */
#define KEY_CURSOR_UP		131
#define KEY_CURSOR_DOWN		132
#define KEY_CURSOR_LEFT		133
#define KEY_CURSOR_RIGHT	134
/* return key */
#define KEY_RETURN		135
/* function keys on auxiliary keypad */
#define KEY_PF1			140
#define KEY_PF2			141
#define KEY_PF3			142
#define KEY_PF4			143
#define KEY_ENTER		144
/* number keys on auxiliary keypad */
#define KEY_NUMPAD_0		145
#define KEY_NUMPAD_1		146
#define KEY_NUMPAD_2		147
#define KEY_NUMPAD_3		148
#define KEY_NUMPAD_4		149
#define KEY_NUMPAD_5		150
#define KEY_NUMPAD_6		151
#define KEY_NUMPAD_7		152
#define KEY_NUMPAD_8		153
#define KEY_NUMPAD_9		154
/* other keys on auxiliary kepad */
#define KEY_NUMPAD_MINUS	155
#define KEY_NUMPAD_COMMA	156
#define KEY_NUMPAD_PERIOD	157

/* keys not present on vt102 keyboard, but useful nonetheless: */
#define KEY_NUMLOCK		160
#define KEY_DELETE		161

/* for debugging purposes: key to enable really verbose debugging */
#ifdef VT_DEBUG
#define KEY_DEBUG		230
#endif /* VT_DEBUG */

#endif /* __KEYDEFS_H_INCLUDED */
