/*
 * Copyright (C) 2012 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "zuse23_matrix.h"

#define COMP_(x)	zuse23_matrix_ ## x

unsigned char zuse23_matrix_sperr[16] = { 1, 1, /* 0, ... */ }; /* FIXME */

struct cpssp {
	int dummy;
};

#define S(x) \
static void \
COMP_(sperr ## x ## _set)(void *_cpssp, unsigned int val) \
{ \
	/* fprintf(stderr, "%s %d\n", __FUNCTION__, val); */ \
	zuse23_matrix_sperr[x] = val; \
}
	S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7);
	S(8); S(9); S(10); S(11); S(12); S(13); S(14); S(15);
#undef S

void *
COMP_(create)(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_sperr0,
	struct sig_boolean *port_sperr1,
	struct sig_boolean *port_sperr2,
	struct sig_boolean *port_sperr3,
	struct sig_boolean *port_sperr4,
	struct sig_boolean *port_sperr5,
	struct sig_boolean *port_sperr6,
	struct sig_boolean *port_sperr7,
	struct sig_boolean *port_sperr8,
	struct sig_boolean *port_sperr9,
	struct sig_boolean *port_sperr10,
	struct sig_boolean *port_sperr11,
	struct sig_boolean *port_sperr12,
	struct sig_boolean *port_sperr13,
	struct sig_boolean *port_sperr14,
	struct sig_boolean *port_sperr15
)
{
#define S(x) \
	static const struct sig_boolean_funcs sperr_func ## x = { \
		.set = COMP_(sperr ## x ## _set), \
	};
	S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7);
	S(8); S(9); S(10); S(11); S(12); S(13); S(14); S(15);
#undef S
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

#define S(x) \
	sig_boolean_connect_in(port_sperr ## x, cpssp, &sperr_func ## x);
	S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7);
	S(8); S(9); S(10); S(11); S(12); S(13); S(14); S(15);
#undef S

	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fp)
{
}

void
COMP_(resume)(void *_cpssp, FILE *fp)
{
}
