/*
 * Copyright (C) 2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_GUI_GTK_CONSOLE_H_INCLUDED
#define __GLUE_GUI_GTK_CONSOLE_H_INCLUDED

#include <gtk/gtk.h>

#include "lib/inspector.h"

#define MAX_PROMPT_LENGTH (1024)

struct insp_console_context_t {
	GtkTextBuffer *buffer;
	GtkTextMark *cursor;
	GtkScrolledWindow *scroll_ctx;
	GtkClipboard *clipboard;
	char prompt_buffer[MAX_PROMPT_LENGTH];
	size_t prompt_length;
};
typedef struct insp_console_context_t insp_console_context;

void insp_console_init(insp_console_context *ctx);
void insp_console_insert_text(insp_console_context *ctx,
                              const gchar *text, gint len);

void textbuf_append(GtkTextBuffer *buffer, const gchar *text, gint len,
                    GtkScrolledWindow *scrolling);

const char* insp_console_get_prompt_text(insp_console_context *ctx);
int insp_console_get_prompt_length(insp_console_context *ctx);
void insp_console_push_to_prompt(insp_console_context *ctx,
                                 const char *name, size_t len);
void insp_console_pop_from_prompt(insp_console_context *ctx);

void insp_console_handle_letter(insp_console_context *ctx, char c);
void insp_console_handle_backspace(insp_console_context *ctx);
void insp_console_handle_delete(insp_console_context *ctx);
void insp_console_handle_left(insp_console_context *ctx);
void insp_console_handle_right(insp_console_context *ctx);
void insp_console_handle_return(insp_console_context *ctx,
                                inspector_context* inspector);

GtkClipboard* insp_console_get_clipboard(insp_console_context *ctx);
void insp_console_set_clipboard(insp_console_context *ctx,
                                GtkClipboard *clipboard);

GtkScrolledWindow* insp_console_get_scroll_ctx(insp_console_context *ctx);
void insp_console_set_scroll_ctx(insp_console_context *ctx,
                                 GtkScrolledWindow *scroll_ctx);

GtkTextBuffer* insp_console_get_buffer(insp_console_context *ctx);
void insp_console_set_buffer(insp_console_context *ctx, GtkTextBuffer *buf);

GtkTextMark* insp_console_get_cursor(insp_console_context *ctx);

#endif /* __GLUE_GUI_GTK_CONSOLE_H_INCLUDED */
