/*
 * Copyright (C) 2010 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <fcntl.h>
#include <inttypes.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

/*
 * For the definitions of this fields see e.g.
 * linux-2.6-2.6.26/drivers/scsi/sym53c8xx_2/sym_nvram.h.
 */
static uint8_t cmos[0x164] = {
	0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x04, 0x10, 0x00, 0x00, 0x00, 0x04, 0x00, 0x01, 0x00, 0x00, 0x10,
	0x00, 0x50, 0x00, 0x00, 0x01, 0x00, 0x80, 0xc0, 0x04, 0x00, 0x01, 0x00, 0x00, 0x10, 0x00, 0x60,
	0x00, 0x00, 0x01, 0x00, 0x00, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0f, 0x00, 0x08, 0x08, 0x64, 0x00, 0x0a, 0x00, 0x0f, 0x00, 0x08, 0x08, 0x64, 0x00,
	0x0a, 0x00, 0x0f, 0x00, 0x08, 0x08, 0x64, 0x00, 0x0a, 0x00, 0x0f, 0x00, 0x08, 0x08, 0x64, 0x00,
	0x0a, 0x00, 0x0f, 0x00, 0x08, 0x08, 0x64, 0x00, 0x0a, 0x00, 0x0f, 0x00, 0x08, 0x08, 0x64, 0x00,
	0x0a, 0x00, 0x0f, 0x00, 0x08, 0x08, 0x64, 0x00, 0x0a, 0x00, 0x0f, 0x00, 0x08, 0x08, 0x64, 0x00,
	0x0a, 0x00, 0x0f, 0x00, 0x08, 0x08, 0x64, 0x00, 0x0a, 0x00, 0x0f, 0x00, 0x08, 0x08, 0x64, 0x00,
	0x0a, 0x00, 0x0f, 0x00, 0x08, 0x08, 0x64, 0x00, 0x0a, 0x00, 0x0f, 0x00, 0x08, 0x08, 0x64, 0x00,
	0x0a, 0x00, 0x0f, 0x00, 0x08, 0x08, 0x64, 0x00, 0x0a, 0x00, 0x0f, 0x00, 0x08, 0x08, 0x64, 0x00,
	0x0a, 0x00, 0x0f, 0x00, 0x08, 0x08, 0x64, 0x00, 0x0a, 0x00, 0x0f, 0x00, 0x08, 0x08, 0x64, 0x00,
	0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

int
main(void)
{
	uint8_t buf[2048];
	unsigned int csum;
	unsigned int x;
	int fd;
	int ret;

	/* Build CMOS file. */
	memset(&buf[0], 0, 256);

	/* Type */
	buf[256 + 0] = 0x00;
	buf[256 + 1] = 0x00;
	/* Byte count */
	buf[256 + 2] = 0x64;
	buf[256 + 3] = 0x01;

	/* Contents */
	memcpy(&buf[256 + 6], cmos, sizeof(cmos));

	/* Trailer */
	buf[256 + 6 + 0x164 + 0] = 0xfe;
	buf[256 + 6 + 0x164 + 1] = 0xfe;
	buf[256 + 6 + 0x164 + 2] = 0x00;
	buf[256 + 6 + 0x164 + 3] = 0x00;
	buf[256 + 6 + 0x164 + 4] = 0x00;
	buf[256 + 6 + 0x164 + 5] = 0x00;

	memset(&buf[256 + 6 + 0x164 + 6], 0, sizeof(buf) - 256 - 6 - 0x164 - 6);

	/* Fix checksum */
	csum = 0;
	for (x = 256 + 6; x < 256 + 6 + 0x164; x++) {
		csum += buf[x];
	}
	buf[256 + 4] = (csum >> 0) & 0xff;
	buf[256 + 5] = (csum >> 8) & 0xff;

	/* Write CMOS file. */
	fd = open("pci_lsi_20810.cmos", O_WRONLY | O_CREAT, 0666);
	assert(0 <= fd);

	ret = write(fd, buf, sizeof(buf));
	assert(ret == sizeof(buf));

	ret = close(fd);
	assert(0 <= ret);

	return 0;
}
