/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.lang.reflect.Array;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;

public class ImageData
extends Data {
    public ImageData(Header h) throws FitsException {
        Class<Number> baseClass;
        int gCount = h.getIntValue("GCOUNT", 1);
        int pCount = h.getIntValue("PCOUNT", 0);
        if (gCount > 1 || pCount != 0) {
            throw new FitsException("Currently unable to handle GROUPed data  GCOUNT=" + gCount + "; PCOUNT=" + pCount);
        }
        int bitpix = h.getIntValue("BITPIX", 0);
        if (bitpix == 8) {
            baseClass = Byte.TYPE;
        } else if (bitpix == 16) {
            baseClass = Short.TYPE;
        } else if (bitpix == 32) {
            baseClass = Integer.TYPE;
        } else if (bitpix == 64) {
            baseClass = Long.TYPE;
        } else if (bitpix == -32) {
            baseClass = Float.TYPE;
        } else if (bitpix == -64) {
            baseClass = Double.TYPE;
        } else {
            throw new FitsException("Invalid BITPIX:" + bitpix);
        }
        int ndim = h.getIntValue("NAXIS   ", 0);
        int[] dims = new int[ndim];
        for (int i = 0; i < ndim; ++i) {
            long cdim = h.getIntValue("NAXIS" + (i + 1), 0);
            if (cdim < 0L) {
                throw new FitsException("Invalid array dimension:" + cdim);
            }
            dims[ndim - i - 1] = (int)cdim;
        }
        if (ndim > 0) {
            this.dataArray = Array.newInstance(baseClass, dims);
        } else {
            int[] dim = new int[]{0};
            this.dataArray = Array.newInstance(baseClass, dim);
        }
    }

    public ImageData() {
        this.dataArray = new byte[0];
    }

    public ImageData(Object x) {
        this.dataArray = x;
    }
}

