/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import ucar.grib.GribChecker;
import ucar.grib.GribGDSVariablesIF;
import ucar.grib.GribGridRecord;
import ucar.grib.GribIndexName;
import ucar.grib.GribNumbers;
import ucar.grib.GribPDSVariablesIF;
import ucar.grib.GribReadIndex;
import ucar.grib.grib1.Grib1GDSVariables;
import ucar.grib.grib1.Grib1Grid;
import ucar.grib.grib1.Grib1PDSVariables;
import ucar.grib.grib1.Grib1Tables;
import ucar.grib.grib1.Grib1WriteIndex;
import ucar.grib.grib2.Grib2GDSVariables;
import ucar.grib.grib2.Grib2PDSVariables;
import ucar.grib.grib2.Grib2Tables;
import ucar.grib.grib2.Grib2WriteIndex;
import ucar.grid.GridDefRecord;
import ucar.grid.GridIndex;
import ucar.grid.GridRecord;
import ucar.unidata.io.RandomAccessFile;

public class ShowGribIndex {
    private static boolean debugTiming = true;
    private static boolean debugParse = false;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static String divider = "------------------------------------------------------------------";

    public ShowGribIndex() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public final void show(String location) throws IOException {
        try {
            GridIndex index = new GribReadIndex().open(location);
            Map<String, String> attrs = index.getGlobalAttributes();
            System.out.println("index_version = " + attrs.get("index_version"));
            System.out.println("grid_edition = " + attrs.get("grid_edition"));
            System.out.println("location = " + attrs.get("location"));
            System.out.println("length = " + attrs.get("length"));
            System.out.println("created = " + attrs.get("created"));
            System.out.println("center = " + attrs.get("center"));
            System.out.println("sub_center = " + attrs.get("sub_center"));
            System.out.println("table_version = " + attrs.get("table_version"));
            String basetime = attrs.get("basetime");
            System.out.println("basetime = " + basetime);
            System.out.println("ensemble = " + attrs.get("ensemble"));
            System.out.println("-----------------------------------------------------------------");
            List<GridRecord> records = index.getGridRecords();
            for (GridRecord gr : records) {
                GribGridRecord ggr = (GribGridRecord)gr;
                System.out.println(ggr.productType + " " + ggr.discipline + " " + ggr.category + " " + ggr.paramNumber + " " + ggr.typeGenProcess + " " + ggr.levelType1 + " " + ggr.levelValue1 + " " + ggr.levelType2 + " " + ggr.levelValue2 + " " + basetime + " " + ggr.forecastTime + " " + ggr.gdsKey + " " + ggr.offset1 + " " + ggr.offset2 + " " + ggr.decimalScale + " " + ggr.bmsExists + " " + ggr.center + " " + ggr.subCenter + " " + ggr.table + " " + ggr.type + " " + ggr.numberForecasts + " " + ggr.lowerLimit + " " + ggr.upperLimit);
            }
            System.out.println("-----------------------------------------------------------------");
            List<GridDefRecord> gdrs = index.getHorizCoordSys();
            for (GridDefRecord gdr : gdrs) {
                System.out.println("GDSkey = " + gdr.getParam("GDSkey"));
                System.out.println("grid_type = " + gdr.getParamInt("grid_type"));
                System.out.println("grid_name = " + gdr.getParam("grid_name"));
                int shape = gdr.getParamInt("grid_shape_code");
                System.out.println("grid_shape_code = " + shape);
                System.out.println("grid_shape = " + gdr.getParam("grid_shape"));
                if (shape < 2 || shape == 6 || shape == 8) {
                    System.out.println("grid_radius_spherical_earth = " + gdr.getParam("grid_radius_spherical_earth"));
                } else if (shape > 1 && shape < 6 || shape == 7) {
                    System.out.println("grid_major_axis_earth = " + gdr.getParam("grid_major_axis_earth"));
                    System.out.println("grid_minor_axis_earth = " + gdr.getParam("grid_minor_axis_earth"));
                }
                System.out.println("Nx = " + gdr.getParam("Nx"));
                System.out.println("Ny = " + gdr.getParam("Ny"));
                System.out.println("La1 = " + gdr.getParam("La1"));
                System.out.println("Lo1 = " + gdr.getParam("Lo1"));
                System.out.println("VectorComponentFlag = " + gdr.getParam("VectorComponentFlag"));
                System.out.println("Dx = " + gdr.getParam("Dx"));
                System.out.println("Dy = " + gdr.getParam("Dy"));
                Set<String> keys = gdr.getKeys();
                for (String key : keys) {
                    if (key.startsWith("grid") || key.startsWith("Dx") || key.startsWith("Dy") || key.startsWith("La1") || key.startsWith("Lo1") || key.startsWith("GDS") || key.startsWith("Nx") || key.startsWith("Ny") || key.startsWith("V")) continue;
                    System.out.println(key + " = " + gdr.getParam(key));
                }
                System.out.println("grid_units = " + gdr.getParam("grid_units"));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public final void open(String location) throws IOException {
        InputStream ios;
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        if (ios == null) {
            return;
        }
        this.open(location, ios);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open(String location, InputStream ios) throws IOException {
        long start = System.currentTimeMillis();
        FilterInputStream dis = null;
        try {
            int i;
            dis = new DataInputStream(new BufferedInputStream(ios));
            long lastModified = ((DataInputStream)dis).readLong();
            if (lastModified == 7597120008394602085L) {
                dis.close();
                dis = null;
                this.openText(location);
                return;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.setTimeInMillis(lastModified);
            if (debugTiming) {
                System.out.println("Grib file " + location.replace(".gbx8", "") + " was modified at " + this.dateFormat.format(calendar.getTime()));
            }
            String baseTime = null;
            boolean grid_edition_1 = false;
            String index_version = "";
            String line = ((DataInputStream)dis).readUTF();
            if (debugParse) {
                System.out.println(line);
            }
            int decimalScale = -9999;
            int center = -1;
            int subCenter = -1;
            int table = -1;
            String[] split = line.split("\\s");
            for (int i2 = 0; i2 < split.length; i2 += 2) {
                System.out.println(split[i2] + " = " + split[i2 + 1]);
                if (split[i2].equals("baseTime")) {
                    baseTime = split[i2 + 1];
                    continue;
                }
                if (split[i2].equals("grid_edition")) {
                    grid_edition_1 = split[i2 + 1].equals("1");
                    continue;
                }
                if (split[i2].equals("index_version")) {
                    index_version = split[i2 + 1];
                    continue;
                }
                if (split[i2].equals("center")) {
                    center = Integer.parseInt(split[i2 + 1]);
                    continue;
                }
                if (split[i2].equals("sub_center")) {
                    subCenter = Integer.parseInt(split[i2 + 1]);
                    continue;
                }
                if (!split[i2].equals("table_version")) continue;
                table = Integer.parseInt(split[i2 + 1]);
            }
            System.out.println(divider);
            int number = ((DataInputStream)dis).readInt();
            boolean bmsExists = false;
            for (i = 0; i < number; ++i) {
                GribPDSVariablesIF pdsv;
                if (index_version.equals("7.0")) {
                    int productType = ((DataInputStream)dis).readInt();
                    int discipline = ((DataInputStream)dis).readInt();
                    int category = ((DataInputStream)dis).readInt();
                    int param = ((DataInputStream)dis).readInt();
                    int typeGenProcess = ((DataInputStream)dis).readInt();
                    int levelType1 = ((DataInputStream)dis).readInt();
                    float levelValue1 = ((DataInputStream)dis).readFloat();
                    int levelType2 = ((DataInputStream)dis).readInt();
                    float levelValue2 = ((DataInputStream)dis).readFloat();
                    long refTime = ((DataInputStream)dis).readLong();
                    calendar.setTimeInMillis(refTime);
                    int foreTime = ((DataInputStream)dis).readInt();
                    int gdsKey = ((DataInputStream)dis).readInt();
                    long offset1 = ((DataInputStream)dis).readLong();
                    long offset2 = ((DataInputStream)dis).readLong();
                    System.out.print(productType + " " + discipline + " " + category + " " + param + " " + typeGenProcess + " " + levelType1 + " " + levelValue1 + " " + levelType2 + " " + levelValue2 + " " + this.dateFormat.format(calendar.getTime()) + " " + foreTime + " " + gdsKey + " " + offset1 + " " + offset2);
                    if (grid_edition_1) {
                        decimalScale = ((DataInputStream)dis).readInt();
                        bmsExists = ((DataInputStream)dis).readBoolean();
                        center = ((DataInputStream)dis).readInt();
                        subCenter = ((DataInputStream)dis).readInt();
                        table = ((DataInputStream)dis).readInt();
                        System.out.println(" " + decimalScale + " " + bmsExists + " " + center + " " + subCenter + " " + table);
                        continue;
                    }
                    System.out.println();
                    continue;
                }
                int discipline = ((DataInputStream)dis).readInt();
                long refTime = ((DataInputStream)dis).readLong();
                calendar.setTimeInMillis(refTime);
                int gdsKey = ((DataInputStream)dis).readInt();
                long offset1 = ((DataInputStream)dis).readLong();
                long offset2 = ((DataInputStream)dis).readLong();
                int pdsSize = ((DataInputStream)dis).readInt();
                byte[] pdsData = new byte[pdsSize];
                ((DataInputStream)dis).read(pdsData);
                if (grid_edition_1) {
                    pdsv = new Grib1PDSVariables(pdsData);
                    decimalScale = ((Grib1PDSVariables)pdsv).getDecimalScale();
                    bmsExists = ((Grib1PDSVariables)pdsv).bmsExists();
                    center = ((Grib1PDSVariables)pdsv).getCenter();
                    subCenter = ((Grib1PDSVariables)pdsv).getSubCenter();
                    table = ((Grib1PDSVariables)pdsv).getTableVersion();
                    System.out.print(((Grib1PDSVariables)pdsv).getProductDefinition() + " " + discipline + " " + ((Grib1PDSVariables)pdsv).getParameterCategory() + " " + ((Grib1PDSVariables)pdsv).getParameterNumber() + " " + ((Grib1PDSVariables)pdsv).getTypeGenProcess() + " " + ((Grib1PDSVariables)pdsv).getTypeFirstFixedSurface() + " " + ((Grib1PDSVariables)pdsv).getValueFirstFixedSurface() + " " + ((Grib1PDSVariables)pdsv).getTypeSecondFixedSurface() + " " + ((Grib1PDSVariables)pdsv).getValueSecondFixedSurface() + " " + this.dateFormat.format(calendar.getTime()) + " " + ((Grib1PDSVariables)pdsv).getForecastTime() + " " + gdsKey + " " + offset1 + " " + offset2 + " " + decimalScale + " " + bmsExists + " " + center + " " + subCenter + " " + table);
                    if (((Grib1PDSVariables)pdsv).isEnsemble()) {
                        System.out.println(" " + ((Grib1PDSVariables)pdsv).getType() + " " + ((Grib1PDSVariables)pdsv).getNumberForecasts() + " " + ((Grib1PDSVariables)pdsv).getValueLowerLimit() + " " + ((Grib1PDSVariables)pdsv).getValueUpperLimit());
                        continue;
                    }
                    System.out.println();
                    continue;
                }
                pdsv = new Grib2PDSVariables(pdsData);
                System.out.print(((Grib2PDSVariables)pdsv).getProductDefinition() + " " + discipline + " " + ((Grib2PDSVariables)pdsv).getParameterCategory() + " " + ((Grib2PDSVariables)pdsv).getParameterNumber() + " " + ((Grib2PDSVariables)pdsv).getTypeGenProcess() + " " + ((Grib2PDSVariables)pdsv).getTypeFirstFixedSurface() + " " + ((Grib2PDSVariables)pdsv).getValueFirstFixedSurface() + " " + ((Grib2PDSVariables)pdsv).getTypeSecondFixedSurface() + " " + ((Grib2PDSVariables)pdsv).getValueSecondFixedSurface() + " " + this.dateFormat.format(calendar.getTime()) + " " + ((Grib2PDSVariables)pdsv).getForecastTime() + " " + gdsKey + " " + offset1 + " " + offset2 + " " + decimalScale + " " + bmsExists + " " + center + " " + subCenter + " " + table);
                if (((Grib2PDSVariables)pdsv).isEnsemble()) {
                    System.out.println(" " + ((Grib2PDSVariables)pdsv).getType() + " " + ((Grib2PDSVariables)pdsv).getNumberForecasts() + " " + ((Grib2PDSVariables)pdsv).getValueLowerLimit() + " " + ((Grib2PDSVariables)pdsv).getValueUpperLimit());
                    continue;
                }
                System.out.println();
            }
            if (index_version.startsWith("7")) {
                while (!(line = ((DataInputStream)dis).readUTF()).equals("End")) {
                    System.out.println(divider);
                    split = line.split("\\t");
                    for (i = 0; i < split.length; i += 2) {
                        System.out.println(split[i] + " = " + split[i + 1]);
                    }
                }
            } else {
                number = ((DataInputStream)dis).readInt();
                for (i = 0; i < number; ++i) {
                    GribGDSVariablesIF gdsv;
                    int gdsSize = ((DataInputStream)dis).readInt();
                    if (gdsSize == 4) {
                        int gdskey = ((DataInputStream)dis).readInt();
                        System.out.println(divider);
                        Grib1Grid.PrintGDS(gdskey);
                        continue;
                    }
                    byte[] gdsData = new byte[gdsSize];
                    ((DataInputStream)dis).read(gdsData);
                    System.out.println(divider);
                    if (grid_edition_1) {
                        gdsv = new Grib1GDSVariables(gdsData);
                        this.Grib1GDS((Grib1GDSVariables)gdsv);
                        continue;
                    }
                    gdsv = new Grib2GDSVariables(gdsData);
                    this.Grib2GDS((Grib2GDSVariables)gdsv);
                }
            }
            if (debugTiming) {
                long took = System.currentTimeMillis() - start;
                System.out.println("Index read " + location + " took=" + took + " msec ");
            }
            return;
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    public void Grib2GDS(Grib2GDSVariables gdsv) {
        int component_flag;
        int gdtn = gdsv.getGdtn();
        System.out.println("GDSkey = " + Integer.toString(gdsv.getGdsKey()));
        System.out.println("grid_type = " + gdtn);
        System.out.println("grid_name = " + Grib2Tables.getGridName(gdtn));
        String winds = GribNumbers.isBitSet(gdsv.getResolution(), 8) ? "Relative" : "True";
        int n = component_flag = GribNumbers.isBitSet(gdsv.getResolution(), 8) ? 1 : 0;
        if ((gdtn < 50 || gdtn > 53) && gdtn != 100 && gdtn != 120 && gdtn != 1200) {
            int shape = gdsv.getShape();
            System.out.println("grid_shape_code = " + shape);
            System.out.println("grid_shape = " + Grib2Tables.getShapeName(shape));
            if (shape < 2 || shape == 6) {
                System.out.println("grid_radius_spherical_earth = " + gdsv.getEarthRadius());
            } else if (shape > 1 && shape < 5) {
                System.out.println("grid_major_axis_earth = " + gdsv.getMajorAxis());
                System.out.println("grid_minor_axis_earth = " + gdsv.getMinorAxis());
            }
        }
        if (gdsv.getOlon() == 0) {
            System.out.println("Quasi = false");
        } else {
            System.out.println("Quasi = true");
        }
        switch (gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                System.out.println("Nx = " + gdsv.getNx());
                System.out.println("Ny = " + gdsv.getNy());
                System.out.println("La1 = " + gdsv.getLa1());
                System.out.println("Lo1 = " + gdsv.getLo1());
                System.out.println("ResCompFlag = " + gdsv.getResolution());
                System.out.println("Winds = " + winds);
                System.out.println("VectorComponentFlag = " + component_flag);
                System.out.println("La2 = " + gdsv.getLa2());
                System.out.println("Lo2 = " + gdsv.getLo2());
                System.out.println("Dx = " + gdsv.getDx());
                System.out.println("Dy = " + gdsv.getDy());
                System.out.println("grid_units = " + gdsv.getGridUnits());
                if (gdtn == 1) {
                    System.out.println("SpLat = " + gdsv.getSpLat());
                    System.out.println("SpLon = " + gdsv.getSpLon());
                    System.out.println("RotationAngle = " + gdsv.getRotationAngle());
                    break;
                }
                if (gdtn == 2) {
                    System.out.println("pLat = " + gdsv.getPoleLat());
                    System.out.println("pLon = " + gdsv.getPoleLon());
                    System.out.println("StretchingFactor = " + gdsv.getStretchingFactor());
                    break;
                }
                if (gdtn != 3) break;
                System.out.println("SpLat = " + gdsv.getSpLat());
                System.out.println("SpLon = " + gdsv.getSpLon());
                System.out.println("RotationAngle = " + gdsv.getRotationAngle());
                System.out.println("pLat = " + gdsv.getPoleLat());
                System.out.println("pLon = " + gdsv.getPoleLon());
                System.out.println("StretchingFactor = " + gdsv.getStretchingFactor());
                break;
            }
            case 10: {
                System.out.println("Nx = " + gdsv.getNx());
                System.out.println("Ny = " + gdsv.getNy());
                System.out.println("La1 = " + gdsv.getLa1());
                System.out.println("Lo1 = " + gdsv.getLo1());
                System.out.println("ResCompFlag = " + gdsv.getResolution());
                System.out.println("Winds = " + winds);
                System.out.println("VectorComponentFlag = " + component_flag);
                System.out.println("LaD = " + gdsv.getLaD());
                System.out.println("La2 = " + gdsv.getLa2());
                System.out.println("Lo2 = " + gdsv.getLo2());
                System.out.println("BasicAngle = " + gdsv.getAngle());
                System.out.println("Dx = " + gdsv.getDx());
                System.out.println("Dy = " + gdsv.getDy());
                System.out.println("grid_units = " + gdsv.getGridUnits());
                break;
            }
            case 20: {
                System.out.println("Nx = " + gdsv.getNx());
                System.out.println("Ny = " + gdsv.getNy());
                System.out.println("La1 = " + gdsv.getLa1());
                System.out.println("Lo1 = " + gdsv.getLo1());
                System.out.println("ResCompFlag = " + gdsv.getResolution());
                System.out.println("Winds = " + winds);
                System.out.println("VectorComponentFlag = " + component_flag);
                System.out.println("LaD = " + gdsv.getLaD());
                System.out.println("LoV = " + gdsv.getLoV());
                System.out.println("Dx = " + gdsv.getDx());
                System.out.println("Dy = " + gdsv.getDy());
                System.out.println("grid_units = " + gdsv.getGridUnits());
                System.out.println("ProjFlag = " + gdsv.getProjectionFlag());
                String npproj = "false";
                if ((gdsv.getProjectionFlag() & 0x80) == 0) {
                    npproj = "true";
                }
                System.out.println("NpProj = " + npproj);
                break;
            }
            case 30: {
                System.out.println("Nx = " + gdsv.getNx());
                System.out.println("Ny = " + gdsv.getNy());
                System.out.println("La1 = " + gdsv.getLa1());
                System.out.println("Lo1 = " + gdsv.getLo1());
                System.out.println("ResCompFlag = " + gdsv.getResolution());
                System.out.println("Winds = " + winds);
                System.out.println("VectorComponentFlag = " + component_flag);
                System.out.println("LaD = " + gdsv.getLaD());
                System.out.println("LoV = " + gdsv.getLoV());
                System.out.println("Dx = " + gdsv.getDx());
                System.out.println("Dy = " + gdsv.getDy());
                System.out.println("grid_units = " + gdsv.getGridUnits());
                System.out.println("ProjFlag = " + gdsv.getProjectionFlag());
                String npproj = "false";
                if ((gdsv.getProjectionFlag() & 0x80) == 0) {
                    npproj = "true";
                }
                System.out.println("NpProj = " + npproj);
                System.out.println("Latin1 = " + gdsv.getLatin1());
                System.out.println("Latin2 = " + gdsv.getLatin2());
                System.out.println("SpLat = " + gdsv.getSpLat());
                System.out.println("SpLon = " + gdsv.getSpLon());
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                System.out.println("Nx = " + gdsv.getNx());
                System.out.println("Ny = " + gdsv.getNy());
                System.out.println("La1 = " + gdsv.getLa1());
                System.out.println("Lo1 = " + gdsv.getLo1());
                System.out.println("ResCompFlag = " + gdsv.getResolution());
                System.out.println("Winds = " + winds);
                System.out.println("VectorComponentFlag = " + component_flag);
                System.out.println("La2 = " + gdsv.getLa2());
                System.out.println("Lo2 = " + gdsv.getLo2());
                System.out.println("Dx = " + gdsv.getDx());
                System.out.println("grid_units = " + gdsv.getGridUnits());
                System.out.println("StretchingFactor = " + gdsv.getStretchingFactor());
                System.out.println("NumberParallels = " + gdsv.getNp());
                if (gdtn == 41) {
                    System.out.println("SpLat = " + gdsv.getSpLat());
                    System.out.println("SpLon = " + gdsv.getSpLon());
                    System.out.println("RotationAngle = " + gdsv.getRotationAngle());
                    break;
                }
                if (gdtn == 42) {
                    System.out.println("pLat = " + gdsv.getPoleLat());
                    System.out.println("pLon = " + gdsv.getPoleLon());
                    System.out.println("StretchingFactor = " + gdsv.getStretchingFactor());
                    break;
                }
                if (gdtn != 43) break;
                System.out.println("SpLat = " + gdsv.getSpLat());
                System.out.println("SpLon = " + gdsv.getSpLon());
                System.out.println("RotationAngle = " + gdsv.getRotationAngle());
                System.out.println("pLat = " + gdsv.getPoleLat());
                System.out.println("pLon = " + gdsv.getPoleLon());
                System.out.println("StretchingFactor = " + gdsv.getStretchingFactor());
                break;
            }
            case 90: {
                System.out.println("Nx = " + gdsv.getNx());
                System.out.println("Ny = " + gdsv.getNy());
                System.out.println("Lap = " + gdsv.getLap());
                System.out.println("Lop = " + gdsv.getLop());
                System.out.println("ResCompFlag = " + gdsv.getResolution());
                System.out.println("Winds = " + winds);
                System.out.println("VectorComponentFlag = " + component_flag);
                System.out.println("Dx = " + gdsv.getDx());
                System.out.println("Dy = " + gdsv.getDy());
                System.out.println("grid_units = " + gdsv.getGridUnits());
                System.out.println("Xp = " + gdsv.getXp());
                System.out.println("Yp = " + gdsv.getYp());
                System.out.println("Angle = " + gdsv.getAngle());
                System.out.println("Nr = " + gdsv.getNr());
                System.out.println("Xo = " + gdsv.getXo());
                System.out.println("Yo = " + gdsv.getYo());
                break;
            }
            case 110: {
                System.out.println("Nx = " + gdsv.getNx());
                System.out.println("Ny = " + gdsv.getNy());
                System.out.println("La1 = " + gdsv.getLa1());
                System.out.println("Lo1 = " + gdsv.getLo1());
                System.out.println("ResCompFlag = " + gdsv.getResolution());
                String npproj = "false";
                if ((gdsv.getProjectionFlag() & 0x80) == 0) {
                    npproj = "true";
                }
                System.out.println("NpProj = " + npproj);
                System.out.println("Winds = " + winds);
                System.out.println("VectorComponentFlag = " + component_flag);
                System.out.println("Dx = " + gdsv.getDx());
                System.out.println("Dy = " + gdsv.getDy());
                System.out.println("grid_units = " + gdsv.getGridUnits());
                System.out.println("ProjFlag = " + gdsv.getProjectionFlag());
                break;
            }
            case 204: {
                System.out.println("Nx = " + gdsv.getNx());
                System.out.println("Ny = " + gdsv.getNy());
                System.out.println("ResCompFlag = " + gdsv.getResolution());
                System.out.println("Winds = " + winds);
                System.out.println("VectorComponentFlag = " + component_flag);
                System.out.println("grid_units = " + gdsv.getGridUnits());
                break;
            }
            default: {
                System.out.println("\tUnknown Grid Type\t" + gdtn);
            }
        }
    }

    public void Grib1GDS(Grib1GDSVariables gdsv) {
        int component_flag;
        int gdtn = gdsv.getGdtn();
        System.out.println("GDSkey = " + Integer.toString(gdsv.getGdsKey()));
        System.out.println("grid_type = " + gdtn);
        System.out.println("grid_name = " + Grib1Tables.getName(gdtn));
        String winds = GribNumbers.isBitSet(gdsv.getResolution(), 8) ? "Relative" : "True";
        int n = component_flag = GribNumbers.isBitSet(gdsv.getResolution(), 8) ? 1 : 0;
        if ((gdtn < 50 || gdtn > 53) && gdtn != 100 && gdtn != 120 && gdtn != 1200) {
            int shape = gdsv.getShape();
            System.out.println("grid_shape_code = " + shape);
            System.out.println("grid_shape = " + Grib1Tables.getShapeName(shape));
            if (shape < 2 || shape == 6) {
                System.out.println("grid_radius_spherical_earth = " + gdsv.getEarthRadius());
            } else if (shape > 1 && shape < 5) {
                System.out.println("grid_major_axis_earth = " + gdsv.getMajorAxis());
                System.out.println("grid_minor_axis_earth = " + gdsv.getMinorAxis());
            }
        }
        switch (gdtn) {
            case 0: 
            case 10: 
            case 20: 
            case 30: 
            case 201: 
            case 202: 
            case 203: 
            case 205: {
                System.out.println("Nx = " + gdsv.getNx());
                System.out.println("Ny = " + gdsv.getNy());
                System.out.println("La1 = " + gdsv.getLa1());
                System.out.println("Lo1 = " + gdsv.getLo1());
                System.out.println("ResCompFlag = " + gdsv.getResolution());
                System.out.println("Winds = " + winds);
                System.out.println("VectorComponentFlag = " + component_flag);
                System.out.println("La2 = " + gdsv.getLa2());
                System.out.println("Lo2 = " + gdsv.getLo2());
                System.out.println("Dx = " + gdsv.getDx());
                System.out.println("Dy = " + gdsv.getDy());
                System.out.println("grid_units = " + gdsv.getGridUnits());
                if (gdtn == 10) {
                    System.out.println("SpLat = " + gdsv.getSpLat());
                    System.out.println("SpLon = " + gdsv.getSpLon());
                    System.out.println("RotationAngle = " + gdsv.getRotationAngle());
                    break;
                }
                if (gdtn == 20) {
                    System.out.println("pLat = " + gdsv.getPoleLat());
                    System.out.println("pLon = " + gdsv.getPoleLon());
                    System.out.println("StretchingFactor = " + gdsv.getStretchingFactor());
                    break;
                }
                if (gdtn != 30) break;
                System.out.println("SpLat = " + gdsv.getSpLat());
                System.out.println("SpLon = " + gdsv.getSpLon());
                System.out.println("RotationAngle = " + gdsv.getRotationAngle());
                System.out.println("pLat = " + gdsv.getPoleLat());
                System.out.println("pLon = " + gdsv.getPoleLon());
                System.out.println("StretchingFactor = " + gdsv.getStretchingFactor());
                break;
            }
            case 1: 
            case 6: {
                System.out.println("Nx = " + gdsv.getNx());
                System.out.println("Ny = " + gdsv.getNy());
                System.out.println("La1 = " + gdsv.getLa1());
                System.out.println("Lo1 = " + gdsv.getLo1());
                System.out.println("ResCompFlag = " + gdsv.getResolution());
                System.out.println("Winds = " + winds);
                System.out.println("VectorComponentFlag = " + component_flag);
                System.out.println("La2 = " + gdsv.getLa2());
                System.out.println("Lo2 = " + gdsv.getLo2());
                System.out.println("Latin = " + gdsv.getLatin1());
                System.out.println("Dx = " + gdsv.getDx());
                System.out.println("Dy = " + gdsv.getDy());
                System.out.println("grid_units = " + gdsv.getGridUnits());
                break;
            }
            case 5: {
                System.out.println("Nx = " + gdsv.getNx());
                System.out.println("Ny = " + gdsv.getNy());
                System.out.println("La1 = " + gdsv.getLa1());
                System.out.println("Lo1 = " + gdsv.getLo1());
                System.out.println("ResCompFlag = " + gdsv.getResolution());
                System.out.println("Winds = " + winds);
                System.out.println("VectorComponentFlag = " + component_flag);
                System.out.println("LoV = " + gdsv.getLoV());
                System.out.println("Dx = " + gdsv.getDx());
                System.out.println("Dy = " + gdsv.getDy());
                System.out.println("grid_units = " + gdsv.getGridUnits());
                System.out.println("ProjFlag = " + gdsv.getProjectionFlag());
                String npproj = "false";
                if ((gdsv.getProjectionFlag() & 0x80) == 0) {
                    npproj = "true";
                }
                System.out.println("NpProj = " + npproj);
                break;
            }
            case 3: 
            case 13: {
                System.out.println("Nx = " + gdsv.getNx());
                System.out.println("Ny = " + gdsv.getNy());
                System.out.println("La1 = " + gdsv.getLa1());
                System.out.println("Lo1 = " + gdsv.getLo1());
                System.out.println("ResCompFlag = " + gdsv.getResolution());
                System.out.println("Winds = " + winds);
                System.out.println("VectorComponentFlag = " + component_flag);
                System.out.println("LoV = " + gdsv.getLoV());
                System.out.println("Dx = " + gdsv.getDx());
                System.out.println("Dy = " + gdsv.getDy());
                System.out.println("grid_units = " + gdsv.getGridUnits());
                System.out.println("ProjFlag = " + gdsv.getProjectionFlag());
                String npproj = "false";
                if ((gdsv.getProjectionFlag() & 0x80) == 0) {
                    npproj = "true";
                }
                System.out.println("NpProj = " + npproj);
                System.out.println("Latin1 = " + gdsv.getLatin1());
                System.out.println("Latin2 = " + gdsv.getLatin2());
                System.out.println("SpLat = " + gdsv.getSpLat());
                System.out.println("SpLon = " + gdsv.getSpLon());
                break;
            }
            case 4: 
            case 14: 
            case 24: 
            case 34: {
                System.out.println("Nx = " + gdsv.getNx());
                System.out.println("Ny = " + gdsv.getNy());
                System.out.println("La1 = " + gdsv.getLa1());
                System.out.println("Lo1 = " + gdsv.getLo1());
                System.out.println("ResCompFlag = " + gdsv.getResolution());
                System.out.println("Winds = " + winds);
                System.out.println("VectorComponentFlag = " + component_flag);
                System.out.println("La2 = " + gdsv.getLa2());
                System.out.println("Lo2 = " + gdsv.getLo2());
                System.out.println("Dx = " + gdsv.getDx());
                System.out.println("grid_units = " + gdsv.getGridUnits());
                System.out.println("NumberParallels = " + gdsv.getNp());
                if (gdtn == 14) {
                    System.out.println("SpLat = " + gdsv.getSpLat());
                    System.out.println("SpLon = " + gdsv.getSpLon());
                    System.out.println("RotationAngle = " + gdsv.getRotationAngle());
                    break;
                }
                if (gdtn == 24) {
                    System.out.println("pLat = " + gdsv.getPoleLat());
                    System.out.println("pLon = " + gdsv.getPoleLon());
                    System.out.println("StretchingFactor = " + gdsv.getStretchingFactor());
                    break;
                }
                if (gdtn != 34) break;
                System.out.println("SpLat = " + gdsv.getSpLat());
                System.out.println("SpLon = " + gdsv.getSpLon());
                System.out.println("RotationAngle = " + gdsv.getRotationAngle());
                System.out.println("pLat = " + gdsv.getPoleLat());
                System.out.println("pLon = " + gdsv.getPoleLon());
                System.out.println("StretchingFactor = " + gdsv.getStretchingFactor());
                break;
            }
            case 90: {
                System.out.println("Nx = " + gdsv.getNx());
                System.out.println("Ny = " + gdsv.getNy());
                System.out.println("Lap = " + gdsv.getLap());
                System.out.println("Lop = " + gdsv.getLop());
                System.out.println("ResCompFlag = " + gdsv.getResolution());
                System.out.println("Winds = " + winds);
                System.out.println("VectorComponentFlag = " + component_flag);
                System.out.println("Dx = " + gdsv.getDx());
                System.out.println("Dy = " + gdsv.getDy());
                System.out.println("grid_units = " + gdsv.getGridUnits());
                System.out.println("Xp = " + gdsv.getXp());
                System.out.println("Yp = " + gdsv.getYp());
                System.out.println("Angle = " + gdsv.getAngle());
                System.out.println("Nr = " + gdsv.getNr());
                System.out.println("Xo = " + gdsv.getXo());
                System.out.println("Yo = " + gdsv.getYo());
                break;
            }
            case 204: {
                System.out.println("Nx = " + gdsv.getNx());
                System.out.println("Ny = " + gdsv.getNy());
                System.out.println("ResCompFlag = " + gdsv.getResolution());
                System.out.println("Winds = " + winds);
                System.out.println("VectorComponentFlag = " + component_flag);
                System.out.println("grid_units = " + gdsv.getGridUnits());
                break;
            }
            default: {
                System.out.println("\tUnknown Grid Type\t" + gdtn);
            }
        }
    }

    public final void openText(String location) throws IOException {
        String line;
        InputStream ios;
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        while ((line = dataIS.readLine()) != null && line.length() != 0) {
            System.out.println(line);
        }
        dataIS.close();
    }

    public static void main(String[] args) throws IOException {
        File gbx;
        String testName = "C:/data/NDFD.grib2.gbx8";
        debugTiming = false;
        if (args.length < 1) {
            new ShowGribIndex().open("C:/data/NDFD.grib2.gbx8");
        } else if ((args[0].endsWith(".gbx") || args[0].endsWith(".gbx8")) && (gbx = new File(args[0])).exists()) {
            new ShowGribIndex().show(gbx.getPath());
            return;
        }
        String gbxName = GribIndexName.getCurrentSuffix(args[0]);
        File gbx2 = new File(gbxName);
        if (gbx2.exists()) {
            new ShowGribIndex().open(gbx2.getPath());
            return;
        }
        String gribName = gbxName.replace(".gbx8", "");
        RandomAccessFile raf = new RandomAccessFile(gribName, "r");
        int edition = GribChecker.getEdition(raf);
        if (edition == 1) {
            Grib1WriteIndex.main(new String[]{gribName, gbxName});
        } else if (edition == 2) {
            Grib2WriteIndex.main(new String[]{gribName, gbxName});
        } else {
            System.out.println("Not a Grib file");
            return;
        }
        new ShowGribIndex().open(gbxName);
    }
}

