/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.Attribute;
import java.rmi.RemoteException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.dods.AttributeAdapter;
import visad.data.dods.ByteAttributeAdapter;
import visad.data.dods.ContainerAttributeAdapter;
import visad.data.dods.Float32AttributeAdapter;
import visad.data.dods.Float64AttributeAdapter;
import visad.data.dods.Int16AttributeAdapter;
import visad.data.dods.Int32AttributeAdapter;
import visad.data.dods.StringAttributeAdapter;
import visad.data.dods.UInt16AttributeAdapter;
import visad.data.dods.UInt32AttributeAdapter;
import visad.data.dods.UnknownAttributeAdapter;

public class AttributeAdapterFactory {
    private static final AttributeAdapterFactory instance = new AttributeAdapterFactory();

    protected AttributeAdapterFactory() {
    }

    public static AttributeAdapterFactory attributeAdapterFactory() {
        return instance;
    }

    public AttributeAdapter attributeAdapter(String name, Attribute attr) throws BadFormException, VisADException, RemoteException {
        AttributeAdapter adapter;
        int type = attr.getType();
        if (type == 10) {
            adapter = this.stringAdapter(name, attr);
        } else if (type == 3) {
            adapter = this.byteAdapter(name, attr);
        } else if (type == 4) {
            adapter = this.int16Adapter(name, attr);
        } else if (type == 5) {
            adapter = this.uInt16Adapter(name, attr);
        } else if (type == 6) {
            adapter = this.int32Adapter(name, attr);
        } else if (type == 7) {
            adapter = this.uInt32Adapter(name, attr);
        } else if (type == 8) {
            adapter = this.float32Adapter(name, attr);
        } else if (type == 9) {
            adapter = this.float64Adapter(name, attr);
        } else if (type == 2) {
            adapter = this.containerAdapter(name, attr);
        } else if (type == 1) {
            adapter = this.unknownAdapter(name, attr);
        } else {
            throw new BadFormException(this.getClass().getName() + ".attributeAdapter(): " + "Unknown DODS attribute type: " + attr.getTypeString());
        }
        return adapter;
    }

    public StringAttributeAdapter stringAdapter(String name, Attribute attr) throws VisADException, RemoteException {
        return new StringAttributeAdapter(name, attr);
    }

    public ByteAttributeAdapter byteAdapter(String name, Attribute attr) throws VisADException, RemoteException {
        return new ByteAttributeAdapter(name, attr);
    }

    public Int16AttributeAdapter int16Adapter(String name, Attribute attr) throws VisADException, RemoteException {
        return new Int16AttributeAdapter(name, attr);
    }

    public UInt16AttributeAdapter uInt16Adapter(String name, Attribute attr) throws VisADException, RemoteException {
        return new UInt16AttributeAdapter(name, attr);
    }

    public Int32AttributeAdapter int32Adapter(String name, Attribute attr) throws VisADException, RemoteException {
        return new Int32AttributeAdapter(name, attr);
    }

    public UInt32AttributeAdapter uInt32Adapter(String name, Attribute attr) throws VisADException, RemoteException {
        return new UInt32AttributeAdapter(name, attr);
    }

    public Float32AttributeAdapter float32Adapter(String name, Attribute attr) throws VisADException, RemoteException {
        return new Float32AttributeAdapter(name, attr);
    }

    public Float64AttributeAdapter float64Adapter(String name, Attribute attr) throws VisADException, RemoteException {
        return new Float64AttributeAdapter(name, attr);
    }

    public ContainerAttributeAdapter containerAdapter(String name, Attribute attr) throws VisADException, RemoteException {
        return new ContainerAttributeAdapter(name, attr, this);
    }

    public UnknownAttributeAdapter unknownAdapter(String name, Attribute attr) throws VisADException, RemoteException {
        return UnknownAttributeAdapter.unknownAttributeAdapter(name, attr);
    }
}

