/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.rmi.RemoteException;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Display;
import visad.DisplayException;
import visad.RangeControl;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.VisADException;
import visad.util.RangeSlider;
import visad.util.Util;

public class SelectRangeWidget
extends RangeSlider
implements ScalarMapListener,
ControlListener {
    private RangeControl rangeControl;

    public SelectRangeWidget(ScalarMap smap) throws VisADException, RemoteException {
        this(smap, true);
    }

    public SelectRangeWidget(ScalarMap smap, float min, float max) throws VisADException, RemoteException {
        this(smap, true);
        if (min == min || max == max) {
            System.err.println("Warning:  SelectRangeWidget initial range  values ignored");
        }
    }

    public SelectRangeWidget(ScalarMap smap, float min, float max, boolean update) throws VisADException, RemoteException {
        this(smap, true);
        if (min == min || max == max) {
            System.err.println("Warning:  SelectRangeWidget initial range  values ignored");
        }
    }

    public SelectRangeWidget(ScalarMap smap, boolean update) throws VisADException, RemoteException {
        super(RangeSlider.nameOf(smap), 0.0f, 1.0f);
        if (!Display.SelectRange.equals(smap.getDisplayScalar())) {
            throw new DisplayException("SelectRangeWidget: ScalarMap must be to Display.SelectRange");
        }
        double[] smapRange = smap.getRange();
        float[] wr = this.widenRange((float)smapRange[0], (float)smapRange[1]);
        this.resetValues(wr[0], wr[1]);
        this.rangeControl = (RangeControl)smap.getControl();
        if (update) {
            smap.addScalarMapListener(this);
        } else {
            this.setBounds(this.minLimit, this.maxLimit);
        }
        this.rangeControl.addControlListener(this);
        float[] range = this.rangeControl.getRange();
        if (range == null) {
            range = new float[]{this.minLimit, this.maxLimit};
        }
        if (range[0] != range[0] || range[1] != range[1]) {
            range[0] = this.minLimit;
            range[1] = this.maxLimit;
        }
        this.setValues(range[0], range[1]);
    }

    private void updateWidget(float min, float max) throws VisADException, RemoteException {
        this.rangeControl.setRange(new float[]{min, max});
        float[] wr = this.widenRange(min, max);
        this.setBounds(wr[0], wr[1]);
    }

    private float[] widenRange(float lo, float hi) {
        float newLo = lo;
        float newHi = hi;
        float widen = 0.001f * (hi - lo);
        if (Math.abs(widen) < 1.0E-4f) {
            return new float[]{lo - widen, hi + widen};
        }
        if ((double)(hi - lo) > 0.0) {
            newLo = (float)Math.floor(lo);
            newHi = (float)Math.ceil(hi);
        } else {
            newLo = (float)Math.ceil(lo);
            newHi = (float)Math.floor(hi);
        }
        return new float[]{newLo, newHi};
    }

    public void mapChanged(ScalarMapEvent e) {
        ScalarMap s = e.getScalarMap();
        double[] range = s.getRange();
        try {
            float r0 = (float)range[0];
            float r1 = (float)range[1];
            if (this.minValue != this.minValue || !Util.isApproximatelyEqual(r0, this.minValue) || this.maxValue != this.maxValue || !Util.isApproximatelyEqual(r1, this.maxValue)) {
                this.updateWidget(r0, r1);
            }
        }
        catch (VisADException exc) {
        }
        catch (RemoteException exc) {
            // empty catch block
        }
    }

    public void controlChanged(ScalarMapControlEvent evt) throws RemoteException, VisADException {
        int id = evt.getId();
        if (this.rangeControl != null && (id == 4 || id == 5)) {
            this.rangeControl.removeControlListener(this);
        }
        if (id == 5 || id == 3) {
            this.rangeControl = (RangeControl)evt.getScalarMap().getControl();
            this.controlChanged(new ControlEvent(this.rangeControl));
            this.rangeControl.addControlListener(this);
        }
    }

    public void valuesUpdated() {
        try {
            this.rangeControl.setRange(new float[]{this.minValue, this.maxValue});
        }
        catch (VisADException exc) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void controlChanged(ControlEvent e) throws VisADException, RemoteException {
        float[] range = this.rangeControl.getRange();
        this.setValues(range[0], range[1]);
    }
}

