/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class ImarisReader
extends FormatReader {
    private static final int IMARIS_MAGIC_NUMBER = 5021964;
    private static final boolean IS_LITTLE = false;
    private int[] offsets;

    public ImarisReader() {
        super("Bitplane Imaris", "ims");
    }

    public boolean isThisType(byte[] block) {
        return DataTools.bytesToInt(block, 0, 4, false) == 5021964;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        this.in.seek(this.offsets[no]);
        int row = this.core.sizeY[0] - 1;
        for (int i = 0; i < this.core.sizeY[0]; ++i) {
            this.in.read(buf, row * this.core.sizeX[0], this.core.sizeX[0]);
            --row;
        }
        return buf;
    }

    public boolean isThisType(String name, boolean open) {
        if (!super.isThisType(name, open)) {
            return false;
        }
        if (!open) {
            return true;
        }
        try {
            RandomAccessStream ras = new RandomAccessStream(name);
            byte[] b = new byte[4];
            ras.readFully(b);
            ras.close();
            return this.isThisType(b);
        }
        catch (IOException e) {
            return false;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("ImarisReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Verifying Imaris RAW format");
        this.in.order(false);
        long magic = this.in.readInt();
        if (magic != 5021964L) {
            throw new FormatException("Imaris magic number not found.");
        }
        this.status("Reading header");
        int version = this.in.readInt();
        this.addMeta("Version", new Integer(version));
        this.in.readInt();
        this.addMeta("Image name", this.in.readString(128));
        this.core.sizeX[0] = this.in.readShort();
        this.core.sizeY[0] = this.in.readShort();
        this.core.sizeZ[0] = this.in.readShort();
        this.in.skipBytes(2);
        this.core.sizeC[0] = this.in.readInt();
        this.in.skipBytes(2);
        this.addMeta("Original date", this.in.readString(32));
        float dx = this.in.readFloat();
        float dy = this.in.readFloat();
        float dz = this.in.readFloat();
        short mag = this.in.readShort();
        this.addMeta("Image comment", this.in.readString(128));
        int isSurvey = this.in.readInt();
        this.addMeta("Survey performed", isSurvey == 0 ? "true" : "false");
        this.status("Calculating image offsets");
        this.core.imageCount[0] = this.core.sizeZ[0] * this.core.sizeC[0];
        this.offsets = new int[this.core.imageCount[0]];
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            int offset = 332 + (i + 1) * 168 + i * this.core.sizeX[0] * this.core.sizeY[0] * this.core.sizeZ[0];
            for (int j = 0; j < this.core.sizeZ[0]; ++j) {
                this.offsets[i * this.core.sizeZ[0] + j] = offset + j * this.core.sizeX[0] * this.core.sizeY[0];
            }
        }
        this.status("Populating metadata");
        this.core.sizeT[0] = this.core.imageCount[0] / (this.core.sizeC[0] * this.core.sizeZ[0]);
        this.core.currentOrder[0] = "XYZCT";
        this.core.rgb[0] = false;
        this.core.interleaved[0] = false;
        this.core.littleEndian[0] = false;
        this.core.indexed[0] = false;
        this.core.falseColor[0] = false;
        this.core.metadataComplete[0] = true;
        MetadataStore store = this.getMetadataStore();
        this.core.pixelType[0] = 1;
        store.setImage(this.currentId, null, null, null);
        FormatTools.populatePixels(store, this);
        store.setDimensions(new Float(dx), new Float(dy), new Float(dz), new Float(1.0f), new Float(1.0f), null);
        store.setObjective(null, null, null, null, new Float(mag), null, null);
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }
}

