/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import opendap.dap.BadSemanticsException;
import opendap.dap.BaseType;
import opendap.dap.BaseTypeFactory;
import opendap.dap.DArray;
import opendap.dap.DConstructor;
import opendap.dap.DDS;
import opendap.dap.DDSException;
import opendap.dap.DGrid;
import opendap.dap.DVector;
import opendap.dap.parser.DDSParserConstants;
import opendap.dap.parser.DDSParserTokenManager;
import opendap.dap.parser.ParseException;
import opendap.dap.parser.SimpleCharStream;
import opendap.dap.parser.Token;

public class DDSParser
implements DDSParserConstants {
    private DDS dds;
    private BaseTypeFactory factory;
    private Stack ctor;
    private BaseType current;
    private int part;
    private String id;
    private static final String noDDSMsg = "The descriptor object returned from the dataset was null\nCheck that the URL is correct.";
    public DDSParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[20];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private void addEntry() {
        if (!this.ctor.empty()) {
            if (this.ctor.peek() instanceof DVector) {
                DVector top = (DVector)this.ctor.peek();
                top.addVariable(this.current);
                this.current = (BaseType)this.ctor.pop();
            } else if (this.ctor.peek() instanceof DConstructor) {
                DConstructor top = (DConstructor)this.ctor.peek();
                if (top instanceof DGrid) {
                    top.addVariable(this.current, this.part);
                } else {
                    top.addVariable(this.current);
                }
            }
        } else {
            this.dds.addVariable(this.current);
        }
    }

    private void throwBad(String s1) throws BadSemanticsException {
        throw new BadSemanticsException("In the dataset descriptor object:\n`" + s1 + "' is not a valid declaration.");
    }

    private void throwBad(String s1, String s2) throws BadSemanticsException {
        throw new BadSemanticsException("In the dataset descriptor object:\n`" + s1 + " " + s2 + "' is not a valid declaration");
    }

    private void checkAdd(String s1) throws BadSemanticsException {
        try {
            this.current.checkSemantics();
            this.addEntry();
        }
        catch (BadSemanticsException e) {
            this.throwBad(s1);
        }
    }

    private void checkAdd(String s1, String s2) throws BadSemanticsException {
        try {
            this.current.checkSemantics();
            this.addEntry();
        }
        catch (BadSemanticsException e) {
            this.throwBad(s1, s2);
        }
    }

    private boolean isKeyword(String word, String keyword) {
        return keyword.equalsIgnoreCase(word);
    }

    public final void Dataset(DDS dds, BaseTypeFactory factory) throws ParseException, DDSException {
        this.dds = dds;
        this.factory = factory;
        this.ctor = new Stack();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                this.jj_consume_token(20);
                this.Declarations();
                this.jj_consume_token(21);
                this.Name();
                this.jj_consume_token(22);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.error(noDDSMsg);
            }
        }
    }

    public final void Declarations() throws ParseException, DDSException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.Declaration();
        }
    }

    public final void Declaration() throws ParseException, DDSException {
        this.NonListDecl();
    }

    public final String NonListDecl() throws ParseException, DDSException {
        String s1 = null;
        String s2 = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    s1 = this.BaseType();
                    s2 = this.Var();
                    this.jj_consume_token(22);
                    this.checkAdd(s1, s2);
                    return s2;
                }
                case 8: {
                    this.Structure();
                    this.jj_consume_token(20);
                    this.Declarations();
                    this.jj_consume_token(21);
                    this.current = (BaseType)this.ctor.pop();
                    s1 = this.Var();
                    this.jj_consume_token(22);
                    this.checkAdd(s1);
                    return s1;
                }
                case 7: {
                    this.Sequence();
                    this.jj_consume_token(20);
                    this.Declarations();
                    this.jj_consume_token(21);
                    this.current = (BaseType)this.ctor.pop();
                    s1 = this.Var();
                    this.jj_consume_token(22);
                    this.checkAdd(s1);
                    return s1;
                }
                case 9: {
                    this.Grid();
                    this.jj_consume_token(20);
                    Token t = this.jj_consume_token(19);
                    this.jj_consume_token(23);
                    if (this.isKeyword(t.image, "array")) {
                        this.part = 1;
                    } else {
                        this.error("\nParse error: Expected the keyword \"Array:\"\nbut found: " + t.image + " instead.");
                    }
                    this.Declaration();
                    t = this.jj_consume_token(19);
                    this.jj_consume_token(23);
                    if (this.isKeyword(t.image, "maps")) {
                        this.part = 2;
                    } else {
                        this.error("\nParse error: Expected the keyword \"Maps:\"\nbut found: " + t.image + " instead.");
                    }
                    this.Declarations();
                    this.jj_consume_token(21);
                    this.current = (BaseType)this.ctor.pop();
                    s1 = this.Var();
                    this.jj_consume_token(22);
                    this.checkAdd(s1);
                    return s1;
                }
            }
            this.jj_la1[2] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        catch (ParseException e) {
            this.error("\nParse Error on token: " + s1 + "\n" + "In the dataset descriptor object:\n" + "Expected a variable declaration (e.g., Int32 i;).");
            throw new Error("Missing return statement in function");
        }
    }

    public final String Structure() throws ParseException {
        Token t = this.jj_consume_token(8);
        this.ctor.push(this.factory.newDStructure());
        return t.image;
    }

    public final String Sequence() throws ParseException {
        Token t = this.jj_consume_token(7);
        this.ctor.push(this.factory.newDSequence());
        return t.image;
    }

    public final String Grid() throws ParseException {
        Token t = this.jj_consume_token(9);
        this.ctor.push(this.factory.newDGrid());
        return t.image;
    }

    public final String BaseType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                Token t = this.jj_consume_token(10);
                this.current = this.factory.newDByte();
                return t.image;
            }
            case 11: {
                Token t = this.jj_consume_token(11);
                this.current = this.factory.newDInt16();
                return t.image;
            }
            case 12: {
                Token t = this.jj_consume_token(12);
                this.current = this.factory.newDUInt16();
                return t.image;
            }
            case 13: {
                Token t = this.jj_consume_token(13);
                this.current = this.factory.newDInt32();
                return t.image;
            }
            case 14: {
                Token t = this.jj_consume_token(14);
                this.current = this.factory.newDUInt32();
                return t.image;
            }
            case 15: {
                Token t = this.jj_consume_token(15);
                this.current = this.factory.newDFloat32();
                return t.image;
            }
            case 16: {
                Token t = this.jj_consume_token(16);
                this.current = this.factory.newDFloat64();
                return t.image;
            }
            case 17: {
                Token t = this.jj_consume_token(17);
                this.current = this.factory.newDString();
                return t.image;
            }
            case 18: {
                Token t = this.jj_consume_token(18);
                this.current = this.factory.newDURL();
                return t.image;
            }
        }
        this.jj_la1[3] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String Var() throws ParseException, DDSException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                Token t = this.jj_consume_token(19);
                this.current.setName(t.image);
                block54: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: {
                            break;
                        }
                        default: {
                            this.jj_la1[4] = this.jj_gen;
                            break block54;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 10: {
                Token t = this.jj_consume_token(10);
                this.current.setName(t.image);
                block55: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: {
                            break;
                        }
                        default: {
                            this.jj_la1[5] = this.jj_gen;
                            break block55;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 11: {
                Token t = this.jj_consume_token(11);
                this.current.setName(t.image);
                block56: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: {
                            break;
                        }
                        default: {
                            this.jj_la1[6] = this.jj_gen;
                            break block56;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 12: {
                Token t = this.jj_consume_token(12);
                this.current.setName(t.image);
                block57: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: {
                            break;
                        }
                        default: {
                            this.jj_la1[7] = this.jj_gen;
                            break block57;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 13: {
                Token t = this.jj_consume_token(13);
                this.current.setName(t.image);
                block58: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: {
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                            break block58;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 14: {
                Token t = this.jj_consume_token(14);
                this.current.setName(t.image);
                block59: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: {
                            break;
                        }
                        default: {
                            this.jj_la1[9] = this.jj_gen;
                            break block59;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 15: {
                Token t = this.jj_consume_token(15);
                this.current.setName(t.image);
                block60: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block60;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 16: {
                Token t = this.jj_consume_token(16);
                this.current.setName(t.image);
                block61: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: {
                            break;
                        }
                        default: {
                            this.jj_la1[11] = this.jj_gen;
                            break block61;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 17: {
                Token t = this.jj_consume_token(17);
                this.current.setName(t.image);
                block62: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: {
                            break;
                        }
                        default: {
                            this.jj_la1[12] = this.jj_gen;
                            break block62;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 18: {
                Token t = this.jj_consume_token(18);
                this.current.setName(t.image);
                block63: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: {
                            break;
                        }
                        default: {
                            this.jj_la1[13] = this.jj_gen;
                            break block63;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 8: {
                Token t = this.jj_consume_token(8);
                this.current.setName(t.image);
                block64: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: {
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                            break block64;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 7: {
                Token t = this.jj_consume_token(7);
                this.current.setName(t.image);
                block65: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: {
                            break;
                        }
                        default: {
                            this.jj_la1[15] = this.jj_gen;
                            break block65;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 9: {
                Token t = this.jj_consume_token(9);
                this.current.setName(t.image);
                block66: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: {
                            break;
                        }
                        default: {
                            this.jj_la1[16] = this.jj_gen;
                            break block66;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
        }
        this.jj_la1[17] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void ArrayDecl() throws ParseException, DDSException {
        Token t = new Token();
        try {
            if (this.jj_2_1(3)) {
                this.jj_consume_token(24);
                t = this.jj_consume_token(19);
                this.jj_consume_token(25);
                if (this.current instanceof DArray) {
                    ((DArray)this.current).appendDim(Integer.parseInt(t.image));
                } else {
                    DArray a = this.factory.newDArray();
                    a.addVariable(this.current);
                    a.appendDim(Integer.parseInt(t.image));
                    this.current = a;
                }
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        t = this.jj_consume_token(19);
                        this.id = t.image;
                        this.jj_consume_token(26);
                        t = this.jj_consume_token(19);
                        if (this.current instanceof DArray) {
                            ((DArray)this.current).appendDim(Integer.parseInt(t.image), this.id);
                        } else {
                            DArray a = this.factory.newDArray();
                            a.addVariable(this.current);
                            a.appendDim(Integer.parseInt(t.image), this.id);
                            this.current = a;
                        }
                        this.jj_consume_token(25);
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            this.error("\nThe index: " + t.image + " is not an integer value.\n" + "Index values must be integers.");
        }
        catch (ParseException e) {
            this.error("\nThere was a problem parsing the DDS:\nExpected an array subscript, but didn't find it\n\nThe offending line contains the characters: " + t.image + "\n\n" + "ParseException Message: \n" + e.getMessage() + "\n");
        }
    }

    public final void Name() throws ParseException, DDSException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: {
                    Token t = this.jj_consume_token(19);
                    this.dds.setName(t.image);
                    break;
                }
                case 10: {
                    Token t = this.jj_consume_token(10);
                    this.dds.setName(t.image);
                    break;
                }
                case 11: {
                    Token t = this.jj_consume_token(11);
                    this.dds.setName(t.image);
                    break;
                }
                case 12: {
                    Token t = this.jj_consume_token(12);
                    this.dds.setName(t.image);
                    break;
                }
                case 13: {
                    Token t = this.jj_consume_token(13);
                    this.dds.setName(t.image);
                    break;
                }
                case 14: {
                    Token t = this.jj_consume_token(14);
                    this.dds.setName(t.image);
                    break;
                }
                case 15: {
                    Token t = this.jj_consume_token(15);
                    this.dds.setName(t.image);
                    break;
                }
                case 16: {
                    Token t = this.jj_consume_token(16);
                    this.dds.setName(t.image);
                    break;
                }
                case 17: {
                    Token t = this.jj_consume_token(17);
                    this.dds.setName(t.image);
                    break;
                }
                case 18: {
                    Token t = this.jj_consume_token(18);
                    this.dds.setName(t.image);
                    break;
                }
                case 8: {
                    Token t = this.jj_consume_token(8);
                    this.dds.setName(t.image);
                    break;
                }
                case 7: {
                    Token t = this.jj_consume_token(7);
                    this.dds.setName(t.image);
                    break;
                }
                case 9: {
                    Token t = this.jj_consume_token(9);
                    this.dds.setName(t.image);
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException e) {
            this.error("Error parsing the dataset name.\nThe name may be missing or may contain an illegal character.");
        }
    }

    void error(String msg) throws ParseException, DDSException {
        throw new DDSException(0, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_scan_token(25);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{64, 524160, 524160, 523264, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 1048448, 0x1000000, 1048448};
    }

    public DDSParser(InputStream stream) {
        this(stream, null);
    }

    public DDSParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new DDSParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 20; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 20; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public DDSParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new DDSParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 20; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 20; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public DDSParser(DDSParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 20; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(DDSParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 20; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[27];
        for (i = 0; i < 27; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 20; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 27; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        DDSParser.jj_la1_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

