/*
 * Decompiled with CFR 0.152.
 */
package opendap.servers.test;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import opendap.dap.BaseType;
import opendap.dap.DAP2Exception;
import opendap.dap.DConstructor;
import opendap.dap.Server.CEEvaluator;
import opendap.dap.Server.ClauseFactory;
import opendap.dap.Server.FunctionLibrary;
import opendap.dap.Server.ServerDDS;
import opendap.dap.parser.ParseException;
import opendap.servers.test.testDataset;
import opendap.servers.test.testEngine;
import opendap.servers.test.test_SDArray;
import opendap.servlet.AbstractServlet;
import opendap.servlet.AsciiWriter;
import opendap.servlet.GuardedDataset;
import opendap.servlet.ReqState;

public class dts
extends AbstractServlet {
    private static FunctionLibrary functionLibrary = new FunctionLibrary("opendap.servers.test.SSF");
    private String ServerVersion = "DODS/3.2";

    public void init() throws ServletException {
        super.init();
        System.out.println("*************************************************");
        System.out.println("*************************************************");
        System.out.println("**************** DTS INIT ***********************");
        System.out.println("*************************************************");
        System.out.println("*************************************************");
    }

    public String getServerVersion() {
        return this.ServerVersion;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setHeader("Last-Modified", new Date().toString());
        System.out.println("*************************************************");
        System.out.println("**************** DTS doGet() ********************");
        System.out.println("*************************************************");
        super.doGet(request, response);
    }

    public void doGetDAP2Data(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        FilterOutputStream bOut;
        System.out.println("*************************************************");
        System.out.println("*************************************************");
        System.out.println("**************** DTS INIT ***********************");
        System.out.println("*************************************************");
        System.out.println("*************************************************");
        System.out.println("Sending OPeNDAP Data For: " + rs.getDataSet());
        response.setContentType("application/octet-stream");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods_data");
        response.setStatus(200);
        ServletOutputStream sOut = response.getOutputStream();
        if (rs.getAcceptsCompressed()) {
            response.setHeader("Content-Encoding", "deflate");
            bOut = new DeflaterOutputStream((OutputStream)sOut);
        } else {
            bOut = new BufferedOutputStream((OutputStream)sOut);
        }
        try {
            GuardedDataset ds = this.getDataset(rs);
            ServerDDS myDDS = ds.getDDS();
            this.cacheArrayShapes(myDDS);
            CEEvaluator ce = new CEEvaluator(myDDS, new ClauseFactory(functionLibrary));
            ce.parseConstraint(rs.getConstraintExpression());
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(bOut));
            myDDS.printConstrained(pw);
            pw.flush();
            ((OutputStream)bOut).write("\nData:\n".getBytes());
            ((OutputStream)bOut).flush();
            DataOutputStream sink = new DataOutputStream(bOut);
            int seqLength = 5;
            String sls = rs.getInitParameter("SequenceLength");
            if (sls != null) {
                seqLength = Integer.valueOf(sls);
            }
            testEngine te = new testEngine(seqLength);
            ce.send(myDDS.getName(), sink, te);
            sink.flush();
            if (rs.getAcceptsCompressed()) {
                ((DeflaterOutputStream)bOut).finish();
            }
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, response);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
    }

    public void doGetASC(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws Exception {
        System.out.println("*************************************************");
        System.out.println("Sending OPeNDAP ASCII Response  For: " + rs.getDataSet());
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setContentType("text/plain");
        response.setHeader("Content-Description", "dods_ascii");
        response.setStatus(200);
        try {
            GuardedDataset ds = this.getDataset(rs);
            ServerDDS myDDS = ds.getDDS();
            this.cacheArrayShapes(myDDS);
            CEEvaluator ce = new CEEvaluator(myDDS, new ClauseFactory(functionLibrary));
            ce.parseConstraint(rs.getConstraintExpression());
            int seqLength = 5;
            String sls = rs.getInitParameter("SequenceLength");
            if (sls != null) {
                seqLength = Integer.valueOf(sls);
            }
            System.out.println("Sequence Length: " + seqLength);
            testEngine te = new testEngine(seqLength);
            PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());
            myDDS.printConstrained(pw);
            pw.println("---------------------------------------------");
            AsciiWriter writer = new AsciiWriter();
            writer.toASCII(pw, myDDS, te);
            pw.flush();
            System.out.println("ASCII Response Sent");
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, response);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
    }

    public void doGetBLOB(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        FilterOutputStream bOut;
        System.out.println("Sending BLOB Data For: " + rs.getDataSet());
        response.setContentType("application/octet-stream");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods_blob");
        ServletOutputStream sOut = response.getOutputStream();
        if (rs.getAcceptsCompressed()) {
            response.setHeader("Content-Encoding", "deflate");
            bOut = new DeflaterOutputStream((OutputStream)sOut);
        } else {
            bOut = new BufferedOutputStream((OutputStream)sOut);
        }
        try {
            GuardedDataset ds = this.getDataset(rs);
            ServerDDS myDDS = ds.getDDS();
            this.cacheArrayShapes(myDDS);
            CEEvaluator ce = new CEEvaluator(myDDS, new ClauseFactory(functionLibrary));
            ce.parseConstraint(rs.getConstraintExpression());
            DataOutputStream sink = new DataOutputStream(bOut);
            int seqLength = 5;
            String sls = rs.getInitParameter("SequenceLength");
            if (sls != null) {
                seqLength = Integer.valueOf(sls);
            }
            testEngine te = new testEngine(seqLength);
            ce.send(myDDS.getName(), sink, te);
            sink.flush();
            if (rs.getAcceptsCompressed()) {
                ((DeflaterOutputStream)bOut).finish();
            }
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, response);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
        response.setStatus(200);
    }

    private void cacheArrayShapes(ServerDDS sdds) {
        Enumeration e = sdds.getVariables();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            this.cAS(bt);
        }
    }

    private void cAS(BaseType bt) {
        if (bt instanceof DConstructor) {
            Enumeration e = ((DConstructor)bt).getVariables();
            while (e.hasMoreElements()) {
                BaseType tbt = (BaseType)e.nextElement();
                this.cAS(tbt);
            }
        } else if (bt instanceof test_SDArray) {
            ((test_SDArray)bt).cacheShape();
        }
    }

    protected GuardedDataset getDataset(ReqState rs) throws DAP2Exception, IOException, ParseException {
        return new testDataset(rs);
    }
}

