/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvService;
import thredds.cataloggen.CatalogBuilder;
import thredds.cataloggen.CatalogRefExpander;
import thredds.cataloggen.DatasetEnhancer;
import thredds.cataloggen.DatasetScanCatalogBuilder;
import thredds.cataloggen.ProxyDatasetHandler;
import thredds.cataloggen.datasetenhancer.RegExpAndDurationTimeCoverageEnhancer;
import thredds.cataloggen.inserter.SimpleLatestProxyDsHandler;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFactory;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import thredds.crawlabledataset.CrawlableDatasetLabeler;
import thredds.crawlabledataset.CrawlableDatasetSorter;
import thredds.crawlabledataset.filter.LastModifiedLimitFilter;
import thredds.crawlabledataset.filter.MultiSelectorFilter;
import thredds.crawlabledataset.filter.RegExpMatchOnNameFilter;
import thredds.crawlabledataset.sorter.LexigraphicByNameSorter;

public class InvDatasetScan
extends InvCatalogRef {
    private static Logger log = LoggerFactory.getLogger(InvDatasetScan.class);
    private static String context = "/thredds";
    private static String catalogServletName = "/catalog";
    private final String rootPath;
    private String scanLocation;
    private CrawlableDataset scanLocationCrDs;
    private final String crDsClassName;
    private final Object crDsConfigObj;
    private final CrawlableDatasetFilter filter;
    private CrawlableDatasetLabeler identifier;
    private CrawlableDatasetLabeler namer;
    private CrawlableDatasetSorter sorter;
    private Map proxyDatasetHandlers;
    private boolean addDatasetSize;
    private List<DatasetEnhancer> childEnhancerList;
    private CatalogRefExpander catalogRefExpander;
    private boolean isValid;
    private StringBuilder invalidMessage;

    public static void setContext(String c) {
        context = c;
    }

    public static void setCatalogServletName(String catServletName) {
        catalogServletName = catServletName;
    }

    private static String makeHref(String path) {
        return context + (catalogServletName == null ? "" : catalogServletName) + "/" + path + "/catalog.xml";
    }

    public InvDatasetScan(InvDatasetImpl parent, String name, String path, String scanLocation, String id, InvDatasetScan from) {
        this(parent, name, path, scanLocation, from.crDsClassName, from.crDsConfigObj, from.filter, from.identifier, from.namer, from.addDatasetSize, from.sorter, from.proxyDatasetHandlers, from.childEnhancerList, from.catalogRefExpander);
        this.setID(id);
    }

    public InvDatasetScan(InvCatalogImpl catalog, InvDatasetImpl parent, String name, String path, String scanLocation, String filter, boolean addDatasetSize, String addLatest, boolean sortOrderIncreasing, String datasetNameMatchPattern, String startTimeSubstitutionPattern, String duration) {
        this(catalog, parent, name, path, scanLocation, filter, addDatasetSize, addLatest, sortOrderIncreasing, datasetNameMatchPattern, startTimeSubstitutionPattern, duration, 0L);
    }

    public InvDatasetScan(InvCatalogImpl catalog, InvDatasetImpl parent, String name, String path, String scanLocation, String filter, boolean addDatasetSize, String addLatest, boolean sortOrderIncreasing, String datasetNameMatchPattern, String startTimeSubstitutionPattern, String duration, long lastModifiedLimit) {
        super(parent, name, InvDatasetScan.makeHref(path));
        InvService service;
        log.debug("InvDatasetScan(): parent=" + parent + ", name=" + name + " , path=" + path + " , scanLocation=" + scanLocation + " , filter=" + filter + " , addLatest=" + addLatest + " , sortOrderIncreasing=" + sortOrderIncreasing + " , datasetNameMatchPattern=" + datasetNameMatchPattern + " , startTimeSubstitutionPattern= " + startTimeSubstitutionPattern + ", duration=" + duration);
        this.rootPath = path;
        this.scanLocation = scanLocation;
        this.crDsClassName = null;
        this.crDsConfigObj = null;
        this.scanLocationCrDs = this.createScanLocationCrDs();
        this.isValid = true;
        if (this.scanLocationCrDs == null) {
            this.isValid = false;
            this.invalidMessage = new StringBuilder("Invalid InvDatasetScan <path=").append(path).append("; scanLocation=").append(scanLocation).append(">: could not create CrawlableDataset for scanLocation.");
        } else if (!this.scanLocationCrDs.exists()) {
            this.isValid = false;
            this.invalidMessage = new StringBuilder("Invalid InvDatasetScan <path=").append(path).append("; scanLocation=").append(scanLocation).append(">: CrawlableDataset for scanLocation does not exist.");
        } else if (!this.scanLocationCrDs.isCollection()) {
            this.isValid = false;
            this.invalidMessage = new StringBuilder("Invalid InvDatasetScan <path=").append(path).append("; scanLocation=").append(scanLocation).append(">: CrawlableDataset for scanLocation not a collection.");
        }
        ArrayList<MultiSelectorFilter.Selector> selectors = new ArrayList<MultiSelectorFilter.Selector>();
        if (lastModifiedLimit > 0L) {
            selectors.add(new MultiSelectorFilter.Selector(new LastModifiedLimitFilter(lastModifiedLimit), false, true, false));
        }
        if (filter != null) {
            selectors.add(new MultiSelectorFilter.Selector(new RegExpMatchOnNameFilter(filter), true, true, false));
        }
        this.filter = selectors.size() > 0 ? new MultiSelectorFilter(selectors) : null;
        this.identifier = null;
        this.namer = null;
        this.addDatasetSize = addDatasetSize;
        this.sorter = new LexigraphicByNameSorter(sortOrderIncreasing);
        this.proxyDatasetHandlers = new HashMap();
        if (addLatest != null && addLatest.equalsIgnoreCase("true") && (service = catalog.findService("latest")) != null) {
            SimpleLatestProxyDsHandler proxyDsHandler = new SimpleLatestProxyDsHandler("latest.xml", true, service, true);
            this.proxyDatasetHandlers.put("latest.xml", proxyDsHandler);
        }
        if (datasetNameMatchPattern != null && startTimeSubstitutionPattern != null && duration != null) {
            this.childEnhancerList = new ArrayList<DatasetEnhancer>();
            this.childEnhancerList.add(RegExpAndDurationTimeCoverageEnhancer.getInstanceToMatchOnDatasetName(datasetNameMatchPattern, startTimeSubstitutionPattern, duration));
        }
    }

    public InvDatasetScan(InvDatasetImpl parent, String name, String path, String scanLocation, String configClassName, Object configObj, CrawlableDatasetFilter filter, CrawlableDatasetLabeler identifier, CrawlableDatasetLabeler namer, boolean addDatasetSize, CrawlableDatasetSorter sorter, Map proxyDatasetHandlers, List childEnhancerList, CatalogRefExpander catalogRefExpander) {
        super(parent, name, InvDatasetScan.makeHref(path));
        this.rootPath = path;
        this.scanLocation = scanLocation;
        this.crDsClassName = configClassName;
        this.crDsConfigObj = configObj;
        this.scanLocationCrDs = this.createScanLocationCrDs();
        this.isValid = true;
        if (this.scanLocationCrDs == null) {
            this.isValid = false;
            this.invalidMessage = new StringBuilder("Invalid InvDatasetScan <path=").append(path).append("; scanLocation=").append(scanLocation).append(">: could not create CrawlableDataset for scanLocation.");
        } else if (!this.scanLocationCrDs.exists()) {
            this.isValid = false;
            this.invalidMessage = new StringBuilder("Invalid InvDatasetScan <path=").append(path).append("; scanLocation=").append(scanLocation).append(">: CrawlableDataset for scanLocation does not exist.");
        } else if (!this.scanLocationCrDs.isCollection()) {
            this.isValid = false;
            this.invalidMessage = new StringBuilder("Invalid InvDatasetScan <path=").append(path).append("; scanLocation=").append(scanLocation).append(">: CrawlableDataset for scanLocation not a collection.");
        }
        this.filter = filter;
        this.identifier = identifier;
        this.namer = namer;
        this.addDatasetSize = addDatasetSize;
        this.sorter = sorter;
        this.childEnhancerList = childEnhancerList;
        this.catalogRefExpander = catalogRefExpander;
        this.proxyDatasetHandlers = proxyDatasetHandlers == null ? new HashMap() : proxyDatasetHandlers;
    }

    public String getPath() {
        return this.rootPath;
    }

    public String getScanLocation() {
        return this.scanLocation;
    }

    public void setScanLocation(String scanLocation) {
        if (!scanLocation.equals(this.scanLocation)) {
            this.isValid = true;
            this.scanLocation = scanLocation;
            this.scanLocationCrDs = this.createScanLocationCrDs();
            if (this.scanLocationCrDs == null) {
                this.isValid = false;
                this.invalidMessage = new StringBuilder("Invalid InvDatasetScan <path=").append(this.rootPath).append("; scanLocation=").append(scanLocation).append(">: could not create CrawlableDataset for scanLocation.");
            } else if (!this.scanLocationCrDs.exists()) {
                this.isValid = false;
                this.invalidMessage = new StringBuilder("Invalid InvDatasetScan <path=").append(this.rootPath).append("; scanLocation=").append(scanLocation).append(">: CrawlableDataset for scanLocation does not exist.");
            } else if (!this.scanLocationCrDs.isCollection()) {
                this.isValid = false;
                this.invalidMessage = new StringBuilder("Invalid InvDatasetScan <path=").append(this.rootPath).append("; scanLocation=").append(scanLocation).append(">: CrawlableDataset for scanLocation not a collection.");
            }
        }
    }

    public String getCrDsClassName() {
        return this.crDsClassName;
    }

    public Object getCrDsConfigObj() {
        return this.crDsConfigObj;
    }

    public CrawlableDatasetFilter getFilter() {
        return this.filter;
    }

    public CrawlableDatasetLabeler getIdentifier() {
        return this.identifier;
    }

    public CrawlableDatasetLabeler getNamer() {
        return this.namer;
    }

    public CrawlableDatasetSorter getSorter() {
        return this.sorter;
    }

    public Map getProxyDatasetHandlers() {
        return this.proxyDatasetHandlers;
    }

    public boolean getAddDatasetSize() {
        return this.addDatasetSize;
    }

    public List getChildEnhancerList() {
        return this.childEnhancerList;
    }

    public CatalogRefExpander getCatalogRefExpander() {
        return this.catalogRefExpander;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getInvalidMessage() {
        return this.invalidMessage.toString();
    }

    private CrawlableDataset createScanLocationCrDs() {
        CrawlableDataset scanLocationCrDs;
        try {
            scanLocationCrDs = CrawlableDatasetFactory.createCrawlableDataset(this.scanLocation, this.crDsClassName, this.crDsConfigObj);
        }
        catch (IllegalAccessException e) {
            log.error("createScanLocationCrDs(): failed to create CrawlableDataset for collectionLevel <" + this.scanLocation + "> and class <" + this.crDsClassName + ">: " + e.getMessage());
            return null;
        }
        catch (NoSuchMethodException e) {
            log.error("createScanLocationCrDs(): failed to create CrawlableDataset for collectionLevel <" + this.scanLocation + "> and class <" + this.crDsClassName + ">: " + e.getMessage());
            return null;
        }
        catch (IOException e) {
            log.error("createScanLocationCrDs(): failed to create CrawlableDataset for collectionLevel <" + this.scanLocation + "> and class <" + this.crDsClassName + ">: " + e.getMessage());
            return null;
        }
        catch (InvocationTargetException e) {
            log.error("createScanLocationCrDs(): failed to create CrawlableDataset for collectionLevel <" + this.scanLocation + "> and class <" + this.crDsClassName + ">: " + e.getMessage());
            return null;
        }
        catch (InstantiationException e) {
            log.error("createScanLocationCrDs(): failed to create CrawlableDataset for collectionLevel <" + this.scanLocation + "> and class <" + this.crDsClassName + ">: " + e.getMessage());
            return null;
        }
        catch (ClassNotFoundException e) {
            log.error("createScanLocationCrDs(): failed to create CrawlableDataset for collectionLevel <" + this.scanLocation + "> and class <" + this.crDsClassName + ">: " + e.getMessage());
            return null;
        }
        return scanLocationCrDs;
    }

    private CatalogBuilder buildCatalogBuilder() {
        DatasetScanCatalogBuilder dsScanCatBuilder;
        InvService service = this.getServiceDefault();
        try {
            dsScanCatBuilder = new DatasetScanCatalogBuilder(this, this.scanLocationCrDs, service);
        }
        catch (IllegalArgumentException e) {
            log.error("buildCatalogBuilder(): failed to create CatalogBuilder for this collection <" + this.scanLocationCrDs.getPath() + ">: " + e.getMessage());
            return null;
        }
        return dsScanCatBuilder;
    }

    public String translatePathToLocation(String dsPath) {
        if (dsPath == null) {
            return null;
        }
        if (dsPath.length() > 0 && dsPath.startsWith("/")) {
            dsPath = dsPath.substring(1);
        }
        if (!dsPath.startsWith(this.getPath())) {
            return null;
        }
        String dataDir = dsPath.substring(this.getPath().length());
        if (dataDir.startsWith("/")) {
            dataDir = dataDir.substring(1);
        }
        CrawlableDataset curCrDs = this.scanLocationCrDs.getDescendant(dataDir);
        if (log.isDebugEnabled()) {
            log.debug("translatePathToLocation(): url dsPath= " + dsPath + " to dataset dsPath= " + curCrDs.getPath());
        }
        return curCrDs.getPath();
    }

    public CrawlableDataset requestCrawlableDataset(String path) throws IOException {
        String crDsPath = this.translatePathToLocation(path);
        if (crDsPath == null) {
            return null;
        }
        CatalogBuilder catBuilder = this.buildCatalogBuilder();
        if (catBuilder == null) {
            return null;
        }
        return catBuilder.requestCrawlableDataset(crDsPath);
    }

    public InvCatalogImpl makeCatalogForDirectory(String orgPath, URI baseURI) {
        InvCatalogImpl catalog;
        CrawlableDataset catalogCrDs;
        String dsDirPath;
        if (log.isDebugEnabled()) {
            log.debug("baseURI=" + baseURI);
            log.debug("orgPath=" + orgPath);
            log.debug("rootPath=" + this.rootPath);
            log.debug("scanLocation=" + this.scanLocation);
        }
        if ((dsDirPath = this.translatePathToLocation(orgPath)) == null) {
            String tmpMsg = "makeCatalogForDirectory(): Requsting path <" + orgPath + "> must start with \"" + this.rootPath + "\".";
            log.error(tmpMsg);
            return null;
        }
        String dsPath = dsDirPath.substring(this.scanLocationCrDs.getPath().length());
        if (dsPath.startsWith("/")) {
            dsPath = dsPath.substring(1);
        }
        CrawlableDataset reqCrDs = this.scanLocationCrDs.getDescendant(dsPath);
        dsDirPath = reqCrDs.getParentDataset().getPath();
        CatalogBuilder catBuilder = this.buildCatalogBuilder();
        if (catBuilder == null) {
            return null;
        }
        try {
            catalogCrDs = catBuilder.requestCrawlableDataset(dsDirPath);
        }
        catch (IOException e) {
            log.error("makeCatalogForDirectory(): I/O error getting catalog level <" + dsDirPath + ">: " + e.getMessage(), e);
            return null;
        }
        if (catalogCrDs == null) {
            log.warn("makeCatalogForDirectory(): requested catalog level <" + dsDirPath + "> not allowed (filtered out).");
            return null;
        }
        if (!catalogCrDs.isCollection()) {
            log.warn("makeCatalogForDirectory(): requested catalog level <" + dsDirPath + "> is not a collection.");
            return null;
        }
        try {
            catalog = catBuilder.generateCatalog(catalogCrDs);
        }
        catch (IOException e) {
            log.error("makeCatalogForDirectory(): catalog generation failed <" + catalogCrDs.getPath() + ">: " + e.getMessage());
            return null;
        }
        if (catalog != null) {
            catalog.setBaseURI(baseURI);
        }
        return catalog;
    }

    public InvCatalogImpl makeProxyDsResolverCatalog(String path, URI baseURI) {
        InvCatalogImpl catalog;
        CrawlableDataset catalogCrDs;
        if (path == null) {
            return null;
        }
        if (path.endsWith("/")) {
            return null;
        }
        String dsDirPath = this.translatePathToLocation(path);
        if (dsDirPath == null) {
            log.error("makeProxyDsResolverCatalog(): Requsting path <" + path + "> must start with \"" + this.rootPath + "\".");
            return null;
        }
        int pos = dsDirPath.lastIndexOf("/");
        if (pos == -1) {
            log.error("makeProxyDsResolverCatalog(): Requsting path <" + path + "> must contain a slash (\"/\").");
            return null;
        }
        String dsName = dsDirPath.substring(pos + 1);
        dsDirPath = dsDirPath.substring(0, pos);
        ProxyDatasetHandler pdh = (ProxyDatasetHandler)this.getProxyDatasetHandlers().get(dsName);
        if (pdh == null) {
            log.error("makeProxyDsResolverCatalog(): No matching proxy dataset handler found <" + dsName + ">.");
            return null;
        }
        CatalogBuilder catBuilder = this.buildCatalogBuilder();
        if (catBuilder == null) {
            return null;
        }
        try {
            catalogCrDs = catBuilder.requestCrawlableDataset(dsDirPath);
        }
        catch (IOException e) {
            log.error("makeProxyDsResolverCatalog(): failed to create CrawlableDataset for catalogLevel <" + dsDirPath + "> and class <" + this.crDsClassName + ">: " + e.getMessage(), e);
            return null;
        }
        if (catalogCrDs == null) {
            log.warn("makeProxyDsResolverCatalog(): requested catalog level <" + dsDirPath + "> not allowed (filtered out).");
            return null;
        }
        if (!catalogCrDs.isCollection()) {
            log.warn("makeProxyDsResolverCatalog(): requested catalog level <" + dsDirPath + "> not a collection.");
            return null;
        }
        try {
            catalog = catBuilder.generateProxyDsResolverCatalog(catalogCrDs, pdh);
        }
        catch (IOException e) {
            log.error("makeProxyDsResolverCatalog(): catalog generation failed <" + catalogCrDs.getPath() + ">: " + e.getMessage());
            return null;
        }
        if (catalog != null) {
            catalog.setBaseURI(baseURI);
        }
        return catalog;
    }

    public InvCatalog makeLatestCatalogForDirectory(String orgPath, URI baseURI) {
        InvCatalogImpl cat = this.makeCatalogForDirectory(orgPath, baseURI);
        if (cat == null) {
            return null;
        }
        InvDatasetImpl topDs = (InvDatasetImpl)cat.getDatasets().get(0);
        Iterator<InvDataset> it = topDs.getDatasets().iterator();
        while (it.hasNext()) {
            InvDatasetImpl curDs = (InvDatasetImpl)it.next();
            if (curDs.hasAccess() && !curDs.getUrlPath().endsWith("latest.xml")) continue;
            it.remove();
        }
        if (topDs.getDatasets().isEmpty()) {
            return null;
        }
        InvDatasetImpl latestDs = (InvDatasetImpl)Collections.max(topDs.getDatasets(), new Comparator(){

            public int compare(Object obj1, Object obj2) {
                InvDataset ds1 = (InvDataset)obj1;
                InvDataset ds2 = (InvDataset)obj2;
                return ds1.getName().compareTo(ds2.getName());
            }
        });
        String baseName = topDs.getName();
        String latestName = baseName.equals("") ? "Latest" : "Latest " + baseName;
        latestDs.setName(latestName);
        cat.subset(latestDs);
        return cat;
    }

    public boolean isRead() {
        return false;
    }

    boolean check(StringBuilder out, boolean show) {
        boolean isValid = true;
        if (this.getPath() == null) {
            out.append("**Error: DatasetScan (").append(this.getFullName()).append("): must have path attribute\n");
            isValid = false;
        }
        if (this.getScanLocation() == null) {
            out.append("**Error: DatasetScan (").append(this.getFullName()).append("): must have dirLocation attribute\n");
            isValid = false;
        }
        if (this.getServiceDefault() == null) {
            out.append("**Error: DatasetScan (").append(this.getFullName()).append("): must have a default service\n");
            isValid = false;
        }
        return isValid && super.check(out, show);
    }
}

