/* tp-zeitgeist.c generated by valac 0.24.0, the Vala compiler
 * generated from tp-zeitgeist.vala, do not modify */

/*
 * Copyright (C) 2013 Philip Withnall
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Authors:
 * 	Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <zeitgeist.h>
#include <stdlib.h>
#include <string.h>
#include <telepathy-glib/telepathy-glib.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <zeitgeist-datamodel.h>
#include <gee.h>


#define FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER (folks_tp_zeitgeist_controller_get_type ())
#define FOLKS_TP_ZEITGEIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER, FolksTpZeitgeistController))
#define FOLKS_TP_ZEITGEIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER, FolksTpZeitgeistControllerClass))
#define FOLKS_TP_ZEITGEIST_IS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER))
#define FOLKS_TP_ZEITGEIST_IS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER))
#define FOLKS_TP_ZEITGEIST_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER, FolksTpZeitgeistControllerClass))

typedef struct _FolksTpZeitgeistController FolksTpZeitgeistController;
typedef struct _FolksTpZeitgeistControllerClass FolksTpZeitgeistControllerClass;
typedef struct _FolksTpZeitgeistControllerPrivate FolksTpZeitgeistControllerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _FolksTpZeitgeistControllerPopulateCountersData FolksTpZeitgeistControllerPopulateCountersData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _FolksTpZeitgeistController {
	GObject parent_instance;
	FolksTpZeitgeistControllerPrivate * priv;
};

struct _FolksTpZeitgeistControllerClass {
	GObjectClass parent_class;
};

typedef void (*FolksTpZeitgeistControllerIncreasePersonaCounter) (FolksPersona* p, GDateTime* converted_datetime);
struct _FolksTpZeitgeistControllerPrivate {
	ZeitgeistLog* _log;
	ZeitgeistMonitor* _monitor;
	gchar* _protocol;
	TpAccount* _account;
	FolksPersonaStore* _store;
	FolksTpZeitgeistControllerIncreasePersonaCounter _im_interaction_cb;
	FolksTpZeitgeistControllerIncreasePersonaCounter _last_call_interaction_cb;
};

struct _FolksTpZeitgeistControllerPopulateCountersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksTpZeitgeistController* self;
	ZeitgeistLog* _tmp0_;
	ZeitgeistLog* _tmp1_;
	GTimeVal tm;
	gint64 end_timestamp;
	GTimeVal _tmp2_;
	glong _tmp3_;
	gint64 start_timestamp;
	gint64 _tmp4_;
	GPtrArray* events;
	GPtrArray* _tmp5_;
	ZeitgeistResultSet* results;
	ZeitgeistLog* _tmp6_;
	gint64 _tmp7_;
	gint64 _tmp8_;
	ZeitgeistTimeRange* _tmp9_;
	ZeitgeistTimeRange* _tmp10_;
	GPtrArray* _tmp11_;
	ZeitgeistResultSet* _tmp12_;
	ZeitgeistResultSet* _tmp13_;
	ZeitgeistResultSet* _e_it;
	ZeitgeistResultSet* _tmp14_;
	ZeitgeistResultSet* _tmp15_;
	ZeitgeistEvent* e;
	ZeitgeistResultSet* _tmp16_;
	ZeitgeistEvent* _tmp17_;
	ZeitgeistEvent* _tmp18_;
	gchar* interaction_type;
	ZeitgeistEvent* _tmp19_;
	ZeitgeistSubject* _tmp20_;
	ZeitgeistSubject* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gint i;
	gboolean _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	ZeitgeistEvent* _tmp29_;
	gint _tmp30_;
	gchar* id;
	ZeitgeistEvent* _tmp31_;
	gint _tmp32_;
	ZeitgeistSubject* _tmp33_;
	ZeitgeistSubject* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gboolean _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	FolksPersona* persona;
	FolksPersonaStore* _tmp42_;
	GeeMap* _tmp43_;
	GeeMap* _tmp44_;
	const gchar* _tmp45_;
	gpointer _tmp46_;
	FolksPersona* _tmp47_;
	FolksPersona* _tmp48_;
	FolksPersona* _tmp49_;
	const gchar* _tmp50_;
	ZeitgeistEvent* _tmp51_;
	ZeitgeistResultSet* _vala1__e_it;
	ZeitgeistResultSet* _tmp52_;
	ZeitgeistResultSet* _tmp53_;
	ZeitgeistEvent* _vala1_e;
	ZeitgeistResultSet* _tmp54_;
	ZeitgeistEvent* _tmp55_;
	ZeitgeistEvent* _tmp56_;
	gchar* _vala1_interaction_type;
	ZeitgeistEvent* _tmp57_;
	ZeitgeistSubject* _tmp58_;
	ZeitgeistSubject* _tmp59_;
	const gchar* _tmp60_;
	const gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gint _vala1_i;
	gboolean _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	ZeitgeistEvent* _tmp67_;
	gint _tmp68_;
	gchar* _vala1_id;
	ZeitgeistEvent* _tmp69_;
	gint _tmp70_;
	ZeitgeistSubject* _tmp71_;
	ZeitgeistSubject* _tmp72_;
	const gchar* _tmp73_;
	const gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gboolean _tmp77_;
	const gchar* _tmp78_;
	const gchar* _tmp79_;
	FolksPersona* _vala1_persona;
	FolksPersonaStore* _tmp80_;
	GeeMap* _tmp81_;
	GeeMap* _tmp82_;
	const gchar* _tmp83_;
	gpointer _tmp84_;
	FolksPersona* _tmp85_;
	FolksPersona* _tmp86_;
	ZeitgeistMonitor* _tmp87_;
	GPtrArray* monitor_events;
	GPtrArray* _tmp88_;
	ZeitgeistTimeRange* _tmp89_;
	ZeitgeistTimeRange* _tmp90_;
	GPtrArray* _tmp91_;
	GPtrArray* _tmp92_;
	ZeitgeistMonitor* _tmp93_;
	ZeitgeistMonitor* _tmp94_;
	ZeitgeistLog* _tmp95_;
	ZeitgeistMonitor* _tmp96_;
	GError * _inner_error_;
};


static gpointer folks_tp_zeitgeist_controller_parent_class = NULL;

GType folks_tp_zeitgeist_controller_get_type (void) G_GNUC_CONST;
#define FOLKS_TP_ZEITGEIST_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER, FolksTpZeitgeistControllerPrivate))
enum  {
	FOLKS_TP_ZEITGEIST_CONTROLLER_DUMMY_PROPERTY
};
FolksTpZeitgeistController* folks_tp_zeitgeist_controller_new (FolksPersonaStore* store, TpAccount* account, FolksTpZeitgeistControllerIncreasePersonaCounter im_interaction_cb, FolksTpZeitgeistControllerIncreasePersonaCounter last_call_interaction_cb);
FolksTpZeitgeistController* folks_tp_zeitgeist_controller_construct (GType object_type, FolksPersonaStore* store, TpAccount* account, FolksTpZeitgeistControllerIncreasePersonaCounter im_interaction_cb, FolksTpZeitgeistControllerIncreasePersonaCounter last_call_interaction_cb);
static void folks_tp_zeitgeist_controller_populate_counters_data_free (gpointer _data);
void folks_tp_zeitgeist_controller_populate_counters (FolksTpZeitgeistController* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_tp_zeitgeist_controller_populate_counters_finish (FolksTpZeitgeistController* self, GAsyncResult* _res_);
static gboolean folks_tp_zeitgeist_controller_populate_counters_co (FolksTpZeitgeistControllerPopulateCountersData* _data_);
static GPtrArray* _folks_tp_zeitgeist_controller_get_zeitgeist_event_templates (FolksTpZeitgeistController* self);
static void folks_tp_zeitgeist_controller_populate_counters_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* _folks_tp_zeitgeist_controller_get_iid_from_event_metadata (FolksTpZeitgeistController* self, const gchar* uri);
static void _folks_tp_zeitgeist_controller_increase_persona_counter (FolksTpZeitgeistController* self, FolksPersona* persona, const gchar* interaction_type, ZeitgeistEvent* event);
static void _folks_tp_zeitgeist_controller_handle_new_interaction (FolksTpZeitgeistController* self, ZeitgeistTimeRange* timerange, ZeitgeistResultSet* events);
static void __folks_tp_zeitgeist_controller_handle_new_interaction_zeitgeist_monitor_events_inserted (ZeitgeistMonitor* _sender, ZeitgeistTimeRange* time_range, ZeitgeistResultSet* events, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void folks_tp_zeitgeist_controller_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FolksTpZeitgeistController* folks_tp_zeitgeist_controller_construct (GType object_type, FolksPersonaStore* store, TpAccount* account, FolksTpZeitgeistControllerIncreasePersonaCounter im_interaction_cb, FolksTpZeitgeistControllerIncreasePersonaCounter last_call_interaction_cb) {
	FolksTpZeitgeistController * self = NULL;
	FolksPersonaStore* _tmp0_ = NULL;
	TpAccount* _tmp1_ = NULL;
	TpAccount* _tmp2_ = NULL;
	TpAccount* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	FolksTpZeitgeistControllerIncreasePersonaCounter _tmp7_ = NULL;
	FolksTpZeitgeistControllerIncreasePersonaCounter _tmp8_ = NULL;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	self = (FolksTpZeitgeistController*) g_object_new (object_type, NULL);
	_tmp0_ = store;
	self->priv->_store = _tmp0_;
	_tmp1_ = account;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_account);
	self->priv->_account = _tmp2_;
	_tmp3_ = account;
	_tmp4_ = tp_account_get_protocol_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (self->priv->_protocol);
	self->priv->_protocol = _tmp6_;
	_tmp7_ = im_interaction_cb;
	self->priv->_im_interaction_cb = _tmp7_;
	_tmp8_ = last_call_interaction_cb;
	self->priv->_last_call_interaction_cb = _tmp8_;
	return self;
}


FolksTpZeitgeistController* folks_tp_zeitgeist_controller_new (FolksPersonaStore* store, TpAccount* account, FolksTpZeitgeistControllerIncreasePersonaCounter im_interaction_cb, FolksTpZeitgeistControllerIncreasePersonaCounter last_call_interaction_cb) {
	return folks_tp_zeitgeist_controller_construct (FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER, store, account, im_interaction_cb, last_call_interaction_cb);
}


static void folks_tp_zeitgeist_controller_populate_counters_data_free (gpointer _data) {
	FolksTpZeitgeistControllerPopulateCountersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksTpZeitgeistControllerPopulateCountersData, _data_);
}


void folks_tp_zeitgeist_controller_populate_counters (FolksTpZeitgeistController* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksTpZeitgeistControllerPopulateCountersData* _data_;
	FolksTpZeitgeistController* _tmp0_ = NULL;
	_data_ = g_slice_new0 (FolksTpZeitgeistControllerPopulateCountersData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_tp_zeitgeist_controller_populate_counters);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_tp_zeitgeist_controller_populate_counters_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_tp_zeitgeist_controller_populate_counters_co (_data_);
}


void folks_tp_zeitgeist_controller_populate_counters_finish (FolksTpZeitgeistController* self, GAsyncResult* _res_) {
	FolksTpZeitgeistControllerPopulateCountersData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_tp_zeitgeist_controller_populate_counters_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksTpZeitgeistControllerPopulateCountersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_tp_zeitgeist_controller_populate_counters_co (_data_);
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static void __folks_tp_zeitgeist_controller_handle_new_interaction_zeitgeist_monitor_events_inserted (ZeitgeistMonitor* _sender, ZeitgeistTimeRange* time_range, ZeitgeistResultSet* events, gpointer self) {
	_folks_tp_zeitgeist_controller_handle_new_interaction ((FolksTpZeitgeistController*) self, time_range, events);
}


static gboolean folks_tp_zeitgeist_controller_populate_counters_co (FolksTpZeitgeistControllerPopulateCountersData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_log;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = zeitgeist_log_new ();
		_g_object_unref0 (_data_->self->priv->_log);
		_data_->self->priv->_log = _data_->_tmp1_;
	}
	{
		g_get_current_time (&_data_->tm);
		memset (&_data_->_tmp2_, 0, sizeof (GTimeVal));
		_data_->_tmp2_ = _data_->tm;
		_data_->_tmp3_ = 0L;
		_data_->_tmp3_ = _data_->_tmp2_.tv_sec;
		_data_->end_timestamp = (gint64) _data_->_tmp3_;
		_data_->_tmp4_ = 0LL;
		_data_->_tmp4_ = _data_->end_timestamp;
		_data_->start_timestamp = _data_->_tmp4_ - (86400 * 30);
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _folks_tp_zeitgeist_controller_get_zeitgeist_event_templates (_data_->self);
		_data_->events = _data_->_tmp5_;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->self->priv->_log;
		_data_->_tmp7_ = 0LL;
		_data_->_tmp7_ = _data_->start_timestamp;
		_data_->_tmp8_ = 0LL;
		_data_->_tmp8_ = _data_->end_timestamp;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = zeitgeist_time_range_new (_data_->_tmp7_ * 1000, _data_->_tmp8_ * 1000);
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->events;
		_data_->_state_ = 1;
		zeitgeist_log_find_events (_data_->_tmp6_, _data_->_tmp10_, _data_->_tmp11_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 0, ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS, NULL, folks_tp_zeitgeist_controller_populate_counters_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = zeitgeist_log_find_events_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->_tmp12_;
		_g_object_unref0 (_data_->_tmp10_);
		_data_->results = _data_->_tmp13_;
		if (_data_->_inner_error_ != NULL) {
			_g_ptr_array_unref0 (_data_->events);
			goto __catch0_g_error;
		}
		{
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = _data_->results;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = zeitgeist_result_set_iterator (_data_->_tmp14_);
			_data_->_e_it = _data_->_tmp15_;
			while (TRUE) {
				_data_->_tmp16_ = NULL;
				_data_->_tmp16_ = _data_->_e_it;
				_data_->_tmp17_ = NULL;
				_data_->_tmp17_ = zeitgeist_result_set_next_value (_data_->_tmp16_);
				_g_object_unref0 (_data_->e);
				_data_->e = _data_->_tmp17_;
				_data_->_tmp18_ = NULL;
				_data_->_tmp18_ = _data_->e;
				if (!(_data_->_tmp18_ != NULL)) {
					break;
				}
				_data_->_tmp19_ = NULL;
				_data_->_tmp19_ = _data_->e;
				_data_->_tmp20_ = NULL;
				_data_->_tmp20_ = zeitgeist_event_get_subject (_data_->_tmp19_, 0);
				_data_->_tmp21_ = NULL;
				_data_->_tmp21_ = _data_->_tmp20_;
				_data_->_tmp22_ = NULL;
				_data_->_tmp22_ = zeitgeist_subject_get_interpretation (_data_->_tmp21_);
				_data_->_tmp23_ = NULL;
				_data_->_tmp23_ = _data_->_tmp22_;
				_data_->_tmp24_ = NULL;
				_data_->_tmp24_ = g_strdup (_data_->_tmp23_);
				_data_->_tmp25_ = NULL;
				_data_->_tmp25_ = _data_->_tmp24_;
				_g_object_unref0 (_data_->_tmp21_);
				_data_->interaction_type = _data_->_tmp25_;
				{
					_data_->i = 1;
					{
						_data_->_tmp26_ = TRUE;
						while (TRUE) {
							if (!_data_->_tmp26_) {
								_data_->_tmp27_ = 0;
								_data_->_tmp27_ = _data_->i;
								_data_->i = _data_->_tmp27_ + 1;
							}
							_data_->_tmp26_ = FALSE;
							_data_->_tmp28_ = 0;
							_data_->_tmp28_ = _data_->i;
							_data_->_tmp29_ = NULL;
							_data_->_tmp29_ = _data_->e;
							_data_->_tmp30_ = 0;
							_data_->_tmp30_ = zeitgeist_event_num_subjects (_data_->_tmp29_);
							if (!(_data_->_tmp28_ < _data_->_tmp30_)) {
								break;
							}
							_data_->_tmp31_ = NULL;
							_data_->_tmp31_ = _data_->e;
							_data_->_tmp32_ = 0;
							_data_->_tmp32_ = _data_->i;
							_data_->_tmp33_ = NULL;
							_data_->_tmp33_ = zeitgeist_event_get_subject (_data_->_tmp31_, _data_->_tmp32_);
							_data_->_tmp34_ = NULL;
							_data_->_tmp34_ = _data_->_tmp33_;
							_data_->_tmp35_ = NULL;
							_data_->_tmp35_ = zeitgeist_subject_get_uri (_data_->_tmp34_);
							_data_->_tmp36_ = NULL;
							_data_->_tmp36_ = _data_->_tmp35_;
							_data_->_tmp37_ = NULL;
							_data_->_tmp37_ = _folks_tp_zeitgeist_controller_get_iid_from_event_metadata (_data_->self, _data_->_tmp36_);
							_data_->_tmp38_ = NULL;
							_data_->_tmp38_ = _data_->_tmp37_;
							_g_object_unref0 (_data_->_tmp34_);
							_data_->id = _data_->_tmp38_;
							_data_->_tmp40_ = NULL;
							_data_->_tmp40_ = _data_->id;
							if (_data_->_tmp40_ == NULL) {
								_data_->_tmp39_ = TRUE;
							} else {
								_data_->_tmp41_ = NULL;
								_data_->_tmp41_ = _data_->interaction_type;
								_data_->_tmp39_ = _data_->_tmp41_ == NULL;
							}
							if (_data_->_tmp39_) {
								_g_free0 (_data_->id);
								continue;
							}
							_data_->_tmp42_ = NULL;
							_data_->_tmp42_ = _data_->self->priv->_store;
							_data_->_tmp43_ = NULL;
							_data_->_tmp43_ = folks_persona_store_get_personas (_data_->_tmp42_);
							_data_->_tmp44_ = NULL;
							_data_->_tmp44_ = _data_->_tmp43_;
							_data_->_tmp45_ = NULL;
							_data_->_tmp45_ = _data_->id;
							_data_->_tmp46_ = NULL;
							_data_->_tmp46_ = gee_map_get (_data_->_tmp44_, _data_->_tmp45_);
							_data_->persona = (FolksPersona*) _data_->_tmp46_;
							_data_->_tmp47_ = NULL;
							_data_->_tmp47_ = _data_->persona;
							if (_data_->_tmp47_ == NULL) {
								_g_object_unref0 (_data_->persona);
								_g_free0 (_data_->id);
								continue;
							}
							_data_->_tmp48_ = NULL;
							_data_->_tmp48_ = _data_->persona;
							g_object_freeze_notify ((GObject*) _data_->_tmp48_);
							_data_->_tmp49_ = NULL;
							_data_->_tmp49_ = _data_->persona;
							_data_->_tmp50_ = NULL;
							_data_->_tmp50_ = _data_->interaction_type;
							_data_->_tmp51_ = NULL;
							_data_->_tmp51_ = _data_->e;
							_folks_tp_zeitgeist_controller_increase_persona_counter (_data_->self, _data_->_tmp49_, _data_->_tmp50_, _data_->_tmp51_);
							_g_object_unref0 (_data_->persona);
							_g_free0 (_data_->id);
						}
					}
				}
				_g_free0 (_data_->interaction_type);
			}
			_g_object_unref0 (_data_->e);
			_g_object_unref0 (_data_->_e_it);
		}
		{
			_data_->_tmp52_ = NULL;
			_data_->_tmp52_ = _data_->results;
			_data_->_tmp53_ = NULL;
			_data_->_tmp53_ = zeitgeist_result_set_iterator (_data_->_tmp52_);
			_data_->_vala1__e_it = _data_->_tmp53_;
			while (TRUE) {
				_data_->_tmp54_ = NULL;
				_data_->_tmp54_ = _data_->_vala1__e_it;
				_data_->_tmp55_ = NULL;
				_data_->_tmp55_ = zeitgeist_result_set_next_value (_data_->_tmp54_);
				_g_object_unref0 (_data_->_vala1_e);
				_data_->_vala1_e = _data_->_tmp55_;
				_data_->_tmp56_ = NULL;
				_data_->_tmp56_ = _data_->_vala1_e;
				if (!(_data_->_tmp56_ != NULL)) {
					break;
				}
				_data_->_tmp57_ = NULL;
				_data_->_tmp57_ = _data_->_vala1_e;
				_data_->_tmp58_ = NULL;
				_data_->_tmp58_ = zeitgeist_event_get_subject (_data_->_tmp57_, 0);
				_data_->_tmp59_ = NULL;
				_data_->_tmp59_ = _data_->_tmp58_;
				_data_->_tmp60_ = NULL;
				_data_->_tmp60_ = zeitgeist_subject_get_interpretation (_data_->_tmp59_);
				_data_->_tmp61_ = NULL;
				_data_->_tmp61_ = _data_->_tmp60_;
				_data_->_tmp62_ = NULL;
				_data_->_tmp62_ = g_strdup (_data_->_tmp61_);
				_data_->_tmp63_ = NULL;
				_data_->_tmp63_ = _data_->_tmp62_;
				_g_object_unref0 (_data_->_tmp59_);
				_data_->_vala1_interaction_type = _data_->_tmp63_;
				{
					_data_->_vala1_i = 1;
					{
						_data_->_tmp64_ = TRUE;
						while (TRUE) {
							if (!_data_->_tmp64_) {
								_data_->_tmp65_ = 0;
								_data_->_tmp65_ = _data_->_vala1_i;
								_data_->_vala1_i = _data_->_tmp65_ + 1;
							}
							_data_->_tmp64_ = FALSE;
							_data_->_tmp66_ = 0;
							_data_->_tmp66_ = _data_->_vala1_i;
							_data_->_tmp67_ = NULL;
							_data_->_tmp67_ = _data_->_vala1_e;
							_data_->_tmp68_ = 0;
							_data_->_tmp68_ = zeitgeist_event_num_subjects (_data_->_tmp67_);
							if (!(_data_->_tmp66_ < _data_->_tmp68_)) {
								break;
							}
							_data_->_tmp69_ = NULL;
							_data_->_tmp69_ = _data_->_vala1_e;
							_data_->_tmp70_ = 0;
							_data_->_tmp70_ = _data_->_vala1_i;
							_data_->_tmp71_ = NULL;
							_data_->_tmp71_ = zeitgeist_event_get_subject (_data_->_tmp69_, _data_->_tmp70_);
							_data_->_tmp72_ = NULL;
							_data_->_tmp72_ = _data_->_tmp71_;
							_data_->_tmp73_ = NULL;
							_data_->_tmp73_ = zeitgeist_subject_get_uri (_data_->_tmp72_);
							_data_->_tmp74_ = NULL;
							_data_->_tmp74_ = _data_->_tmp73_;
							_data_->_tmp75_ = NULL;
							_data_->_tmp75_ = _folks_tp_zeitgeist_controller_get_iid_from_event_metadata (_data_->self, _data_->_tmp74_);
							_data_->_tmp76_ = NULL;
							_data_->_tmp76_ = _data_->_tmp75_;
							_g_object_unref0 (_data_->_tmp72_);
							_data_->_vala1_id = _data_->_tmp76_;
							_data_->_tmp78_ = NULL;
							_data_->_tmp78_ = _data_->_vala1_id;
							if (_data_->_tmp78_ == NULL) {
								_data_->_tmp77_ = TRUE;
							} else {
								_data_->_tmp79_ = NULL;
								_data_->_tmp79_ = _data_->_vala1_interaction_type;
								_data_->_tmp77_ = _data_->_tmp79_ == NULL;
							}
							if (_data_->_tmp77_) {
								_g_free0 (_data_->_vala1_id);
								continue;
							}
							_data_->_tmp80_ = NULL;
							_data_->_tmp80_ = _data_->self->priv->_store;
							_data_->_tmp81_ = NULL;
							_data_->_tmp81_ = folks_persona_store_get_personas (_data_->_tmp80_);
							_data_->_tmp82_ = NULL;
							_data_->_tmp82_ = _data_->_tmp81_;
							_data_->_tmp83_ = NULL;
							_data_->_tmp83_ = _data_->_vala1_id;
							_data_->_tmp84_ = NULL;
							_data_->_tmp84_ = gee_map_get (_data_->_tmp82_, _data_->_tmp83_);
							_data_->_vala1_persona = (FolksPersona*) _data_->_tmp84_;
							_data_->_tmp85_ = NULL;
							_data_->_tmp85_ = _data_->_vala1_persona;
							if (_data_->_tmp85_ == NULL) {
								_g_object_unref0 (_data_->_vala1_persona);
								_g_free0 (_data_->_vala1_id);
								continue;
							}
							_data_->_tmp86_ = NULL;
							_data_->_tmp86_ = _data_->_vala1_persona;
							g_object_thaw_notify ((GObject*) _data_->_tmp86_);
							_g_object_unref0 (_data_->_vala1_persona);
							_g_free0 (_data_->_vala1_id);
						}
					}
				}
				_g_free0 (_data_->_vala1_interaction_type);
			}
			_g_object_unref0 (_data_->_vala1_e);
			_g_object_unref0 (_data_->_vala1__e_it);
		}
		_g_object_unref0 (_data_->results);
		_g_ptr_array_unref0 (_data_->events);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error_);
		_data_->_inner_error_ = NULL;
		g_debug ("tp-zeitgeist.vala:136: Failed to fetch events from Zeitgeist");
	}
	__finally0:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp87_ = NULL;
	_data_->_tmp87_ = _data_->self->priv->_monitor;
	if (_data_->_tmp87_ == NULL) {
		_data_->_tmp88_ = NULL;
		_data_->_tmp88_ = _folks_tp_zeitgeist_controller_get_zeitgeist_event_templates (_data_->self);
		_data_->monitor_events = _data_->_tmp88_;
		_data_->_tmp89_ = NULL;
		_data_->_tmp89_ = zeitgeist_time_range_new_from_now ();
		_data_->_tmp90_ = NULL;
		_data_->_tmp90_ = _data_->_tmp89_;
		_data_->_tmp91_ = NULL;
		_data_->_tmp91_ = _data_->monitor_events;
		_data_->_tmp92_ = NULL;
		_data_->_tmp92_ = _g_ptr_array_ref0 (_data_->_tmp91_);
		_data_->_tmp93_ = NULL;
		_data_->_tmp93_ = zeitgeist_monitor_new (_data_->_tmp90_, _data_->_tmp92_);
		_g_object_unref0 (_data_->self->priv->_monitor);
		_data_->self->priv->_monitor = _data_->_tmp93_;
		_g_object_unref0 (_data_->_tmp90_);
		_data_->_tmp94_ = NULL;
		_data_->_tmp94_ = _data_->self->priv->_monitor;
		g_signal_connect_object (_data_->_tmp94_, "events-inserted", (GCallback) __folks_tp_zeitgeist_controller_handle_new_interaction_zeitgeist_monitor_events_inserted, _data_->self, 0);
		{
			_data_->_tmp95_ = NULL;
			_data_->_tmp95_ = _data_->self->priv->_log;
			_data_->_tmp96_ = NULL;
			_data_->_tmp96_ = _data_->self->priv->_monitor;
			zeitgeist_log_install_monitor (_data_->_tmp95_, _data_->_tmp96_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_data_->_inner_error_);
			_data_->_inner_error_ = NULL;
			g_warning ("tp-zeitgeist.vala:154: Failed to install monitor for Zeitgeist");
			_g_object_unref0 (_data_->self->priv->_monitor);
			_data_->self->priv->_monitor = NULL;
		}
		__finally1:
		if (_data_->_inner_error_ != NULL) {
			_g_ptr_array_unref0 (_data_->monitor_events);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_g_ptr_array_unref0 (_data_->monitor_events);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* _folks_tp_zeitgeist_controller_get_iid_from_event_metadata (FolksTpZeitgeistController* self, const gchar* uri) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* new_uri = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = uri;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = uri;
	_tmp2_ = string_replace (_tmp1_, "x-telepathy-identifier:", "");
	new_uri = _tmp2_;
	_tmp3_ = self->priv->_protocol;
	_tmp4_ = g_strconcat (_tmp3_, ":", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = new_uri;
	_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp5_);
	result = _tmp8_;
	_g_free0 (new_uri);
	return result;
}


static void _folks_tp_zeitgeist_controller_increase_persona_counter (FolksTpZeitgeistController* self, FolksPersona* persona, const gchar* interaction_type, ZeitgeistEvent* event) {
	guint timestamp = 0U;
	ZeitgeistEvent* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	GDateTime* converted_datetime = NULL;
	guint _tmp3_ = 0U;
	GDateTime* _tmp4_ = NULL;
	gchar* interpretation = NULL;
	ZeitgeistEvent* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GDateTime* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_return_if_fail (interaction_type != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = event;
	_tmp1_ = zeitgeist_event_get_timestamp (_tmp0_);
	_tmp2_ = _tmp1_;
	timestamp = (guint) (_tmp2_ / 1000);
	_tmp3_ = timestamp;
	_tmp4_ = g_date_time_new_from_unix_utc ((gint64) _tmp3_);
	converted_datetime = _tmp4_;
	_tmp5_ = event;
	_tmp6_ = zeitgeist_event_get_interpretation (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup (_tmp7_);
	interpretation = _tmp8_;
	_tmp9_ = converted_datetime;
	if (_tmp9_ == NULL) {
		_g_free0 (interpretation);
		_g_date_time_unref0 (converted_datetime);
		return;
	}
	_tmp11_ = interaction_type;
	if (g_strcmp0 (_tmp11_, ZEITGEIST_NMO_IMMESSAGE) == 0) {
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_ = NULL;
		_tmp13_ = interpretation;
		if (g_strcmp0 (_tmp13_, ZEITGEIST_ZG_SEND_EVENT) == 0) {
			_tmp12_ = TRUE;
		} else {
			const gchar* _tmp14_ = NULL;
			_tmp14_ = interpretation;
			_tmp12_ = g_strcmp0 (_tmp14_, ZEITGEIST_ZG_RECEIVE_EVENT) == 0;
		}
		_tmp10_ = _tmp12_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		FolksTpZeitgeistControllerIncreasePersonaCounter _tmp15_ = NULL;
		FolksPersona* _tmp16_ = NULL;
		GDateTime* _tmp17_ = NULL;
		_tmp15_ = self->priv->_im_interaction_cb;
		_tmp16_ = persona;
		_tmp17_ = converted_datetime;
		_tmp15_ (_tmp16_, _tmp17_);
	} else {
		gboolean _tmp18_ = FALSE;
		const gchar* _tmp19_ = NULL;
		_tmp19_ = interaction_type;
		if (g_strcmp0 (_tmp19_, ZEITGEIST_NFO_AUDIO) == 0) {
			const gchar* _tmp20_ = NULL;
			_tmp20_ = interpretation;
			_tmp18_ = g_strcmp0 (_tmp20_, ZEITGEIST_ZG_LEAVE_EVENT) == 0;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			FolksTpZeitgeistControllerIncreasePersonaCounter _tmp21_ = NULL;
			FolksPersona* _tmp22_ = NULL;
			GDateTime* _tmp23_ = NULL;
			_tmp21_ = self->priv->_last_call_interaction_cb;
			_tmp22_ = persona;
			_tmp23_ = converted_datetime;
			_tmp21_ (_tmp22_, _tmp23_);
		}
	}
	_g_free0 (interpretation);
	_g_date_time_unref0 (converted_datetime);
}


static void _folks_tp_zeitgeist_controller_handle_new_interaction (FolksTpZeitgeistController* self, ZeitgeistTimeRange* timerange, ZeitgeistResultSet* events) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (timerange != NULL);
	g_return_if_fail (events != NULL);
	{
		ZeitgeistResultSet* _e_it = NULL;
		ZeitgeistResultSet* _tmp0_ = NULL;
		ZeitgeistResultSet* _tmp1_ = NULL;
		ZeitgeistEvent* e = NULL;
		_tmp0_ = events;
		_tmp1_ = zeitgeist_result_set_iterator (_tmp0_);
		_e_it = _tmp1_;
		while (TRUE) {
			ZeitgeistResultSet* _tmp2_ = NULL;
			ZeitgeistEvent* _tmp3_ = NULL;
			ZeitgeistEvent* _tmp4_ = NULL;
			_tmp2_ = _e_it;
			_tmp3_ = zeitgeist_result_set_next_value (_tmp2_);
			_g_object_unref0 (e);
			e = _tmp3_;
			_tmp4_ = e;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			{
				gint i = 0;
				i = 1;
				{
					gboolean _tmp5_ = FALSE;
					_tmp5_ = TRUE;
					while (TRUE) {
						gint _tmp7_ = 0;
						ZeitgeistEvent* _tmp8_ = NULL;
						gint _tmp9_ = 0;
						gchar* id = NULL;
						ZeitgeistEvent* _tmp10_ = NULL;
						gint _tmp11_ = 0;
						ZeitgeistSubject* _tmp12_ = NULL;
						ZeitgeistSubject* _tmp13_ = NULL;
						const gchar* _tmp14_ = NULL;
						const gchar* _tmp15_ = NULL;
						gchar* _tmp16_ = NULL;
						gchar* _tmp17_ = NULL;
						gchar* interaction_type = NULL;
						ZeitgeistEvent* _tmp18_ = NULL;
						ZeitgeistSubject* _tmp19_ = NULL;
						ZeitgeistSubject* _tmp20_ = NULL;
						const gchar* _tmp21_ = NULL;
						const gchar* _tmp22_ = NULL;
						gchar* _tmp23_ = NULL;
						gchar* _tmp24_ = NULL;
						gboolean _tmp25_ = FALSE;
						const gchar* _tmp26_ = NULL;
						FolksPersona* persona = NULL;
						FolksPersonaStore* _tmp28_ = NULL;
						GeeMap* _tmp29_ = NULL;
						GeeMap* _tmp30_ = NULL;
						const gchar* _tmp31_ = NULL;
						gpointer _tmp32_ = NULL;
						FolksPersona* _tmp33_ = NULL;
						FolksPersona* _tmp34_ = NULL;
						const gchar* _tmp35_ = NULL;
						ZeitgeistEvent* _tmp36_ = NULL;
						if (!_tmp5_) {
							gint _tmp6_ = 0;
							_tmp6_ = i;
							i = _tmp6_ + 1;
						}
						_tmp5_ = FALSE;
						_tmp7_ = i;
						_tmp8_ = e;
						_tmp9_ = zeitgeist_event_num_subjects (_tmp8_);
						if (!(_tmp7_ < _tmp9_)) {
							break;
						}
						_tmp10_ = e;
						_tmp11_ = i;
						_tmp12_ = zeitgeist_event_get_subject (_tmp10_, _tmp11_);
						_tmp13_ = _tmp12_;
						_tmp14_ = zeitgeist_subject_get_uri (_tmp13_);
						_tmp15_ = _tmp14_;
						_tmp16_ = _folks_tp_zeitgeist_controller_get_iid_from_event_metadata (self, _tmp15_);
						_tmp17_ = _tmp16_;
						_g_object_unref0 (_tmp13_);
						id = _tmp17_;
						_tmp18_ = e;
						_tmp19_ = zeitgeist_event_get_subject (_tmp18_, 0);
						_tmp20_ = _tmp19_;
						_tmp21_ = zeitgeist_subject_get_interpretation (_tmp20_);
						_tmp22_ = _tmp21_;
						_tmp23_ = g_strdup (_tmp22_);
						_tmp24_ = _tmp23_;
						_g_object_unref0 (_tmp20_);
						interaction_type = _tmp24_;
						_tmp26_ = id;
						if (_tmp26_ == NULL) {
							_tmp25_ = TRUE;
						} else {
							const gchar* _tmp27_ = NULL;
							_tmp27_ = interaction_type;
							_tmp25_ = _tmp27_ == NULL;
						}
						if (_tmp25_) {
							_g_free0 (interaction_type);
							_g_free0 (id);
							continue;
						}
						_tmp28_ = self->priv->_store;
						_tmp29_ = folks_persona_store_get_personas (_tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = id;
						_tmp32_ = gee_map_get (_tmp30_, _tmp31_);
						persona = (FolksPersona*) _tmp32_;
						_tmp33_ = persona;
						if (_tmp33_ == NULL) {
							_g_object_unref0 (persona);
							_g_free0 (interaction_type);
							_g_free0 (id);
							continue;
						}
						_tmp34_ = persona;
						_tmp35_ = interaction_type;
						_tmp36_ = e;
						_folks_tp_zeitgeist_controller_increase_persona_counter (self, _tmp34_, _tmp35_, _tmp36_);
						_g_object_unref0 (persona);
						_g_free0 (interaction_type);
						_g_free0 (id);
					}
				}
			}
		}
		_g_object_unref0 (e);
		_g_object_unref0 (_e_it);
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static GPtrArray* _folks_tp_zeitgeist_controller_get_zeitgeist_event_templates (FolksTpZeitgeistController* self) {
	GPtrArray* result = NULL;
	gchar* origin = NULL;
	TpAccount* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	ZeitgeistEvent* ev1 = NULL;
	ZeitgeistEvent* _tmp3_ = NULL;
	GPtrArray* templates = NULL;
	GPtrArray* _tmp4_ = NULL;
	ZeitgeistEvent* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_account;
	_tmp1_ = tp_account_get_path_suffix (_tmp0_);
	_tmp2_ = g_strconcat ("x-telepathy-account-path:", _tmp1_, NULL);
	origin = _tmp2_;
	_tmp3_ = zeitgeist_event_new_full ("", "", "dbus://org.freedesktop.Telepathy.Logger.service", NULL, NULL);
	ev1 = _tmp3_;
	zeitgeist_event_set_origin (ev1, origin);
	_tmp4_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	templates = _tmp4_;
	_tmp5_ = _g_object_ref0 (ev1);
	g_ptr_array_add (templates, _tmp5_);
	result = templates;
	_g_object_unref0 (ev1);
	_g_free0 (origin);
	return result;
}


static void folks_tp_zeitgeist_controller_class_init (FolksTpZeitgeistControllerClass * klass) {
	folks_tp_zeitgeist_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksTpZeitgeistControllerPrivate));
	G_OBJECT_CLASS (klass)->finalize = folks_tp_zeitgeist_controller_finalize;
}


static void folks_tp_zeitgeist_controller_instance_init (FolksTpZeitgeistController * self) {
	self->priv = FOLKS_TP_ZEITGEIST_CONTROLLER_GET_PRIVATE (self);
	self->priv->_log = NULL;
	self->priv->_monitor = NULL;
}


static void folks_tp_zeitgeist_controller_finalize (GObject* obj) {
	FolksTpZeitgeistController * self;
	ZeitgeistMonitor* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER, FolksTpZeitgeistController);
	_tmp0_ = self->priv->_monitor;
	if (_tmp0_ != NULL) {
		ZeitgeistLog* _tmp1_ = NULL;
		ZeitgeistMonitor* _tmp2_ = NULL;
		ZeitgeistMonitor* _tmp3_ = NULL;
		_tmp1_ = self->priv->_log;
		_tmp2_ = self->priv->_monitor;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		zeitgeist_log_remove_monitor (_tmp1_, _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_object_unref0 (self->priv->_monitor);
		self->priv->_monitor = NULL;
	}
	_g_object_unref0 (self->priv->_log);
	_g_object_unref0 (self->priv->_monitor);
	_g_free0 (self->priv->_protocol);
	_g_object_unref0 (self->priv->_account);
	G_OBJECT_CLASS (folks_tp_zeitgeist_controller_parent_class)->finalize (obj);
}


/**
 * Zeitgeist code for libfolks-telepathy.la. This is separated out from
 * tpf-persona-store.vala so that it can be conditionally compiled out.
 *
 * See the note in Makefile.am, and
 * [[https://bugzilla.gnome.org/show_bug.cgi?id=701099]].
 */
GType folks_tp_zeitgeist_controller_get_type (void) {
	static volatile gsize folks_tp_zeitgeist_controller_type_id__volatile = 0;
	if (g_once_init_enter (&folks_tp_zeitgeist_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksTpZeitgeistControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_tp_zeitgeist_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksTpZeitgeistController), 0, (GInstanceInitFunc) folks_tp_zeitgeist_controller_instance_init, NULL };
		GType folks_tp_zeitgeist_controller_type_id;
		folks_tp_zeitgeist_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksTpZeitgeistController", &g_define_type_info, 0);
		g_once_init_leave (&folks_tp_zeitgeist_controller_type_id__volatile, folks_tp_zeitgeist_controller_type_id);
	}
	return folks_tp_zeitgeist_controller_type_id__volatile;
}



