/* test-case.c generated by valac 0.24.0, the Vala compiler
 * generated from test-case.vala, do not modify */

/* test-case.vala
 *
 * Copyright © 2013 Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *      Simon McVittie <simon.mcvittie@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <glib/gstdio.h>


#define TRACKER_TEST_TYPE_TEST_CASE (tracker_test_test_case_get_type ())
#define TRACKER_TEST_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TEST_TYPE_TEST_CASE, TrackerTestTestCase))
#define TRACKER_TEST_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TEST_TYPE_TEST_CASE, TrackerTestTestCaseClass))
#define TRACKER_TEST_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TEST_TYPE_TEST_CASE))
#define TRACKER_TEST_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TEST_TYPE_TEST_CASE))
#define TRACKER_TEST_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TEST_TYPE_TEST_CASE, TrackerTestTestCaseClass))

typedef struct _TrackerTestTestCase TrackerTestTestCase;
typedef struct _TrackerTestTestCaseClass TrackerTestTestCaseClass;
typedef struct _TrackerTestTestCasePrivate TrackerTestTestCasePrivate;

#define TRACKER_TEST_TYPE_BACKEND (tracker_test_backend_get_type ())
#define TRACKER_TEST_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackend))
#define TRACKER_TEST_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackendClass))
#define TRACKER_TEST_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TEST_TYPE_BACKEND))
#define TRACKER_TEST_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TEST_TYPE_BACKEND))
#define TRACKER_TEST_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackendClass))

typedef struct _TrackerTestBackend TrackerTestBackend;
typedef struct _TrackerTestBackendClass TrackerTestBackendClass;
#define _tracker_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (tracker_test_backend_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))

struct _TrackerTestTestCase {
	FolksTestCase parent_instance;
	TrackerTestTestCasePrivate * priv;
	TrackerTestBackend* tracker_backend;
};

struct _TrackerTestTestCaseClass {
	FolksTestCaseClass parent_class;
	void (*create_backend) (TrackerTestTestCase* self);
};


static gpointer tracker_test_test_case_parent_class = NULL;

GType tracker_test_test_case_get_type (void) G_GNUC_CONST;
gpointer tracker_test_backend_ref (gpointer instance);
void tracker_test_backend_unref (gpointer instance);
GParamSpec* tracker_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_test_value_set_backend (GValue* value, gpointer v_object);
void tracker_test_value_take_backend (GValue* value, gpointer v_object);
gpointer tracker_test_value_get_backend (const GValue* value);
GType tracker_test_backend_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_TEST_TEST_CASE_DUMMY_PROPERTY
};
TrackerTestTestCase* tracker_test_test_case_new (const gchar* name);
TrackerTestTestCase* tracker_test_test_case_construct (GType object_type, const gchar* name);
static void tracker_test_test_case_real_private_bus_up (FolksTestCase* base);
static void tracker_test_test_case_real_set_up (FolksTestCase* base);
void tracker_test_test_case_create_backend (TrackerTestTestCase* self);
static void tracker_test_test_case_real_create_backend (TrackerTestTestCase* self);
TrackerTestBackend* tracker_test_backend_new (void);
TrackerTestBackend* tracker_test_backend_construct (GType object_type);
void tracker_test_backend_set_up (TrackerTestBackend* self);
static void tracker_test_test_case_real_tear_down (FolksTestCase* base);
void tracker_test_backend_tear_down (TrackerTestBackend* self);
static void tracker_test_test_case_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
   * Set environment variables and create the tracker backend.
   *
   * FIXME: maybe it shouldn't be created until set_up()? (Tests
   * will need to be checked to make sure that's OK.)
   */
TrackerTestTestCase* tracker_test_test_case_construct (GType object_type, const gchar* name) {
	TrackerTestTestCase * self = NULL;
	const gchar* _tmp0_ = NULL;
#line 48 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 50 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_tmp0_ = name;
#line 50 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	self = (TrackerTestTestCase*) folks_test_case_construct (object_type, _tmp0_);
#line 52 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	g_setenv ("FOLKS_BACKENDS_ALLOWED", "tracker", TRUE);
#line 53 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	g_setenv ("FOLKS_PRIMARY_STORE", "tracker", TRUE);
#line 48 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	return self;
#line 123 "test-case.c"
}


TrackerTestTestCase* tracker_test_test_case_new (const gchar* name) {
#line 48 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	return tracker_test_test_case_construct (TRACKER_TEST_TYPE_TEST_CASE, name);
#line 130 "test-case.c"
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/opt/gnome3/build/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/opt/gnome3/build/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/opt/gnome3/build/share/vala-0.24/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/opt/gnome3/build/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/opt/gnome3/build/share/vala-0.24/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/opt/gnome3/build/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/opt/gnome3/build/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 153 "test-case.c"
}


static void tracker_test_test_case_real_private_bus_up (FolksTestCase* base) {
	TrackerTestTestCase * self;
	gint exit_status = 0;
	gchar* capture_stdout = NULL;
	gchar* libexec = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* service_file_name = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* service_file = NULL;
	gchar* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
#line 56 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	self = (TrackerTestTestCase*) base;
#line 58 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	FOLKS_TEST_CASE_CLASS (tracker_test_test_case_parent_class)->private_bus_up (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_TEST_CASE, FolksTestCase));
#line 61 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	exit_status = -1;
#line 62 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	capture_stdout = NULL;
#line 182 "test-case.c"
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar** _tmp3_ = NULL;
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 66 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_tmp0_ = g_strdup ("pkg-config");
#line 66 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_tmp1_ = g_strdup ("--variable=prefix");
#line 66 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_tmp2_ = g_strdup_printf ("tracker-miner-%s", TRACKER_SPARQL_MAJOR);
#line 66 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_tmp3_ = g_new0 (gchar*, 3 + 1);
#line 66 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_tmp3_[0] = _tmp0_;
#line 66 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_tmp3_[1] = _tmp1_;
#line 66 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_tmp3_[2] = _tmp2_;
#line 66 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_tmp4_ = _tmp3_;
#line 66 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_tmp4__length1 = 3;
#line 66 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		g_spawn_sync (NULL, _tmp4_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp5_, NULL, &_tmp6_, &_inner_error_);
#line 66 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_g_free0 (capture_stdout);
#line 66 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		capture_stdout = _tmp5_;
#line 66 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		exit_status = _tmp6_;
#line 66 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
#line 66 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		if (_inner_error_ != NULL) {
#line 223 "test-case.c"
			goto __catch4_g_error;
		}
#line 76 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_tmp7_ = exit_status;
#line 76 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		g_spawn_check_exit_status (_tmp7_, &_inner_error_);
#line 76 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		if (_inner_error_ != NULL) {
#line 232 "test-case.c"
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e1 = NULL;
		const gchar* _tmp8_ = NULL;
#line 64 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		e1 = _inner_error_;
#line 64 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_inner_error_ = NULL;
#line 80 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_tmp8_ = e1->message;
#line 80 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		g_error ("test-case.vala:80: Error getting libexecdir from pkg-config: %s", _tmp8_);
#line 64 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_g_error_free0 (e1);
#line 251 "test-case.c"
	}
	__finally4:
#line 64 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	if (_inner_error_ != NULL) {
#line 64 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_g_free0 (capture_stdout);
#line 64 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 64 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		g_clear_error (&_inner_error_);
#line 64 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		return;
#line 264 "test-case.c"
	}
#line 85 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_tmp9_ = capture_stdout;
#line 85 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_tmp10_ = string_strip (_tmp9_);
#line 85 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_tmp11_ = _tmp10_;
#line 85 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_tmp12_ = g_strconcat (_tmp11_, "/libexec", NULL);
#line 85 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_tmp13_ = _tmp12_;
#line 85 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_g_free0 (_tmp11_);
#line 85 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	libexec = _tmp13_;
#line 88 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_tmp14_ = folks_test_case_get_transient_dir ((FolksTestCase*) self);
#line 88 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_tmp15_ = _tmp14_;
#line 88 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_tmp16_ = g_build_filename (_tmp15_, "dbus-1", "services", "org.freedesktop.Tracker1.service", NULL);
#line 88 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	service_file_name = _tmp16_;
#line 91 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_tmp17_ = g_strdup_printf ("[D-BUS Service]\n" "Name=org.freedesktop.Tracker1\n" "Exec=%s/tracker-store\n", libexec);
#line 91 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	service_file = _tmp17_;
#line 292 "test-case.c"
	{
#line 97 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		g_file_set_contents (service_file_name, service_file, (gssize) (-1), &_inner_error_);
#line 97 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		if (_inner_error_ != NULL) {
#line 97 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 300 "test-case.c"
				goto __catch5_g_file_error;
			}
#line 97 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
			_g_free0 (service_file);
#line 97 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
			_g_free0 (service_file_name);
#line 97 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
			_g_free0 (libexec);
#line 97 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
			_g_free0 (capture_stdout);
#line 97 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 97 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
			g_clear_error (&_inner_error_);
#line 97 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
			return;
#line 317 "test-case.c"
		}
	}
	goto __finally5;
	__catch5_g_file_error:
	{
		GError* e2 = NULL;
		const gchar* _tmp18_ = NULL;
#line 95 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		e2 = _inner_error_;
#line 95 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_inner_error_ = NULL;
#line 101 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_tmp18_ = e2->message;
#line 101 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		g_error ("test-case.vala:101: Error creating D-Bus service file ‘%s’: %s", service_file_name, _tmp18_);
#line 95 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_g_error_free0 (e2);
#line 335 "test-case.c"
	}
	__finally5:
#line 95 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	if (_inner_error_ != NULL) {
#line 95 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_g_free0 (service_file);
#line 95 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_g_free0 (service_file_name);
#line 95 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_g_free0 (libexec);
#line 95 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_g_free0 (capture_stdout);
#line 95 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		g_clear_error (&_inner_error_);
#line 95 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		return;
#line 354 "test-case.c"
	}
#line 56 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_g_free0 (service_file);
#line 56 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_g_free0 (service_file_name);
#line 56 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_g_free0 (libexec);
#line 56 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_g_free0 (capture_stdout);
#line 364 "test-case.c"
}


static void tracker_test_test_case_real_set_up (FolksTestCase* base) {
	TrackerTestTestCase * self;
#line 106 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	self = (TrackerTestTestCase*) base;
#line 108 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	FOLKS_TEST_CASE_CLASS (tracker_test_test_case_parent_class)->set_up (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_TEST_CASE, FolksTestCase));
#line 109 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	tracker_test_test_case_create_backend (self);
#line 376 "test-case.c"
}


/**
   * Virtual method to create and set up the Tracker backend.
   * Called from set_up(); may be overridden to not create the backend,
   * or to create it but not set it up.
   *
   * Subclasses may chain up, but are not required to so.
   */
static void tracker_test_test_case_real_create_backend (TrackerTestTestCase* self) {
	TrackerTestBackend* _tmp0_ = NULL;
	TrackerTestBackend* _tmp1_ = NULL;
#line 121 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_tmp0_ = tracker_test_backend_new ();
#line 121 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_tracker_test_backend_unref0 (self->tracker_backend);
#line 121 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	self->tracker_backend = _tmp0_;
#line 122 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_tmp1_ = self->tracker_backend;
#line 122 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	tracker_test_backend_set_up (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TRACKER_TEST_TYPE_BACKEND, TrackerTestBackend));
#line 400 "test-case.c"
}


void tracker_test_test_case_create_backend (TrackerTestTestCase* self) {
#line 119 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	g_return_if_fail (self != NULL);
#line 119 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	TRACKER_TEST_TEST_CASE_GET_CLASS (self)->create_backend (self);
#line 409 "test-case.c"
}


static gpointer _g_main_context_ref0 (gpointer self) {
#line 138 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	return self ? g_main_context_ref (self) : NULL;
#line 416 "test-case.c"
}


static void tracker_test_test_case_real_tear_down (FolksTestCase* base) {
	TrackerTestTestCase * self;
	TrackerTestBackend* _tmp0_ = NULL;
	GMainContext* context = NULL;
	GMainContext* _tmp2_ = NULL;
	GMainContext* _tmp3_ = NULL;
#line 125 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	self = (TrackerTestTestCase*) base;
#line 127 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_tmp0_ = self->tracker_backend;
#line 127 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	if (_tmp0_ != NULL) {
#line 432 "test-case.c"
		TrackerTestBackend* _tmp1_ = NULL;
#line 129 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_tmp1_ = self->tracker_backend;
#line 129 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		tracker_test_backend_tear_down (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TRACKER_TEST_TYPE_BACKEND, TrackerTestBackend));
#line 438 "test-case.c"
	}
#line 138 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_tmp2_ = g_main_context_default ();
#line 138 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_tmp3_ = _g_main_context_ref0 (_tmp2_);
#line 138 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	context = _tmp3_;
#line 139 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	while (TRUE) {
#line 448 "test-case.c"
		GMainContext* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 139 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_tmp4_ = context;
#line 139 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		_tmp5_ = g_main_context_iteration (_tmp4_, FALSE);
#line 139 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
		if (!_tmp5_) {
#line 139 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
			break;
#line 459 "test-case.c"
		}
	}
#line 141 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	FOLKS_TEST_CASE_CLASS (tracker_test_test_case_parent_class)->tear_down (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_TEST_CASE, FolksTestCase));
#line 125 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_g_main_context_unref0 (context);
#line 466 "test-case.c"
}


static void tracker_test_test_case_class_init (TrackerTestTestCaseClass * klass) {
#line 32 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	tracker_test_test_case_parent_class = g_type_class_peek_parent (klass);
#line 32 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	FOLKS_TEST_CASE_CLASS (klass)->private_bus_up = tracker_test_test_case_real_private_bus_up;
#line 32 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	FOLKS_TEST_CASE_CLASS (klass)->set_up = tracker_test_test_case_real_set_up;
#line 32 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	TRACKER_TEST_TEST_CASE_CLASS (klass)->create_backend = tracker_test_test_case_real_create_backend;
#line 32 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = tracker_test_test_case_real_tear_down;
#line 32 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_test_test_case_finalize;
#line 483 "test-case.c"
}


static void tracker_test_test_case_instance_init (TrackerTestTestCase * self) {
#line 40 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	self->tracker_backend = NULL;
#line 490 "test-case.c"
}


static void tracker_test_test_case_finalize (GObject* obj) {
	TrackerTestTestCase * self;
#line 32 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TEST_TYPE_TEST_CASE, TrackerTestTestCase);
#line 40 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	_tracker_test_backend_unref0 (self->tracker_backend);
#line 32 "/opt/gnome3/source/folks/tests/lib/tracker/test-case.vala"
	G_OBJECT_CLASS (tracker_test_test_case_parent_class)->finalize (obj);
#line 502 "test-case.c"
}


/**
 * A test case for the Tracker backend.
 *
 * Folks is configured to use the Tracker backend as primary store,
 * and no other backends.
 *
 * This uses tracker-control to start and stop Tracker services on a private
 * D-Bus bus.
 */
GType tracker_test_test_case_get_type (void) {
	static volatile gsize tracker_test_test_case_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_test_test_case_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerTestTestCaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_test_test_case_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerTestTestCase), 0, (GInstanceInitFunc) tracker_test_test_case_instance_init, NULL };
		GType tracker_test_test_case_type_id;
		tracker_test_test_case_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "TrackerTestTestCase", &g_define_type_info, 0);
		g_once_init_leave (&tracker_test_test_case_type_id__volatile, tracker_test_test_case_type_id);
	}
	return tracker_test_test_case_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



