/*
 * Decompiled with CFR 0.152.
 */
package bemused;

import bemused.BemusedProtocolException;
import bemused.CommandTarget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import translate.Translate;

public class Command {
    String name;
    String strArg;
    int intArg;
    byte byteArg;
    Translate t = Translate.getInstance();

    public Command(String string) {
        this.name = string;
    }

    public Command(String string, int n) {
        this.name = string;
        this.intArg = n;
    }

    public Command(String string, byte by) {
        this.name = string;
        this.byteArg = by;
    }

    public Command(String string, String string2) {
        this.name = string;
        this.strArg = string2;
    }

    public void setFilenameArg(String string) {
        this.strArg = string;
    }

    public String getName() {
        return this.name;
    }

    private byte readByte(DataInputStream dataInputStream) throws IOException {
        return (byte)dataInputStream.readUnsignedByte();
    }

    private void writeShort(DataOutputStream dataOutputStream, short s) throws IOException {
        dataOutputStream.writeShort(s);
    }

    private void writeString(DataOutputStream dataOutputStream, String string) throws BemusedProtocolException {
        byte[] byArray = string.getBytes();
        try {
            for (int i = 0; i < byArray.length; ++i) {
                dataOutputStream.writeByte(byArray[i]);
            }
        }
        catch (IOException iOException) {
            throw new BemusedProtocolException("BemusedCommand:execute: " + iOException.getMessage());
        }
    }

    public void execute(CommandTarget commandTarget) throws BemusedProtocolException {
        DataOutputStream dataOutputStream = commandTarget.getOutputStream();
        DataInputStream dataInputStream = commandTarget.getInputStream();
        try {
            dataOutputStream.write(this.name.getBytes(), 0, 4);
            if (this.name.equals("TEXT")) {
                this.writeString(dataOutputStream, this.strArg);
                dataOutputStream.flush();
            } else if (this.name.equals("MITM")) {
                this.writeString(dataOutputStream, this.strArg);
                dataOutputStream.flush();
            } else if (this.name.equals("MSND")) {
                dataOutputStream.flush();
                this.readMenu(dataInputStream, commandTarget);
            } else if (this.name.equals("STAT")) {
                dataOutputStream.flush();
                this.readItemData(dataInputStream, commandTarget);
            } else {
                dataOutputStream.flush();
            }
        }
        catch (IOException iOException) {
            throw new BemusedProtocolException("BemusedCommand:execute: " + iOException.getMessage());
        }
    }

    private void readMenu(DataInputStream dataInputStream, CommandTarget commandTarget) throws IOException {
        byte[] byArray = new byte[128];
        int n = byArray.length;
        Vector<String> vector = new Vector<String>();
        byte by = this.readByte(dataInputStream);
        while (by != 0) {
            int n2 = 0;
            while (by != 10) {
                if (n2 < n) {
                    byArray[n2++] = by;
                }
                by = this.readByte(dataInputStream);
            }
            if (n2 > 0) {
                String string = new String(byArray, 0, n2, "UTF-8");
                vector.addElement(string);
            }
            by = this.readByte(dataInputStream);
        }
        int n3 = vector.size();
        String[] stringArray = new String[n3 < 1 ? 0 : n3];
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        commandTarget.setDirInfo(stringArray);
    }

    private void requestMenu(DataOutputStream dataOutputStream) throws BemusedProtocolException {
        this.writeString(dataOutputStream, "MSND");
    }

    private void readItemData(DataInputStream dataInputStream, CommandTarget commandTarget) throws IOException {
        byte[] byArray = new byte[128];
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.readByte(dataInputStream);
        while (by != 0) {
            int n2 = 0;
            while (n2 < n && by != 0) {
                byArray[n2++] = by;
                by = this.readByte(dataInputStream);
            }
            String string = new String(byArray, 0, n2, "UTF-8");
            stringBuffer.append(string);
        }
        String string = stringBuffer.toString();
        if (string.equals("")) {
            string = Translate.get("Press any key to control");
        }
        commandTarget.setStatus(string);
    }
}

