/* utils.c generated by valac 0.14.2, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010-2011 Simon Busch <morphis@gravedo.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <freesmartphone.h>
#include <fsogsm.h>
#include <fsobasics.h>
#include <stdlib.h>
#include <string.h>
#include <fsotransport.h>
#include <radio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SAMSUNG_TYPE_IPC_CHANNEL (samsung_ipc_channel_get_type ())
#define SAMSUNG_IPC_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SAMSUNG_TYPE_IPC_CHANNEL, SamsungIpcChannel))
#define SAMSUNG_IPC_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SAMSUNG_TYPE_IPC_CHANNEL, SamsungIpcChannelClass))
#define SAMSUNG_IS_IPC_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SAMSUNG_TYPE_IPC_CHANNEL))
#define SAMSUNG_IS_IPC_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SAMSUNG_TYPE_IPC_CHANNEL))
#define SAMSUNG_IPC_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SAMSUNG_TYPE_IPC_CHANNEL, SamsungIpcChannelClass))

typedef struct _SamsungIpcChannel SamsungIpcChannel;
typedef struct _SamsungIpcChannelClass SamsungIpcChannelClass;



void updateSimAuthStatus (FreeSmartphoneGSMSIMAuthStatus status);
const gchar* free_smartphone_gsm_sim_auth_status_to_string (FreeSmartphoneGSMSIMAuthStatus self);
gchar* gatherFunctionalityLevel (void);
GType samsung_ipc_channel_get_type (void) G_GNUC_CONST;
GType samsung_ipc_channel_register_type (GTypeModule * module);
gint16 samsung_ipc_channel_get_phone_pwr_state (SamsungIpcChannel* self);
gchar* networkRegistrationStateToString (gint8 reg_state);
gchar* networkAccessTechnologyToString (gint8 act);
gchar* ipAddrFromByteArray (guint8* data, gint size);


void updateSimAuthStatus (FreeSmartphoneGSMSIMAuthStatus status) {
	FsoGsmModem* _tmp0_;
	FsoFrameworkLogger* _tmp1_;
	FreeSmartphoneGSMSIMAuthStatus _tmp2_;
	GEnumValue* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	FsoGsmModem* _tmp6_;
	gpointer _tmp7_ = NULL;
	FreeSmartphoneGSMSIM* obj;
	FreeSmartphoneGSMSIM* _tmp8_;
	FreeSmartphoneGSMSIMAuthStatus _tmp9_;
	FsoGsmModem* _tmp10_;
	FsoGsmModemData* _tmp11_ = NULL;
	FsoGsmModemData* data;
	FreeSmartphoneGSMSIMAuthStatus _tmp12_;
	FsoGsmModemData* _tmp13_;
	FreeSmartphoneGSMSIMAuthStatus _tmp14_;
	_tmp0_ = fso_gsm_theModem;
	_tmp1_ = ((FsoFrameworkAbstractObject*) _tmp0_)->logger;
	_tmp2_ = status;
	_tmp3_ = g_enum_get_value (g_type_class_ref (FREE_SMARTPHONE_GSM_TYPE_SIM_AUTH_STATUS), _tmp2_);
	_tmp4_ = g_strconcat ("SIM Auth status now ", (_tmp3_ != NULL) ? _tmp3_->value_name : NULL, NULL);
	_tmp5_ = _tmp4_;
	fso_framework_logger_info (_tmp1_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = fso_gsm_theModem;
	_tmp7_ = fso_gsm_modem_theDevice (_tmp6_, FREE_SMARTPHONE_GSM_TYPE_SIM, (GBoxedCopyFunc) g_object_ref, g_object_unref);
	obj = (FreeSmartphoneGSMSIM*) _tmp7_;
	_tmp8_ = obj;
	_tmp9_ = status;
	g_signal_emit_by_name (_tmp8_, "auth-status", _tmp9_);
	_tmp10_ = fso_gsm_theModem;
	_tmp11_ = fso_gsm_modem_data (_tmp10_);
	data = _tmp11_;
	_tmp12_ = status;
	_tmp13_ = data;
	_tmp14_ = _tmp13_->simAuthStatus;
	if (_tmp12_ != _tmp14_) {
		FsoGsmModemData* _tmp15_;
		FreeSmartphoneGSMSIMAuthStatus _tmp16_;
		FsoGsmModem* _tmp17_;
		FsoGsmModemStatus _tmp18_ = 0;
		FsoGsmModemStatus modemStatus;
		FsoGsmModemStatus _tmp19_;
		_tmp15_ = data;
		_tmp16_ = status;
		_tmp15_->simAuthStatus = _tmp16_;
		_tmp17_ = fso_gsm_theModem;
		_tmp18_ = fso_gsm_modem_status (_tmp17_);
		modemStatus = _tmp18_;
		_tmp19_ = modemStatus;
		if (_tmp19_ == FSO_GSM_MODEM_STATUS_INITIALIZING) {
			FreeSmartphoneGSMSIMAuthStatus _tmp20_;
			_tmp20_ = status;
			if (_tmp20_ == FREE_SMARTPHONE_GSM_SIM_AUTH_STATUS_READY) {
				FsoGsmModem* _tmp21_;
				_tmp21_ = fso_gsm_theModem;
				fso_gsm_modem_advanceToState (_tmp21_, FSO_GSM_MODEM_STATUS_ALIVE_SIM_UNLOCKED, FALSE);
			} else {
				FsoGsmModem* _tmp22_;
				_tmp22_ = fso_gsm_theModem;
				fso_gsm_modem_advanceToState (_tmp22_, FSO_GSM_MODEM_STATUS_ALIVE_SIM_LOCKED, FALSE);
			}
		} else {
			FsoGsmModemStatus _tmp23_;
			_tmp23_ = modemStatus;
			if (_tmp23_ == FSO_GSM_MODEM_STATUS_ALIVE_SIM_LOCKED) {
				FreeSmartphoneGSMSIMAuthStatus _tmp24_;
				_tmp24_ = status;
				if (_tmp24_ == FREE_SMARTPHONE_GSM_SIM_AUTH_STATUS_READY) {
					FsoGsmModem* _tmp25_;
					_tmp25_ = fso_gsm_theModem;
					fso_gsm_modem_advanceToState (_tmp25_, FSO_GSM_MODEM_STATUS_ALIVE_SIM_UNLOCKED, FALSE);
				}
			} else {
				gboolean _tmp26_ = FALSE;
				FsoGsmModemStatus _tmp27_;
				gboolean _tmp29_;
				_tmp27_ = modemStatus;
				if (_tmp27_ == FSO_GSM_MODEM_STATUS_ALIVE_REGISTERED) {
					_tmp26_ = TRUE;
				} else {
					FsoGsmModemStatus _tmp28_;
					_tmp28_ = modemStatus;
					_tmp26_ = _tmp28_ == FSO_GSM_MODEM_STATUS_ALIVE_SIM_UNLOCKED;
				}
				_tmp29_ = _tmp26_;
				if (_tmp29_) {
					FreeSmartphoneGSMSIMAuthStatus _tmp30_;
					_tmp30_ = status;
					if (_tmp30_ == FREE_SMARTPHONE_GSM_SIM_AUTH_STATUS_PIN_REQUIRED) {
						FsoGsmModem* _tmp31_;
						_tmp31_ = fso_gsm_theModem;
						fso_gsm_modem_advanceToState (_tmp31_, FSO_GSM_MODEM_STATUS_ALIVE_SIM_LOCKED, TRUE);
					}
				}
			}
		}
	}
	_g_object_unref0 (data);
	_g_object_unref0 (obj);
}


/**
 * Determine functionality level according to modem state
 **/
gchar* gatherFunctionalityLevel (void) {
	gchar* result = NULL;
	FsoGsmModem* _tmp0_;
	FsoGsmChannel* _tmp1_ = NULL;
	SamsungIpcChannel* channel;
	gchar* _tmp2_;
	gchar* functionality_level;
	gboolean _tmp3_ = FALSE;
	FsoGsmModem* _tmp4_;
	FsoGsmModemStatus _tmp5_ = 0;
	gboolean _tmp9_;
	_tmp0_ = fso_gsm_theModem;
	_tmp1_ = fso_gsm_modem_channel (_tmp0_, "main");
	channel = SAMSUNG_IS_IPC_CHANNEL (_tmp1_) ? ((SamsungIpcChannel*) _tmp1_) : NULL;
	_tmp2_ = g_strdup ("minimal");
	functionality_level = _tmp2_;
	_tmp4_ = fso_gsm_theModem;
	_tmp5_ = fso_gsm_modem_status (_tmp4_);
	if (_tmp5_ == FSO_GSM_MODEM_STATUS_ALIVE_SIM_READY) {
		SamsungIpcChannel* _tmp6_;
		gint16 _tmp7_;
		gint16 _tmp8_;
		_tmp6_ = channel;
		_tmp7_ = samsung_ipc_channel_get_phone_pwr_state (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp3_ = _tmp8_ == IPC_PWR_PHONE_STATE_LPM;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp9_ = _tmp3_;
	if (_tmp9_) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("airplane");
		_g_free0 (functionality_level);
		functionality_level = _tmp10_;
	} else {
		FsoGsmModem* _tmp11_;
		FsoGsmModemStatus _tmp12_ = 0;
		_tmp11_ = fso_gsm_theModem;
		_tmp12_ = fso_gsm_modem_status (_tmp11_);
		if (_tmp12_ == FSO_GSM_MODEM_STATUS_ALIVE_REGISTERED) {
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("full");
			_g_free0 (functionality_level);
			functionality_level = _tmp13_;
		}
	}
	result = functionality_level;
	_g_object_unref0 (channel);
	return result;
}


gchar* networkRegistrationStateToString (gint8 reg_state) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _result_;
	gint8 _tmp1_;
	_tmp0_ = g_strdup ("unknown");
	_result_ = _tmp0_;
	_tmp1_ = reg_state;
	switch (_tmp1_) {
		case IPC_NET_REGISTRATION_STATE_HOME:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("home");
			_g_free0 (_result_);
			_result_ = _tmp2_;
			break;
		}
		case IPC_NET_REGISTRATION_STATE_SEARCHING:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("busy");
			_g_free0 (_result_);
			_result_ = _tmp3_;
			break;
		}
		case IPC_NET_REGISTRATION_STATE_EMERGENCY:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("denied");
			_g_free0 (_result_);
			_result_ = _tmp4_;
			break;
		}
		case IPC_NET_REGISTRATION_STATE_ROAMING:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("roaming");
			_g_free0 (_result_);
			_result_ = _tmp5_;
			break;
		}
		default:
		break;
	}
	result = _result_;
	return result;
}


gchar* networkAccessTechnologyToString (gint8 act) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _result_;
	gint8 _tmp1_;
	_tmp0_ = g_strdup ("unknown");
	_result_ = _tmp0_;
	_tmp1_ = act;
	switch (_tmp1_) {
		case IPC_NET_ACCESS_TECHNOLOGY_GSM:
		case IPC_NET_ACCESS_TECHNOLOGY_GSM2:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("GSM");
			_g_free0 (_result_);
			_result_ = _tmp2_;
			break;
		}
		case IPC_NET_ACCESS_TECHNOLOGY_GPRS:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("GPRS");
			_g_free0 (_result_);
			_result_ = _tmp3_;
			break;
		}
		case IPC_NET_ACCESS_TECHNOLOGY_EDGE:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("EDGE");
			_g_free0 (_result_);
			_result_ = _tmp4_;
			break;
		}
		case IPC_NET_ACCESS_TECHNOLOGY_UMTS:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("UMTS");
			_g_free0 (_result_);
			_result_ = _tmp5_;
			break;
		}
		default:
		break;
	}
	result = _result_;
	return result;
}


gchar* ipAddrFromByteArray (guint8* data, gint size) {
	gchar* result = NULL;
	gint _tmp0_;
	guint8* _tmp2_;
	guint8 _tmp3_;
	guint8* _tmp4_;
	guint8 _tmp5_;
	guint8* _tmp6_;
	guint8 _tmp7_;
	guint8* _tmp8_;
	guint8 _tmp9_;
	gchar* _tmp10_ = NULL;
	_tmp0_ = size;
	if (_tmp0_ != 4) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("0.0.0.0");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = data;
	_tmp3_ = _tmp2_[0];
	_tmp4_ = data;
	_tmp5_ = _tmp4_[1];
	_tmp6_ = data;
	_tmp7_ = _tmp6_[2];
	_tmp8_ = data;
	_tmp9_ = _tmp8_[3];
	_tmp10_ = g_strdup_printf ("%i.%i.%i.%i", (gint) _tmp3_, (gint) _tmp5_, (gint) _tmp7_, (gint) _tmp9_);
	result = _tmp10_;
	return result;
}



