/* testsms.c generated by valac 0.14.2, the Vala compiler
 * generated from testsms.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <smsutil.h>
#include <conversions.h>
#include <stdlib.h>
#include <string.h>
#include <util.h>
#include <fsogsm.h>
#include <gee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _sms_free0(var) ((var == NULL) ? NULL : (var = (sms_free (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
#define _wrap_hex_pdu_unref0(var) ((var == NULL) ? NULL : (var = (wrap_hex_pdu_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))


extern GSList* smslist;

void test_sms_decode_deliver_single_default_alphabet (void);
static guint8* _vala_array_dup1 (guint8* self, int length);
void test_sms_decode_deliver_single_concatenated_default_alphabet (void);
static guint8* _vala_array_dup2 (guint8* self, int length);
void test_sms_decode_deliver_multiple_concatenated_default_alphabet (void);
void test_sms_decode_deliver_whole_concatenated_default_alphabet (void);
void test_sms_decode_deliver_incoming_mms_control_message (void);
#define pdu5 "0791947106004034440B899421436587F900F501505102500280860605040B8423F061" \
"06226170706C69636174696F6E2F766E642E7761702E6D6D732D6D65737361676500AF" \
"848C82986B70684544414F637942008D908919802B3439313730323732303030332F54" \
"5950453D504C4D4E008A808E0261A88805810303F47983687474703A2F2F31302E3831" \
"2E302E373A383030322F6B70684544414F63794200"
#define pdulength5 153
void test_sms_decode_status_report (void);
#define pdu4 "079144999701903706990C91448748749999101151714000001011517140000000"
#define pdulength4 25
const gchar* sms_status_to_string (int self);
static const char* _sms_status_to_string (int value);
void test_sms_encode_submit_single_default_alphabet (void);
#define SHORT_TEXT "Hoffentlich diesmal mit ACKPDU"
static guint8* _vala_array_dup3 (guint8* self, int length);
void test_sms_encode_submit_concatenated_default_alphabet (void);
#define PHONE_NUMBER "+49123456789"
#define LONG_TEXT "freesmartphone.org is a collaboration platform for open source and ope" \
"n discussion software projects working on interoperability and shared " \
"technology for Linux-based SmartPhones. freesmartphone.org works on a " \
"service layer (middleware) that allows developers to concentrate on th" \
"eir application business logic rather than dealing with device specifi" \
"cs. freesmartphone.org honours and bases on specifications and softwar" \
"e created by the freedesktop.org community."
void _vala_main (gchar** args, int args_length1);
static void _test_sms_decode_deliver_single_default_alphabet_gcallback (void);
static void _test_sms_decode_deliver_single_concatenated_default_alphabet_gcallback (void);
static void _test_sms_decode_deliver_multiple_concatenated_default_alphabet_gcallback (void);
static void _test_sms_decode_status_report_gcallback (void);
static void _test_sms_encode_submit_single_default_alphabet_gcallback (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

extern const gint pdulengths1[11];
extern const gchar* pdus1[11];
extern const gchar* LONG_TEXT_PDUS[4];
extern const gint LONG_TEXT_PDULENS[4];

static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static struct sms* sms_newFromHexPdu (const gchar* hexpdu, gint tpdulen) {
	struct sms* result = NULL;
	glong items_written;
	gchar* _tmp0_ = NULL;
	gchar* binpdu;
	gint binpdu_length1;
	gint _binpdu_size_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp2__length1;
	glong _tmp3_ = 0L;
	glong _tmp4_;
	struct sms* _tmp5_;
	struct sms* sms;
	gchar* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	struct sms* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean res;
	gboolean _tmp10_;
	g_return_val_if_fail (hexpdu != NULL, NULL);
	items_written = (glong) (-1);
	_tmp0_ = g_new0 (gchar, 1024);
	binpdu = _tmp0_;
	binpdu_length1 = 1024;
	_binpdu_size_ = binpdu_length1;
	_tmp1_ = hexpdu;
	_tmp2_ = binpdu;
	_tmp2__length1 = binpdu_length1;
	decode_hex_own_buf (_tmp1_, (glong) (-1), &_tmp3_, (gchar) 0, _tmp2_);
	items_written = _tmp3_;
	_tmp4_ = items_written;
	g_assert (_tmp4_ != ((glong) (-1)));
	_tmp5_ = sms_new ();
	sms = _tmp5_;
	_tmp6_ = binpdu;
	_tmp6__length1 = binpdu_length1;
	_tmp7_ = tpdulen;
	_tmp8_ = sms;
	_tmp9_ = sms_decode (_tmp6_, _tmp6__length1, FALSE, _tmp7_, _tmp8_);
	res = _tmp9_;
	_tmp10_ = res;
	if (!_tmp10_) {
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp11_ = tpdulen;
		_tmp12_ = g_strdup_printf ("%i", _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = hexpdu;
		_tmp15_ = string_to_string (_tmp14_);
		_tmp16_ = g_strconcat ("Sms.Message::newFromHexPdu: could not decode message w/ tpdulen ", _tmp13_, " and hexpdu ", _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		g_warning ("fsogsm3rdparty.vapi:602: %s", _tmp17_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp13_);
		result = NULL;
		_sms_free0 (sms);
		binpdu = (g_free (binpdu), NULL);
		return result;
	} else {
		result = sms;
		binpdu = (g_free (binpdu), NULL);
		return result;
	}
	_sms_free0 (sms);
	binpdu = (g_free (binpdu), NULL);
}


static gchar* sms_number (struct sms* self) {
	gchar* result = NULL;
	enum sms_type _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->type;
	switch (_tmp0_) {
		case SMS_TYPE_DELIVER:
		{
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_;
			_tmp1_ = sms_address_to_string (&self->deliver.oaddr);
			_tmp2_ = g_strdup (_tmp1_);
			result = _tmp2_;
			return result;
		}
		case SMS_TYPE_SUBMIT:
		{
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp3_ = sms_address_to_string (&self->submit.daddr);
			_tmp4_ = g_strdup (_tmp3_);
			result = _tmp4_;
			return result;
		}
		case SMS_TYPE_COMMAND:
		{
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			_tmp5_ = sms_address_to_string (&self->command.daddr);
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			return result;
		}
		case SMS_TYPE_STATUS_REPORT:
		{
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp7_ = sms_address_to_string (&self->status_report.raddr);
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		}
		default:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("unknown");
			result = _tmp9_;
			return result;
		}
	}
}


static gchar* sms_to_string (struct sms* self) {
	gchar* result = NULL;
	GSList* list;
	GSList* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	list = NULL;
	list = g_slist_append (list, self);
	_tmp0_ = list;
	_tmp1_ = sms_decode_text (_tmp0_);
	result = _tmp1_;
	_g_slist_free0 (list);
	return result;
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void test_sms_decode_deliver_single_default_alphabet (void) {
	struct sms* _tmp0_ = NULL;
	struct sms* sms;
	enum sms_type _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	struct sms_deliver _tmp5_;
	struct sms_scts _tmp6_;
	guint8 _tmp7_;
	struct sms_deliver _tmp8_;
	struct sms_scts _tmp9_;
	guint8 _tmp10_;
	struct sms_deliver _tmp11_;
	struct sms_scts _tmp12_;
	guint8 _tmp13_;
	struct sms_deliver _tmp14_;
	struct sms_scts _tmp15_;
	guint8 _tmp16_;
	struct sms_deliver _tmp17_;
	struct sms_scts _tmp18_;
	guint8 _tmp19_;
	struct sms_deliver _tmp20_;
	struct sms_scts _tmp21_;
	guint8 _tmp22_;
	struct sms_deliver _tmp23_;
	struct sms_scts _tmp24_;
	gint8 _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	gboolean udhi = FALSE;
	guint8 dcs = 0U;
	guint8 max = 0U;
	gboolean _tmp28_ = FALSE;
	guint8 _tmp29_ = 0U;
	guint8 _tmp30_ = 0U;
	guint8 _tmp31_;
	guint8* _tmp32_ = NULL;
	guint8* _tmp33_;
	gint _tmp33__length1;
	guint8* ud;
	gint ud_length1;
	gint _ud_size_;
	_tmp0_ = sms_newFromHexPdu ("0791947106004034040D91947146093052F20000900192608270401EC8B7D95C76D3D9" \
"E9311A444E97E7ED301BD44ED341C1E1124AAC02", 47);
	sms = _tmp0_;
	_tmp1_ = sms->type;
	g_assert (_tmp1_ == SMS_TYPE_DELIVER);
	_tmp2_ = sms_address_to_string (&sms->sc_addr);
	g_assert (g_strcmp0 (_tmp2_, "+491760000443") == 0);
	_tmp3_ = sms_number (sms);
	_tmp4_ = _tmp3_;
	g_assert (g_strcmp0 (_tmp4_, "+4917649003252") == 0);
	_g_free0 (_tmp4_);
	_tmp5_ = sms->deliver;
	_tmp6_ = _tmp5_.scts;
	_tmp7_ = _tmp6_.year;
	g_assert (((gint) _tmp7_) == 9);
	_tmp8_ = sms->deliver;
	_tmp9_ = _tmp8_.scts;
	_tmp10_ = _tmp9_.month;
	g_assert (((gint) _tmp10_) == 10);
	_tmp11_ = sms->deliver;
	_tmp12_ = _tmp11_.scts;
	_tmp13_ = _tmp12_.day;
	g_assert (((gint) _tmp13_) == 29);
	_tmp14_ = sms->deliver;
	_tmp15_ = _tmp14_.scts;
	_tmp16_ = _tmp15_.hour;
	g_assert (((gint) _tmp16_) == 6);
	_tmp17_ = sms->deliver;
	_tmp18_ = _tmp17_.scts;
	_tmp19_ = _tmp18_.minute;
	g_assert (((gint) _tmp19_) == 28);
	_tmp20_ = sms->deliver;
	_tmp21_ = _tmp20_.scts;
	_tmp22_ = _tmp21_.second;
	g_assert (((gint) _tmp22_) == 7);
	_tmp23_ = sms->deliver;
	_tmp24_ = _tmp23_.scts;
	_tmp25_ = _tmp24_.timezone;
	g_assert (((gint) _tmp25_) == (+4));
	_tmp26_ = sms_to_string (sms);
	_tmp27_ = _tmp26_;
	g_assert (g_strcmp0 (_tmp27_, "Hoffentlich diesmal mit ACKPDU") == 0);
	_g_free0 (_tmp27_);
	_tmp32_ = sms_extract_common (sms, &_tmp28_, &_tmp29_, &_tmp31_, &_tmp30_);
	udhi = _tmp28_;
	dcs = _tmp29_;
	max = _tmp30_;
	_tmp33_ = (_tmp32_ != NULL) ? _vala_array_dup1 (_tmp32_, _tmp31_) : ((gpointer) _tmp32_);
	_tmp33__length1 = _tmp31_;
	ud = _tmp33_;
	ud_length1 = _tmp33__length1;
	_ud_size_ = ud_length1;
	g_assert (ud != NULL);
	g_assert (ud_length1 == 30);
	g_assert (((gint) dcs) == 0);
	g_assert (((gint) max) == 140);
	g_assert (!udhi);
	ud = (g_free (ud), NULL);
	_sms_free0 (sms);
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void test_sms_decode_deliver_single_concatenated_default_alphabet (void) {
	struct sms* _tmp0_ = NULL;
	struct sms* sms;
	enum sms_type _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	struct sms_deliver _tmp5_;
	struct sms_scts _tmp6_;
	guint8 _tmp7_;
	struct sms_deliver _tmp8_;
	struct sms_scts _tmp9_;
	guint8 _tmp10_;
	struct sms_deliver _tmp11_;
	struct sms_scts _tmp12_;
	guint8 _tmp13_;
	struct sms_deliver _tmp14_;
	struct sms_scts _tmp15_;
	guint8 _tmp16_;
	struct sms_deliver _tmp17_;
	struct sms_scts _tmp18_;
	guint8 _tmp19_;
	struct sms_deliver _tmp20_;
	struct sms_scts _tmp21_;
	guint8 _tmp22_;
	struct sms_deliver _tmp23_;
	struct sms_scts _tmp24_;
	gint8 _tmp25_;
	gboolean udhi = FALSE;
	guint8 dcs = 0U;
	guint8 max = 0U;
	gboolean _tmp26_ = FALSE;
	guint8 _tmp27_ = 0U;
	guint8 _tmp28_ = 0U;
	guint8 _tmp29_;
	guint8* _tmp30_ = NULL;
	guint8* _tmp31_;
	gint _tmp31__length1;
	guint8* ud;
	gint ud_length1;
	gint _ud_size_;
	guint16 ref_num = 0U;
	guint8 max_msgs = 0U;
	guint8 seq_num = 0U;
	guint16 _tmp32_ = 0U;
	guint8 _tmp33_ = 0U;
	guint8 _tmp34_ = 0U;
	gboolean _tmp35_ = FALSE;
	_tmp0_ = sms_newFromHexPdu ("0791947101670000440C91947120270030000090010321614440A0050003040B02C668" \
"3A885C978FD1A034DA0D4297E5E1FADC9C7693CB6ED09AEF7697DD2CD0BCCC16CFE9A0" \
"7BD9ED06CDD365505A7E2EBBC9F7B0DB0D9A97D36E50B41E96D3D36539A82C37BFD967" \
"79393D4683EC65F93DECD6D341E83D9D5E76BB14CCB79BFC06A1C3747A19242D8FD174" \
"1039DC4ED3592072D803B2A6E520F77B8C06B9D363341D242ECBCB", 159);
	sms = _tmp0_;
	_tmp1_ = sms->type;
	g_assert (_tmp1_ == SMS_TYPE_DELIVER);
	_tmp2_ = sms_address_to_string (&sms->sc_addr);
	g_assert (g_strcmp0 (_tmp2_, "+491710760000") == 0);
	_tmp3_ = sms_number (sms);
	_tmp4_ = _tmp3_;
	g_assert (g_strcmp0 (_tmp4_, "+491702720003") == 0);
	_g_free0 (_tmp4_);
	_tmp5_ = sms->deliver;
	_tmp6_ = _tmp5_.scts;
	_tmp7_ = _tmp6_.year;
	g_assert (((gint) _tmp7_) == 9);
	_tmp8_ = sms->deliver;
	_tmp9_ = _tmp8_.scts;
	_tmp10_ = _tmp9_.month;
	g_assert (((gint) _tmp10_) == 10);
	_tmp11_ = sms->deliver;
	_tmp12_ = _tmp11_.scts;
	_tmp13_ = _tmp12_.day;
	g_assert (((gint) _tmp13_) == 30);
	_tmp14_ = sms->deliver;
	_tmp15_ = _tmp14_.scts;
	_tmp16_ = _tmp15_.hour;
	g_assert (((gint) _tmp16_) == 12);
	_tmp17_ = sms->deliver;
	_tmp18_ = _tmp17_.scts;
	_tmp19_ = _tmp18_.minute;
	g_assert (((gint) _tmp19_) == 16);
	_tmp20_ = sms->deliver;
	_tmp21_ = _tmp20_.scts;
	_tmp22_ = _tmp21_.second;
	g_assert (((gint) _tmp22_) == 44);
	_tmp23_ = sms->deliver;
	_tmp24_ = _tmp23_.scts;
	_tmp25_ = _tmp24_.timezone;
	g_assert (((gint) _tmp25_) == (+4));
	_tmp30_ = sms_extract_common (sms, &_tmp26_, &_tmp27_, &_tmp29_, &_tmp28_);
	udhi = _tmp26_;
	dcs = _tmp27_;
	max = _tmp28_;
	_tmp31_ = (_tmp30_ != NULL) ? _vala_array_dup2 (_tmp30_, _tmp29_) : ((gpointer) _tmp30_);
	_tmp31__length1 = _tmp29_;
	ud = _tmp31_;
	ud_length1 = _tmp31__length1;
	_ud_size_ = ud_length1;
	g_assert (ud != NULL);
	g_assert (ud_length1 == 160);
	g_assert (((gint) dcs) == 0);
	g_assert (((gint) max) == 140);
	g_assert (udhi);
	_tmp35_ = sms_extract_concatenation (sms, &_tmp32_, &_tmp33_, &_tmp34_);
	ref_num = _tmp32_;
	max_msgs = _tmp33_;
	seq_num = _tmp34_;
	g_assert (_tmp35_);
	g_assert (((gint) ref_num) == 4);
	g_assert (((gint) max_msgs) == 11);
	g_assert (((gint) seq_num) == 2);
	ud = (g_free (ud), NULL);
	_sms_free0 (sms);
}


void test_sms_decode_deliver_multiple_concatenated_default_alphabet (void) {
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				const gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				struct sms* _tmp8_ = NULL;
				struct sms* sms;
				guint16 ref_num = 0U;
				guint8 max_msgs = 0U;
				guint8 seq_num = 0U;
				struct sms* _tmp9_;
				guint16 _tmp10_ = 0U;
				guint8 _tmp11_ = 0U;
				guint8 _tmp12_ = 0U;
				gboolean _tmp13_ = FALSE;
				guint16 _tmp14_;
				guint8 _tmp15_;
				guint8 _tmp16_;
				gint _tmp17_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				if (!(_tmp3_ < G_N_ELEMENTS (pdulengths1))) {
					break;
				}
				_tmp4_ = i;
				_tmp5_ = pdus1[_tmp4_];
				_tmp6_ = i;
				_tmp7_ = pdulengths1[_tmp6_];
				_tmp8_ = sms_newFromHexPdu (_tmp5_, _tmp7_);
				sms = _tmp8_;
				_tmp9_ = sms;
				_tmp13_ = sms_extract_concatenation (_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
				ref_num = _tmp10_;
				max_msgs = _tmp11_;
				seq_num = _tmp12_;
				g_assert (_tmp13_);
				_tmp14_ = ref_num;
				g_assert (((gint) _tmp14_) == 4);
				_tmp15_ = max_msgs;
				g_assert (((gint) _tmp15_) == 11);
				_tmp16_ = seq_num;
				_tmp17_ = i;
				g_assert (((gint) _tmp16_) == (_tmp17_ + 1));
				_sms_free0 (sms);
			}
		}
	}
}


void test_sms_decode_deliver_whole_concatenated_default_alphabet (void) {
	struct sms** _tmp0_ = NULL;
	struct sms** smses;
	gint smses_length1;
	gint _smses_size_;
	GSList* smslist;
	GSList* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* text;
	gint _tmp22_;
	gint _tmp23_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	_tmp0_ = g_new0 (struct sms*, G_N_ELEMENTS (pdulengths1) + 1);
	smses = _tmp0_;
	smses_length1 = G_N_ELEMENTS (pdulengths1);
	_smses_size_ = smses_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				struct sms** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				gint _tmp7_;
				const gchar* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				struct sms* _tmp11_ = NULL;
				struct sms* _tmp12_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				if (!(_tmp4_ < G_N_ELEMENTS (pdulengths1))) {
					break;
				}
				_tmp5_ = smses;
				_tmp5__length1 = smses_length1;
				_tmp6_ = i;
				_tmp7_ = i;
				_tmp8_ = pdus1[_tmp7_];
				_tmp9_ = i;
				_tmp10_ = pdulengths1[_tmp9_];
				_tmp11_ = sms_newFromHexPdu (_tmp8_, _tmp10_);
				_sms_free0 (_tmp5_[_tmp6_]);
				_tmp5_[_tmp6_] = _tmp11_;
				_tmp12_ = _tmp5_[_tmp6_];
			}
		}
	}
	smslist = NULL;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_;
				gint _tmp16_;
				struct sms** _tmp17_;
				gint _tmp17__length1;
				gint _tmp18_;
				struct sms* _tmp19_;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = i;
				if (!(_tmp16_ < G_N_ELEMENTS (pdulengths1))) {
					break;
				}
				_tmp17_ = smses;
				_tmp17__length1 = smses_length1;
				_tmp18_ = i;
				_tmp19_ = _tmp17_[_tmp18_];
				smslist = g_slist_append (smslist, _tmp19_);
			}
		}
	}
	_tmp20_ = smslist;
	_tmp21_ = sms_decode_text (_tmp20_);
	text = _tmp21_;
	_tmp22_ = strlen (text);
	_tmp23_ = _tmp22_;
	g_assert (_tmp23_ == 1562);
	_tmp24_ = g_str_has_prefix (text, "Wie haben die Drazi von der Beteiligung der Centauri erfahren?");
	g_assert (_tmp24_);
	_tmp25_ = g_str_has_suffix (text, "zwischen Delenn und Lennier angedeutet zu werden.");
	g_assert (_tmp25_);
	_g_free0 (text);
	_g_slist_free0 (smslist);
	smses = (_vala_array_free (smses, smses_length1, (GDestroyNotify) sms_free), NULL);
}


void test_sms_decode_deliver_incoming_mms_control_message (void) {
	struct sms* _tmp0_ = NULL;
	struct sms* sms;
	gint dst = 0;
	gint src = 0;
	gboolean is8bit = FALSE;
	struct sms* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean has_app_port;
	gboolean _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_;
	gchar* _tmp10_;
	gchar* contents;
	struct sms* _tmp11_;
	struct sms_deliver _tmp12_;
	guint8* ud;
	const gchar* _tmp27_;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	_tmp0_ = sms_newFromHexPdu (pdu5, pdulength5);
	sms = _tmp0_;
	_tmp1_ = sms;
	_tmp5_ = sms_extract_app_port (_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	dst = _tmp2_;
	src = _tmp3_;
	is8bit = _tmp4_;
	has_app_port = _tmp5_;
	_tmp6_ = has_app_port;
	g_assert (_tmp6_);
	_tmp7_ = dst;
	g_assert (_tmp7_ == 2948);
	_tmp8_ = src;
	g_assert (_tmp8_ == 9200);
	_tmp9_ = is8bit;
	g_assert (!_tmp9_);
	_tmp10_ = g_strdup ("");
	contents = _tmp10_;
	_tmp11_ = sms;
	_tmp12_ = _tmp11_->deliver;
	ud = _tmp12_.ud;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_;
				gint _tmp16_;
				struct sms* _tmp17_;
				struct sms_deliver _tmp18_;
				guint8 _tmp19_;
				const gchar* _tmp20_;
				guint8* _tmp21_;
				gint _tmp22_;
				guint8 _tmp23_;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = i;
				_tmp17_ = sms;
				_tmp18_ = _tmp17_->deliver;
				_tmp19_ = _tmp18_.udl;
				if (!(_tmp16_ < ((gint) _tmp19_))) {
					break;
				}
				_tmp20_ = contents;
				_tmp21_ = ud;
				_tmp22_ = i;
				_tmp23_ = _tmp21_[_tmp22_];
				_tmp24_ = g_strdup_printf ("%c", (gint) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strconcat (_tmp20_, _tmp25_, NULL);
				_g_free0 (contents);
				contents = _tmp26_;
				_g_free0 (_tmp25_);
			}
		}
	}
	_tmp27_ = contents;
	_tmp28_ = string_to_string (_tmp27_);
	_tmp29_ = g_strconcat ("content = ", _tmp28_, NULL);
	_tmp30_ = _tmp29_;
	g_debug ("testsms.vala:164: %s", _tmp30_);
	_g_free0 (_tmp30_);
	g_assert (FALSE);
	_g_free0 (contents);
	_sms_free0 (sms);
}


static const char* _sms_status_to_string (int value) {
	switch (value) {
		case SMS_ST_COMPLETED_RECEIVED:
		return "SMS_ST_COMPLETED_RECEIVED";
		case SMS_ST_COMPLETED_UNABLE_TO_CONFIRM:
		return "SMS_ST_COMPLETED_UNABLE_TO_CONFIRM";
		case SMS_ST_COMPLETED_REPLACED:
		return "SMS_ST_COMPLETED_REPLACED";
		case SMS_ST_COMPLETED_LAST:
		return "SMS_ST_COMPLETED_LAST";
		case SMS_ST_TEMPORARY_CONGESTION:
		return "SMS_ST_TEMPORARY_CONGESTION";
		case SMS_ST_TEMPORARY_SME_BUSY:
		return "SMS_ST_TEMPORARY_SME_BUSY";
		case SMS_ST_TEMPORARY_NO_RESPONSE:
		return "SMS_ST_TEMPORARY_NO_RESPONSE";
		case SMS_ST_TEMPORARY_SERVICE_REJECTED:
		return "SMS_ST_TEMPORARY_SERVICE_REJECTED";
		case SMS_ST_TEMPORARY_QOS_UNAVAILABLE:
		return "SMS_ST_TEMPORARY_QOS_UNAVAILABLE";
		case SMS_ST_TEMPORARY_SME_ERROR:
		return "SMS_ST_TEMPORARY_SME_ERROR";
		case SMS_ST_TEMPORARY_LAST:
		return "SMS_ST_TEMPORARY_LAST";
		case SMS_ST_PERMANENT_RP_ERROR:
		return "SMS_ST_PERMANENT_RP_ERROR";
		case SMS_ST_PERMANENT_INVALID_DESTINATION:
		return "SMS_ST_PERMANENT_INVALID_DESTINATION";
		case SMS_ST_PERMANENT_CONNECTION_REJECTED:
		return "SMS_ST_PERMANENT_CONNECTION_REJECTED";
		case SMS_ST_PERMANENT_NOT_OBTAINABLE:
		return "SMS_ST_PERMANENT_NOT_OBTAINABLE";
		case SMS_ST_PERMANENT_QOS_UNAVAILABLE:
		return "SMS_ST_PERMANENT_QOS_UNAVAILABLE";
		case SMS_ST_PERMANENT_INTERWORKING_UNAVAILABLE:
		return "SMS_ST_PERMANENT_INTERWORKING_UNAVAILABLE";
		case SMS_ST_PERMANENT_VALIDITY_PERIOD_EXPIRED:
		return "SMS_ST_PERMANENT_VALIDITY_PERIOD_EXPIRED";
		case SMS_ST_PERMANENT_DELETED:
		return "SMS_ST_PERMANENT_DELETED";
		case SMS_ST_PERMANENT_SC_ADMIN_DELETED:
		return "SMS_ST_PERMANENT_SC_ADMIN_DELETED";
		case SMS_ST_PERMANENT_SM_DOES_NOT_EXIST:
		return "SMS_ST_PERMANENT_SM_DOES_NOT_EXIST";
		case SMS_ST_PERMANENT_LAST:
		return "SMS_ST_PERMANENT_LAST";
		case SMS_ST_TEMPFINAL_CONGESTION:
		return "SMS_ST_TEMPFINAL_CONGESTION";
		case SMS_ST_TEMPFINAL_SME_BUSY:
		return "SMS_ST_TEMPFINAL_SME_BUSY";
		case SMS_ST_TEMPFINAL_NO_RESPONSE:
		return "SMS_ST_TEMPFINAL_NO_RESPONSE";
		case SMS_ST_TEMPFINAL_SERVICE_REJECTED:
		return "SMS_ST_TEMPFINAL_SERVICE_REJECTED";
		case SMS_ST_TEMPFINAL_QOS_UNAVAILABLE:
		return "SMS_ST_TEMPFINAL_QOS_UNAVAILABLE";
		case SMS_ST_TEMPFINAL_SME_ERROR:
		return "SMS_ST_TEMPFINAL_SME_ERROR";
		case SMS_ST_TEMPFINAL_LAST:
		return "SMS_ST_TEMPFINAL_LAST";
	}
	return NULL;
}


void test_sms_decode_status_report (void) {
	struct sms* _tmp0_ = NULL;
	struct sms* sms;
	gchar* _tmp1_ = NULL;
	gchar* number;
	struct sms_status_report _tmp2_;
	guint8 _tmp3_;
	guint8 reference;
	struct sms_status_report _tmp4_;
	int _tmp5_;
	int status;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	_tmp0_ = sms_newFromHexPdu (pdu4, pdulength4);
	sms = _tmp0_;
	_tmp1_ = sms_number (sms);
	number = _tmp1_;
	_tmp2_ = sms->status_report;
	_tmp3_ = _tmp2_.mr;
	reference = _tmp3_;
	_tmp4_ = sms->status_report;
	_tmp5_ = _tmp4_.st;
	status = _tmp5_;
	_tmp6_ = string_to_string (number);
	_tmp7_ = g_strconcat ("sms report addr: ", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	g_debug ("testsms.vala:179: %s", _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = g_strdup_printf ("%hhu", reference);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat ("sms report ref: ", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	g_debug ("testsms.vala:180: %s", _tmp12_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = _sms_status_to_string (status);
	_tmp14_ = g_strconcat ("sms report status: ", _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	g_debug ("testsms.vala:181: %s", _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = sms_to_string (sms);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat ("sms report text: ", _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	g_debug ("testsms.vala:182: %s", _tmp19_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (number);
	_sms_free0 (sms);
}


static guint8* _vala_array_dup3 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void test_sms_encode_submit_single_default_alphabet (void) {
	gint offset = 0;
	gint _tmp0_ = 0;
	GSList* _tmp1_ = NULL;
	GSList* _tmp2_;
	guint _tmp3_ = 0U;
	GSList* _tmp4_;
	gconstpointer _tmp5_ = NULL;
	struct sms* sms;
	enum sms_type _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gboolean udhi = FALSE;
	guint8 dcs = 0U;
	guint8 max = 0U;
	gboolean _tmp9_ = FALSE;
	guint8 _tmp10_ = 0U;
	guint8 _tmp11_ = 0U;
	guint8 _tmp12_;
	guint8* _tmp13_ = NULL;
	guint8* _tmp14_;
	gint _tmp14__length1;
	guint8* ud;
	gint ud_length1;
	gint _ud_size_;
	gint _tmp15_;
	gint _tmp16_;
	_tmp1_ = sms_text_prepare (SHORT_TEXT, (guint16) 0, TRUE, &_tmp0_);
	offset = _tmp0_;
	_g_slist_free0 (smslist);
	smslist = _tmp1_;
	_tmp2_ = smslist;
	_tmp3_ = g_slist_length (_tmp2_);
	g_assert (_tmp3_ == ((guint) 1));
	_tmp4_ = smslist;
	_tmp5_ = g_slist_nth_data (_tmp4_, (guint) 0);
	sms = (struct sms*) ((struct sms*) _tmp5_);
	_tmp6_ = sms->type;
	g_assert (_tmp6_ == SMS_TYPE_SUBMIT);
	_tmp7_ = sms_to_string (sms);
	_tmp8_ = _tmp7_;
	g_assert (g_strcmp0 (_tmp8_, SHORT_TEXT) == 0);
	_g_free0 (_tmp8_);
	_tmp13_ = sms_extract_common (sms, &_tmp9_, &_tmp10_, &_tmp12_, &_tmp11_);
	udhi = _tmp9_;
	dcs = _tmp10_;
	max = _tmp11_;
	_tmp14_ = (_tmp13_ != NULL) ? _vala_array_dup3 (_tmp13_, _tmp12_) : ((gpointer) _tmp13_);
	_tmp14__length1 = _tmp12_;
	ud = _tmp14_;
	ud_length1 = _tmp14__length1;
	_ud_size_ = ud_length1;
	g_assert (ud != NULL);
	_tmp15_ = strlen (SHORT_TEXT);
	_tmp16_ = _tmp15_;
	g_assert (ud_length1 == _tmp16_);
	g_assert (((gint) dcs) == 0);
	g_assert (((gint) max) == 140);
	g_assert (!udhi);
	ud = (g_free (ud), NULL);
}


void test_sms_encode_submit_concatenated_default_alphabet (void) {
	FsoGsmAtSmsHandler* _tmp0_;
	FsoGsmSmsHandler* handler;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* pdu;
	gint _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_ = NULL;
	WrapHexPdu* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gpointer _tmp8_ = NULL;
	WrapHexPdu* _tmp9_;
	guint _tmp10_;
	gint _tmp11_;
	gpointer _tmp12_ = NULL;
	WrapHexPdu* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gpointer _tmp16_ = NULL;
	WrapHexPdu* _tmp17_;
	guint _tmp18_;
	gint _tmp19_;
	gpointer _tmp20_ = NULL;
	WrapHexPdu* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gpointer _tmp24_ = NULL;
	WrapHexPdu* _tmp25_;
	guint _tmp26_;
	gint _tmp27_;
	gpointer _tmp28_ = NULL;
	WrapHexPdu* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gpointer _tmp32_ = NULL;
	WrapHexPdu* _tmp33_;
	guint _tmp34_;
	gint _tmp35_;
	_tmp0_ = fso_gsm_at_sms_handler_new ();
	handler = (FsoGsmSmsHandler*) _tmp0_;
	_tmp1_ = fso_gsm_sms_handler_formatTextMessage (handler, PHONE_NUMBER, LONG_TEXT, FALSE);
	pdu = _tmp1_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) pdu);
	_tmp3_ = _tmp2_;
	g_assert (_tmp3_ == 4);
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) pdu, 0);
	_tmp5_ = (WrapHexPdu*) _tmp4_;
	_tmp6_ = _tmp5_->hexpdu;
	_tmp7_ = LONG_TEXT_PDUS[0];
	g_assert (g_strcmp0 (_tmp6_, _tmp7_) == 0);
	_wrap_hex_pdu_unref0 (_tmp5_);
	_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) pdu, 0);
	_tmp9_ = (WrapHexPdu*) _tmp8_;
	_tmp10_ = _tmp9_->tpdulen;
	_tmp11_ = LONG_TEXT_PDULENS[0];
	g_assert (_tmp10_ == ((guint) _tmp11_));
	_wrap_hex_pdu_unref0 (_tmp9_);
	_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) pdu, 1);
	_tmp13_ = (WrapHexPdu*) _tmp12_;
	_tmp14_ = _tmp13_->hexpdu;
	_tmp15_ = LONG_TEXT_PDUS[1];
	g_assert (g_strcmp0 (_tmp14_, _tmp15_) == 0);
	_wrap_hex_pdu_unref0 (_tmp13_);
	_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) pdu, 1);
	_tmp17_ = (WrapHexPdu*) _tmp16_;
	_tmp18_ = _tmp17_->tpdulen;
	_tmp19_ = LONG_TEXT_PDULENS[1];
	g_assert (_tmp18_ == ((guint) _tmp19_));
	_wrap_hex_pdu_unref0 (_tmp17_);
	_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) pdu, 2);
	_tmp21_ = (WrapHexPdu*) _tmp20_;
	_tmp22_ = _tmp21_->hexpdu;
	_tmp23_ = LONG_TEXT_PDUS[2];
	g_assert (g_strcmp0 (_tmp22_, _tmp23_) == 0);
	_wrap_hex_pdu_unref0 (_tmp21_);
	_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) pdu, 2);
	_tmp25_ = (WrapHexPdu*) _tmp24_;
	_tmp26_ = _tmp25_->tpdulen;
	_tmp27_ = LONG_TEXT_PDULENS[2];
	g_assert (_tmp26_ == ((guint) _tmp27_));
	_wrap_hex_pdu_unref0 (_tmp25_);
	_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) pdu, 3);
	_tmp29_ = (WrapHexPdu*) _tmp28_;
	_tmp30_ = _tmp29_->hexpdu;
	_tmp31_ = LONG_TEXT_PDUS[3];
	g_assert (g_strcmp0 (_tmp30_, _tmp31_) == 0);
	_wrap_hex_pdu_unref0 (_tmp29_);
	_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) pdu, 3);
	_tmp33_ = (WrapHexPdu*) _tmp32_;
	_tmp34_ = _tmp33_->tpdulen;
	_tmp35_ = LONG_TEXT_PDULENS[3];
	g_assert (_tmp34_ == ((guint) _tmp35_));
	_wrap_hex_pdu_unref0 (_tmp33_);
	_g_object_unref0 (pdu);
	_g_object_unref0 (handler);
}


static void _test_sms_decode_deliver_single_default_alphabet_gcallback (void) {
	test_sms_decode_deliver_single_default_alphabet ();
}


static void _test_sms_decode_deliver_single_concatenated_default_alphabet_gcallback (void) {
	test_sms_decode_deliver_single_concatenated_default_alphabet ();
}


static void _test_sms_decode_deliver_multiple_concatenated_default_alphabet_gcallback (void) {
	test_sms_decode_deliver_multiple_concatenated_default_alphabet ();
}


static void _test_sms_decode_status_report_gcallback (void) {
	test_sms_decode_status_report ();
}


static void _test_sms_encode_submit_single_default_alphabet_gcallback (void) {
	test_sms_encode_submit_single_default_alphabet ();
}


void _vala_main (gchar** args, int args_length1) {
	g_test_init (&args_length1, &args, NULL);
	g_test_add_func ("/3rdparty/Sms/Decode/Deliver/Single/DefaultAlphabet", _test_sms_decode_deliver_single_default_alphabet_gcallback);
	g_test_add_func ("/3rdparty/Sms/Decode/Deliver/Single/Concatenated/DefaultAlphabet", _test_sms_decode_deliver_single_concatenated_default_alphabet_gcallback);
	g_test_add_func ("/3rdparty/Sms/Decode/Deliver/Multiple/Concatenated/DefaultAlphabet", _test_sms_decode_deliver_multiple_concatenated_default_alphabet_gcallback);
	g_test_add_func ("/3rdparty/Sms/Decode/StatusReport", _test_sms_decode_status_report_gcallback);
	g_test_add_func ("/3rdparty/Sms/Encode/Submit/Single/DefaultAlphabet", _test_sms_encode_submit_single_default_alphabet_gcallback);
	g_test_run ();
}


int main (int argc, char ** argv) {
	g_type_init ();
	_vala_main (argv, argc);
	return 0;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



