#!/bin/sh

set -e

test -n "$1"
PLUGIN="$1"

BASEURL=https://hg.gajim.org
REPO=gajim-plugins
PACKAGE=gajim-$(echo "$PLUGIN" | sed 's/_//g')

CWD=$(pwd)
TMPDIR=$(mktemp -d)
cd "$TMPDIR"
hg clone "$BASEURL"/"$REPO"/
VERSION=$(grep ^version: ./"$REPO"/"$PLUGIN"/manifest.ini | sed 's/.*: *//')
FILENAME="$CWD"/../"$PACKAGE"_"$VERSION".orig.tar.gz
test ! -e "$FILENAME"
tar -czvf "$FILENAME" -C "$REPO"/ "$PLUGIN"/
echo You may remove "$TMPDIR" now
