{-# OPTIONS_GHC -w #-}
{-# OPTIONS -fglasgow-exts -cpp #-}
-- | This module provides the generated Happy parser for Haskell. It exports
-- a number of parsers which may be used in any library that uses the GHC API.
-- A common usage pattern is to initialize the parser state with a given string
-- and then parse that string:
--
-- @
--     runParser :: DynFlags -> String -> P a -> ParseResult a
--     runParser flags str parser = unP parser parseState
--     where
--       filename = "\<interactive\>"
--       location = mkRealSrcLoc (mkFastString filename) 1 1
--       buffer = stringToStringBuffer str
--       parseState = mkPState flags buffer location
-- @
module Parser (parseModule, parseImport, parseStatement,
               parseDeclaration, parseExpression, parsePattern,
               parseTypeSignature,
               parseStmt, parseIdentifier,
               parseType, parseHeader) where

-- base
import Control.Monad    ( unless, liftM )
import GHC.Exts
import Data.Char
import Control.Monad    ( mplus )
import Control.Applicative ((<$))

-- compiler/hsSyn
import HsSyn

-- compiler/main
import HscTypes         ( IsBootInterface, WarningTxt(..) )
import DynFlags

-- compiler/utils
import OrdList
import BooleanFormula   ( BooleanFormula(..), LBooleanFormula(..), mkTrue )
import FastString
import Maybes           ( orElse )
import Outputable

-- compiler/basicTypes
import RdrName
import OccName          ( varName, dataName, tcClsName, tvName, startsWithUnderscore )
import DataCon          ( DataCon, dataConName )
import SrcLoc
import Module
import BasicTypes

-- compiler/types
import Type             ( funTyCon )
import Kind             ( Kind )
import Class            ( FunDep )

-- compiler/parser
import RdrHsSyn
import Lexer
import HaddockUtils
import ApiAnnotation

-- compiler/typecheck
import TcEvidence       ( emptyTcEvBinds )

-- compiler/prelude
import ForeignCall
import TysPrim          ( eqPrimTyCon )
import PrelNames        ( eqTyCon_RDR )
import TysWiredIn       ( unitTyCon, unitDataCon, tupleTyCon, tupleDataCon, nilDataCon,
                          unboxedUnitTyCon, unboxedUnitDataCon,
                          listTyCon_RDR, parrTyCon_RDR, consDataCon_RDR )

-- compiler/utils
import Util             ( looksLikePackageName )
import Prelude

import qualified GHC.LanguageExtensions as LangExt
import qualified Data.Array as Happy_Data_Array
import qualified GHC.Exts as Happy_GHC_Exts
import Control.Applicative(Applicative(..))
import Control.Monad (ap)

-- parser produced by Happy Version 1.19.5

newtype HappyAbsSyn  = HappyAbsSyn HappyAny
#if __GLASGOW_HASKELL__ >= 607
type HappyAny = Happy_GHC_Exts.Any
#else
type HappyAny = forall a . a
#endif
happyIn14 :: (Located RdrName) -> (HappyAbsSyn )
happyIn14 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn14 #-}
happyOut14 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut14 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut14 #-}
happyIn15 :: (Located (HsModule RdrName)) -> (HappyAbsSyn )
happyIn15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn15 #-}
happyOut15 :: (HappyAbsSyn ) -> (Located (HsModule RdrName))
happyOut15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut15 #-}
happyIn16 :: (Maybe LHsDocString) -> (HappyAbsSyn )
happyIn16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn16 #-}
happyOut16 :: (HappyAbsSyn ) -> (Maybe LHsDocString)
happyOut16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut16 #-}
happyIn17 :: (()) -> (HappyAbsSyn )
happyIn17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn17 #-}
happyOut17 :: (HappyAbsSyn ) -> (())
happyOut17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut17 #-}
happyIn18 :: (Maybe (Located WarningTxt)) -> (HappyAbsSyn )
happyIn18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn18 #-}
happyOut18 :: (HappyAbsSyn ) -> (Maybe (Located WarningTxt))
happyOut18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut18 #-}
happyIn19 :: (([AddAnn]
             ,([LImportDecl RdrName], [LHsDecl RdrName]))) -> (HappyAbsSyn )
happyIn19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn19 #-}
happyOut19 :: (HappyAbsSyn ) -> (([AddAnn]
             ,([LImportDecl RdrName], [LHsDecl RdrName])))
happyOut19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut19 #-}
happyIn20 :: (([AddAnn]
             ,([LImportDecl RdrName], [LHsDecl RdrName]))) -> (HappyAbsSyn )
happyIn20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn20 #-}
happyOut20 :: (HappyAbsSyn ) -> (([AddAnn]
             ,([LImportDecl RdrName], [LHsDecl RdrName])))
happyOut20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut20 #-}
happyIn21 :: (([AddAnn]
             ,([LImportDecl RdrName], [LHsDecl RdrName]))) -> (HappyAbsSyn )
happyIn21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn21 #-}
happyOut21 :: (HappyAbsSyn ) -> (([AddAnn]
             ,([LImportDecl RdrName], [LHsDecl RdrName])))
happyOut21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut21 #-}
happyIn22 :: ([LHsDecl RdrName]) -> (HappyAbsSyn )
happyIn22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn22 #-}
happyOut22 :: (HappyAbsSyn ) -> ([LHsDecl RdrName])
happyOut22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut22 #-}
happyIn23 :: (Located (HsModule RdrName)) -> (HappyAbsSyn )
happyIn23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn23 #-}
happyOut23 :: (HappyAbsSyn ) -> (Located (HsModule RdrName))
happyOut23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut23 #-}
happyIn24 :: ([LImportDecl RdrName]) -> (HappyAbsSyn )
happyIn24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn24 #-}
happyOut24 :: (HappyAbsSyn ) -> ([LImportDecl RdrName])
happyOut24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut24 #-}
happyIn25 :: ([LImportDecl RdrName]) -> (HappyAbsSyn )
happyIn25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn25 #-}
happyOut25 :: (HappyAbsSyn ) -> ([LImportDecl RdrName])
happyOut25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut25 #-}
happyIn26 :: ((Maybe (Located [LIE RdrName]))) -> (HappyAbsSyn )
happyIn26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn26 #-}
happyOut26 :: (HappyAbsSyn ) -> ((Maybe (Located [LIE RdrName])))
happyOut26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut26 #-}
happyIn27 :: (OrdList (LIE RdrName)) -> (HappyAbsSyn )
happyIn27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn27 #-}
happyOut27 :: (HappyAbsSyn ) -> (OrdList (LIE RdrName))
happyOut27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut27 #-}
happyIn28 :: (OrdList (LIE RdrName)) -> (HappyAbsSyn )
happyIn28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn28 #-}
happyOut28 :: (HappyAbsSyn ) -> (OrdList (LIE RdrName))
happyOut28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut28 #-}
happyIn29 :: (OrdList (LIE RdrName)) -> (HappyAbsSyn )
happyIn29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn29 #-}
happyOut29 :: (HappyAbsSyn ) -> (OrdList (LIE RdrName))
happyOut29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut29 #-}
happyIn30 :: (OrdList (LIE RdrName)) -> (HappyAbsSyn )
happyIn30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn30 #-}
happyOut30 :: (HappyAbsSyn ) -> (OrdList (LIE RdrName))
happyOut30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut30 #-}
happyIn31 :: (OrdList (LIE RdrName)) -> (HappyAbsSyn )
happyIn31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn31 #-}
happyOut31 :: (HappyAbsSyn ) -> (OrdList (LIE RdrName))
happyOut31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut31 #-}
happyIn32 :: (Located ([AddAnn],ImpExpSubSpec)) -> (HappyAbsSyn )
happyIn32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn32 #-}
happyOut32 :: (HappyAbsSyn ) -> (Located ([AddAnn],ImpExpSubSpec))
happyOut32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut32 #-}
happyIn33 :: (([AddAnn], [Located (Maybe RdrName)])) -> (HappyAbsSyn )
happyIn33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn33 #-}
happyOut33 :: (HappyAbsSyn ) -> (([AddAnn], [Located (Maybe RdrName)]))
happyOut33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut33 #-}
happyIn34 :: (([AddAnn], [Located (Maybe RdrName)])) -> (HappyAbsSyn )
happyIn34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn34 #-}
happyOut34 :: (HappyAbsSyn ) -> (([AddAnn], [Located (Maybe RdrName)]))
happyOut34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut34 #-}
happyIn35 :: (Located ([AddAnn],Located (Maybe RdrName))) -> (HappyAbsSyn )
happyIn35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn35 #-}
happyOut35 :: (HappyAbsSyn ) -> (Located ([AddAnn],Located (Maybe RdrName)))
happyOut35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut35 #-}
happyIn36 :: (Located RdrName) -> (HappyAbsSyn )
happyIn36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn36 #-}
happyOut36 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut36 #-}
happyIn37 :: (Located RdrName) -> (HappyAbsSyn )
happyIn37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn37 #-}
happyOut37 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut37 #-}
happyIn38 :: (([AddAnn],[LImportDecl RdrName])) -> (HappyAbsSyn )
happyIn38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn38 #-}
happyOut38 :: (HappyAbsSyn ) -> (([AddAnn],[LImportDecl RdrName]))
happyOut38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut38 #-}
happyIn39 :: (LImportDecl RdrName) -> (HappyAbsSyn )
happyIn39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn39 #-}
happyOut39 :: (HappyAbsSyn ) -> (LImportDecl RdrName)
happyOut39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut39 #-}
happyIn40 :: ((([AddAnn],Maybe SourceText),IsBootInterface)) -> (HappyAbsSyn )
happyIn40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn40 #-}
happyOut40 :: (HappyAbsSyn ) -> ((([AddAnn],Maybe SourceText),IsBootInterface))
happyOut40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut40 #-}
happyIn41 :: (([AddAnn],Bool)) -> (HappyAbsSyn )
happyIn41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn41 #-}
happyOut41 :: (HappyAbsSyn ) -> (([AddAnn],Bool))
happyOut41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut41 #-}
happyIn42 :: (([AddAnn],Maybe StringLiteral)) -> (HappyAbsSyn )
happyIn42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn42 #-}
happyOut42 :: (HappyAbsSyn ) -> (([AddAnn],Maybe StringLiteral))
happyOut42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut42 #-}
happyIn43 :: (([AddAnn],Bool)) -> (HappyAbsSyn )
happyIn43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn43 #-}
happyOut43 :: (HappyAbsSyn ) -> (([AddAnn],Bool))
happyOut43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut43 #-}
happyIn44 :: (([AddAnn],Located (Maybe ModuleName))) -> (HappyAbsSyn )
happyIn44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn44 #-}
happyOut44 :: (HappyAbsSyn ) -> (([AddAnn],Located (Maybe ModuleName)))
happyOut44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut44 #-}
happyIn45 :: (Located (Maybe (Bool, Located [LIE RdrName]))) -> (HappyAbsSyn )
happyIn45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn45 #-}
happyOut45 :: (HappyAbsSyn ) -> (Located (Maybe (Bool, Located [LIE RdrName])))
happyOut45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut45 #-}
happyIn46 :: (Located (Bool, Located [LIE RdrName])) -> (HappyAbsSyn )
happyIn46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn46 #-}
happyOut46 :: (HappyAbsSyn ) -> (Located (Bool, Located [LIE RdrName]))
happyOut46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut46 #-}
happyIn47 :: (Located (SourceText,Int)) -> (HappyAbsSyn )
happyIn47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn47 #-}
happyOut47 :: (HappyAbsSyn ) -> (Located (SourceText,Int))
happyOut47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut47 #-}
happyIn48 :: (Located FixityDirection) -> (HappyAbsSyn )
happyIn48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn48 #-}
happyOut48 :: (HappyAbsSyn ) -> (Located FixityDirection)
happyOut48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut48 #-}
happyIn49 :: (Located (OrdList (Located RdrName))) -> (HappyAbsSyn )
happyIn49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn49 #-}
happyOut49 :: (HappyAbsSyn ) -> (Located (OrdList (Located RdrName)))
happyOut49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut49 #-}
happyIn50 :: (OrdList (LHsDecl RdrName)) -> (HappyAbsSyn )
happyIn50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn50 #-}
happyOut50 :: (HappyAbsSyn ) -> (OrdList (LHsDecl RdrName))
happyOut50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut50 #-}
happyIn51 :: (LHsDecl RdrName) -> (HappyAbsSyn )
happyIn51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn51 #-}
happyOut51 :: (HappyAbsSyn ) -> (LHsDecl RdrName)
happyOut51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut51 #-}
happyIn52 :: (LTyClDecl RdrName) -> (HappyAbsSyn )
happyIn52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn52 #-}
happyOut52 :: (HappyAbsSyn ) -> (LTyClDecl RdrName)
happyOut52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut52 #-}
happyIn53 :: (LTyClDecl RdrName) -> (HappyAbsSyn )
happyIn53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn53 #-}
happyOut53 :: (HappyAbsSyn ) -> (LTyClDecl RdrName)
happyOut53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut53 #-}
happyIn54 :: (LInstDecl RdrName) -> (HappyAbsSyn )
happyIn54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn54 #-}
happyOut54 :: (HappyAbsSyn ) -> (LInstDecl RdrName)
happyOut54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut54 #-}
happyIn55 :: (Maybe (Located OverlapMode)) -> (HappyAbsSyn )
happyIn55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn55 #-}
happyOut55 :: (HappyAbsSyn ) -> (Maybe (Located OverlapMode))
happyOut55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut55 #-}
happyIn56 :: (Located ([AddAnn], Maybe (LInjectivityAnn RdrName))) -> (HappyAbsSyn )
happyIn56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn56 #-}
happyOut56 :: (HappyAbsSyn ) -> (Located ([AddAnn], Maybe (LInjectivityAnn RdrName)))
happyOut56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut56 #-}
happyIn57 :: (LInjectivityAnn RdrName) -> (HappyAbsSyn )
happyIn57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn57 #-}
happyOut57 :: (HappyAbsSyn ) -> (LInjectivityAnn RdrName)
happyOut57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut57 #-}
happyIn58 :: (Located [Located RdrName]) -> (HappyAbsSyn )
happyIn58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn58 #-}
happyOut58 :: (HappyAbsSyn ) -> (Located [Located RdrName])
happyOut58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut58 #-}
happyIn59 :: (Located ([AddAnn],FamilyInfo RdrName)) -> (HappyAbsSyn )
happyIn59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn59 #-}
happyOut59 :: (HappyAbsSyn ) -> (Located ([AddAnn],FamilyInfo RdrName))
happyOut59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut59 #-}
happyIn60 :: (Located ([AddAnn],Maybe [LTyFamInstEqn RdrName])) -> (HappyAbsSyn )
happyIn60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn60 #-}
happyOut60 :: (HappyAbsSyn ) -> (Located ([AddAnn],Maybe [LTyFamInstEqn RdrName]))
happyOut60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut60 #-}
happyIn61 :: (Located [LTyFamInstEqn RdrName]) -> (HappyAbsSyn )
happyIn61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn61 #-}
happyOut61 :: (HappyAbsSyn ) -> (Located [LTyFamInstEqn RdrName])
happyOut61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut61 #-}
happyIn62 :: (Located ([AddAnn],LTyFamInstEqn RdrName)) -> (HappyAbsSyn )
happyIn62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn62 #-}
happyOut62 :: (HappyAbsSyn ) -> (Located ([AddAnn],LTyFamInstEqn RdrName))
happyOut62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut62 #-}
happyIn63 :: (LHsDecl RdrName) -> (HappyAbsSyn )
happyIn63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn63 #-}
happyOut63 :: (HappyAbsSyn ) -> (LHsDecl RdrName)
happyOut63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut63 #-}
happyIn64 :: ([AddAnn]) -> (HappyAbsSyn )
happyIn64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn64 #-}
happyOut64 :: (HappyAbsSyn ) -> ([AddAnn])
happyOut64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut64 #-}
happyIn65 :: (LInstDecl RdrName) -> (HappyAbsSyn )
happyIn65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn65 #-}
happyOut65 :: (HappyAbsSyn ) -> (LInstDecl RdrName)
happyOut65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut65 #-}
happyIn66 :: (Located (AddAnn, NewOrData)) -> (HappyAbsSyn )
happyIn66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn66 #-}
happyOut66 :: (HappyAbsSyn ) -> (Located (AddAnn, NewOrData))
happyOut66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut66 #-}
happyIn67 :: (Located ([AddAnn], Maybe (LHsKind RdrName))) -> (HappyAbsSyn )
happyIn67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn67 #-}
happyOut67 :: (HappyAbsSyn ) -> (Located ([AddAnn], Maybe (LHsKind RdrName)))
happyOut67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut67 #-}
happyIn68 :: (Located ([AddAnn], LFamilyResultSig RdrName)) -> (HappyAbsSyn )
happyIn68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn68 #-}
happyOut68 :: (HappyAbsSyn ) -> (Located ([AddAnn], LFamilyResultSig RdrName))
happyOut68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut68 #-}
happyIn69 :: (Located ([AddAnn], LFamilyResultSig RdrName)) -> (HappyAbsSyn )
happyIn69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn69 #-}
happyOut69 :: (HappyAbsSyn ) -> (Located ([AddAnn], LFamilyResultSig RdrName))
happyOut69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut69 #-}
happyIn70 :: (Located ([AddAnn], ( LFamilyResultSig RdrName
                                            , Maybe (LInjectivityAnn RdrName)))) -> (HappyAbsSyn )
happyIn70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn70 #-}
happyOut70 :: (HappyAbsSyn ) -> (Located ([AddAnn], ( LFamilyResultSig RdrName
                                            , Maybe (LInjectivityAnn RdrName))))
happyOut70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut70 #-}
happyIn71 :: (Located (Maybe (LHsContext RdrName), LHsType RdrName)) -> (HappyAbsSyn )
happyIn71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn71 #-}
happyOut71 :: (HappyAbsSyn ) -> (Located (Maybe (LHsContext RdrName), LHsType RdrName))
happyOut71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut71 #-}
happyIn72 :: (Maybe (Located CType)) -> (HappyAbsSyn )
happyIn72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn72 #-}
happyOut72 :: (HappyAbsSyn ) -> (Maybe (Located CType))
happyOut72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut72 #-}
happyIn73 :: (LDerivDecl RdrName) -> (HappyAbsSyn )
happyIn73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn73 #-}
happyOut73 :: (HappyAbsSyn ) -> (LDerivDecl RdrName)
happyOut73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut73 #-}
happyIn74 :: (LRoleAnnotDecl RdrName) -> (HappyAbsSyn )
happyIn74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn74 #-}
happyOut74 :: (HappyAbsSyn ) -> (LRoleAnnotDecl RdrName)
happyOut74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut74 #-}
happyIn75 :: (Located [Located (Maybe FastString)]) -> (HappyAbsSyn )
happyIn75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn75 #-}
happyOut75 :: (HappyAbsSyn ) -> (Located [Located (Maybe FastString)])
happyOut75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut75 #-}
happyIn76 :: (Located [Located (Maybe FastString)]) -> (HappyAbsSyn )
happyIn76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn76 #-}
happyOut76 :: (HappyAbsSyn ) -> (Located [Located (Maybe FastString)])
happyOut76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut76 #-}
happyIn77 :: (Located (Maybe FastString)) -> (HappyAbsSyn )
happyIn77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn77 #-}
happyOut77 :: (HappyAbsSyn ) -> (Located (Maybe FastString))
happyOut77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut77 #-}
happyIn78 :: (LHsDecl RdrName) -> (HappyAbsSyn )
happyIn78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn78 #-}
happyOut78 :: (HappyAbsSyn ) -> (LHsDecl RdrName)
happyOut78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut78 #-}
happyIn79 :: ((Located RdrName, HsPatSynDetails (Located RdrName), [AddAnn])) -> (HappyAbsSyn )
happyIn79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn79 #-}
happyOut79 :: (HappyAbsSyn ) -> ((Located RdrName, HsPatSynDetails (Located RdrName), [AddAnn]))
happyOut79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut79 #-}
happyIn80 :: ([Located RdrName]) -> (HappyAbsSyn )
happyIn80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn80 #-}
happyOut80 :: (HappyAbsSyn ) -> ([Located RdrName])
happyOut80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut80 #-}
happyIn81 :: ([RecordPatSynField (Located RdrName)]) -> (HappyAbsSyn )
happyIn81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn81 #-}
happyOut81 :: (HappyAbsSyn ) -> ([RecordPatSynField (Located RdrName)])
happyOut81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut81 #-}
happyIn82 :: (Located ([AddAnn]
                         , Located (OrdList (LHsDecl RdrName)))) -> (HappyAbsSyn )
happyIn82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn82 #-}
happyOut82 :: (HappyAbsSyn ) -> (Located ([AddAnn]
                         , Located (OrdList (LHsDecl RdrName))))
happyOut82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut82 #-}
happyIn83 :: (LSig RdrName) -> (HappyAbsSyn )
happyIn83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn83 #-}
happyOut83 :: (HappyAbsSyn ) -> (LSig RdrName)
happyOut83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut83 #-}
happyIn84 :: (LHsDecl RdrName) -> (HappyAbsSyn )
happyIn84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn84 #-}
happyOut84 :: (HappyAbsSyn ) -> (LHsDecl RdrName)
happyOut84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut84 #-}
happyIn85 :: (Located ([AddAnn],OrdList (LHsDecl RdrName))) -> (HappyAbsSyn )
happyIn85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn85 #-}
happyOut85 :: (HappyAbsSyn ) -> (Located ([AddAnn],OrdList (LHsDecl RdrName)))
happyOut85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut85 #-}
happyIn86 :: (Located ([AddAnn]
                     , OrdList (LHsDecl RdrName))) -> (HappyAbsSyn )
happyIn86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn86 #-}
happyOut86 :: (HappyAbsSyn ) -> (Located ([AddAnn]
                     , OrdList (LHsDecl RdrName)))
happyOut86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut86 #-}
happyIn87 :: (Located ([AddAnn]
                       ,(OrdList (LHsDecl RdrName)))) -> (HappyAbsSyn )
happyIn87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn87 #-}
happyOut87 :: (HappyAbsSyn ) -> (Located ([AddAnn]
                       ,(OrdList (LHsDecl RdrName))))
happyOut87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut87 #-}
happyIn88 :: (Located (OrdList (LHsDecl RdrName))) -> (HappyAbsSyn )
happyIn88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn88 #-}
happyOut88 :: (HappyAbsSyn ) -> (Located (OrdList (LHsDecl RdrName)))
happyOut88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut88 #-}
happyIn89 :: (Located ([AddAnn],OrdList (LHsDecl RdrName))) -> (HappyAbsSyn )
happyIn89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn89 #-}
happyOut89 :: (HappyAbsSyn ) -> (Located ([AddAnn],OrdList (LHsDecl RdrName)))
happyOut89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut89 #-}
happyIn90 :: (Located ([AddAnn]
                     , OrdList (LHsDecl RdrName))) -> (HappyAbsSyn )
happyIn90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn90 #-}
happyOut90 :: (HappyAbsSyn ) -> (Located ([AddAnn]
                     , OrdList (LHsDecl RdrName)))
happyOut90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut90 #-}
happyIn91 :: (Located ([AddAnn]
                        , OrdList (LHsDecl RdrName))) -> (HappyAbsSyn )
happyIn91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn91 #-}
happyOut91 :: (HappyAbsSyn ) -> (Located ([AddAnn]
                        , OrdList (LHsDecl RdrName)))
happyOut91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut91 #-}
happyIn92 :: (Located ([AddAnn],OrdList (LHsDecl RdrName))) -> (HappyAbsSyn )
happyIn92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn92 #-}
happyOut92 :: (HappyAbsSyn ) -> (Located ([AddAnn],OrdList (LHsDecl RdrName)))
happyOut92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut92 #-}
happyIn93 :: (Located ([AddAnn],Located (OrdList (LHsDecl RdrName)))) -> (HappyAbsSyn )
happyIn93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn93 #-}
happyOut93 :: (HappyAbsSyn ) -> (Located ([AddAnn],Located (OrdList (LHsDecl RdrName))))
happyOut93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut93 #-}
happyIn94 :: (Located ([AddAnn],Located (HsLocalBinds RdrName))) -> (HappyAbsSyn )
happyIn94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn94 #-}
happyOut94 :: (HappyAbsSyn ) -> (Located ([AddAnn],Located (HsLocalBinds RdrName)))
happyOut94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut94 #-}
happyIn95 :: (Located ([AddAnn],Located (HsLocalBinds RdrName))) -> (HappyAbsSyn )
happyIn95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn95 #-}
happyOut95 :: (HappyAbsSyn ) -> (Located ([AddAnn],Located (HsLocalBinds RdrName)))
happyOut95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut95 #-}
happyIn96 :: (OrdList (LRuleDecl RdrName)) -> (HappyAbsSyn )
happyIn96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn96 #-}
happyOut96 :: (HappyAbsSyn ) -> (OrdList (LRuleDecl RdrName))
happyOut96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut96 #-}
happyIn97 :: (LRuleDecl RdrName) -> (HappyAbsSyn )
happyIn97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn97 #-}
happyOut97 :: (HappyAbsSyn ) -> (LRuleDecl RdrName)
happyOut97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut97 #-}
happyIn98 :: (([AddAnn],Maybe Activation)) -> (HappyAbsSyn )
happyIn98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn98 #-}
happyOut98 :: (HappyAbsSyn ) -> (([AddAnn],Maybe Activation))
happyOut98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut98 #-}
happyIn99 :: (([AddAnn]
                              ,Activation)) -> (HappyAbsSyn )
happyIn99 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn99 #-}
happyOut99 :: (HappyAbsSyn ) -> (([AddAnn]
                              ,Activation))
happyOut99 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut99 #-}
happyIn100 :: (([AddAnn],[LRuleBndr RdrName])) -> (HappyAbsSyn )
happyIn100 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn100 #-}
happyOut100 :: (HappyAbsSyn ) -> (([AddAnn],[LRuleBndr RdrName]))
happyOut100 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut100 #-}
happyIn101 :: ([LRuleBndr RdrName]) -> (HappyAbsSyn )
happyIn101 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn101 #-}
happyOut101 :: (HappyAbsSyn ) -> ([LRuleBndr RdrName])
happyOut101 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut101 #-}
happyIn102 :: (LRuleBndr RdrName) -> (HappyAbsSyn )
happyIn102 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn102 #-}
happyOut102 :: (HappyAbsSyn ) -> (LRuleBndr RdrName)
happyOut102 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut102 #-}
happyIn103 :: (OrdList (LWarnDecl RdrName)) -> (HappyAbsSyn )
happyIn103 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn103 #-}
happyOut103 :: (HappyAbsSyn ) -> (OrdList (LWarnDecl RdrName))
happyOut103 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut103 #-}
happyIn104 :: (OrdList (LWarnDecl RdrName)) -> (HappyAbsSyn )
happyIn104 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn104 #-}
happyOut104 :: (HappyAbsSyn ) -> (OrdList (LWarnDecl RdrName))
happyOut104 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut104 #-}
happyIn105 :: (OrdList (LWarnDecl RdrName)) -> (HappyAbsSyn )
happyIn105 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn105 #-}
happyOut105 :: (HappyAbsSyn ) -> (OrdList (LWarnDecl RdrName))
happyOut105 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut105 #-}
happyIn106 :: (OrdList (LWarnDecl RdrName)) -> (HappyAbsSyn )
happyIn106 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn106 #-}
happyOut106 :: (HappyAbsSyn ) -> (OrdList (LWarnDecl RdrName))
happyOut106 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut106 #-}
happyIn107 :: (Located ([AddAnn],[Located StringLiteral])) -> (HappyAbsSyn )
happyIn107 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn107 #-}
happyOut107 :: (HappyAbsSyn ) -> (Located ([AddAnn],[Located StringLiteral]))
happyOut107 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut107 #-}
happyIn108 :: (Located (OrdList (Located StringLiteral))) -> (HappyAbsSyn )
happyIn108 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn108 #-}
happyOut108 :: (HappyAbsSyn ) -> (Located (OrdList (Located StringLiteral)))
happyOut108 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut108 #-}
happyIn109 :: (LHsDecl RdrName) -> (HappyAbsSyn )
happyIn109 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn109 #-}
happyOut109 :: (HappyAbsSyn ) -> (LHsDecl RdrName)
happyOut109 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut109 #-}
happyIn110 :: (Located ([AddAnn],HsDecl RdrName)) -> (HappyAbsSyn )
happyIn110 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn110 #-}
happyOut110 :: (HappyAbsSyn ) -> (Located ([AddAnn],HsDecl RdrName))
happyOut110 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut110 #-}
happyIn111 :: (Located CCallConv) -> (HappyAbsSyn )
happyIn111 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn111 #-}
happyOut111 :: (HappyAbsSyn ) -> (Located CCallConv)
happyOut111 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut111 #-}
happyIn112 :: (Located Safety) -> (HappyAbsSyn )
happyIn112 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn112 #-}
happyOut112 :: (HappyAbsSyn ) -> (Located Safety)
happyOut112 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut112 #-}
happyIn113 :: (Located ([AddAnn]
                    ,(Located StringLiteral, Located RdrName, LHsSigType RdrName))) -> (HappyAbsSyn )
happyIn113 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn113 #-}
happyOut113 :: (HappyAbsSyn ) -> (Located ([AddAnn]
                    ,(Located StringLiteral, Located RdrName, LHsSigType RdrName)))
happyOut113 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut113 #-}
happyIn114 :: (([AddAnn], Maybe (LHsType RdrName))) -> (HappyAbsSyn )
happyIn114 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn114 #-}
happyOut114 :: (HappyAbsSyn ) -> (([AddAnn], Maybe (LHsType RdrName)))
happyOut114 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut114 #-}
happyIn115 :: (([AddAnn],Maybe (LHsType RdrName))) -> (HappyAbsSyn )
happyIn115 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn115 #-}
happyOut115 :: (HappyAbsSyn ) -> (([AddAnn],Maybe (LHsType RdrName)))
happyOut115 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut115 #-}
happyIn116 :: (LHsType RdrName) -> (HappyAbsSyn )
happyIn116 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn116 #-}
happyOut116 :: (HappyAbsSyn ) -> (LHsType RdrName)
happyOut116 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut116 #-}
happyIn117 :: (LHsType RdrName) -> (HappyAbsSyn )
happyIn117 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn117 #-}
happyOut117 :: (HappyAbsSyn ) -> (LHsType RdrName)
happyOut117 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut117 #-}
happyIn118 :: (Located [Located RdrName]) -> (HappyAbsSyn )
happyIn118 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn118 #-}
happyOut118 :: (HappyAbsSyn ) -> (Located [Located RdrName])
happyOut118 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut118 #-}
happyIn119 :: ((OrdList (LHsSigType RdrName))) -> (HappyAbsSyn )
happyIn119 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn119 #-}
happyOut119 :: (HappyAbsSyn ) -> ((OrdList (LHsSigType RdrName)))
happyOut119 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut119 #-}
happyIn120 :: (Located ([AddAnn],HsSrcBang)) -> (HappyAbsSyn )
happyIn120 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn120 #-}
happyOut120 :: (HappyAbsSyn ) -> (Located ([AddAnn],HsSrcBang))
happyOut120 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut120 #-}
happyIn121 :: (Located ([AddAnn], SrcStrictness)) -> (HappyAbsSyn )
happyIn121 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn121 #-}
happyOut121 :: (HappyAbsSyn ) -> (Located ([AddAnn], SrcStrictness))
happyOut121 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut121 #-}
happyIn122 :: (Located ([AddAnn], Maybe SourceText, SrcUnpackedness)) -> (HappyAbsSyn )
happyIn122 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn122 #-}
happyOut122 :: (HappyAbsSyn ) -> (Located ([AddAnn], Maybe SourceText, SrcUnpackedness))
happyOut122 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut122 #-}
happyIn123 :: (LHsType RdrName) -> (HappyAbsSyn )
happyIn123 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn123 #-}
happyOut123 :: (HappyAbsSyn ) -> (LHsType RdrName)
happyOut123 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut123 #-}
happyIn124 :: (LHsType RdrName) -> (HappyAbsSyn )
happyIn124 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn124 #-}
happyOut124 :: (HappyAbsSyn ) -> (LHsType RdrName)
happyOut124 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut124 #-}
happyIn125 :: (LHsContext RdrName) -> (HappyAbsSyn )
happyIn125 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn125 #-}
happyOut125 :: (HappyAbsSyn ) -> (LHsContext RdrName)
happyOut125 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut125 #-}
happyIn126 :: (LHsContext RdrName) -> (HappyAbsSyn )
happyIn126 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn126 #-}
happyOut126 :: (HappyAbsSyn ) -> (LHsContext RdrName)
happyOut126 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut126 #-}
happyIn127 :: (LHsType RdrName) -> (HappyAbsSyn )
happyIn127 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn127 #-}
happyOut127 :: (HappyAbsSyn ) -> (LHsType RdrName)
happyOut127 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut127 #-}
happyIn128 :: (LHsType RdrName) -> (HappyAbsSyn )
happyIn128 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn128 #-}
happyOut128 :: (HappyAbsSyn ) -> (LHsType RdrName)
happyOut128 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut128 #-}
happyIn129 :: (LHsType RdrName) -> (HappyAbsSyn )
happyIn129 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn129 #-}
happyOut129 :: (HappyAbsSyn ) -> (LHsType RdrName)
happyOut129 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut129 #-}
happyIn130 :: (LHsType RdrName) -> (HappyAbsSyn )
happyIn130 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn130 #-}
happyOut130 :: (HappyAbsSyn ) -> (LHsType RdrName)
happyOut130 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut130 #-}
happyIn131 :: (Located [LHsAppType RdrName]) -> (HappyAbsSyn )
happyIn131 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn131 #-}
happyOut131 :: (HappyAbsSyn ) -> (Located [LHsAppType RdrName])
happyOut131 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut131 #-}
happyIn132 :: (LHsAppType RdrName) -> (HappyAbsSyn )
happyIn132 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn132 #-}
happyOut132 :: (HappyAbsSyn ) -> (LHsAppType RdrName)
happyOut132 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut132 #-}
happyIn133 :: (LHsType RdrName) -> (HappyAbsSyn )
happyIn133 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn133 #-}
happyOut133 :: (HappyAbsSyn ) -> (LHsType RdrName)
happyOut133 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut133 #-}
happyIn134 :: (LHsSigType RdrName) -> (HappyAbsSyn )
happyIn134 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn134 #-}
happyOut134 :: (HappyAbsSyn ) -> (LHsSigType RdrName)
happyOut134 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut134 #-}
happyIn135 :: ([LHsSigType RdrName]) -> (HappyAbsSyn )
happyIn135 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn135 #-}
happyOut135 :: (HappyAbsSyn ) -> ([LHsSigType RdrName])
happyOut135 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut135 #-}
happyIn136 :: ([LHsType RdrName]) -> (HappyAbsSyn )
happyIn136 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn136 #-}
happyOut136 :: (HappyAbsSyn ) -> ([LHsType RdrName])
happyOut136 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut136 #-}
happyIn137 :: ([LHsType RdrName]) -> (HappyAbsSyn )
happyIn137 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn137 #-}
happyOut137 :: (HappyAbsSyn ) -> ([LHsType RdrName])
happyOut137 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut137 #-}
happyIn138 :: ([LHsTyVarBndr RdrName]) -> (HappyAbsSyn )
happyIn138 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn138 #-}
happyOut138 :: (HappyAbsSyn ) -> ([LHsTyVarBndr RdrName])
happyOut138 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut138 #-}
happyIn139 :: (LHsTyVarBndr RdrName) -> (HappyAbsSyn )
happyIn139 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn139 #-}
happyOut139 :: (HappyAbsSyn ) -> (LHsTyVarBndr RdrName)
happyOut139 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut139 #-}
happyIn140 :: (Located ([AddAnn],[Located (FunDep (Located RdrName))])) -> (HappyAbsSyn )
happyIn140 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn140 #-}
happyOut140 :: (HappyAbsSyn ) -> (Located ([AddAnn],[Located (FunDep (Located RdrName))]))
happyOut140 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut140 #-}
happyIn141 :: (Located [Located (FunDep (Located RdrName))]) -> (HappyAbsSyn )
happyIn141 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn141 #-}
happyOut141 :: (HappyAbsSyn ) -> (Located [Located (FunDep (Located RdrName))])
happyOut141 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut141 #-}
happyIn142 :: (Located (FunDep (Located RdrName))) -> (HappyAbsSyn )
happyIn142 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn142 #-}
happyOut142 :: (HappyAbsSyn ) -> (Located (FunDep (Located RdrName)))
happyOut142 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut142 #-}
happyIn143 :: (Located [Located RdrName]) -> (HappyAbsSyn )
happyIn143 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn143 #-}
happyOut143 :: (HappyAbsSyn ) -> (Located [Located RdrName])
happyOut143 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut143 #-}
happyIn144 :: (LHsKind RdrName) -> (HappyAbsSyn )
happyIn144 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn144 #-}
happyOut144 :: (HappyAbsSyn ) -> (LHsKind RdrName)
happyOut144 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut144 #-}
happyIn145 :: (Located ([AddAnn]
                          ,[LConDecl RdrName])) -> (HappyAbsSyn )
happyIn145 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn145 #-}
happyOut145 :: (HappyAbsSyn ) -> (Located ([AddAnn]
                          ,[LConDecl RdrName]))
happyOut145 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut145 #-}
happyIn146 :: (Located [LConDecl RdrName]) -> (HappyAbsSyn )
happyIn146 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn146 #-}
happyOut146 :: (HappyAbsSyn ) -> (Located [LConDecl RdrName])
happyOut146 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut146 #-}
happyIn147 :: (LConDecl RdrName) -> (HappyAbsSyn )
happyIn147 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn147 #-}
happyOut147 :: (HappyAbsSyn ) -> (LConDecl RdrName)
happyOut147 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut147 #-}
happyIn148 :: (LConDecl RdrName) -> (HappyAbsSyn )
happyIn148 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn148 #-}
happyOut148 :: (HappyAbsSyn ) -> (LConDecl RdrName)
happyOut148 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut148 #-}
happyIn149 :: (Located ([AddAnn],[LConDecl RdrName])) -> (HappyAbsSyn )
happyIn149 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn149 #-}
happyOut149 :: (HappyAbsSyn ) -> (Located ([AddAnn],[LConDecl RdrName]))
happyOut149 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut149 #-}
happyIn150 :: (Located [LConDecl RdrName]) -> (HappyAbsSyn )
happyIn150 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn150 #-}
happyOut150 :: (HappyAbsSyn ) -> (Located [LConDecl RdrName])
happyOut150 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut150 #-}
happyIn151 :: (LConDecl RdrName) -> (HappyAbsSyn )
happyIn151 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn151 #-}
happyOut151 :: (HappyAbsSyn ) -> (LConDecl RdrName)
happyOut151 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut151 #-}
happyIn152 :: (Located ([AddAnn], Maybe [LHsTyVarBndr RdrName])) -> (HappyAbsSyn )
happyIn152 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn152 #-}
happyOut152 :: (HappyAbsSyn ) -> (Located ([AddAnn], Maybe [LHsTyVarBndr RdrName]))
happyOut152 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut152 #-}
happyIn153 :: (Located (Located RdrName, HsConDeclDetails RdrName)) -> (HappyAbsSyn )
happyIn153 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn153 #-}
happyOut153 :: (HappyAbsSyn ) -> (Located (Located RdrName, HsConDeclDetails RdrName))
happyOut153 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut153 #-}
happyIn154 :: ([LConDeclField RdrName]) -> (HappyAbsSyn )
happyIn154 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn154 #-}
happyOut154 :: (HappyAbsSyn ) -> ([LConDeclField RdrName])
happyOut154 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut154 #-}
happyIn155 :: ([LConDeclField RdrName]) -> (HappyAbsSyn )
happyIn155 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn155 #-}
happyOut155 :: (HappyAbsSyn ) -> ([LConDeclField RdrName])
happyOut155 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut155 #-}
happyIn156 :: (LConDeclField RdrName) -> (HappyAbsSyn )
happyIn156 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn156 #-}
happyOut156 :: (HappyAbsSyn ) -> (LConDeclField RdrName)
happyOut156 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut156 #-}
happyIn157 :: (Located (HsDeriving RdrName)) -> (HappyAbsSyn )
happyIn157 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn157 #-}
happyOut157 :: (HappyAbsSyn ) -> (Located (HsDeriving RdrName))
happyOut157 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut157 #-}
happyIn158 :: (LHsDecl RdrName) -> (HappyAbsSyn )
happyIn158 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn158 #-}
happyOut158 :: (HappyAbsSyn ) -> (LHsDecl RdrName)
happyOut158 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut158 #-}
happyIn159 :: (LDocDecl) -> (HappyAbsSyn )
happyIn159 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn159 #-}
happyOut159 :: (HappyAbsSyn ) -> (LDocDecl)
happyOut159 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut159 #-}
happyIn160 :: (LHsDecl RdrName) -> (HappyAbsSyn )
happyIn160 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn160 #-}
happyOut160 :: (HappyAbsSyn ) -> (LHsDecl RdrName)
happyOut160 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut160 #-}
happyIn161 :: (LHsDecl RdrName) -> (HappyAbsSyn )
happyIn161 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn161 #-}
happyOut161 :: (HappyAbsSyn ) -> (LHsDecl RdrName)
happyOut161 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut161 #-}
happyIn162 :: (Located ([AddAnn],GRHSs RdrName (LHsExpr RdrName))) -> (HappyAbsSyn )
happyIn162 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn162 #-}
happyOut162 :: (HappyAbsSyn ) -> (Located ([AddAnn],GRHSs RdrName (LHsExpr RdrName)))
happyOut162 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut162 #-}
happyIn163 :: (Located [LGRHS RdrName (LHsExpr RdrName)]) -> (HappyAbsSyn )
happyIn163 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn163 #-}
happyOut163 :: (HappyAbsSyn ) -> (Located [LGRHS RdrName (LHsExpr RdrName)])
happyOut163 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut163 #-}
happyIn164 :: (LGRHS RdrName (LHsExpr RdrName)) -> (HappyAbsSyn )
happyIn164 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn164 #-}
happyOut164 :: (HappyAbsSyn ) -> (LGRHS RdrName (LHsExpr RdrName))
happyOut164 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut164 #-}
happyIn165 :: (LHsDecl RdrName) -> (HappyAbsSyn )
happyIn165 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn165 #-}
happyOut165 :: (HappyAbsSyn ) -> (LHsDecl RdrName)
happyOut165 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut165 #-}
happyIn166 :: (([AddAnn],Maybe Activation)) -> (HappyAbsSyn )
happyIn166 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn166 #-}
happyOut166 :: (HappyAbsSyn ) -> (([AddAnn],Maybe Activation))
happyOut166 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut166 #-}
happyIn167 :: (([AddAnn],Activation)) -> (HappyAbsSyn )
happyIn167 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn167 #-}
happyOut167 :: (HappyAbsSyn ) -> (([AddAnn],Activation))
happyOut167 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut167 #-}
happyIn168 :: (Located (HsSplice RdrName)) -> (HappyAbsSyn )
happyIn168 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn168 #-}
happyOut168 :: (HappyAbsSyn ) -> (Located (HsSplice RdrName))
happyOut168 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut168 #-}
happyIn169 :: (LHsExpr RdrName) -> (HappyAbsSyn )
happyIn169 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn169 #-}
happyOut169 :: (HappyAbsSyn ) -> (LHsExpr RdrName)
happyOut169 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut169 #-}
happyIn170 :: (LHsExpr RdrName) -> (HappyAbsSyn )
happyIn170 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn170 #-}
happyOut170 :: (HappyAbsSyn ) -> (LHsExpr RdrName)
happyOut170 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut170 #-}
happyIn171 :: (LHsExpr RdrName) -> (HappyAbsSyn )
happyIn171 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn171 #-}
happyOut171 :: (HappyAbsSyn ) -> (LHsExpr RdrName)
happyOut171 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut171 #-}
happyIn172 :: (([Located a],Bool)) -> (HappyAbsSyn )
happyIn172 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn172 #-}
happyOut172 :: (HappyAbsSyn ) -> (([Located a],Bool))
happyOut172 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut172 #-}
happyIn173 :: (Located (([AddAnn],SourceText),StringLiteral)) -> (HappyAbsSyn )
happyIn173 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn173 #-}
happyOut173 :: (HappyAbsSyn ) -> (Located (([AddAnn],SourceText),StringLiteral))
happyOut173 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut173 #-}
happyIn174 :: (Located ( (([AddAnn],SourceText),(StringLiteral,(Int,Int),(Int,Int))),
                         ((SourceText,SourceText),(SourceText,SourceText))
                       )) -> (HappyAbsSyn )
happyIn174 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn174 #-}
happyOut174 :: (HappyAbsSyn ) -> (Located ( (([AddAnn],SourceText),(StringLiteral,(Int,Int),(Int,Int))),
                         ((SourceText,SourceText),(SourceText,SourceText))
                       ))
happyOut174 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut174 #-}
happyIn175 :: (LHsExpr RdrName) -> (HappyAbsSyn )
happyIn175 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn175 #-}
happyOut175 :: (HappyAbsSyn ) -> (LHsExpr RdrName)
happyOut175 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut175 #-}
happyIn176 :: (LHsExpr RdrName) -> (HappyAbsSyn )
happyIn176 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn176 #-}
happyOut176 :: (HappyAbsSyn ) -> (LHsExpr RdrName)
happyOut176 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut176 #-}
happyIn177 :: (LHsExpr RdrName) -> (HappyAbsSyn )
happyIn177 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn177 #-}
happyOut177 :: (HappyAbsSyn ) -> (LHsExpr RdrName)
happyOut177 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut177 #-}
happyIn178 :: (LHsExpr RdrName) -> (HappyAbsSyn )
happyIn178 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn178 #-}
happyOut178 :: (HappyAbsSyn ) -> (LHsExpr RdrName)
happyOut178 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut178 #-}
happyIn179 :: (LHsExpr RdrName) -> (HappyAbsSyn )
happyIn179 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn179 #-}
happyOut179 :: (HappyAbsSyn ) -> (LHsExpr RdrName)
happyOut179 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut179 #-}
happyIn180 :: ([LHsCmdTop RdrName]) -> (HappyAbsSyn )
happyIn180 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn180 #-}
happyOut180 :: (HappyAbsSyn ) -> ([LHsCmdTop RdrName])
happyOut180 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut180 #-}
happyIn181 :: (LHsCmdTop RdrName) -> (HappyAbsSyn )
happyIn181 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn181 #-}
happyOut181 :: (HappyAbsSyn ) -> (LHsCmdTop RdrName)
happyOut181 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut181 #-}
happyIn182 :: (([AddAnn],[LHsDecl RdrName])) -> (HappyAbsSyn )
happyIn182 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn182 #-}
happyOut182 :: (HappyAbsSyn ) -> (([AddAnn],[LHsDecl RdrName]))
happyOut182 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut182 #-}
happyIn183 :: ([LHsDecl RdrName]) -> (HappyAbsSyn )
happyIn183 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn183 #-}
happyOut183 :: (HappyAbsSyn ) -> ([LHsDecl RdrName])
happyOut183 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut183 #-}
happyIn184 :: (LHsExpr RdrName) -> (HappyAbsSyn )
happyIn184 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn184 #-}
happyOut184 :: (HappyAbsSyn ) -> (LHsExpr RdrName)
happyOut184 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut184 #-}
happyIn185 :: ([LHsTupArg RdrName]) -> (HappyAbsSyn )
happyIn185 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn185 #-}
happyOut185 :: (HappyAbsSyn ) -> ([LHsTupArg RdrName])
happyOut185 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut185 #-}
happyIn186 :: ((SrcSpan,[LHsTupArg RdrName])) -> (HappyAbsSyn )
happyIn186 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn186 #-}
happyOut186 :: (HappyAbsSyn ) -> ((SrcSpan,[LHsTupArg RdrName]))
happyOut186 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut186 #-}
happyIn187 :: ([LHsTupArg RdrName]) -> (HappyAbsSyn )
happyIn187 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn187 #-}
happyOut187 :: (HappyAbsSyn ) -> ([LHsTupArg RdrName])
happyOut187 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut187 #-}
happyIn188 :: (([AddAnn],HsExpr RdrName)) -> (HappyAbsSyn )
happyIn188 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn188 #-}
happyOut188 :: (HappyAbsSyn ) -> (([AddAnn],HsExpr RdrName))
happyOut188 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut188 #-}
happyIn189 :: (Located [LHsExpr RdrName]) -> (HappyAbsSyn )
happyIn189 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn189 #-}
happyOut189 :: (HappyAbsSyn ) -> (Located [LHsExpr RdrName])
happyOut189 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut189 #-}
happyIn190 :: (Located [LStmt RdrName (LHsExpr RdrName)]) -> (HappyAbsSyn )
happyIn190 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn190 #-}
happyOut190 :: (HappyAbsSyn ) -> (Located [LStmt RdrName (LHsExpr RdrName)])
happyOut190 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut190 #-}
happyIn191 :: (Located [[LStmt RdrName (LHsExpr RdrName)]]) -> (HappyAbsSyn )
happyIn191 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn191 #-}
happyOut191 :: (HappyAbsSyn ) -> (Located [[LStmt RdrName (LHsExpr RdrName)]])
happyOut191 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut191 #-}
happyIn192 :: (Located [LStmt RdrName (LHsExpr RdrName)]) -> (HappyAbsSyn )
happyIn192 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn192 #-}
happyOut192 :: (HappyAbsSyn ) -> (Located [LStmt RdrName (LHsExpr RdrName)])
happyOut192 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut192 #-}
happyIn193 :: (Located ([AddAnn],[LStmt RdrName (LHsExpr RdrName)] -> Stmt RdrName (LHsExpr RdrName))) -> (HappyAbsSyn )
happyIn193 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn193 #-}
happyOut193 :: (HappyAbsSyn ) -> (Located ([AddAnn],[LStmt RdrName (LHsExpr RdrName)] -> Stmt RdrName (LHsExpr RdrName)))
happyOut193 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut193 #-}
happyIn194 :: (([AddAnn],HsExpr RdrName)) -> (HappyAbsSyn )
happyIn194 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn194 #-}
happyOut194 :: (HappyAbsSyn ) -> (([AddAnn],HsExpr RdrName))
happyOut194 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut194 #-}
happyIn195 :: (Located [LStmt RdrName (LHsExpr RdrName)]) -> (HappyAbsSyn )
happyIn195 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn195 #-}
happyOut195 :: (HappyAbsSyn ) -> (Located [LStmt RdrName (LHsExpr RdrName)])
happyOut195 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut195 #-}
happyIn196 :: (Located [LStmt RdrName (LHsExpr RdrName)]) -> (HappyAbsSyn )
happyIn196 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn196 #-}
happyOut196 :: (HappyAbsSyn ) -> (Located [LStmt RdrName (LHsExpr RdrName)])
happyOut196 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut196 #-}
happyIn197 :: (Located ([AddAnn],[LMatch RdrName (LHsExpr RdrName)])) -> (HappyAbsSyn )
happyIn197 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn197 #-}
happyOut197 :: (HappyAbsSyn ) -> (Located ([AddAnn],[LMatch RdrName (LHsExpr RdrName)]))
happyOut197 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut197 #-}
happyIn198 :: (Located ([AddAnn],[LMatch RdrName (LHsExpr RdrName)])) -> (HappyAbsSyn )
happyIn198 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn198 #-}
happyOut198 :: (HappyAbsSyn ) -> (Located ([AddAnn],[LMatch RdrName (LHsExpr RdrName)]))
happyOut198 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut198 #-}
happyIn199 :: (Located ([AddAnn],[LMatch RdrName (LHsExpr RdrName)])) -> (HappyAbsSyn )
happyIn199 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn199 #-}
happyOut199 :: (HappyAbsSyn ) -> (Located ([AddAnn],[LMatch RdrName (LHsExpr RdrName)]))
happyOut199 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut199 #-}
happyIn200 :: (LMatch RdrName (LHsExpr RdrName)) -> (HappyAbsSyn )
happyIn200 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn200 #-}
happyOut200 :: (HappyAbsSyn ) -> (LMatch RdrName (LHsExpr RdrName))
happyOut200 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut200 #-}
happyIn201 :: (Located ([AddAnn],GRHSs RdrName (LHsExpr RdrName))) -> (HappyAbsSyn )
happyIn201 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn201 #-}
happyOut201 :: (HappyAbsSyn ) -> (Located ([AddAnn],GRHSs RdrName (LHsExpr RdrName)))
happyOut201 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut201 #-}
happyIn202 :: (Located [LGRHS RdrName (LHsExpr RdrName)]) -> (HappyAbsSyn )
happyIn202 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn202 #-}
happyOut202 :: (HappyAbsSyn ) -> (Located [LGRHS RdrName (LHsExpr RdrName)])
happyOut202 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut202 #-}
happyIn203 :: (Located [LGRHS RdrName (LHsExpr RdrName)]) -> (HappyAbsSyn )
happyIn203 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn203 #-}
happyOut203 :: (HappyAbsSyn ) -> (Located [LGRHS RdrName (LHsExpr RdrName)])
happyOut203 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut203 #-}
happyIn204 :: (Located [LGRHS RdrName (LHsExpr RdrName)]) -> (HappyAbsSyn )
happyIn204 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn204 #-}
happyOut204 :: (HappyAbsSyn ) -> (Located [LGRHS RdrName (LHsExpr RdrName)])
happyOut204 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut204 #-}
happyIn205 :: (Located ([AddAnn],[LGRHS RdrName (LHsExpr RdrName)])) -> (HappyAbsSyn )
happyIn205 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn205 #-}
happyOut205 :: (HappyAbsSyn ) -> (Located ([AddAnn],[LGRHS RdrName (LHsExpr RdrName)]))
happyOut205 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut205 #-}
happyIn206 :: (LGRHS RdrName (LHsExpr RdrName)) -> (HappyAbsSyn )
happyIn206 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn206 #-}
happyOut206 :: (HappyAbsSyn ) -> (LGRHS RdrName (LHsExpr RdrName))
happyOut206 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut206 #-}
happyIn207 :: (LPat RdrName) -> (HappyAbsSyn )
happyIn207 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn207 #-}
happyOut207 :: (HappyAbsSyn ) -> (LPat RdrName)
happyOut207 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut207 #-}
happyIn208 :: (LPat RdrName) -> (HappyAbsSyn )
happyIn208 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn208 #-}
happyOut208 :: (HappyAbsSyn ) -> (LPat RdrName)
happyOut208 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut208 #-}
happyIn209 :: (LPat RdrName) -> (HappyAbsSyn )
happyIn209 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn209 #-}
happyOut209 :: (HappyAbsSyn ) -> (LPat RdrName)
happyOut209 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut209 #-}
happyIn210 :: ([LPat RdrName]) -> (HappyAbsSyn )
happyIn210 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn210 #-}
happyOut210 :: (HappyAbsSyn ) -> ([LPat RdrName])
happyOut210 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut210 #-}
happyIn211 :: (Located ([AddAnn],[LStmt RdrName (LHsExpr RdrName)])) -> (HappyAbsSyn )
happyIn211 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn211 #-}
happyOut211 :: (HappyAbsSyn ) -> (Located ([AddAnn],[LStmt RdrName (LHsExpr RdrName)]))
happyOut211 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut211 #-}
happyIn212 :: (Located ([AddAnn],[LStmt RdrName (LHsExpr RdrName)])) -> (HappyAbsSyn )
happyIn212 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn212 #-}
happyOut212 :: (HappyAbsSyn ) -> (Located ([AddAnn],[LStmt RdrName (LHsExpr RdrName)]))
happyOut212 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut212 #-}
happyIn213 :: (Maybe (LStmt RdrName (LHsExpr RdrName))) -> (HappyAbsSyn )
happyIn213 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn213 #-}
happyOut213 :: (HappyAbsSyn ) -> (Maybe (LStmt RdrName (LHsExpr RdrName)))
happyOut213 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut213 #-}
happyIn214 :: (LStmt RdrName (LHsExpr RdrName)) -> (HappyAbsSyn )
happyIn214 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn214 #-}
happyOut214 :: (HappyAbsSyn ) -> (LStmt RdrName (LHsExpr RdrName))
happyOut214 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut214 #-}
happyIn215 :: (LStmt RdrName (LHsExpr RdrName)) -> (HappyAbsSyn )
happyIn215 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn215 #-}
happyOut215 :: (HappyAbsSyn ) -> (LStmt RdrName (LHsExpr RdrName))
happyOut215 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut215 #-}
happyIn216 :: (([AddAnn],([LHsRecField RdrName (LHsExpr RdrName)], Bool))) -> (HappyAbsSyn )
happyIn216 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn216 #-}
happyOut216 :: (HappyAbsSyn ) -> (([AddAnn],([LHsRecField RdrName (LHsExpr RdrName)], Bool)))
happyOut216 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut216 #-}
happyIn217 :: (([AddAnn],([LHsRecField RdrName (LHsExpr RdrName)], Bool))) -> (HappyAbsSyn )
happyIn217 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn217 #-}
happyOut217 :: (HappyAbsSyn ) -> (([AddAnn],([LHsRecField RdrName (LHsExpr RdrName)], Bool)))
happyOut217 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut217 #-}
happyIn218 :: (LHsRecField RdrName (LHsExpr RdrName)) -> (HappyAbsSyn )
happyIn218 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn218 #-}
happyOut218 :: (HappyAbsSyn ) -> (LHsRecField RdrName (LHsExpr RdrName))
happyOut218 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut218 #-}
happyIn219 :: (Located [LIPBind RdrName]) -> (HappyAbsSyn )
happyIn219 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn219 #-}
happyOut219 :: (HappyAbsSyn ) -> (Located [LIPBind RdrName])
happyOut219 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut219 #-}
happyIn220 :: (LIPBind RdrName) -> (HappyAbsSyn )
happyIn220 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn220 #-}
happyOut220 :: (HappyAbsSyn ) -> (LIPBind RdrName)
happyOut220 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut220 #-}
happyIn221 :: (Located HsIPName) -> (HappyAbsSyn )
happyIn221 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn221 #-}
happyOut221 :: (HappyAbsSyn ) -> (Located HsIPName)
happyOut221 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut221 #-}
happyIn222 :: (Located FastString) -> (HappyAbsSyn )
happyIn222 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn222 #-}
happyOut222 :: (HappyAbsSyn ) -> (Located FastString)
happyOut222 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut222 #-}
happyIn223 :: (LBooleanFormula (Located RdrName)) -> (HappyAbsSyn )
happyIn223 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn223 #-}
happyOut223 :: (HappyAbsSyn ) -> (LBooleanFormula (Located RdrName))
happyOut223 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut223 #-}
happyIn224 :: (LBooleanFormula (Located RdrName)) -> (HappyAbsSyn )
happyIn224 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn224 #-}
happyOut224 :: (HappyAbsSyn ) -> (LBooleanFormula (Located RdrName))
happyOut224 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut224 #-}
happyIn225 :: (LBooleanFormula (Located RdrName)) -> (HappyAbsSyn )
happyIn225 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn225 #-}
happyOut225 :: (HappyAbsSyn ) -> (LBooleanFormula (Located RdrName))
happyOut225 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut225 #-}
happyIn226 :: (LBooleanFormula (Located RdrName)) -> (HappyAbsSyn )
happyIn226 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn226 #-}
happyOut226 :: (HappyAbsSyn ) -> (LBooleanFormula (Located RdrName))
happyOut226 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut226 #-}
happyIn227 :: (Located [Located RdrName]) -> (HappyAbsSyn )
happyIn227 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn227 #-}
happyOut227 :: (HappyAbsSyn ) -> (Located [Located RdrName])
happyOut227 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut227 #-}
happyIn228 :: (Located RdrName) -> (HappyAbsSyn )
happyIn228 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn228 #-}
happyOut228 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut228 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut228 #-}
happyIn229 :: (Located RdrName) -> (HappyAbsSyn )
happyIn229 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn229 #-}
happyOut229 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut229 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut229 #-}
happyIn230 :: (Located RdrName) -> (HappyAbsSyn )
happyIn230 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn230 #-}
happyOut230 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut230 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut230 #-}
happyIn231 :: (Located RdrName) -> (HappyAbsSyn )
happyIn231 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn231 #-}
happyOut231 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut231 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut231 #-}
happyIn232 :: (Located RdrName) -> (HappyAbsSyn )
happyIn232 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn232 #-}
happyOut232 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut232 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut232 #-}
happyIn233 :: (Located [Located RdrName]) -> (HappyAbsSyn )
happyIn233 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn233 #-}
happyOut233 :: (HappyAbsSyn ) -> (Located [Located RdrName])
happyOut233 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut233 #-}
happyIn234 :: (Located DataCon) -> (HappyAbsSyn )
happyIn234 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn234 #-}
happyOut234 :: (HappyAbsSyn ) -> (Located DataCon)
happyOut234 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut234 #-}
happyIn235 :: (Located DataCon) -> (HappyAbsSyn )
happyIn235 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn235 #-}
happyOut235 :: (HappyAbsSyn ) -> (Located DataCon)
happyOut235 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut235 #-}
happyIn236 :: (Located RdrName) -> (HappyAbsSyn )
happyIn236 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn236 #-}
happyOut236 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut236 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut236 #-}
happyIn237 :: (Located RdrName) -> (HappyAbsSyn )
happyIn237 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn237 #-}
happyOut237 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut237 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut237 #-}
happyIn238 :: (Located RdrName) -> (HappyAbsSyn )
happyIn238 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn238 #-}
happyOut238 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut238 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut238 #-}
happyIn239 :: (Located RdrName) -> (HappyAbsSyn )
happyIn239 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn239 #-}
happyOut239 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut239 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut239 #-}
happyIn240 :: (Located RdrName) -> (HappyAbsSyn )
happyIn240 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn240 #-}
happyOut240 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut240 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut240 #-}
happyIn241 :: (Located RdrName) -> (HappyAbsSyn )
happyIn241 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn241 #-}
happyOut241 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut241 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut241 #-}
happyIn242 :: (Located RdrName) -> (HappyAbsSyn )
happyIn242 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn242 #-}
happyOut242 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut242 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut242 #-}
happyIn243 :: (Located RdrName) -> (HappyAbsSyn )
happyIn243 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn243 #-}
happyOut243 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut243 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut243 #-}
happyIn244 :: (Located RdrName) -> (HappyAbsSyn )
happyIn244 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn244 #-}
happyOut244 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut244 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut244 #-}
happyIn245 :: (Located RdrName) -> (HappyAbsSyn )
happyIn245 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn245 #-}
happyOut245 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut245 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut245 #-}
happyIn246 :: (Located RdrName) -> (HappyAbsSyn )
happyIn246 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn246 #-}
happyOut246 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut246 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut246 #-}
happyIn247 :: (Located RdrName) -> (HappyAbsSyn )
happyIn247 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn247 #-}
happyOut247 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut247 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut247 #-}
happyIn248 :: (Located RdrName) -> (HappyAbsSyn )
happyIn248 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn248 #-}
happyOut248 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut248 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut248 #-}
happyIn249 :: (LHsExpr RdrName) -> (HappyAbsSyn )
happyIn249 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn249 #-}
happyOut249 :: (HappyAbsSyn ) -> (LHsExpr RdrName)
happyOut249 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut249 #-}
happyIn250 :: (LHsExpr RdrName) -> (HappyAbsSyn )
happyIn250 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn250 #-}
happyOut250 :: (HappyAbsSyn ) -> (LHsExpr RdrName)
happyOut250 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut250 #-}
happyIn251 :: (Located RdrName) -> (HappyAbsSyn )
happyIn251 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn251 #-}
happyOut251 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut251 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut251 #-}
happyIn252 :: (Located RdrName) -> (HappyAbsSyn )
happyIn252 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn252 #-}
happyOut252 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut252 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut252 #-}
happyIn253 :: (Located RdrName) -> (HappyAbsSyn )
happyIn253 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn253 #-}
happyOut253 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut253 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut253 #-}
happyIn254 :: (Located RdrName) -> (HappyAbsSyn )
happyIn254 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn254 #-}
happyOut254 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut254 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut254 #-}
happyIn255 :: (Located RdrName) -> (HappyAbsSyn )
happyIn255 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn255 #-}
happyOut255 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut255 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut255 #-}
happyIn256 :: (Located RdrName) -> (HappyAbsSyn )
happyIn256 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn256 #-}
happyOut256 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut256 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut256 #-}
happyIn257 :: (Located RdrName) -> (HappyAbsSyn )
happyIn257 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn257 #-}
happyOut257 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut257 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut257 #-}
happyIn258 :: (Located RdrName) -> (HappyAbsSyn )
happyIn258 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn258 #-}
happyOut258 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut258 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut258 #-}
happyIn259 :: (Located RdrName) -> (HappyAbsSyn )
happyIn259 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn259 #-}
happyOut259 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut259 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut259 #-}
happyIn260 :: (Located RdrName) -> (HappyAbsSyn )
happyIn260 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn260 #-}
happyOut260 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut260 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut260 #-}
happyIn261 :: (Located RdrName) -> (HappyAbsSyn )
happyIn261 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn261 #-}
happyOut261 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut261 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut261 #-}
happyIn262 :: (Located RdrName) -> (HappyAbsSyn )
happyIn262 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn262 #-}
happyOut262 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut262 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut262 #-}
happyIn263 :: (Located RdrName) -> (HappyAbsSyn )
happyIn263 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn263 #-}
happyOut263 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut263 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut263 #-}
happyIn264 :: (Located RdrName) -> (HappyAbsSyn )
happyIn264 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn264 #-}
happyOut264 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut264 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut264 #-}
happyIn265 :: (Located FastString) -> (HappyAbsSyn )
happyIn265 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn265 #-}
happyOut265 :: (HappyAbsSyn ) -> (Located FastString)
happyOut265 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut265 #-}
happyIn266 :: (Located FastString) -> (HappyAbsSyn )
happyIn266 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn266 #-}
happyOut266 :: (HappyAbsSyn ) -> (Located FastString)
happyOut266 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut266 #-}
happyIn267 :: (Located RdrName) -> (HappyAbsSyn )
happyIn267 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn267 #-}
happyOut267 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut267 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut267 #-}
happyIn268 :: (Located RdrName) -> (HappyAbsSyn )
happyIn268 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn268 #-}
happyOut268 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut268 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut268 #-}
happyIn269 :: (Located RdrName) -> (HappyAbsSyn )
happyIn269 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn269 #-}
happyOut269 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut269 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut269 #-}
happyIn270 :: (Located RdrName) -> (HappyAbsSyn )
happyIn270 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn270 #-}
happyOut270 :: (HappyAbsSyn ) -> (Located RdrName)
happyOut270 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut270 #-}
happyIn271 :: (Located HsLit) -> (HappyAbsSyn )
happyIn271 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn271 #-}
happyOut271 :: (HappyAbsSyn ) -> (Located HsLit)
happyOut271 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut271 #-}
happyIn272 :: (()) -> (HappyAbsSyn )
happyIn272 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn272 #-}
happyOut272 :: (HappyAbsSyn ) -> (())
happyOut272 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut272 #-}
happyIn273 :: (Located ModuleName) -> (HappyAbsSyn )
happyIn273 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn273 #-}
happyOut273 :: (HappyAbsSyn ) -> (Located ModuleName)
happyOut273 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut273 #-}
happyIn274 :: (([SrcSpan],Int)) -> (HappyAbsSyn )
happyIn274 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn274 #-}
happyOut274 :: (HappyAbsSyn ) -> (([SrcSpan],Int))
happyOut274 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut274 #-}
happyIn275 :: (LHsDocString) -> (HappyAbsSyn )
happyIn275 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn275 #-}
happyOut275 :: (HappyAbsSyn ) -> (LHsDocString)
happyOut275 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut275 #-}
happyIn276 :: (LHsDocString) -> (HappyAbsSyn )
happyIn276 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn276 #-}
happyOut276 :: (HappyAbsSyn ) -> (LHsDocString)
happyOut276 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut276 #-}
happyIn277 :: (Located (String, HsDocString)) -> (HappyAbsSyn )
happyIn277 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn277 #-}
happyOut277 :: (HappyAbsSyn ) -> (Located (String, HsDocString))
happyOut277 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut277 #-}
happyIn278 :: (Located (Int, HsDocString)) -> (HappyAbsSyn )
happyIn278 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn278 #-}
happyOut278 :: (HappyAbsSyn ) -> (Located (Int, HsDocString))
happyOut278 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut278 #-}
happyIn279 :: (Maybe LHsDocString) -> (HappyAbsSyn )
happyIn279 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn279 #-}
happyOut279 :: (HappyAbsSyn ) -> (Maybe LHsDocString)
happyOut279 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut279 #-}
happyIn280 :: (Maybe LHsDocString) -> (HappyAbsSyn )
happyIn280 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn280 #-}
happyOut280 :: (HappyAbsSyn ) -> (Maybe LHsDocString)
happyOut280 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut280 #-}
happyIn281 :: (Maybe LHsDocString) -> (HappyAbsSyn )
happyIn281 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn281 #-}
happyOut281 :: (HappyAbsSyn ) -> (Maybe LHsDocString)
happyOut281 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut281 #-}
happyInTok :: ((Located Token)) -> (HappyAbsSyn )
happyInTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyInTok #-}
happyOutTok :: (HappyAbsSyn ) -> ((Located Token))
happyOutTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOutTok #-}


happyActOffsets :: HappyAddr
happyActOffsets = HappyA# "\x1e\x00\x74\x08\x1c\x1e\xe1\x10\xbc\x22\x00\x21\xf9\x18\x1c\x1e\xc3\x3b\x8e\x33\x0b\x00\xa4\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa8\x02\x00\x00\x00\x00\x64\x08\x6a\x08\x75\x08\x00\x00\x00\x00\x67\x08\x00\x00\xeb\x36\x00\x00\x7f\x04\xf0\x07\x1b\x08\x00\x00\x59\x04\x7a\x35\x00\x00\x00\x00\x00\x00\x28\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x96\x41\x00\x00\x00\x00\x00\x00\x26\x08\x24\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe7\xff\xf2\x29\x77\x29\x8b\x27\x81\x28\x9c\x34\x24\x3c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbc\x22\x00\x00\x00\x00\xcf\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x08\xde\x18\x4a\x04\xe9\x3d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x08\x25\x04\x00\x00\xbc\x22\xbc\x22\x4b\x25\x00\x00\x00\x08\x00\x00\x00\x00\x0d\x08\xc6\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x08\x00\x00\x00\x00\xbc\x22\x4a\x05\x88\x1d\x34\x05\x33\x05\x85\x26\x33\x05\x85\x26\xe8\x07\x07\x01\xe4\x07\x3f\x23\x85\x26\xc8\x24\x85\x26\xd1\x17\x65\x18\xa9\x16\x15\x16\x08\x27\x32\x3d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbc\x22\xbc\x22\x8e\x33\x1a\x05\xbc\x22\x00\x00\xbc\x22\x00\x00\xbc\x22\xbd\x3d\xe5\x07\x00\x00\xc4\x07\x62\x0d\xeb\x07\xea\x07\x00\x00\x00\x00\x00\x00\xec\x04\xd2\x02\xf4\x07\x04\x00\xf4\x07\x3c\x40\x81\x15\x00\x00\xb3\x07\x85\x26\xb3\x07\xb3\x07\x00\x00\x00\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x05\x00\x00\x00\x00\x00\x00\x00\x00\x7a\x35\x2b\x08\xe1\x07\x34\x08\xee\x04\x00\x00\xfc\x28\x32\x01\x1c\x40\xde\x07\xc4\x3f\xc4\x3f\x2c\x3f\x48\x3e\x2c\x08\xa4\x3e\x85\x26\x00\x00\x00\x00\x00\x00\x00\x00\xa8\x07\xa8\x07\x08\x08\xa4\x07\x25\x08\x4d\x10\x00\x00\x4d\x10\xd9\x07\x00\x00\xd0\x07\x00\x00\xcb\x07\x00\x00\x46\x00\x29\x04\x14\x08\xee\x07\x84\x02\xed\x07\x1d\x03\xe7\x07\x1d\x03\x1d\x03\x85\x26\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x26\xc0\x07\xa3\x01\x12\x00\x00\x00\x38\x01\xc3\x07\x0a\x00\x00\x00\x38\x01\x07\x00\x00\x00\xcd\x07\x41\x04\xb4\x40\x22\x00\x45\x01\x00\x00\xef\x04\xef\x04\xe2\x07\xdb\x07\x7a\x35\x7a\x35\x13\x03\x8e\x33\xe3\x07\xe0\x07\xdf\x07\xdc\x07\xee\x04\x8e\x33\x7a\x35\xd4\x07\xcc\x07\x00\x00\x84\x02\x00\x00\xbc\x22\x00\x00\x13\x33\x7a\x35\xdd\x07\xa7\x07\x00\x00\xce\x07\x25\x04\x73\x03\xb7\x07\x00\x00\xbc\x22\x00\x00\x00\x00\xab\x07\xa6\x07\xa5\x07\xa3\x07\xed\x14\xc8\x24\x00\x00\x00\x00\x8e\x3d\xc1\x07\x00\x00\xb9\x07\x94\x07\x00\x00\xcc\x3e\xa4\x3e\x00\x00\xdc\x00\xa4\x3e\x98\x32\xa4\x3e\xb5\x07\x00\x00\xef\x07\xc5\x13\xc5\x13\x55\x41\x1d\x32\xb6\x02\x00\x00\x00\x00\x00\x00\x00\x00\x99\x07\x93\x07\x72\x1d\x21\x04\x92\x07\x90\x07\x6d\x07\x6a\x07\xe1\x10\xe1\x10\x69\x07\xfe\x02\x68\x07\x00\x00\x00\x00\xa5\x08\x00\x00\x00\x00\x1c\x04\x8a\x07\x00\x00\x00\x00\x59\x14\x00\x00\x84\x07\x4a\x02\x79\x07\x80\x07\x3e\x01\x7e\x07\x6b\x07\x00\x00\x00\x00\x45\x24\x00\x00\x00\x00\xc2\x23\xe9\x04\x85\x26\x58\x07\x8b\x07\x88\x07\x86\x07\x00\x00\x00\x00\xf4\x1c\xf4\x1c\x7c\x07\x00\x00\xbe\x07\x5f\x07\x37\x00\x00\x00\x5f\x07\x6c\x20\x7b\x07\x00\x00\xae\x07\x85\x26\xbc\x22\x74\x3e\x00\x00\xeb\x36\x00\x00\x00\x00\xa2\x31\xbc\x22\xbc\x22\xbc\x22\xbc\x22\x57\x07\x55\x07\x1a\x04\x5b\x07\x59\x07\x2f\x03\x56\x07\x54\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x31\x06\x28\x19\x3e\x51\x07\x4e\x07\x45\x07\x4a\x07\xe9\x03\x00\x00\x18\x00\x50\x07\x2a\x03\x4f\x07\x48\x07\x44\x07\x00\x00\x49\x07\x00\x00\x4f\x02\x00\x00\x4b\x07\x00\x00\x26\x01\x00\x00\x55\x41\x00\x00\x00\x00\x4d\x07\x96\x41\x00\x00\xb6\x41\x7a\x35\x00\x00\xa2\x31\xa2\x31\x00\x00\x00\x00\x61\x3d\x3c\x07\x3c\x07\x7e\x03\xc7\x05\x00\x00\x00\x00\x91\x07\x00\x00\x00\x00\x00\x00\x46\x07\x00\x00\xa2\x31\xf6\x00\x00\x00\xca\x02\x3a\x07\x00\x00\x00\x00\xa2\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x31\x00\x00\xa2\x31\x00\x00\x00\x00\xa2\x31\x00\x00\x00\x00\x38\x07\x27\x07\x35\x07\x30\x07\x2e\x07\x2c\x07\x28\x07\x25\x07\x24\x07\x23\x07\x26\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x07\x00\x00\x1a\x07\x36\x07\x00\x00\x00\x00\x00\x00\xe9\x04\x2b\x00\x32\x07\x19\x07\x00\x00\x00\x00\x00\x00\x13\x07\x00\x00\x00\x00\x00\x00\x66\x07\xbc\x22\xbc\x22\x25\x01\x00\x00\xc2\x01\xbc\x22\x00\x00\x00\x00\x33\x07\x00\x00\x00\x00\x8d\x19\xc4\x0e\xc2\x23\x31\x07\x65\x18\x00\x00\xbc\x22\x60\x1c\x65\x18\x00\x00\xbc\x22\x60\x1c\x65\x18\x00\x00\x0e\x07\x00\x00\x00\x00\x00\x00\x3d\x17\x00\x00\x51\x26\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x1b\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0b\x07\x06\x07\x00\x00\xff\x06\x00\x00\x00\x00\x00\x00\x00\x00\x94\x40\x00\x00\x00\x00\x15\x07\x00\x00\x20\x01\x1e\x07\x96\x41\xea\x00\x22\x01\x00\x00\x00\x00\x8c\x07\xcc\x1b\xa0\x00\x00\x00\x1c\x07\xbd\x01\x7d\x01\xa2\x31\x17\x07\x00\x00\x16\x07\x0f\x07\xe1\x06\xf8\x06\x0c\x07\xee\x06\xec\x06\xa4\x3f\xa4\x3f\x00\x00\xe4\x06\xdf\x06\x74\x0b\x00\x00\x00\x00\xbc\x22\x65\x18\xf7\xff\x7a\x35\x05\x00\x00\x00\xfc\x06\x2c\x00\x00\x07\x96\x41\x00\x00\x00\x00\x33\x00\x00\x00\xbc\x22\x6c\x20\x7a\x35\x2d\x07\x00\x00\xfb\x06\xde\x06\xa2\x31\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x07\x4a\x00\xcf\x02\xb2\x05\x00\x00\xf7\x06\x27\x31\x91\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x64\x3b\x4a\x0e\xd1\x06\x00\x00\x4a\x0e\x4a\x0e\xd8\x1f\xd8\x1f\x21\x07\x00\x00\x51\x00\x00\x00\xb6\x06\x00\x00\xa1\x06\x00\x00\x00\x00\x4c\x3f\x4c\x3f\x00\x00\x00\x00\x4c\x3f\xce\x25\xe5\x06\xdd\x06\xa0\x03\xdc\x06\xbc\x22\x5b\x03\x00\x00\x00\x00\x00\x00\x03\x07\x00\x00\xa0\x05\x00\x00\xe1\x10\x4d\x10\x00\x00\x00\x00\x00\x00\x00\x00\xb2\x06\x38\x01\x38\x01\x9c\x06\x00\x00\x00\x00\x1d\x03\xc8\x06\x00\x00\x00\x00\x1d\x03\x00\x00\x00\x00\xc4\x06\x00\x00\x00\x00\x00\x00\x14\x02\x00\x00\x00\x00\xfb\xff\xac\x06\xbc\x22\x28\x41\xeb\x06\x00\x00\xa7\x06\x95\x06\x00\x00\x93\x06\x00\x00\x44\x3b\x00\x00\xae\x06\xa9\x06\xa6\x06\xa5\x06\x08\x41\x00\x00\x00\x00\xac\x30\xa0\x06\xac\x30\x96\x41\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x04\x00\x00\x00\x00\x00\x00\xac\x30\x79\x06\x00\x00\x7d\x41\x00\x00\xfe\x03\x00\x00\x99\x06\xca\x06\x00\x00\x00\x00\xb5\x03\x86\x06\x7a\x35\x8d\x06\x31\x30\x31\x30\xc1\x06\xd4\x06\x8e\x06\xb6\x2f\x05\x00\x00\x00\x91\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb6\x2f\x00\x00\x75\x06\xb6\x2f\x00\x00\x00\x00\x00\x00\x00\x00\x69\x06\x00\x00\xc5\x13\xbc\x22\x00\x00\x00\x00\x3b\x2f\x08\x41\x77\x06\x7a\x35\x3b\x2f\x3b\x2f\xb6\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x02\x00\x00\x00\x00\x00\x00\x0b\x01\x00\x00\x00\x00\x28\x22\x00\x00\x37\x01\x00\x00\x00\x00\x00\x00\x81\x06\xeb\x36\x00\x00\x46\x00\x65\x06\x00\x00\x7d\x06\x00\x00\x49\x1b\x68\x06\x00\x00\x41\x06\x00\x00\x00\x00\xb5\x1a\x00\x00\x00\x00\x00\x00\x94\x21\x00\x00\x44\x1f\x94\x21\x00\x00\x00\x00\x65\x18\x74\x3e\x00\x00\x00\x00\x00\x00\xc0\x2e\x00\x00\x00\x00\x66\x06\x00\x00\x64\x06\x5f\x06\x3c\x06\xc0\x2e\x00\x00\xc0\x2e\x63\x06\xa2\x06\x89\x04\x52\x06\x32\x06\x00\x00\x2c\x06\x00\x00\x00\x00\x00\x00\x4c\x06\x00\x00\x00\x00\x00\x00\x00\x00\x43\x06\x00\x00\x62\x06\x00\x00\x00\x00\x55\x03\xb0\x1e\x00\x00\x00\x00\x94\x21\x94\x21\x80\x06\x9a\x05\x21\x1a\x21\x1a\x94\x21\x00\x00\x00\x00\x00\x00\x00\x00\x45\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x59\x06\x37\x06\x60\x06\x00\x00\x57\x06\x00\x00\x84\x06\x94\x06\x00\x00\x19\x06\x00\x00\x07\x03\x92\x06\x7d\x03\x45\x2e\x76\x02\xca\x2d\x00\x00\x00\x00\x94\x21\x00\x00\x31\x13\x31\x13\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9d\x12\x9d\x12\x00\x00\x00\x00\x00\x00\x7a\x06\xb6\x41\x00\x00\x4e\x06\x4f\x2d\x00\x00\x00\x00\x4a\x0e\x00\x00\x00\x00\x38\x02\x39\x06\xd4\x40\x00\x00\x4a\x0e\x39\x05\x00\x00\x00\x00\x30\x06\x00\x00\x17\x06\x00\x00\x49\x06\x00\x00\x48\x06\x06\x03\x00\x00\x47\x06\x46\x06\x73\x06\xfb\x01\x00\x00\x00\x00\x88\x06\x00\x00\x00\x00\x00\x00\x00\x00\x94\x21\x3f\x06\x00\x00\x00\x00\xc5\x13\xc5\x13\x00\x00\x00\x00\x4f\x2d\x00\x00\x2f\x06\x00\x00\x04\x01\x00\x00\x38\x06\x00\x00\x8b\x00\x00\x00\x00\x00\x7a\x35\x75\x01\x00\x00\xb6\x41\x00\x00\x00\x00\x74\x00\x00\x00\x56\x06\x94\x21\xd4\x2c\x73\x01\x00\x00\x00\x00\x00\x00\x65\x02\x65\x02\x00\x00\x00\x00\xff\x34\x10\x00\x00\x00\x5d\x06\x00\x00\x6f\x06\x00\x00\x00\x00\x59\x2c\x00\x00\x00\x00\x00\x00\x00\x00\x94\x21\x94\x21\x94\x21\x00\x00\x00\x00\x00\x00\x00\x00\x5c\x06\x1e\x06\x00\x00\x94\x21\xf0\x05\x61\x06\x00\x00\x00\x00\x00\x00\x00\x00\x02\x06\x00\x00\x86\x3c\x89\x04\x00\x00\x00\x00\x00\x00\xd2\x00\x00\x00\x5b\x06\x5b\x06\x00\x00\x89\x04\xfd\x05\x00\x00\x00\x00\x00\x00\x00\x00\x06\x03\xbf\x01\xd7\x01\x56\x03\x89\x04\x00\x00\x94\x21\x18\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x06\x00\x00\x00\x00\xeb\x36\x0e\x36\x09\x06\xf8\x05\xf3\x05\x00\x00\x46\x00\xf5\x05\x00\x00\xec\x05\x0b\x06\xeb\x05\xf6\x05\x00\x00\x09\x12\x00\x00\x76\x05\x7a\x35\x7a\x35\x81\x05\x7a\x35\x00\x00\x00\x00\x00\x00\x75\x11\x00\x00\x00\x00\x7a\x35\x00\x00\x84\x34\x09\x34\xb6\x41\x00\x00\x73\x00\x61\x01\x59\x2c\x00\x00\x21\x00\x06\x03\x00\x00\x4d\x10\x4d\x10\x46\x00\xf4\x05\x00\x00\x00\x00\x00\x00\xee\x05\x89\x04\xea\x05\x00\x00\x00\x00\xb6\x41\x00\x00\x1f\x00\x00\x00\x46\x00\x52\x01\xf1\x05\x05\x00\x00\x00\x04\x06\xde\x2b\x74\x05\x00\x00\x00\x00\x63\x2b\xe8\x2a\x00\x00\x00\x00\xd2\x02\x6d\x2a\xd2\x02\x65\x02\x00\x00\x00\x00\x7a\x35\xcd\x05\xf2\x05\xe9\x05\xf5\x35\x00\x00\xc8\x05\x94\x21\xd0\x05\x00\x00\x00\x00\xe4\x05\xdd\x05\xd3\x05\xcc\x05\x00\x00\xd4\x01\x00\x00\x00\x00\x00\x00\x05\x3d\xc5\x05\xc2\x05\xc2\x05\x89\x04\xc6\x05\xbf\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe3\x05\x00\x00\x00\x00\x00\x00\xeb\x36\xeb\x36\x00\x00\xa6\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd7\x05\xd6\x05\x8b\x27\x00\x00\x00\x00\x0e\x36\x00\x00\x00\x00\x0a\x06\x1b\x06\x00\x00\x00\x00\x7a\x35\x00\x00\x00\x00\x00\x00\x00\x00\xba\x05\x89\x04\x00\x00\x00\x00\xb9\x05\x00\x00\x00\x00\x00\x00\x0d\x06\xcb\x05\xb6\x41\x00\x00\x70\x36\x8b\x05\xeb\x36\x00\x00\x05\x3d\x00\x00\x00\x00\xa6\x3c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyGotoOffsets :: HappyAddr
happyGotoOffsets = HappyA# "\x01\x00\xed\x05\xf1\x48\x4f\x04\xa5\x51\x46\x4a\xfe\x08\xfe\x47\x2e\x03\x04\x39\x03\x00\x16\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x03\x00\x00\x00\x00\x00\x00\x9e\x05\x00\x00\x00\x00\x00\x00\x98\x05\x00\x00\xb8\x13\x00\x00\x93\x05\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb7\x00\xe9\x38\xc3\x38\x68\x0b\x4d\x0b\xff\x00\x5e\x26\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x51\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x04\xf1\x04\x1a\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc5\x08\x00\x00\x3a\x51\xf6\x50\x2b\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcf\x50\x4e\x05\xca\x48\x11\x05\x49\x05\x18\x54\x2c\x05\xd7\x53\x00\x00\x00\x00\x00\x00\x9f\x52\xc3\x53\x6a\x0b\xb0\x53\xf5\x42\x8d\x42\x94\x41\xda\x41\x22\x3b\x2a\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x50\x37\x52\xb2\x38\x45\x05\x64\x50\x00\x00\x20\x50\x00\x00\xf9\x4f\x56\x04\xca\x05\x00\x00\x00\x00\xc5\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xea\x04\xc4\x01\x0a\x05\xba\x04\xb6\x04\x08\x04\x4e\x41\x00\x00\x00\x00\x6f\x53\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xad\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x03\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x0a\x00\x00\x00\x00\x00\x00\xb6\x05\x00\x00\x4a\x3a\x6c\x05\x80\x00\xac\x04\xb7\x01\x0f\x02\x21\x03\xdb\x03\x00\x00\xc8\x03\x5b\x53\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbb\x05\x00\x00\x00\x00\xb2\x01\x00\x00\x24\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x04\xbf\x04\x91\x05\x00\x00\xf3\x04\x00\x00\x36\x05\x00\x00\xd3\x04\x9a\x04\x48\x53\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07\x53\xb0\x04\x00\x03\x00\x00\x00\x00\x42\x05\x00\x00\x00\x00\x00\x00\x30\x05\x00\x00\x00\x00\xa1\x04\x00\x00\xf9\xff\x29\x00\x6a\x02\x00\x00\x24\x05\x17\x05\x00\x00\x00\x00\xc7\x09\x39\x3a\x7c\x03\x17\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x3d\x05\xdf\x27\x28\x3a\xc1\x04\x00\x00\x00\x00\xda\x04\x00\x00\xce\x42\x00\x00\x03\x0c\x6d\x0a\xfb\x04\x00\x00\x00\x00\x00\x00\x35\x06\x8e\xff\x00\x00\x00\x00\x10\x52\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc5\x43\x6a\x0b\x00\x00\x00\x00\xc0\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdf\x0b\x77\x03\x00\x00\x00\x00\x64\x03\xfc\x0c\x46\x03\x00\x00\x00\x00\x00\x00\x4c\x07\xd3\x06\x60\x00\x5b\x0f\xf0\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x01\x26\x04\x00\x00\x00\x00\x00\x00\x00\x00\x41\x03\xbb\x02\x00\x00\xa6\x03\x00\x00\x00\x00\x00\x00\xf0\x04\x7e\x04\x00\x00\x8e\xff\x00\x00\x00\x00\x00\x00\xc5\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf3\x52\x00\x00\x00\x00\x8b\x52\x62\x04\xe0\x52\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xba\x47\x76\x47\x00\x00\x00\x00\x00\x00\x72\x04\x76\xff\x00\x00\x69\x04\x32\x47\xa3\xff\x00\x00\x00\x00\x9e\x43\xb5\x4f\x42\x01\x00\x00\x43\x0f\x00\x00\x00\x00\xda\x0d\x8e\x4f\x4a\x4f\x23\x4f\xdf\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd4\x26\xb2\x0a\xac\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x02\x00\x00\x24\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x71\x01\xa7\x39\x00\x00\x29\x38\x0e\x38\x00\x00\x00\x00\xad\x01\x00\x00\x00\x00\xff\x03\xf5\x04\x00\x00\x00\x00\xd4\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd8\x34\x00\x00\x00\x00\x44\x04\x00\x00\x00\x00\x00\x00\xb7\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf3\x37\x00\x00\xc1\x2a\x00\x00\x00\x00\xcb\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x04\x1d\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x04\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x4e\x74\x4e\xa8\x03\x00\x00\x00\x00\x4d\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xee\x46\x45\x42\x78\x52\x3e\x04\x23\x45\x00\x00\x09\x4e\xd1\x45\xdd\x44\x00\x00\xe2\x4d\x8b\x45\x97\x44\x00\x00\x8d\xff\x00\x00\x00\x00\x00\x00\x5d\x43\x00\x00\xc5\x07\x00\x00\x00\x00\x00\x00\x00\x00\x9f\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07\x02\x00\x00\x00\x00\x00\x00\x00\x00\x88\x03\x00\x00\xf0\x00\x00\x00\x96\x03\x00\x00\x00\x00\x09\x03\x00\x00\x93\x03\x00\x00\x00\x00\x00\x00\x00\x00\xbf\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdf\x09\xd5\x07\x00\x00\x00\x00\x00\x00\xa6\x03\x00\x00\x00\x00\xce\x42\x51\x44\x00\x00\x55\x0a\xe2\xff\x00\x00\x00\x00\x7b\x03\x00\x00\xa7\x00\x00\x00\x00\x00\xec\xff\x00\x00\x9e\x4d\xa4\x46\x96\x39\x2a\x04\xdd\x04\x3a\x04\x00\x00\xe1\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x05\x04\xe3\x04\x00\x04\x0e\x04\x00\x00\x00\x00\x67\x33\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\xff\x13\x02\x42\x03\x00\x00\xd2\xff\xda\xff\x02\x4a\xbe\x49\xe1\x03\x00\x00\x00\x00\x00\x00\xd2\x03\x00\x00\xc2\x03\x00\x00\x00\x00\xfa\x02\xc2\x06\x00\x00\x00\x00\x0d\x01\x36\x43\x00\x00\x00\x00\x00\x00\x00\x00\x77\x4d\x00\x00\x00\x00\x00\x00\x00\x00\xef\x03\x00\x00\x2b\x04\x00\x00\x28\x04\x37\x02\x00\x00\x00\x00\x00\x00\x00\x00\xe7\x03\x8c\x03\x78\x03\xa3\x03\x00\x00\x00\x00\xf2\x03\x00\x00\x00\x00\x00\x00\xe4\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcc\x51\xfe\xff\x76\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfd\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf5\x01\x00\x00\x00\x00\x71\x32\x5e\x03\xd8\x37\xe1\x00\x00\x00\x53\x03\x00\x00\x00\x00\x00\x00\x00\x00\x39\x03\x00\x00\x00\x00\x00\x00\x4f\x37\x00\x00\x00\x00\x4a\x01\x00\x00\x29\x03\x00\x00\x00\x00\xf2\x02\x00\x00\x00\x00\xfc\x03\x00\x00\x85\x39\x00\x00\x9a\x25\x94\x24\xc5\x02\xab\x02\x00\x00\x34\x37\xdd\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x0c\x00\x00\x00\x00\x39\x0c\x00\x00\x00\x00\x00\x00\x00\x00\xaa\x03\x00\x00\x8c\x08\x33\x4d\x00\x00\x00\x00\x32\x0f\x15\x01\x00\x00\x6a\x39\x7b\x31\x85\x30\x5a\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0c\x4d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x0b\x00\x00\x2d\x02\x00\x00\x00\x00\xc1\x02\x00\x00\x60\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x48\x00\x00\x00\x00\x00\x00\xc8\x4c\x00\x00\x7a\x49\xa1\x4c\x00\x00\x00\x00\x0b\x44\xda\x00\x00\x00\x00\x00\x00\x00\xd5\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x02\x8f\x2f\x00\x00\x19\x37\x12\x03\x00\x00\x19\x00\x00\x00\x27\x02\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x02\x00\x00\x00\x00\x00\x00\x00\x00\xf4\x03\x36\x49\x00\x00\x00\x00\x5d\x4c\x36\x4c\x00\x00\x00\x00\x16\x46\x42\x48\xf2\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x99\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x02\x66\x02\x00\x00\xac\xff\x00\x00\xe8\x02\x57\x02\x00\x00\xa3\x2d\x00\x00\x0b\x23\x00\x00\x00\x00\xcb\x4b\x00\x00\x5a\x06\xe1\x05\x00\x00\x22\x02\x19\x03\x00\x00\x00\x00\x41\x05\xc8\x04\x00\x00\x00\x00\x00\x00\xa0\x02\x0d\x00\x00\x00\x00\x00\x21\x0f\x00\x00\x00\x00\xce\xff\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xff\x00\x00\xd0\x01\xa6\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x01\x00\x00\x00\x00\x00\x00\x00\x00\x83\x02\x00\x00\x00\x00\x43\x02\x00\x00\x00\x00\x00\x00\x00\x00\x87\x4b\x00\x00\x00\x00\x00\x00\x65\x08\xec\x07\x00\x00\x00\x00\xf4\x0e\x00\x00\x00\x00\x00\x00\x4c\x02\x00\x00\x0e\x02\x00\x00\x3f\x01\x00\x00\x00\x00\x96\x09\x00\x00\x00\x00\x4a\x01\x00\x00\x00\x00\x30\x01\x00\x00\xf1\x01\x1e\x42\x76\x09\x00\x00\x00\x00\x00\x00\x00\x00\x74\x02\x17\x02\x00\x00\x00\x00\x94\x23\xa9\x01\x00\x00\x94\x01\x00\x00\x4e\x01\x00\x00\x00\x00\x1e\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x60\x4b\x1c\x4b\xf5\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x67\x01\xf3\x00\x00\x00\xb1\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x00\x4c\x00\x00\x00\x00\x00\x00\x00\xa2\x01\x00\x00\x49\x03\xd5\x02\x00\x00\x48\x00\x91\x01\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x0b\x03\x9c\x01\x6d\x03\x3a\x00\x00\x00\x8a\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x3a\xc4\xff\x00\x00\x00\x00\x00\x00\x00\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x07\x00\x00\x39\x01\x5e\x09\x44\x39\xa6\x03\x99\x0d\x00\x00\x00\x00\x00\x00\x68\x05\x00\x00\x00\x00\x29\x0a\x00\x00\x63\x08\x58\x06\xd5\xff\x00\x00\x45\x00\x00\x00\xad\x2c\x00\x00\xd6\x01\x27\x00\x00\x00\x96\x00\x08\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x00\x00\x00\x00\x00\x00\x76\x01\x00\x00\xc2\xff\x00\x00\xb0\xff\x00\x00\x00\x00\xd8\xff\x00\x00\x30\x00\x96\x0e\x5d\x00\x00\x00\x00\x00\xfe\x36\x47\x36\x00\x00\x00\x00\x92\xff\x32\x0d\x89\x01\x29\x01\x00\x00\x00\x00\x19\x1b\x11\x02\x00\x00\x00\x00\xc6\x03\x00\x00\x0c\x02\x78\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb3\x02\x00\x00\x00\x00\x00\x00\xa9\x02\x00\x00\x00\x00\x00\x00\xfa\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x06\x62\x3a\x00\x00\x82\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x19\x0b\x00\x00\x00\x00\xc5\xff\x00\x00\x00\x00\xd7\xff\xc3\xff\x00\x00\x00\x00\x3e\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\xff\x00\x00\xeb\xff\x00\x00\xc6\x03\x64\x01\x2b\x06\x00\x00\x8a\x01\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyDefActions :: HappyAddr
happyDefActions = HappyA# "\xeb\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcc\xfd\x00\x00\x00\x00\xeb\xff\x00\x00\xf4\xff\x64\xfd\x61\xfd\x5e\xfd\x4e\xfd\x4c\xfd\x4d\xfd\x5a\xfd\x4b\xfd\x4a\xfd\x49\xfd\x5c\xfd\x5b\xfd\x5d\xfd\x59\xfd\x58\xfd\x48\xfd\x47\xfd\x46\xfd\x45\xfd\x44\xfd\x43\xfd\x00\x00\x5f\xfd\x60\xfd\x00\x00\xbb\xff\x00\x00\xde\xff\xed\xff\xbb\xff\x27\xfd\x00\x00\xe5\xfe\xe4\xfe\x00\x00\x00\x00\xdb\xfe\xd4\xfe\xce\xfe\xcb\xfe\xc9\xfe\xb8\xfe\x00\x00\xc4\xfe\x95\xfd\xc8\xfe\x8e\xfd\x83\xfd\x86\xfd\x7f\xfd\xc3\xfe\xc7\xfe\x6e\xfd\x6a\xfd\xae\xfe\xa5\xfe\x68\xfd\x67\xfd\x69\xfd\x00\x00\x00\x00\x7c\xfd\xe1\xfe\x7b\xfd\xe2\xfe\x6c\xfd\x23\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\xfd\x82\xfd\x7d\xfd\x7e\xfd\x84\xfd\x80\xfd\x81\xfd\xbb\xfd\xaf\xfe\xb0\xfe\xb6\xfe\x00\x00\x61\xfe\x60\xfe\x00\x00\xf3\xff\xab\xfd\x9e\xfd\xaa\xfd\xf1\xff\xf2\xff\x72\xfd\x56\xfd\x57\xfd\x52\xfd\x4f\xfd\xa9\xfd\x40\xfd\x9a\xfd\x3d\xfd\x3a\xfd\x51\xfd\x42\xfd\x41\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x3e\xfd\x50\xfd\x3b\xfd\x3f\xfd\x53\xfd\x3c\xfd\x23\xfe\xc8\xfd\x5a\xfe\x59\xfe\x00\x00\x00\x00\x4a\xfe\x41\xfe\x3e\xfe\x3c\xfe\x2d\xfe\x00\x00\x00\x00\xcd\xfd\xcb\xfd\x39\xfe\x38\xfe\x3a\xfe\x3b\xfe\x37\xfe\x2e\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\xfd\x00\x00\x00\x00\x00\x00\x00\x00\xba\xfd\x39\xfd\x38\xfd\x36\xfe\x35\xfe\x35\xfd\x34\xfd\x37\xfd\x36\xfd\x33\xfd\x32\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\xfe\x00\x00\x1f\xfe\x00\x00\x00\x00\xab\xff\x6b\xfe\x00\x00\x00\x00\x00\x00\x61\xfd\xa9\xff\xa8\xff\xa7\xff\x00\x00\x00\x00\x65\xfe\x65\xfe\x65\xfe\xb8\xfd\x00\x00\xdb\xfd\x00\x00\x00\x00\x00\x00\x00\x00\xa1\xff\xa0\xff\x9f\xff\x54\xff\x9e\xff\x9d\xff\x77\xfe\x90\xff\x76\xfe\x7f\xfe\x8f\xff\x7a\xfe\x8e\xff\x7e\xfe\x7d\xfe\x7c\xfe\x7b\xfe\x00\x00\x64\xff\x00\x00\x00\x00\x7f\xff\x63\xff\x00\x00\x00\x00\x00\x00\x1b\xff\x06\xff\x0b\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\xfd\x2a\xfd\x29\xfd\x28\xfd\x00\x00\x00\x00\xb8\xff\x00\x00\x00\x00\xbb\xff\xee\xff\xbb\xff\x00\x00\xe1\xff\xe3\xff\xbc\xff\xe0\xff\xa2\xff\x00\x00\x00\x00\xb6\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\xfd\xa5\xfd\xaf\xfd\x66\xfd\xa7\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x0c\xff\x00\x00\xb1\xfd\x00\x00\x07\xff\x00\x00\x00\x00\x1c\xff\x19\xff\x00\x00\x45\xff\x00\x00\x00\x00\x9b\xff\x00\x00\x00\x00\x00\x00\xd4\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\xff\xa9\xfe\x00\x00\xa2\xfe\x00\x00\x57\xff\x00\x00\x75\xfd\x00\x00\x76\xfd\x00\x00\x00\x00\x54\xff\x00\x00\xda\xfd\x16\xfe\x5a\xfe\x00\x00\x00\x00\x73\xfd\x00\x00\x74\xfd\x70\xfd\x54\xfd\x00\x00\x55\xfd\x9a\xfd\x00\x00\x51\xfd\xa2\xfd\x2c\xfd\x00\x00\x00\x00\xb9\xfd\xb7\xfd\xb5\xfd\xb2\xfd\x00\x00\x00\x00\x64\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\xff\x00\x00\x26\xff\x26\xff\x00\x00\x00\x00\x00\x00\xaa\xff\x29\xfe\x98\xfd\x2a\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\xfe\x18\xfe\x00\x00\x00\x00\x00\x00\x2b\xfe\x2c\xfe\x00\x00\x1c\xfe\x3b\xfe\x00\x00\x00\x00\x54\xfd\x55\xfd\x00\x00\xa0\xfd\x00\x00\xf7\xfd\xf6\xfd\x00\x00\x0c\xfe\x00\x00\x0b\xfe\x9d\xfd\xd8\xfd\x51\xfe\x3f\xfe\xd7\xfd\xd4\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\xfe\xca\xfd\xce\xfd\xce\xfd\x00\x00\x4f\xfe\xc7\xfd\x48\xfe\x00\x00\x53\xfe\x48\xfe\x00\x00\x00\x00\x50\xfe\x00\x00\x00\x00\x00\x00\xc5\xfd\x44\xfe\x00\x00\x4d\xfe\x4e\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb5\xfe\xad\xfd\xac\xfd\xc6\xfe\xc5\xfe\xb2\xfe\x78\xfd\xa9\xfe\x00\x00\x00\x00\x00\x00\x00\x00\xa8\xfe\x00\x00\x00\x00\xbe\xfe\x00\x00\x86\xfd\x00\x00\x00\x00\xe1\xfe\x00\x00\xc0\xfe\x00\x00\x90\xfd\x00\x00\x91\xfd\x00\x00\x87\xfe\x85\xfe\x24\xfd\x00\x00\xdf\xfe\xe0\xfe\x00\x00\xa5\xfe\xa4\xfe\x00\x00\x00\x00\xca\xfe\x00\x00\x00\x00\xe3\xfe\xc2\xfe\x00\x00\xdb\xff\xda\xff\x00\x00\xe8\xff\x2f\xfd\x2e\xfd\xbd\xff\xdd\xfe\xd3\xfe\xdc\xfe\x00\x00\xa6\xfe\x00\x00\x00\x00\xe8\xfe\x00\x00\x00\x00\xc1\xfe\xbc\xfe\x00\x00\xbb\xfe\x8f\xfd\x8c\xfd\x92\xfd\x94\xfd\x2d\xfd\x8d\xfd\x00\x00\xba\xfe\x00\x00\x93\xfd\xbd\xfe\x00\x00\x6d\xfd\x85\xfd\x00\x00\x00\x00\x00\x00\x7c\xfd\x7b\xfd\xe2\xfe\x6c\xfd\x7d\xfd\x7e\xfd\x81\xfd\x00\x00\xaa\xfe\xb7\xfe\xf0\xff\xa1\xfd\xa8\xfd\x62\xfd\x9f\xfd\x99\xfd\x71\xfd\x5b\xfe\x5c\xfe\x5d\xfe\x5e\xfe\x5f\xfe\xeb\xfe\x43\xfe\x00\x00\xc6\xfd\xc3\xfd\xc0\xfd\xc2\xfd\xc9\xfd\x40\xfe\x00\x00\x00\x00\x00\x00\xf2\xfd\xf0\xfd\xdf\xfd\x49\xfe\x48\xfe\xdd\xfd\x30\xfd\x31\xfd\x00\x00\x00\x00\x00\x00\x00\x00\xcf\xfd\x00\x00\x00\x00\x47\xfe\x46\xfe\x00\x00\xd6\xfd\x55\xfe\x00\x00\x00\x00\xd4\xfd\xed\xfe\x00\x00\x30\xfe\x0a\xfe\x00\x00\x00\x00\x2f\xfe\x00\x00\x00\x00\x00\x00\x63\xfd\x0e\xfe\x11\xfe\x31\xfe\x12\xfe\x0d\xfe\x32\xfe\x00\x00\x28\xfe\x25\xfe\x26\xfe\x17\xfe\x00\x00\x00\x00\x24\xfe\x27\xfe\x20\xfe\x1e\xfe\x96\xfd\x00\x00\x00\x00\x97\xfd\x6c\xfe\x79\xfd\xa5\xff\x7a\xfd\x9c\xfd\x00\x00\x6e\xfe\xea\xfe\x00\x00\xd7\xfe\xd2\xfe\x00\x00\xa5\xfe\x00\x00\x00\x00\x75\xfe\x27\xff\xef\xfe\x74\xfe\x00\x00\xbd\xfd\x39\xfe\x00\x00\x00\x00\x00\x00\x00\x00\xad\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x66\xfe\x00\x00\x63\xfd\x14\xfe\x33\xfe\x34\xfe\x15\xfe\x00\x00\x00\x00\x00\x00\x62\xff\xee\xfe\x00\x00\xd2\xfe\x00\x00\xa5\xfe\x58\xfe\x78\xfe\x1f\xff\x70\xfe\x00\x00\x00\x00\x00\x00\x34\xff\x9d\xfe\x60\xff\x00\x00\x00\x00\x80\xff\x81\xff\x83\xff\x82\xff\x2a\xff\x51\xff\x00\x00\x5e\xff\x86\xff\x00\x00\x00\x00\x00\x00\xf9\xfe\xf8\xfe\xf7\xfe\xf6\xfe\xf5\xfe\x00\x00\x00\x00\x00\x00\x48\xff\x45\xff\x00\x00\x00\x00\x00\x00\x13\xff\x18\xff\x00\x00\x98\xff\x1d\xff\x05\xff\x00\xff\x04\xff\x9a\xff\x08\xff\x00\x00\x0a\xff\x99\xff\x0d\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x96\xff\x79\xfe\xb9\xff\xb2\xff\xb7\xff\xe8\xff\xe4\xff\xa3\xff\xbd\xff\xe5\xff\xe2\xff\xbe\xff\xa4\xff\xd8\xff\x00\x00\x00\x00\xb4\xff\xb3\xff\x94\xff\x00\x00\x00\x00\x91\xff\x95\xff\x00\x00\xff\xfe\xfd\xfe\x00\x00\x0e\xff\xb0\xfd\x09\xff\x00\x00\x01\xff\x1e\xff\x00\x00\x00\x00\x00\x00\x00\x00\x4a\xff\x4b\xff\x00\x00\x43\xff\x44\xff\x00\x00\x47\xff\x00\x00\xfb\xfe\x00\x00\xf3\xfe\xf2\xfe\xf4\xfe\x00\x00\xfa\xfe\x8c\xff\x00\x00\x7e\xff\x00\x00\x00\x00\x52\xff\x50\xff\x4f\xff\x4c\xff\x4d\xff\x87\xff\x00\x00\x53\xff\x9c\xff\x88\xff\x00\x00\xa1\xfe\x9f\xfe\x00\x00\x8d\xff\x00\x00\x58\xff\x00\x00\x1f\xff\x72\xfe\x71\xfe\x00\x00\x00\x00\x00\x00\xd1\xfe\x00\x00\x00\x00\x98\xfe\x83\xfe\x00\x00\x00\x00\x62\xff\x55\xff\x00\x00\x13\xfe\x6f\xfd\xb6\xfd\xb4\xfd\xa6\xfd\xb3\xfd\x00\x00\x63\xfe\x00\x00\x00\x00\x67\xfe\x6a\xfe\x3f\xff\x22\xff\xbe\xfd\x25\xff\x28\xff\x00\x00\x21\xff\x24\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1a\xfe\x19\xfe\x1b\xfe\x1d\xfe\x22\xfe\x10\xfe\x0f\xfe\x16\xfe\x04\xfe\xf3\xfd\x03\xfe\x01\xfe\xfe\xfd\xfd\xfd\x00\x00\xf5\xfd\x16\xfe\x06\xfe\x08\xfe\x05\xfe\x00\x00\x00\x00\xd5\xfd\x00\x00\xeb\xfd\xe7\xfd\xed\xfe\xec\xfd\x00\x00\x00\x00\xed\xfd\x00\x00\x4b\xfe\xd3\xfd\xd0\xfd\xd2\xfd\x4c\xfe\x56\xfe\x00\x00\xe0\xfd\x00\x00\x00\x00\xde\xfd\x52\xfe\x00\x00\x00\x00\x3d\xfe\xb3\xfe\x65\xfd\x00\x00\x77\xfd\xa7\xfe\x00\x00\x9b\xfe\x00\x00\x00\x00\x25\xfd\x00\x00\xde\xfe\x00\x00\xd8\xff\x00\x00\xd1\xff\x00\x00\x25\xfd\x26\xfd\x23\xfd\xb1\xfe\xb9\xfe\xbf\xfe\x00\x00\xc4\xfd\xc1\xfd\xdc\xfd\xf1\xfd\x48\xfe\xd1\xfd\x00\x00\xef\xfd\xea\xfd\x00\x00\xe8\xfd\xee\xfd\xec\xfe\x00\x00\x09\xfe\xfc\xfd\x43\xfd\x00\x00\x00\x00\x00\x00\xa6\xff\xd9\xfe\xd0\xfe\xd8\xfe\x00\x00\xe9\xfe\x6d\xfe\xbc\xfd\x29\xff\xbf\xfd\x00\x00\xe7\xfe\x00\x00\x62\xfe\x00\x00\x56\xff\x98\xfe\x83\xfe\x61\xff\x23\xfd\x8a\xff\x00\x00\x83\xfe\x00\x00\x00\x00\xd8\xfe\x00\x00\x20\xff\x73\xfe\x00\x00\x35\xff\x38\xff\x38\xff\x9c\xfe\x9d\xfe\x9d\xfe\x5f\xff\x2b\xff\x2e\xff\x2e\xff\x4e\xff\x5c\xff\x5d\xff\x79\xff\x00\x00\x6f\xff\x00\x00\x00\x00\xfc\xfe\x9b\xfd\x00\x00\x46\xff\x49\xff\x00\x00\x00\x00\x12\xff\x10\xff\x00\x00\x00\x00\x17\xff\x15\xff\x00\x00\x03\xff\x00\x00\xfe\xfe\x00\x00\x97\xff\x00\x00\x00\x00\xb5\xff\x00\x00\x00\x00\x00\x00\x00\x00\xea\xff\xe9\xff\xb0\xff\x92\xff\x93\xff\x02\xff\x16\xff\x00\x00\x00\x00\x11\xff\x14\xff\x26\xff\x26\xff\x42\xff\xf0\xfe\x00\x00\x7d\xff\x00\x00\x8b\xff\x00\x00\x33\xff\x54\xff\x2f\xff\x00\x00\x32\xff\x64\xff\x00\x00\x00\x00\xa0\xfe\x9e\xfe\x3e\xff\x39\xff\x00\x00\x3d\xff\x69\xff\x00\x00\x00\x00\x00\x00\x6f\xfe\xda\xfe\xcf\xfe\x95\xfe\x95\xfe\x89\xff\x82\xfe\x00\x00\x91\xfe\x8f\xfe\x8b\xfe\x85\xff\x83\xfe\x68\xfe\x69\xfe\x00\x00\xf4\xfd\x00\xfe\xff\xfd\x02\xfe\x00\x00\x00\x00\x00\x00\x07\xfe\x57\xfe\xe9\xfd\xe6\xfd\x1f\xff\xe3\xfd\xe1\xfd\x00\x00\x00\x00\x00\x00\xb4\xfe\x86\xfe\x84\xfe\xa3\xfe\x00\x00\xd6\xff\xd3\xff\xd1\xff\xce\xff\xcf\xff\xd0\xff\x00\x00\xdf\xff\xbb\xff\xbb\xff\xd2\xff\xd1\xff\xca\xff\xc2\xff\xbf\xff\x8b\xfd\xc0\xff\x00\x00\x00\x00\x00\x00\x00\x00\xd1\xff\xd9\xff\x00\x00\x00\x00\xe4\xfd\xe2\xfd\xe5\xfd\xfb\xfd\xfa\xfd\x00\x00\xe6\xfe\x84\xff\x00\x00\xa5\xfe\x00\x00\xac\xfe\x00\x00\x81\xfe\x00\x00\x96\xfe\x93\xfe\xa4\xfd\x00\x00\x00\x00\x00\x00\x37\xff\x3a\xff\x6b\xff\x5b\xff\x00\x00\x00\x00\x00\x00\x00\x00\x68\xff\x36\xff\x2d\xff\x30\xff\x67\xff\x2c\xff\x00\x00\x78\xff\x70\xff\x70\xff\x00\x00\xf1\xfe\x00\x00\x00\x00\x00\x00\x1a\xff\xae\xff\x00\x00\xef\xff\xbb\xff\xbb\xff\x00\x00\x00\x00\xb1\xff\xba\xff\xaf\xff\x00\x00\xd1\xff\x00\x00\x41\xff\x40\xff\x7c\xff\x7a\xff\x00\x00\x71\xff\x00\x00\x00\x00\x00\x00\x62\xff\x31\xff\x60\xff\x00\x00\x5b\xff\x6a\xff\x6d\xff\x00\x00\x00\x00\x3b\xff\x9a\xfe\x00\x00\x00\x00\x00\x00\x95\xfe\x99\xfe\x80\xfe\x00\x00\x25\xfd\x00\x00\x00\x00\x8a\xfe\xcc\xfe\x25\xfd\x00\x00\x00\x00\x54\xfe\xd7\xff\x00\x00\x00\x00\x00\x00\x00\x00\xcb\xff\x00\x00\xc1\xff\xcc\xff\xcd\xff\xc8\xff\xd4\xff\xdc\xff\xdd\xff\xd1\xff\x00\x00\xc7\xff\xc5\xff\xc4\xff\xc3\xff\x8a\xfd\x89\xfd\x87\xfd\x88\xfd\x00\x00\xf9\xfd\x8d\xfe\xcd\xfe\x00\x00\x00\x00\x8c\xfe\x23\xfd\xab\xfe\x97\xfe\xa3\xfd\x92\xfe\x94\xfe\x00\x00\xc3\xfe\x00\x00\x5a\xff\x6c\xff\x00\x00\x3c\xff\x6e\xff\x98\xfe\x83\xfe\x75\xff\x77\xff\x72\xff\x74\xff\x76\xff\x7b\xff\x0f\xff\x00\x00\xd1\xff\xe7\xff\xe6\xff\x00\x00\xad\xff\x73\xff\x66\xff\x83\xfe\xc3\xfe\x00\x00\x90\xfe\x8a\xfe\x25\xfd\x89\xfe\x45\xfe\x00\x00\xc9\xff\xd5\xff\xd3\xff\xc6\xff\x8e\xfe\x59\xff\x65\xff\xac\xff"#

happyCheck :: HappyAddr
happyCheck = HappyA# "\xff\xff\x2c\x00\x01\x00\x02\x00\x03\x00\x02\x00\x03\x00\x06\x00\x0e\x00\x0f\x00\x10\x00\x89\x00\x09\x00\x35\x00\x0b\x00\x07\x00\x08\x00\x43\x00\x35\x00\x23\x00\x42\x00\x11\x00\x2b\x00\x35\x00\x86\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x43\x00\x13\x00\x00\x00\x18\x00\x19\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x22\x00\x0a\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x13\x00\x62\x00\x63\x00\x88\x00\x89\x00\xc0\x00\x00\x00\x2b\x00\xac\x00\xac\x00\x42\x00\x34\x00\x51\x00\x47\x00\x11\x00\x7c\x00\x7d\x00\x7d\x00\x3b\x00\x3c\x00\x5e\x00\x00\x00\x8f\x00\x40\x00\x0f\x00\x10\x00\x01\x00\x19\x00\x45\x00\x47\x00\x4a\x00\x4b\x00\x47\x00\x8f\x00\x57\x00\x58\x00\x57\x00\x58\x00\x0f\x00\x10\x00\x47\x00\x83\x00\x0f\x00\x10\x00\x62\x00\x4e\x00\x87\x00\x63\x00\xbe\x00\x4a\x00\xc0\x00\x87\x00\x61\x00\x36\x00\x5f\x00\x5d\x00\x87\x00\x83\x00\x49\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\x42\x00\x7a\x00\x6b\x00\x00\x00\x00\x00\x6b\x00\x7b\x00\x4b\x00\x02\x01\x4e\x00\x4e\x00\x5d\x00\x50\x00\x6b\x00\x66\x00\x60\x00\x54\x00\x4e\x00\x96\x00\x63\x00\x6c\x00\x4e\x00\x65\x00\x05\x01\x83\x00\x5e\x00\x6b\x00\x00\x00\x68\x00\x0b\x01\x83\x00\x6d\x00\xfe\x00\x04\x01\x04\x01\x83\x00\x72\x00\x38\x00\x11\x00\x60\x00\x90\x00\x91\x00\x92\x00\x16\x00\x17\x00\x07\x00\x08\x00\x97\x00\x00\x00\x83\x00\x9a\x00\x52\x00\x9c\x00\x9d\x00\x60\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x18\x00\x19\x00\x84\x00\x05\x01\x02\x01\xef\x00\xef\x00\xf1\x00\xf1\x00\x0b\x01\x22\x00\x6f\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\xfb\x00\xfb\x00\x41\x00\xf2\x00\xf5\x00\x02\x01\xf5\x00\xf1\x00\xf5\x00\x68\x00\xfb\x00\x34\x00\xfb\x00\x7b\x00\xfb\x00\xde\x00\xf5\x00\xfb\x00\x3b\x00\x3c\x00\x60\x00\x60\x00\xfb\x00\x40\x00\xcf\x00\xd0\x00\xe9\x00\xea\x00\x45\x00\xf1\x00\x05\x01\x6b\x00\x6b\x00\xd8\x00\xd9\x00\x05\x01\x0b\x01\xdc\x00\xdd\x00\xfb\x00\x05\x01\x0b\x01\xf9\x00\xfa\x00\x60\x00\xfc\x00\x0b\x01\xf5\x00\xf2\x00\x00\x01\xf5\x00\xf5\x00\xf5\x00\xfb\x00\x5f\x00\x6b\x00\xfb\x00\xfb\x00\xfb\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf1\x00\x05\x01\x60\x00\x07\x01\x08\x01\xfb\x00\x02\x01\xfd\x00\xfe\x00\xde\x00\xfb\x00\x01\x01\x09\x01\x6b\x00\x09\x01\x05\x01\x06\x01\x07\x01\x08\x01\x05\x01\xf2\x00\x07\x01\x08\x01\xf5\x00\xf2\x00\x8d\x00\x8e\x00\xf5\x00\x05\x01\xfb\x00\x07\x01\x08\x01\x05\x01\xfb\x00\x07\x01\x08\x01\x00\x00\x7c\x00\x7d\x00\x00\x00\x90\x00\x91\x00\x92\x00\x00\x01\x03\x01\x07\x00\x08\x00\x97\x00\x52\x00\x5d\x00\x9a\x00\x5f\x00\x9c\x00\x9d\x00\x4a\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x18\x00\x19\x00\x0c\x00\x05\x01\x4a\x00\x07\x01\x08\x01\x8c\x00\x8d\x00\x8e\x00\x22\x00\x02\x01\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x05\x01\x1c\x00\x07\x01\x08\x01\x05\x01\xf2\x00\x07\x01\x08\x01\xf5\x00\x6c\x00\x7b\x00\x34\x00\x4e\x00\xda\x00\xfb\x00\xdc\x00\xdd\x00\x7d\x00\x3b\x00\x3c\x00\x5d\x00\x6c\x00\x5f\x00\x40\x00\xcf\x00\xd0\x00\x5a\x00\xe3\x00\x45\x00\xe5\x00\xe6\x00\x7c\x00\x7d\x00\xd8\x00\xd9\x00\x50\x00\x38\x00\xdc\x00\xdd\x00\x54\x00\xf5\x00\x6f\x00\x6c\x00\xf3\x00\xf4\x00\xf5\x00\xfb\x00\x7c\x00\x7d\x00\xfe\x00\x48\x00\xfb\x00\x7a\x00\x60\x00\x5f\x00\x02\x01\x60\x00\x48\x00\x50\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\x4e\x00\x6b\x00\x49\x00\x05\x01\x6b\x00\xfb\x00\x6c\x00\xfd\x00\xfe\x00\x0b\x01\xef\x00\x01\x01\xf1\x00\x61\x00\x03\x01\x05\x01\x06\x01\x07\x01\x08\x01\x15\x00\x16\x00\x17\x00\xfb\x00\x12\x00\x84\x00\xcb\x00\xcc\x00\x7c\x00\x7d\x00\x83\x00\x6c\x00\x66\x00\x0a\x00\x84\x00\x85\x00\x86\x00\x5e\x00\x6c\x00\x7a\x00\xc0\x00\x90\x00\x91\x00\x92\x00\x72\x00\x51\x00\x07\x00\x08\x00\x97\x00\x05\x01\x6b\x00\x9a\x00\x5e\x00\x9c\x00\x9d\x00\x0b\x01\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x18\x00\x19\x00\x6b\x00\xf3\x00\xf4\x00\xf5\x00\xef\x00\x5e\x00\xf1\x00\x5e\x00\x22\x00\xfb\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x5e\x00\xfb\x00\x8f\x00\x6b\x00\xef\x00\x6b\x00\xf1\x00\xd5\x00\xd6\x00\xe5\x00\xe6\x00\x34\x00\xda\x00\x6b\x00\xdc\x00\xdd\x00\xfb\x00\x49\x00\x3b\x00\x3c\x00\xef\x00\xf1\x00\xf1\x00\x40\x00\xcf\x00\xd0\x00\x1f\x00\x20\x00\x45\x00\x55\x00\x56\x00\xfb\x00\xfb\x00\xd8\x00\xd9\x00\x5b\x00\xf2\x00\xdc\x00\xdd\x00\xf5\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xf2\x00\xfb\x00\x66\x00\xf5\x00\xfe\x00\xca\x00\xcb\x00\xcc\x00\x6c\x00\xfb\x00\x5f\x00\x5b\x00\x5c\x00\x71\x00\x72\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xef\x00\x5e\x00\xf1\x00\x49\x00\x8a\x00\xfb\x00\x5e\x00\xfd\x00\xfe\x00\x32\x00\x65\x00\x01\x01\xfb\x00\xfe\x00\x6b\x00\x05\x01\x06\x01\x07\x01\x08\x01\x6b\x00\x05\x01\x70\x00\xe7\x00\xe8\x00\x02\x01\x74\x00\x0b\x01\xf3\x00\xf4\x00\xf5\x00\x61\x00\xef\x00\x66\x00\xf1\x00\x65\x00\xfb\x00\x67\x00\x08\x00\x6c\x00\x02\x01\x90\x00\x91\x00\x92\x00\xfb\x00\x72\x00\x70\x00\x3a\x00\x97\x00\x76\x00\x74\x00\x9a\x00\x04\x01\x9c\x00\x9d\x00\x19\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x5d\x00\x22\x00\x5f\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\xef\x00\x1e\x00\xf1\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xf1\x00\x59\x00\x5a\x00\x06\x01\x34\x00\xfb\x00\xe3\x00\x0a\x01\xe5\x00\xe6\x00\xfb\x00\x3b\x00\x3c\x00\xd8\x00\xd9\x00\x62\x00\x40\x00\xdc\x00\xdd\x00\x2e\x00\x48\x00\x45\x00\xf3\x00\xf4\x00\xf5\x00\x6c\x00\xcf\x00\xd0\x00\x50\x00\xd7\x00\xfb\x00\xd9\x00\xfe\x00\x05\x00\xdc\x00\xd8\x00\xd9\x00\xd5\x00\xd6\x00\xdc\x00\xdd\x00\x03\x01\xda\x00\x48\x00\xdc\x00\xdd\x00\x5d\x00\x5f\x00\x5f\x00\x4e\x00\xfd\x00\xfe\x00\x84\x00\x85\x00\x86\x00\xda\x00\xf2\x00\xdc\x00\xdd\x00\xf5\x00\x81\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xfb\x00\xf2\x00\xfd\x00\xfe\x00\xf5\x00\xfb\x00\x05\x01\xfd\x00\xfe\x00\x62\x00\xfb\x00\x01\x01\x0b\x01\xfe\x00\x6c\x00\x05\x01\x06\x01\x07\x01\x08\x01\x6c\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x4b\x00\xfe\x00\x08\x00\x4e\x00\xf5\x00\x61\x00\x90\x00\x91\x00\x92\x00\x65\x00\xfb\x00\x67\x00\x2d\x00\x97\x00\x4b\x00\x6b\x00\x9a\x00\x4e\x00\x9c\x00\x9d\x00\x70\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x22\x00\x83\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\xd5\x00\xd6\x00\x8f\x00\xf2\x00\x83\x00\xda\x00\xf5\x00\xdc\x00\xdd\x00\x18\x00\x19\x00\x34\x00\xfb\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\x8f\x00\x3b\x00\x3c\x00\x84\x00\x85\x00\x86\x00\x40\x00\xf5\x00\x55\x00\x56\x00\x49\x00\x45\x00\xf2\x00\xfb\x00\x5b\x00\xf5\x00\xfe\x00\xcf\x00\xd0\x00\xf5\x00\x9e\x00\xfb\x00\x55\x00\x56\x00\xfe\x00\xfb\x00\xd8\x00\xd9\x00\x5b\x00\x06\x01\xdc\x00\xdd\x00\xfe\x00\x0a\x01\x06\x01\x49\x00\x71\x00\x5f\x00\x0a\x01\x05\x01\x75\x00\x0c\x00\x55\x00\x56\x00\x52\x00\x0b\x01\x6d\x00\x55\x00\x5b\x00\x65\x00\x71\x00\x72\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\x06\x01\x00\x00\x02\x01\x05\x01\x0a\x01\xfb\x00\x61\x00\xfd\x00\xfe\x00\x0b\x01\x65\x00\x01\x01\x67\x00\x8f\x00\x71\x00\x05\x01\x06\x01\x07\x01\x08\x01\x71\x00\x72\x00\x70\x00\x51\x00\x75\x00\x76\x00\x06\x01\x49\x00\x83\x00\x08\x00\x0a\x01\x90\x00\x91\x00\x92\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\x97\x00\x55\x00\x56\x00\x9a\x00\x5c\x00\x9c\x00\x9d\x00\x5b\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x18\x00\x19\x00\x22\x00\xa9\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x00\x01\x6d\x00\x65\x00\x64\x00\x04\x01\x71\x00\x72\x00\x48\x00\xfe\x00\x75\x00\x76\x00\x34\x00\x70\x00\x70\x00\x65\x00\x05\x01\x74\x00\x74\x00\x3b\x00\x3c\x00\x61\x00\x0b\x01\x63\x00\x40\x00\x65\x00\x70\x00\x67\x00\x4c\x00\x45\x00\x74\x00\x2a\x00\x8b\x00\xcf\x00\xd0\x00\xe3\x00\x70\x00\xe5\x00\xe6\x00\x66\x00\x74\x00\x3f\x00\xd8\x00\xd9\x00\x66\x00\x6c\x00\xdc\x00\xdd\x00\x80\x00\x81\x00\x6c\x00\xf3\x00\xf4\x00\xf5\x00\x49\x00\x5f\x00\xf5\x00\x47\x00\x4e\x00\xfb\x00\x50\x00\x4b\x00\xfb\x00\x52\x00\xfd\x00\xfe\x00\x55\x00\x56\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\x5b\x00\xff\x00\x00\x01\xf4\x00\xf5\x00\xfb\x00\x04\x01\xfd\x00\xfe\x00\x44\x00\xfb\x00\x01\x01\xfd\x00\xfe\x00\x1c\x00\x05\x01\x06\x01\x07\x01\x08\x01\xe0\x00\xe1\x00\xe2\x00\x71\x00\x72\x00\xe5\x00\xe6\x00\x75\x00\x76\x00\xe5\x00\xe6\x00\xd5\x00\xd6\x00\x90\x00\x91\x00\x92\x00\xda\x00\x5d\x00\xdc\x00\xdd\x00\x97\x00\x66\x00\x5d\x00\x9a\x00\x5f\x00\x9c\x00\x9d\x00\x6c\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x47\x00\xdf\x00\x5d\x00\xa9\x00\x4b\x00\xf2\x00\xe2\x00\x70\x00\xf5\x00\xe5\x00\xe6\x00\x74\x00\x0c\x00\xeb\x00\xfb\x00\xed\x00\xd6\x00\xfe\x00\xf9\x00\xfa\x00\xda\x00\xfc\x00\xdc\x00\xdd\x00\xf6\x00\x00\x01\xf8\x00\xf9\x00\xfa\x00\x04\x01\xfc\x00\xd8\x00\xd9\x00\xff\x00\x00\x01\xdc\x00\xdd\x00\x1d\x00\xdf\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\x5d\x00\xf2\x00\x5f\x00\xfb\x00\xf5\x00\xfd\x00\xfe\x00\xd8\x00\xd9\x00\xed\x00\xfb\x00\xdc\x00\xdd\x00\xfe\x00\x5e\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\x53\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x04\x00\x6a\x00\x6b\x00\x6c\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\x56\x00\xde\x00\xf3\x00\xf4\x00\xf5\x00\xfb\x00\x77\x00\xfd\x00\xfe\x00\xfe\x00\xfb\x00\x01\x01\xe9\x00\xea\x00\x37\x00\x05\x01\x06\x01\x07\x01\x08\x01\x22\x00\x4f\x00\x50\x00\x25\x00\x26\x00\x27\x00\x28\x00\x68\x00\x4d\x00\xf9\x00\xfa\x00\x6c\x00\xfc\x00\xf3\x00\xf4\x00\xf5\x00\x00\x01\x5d\x00\x34\x00\x5f\x00\xe2\x00\xfb\x00\x9a\x00\xe5\x00\xe6\x00\x3b\x00\x3c\x00\xf8\x00\xf9\x00\xfa\x00\x40\x00\xfc\x00\xf3\x00\xf4\x00\xf5\x00\x45\x00\x49\x00\x4a\x00\x36\x00\x22\x00\xfb\x00\x49\x00\x25\x00\x26\x00\x27\x00\x28\x00\xce\x00\xcf\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x06\x01\x68\x00\x34\x00\x68\x00\xdf\x00\x6c\x00\x5f\x00\x6c\x00\x68\x00\x3b\x00\x3c\x00\x4b\x00\x6c\x00\x06\x01\x40\x00\x4f\x00\xeb\x00\x6d\x00\xed\x00\x45\x00\x02\x01\x71\x00\x72\x00\x02\x01\x70\x00\x75\x00\x76\x00\xf6\x00\x74\x00\xf8\x00\xf9\x00\xfa\x00\x02\x01\xfc\x00\x65\x00\xde\x00\xff\x00\x00\x01\xe1\x00\xe2\x00\x50\x00\x02\x01\xe5\x00\xe6\x00\x54\x00\x5f\x00\xbb\x00\xbc\x00\xbd\x00\x68\x00\x9e\x00\xc0\x00\xef\x00\x6c\x00\xf1\x00\x90\x00\x91\x00\x92\x00\xf3\x00\xf4\x00\xf5\x00\x5d\x00\x97\x00\x5f\x00\xfb\x00\x9a\x00\xfb\x00\x9c\x00\x9d\x00\x00\x01\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xf3\x00\xf4\x00\xf5\x00\x52\x00\xe0\x00\xe1\x00\xe2\x00\x56\x00\xfb\x00\xe5\x00\xe6\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xc0\x00\xd6\x00\x90\x00\x91\x00\x92\x00\xda\x00\xb7\x00\xdc\x00\xdd\x00\x97\x00\xe7\x00\xe8\x00\x9a\x00\x22\x00\x9c\x00\x9d\x00\x19\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x54\x00\x55\x00\xcf\x00\xd0\x00\x04\x00\xf2\x00\x33\x00\x34\x00\xf5\x00\x52\x00\x53\x00\xd8\x00\xd9\x00\x03\x01\xfb\x00\xdc\x00\xdd\x00\xfe\x00\x9e\x00\x40\x00\xf3\x00\xf4\x00\xf5\x00\x83\x00\x45\x00\x85\x00\x86\x00\x9e\x00\xfb\x00\x4a\x00\x4b\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xb7\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\x3d\x00\x3e\x00\x3f\x00\xfb\x00\xa6\x00\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\x04\x01\xdc\x00\xdd\x00\x05\x01\x06\x01\x07\x01\x08\x01\x43\x00\x44\x00\x45\x00\x46\x00\x3a\x00\xe0\x00\xe1\x00\xe2\x00\x4f\x00\x50\x00\xe5\x00\xe6\x00\xf9\x00\xfa\x00\x7e\x00\xfc\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xef\x00\x5d\x00\xf1\x00\x5f\x00\x5d\x00\xfb\x00\x5f\x00\xfd\x00\xfe\x00\x98\x00\x99\x00\x01\x01\xfb\x00\x98\x00\x99\x00\x05\x01\x06\x01\x07\x01\x08\x01\x90\x00\x91\x00\x92\x00\x93\x00\x7f\x00\x80\x00\x81\x00\x97\x00\x4f\x00\x50\x00\x9a\x00\x22\x00\x9c\x00\x9d\x00\x29\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x94\x00\x95\x00\x96\x00\x49\x00\x4a\x00\x4b\x00\x33\x00\x34\x00\x4e\x00\x5d\x00\x61\x00\x5f\x00\xe0\x00\xe1\x00\xe2\x00\x55\x00\x56\x00\xe5\x00\xe6\x00\x40\x00\x49\x00\x5b\x00\x4b\x00\x61\x00\x45\x00\x94\x00\x95\x00\x96\x00\x22\x00\x4a\x00\x4b\x00\x5d\x00\x55\x00\x56\x00\x5d\x00\x5d\x00\x5f\x00\x5f\x00\x5b\x00\x6d\x00\xe6\x00\xcf\x00\xd0\x00\x71\x00\x72\x00\x33\x00\x34\x00\x75\x00\x76\x00\x5d\x00\xd8\x00\xd9\x00\x98\x00\x99\x00\xdc\x00\xdd\x00\x6d\x00\x5d\x00\x40\x00\x5f\x00\x71\x00\x72\x00\x1b\x00\x45\x00\x75\x00\x76\x00\x18\x00\x19\x00\x4a\x00\xe0\x00\xe1\x00\xe2\x00\x18\x00\x19\x00\xe5\x00\xe6\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\x4a\x00\x4b\x00\x4a\x00\x4b\x00\x03\x01\xfb\x00\x02\x01\xfd\x00\xfe\x00\x2d\x00\x2e\x00\x01\x01\x49\x00\x4a\x00\x60\x00\x05\x01\x06\x01\x07\x01\x08\x01\x90\x00\x91\x00\x92\x00\x93\x00\x1a\x00\x55\x00\x56\x00\x97\x00\x39\x00\x3a\x00\x9a\x00\x5b\x00\x9c\x00\x9d\x00\x29\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x3a\x00\xf8\x00\xf9\x00\xfa\x00\x21\x00\xfc\x00\xa8\x00\x6d\x00\xff\x00\x00\x01\xc5\x00\x71\x00\x72\x00\x04\x01\x04\x01\x75\x00\x76\x00\x90\x00\x91\x00\x92\x00\x93\x00\x4a\x00\x4b\x00\x6b\x00\x97\x00\x39\x00\x3a\x00\x9a\x00\x22\x00\x9c\x00\x9d\x00\x19\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xc5\x00\x84\x00\xcf\x00\xd0\x00\x31\x00\xc5\x00\x07\x00\x4a\x00\xe0\x00\xe1\x00\xe2\x00\xd8\x00\xd9\x00\xe5\x00\xe6\x00\xdc\x00\xdd\x00\x66\x00\x66\x00\x40\x00\x07\x00\x19\x00\x4e\x00\x4e\x00\x45\x00\x46\x00\x47\x00\x83\x00\x47\x00\x6c\x00\x66\x00\x6b\x00\x6a\x00\x6b\x00\x6c\x00\x6c\x00\x66\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\x66\x00\x76\x00\x77\x00\xfb\x00\x54\x00\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\x66\x00\xdc\x00\xdd\x00\x05\x01\x06\x01\x07\x01\x08\x01\x66\x00\x7b\x00\x84\x00\x5b\x00\x4a\x00\x5e\x00\x66\x00\x84\x00\x5e\x00\x65\x00\x5e\x00\x4a\x00\x6b\x00\x4e\x00\x6c\x00\x66\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\x9a\x00\x2e\x00\x6b\x00\x49\x00\x65\x00\xfb\x00\x6c\x00\xfd\x00\xfe\x00\x0c\x00\x66\x00\x01\x01\x09\x00\x7b\x00\x4e\x00\x05\x01\x06\x01\x07\x01\x08\x01\x90\x00\x91\x00\x92\x00\x93\x00\x19\x00\x07\x00\x1a\x00\x97\x00\x23\x00\x42\x00\x9a\x00\x22\x00\x9c\x00\x9d\x00\x50\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x2f\x00\x30\x00\x4a\x00\x02\x00\x31\x00\x19\x00\x47\x00\x47\x00\x47\x00\x47\x00\x7a\x00\x62\x00\x19\x00\x5b\x00\x6a\x00\x6b\x00\x6c\x00\x4a\x00\x07\x00\x40\x00\x07\x00\x83\x00\x19\x00\x47\x00\x45\x00\x46\x00\x47\x00\x77\x00\x6c\x00\x4b\x00\xe1\x00\xe2\x00\x47\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\x2d\x00\x6b\x00\x83\x00\xcf\x00\xd0\x00\x66\x00\xef\x00\xf0\x00\xf1\x00\x84\x00\x55\x00\x66\x00\xd8\x00\xd9\x00\x19\x00\x7b\x00\xdc\x00\xdd\x00\xfb\x00\x84\x00\x62\x00\x6a\x00\x6b\x00\x6c\x00\x9a\x00\x5e\x00\x4a\x00\x65\x00\x71\x00\x66\x00\x73\x00\x66\x00\x75\x00\x76\x00\x77\x00\x6b\x00\x50\x00\x5b\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\x62\x00\x47\x00\x4b\x00\x19\x00\x07\x00\xfb\x00\x50\x00\xfd\x00\xfe\x00\x77\x00\x5b\x00\x01\x01\x19\x00\x4b\x00\x6c\x00\x05\x01\x06\x01\x07\x01\x08\x01\x90\x00\x91\x00\x92\x00\x93\x00\x4e\x00\x4a\x00\x4a\x00\x97\x00\x9a\x00\x4a\x00\x9a\x00\x22\x00\x9c\x00\x9d\x00\x4a\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x6d\x00\x6c\x00\xd8\x00\xd9\x00\x19\x00\x5e\x00\xdc\x00\xdd\x00\x6a\x00\x6b\x00\x6c\x00\x47\x00\xe1\x00\xe2\x00\x62\x00\x47\x00\xe5\x00\xe6\x00\x74\x00\x40\x00\xdf\x00\x77\x00\x7a\x00\x65\x00\x45\x00\x16\x00\xef\x00\x7a\x00\xf1\x00\xf3\x00\xf4\x00\xf5\x00\xeb\x00\x4e\x00\xed\x00\x47\x00\x47\x00\xfb\x00\xfb\x00\xfd\x00\xfe\x00\xcf\x00\xd0\x00\xf6\x00\x47\x00\xf8\x00\xf9\x00\xfa\x00\x7a\x00\xfc\x00\xd8\x00\xd9\x00\xff\x00\x00\x01\xdc\x00\xdd\x00\x9a\x00\xe1\x00\xe2\x00\x1a\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\x70\x00\x4b\x00\x19\x00\x66\x00\x4a\x00\x19\x00\xef\x00\xf0\x00\xf1\x00\x4a\x00\x6c\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\x54\x00\x6d\x00\x66\x00\xfb\x00\x66\x00\xfb\x00\x4a\x00\xfd\x00\xfe\x00\x4a\x00\x62\x00\x01\x01\x7b\x00\x47\x00\x47\x00\x05\x01\x06\x01\x07\x01\x08\x01\x90\x00\x91\x00\x92\x00\x93\x00\x4b\x00\x4a\x00\x54\x00\x97\x00\x6c\x00\x66\x00\x9a\x00\x22\x00\x9c\x00\x9d\x00\x66\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x5e\x00\x6c\x00\x4a\x00\x49\x00\x17\x00\x6b\x00\xe1\x00\xe2\x00\x4b\x00\x50\x00\xe5\x00\xe6\x00\x6c\x00\x6c\x00\x5e\x00\x62\x00\x66\x00\x66\x00\x66\x00\x40\x00\xef\x00\x66\x00\xf1\x00\x4a\x00\x45\x00\x66\x00\x6c\x00\x66\x00\x22\x00\x66\x00\xd5\x00\xd6\x00\xfb\x00\x4e\x00\x66\x00\xda\x00\x0c\x00\xdc\x00\xdd\x00\xcd\x00\xce\x00\xcf\x00\xd0\x00\x31\x00\x6d\x00\x6c\x00\x6b\x00\x5b\x00\x5e\x00\x66\x00\xd8\x00\xd9\x00\x64\x00\x66\x00\xdc\x00\xdd\x00\x6c\x00\x68\x00\x40\x00\xf2\x00\x66\x00\x66\x00\xf5\x00\x45\x00\x46\x00\x66\x00\x6d\x00\x66\x00\xfb\x00\x6d\x00\x66\x00\xfe\x00\x66\x00\x6d\x00\x15\x00\x6d\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\x4e\x00\x6b\x00\x0d\x00\x50\x00\x47\x00\xfb\x00\x47\x00\xfd\x00\xfe\x00\x47\x00\x7b\x00\x01\x01\x49\x00\x4a\x00\x6c\x00\x05\x01\x06\x01\x07\x01\x08\x01\x90\x00\x91\x00\x92\x00\x93\x00\x62\x00\x55\x00\x56\x00\x97\x00\x64\x00\x6c\x00\x9a\x00\x5b\x00\x9c\x00\x9d\x00\x66\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x68\x00\x8b\x00\x8b\x00\x8b\x00\x66\x00\x64\x00\x66\x00\x6d\x00\x8d\x00\x62\x00\x0d\x00\x71\x00\x72\x00\x4a\x00\x6c\x00\x75\x00\x76\x00\x90\x00\x91\x00\x92\x00\x93\x00\x4e\x00\x47\x00\x66\x00\x97\x00\x66\x00\x66\x00\x9a\x00\x22\x00\x9c\x00\x9d\x00\x66\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xcd\x00\xce\x00\xcf\x00\xd0\x00\x66\x00\x50\x00\x42\x00\x54\x00\x7a\x00\x4e\x00\x47\x00\xd8\x00\xd9\x00\x47\x00\x47\x00\xdc\x00\xdd\x00\x47\x00\x50\x00\x40\x00\x4b\x00\x61\x00\x6c\x00\x70\x00\x45\x00\x4b\x00\x1f\x00\x47\x00\x47\x00\x6b\x00\x5e\x00\x13\x00\x95\x00\x4e\x00\x6b\x00\x34\x00\x95\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\x18\x00\x11\x00\x65\x00\xfb\x00\x95\x00\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\x23\x00\xdc\x00\xdd\x00\x05\x01\x06\x01\x07\x01\x08\x01\x61\x00\x6c\x00\x6c\x00\x7a\x00\x95\x00\x51\x00\x95\x00\x4f\x00\x5d\x00\x7a\x00\x9a\x00\x7b\x00\x4f\x00\x7a\x00\x62\x00\x95\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xa4\x00\xa5\x00\x47\x00\xa7\x00\x47\x00\xfb\x00\x54\x00\xfd\x00\xfe\x00\x4a\x00\x0c\x00\x01\x01\x00\x00\x0c\x00\x13\x00\x05\x01\x06\x01\x07\x01\x08\x01\x90\x00\x91\x00\x92\x00\x93\x00\x0c\x00\xff\xff\xff\xff\x97\x00\xff\xff\x95\x00\x9a\x00\x22\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x2f\x00\x30\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\x40\x00\xff\xff\xd2\x00\xd3\x00\xd4\x00\x45\x00\xd6\x00\xff\xff\xff\xff\x22\x00\xda\x00\xff\xff\xdc\x00\xdd\x00\x4e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xf2\x00\xdc\x00\xdd\x00\xf5\x00\xff\xff\x40\x00\x6a\x00\x6b\x00\x6c\x00\xfb\x00\x45\x00\xff\xff\xfe\x00\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\x49\x00\xff\xff\xff\xff\x05\x01\x06\x01\x07\x01\x08\x01\x90\x00\x91\x00\x92\x00\x93\x00\xff\xff\x55\x00\x56\x00\x97\x00\x9a\x00\xff\xff\x9a\x00\x5b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\x75\x00\x76\x00\x90\x00\x91\x00\x92\x00\x93\x00\x22\x00\xff\xff\xff\xff\x97\x00\xff\xff\xff\xff\x9a\x00\xff\xff\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\x45\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xfb\x00\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x05\x01\x06\x01\x07\x01\x08\x01\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\x30\x00\xff\xff\xff\xff\x05\x01\x06\x01\x07\x01\x08\x01\x97\x00\xff\xff\xff\xff\x9a\x00\xff\xff\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xdf\x00\xff\xff\x30\x00\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\xeb\x00\x73\x00\xed\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf6\x00\xff\xff\xf8\x00\xf9\x00\xfa\x00\xff\xff\xfc\x00\xff\xff\xff\xff\xff\x00\x00\x01\x30\x00\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xd8\x00\xd9\x00\x9a\x00\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\x30\x00\x9a\x00\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\x6a\x00\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x9a\x00\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\x9a\x00\x6a\x00\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\xfb\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xe1\x00\xe2\x00\xfb\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\x9a\x00\x39\x00\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xe1\x00\xe2\x00\x01\x01\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x39\x00\xff\xff\xff\xff\xfb\x00\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x39\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xd3\x00\xd4\x00\xff\xff\xd6\x00\xef\x00\xf0\x00\xf1\x00\xda\x00\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xfb\x00\x9a\x00\x6f\x00\x39\x00\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf2\x00\xff\xff\xff\xff\xf5\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xfb\x00\xff\xff\x6f\x00\xfe\x00\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xfb\x00\x73\x00\x9a\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\xe1\x00\xe2\x00\xfb\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xcf\x00\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xfb\x00\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\x6a\x00\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\x77\x00\xff\xff\xff\xff\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xff\xff\xff\xff\xff\x00\x00\x01\x9a\x00\xff\xff\xff\xff\x04\x01\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\x49\x00\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\x7b\x00\x55\x00\x56\x00\x9a\x00\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x6d\x00\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\x9a\x00\xcf\x00\x75\x00\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\x9a\x00\xff\xff\x9a\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xfb\x00\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\x04\x01\xff\xff\xff\xff\xef\x00\xff\xff\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xcf\x00\xff\xff\xcf\x00\xd0\x00\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xfb\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\x04\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\x66\x00\x67\x00\x01\x01\x04\x01\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\xff\xff\x71\x00\x72\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\xff\xff\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\x66\x00\xff\xff\xff\xff\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xd2\x00\xd3\x00\xd4\x00\xff\xff\xd6\x00\xff\xff\xff\xff\x9a\x00\xda\x00\x66\x00\xdc\x00\xdd\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf2\x00\xcf\x00\x9a\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xff\xff\xfe\x00\xff\xff\x00\x01\xff\xff\xff\xff\xff\xff\x04\x01\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xcf\x00\x9a\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\x66\x00\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xfb\x00\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\x66\x00\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\x66\x00\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x49\x00\x4a\x00\xff\xff\xff\xff\xff\xff\xcf\x00\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xcf\x00\x9a\x00\xff\xff\xff\xff\x6d\x00\xef\x00\xf0\x00\xf1\x00\x71\x00\x72\x00\xff\xff\xff\xff\x75\x00\x76\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xcf\x00\xff\xff\x6a\x00\x6b\x00\x6c\x00\xef\x00\xf0\x00\xf1\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xfb\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\x66\x00\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xfb\x00\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\x9a\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\x02\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x9a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\xfb\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\x00\x00\x01\x00\x02\x00\x03\x00\xff\xff\xef\x00\xf0\x00\xf1\x00\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\x6e\x00\x6f\x00\xff\xff\xff\xff\x72\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x60\x00\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\x6b\x00\x9a\x00\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\x6e\x00\x6f\x00\xff\xff\xcf\x00\x72\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x9a\x00\x6e\x00\x6f\x00\xfb\x00\xff\xff\x72\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\x6e\x00\x6f\x00\xff\xff\xff\xff\x72\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x77\x00\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x67\x00\xcf\x00\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\x6e\x00\x6f\x00\xff\xff\x9a\x00\x72\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xfb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xcf\x00\xff\xff\xff\xff\xfb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xff\xff\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe1\x00\xe2\x00\xfb\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x08\x00\xfb\x00\x0a\x00\x0b\x00\x0c\x00\xff\xff\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\xff\xff\x14\x00\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\xff\xff\x14\x00\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\x05\x00\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\x0e\x00\x0f\x00\x10\x00\xff\xff\x12\x00\xff\xff\x14\x00\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\x05\x00\x06\x00\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\x0e\x00\x0f\x00\x10\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\x05\x00\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\x0e\x00\x0f\x00\x10\x00\xff\xff\x12\x00\xff\xff\x14\x00\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\x05\x00\x06\x00\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\x0e\x00\x0f\x00\x10\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\x0e\x00\x0f\x00\x10\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\x77\x00\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\x9a\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\x4c\x00\xff\xff\xef\x00\xff\xff\xf1\x00\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xfb\x00\x5b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\x68\x00\x69\x00\xff\xff\xff\xff\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\x68\x00\x69\x00\xff\xff\xff\xff\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\x0e\x00\x0f\x00\x10\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\x49\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\x50\x00\x36\x00\x37\x00\x38\x00\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\x41\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6c\x00\x52\x00\xff\xff\xff\xff\x55\x00\x71\x00\x72\x00\xff\xff\xff\xff\x75\x00\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5e\x00\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\x17\x00\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x79\x00\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\x9a\x00\x6b\x00\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x01\x00\x02\x00\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\x0a\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\x49\x00\x4a\x00\x4b\x00\xff\xff\xff\xff\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\x17\x00\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\x50\x00\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\x4e\x00\xff\xff\x66\x00\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\x5d\x00\xff\xff\x75\x00\x76\x00\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x01\x00\x02\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x01\x00\x02\x00\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\x0a\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\xff\xff\x71\x00\x72\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4d\x00\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\xff\xff\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\x9a\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x01\x00\x02\x00\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\x0a\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xcf\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xe1\x00\xe2\x00\x2c\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\xfb\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x79\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\xff\xff\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\x9a\x00\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x01\x00\x02\x00\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\x0a\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x01\x00\x02\x00\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\x0a\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\xff\xff\x71\x00\x72\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\x9a\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x01\x00\x02\x00\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\x0a\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xcf\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xe1\x00\xe2\x00\x2c\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x01\x00\x02\x00\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\x0a\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\xff\xff\x71\x00\x72\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\x9a\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x01\x00\x02\x00\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\x0a\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xcf\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xe1\x00\xe2\x00\x2c\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\x52\x00\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\xff\xff\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x01\x00\x02\x00\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\x0a\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xd7\x00\xff\xff\xd9\x00\xff\xff\xff\xff\xdc\x00\xff\xff\xff\xff\xdf\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xea\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\xf2\x00\xff\xff\xff\xff\xf5\x00\xff\xff\xff\xff\xff\xff\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\x9a\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x01\x00\x02\x00\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\xff\xff\x8c\x00\x0a\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xcf\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xe1\x00\xe2\x00\x2c\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\x49\x00\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x52\x00\x7a\x00\x7b\x00\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x9a\x00\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xfb\x00\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\x68\x00\xff\xff\xff\xff\xff\xff\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x11\x00\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\x49\x00\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x52\x00\xff\xff\x7b\x00\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x9a\x00\x74\x00\x75\x00\x76\x00\xff\xff\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xfb\x00\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\x49\x00\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x52\x00\xff\xff\x7b\x00\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x9a\x00\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xfb\x00\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\x49\x00\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x52\x00\xff\xff\x7b\x00\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x9a\x00\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xfb\x00\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\x49\x00\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x52\x00\xff\xff\x7b\x00\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x9a\x00\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xfb\x00\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x11\x00\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\x49\x00\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x9a\x00\x74\x00\x75\x00\x76\x00\xff\xff\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xfb\x00\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\x6e\x00\x6f\x00\x49\x00\xff\xff\x72\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x9a\x00\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xfb\x00\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\x6e\x00\x6f\x00\x49\x00\xff\xff\x72\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x9a\x00\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xfb\x00\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\x49\x00\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x9a\x00\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xfb\x00\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\x6e\x00\x6f\x00\x49\x00\xff\xff\x72\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x9a\x00\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xfb\x00\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\x6e\x00\x6f\x00\x49\x00\xff\xff\x72\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x9a\x00\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xfb\x00\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\x49\x00\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x9a\x00\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xfb\x00\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\x6e\x00\x6f\x00\x49\x00\xff\xff\x72\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x9a\x00\x74\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xfb\x00\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\x75\x00\x76\x00\xff\xff\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\x02\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x0a\x00\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x3b\x00\x3c\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\x75\x00\x76\x00\xff\xff\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\x6f\x00\x70\x00\xff\xff\xff\xff\xff\xff\x74\x00\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\x49\x00\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x9a\x00\x74\x00\x75\x00\x76\x00\xff\xff\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xfb\x00\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\x75\x00\x76\x00\xff\xff\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\xff\xff\x02\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x0a\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x3b\x00\x3c\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\x54\x00\xff\xff\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\xff\xff\x72\x00\xff\xff\x74\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\x65\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\x6f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\x49\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\x7d\x00\xff\xff\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x9a\x00\x72\x00\xff\xff\x74\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7a\x00\x7b\x00\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\x16\x00\xff\xff\x93\x00\x94\x00\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xcf\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\xff\xff\xff\xff\x56\x00\xfb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x6f\x00\x70\x00\xff\xff\xff\xff\xff\xff\x74\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7a\x00\x7b\x00\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\xff\xff\xff\xff\x93\x00\x94\x00\x82\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\xff\xff\x82\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\xff\xff\x82\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\x9a\x00\xff\xff\xff\xff\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xcf\x00\x9a\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xfb\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x82\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\xff\xff\x82\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xcf\x00\x9a\x00\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xfb\x00\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\x9a\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xff\xff\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xfb\x00\x6a\x00\x6b\x00\x6c\x00\xff\xff\xef\x00\xf0\x00\xf1\x00\x71\x00\xff\xff\x73\x00\xcf\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xfb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xcf\x00\x6a\x00\x6b\x00\x6c\x00\xff\xff\xef\x00\xf0\x00\xf1\x00\x71\x00\xff\xff\x73\x00\x9a\x00\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xfb\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\xef\x00\xf0\x00\xf1\x00\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xfb\x00\x6a\x00\x6b\x00\x6c\x00\xff\xff\x9a\x00\xff\xff\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xfb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xfb\x00\x6a\x00\x6b\x00\x6c\x00\xff\xff\xef\x00\xf0\x00\xf1\x00\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xfb\x00\x6a\x00\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\xff\xff\x73\x00\xff\xff\x75\x00\x76\x00\x77\x00\x9a\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\x70\x00\x6a\x00\x6b\x00\x6c\x00\x74\x00\xff\xff\xff\xff\x77\x00\x9a\x00\xff\xff\xff\xff\x74\x00\xff\xff\xff\xff\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\x8b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xfb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xfb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xef\x00\xf0\x00\xf1\x00\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xe1\x00\xe2\x00\xfb\x00\x02\x00\xe5\x00\xe6\x00\xff\xff\xef\x00\xff\xff\xf1\x00\xff\xff\x0a\x00\xff\xff\xff\xff\xef\x00\xff\xff\xf1\x00\xff\xff\xff\xff\xfb\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xfb\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x02\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x0a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x65\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x6f\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\x9a\x00\x2c\x00\x7a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x02\x00\xa4\x00\xa5\x00\xff\xff\x65\x00\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\x7a\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\x65\x00\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\x6f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7a\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xfb\x00\x5b\x00\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\x61\x00\xff\xff\x02\x00\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\x6d\x00\xff\xff\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\xff\xff\x02\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\x6d\x00\xff\xff\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\x13\x00\x76\x00\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x02\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x0a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\x2f\x00\xff\xff\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\x2f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6c\x00\xff\xff\xff\xff\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x02\x00\xff\xff\xff\xff\xff\xff\x65\x00\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\x16\x00\xff\xff\x18\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\x48\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\x70\x00\xff\xff\x16\x00\x73\x00\x74\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\x02\x00\xff\xff\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\x65\x00\x0a\x00\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\x70\x00\xff\xff\x16\x00\x73\x00\x74\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x02\x00\xff\xff\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\x65\x00\x0a\x00\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\x70\x00\xff\xff\x16\x00\xff\xff\x74\x00\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\x70\x00\x16\x00\xff\xff\x73\x00\x74\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x02\x00\xff\xff\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x65\x00\x0a\x00\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\x70\x00\xff\xff\x16\x00\xff\xff\x74\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x02\x00\xff\xff\x04\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\x70\x00\xff\xff\xff\xff\x73\x00\x74\x00\x16\x00\xff\xff\x18\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\x70\x00\x16\x00\xff\xff\xff\xff\x74\x00\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\xff\xff\xff\xff\x16\x00\x73\x00\x48\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x02\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\x65\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\x6f\x00\xff\xff\xff\xff\x1a\x00\x73\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\xff\xff\x49\x00\xff\xff\x73\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x55\x00\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x02\x00\xff\xff\xff\xff\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\x0a\x00\xff\xff\x6c\x00\xff\xff\xff\xff\x6f\x00\x70\x00\x71\x00\x72\x00\x13\x00\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x02\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x0a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\x70\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x0a\x00\xff\xff\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\x6f\x00\x70\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x02\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x0a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\x70\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x0a\x00\xff\xff\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\x6f\x00\x70\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x02\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x0a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\x70\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x0a\x00\xff\xff\xff\xff\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\x6f\x00\x70\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x02\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x0a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x02\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x0a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x4a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\x6f\x00\x70\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5d\x00\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\x6f\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x02\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x0a\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x1a\x00\x6f\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x65\x00\xff\xff\x1a\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x6f\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x02\x00\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x6f\x00\x02\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x0a\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x02\x00\xff\xff\x65\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x0a\x00\xff\xff\x2c\x00\xff\xff\x6f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\x50\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x6f\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xaa\x00\xab\x00\xff\xff\x65\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xdf\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xec\x00\xff\xff\xee\x00\xff\xff\xaa\x00\xab\x00\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x01\x01\xff\xff\xff\xff\x04\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xdf\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xec\x00\xff\xff\xee\x00\xff\xff\xaa\x00\xab\x00\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x01\x01\xff\xff\xff\xff\x04\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\x9a\x00\xdf\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xec\x00\xff\xff\xee\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xf7\x00\xf8\x00\xff\xff\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x01\x01\xff\xff\xff\xff\x04\x01\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xb8\x00\xb9\x00\xba\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xaa\x00\xf3\x00\xf4\x00\xf5\x00\xff\xff\xaf\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xb4\x00\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\x02\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\x9a\x00\xdc\x00\xdd\x00\x9d\x00\xdf\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xec\x00\xff\xff\xee\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xf7\x00\xf8\x00\xff\xff\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x01\x01\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xaa\x00\xff\xff\xff\xff\xff\xff\xae\x00\xaf\x00\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\x9a\x00\xdc\x00\xdd\x00\xff\xff\xdf\x00\xff\xff\xff\xff\xff\xff\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xec\x00\xff\xff\xee\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xf7\x00\xf8\x00\xff\xff\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x01\x01\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\x9a\x00\xdc\x00\xdd\x00\xff\xff\xdf\x00\xff\xff\xff\xff\xff\xff\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xec\x00\xff\xff\xee\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xf7\x00\xf8\x00\xff\xff\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x01\x01\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\xff\xff\xdf\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xec\x00\xff\xff\xee\x00\xff\xff\xaa\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xf7\x00\xf8\x00\xff\xff\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xdf\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xec\x00\xff\xff\xee\x00\xff\xff\xaa\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xf7\x00\xf8\x00\xff\xff\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xdf\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xec\x00\xff\xff\xee\x00\xff\xff\xaa\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xf7\x00\xf8\x00\xff\xff\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xdf\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xec\x00\xff\xff\xee\x00\xff\xff\xaa\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xf7\x00\xf8\x00\xff\xff\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xdf\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xec\x00\xff\xff\xee\x00\xff\xff\xaa\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xf7\x00\xf8\x00\xff\xff\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xdf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xec\x00\xff\xff\xee\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xf7\x00\xf8\x00\xff\xff\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x01\x01\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xb1\x00\xb2\x00\xb3\x00\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xb8\x00\xb9\x00\xba\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xb5\x00\xb6\x00\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xc2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xb8\x00\xb9\x00\xba\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xb5\x00\xb6\x00\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xc2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xc2\x00\xff\xff\xff\xff\xff\xff\xc6\x00\xff\xff\xc8\x00\xc9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xc2\x00\xff\xff\xff\xff\xff\xff\xc6\x00\xff\xff\xc8\x00\xc9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xc2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xc7\x00\xc8\x00\xc9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xb3\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xc2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xc2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc8\x00\xc9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xbe\x00\xbf\x00\xc0\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc8\x00\xc9\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xba\x00\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xc1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xc2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xc1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xc1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xc1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\xff\xff\xdc\x00\xdd\x00\x9a\x00\xff\xff\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\x9c\x00\x9d\x00\xff\xff\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\x9a\x00\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\x9a\x00\xff\xff\xc3\x00\xc4\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc3\x00\xc4\x00\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc3\x00\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\x9a\x00\xdc\x00\xdd\x00\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\x9a\x00\xdc\x00\xdd\x00\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\x9a\x00\xdc\x00\xdd\x00\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xd8\x00\xd9\x00\x01\x01\x9a\x00\xdc\x00\xdd\x00\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\x9a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xd0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xd9\x00\xff\xff\xff\xff\xdc\x00\xdd\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x00\xff\xff\xfd\x00\xfe\x00\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

happyTable :: HappyAddr
happyTable = HappyA# "\x00\x00\x94\x04\xff\x00\x00\x01\x01\x01\x25\x00\x26\x00\x02\x01\xfe\x04\xff\x04\x41\x04\xf7\x04\x27\x00\xe3\x04\x28\x00\x8a\x04\x05\x01\x00\x04\xb9\x03\x6a\x02\x01\x03\x63\x01\x02\x05\x2c\x03\xda\x04\xf0\x04\x3f\x04\x40\x04\x41\x04\xff\x02\xec\xff\x3a\x02\x06\x01\x07\x01\xec\x04\x3f\x04\x40\x04\x41\x04\x3e\x04\x3f\x04\x40\x04\x41\x04\xc1\x00\x90\x04\x08\x01\x09\x01\xd6\x00\xd7\x00\xd8\x00\xec\xff\x04\x03\x05\x03\x21\x04\x22\x04\x37\x02\x3a\x02\x03\x04\x54\x03\x58\x02\xbe\x02\xd9\x00\x24\x03\x32\x03\x45\x01\xae\x04\xe1\x01\xdb\x04\xda\x00\xdb\x00\x88\xfe\x3a\x02\x03\x05\xdc\x00\xb6\x04\x41\x04\x15\x03\x27\x03\xc2\x00\xc7\x02\x30\x03\x23\xfd\xcc\x02\xf3\x04\xfc\x03\xe0\x03\xdf\x03\xe0\x03\xc1\x04\x41\x04\xd0\x02\xf4\x04\x49\x04\x41\x04\xe6\x03\x23\xfd\xe4\x04\xd9\x03\x31\x02\x07\x02\xa5\x01\xba\x03\x61\x01\xe2\x04\xdd\x00\x2b\x00\x2d\x03\xf9\x00\x75\x00\x69\x04\x6a\x04\x67\x00\x16\x01\x46\x01\x33\x03\xc8\x02\x3a\x02\x3a\x02\xcd\x02\xe7\x03\xd4\xfe\x38\x02\xa7\x01\xd4\xfe\x04\x01\x2b\x03\xd1\x02\x08\x02\x3b\x02\xd6\xfe\xa4\x02\x25\x03\x0b\x03\x09\x02\xa7\x01\x91\x04\xdc\x01\xf9\x00\x79\x03\xe8\x04\x3a\x02\xf8\x01\x23\x04\x2c\x00\xbe\x02\x19\x01\x59\x02\x59\x02\xf9\x00\x7f\x00\xdf\x04\x4a\x04\x3b\x02\xde\x00\xdf\x00\xe0\x00\x4b\x04\x4c\x04\x8b\x04\x05\x01\xe1\x00\x3a\x02\x2c\x00\x82\x00\xfa\x02\xe2\x00\x85\x00\x3b\x02\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x06\x01\x07\x01\xfa\x00\xdc\x01\xe8\x04\xe2\x01\xe2\x01\x41\x00\x41\x00\x23\x04\xc1\x00\x16\x03\x08\x01\x09\x01\xd6\x00\xd7\x00\xd8\x00\x42\x00\x42\x00\x27\x01\x06\x03\x00\x03\xe9\x04\x18\x01\x95\x04\xbf\x02\x77\x02\x0f\x00\xd9\x00\x0f\x00\xfb\x02\x0f\x00\x6b\x02\x00\x03\x42\x00\xda\x00\xdb\x00\x3b\x02\x3b\x02\x0f\x00\xdc\x00\x91\x00\x92\x00\x6c\x02\x6d\x02\xc2\x00\x04\x04\xdc\x01\x44\x03\x6f\x04\x93\x00\x66\x00\xdc\x01\x2e\x03\x67\x00\x68\x00\x42\x00\xdc\x01\x2e\x03\xc4\x01\x6e\x00\x3b\x02\x6f\x00\x2e\x03\xbf\x02\x06\x03\x6e\x02\xe1\x03\x18\x01\xe1\x03\x0f\x00\xdd\x00\x79\x04\x0f\x00\x0f\x00\x0f\x00\xc5\x00\x94\x00\x0d\x00\xc6\x00\x04\x04\x42\x04\x3b\x02\x43\x04\x44\x04\x0f\x00\xef\x04\x70\x00\x71\x00\xbc\x02\x42\x00\x95\x00\x29\x00\x42\x03\x29\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\x42\x04\x06\x03\x43\x04\x44\x04\x18\x01\xf9\x01\x3b\x04\xdb\x01\x18\x01\x42\x04\x0f\x00\x43\x04\x44\x04\x42\x04\x0f\x00\x43\x04\x44\x04\x3a\x02\x27\x03\xe1\x01\x3a\x02\xde\x00\xdf\x00\xe0\x00\x6e\x02\x8c\x04\x04\x01\x05\x01\xe1\x00\x88\x02\x48\x04\x82\x00\x49\x04\xe2\x00\x85\x00\x48\x03\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x06\x01\x07\x01\x2d\x01\x42\x04\x88\x03\x43\x04\x44\x04\xd9\x01\xda\x01\xdb\x01\xc1\x00\x93\x04\x08\x01\x09\x01\xd6\x00\xd7\x00\xd8\x00\x42\x04\x2e\x01\x43\x04\x44\x04\x42\x04\xf9\x01\x43\x04\x44\x04\x18\x01\x49\x03\x89\x02\xd9\x00\xa7\x03\x28\x01\x0f\x00\x67\x00\x16\x01\xd2\x03\xda\x00\xdb\x00\x7e\x04\x49\x03\x7f\x04\xdc\x00\x91\x00\x92\x00\xf3\x02\x4d\x04\xc2\x00\x4e\x04\x3c\x00\x49\x03\xe1\x01\x93\x00\x66\x00\x4c\x03\xa1\x04\x67\x00\x68\x00\xd6\xfe\x29\x01\x99\x01\xa8\x03\x4f\x04\x0d\x00\x0e\x00\x0f\x00\xf6\x01\xe1\x01\x19\x01\xa4\x03\x0f\x00\x9a\x01\x3b\x02\xdd\x00\xaa\x04\x3b\x02\x4e\x02\x96\x02\xc5\x00\x94\x00\x0d\x00\xc6\x00\x4f\x02\x44\x03\x75\x00\xdc\x01\x71\x03\x0f\x00\x23\xfd\x70\x00\x71\x00\xdd\x01\xe2\x01\x95\x00\x41\x00\xca\x02\xbe\x04\xe3\x00\xe4\x00\xe5\x00\xe6\x00\x00\x05\xc8\x04\x4c\x04\x42\x00\xbf\x04\xfa\x00\x95\x03\x2b\x02\xe0\x01\xe1\x01\xf9\x00\x50\x02\x56\x01\x46\x04\xd7\x04\x67\x04\x68\x04\xe7\x04\x57\x01\xcb\x02\x59\x04\xde\x00\xdf\x00\xe0\x00\x7f\x00\x5a\x04\x0a\x01\x05\x01\xe1\x00\xdc\x01\xe8\x04\x82\x00\x93\x04\xe2\x00\x85\x00\xdd\x01\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x06\x01\x07\x01\x44\x03\x2c\x02\x0d\x00\x0e\x00\xe2\x01\x6e\x04\x41\x00\x78\x04\xc1\x00\x0f\x00\x08\x01\x09\x01\xd6\x00\xd7\x00\xd8\x00\x41\x03\x42\x00\x5f\x04\x6f\x04\xe2\x01\x79\x04\x41\x00\x1f\x01\x20\x01\xc8\x01\x3c\x00\xd9\x00\x15\x01\x42\x03\x67\x00\x16\x01\x42\x00\x75\x00\xda\x00\xdb\x00\xe2\x01\xc9\x01\x41\x00\xdc\x00\x91\x00\x92\x00\x8d\x04\x8e\x04\xc2\x00\x76\x00\x77\x00\x42\x00\x42\x00\x93\x00\x66\x00\x78\x00\x17\x01\x67\x00\x68\x00\x18\x01\x69\x04\x6a\x04\x67\x00\x16\x01\xae\x03\x0f\x00\x56\x01\x18\x01\x19\x01\x29\x02\x2a\x02\x2b\x02\x57\x01\x0f\x00\xdd\x00\x21\x01\x22\x01\x7e\x00\x7f\x00\xc5\x00\x94\x00\x0d\x00\xc6\x00\xe2\x01\x43\x03\x41\x00\x75\x00\x60\x04\x0f\x00\x70\x03\x70\x00\x71\x00\x74\x04\xb1\x02\x95\x00\x42\x00\x19\x01\x44\x03\xe3\x00\xe4\x00\xe5\x00\xe6\x00\x71\x03\xdc\x01\x58\x00\x67\x02\x3e\x00\x76\x04\x5b\x00\x6b\x04\x2c\x02\x0d\x00\x0e\x00\x79\x00\xca\x03\x56\x01\x41\x00\xbd\x04\x0f\x00\x7b\x00\xe2\x02\x57\x01\x7a\x04\xde\x00\xdf\x00\xe0\x00\x42\x00\x7f\x00\x7d\x00\x7b\x04\xe1\x00\x82\x00\x80\x00\x82\x00\xd0\x01\xe2\x00\x85\x00\xe3\x02\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x89\x04\xc1\x00\x8a\x04\x08\x01\x09\x01\xd6\x00\xd7\x00\xd8\x00\xf5\x01\x85\x04\x41\x00\x69\x04\xd8\x04\x67\x00\x16\x01\xea\x04\x1d\x01\x1e\x01\x8f\x03\xd9\x00\x42\x00\x4d\x04\x01\x05\x4e\x04\x3c\x00\x42\x00\xda\x00\xdb\x00\xbb\x04\x66\x00\xe8\x03\xdc\x00\x67\x00\x68\x00\x7c\x04\xa9\x03\xc2\x00\x4f\x04\x0d\x00\x0e\x00\xe9\x03\x91\x00\x92\x00\x96\x02\xbe\x01\x0f\x00\xbf\x01\x19\x01\x87\x04\xc0\x01\x93\x00\x66\x00\x23\x01\x20\x01\x67\x00\x68\x00\xf5\x03\x15\x01\x52\x02\x67\x00\x16\x01\xff\x03\xdd\x00\x00\x04\x53\x02\x70\x00\x71\x00\x66\x04\x67\x04\x68\x04\x64\x01\xc3\x01\x67\x00\x16\x01\x18\x01\x10\x04\xc5\x00\x94\x00\x0d\x00\xc6\x00\x0f\x00\x17\x01\x70\x00\x71\x00\x18\x01\x0f\x00\xdc\x01\x70\x00\x71\x00\xfe\x01\x0f\x00\x95\x00\x62\x04\x19\x01\x54\x02\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xff\x01\xc5\x04\xc6\x04\xc7\x04\xc8\x04\x4c\x04\xdc\xfe\x19\x01\x5f\x02\xdc\xfe\xfb\x03\x79\x00\xde\x00\xdf\x00\xe0\x00\x2b\x01\x0f\x00\x7b\x00\x05\x04\xe1\x00\xa3\x02\x23\xfd\x82\x00\xa4\x02\xe2\x00\x85\x00\x7d\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\xc1\x00\x25\x04\x08\x01\x09\x01\xd6\x00\xd7\x00\xd8\x00\x1f\x01\x20\x01\x1e\x04\xd7\x03\xf9\x00\x15\x01\x18\x01\x67\x00\x16\x01\xc2\x04\x07\x01\xd9\x00\x0f\x00\x69\x04\x6a\x04\x67\x00\x16\x01\x24\x04\xda\x00\xdb\x00\x6c\x04\x67\x04\x68\x04\xdc\x00\x0e\x02\x76\x00\x77\x00\x75\x00\xc2\x00\x17\x01\x0f\x00\x78\x00\x18\x01\x02\x03\x91\x00\x92\x00\x03\x03\x39\x04\x0f\x00\x76\x00\x77\x00\x19\x01\x0f\x00\x93\x00\x66\x00\x78\x00\x8f\x03\x67\x00\x68\x00\x19\x01\xd0\x04\x8f\x03\x4b\x00\x7e\x00\xdd\x00\xd5\x04\xdc\x01\x81\x00\x8b\x03\x76\x00\x77\x00\x69\x02\x6b\x04\x70\x02\x4d\x00\x78\x00\x9e\x03\x7e\x00\x7f\x00\xc5\x00\x94\x00\x0d\x00\xc6\x00\x8f\x03\x64\x00\xa0\x03\xdc\x01\x3c\x04\x0f\x00\x79\x00\x70\x00\x71\x00\xfb\x01\x2b\x01\x95\x00\x7b\x00\xbd\x03\x7e\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\x59\x00\x5a\x00\x7d\x00\xc5\x03\x5c\x00\x5d\x00\x8f\x03\x75\x00\xbf\x03\x5f\x02\x90\x03\xde\x00\xdf\x00\xe0\x00\x69\x04\x6a\x04\x67\x00\x16\x01\xe1\x00\x76\x00\x77\x00\x82\x00\xf5\x02\xe2\x00\x85\x00\x78\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\xc3\x04\x07\x01\xc1\x00\x60\x02\x08\x01\x09\x01\xd6\x00\xd7\x00\xd8\x00\x8b\x02\x7c\x00\x21\x04\x3e\x01\xbb\x01\x7e\x00\x7f\x00\xc7\x03\x19\x01\x81\x00\x82\x00\xd9\x00\xf0\x01\x58\x00\xb1\x02\xdc\x01\xf1\x01\x5b\x00\xda\x00\xdb\x00\x71\x01\x6b\x04\x72\x01\xdc\x00\x73\x01\x58\x00\x74\x01\xce\x03\xc2\x00\x5b\x00\xd4\x03\x5e\x02\x91\x00\x92\x00\x4d\x04\x58\x00\x4e\x04\x3c\x00\x04\x02\x5b\x00\xd1\x03\x93\x00\x66\x00\x1d\x02\x05\x02\x67\x00\x68\x00\x0f\x04\x1e\x03\x05\x02\x4f\x04\x0d\x00\x0e\x00\xb8\x04\xdd\x00\x0e\x02\xeb\x02\xa7\x01\x0f\x00\x38\x04\xec\x02\x0f\x00\xb9\x04\xb7\x01\x71\x00\x76\x00\x77\x00\xc5\x00\x94\x00\x0d\x00\xc6\x00\x78\x00\xba\x01\x73\x00\x8f\x02\x0e\x00\x0f\x00\xbb\x01\x70\x00\x71\x00\xdd\x03\x0f\x00\x95\x00\xb7\x01\x71\x00\xed\x03\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xea\x03\x6e\x01\x39\x00\x7e\x00\xba\x04\x3b\x00\x3c\x00\x81\x00\xbb\x04\x1f\x04\x3c\x00\x23\x01\x20\x01\xde\x00\xdf\x00\xe0\x00\x15\x01\xef\x03\x67\x00\x16\x01\xe1\x00\x94\x02\x1d\x04\x82\x00\x1e\x04\xe2\x00\x85\x00\x57\x01\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\xef\x02\x3f\x01\xf0\x03\x61\x02\xf0\x02\x17\x01\xbd\x04\xf0\x01\x18\x01\x3b\x00\x3c\x00\xf1\x01\xf1\x03\x40\x01\x0f\x00\x41\x01\x14\x01\x19\x01\x10\x02\x6e\x00\x15\x01\x6f\x00\x67\x00\x16\x01\x6b\x00\x8b\x02\x6c\x00\x6d\x00\x6e\x00\xbb\x01\x6f\x00\x65\x00\x66\x00\x72\x00\x73\x00\x67\x00\x68\x00\xe8\x02\x69\x00\xb6\x01\x0e\x00\x91\x00\x92\x00\x68\x01\x17\x01\x69\x01\x0f\x00\x18\x01\xb7\x01\x71\x00\x93\x00\x66\x00\x6a\x00\x0f\x00\x67\x00\x68\x00\x19\x01\xf6\x02\x0c\x00\x0d\x00\x0e\x00\x6b\x00\xf8\x02\x6c\x00\x6d\x00\x6e\x00\x0f\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\xe5\x02\x2c\x00\x2d\x00\x2e\x00\xc5\x00\x94\x00\x0d\x00\xc6\x00\xfb\x02\x6b\x02\x83\x02\x0d\x00\x0e\x00\x0f\x00\xd1\x04\x70\x00\x71\x00\x02\x03\x0f\x00\x95\x00\xa9\x03\x6d\x02\x0e\x03\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xc1\x00\x65\x01\xc4\x03\xe4\x02\xd6\x00\xd7\x00\xd8\x00\x0a\x02\x16\x03\xc4\x01\x6e\x00\x05\x02\x6f\x00\x86\x02\x0d\x00\x0e\x00\x6e\x02\xc9\x03\xd9\x00\xca\x03\xaf\x02\x0f\x00\x36\x00\x3b\x00\x3c\x00\xda\x00\xdb\x00\xb9\x01\x88\x01\x6e\x00\xdc\x00\x6f\x00\x89\x02\x0d\x00\x0e\x00\xc2\x00\x75\x00\xb2\x01\x1a\x03\xc1\x00\x0f\x00\x1f\x03\xd5\x00\xd6\x00\xd7\x00\xd8\x00\xb2\x03\xb3\x03\x76\x00\x77\x00\xb3\x01\xb4\x01\xb5\x01\xb6\x01\x78\x00\x29\x03\x20\x02\xd9\x00\x5b\x02\x3f\x01\x05\x02\xdd\x00\x57\x01\x67\x02\xda\x00\xdb\x00\xc2\x02\x57\x01\x29\x03\xdc\x00\xc3\x02\x40\x01\x7c\x00\x41\x01\xc2\x00\x45\x03\x7e\x00\x7f\x00\x46\x03\xf0\x01\x81\x00\x82\x00\x6b\x00\xf1\x01\x6c\x00\x6d\x00\x6e\x00\x4f\x03\x6f\x00\x62\x03\xd2\x04\x72\x00\x73\x00\x38\x00\x39\x00\xe7\x01\x71\x03\x3b\x00\x3c\x00\xd6\xfe\xdd\x00\x33\x04\x34\x04\x35\x04\x88\x01\x75\x03\x36\x04\x3f\x00\x57\x01\x41\x00\xde\x00\xdf\x00\xe0\x00\x0f\x01\x0d\x00\x0e\x00\xd0\x03\xe1\x00\xd1\x03\x42\x00\x82\x00\x0f\x00\xe2\x00\x85\x00\x6e\x02\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x11\x01\x0d\x00\x0e\x00\x4c\x00\xec\x03\x6e\x01\x39\x00\x4e\x00\x0f\x00\x3b\x00\x3c\x00\x58\x01\x59\x01\x5a\x01\x5b\x01\x37\x02\x5c\x01\xde\x00\xdf\x00\xe0\x00\x15\x01\x79\x03\x67\x00\x16\x01\xe1\x00\x67\x02\x3e\x00\x82\x00\xc1\x00\xe2\x00\x85\x00\xe3\x02\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\xc3\x02\xc4\x02\x91\x00\x92\x00\x8a\x03\x17\x01\x07\x04\x08\x04\x18\x01\x24\x01\x25\x01\x93\x00\x66\x00\xee\x01\x0f\x00\x67\x00\x68\x00\x19\x01\x35\x02\xdc\x00\x0c\x00\x0d\x00\x0e\x00\xf9\x00\xc2\x00\xfb\x00\xfc\x00\x3b\x02\x0f\x00\x09\x04\x0a\x04\xb7\x02\xb8\x02\xb9\x02\xba\x02\xbb\x02\x46\x02\xc5\x00\x94\x00\x0d\x00\xc6\x00\x91\x00\x92\x00\x11\x03\x12\x03\x13\x03\x0f\x00\x5b\x02\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\xcc\x01\x67\x00\x68\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\x35\x01\x36\x01\x37\x01\x38\x01\x97\x02\x6d\x01\x6e\x01\x39\x00\x65\x01\x66\x01\x3b\x00\x3c\x00\x10\x02\x6e\x00\xa5\x02\x6f\x00\xc5\x00\x94\x00\x0d\x00\xc6\x00\x6f\x01\x48\x02\x41\x00\x49\x02\x68\x01\x0f\x00\x69\x01\x70\x00\x71\x00\x5e\x01\x5f\x01\x95\x00\x42\x00\x61\x01\x5f\x01\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xde\x00\xdf\x00\x79\x02\x0b\x04\x1c\x03\x1d\x03\x1e\x03\xe1\x00\x65\x01\xa1\x01\x82\x00\xc1\x00\x7b\x02\x85\x00\xa9\x02\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x7c\x02\x9f\x02\xa0\x02\xa1\x02\x75\x00\x43\x01\xef\xfe\x07\x04\x08\x04\xef\xfe\x79\x01\xb5\x02\x7a\x01\xd4\x02\x6e\x01\x39\x00\x76\x00\x77\x00\x3b\x00\x3c\x00\xdc\x00\x75\x00\x78\x00\xfb\x03\xbb\x02\xc2\x00\xd9\x02\xa0\x02\xa1\x02\xc1\x00\x09\x04\x0e\x04\xc8\x02\x76\x00\x77\x00\x9e\x01\x68\x01\x9f\x01\x69\x01\x78\x00\x7c\x00\xd1\x02\x91\x00\x92\x00\x7e\x00\x7f\x00\x07\x04\x08\x04\x81\x00\x82\x00\xce\x02\x93\x00\x66\x00\x63\x01\x5f\x01\x67\x00\x68\x00\x7c\x00\x9e\x01\xdc\x00\x9f\x01\x7e\x00\x7f\x00\xdb\x02\xc2\x00\x81\x00\x82\x00\xeb\x01\x07\x01\x9c\x04\xd5\x02\x6e\x01\x39\x00\xec\x01\x07\x01\x3b\x00\x3c\x00\xc5\x00\x94\x00\x0d\x00\xc6\x00\xa3\x04\xe1\x04\xa3\x04\xa4\x04\xdd\x02\x0f\x00\xde\x02\x70\x00\x71\x00\x2e\x04\x2f\x04\x95\x00\x75\x00\x9f\x04\x2b\x01\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xde\x00\xdf\x00\x79\x02\x0b\x04\x0c\x01\x76\x00\x77\x00\xe1\x00\xe7\x02\xe8\x02\x82\x00\x78\x00\x7b\x02\x85\x00\x33\x01\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x7c\x02\x43\x01\xb9\x01\x88\x01\x6e\x00\x6b\x01\x6f\x00\x77\x01\x7c\x00\xba\x01\x73\x00\x9c\x01\x7e\x00\x7f\x00\xbb\x01\xb8\x01\x81\x00\x82\x00\xde\x00\xdf\x00\x79\x02\x0b\x04\x10\x03\x11\x03\xe8\x01\xe1\x00\xe7\x02\xe8\x02\x82\x00\xc1\x00\x7b\x02\x85\x00\xfd\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x7c\x02\xa0\x01\xfa\x00\x91\x00\x92\x00\x11\x04\xa8\x01\xbf\x03\x8a\x03\xd7\x02\x6e\x01\x39\x00\x93\x00\x66\x00\x3b\x00\x3c\x00\x67\x00\x68\x00\x05\x05\xf2\x04\xdc\x00\xbf\x03\xc1\x03\xa4\xfe\xf7\x04\xc2\x00\x12\x04\x13\x04\xf9\x00\xfc\x04\xfd\x04\xfe\x04\xf2\x01\x2c\x00\x2d\x00\x2e\x00\xc5\x04\xcb\x04\xc5\x00\x94\x00\x0d\x00\xc6\x00\x91\x00\x92\x00\xcc\x04\xe5\x01\x35\x00\x0f\x00\xd4\x04\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\xcd\x04\x67\x00\x68\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xce\x04\xcf\x04\xfa\x00\xd5\x04\x1c\x03\xe6\x04\xec\x04\xfa\x00\xef\x04\xee\x04\xa6\x04\xa8\x04\xa7\x04\xae\x04\xa9\x04\xac\x04\xc5\x00\x94\x00\x0d\x00\xc6\x00\x36\x00\xb4\x04\xaa\x04\xb5\x04\xc1\x04\x0f\x00\xad\x04\x70\x00\x71\x00\xff\x00\x56\x04\x95\x00\x57\x04\x58\x04\xa7\x01\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xde\x00\xdf\x00\x79\x02\x14\x04\x27\x03\xbf\x03\x62\x04\xe1\x00\x76\x04\x46\x01\x82\x00\xc1\x00\x7b\x02\x85\x00\x80\x04\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x7c\x02\x96\x04\x97\x04\x84\x04\x87\x04\x11\x04\xf3\x03\xf4\x03\xf5\x03\xf7\x03\xf8\x03\xf9\x03\xfa\x03\x07\x04\xfe\x03\x2c\x00\x2d\x00\x2e\x00\x03\x04\xbf\x03\xdc\x00\xbf\x03\xf9\x00\xc1\x03\x27\x04\xc2\x00\x12\x04\x18\x04\xd1\x04\x29\x04\x45\x03\x38\x00\x39\x00\x28\x04\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x30\x04\x37\x02\xf9\x00\x91\x00\x92\x00\x3b\x04\x3f\x00\x40\x00\x41\x00\xfa\x00\x39\x04\x3e\x04\x93\x00\x66\x00\x46\x04\x9c\x03\x67\x00\x68\x00\x42\x00\xfa\x00\x92\x03\x2c\x00\x2d\x00\x2e\x00\x36\x00\x9d\x03\x64\x03\x8d\x03\xb3\x02\x93\x03\x2f\x01\x94\x03\x33\x00\x34\x00\x35\x00\xa0\x03\xa3\x03\xae\x03\xc5\x00\x94\x00\x0d\x00\xc6\x00\xb7\x03\xb9\x03\xbd\x03\xc1\x03\xbf\x03\x0f\x00\xc2\x03\x70\x00\x71\x00\x5e\x00\xc4\x03\x95\x00\x27\x03\xc7\x03\xcd\x03\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xde\x00\xdf\x00\x79\x02\x14\x04\xd6\x03\x5d\xfd\x5b\xfd\xe1\x00\x36\x00\x5c\xfd\x82\x00\xc1\x00\x7b\x02\x85\x00\xd9\x03\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x7c\x02\xdb\x03\xdc\x03\x7d\x01\x66\x00\xdf\x03\xdd\x03\x67\x00\x68\x00\x2c\x00\x2d\x00\x2e\x00\xea\x03\x38\x00\x39\x00\xe5\x03\xec\x03\x3b\x00\x3c\x00\xfa\x04\xdc\x00\x3f\x01\xb1\x04\xef\x03\x8d\x03\xc2\x00\xea\x02\x3f\x00\xf8\x02\x41\x00\x7e\x01\x0d\x00\x0e\x00\x94\x02\x78\x02\x41\x01\xee\x02\xf1\x02\x0f\x00\x42\x00\x70\x00\x71\x00\x91\x00\x92\x00\x6b\x00\xf2\x02\x6c\x00\x6d\x00\x6e\x00\x27\x01\x6f\x00\x93\x00\x66\x00\x72\x00\x73\x00\x67\x00\x68\x00\x36\x00\x38\x00\x39\x00\xfd\x02\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x7d\x00\x0e\x03\x18\x03\x1a\x03\x1c\x03\x21\x03\x3f\x00\x40\x00\x41\x00\x29\x03\x65\xfd\xc5\x00\x94\x00\x0d\x00\xc6\x00\x2c\x03\x35\x03\x38\x03\x42\x00\x39\x03\x0f\x00\x3a\x03\x70\x00\x71\x00\x3d\x03\x3b\x03\x95\x00\x3c\x03\x3e\x03\x3f\x03\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xde\x00\xdf\x00\x79\x02\x7a\x02\x45\x03\x4b\x03\x4d\x03\xe1\x00\x4e\x03\x02\x02\x82\x00\xc1\x00\x7b\x02\x85\x00\x06\x02\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x7c\x02\x4f\x03\x57\x01\x64\x03\x6e\x03\x75\x03\x37\x02\x38\x00\x39\x00\x7b\x03\x78\x03\x3b\x00\x3c\x00\x77\x03\x7c\x03\x7d\x03\x7e\x03\x3c\xfd\x3b\xfd\x50\xfd\xdc\x00\x3f\x00\x41\xfd\x41\x00\x8a\x03\xc2\x00\x42\xfd\x80\x03\x51\xfd\xc1\x00\x3a\xfd\xf4\x02\x20\x01\x42\x00\x80\x02\x7f\x03\x15\x01\xff\x00\x67\x00\x16\x01\x7d\x02\x7e\x02\x7f\x02\x92\x00\x11\x04\x81\x03\x87\x03\xf2\x01\xf8\x01\xfd\x01\x01\x02\x93\x00\x66\x00\x00\x02\x02\x02\x67\x00\x68\x00\x0c\x02\x0b\x02\xdc\x00\x17\x01\x03\x02\x06\x02\x18\x01\xc2\x00\xa4\x04\x1b\x02\x0d\x02\x1c\x02\x0f\x00\x0e\x02\x1e\x02\x19\x01\x1f\x02\x21\x02\x31\x02\x22\x02\xc5\x00\x94\x00\x0d\x00\xc6\x00\xa7\x01\x37\x02\x3d\x02\x3e\x02\x42\x02\x0f\x00\x43\x02\x70\x00\x71\x00\x44\x02\x45\x02\x95\x00\x75\x00\x43\x01\x4c\x02\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xde\x00\xdf\x00\x79\x02\x7a\x02\x4d\x02\x76\x00\x77\x00\xe1\x00\x51\x02\x4c\x02\x82\x00\x78\x00\x7b\x02\x85\x00\x55\x02\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x7c\x02\x58\x02\x5d\x02\x5f\x02\x63\x02\x65\x02\xd7\x01\x66\x02\x7c\x00\x64\x02\xd9\x01\x3d\x02\x7e\x00\x7f\x00\x83\x02\x8d\x02\x81\x00\x82\x00\xde\x00\xdf\x00\x79\x02\x14\x04\x8e\x02\x8f\x02\x1e\x02\xe1\x00\x52\xfd\x91\x02\x82\x00\xc1\x00\x7b\x02\x85\x00\x1f\x02\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x7c\x02\x81\x02\x7e\x02\x7f\x02\x92\x00\x93\x02\x96\x02\x46\x01\xa5\x02\x97\x02\xa7\x02\xab\x02\x93\x00\x66\x00\xac\x02\xad\x02\x67\x00\x68\x00\xae\x02\xe7\x01\xdc\x00\xb5\x02\xc6\x02\xce\x02\x58\x00\xc2\x00\xd7\x02\xdd\x02\xd9\x02\xdb\x02\xe0\x02\xe2\x02\x0c\x01\xff\xff\x81\x04\xe1\x02\x0e\x01\xff\xff\xc5\x00\x94\x00\x0d\x00\xc6\x00\x91\x00\x92\x00\x11\x01\x39\x01\x3a\x01\x0f\x00\xff\xff\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x3b\x01\x67\x00\x68\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\x61\x01\x66\xfd\x6a\x01\x27\x01\xff\xff\xab\x01\xff\xff\xac\x01\xad\x01\x98\x01\x82\x00\x6d\x01\xd9\xfd\x9b\x01\x90\x01\xff\xff\xc5\x00\x94\x00\x0d\x00\xc6\x00\x50\x03\x8c\x00\xdf\x01\x51\x03\xe0\x01\x0f\x00\xe8\x01\x70\x00\x71\x00\xe5\x01\xff\x00\x95\x00\xff\xff\xff\x00\xee\x01\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xde\x00\xdf\x00\x79\x02\x7a\x02\xff\x00\x00\x00\x00\x00\xe1\x00\x00\x00\xff\xff\x82\x00\xc1\x00\x7b\x02\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x7c\x02\x99\x04\x97\x04\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\xdc\x00\x00\x00\x35\x03\x5a\x01\x5b\x01\xc2\x00\x5c\x01\x00\x00\x00\x00\xc1\x00\x15\x01\x00\x00\x67\x00\x16\x01\x82\x04\x00\x00\x00\x00\x00\x00\x00\x00\x81\x01\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x17\x01\x67\x00\x68\x00\x18\x01\x00\x00\xdc\x00\x2c\x00\x2d\x00\x2e\x00\x0f\x00\xc2\x00\x00\x00\x19\x01\xb3\x02\x00\x00\x2f\x01\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\xc5\x00\x94\x00\x0d\x00\xc6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x75\x00\x00\x00\x00\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xde\x00\xdf\x00\x79\x02\x7a\x02\x00\x00\x76\x00\x77\x00\xe1\x00\x36\x00\x00\x00\x82\x00\x78\x00\x7b\x02\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x7c\x02\x56\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x57\x01\x00\x00\x00\x00\x00\x00\x00\x00\x7e\x00\x7f\x00\x00\x00\x00\x00\x81\x00\x82\x00\xde\x00\xdf\x00\x79\x02\xb1\x03\xc1\x00\x00\x00\x00\x00\xe1\x00\x00\x00\x00\x00\x82\x00\x00\x00\x7b\x02\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x7c\x02\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\xc2\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\xc5\x00\x94\x00\x0d\x00\xc6\x00\x91\x00\x92\x00\x00\x00\x42\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xf2\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc5\x00\x94\x00\x0d\x00\xc6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\xa0\x04\x00\x00\x00\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xc3\x00\x00\x00\x00\x00\x82\x00\x00\x00\xc4\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x3f\x01\x00\x00\x6f\x04\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb3\x02\x40\x01\x2f\x01\x41\x01\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x00\x00\x6c\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x72\x00\x73\x00\x79\x04\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x91\x00\x92\x00\xb3\x02\x00\x00\x2f\x01\x00\x00\x33\x00\x34\x00\x35\x00\x93\x00\x66\x00\x36\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x04\x00\x00\x2f\x01\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\xc5\x00\x94\x00\x0d\x00\xc6\x00\x00\x00\x00\x00\x00\x00\xb2\x02\x36\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb3\x02\x00\x00\x2f\x01\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x36\x00\x00\x00\x82\x00\xcf\x04\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x36\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb3\x02\x42\x00\x2f\x01\x00\x00\x33\x00\x34\x00\x35\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x38\x00\x39\x00\x42\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x36\x00\x9b\x04\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x42\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x38\x00\x39\x00\x95\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x03\x00\x00\x00\x00\x42\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x3c\x01\x00\x00\x3d\x01\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x02\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x36\x03\x5b\x01\x00\x00\x5c\x01\x3f\x00\x40\x00\x41\x00\x15\x01\x00\x00\x67\x00\x16\x01\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x42\x00\x36\x00\x3c\x01\x3b\x01\x3d\x01\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x17\x01\x00\x00\x00\x00\x18\x01\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x0f\x00\x00\x00\x3c\x01\x19\x01\x3d\x01\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x3c\x01\x00\x00\x3d\x01\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x0f\x02\x00\x00\x30\x00\x00\x00\x31\x00\x42\x00\x32\x00\x36\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x38\x00\x39\x00\x42\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x37\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\xce\x01\x42\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x03\x00\x00\x00\x00\x10\x02\x6e\x00\x42\x00\x6f\x00\x00\x00\x00\x00\xba\x01\x73\x00\x36\x00\x00\x00\x00\x00\xbb\x01\x2c\x00\x2d\x00\x2e\x00\xca\x01\x00\x00\x30\x00\x75\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\xcb\x01\x76\x00\x77\x00\x36\x00\x00\x00\x00\x00\x00\x00\x78\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\xce\x01\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x7c\x00\x00\x00\x00\x00\x00\x00\x7e\x00\x7f\x00\x36\x00\x37\x00\x81\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\xcf\x01\x3e\x00\x36\x00\x00\x00\x82\x00\x00\x00\x00\x00\x00\x00\xf5\x04\x40\x00\x41\x00\x91\x01\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x38\x00\x39\x00\x42\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x37\x00\xd0\x01\x00\x00\x00\x00\x3f\x00\x00\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x37\x00\x00\x00\x91\x00\x92\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x42\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\xcf\x01\x3e\x00\xcc\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x42\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x99\x02\x70\x02\x95\x00\xd0\x01\x2c\x00\x2d\x00\x2e\x00\x27\x02\x71\x02\x9a\x02\x00\x00\x31\x00\x73\x02\x9b\x02\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb4\x03\x00\x00\x00\x00\x5e\x04\x2c\x00\x2d\x00\x2e\x00\x27\x02\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\xb4\x03\x00\x00\x00\x00\xb5\x03\x2c\x00\x2d\x00\x2e\x00\x27\x02\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x8a\x02\x5a\x01\x5b\x01\x00\x00\x5c\x01\x00\x00\x00\x00\x36\x00\x15\x01\xb4\x03\x67\x00\x16\x01\xb7\x03\x2c\x00\x2d\x00\x2e\x00\x27\x02\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x17\x01\x9c\x02\x36\x00\x18\x01\x00\x00\x00\x00\x00\x00\x10\x02\x6e\x00\x0f\x00\x6f\x00\x00\x00\x19\x01\x00\x00\x8b\x02\x00\x00\x00\x00\x00\x00\xbb\x01\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x37\x00\x36\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x84\x02\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x27\x02\x42\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x18\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x84\x02\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x27\x02\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x85\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x84\x02\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x27\x02\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\xae\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\xd9\x04\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x27\x02\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x75\x00\x6b\x01\x00\x00\x00\x00\x00\x00\x37\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x76\x00\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x37\x00\x36\x00\x00\x00\x00\x00\x7c\x00\x3f\x00\x40\x00\x41\x00\x7e\x00\x7f\x00\x00\x00\x00\x00\x81\x00\x82\x00\x00\x00\x00\x00\x00\x00\x42\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x37\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x9d\x04\x00\x00\x2f\x01\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x42\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x3f\x03\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x27\x02\x42\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x36\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x02\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x27\x02\x00\x00\x30\x00\x00\x00\x31\x00\x11\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x36\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x42\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x3a\x02\x97\x00\x11\x00\x98\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\xe1\x04\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x71\x02\x72\x02\x00\x00\x00\x00\x73\x02\x74\x02\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xd4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3b\x02\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x6b\x03\x36\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x00\x00\x00\x00\x80\x04\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x71\x02\x72\x02\x00\x00\x75\x02\x73\x02\x74\x02\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x01\x04\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x36\x00\x71\x02\x72\x02\x42\x00\x00\x00\x73\x02\x74\x02\x00\x00\x33\x00\x34\x00\x35\x00\xaf\x03\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x71\x02\x72\x02\x00\x00\x00\x00\x73\x02\x74\x02\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x02\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x02\x75\x02\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x71\x02\x72\x02\x00\x00\x36\x00\x73\x02\x74\x02\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x75\x02\x00\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x02\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x38\x00\x39\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x75\x02\x00\x00\x00\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x00\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x42\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x97\x00\x11\x00\x98\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\x99\x00\x42\x00\x12\x00\x9a\x00\xff\x00\x00\x00\xc8\x00\xc9\x00\xca\x00\xec\x00\xcb\x00\x00\x00\xed\x00\x00\x00\x13\x00\x00\x00\xee\x00\x00\x00\x14\x00\xef\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\xf0\x00\x9f\x00\xcd\x00\xce\x00\xcf\x00\x00\x00\xf1\x00\xa0\x00\xa1\x00\xa2\x00\xf2\x00\xf3\x00\x00\x00\x00\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xd0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xf8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xd1\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\xc8\x00\xc9\x00\xca\x00\xec\x00\xcb\x00\x00\x00\xed\x00\x00\x00\x13\x00\x00\x00\xee\x00\x00\x00\x14\x00\xef\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\xf0\x00\x9f\x00\xcd\x00\xce\x00\xcf\x00\x00\x00\xf1\x00\xa0\x00\xa1\x00\xa2\x00\xf2\x00\xf3\x00\x00\x00\x00\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xd0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xf8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xd1\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x0d\x04\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\xc8\x00\xc9\x00\xca\x00\x00\x00\xcb\x00\x00\x00\xed\x00\x00\x00\x13\x00\x00\x00\x0e\x04\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\xf0\x00\x9f\x00\xcd\x00\xce\x00\xcf\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xf8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xd1\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x16\x04\x17\x04\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\xc8\x00\xc9\x00\xca\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x18\x04\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\xf0\x00\x9f\x00\xcd\x00\xce\x00\xcf\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xf8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xd1\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x0d\x04\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\xc8\x00\xc9\x00\xca\x00\x00\x00\xcb\x00\x00\x00\xed\x00\x00\x00\x13\x00\x00\x00\x0e\x04\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\xf0\x00\x9f\x00\xcd\x00\xce\x00\xcf\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xf8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xd1\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x16\x04\x17\x04\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\xc8\x00\xc9\x00\xca\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x18\x04\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\xf0\x00\x9f\x00\xcd\x00\xce\x00\xcf\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xf8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xd1\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\xc8\x00\xc9\x00\xca\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\xf0\x00\x9f\x00\xcd\x00\xce\x00\xcf\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xf8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xd1\x00\x00\x00\xaa\x00\x00\x00\xab\x00\xe9\x01\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x36\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x3f\x00\x00\x00\x41\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\x77\x00\x00\x00\x00\x00\x00\x00\x42\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x20\x02\xab\x00\x00\x00\x00\x00\x05\x02\x58\x01\xac\x00\x24\x00\x7d\x00\x7e\x00\x7f\x00\x25\x00\x80\x00\x81\x00\x82\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x1d\x02\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x05\x02\x58\x01\xac\x00\x24\x00\x7d\x00\x7e\x00\x7f\x00\x25\x00\x80\x00\x81\x00\x82\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\x55\x01\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x56\x01\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x57\x01\x58\x01\xac\x00\x24\x00\x7d\x00\x7e\x00\x7f\x00\x25\x00\x80\x00\x81\x00\x82\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x88\x01\xab\x00\x00\x00\x00\x00\x57\x01\x58\x01\xac\x00\x24\x00\x7d\x00\x7e\x00\x7f\x00\x25\x00\x80\x00\x81\x00\x82\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\x55\x01\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x56\x01\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x57\x01\x58\x01\xac\x00\x24\x00\x7d\x00\x7e\x00\x7f\x00\x25\x00\x80\x00\x81\x00\x82\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x05\x02\x58\x01\xac\x00\x24\x00\x7d\x00\x7e\x00\x7f\x00\x25\x00\x80\x00\x81\x00\x82\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x90\x01\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x58\x01\xac\x00\x24\x00\x7d\x00\x7e\x00\x7f\x00\x25\x00\x80\x00\x81\x00\x82\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x58\x01\xac\x00\x24\x00\x7d\x00\x7e\x00\x7f\x00\x25\x00\x80\x00\x81\x00\x82\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\xc8\x00\xc9\x00\xca\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x75\x00\xcc\x00\x9f\x00\xcd\x00\xce\x00\xcf\x00\x00\x00\xbd\x01\xa0\x00\xa1\x00\xa2\x00\x00\x00\x76\x00\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x00\xd0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x56\x01\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x57\x01\xa4\x00\x00\x00\x00\x00\xa5\x00\x7e\x00\x7f\x00\x00\x00\x00\x00\x81\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xd1\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xd4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x03\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x6b\x03\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x00\x00\x00\x00\x00\x00\x13\x00\x5d\x03\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xa6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x9e\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xa6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\x04\x00\x00\x2f\x01\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\xd6\x04\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xd4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x36\x00\x6b\x03\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x2d\xfe\x2d\xfe\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x2d\xfe\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2d\xfe\x00\x00\x00\x00\x00\x00\x2d\xfe\x00\x00\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x00\x00\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x00\x00\x00\x00\x2d\xfe\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x2d\xfe\x2d\xfe\x2d\xfe\x00\x00\x00\x00\x2d\xfe\x00\x00\x00\x00\x00\x00\x2d\xfe\x00\x00\x00\x00\x2d\xfe\x2d\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x2d\xfe\x2d\xfe\x2d\xfe\x00\x00\x00\x00\x00\x00\x2d\xfe\x00\x00\x2d\xfe\x00\x00\x2d\xfe\x00\x00\x2d\xfe\x00\x00\x2d\xfe\x00\x00\x00\x00\x00\x00\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x00\x00\x2d\xfe\x00\x00\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x2d\xfe\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x00\x00\x00\x00\x00\x00\x13\x00\x5d\x03\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xa6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x9e\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xa6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\xd2\x01\x00\x00\x69\x02\xd4\x01\x00\x00\x4d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\xa7\x01\x00\x00\x6a\x02\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\x57\x01\x00\x00\x00\x00\x00\x00\x00\x00\x59\x00\x5a\x00\xa8\x01\x00\x00\x5c\x00\x5d\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x9e\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xa6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xd4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xa6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xd4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xa6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\xd4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\xa6\x03\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x97\x00\x11\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x12\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x9c\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x9d\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\xa1\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\xa5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x97\x00\x11\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x12\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x88\x03\x1a\x04\x9a\x02\x00\x00\x31\x00\x73\x02\x9b\x02\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x96\x01\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\x00\x00\x97\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x36\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x97\x00\x11\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x12\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x9c\x02\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x38\x00\x39\x00\x22\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\x04\x42\x00\x2f\x01\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x64\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\x00\x00\x97\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x36\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x97\x00\x11\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x12\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaf\x01\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x97\x00\x11\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x12\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\xf2\x01\xaa\x03\x9a\x02\x00\x00\x31\x00\x73\x02\x9b\x02\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x36\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x97\x00\x11\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x12\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x9c\x02\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x38\x00\x39\x00\x22\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaf\x01\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x97\x00\x11\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x12\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\xf3\x01\xab\x03\x9a\x02\x00\x00\x31\x00\x73\x02\x9b\x02\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x36\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x97\x00\x11\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x12\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x9c\x02\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x38\x00\x39\x00\x22\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x97\x00\x11\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x53\x03\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x00\x00\x00\x00\xa4\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x00\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x00\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x97\x00\x11\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x12\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\xbe\x01\x00\x00\xbf\x01\x00\x00\x00\x00\xc0\x01\x00\x00\x00\x00\xc1\x01\x2c\x00\x2d\x00\x2e\x00\xca\x01\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\xc2\x01\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x18\x02\x19\x02\xc3\x01\x00\x00\x00\x00\x18\x01\x00\x00\x00\x00\x00\x00\xc4\x01\x6e\x00\x0f\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xa8\x00\x00\x00\xa9\x00\x36\x00\xaa\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x00\x00\x00\x00\x5e\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\x00\x00\x44\x00\x11\x00\x00\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\x00\x00\xbc\x00\x12\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\x63\x00\x64\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x37\x00\x00\x00\x45\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x38\x00\x39\x00\x22\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd2\x01\x00\x00\xd3\x01\xd4\x01\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\xd5\x01\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x57\x01\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x45\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\xca\x01\x00\x00\x30\x00\x12\x02\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x4c\x00\xa8\x02\x19\x02\x13\x02\x14\x02\x00\x00\x00\x00\x00\x00\x00\x00\x15\x02\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x56\x01\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x57\x01\x55\x00\x56\x00\x57\x00\x58\x00\x16\x02\x17\x02\x36\x00\x5b\x00\x5c\x00\x18\x02\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x45\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x42\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\xce\x01\x00\x00\x00\x00\x00\x00\x57\x01\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x01\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x32\x01\x33\x01\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\xca\x01\x00\x00\x30\x00\x4b\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x4c\x00\x00\x00\x94\x03\x4d\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x36\x00\x5b\x00\x5c\x00\x5d\x00\x00\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x45\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x42\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\xd7\x01\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x45\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\xca\x01\x00\x00\x30\x00\x4b\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x4c\x00\x00\x00\x81\x03\x4d\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\xd9\x01\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x36\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x45\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x42\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x45\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\xca\x01\x00\x00\x30\x00\x4b\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x4c\x00\x00\x00\x82\x03\x4d\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\xde\x04\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x36\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x45\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x42\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x77\x02\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\xca\x01\x00\x00\x30\x00\x4b\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x4c\x00\x00\x00\x85\x03\x4d\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x36\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x45\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x42\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x72\x04\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x73\x04\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x91\x04\x00\x00\x30\x00\x4b\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x36\x00\x5b\x00\x5c\x00\x5d\x00\x00\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x77\x02\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x42\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x9e\x02\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x1b\x04\x72\x02\x4b\x00\x00\x00\x73\x02\x74\x02\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x36\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x77\x02\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x75\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x42\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x45\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x1a\x04\x72\x02\x4b\x00\x00\x00\x73\x02\x74\x02\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x36\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x77\x02\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x75\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x42\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x45\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x8e\x03\x00\x00\x30\x00\x4b\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x36\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x9e\x02\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x42\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x45\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\xaa\x03\x72\x02\x4b\x00\x00\x00\x73\x02\x74\x02\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x36\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x77\x02\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x75\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x42\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x45\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\xab\x03\x72\x02\x4b\x00\x00\x00\x73\x02\x74\x02\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x36\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x77\x02\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x75\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x42\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x45\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\xd6\x03\x00\x00\x30\x00\x4b\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x36\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x9e\x02\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x42\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x45\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x0c\x03\x72\x02\x4b\x00\x00\x00\x73\x02\x74\x02\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x36\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x75\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x99\x04\x4b\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x42\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x00\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x11\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x12\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x49\x00\x4a\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x9b\x04\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x00\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x57\x00\x58\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x88\x03\x00\x00\x30\x00\x4b\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x66\x04\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x36\x00\x5b\x00\x5c\x00\x5d\x00\x00\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x4d\x00\x4e\x00\x00\x00\x00\x00\x42\x00\x00\x00\x4f\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x00\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x00\x00\x11\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x12\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x00\x00\xd5\xfe\x00\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbe\x02\xeb\x01\x57\x00\x58\x00\x00\x00\x7f\x00\x00\x00\x5b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\xe4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\xd6\x03\x00\x00\x30\x00\x00\x00\x31\x00\x75\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x00\x00\xdb\x04\x00\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbe\x02\xeb\x01\x57\x00\x58\x00\x36\x00\x7f\x00\x00\x00\x5b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x44\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x13\x00\x00\x00\x63\x00\x64\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x37\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x4a\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdc\x04\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xeb\x01\x57\x00\x58\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5f\x00\x60\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x83\x03\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x61\x00\x62\x00\x00\x00\x00\x00\x00\x00\x63\x00\x64\x00\xde\x04\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x83\x03\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x00\x00\x8d\x03\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x83\x03\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x00\x00\xbb\x03\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x83\x03\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x37\x00\x36\x00\x00\x00\x00\x00\xcd\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x37\x00\x36\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x83\x03\x00\x00\x30\x00\x00\x00\x31\x00\x42\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd3\x03\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x83\x03\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x00\x00\x84\x03\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\xf2\x01\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\xf3\x01\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x37\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x37\x00\x36\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x7a\x01\x00\x00\x30\x00\x00\x00\x31\x00\x42\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\xd5\x01\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\xd7\x01\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x36\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x37\x00\x00\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x37\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x42\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x9f\x04\x00\x00\x2f\x01\x37\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x37\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x3f\x00\x40\x00\x41\x00\xac\x03\x00\x00\x2f\x01\x36\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x42\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x3f\x00\x40\x00\x41\x00\xc2\x03\x00\x00\x2f\x01\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x42\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x36\x00\x00\x00\x00\x00\x21\x03\x00\x00\x2f\x01\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf4\x01\x00\x00\x2f\x01\x00\x00\x33\x00\x34\x00\x35\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x00\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x42\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x3f\x00\x40\x00\x41\x00\xa7\x02\x00\x00\x2f\x01\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x42\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb1\x02\x00\x00\x2f\x01\x00\x00\x33\x00\x34\x00\x35\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2e\x01\x00\x00\x2f\x01\x00\x00\x33\x00\x34\x00\x35\x00\x36\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\xaf\x04\x2c\x00\x2d\x00\x2e\x00\xb0\x04\x00\x00\x00\x00\xb1\x04\x36\x00\x00\x00\x00\x00\xf8\x04\x00\x00\x00\x00\xb1\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\xb2\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf9\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x38\x00\x39\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x41\x00\x38\x00\x39\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x38\x00\x39\x00\x42\x00\x11\x00\x3b\x00\x3c\x00\x00\x00\x3f\x00\x00\x00\x41\x00\x00\x00\x12\x00\x00\x00\x00\x00\x3f\x00\x00\x00\x41\x00\x00\x00\x00\x00\x42\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x42\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x11\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x12\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x08\x03\x09\x03\x0a\x03\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\xfb\x01\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x24\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x82\x00\x22\x00\x0b\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x80\x01\x8c\x00\x00\x00\xfb\x01\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x0b\x03\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\xfb\x01\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0b\x03\x75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x81\x01\x0d\x00\x0e\x00\x76\x00\x77\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x78\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x79\x00\x00\x00\x11\x00\x00\x00\x7a\x00\x00\x00\x7b\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x7c\x00\x00\x00\x24\x00\x7d\x00\x7e\x00\x7f\x00\x25\x00\x80\x00\x81\x00\x82\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x76\x00\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc6\x01\x00\x00\x00\x00\x11\x00\xc7\x01\x00\x00\x7b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\xc8\x01\x00\x00\x24\x00\x7d\x00\x7e\x00\x7f\x00\x00\x00\x80\x00\x51\x04\x82\x00\x00\x00\x13\x00\x00\x00\x52\x04\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x11\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x12\x00\x00\x00\x22\x00\x00\x00\x00\x00\x53\x04\x00\x00\x00\x00\x00\x00\x51\x04\x00\x00\x00\x00\x13\x00\x00\x00\x52\x04\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x53\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x04\x00\x00\x00\x00\x24\x00\x58\x00\x00\x00\x00\x00\x25\x00\x5b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x54\x04\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x58\x00\x00\x00\x00\x00\x25\x00\x5b\x00\x13\x00\x00\x00\x52\x04\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\xca\x04\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x04\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x58\x00\x00\x00\x13\x00\x25\x00\x5b\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\x79\x00\x00\x00\x00\x00\x00\x00\x80\x01\x12\x00\x7b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x7d\x00\x00\x00\x13\x00\x25\x00\x80\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\xc6\x01\x00\x00\x00\x00\x00\x00\xc7\x01\x12\x00\x7b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x7d\x00\x00\x00\x13\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x7d\x00\x13\x00\x00\x00\x25\x00\x80\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\x71\x01\x00\x00\x72\x01\x00\x00\x73\x01\x12\x00\x74\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x57\x00\x58\x00\x00\x00\x13\x00\x00\x00\x5b\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\x13\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x25\x00\x80\x00\x13\x00\x00\x00\x14\x01\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x7d\x00\x13\x00\x00\x00\x00\x00\x80\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x00\x00\x13\x00\x25\x00\x2e\x02\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x11\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x24\x00\x00\x00\x00\x00\x14\x00\x25\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x75\x00\x00\x00\x25\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x76\x00\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x11\x00\x00\x00\x00\x00\x5e\x01\x56\x01\x7b\x00\x00\x00\x00\x00\x12\x00\x00\x00\x57\x01\x00\x00\x00\x00\x24\x00\x7d\x00\x7e\x00\x7f\x00\x1b\x01\x00\x00\x00\x00\x13\x00\x00\x00\x1c\x01\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x11\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x12\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x00\x00\x00\x00\x00\x00\x1d\x01\x00\x00\x7b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x12\x00\x00\x00\x00\x00\x1d\x01\x00\x00\x7b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x24\x00\x7d\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x11\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x12\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x00\x00\x00\x00\x00\x00\x5e\x01\x00\x00\x7b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x12\x00\x00\x00\x00\x00\x1d\x01\x00\x00\x7b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x24\x00\x7d\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x11\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x12\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x00\x00\x00\x00\x00\x00\x2b\x01\x00\x00\x7b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x12\x00\x00\x00\x00\x00\x5e\x01\x00\x00\x7b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x24\x00\x7d\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x11\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x12\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x11\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x12\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x83\x02\x00\x00\x22\x00\x00\x00\x00\x00\x24\x00\x7d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc1\x02\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x24\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x11\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x12\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe3\x03\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x14\x00\x24\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\xfb\x01\x00\x00\x14\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x24\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x11\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe3\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x24\x00\x11\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x12\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x11\x00\x00\x00\xfb\x01\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x12\x00\x00\x00\x22\x00\x00\x00\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\xcc\x03\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x46\x00\x47\x00\x48\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x82\x00\x47\x01\x48\x01\x85\x00\x57\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x01\x4a\x01\x00\x00\xe4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x57\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x4b\x01\x82\x00\x47\x01\x48\x01\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x4c\x01\x00\x00\x4d\x01\x00\x00\x49\x01\x4a\x01\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x4e\x01\x4f\x01\x50\x01\x51\x01\x0f\x00\x6f\x00\x70\x00\x71\x00\x52\x01\x73\x00\x95\x00\x00\x00\x00\x00\x53\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x4b\x01\x82\x00\x47\x01\x48\x01\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x4c\x01\x00\x00\x4d\x01\x00\x00\x82\x01\x83\x01\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x4e\x01\x4f\x01\x88\x01\x51\x01\x0f\x00\x6f\x00\x70\x00\x71\x00\x52\x01\x73\x00\x95\x00\x00\x00\x00\x00\x53\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x82\x00\x4b\x01\x73\x04\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x4c\x01\x00\x00\x4d\x01\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x4e\x01\x84\x01\x00\x00\x85\x01\x0f\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x95\x00\x00\x00\x00\x00\x86\x01\x82\x00\xd1\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x65\x03\x66\x03\x67\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x68\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x82\x00\x47\x01\x48\x01\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x89\x01\x94\x00\x0d\x00\x0e\x00\x00\x00\x8a\x01\x00\x00\x00\x00\x00\x00\x0f\x00\x8b\x01\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x69\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x82\x00\x67\x00\x68\x00\x9e\x02\x4b\x01\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x01\x00\x00\x4d\x01\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x4e\x01\x84\x01\x00\x00\x85\x01\x0f\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x95\x00\x82\x00\x47\x01\x48\x01\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x8c\x01\x00\x00\x00\x00\x00\x00\x8d\x01\x8e\x01\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x82\x00\x67\x00\x68\x00\x00\x00\x4b\x01\x00\x00\x00\x00\x00\x00\xf2\x02\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x01\x00\x00\x4d\x01\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x4e\x01\x84\x01\x00\x00\x85\x01\x0f\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x95\x00\x82\x00\x47\x01\x48\x01\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x55\x02\x00\x00\x00\x00\x53\x03\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x82\x00\x67\x00\x68\x00\x00\x00\x4b\x01\x00\x00\x00\x00\x00\x00\x2f\x02\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x01\x00\x00\x4d\x01\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x4e\x01\x84\x01\x00\x00\x85\x01\x0f\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x95\x00\x82\x00\x47\x01\x48\x01\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x55\x02\x00\x00\x00\x00\x56\x02\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x00\x00\x4b\x01\x82\x00\x47\x01\x48\x01\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x4c\x01\x00\x00\x4d\x01\x00\x00\x96\x03\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x4e\x01\x84\x01\x00\x00\x85\x01\x0f\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x4b\x01\x82\x00\x47\x01\x48\x01\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x4c\x01\x00\x00\x4d\x01\x00\x00\x33\x03\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x4e\x01\x84\x01\x00\x00\x85\x01\x0f\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x4b\x01\x82\x00\x55\x03\x48\x01\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x4c\x01\x00\x00\x4d\x01\x00\x00\x56\x03\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x4e\x01\x84\x01\x00\x00\x85\x01\x0f\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x4b\x01\x82\x00\x5e\x03\x48\x01\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x4c\x01\x00\x00\x4d\x01\x00\x00\x56\x03\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x4e\x01\x84\x01\x00\x00\x85\x01\x0f\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x4b\x01\x82\x00\x47\x01\x48\x01\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x4c\x01\x00\x00\x4d\x01\x00\x00\x61\x03\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x4e\x01\x84\x01\x00\x00\x85\x01\x0f\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x4b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x01\x00\x00\x4d\x01\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x4e\x01\x84\x01\x00\x00\x85\x01\x0f\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x95\x00\x82\x00\x83\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x57\x03\x58\x03\x59\x03\x5a\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x82\x00\x83\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x5f\x03\x58\x03\x59\x03\x5a\x03\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x82\x00\x83\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x2c\x04\x59\x03\x5a\x03\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x82\x00\xd1\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x9d\x03\x66\x03\x67\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x68\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x82\x00\x83\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x22\x03\x33\x02\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x82\x00\xd1\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x6b\x03\x66\x03\x67\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x68\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x82\x00\x83\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x32\x02\x33\x02\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x82\x00\x83\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x3e\x02\x00\x00\x3f\x02\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x82\x00\x83\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x40\x02\x00\x00\x3f\x02\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x82\x00\x83\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x8f\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x82\x00\x83\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x2a\x04\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x82\x00\x83\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9a\x03\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x82\x00\xa2\x01\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\xa3\x01\xa4\x01\xa5\x01\x82\x00\x83\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\x00\x90\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x00\x00\x82\x00\xd1\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x32\x04\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x68\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x82\x00\x83\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x82\x00\xd1\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\xfd\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x82\x00\xd1\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\xfe\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x82\x00\xd1\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\xd2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x82\x00\xb5\x04\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\x58\x04\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\x5b\x04\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\x5c\x04\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\x5d\x04\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\x84\x04\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\x19\x04\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\x29\x04\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\x30\x04\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\x31\x04\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\x97\x03\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\x99\x03\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\xa4\x03\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\xb0\x03\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\xec\x02\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\x23\x03\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\x5d\x03\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\x60\x03\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\x6e\x03\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\x72\x03\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\x73\x03\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\x22\x02\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\x23\x02\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\x24\x02\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\x25\x02\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\x2e\x02\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\x74\x01\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\x75\x01\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\x76\x01\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\x7c\x01\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\xa9\x01\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\xaf\x01\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\xb0\x01\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\xbd\x01\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\xd4\x00\x84\x00\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\x00\x00\xe3\x03\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x00\x00\x67\x00\x68\x00\x82\x00\x00\x00\x91\x02\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x82\x00\x00\x00\x7b\x01\x85\x00\x00\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x82\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x01\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x93\x01\x8a\x00\x8b\x00\x8c\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x82\x00\x00\x00\x49\x02\x64\x03\x00\x00\x00\x00\x00\x00\x00\x00\x93\x01\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x02\x4a\x02\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x01\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x82\x00\x67\x00\x68\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x45\x02\x8a\x00\x8b\x00\x8c\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\xad\x01\x8a\x00\x8b\x00\x8c\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd2\x02\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x82\x00\x67\x00\x68\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\xd3\x02\x8a\x00\x8b\x00\x8c\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x0e\x01\x8a\x00\x8b\x00\x8c\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x01\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x82\x00\x67\x00\x68\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x90\x01\x8a\x00\x8b\x00\x8c\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x92\x01\x8a\x00\x8b\x00\x8c\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x01\x8a\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x93\x00\x66\x00\x95\x00\x82\x00\x67\x00\x68\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x9f\x01\x8a\x00\x8b\x00\x8c\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\xad\x01\x8a\x00\x8b\x00\x8c\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x66\x00\x00\x00\x00\x00\x67\x00\x68\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x00\x0d\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\x70\x00\x71\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyReduceArr = Happy_Data_Array.array (11, 732) [
	(11 , happyReduce_11),
	(12 , happyReduce_12),
	(13 , happyReduce_13),
	(14 , happyReduce_14),
	(15 , happyReduce_15),
	(16 , happyReduce_16),
	(17 , happyReduce_17),
	(18 , happyReduce_18),
	(19 , happyReduce_19),
	(20 , happyReduce_20),
	(21 , happyReduce_21),
	(22 , happyReduce_22),
	(23 , happyReduce_23),
	(24 , happyReduce_24),
	(25 , happyReduce_25),
	(26 , happyReduce_26),
	(27 , happyReduce_27),
	(28 , happyReduce_28),
	(29 , happyReduce_29),
	(30 , happyReduce_30),
	(31 , happyReduce_31),
	(32 , happyReduce_32),
	(33 , happyReduce_33),
	(34 , happyReduce_34),
	(35 , happyReduce_35),
	(36 , happyReduce_36),
	(37 , happyReduce_37),
	(38 , happyReduce_38),
	(39 , happyReduce_39),
	(40 , happyReduce_40),
	(41 , happyReduce_41),
	(42 , happyReduce_42),
	(43 , happyReduce_43),
	(44 , happyReduce_44),
	(45 , happyReduce_45),
	(46 , happyReduce_46),
	(47 , happyReduce_47),
	(48 , happyReduce_48),
	(49 , happyReduce_49),
	(50 , happyReduce_50),
	(51 , happyReduce_51),
	(52 , happyReduce_52),
	(53 , happyReduce_53),
	(54 , happyReduce_54),
	(55 , happyReduce_55),
	(56 , happyReduce_56),
	(57 , happyReduce_57),
	(58 , happyReduce_58),
	(59 , happyReduce_59),
	(60 , happyReduce_60),
	(61 , happyReduce_61),
	(62 , happyReduce_62),
	(63 , happyReduce_63),
	(64 , happyReduce_64),
	(65 , happyReduce_65),
	(66 , happyReduce_66),
	(67 , happyReduce_67),
	(68 , happyReduce_68),
	(69 , happyReduce_69),
	(70 , happyReduce_70),
	(71 , happyReduce_71),
	(72 , happyReduce_72),
	(73 , happyReduce_73),
	(74 , happyReduce_74),
	(75 , happyReduce_75),
	(76 , happyReduce_76),
	(77 , happyReduce_77),
	(78 , happyReduce_78),
	(79 , happyReduce_79),
	(80 , happyReduce_80),
	(81 , happyReduce_81),
	(82 , happyReduce_82),
	(83 , happyReduce_83),
	(84 , happyReduce_84),
	(85 , happyReduce_85),
	(86 , happyReduce_86),
	(87 , happyReduce_87),
	(88 , happyReduce_88),
	(89 , happyReduce_89),
	(90 , happyReduce_90),
	(91 , happyReduce_91),
	(92 , happyReduce_92),
	(93 , happyReduce_93),
	(94 , happyReduce_94),
	(95 , happyReduce_95),
	(96 , happyReduce_96),
	(97 , happyReduce_97),
	(98 , happyReduce_98),
	(99 , happyReduce_99),
	(100 , happyReduce_100),
	(101 , happyReduce_101),
	(102 , happyReduce_102),
	(103 , happyReduce_103),
	(104 , happyReduce_104),
	(105 , happyReduce_105),
	(106 , happyReduce_106),
	(107 , happyReduce_107),
	(108 , happyReduce_108),
	(109 , happyReduce_109),
	(110 , happyReduce_110),
	(111 , happyReduce_111),
	(112 , happyReduce_112),
	(113 , happyReduce_113),
	(114 , happyReduce_114),
	(115 , happyReduce_115),
	(116 , happyReduce_116),
	(117 , happyReduce_117),
	(118 , happyReduce_118),
	(119 , happyReduce_119),
	(120 , happyReduce_120),
	(121 , happyReduce_121),
	(122 , happyReduce_122),
	(123 , happyReduce_123),
	(124 , happyReduce_124),
	(125 , happyReduce_125),
	(126 , happyReduce_126),
	(127 , happyReduce_127),
	(128 , happyReduce_128),
	(129 , happyReduce_129),
	(130 , happyReduce_130),
	(131 , happyReduce_131),
	(132 , happyReduce_132),
	(133 , happyReduce_133),
	(134 , happyReduce_134),
	(135 , happyReduce_135),
	(136 , happyReduce_136),
	(137 , happyReduce_137),
	(138 , happyReduce_138),
	(139 , happyReduce_139),
	(140 , happyReduce_140),
	(141 , happyReduce_141),
	(142 , happyReduce_142),
	(143 , happyReduce_143),
	(144 , happyReduce_144),
	(145 , happyReduce_145),
	(146 , happyReduce_146),
	(147 , happyReduce_147),
	(148 , happyReduce_148),
	(149 , happyReduce_149),
	(150 , happyReduce_150),
	(151 , happyReduce_151),
	(152 , happyReduce_152),
	(153 , happyReduce_153),
	(154 , happyReduce_154),
	(155 , happyReduce_155),
	(156 , happyReduce_156),
	(157 , happyReduce_157),
	(158 , happyReduce_158),
	(159 , happyReduce_159),
	(160 , happyReduce_160),
	(161 , happyReduce_161),
	(162 , happyReduce_162),
	(163 , happyReduce_163),
	(164 , happyReduce_164),
	(165 , happyReduce_165),
	(166 , happyReduce_166),
	(167 , happyReduce_167),
	(168 , happyReduce_168),
	(169 , happyReduce_169),
	(170 , happyReduce_170),
	(171 , happyReduce_171),
	(172 , happyReduce_172),
	(173 , happyReduce_173),
	(174 , happyReduce_174),
	(175 , happyReduce_175),
	(176 , happyReduce_176),
	(177 , happyReduce_177),
	(178 , happyReduce_178),
	(179 , happyReduce_179),
	(180 , happyReduce_180),
	(181 , happyReduce_181),
	(182 , happyReduce_182),
	(183 , happyReduce_183),
	(184 , happyReduce_184),
	(185 , happyReduce_185),
	(186 , happyReduce_186),
	(187 , happyReduce_187),
	(188 , happyReduce_188),
	(189 , happyReduce_189),
	(190 , happyReduce_190),
	(191 , happyReduce_191),
	(192 , happyReduce_192),
	(193 , happyReduce_193),
	(194 , happyReduce_194),
	(195 , happyReduce_195),
	(196 , happyReduce_196),
	(197 , happyReduce_197),
	(198 , happyReduce_198),
	(199 , happyReduce_199),
	(200 , happyReduce_200),
	(201 , happyReduce_201),
	(202 , happyReduce_202),
	(203 , happyReduce_203),
	(204 , happyReduce_204),
	(205 , happyReduce_205),
	(206 , happyReduce_206),
	(207 , happyReduce_207),
	(208 , happyReduce_208),
	(209 , happyReduce_209),
	(210 , happyReduce_210),
	(211 , happyReduce_211),
	(212 , happyReduce_212),
	(213 , happyReduce_213),
	(214 , happyReduce_214),
	(215 , happyReduce_215),
	(216 , happyReduce_216),
	(217 , happyReduce_217),
	(218 , happyReduce_218),
	(219 , happyReduce_219),
	(220 , happyReduce_220),
	(221 , happyReduce_221),
	(222 , happyReduce_222),
	(223 , happyReduce_223),
	(224 , happyReduce_224),
	(225 , happyReduce_225),
	(226 , happyReduce_226),
	(227 , happyReduce_227),
	(228 , happyReduce_228),
	(229 , happyReduce_229),
	(230 , happyReduce_230),
	(231 , happyReduce_231),
	(232 , happyReduce_232),
	(233 , happyReduce_233),
	(234 , happyReduce_234),
	(235 , happyReduce_235),
	(236 , happyReduce_236),
	(237 , happyReduce_237),
	(238 , happyReduce_238),
	(239 , happyReduce_239),
	(240 , happyReduce_240),
	(241 , happyReduce_241),
	(242 , happyReduce_242),
	(243 , happyReduce_243),
	(244 , happyReduce_244),
	(245 , happyReduce_245),
	(246 , happyReduce_246),
	(247 , happyReduce_247),
	(248 , happyReduce_248),
	(249 , happyReduce_249),
	(250 , happyReduce_250),
	(251 , happyReduce_251),
	(252 , happyReduce_252),
	(253 , happyReduce_253),
	(254 , happyReduce_254),
	(255 , happyReduce_255),
	(256 , happyReduce_256),
	(257 , happyReduce_257),
	(258 , happyReduce_258),
	(259 , happyReduce_259),
	(260 , happyReduce_260),
	(261 , happyReduce_261),
	(262 , happyReduce_262),
	(263 , happyReduce_263),
	(264 , happyReduce_264),
	(265 , happyReduce_265),
	(266 , happyReduce_266),
	(267 , happyReduce_267),
	(268 , happyReduce_268),
	(269 , happyReduce_269),
	(270 , happyReduce_270),
	(271 , happyReduce_271),
	(272 , happyReduce_272),
	(273 , happyReduce_273),
	(274 , happyReduce_274),
	(275 , happyReduce_275),
	(276 , happyReduce_276),
	(277 , happyReduce_277),
	(278 , happyReduce_278),
	(279 , happyReduce_279),
	(280 , happyReduce_280),
	(281 , happyReduce_281),
	(282 , happyReduce_282),
	(283 , happyReduce_283),
	(284 , happyReduce_284),
	(285 , happyReduce_285),
	(286 , happyReduce_286),
	(287 , happyReduce_287),
	(288 , happyReduce_288),
	(289 , happyReduce_289),
	(290 , happyReduce_290),
	(291 , happyReduce_291),
	(292 , happyReduce_292),
	(293 , happyReduce_293),
	(294 , happyReduce_294),
	(295 , happyReduce_295),
	(296 , happyReduce_296),
	(297 , happyReduce_297),
	(298 , happyReduce_298),
	(299 , happyReduce_299),
	(300 , happyReduce_300),
	(301 , happyReduce_301),
	(302 , happyReduce_302),
	(303 , happyReduce_303),
	(304 , happyReduce_304),
	(305 , happyReduce_305),
	(306 , happyReduce_306),
	(307 , happyReduce_307),
	(308 , happyReduce_308),
	(309 , happyReduce_309),
	(310 , happyReduce_310),
	(311 , happyReduce_311),
	(312 , happyReduce_312),
	(313 , happyReduce_313),
	(314 , happyReduce_314),
	(315 , happyReduce_315),
	(316 , happyReduce_316),
	(317 , happyReduce_317),
	(318 , happyReduce_318),
	(319 , happyReduce_319),
	(320 , happyReduce_320),
	(321 , happyReduce_321),
	(322 , happyReduce_322),
	(323 , happyReduce_323),
	(324 , happyReduce_324),
	(325 , happyReduce_325),
	(326 , happyReduce_326),
	(327 , happyReduce_327),
	(328 , happyReduce_328),
	(329 , happyReduce_329),
	(330 , happyReduce_330),
	(331 , happyReduce_331),
	(332 , happyReduce_332),
	(333 , happyReduce_333),
	(334 , happyReduce_334),
	(335 , happyReduce_335),
	(336 , happyReduce_336),
	(337 , happyReduce_337),
	(338 , happyReduce_338),
	(339 , happyReduce_339),
	(340 , happyReduce_340),
	(341 , happyReduce_341),
	(342 , happyReduce_342),
	(343 , happyReduce_343),
	(344 , happyReduce_344),
	(345 , happyReduce_345),
	(346 , happyReduce_346),
	(347 , happyReduce_347),
	(348 , happyReduce_348),
	(349 , happyReduce_349),
	(350 , happyReduce_350),
	(351 , happyReduce_351),
	(352 , happyReduce_352),
	(353 , happyReduce_353),
	(354 , happyReduce_354),
	(355 , happyReduce_355),
	(356 , happyReduce_356),
	(357 , happyReduce_357),
	(358 , happyReduce_358),
	(359 , happyReduce_359),
	(360 , happyReduce_360),
	(361 , happyReduce_361),
	(362 , happyReduce_362),
	(363 , happyReduce_363),
	(364 , happyReduce_364),
	(365 , happyReduce_365),
	(366 , happyReduce_366),
	(367 , happyReduce_367),
	(368 , happyReduce_368),
	(369 , happyReduce_369),
	(370 , happyReduce_370),
	(371 , happyReduce_371),
	(372 , happyReduce_372),
	(373 , happyReduce_373),
	(374 , happyReduce_374),
	(375 , happyReduce_375),
	(376 , happyReduce_376),
	(377 , happyReduce_377),
	(378 , happyReduce_378),
	(379 , happyReduce_379),
	(380 , happyReduce_380),
	(381 , happyReduce_381),
	(382 , happyReduce_382),
	(383 , happyReduce_383),
	(384 , happyReduce_384),
	(385 , happyReduce_385),
	(386 , happyReduce_386),
	(387 , happyReduce_387),
	(388 , happyReduce_388),
	(389 , happyReduce_389),
	(390 , happyReduce_390),
	(391 , happyReduce_391),
	(392 , happyReduce_392),
	(393 , happyReduce_393),
	(394 , happyReduce_394),
	(395 , happyReduce_395),
	(396 , happyReduce_396),
	(397 , happyReduce_397),
	(398 , happyReduce_398),
	(399 , happyReduce_399),
	(400 , happyReduce_400),
	(401 , happyReduce_401),
	(402 , happyReduce_402),
	(403 , happyReduce_403),
	(404 , happyReduce_404),
	(405 , happyReduce_405),
	(406 , happyReduce_406),
	(407 , happyReduce_407),
	(408 , happyReduce_408),
	(409 , happyReduce_409),
	(410 , happyReduce_410),
	(411 , happyReduce_411),
	(412 , happyReduce_412),
	(413 , happyReduce_413),
	(414 , happyReduce_414),
	(415 , happyReduce_415),
	(416 , happyReduce_416),
	(417 , happyReduce_417),
	(418 , happyReduce_418),
	(419 , happyReduce_419),
	(420 , happyReduce_420),
	(421 , happyReduce_421),
	(422 , happyReduce_422),
	(423 , happyReduce_423),
	(424 , happyReduce_424),
	(425 , happyReduce_425),
	(426 , happyReduce_426),
	(427 , happyReduce_427),
	(428 , happyReduce_428),
	(429 , happyReduce_429),
	(430 , happyReduce_430),
	(431 , happyReduce_431),
	(432 , happyReduce_432),
	(433 , happyReduce_433),
	(434 , happyReduce_434),
	(435 , happyReduce_435),
	(436 , happyReduce_436),
	(437 , happyReduce_437),
	(438 , happyReduce_438),
	(439 , happyReduce_439),
	(440 , happyReduce_440),
	(441 , happyReduce_441),
	(442 , happyReduce_442),
	(443 , happyReduce_443),
	(444 , happyReduce_444),
	(445 , happyReduce_445),
	(446 , happyReduce_446),
	(447 , happyReduce_447),
	(448 , happyReduce_448),
	(449 , happyReduce_449),
	(450 , happyReduce_450),
	(451 , happyReduce_451),
	(452 , happyReduce_452),
	(453 , happyReduce_453),
	(454 , happyReduce_454),
	(455 , happyReduce_455),
	(456 , happyReduce_456),
	(457 , happyReduce_457),
	(458 , happyReduce_458),
	(459 , happyReduce_459),
	(460 , happyReduce_460),
	(461 , happyReduce_461),
	(462 , happyReduce_462),
	(463 , happyReduce_463),
	(464 , happyReduce_464),
	(465 , happyReduce_465),
	(466 , happyReduce_466),
	(467 , happyReduce_467),
	(468 , happyReduce_468),
	(469 , happyReduce_469),
	(470 , happyReduce_470),
	(471 , happyReduce_471),
	(472 , happyReduce_472),
	(473 , happyReduce_473),
	(474 , happyReduce_474),
	(475 , happyReduce_475),
	(476 , happyReduce_476),
	(477 , happyReduce_477),
	(478 , happyReduce_478),
	(479 , happyReduce_479),
	(480 , happyReduce_480),
	(481 , happyReduce_481),
	(482 , happyReduce_482),
	(483 , happyReduce_483),
	(484 , happyReduce_484),
	(485 , happyReduce_485),
	(486 , happyReduce_486),
	(487 , happyReduce_487),
	(488 , happyReduce_488),
	(489 , happyReduce_489),
	(490 , happyReduce_490),
	(491 , happyReduce_491),
	(492 , happyReduce_492),
	(493 , happyReduce_493),
	(494 , happyReduce_494),
	(495 , happyReduce_495),
	(496 , happyReduce_496),
	(497 , happyReduce_497),
	(498 , happyReduce_498),
	(499 , happyReduce_499),
	(500 , happyReduce_500),
	(501 , happyReduce_501),
	(502 , happyReduce_502),
	(503 , happyReduce_503),
	(504 , happyReduce_504),
	(505 , happyReduce_505),
	(506 , happyReduce_506),
	(507 , happyReduce_507),
	(508 , happyReduce_508),
	(509 , happyReduce_509),
	(510 , happyReduce_510),
	(511 , happyReduce_511),
	(512 , happyReduce_512),
	(513 , happyReduce_513),
	(514 , happyReduce_514),
	(515 , happyReduce_515),
	(516 , happyReduce_516),
	(517 , happyReduce_517),
	(518 , happyReduce_518),
	(519 , happyReduce_519),
	(520 , happyReduce_520),
	(521 , happyReduce_521),
	(522 , happyReduce_522),
	(523 , happyReduce_523),
	(524 , happyReduce_524),
	(525 , happyReduce_525),
	(526 , happyReduce_526),
	(527 , happyReduce_527),
	(528 , happyReduce_528),
	(529 , happyReduce_529),
	(530 , happyReduce_530),
	(531 , happyReduce_531),
	(532 , happyReduce_532),
	(533 , happyReduce_533),
	(534 , happyReduce_534),
	(535 , happyReduce_535),
	(536 , happyReduce_536),
	(537 , happyReduce_537),
	(538 , happyReduce_538),
	(539 , happyReduce_539),
	(540 , happyReduce_540),
	(541 , happyReduce_541),
	(542 , happyReduce_542),
	(543 , happyReduce_543),
	(544 , happyReduce_544),
	(545 , happyReduce_545),
	(546 , happyReduce_546),
	(547 , happyReduce_547),
	(548 , happyReduce_548),
	(549 , happyReduce_549),
	(550 , happyReduce_550),
	(551 , happyReduce_551),
	(552 , happyReduce_552),
	(553 , happyReduce_553),
	(554 , happyReduce_554),
	(555 , happyReduce_555),
	(556 , happyReduce_556),
	(557 , happyReduce_557),
	(558 , happyReduce_558),
	(559 , happyReduce_559),
	(560 , happyReduce_560),
	(561 , happyReduce_561),
	(562 , happyReduce_562),
	(563 , happyReduce_563),
	(564 , happyReduce_564),
	(565 , happyReduce_565),
	(566 , happyReduce_566),
	(567 , happyReduce_567),
	(568 , happyReduce_568),
	(569 , happyReduce_569),
	(570 , happyReduce_570),
	(571 , happyReduce_571),
	(572 , happyReduce_572),
	(573 , happyReduce_573),
	(574 , happyReduce_574),
	(575 , happyReduce_575),
	(576 , happyReduce_576),
	(577 , happyReduce_577),
	(578 , happyReduce_578),
	(579 , happyReduce_579),
	(580 , happyReduce_580),
	(581 , happyReduce_581),
	(582 , happyReduce_582),
	(583 , happyReduce_583),
	(584 , happyReduce_584),
	(585 , happyReduce_585),
	(586 , happyReduce_586),
	(587 , happyReduce_587),
	(588 , happyReduce_588),
	(589 , happyReduce_589),
	(590 , happyReduce_590),
	(591 , happyReduce_591),
	(592 , happyReduce_592),
	(593 , happyReduce_593),
	(594 , happyReduce_594),
	(595 , happyReduce_595),
	(596 , happyReduce_596),
	(597 , happyReduce_597),
	(598 , happyReduce_598),
	(599 , happyReduce_599),
	(600 , happyReduce_600),
	(601 , happyReduce_601),
	(602 , happyReduce_602),
	(603 , happyReduce_603),
	(604 , happyReduce_604),
	(605 , happyReduce_605),
	(606 , happyReduce_606),
	(607 , happyReduce_607),
	(608 , happyReduce_608),
	(609 , happyReduce_609),
	(610 , happyReduce_610),
	(611 , happyReduce_611),
	(612 , happyReduce_612),
	(613 , happyReduce_613),
	(614 , happyReduce_614),
	(615 , happyReduce_615),
	(616 , happyReduce_616),
	(617 , happyReduce_617),
	(618 , happyReduce_618),
	(619 , happyReduce_619),
	(620 , happyReduce_620),
	(621 , happyReduce_621),
	(622 , happyReduce_622),
	(623 , happyReduce_623),
	(624 , happyReduce_624),
	(625 , happyReduce_625),
	(626 , happyReduce_626),
	(627 , happyReduce_627),
	(628 , happyReduce_628),
	(629 , happyReduce_629),
	(630 , happyReduce_630),
	(631 , happyReduce_631),
	(632 , happyReduce_632),
	(633 , happyReduce_633),
	(634 , happyReduce_634),
	(635 , happyReduce_635),
	(636 , happyReduce_636),
	(637 , happyReduce_637),
	(638 , happyReduce_638),
	(639 , happyReduce_639),
	(640 , happyReduce_640),
	(641 , happyReduce_641),
	(642 , happyReduce_642),
	(643 , happyReduce_643),
	(644 , happyReduce_644),
	(645 , happyReduce_645),
	(646 , happyReduce_646),
	(647 , happyReduce_647),
	(648 , happyReduce_648),
	(649 , happyReduce_649),
	(650 , happyReduce_650),
	(651 , happyReduce_651),
	(652 , happyReduce_652),
	(653 , happyReduce_653),
	(654 , happyReduce_654),
	(655 , happyReduce_655),
	(656 , happyReduce_656),
	(657 , happyReduce_657),
	(658 , happyReduce_658),
	(659 , happyReduce_659),
	(660 , happyReduce_660),
	(661 , happyReduce_661),
	(662 , happyReduce_662),
	(663 , happyReduce_663),
	(664 , happyReduce_664),
	(665 , happyReduce_665),
	(666 , happyReduce_666),
	(667 , happyReduce_667),
	(668 , happyReduce_668),
	(669 , happyReduce_669),
	(670 , happyReduce_670),
	(671 , happyReduce_671),
	(672 , happyReduce_672),
	(673 , happyReduce_673),
	(674 , happyReduce_674),
	(675 , happyReduce_675),
	(676 , happyReduce_676),
	(677 , happyReduce_677),
	(678 , happyReduce_678),
	(679 , happyReduce_679),
	(680 , happyReduce_680),
	(681 , happyReduce_681),
	(682 , happyReduce_682),
	(683 , happyReduce_683),
	(684 , happyReduce_684),
	(685 , happyReduce_685),
	(686 , happyReduce_686),
	(687 , happyReduce_687),
	(688 , happyReduce_688),
	(689 , happyReduce_689),
	(690 , happyReduce_690),
	(691 , happyReduce_691),
	(692 , happyReduce_692),
	(693 , happyReduce_693),
	(694 , happyReduce_694),
	(695 , happyReduce_695),
	(696 , happyReduce_696),
	(697 , happyReduce_697),
	(698 , happyReduce_698),
	(699 , happyReduce_699),
	(700 , happyReduce_700),
	(701 , happyReduce_701),
	(702 , happyReduce_702),
	(703 , happyReduce_703),
	(704 , happyReduce_704),
	(705 , happyReduce_705),
	(706 , happyReduce_706),
	(707 , happyReduce_707),
	(708 , happyReduce_708),
	(709 , happyReduce_709),
	(710 , happyReduce_710),
	(711 , happyReduce_711),
	(712 , happyReduce_712),
	(713 , happyReduce_713),
	(714 , happyReduce_714),
	(715 , happyReduce_715),
	(716 , happyReduce_716),
	(717 , happyReduce_717),
	(718 , happyReduce_718),
	(719 , happyReduce_719),
	(720 , happyReduce_720),
	(721 , happyReduce_721),
	(722 , happyReduce_722),
	(723 , happyReduce_723),
	(724 , happyReduce_724),
	(725 , happyReduce_725),
	(726 , happyReduce_726),
	(727 , happyReduce_727),
	(728 , happyReduce_728),
	(729 , happyReduce_729),
	(730 , happyReduce_730),
	(731 , happyReduce_731),
	(732 , happyReduce_732)
	]

happy_n_terms = 150 :: Int
happy_n_nonterms = 268 :: Int

happyReduce_11 = happySpecReduce_1  0# happyReduction_11
happyReduction_11 happy_x_1
	 =  case happyOut257 happy_x_1 of { happy_var_1 -> 
	happyIn14
		 (happy_var_1
	)}

happyReduce_12 = happySpecReduce_1  0# happyReduction_12
happyReduction_12 happy_x_1
	 =  case happyOut230 happy_x_1 of { happy_var_1 -> 
	happyIn14
		 (happy_var_1
	)}

happyReduce_13 = happySpecReduce_1  0# happyReduction_13
happyReduction_13 happy_x_1
	 =  case happyOut251 happy_x_1 of { happy_var_1 -> 
	happyIn14
		 (happy_var_1
	)}

happyReduce_14 = happySpecReduce_1  0# happyReduction_14
happyReduction_14 happy_x_1
	 =  case happyOut237 happy_x_1 of { happy_var_1 -> 
	happyIn14
		 (happy_var_1
	)}

happyReduce_15 = happyMonadReduce 3# 0# happyReduction_15
happyReduction_15 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ getRdrName funTyCon)
                               [mj AnnOpenP happy_var_1,mu AnnRarrow happy_var_2,mj AnnCloseP happy_var_3])}}}
	) (\r -> happyReturn (happyIn14 r))

happyReduce_16 = happyMonadReduce 7# 1# happyReduction_16
happyReduction_16 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut16 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut273 happy_x_3 of { happy_var_3 -> 
	case happyOut18 happy_x_4 of { happy_var_4 -> 
	case happyOut26 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { happy_var_6 -> 
	case happyOut19 happy_x_7 of { happy_var_7 -> 
	( fileSrcSpan >>= \ loc ->
                ams (L loc (HsModule (Just happy_var_3) happy_var_5 (fst $ snd happy_var_7)
                              (snd $ snd happy_var_7) happy_var_4 happy_var_1)
                    )
                    ([mj AnnModule happy_var_2, mj AnnWhere happy_var_6] ++ fst happy_var_7))}}}}}}}
	) (\r -> happyReturn (happyIn15 r))

happyReduce_17 = happyMonadReduce 1# 1# happyReduction_17
happyReduction_17 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut20 happy_x_1 of { happy_var_1 -> 
	( fileSrcSpan >>= \ loc ->
                   ams (L loc (HsModule Nothing Nothing
                               (fst $ snd happy_var_1) (snd $ snd happy_var_1) Nothing Nothing))
                       (fst happy_var_1))}
	) (\r -> happyReturn (happyIn15 r))

happyReduce_18 = happySpecReduce_1  2# happyReduction_18
happyReduction_18 happy_x_1
	 =  case happyOut279 happy_x_1 of { happy_var_1 -> 
	happyIn16
		 (happy_var_1
	)}

happyReduce_19 = happySpecReduce_0  2# happyReduction_19
happyReduction_19  =  happyIn16
		 (Nothing
	)

happyReduce_20 = happyMonadReduce 0# 3# happyReduction_20
happyReduction_20 (happyRest) tk
	 = happyThen (( pushCurrentContext)
	) (\r -> happyReturn (happyIn17 r))

happyReduce_21 = happyMonadReduce 3# 4# happyReduction_21
happyReduction_21 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut107 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ajs (Just (sLL happy_var_1 happy_var_3 $ DeprecatedTxt (sL1 happy_var_1 (getDEPRECATED_PRAGs happy_var_1)) (snd $ unLoc happy_var_2)))
                             (mo happy_var_1:mc happy_var_3: (fst $ unLoc happy_var_2)))}}}
	) (\r -> happyReturn (happyIn18 r))

happyReduce_22 = happyMonadReduce 3# 4# happyReduction_22
happyReduction_22 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut107 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ajs (Just (sLL happy_var_1 happy_var_3 $ WarningTxt (sL1 happy_var_1 (getWARNING_PRAGs happy_var_1)) (snd $ unLoc happy_var_2)))
                                (mo happy_var_1:mc happy_var_3 : (fst $ unLoc happy_var_2)))}}}
	) (\r -> happyReturn (happyIn18 r))

happyReduce_23 = happySpecReduce_0  4# happyReduction_23
happyReduction_23  =  happyIn18
		 (Nothing
	)

happyReduce_24 = happySpecReduce_3  5# happyReduction_24
happyReduction_24 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut21 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn19
		 ((moc happy_var_1:mcc happy_var_3:(fst happy_var_2)
                                         , snd happy_var_2)
	)}}}

happyReduce_25 = happySpecReduce_3  5# happyReduction_25
happyReduction_25 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut21 happy_x_2 of { happy_var_2 -> 
	happyIn19
		 ((fst happy_var_2, snd happy_var_2)
	)}

happyReduce_26 = happySpecReduce_3  6# happyReduction_26
happyReduction_26 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut21 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn20
		 ((moc happy_var_1:mcc happy_var_3
                                                   :(fst happy_var_2), snd happy_var_2)
	)}}}

happyReduce_27 = happySpecReduce_3  6# happyReduction_27
happyReduction_27 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut21 happy_x_2 of { happy_var_2 -> 
	happyIn20
		 (([],snd happy_var_2)
	)}

happyReduce_28 = happySpecReduce_1  7# happyReduction_28
happyReduction_28 happy_x_1
	 =  case happyOut38 happy_x_1 of { happy_var_1 -> 
	happyIn21
		 ((fst happy_var_1
                                          ,(reverse $ snd happy_var_1,[]))
	)}

happyReduce_29 = happyMonadReduce 3# 7# happyReduction_29
happyReduction_29 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut22 happy_x_3 of { happy_var_3 -> 
	( if null (snd happy_var_1)
                                             then return ((mj AnnSemi happy_var_2:(fst happy_var_1))
                                                         ,(reverse $ snd happy_var_1,happy_var_3))
                                             else do
                                              { addAnnotation (gl $ head $ snd happy_var_1)
                                                              AnnSemi (gl happy_var_2)
                                              ; return (fst happy_var_1
                                                       ,(reverse $ snd happy_var_1,happy_var_3)) })}}}
	) (\r -> happyReturn (happyIn21 r))

happyReduce_30 = happySpecReduce_1  7# happyReduction_30
happyReduction_30 happy_x_1
	 =  case happyOut22 happy_x_1 of { happy_var_1 -> 
	happyIn21
		 (([],([],happy_var_1))
	)}

happyReduce_31 = happySpecReduce_1  8# happyReduction_31
happyReduction_31 happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	happyIn22
		 (cvTopDecls happy_var_1
	)}

happyReduce_32 = happyMonadReduce 7# 9# happyReduction_32
happyReduction_32 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut16 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut273 happy_x_3 of { happy_var_3 -> 
	case happyOut18 happy_x_4 of { happy_var_4 -> 
	case happyOut26 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { happy_var_6 -> 
	case happyOut24 happy_x_7 of { happy_var_7 -> 
	( fileSrcSpan >>= \ loc ->
                   ams (L loc (HsModule (Just happy_var_3) happy_var_5 happy_var_7 [] happy_var_4 happy_var_1
                          )) [mj AnnModule happy_var_2,mj AnnWhere happy_var_6])}}}}}}}
	) (\r -> happyReturn (happyIn23 r))

happyReduce_33 = happyMonadReduce 1# 9# happyReduction_33
happyReduction_33 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut25 happy_x_1 of { happy_var_1 -> 
	( fileSrcSpan >>= \ loc ->
                   return (L loc (HsModule Nothing Nothing happy_var_1 [] Nothing
                          Nothing)))}
	) (\r -> happyReturn (happyIn23 r))

happyReduce_34 = happySpecReduce_2  10# happyReduction_34
happyReduction_34 happy_x_2
	happy_x_1
	 =  case happyOut38 happy_x_2 of { happy_var_2 -> 
	happyIn24
		 (snd happy_var_2
	)}

happyReduce_35 = happySpecReduce_2  10# happyReduction_35
happyReduction_35 happy_x_2
	happy_x_1
	 =  case happyOut38 happy_x_2 of { happy_var_2 -> 
	happyIn24
		 (snd happy_var_2
	)}

happyReduce_36 = happySpecReduce_2  11# happyReduction_36
happyReduction_36 happy_x_2
	happy_x_1
	 =  case happyOut38 happy_x_2 of { happy_var_2 -> 
	happyIn25
		 (snd happy_var_2
	)}

happyReduce_37 = happySpecReduce_2  11# happyReduction_37
happyReduction_37 happy_x_2
	happy_x_1
	 =  case happyOut38 happy_x_2 of { happy_var_2 -> 
	happyIn25
		 (snd happy_var_2
	)}

happyReduce_38 = happyMonadReduce 3# 12# happyReduction_38
happyReduction_38 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 ()) [mop happy_var_1,mcp happy_var_3] >>
                                       return (Just (sLL happy_var_1 happy_var_3 (fromOL happy_var_2))))}}}
	) (\r -> happyReturn (happyIn26 r))

happyReduce_39 = happySpecReduce_0  12# happyReduction_39
happyReduction_39  =  happyIn26
		 (Nothing
	)

happyReduce_40 = happyMonadReduce 3# 13# happyReduction_40
happyReduction_40 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut29 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut29 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (oll happy_var_1) AnnComma (gl happy_var_2)
                                         >> return (happy_var_1 `appOL` happy_var_3))}}}
	) (\r -> happyReturn (happyIn27 r))

happyReduce_41 = happySpecReduce_1  13# happyReduction_41
happyReduction_41 happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn27
		 (happy_var_1
	)}

happyReduce_42 = happyMonadReduce 5# 14# happyReduction_42
happyReduction_42 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut29 happy_x_1 of { happy_var_1 -> 
	case happyOut31 happy_x_2 of { happy_var_2 -> 
	case happyOut29 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	case happyOut28 happy_x_5 of { happy_var_5 -> 
	( (addAnnotation (oll (happy_var_1 `appOL` happy_var_2 `appOL` happy_var_3))
                                            AnnComma (gl happy_var_4) ) >>
                              return (happy_var_1 `appOL` happy_var_2 `appOL` happy_var_3 `appOL` happy_var_5))}}}}}
	) (\r -> happyReturn (happyIn28 r))

happyReduce_43 = happySpecReduce_3  14# happyReduction_43
happyReduction_43 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut29 happy_x_1 of { happy_var_1 -> 
	case happyOut31 happy_x_2 of { happy_var_2 -> 
	case happyOut29 happy_x_3 of { happy_var_3 -> 
	happyIn28
		 (happy_var_1 `appOL` happy_var_2 `appOL` happy_var_3
	)}}}

happyReduce_44 = happySpecReduce_1  14# happyReduction_44
happyReduction_44 happy_x_1
	 =  case happyOut29 happy_x_1 of { happy_var_1 -> 
	happyIn28
		 (happy_var_1
	)}

happyReduce_45 = happySpecReduce_2  15# happyReduction_45
happyReduction_45 happy_x_2
	happy_x_1
	 =  case happyOut30 happy_x_1 of { happy_var_1 -> 
	case happyOut29 happy_x_2 of { happy_var_2 -> 
	happyIn29
		 (happy_var_1 `appOL` happy_var_2
	)}}

happyReduce_46 = happySpecReduce_0  15# happyReduction_46
happyReduction_46  =  happyIn29
		 (nilOL
	)

happyReduce_47 = happySpecReduce_1  16# happyReduction_47
happyReduction_47 happy_x_1
	 =  case happyOut278 happy_x_1 of { happy_var_1 -> 
	happyIn30
		 (unitOL (sL1 happy_var_1 (case (unLoc happy_var_1) of (n, doc) -> IEGroup n doc))
	)}

happyReduce_48 = happySpecReduce_1  16# happyReduction_48
happyReduction_48 happy_x_1
	 =  case happyOut277 happy_x_1 of { happy_var_1 -> 
	happyIn30
		 (unitOL (sL1 happy_var_1 (IEDocNamed ((fst . unLoc) happy_var_1)))
	)}

happyReduce_49 = happySpecReduce_1  16# happyReduction_49
happyReduction_49 happy_x_1
	 =  case happyOut275 happy_x_1 of { happy_var_1 -> 
	happyIn30
		 (unitOL (sL1 happy_var_1 (IEDoc (unLoc happy_var_1)))
	)}

happyReduce_50 = happyMonadReduce 2# 17# happyReduction_50
happyReduction_50 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut36 happy_x_1 of { happy_var_1 -> 
	case happyOut32 happy_x_2 of { happy_var_2 -> 
	( mkModuleImpExp happy_var_1 (snd $ unLoc happy_var_2)
                                          >>= \ie -> amsu (sLL happy_var_1 happy_var_2 ie) (fst $ unLoc happy_var_2))}}
	) (\r -> happyReturn (happyIn31 r))

happyReduce_51 = happyMonadReduce 2# 17# happyReduction_51
happyReduction_51 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut273 happy_x_2 of { happy_var_2 -> 
	( amsu (sLL happy_var_1 happy_var_2 (IEModuleContents happy_var_2))
                                             [mj AnnModule happy_var_1])}}
	) (\r -> happyReturn (happyIn31 r))

happyReduce_52 = happyMonadReduce 2# 17# happyReduction_52
happyReduction_52 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut230 happy_x_2 of { happy_var_2 -> 
	( amsu (sLL happy_var_1 happy_var_2 (IEVar happy_var_2))
                                             [mj AnnPattern happy_var_1])}}
	) (\r -> happyReturn (happyIn31 r))

happyReduce_53 = happySpecReduce_0  18# happyReduction_53
happyReduction_53  =  happyIn32
		 (sL0 ([],ImpExpAbs)
	)

happyReduce_54 = happyMonadReduce 3# 18# happyReduction_54
happyReduction_54 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut33 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( mkImpExpSubSpec (reverse (snd happy_var_2))
                                      >>= \(as,ie) -> return $ sLL happy_var_1 happy_var_3
                                            (as ++ [mop happy_var_1,mcp happy_var_3] ++ fst happy_var_2, ie))}}}
	) (\r -> happyReturn (happyIn32 r))

happyReduce_55 = happySpecReduce_0  19# happyReduction_55
happyReduction_55  =  happyIn33
		 (([],[])
	)

happyReduce_56 = happySpecReduce_1  19# happyReduction_56
happyReduction_56 happy_x_1
	 =  case happyOut34 happy_x_1 of { happy_var_1 -> 
	happyIn33
		 (happy_var_1
	)}

happyReduce_57 = happyMonadReduce 3# 20# happyReduction_57
happyReduction_57 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut34 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut35 happy_x_3 of { happy_var_3 -> 
	( case (head (snd happy_var_1)) of
                                                    l@(L _ Nothing) ->
                                                       return ([mj AnnComma happy_var_2, mj AnnDotdot l]
                                                               ,(snd (unLoc happy_var_3)  : snd happy_var_1))
                                                    l -> (ams (head (snd happy_var_1)) [mj AnnComma happy_var_2] >>
                                                          return (fst happy_var_1 ++ fst (unLoc happy_var_3),
                                                                  snd (unLoc happy_var_3) : snd happy_var_1)))}}}
	) (\r -> happyReturn (happyIn34 r))

happyReduce_58 = happySpecReduce_1  20# happyReduction_58
happyReduction_58 happy_x_1
	 =  case happyOut35 happy_x_1 of { happy_var_1 -> 
	happyIn34
		 ((fst (unLoc happy_var_1),[snd (unLoc happy_var_1)])
	)}

happyReduce_59 = happySpecReduce_1  21# happyReduction_59
happyReduction_59 happy_x_1
	 =  case happyOut36 happy_x_1 of { happy_var_1 -> 
	happyIn35
		 (sL1 happy_var_1 ([],Just `fmap` happy_var_1)
	)}

happyReduce_60 = happySpecReduce_1  21# happyReduction_60
happyReduction_60 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn35
		 (sL1 happy_var_1 ([mj AnnDotdot happy_var_1], sL1 happy_var_1 Nothing)
	)}

happyReduce_61 = happySpecReduce_1  22# happyReduction_61
happyReduction_61 happy_x_1
	 =  case happyOut37 happy_x_1 of { happy_var_1 -> 
	happyIn36
		 (happy_var_1
	)}

happyReduce_62 = happyMonadReduce 2# 22# happyReduction_62
happyReduction_62 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut240 happy_x_2 of { happy_var_2 -> 
	( amms (mkTypeImpExp (sLL happy_var_1 happy_var_2 (unLoc happy_var_2)))
                                            [mj AnnType happy_var_1,mj AnnVal happy_var_2])}}
	) (\r -> happyReturn (happyIn36 r))

happyReduce_63 = happySpecReduce_1  23# happyReduction_63
happyReduction_63 happy_x_1
	 =  case happyOut257 happy_x_1 of { happy_var_1 -> 
	happyIn37
		 (happy_var_1
	)}

happyReduce_64 = happySpecReduce_1  23# happyReduction_64
happyReduction_64 happy_x_1
	 =  case happyOut241 happy_x_1 of { happy_var_1 -> 
	happyIn37
		 (happy_var_1
	)}

happyReduce_65 = happyMonadReduce 3# 24# happyReduction_65
happyReduction_65 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut39 happy_x_3 of { happy_var_3 -> 
	( if null (snd happy_var_1)
                                     then return (mj AnnSemi happy_var_2:fst happy_var_1,happy_var_3 : snd happy_var_1)
                                     else do
                                      { addAnnotation (gl $ head $ snd happy_var_1)
                                                      AnnSemi (gl happy_var_2)
                                      ; return (fst happy_var_1,happy_var_3 : snd happy_var_1) })}}}
	) (\r -> happyReturn (happyIn38 r))

happyReduce_66 = happyMonadReduce 2# 24# happyReduction_66
happyReduction_66 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( if null (snd happy_var_1)
                                     then return ((mj AnnSemi happy_var_2:fst happy_var_1),snd happy_var_1)
                                     else do
                                       { addAnnotation (gl $ head $ snd happy_var_1)
                                                       AnnSemi (gl happy_var_2)
                                       ; return happy_var_1})}}
	) (\r -> happyReturn (happyIn38 r))

happyReduce_67 = happySpecReduce_1  24# happyReduction_67
happyReduction_67 happy_x_1
	 =  case happyOut39 happy_x_1 of { happy_var_1 -> 
	happyIn38
		 (([],[happy_var_1])
	)}

happyReduce_68 = happySpecReduce_0  24# happyReduction_68
happyReduction_68  =  happyIn38
		 (([],[])
	)

happyReduce_69 = happyMonadReduce 8# 25# happyReduction_69
happyReduction_69 (happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut40 happy_x_2 of { happy_var_2 -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	case happyOut43 happy_x_4 of { happy_var_4 -> 
	case happyOut42 happy_x_5 of { happy_var_5 -> 
	case happyOut273 happy_x_6 of { happy_var_6 -> 
	case happyOut44 happy_x_7 of { happy_var_7 -> 
	case happyOut45 happy_x_8 of { happy_var_8 -> 
	( ams (L (comb4 happy_var_1 happy_var_6 (snd happy_var_7) happy_var_8) $
                  ImportDecl { ideclSourceSrc = snd $ fst happy_var_2
                             , ideclName = happy_var_6, ideclPkgQual = snd happy_var_5
                             , ideclSource = snd happy_var_2, ideclSafe = snd happy_var_3
                             , ideclQualified = snd happy_var_4, ideclImplicit = False
                             , ideclAs = unLoc (snd happy_var_7)
                             , ideclHiding = unLoc happy_var_8 })
                   ((mj AnnImport happy_var_1 : (fst $ fst happy_var_2) ++ fst happy_var_3 ++ fst happy_var_4
                                    ++ fst happy_var_5 ++ fst happy_var_7)))}}}}}}}}
	) (\r -> happyReturn (happyIn39 r))

happyReduce_70 = happySpecReduce_2  26# happyReduction_70
happyReduction_70 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	happyIn40
		 ((([mo happy_var_1,mc happy_var_2],Just (getSOURCE_PRAGs happy_var_1))
                                      ,True)
	)}}

happyReduce_71 = happySpecReduce_0  26# happyReduction_71
happyReduction_71  =  happyIn40
		 ((([],Nothing),False)
	)

happyReduce_72 = happySpecReduce_1  27# happyReduction_72
happyReduction_72 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn41
		 (([mj AnnSafe happy_var_1],True)
	)}

happyReduce_73 = happySpecReduce_0  27# happyReduction_73
happyReduction_73  =  happyIn41
		 (([],False)
	)

happyReduce_74 = happyMonadReduce 1# 28# happyReduction_74
happyReduction_74 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	( let pkgFS = getSTRING happy_var_1 in
                     if looksLikePackageName (unpackFS pkgFS)
                        then return ([mj AnnPackageName happy_var_1], Just (StringLiteral (getSTRINGs happy_var_1) pkgFS))
                        else parseErrorSDoc (getLoc happy_var_1) $ vcat [
                             text "parse error" <> colon <+> quotes (ppr pkgFS),
                             text "Version number or non-alphanumeric" <+>
                             text "character in package name"])}
	) (\r -> happyReturn (happyIn42 r))

happyReduce_75 = happySpecReduce_0  28# happyReduction_75
happyReduction_75  =  happyIn42
		 (([],Nothing)
	)

happyReduce_76 = happySpecReduce_1  29# happyReduction_76
happyReduction_76 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn43
		 (([mj AnnQualified happy_var_1],True)
	)}

happyReduce_77 = happySpecReduce_0  29# happyReduction_77
happyReduction_77  =  happyIn43
		 (([],False)
	)

happyReduce_78 = happySpecReduce_2  30# happyReduction_78
happyReduction_78 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut273 happy_x_2 of { happy_var_2 -> 
	happyIn44
		 (([mj AnnAs happy_var_1,mj AnnVal happy_var_2]
                                                 ,sLL happy_var_1 happy_var_2 (Just (unLoc happy_var_2)))
	)}}

happyReduce_79 = happySpecReduce_0  30# happyReduction_79
happyReduction_79  =  happyIn44
		 (([],noLoc Nothing)
	)

happyReduce_80 = happyMonadReduce 1# 31# happyReduction_80
happyReduction_80 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut46 happy_x_1 of { happy_var_1 -> 
	( let (b, ie) = unLoc happy_var_1 in
                                       checkImportSpec ie
                                        >>= \checkedIe ->
                                          return (L (gl happy_var_1) (Just (b, checkedIe))))}
	) (\r -> happyReturn (happyIn45 r))

happyReduce_81 = happySpecReduce_0  31# happyReduction_81
happyReduction_81  =  happyIn45
		 (noLoc Nothing
	)

happyReduce_82 = happyMonadReduce 3# 32# happyReduction_82
happyReduction_82 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (False,
                                                      sLL happy_var_1 happy_var_3 $ fromOL happy_var_2))
                                                   [mop happy_var_1,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn46 r))

happyReduce_83 = happyMonadReduce 4# 32# happyReduction_83
happyReduction_83 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	( ams (sLL happy_var_1 happy_var_4 (True,
                                                      sLL happy_var_1 happy_var_4 $ fromOL happy_var_3))
                                               [mj AnnHiding happy_var_1,mop happy_var_2,mcp happy_var_4])}}}}
	) (\r -> happyReturn (happyIn46 r))

happyReduce_84 = happySpecReduce_0  33# happyReduction_84
happyReduction_84  =  happyIn47
		 (noLoc ("",9)
	)

happyReduce_85 = happyMonadReduce 1# 33# happyReduction_85
happyReduction_85 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	( checkPrecP (sL1 happy_var_1 (getINTEGERs happy_var_1,fromInteger (getINTEGER happy_var_1))))}
	) (\r -> happyReturn (happyIn47 r))

happyReduce_86 = happySpecReduce_1  34# happyReduction_86
happyReduction_86 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn48
		 (sL1 happy_var_1 InfixN
	)}

happyReduce_87 = happySpecReduce_1  34# happyReduction_87
happyReduction_87 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn48
		 (sL1 happy_var_1 InfixL
	)}

happyReduce_88 = happySpecReduce_1  34# happyReduction_88
happyReduction_88 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn48
		 (sL1 happy_var_1 InfixR
	)}

happyReduce_89 = happyMonadReduce 3# 35# happyReduction_89
happyReduction_89 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut49 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut247 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (oll $ unLoc happy_var_1) AnnComma (gl happy_var_2) >>
                              return (sLL happy_var_1 happy_var_3 ((unLoc happy_var_1) `appOL` unitOL happy_var_3)))}}}
	) (\r -> happyReturn (happyIn49 r))

happyReduce_90 = happySpecReduce_1  35# happyReduction_90
happyReduction_90 happy_x_1
	 =  case happyOut247 happy_x_1 of { happy_var_1 -> 
	happyIn49
		 (sL1 happy_var_1 (unitOL happy_var_1)
	)}

happyReduce_91 = happyMonadReduce 3# 36# happyReduction_91
happyReduction_91 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut50 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut51 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (oll happy_var_1) AnnSemi (gl happy_var_2)
                                         >> return (happy_var_1 `appOL` unitOL happy_var_3))}}}
	) (\r -> happyReturn (happyIn50 r))

happyReduce_92 = happyMonadReduce 2# 36# happyReduction_92
happyReduction_92 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut50 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( addAnnotation (oll happy_var_1) AnnSemi (gl happy_var_2)
                                         >> return happy_var_1)}}
	) (\r -> happyReturn (happyIn50 r))

happyReduce_93 = happySpecReduce_1  36# happyReduction_93
happyReduction_93 happy_x_1
	 =  case happyOut51 happy_x_1 of { happy_var_1 -> 
	happyIn50
		 (unitOL happy_var_1
	)}

happyReduce_94 = happySpecReduce_1  37# happyReduction_94
happyReduction_94 happy_x_1
	 =  case happyOut52 happy_x_1 of { happy_var_1 -> 
	happyIn51
		 (sL1 happy_var_1 (TyClD (unLoc happy_var_1))
	)}

happyReduce_95 = happySpecReduce_1  37# happyReduction_95
happyReduction_95 happy_x_1
	 =  case happyOut53 happy_x_1 of { happy_var_1 -> 
	happyIn51
		 (sL1 happy_var_1 (TyClD (unLoc happy_var_1))
	)}

happyReduce_96 = happySpecReduce_1  37# happyReduction_96
happyReduction_96 happy_x_1
	 =  case happyOut54 happy_x_1 of { happy_var_1 -> 
	happyIn51
		 (sL1 happy_var_1 (InstD (unLoc happy_var_1))
	)}

happyReduce_97 = happySpecReduce_1  37# happyReduction_97
happyReduction_97 happy_x_1
	 =  case happyOut73 happy_x_1 of { happy_var_1 -> 
	happyIn51
		 (sLL happy_var_1 happy_var_1 (DerivD (unLoc happy_var_1))
	)}

happyReduce_98 = happySpecReduce_1  37# happyReduction_98
happyReduction_98 happy_x_1
	 =  case happyOut74 happy_x_1 of { happy_var_1 -> 
	happyIn51
		 (sL1 happy_var_1 (RoleAnnotD (unLoc happy_var_1))
	)}

happyReduce_99 = happyMonadReduce 4# 37# happyReduction_99
happyReduction_99 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut136 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	( ams (sLL happy_var_1 happy_var_4 (DefD (DefaultDecl happy_var_3)))
                                                         [mj AnnDefault happy_var_1
                                                         ,mop happy_var_2,mcp happy_var_4])}}}}
	) (\r -> happyReturn (happyIn51 r))

happyReduce_100 = happyMonadReduce 2# 37# happyReduction_100
happyReduction_100 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut110 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 (snd $ unLoc happy_var_2))
                                           (mj AnnForeign happy_var_1:(fst $ unLoc happy_var_2)))}}
	) (\r -> happyReturn (happyIn51 r))

happyReduce_101 = happyMonadReduce 3# 37# happyReduction_101
happyReduction_101 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut105 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ WarningD (Warnings (getDEPRECATED_PRAGs happy_var_1) (fromOL happy_var_2)))
                                                       [mo happy_var_1,mc happy_var_3])}}}
	) (\r -> happyReturn (happyIn51 r))

happyReduce_102 = happyMonadReduce 3# 37# happyReduction_102
happyReduction_102 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut103 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ WarningD (Warnings (getWARNING_PRAGs happy_var_1) (fromOL happy_var_2)))
                                                       [mo happy_var_1,mc happy_var_3])}}}
	) (\r -> happyReturn (happyIn51 r))

happyReduce_103 = happyMonadReduce 3# 37# happyReduction_103
happyReduction_103 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut96 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ RuleD (HsRules (getRULES_PRAGs happy_var_1) (fromOL happy_var_2)))
                                                       [mo happy_var_1,mc happy_var_3])}}}
	) (\r -> happyReturn (happyIn51 r))

happyReduce_104 = happyMonadReduce 5# 37# happyReduction_104
happyReduction_104 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut257 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut169 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { happy_var_5 -> 
	( ams (sLL happy_var_1 happy_var_5 $ VectD (HsVect (getVECT_PRAGs happy_var_1) happy_var_2 happy_var_4))
                                                    [mo happy_var_1,mj AnnEqual happy_var_3
                                                    ,mc happy_var_5])}}}}}
	) (\r -> happyReturn (happyIn51 r))

happyReduce_105 = happyMonadReduce 3# 37# happyReduction_105
happyReduction_105 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut257 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ VectD (HsNoVect (getNOVECT_PRAGs happy_var_1) happy_var_2))
                                                     [mo happy_var_1,mc happy_var_3])}}}
	) (\r -> happyReturn (happyIn51 r))

happyReduce_106 = happyMonadReduce 4# 37# happyReduction_106
happyReduction_106 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut238 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	( ams (sLL happy_var_1 happy_var_4 $
                                    VectD (HsVectTypeIn (getVECT_PRAGs happy_var_1) False happy_var_3 Nothing))
                                    [mo happy_var_1,mj AnnType happy_var_2,mc happy_var_4])}}}}
	) (\r -> happyReturn (happyIn51 r))

happyReduce_107 = happyMonadReduce 4# 37# happyReduction_107
happyReduction_107 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut238 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	( ams (sLL happy_var_1 happy_var_4 $
                                    VectD (HsVectTypeIn (getVECT_SCALAR_PRAGs happy_var_1) True happy_var_3 Nothing))
                                    [mo happy_var_1,mj AnnType happy_var_2,mc happy_var_4])}}}}
	) (\r -> happyReturn (happyIn51 r))

happyReduce_108 = happyMonadReduce 6# 37# happyReduction_108
happyReduction_108 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut238 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	case happyOut238 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { happy_var_6 -> 
	( ams (sLL happy_var_1 happy_var_6 $
                                    VectD (HsVectTypeIn (getVECT_PRAGs happy_var_1) False happy_var_3 (Just happy_var_5)))
                                    [mo happy_var_1,mj AnnType happy_var_2,mj AnnEqual happy_var_4,mc happy_var_6])}}}}}}
	) (\r -> happyReturn (happyIn51 r))

happyReduce_109 = happyMonadReduce 6# 37# happyReduction_109
happyReduction_109 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut238 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	case happyOut238 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { happy_var_6 -> 
	( ams (sLL happy_var_1 happy_var_6 $
                                    VectD (HsVectTypeIn (getVECT_SCALAR_PRAGs happy_var_1) True happy_var_3 (Just happy_var_5)))
                                    [mo happy_var_1,mj AnnType happy_var_2,mj AnnEqual happy_var_4,mc happy_var_6])}}}}}}
	) (\r -> happyReturn (happyIn51 r))

happyReduce_110 = happyMonadReduce 4# 37# happyReduction_110
happyReduction_110 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut238 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	( ams (sLL happy_var_1 happy_var_4  $ VectD (HsVectClassIn (getVECT_PRAGs happy_var_1) happy_var_3))
                                                 [mo happy_var_1,mj AnnClass happy_var_2,mc happy_var_4])}}}}
	) (\r -> happyReturn (happyIn51 r))

happyReduce_111 = happySpecReduce_1  37# happyReduction_111
happyReduction_111 happy_x_1
	 =  case happyOut109 happy_x_1 of { happy_var_1 -> 
	happyIn51
		 (happy_var_1
	)}

happyReduce_112 = happySpecReduce_1  37# happyReduction_112
happyReduction_112 happy_x_1
	 =  case happyOut160 happy_x_1 of { happy_var_1 -> 
	happyIn51
		 (happy_var_1
	)}

happyReduce_113 = happySpecReduce_1  37# happyReduction_113
happyReduction_113 happy_x_1
	 =  case happyOut170 happy_x_1 of { happy_var_1 -> 
	happyIn51
		 (sLL happy_var_1 happy_var_1 $ mkSpliceDecl happy_var_1
	)}

happyReduce_114 = happyMonadReduce 4# 38# happyReduction_114
happyReduction_114 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut71 happy_x_2 of { happy_var_2 -> 
	case happyOut140 happy_x_3 of { happy_var_3 -> 
	case happyOut87 happy_x_4 of { happy_var_4 -> 
	( amms (mkClassDecl (comb4 happy_var_1 happy_var_2 happy_var_3 happy_var_4) happy_var_2 happy_var_3 (snd $ unLoc happy_var_4))
                        (mj AnnClass happy_var_1:(fst $ unLoc happy_var_3)++(fst $ unLoc happy_var_4)))}}}}
	) (\r -> happyReturn (happyIn52 r))

happyReduce_115 = happyMonadReduce 4# 39# happyReduction_115
happyReduction_115 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut127 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut124 happy_x_4 of { happy_var_4 -> 
	( amms (mkTySynonym (comb2 happy_var_1 happy_var_4) happy_var_2 happy_var_4)
                        [mj AnnType happy_var_1,mj AnnEqual happy_var_3])}}}}
	) (\r -> happyReturn (happyIn53 r))

happyReduce_116 = happyMonadReduce 6# 39# happyReduction_116
happyReduction_116 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut127 happy_x_3 of { happy_var_3 -> 
	case happyOut69 happy_x_4 of { happy_var_4 -> 
	case happyOut56 happy_x_5 of { happy_var_5 -> 
	case happyOut59 happy_x_6 of { happy_var_6 -> 
	( amms (mkFamDecl (comb4 happy_var_1 happy_var_3 happy_var_4 happy_var_5) (snd $ unLoc happy_var_6) happy_var_3
                                   (snd $ unLoc happy_var_4) (snd $ unLoc happy_var_5))
                        (mj AnnType happy_var_1:mj AnnFamily happy_var_2:(fst $ unLoc happy_var_4)
                           ++ (fst $ unLoc happy_var_5) ++ (fst $ unLoc happy_var_6)))}}}}}}
	) (\r -> happyReturn (happyIn53 r))

happyReduce_117 = happyMonadReduce 5# 39# happyReduction_117
happyReduction_117 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut66 happy_x_1 of { happy_var_1 -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	case happyOut71 happy_x_3 of { happy_var_3 -> 
	case happyOut149 happy_x_4 of { happy_var_4 -> 
	case happyOut157 happy_x_5 of { happy_var_5 -> 
	( amms (mkTyData (comb4 happy_var_1 happy_var_3 happy_var_4 happy_var_5) (snd $ unLoc happy_var_1) happy_var_2 happy_var_3
                           Nothing (reverse (snd $ unLoc happy_var_4))
                                   (unLoc happy_var_5))
                                   -- We need the location on tycl_hdr in case
                                   -- constrs and deriving are both empty
                        ((fst $ unLoc happy_var_1):(fst $ unLoc happy_var_4)))}}}}}
	) (\r -> happyReturn (happyIn53 r))

happyReduce_118 = happyMonadReduce 6# 39# happyReduction_118
happyReduction_118 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut66 happy_x_1 of { happy_var_1 -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	case happyOut71 happy_x_3 of { happy_var_3 -> 
	case happyOut67 happy_x_4 of { happy_var_4 -> 
	case happyOut145 happy_x_5 of { happy_var_5 -> 
	case happyOut157 happy_x_6 of { happy_var_6 -> 
	( amms (mkTyData (comb4 happy_var_1 happy_var_3 happy_var_5 happy_var_6) (snd $ unLoc happy_var_1) happy_var_2 happy_var_3
                            (snd $ unLoc happy_var_4) (snd $ unLoc happy_var_5) (unLoc happy_var_6) )
                                   -- We need the location on tycl_hdr in case
                                   -- constrs and deriving are both empty
                    ((fst $ unLoc happy_var_1):(fst $ unLoc happy_var_4)++(fst $ unLoc happy_var_5)))}}}}}}
	) (\r -> happyReturn (happyIn53 r))

happyReduce_119 = happyMonadReduce 4# 39# happyReduction_119
happyReduction_119 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut127 happy_x_3 of { happy_var_3 -> 
	case happyOut68 happy_x_4 of { happy_var_4 -> 
	( amms (mkFamDecl (comb3 happy_var_1 happy_var_2 happy_var_4) DataFamily happy_var_3
                                   (snd $ unLoc happy_var_4) Nothing)
                        (mj AnnData happy_var_1:mj AnnFamily happy_var_2:(fst $ unLoc happy_var_4)))}}}}
	) (\r -> happyReturn (happyIn53 r))

happyReduce_120 = happyMonadReduce 4# 40# happyReduction_120
happyReduction_120 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut55 happy_x_2 of { happy_var_2 -> 
	case happyOut134 happy_x_3 of { happy_var_3 -> 
	case happyOut91 happy_x_4 of { happy_var_4 -> 
	( do { (binds, sigs, _, ats, adts, _) <- cvBindsAndSigs (snd $ unLoc happy_var_4)
             ; let cid = ClsInstDecl { cid_poly_ty = happy_var_3, cid_binds = binds
                                     , cid_sigs = mkClassOpSigs sigs
                                     , cid_tyfam_insts = ats
                                     , cid_overlap_mode = happy_var_2
                                     , cid_datafam_insts = adts }
             ; ams (L (comb3 happy_var_1 (hsSigType happy_var_3) happy_var_4) (ClsInstD { cid_inst = cid }))
                   (mj AnnInstance happy_var_1 : (fst $ unLoc happy_var_4)) })}}}}
	) (\r -> happyReturn (happyIn54 r))

happyReduce_121 = happyMonadReduce 3# 40# happyReduction_121
happyReduction_121 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut62 happy_x_3 of { happy_var_3 -> 
	( ams happy_var_3 (fst $ unLoc happy_var_3)
                >> amms (mkTyFamInst (comb2 happy_var_1 happy_var_3) (snd $ unLoc happy_var_3))
                    (mj AnnType happy_var_1:mj AnnInstance happy_var_2:(fst $ unLoc happy_var_3)))}}}
	) (\r -> happyReturn (happyIn54 r))

happyReduce_122 = happyMonadReduce 6# 40# happyReduction_122
happyReduction_122 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut66 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut72 happy_x_3 of { happy_var_3 -> 
	case happyOut71 happy_x_4 of { happy_var_4 -> 
	case happyOut149 happy_x_5 of { happy_var_5 -> 
	case happyOut157 happy_x_6 of { happy_var_6 -> 
	( amms (mkDataFamInst (comb4 happy_var_1 happy_var_4 happy_var_5 happy_var_6) (snd $ unLoc happy_var_1) happy_var_3 happy_var_4
                                      Nothing (reverse (snd  $ unLoc happy_var_5))
                                              (unLoc happy_var_6))
                    ((fst $ unLoc happy_var_1):mj AnnInstance happy_var_2:(fst $ unLoc happy_var_5)))}}}}}}
	) (\r -> happyReturn (happyIn54 r))

happyReduce_123 = happyMonadReduce 7# 40# happyReduction_123
happyReduction_123 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut66 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut72 happy_x_3 of { happy_var_3 -> 
	case happyOut71 happy_x_4 of { happy_var_4 -> 
	case happyOut67 happy_x_5 of { happy_var_5 -> 
	case happyOut145 happy_x_6 of { happy_var_6 -> 
	case happyOut157 happy_x_7 of { happy_var_7 -> 
	( amms (mkDataFamInst (comb4 happy_var_1 happy_var_4 happy_var_6 happy_var_7) (snd $ unLoc happy_var_1) happy_var_3 happy_var_4
                                   (snd $ unLoc happy_var_5) (snd $ unLoc happy_var_6) (unLoc happy_var_7))
                    ((fst $ unLoc happy_var_1):mj AnnInstance happy_var_2
                       :(fst $ unLoc happy_var_5)++(fst $ unLoc happy_var_6)))}}}}}}}
	) (\r -> happyReturn (happyIn54 r))

happyReduce_124 = happyMonadReduce 2# 41# happyReduction_124
happyReduction_124 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( ajs (Just (sLL happy_var_1 happy_var_2 (Overlappable (getOVERLAPPABLE_PRAGs happy_var_1))))
                                       [mo happy_var_1,mc happy_var_2])}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_125 = happyMonadReduce 2# 41# happyReduction_125
happyReduction_125 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( ajs (Just (sLL happy_var_1 happy_var_2 (Overlapping (getOVERLAPPING_PRAGs happy_var_1))))
                                       [mo happy_var_1,mc happy_var_2])}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_126 = happyMonadReduce 2# 41# happyReduction_126
happyReduction_126 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( ajs (Just (sLL happy_var_1 happy_var_2 (Overlaps (getOVERLAPS_PRAGs happy_var_1))))
                                       [mo happy_var_1,mc happy_var_2])}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_127 = happyMonadReduce 2# 41# happyReduction_127
happyReduction_127 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( ajs (Just (sLL happy_var_1 happy_var_2 (Incoherent (getINCOHERENT_PRAGs happy_var_1))))
                                       [mo happy_var_1,mc happy_var_2])}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_128 = happySpecReduce_0  41# happyReduction_128
happyReduction_128  =  happyIn55
		 (Nothing
	)

happyReduce_129 = happySpecReduce_0  42# happyReduction_129
happyReduction_129  =  happyIn56
		 (noLoc ([], Nothing)
	)

happyReduce_130 = happySpecReduce_2  42# happyReduction_130
happyReduction_130 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut57 happy_x_2 of { happy_var_2 -> 
	happyIn56
		 (sLL happy_var_1 happy_var_2 ([mj AnnVbar happy_var_1]
                                                , Just (happy_var_2))
	)}}

happyReduce_131 = happyMonadReduce 3# 43# happyReduction_131
happyReduction_131 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut255 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (InjectivityAnn happy_var_1 (reverse (unLoc happy_var_3))))
                  [mu AnnRarrow happy_var_2])}}}
	) (\r -> happyReturn (happyIn57 r))

happyReduce_132 = happySpecReduce_2  44# happyReduction_132
happyReduction_132 happy_x_2
	happy_x_1
	 =  case happyOut58 happy_x_1 of { happy_var_1 -> 
	case happyOut255 happy_x_2 of { happy_var_2 -> 
	happyIn58
		 (sLL happy_var_1 happy_var_2 (happy_var_2 : unLoc happy_var_1)
	)}}

happyReduce_133 = happySpecReduce_1  44# happyReduction_133
happyReduction_133 happy_x_1
	 =  case happyOut255 happy_x_1 of { happy_var_1 -> 
	happyIn58
		 (sLL happy_var_1 happy_var_1 [happy_var_1]
	)}

happyReduce_134 = happySpecReduce_0  45# happyReduction_134
happyReduction_134  =  happyIn59
		 (noLoc ([],OpenTypeFamily)
	)

happyReduce_135 = happySpecReduce_2  45# happyReduction_135
happyReduction_135 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut60 happy_x_2 of { happy_var_2 -> 
	happyIn59
		 (sLL happy_var_1 happy_var_2 (mj AnnWhere happy_var_1:(fst $ unLoc happy_var_2)
                    ,ClosedTypeFamily (fmap reverse $ snd $ unLoc happy_var_2))
	)}}

happyReduce_136 = happySpecReduce_3  46# happyReduction_136
happyReduction_136 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut61 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn60
		 (sLL happy_var_1 happy_var_3 ([moc happy_var_1,mcc happy_var_3]
                                                ,Just (unLoc happy_var_2))
	)}}}

happyReduce_137 = happySpecReduce_3  46# happyReduction_137
happyReduction_137 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut61 happy_x_2 of { happy_var_2 -> 
	happyIn60
		 (let L loc _ = happy_var_2 in
                                             L loc ([],Just (unLoc happy_var_2))
	)}

happyReduce_138 = happySpecReduce_3  46# happyReduction_138
happyReduction_138 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn60
		 (sLL happy_var_1 happy_var_3 ([moc happy_var_1,mj AnnDotdot happy_var_2
                                                 ,mcc happy_var_3],Nothing)
	)}}}

happyReduce_139 = happySpecReduce_3  46# happyReduction_139
happyReduction_139 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_2 of { happy_var_2 -> 
	happyIn60
		 (let L loc _ = happy_var_2 in
                                             L loc ([mj AnnDotdot happy_var_2],Nothing)
	)}

happyReduce_140 = happyMonadReduce 3# 47# happyReduction_140
happyReduction_140 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut61 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut62 happy_x_3 of { happy_var_3 -> 
	( asl (unLoc happy_var_1) happy_var_2 (snd $ unLoc happy_var_3)
                                         >> ams happy_var_3 (fst $ unLoc happy_var_3)
                                         >> return (sLL happy_var_1 happy_var_3 ((snd $ unLoc happy_var_3) : unLoc happy_var_1)))}}}
	) (\r -> happyReturn (happyIn61 r))

happyReduce_141 = happyMonadReduce 2# 47# happyReduction_141
happyReduction_141 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut61 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( addAnnotation (gl happy_var_1) AnnSemi (gl happy_var_2)
                                         >> return (sLL happy_var_1 happy_var_2  (unLoc happy_var_1)))}}
	) (\r -> happyReturn (happyIn61 r))

happyReduce_142 = happyMonadReduce 1# 47# happyReduction_142
happyReduction_142 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut62 happy_x_1 of { happy_var_1 -> 
	( ams happy_var_1 (fst $ unLoc happy_var_1)
                                         >> return (sLL happy_var_1 happy_var_1 [snd $ unLoc happy_var_1]))}
	) (\r -> happyReturn (happyIn61 r))

happyReduce_143 = happySpecReduce_0  47# happyReduction_143
happyReduction_143  =  happyIn61
		 (noLoc []
	)

happyReduce_144 = happyMonadReduce 3# 48# happyReduction_144
happyReduction_144 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut127 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut123 happy_x_3 of { happy_var_3 -> 
	( do { (eqn,ann) <- mkTyFamInstEqn happy_var_1 happy_var_3
                    ; return (sLL happy_var_1 happy_var_3 (mj AnnEqual happy_var_2:ann, sLL happy_var_1 happy_var_3 eqn))  })}}}
	) (\r -> happyReturn (happyIn62 r))

happyReduce_145 = happyMonadReduce 4# 49# happyReduction_145
happyReduction_145 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut64 happy_x_2 of { happy_var_2 -> 
	case happyOut127 happy_x_3 of { happy_var_3 -> 
	case happyOut68 happy_x_4 of { happy_var_4 -> 
	( amms (liftM mkTyClD (mkFamDecl (comb3 happy_var_1 happy_var_3 happy_var_4) DataFamily happy_var_3
                                                  (snd $ unLoc happy_var_4) Nothing))
                        (mj AnnData happy_var_1:happy_var_2++(fst $ unLoc happy_var_4)))}}}}
	) (\r -> happyReturn (happyIn63 r))

happyReduce_146 = happyMonadReduce 3# 49# happyReduction_146
happyReduction_146 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut127 happy_x_2 of { happy_var_2 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	( amms (liftM mkTyClD
                        (mkFamDecl (comb3 happy_var_1 happy_var_2 happy_var_3) OpenTypeFamily happy_var_2
                                   (fst . snd $ unLoc happy_var_3)
                                   (snd . snd $ unLoc happy_var_3)))
                       (mj AnnType happy_var_1:(fst $ unLoc happy_var_3)))}}}
	) (\r -> happyReturn (happyIn63 r))

happyReduce_147 = happyMonadReduce 4# 49# happyReduction_147
happyReduction_147 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut127 happy_x_3 of { happy_var_3 -> 
	case happyOut70 happy_x_4 of { happy_var_4 -> 
	( amms (liftM mkTyClD
                        (mkFamDecl (comb3 happy_var_1 happy_var_3 happy_var_4) OpenTypeFamily happy_var_3
                                   (fst . snd $ unLoc happy_var_4)
                                   (snd . snd $ unLoc happy_var_4)))
                       (mj AnnType happy_var_1:mj AnnFamily happy_var_2:(fst $ unLoc happy_var_4)))}}}}
	) (\r -> happyReturn (happyIn63 r))

happyReduce_148 = happyMonadReduce 2# 49# happyReduction_148
happyReduction_148 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut62 happy_x_2 of { happy_var_2 -> 
	( ams happy_var_2 (fst $ unLoc happy_var_2) >>
                   amms (liftM mkInstD (mkTyFamInst (comb2 happy_var_1 happy_var_2) (snd $ unLoc happy_var_2)))
                        (mj AnnType happy_var_1:(fst $ unLoc happy_var_2)))}}
	) (\r -> happyReturn (happyIn63 r))

happyReduce_149 = happyMonadReduce 3# 49# happyReduction_149
happyReduction_149 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut62 happy_x_3 of { happy_var_3 -> 
	( ams happy_var_3 (fst $ unLoc happy_var_3) >>
                   amms (liftM mkInstD (mkTyFamInst (comb2 happy_var_1 happy_var_3) (snd $ unLoc happy_var_3)))
                        (mj AnnType happy_var_1:mj AnnInstance happy_var_2:(fst $ unLoc happy_var_3)))}}}
	) (\r -> happyReturn (happyIn63 r))

happyReduce_150 = happySpecReduce_0  50# happyReduction_150
happyReduction_150  =  happyIn64
		 ([]
	)

happyReduce_151 = happySpecReduce_1  50# happyReduction_151
happyReduction_151 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn64
		 ([mj AnnFamily happy_var_1]
	)}

happyReduce_152 = happyMonadReduce 2# 51# happyReduction_152
happyReduction_152 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut62 happy_x_2 of { happy_var_2 -> 
	( ams happy_var_2 (fst $ unLoc happy_var_2) >>
                   amms (mkTyFamInst (comb2 happy_var_1 happy_var_2) (snd $ unLoc happy_var_2))
                        (mj AnnType happy_var_1:(fst $ unLoc happy_var_2)))}}
	) (\r -> happyReturn (happyIn65 r))

happyReduce_153 = happyMonadReduce 5# 51# happyReduction_153
happyReduction_153 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut66 happy_x_1 of { happy_var_1 -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	case happyOut71 happy_x_3 of { happy_var_3 -> 
	case happyOut149 happy_x_4 of { happy_var_4 -> 
	case happyOut157 happy_x_5 of { happy_var_5 -> 
	( amms (mkDataFamInst (comb4 happy_var_1 happy_var_3 happy_var_4 happy_var_5) (snd $ unLoc happy_var_1) happy_var_2 happy_var_3
                                    Nothing (reverse (snd $ unLoc happy_var_4))
                                            (unLoc happy_var_5))
                       ((fst $ unLoc happy_var_1):(fst $ unLoc happy_var_4)))}}}}}
	) (\r -> happyReturn (happyIn65 r))

happyReduce_154 = happyMonadReduce 6# 51# happyReduction_154
happyReduction_154 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut66 happy_x_1 of { happy_var_1 -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	case happyOut71 happy_x_3 of { happy_var_3 -> 
	case happyOut67 happy_x_4 of { happy_var_4 -> 
	case happyOut145 happy_x_5 of { happy_var_5 -> 
	case happyOut157 happy_x_6 of { happy_var_6 -> 
	( amms (mkDataFamInst (comb4 happy_var_1 happy_var_3 happy_var_5 happy_var_6) (snd $ unLoc happy_var_1) happy_var_2
                                happy_var_3 (snd $ unLoc happy_var_4) (snd $ unLoc happy_var_5) (unLoc happy_var_6))
                        ((fst $ unLoc happy_var_1):(fst $ unLoc happy_var_4)++(fst $ unLoc happy_var_5)))}}}}}}
	) (\r -> happyReturn (happyIn65 r))

happyReduce_155 = happySpecReduce_1  52# happyReduction_155
happyReduction_155 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn66
		 (sL1 happy_var_1 (mj AnnData    happy_var_1,DataType)
	)}

happyReduce_156 = happySpecReduce_1  52# happyReduction_156
happyReduction_156 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn66
		 (sL1 happy_var_1 (mj AnnNewtype happy_var_1,NewType)
	)}

happyReduce_157 = happySpecReduce_0  53# happyReduction_157
happyReduction_157  =  happyIn67
		 (noLoc     ([]               , Nothing)
	)

happyReduce_158 = happySpecReduce_2  53# happyReduction_158
happyReduction_158 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut144 happy_x_2 of { happy_var_2 -> 
	happyIn67
		 (sLL happy_var_1 happy_var_2 ([mu AnnDcolon happy_var_1], Just happy_var_2)
	)}}

happyReduce_159 = happySpecReduce_0  54# happyReduction_159
happyReduction_159  =  happyIn68
		 (noLoc     ([]               , noLoc NoSig           )
	)

happyReduce_160 = happySpecReduce_2  54# happyReduction_160
happyReduction_160 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut144 happy_x_2 of { happy_var_2 -> 
	happyIn68
		 (sLL happy_var_1 happy_var_2 ([mu AnnDcolon happy_var_1], sLL happy_var_1 happy_var_2 (KindSig happy_var_2))
	)}}

happyReduce_161 = happySpecReduce_0  55# happyReduction_161
happyReduction_161  =  happyIn69
		 (noLoc     ([]               , noLoc      NoSig       )
	)

happyReduce_162 = happySpecReduce_2  55# happyReduction_162
happyReduction_162 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut144 happy_x_2 of { happy_var_2 -> 
	happyIn69
		 (sLL happy_var_1 happy_var_2 ([mu AnnDcolon happy_var_1], sLL happy_var_1 happy_var_2 (KindSig  happy_var_2))
	)}}

happyReduce_163 = happySpecReduce_2  55# happyReduction_163
happyReduction_163 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut139 happy_x_2 of { happy_var_2 -> 
	happyIn69
		 (sLL happy_var_1 happy_var_2 ([mj AnnEqual happy_var_1] , sLL happy_var_1 happy_var_2 (TyVarSig happy_var_2))
	)}}

happyReduce_164 = happySpecReduce_0  56# happyReduction_164
happyReduction_164  =  happyIn70
		 (noLoc ([], (noLoc NoSig, Nothing))
	)

happyReduce_165 = happySpecReduce_2  56# happyReduction_165
happyReduction_165 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut144 happy_x_2 of { happy_var_2 -> 
	happyIn70
		 (sLL happy_var_1 happy_var_2 ( [mu AnnDcolon happy_var_1]
                                 , (sLL happy_var_2 happy_var_2 (KindSig happy_var_2), Nothing))
	)}}

happyReduce_166 = happyReduce 4# 56# happyReduction_166
happyReduction_166 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut139 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut57 happy_x_4 of { happy_var_4 -> 
	happyIn70
		 (sLL happy_var_1 happy_var_4 ([mj AnnEqual happy_var_1, mj AnnVbar happy_var_3]
                            , (sLL happy_var_1 happy_var_2 (TyVarSig happy_var_2), Just happy_var_4))
	) `HappyStk` happyRest}}}}

happyReduce_167 = happyMonadReduce 3# 57# happyReduction_167
happyReduction_167 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut125 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut127 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl happy_var_1) (toUnicodeAnn AnnDarrow happy_var_2) (gl happy_var_2)
                                       >> (return (sLL happy_var_1 happy_var_3 (Just happy_var_1, happy_var_3))))}}}
	) (\r -> happyReturn (happyIn71 r))

happyReduce_168 = happySpecReduce_1  57# happyReduction_168
happyReduction_168 happy_x_1
	 =  case happyOut127 happy_x_1 of { happy_var_1 -> 
	happyIn71
		 (sL1 happy_var_1 (Nothing, happy_var_1)
	)}

happyReduce_169 = happyMonadReduce 4# 58# happyReduction_169
happyReduction_169 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	( ajs (Just (sLL happy_var_1 happy_var_4 (CType (getCTYPEs happy_var_1) (Just (Header (getSTRINGs happy_var_2) (getSTRING happy_var_2)))
                                        (getSTRINGs happy_var_3,getSTRING happy_var_3))))
                              [mo happy_var_1,mj AnnHeader happy_var_2,mj AnnVal happy_var_3,mc happy_var_4])}}}}
	) (\r -> happyReturn (happyIn72 r))

happyReduce_170 = happyMonadReduce 3# 58# happyReduction_170
happyReduction_170 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ajs (Just (sLL happy_var_1 happy_var_3 (CType (getCTYPEs happy_var_1) Nothing  (getSTRINGs happy_var_2, getSTRING happy_var_2))))
                              [mo happy_var_1,mj AnnVal happy_var_2,mc happy_var_3])}}}
	) (\r -> happyReturn (happyIn72 r))

happyReduce_171 = happySpecReduce_0  58# happyReduction_171
happyReduction_171  =  happyIn72
		 (Nothing
	)

happyReduce_172 = happyMonadReduce 4# 59# happyReduction_172
happyReduction_172 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut55 happy_x_3 of { happy_var_3 -> 
	case happyOut134 happy_x_4 of { happy_var_4 -> 
	( do { let { err = text "in the stand-alone deriving instance"
                                             <> colon <+> quotes (ppr happy_var_4) }
                               ; ams (sLL happy_var_1 (hsSigType happy_var_4) (DerivDecl happy_var_4 happy_var_3))
                                     [mj AnnDeriving happy_var_1, mj AnnInstance happy_var_2] })}}}}
	) (\r -> happyReturn (happyIn73 r))

happyReduce_173 = happyMonadReduce 4# 60# happyReduction_173
happyReduction_173 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut240 happy_x_3 of { happy_var_3 -> 
	case happyOut75 happy_x_4 of { happy_var_4 -> 
	( amms (mkRoleAnnotDecl (comb3 happy_var_1 happy_var_3 happy_var_4) happy_var_3 (reverse (unLoc happy_var_4)))
                  [mj AnnType happy_var_1,mj AnnRole happy_var_2])}}}}
	) (\r -> happyReturn (happyIn74 r))

happyReduce_174 = happySpecReduce_0  61# happyReduction_174
happyReduction_174  =  happyIn75
		 (noLoc []
	)

happyReduce_175 = happySpecReduce_1  61# happyReduction_175
happyReduction_175 happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	happyIn75
		 (happy_var_1
	)}

happyReduce_176 = happySpecReduce_1  62# happyReduction_176
happyReduction_176 happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	happyIn76
		 (sLL happy_var_1 happy_var_1 [happy_var_1]
	)}

happyReduce_177 = happySpecReduce_2  62# happyReduction_177
happyReduction_177 happy_x_2
	happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	case happyOut77 happy_x_2 of { happy_var_2 -> 
	happyIn76
		 (sLL happy_var_1 happy_var_2 $ happy_var_2 : unLoc happy_var_1
	)}}

happyReduce_178 = happySpecReduce_1  63# happyReduction_178
happyReduction_178 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (sL1 happy_var_1 $ Just $ getVARID happy_var_1
	)}

happyReduce_179 = happySpecReduce_1  63# happyReduction_179
happyReduction_179 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (sL1 happy_var_1 Nothing
	)}

happyReduce_180 = happyMonadReduce 4# 64# happyReduction_180
happyReduction_180 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut79 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut207 happy_x_4 of { happy_var_4 -> 
	(      let (name, args,as ) = happy_var_2 in
                 ams (sLL happy_var_1 happy_var_4 . ValD $ mkPatSynBind name args happy_var_4
                                                    ImplicitBidirectional)
               (as ++ [mj AnnPattern happy_var_1, mj AnnEqual happy_var_3]))}}}}
	) (\r -> happyReturn (happyIn78 r))

happyReduce_181 = happyMonadReduce 4# 64# happyReduction_181
happyReduction_181 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut79 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut207 happy_x_4 of { happy_var_4 -> 
	(    let (name, args, as) = happy_var_2 in
               ams (sLL happy_var_1 happy_var_4 . ValD $ mkPatSynBind name args happy_var_4 Unidirectional)
               (as ++ [mj AnnPattern happy_var_1,mu AnnLarrow happy_var_3]))}}}}
	) (\r -> happyReturn (happyIn78 r))

happyReduce_182 = happyMonadReduce 5# 64# happyReduction_182
happyReduction_182 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut79 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut207 happy_x_4 of { happy_var_4 -> 
	case happyOut82 happy_x_5 of { happy_var_5 -> 
	( do { let (name, args, as) = happy_var_2
                  ; mg <- mkPatSynMatchGroup name (snd $ unLoc happy_var_5)
                  ; ams (sLL happy_var_1 happy_var_5 . ValD $
                           mkPatSynBind name args happy_var_4 (ExplicitBidirectional mg))
                       (as ++ ((mj AnnPattern happy_var_1:mu AnnLarrow happy_var_3:(fst $ unLoc happy_var_5))) )
                   })}}}}}
	) (\r -> happyReturn (happyIn78 r))

happyReduce_183 = happySpecReduce_2  65# happyReduction_183
happyReduction_183 happy_x_2
	happy_x_1
	 =  case happyOut232 happy_x_1 of { happy_var_1 -> 
	case happyOut80 happy_x_2 of { happy_var_2 -> 
	happyIn79
		 ((happy_var_1, PrefixPatSyn happy_var_2, [])
	)}}

happyReduce_184 = happySpecReduce_3  65# happyReduction_184
happyReduction_184 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut259 happy_x_1 of { happy_var_1 -> 
	case happyOut236 happy_x_2 of { happy_var_2 -> 
	case happyOut259 happy_x_3 of { happy_var_3 -> 
	happyIn79
		 ((happy_var_2, InfixPatSyn happy_var_1 happy_var_3, [])
	)}}}

happyReduce_185 = happyReduce 4# 65# happyReduction_185
happyReduction_185 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut232 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut81 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	happyIn79
		 ((happy_var_1, RecordPatSyn happy_var_3, [moc happy_var_2, mcc happy_var_4] )
	) `HappyStk` happyRest}}}}

happyReduce_186 = happySpecReduce_0  66# happyReduction_186
happyReduction_186  =  happyIn80
		 ([]
	)

happyReduce_187 = happySpecReduce_2  66# happyReduction_187
happyReduction_187 happy_x_2
	happy_x_1
	 =  case happyOut259 happy_x_1 of { happy_var_1 -> 
	case happyOut80 happy_x_2 of { happy_var_2 -> 
	happyIn80
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_188 = happySpecReduce_1  67# happyReduction_188
happyReduction_188 happy_x_1
	 =  case happyOut259 happy_x_1 of { happy_var_1 -> 
	happyIn81
		 ([RecordPatSynField happy_var_1 happy_var_1]
	)}

happyReduce_189 = happyMonadReduce 3# 67# happyReduction_189
happyReduction_189 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut259 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut81 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (getLoc happy_var_1) AnnComma (getLoc happy_var_2) >>
                                         return ((RecordPatSynField happy_var_1 happy_var_1) : happy_var_3 ))}}}
	) (\r -> happyReturn (happyIn81 r))

happyReduce_190 = happyReduce 4# 68# happyReduction_190
happyReduction_190 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut92 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	happyIn82
		 (sLL happy_var_1 happy_var_4 ((mj AnnWhere happy_var_1:moc happy_var_2
                                           :mcc happy_var_4:(fst $ unLoc happy_var_3)),sL1 happy_var_3 (snd $ unLoc happy_var_3))
	) `HappyStk` happyRest}}}}

happyReduce_191 = happyReduce 4# 68# happyReduction_191
happyReduction_191 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut92 happy_x_3 of { happy_var_3 -> 
	happyIn82
		 (L (comb2 happy_var_1 happy_var_3) ((mj AnnWhere happy_var_1:(fst $ unLoc happy_var_3))
                                          ,sL1 happy_var_3 (snd $ unLoc happy_var_3))
	) `HappyStk` happyRest}}

happyReduce_192 = happyMonadReduce 4# 69# happyReduction_192
happyReduction_192 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut232 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut116 happy_x_4 of { happy_var_4 -> 
	( ams (sLL happy_var_1 happy_var_4 $ PatSynSig happy_var_2 (mkLHsSigType happy_var_4))
                          [mj AnnPattern happy_var_1, mu AnnDcolon happy_var_3])}}}}
	) (\r -> happyReturn (happyIn83 r))

happyReduce_193 = happySpecReduce_1  70# happyReduction_193
happyReduction_193 happy_x_1
	 =  case happyOut63 happy_x_1 of { happy_var_1 -> 
	happyIn84
		 (happy_var_1
	)}

happyReduce_194 = happySpecReduce_1  70# happyReduction_194
happyReduction_194 happy_x_1
	 =  case happyOut161 happy_x_1 of { happy_var_1 -> 
	happyIn84
		 (happy_var_1
	)}

happyReduce_195 = happyMonadReduce 4# 70# happyReduction_195
happyReduction_195 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut117 happy_x_4 of { happy_var_4 -> 
	( do { v <- checkValSigLhs happy_var_2
                          ; let err = text "in default signature" <> colon <+>
                                      quotes (ppr happy_var_2)
                          ; ams (sLL happy_var_1 happy_var_4 $ SigD $ ClassOpSig True [v] $ mkLHsSigType happy_var_4)
                                [mj AnnDefault happy_var_1,mu AnnDcolon happy_var_3] })}}}}
	) (\r -> happyReturn (happyIn84 r))

happyReduce_196 = happyMonadReduce 3# 71# happyReduction_196
happyReduction_196 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut85 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut84 happy_x_3 of { happy_var_3 -> 
	( if isNilOL (snd $ unLoc happy_var_1)
                                             then return (sLL happy_var_1 happy_var_3 (mj AnnSemi happy_var_2:(fst $ unLoc happy_var_1)
                                                                    , unitOL happy_var_3))
                                             else ams (lastOL (snd $ unLoc happy_var_1)) [mj AnnSemi happy_var_2]
                                           >> return (sLL happy_var_1 happy_var_3 (fst $ unLoc happy_var_1
                                                                ,(snd $ unLoc happy_var_1) `appOL` unitOL happy_var_3)))}}}
	) (\r -> happyReturn (happyIn85 r))

happyReduce_197 = happyMonadReduce 2# 71# happyReduction_197
happyReduction_197 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut85 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( if isNilOL (snd $ unLoc happy_var_1)
                                             then return (sLL happy_var_1 happy_var_2 (mj AnnSemi happy_var_2:(fst $ unLoc happy_var_1)
                                                                                   ,snd $ unLoc happy_var_1))
                                             else ams (lastOL (snd $ unLoc happy_var_1)) [mj AnnSemi happy_var_2]
                                           >> return (sLL happy_var_1 happy_var_2  (unLoc happy_var_1)))}}
	) (\r -> happyReturn (happyIn85 r))

happyReduce_198 = happySpecReduce_1  71# happyReduction_198
happyReduction_198 happy_x_1
	 =  case happyOut84 happy_x_1 of { happy_var_1 -> 
	happyIn85
		 (sL1 happy_var_1 ([], unitOL happy_var_1)
	)}

happyReduce_199 = happySpecReduce_0  71# happyReduction_199
happyReduction_199  =  happyIn85
		 (noLoc ([],nilOL)
	)

happyReduce_200 = happySpecReduce_3  72# happyReduction_200
happyReduction_200 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut85 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn86
		 (sLL happy_var_1 happy_var_3 (moc happy_var_1:mcc happy_var_3:(fst $ unLoc happy_var_2)
                                             ,snd $ unLoc happy_var_2)
	)}}}

happyReduce_201 = happySpecReduce_3  72# happyReduction_201
happyReduction_201 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut85 happy_x_2 of { happy_var_2 -> 
	happyIn86
		 (happy_var_2
	)}

happyReduce_202 = happySpecReduce_2  73# happyReduction_202
happyReduction_202 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut86 happy_x_2 of { happy_var_2 -> 
	happyIn87
		 (sLL happy_var_1 happy_var_2 (mj AnnWhere happy_var_1:(fst $ unLoc happy_var_2)
                                             ,snd $ unLoc happy_var_2)
	)}}

happyReduce_203 = happySpecReduce_0  73# happyReduction_203
happyReduction_203  =  happyIn87
		 (noLoc ([],nilOL)
	)

happyReduce_204 = happySpecReduce_1  74# happyReduction_204
happyReduction_204 happy_x_1
	 =  case happyOut65 happy_x_1 of { happy_var_1 -> 
	happyIn88
		 (sLL happy_var_1 happy_var_1 (unitOL (sL1 happy_var_1 (InstD (unLoc happy_var_1))))
	)}

happyReduce_205 = happySpecReduce_1  74# happyReduction_205
happyReduction_205 happy_x_1
	 =  case happyOut161 happy_x_1 of { happy_var_1 -> 
	happyIn88
		 (sLL happy_var_1 happy_var_1 (unitOL happy_var_1)
	)}

happyReduce_206 = happyMonadReduce 3# 75# happyReduction_206
happyReduction_206 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut89 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut88 happy_x_3 of { happy_var_3 -> 
	( if isNilOL (snd $ unLoc happy_var_1)
                                             then return (sLL happy_var_1 happy_var_3 (mj AnnSemi happy_var_2:(fst $ unLoc happy_var_1)
                                                                    , unLoc happy_var_3))
                                             else ams (lastOL $ snd $ unLoc happy_var_1) [mj AnnSemi happy_var_2]
                                           >> return
                                            (sLL happy_var_1 happy_var_3 (fst $ unLoc happy_var_1
                                                       ,(snd $ unLoc happy_var_1) `appOL` unLoc happy_var_3)))}}}
	) (\r -> happyReturn (happyIn89 r))

happyReduce_207 = happyMonadReduce 2# 75# happyReduction_207
happyReduction_207 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut89 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( if isNilOL (snd $ unLoc happy_var_1)
                                             then return (sLL happy_var_1 happy_var_2 (mj AnnSemi happy_var_2:(fst $ unLoc happy_var_1)
                                                                                   ,snd $ unLoc happy_var_1))
                                             else ams (lastOL $ snd $ unLoc happy_var_1) [mj AnnSemi happy_var_2]
                                           >> return (sLL happy_var_1 happy_var_2 (unLoc happy_var_1)))}}
	) (\r -> happyReturn (happyIn89 r))

happyReduce_208 = happySpecReduce_1  75# happyReduction_208
happyReduction_208 happy_x_1
	 =  case happyOut88 happy_x_1 of { happy_var_1 -> 
	happyIn89
		 (sL1 happy_var_1 ([],unLoc happy_var_1)
	)}

happyReduce_209 = happySpecReduce_0  75# happyReduction_209
happyReduction_209  =  happyIn89
		 (noLoc ([],nilOL)
	)

happyReduce_210 = happySpecReduce_3  76# happyReduction_210
happyReduction_210 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut89 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn90
		 (sLL happy_var_1 happy_var_3 (moc happy_var_1:mcc happy_var_3:(fst $ unLoc happy_var_2),snd $ unLoc happy_var_2)
	)}}}

happyReduce_211 = happySpecReduce_3  76# happyReduction_211
happyReduction_211 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut89 happy_x_2 of { happy_var_2 -> 
	happyIn90
		 (L (gl happy_var_2) (unLoc happy_var_2)
	)}

happyReduce_212 = happySpecReduce_2  77# happyReduction_212
happyReduction_212 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut90 happy_x_2 of { happy_var_2 -> 
	happyIn91
		 (sLL happy_var_1 happy_var_2 (mj AnnWhere happy_var_1:(fst $ unLoc happy_var_2)
                                             ,(snd $ unLoc happy_var_2))
	)}}

happyReduce_213 = happySpecReduce_0  77# happyReduction_213
happyReduction_213  =  happyIn91
		 (noLoc ([],nilOL)
	)

happyReduce_214 = happyMonadReduce 3# 78# happyReduction_214
happyReduction_214 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut92 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut161 happy_x_3 of { happy_var_3 -> 
	( if isNilOL (snd $ unLoc happy_var_1)
                                 then return (sLL happy_var_1 happy_var_3 (mj AnnSemi happy_var_2:(fst $ unLoc happy_var_1)
                                                        , unitOL happy_var_3))
                                 else do ams (lastOL $ snd $ unLoc happy_var_1) [mj AnnSemi happy_var_2]
                                           >> return (
                                          let { this = unitOL happy_var_3;
                                                rest = snd $ unLoc happy_var_1;
                                                these = rest `appOL` this }
                                          in rest `seq` this `seq` these `seq`
                                             (sLL happy_var_1 happy_var_3 (fst $ unLoc happy_var_1,these))))}}}
	) (\r -> happyReturn (happyIn92 r))

happyReduce_215 = happyMonadReduce 2# 78# happyReduction_215
happyReduction_215 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut92 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( if isNilOL (snd $ unLoc happy_var_1)
                                  then return (sLL happy_var_1 happy_var_2 ((mj AnnSemi happy_var_2:(fst $ unLoc happy_var_1)
                                                          ,snd $ unLoc happy_var_1)))
                                  else ams (lastOL $ snd $ unLoc happy_var_1) [mj AnnSemi happy_var_2]
                                           >> return (sLL happy_var_1 happy_var_2 (unLoc happy_var_1)))}}
	) (\r -> happyReturn (happyIn92 r))

happyReduce_216 = happySpecReduce_1  78# happyReduction_216
happyReduction_216 happy_x_1
	 =  case happyOut161 happy_x_1 of { happy_var_1 -> 
	happyIn92
		 (sL1 happy_var_1 ([], unitOL happy_var_1)
	)}

happyReduce_217 = happySpecReduce_0  78# happyReduction_217
happyReduction_217  =  happyIn92
		 (noLoc ([],nilOL)
	)

happyReduce_218 = happySpecReduce_3  79# happyReduction_218
happyReduction_218 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut92 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn93
		 (sLL happy_var_1 happy_var_3 (moc happy_var_1:mcc happy_var_3:(fst $ unLoc happy_var_2)
                                                   ,sL1 happy_var_2 $ snd $ unLoc happy_var_2)
	)}}}

happyReduce_219 = happySpecReduce_3  79# happyReduction_219
happyReduction_219 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut92 happy_x_2 of { happy_var_2 -> 
	happyIn93
		 (L (gl happy_var_2) (fst $ unLoc happy_var_2,sL1 happy_var_2 $ snd $ unLoc happy_var_2)
	)}

happyReduce_220 = happyMonadReduce 1# 80# happyReduction_220
happyReduction_220 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut93 happy_x_1 of { happy_var_1 -> 
	( do { val_binds <- cvBindGroup (unLoc $ snd $ unLoc happy_var_1)
                                  ; return (sL1 happy_var_1 (fst $ unLoc happy_var_1
                                                    ,sL1 happy_var_1 $ HsValBinds val_binds)) })}
	) (\r -> happyReturn (happyIn94 r))

happyReduce_221 = happySpecReduce_3  80# happyReduction_221
happyReduction_221 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut219 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn94
		 (sLL happy_var_1 happy_var_3 ([moc happy_var_1,mcc happy_var_3]
                                             ,sL1 happy_var_2 $ HsIPBinds (IPBinds (unLoc happy_var_2)
                                                         emptyTcEvBinds))
	)}}}

happyReduce_222 = happySpecReduce_3  80# happyReduction_222
happyReduction_222 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut219 happy_x_2 of { happy_var_2 -> 
	happyIn94
		 (L (getLoc happy_var_2) ([]
                                            ,sL1 happy_var_2 $ HsIPBinds (IPBinds (unLoc happy_var_2)
                                                        emptyTcEvBinds))
	)}

happyReduce_223 = happySpecReduce_2  81# happyReduction_223
happyReduction_223 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut94 happy_x_2 of { happy_var_2 -> 
	happyIn95
		 (sLL happy_var_1 happy_var_2 (mj AnnWhere happy_var_1 : (fst $ unLoc happy_var_2)
                                             ,snd $ unLoc happy_var_2)
	)}}

happyReduce_224 = happySpecReduce_0  81# happyReduction_224
happyReduction_224  =  happyIn95
		 (noLoc ([],noLoc emptyLocalBinds)
	)

happyReduce_225 = happyMonadReduce 3# 82# happyReduction_225
happyReduction_225 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut96 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut97 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (oll happy_var_1) AnnSemi (gl happy_var_2)
                                          >> return (happy_var_1 `snocOL` happy_var_3))}}}
	) (\r -> happyReturn (happyIn96 r))

happyReduce_226 = happyMonadReduce 2# 82# happyReduction_226
happyReduction_226 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut96 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( addAnnotation (oll happy_var_1) AnnSemi (gl happy_var_2)
                                          >> return happy_var_1)}}
	) (\r -> happyReturn (happyIn96 r))

happyReduce_227 = happySpecReduce_1  82# happyReduction_227
happyReduction_227 happy_x_1
	 =  case happyOut97 happy_x_1 of { happy_var_1 -> 
	happyIn96
		 (unitOL happy_var_1
	)}

happyReduce_228 = happySpecReduce_0  82# happyReduction_228
happyReduction_228  =  happyIn96
		 (nilOL
	)

happyReduce_229 = happyMonadReduce 6# 83# happyReduction_229
happyReduction_229 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut98 happy_x_2 of { happy_var_2 -> 
	case happyOut100 happy_x_3 of { happy_var_3 -> 
	case happyOut170 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { happy_var_5 -> 
	case happyOut169 happy_x_6 of { happy_var_6 -> 
	(ams (sLL happy_var_1 happy_var_6 $ (HsRule (L (gl happy_var_1) (getSTRINGs happy_var_1,getSTRING happy_var_1))
                                  ((snd happy_var_2) `orElse` AlwaysActive)
                                  (snd happy_var_3) happy_var_4 placeHolderNames happy_var_6
                                  placeHolderNames))
               (mj AnnEqual happy_var_5 : (fst happy_var_2) ++ (fst happy_var_3)))}}}}}}
	) (\r -> happyReturn (happyIn97 r))

happyReduce_230 = happySpecReduce_0  84# happyReduction_230
happyReduction_230  =  happyIn98
		 (([],Nothing)
	)

happyReduce_231 = happySpecReduce_1  84# happyReduction_231
happyReduction_231 happy_x_1
	 =  case happyOut99 happy_x_1 of { happy_var_1 -> 
	happyIn98
		 ((fst happy_var_1,Just (snd happy_var_1))
	)}

happyReduce_232 = happySpecReduce_3  85# happyReduction_232
happyReduction_232 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn99
		 (([mos happy_var_1,mj AnnVal happy_var_2,mcs happy_var_3]
                                  ,ActiveAfter  (getINTEGERs happy_var_2) (fromInteger (getINTEGER happy_var_2)))
	)}}}

happyReduce_233 = happyReduce 4# 85# happyReduction_233
happyReduction_233 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	happyIn99
		 (([mos happy_var_1,mj AnnTilde happy_var_2,mj AnnVal happy_var_3,mcs happy_var_4]
                                  ,ActiveBefore (getINTEGERs happy_var_3) (fromInteger (getINTEGER happy_var_3)))
	) `HappyStk` happyRest}}}}

happyReduce_234 = happySpecReduce_3  85# happyReduction_234
happyReduction_234 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn99
		 (([mos happy_var_1,mj AnnTilde happy_var_2,mcs happy_var_3]
                                  ,NeverActive)
	)}}}

happyReduce_235 = happySpecReduce_3  86# happyReduction_235
happyReduction_235 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut101 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn100
		 (([mu AnnForall happy_var_1,mj AnnDot happy_var_3],happy_var_2)
	)}}}

happyReduce_236 = happySpecReduce_0  86# happyReduction_236
happyReduction_236  =  happyIn100
		 (([],[])
	)

happyReduce_237 = happySpecReduce_1  87# happyReduction_237
happyReduction_237 happy_x_1
	 =  case happyOut102 happy_x_1 of { happy_var_1 -> 
	happyIn101
		 ([happy_var_1]
	)}

happyReduce_238 = happySpecReduce_2  87# happyReduction_238
happyReduction_238 happy_x_2
	happy_x_1
	 =  case happyOut102 happy_x_1 of { happy_var_1 -> 
	case happyOut101 happy_x_2 of { happy_var_2 -> 
	happyIn101
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_239 = happySpecReduce_1  88# happyReduction_239
happyReduction_239 happy_x_1
	 =  case happyOut259 happy_x_1 of { happy_var_1 -> 
	happyIn102
		 (sLL happy_var_1 happy_var_1 (RuleBndr happy_var_1)
	)}

happyReduce_240 = happyMonadReduce 5# 88# happyReduction_240
happyReduction_240 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut259 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut123 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { happy_var_5 -> 
	( ams (sLL happy_var_1 happy_var_5 (RuleBndrSig happy_var_2
                                                       (mkLHsSigWcType happy_var_4)))
                                               [mop happy_var_1,mu AnnDcolon happy_var_3,mcp happy_var_5])}}}}}
	) (\r -> happyReturn (happyIn102 r))

happyReduce_241 = happyMonadReduce 3# 89# happyReduction_241
happyReduction_241 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut103 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut104 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (oll happy_var_1) AnnSemi (gl happy_var_2)
                                          >> return (happy_var_1 `appOL` happy_var_3))}}}
	) (\r -> happyReturn (happyIn103 r))

happyReduce_242 = happyMonadReduce 2# 89# happyReduction_242
happyReduction_242 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut103 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( addAnnotation (oll happy_var_1) AnnSemi (gl happy_var_2)
                                          >> return happy_var_1)}}
	) (\r -> happyReturn (happyIn103 r))

happyReduce_243 = happySpecReduce_1  89# happyReduction_243
happyReduction_243 happy_x_1
	 =  case happyOut104 happy_x_1 of { happy_var_1 -> 
	happyIn103
		 (happy_var_1
	)}

happyReduce_244 = happySpecReduce_0  89# happyReduction_244
happyReduction_244  =  happyIn103
		 (nilOL
	)

happyReduce_245 = happyMonadReduce 2# 90# happyReduction_245
happyReduction_245 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut227 happy_x_1 of { happy_var_1 -> 
	case happyOut107 happy_x_2 of { happy_var_2 -> 
	( amsu (sLL happy_var_1 happy_var_2 (Warning (unLoc happy_var_1) (WarningTxt (noLoc "") $ snd $ unLoc happy_var_2)))
                     (fst $ unLoc happy_var_2))}}
	) (\r -> happyReturn (happyIn104 r))

happyReduce_246 = happyMonadReduce 3# 91# happyReduction_246
happyReduction_246 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut105 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut106 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (oll happy_var_1) AnnSemi (gl happy_var_2)
                                          >> return (happy_var_1 `appOL` happy_var_3))}}}
	) (\r -> happyReturn (happyIn105 r))

happyReduce_247 = happyMonadReduce 2# 91# happyReduction_247
happyReduction_247 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut105 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( addAnnotation (oll happy_var_1) AnnSemi (gl happy_var_2)
                                          >> return happy_var_1)}}
	) (\r -> happyReturn (happyIn105 r))

happyReduce_248 = happySpecReduce_1  91# happyReduction_248
happyReduction_248 happy_x_1
	 =  case happyOut106 happy_x_1 of { happy_var_1 -> 
	happyIn105
		 (happy_var_1
	)}

happyReduce_249 = happySpecReduce_0  91# happyReduction_249
happyReduction_249  =  happyIn105
		 (nilOL
	)

happyReduce_250 = happyMonadReduce 2# 92# happyReduction_250
happyReduction_250 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut227 happy_x_1 of { happy_var_1 -> 
	case happyOut107 happy_x_2 of { happy_var_2 -> 
	( amsu (sLL happy_var_1 happy_var_2 $ (Warning (unLoc happy_var_1) (DeprecatedTxt (noLoc "") $ snd $ unLoc happy_var_2)))
                     (fst $ unLoc happy_var_2))}}
	) (\r -> happyReturn (happyIn106 r))

happyReduce_251 = happySpecReduce_1  93# happyReduction_251
happyReduction_251 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn107
		 (sL1 happy_var_1 ([],[L (gl happy_var_1) (getStringLiteral happy_var_1)])
	)}

happyReduce_252 = happySpecReduce_3  93# happyReduction_252
happyReduction_252 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut108 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn107
		 (sLL happy_var_1 happy_var_3 $ ([mos happy_var_1,mcs happy_var_3],fromOL (unLoc happy_var_2))
	)}}}

happyReduce_253 = happyMonadReduce 3# 94# happyReduction_253
happyReduction_253 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut108 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( addAnnotation (oll $ unLoc happy_var_1) AnnComma (gl happy_var_2) >>
                               return (sLL happy_var_1 happy_var_3 (unLoc happy_var_1 `snocOL`
                                                  (L (gl happy_var_3) (getStringLiteral happy_var_3)))))}}}
	) (\r -> happyReturn (happyIn108 r))

happyReduce_254 = happySpecReduce_1  94# happyReduction_254
happyReduction_254 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn108
		 (sLL happy_var_1 happy_var_1 (unitOL (L (gl happy_var_1) (getStringLiteral happy_var_1)))
	)}

happyReduce_255 = happySpecReduce_0  94# happyReduction_255
happyReduction_255  =  happyIn108
		 (noLoc nilOL
	)

happyReduce_256 = happyMonadReduce 4# 95# happyReduction_256
happyReduction_256 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut228 happy_x_2 of { happy_var_2 -> 
	case happyOut176 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	( ams (sLL happy_var_1 happy_var_4 (AnnD $ HsAnnotation
                                            (getANN_PRAGs happy_var_1)
                                            (ValueAnnProvenance happy_var_2) happy_var_3))
                                            [mo happy_var_1,mc happy_var_4])}}}}
	) (\r -> happyReturn (happyIn109 r))

happyReduce_257 = happyMonadReduce 5# 95# happyReduction_257
happyReduction_257 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut244 happy_x_3 of { happy_var_3 -> 
	case happyOut176 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { happy_var_5 -> 
	( ams (sLL happy_var_1 happy_var_5 (AnnD $ HsAnnotation
                                            (getANN_PRAGs happy_var_1)
                                            (TypeAnnProvenance happy_var_3) happy_var_4))
                                            [mo happy_var_1,mj AnnType happy_var_2,mc happy_var_5])}}}}}
	) (\r -> happyReturn (happyIn109 r))

happyReduce_258 = happyMonadReduce 4# 95# happyReduction_258
happyReduction_258 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut176 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	( ams (sLL happy_var_1 happy_var_4 (AnnD $ HsAnnotation
                                                (getANN_PRAGs happy_var_1)
                                                 ModuleAnnProvenance happy_var_3))
                                                [mo happy_var_1,mj AnnModule happy_var_2,mc happy_var_4])}}}}
	) (\r -> happyReturn (happyIn109 r))

happyReduce_259 = happyMonadReduce 4# 96# happyReduction_259
happyReduction_259 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut111 happy_x_2 of { happy_var_2 -> 
	case happyOut112 happy_x_3 of { happy_var_3 -> 
	case happyOut113 happy_x_4 of { happy_var_4 -> 
	( mkImport happy_var_2 happy_var_3 (snd $ unLoc happy_var_4) >>= \i ->
                 return (sLL happy_var_1 happy_var_4 (mj AnnImport happy_var_1 : (fst $ unLoc happy_var_4),i)))}}}}
	) (\r -> happyReturn (happyIn110 r))

happyReduce_260 = happyMonadReduce 3# 96# happyReduction_260
happyReduction_260 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut111 happy_x_2 of { happy_var_2 -> 
	case happyOut113 happy_x_3 of { happy_var_3 -> 
	( do { d <- mkImport happy_var_2 (noLoc PlaySafe) (snd $ unLoc happy_var_3);
                    return (sLL happy_var_1 happy_var_3 (mj AnnImport happy_var_1 : (fst $ unLoc happy_var_3),d)) })}}}
	) (\r -> happyReturn (happyIn110 r))

happyReduce_261 = happyMonadReduce 3# 96# happyReduction_261
happyReduction_261 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut111 happy_x_2 of { happy_var_2 -> 
	case happyOut113 happy_x_3 of { happy_var_3 -> 
	( mkExport happy_var_2 (snd $ unLoc happy_var_3) >>= \i ->
                  return (sLL happy_var_1 happy_var_3 (mj AnnExport happy_var_1 : (fst $ unLoc happy_var_3),i) ))}}}
	) (\r -> happyReturn (happyIn110 r))

happyReduce_262 = happySpecReduce_1  97# happyReduction_262
happyReduction_262 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn111
		 (sLL happy_var_1 happy_var_1 StdCallConv
	)}

happyReduce_263 = happySpecReduce_1  97# happyReduction_263
happyReduction_263 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn111
		 (sLL happy_var_1 happy_var_1 CCallConv
	)}

happyReduce_264 = happySpecReduce_1  97# happyReduction_264
happyReduction_264 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn111
		 (sLL happy_var_1 happy_var_1 CApiConv
	)}

happyReduce_265 = happySpecReduce_1  97# happyReduction_265
happyReduction_265 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn111
		 (sLL happy_var_1 happy_var_1 PrimCallConv
	)}

happyReduce_266 = happySpecReduce_1  97# happyReduction_266
happyReduction_266 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn111
		 (sLL happy_var_1 happy_var_1 JavaScriptCallConv
	)}

happyReduce_267 = happySpecReduce_1  98# happyReduction_267
happyReduction_267 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn112
		 (sLL happy_var_1 happy_var_1 PlayRisky
	)}

happyReduce_268 = happySpecReduce_1  98# happyReduction_268
happyReduction_268 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn112
		 (sLL happy_var_1 happy_var_1 PlaySafe
	)}

happyReduce_269 = happySpecReduce_1  98# happyReduction_269
happyReduction_269 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn112
		 (sLL happy_var_1 happy_var_1 PlayInterruptible
	)}

happyReduce_270 = happyReduce 4# 99# happyReduction_270
happyReduction_270 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut256 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut117 happy_x_4 of { happy_var_4 -> 
	happyIn113
		 (sLL happy_var_1 happy_var_4 ([mu AnnDcolon happy_var_3]
                                             ,(L (getLoc happy_var_1)
                                                    (getStringLiteral happy_var_1), happy_var_2, mkLHsSigType happy_var_4))
	) `HappyStk` happyRest}}}}

happyReduce_271 = happySpecReduce_3  99# happyReduction_271
happyReduction_271 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut256 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut117 happy_x_3 of { happy_var_3 -> 
	happyIn113
		 (sLL happy_var_1 happy_var_3 ([mu AnnDcolon happy_var_2]
                                             ,(noLoc (StringLiteral "" nilFS), happy_var_1, mkLHsSigType happy_var_3))
	)}}}

happyReduce_272 = happySpecReduce_0  100# happyReduction_272
happyReduction_272  =  happyIn114
		 (([],Nothing)
	)

happyReduce_273 = happySpecReduce_2  100# happyReduction_273
happyReduction_273 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut116 happy_x_2 of { happy_var_2 -> 
	happyIn114
		 (([mu AnnDcolon happy_var_1],Just happy_var_2)
	)}}

happyReduce_274 = happySpecReduce_0  101# happyReduction_274
happyReduction_274  =  happyIn115
		 (([],Nothing)
	)

happyReduce_275 = happySpecReduce_2  101# happyReduction_275
happyReduction_275 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut133 happy_x_2 of { happy_var_2 -> 
	happyIn115
		 (([mu AnnDcolon happy_var_1],Just happy_var_2)
	)}}

happyReduce_276 = happySpecReduce_1  102# happyReduction_276
happyReduction_276 happy_x_1
	 =  case happyOut123 happy_x_1 of { happy_var_1 -> 
	happyIn116
		 (happy_var_1
	)}

happyReduce_277 = happySpecReduce_1  103# happyReduction_277
happyReduction_277 happy_x_1
	 =  case happyOut124 happy_x_1 of { happy_var_1 -> 
	happyIn117
		 (happy_var_1
	)}

happyReduce_278 = happyMonadReduce 3# 104# happyReduction_278
happyReduction_278 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut118 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut256 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl $ head $ unLoc happy_var_1)
                                                       AnnComma (gl happy_var_2)
                                         >> return (sLL happy_var_1 happy_var_3 (happy_var_3 : unLoc happy_var_1)))}}}
	) (\r -> happyReturn (happyIn118 r))

happyReduce_279 = happySpecReduce_1  104# happyReduction_279
happyReduction_279 happy_x_1
	 =  case happyOut256 happy_x_1 of { happy_var_1 -> 
	happyIn118
		 (sL1 happy_var_1 [happy_var_1]
	)}

happyReduce_280 = happySpecReduce_1  105# happyReduction_280
happyReduction_280 happy_x_1
	 =  case happyOut116 happy_x_1 of { happy_var_1 -> 
	happyIn119
		 (unitOL (mkLHsSigType happy_var_1)
	)}

happyReduce_281 = happyMonadReduce 3# 105# happyReduction_281
happyReduction_281 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut116 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut119 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl happy_var_1) AnnComma (gl happy_var_2)
                                >> return (unitOL (mkLHsSigType happy_var_1) `appOL` happy_var_3))}}}
	) (\r -> happyReturn (happyIn119 r))

happyReduce_282 = happySpecReduce_1  106# happyReduction_282
happyReduction_282 happy_x_1
	 =  case happyOut121 happy_x_1 of { happy_var_1 -> 
	happyIn120
		 (sL1 happy_var_1 (let (a, str) = unLoc happy_var_1 in (a, HsSrcBang Nothing NoSrcUnpack str))
	)}

happyReduce_283 = happySpecReduce_1  106# happyReduction_283
happyReduction_283 happy_x_1
	 =  case happyOut122 happy_x_1 of { happy_var_1 -> 
	happyIn120
		 (sL1 happy_var_1 (let (a, prag, unpk) = unLoc happy_var_1 in (a, HsSrcBang prag unpk NoSrcStrict))
	)}

happyReduce_284 = happySpecReduce_2  106# happyReduction_284
happyReduction_284 happy_x_2
	happy_x_1
	 =  case happyOut122 happy_x_1 of { happy_var_1 -> 
	case happyOut121 happy_x_2 of { happy_var_2 -> 
	happyIn120
		 (sLL happy_var_1 happy_var_2 (let { (a, prag, unpk) = unLoc happy_var_1
                                                   ; (a', str) = unLoc happy_var_2 }
                                                in (a ++ a', HsSrcBang prag unpk str))
	)}}

happyReduce_285 = happySpecReduce_1  107# happyReduction_285
happyReduction_285 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn121
		 (sL1 happy_var_1 ([mj AnnBang happy_var_1], SrcStrict)
	)}

happyReduce_286 = happySpecReduce_1  107# happyReduction_286
happyReduction_286 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn121
		 (sL1 happy_var_1 ([mj AnnTilde happy_var_1], SrcLazy)
	)}

happyReduce_287 = happySpecReduce_2  108# happyReduction_287
happyReduction_287 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	happyIn122
		 (sLL happy_var_1 happy_var_2 ([mo happy_var_1, mc happy_var_2], Just $ getUNPACK_PRAGs happy_var_1, SrcUnpack)
	)}}

happyReduce_288 = happySpecReduce_2  108# happyReduction_288
happyReduction_288 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	happyIn122
		 (sLL happy_var_1 happy_var_2 ([mo happy_var_1, mc happy_var_2], Just $ getNOUNPACK_PRAGs happy_var_1, SrcNoUnpack)
	)}}

happyReduce_289 = happyMonadReduce 4# 109# happyReduction_289
happyReduction_289 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut138 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut123 happy_x_4 of { happy_var_4 -> 
	( hintExplicitForall (getLoc happy_var_1) >>
                                           ams (sLL happy_var_1 happy_var_4 $
                                                HsForAllTy { hst_bndrs = happy_var_2
                                                           , hst_body = happy_var_4 })
                                               [mu AnnForall happy_var_1, mj AnnDot happy_var_3])}}}}
	) (\r -> happyReturn (happyIn123 r))

happyReduce_290 = happyMonadReduce 3# 109# happyReduction_290
happyReduction_290 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut125 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut123 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl happy_var_1) (toUnicodeAnn AnnDarrow happy_var_2) (gl happy_var_2)
                                         >> return (sLL happy_var_1 happy_var_3 $
                                            HsQualTy { hst_ctxt = happy_var_1
                                                     , hst_body = happy_var_3 }))}}}
	) (\r -> happyReturn (happyIn123 r))

happyReduce_291 = happyMonadReduce 3# 109# happyReduction_291
happyReduction_291 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut221 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut127 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (HsIParamTy (unLoc happy_var_1) happy_var_3))
                                             [mj AnnVal happy_var_1,mu AnnDcolon happy_var_2])}}}
	) (\r -> happyReturn (happyIn123 r))

happyReduce_292 = happySpecReduce_1  109# happyReduction_292
happyReduction_292 happy_x_1
	 =  case happyOut127 happy_x_1 of { happy_var_1 -> 
	happyIn123
		 (happy_var_1
	)}

happyReduce_293 = happyMonadReduce 4# 110# happyReduction_293
happyReduction_293 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut138 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut124 happy_x_4 of { happy_var_4 -> 
	( hintExplicitForall (getLoc happy_var_1) >>
                                            ams (sLL happy_var_1 happy_var_4 $
                                                 HsForAllTy { hst_bndrs = happy_var_2
                                                            , hst_body = happy_var_4 })
                                                [mu AnnForall happy_var_1,mj AnnDot happy_var_3])}}}}
	) (\r -> happyReturn (happyIn124 r))

happyReduce_294 = happyMonadReduce 3# 110# happyReduction_294
happyReduction_294 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut125 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut124 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl happy_var_1) (toUnicodeAnn AnnDarrow happy_var_2) (gl happy_var_2)
                                         >> return (sLL happy_var_1 happy_var_3 $
                                            HsQualTy { hst_ctxt = happy_var_1
                                                     , hst_body = happy_var_3 }))}}}
	) (\r -> happyReturn (happyIn124 r))

happyReduce_295 = happyMonadReduce 3# 110# happyReduction_295
happyReduction_295 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut221 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut127 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (HsIParamTy (unLoc happy_var_1) happy_var_3))
                                             [mj AnnVal happy_var_1,mu AnnDcolon happy_var_2])}}}
	) (\r -> happyReturn (happyIn124 r))

happyReduce_296 = happySpecReduce_1  110# happyReduction_296
happyReduction_296 happy_x_1
	 =  case happyOut128 happy_x_1 of { happy_var_1 -> 
	happyIn124
		 (happy_var_1
	)}

happyReduce_297 = happyMonadReduce 1# 111# happyReduction_297
happyReduction_297 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut129 happy_x_1 of { happy_var_1 -> 
	( do { (anns,ctx) <- checkContext happy_var_1
                                                ; if null (unLoc ctx)
                                                   then addAnnotation (gl happy_var_1) AnnUnit (gl happy_var_1)
                                                   else return ()
                                                ; ams ctx anns
                                                })}
	) (\r -> happyReturn (happyIn125 r))

happyReduce_298 = happyMonadReduce 1# 112# happyReduction_298
happyReduction_298 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut130 happy_x_1 of { happy_var_1 -> 
	( do { ty <- splitTilde happy_var_1
                                             ; (anns,ctx) <- checkContext ty
                                             ; if null (unLoc ctx)
                                                   then addAnnotation (gl ty) AnnUnit (gl ty)
                                                   else return ()
                                             ; ams ctx anns
                                             })}
	) (\r -> happyReturn (happyIn126 r))

happyReduce_299 = happySpecReduce_1  113# happyReduction_299
happyReduction_299 happy_x_1
	 =  case happyOut129 happy_x_1 of { happy_var_1 -> 
	happyIn127
		 (happy_var_1
	)}

happyReduce_300 = happyMonadReduce 3# 113# happyReduction_300
happyReduction_300 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut129 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut123 happy_x_3 of { happy_var_3 -> 
	( ams happy_var_1 [mu AnnRarrow happy_var_2] -- See note [GADT decl discards annotations]
                                       >> ams (sLL happy_var_1 happy_var_3 $ HsFunTy happy_var_1 happy_var_3)
                                              [mu AnnRarrow happy_var_2])}}}
	) (\r -> happyReturn (happyIn127 r))

happyReduce_301 = happySpecReduce_1  114# happyReduction_301
happyReduction_301 happy_x_1
	 =  case happyOut129 happy_x_1 of { happy_var_1 -> 
	happyIn128
		 (happy_var_1
	)}

happyReduce_302 = happySpecReduce_2  114# happyReduction_302
happyReduction_302 happy_x_2
	happy_x_1
	 =  case happyOut129 happy_x_1 of { happy_var_1 -> 
	case happyOut276 happy_x_2 of { happy_var_2 -> 
	happyIn128
		 (sLL happy_var_1 happy_var_2 $ HsDocTy happy_var_1 happy_var_2
	)}}

happyReduce_303 = happyMonadReduce 3# 114# happyReduction_303
happyReduction_303 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut129 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut124 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ HsFunTy happy_var_1 happy_var_3)
                                                [mu AnnRarrow happy_var_2])}}}
	) (\r -> happyReturn (happyIn128 r))

happyReduce_304 = happyMonadReduce 4# 114# happyReduction_304
happyReduction_304 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut129 happy_x_1 of { happy_var_1 -> 
	case happyOut276 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut124 happy_x_4 of { happy_var_4 -> 
	( ams (sLL happy_var_1 happy_var_4 $
                                                 HsFunTy (L (comb2 happy_var_1 happy_var_2) (HsDocTy happy_var_1 happy_var_2))
                                                         happy_var_4)
                                                [mu AnnRarrow happy_var_3])}}}}
	) (\r -> happyReturn (happyIn128 r))

happyReduce_305 = happyMonadReduce 1# 115# happyReduction_305
happyReduction_305 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut131 happy_x_1 of { happy_var_1 -> 
	(  splitTildeApps (reverse (unLoc happy_var_1)) >>=
                                          \ts -> return $ sL1 happy_var_1 $ HsAppsTy ts)}
	) (\r -> happyReturn (happyIn129 r))

happyReduce_306 = happySpecReduce_2  116# happyReduction_306
happyReduction_306 happy_x_2
	happy_x_1
	 =  case happyOut130 happy_x_1 of { happy_var_1 -> 
	case happyOut133 happy_x_2 of { happy_var_2 -> 
	happyIn130
		 (sLL happy_var_1 happy_var_2 $ HsAppTy happy_var_1 happy_var_2
	)}}

happyReduce_307 = happySpecReduce_1  116# happyReduction_307
happyReduction_307 happy_x_1
	 =  case happyOut133 happy_x_1 of { happy_var_1 -> 
	happyIn130
		 (happy_var_1
	)}

happyReduce_308 = happySpecReduce_1  117# happyReduction_308
happyReduction_308 happy_x_1
	 =  case happyOut132 happy_x_1 of { happy_var_1 -> 
	happyIn131
		 (sL1 happy_var_1 [happy_var_1]
	)}

happyReduce_309 = happySpecReduce_2  117# happyReduction_309
happyReduction_309 happy_x_2
	happy_x_1
	 =  case happyOut131 happy_x_1 of { happy_var_1 -> 
	case happyOut132 happy_x_2 of { happy_var_2 -> 
	happyIn131
		 (sLL happy_var_1 happy_var_2 $ happy_var_2 : (unLoc happy_var_1)
	)}}

happyReduce_310 = happySpecReduce_1  118# happyReduction_310
happyReduction_310 happy_x_1
	 =  case happyOut133 happy_x_1 of { happy_var_1 -> 
	happyIn132
		 (sL1 happy_var_1 $ HsAppPrefix happy_var_1
	)}

happyReduce_311 = happySpecReduce_1  118# happyReduction_311
happyReduction_311 happy_x_1
	 =  case happyOut242 happy_x_1 of { happy_var_1 -> 
	happyIn132
		 (sL1 happy_var_1 $ HsAppInfix happy_var_1
	)}

happyReduce_312 = happySpecReduce_1  118# happyReduction_312
happyReduction_312 happy_x_1
	 =  case happyOut254 happy_x_1 of { happy_var_1 -> 
	happyIn132
		 (sL1 happy_var_1 $ HsAppInfix happy_var_1
	)}

happyReduce_313 = happyMonadReduce 2# 118# happyReduction_313
happyReduction_313 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut237 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ HsAppInfix happy_var_2)
                                               [mj AnnSimpleQuote happy_var_1])}}
	) (\r -> happyReturn (happyIn132 r))

happyReduce_314 = happyMonadReduce 2# 118# happyReduction_314
happyReduction_314 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut248 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ HsAppInfix happy_var_2)
                                               [mj AnnSimpleQuote happy_var_1])}}
	) (\r -> happyReturn (happyIn132 r))

happyReduce_315 = happySpecReduce_1  119# happyReduction_315
happyReduction_315 happy_x_1
	 =  case happyOut239 happy_x_1 of { happy_var_1 -> 
	happyIn133
		 (sL1 happy_var_1 (HsTyVar happy_var_1)
	)}

happyReduce_316 = happySpecReduce_1  119# happyReduction_316
happyReduction_316 happy_x_1
	 =  case happyOut253 happy_x_1 of { happy_var_1 -> 
	happyIn133
		 (sL1 happy_var_1 (HsTyVar happy_var_1)
	)}

happyReduce_317 = happyMonadReduce 2# 119# happyReduction_317
happyReduction_317 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut120 happy_x_1 of { happy_var_1 -> 
	case happyOut133 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 (HsBangTy (snd $ unLoc happy_var_1) happy_var_2))
                                                (fst $ unLoc happy_var_1))}}
	) (\r -> happyReturn (happyIn133 r))

happyReduce_318 = happyMonadReduce 3# 119# happyReduction_318
happyReduction_318 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut154 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( amms (checkRecordSyntax
                                                    (sLL happy_var_1 happy_var_3 $ HsRecTy happy_var_2))
                                                        -- Constructor sigs only
                                                 [moc happy_var_1,mcc happy_var_3])}}}
	) (\r -> happyReturn (happyIn133 r))

happyReduce_319 = happyMonadReduce 2# 119# happyReduction_319
happyReduction_319 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ HsTupleTy
                                                    HsBoxedOrConstraintTuple [])
                                                [mop happy_var_1,mcp happy_var_2])}}
	) (\r -> happyReturn (happyIn133 r))

happyReduce_320 = happyMonadReduce 5# 119# happyReduction_320
happyReduction_320 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut123 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut137 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { happy_var_5 -> 
	( addAnnotation (gl happy_var_2) AnnComma
                                                          (gl happy_var_3) >>
                                            ams (sLL happy_var_1 happy_var_5 $ HsTupleTy
                                             HsBoxedOrConstraintTuple (happy_var_2 : happy_var_4))
                                                [mop happy_var_1,mcp happy_var_5])}}}}}
	) (\r -> happyReturn (happyIn133 r))

happyReduce_321 = happyMonadReduce 2# 119# happyReduction_321
happyReduction_321 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ HsTupleTy HsUnboxedTuple [])
                                             [mo happy_var_1,mc happy_var_2])}}
	) (\r -> happyReturn (happyIn133 r))

happyReduce_322 = happyMonadReduce 3# 119# happyReduction_322
happyReduction_322 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut137 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ HsTupleTy HsUnboxedTuple happy_var_2)
                                             [mo happy_var_1,mc happy_var_3])}}}
	) (\r -> happyReturn (happyIn133 r))

happyReduce_323 = happyMonadReduce 3# 119# happyReduction_323
happyReduction_323 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut123 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ HsListTy  happy_var_2) [mos happy_var_1,mcs happy_var_3])}}}
	) (\r -> happyReturn (happyIn133 r))

happyReduce_324 = happyMonadReduce 3# 119# happyReduction_324
happyReduction_324 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut123 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ HsPArrTy  happy_var_2) [mo happy_var_1,mc happy_var_3])}}}
	) (\r -> happyReturn (happyIn133 r))

happyReduce_325 = happyMonadReduce 3# 119# happyReduction_325
happyReduction_325 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut123 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ HsParTy   happy_var_2) [mop happy_var_1,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn133 r))

happyReduce_326 = happyMonadReduce 5# 119# happyReduction_326
happyReduction_326 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut123 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut144 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { happy_var_5 -> 
	( ams (sLL happy_var_1 happy_var_5 $ HsKindSig happy_var_2 happy_var_4)
                                             [mop happy_var_1,mu AnnDcolon happy_var_3,mcp happy_var_5])}}}}}
	) (\r -> happyReturn (happyIn133 r))

happyReduce_327 = happySpecReduce_1  119# happyReduction_327
happyReduction_327 happy_x_1
	 =  case happyOut168 happy_x_1 of { happy_var_1 -> 
	happyIn133
		 (sL1 happy_var_1 (HsSpliceTy (unLoc happy_var_1) placeHolderKind)
	)}

happyReduce_328 = happyMonadReduce 3# 119# happyReduction_328
happyReduction_328 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut169 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ mkHsSpliceTy happy_var_2)
                                             [mj AnnOpenPE happy_var_1,mj AnnCloseP happy_var_3])}}}
	) (\r -> happyReturn (happyIn133 r))

happyReduce_329 = happyMonadReduce 1# 119# happyReduction_329
happyReduction_329 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	(ams (sLL happy_var_1 happy_var_1 $ mkHsSpliceTy $ sL1 happy_var_1 $ HsVar $
                                             (sL1 happy_var_1 (mkUnqual varName (getTH_ID_SPLICE happy_var_1))))
                                             [mj AnnThIdSplice happy_var_1])}
	) (\r -> happyReturn (happyIn133 r))

happyReduce_330 = happyMonadReduce 2# 119# happyReduction_330
happyReduction_330 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut229 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ HsTyVar happy_var_2) [mj AnnSimpleQuote happy_var_1,mj AnnName happy_var_2])}}
	) (\r -> happyReturn (happyIn133 r))

happyReduce_331 = happyMonadReduce 6# 119# happyReduction_331
happyReduction_331 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut123 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	case happyOut137 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { happy_var_6 -> 
	( addAnnotation (gl happy_var_3) AnnComma (gl happy_var_4) >>
                                ams (sLL happy_var_1 happy_var_6 $ HsExplicitTupleTy [] (happy_var_3 : happy_var_5))
                                    [mj AnnSimpleQuote happy_var_1,mop happy_var_2,mcp happy_var_6])}}}}}}
	) (\r -> happyReturn (happyIn133 r))

happyReduce_332 = happyMonadReduce 4# 119# happyReduction_332
happyReduction_332 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut136 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	( ams (sLL happy_var_1 happy_var_4 $ HsExplicitListTy
                                                            placeHolderKind happy_var_3)
                                                       [mj AnnSimpleQuote happy_var_1,mos happy_var_2,mcs happy_var_4])}}}}
	) (\r -> happyReturn (happyIn133 r))

happyReduce_333 = happyMonadReduce 2# 119# happyReduction_333
happyReduction_333 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut256 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ HsTyVar happy_var_2)
                                                       [mj AnnSimpleQuote happy_var_1,mj AnnName happy_var_2])}}
	) (\r -> happyReturn (happyIn133 r))

happyReduce_334 = happyMonadReduce 5# 119# happyReduction_334
happyReduction_334 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut123 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut137 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { happy_var_5 -> 
	( addAnnotation (gl happy_var_2) AnnComma
                                                           (gl happy_var_3) >>
                                             ams (sLL happy_var_1 happy_var_5 $ HsExplicitListTy
                                                     placeHolderKind (happy_var_2 : happy_var_4))
                                                 [mos happy_var_1,mcs happy_var_5])}}}}}
	) (\r -> happyReturn (happyIn133 r))

happyReduce_335 = happySpecReduce_1  119# happyReduction_335
happyReduction_335 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn133
		 (sLL happy_var_1 happy_var_1 $ HsTyLit $ HsNumTy (getINTEGERs happy_var_1)
                                                               (getINTEGER happy_var_1)
	)}

happyReduce_336 = happySpecReduce_1  119# happyReduction_336
happyReduction_336 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn133
		 (sLL happy_var_1 happy_var_1 $ HsTyLit $ HsStrTy (getSTRINGs happy_var_1)
                                                               (getSTRING  happy_var_1)
	)}

happyReduce_337 = happySpecReduce_1  119# happyReduction_337
happyReduction_337 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn133
		 (sL1 happy_var_1 $ mkAnonWildCardTy
	)}

happyReduce_338 = happySpecReduce_1  120# happyReduction_338
happyReduction_338 happy_x_1
	 =  case happyOut116 happy_x_1 of { happy_var_1 -> 
	happyIn134
		 (mkLHsSigType happy_var_1
	)}

happyReduce_339 = happySpecReduce_1  121# happyReduction_339
happyReduction_339 happy_x_1
	 =  case happyOut127 happy_x_1 of { happy_var_1 -> 
	happyIn135
		 ([mkLHsSigType happy_var_1]
	)}

happyReduce_340 = happyMonadReduce 3# 121# happyReduction_340
happyReduction_340 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut127 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut135 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl happy_var_1) AnnComma (gl happy_var_2)
                                           >> return (mkLHsSigType happy_var_1 : happy_var_3))}}}
	) (\r -> happyReturn (happyIn135 r))

happyReduce_341 = happySpecReduce_1  122# happyReduction_341
happyReduction_341 happy_x_1
	 =  case happyOut137 happy_x_1 of { happy_var_1 -> 
	happyIn136
		 (happy_var_1
	)}

happyReduce_342 = happySpecReduce_0  122# happyReduction_342
happyReduction_342  =  happyIn136
		 ([]
	)

happyReduce_343 = happySpecReduce_1  123# happyReduction_343
happyReduction_343 happy_x_1
	 =  case happyOut123 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 ([happy_var_1]
	)}

happyReduce_344 = happyMonadReduce 3# 123# happyReduction_344
happyReduction_344 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut123 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut137 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl happy_var_1) AnnComma (gl happy_var_2)
                                          >> return (happy_var_1 : happy_var_3))}}}
	) (\r -> happyReturn (happyIn137 r))

happyReduce_345 = happySpecReduce_2  124# happyReduction_345
happyReduction_345 happy_x_2
	happy_x_1
	 =  case happyOut139 happy_x_1 of { happy_var_1 -> 
	case happyOut138 happy_x_2 of { happy_var_2 -> 
	happyIn138
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_346 = happySpecReduce_0  124# happyReduction_346
happyReduction_346  =  happyIn138
		 ([]
	)

happyReduce_347 = happySpecReduce_1  125# happyReduction_347
happyReduction_347 happy_x_1
	 =  case happyOut253 happy_x_1 of { happy_var_1 -> 
	happyIn139
		 (sL1 happy_var_1 (UserTyVar happy_var_1)
	)}

happyReduce_348 = happyMonadReduce 5# 125# happyReduction_348
happyReduction_348 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut253 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut144 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { happy_var_5 -> 
	( ams (sLL happy_var_1 happy_var_5  (KindedTyVar happy_var_2 happy_var_4))
                                               [mop happy_var_1,mu AnnDcolon happy_var_3
                                               ,mcp happy_var_5])}}}}}
	) (\r -> happyReturn (happyIn139 r))

happyReduce_349 = happySpecReduce_0  126# happyReduction_349
happyReduction_349  =  happyIn140
		 (noLoc ([],[])
	)

happyReduce_350 = happySpecReduce_2  126# happyReduction_350
happyReduction_350 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut141 happy_x_2 of { happy_var_2 -> 
	happyIn140
		 ((sLL happy_var_1 happy_var_2 ([mj AnnVbar happy_var_1]
                                                 ,reverse (unLoc happy_var_2)))
	)}}

happyReduce_351 = happyMonadReduce 3# 127# happyReduction_351
happyReduction_351 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut141 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut142 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl $ head $ unLoc happy_var_1) AnnComma (gl happy_var_2)
                           >> return (sLL happy_var_1 happy_var_3 (happy_var_3 : unLoc happy_var_1)))}}}
	) (\r -> happyReturn (happyIn141 r))

happyReduce_352 = happySpecReduce_1  127# happyReduction_352
happyReduction_352 happy_x_1
	 =  case happyOut142 happy_x_1 of { happy_var_1 -> 
	happyIn141
		 (sL1 happy_var_1 [happy_var_1]
	)}

happyReduce_353 = happyMonadReduce 3# 128# happyReduction_353
happyReduction_353 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut143 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut143 happy_x_3 of { happy_var_3 -> 
	( ams (L (comb3 happy_var_1 happy_var_2 happy_var_3)
                                       (reverse (unLoc happy_var_1), reverse (unLoc happy_var_3)))
                                       [mu AnnRarrow happy_var_2])}}}
	) (\r -> happyReturn (happyIn142 r))

happyReduce_354 = happySpecReduce_0  129# happyReduction_354
happyReduction_354  =  happyIn143
		 (noLoc []
	)

happyReduce_355 = happySpecReduce_2  129# happyReduction_355
happyReduction_355 happy_x_2
	happy_x_1
	 =  case happyOut143 happy_x_1 of { happy_var_1 -> 
	case happyOut253 happy_x_2 of { happy_var_2 -> 
	happyIn143
		 (sLL happy_var_1 happy_var_2 (happy_var_2 : unLoc happy_var_1)
	)}}

happyReduce_356 = happySpecReduce_1  130# happyReduction_356
happyReduction_356 happy_x_1
	 =  case happyOut123 happy_x_1 of { happy_var_1 -> 
	happyIn144
		 (happy_var_1
	)}

happyReduce_357 = happyReduce 4# 131# happyReduction_357
happyReduction_357 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut146 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	happyIn145
		 (L (comb2 happy_var_1 happy_var_3)
                                                    ([mj AnnWhere happy_var_1
                                                     ,moc happy_var_2
                                                     ,mcc happy_var_4]
                                                    , unLoc happy_var_3)
	) `HappyStk` happyRest}}}}

happyReduce_358 = happyReduce 4# 131# happyReduction_358
happyReduction_358 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut146 happy_x_3 of { happy_var_3 -> 
	happyIn145
		 (L (comb2 happy_var_1 happy_var_3)
                                                     ([mj AnnWhere happy_var_1]
                                                     , unLoc happy_var_3)
	) `HappyStk` happyRest}}

happyReduce_359 = happySpecReduce_0  131# happyReduction_359
happyReduction_359  =  happyIn145
		 (noLoc ([],[])
	)

happyReduce_360 = happyMonadReduce 3# 132# happyReduction_360
happyReduction_360 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut147 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut146 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl happy_var_1) AnnSemi (gl happy_var_2)
                     >> return (L (comb2 happy_var_1 happy_var_3) (happy_var_1 : unLoc happy_var_3)))}}}
	) (\r -> happyReturn (happyIn146 r))

happyReduce_361 = happySpecReduce_1  132# happyReduction_361
happyReduction_361 happy_x_1
	 =  case happyOut147 happy_x_1 of { happy_var_1 -> 
	happyIn146
		 (L (gl happy_var_1) [happy_var_1]
	)}

happyReduce_362 = happySpecReduce_0  132# happyReduction_362
happyReduction_362  =  happyIn146
		 (noLoc []
	)

happyReduce_363 = happyMonadReduce 3# 133# happyReduction_363
happyReduction_363 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut281 happy_x_1 of { happy_var_1 -> 
	case happyOut148 happy_x_3 of { happy_var_3 -> 
	( return $ addConDoc happy_var_3 happy_var_1)}}
	) (\r -> happyReturn (happyIn147 r))

happyReduce_364 = happyMonadReduce 1# 133# happyReduction_364
happyReduction_364 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut148 happy_x_1 of { happy_var_1 -> 
	( return happy_var_1)}
	) (\r -> happyReturn (happyIn147 r))

happyReduce_365 = happyMonadReduce 3# 134# happyReduction_365
happyReduction_365 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut233 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut116 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (mkGadtDecl (unLoc happy_var_1) (mkLHsSigType happy_var_3)))
                       [mu AnnDcolon happy_var_2])}}}
	) (\r -> happyReturn (happyIn148 r))

happyReduce_366 = happySpecReduce_3  135# happyReduction_366
happyReduction_366 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut281 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut150 happy_x_3 of { happy_var_3 -> 
	happyIn149
		 (L (comb2 happy_var_2 happy_var_3) ([mj AnnEqual happy_var_2]
                                                     ,addConDocs (unLoc happy_var_3) happy_var_1)
	)}}}

happyReduce_367 = happyMonadReduce 5# 136# happyReduction_367
happyReduction_367 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut150 happy_x_1 of { happy_var_1 -> 
	case happyOut281 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut280 happy_x_4 of { happy_var_4 -> 
	case happyOut151 happy_x_5 of { happy_var_5 -> 
	( addAnnotation (gl $ head $ unLoc happy_var_1) AnnVbar (gl happy_var_3)
               >> return (sLL happy_var_1 happy_var_5 (addConDoc happy_var_5 happy_var_2 : addConDocFirst (unLoc happy_var_1) happy_var_4)))}}}}}
	) (\r -> happyReturn (happyIn150 r))

happyReduce_368 = happySpecReduce_1  136# happyReduction_368
happyReduction_368 happy_x_1
	 =  case happyOut151 happy_x_1 of { happy_var_1 -> 
	happyIn150
		 (sL1 happy_var_1 [happy_var_1]
	)}

happyReduce_369 = happyMonadReduce 6# 137# happyReduction_369
happyReduction_369 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut281 happy_x_1 of { happy_var_1 -> 
	case happyOut152 happy_x_2 of { happy_var_2 -> 
	case happyOut126 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	case happyOut153 happy_x_5 of { happy_var_5 -> 
	case happyOut280 happy_x_6 of { happy_var_6 -> 
	( ams (let (con,details) = unLoc happy_var_5 in
                  addConDoc (L (comb4 happy_var_2 happy_var_3 happy_var_4 happy_var_5) (mkConDeclH98 con
                                                   (snd $ unLoc happy_var_2) happy_var_3 details))
                            (happy_var_1 `mplus` happy_var_6))
                        (mu AnnDarrow happy_var_4:(fst $ unLoc happy_var_2)))}}}}}}
	) (\r -> happyReturn (happyIn151 r))

happyReduce_370 = happyMonadReduce 4# 137# happyReduction_370
happyReduction_370 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut281 happy_x_1 of { happy_var_1 -> 
	case happyOut152 happy_x_2 of { happy_var_2 -> 
	case happyOut153 happy_x_3 of { happy_var_3 -> 
	case happyOut280 happy_x_4 of { happy_var_4 -> 
	( ams ( let (con,details) = unLoc happy_var_3 in
                  addConDoc (L (comb2 happy_var_2 happy_var_3) (mkConDeclH98 con
                                           (snd $ unLoc happy_var_2) (noLoc []) details))
                            (happy_var_1 `mplus` happy_var_4))
                       (fst $ unLoc happy_var_2))}}}}
	) (\r -> happyReturn (happyIn151 r))

happyReduce_371 = happySpecReduce_3  138# happyReduction_371
happyReduction_371 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut138 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn152
		 (sLL happy_var_1 happy_var_3 ([mu AnnForall happy_var_1,mj AnnDot happy_var_3], Just happy_var_2)
	)}}}

happyReduce_372 = happySpecReduce_0  138# happyReduction_372
happyReduction_372  =  happyIn152
		 (noLoc ([], Nothing)
	)

happyReduce_373 = happyMonadReduce 1# 139# happyReduction_373
happyReduction_373 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut130 happy_x_1 of { happy_var_1 -> 
	( do { c <- splitCon happy_var_1
                                                     ; return $ sLL happy_var_1 happy_var_1 c })}
	) (\r -> happyReturn (happyIn153 r))

happyReduce_374 = happyMonadReduce 3# 139# happyReduction_374
happyReduction_374 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut130 happy_x_1 of { happy_var_1 -> 
	case happyOut236 happy_x_2 of { happy_var_2 -> 
	case happyOut130 happy_x_3 of { happy_var_3 -> 
	( do { ty <- splitTilde happy_var_1
                                                     ; return $ sLL happy_var_1 happy_var_3 (happy_var_2, InfixCon ty happy_var_3) })}}}
	) (\r -> happyReturn (happyIn153 r))

happyReduce_375 = happySpecReduce_0  140# happyReduction_375
happyReduction_375  =  happyIn154
		 ([]
	)

happyReduce_376 = happySpecReduce_1  140# happyReduction_376
happyReduction_376 happy_x_1
	 =  case happyOut155 happy_x_1 of { happy_var_1 -> 
	happyIn154
		 (happy_var_1
	)}

happyReduce_377 = happyMonadReduce 5# 141# happyReduction_377
happyReduction_377 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut156 happy_x_1 of { happy_var_1 -> 
	case happyOut281 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut280 happy_x_4 of { happy_var_4 -> 
	case happyOut155 happy_x_5 of { happy_var_5 -> 
	( addAnnotation (gl happy_var_1) AnnComma (gl happy_var_3) >>
               return ((addFieldDoc happy_var_1 happy_var_4) : addFieldDocs happy_var_5 happy_var_2))}}}}}
	) (\r -> happyReturn (happyIn155 r))

happyReduce_378 = happySpecReduce_1  141# happyReduction_378
happyReduction_378 happy_x_1
	 =  case happyOut156 happy_x_1 of { happy_var_1 -> 
	happyIn155
		 ([happy_var_1]
	)}

happyReduce_379 = happyMonadReduce 5# 142# happyReduction_379
happyReduction_379 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut281 happy_x_1 of { happy_var_1 -> 
	case happyOut118 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut123 happy_x_4 of { happy_var_4 -> 
	case happyOut280 happy_x_5 of { happy_var_5 -> 
	( ams (L (comb2 happy_var_2 happy_var_4)
                      (ConDeclField (reverse (map (\ln@(L l n) -> L l $ FieldOcc ln PlaceHolder) (unLoc happy_var_2))) happy_var_4 (happy_var_1 `mplus` happy_var_5)))
                   [mu AnnDcolon happy_var_3])}}}}}
	) (\r -> happyReturn (happyIn156 r))

happyReduce_380 = happySpecReduce_0  143# happyReduction_380
happyReduction_380  =  happyIn157
		 (noLoc Nothing
	)

happyReduce_381 = happyMonadReduce 2# 143# happyReduction_381
happyReduction_381 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut243 happy_x_2 of { happy_var_2 -> 
	( let { L tv_loc tv = happy_var_2
                                         ; full_loc = comb2 happy_var_1 happy_var_2 }
                                      in ams (L full_loc $ Just $ L full_loc $
                                                 [mkLHsSigType (L tv_loc (HsTyVar happy_var_2))])
                                             [mj AnnDeriving happy_var_1])}}
	) (\r -> happyReturn (happyIn157 r))

happyReduce_382 = happyMonadReduce 3# 143# happyReduction_382
happyReduction_382 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( let { full_loc = comb2 happy_var_1 happy_var_3 }
                                     in ams (L full_loc $ Just $ L full_loc [])
                                            [mj AnnDeriving happy_var_1,mop happy_var_2,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn157 r))

happyReduce_383 = happyMonadReduce 4# 143# happyReduction_383
happyReduction_383 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut135 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	( let { full_loc = comb2 happy_var_1 happy_var_4 }
                                             in ams (L full_loc $ Just $ L full_loc happy_var_3)
                                                    [mj AnnDeriving happy_var_1,mop happy_var_2,mcp happy_var_4])}}}}
	) (\r -> happyReturn (happyIn157 r))

happyReduce_384 = happySpecReduce_1  144# happyReduction_384
happyReduction_384 happy_x_1
	 =  case happyOut159 happy_x_1 of { happy_var_1 -> 
	happyIn158
		 (sL1 happy_var_1 (DocD (unLoc happy_var_1))
	)}

happyReduce_385 = happySpecReduce_1  145# happyReduction_385
happyReduction_385 happy_x_1
	 =  case happyOut275 happy_x_1 of { happy_var_1 -> 
	happyIn159
		 (sL1 happy_var_1 (DocCommentNext (unLoc happy_var_1))
	)}

happyReduce_386 = happySpecReduce_1  145# happyReduction_386
happyReduction_386 happy_x_1
	 =  case happyOut276 happy_x_1 of { happy_var_1 -> 
	happyIn159
		 (sL1 happy_var_1 (DocCommentPrev (unLoc happy_var_1))
	)}

happyReduce_387 = happySpecReduce_1  145# happyReduction_387
happyReduction_387 happy_x_1
	 =  case happyOut277 happy_x_1 of { happy_var_1 -> 
	happyIn159
		 (sL1 happy_var_1 (case (unLoc happy_var_1) of (n, doc) -> DocCommentNamed n doc)
	)}

happyReduce_388 = happySpecReduce_1  145# happyReduction_388
happyReduction_388 happy_x_1
	 =  case happyOut278 happy_x_1 of { happy_var_1 -> 
	happyIn159
		 (sL1 happy_var_1 (case (unLoc happy_var_1) of (n, doc) -> DocGroup n doc)
	)}

happyReduce_389 = happySpecReduce_1  146# happyReduction_389
happyReduction_389 happy_x_1
	 =  case happyOut165 happy_x_1 of { happy_var_1 -> 
	happyIn160
		 (happy_var_1
	)}

happyReduce_390 = happyMonadReduce 3# 146# happyReduction_390
happyReduction_390 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut176 happy_x_2 of { happy_var_2 -> 
	case happyOut162 happy_x_3 of { happy_var_3 -> 
	( do { let { e = sLL happy_var_1 happy_var_2 (SectionR (sL1 happy_var_1 (HsVar (sL1 happy_var_1 bang_RDR))) happy_var_2) };
                                        pat <- checkPattern empty e;
                                        _ <- ams (sLL happy_var_1 happy_var_3 ())
                                               (fst $ unLoc happy_var_3);
                                        return $ sLL happy_var_1 happy_var_3 $ ValD $
                                            PatBind pat (snd $ unLoc happy_var_3)
                                                    placeHolderType
                                                    placeHolderNames
                                                    ([],[]) })}}}
	) (\r -> happyReturn (happyIn160 r))

happyReduce_391 = happyMonadReduce 3# 146# happyReduction_391
happyReduction_391 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut170 happy_x_1 of { happy_var_1 -> 
	case happyOut114 happy_x_2 of { happy_var_2 -> 
	case happyOut162 happy_x_3 of { happy_var_3 -> 
	( do { (ann,r) <- checkValDef empty happy_var_1 (snd happy_var_2) happy_var_3;
                                        let { l = comb2 happy_var_1 happy_var_3 };
                                        case r of {
                                          (FunBind n _ _ _ _) ->
                                                ams (L l ()) (mj AnnFunId n:(fst happy_var_2)) >> return () ;
                                          (PatBind (L lh _lhs) _rhs _ _ _) ->
                                                ams (L lh ()) (fst happy_var_2) >> return () } ;
                                        _ <- ams (L l ()) (ann ++ (fst $ unLoc happy_var_3));
                                        return $! (sL l $ ValD r) })}}}
	) (\r -> happyReturn (happyIn160 r))

happyReduce_392 = happySpecReduce_1  146# happyReduction_392
happyReduction_392 happy_x_1
	 =  case happyOut78 happy_x_1 of { happy_var_1 -> 
	happyIn160
		 (happy_var_1
	)}

happyReduce_393 = happySpecReduce_1  146# happyReduction_393
happyReduction_393 happy_x_1
	 =  case happyOut158 happy_x_1 of { happy_var_1 -> 
	happyIn160
		 (happy_var_1
	)}

happyReduce_394 = happySpecReduce_1  147# happyReduction_394
happyReduction_394 happy_x_1
	 =  case happyOut160 happy_x_1 of { happy_var_1 -> 
	happyIn161
		 (happy_var_1
	)}

happyReduce_395 = happySpecReduce_1  147# happyReduction_395
happyReduction_395 happy_x_1
	 =  case happyOut179 happy_x_1 of { happy_var_1 -> 
	happyIn161
		 (sLL happy_var_1 happy_var_1 $ mkSpliceDecl happy_var_1
	)}

happyReduce_396 = happySpecReduce_3  148# happyReduction_396
happyReduction_396 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut169 happy_x_2 of { happy_var_2 -> 
	case happyOut95 happy_x_3 of { happy_var_3 -> 
	happyIn162
		 (sL (comb3 happy_var_1 happy_var_2 happy_var_3)
                                    ((mj AnnEqual happy_var_1 : (fst $ unLoc happy_var_3))
                                    ,GRHSs (unguardedRHS (comb3 happy_var_1 happy_var_2 happy_var_3) happy_var_2)
                                   (snd $ unLoc happy_var_3))
	)}}}

happyReduce_397 = happySpecReduce_2  148# happyReduction_397
happyReduction_397 happy_x_2
	happy_x_1
	 =  case happyOut163 happy_x_1 of { happy_var_1 -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	happyIn162
		 (sLL happy_var_1 happy_var_2  (fst $ unLoc happy_var_2
                                    ,GRHSs (reverse (unLoc happy_var_1))
                                                    (snd $ unLoc happy_var_2))
	)}}

happyReduce_398 = happySpecReduce_2  149# happyReduction_398
happyReduction_398 happy_x_2
	happy_x_1
	 =  case happyOut163 happy_x_1 of { happy_var_1 -> 
	case happyOut164 happy_x_2 of { happy_var_2 -> 
	happyIn163
		 (sLL happy_var_1 happy_var_2 (happy_var_2 : unLoc happy_var_1)
	)}}

happyReduce_399 = happySpecReduce_1  149# happyReduction_399
happyReduction_399 happy_x_1
	 =  case happyOut164 happy_x_1 of { happy_var_1 -> 
	happyIn163
		 (sL1 happy_var_1 [happy_var_1]
	)}

happyReduce_400 = happyMonadReduce 4# 150# happyReduction_400
happyReduction_400 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut195 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut169 happy_x_4 of { happy_var_4 -> 
	( ams (sL (comb2 happy_var_1 happy_var_4) $ GRHS (unLoc happy_var_2) happy_var_4)
                                         [mj AnnVbar happy_var_1,mj AnnEqual happy_var_3])}}}}
	) (\r -> happyReturn (happyIn164 r))

happyReduce_401 = happyMonadReduce 3# 151# happyReduction_401
happyReduction_401 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut170 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut117 happy_x_3 of { happy_var_3 -> 
	( do v <- checkValSigLhs happy_var_1
                        ; _ <- ams (sLL happy_var_1 happy_var_3 ()) [mu AnnDcolon happy_var_2]
                        ; return (sLL happy_var_1 happy_var_3 $ SigD $
                                  TypeSig [v] (mkLHsSigWcType happy_var_3)))}}}
	) (\r -> happyReturn (happyIn165 r))

happyReduce_402 = happyMonadReduce 5# 151# happyReduction_402
happyReduction_402 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut256 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut118 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	case happyOut117 happy_x_5 of { happy_var_5 -> 
	( do { let sig = TypeSig (happy_var_1 : reverse (unLoc happy_var_3))
                                     (mkLHsSigWcType happy_var_5)
                 ; addAnnotation (gl happy_var_1) AnnComma (gl happy_var_2)
                 ; ams ( sLL happy_var_1 happy_var_5 $ SigD sig )
                       [mu AnnDcolon happy_var_4] })}}}}}
	) (\r -> happyReturn (happyIn165 r))

happyReduce_403 = happyMonadReduce 3# 151# happyReduction_403
happyReduction_403 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut48 happy_x_1 of { happy_var_1 -> 
	case happyOut47 happy_x_2 of { happy_var_2 -> 
	case happyOut49 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ SigD
                        (FixSig (FixitySig (fromOL $ unLoc happy_var_3)
                                (Fixity (fst $ unLoc happy_var_2) (snd $ unLoc happy_var_2) (unLoc happy_var_1)))))
                     [mj AnnInfix happy_var_1,mj AnnVal happy_var_2])}}}
	) (\r -> happyReturn (happyIn165 r))

happyReduce_404 = happySpecReduce_1  151# happyReduction_404
happyReduction_404 happy_x_1
	 =  case happyOut83 happy_x_1 of { happy_var_1 -> 
	happyIn165
		 (sLL happy_var_1 happy_var_1 . SigD . unLoc $ happy_var_1
	)}

happyReduce_405 = happyMonadReduce 4# 151# happyReduction_405
happyReduction_405 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut166 happy_x_2 of { happy_var_2 -> 
	case happyOut257 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	( ams ((sLL happy_var_1 happy_var_4 $ SigD (InlineSig happy_var_3
                            (mkInlinePragma (getINLINE_PRAGs happy_var_1) (getINLINE happy_var_1)
                                            (snd happy_var_2)))))
                       ((mo happy_var_1:fst happy_var_2) ++ [mc happy_var_4]))}}}}
	) (\r -> happyReturn (happyIn165 r))

happyReduce_406 = happyMonadReduce 6# 151# happyReduction_406
happyReduction_406 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut166 happy_x_2 of { happy_var_2 -> 
	case happyOut257 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	case happyOut119 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { happy_var_6 -> 
	( ams (
                 let inl_prag = mkInlinePragma (getSPEC_PRAGs happy_var_1)
                                             (EmptyInlineSpec, FunLike) (snd happy_var_2)
                  in sLL happy_var_1 happy_var_6 $ SigD (SpecSig happy_var_3 (fromOL happy_var_5) inl_prag))
                    (mo happy_var_1:mu AnnDcolon happy_var_4:mc happy_var_6:(fst happy_var_2)))}}}}}}
	) (\r -> happyReturn (happyIn165 r))

happyReduce_407 = happyMonadReduce 6# 151# happyReduction_407
happyReduction_407 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut166 happy_x_2 of { happy_var_2 -> 
	case happyOut257 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	case happyOut119 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { happy_var_6 -> 
	( ams (sLL happy_var_1 happy_var_6 $ SigD (SpecSig happy_var_3 (fromOL happy_var_5)
                               (mkInlinePragma (getSPEC_INLINE_PRAGs happy_var_1)
                                               (getSPEC_INLINE happy_var_1) (snd happy_var_2))))
                       (mo happy_var_1:mu AnnDcolon happy_var_4:mc happy_var_6:(fst happy_var_2)))}}}}}}
	) (\r -> happyReturn (happyIn165 r))

happyReduce_408 = happyMonadReduce 4# 151# happyReduction_408
happyReduction_408 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut134 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	( ams (sLL happy_var_1 happy_var_4
                                  $ SigD (SpecInstSig (getSPEC_PRAGs happy_var_1) happy_var_3))
                       [mo happy_var_1,mj AnnInstance happy_var_2,mc happy_var_4])}}}}
	) (\r -> happyReturn (happyIn165 r))

happyReduce_409 = happyMonadReduce 3# 151# happyReduction_409
happyReduction_409 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut223 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ SigD (MinimalSig (getMINIMAL_PRAGs happy_var_1) happy_var_2))
                   [mo happy_var_1,mc happy_var_3])}}}
	) (\r -> happyReturn (happyIn165 r))

happyReduce_410 = happySpecReduce_0  152# happyReduction_410
happyReduction_410  =  happyIn166
		 (([],Nothing)
	)

happyReduce_411 = happySpecReduce_1  152# happyReduction_411
happyReduction_411 happy_x_1
	 =  case happyOut167 happy_x_1 of { happy_var_1 -> 
	happyIn166
		 ((fst happy_var_1,Just (snd happy_var_1))
	)}

happyReduce_412 = happySpecReduce_3  153# happyReduction_412
happyReduction_412 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn167
		 (([mj AnnOpenS happy_var_1,mj AnnVal happy_var_2,mj AnnCloseS happy_var_3]
                                  ,ActiveAfter  (getINTEGERs happy_var_2) (fromInteger (getINTEGER happy_var_2)))
	)}}}

happyReduce_413 = happyReduce 4# 153# happyReduction_413
happyReduction_413 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	happyIn167
		 (([mj AnnOpenS happy_var_1,mj AnnTilde happy_var_2,mj AnnVal happy_var_3
                                                 ,mj AnnCloseS happy_var_4]
                                  ,ActiveBefore (getINTEGERs happy_var_3) (fromInteger (getINTEGER happy_var_3)))
	) `HappyStk` happyRest}}}}

happyReduce_414 = happySpecReduce_1  154# happyReduction_414
happyReduction_414 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn168
		 (let { loc = getLoc happy_var_1
                                ; ITquasiQuote (quoter, quote, quoteSpan) = unLoc happy_var_1
                                ; quoterId = mkUnqual varName quoter }
                            in sL1 happy_var_1 (mkHsQuasiQuote quoterId (RealSrcSpan quoteSpan) quote)
	)}

happyReduce_415 = happySpecReduce_1  154# happyReduction_415
happyReduction_415 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn168
		 (let { loc = getLoc happy_var_1
                                ; ITqQuasiQuote (qual, quoter, quote, quoteSpan) = unLoc happy_var_1
                                ; quoterId = mkQual varName (qual, quoter) }
                            in sL (getLoc happy_var_1) (mkHsQuasiQuote quoterId (RealSrcSpan quoteSpan) quote)
	)}

happyReduce_416 = happyMonadReduce 3# 155# happyReduction_416
happyReduction_416 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut170 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut116 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ ExprWithTySig happy_var_1 (mkLHsSigWcType happy_var_3))
                                       [mu AnnDcolon happy_var_2])}}}
	) (\r -> happyReturn (happyIn169 r))

happyReduce_417 = happyMonadReduce 3# 155# happyReduction_417
happyReduction_417 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut170 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut169 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ HsArrApp happy_var_1 happy_var_3 placeHolderType
                                                        HsFirstOrderApp True)
                                       [mu Annlarrowtail happy_var_2])}}}
	) (\r -> happyReturn (happyIn169 r))

happyReduce_418 = happyMonadReduce 3# 155# happyReduction_418
happyReduction_418 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut170 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut169 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ HsArrApp happy_var_3 happy_var_1 placeHolderType
                                                      HsFirstOrderApp False)
                                       [mu Annrarrowtail happy_var_2])}}}
	) (\r -> happyReturn (happyIn169 r))

happyReduce_419 = happyMonadReduce 3# 155# happyReduction_419
happyReduction_419 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut170 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut169 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ HsArrApp happy_var_1 happy_var_3 placeHolderType
                                                      HsHigherOrderApp True)
                                       [mu AnnLarrowtail happy_var_2])}}}
	) (\r -> happyReturn (happyIn169 r))

happyReduce_420 = happyMonadReduce 3# 155# happyReduction_420
happyReduction_420 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut170 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut169 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ HsArrApp happy_var_3 happy_var_1 placeHolderType
                                                      HsHigherOrderApp False)
                                       [mu AnnRarrowtail happy_var_2])}}}
	) (\r -> happyReturn (happyIn169 r))

happyReduce_421 = happySpecReduce_1  155# happyReduction_421
happyReduction_421 happy_x_1
	 =  case happyOut170 happy_x_1 of { happy_var_1 -> 
	happyIn169
		 (happy_var_1
	)}

happyReduce_422 = happySpecReduce_1  156# happyReduction_422
happyReduction_422 happy_x_1
	 =  case happyOut171 happy_x_1 of { happy_var_1 -> 
	happyIn170
		 (happy_var_1
	)}

happyReduce_423 = happyMonadReduce 3# 156# happyReduction_423
happyReduction_423 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut170 happy_x_1 of { happy_var_1 -> 
	case happyOut249 happy_x_2 of { happy_var_2 -> 
	case happyOut171 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3
                                             (OpApp happy_var_1 happy_var_2 placeHolderFixity happy_var_3))
                                         [mj AnnVal happy_var_2])}}}
	) (\r -> happyReturn (happyIn170 r))

happyReduce_424 = happyMonadReduce 6# 157# happyReduction_424
happyReduction_424 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut209 happy_x_2 of { happy_var_2 -> 
	case happyOut210 happy_x_3 of { happy_var_3 -> 
	case happyOut115 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { happy_var_5 -> 
	case happyOut169 happy_x_6 of { happy_var_6 -> 
	( ams (sLL happy_var_1 happy_var_6 $ HsLam (mkMatchGroup FromSource
                            [sLL happy_var_1 happy_var_6 $ Match { m_fixity = NonFunBindMatch
                                               , m_pats = happy_var_2:happy_var_3
                                               , m_type = snd happy_var_4
                                               , m_grhss = unguardedGRHSs happy_var_6 }]))
                          (mj AnnLam happy_var_1:mu AnnRarrow happy_var_5:(fst happy_var_4)))}}}}}}
	) (\r -> happyReturn (happyIn171 r))

happyReduce_425 = happyMonadReduce 4# 157# happyReduction_425
happyReduction_425 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut94 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut169 happy_x_4 of { happy_var_4 -> 
	( ams (sLL happy_var_1 happy_var_4 $ HsLet (snd $ unLoc happy_var_2) happy_var_4)
                                               (mj AnnLet happy_var_1:mj AnnIn happy_var_3
                                                 :(fst $ unLoc happy_var_2)))}}}}
	) (\r -> happyReturn (happyIn171 r))

happyReduce_426 = happyMonadReduce 3# 157# happyReduction_426
happyReduction_426 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut197 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ HsLamCase placeHolderType
                                   (mkMatchGroup FromSource (snd $ unLoc happy_var_3)))
                   (mj AnnLam happy_var_1:mj AnnCase happy_var_2:(fst $ unLoc happy_var_3)))}}}
	) (\r -> happyReturn (happyIn171 r))

happyReduce_427 = happyMonadReduce 8# 157# happyReduction_427
happyReduction_427 (happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut169 happy_x_2 of { happy_var_2 -> 
	case happyOut172 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	case happyOut169 happy_x_5 of { happy_var_5 -> 
	case happyOut172 happy_x_6 of { happy_var_6 -> 
	case happyOutTok happy_x_7 of { happy_var_7 -> 
	case happyOut169 happy_x_8 of { happy_var_8 -> 
	( checkDoAndIfThenElse happy_var_2 (snd happy_var_3) happy_var_5 (snd happy_var_6) happy_var_8 >>
                              ams (sLL happy_var_1 happy_var_8 $ mkHsIf happy_var_2 happy_var_5 happy_var_8)
                                  (mj AnnIf happy_var_1:mj AnnThen happy_var_4
                                     :mj AnnElse happy_var_7
                                     :(map (\l -> mj AnnSemi l) (fst happy_var_3))
                                    ++(map (\l -> mj AnnSemi l) (fst happy_var_6))))}}}}}}}}
	) (\r -> happyReturn (happyIn171 r))

happyReduce_428 = happyMonadReduce 2# 157# happyReduction_428
happyReduction_428 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut205 happy_x_2 of { happy_var_2 -> 
	( hintMultiWayIf (getLoc happy_var_1) >>
                                           ams (sLL happy_var_1 happy_var_2 $ HsMultiIf
                                                     placeHolderType
                                                     (reverse $ snd $ unLoc happy_var_2))
                                               (mj AnnIf happy_var_1:(fst $ unLoc happy_var_2)))}}
	) (\r -> happyReturn (happyIn171 r))

happyReduce_429 = happyMonadReduce 4# 157# happyReduction_429
happyReduction_429 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut169 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut197 happy_x_4 of { happy_var_4 -> 
	( ams (sLL happy_var_1 happy_var_4 $ HsCase happy_var_2 (mkMatchGroup
                                                   FromSource (snd $ unLoc happy_var_4)))
                                               (mj AnnCase happy_var_1:mj AnnOf happy_var_3
                                                  :(fst $ unLoc happy_var_4)))}}}}
	) (\r -> happyReturn (happyIn171 r))

happyReduce_430 = happyMonadReduce 2# 157# happyReduction_430
happyReduction_430 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut175 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ NegApp happy_var_2 noSyntaxExpr)
                                               [mj AnnMinus happy_var_1])}}
	) (\r -> happyReturn (happyIn171 r))

happyReduce_431 = happyMonadReduce 2# 157# happyReduction_431
happyReduction_431 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut211 happy_x_2 of { happy_var_2 -> 
	( ams (L (comb2 happy_var_1 happy_var_2)
                                               (mkHsDo DoExpr (snd $ unLoc happy_var_2)))
                                               (mj AnnDo happy_var_1:(fst $ unLoc happy_var_2)))}}
	) (\r -> happyReturn (happyIn171 r))

happyReduce_432 = happyMonadReduce 2# 157# happyReduction_432
happyReduction_432 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut211 happy_x_2 of { happy_var_2 -> 
	( ams (L (comb2 happy_var_1 happy_var_2)
                                              (mkHsDo MDoExpr (snd $ unLoc happy_var_2)))
                                           (mj AnnMdo happy_var_1:(fst $ unLoc happy_var_2)))}}
	) (\r -> happyReturn (happyIn171 r))

happyReduce_433 = happyMonadReduce 2# 157# happyReduction_433
happyReduction_433 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut173 happy_x_1 of { happy_var_1 -> 
	case happyOut169 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ HsSCC (snd $ fst $ unLoc happy_var_1) (snd $ unLoc happy_var_1) happy_var_2)
                                      (fst $ fst $ unLoc happy_var_1))}}
	) (\r -> happyReturn (happyIn171 r))

happyReduce_434 = happyMonadReduce 2# 157# happyReduction_434
happyReduction_434 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOut169 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ HsTickPragma (snd $ fst $ fst $ unLoc happy_var_1)
                                                                (snd $ fst $ unLoc happy_var_1) (snd $ unLoc happy_var_1) happy_var_2)
                                      (fst $ fst $ fst $ unLoc happy_var_1))}}
	) (\r -> happyReturn (happyIn171 r))

happyReduce_435 = happyMonadReduce 4# 157# happyReduction_435
happyReduction_435 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut176 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut169 happy_x_4 of { happy_var_4 -> 
	( checkPattern empty happy_var_2 >>= \ p ->
                           checkCommand happy_var_4 >>= \ cmd ->
                           ams (sLL happy_var_1 happy_var_4 $ HsProc p (sLL happy_var_1 happy_var_4 $ HsCmdTop cmd placeHolderType
                                                placeHolderType []))
                                            -- TODO: is LL right here?
                               [mj AnnProc happy_var_1,mu AnnRarrow happy_var_3])}}}}
	) (\r -> happyReturn (happyIn171 r))

happyReduce_436 = happyMonadReduce 4# 157# happyReduction_436
happyReduction_436 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut169 happy_x_4 of { happy_var_4 -> 
	( ams (sLL happy_var_1 happy_var_4 $ HsCoreAnn (getCORE_PRAGs happy_var_1) (getStringLiteral happy_var_2) happy_var_4)
                                              [mo happy_var_1,mj AnnVal happy_var_2
                                              ,mc happy_var_3])}}}}
	) (\r -> happyReturn (happyIn171 r))

happyReduce_437 = happySpecReduce_1  157# happyReduction_437
happyReduction_437 happy_x_1
	 =  case happyOut175 happy_x_1 of { happy_var_1 -> 
	happyIn171
		 (happy_var_1
	)}

happyReduce_438 = happySpecReduce_1  158# happyReduction_438
happyReduction_438 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn172
		 (([happy_var_1],True)
	)}

happyReduce_439 = happySpecReduce_0  158# happyReduction_439
happyReduction_439  =  happyIn172
		 (([],False)
	)

happyReduce_440 = happyMonadReduce 3# 159# happyReduction_440
happyReduction_440 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( do scc <- getSCC happy_var_2
                                            ; return $ sLL happy_var_1 happy_var_3
                                               (([mo happy_var_1,mj AnnValStr happy_var_2
                                                ,mc happy_var_3],getSCC_PRAGs happy_var_1),(StringLiteral (getSTRINGs happy_var_2) scc)))}}}
	) (\r -> happyReturn (happyIn173 r))

happyReduce_441 = happySpecReduce_3  159# happyReduction_441
happyReduction_441 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn173
		 (sLL happy_var_1 happy_var_3 (([mo happy_var_1,mj AnnVal happy_var_2
                                         ,mc happy_var_3],getSCC_PRAGs happy_var_1)
                                        ,(StringLiteral (unpackFS $ getVARID happy_var_2) (getVARID happy_var_2)))
	)}}}

happyReduce_442 = happyReduce 10# 160# happyReduction_442
happyReduction_442 (happy_x_10 `HappyStk`
	happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { happy_var_6 -> 
	case happyOutTok happy_x_7 of { happy_var_7 -> 
	case happyOutTok happy_x_8 of { happy_var_8 -> 
	case happyOutTok happy_x_9 of { happy_var_9 -> 
	case happyOutTok happy_x_10 of { happy_var_10 -> 
	happyIn174
		 (sLL happy_var_1 happy_var_10 $ ((([mo happy_var_1,mj AnnVal happy_var_2
                                              ,mj AnnVal happy_var_3,mj AnnColon happy_var_4
                                              ,mj AnnVal happy_var_5,mj AnnMinus happy_var_6
                                              ,mj AnnVal happy_var_7,mj AnnColon happy_var_8
                                              ,mj AnnVal happy_var_9,mc happy_var_10],
                                                getGENERATED_PRAGs happy_var_1)
                                              ,((getStringLiteral happy_var_2)
                                               ,( fromInteger $ getINTEGER happy_var_3
                                                , fromInteger $ getINTEGER happy_var_5
                                                )
                                               ,( fromInteger $ getINTEGER happy_var_7
                                                , fromInteger $ getINTEGER happy_var_9
                                                )
                                               ))
                                             , (( getINTEGERs happy_var_3
                                                , getINTEGERs happy_var_5
                                                )
                                               ,( getINTEGERs happy_var_7
                                                , getINTEGERs happy_var_9
                                                )))
	) `HappyStk` happyRest}}}}}}}}}}

happyReduce_443 = happySpecReduce_2  161# happyReduction_443
happyReduction_443 happy_x_2
	happy_x_1
	 =  case happyOut175 happy_x_1 of { happy_var_1 -> 
	case happyOut176 happy_x_2 of { happy_var_2 -> 
	happyIn175
		 (sLL happy_var_1 happy_var_2 $ HsApp happy_var_1 happy_var_2
	)}}

happyReduce_444 = happyMonadReduce 3# 161# happyReduction_444
happyReduction_444 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut175 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut133 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ HsAppType happy_var_1 (mkHsWildCardBndrs happy_var_3))
                                            [mj AnnAt happy_var_2])}}}
	) (\r -> happyReturn (happyIn175 r))

happyReduce_445 = happyMonadReduce 2# 161# happyReduction_445
happyReduction_445 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut176 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ HsStatic happy_var_2)
                                            [mj AnnStatic happy_var_1])}}
	) (\r -> happyReturn (happyIn175 r))

happyReduce_446 = happySpecReduce_1  161# happyReduction_446
happyReduction_446 happy_x_1
	 =  case happyOut176 happy_x_1 of { happy_var_1 -> 
	happyIn175
		 (happy_var_1
	)}

happyReduce_447 = happyMonadReduce 3# 162# happyReduction_447
happyReduction_447 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut257 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut176 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ EAsPat happy_var_1 happy_var_3) [mj AnnAt happy_var_2])}}}
	) (\r -> happyReturn (happyIn176 r))

happyReduce_448 = happyMonadReduce 2# 162# happyReduction_448
happyReduction_448 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut176 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ ELazyPat happy_var_2) [mj AnnTilde happy_var_1])}}
	) (\r -> happyReturn (happyIn176 r))

happyReduce_449 = happySpecReduce_1  162# happyReduction_449
happyReduction_449 happy_x_1
	 =  case happyOut177 happy_x_1 of { happy_var_1 -> 
	happyIn176
		 (happy_var_1
	)}

happyReduce_450 = happyMonadReduce 4# 163# happyReduction_450
happyReduction_450 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut177 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut216 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	( do { r <- mkRecConstrOrUpdate happy_var_1 (comb2 happy_var_2 happy_var_4)
                                                                   (snd happy_var_3)
                                     ; _ <- ams (sLL happy_var_1 happy_var_4 ()) (moc happy_var_2:mcc happy_var_4:(fst happy_var_3))
                                     ; checkRecordSyntax (sLL happy_var_1 happy_var_4 r) })}}}}
	) (\r -> happyReturn (happyIn177 r))

happyReduce_451 = happySpecReduce_1  163# happyReduction_451
happyReduction_451 happy_x_1
	 =  case happyOut178 happy_x_1 of { happy_var_1 -> 
	happyIn177
		 (happy_var_1
	)}

happyReduce_452 = happySpecReduce_1  164# happyReduction_452
happyReduction_452 happy_x_1
	 =  case happyOut257 happy_x_1 of { happy_var_1 -> 
	happyIn178
		 (sL1 happy_var_1 (HsVar   $! happy_var_1)
	)}

happyReduce_453 = happySpecReduce_1  164# happyReduction_453
happyReduction_453 happy_x_1
	 =  case happyOut230 happy_x_1 of { happy_var_1 -> 
	happyIn178
		 (sL1 happy_var_1 (HsVar   $! happy_var_1)
	)}

happyReduce_454 = happySpecReduce_1  164# happyReduction_454
happyReduction_454 happy_x_1
	 =  case happyOut221 happy_x_1 of { happy_var_1 -> 
	happyIn178
		 (sL1 happy_var_1 (HsIPVar $! unLoc happy_var_1)
	)}

happyReduce_455 = happySpecReduce_1  164# happyReduction_455
happyReduction_455 happy_x_1
	 =  case happyOut222 happy_x_1 of { happy_var_1 -> 
	happyIn178
		 (sL1 happy_var_1 (HsOverLabel $! unLoc happy_var_1)
	)}

happyReduce_456 = happySpecReduce_1  164# happyReduction_456
happyReduction_456 happy_x_1
	 =  case happyOut271 happy_x_1 of { happy_var_1 -> 
	happyIn178
		 (sL1 happy_var_1 (HsLit   $! unLoc happy_var_1)
	)}

happyReduce_457 = happySpecReduce_1  164# happyReduction_457
happyReduction_457 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn178
		 (sL (getLoc happy_var_1) (HsOverLit $! mkHsIntegral (getINTEGERs happy_var_1)
                                         (getINTEGER happy_var_1) placeHolderType)
	)}

happyReduce_458 = happySpecReduce_1  164# happyReduction_458
happyReduction_458 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn178
		 (sL (getLoc happy_var_1) (HsOverLit $! mkHsFractional
                                          (getRATIONAL happy_var_1) placeHolderType)
	)}

happyReduce_459 = happyMonadReduce 3# 164# happyReduction_459
happyReduction_459 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut184 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (HsPar happy_var_2)) [mop happy_var_1,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn178 r))

happyReduce_460 = happyMonadReduce 3# 164# happyReduction_460
happyReduction_460 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut185 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (ExplicitTuple happy_var_2 Boxed))
                                               [mop happy_var_1,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn178 r))

happyReduce_461 = happyMonadReduce 3# 164# happyReduction_461
happyReduction_461 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut184 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (ExplicitTuple [L (gl happy_var_2)
                                                         (Present happy_var_2)] Unboxed))
                                               [mo happy_var_1,mc happy_var_3])}}}
	) (\r -> happyReturn (happyIn178 r))

happyReduce_462 = happyMonadReduce 3# 164# happyReduction_462
happyReduction_462 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut185 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (ExplicitTuple happy_var_2 Unboxed))
                                               [mo happy_var_1,mc happy_var_3])}}}
	) (\r -> happyReturn (happyIn178 r))

happyReduce_463 = happyMonadReduce 3# 164# happyReduction_463
happyReduction_463 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut188 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (snd happy_var_2)) (mos happy_var_1:mcs happy_var_3:(fst happy_var_2)))}}}
	) (\r -> happyReturn (happyIn178 r))

happyReduce_464 = happyMonadReduce 3# 164# happyReduction_464
happyReduction_464 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut194 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (snd happy_var_2)) (mo happy_var_1:mc happy_var_3:(fst happy_var_2)))}}}
	) (\r -> happyReturn (happyIn178 r))

happyReduce_465 = happySpecReduce_1  164# happyReduction_465
happyReduction_465 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn178
		 (sL1 happy_var_1 EWildPat
	)}

happyReduce_466 = happySpecReduce_1  164# happyReduction_466
happyReduction_466 happy_x_1
	 =  case happyOut179 happy_x_1 of { happy_var_1 -> 
	happyIn178
		 (happy_var_1
	)}

happyReduce_467 = happyMonadReduce 2# 164# happyReduction_467
happyReduction_467 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut257 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ HsBracket (VarBr True  (unLoc happy_var_2))) [mj AnnSimpleQuote happy_var_1,mj AnnName happy_var_2])}}
	) (\r -> happyReturn (happyIn178 r))

happyReduce_468 = happyMonadReduce 2# 164# happyReduction_468
happyReduction_468 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut230 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ HsBracket (VarBr True  (unLoc happy_var_2))) [mj AnnSimpleQuote happy_var_1,mj AnnName happy_var_2])}}
	) (\r -> happyReturn (happyIn178 r))

happyReduce_469 = happyMonadReduce 2# 164# happyReduction_469
happyReduction_469 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut253 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ HsBracket (VarBr False (unLoc happy_var_2))) [mj AnnThTyQuote happy_var_1,mj AnnName happy_var_2])}}
	) (\r -> happyReturn (happyIn178 r))

happyReduce_470 = happyMonadReduce 2# 164# happyReduction_470
happyReduction_470 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut238 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ HsBracket (VarBr False (unLoc happy_var_2))) [mj AnnThTyQuote happy_var_1,mj AnnName happy_var_2])}}
	) (\r -> happyReturn (happyIn178 r))

happyReduce_471 = happyMonadReduce 3# 164# happyReduction_471
happyReduction_471 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut169 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ HsBracket (ExpBr happy_var_2))
                                      (if (hasE happy_var_1) then [mj AnnOpenE happy_var_1,mc happy_var_3] else [mo happy_var_1,mc happy_var_3]))}}}
	) (\r -> happyReturn (happyIn178 r))

happyReduce_472 = happyMonadReduce 3# 164# happyReduction_472
happyReduction_472 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut169 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ HsBracket (TExpBr happy_var_2))
                                      (if (hasE happy_var_1) then [mj AnnOpenE happy_var_1,mc happy_var_3] else [mo happy_var_1,mc happy_var_3]))}}}
	) (\r -> happyReturn (happyIn178 r))

happyReduce_473 = happyMonadReduce 3# 164# happyReduction_473
happyReduction_473 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut123 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ HsBracket (TypBr happy_var_2)) [mo happy_var_1,mc happy_var_3])}}}
	) (\r -> happyReturn (happyIn178 r))

happyReduce_474 = happyMonadReduce 3# 164# happyReduction_474
happyReduction_474 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( checkPattern empty happy_var_2 >>= \p ->
                                      ams (sLL happy_var_1 happy_var_3 $ HsBracket (PatBr p))
                                          [mo happy_var_1,mc happy_var_3])}}}
	) (\r -> happyReturn (happyIn178 r))

happyReduce_475 = happyMonadReduce 3# 164# happyReduction_475
happyReduction_475 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut182 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ HsBracket (DecBrL (snd happy_var_2)))
                                      (mo happy_var_1:mc happy_var_3:fst happy_var_2))}}}
	) (\r -> happyReturn (happyIn178 r))

happyReduce_476 = happySpecReduce_1  164# happyReduction_476
happyReduction_476 happy_x_1
	 =  case happyOut168 happy_x_1 of { happy_var_1 -> 
	happyIn178
		 (sL1 happy_var_1 (HsSpliceE (unLoc happy_var_1))
	)}

happyReduce_477 = happyMonadReduce 4# 164# happyReduction_477
happyReduction_477 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut178 happy_x_2 of { happy_var_2 -> 
	case happyOut180 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	( ams (sLL happy_var_1 happy_var_4 $ HsArrForm happy_var_2
                                                           Nothing (reverse happy_var_3))
                                          [mo happy_var_1,mc happy_var_4])}}}}
	) (\r -> happyReturn (happyIn178 r))

happyReduce_478 = happyMonadReduce 1# 165# happyReduction_478
happyReduction_478 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	( ams (sL1 happy_var_1 $ mkHsSpliceE
                                        (sL1 happy_var_1 $ HsVar (sL1 happy_var_1 (mkUnqual varName
                                                           (getTH_ID_SPLICE happy_var_1)))))
                                       [mj AnnThIdSplice happy_var_1])}
	) (\r -> happyReturn (happyIn179 r))

happyReduce_479 = happyMonadReduce 3# 165# happyReduction_479
happyReduction_479 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut169 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ mkHsSpliceE happy_var_2)
                                       [mj AnnOpenPE happy_var_1,mj AnnCloseP happy_var_3])}}}
	) (\r -> happyReturn (happyIn179 r))

happyReduce_480 = happyMonadReduce 1# 165# happyReduction_480
happyReduction_480 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	( ams (sL1 happy_var_1 $ mkHsSpliceTE
                                        (sL1 happy_var_1 $ HsVar (sL1 happy_var_1 (mkUnqual varName
                                                        (getTH_ID_TY_SPLICE happy_var_1)))))
                                       [mj AnnThIdTySplice happy_var_1])}
	) (\r -> happyReturn (happyIn179 r))

happyReduce_481 = happyMonadReduce 3# 165# happyReduction_481
happyReduction_481 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut169 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ mkHsSpliceTE happy_var_2)
                                       [mj AnnOpenPTE happy_var_1,mj AnnCloseP happy_var_3])}}}
	) (\r -> happyReturn (happyIn179 r))

happyReduce_482 = happySpecReduce_2  166# happyReduction_482
happyReduction_482 happy_x_2
	happy_x_1
	 =  case happyOut180 happy_x_1 of { happy_var_1 -> 
	case happyOut181 happy_x_2 of { happy_var_2 -> 
	happyIn180
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_483 = happySpecReduce_0  166# happyReduction_483
happyReduction_483  =  happyIn180
		 ([]
	)

happyReduce_484 = happyMonadReduce 1# 167# happyReduction_484
happyReduction_484 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut178 happy_x_1 of { happy_var_1 -> 
	( checkCommand happy_var_1 >>= \ cmd ->
                                    return (sL1 happy_var_1 $ HsCmdTop cmd
                                           placeHolderType placeHolderType []))}
	) (\r -> happyReturn (happyIn181 r))

happyReduce_485 = happySpecReduce_3  168# happyReduction_485
happyReduction_485 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut183 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn182
		 (([mj AnnOpenC happy_var_1
                                                  ,mj AnnCloseC happy_var_3],happy_var_2)
	)}}}

happyReduce_486 = happySpecReduce_3  168# happyReduction_486
happyReduction_486 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut183 happy_x_2 of { happy_var_2 -> 
	happyIn182
		 (([],happy_var_2)
	)}

happyReduce_487 = happySpecReduce_0  169# happyReduction_487
happyReduction_487  =  happyIn183
		 ([]
	)

happyReduce_488 = happySpecReduce_1  169# happyReduction_488
happyReduction_488 happy_x_1
	 =  case happyOut22 happy_x_1 of { happy_var_1 -> 
	happyIn183
		 (happy_var_1
	)}

happyReduce_489 = happySpecReduce_1  170# happyReduction_489
happyReduction_489 happy_x_1
	 =  case happyOut169 happy_x_1 of { happy_var_1 -> 
	happyIn184
		 (happy_var_1
	)}

happyReduce_490 = happySpecReduce_2  170# happyReduction_490
happyReduction_490 happy_x_2
	happy_x_1
	 =  case happyOut170 happy_x_1 of { happy_var_1 -> 
	case happyOut249 happy_x_2 of { happy_var_2 -> 
	happyIn184
		 (sLL happy_var_1 happy_var_2 $ SectionL happy_var_1 happy_var_2
	)}}

happyReduce_491 = happySpecReduce_2  170# happyReduction_491
happyReduction_491 happy_x_2
	happy_x_1
	 =  case happyOut250 happy_x_1 of { happy_var_1 -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	happyIn184
		 (sLL happy_var_1 happy_var_2 $ SectionR happy_var_1 happy_var_2
	)}}

happyReduce_492 = happyMonadReduce 3# 170# happyReduction_492
happyReduction_492 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut169 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut184 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ EViewPat happy_var_1 happy_var_3) [mu AnnRarrow happy_var_2])}}}
	) (\r -> happyReturn (happyIn184 r))

happyReduce_493 = happyMonadReduce 2# 171# happyReduction_493
happyReduction_493 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut184 happy_x_1 of { happy_var_1 -> 
	case happyOut186 happy_x_2 of { happy_var_2 -> 
	( do { addAnnotation (gl happy_var_1) AnnComma (fst happy_var_2)
                                ; return ((sL1 happy_var_1 (Present happy_var_1)) : snd happy_var_2) })}}
	) (\r -> happyReturn (happyIn185 r))

happyReduce_494 = happyMonadReduce 2# 171# happyReduction_494
happyReduction_494 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut274 happy_x_1 of { happy_var_1 -> 
	case happyOut187 happy_x_2 of { happy_var_2 -> 
	( do { mapM_ (\ll -> addAnnotation ll AnnComma ll) (fst happy_var_1)
                      ; return
                           (map (\l -> L l missingTupArg) (fst happy_var_1) ++ happy_var_2) })}}
	) (\r -> happyReturn (happyIn185 r))

happyReduce_495 = happyMonadReduce 2# 172# happyReduction_495
happyReduction_495 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut274 happy_x_1 of { happy_var_1 -> 
	case happyOut187 happy_x_2 of { happy_var_2 -> 
	( do { mapM_ (\ll -> addAnnotation ll AnnComma ll) (tail $ fst happy_var_1)
             ; return (
            (head $ fst happy_var_1
            ,(map (\l -> L l missingTupArg) (tail $ fst happy_var_1)) ++ happy_var_2)) })}}
	) (\r -> happyReturn (happyIn186 r))

happyReduce_496 = happyMonadReduce 2# 173# happyReduction_496
happyReduction_496 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut184 happy_x_1 of { happy_var_1 -> 
	case happyOut186 happy_x_2 of { happy_var_2 -> 
	( addAnnotation (gl happy_var_1) AnnComma (fst happy_var_2) >>
                                    return ((L (gl happy_var_1) (Present happy_var_1)) : snd happy_var_2))}}
	) (\r -> happyReturn (happyIn187 r))

happyReduce_497 = happySpecReduce_1  173# happyReduction_497
happyReduction_497 happy_x_1
	 =  case happyOut184 happy_x_1 of { happy_var_1 -> 
	happyIn187
		 ([L (gl happy_var_1) (Present happy_var_1)]
	)}

happyReduce_498 = happySpecReduce_0  173# happyReduction_498
happyReduction_498  =  happyIn187
		 ([noLoc missingTupArg]
	)

happyReduce_499 = happySpecReduce_1  174# happyReduction_499
happyReduction_499 happy_x_1
	 =  case happyOut184 happy_x_1 of { happy_var_1 -> 
	happyIn188
		 (([],ExplicitList placeHolderType Nothing [happy_var_1])
	)}

happyReduce_500 = happySpecReduce_1  174# happyReduction_500
happyReduction_500 happy_x_1
	 =  case happyOut189 happy_x_1 of { happy_var_1 -> 
	happyIn188
		 (([],ExplicitList placeHolderType Nothing
                                                   (reverse (unLoc happy_var_1)))
	)}

happyReduce_501 = happySpecReduce_2  174# happyReduction_501
happyReduction_501 happy_x_2
	happy_x_1
	 =  case happyOut184 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	happyIn188
		 (([mj AnnDotdot happy_var_2],
                                      ArithSeq noPostTcExpr Nothing (From happy_var_1))
	)}}

happyReduce_502 = happyReduce 4# 174# happyReduction_502
happyReduction_502 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut184 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut169 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	happyIn188
		 (([mj AnnComma happy_var_2,mj AnnDotdot happy_var_4],
                                  ArithSeq noPostTcExpr Nothing
                                                             (FromThen happy_var_1 happy_var_3))
	) `HappyStk` happyRest}}}}

happyReduce_503 = happySpecReduce_3  174# happyReduction_503
happyReduction_503 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut184 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut169 happy_x_3 of { happy_var_3 -> 
	happyIn188
		 (([mj AnnDotdot happy_var_2],
                                   ArithSeq noPostTcExpr Nothing
                                                               (FromTo happy_var_1 happy_var_3))
	)}}}

happyReduce_504 = happyReduce 5# 174# happyReduction_504
happyReduction_504 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut184 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut169 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	case happyOut169 happy_x_5 of { happy_var_5 -> 
	happyIn188
		 (([mj AnnComma happy_var_2,mj AnnDotdot happy_var_4],
                                    ArithSeq noPostTcExpr Nothing
                                                (FromThenTo happy_var_1 happy_var_3 happy_var_5))
	) `HappyStk` happyRest}}}}}

happyReduce_505 = happyMonadReduce 3# 174# happyReduction_505
happyReduction_505 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut184 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut190 happy_x_3 of { happy_var_3 -> 
	( checkMonadComp >>= \ ctxt ->
                return ([mj AnnVbar happy_var_2],
                        mkHsComp ctxt (unLoc happy_var_3) happy_var_1))}}}
	) (\r -> happyReturn (happyIn188 r))

happyReduce_506 = happyMonadReduce 3# 175# happyReduction_506
happyReduction_506 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut189 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut184 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl $ head $ unLoc happy_var_1)
                                                            AnnComma (gl happy_var_2) >>
                                      return (sLL happy_var_1 happy_var_3 (((:) $! happy_var_3) $! unLoc happy_var_1)))}}}
	) (\r -> happyReturn (happyIn189 r))

happyReduce_507 = happyMonadReduce 3# 175# happyReduction_507
happyReduction_507 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut184 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut184 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl happy_var_1) AnnComma (gl happy_var_2) >>
                                      return (sLL happy_var_1 happy_var_3 [happy_var_3,happy_var_1]))}}}
	) (\r -> happyReturn (happyIn189 r))

happyReduce_508 = happySpecReduce_1  176# happyReduction_508
happyReduction_508 happy_x_1
	 =  case happyOut191 happy_x_1 of { happy_var_1 -> 
	happyIn190
		 (case (unLoc happy_var_1) of
                    [qs] -> sL1 happy_var_1 qs
                    -- We just had one thing in our "parallel" list so
                    -- we simply return that thing directly

                    qss -> sL1 happy_var_1 [sL1 happy_var_1 $ ParStmt [ParStmtBlock qs [] noSyntaxExpr |
                                            qs <- qss]
                                            noExpr noSyntaxExpr placeHolderType]
                    -- We actually found some actual parallel lists so
                    -- we wrap them into as a ParStmt
	)}

happyReduce_509 = happyMonadReduce 3# 177# happyReduction_509
happyReduction_509 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut192 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut191 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl $ head $ unLoc happy_var_1) AnnVbar (gl happy_var_2) >>
                        return (sLL happy_var_1 happy_var_3 (reverse (unLoc happy_var_1) : unLoc happy_var_3)))}}}
	) (\r -> happyReturn (happyIn191 r))

happyReduce_510 = happySpecReduce_1  177# happyReduction_510
happyReduction_510 happy_x_1
	 =  case happyOut192 happy_x_1 of { happy_var_1 -> 
	happyIn191
		 (L (getLoc happy_var_1) [reverse (unLoc happy_var_1)]
	)}

happyReduce_511 = happyMonadReduce 3# 178# happyReduction_511
happyReduction_511 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut192 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut193 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl $ head $ unLoc happy_var_1) AnnComma (gl happy_var_2) >>
                ams (sLL happy_var_1 happy_var_3 ()) (fst $ unLoc happy_var_3) >>
                return (sLL happy_var_1 happy_var_3 [sLL happy_var_1 happy_var_3 ((snd $ unLoc happy_var_3) (reverse (unLoc happy_var_1)))]))}}}
	) (\r -> happyReturn (happyIn192 r))

happyReduce_512 = happyMonadReduce 3# 178# happyReduction_512
happyReduction_512 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut192 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut215 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl $ head $ unLoc happy_var_1) AnnComma (gl happy_var_2) >>
                return (sLL happy_var_1 happy_var_3 (happy_var_3 : unLoc happy_var_1)))}}}
	) (\r -> happyReturn (happyIn192 r))

happyReduce_513 = happyMonadReduce 1# 178# happyReduction_513
happyReduction_513 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut193 happy_x_1 of { happy_var_1 -> 
	( ams happy_var_1 (fst $ unLoc happy_var_1) >>
                              return (sLL happy_var_1 happy_var_1 [L (getLoc happy_var_1) ((snd $ unLoc happy_var_1) [])]))}
	) (\r -> happyReturn (happyIn192 r))

happyReduce_514 = happySpecReduce_1  178# happyReduction_514
happyReduction_514 happy_x_1
	 =  case happyOut215 happy_x_1 of { happy_var_1 -> 
	happyIn192
		 (sL1 happy_var_1 [happy_var_1]
	)}

happyReduce_515 = happySpecReduce_2  179# happyReduction_515
happyReduction_515 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut169 happy_x_2 of { happy_var_2 -> 
	happyIn193
		 (sLL happy_var_1 happy_var_2 ([mj AnnThen happy_var_1], \ss -> (mkTransformStmt ss happy_var_2))
	)}}

happyReduce_516 = happyReduce 4# 179# happyReduction_516
happyReduction_516 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut169 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut169 happy_x_4 of { happy_var_4 -> 
	happyIn193
		 (sLL happy_var_1 happy_var_4 ([mj AnnThen happy_var_1,mj AnnBy  happy_var_3],\ss -> (mkTransformByStmt ss happy_var_2 happy_var_4))
	) `HappyStk` happyRest}}}}

happyReduce_517 = happyReduce 4# 179# happyReduction_517
happyReduction_517 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut169 happy_x_4 of { happy_var_4 -> 
	happyIn193
		 (sLL happy_var_1 happy_var_4 ([mj AnnThen happy_var_1,mj AnnGroup happy_var_2,mj AnnUsing happy_var_3], \ss -> (mkGroupUsingStmt ss happy_var_4))
	) `HappyStk` happyRest}}}}

happyReduce_518 = happyReduce 6# 179# happyReduction_518
happyReduction_518 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut169 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { happy_var_5 -> 
	case happyOut169 happy_x_6 of { happy_var_6 -> 
	happyIn193
		 (sLL happy_var_1 happy_var_6 ([mj AnnThen happy_var_1,mj AnnGroup happy_var_2,mj AnnBy happy_var_3,mj AnnUsing happy_var_5], \ss -> (mkGroupByUsingStmt ss happy_var_4 happy_var_6))
	) `HappyStk` happyRest}}}}}}

happyReduce_519 = happySpecReduce_0  180# happyReduction_519
happyReduction_519  =  happyIn194
		 (([],ExplicitPArr placeHolderType [])
	)

happyReduce_520 = happySpecReduce_1  180# happyReduction_520
happyReduction_520 happy_x_1
	 =  case happyOut184 happy_x_1 of { happy_var_1 -> 
	happyIn194
		 (([],ExplicitPArr placeHolderType [happy_var_1])
	)}

happyReduce_521 = happySpecReduce_1  180# happyReduction_521
happyReduction_521 happy_x_1
	 =  case happyOut189 happy_x_1 of { happy_var_1 -> 
	happyIn194
		 (([],ExplicitPArr placeHolderType
                                                          (reverse (unLoc happy_var_1)))
	)}

happyReduce_522 = happySpecReduce_3  180# happyReduction_522
happyReduction_522 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut184 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut169 happy_x_3 of { happy_var_3 -> 
	happyIn194
		 (([mj AnnDotdot happy_var_2]
                                 ,PArrSeq noPostTcExpr (FromTo happy_var_1 happy_var_3))
	)}}}

happyReduce_523 = happyReduce 5# 180# happyReduction_523
happyReduction_523 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut184 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut169 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { happy_var_4 -> 
	case happyOut169 happy_x_5 of { happy_var_5 -> 
	happyIn194
		 (([mj AnnComma happy_var_2,mj AnnDotdot happy_var_4]
                          ,PArrSeq noPostTcExpr (FromThenTo happy_var_1 happy_var_3 happy_var_5))
	) `HappyStk` happyRest}}}}}

happyReduce_524 = happySpecReduce_3  180# happyReduction_524
happyReduction_524 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut184 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut190 happy_x_3 of { happy_var_3 -> 
	happyIn194
		 (([mj AnnVbar happy_var_2],mkHsComp PArrComp (unLoc happy_var_3) happy_var_1)
	)}}}

happyReduce_525 = happySpecReduce_1  181# happyReduction_525
happyReduction_525 happy_x_1
	 =  case happyOut196 happy_x_1 of { happy_var_1 -> 
	happyIn195
		 (L (getLoc happy_var_1) (reverse (unLoc happy_var_1))
	)}

happyReduce_526 = happyMonadReduce 3# 182# happyReduction_526
happyReduction_526 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut196 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut215 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl $ head $ unLoc happy_var_1) AnnComma
                                             (gl happy_var_2) >>
                               return (sLL happy_var_1 happy_var_3 (happy_var_3 : unLoc happy_var_1)))}}}
	) (\r -> happyReturn (happyIn196 r))

happyReduce_527 = happySpecReduce_1  182# happyReduction_527
happyReduction_527 happy_x_1
	 =  case happyOut215 happy_x_1 of { happy_var_1 -> 
	happyIn196
		 (sL1 happy_var_1 [happy_var_1]
	)}

happyReduce_528 = happySpecReduce_3  183# happyReduction_528
happyReduction_528 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut198 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn197
		 (sLL happy_var_1 happy_var_3 ((moc happy_var_1:mcc happy_var_3:(fst $ unLoc happy_var_2))
                                               ,(reverse (snd $ unLoc happy_var_2)))
	)}}}

happyReduce_529 = happySpecReduce_3  183# happyReduction_529
happyReduction_529 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut198 happy_x_2 of { happy_var_2 -> 
	happyIn197
		 (L (getLoc happy_var_2) (fst $ unLoc happy_var_2
                                        ,(reverse (snd $ unLoc happy_var_2)))
	)}

happyReduce_530 = happySpecReduce_2  183# happyReduction_530
happyReduction_530 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	happyIn197
		 (noLoc ([moc happy_var_1,mcc happy_var_2],[])
	)}}

happyReduce_531 = happySpecReduce_2  183# happyReduction_531
happyReduction_531 happy_x_2
	happy_x_1
	 =  happyIn197
		 (noLoc ([],[])
	)

happyReduce_532 = happySpecReduce_1  184# happyReduction_532
happyReduction_532 happy_x_1
	 =  case happyOut199 happy_x_1 of { happy_var_1 -> 
	happyIn198
		 (sL1 happy_var_1 (fst $ unLoc happy_var_1,snd $ unLoc happy_var_1)
	)}

happyReduce_533 = happySpecReduce_2  184# happyReduction_533
happyReduction_533 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut198 happy_x_2 of { happy_var_2 -> 
	happyIn198
		 (sLL happy_var_1 happy_var_2 ((mj AnnSemi happy_var_1:(fst $ unLoc happy_var_2))
                                               ,snd $ unLoc happy_var_2)
	)}}

happyReduce_534 = happyMonadReduce 3# 185# happyReduction_534
happyReduction_534 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut199 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut200 happy_x_3 of { happy_var_3 -> 
	( if null (snd $ unLoc happy_var_1)
                                     then return (sLL happy_var_1 happy_var_3 (mj AnnSemi happy_var_2:(fst $ unLoc happy_var_1)
                                                  ,[happy_var_3]))
                                     else (ams (head $ snd $ unLoc happy_var_1)
                                               (mj AnnSemi happy_var_2:(fst $ unLoc happy_var_1))
                                           >> return (sLL happy_var_1 happy_var_3 ([],happy_var_3 : (snd $ unLoc happy_var_1))) ))}}}
	) (\r -> happyReturn (happyIn199 r))

happyReduce_535 = happyMonadReduce 2# 185# happyReduction_535
happyReduction_535 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut199 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( if null (snd $ unLoc happy_var_1)
                                     then return (sLL happy_var_1 happy_var_2 (mj AnnSemi happy_var_2:(fst $ unLoc happy_var_1)
                                                  ,snd $ unLoc happy_var_1))
                                     else (ams (head $ snd $ unLoc happy_var_1)
                                               (mj AnnSemi happy_var_2:(fst $ unLoc happy_var_1))
                                           >> return (sLL happy_var_1 happy_var_2 ([],snd $ unLoc happy_var_1))))}}
	) (\r -> happyReturn (happyIn199 r))

happyReduce_536 = happySpecReduce_1  185# happyReduction_536
happyReduction_536 happy_x_1
	 =  case happyOut200 happy_x_1 of { happy_var_1 -> 
	happyIn199
		 (sL1 happy_var_1 ([],[happy_var_1])
	)}

happyReduce_537 = happyMonadReduce 3# 186# happyReduction_537
happyReduction_537 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut207 happy_x_1 of { happy_var_1 -> 
	case happyOut115 happy_x_2 of { happy_var_2 -> 
	case happyOut201 happy_x_3 of { happy_var_3 -> 
	(ams (sLL happy_var_1 happy_var_3 (Match { m_fixity = NonFunBindMatch
                                                        , m_pats = [happy_var_1]
                                                        , m_type = snd happy_var_2
                                                        , m_grhss = snd $ unLoc happy_var_3 }))
                                      (fst happy_var_2 ++ (fst $ unLoc happy_var_3)))}}}
	) (\r -> happyReturn (happyIn200 r))

happyReduce_538 = happySpecReduce_2  187# happyReduction_538
happyReduction_538 happy_x_2
	happy_x_1
	 =  case happyOut202 happy_x_1 of { happy_var_1 -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	happyIn201
		 (sLL happy_var_1 happy_var_2 (fst $ unLoc happy_var_2,
                                            GRHSs (unLoc happy_var_1) (snd $ unLoc happy_var_2))
	)}}

happyReduce_539 = happyMonadReduce 2# 188# happyReduction_539
happyReduction_539 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut169 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 (unguardedRHS (comb2 happy_var_1 happy_var_2) happy_var_2))
                                     [mu AnnRarrow happy_var_1])}}
	) (\r -> happyReturn (happyIn202 r))

happyReduce_540 = happySpecReduce_1  188# happyReduction_540
happyReduction_540 happy_x_1
	 =  case happyOut203 happy_x_1 of { happy_var_1 -> 
	happyIn202
		 (sL1 happy_var_1 (reverse (unLoc happy_var_1))
	)}

happyReduce_541 = happySpecReduce_2  189# happyReduction_541
happyReduction_541 happy_x_2
	happy_x_1
	 =  case happyOut203 happy_x_1 of { happy_var_1 -> 
	case happyOut206 happy_x_2 of { happy_var_2 -> 
	happyIn203
		 (sLL happy_var_1 happy_var_2 (happy_var_2 : unLoc happy_var_1)
	)}}

happyReduce_542 = happySpecReduce_1  189# happyReduction_542
happyReduction_542 happy_x_1
	 =  case happyOut206 happy_x_1 of { happy_var_1 -> 
	happyIn203
		 (sL1 happy_var_1 [happy_var_1]
	)}

happyReduce_543 = happyMonadReduce 3# 190# happyReduction_543
happyReduction_543 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut204 happy_x_1 of { happy_var_1 -> 
	case happyOut206 happy_x_2 of { happy_var_2 -> 
	case happyOut172 happy_x_3 of { happy_var_3 -> 
	( ams (sL (comb2 happy_var_1 happy_var_2) (happy_var_2 : unLoc happy_var_1))
                                           (map (\l -> mj AnnSemi l) $ fst happy_var_3))}}}
	) (\r -> happyReturn (happyIn204 r))

happyReduce_544 = happyMonadReduce 2# 190# happyReduction_544
happyReduction_544 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut206 happy_x_1 of { happy_var_1 -> 
	case happyOut172 happy_x_2 of { happy_var_2 -> 
	( ams (sL1 happy_var_1 [happy_var_1])
                                           (map (\l -> mj AnnSemi l) $ fst happy_var_2))}}
	) (\r -> happyReturn (happyIn204 r))

happyReduce_545 = happySpecReduce_3  191# happyReduction_545
happyReduction_545 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut204 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn205
		 (sLL happy_var_1 happy_var_3 ([moc happy_var_1,mcc happy_var_3],unLoc happy_var_2)
	)}}}

happyReduce_546 = happySpecReduce_2  191# happyReduction_546
happyReduction_546 happy_x_2
	happy_x_1
	 =  case happyOut204 happy_x_1 of { happy_var_1 -> 
	happyIn205
		 (sL1 happy_var_1 ([],unLoc happy_var_1)
	)}

happyReduce_547 = happyMonadReduce 4# 192# happyReduction_547
happyReduction_547 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut195 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOut169 happy_x_4 of { happy_var_4 -> 
	( ams (sL (comb2 happy_var_1 happy_var_4) $ GRHS (unLoc happy_var_2) happy_var_4)
                                         [mj AnnVbar happy_var_1,mu AnnRarrow happy_var_3])}}}}
	) (\r -> happyReturn (happyIn206 r))

happyReduce_548 = happyMonadReduce 1# 193# happyReduction_548
happyReduction_548 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut169 happy_x_1 of { happy_var_1 -> 
	( checkPattern empty happy_var_1)}
	) (\r -> happyReturn (happyIn207 r))

happyReduce_549 = happyMonadReduce 2# 193# happyReduction_549
happyReduction_549 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut176 happy_x_2 of { happy_var_2 -> 
	( amms (checkPattern empty (sLL happy_var_1 happy_var_2 (SectionR
                                                     (sL1 happy_var_1 (HsVar (sL1 happy_var_1 bang_RDR))) happy_var_2)))
                                [mj AnnBang happy_var_1])}}
	) (\r -> happyReturn (happyIn207 r))

happyReduce_550 = happyMonadReduce 1# 194# happyReduction_550
happyReduction_550 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut169 happy_x_1 of { happy_var_1 -> 
	( checkPattern
                                (text "Possibly caused by a missing 'do'?") happy_var_1)}
	) (\r -> happyReturn (happyIn208 r))

happyReduce_551 = happyMonadReduce 2# 194# happyReduction_551
happyReduction_551 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut176 happy_x_2 of { happy_var_2 -> 
	( amms (checkPattern
                                     (text "Possibly caused by a missing 'do'?")
                                     (sLL happy_var_1 happy_var_2 (SectionR (sL1 happy_var_1 (HsVar (sL1 happy_var_1 bang_RDR))) happy_var_2)))
                                  [mj AnnBang happy_var_1])}}
	) (\r -> happyReturn (happyIn208 r))

happyReduce_552 = happyMonadReduce 1# 195# happyReduction_552
happyReduction_552 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut176 happy_x_1 of { happy_var_1 -> 
	( checkPattern empty happy_var_1)}
	) (\r -> happyReturn (happyIn209 r))

happyReduce_553 = happyMonadReduce 2# 195# happyReduction_553
happyReduction_553 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut176 happy_x_2 of { happy_var_2 -> 
	( amms (checkPattern empty
                                            (sLL happy_var_1 happy_var_2 (SectionR
                                                (sL1 happy_var_1 (HsVar (sL1 happy_var_1 bang_RDR))) happy_var_2)))
                                        [mj AnnBang happy_var_1])}}
	) (\r -> happyReturn (happyIn209 r))

happyReduce_554 = happySpecReduce_2  196# happyReduction_554
happyReduction_554 happy_x_2
	happy_x_1
	 =  case happyOut209 happy_x_1 of { happy_var_1 -> 
	case happyOut210 happy_x_2 of { happy_var_2 -> 
	happyIn210
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_555 = happySpecReduce_0  196# happyReduction_555
happyReduction_555  =  happyIn210
		 ([]
	)

happyReduce_556 = happySpecReduce_3  197# happyReduction_556
happyReduction_556 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut212 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	happyIn211
		 (sLL happy_var_1 happy_var_3 ((moc happy_var_1:mcc happy_var_3:(fst $ unLoc happy_var_2))
                                             ,(reverse $ snd $ unLoc happy_var_2))
	)}}}

happyReduce_557 = happySpecReduce_3  197# happyReduction_557
happyReduction_557 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut212 happy_x_2 of { happy_var_2 -> 
	happyIn211
		 (L (gl happy_var_2) (fst $ unLoc happy_var_2
                                                    ,reverse $ snd $ unLoc happy_var_2)
	)}

happyReduce_558 = happyMonadReduce 3# 198# happyReduction_558
happyReduction_558 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut212 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut214 happy_x_3 of { happy_var_3 -> 
	( if null (snd $ unLoc happy_var_1)
                              then return (sLL happy_var_1 happy_var_3 (mj AnnSemi happy_var_2:(fst $ unLoc happy_var_1)
                                                     ,happy_var_3 : (snd $ unLoc happy_var_1)))
                              else do
                               { ams (head $ snd $ unLoc happy_var_1) [mj AnnSemi happy_var_2]
                               ; return $ sLL happy_var_1 happy_var_3 (fst $ unLoc happy_var_1,happy_var_3 :(snd $ unLoc happy_var_1)) })}}}
	) (\r -> happyReturn (happyIn212 r))

happyReduce_559 = happyMonadReduce 2# 198# happyReduction_559
happyReduction_559 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut212 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( if null (snd $ unLoc happy_var_1)
                             then return (sLL happy_var_1 happy_var_2 (mj AnnSemi happy_var_2:(fst $ unLoc happy_var_1),snd $ unLoc happy_var_1))
                             else do
                               { ams (head $ snd $ unLoc happy_var_1)
                                               [mj AnnSemi happy_var_2]
                               ; return happy_var_1 })}}
	) (\r -> happyReturn (happyIn212 r))

happyReduce_560 = happySpecReduce_1  198# happyReduction_560
happyReduction_560 happy_x_1
	 =  case happyOut214 happy_x_1 of { happy_var_1 -> 
	happyIn212
		 (sL1 happy_var_1 ([],[happy_var_1])
	)}

happyReduce_561 = happySpecReduce_0  198# happyReduction_561
happyReduction_561  =  happyIn212
		 (noLoc ([],[])
	)

happyReduce_562 = happySpecReduce_1  199# happyReduction_562
happyReduction_562 happy_x_1
	 =  case happyOut214 happy_x_1 of { happy_var_1 -> 
	happyIn213
		 (Just happy_var_1
	)}

happyReduce_563 = happySpecReduce_0  199# happyReduction_563
happyReduction_563  =  happyIn213
		 (Nothing
	)

happyReduce_564 = happySpecReduce_1  200# happyReduction_564
happyReduction_564 happy_x_1
	 =  case happyOut215 happy_x_1 of { happy_var_1 -> 
	happyIn214
		 (happy_var_1
	)}

happyReduce_565 = happyMonadReduce 2# 200# happyReduction_565
happyReduction_565 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut211 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ mkRecStmt (snd $ unLoc happy_var_2))
                                               (mj AnnRec happy_var_1:(fst $ unLoc happy_var_2)))}}
	) (\r -> happyReturn (happyIn214 r))

happyReduce_566 = happyMonadReduce 3# 201# happyReduction_566
happyReduction_566 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut208 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut169 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ mkBindStmt happy_var_1 happy_var_3)
                                               [mu AnnLarrow happy_var_2])}}}
	) (\r -> happyReturn (happyIn215 r))

happyReduce_567 = happySpecReduce_1  201# happyReduction_567
happyReduction_567 happy_x_1
	 =  case happyOut169 happy_x_1 of { happy_var_1 -> 
	happyIn215
		 (sL1 happy_var_1 $ mkBodyStmt happy_var_1
	)}

happyReduce_568 = happyMonadReduce 2# 201# happyReduction_568
happyReduction_568 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut94 happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2$ LetStmt (snd $ unLoc happy_var_2))
                                               (mj AnnLet happy_var_1:(fst $ unLoc happy_var_2)))}}
	) (\r -> happyReturn (happyIn215 r))

happyReduce_569 = happySpecReduce_1  202# happyReduction_569
happyReduction_569 happy_x_1
	 =  case happyOut217 happy_x_1 of { happy_var_1 -> 
	happyIn216
		 (happy_var_1
	)}

happyReduce_570 = happySpecReduce_0  202# happyReduction_570
happyReduction_570  =  happyIn216
		 (([],([], False))
	)

happyReduce_571 = happyMonadReduce 3# 203# happyReduction_571
happyReduction_571 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut218 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut217 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl happy_var_1) AnnComma (gl happy_var_2) >>
                   return (case happy_var_3 of (ma,(flds, dd)) -> (ma,(happy_var_1 : flds, dd))))}}}
	) (\r -> happyReturn (happyIn217 r))

happyReduce_572 = happySpecReduce_1  203# happyReduction_572
happyReduction_572 happy_x_1
	 =  case happyOut218 happy_x_1 of { happy_var_1 -> 
	happyIn217
		 (([],([happy_var_1], False))
	)}

happyReduce_573 = happySpecReduce_1  203# happyReduction_573
happyReduction_573 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn217
		 (([mj AnnDotdot happy_var_1],([],   True))
	)}

happyReduce_574 = happyMonadReduce 3# 204# happyReduction_574
happyReduction_574 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut257 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut184 happy_x_3 of { happy_var_3 -> 
	( ams  (sLL happy_var_1 happy_var_3 $ HsRecField (sL1 happy_var_1 $ mkFieldOcc happy_var_1) happy_var_3 False)
                                [mj AnnEqual happy_var_2])}}}
	) (\r -> happyReturn (happyIn218 r))

happyReduce_575 = happySpecReduce_1  204# happyReduction_575
happyReduction_575 happy_x_1
	 =  case happyOut257 happy_x_1 of { happy_var_1 -> 
	happyIn218
		 (sLL happy_var_1 happy_var_1 $ HsRecField (sL1 happy_var_1 $ mkFieldOcc happy_var_1) placeHolderPunRhs True
	)}

happyReduce_576 = happyMonadReduce 3# 205# happyReduction_576
happyReduction_576 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut219 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut220 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl $ last $ unLoc happy_var_1) AnnSemi (gl happy_var_2) >>
                         return (let { this = happy_var_3; rest = unLoc happy_var_1 }
                              in rest `seq` this `seq` sLL happy_var_1 happy_var_3 (this : rest)))}}}
	) (\r -> happyReturn (happyIn219 r))

happyReduce_577 = happyMonadReduce 2# 205# happyReduction_577
happyReduction_577 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut219 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( addAnnotation (gl $ last $ unLoc happy_var_1) AnnSemi (gl happy_var_2) >>
                         return (sLL happy_var_1 happy_var_2 (unLoc happy_var_1)))}}
	) (\r -> happyReturn (happyIn219 r))

happyReduce_578 = happySpecReduce_1  205# happyReduction_578
happyReduction_578 happy_x_1
	 =  case happyOut220 happy_x_1 of { happy_var_1 -> 
	happyIn219
		 (let this = happy_var_1 in this `seq` sL1 happy_var_1 [this]
	)}

happyReduce_579 = happyMonadReduce 3# 206# happyReduction_579
happyReduction_579 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut221 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut169 happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (IPBind (Left happy_var_1) happy_var_3))
                                              [mj AnnEqual happy_var_2])}}}
	) (\r -> happyReturn (happyIn220 r))

happyReduce_580 = happySpecReduce_1  207# happyReduction_580
happyReduction_580 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn221
		 (sL1 happy_var_1 (HsIPName (getIPDUPVARID happy_var_1))
	)}

happyReduce_581 = happySpecReduce_1  208# happyReduction_581
happyReduction_581 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn222
		 (sL1 happy_var_1 (getLABELVARID happy_var_1)
	)}

happyReduce_582 = happySpecReduce_1  209# happyReduction_582
happyReduction_582 happy_x_1
	 =  case happyOut224 happy_x_1 of { happy_var_1 -> 
	happyIn223
		 (happy_var_1
	)}

happyReduce_583 = happySpecReduce_0  209# happyReduction_583
happyReduction_583  =  happyIn223
		 (noLoc mkTrue
	)

happyReduce_584 = happySpecReduce_1  210# happyReduction_584
happyReduction_584 happy_x_1
	 =  case happyOut225 happy_x_1 of { happy_var_1 -> 
	happyIn224
		 (happy_var_1
	)}

happyReduce_585 = happyMonadReduce 3# 210# happyReduction_585
happyReduction_585 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut225 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut224 happy_x_3 of { happy_var_3 -> 
	( aa happy_var_1 (AnnVbar, happy_var_2)
                              >> return (sLL happy_var_1 happy_var_3 (Or [happy_var_1,happy_var_3])))}}}
	) (\r -> happyReturn (happyIn224 r))

happyReduce_586 = happySpecReduce_1  211# happyReduction_586
happyReduction_586 happy_x_1
	 =  case happyOut226 happy_x_1 of { happy_var_1 -> 
	happyIn225
		 (happy_var_1
	)}

happyReduce_587 = happyMonadReduce 3# 211# happyReduction_587
happyReduction_587 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut226 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut225 happy_x_3 of { happy_var_3 -> 
	( aa happy_var_1 (AnnComma,happy_var_2) >> return (sLL happy_var_1 happy_var_3 (And [happy_var_1,happy_var_3])))}}}
	) (\r -> happyReturn (happyIn225 r))

happyReduce_588 = happyMonadReduce 3# 212# happyReduction_588
happyReduction_588 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut224 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (Parens happy_var_2)) [mop happy_var_1,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn226 r))

happyReduce_589 = happySpecReduce_1  212# happyReduction_589
happyReduction_589 happy_x_1
	 =  case happyOut228 happy_x_1 of { happy_var_1 -> 
	happyIn226
		 (sL1 happy_var_1 (Var happy_var_1)
	)}

happyReduce_590 = happySpecReduce_1  213# happyReduction_590
happyReduction_590 happy_x_1
	 =  case happyOut228 happy_x_1 of { happy_var_1 -> 
	happyIn227
		 (sL1 happy_var_1 [happy_var_1]
	)}

happyReduce_591 = happyMonadReduce 3# 213# happyReduction_591
happyReduction_591 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut228 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut227 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl happy_var_1) AnnComma (gl happy_var_2) >>
                                    return (sLL happy_var_1 happy_var_3 (happy_var_1 : unLoc happy_var_3)))}}}
	) (\r -> happyReturn (happyIn227 r))

happyReduce_592 = happySpecReduce_1  214# happyReduction_592
happyReduction_592 happy_x_1
	 =  case happyOut256 happy_x_1 of { happy_var_1 -> 
	happyIn228
		 (happy_var_1
	)}

happyReduce_593 = happySpecReduce_1  214# happyReduction_593
happyReduction_593 happy_x_1
	 =  case happyOut232 happy_x_1 of { happy_var_1 -> 
	happyIn228
		 (happy_var_1
	)}

happyReduce_594 = happySpecReduce_1  215# happyReduction_594
happyReduction_594 happy_x_1
	 =  case happyOut231 happy_x_1 of { happy_var_1 -> 
	happyIn229
		 (happy_var_1
	)}

happyReduce_595 = happySpecReduce_1  215# happyReduction_595
happyReduction_595 happy_x_1
	 =  case happyOut234 happy_x_1 of { happy_var_1 -> 
	happyIn229
		 (sL1 happy_var_1 $ nameRdrName (dataConName (unLoc happy_var_1))
	)}

happyReduce_596 = happySpecReduce_1  216# happyReduction_596
happyReduction_596 happy_x_1
	 =  case happyOut231 happy_x_1 of { happy_var_1 -> 
	happyIn230
		 (happy_var_1
	)}

happyReduce_597 = happySpecReduce_1  216# happyReduction_597
happyReduction_597 happy_x_1
	 =  case happyOut235 happy_x_1 of { happy_var_1 -> 
	happyIn230
		 (sL1 happy_var_1 $ nameRdrName (dataConName (unLoc happy_var_1))
	)}

happyReduce_598 = happySpecReduce_1  217# happyReduction_598
happyReduction_598 happy_x_1
	 =  case happyOut267 happy_x_1 of { happy_var_1 -> 
	happyIn231
		 (happy_var_1
	)}

happyReduce_599 = happyMonadReduce 3# 217# happyReduction_599
happyReduction_599 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut269 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (unLoc happy_var_2))
                                   [mop happy_var_1,mj AnnVal happy_var_2,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn231 r))

happyReduce_600 = happySpecReduce_1  218# happyReduction_600
happyReduction_600 happy_x_1
	 =  case happyOut268 happy_x_1 of { happy_var_1 -> 
	happyIn232
		 (happy_var_1
	)}

happyReduce_601 = happyMonadReduce 3# 218# happyReduction_601
happyReduction_601 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut270 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (unLoc happy_var_2))
                                       [mop happy_var_1,mj AnnVal happy_var_2,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn232 r))

happyReduce_602 = happySpecReduce_1  218# happyReduction_602
happyReduction_602 happy_x_1
	 =  case happyOut235 happy_x_1 of { happy_var_1 -> 
	happyIn232
		 (sL1 happy_var_1 $ nameRdrName (dataConName (unLoc happy_var_1))
	)}

happyReduce_603 = happySpecReduce_1  219# happyReduction_603
happyReduction_603 happy_x_1
	 =  case happyOut232 happy_x_1 of { happy_var_1 -> 
	happyIn233
		 (sL1 happy_var_1 [happy_var_1]
	)}

happyReduce_604 = happyMonadReduce 3# 219# happyReduction_604
happyReduction_604 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut232 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut233 happy_x_3 of { happy_var_3 -> 
	( addAnnotation (gl happy_var_1) AnnComma (gl happy_var_2) >>
                                   return (sLL happy_var_1 happy_var_3 (happy_var_1 : unLoc happy_var_3)))}}}
	) (\r -> happyReturn (happyIn233 r))

happyReduce_605 = happyMonadReduce 2# 220# happyReduction_605
happyReduction_605 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 unitDataCon) [mop happy_var_1,mcp happy_var_2])}}
	) (\r -> happyReturn (happyIn234 r))

happyReduce_606 = happyMonadReduce 3# 220# happyReduction_606
happyReduction_606 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut274 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ tupleDataCon Boxed (snd happy_var_2 + 1))
                                       (mop happy_var_1:mcp happy_var_3:(mcommas (fst happy_var_2))))}}}
	) (\r -> happyReturn (happyIn234 r))

happyReduce_607 = happyMonadReduce 2# 220# happyReduction_607
happyReduction_607 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ unboxedUnitDataCon) [mo happy_var_1,mc happy_var_2])}}
	) (\r -> happyReturn (happyIn234 r))

happyReduce_608 = happyMonadReduce 3# 220# happyReduction_608
happyReduction_608 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut274 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ tupleDataCon Unboxed (snd happy_var_2 + 1))
                                       (mo happy_var_1:mc happy_var_3:(mcommas (fst happy_var_2))))}}}
	) (\r -> happyReturn (happyIn234 r))

happyReduce_609 = happySpecReduce_1  221# happyReduction_609
happyReduction_609 happy_x_1
	 =  case happyOut234 happy_x_1 of { happy_var_1 -> 
	happyIn235
		 (happy_var_1
	)}

happyReduce_610 = happyMonadReduce 2# 221# happyReduction_610
happyReduction_610 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 nilDataCon) [mos happy_var_1,mcs happy_var_2])}}
	) (\r -> happyReturn (happyIn235 r))

happyReduce_611 = happySpecReduce_1  222# happyReduction_611
happyReduction_611 happy_x_1
	 =  case happyOut270 happy_x_1 of { happy_var_1 -> 
	happyIn236
		 (happy_var_1
	)}

happyReduce_612 = happyMonadReduce 3# 222# happyReduction_612
happyReduction_612 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut268 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (unLoc happy_var_2))
                                       [mj AnnBackquote happy_var_1,mj AnnVal happy_var_2
                                       ,mj AnnBackquote happy_var_3])}}}
	) (\r -> happyReturn (happyIn236 r))

happyReduce_613 = happySpecReduce_1  223# happyReduction_613
happyReduction_613 happy_x_1
	 =  case happyOut269 happy_x_1 of { happy_var_1 -> 
	happyIn237
		 (happy_var_1
	)}

happyReduce_614 = happyMonadReduce 3# 223# happyReduction_614
happyReduction_614 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut267 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (unLoc happy_var_2))
                                       [mj AnnBackquote happy_var_1,mj AnnVal happy_var_2
                                       ,mj AnnBackquote happy_var_3])}}}
	) (\r -> happyReturn (happyIn237 r))

happyReduce_615 = happySpecReduce_1  224# happyReduction_615
happyReduction_615 happy_x_1
	 =  case happyOut239 happy_x_1 of { happy_var_1 -> 
	happyIn238
		 (happy_var_1
	)}

happyReduce_616 = happyMonadReduce 2# 224# happyReduction_616
happyReduction_616 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ getRdrName unitTyCon)
                                              [mop happy_var_1,mcp happy_var_2])}}
	) (\r -> happyReturn (happyIn238 r))

happyReduce_617 = happyMonadReduce 2# 224# happyReduction_617
happyReduction_617 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ getRdrName unboxedUnitTyCon)
                                              [mo happy_var_1,mc happy_var_2])}}
	) (\r -> happyReturn (happyIn238 r))

happyReduce_618 = happySpecReduce_1  225# happyReduction_618
happyReduction_618 happy_x_1
	 =  case happyOut240 happy_x_1 of { happy_var_1 -> 
	happyIn239
		 (happy_var_1
	)}

happyReduce_619 = happyMonadReduce 3# 225# happyReduction_619
happyReduction_619 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut274 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ getRdrName (tupleTyCon Boxed
                                                        (snd happy_var_2 + 1)))
                                       (mop happy_var_1:mcp happy_var_3:(mcommas (fst happy_var_2))))}}}
	) (\r -> happyReturn (happyIn239 r))

happyReduce_620 = happyMonadReduce 3# 225# happyReduction_620
happyReduction_620 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut274 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ getRdrName (tupleTyCon Unboxed
                                                        (snd happy_var_2 + 1)))
                                       (mo happy_var_1:mc happy_var_3:(mcommas (fst happy_var_2))))}}}
	) (\r -> happyReturn (happyIn239 r))

happyReduce_621 = happyMonadReduce 3# 225# happyReduction_621
happyReduction_621 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ getRdrName funTyCon)
                                       [mop happy_var_1,mu AnnRarrow happy_var_2,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn239 r))

happyReduce_622 = happyMonadReduce 2# 225# happyReduction_622
happyReduction_622 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ listTyCon_RDR) [mos happy_var_1,mcs happy_var_2])}}
	) (\r -> happyReturn (happyIn239 r))

happyReduce_623 = happyMonadReduce 2# 225# happyReduction_623
happyReduction_623 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	( ams (sLL happy_var_1 happy_var_2 $ parrTyCon_RDR) [mo happy_var_1,mc happy_var_2])}}
	) (\r -> happyReturn (happyIn239 r))

happyReduce_624 = happyMonadReduce 3# 225# happyReduction_624
happyReduction_624 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ getRdrName eqPrimTyCon)
                                        [mop happy_var_1,mj AnnTildehsh happy_var_2,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn239 r))

happyReduce_625 = happySpecReduce_1  226# happyReduction_625
happyReduction_625 happy_x_1
	 =  case happyOut243 happy_x_1 of { happy_var_1 -> 
	happyIn240
		 (happy_var_1
	)}

happyReduce_626 = happyMonadReduce 3# 226# happyReduction_626
happyReduction_626 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut245 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (unLoc happy_var_2))
                                               [mop happy_var_1,mj AnnVal happy_var_2,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn240 r))

happyReduce_627 = happyMonadReduce 3# 226# happyReduction_627
happyReduction_627 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ eqTyCon_RDR)
                                               [mop happy_var_1,mj AnnVal happy_var_2,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn240 r))

happyReduce_628 = happySpecReduce_1  227# happyReduction_628
happyReduction_628 happy_x_1
	 =  case happyOut243 happy_x_1 of { happy_var_1 -> 
	happyIn241
		 (happy_var_1
	)}

happyReduce_629 = happyMonadReduce 3# 227# happyReduction_629
happyReduction_629 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( let name = sL1 happy_var_2 $! mkQual tcClsName (getQCONSYM happy_var_2)
                                in ams (sLL happy_var_1 happy_var_3 (unLoc name)) [mop happy_var_1,mj AnnVal name,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn241 r))

happyReduce_630 = happyMonadReduce 3# 227# happyReduction_630
happyReduction_630 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( let name = sL1 happy_var_2 $! mkUnqual tcClsName (getCONSYM happy_var_2)
                                in ams (sLL happy_var_1 happy_var_3 (unLoc name)) [mop happy_var_1,mj AnnVal name,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn241 r))

happyReduce_631 = happyMonadReduce 3# 227# happyReduction_631
happyReduction_631 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( let name = sL1 happy_var_2 $! consDataCon_RDR
                                in ams (sLL happy_var_1 happy_var_3 (unLoc name)) [mop happy_var_1,mj AnnVal name,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn241 r))

happyReduce_632 = happyMonadReduce 3# 227# happyReduction_632
happyReduction_632 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 $ eqTyCon_RDR) [mop happy_var_1,mj AnnTilde happy_var_2,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn241 r))

happyReduce_633 = happySpecReduce_1  228# happyReduction_633
happyReduction_633 happy_x_1
	 =  case happyOut245 happy_x_1 of { happy_var_1 -> 
	happyIn242
		 (happy_var_1
	)}

happyReduce_634 = happyMonadReduce 3# 228# happyReduction_634
happyReduction_634 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut243 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (unLoc happy_var_2))
                                               [mj AnnBackquote happy_var_1,mj AnnVal happy_var_2
                                               ,mj AnnBackquote happy_var_3])}}}
	) (\r -> happyReturn (happyIn242 r))

happyReduce_635 = happySpecReduce_1  229# happyReduction_635
happyReduction_635 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn243
		 (sL1 happy_var_1 $! mkQual tcClsName (getQCONID happy_var_1)
	)}

happyReduce_636 = happySpecReduce_1  229# happyReduction_636
happyReduction_636 happy_x_1
	 =  case happyOut244 happy_x_1 of { happy_var_1 -> 
	happyIn243
		 (happy_var_1
	)}

happyReduce_637 = happySpecReduce_1  230# happyReduction_637
happyReduction_637 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn244
		 (sL1 happy_var_1 $! mkUnqual tcClsName (getCONID happy_var_1)
	)}

happyReduce_638 = happySpecReduce_1  231# happyReduction_638
happyReduction_638 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn245
		 (sL1 happy_var_1 $! mkQual tcClsName (getQCONSYM happy_var_1)
	)}

happyReduce_639 = happySpecReduce_1  231# happyReduction_639
happyReduction_639 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn245
		 (sL1 happy_var_1 $! mkQual tcClsName (getQVARSYM happy_var_1)
	)}

happyReduce_640 = happySpecReduce_1  231# happyReduction_640
happyReduction_640 happy_x_1
	 =  case happyOut246 happy_x_1 of { happy_var_1 -> 
	happyIn245
		 (happy_var_1
	)}

happyReduce_641 = happySpecReduce_1  232# happyReduction_641
happyReduction_641 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn246
		 (sL1 happy_var_1 $! mkUnqual tcClsName (getCONSYM happy_var_1)
	)}

happyReduce_642 = happySpecReduce_1  232# happyReduction_642
happyReduction_642 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn246
		 (sL1 happy_var_1 $! mkUnqual tcClsName (getVARSYM happy_var_1)
	)}

happyReduce_643 = happySpecReduce_1  232# happyReduction_643
happyReduction_643 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn246
		 (sL1 happy_var_1 $! consDataCon_RDR
	)}

happyReduce_644 = happySpecReduce_1  232# happyReduction_644
happyReduction_644 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn246
		 (sL1 happy_var_1 $! mkUnqual tcClsName (fsLit "-")
	)}

happyReduce_645 = happySpecReduce_1  233# happyReduction_645
happyReduction_645 happy_x_1
	 =  case happyOut248 happy_x_1 of { happy_var_1 -> 
	happyIn247
		 (happy_var_1
	)}

happyReduce_646 = happySpecReduce_1  233# happyReduction_646
happyReduction_646 happy_x_1
	 =  case happyOut236 happy_x_1 of { happy_var_1 -> 
	happyIn247
		 (happy_var_1
	)}

happyReduce_647 = happySpecReduce_1  234# happyReduction_647
happyReduction_647 happy_x_1
	 =  case happyOut263 happy_x_1 of { happy_var_1 -> 
	happyIn248
		 (happy_var_1
	)}

happyReduce_648 = happyMonadReduce 3# 234# happyReduction_648
happyReduction_648 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut259 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (unLoc happy_var_2))
                                       [mj AnnBackquote happy_var_1,mj AnnVal happy_var_2
                                       ,mj AnnBackquote happy_var_3])}}}
	) (\r -> happyReturn (happyIn248 r))

happyReduce_649 = happySpecReduce_1  235# happyReduction_649
happyReduction_649 happy_x_1
	 =  case happyOut251 happy_x_1 of { happy_var_1 -> 
	happyIn249
		 (sL1 happy_var_1 $ HsVar happy_var_1
	)}

happyReduce_650 = happySpecReduce_1  235# happyReduction_650
happyReduction_650 happy_x_1
	 =  case happyOut237 happy_x_1 of { happy_var_1 -> 
	happyIn249
		 (sL1 happy_var_1 $ HsVar happy_var_1
	)}

happyReduce_651 = happySpecReduce_1  236# happyReduction_651
happyReduction_651 happy_x_1
	 =  case happyOut252 happy_x_1 of { happy_var_1 -> 
	happyIn250
		 (sL1 happy_var_1 $ HsVar happy_var_1
	)}

happyReduce_652 = happySpecReduce_1  236# happyReduction_652
happyReduction_652 happy_x_1
	 =  case happyOut237 happy_x_1 of { happy_var_1 -> 
	happyIn250
		 (sL1 happy_var_1 $ HsVar happy_var_1
	)}

happyReduce_653 = happySpecReduce_1  237# happyReduction_653
happyReduction_653 happy_x_1
	 =  case happyOut260 happy_x_1 of { happy_var_1 -> 
	happyIn251
		 (happy_var_1
	)}

happyReduce_654 = happyMonadReduce 3# 237# happyReduction_654
happyReduction_654 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut258 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (unLoc happy_var_2))
                                       [mj AnnBackquote happy_var_1,mj AnnVal happy_var_2
                                       ,mj AnnBackquote happy_var_3])}}}
	) (\r -> happyReturn (happyIn251 r))

happyReduce_655 = happySpecReduce_1  238# happyReduction_655
happyReduction_655 happy_x_1
	 =  case happyOut261 happy_x_1 of { happy_var_1 -> 
	happyIn252
		 (happy_var_1
	)}

happyReduce_656 = happyMonadReduce 3# 238# happyReduction_656
happyReduction_656 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut258 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (unLoc happy_var_2))
                                       [mj AnnBackquote happy_var_1,mj AnnVal happy_var_2
                                       ,mj AnnBackquote happy_var_3])}}}
	) (\r -> happyReturn (happyIn252 r))

happyReduce_657 = happySpecReduce_1  239# happyReduction_657
happyReduction_657 happy_x_1
	 =  case happyOut255 happy_x_1 of { happy_var_1 -> 
	happyIn253
		 (happy_var_1
	)}

happyReduce_658 = happyMonadReduce 3# 240# happyReduction_658
happyReduction_658 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut255 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (unLoc happy_var_2))
                                       [mj AnnBackquote happy_var_1,mj AnnVal happy_var_2
                                       ,mj AnnBackquote happy_var_3])}}}
	) (\r -> happyReturn (happyIn254 r))

happyReduce_659 = happyMonadReduce 1# 240# happyReduction_659
happyReduction_659 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	( parseErrorSDoc (getLoc happy_var_1)
                                      (vcat [text "Illegal symbol '.' in type",
                                             text "Perhaps you intended to use RankNTypes or a similar language",
                                             text "extension to enable explicit-forall syntax: forall <tvs>. <type>"]))}
	) (\r -> happyReturn (happyIn254 r))

happyReduce_660 = happySpecReduce_1  241# happyReduction_660
happyReduction_660 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn255
		 (sL1 happy_var_1 $! mkUnqual tvName (getVARID happy_var_1)
	)}

happyReduce_661 = happySpecReduce_1  241# happyReduction_661
happyReduction_661 happy_x_1
	 =  case happyOut265 happy_x_1 of { happy_var_1 -> 
	happyIn255
		 (sL1 happy_var_1 $! mkUnqual tvName (unLoc happy_var_1)
	)}

happyReduce_662 = happySpecReduce_1  241# happyReduction_662
happyReduction_662 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn255
		 (sL1 happy_var_1 $! mkUnqual tvName (fsLit "unsafe")
	)}

happyReduce_663 = happySpecReduce_1  241# happyReduction_663
happyReduction_663 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn255
		 (sL1 happy_var_1 $! mkUnqual tvName (fsLit "safe")
	)}

happyReduce_664 = happySpecReduce_1  241# happyReduction_664
happyReduction_664 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn255
		 (sL1 happy_var_1 $! mkUnqual tvName (fsLit "interruptible")
	)}

happyReduce_665 = happySpecReduce_1  242# happyReduction_665
happyReduction_665 happy_x_1
	 =  case happyOut259 happy_x_1 of { happy_var_1 -> 
	happyIn256
		 (happy_var_1
	)}

happyReduce_666 = happyMonadReduce 3# 242# happyReduction_666
happyReduction_666 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut263 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (unLoc happy_var_2))
                                       [mop happy_var_1,mj AnnVal happy_var_2,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn256 r))

happyReduce_667 = happySpecReduce_1  243# happyReduction_667
happyReduction_667 happy_x_1
	 =  case happyOut258 happy_x_1 of { happy_var_1 -> 
	happyIn257
		 (happy_var_1
	)}

happyReduce_668 = happyMonadReduce 3# 243# happyReduction_668
happyReduction_668 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut263 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (unLoc happy_var_2))
                                       [mop happy_var_1,mj AnnVal happy_var_2,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn257 r))

happyReduce_669 = happyMonadReduce 3# 243# happyReduction_669
happyReduction_669 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut262 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	( ams (sLL happy_var_1 happy_var_3 (unLoc happy_var_2))
                                       [mop happy_var_1,mj AnnVal happy_var_2,mcp happy_var_3])}}}
	) (\r -> happyReturn (happyIn257 r))

happyReduce_670 = happySpecReduce_1  244# happyReduction_670
happyReduction_670 happy_x_1
	 =  case happyOut259 happy_x_1 of { happy_var_1 -> 
	happyIn258
		 (happy_var_1
	)}

happyReduce_671 = happySpecReduce_1  244# happyReduction_671
happyReduction_671 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn258
		 (sL1 happy_var_1 $! mkQual varName (getQVARID happy_var_1)
	)}

happyReduce_672 = happySpecReduce_1  245# happyReduction_672
happyReduction_672 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn259
		 (sL1 happy_var_1 $! mkUnqual varName (getVARID happy_var_1)
	)}

happyReduce_673 = happySpecReduce_1  245# happyReduction_673
happyReduction_673 happy_x_1
	 =  case happyOut265 happy_x_1 of { happy_var_1 -> 
	happyIn259
		 (sL1 happy_var_1 $! mkUnqual varName (unLoc happy_var_1)
	)}

happyReduce_674 = happySpecReduce_1  245# happyReduction_674
happyReduction_674 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn259
		 (sL1 happy_var_1 $! mkUnqual varName (fsLit "unsafe")
	)}

happyReduce_675 = happySpecReduce_1  245# happyReduction_675
happyReduction_675 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn259
		 (sL1 happy_var_1 $! mkUnqual varName (fsLit "safe")
	)}

happyReduce_676 = happySpecReduce_1  245# happyReduction_676
happyReduction_676 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn259
		 (sL1 happy_var_1 $! mkUnqual varName (fsLit "interruptible")
	)}

happyReduce_677 = happySpecReduce_1  245# happyReduction_677
happyReduction_677 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn259
		 (sL1 happy_var_1 $! mkUnqual varName (fsLit "forall")
	)}

happyReduce_678 = happySpecReduce_1  245# happyReduction_678
happyReduction_678 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn259
		 (sL1 happy_var_1 $! mkUnqual varName (fsLit "family")
	)}

happyReduce_679 = happySpecReduce_1  245# happyReduction_679
happyReduction_679 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn259
		 (sL1 happy_var_1 $! mkUnqual varName (fsLit "role")
	)}

happyReduce_680 = happySpecReduce_1  246# happyReduction_680
happyReduction_680 happy_x_1
	 =  case happyOut263 happy_x_1 of { happy_var_1 -> 
	happyIn260
		 (happy_var_1
	)}

happyReduce_681 = happySpecReduce_1  246# happyReduction_681
happyReduction_681 happy_x_1
	 =  case happyOut262 happy_x_1 of { happy_var_1 -> 
	happyIn260
		 (happy_var_1
	)}

happyReduce_682 = happySpecReduce_1  247# happyReduction_682
happyReduction_682 happy_x_1
	 =  case happyOut264 happy_x_1 of { happy_var_1 -> 
	happyIn261
		 (happy_var_1
	)}

happyReduce_683 = happySpecReduce_1  247# happyReduction_683
happyReduction_683 happy_x_1
	 =  case happyOut262 happy_x_1 of { happy_var_1 -> 
	happyIn261
		 (happy_var_1
	)}

happyReduce_684 = happySpecReduce_1  248# happyReduction_684
happyReduction_684 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn262
		 (sL1 happy_var_1 $ mkQual varName (getQVARSYM happy_var_1)
	)}

happyReduce_685 = happySpecReduce_1  249# happyReduction_685
happyReduction_685 happy_x_1
	 =  case happyOut264 happy_x_1 of { happy_var_1 -> 
	happyIn263
		 (happy_var_1
	)}

happyReduce_686 = happySpecReduce_1  249# happyReduction_686
happyReduction_686 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn263
		 (sL1 happy_var_1 $ mkUnqual varName (fsLit "-")
	)}

happyReduce_687 = happySpecReduce_1  250# happyReduction_687
happyReduction_687 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn264
		 (sL1 happy_var_1 $ mkUnqual varName (getVARSYM happy_var_1)
	)}

happyReduce_688 = happySpecReduce_1  250# happyReduction_688
happyReduction_688 happy_x_1
	 =  case happyOut266 happy_x_1 of { happy_var_1 -> 
	happyIn264
		 (sL1 happy_var_1 $ mkUnqual varName (unLoc happy_var_1)
	)}

happyReduce_689 = happySpecReduce_1  251# happyReduction_689
happyReduction_689 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn265
		 (sL1 happy_var_1 (fsLit "as")
	)}

happyReduce_690 = happySpecReduce_1  251# happyReduction_690
happyReduction_690 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn265
		 (sL1 happy_var_1 (fsLit "qualified")
	)}

happyReduce_691 = happySpecReduce_1  251# happyReduction_691
happyReduction_691 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn265
		 (sL1 happy_var_1 (fsLit "hiding")
	)}

happyReduce_692 = happySpecReduce_1  251# happyReduction_692
happyReduction_692 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn265
		 (sL1 happy_var_1 (fsLit "export")
	)}

happyReduce_693 = happySpecReduce_1  251# happyReduction_693
happyReduction_693 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn265
		 (sL1 happy_var_1 (fsLit "label")
	)}

happyReduce_694 = happySpecReduce_1  251# happyReduction_694
happyReduction_694 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn265
		 (sL1 happy_var_1 (fsLit "dynamic")
	)}

happyReduce_695 = happySpecReduce_1  251# happyReduction_695
happyReduction_695 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn265
		 (sL1 happy_var_1 (fsLit "stdcall")
	)}

happyReduce_696 = happySpecReduce_1  251# happyReduction_696
happyReduction_696 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn265
		 (sL1 happy_var_1 (fsLit "ccall")
	)}

happyReduce_697 = happySpecReduce_1  251# happyReduction_697
happyReduction_697 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn265
		 (sL1 happy_var_1 (fsLit "capi")
	)}

happyReduce_698 = happySpecReduce_1  251# happyReduction_698
happyReduction_698 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn265
		 (sL1 happy_var_1 (fsLit "prim")
	)}

happyReduce_699 = happySpecReduce_1  251# happyReduction_699
happyReduction_699 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn265
		 (sL1 happy_var_1 (fsLit "javascript")
	)}

happyReduce_700 = happySpecReduce_1  251# happyReduction_700
happyReduction_700 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn265
		 (sL1 happy_var_1 (fsLit "group")
	)}

happyReduce_701 = happyMonadReduce 1# 252# happyReduction_701
happyReduction_701 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	( ams (sL1 happy_var_1 (fsLit "!")) [mj AnnBang happy_var_1])}
	) (\r -> happyReturn (happyIn266 r))

happyReduce_702 = happySpecReduce_1  252# happyReduction_702
happyReduction_702 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn266
		 (sL1 happy_var_1 (fsLit ".")
	)}

happyReduce_703 = happySpecReduce_1  253# happyReduction_703
happyReduction_703 happy_x_1
	 =  case happyOut268 happy_x_1 of { happy_var_1 -> 
	happyIn267
		 (happy_var_1
	)}

happyReduce_704 = happySpecReduce_1  253# happyReduction_704
happyReduction_704 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn267
		 (sL1 happy_var_1 $! mkQual dataName (getQCONID happy_var_1)
	)}

happyReduce_705 = happySpecReduce_1  254# happyReduction_705
happyReduction_705 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn268
		 (sL1 happy_var_1 $ mkUnqual dataName (getCONID happy_var_1)
	)}

happyReduce_706 = happySpecReduce_1  255# happyReduction_706
happyReduction_706 happy_x_1
	 =  case happyOut270 happy_x_1 of { happy_var_1 -> 
	happyIn269
		 (happy_var_1
	)}

happyReduce_707 = happySpecReduce_1  255# happyReduction_707
happyReduction_707 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn269
		 (sL1 happy_var_1 $ mkQual dataName (getQCONSYM happy_var_1)
	)}

happyReduce_708 = happySpecReduce_1  256# happyReduction_708
happyReduction_708 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn270
		 (sL1 happy_var_1 $ mkUnqual dataName (getCONSYM happy_var_1)
	)}

happyReduce_709 = happySpecReduce_1  256# happyReduction_709
happyReduction_709 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn270
		 (sL1 happy_var_1 $ consDataCon_RDR
	)}

happyReduce_710 = happySpecReduce_1  257# happyReduction_710
happyReduction_710 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn271
		 (sL1 happy_var_1 $ HsChar       (getCHARs happy_var_1) $ getCHAR happy_var_1
	)}

happyReduce_711 = happySpecReduce_1  257# happyReduction_711
happyReduction_711 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn271
		 (sL1 happy_var_1 $ HsString     (getSTRINGs happy_var_1)
                                                   $ getSTRING happy_var_1
	)}

happyReduce_712 = happySpecReduce_1  257# happyReduction_712
happyReduction_712 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn271
		 (sL1 happy_var_1 $ HsIntPrim    (getPRIMINTEGERs happy_var_1)
                                                   $ getPRIMINTEGER happy_var_1
	)}

happyReduce_713 = happySpecReduce_1  257# happyReduction_713
happyReduction_713 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn271
		 (sL1 happy_var_1 $ HsWordPrim   (getPRIMWORDs happy_var_1)
                                                   $ getPRIMWORD happy_var_1
	)}

happyReduce_714 = happySpecReduce_1  257# happyReduction_714
happyReduction_714 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn271
		 (sL1 happy_var_1 $ HsCharPrim   (getPRIMCHARs happy_var_1)
                                                   $ getPRIMCHAR happy_var_1
	)}

happyReduce_715 = happySpecReduce_1  257# happyReduction_715
happyReduction_715 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn271
		 (sL1 happy_var_1 $ HsStringPrim (getPRIMSTRINGs happy_var_1)
                                                   $ getPRIMSTRING happy_var_1
	)}

happyReduce_716 = happySpecReduce_1  257# happyReduction_716
happyReduction_716 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn271
		 (sL1 happy_var_1 $ HsFloatPrim  $ getPRIMFLOAT happy_var_1
	)}

happyReduce_717 = happySpecReduce_1  257# happyReduction_717
happyReduction_717 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn271
		 (sL1 happy_var_1 $ HsDoublePrim $ getPRIMDOUBLE happy_var_1
	)}

happyReduce_718 = happySpecReduce_1  258# happyReduction_718
happyReduction_718 happy_x_1
	 =  happyIn272
		 (()
	)

happyReduce_719 = happyMonadReduce 1# 258# happyReduction_719
happyReduction_719 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (( popContext)
	) (\r -> happyReturn (happyIn272 r))

happyReduce_720 = happySpecReduce_1  259# happyReduction_720
happyReduction_720 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn273
		 (sL1 happy_var_1 $ mkModuleNameFS (getCONID happy_var_1)
	)}

happyReduce_721 = happySpecReduce_1  259# happyReduction_721
happyReduction_721 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn273
		 (sL1 happy_var_1 $ let (mod,c) = getQCONID happy_var_1 in
                                  mkModuleNameFS
                                   (mkFastString
                                     (unpackFS mod ++ '.':unpackFS c))
	)}

happyReduce_722 = happySpecReduce_2  260# happyReduction_722
happyReduction_722 happy_x_2
	happy_x_1
	 =  case happyOut274 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	happyIn274
		 (((fst happy_var_1)++[gl happy_var_2],snd happy_var_1 + 1)
	)}}

happyReduce_723 = happySpecReduce_1  260# happyReduction_723
happyReduction_723 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn274
		 (([gl happy_var_1],1)
	)}

happyReduce_724 = happyMonadReduce 1# 261# happyReduction_724
happyReduction_724 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	( return (sL1 happy_var_1 (HsDocString (mkFastString (getDOCNEXT happy_var_1)))))}
	) (\r -> happyReturn (happyIn275 r))

happyReduce_725 = happyMonadReduce 1# 262# happyReduction_725
happyReduction_725 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	( return (sL1 happy_var_1 (HsDocString (mkFastString (getDOCPREV happy_var_1)))))}
	) (\r -> happyReturn (happyIn276 r))

happyReduce_726 = happyMonadReduce 1# 263# happyReduction_726
happyReduction_726 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	(
      let string = getDOCNAMED happy_var_1
          (name, rest) = break isSpace string
      in return (sL1 happy_var_1 (name, HsDocString (mkFastString rest))))}
	) (\r -> happyReturn (happyIn277 r))

happyReduce_727 = happyMonadReduce 1# 264# happyReduction_727
happyReduction_727 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	( let (n, doc) = getDOCSECTION happy_var_1 in
        return (sL1 happy_var_1 (n, HsDocString (mkFastString doc))))}
	) (\r -> happyReturn (happyIn278 r))

happyReduce_728 = happyMonadReduce 1# 265# happyReduction_728
happyReduction_728 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	( let string = getDOCNEXT happy_var_1 in
                     return (Just (sL1 happy_var_1 (HsDocString (mkFastString string)))))}
	) (\r -> happyReturn (happyIn279 r))

happyReduce_729 = happySpecReduce_1  266# happyReduction_729
happyReduction_729 happy_x_1
	 =  case happyOut276 happy_x_1 of { happy_var_1 -> 
	happyIn280
		 (Just happy_var_1
	)}

happyReduce_730 = happySpecReduce_0  266# happyReduction_730
happyReduction_730  =  happyIn280
		 (Nothing
	)

happyReduce_731 = happySpecReduce_1  267# happyReduction_731
happyReduction_731 happy_x_1
	 =  case happyOut275 happy_x_1 of { happy_var_1 -> 
	happyIn281
		 (Just happy_var_1
	)}

happyReduce_732 = happySpecReduce_0  267# happyReduction_732
happyReduction_732  =  happyIn281
		 (Nothing
	)

happyNewToken action sts stk
	= (lexer True)(\tk -> 
	let cont i = happyDoAction i tk action sts stk in
	case tk of {
	L _ ITeof -> happyDoAction 149# tk action sts stk;
	L _ ITunderscore -> cont 1#;
	L _ ITas -> cont 2#;
	L _ ITcase -> cont 3#;
	L _ ITclass -> cont 4#;
	L _ ITdata -> cont 5#;
	L _ ITdefault -> cont 6#;
	L _ ITderiving -> cont 7#;
	L _ ITdo -> cont 8#;
	L _ ITelse -> cont 9#;
	L _ IThiding -> cont 10#;
	L _ ITif -> cont 11#;
	L _ ITimport -> cont 12#;
	L _ ITin -> cont 13#;
	L _ ITinfix -> cont 14#;
	L _ ITinfixl -> cont 15#;
	L _ ITinfixr -> cont 16#;
	L _ ITinstance -> cont 17#;
	L _ ITlet -> cont 18#;
	L _ ITmodule -> cont 19#;
	L _ ITnewtype -> cont 20#;
	L _ ITof -> cont 21#;
	L _ ITqualified -> cont 22#;
	L _ ITthen -> cont 23#;
	L _ ITtype -> cont 24#;
	L _ ITwhere -> cont 25#;
	L _ (ITforall _) -> cont 26#;
	L _ ITforeign -> cont 27#;
	L _ ITexport -> cont 28#;
	L _ ITlabel -> cont 29#;
	L _ ITdynamic -> cont 30#;
	L _ ITsafe -> cont 31#;
	L _ ITinterruptible -> cont 32#;
	L _ ITunsafe -> cont 33#;
	L _ ITmdo -> cont 34#;
	L _ ITfamily -> cont 35#;
	L _ ITrole -> cont 36#;
	L _ ITstdcallconv -> cont 37#;
	L _ ITccallconv -> cont 38#;
	L _ ITcapiconv -> cont 39#;
	L _ ITprimcallconv -> cont 40#;
	L _ ITjavascriptcallconv -> cont 41#;
	L _ ITproc -> cont 42#;
	L _ ITrec -> cont 43#;
	L _ ITgroup -> cont 44#;
	L _ ITby -> cont 45#;
	L _ ITusing -> cont 46#;
	L _ ITpattern -> cont 47#;
	L _ ITstatic -> cont 48#;
	L _ (ITinline_prag _ _ _) -> cont 49#;
	L _ (ITspec_prag _) -> cont 50#;
	L _ (ITspec_inline_prag _ _) -> cont 51#;
	L _ (ITsource_prag _) -> cont 52#;
	L _ (ITrules_prag _) -> cont 53#;
	L _ (ITcore_prag _) -> cont 54#;
	L _ (ITscc_prag _) -> cont 55#;
	L _ (ITgenerated_prag _) -> cont 56#;
	L _ (ITdeprecated_prag _) -> cont 57#;
	L _ (ITwarning_prag _) -> cont 58#;
	L _ (ITunpack_prag _) -> cont 59#;
	L _ (ITnounpack_prag _) -> cont 60#;
	L _ (ITann_prag _) -> cont 61#;
	L _ (ITvect_prag _) -> cont 62#;
	L _ (ITvect_scalar_prag _) -> cont 63#;
	L _ (ITnovect_prag _) -> cont 64#;
	L _ (ITminimal_prag _) -> cont 65#;
	L _ (ITctype _) -> cont 66#;
	L _ (IToverlapping_prag _) -> cont 67#;
	L _ (IToverlappable_prag _) -> cont 68#;
	L _ (IToverlaps_prag _) -> cont 69#;
	L _ (ITincoherent_prag _) -> cont 70#;
	L _ ITclose_prag -> cont 71#;
	L _ ITdotdot -> cont 72#;
	L _ ITcolon -> cont 73#;
	L _ (ITdcolon _) -> cont 74#;
	L _ ITequal -> cont 75#;
	L _ ITlam -> cont 76#;
	L _ ITlcase -> cont 77#;
	L _ ITvbar -> cont 78#;
	L _ (ITlarrow _) -> cont 79#;
	L _ (ITrarrow _) -> cont 80#;
	L _ ITat -> cont 81#;
	L _ ITtilde -> cont 82#;
	L _ ITtildehsh -> cont 83#;
	L _ (ITdarrow _) -> cont 84#;
	L _ ITminus -> cont 85#;
	L _ ITbang -> cont 86#;
	L _ (ITlarrowtail _) -> cont 87#;
	L _ (ITrarrowtail _) -> cont 88#;
	L _ (ITLarrowtail _) -> cont 89#;
	L _ (ITRarrowtail _) -> cont 90#;
	L _ ITdot -> cont 91#;
	L _ ITtypeApp -> cont 92#;
	L _ ITocurly -> cont 93#;
	L _ ITccurly -> cont 94#;
	L _ ITvocurly -> cont 95#;
	L _ ITvccurly -> cont 96#;
	L _ ITobrack -> cont 97#;
	L _ ITcbrack -> cont 98#;
	L _ ITopabrack -> cont 99#;
	L _ ITcpabrack -> cont 100#;
	L _ IToparen -> cont 101#;
	L _ ITcparen -> cont 102#;
	L _ IToubxparen -> cont 103#;
	L _ ITcubxparen -> cont 104#;
	L _ IToparenbar -> cont 105#;
	L _ ITcparenbar -> cont 106#;
	L _ ITsemi -> cont 107#;
	L _ ITcomma -> cont 108#;
	L _ ITbackquote -> cont 109#;
	L _ ITsimpleQuote -> cont 110#;
	L _ (ITvarid    _) -> cont 111#;
	L _ (ITconid    _) -> cont 112#;
	L _ (ITvarsym   _) -> cont 113#;
	L _ (ITconsym   _) -> cont 114#;
	L _ (ITqvarid   _) -> cont 115#;
	L _ (ITqconid   _) -> cont 116#;
	L _ (ITqvarsym  _) -> cont 117#;
	L _ (ITqconsym  _) -> cont 118#;
	L _ (ITdupipvarid   _) -> cont 119#;
	L _ (ITlabelvarid   _) -> cont 120#;
	L _ (ITchar   _ _) -> cont 121#;
	L _ (ITstring _ _) -> cont 122#;
	L _ (ITinteger _ _) -> cont 123#;
	L _ (ITrational _) -> cont 124#;
	L _ (ITprimchar   _ _) -> cont 125#;
	L _ (ITprimstring _ _) -> cont 126#;
	L _ (ITprimint    _ _) -> cont 127#;
	L _ (ITprimword   _ _) -> cont 128#;
	L _ (ITprimfloat  _) -> cont 129#;
	L _ (ITprimdouble _) -> cont 130#;
	L _ (ITdocCommentNext _) -> cont 131#;
	L _ (ITdocCommentPrev _) -> cont 132#;
	L _ (ITdocCommentNamed _) -> cont 133#;
	L _ (ITdocSection _ _) -> cont 134#;
	L _ (ITopenExpQuote _) -> cont 135#;
	L _ ITopenPatQuote -> cont 136#;
	L _ ITopenTypQuote -> cont 137#;
	L _ ITopenDecQuote -> cont 138#;
	L _ ITcloseQuote -> cont 139#;
	L _ (ITopenTExpQuote _) -> cont 140#;
	L _ ITcloseTExpQuote -> cont 141#;
	L _ (ITidEscape _) -> cont 142#;
	L _ ITparenEscape -> cont 143#;
	L _ (ITidTyEscape _) -> cont 144#;
	L _ ITparenTyEscape -> cont 145#;
	L _ ITtyQuote -> cont 146#;
	L _ (ITquasiQuote _) -> cont 147#;
	L _ (ITqQuasiQuote _) -> cont 148#;
	_ -> happyError' tk
	})

happyError_ 149# tk = happyError' tk
happyError_ _ tk = happyError' tk

happyThen :: () => P a -> (a -> P b) -> P b
happyThen = (>>=)
happyReturn :: () => a -> P a
happyReturn = (return)
happyThen1 = happyThen
happyReturn1 :: () => a -> P a
happyReturn1 = happyReturn
happyError' :: () => ((Located Token)) -> P a
happyError' tk = (\token -> happyError) tk

parseModule = happySomeParser where
  happySomeParser = happyThen (happyParse 0#) (\x -> happyReturn (happyOut15 x))

parseImport = happySomeParser where
  happySomeParser = happyThen (happyParse 1#) (\x -> happyReturn (happyOut39 x))

parseStatement = happySomeParser where
  happySomeParser = happyThen (happyParse 2#) (\x -> happyReturn (happyOut214 x))

parseDeclaration = happySomeParser where
  happySomeParser = happyThen (happyParse 3#) (\x -> happyReturn (happyOut51 x))

parseExpression = happySomeParser where
  happySomeParser = happyThen (happyParse 4#) (\x -> happyReturn (happyOut169 x))

parsePattern = happySomeParser where
  happySomeParser = happyThen (happyParse 5#) (\x -> happyReturn (happyOut207 x))

parseTypeSignature = happySomeParser where
  happySomeParser = happyThen (happyParse 6#) (\x -> happyReturn (happyOut165 x))

parseStmt = happySomeParser where
  happySomeParser = happyThen (happyParse 7#) (\x -> happyReturn (happyOut213 x))

parseIdentifier = happySomeParser where
  happySomeParser = happyThen (happyParse 8#) (\x -> happyReturn (happyOut14 x))

parseType = happySomeParser where
  happySomeParser = happyThen (happyParse 9#) (\x -> happyReturn (happyOut123 x))

parseHeader = happySomeParser where
  happySomeParser = happyThen (happyParse 10#) (\x -> happyReturn (happyOut23 x))

happySeq = happyDoSeq


happyError :: P a
happyError = srcParseFail

getVARID        (L _ (ITvarid    x)) = x
getCONID        (L _ (ITconid    x)) = x
getVARSYM       (L _ (ITvarsym   x)) = x
getCONSYM       (L _ (ITconsym   x)) = x
getQVARID       (L _ (ITqvarid   x)) = x
getQCONID       (L _ (ITqconid   x)) = x
getQVARSYM      (L _ (ITqvarsym  x)) = x
getQCONSYM      (L _ (ITqconsym  x)) = x
getIPDUPVARID   (L _ (ITdupipvarid   x)) = x
getLABELVARID   (L _ (ITlabelvarid   x)) = x
getCHAR         (L _ (ITchar   _ x)) = x
getSTRING       (L _ (ITstring _ x)) = x
getINTEGER      (L _ (ITinteger _ x)) = x
getRATIONAL     (L _ (ITrational x)) = x
getPRIMCHAR     (L _ (ITprimchar _ x)) = x
getPRIMSTRING   (L _ (ITprimstring _ x)) = x
getPRIMINTEGER  (L _ (ITprimint  _ x)) = x
getPRIMWORD     (L _ (ITprimword _ x)) = x
getPRIMFLOAT    (L _ (ITprimfloat x)) = x
getPRIMDOUBLE   (L _ (ITprimdouble x)) = x
getTH_ID_SPLICE (L _ (ITidEscape x)) = x
getTH_ID_TY_SPLICE (L _ (ITidTyEscape x)) = x
getINLINE       (L _ (ITinline_prag _ inl conl)) = (inl,conl)
getSPEC_INLINE  (L _ (ITspec_inline_prag _ True))  = (Inline,  FunLike)
getSPEC_INLINE  (L _ (ITspec_inline_prag _ False)) = (NoInline,FunLike)

getDOCNEXT (L _ (ITdocCommentNext x)) = x
getDOCPREV (L _ (ITdocCommentPrev x)) = x
getDOCNAMED (L _ (ITdocCommentNamed x)) = x
getDOCSECTION (L _ (ITdocSection n x)) = (n, x)

getCHARs        (L _ (ITchar       src _)) = src
getSTRINGs      (L _ (ITstring     src _)) = src
getINTEGERs     (L _ (ITinteger    src _)) = src
getPRIMCHARs    (L _ (ITprimchar   src _)) = src
getPRIMSTRINGs  (L _ (ITprimstring src _)) = src
getPRIMINTEGERs (L _ (ITprimint    src _)) = src
getPRIMWORDs    (L _ (ITprimword   src _)) = src

-- See Note [Pragma source text] in BasicTypes for the following
getINLINE_PRAGs       (L _ (ITinline_prag       src _ _)) = src
getSPEC_PRAGs         (L _ (ITspec_prag         src))     = src
getSPEC_INLINE_PRAGs  (L _ (ITspec_inline_prag  src _))   = src
getSOURCE_PRAGs       (L _ (ITsource_prag       src)) = src
getRULES_PRAGs        (L _ (ITrules_prag        src)) = src
getWARNING_PRAGs      (L _ (ITwarning_prag      src)) = src
getDEPRECATED_PRAGs   (L _ (ITdeprecated_prag   src)) = src
getSCC_PRAGs          (L _ (ITscc_prag          src)) = src
getGENERATED_PRAGs    (L _ (ITgenerated_prag    src)) = src
getCORE_PRAGs         (L _ (ITcore_prag         src)) = src
getUNPACK_PRAGs       (L _ (ITunpack_prag       src)) = src
getNOUNPACK_PRAGs     (L _ (ITnounpack_prag     src)) = src
getANN_PRAGs          (L _ (ITann_prag          src)) = src
getVECT_PRAGs         (L _ (ITvect_prag         src)) = src
getVECT_SCALAR_PRAGs  (L _ (ITvect_scalar_prag  src)) = src
getNOVECT_PRAGs       (L _ (ITnovect_prag       src)) = src
getMINIMAL_PRAGs      (L _ (ITminimal_prag      src)) = src
getOVERLAPPABLE_PRAGs (L _ (IToverlappable_prag src)) = src
getOVERLAPPING_PRAGs  (L _ (IToverlapping_prag  src)) = src
getOVERLAPS_PRAGs     (L _ (IToverlaps_prag     src)) = src
getINCOHERENT_PRAGs   (L _ (ITincoherent_prag   src)) = src
getCTYPEs             (L _ (ITctype             src)) = src

getStringLiteral l = StringLiteral (getSTRINGs l) (getSTRING l)

isUnicode :: Located Token -> Bool
isUnicode (L _ (ITforall     iu)) = iu == UnicodeSyntax
isUnicode (L _ (ITdarrow     iu)) = iu == UnicodeSyntax
isUnicode (L _ (ITdcolon     iu)) = iu == UnicodeSyntax
isUnicode (L _ (ITlarrow     iu)) = iu == UnicodeSyntax
isUnicode (L _ (ITrarrow     iu)) = iu == UnicodeSyntax
isUnicode (L _ (ITrarrow     iu)) = iu == UnicodeSyntax
isUnicode (L _ (ITlarrowtail iu)) = iu == UnicodeSyntax
isUnicode (L _ (ITrarrowtail iu)) = iu == UnicodeSyntax
isUnicode (L _ (ITLarrowtail iu)) = iu == UnicodeSyntax
isUnicode (L _ (ITRarrowtail iu)) = iu == UnicodeSyntax
isUnicode _                       = False

hasE :: Located Token -> Bool
hasE (L _ (ITopenExpQuote HasE))  = True
hasE (L _ (ITopenTExpQuote HasE)) = True
hasE _                            = False

getSCC :: Located Token -> P FastString
getSCC lt = do let s = getSTRING lt
                   err = "Spaces are not allowed in SCCs"
               -- We probably actually want to be more restrictive than this
               if ' ' `elem` unpackFS s
                   then failSpanMsgP (getLoc lt) (text err)
                   else return s

-- Utilities for combining source spans
comb2 :: Located a -> Located b -> SrcSpan
comb2 a b = a `seq` b `seq` combineLocs a b

comb3 :: Located a -> Located b -> Located c -> SrcSpan
comb3 a b c = a `seq` b `seq` c `seq`
    combineSrcSpans (getLoc a) (combineSrcSpans (getLoc b) (getLoc c))

comb4 :: Located a -> Located b -> Located c -> Located d -> SrcSpan
comb4 a b c d = a `seq` b `seq` c `seq` d `seq`
    (combineSrcSpans (getLoc a) $ combineSrcSpans (getLoc b) $
                combineSrcSpans (getLoc c) (getLoc d))

-- strict constructor version:
{-# INLINE sL #-}
sL :: SrcSpan -> a -> Located a
sL span a = span `seq` a `seq` L span a

-- See Note [Adding location info] for how these utility functions are used

-- replaced last 3 CPP macros in this file
{-# INLINE sL0 #-}
sL0 :: a -> Located a
sL0 = L noSrcSpan       -- #define L0   L noSrcSpan

{-# INLINE sL1 #-}
sL1 :: Located a -> b -> Located b
sL1 x = sL (getLoc x)   -- #define sL1   sL (getLoc $1)

{-# INLINE sLL #-}
sLL :: Located a -> Located b -> c -> Located c
sLL x y = sL (comb2 x y) -- #define LL   sL (comb2 $1 $>)

{- Note [Adding location info]
   ~~~~~~~~~~~~~~~~~~~~~~~~~~~

This is done using the three functions below, sL0, sL1
and sLL.  Note that these functions were mechanically
converted from the three macros that used to exist before,
namely L0, L1 and LL.

They each add a SrcSpan to their argument.

   sL0  adds 'noSrcSpan', used for empty productions
     -- This doesn't seem to work anymore -=chak

   sL1  for a production with a single token on the lhs.  Grabs the SrcSpan
        from that token.

   sLL  for a production with >1 token on the lhs.  Makes up a SrcSpan from
        the first and last tokens.

These suffice for the majority of cases.  However, we must be
especially careful with empty productions: sLL won't work if the first
or last token on the lhs can represent an empty span.  In these cases,
we have to calculate the span using more of the tokens from the lhs, eg.

        | 'newtype' tycl_hdr '=' newconstr deriving
                { L (comb3 $1 $4 $5)
                    (mkTyData NewType (unLoc $2) $4 (unLoc $5)) }

We provide comb3 and comb4 functions which are useful in such cases.

Be careful: there's no checking that you actually got this right, the
only symptom will be that the SrcSpans of your syntax will be
incorrect.

-}

-- Make a source location for the file.  We're a bit lazy here and just
-- make a point SrcSpan at line 1, column 0.  Strictly speaking we should
-- try to find the span of the whole file (ToDo).
fileSrcSpan :: P SrcSpan
fileSrcSpan = do
  l <- getSrcLoc;
  let loc = mkSrcLoc (srcLocFile l) 1 1;
  return (mkSrcSpan loc loc)

-- Hint about the MultiWayIf extension
hintMultiWayIf :: SrcSpan -> P ()
hintMultiWayIf span = do
  mwiEnabled <- liftM ((LangExt.MultiWayIf `xopt`) . dflags) getPState
  unless mwiEnabled $ parseErrorSDoc span $
    text "Multi-way if-expressions need MultiWayIf turned on"

-- Hint about if usage for beginners
hintIf :: SrcSpan -> String -> P (LHsExpr RdrName)
hintIf span msg = do
  mwiEnabled <- liftM ((LangExt.MultiWayIf `xopt`) . dflags) getPState
  if mwiEnabled
    then parseErrorSDoc span $ text $ "parse error in if statement"
    else parseErrorSDoc span $ text $ "parse error in if statement: "++msg

-- Hint about explicit-forall, assuming UnicodeSyntax is on
hintExplicitForall :: SrcSpan -> P ()
hintExplicitForall span = do
    forall      <- extension explicitForallEnabled
    rulePrag    <- extension inRulePrag
    unless (forall || rulePrag) $ parseErrorSDoc span $ vcat
      [ text "Illegal symbol '\x2200' in type" -- U+2200 FOR ALL
      , text "Perhaps you intended to use RankNTypes or a similar language"
      , text "extension to enable explicit-forall syntax: \x2200 <tvs>. <type>"
      ]

{-
%************************************************************************
%*                                                                      *
        Helper functions for generating annotations in the parser
%*                                                                      *
%************************************************************************

For the general principles of the following routines, see Note [Api annotations]
in ApiAnnotation.hs

-}

-- |Construct an AddAnn from the annotation keyword and the location
-- of the keyword itself
mj :: AnnKeywordId -> Located e -> AddAnn
mj a l s = addAnnotation s a (gl l)

-- |Construct an AddAnn from the annotation keyword and the Located Token. If
-- the token has a unicode equivalent and this has been used, provide the
-- unicode variant of the annotation.
mu :: AnnKeywordId -> Located Token -> AddAnn
mu a lt@(L l t) = (\s -> addAnnotation s (toUnicodeAnn a lt) l)

-- | If the 'Token' is using its unicode variant return the unicode variant of
--   the annotation
toUnicodeAnn :: AnnKeywordId -> Located Token -> AnnKeywordId
toUnicodeAnn a t = if isUnicode t then unicodeAnn a else a

gl = getLoc

-- |Add an annotation to the located element, and return the located
-- element as a pass through
aa :: Located a -> (AnnKeywordId,Located c) -> P (Located a)
aa a@(L l _) (b,s) = addAnnotation l b (gl s) >> return a

-- |Add an annotation to a located element resulting from a monadic action
am :: P (Located a) -> (AnnKeywordId, Located b) -> P (Located a)
am a (b,s) = do
  av@(L l _) <- a
  addAnnotation l b (gl s)
  return av

-- |Add a list of AddAnns to the given AST element
ams :: Located a -> [AddAnn] -> P (Located a)
ams a@(L l _) bs = addAnnsAt l bs >> return a

-- |Add all [AddAnn] to an AST element wrapped in a Just
aljs :: Located (Maybe a) -> [AddAnn] -> P (Located (Maybe a))
aljs a@(L l _) bs = addAnnsAt l bs >> return a

-- |Add all [AddAnn] to an AST element wrapped in a Just
ajs a@(Just (L l _)) bs = addAnnsAt l bs >> return a

-- |Add a list of AddAnns to the given AST element, where the AST element is the
--  result of a monadic action
amms :: P (Located a) -> [AddAnn] -> P (Located a)
amms a bs = do { av@(L l _) <- a
               ; addAnnsAt l bs
               ; return av }

-- |Add a list of AddAnns to the AST element, and return the element as a
--  OrdList
amsu :: Located a -> [AddAnn] -> P (OrdList (Located a))
amsu a@(L l _) bs = addAnnsAt l bs >> return (unitOL a)

-- |Synonyms for AddAnn versions of AnnOpen and AnnClose
mo,mc :: Located Token -> AddAnn
mo ll = mj AnnOpen ll
mc ll = mj AnnClose ll

moc,mcc :: Located Token -> AddAnn
moc ll = mj AnnOpenC ll
mcc ll = mj AnnCloseC ll

mop,mcp :: Located Token -> AddAnn
mop ll = mj AnnOpenP ll
mcp ll = mj AnnCloseP ll

mos,mcs :: Located Token -> AddAnn
mos ll = mj AnnOpenS ll
mcs ll = mj AnnCloseS ll

-- |Given a list of the locations of commas, provide a [AddAnn] with an AnnComma
--  entry for each SrcSpan
mcommas :: [SrcSpan] -> [AddAnn]
mcommas ss = map (\s -> mj AnnCommaTuple (L s ())) ss

-- |Get the location of the last element of a OrdList, or noSrcSpan
oll :: OrdList (Located a) -> SrcSpan
oll l =
  if isNilOL l then noSrcSpan
               else getLoc (lastOL l)

-- |Add a semicolon annotation in the right place in a list. If the
-- leading list is empty, add it to the tail
asl :: [Located a] -> Located b -> Located a -> P()
asl [] (L ls _) (L l _) = addAnnotation l          AnnSemi ls
asl (x:_xs) (L ls _) _x = addAnnotation (getLoc x) AnnSemi ls
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "<built-in>" #-}
{-# LINE 1 "<command-line>" #-}
{-# LINE 11 "<command-line>" #-}
# 1 "/usr/include/stdc-predef.h" 1 3 4

# 17 "/usr/include/stdc-predef.h" 3 4










































{-# LINE 11 "<command-line>" #-}
{-# LINE 1 "/opt/exp/ghc/root-ghc-7.10/lib/ghc-7.10.1.20150506/include/ghcversion.h" #-}


















{-# LINE 11 "<command-line>" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
-- Id: GenericTemplate.hs,v 1.26 2005/01/14 14:47:22 simonmar Exp 

{-# LINE 13 "templates/GenericTemplate.hs" #-}





-- Do not remove this comment. Required to fix CPP parsing when using GCC and a clang-compiled alex.
#if __GLASGOW_HASKELL__ > 706
#define LT(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.<# m)) :: Bool)
#define GTE(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.>=# m)) :: Bool)
#define EQ(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.==# m)) :: Bool)
#else
#define LT(n,m) (n Happy_GHC_Exts.<# m)
#define GTE(n,m) (n Happy_GHC_Exts.>=# m)
#define EQ(n,m) (n Happy_GHC_Exts.==# m)
#endif
{-# LINE 46 "templates/GenericTemplate.hs" #-}


data Happy_IntList = HappyCons Happy_GHC_Exts.Int# Happy_IntList





{-# LINE 67 "templates/GenericTemplate.hs" #-}

{-# LINE 77 "templates/GenericTemplate.hs" #-}

{-# LINE 86 "templates/GenericTemplate.hs" #-}

infixr 9 `HappyStk`
data HappyStk a = HappyStk a (HappyStk a)

-----------------------------------------------------------------------------
-- starting the parse

happyParse start_state = happyNewToken start_state notHappyAtAll notHappyAtAll

-----------------------------------------------------------------------------
-- Accepting the parse

-- If the current token is 0#, it means we've just accepted a partial
-- parse (a %partial parser).  We must ignore the saved token on the top of
-- the stack in this case.
happyAccept 0# tk st sts (_ `HappyStk` ans `HappyStk` _) =
        happyReturn1 ans
happyAccept j tk st sts (HappyStk ans _) = 
        (happyTcHack j (happyTcHack st)) (happyReturn1 ans)

-----------------------------------------------------------------------------
-- Arrays only: do the next action



happyDoAction i tk st
        = {- nothing -}


          case action of
                0#           -> {- nothing -}
                                     happyFail i tk st
                -1#          -> {- nothing -}
                                     happyAccept i tk st
                n | LT(n,(0# :: Happy_GHC_Exts.Int#)) -> {- nothing -}

                                                   (happyReduceArr Happy_Data_Array.! rule) i tk st
                                                   where rule = (Happy_GHC_Exts.I# ((Happy_GHC_Exts.negateInt# ((n Happy_GHC_Exts.+# (1# :: Happy_GHC_Exts.Int#))))))
                n                 -> {- nothing -}


                                     happyShift new_state i tk st
                                     where new_state = (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#))
   where off    = indexShortOffAddr happyActOffsets st
         off_i  = (off Happy_GHC_Exts.+# i)
         check  = if GTE(off_i,(0# :: Happy_GHC_Exts.Int#))
                  then EQ(indexShortOffAddr happyCheck off_i, i)
                  else False
         action
          | check     = indexShortOffAddr happyTable off_i
          | otherwise = indexShortOffAddr happyDefActions st


indexShortOffAddr (HappyA# arr) off =
        Happy_GHC_Exts.narrow16Int# i
  where
        i = Happy_GHC_Exts.word2Int# (Happy_GHC_Exts.or# (Happy_GHC_Exts.uncheckedShiftL# high 8#) low)
        high = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr (off' Happy_GHC_Exts.+# 1#)))
        low  = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr off'))
        off' = off Happy_GHC_Exts.*# 2#





data HappyAddr = HappyA# Happy_GHC_Exts.Addr#




-----------------------------------------------------------------------------
-- HappyState data type (not arrays)

{-# LINE 170 "templates/GenericTemplate.hs" #-}

-----------------------------------------------------------------------------
-- Shifting a token

happyShift new_state 0# tk st sts stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--     trace "shifting the error token" $
     happyDoAction i tk new_state (HappyCons (st) (sts)) (stk)

happyShift new_state i tk st sts stk =
     happyNewToken new_state (HappyCons (st) (sts)) ((happyInTok (tk))`HappyStk`stk)

-- happyReduce is specialised for the common cases.

happySpecReduce_0 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_0 nt fn j tk st@((action)) sts stk
     = happyGoto nt j tk st (HappyCons (st) (sts)) (fn `HappyStk` stk)

happySpecReduce_1 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_1 nt fn j tk _ sts@((HappyCons (st@(action)) (_))) (v1`HappyStk`stk')
     = let r = fn v1 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_2 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_2 nt fn j tk _ (HappyCons (_) (sts@((HappyCons (st@(action)) (_))))) (v1`HappyStk`v2`HappyStk`stk')
     = let r = fn v1 v2 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_3 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_3 nt fn j tk _ (HappyCons (_) ((HappyCons (_) (sts@((HappyCons (st@(action)) (_))))))) (v1`HappyStk`v2`HappyStk`v3`HappyStk`stk')
     = let r = fn v1 v2 v3 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happyReduce k i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyReduce k nt fn j tk st sts stk
     = case happyDrop (k Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) sts of
         sts1@((HappyCons (st1@(action)) (_))) ->
                let r = fn stk in  -- it doesn't hurt to always seq here...
                happyDoSeq r (happyGoto nt j tk st1 sts1 r)

happyMonadReduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonadReduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
          let drop_stk = happyDropStk k stk in
          happyThen1 (fn stk tk) (\r -> happyGoto nt j tk st1 sts1 (r `HappyStk` drop_stk))

happyMonad2Reduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonad2Reduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
         let drop_stk = happyDropStk k stk

             off = indexShortOffAddr happyGotoOffsets st1
             off_i = (off Happy_GHC_Exts.+# nt)
             new_state = indexShortOffAddr happyTable off_i



          in
          happyThen1 (fn stk tk) (\r -> happyNewToken new_state sts1 (r `HappyStk` drop_stk))

happyDrop 0# l = l
happyDrop n (HappyCons (_) (t)) = happyDrop (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) t

happyDropStk 0# l = l
happyDropStk n (x `HappyStk` xs) = happyDropStk (n Happy_GHC_Exts.-# (1#::Happy_GHC_Exts.Int#)) xs

-----------------------------------------------------------------------------
-- Moving to a new state after a reduction


happyGoto nt j tk st = 
   {- nothing -}
   happyDoAction j tk new_state
   where off = indexShortOffAddr happyGotoOffsets st
         off_i = (off Happy_GHC_Exts.+# nt)
         new_state = indexShortOffAddr happyTable off_i




-----------------------------------------------------------------------------
-- Error recovery (0# is the error token)

-- parse error if we are in recovery and we fail again
happyFail 0# tk old_st _ stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--      trace "failing" $ 
        happyError_ i tk

{-  We don't need state discarding for our restricted implementation of
    "error".  In fact, it can cause some bogus parses, so I've disabled it
    for now --SDM

-- discard a state
happyFail  0# tk old_st (HappyCons ((action)) (sts)) 
                                                (saved_tok `HappyStk` _ `HappyStk` stk) =
--      trace ("discarding state, depth " ++ show (length stk))  $
        happyDoAction 0# tk action sts ((saved_tok`HappyStk`stk))
-}

-- Enter error recovery: generate an error token,
--                       save the old token and carry on.
happyFail  i tk (action) sts stk =
--      trace "entering error recovery" $
        happyDoAction 0# tk action sts ( (Happy_GHC_Exts.unsafeCoerce# (Happy_GHC_Exts.I# (i))) `HappyStk` stk)

-- Internal happy errors:

notHappyAtAll :: a
notHappyAtAll = error "Internal Happy error\n"

-----------------------------------------------------------------------------
-- Hack to get the typechecker to accept our action functions


happyTcHack :: Happy_GHC_Exts.Int# -> a -> a
happyTcHack x y = y
{-# INLINE happyTcHack #-}


-----------------------------------------------------------------------------
-- Seq-ing.  If the --strict flag is given, then Happy emits 
--      happySeq = happyDoSeq
-- otherwise it emits
--      happySeq = happyDontSeq

happyDoSeq, happyDontSeq :: a -> b -> b
happyDoSeq   a b = a `seq` b
happyDontSeq a b = b

-----------------------------------------------------------------------------
-- Don't inline any functions from the template.  GHC has a nasty habit
-- of deciding to inline happyGoto everywhere, which increases the size of
-- the generated parser quite a bit.


{-# NOINLINE happyDoAction #-}
{-# NOINLINE happyTable #-}
{-# NOINLINE happyCheck #-}
{-# NOINLINE happyActOffsets #-}
{-# NOINLINE happyGotoOffsets #-}
{-# NOINLINE happyDefActions #-}

{-# NOINLINE happyShift #-}
{-# NOINLINE happySpecReduce_0 #-}
{-# NOINLINE happySpecReduce_1 #-}
{-# NOINLINE happySpecReduce_2 #-}
{-# NOINLINE happySpecReduce_3 #-}
{-# NOINLINE happyReduce #-}
{-# NOINLINE happyMonadReduce #-}
{-# NOINLINE happyGoto #-}
{-# NOINLINE happyFail #-}

-- end of Happy Template.
