/* gnome-sudoku.c generated by valac 0.26.0.21-afb3, the Vala compiler
 * generated from gnome-sudoku.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libsudoku.h"
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <gee.h>


#define TYPE_SUDOKU (sudoku_get_type ())
#define SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU, Sudoku))
#define SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU, SudokuClass))
#define IS_SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU))
#define IS_SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU))
#define SUDOKU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU, SudokuClass))

typedef struct _Sudoku Sudoku;
typedef struct _SudokuClass SudokuClass;
typedef struct _SudokuPrivate SudokuPrivate;

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;

#define TYPE_PRINT_DIALOG (print_dialog_get_type ())
#define PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_DIALOG, PrintDialog))
#define PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_DIALOG, PrintDialogClass))
#define IS_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_DIALOG))
#define IS_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_DIALOG))
#define PRINT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_DIALOG, PrintDialogClass))

typedef struct _PrintDialog PrintDialog;
typedef struct _PrintDialogClass PrintDialogClass;
typedef struct _Block4Data Block4Data;

struct _Sudoku {
	GtkApplication parent_instance;
	SudokuPrivate * priv;
};

struct _SudokuClass {
	GtkApplicationClass parent_class;
};

struct _SudokuPrivate {
	GSettings* settings;
	gboolean is_maximized;
	gint window_width;
	gint window_height;
	GtkApplicationWindow* window;
	SudokuGame* game;
	SudokuView* view;
	GtkHeaderBar* headerbar;
	GtkStack* main_stack;
	GtkBox* game_box;
	GtkBox* undo_redo_box;
	GtkButton* back_button;
	SudokuSaver* saver;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
	GSimpleAction* clear_action;
	GSimpleAction* print_action;
	GSimpleAction* print_multiple_action;
	gboolean show_possibilities;
	gchar* desktop;
};

struct _Block1Data {
	int _ref_count_;
	Sudoku* self;
	SudokuBoard* board;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GtkMessageDialog* dialog;
};

struct _Block3Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

struct _Block4Data {
	int _ref_count_;
	Sudoku* self;
	PrintDialog* print_dialog;
};


static gpointer sudoku_parent_class = NULL;

GType sudoku_get_type (void) G_GNUC_CONST;
GType sudoku_view_get_type (void) G_GNUC_CONST;
#define SUDOKU_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU, SudokuPrivate))
enum  {
	SUDOKU_DUMMY_PROPERTY
};
static void sudoku_new_game_cb (Sudoku* self);
static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty);
static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_reset_cb (Sudoku* self);
static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_back_cb (Sudoku* self);
static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_undo_cb (Sudoku* self);
static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_redo_cb (Sudoku* self);
static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_cb (Sudoku* self);
static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_multiple_cb (Sudoku* self);
static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_help_cb (Sudoku* self);
static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_about_cb (Sudoku* self);
static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Sudoku* sudoku_new (void);
Sudoku* sudoku_construct (GType object_type);
static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options);
static void sudoku_real_startup (GApplication* base);
static void __lambda21_ (Sudoku* self);
void sudoku_view_set_show_warnings (SudokuView* self, gboolean value);
static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean sudoku_window_configure_event_cb (Sudoku* self, GdkEventConfigure* event);
static gboolean _sudoku_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event);
static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void sudoku_start_game (Sudoku* self, SudokuBoard* board);
static void sudoku_show_new_game_screen (Sudoku* self);
static void sudoku_real_activate (GApplication* base);
static void sudoku_real_shutdown (GApplication* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
SudokuView* sudoku_view_new (SudokuGame* game);
SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game);
void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value);
static void __lambda14_ (Sudoku* self);
static void ___lambda14__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self);
static void __lambda15_ (Block1Data* _data1_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda16_ (Block2Data* _data2_, gint response_id);
static void ___lambda16__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void ___lambda15__sudoku_board_completed (SudokuBoard* _sender, gpointer self);
static void __lambda13_ (Sudoku* self, GObject* obj, GAsyncResult* res);
static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda17_ (Block3Data* _data3_, gint response_id);
void sudoku_view_clear (SudokuView* self);
static void ___lambda17__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
GType sudoku_printer_get_type (void) G_GNUC_CONST;
SudokuPrinter* sudoku_printer_new (GeeList* boards, GtkWindow* window);
SudokuPrinter* sudoku_printer_construct (GType object_type, GeeList* boards, GtkWindow* window);
GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
GType print_dialog_get_type (void) G_GNUC_CONST;
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
PrintDialog* print_dialog_new (SudokuSaver* saver, GtkWindow* window);
PrintDialog* print_dialog_construct (GType object_type, SudokuSaver* saver, GtkWindow* window);
static void __lambda20_ (Block4Data* _data4_);
static void ___lambda20__print_dialog_finished (PrintDialog* _sender, gpointer self);
gint sudoku_main (gchar** args, int args_length1);
static void sudoku_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry SUDOKU_action_entries[11] = {{"new-game", _sudoku_new_game_cb_gsimple_action_activate_callback}, {"start-game", _sudoku_start_game_cb_gsimple_action_activate_callback, "i"}, {"reset", _sudoku_reset_cb_gsimple_action_activate_callback}, {"back", _sudoku_back_cb_gsimple_action_activate_callback}, {"undo", _sudoku_undo_cb_gsimple_action_activate_callback}, {"redo", _sudoku_redo_cb_gsimple_action_activate_callback}, {"print", _sudoku_print_cb_gsimple_action_activate_callback}, {"print-multiple", _sudoku_print_multiple_cb_gsimple_action_activate_callback}, {"help", _sudoku_help_cb_gsimple_action_activate_callback}, {"about", _sudoku_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GOptionEntry SUDOKU_option_entries[3] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Show release version", NULL}, {"show-possible-values", 's', 0, G_OPTION_ARG_NONE, NULL, "Show the possible values for each cell", NULL}, {NULL}};
static const gchar* SUDOKU_authors[6] = {"Robert Ancell <robert.ancell@gmail.com>", "Christopher Baines <cbaines8@gmail.com>", "Thomas M. Hinkle <Thomas_Hinkle@alumni.brown.edu>", "Parin Porecha <parinporecha@gmail.com>", "John Stowers <john.stowers@gmail.com>", NULL};

static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_new_game_cb ((Sudoku*) self);
#line 232 "gnome-sudoku.c"
}


static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_start_game_cb ((Sudoku*) self, action, parameter);
#line 239 "gnome-sudoku.c"
}


static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_reset_cb ((Sudoku*) self);
#line 246 "gnome-sudoku.c"
}


static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_back_cb ((Sudoku*) self);
#line 253 "gnome-sudoku.c"
}


static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_undo_cb ((Sudoku*) self);
#line 260 "gnome-sudoku.c"
}


static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_redo_cb ((Sudoku*) self);
#line 267 "gnome-sudoku.c"
}


static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_print_cb ((Sudoku*) self);
#line 274 "gnome-sudoku.c"
}


static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_print_multiple_cb ((Sudoku*) self);
#line 281 "gnome-sudoku.c"
}


static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_help_cb ((Sudoku*) self);
#line 288 "gnome-sudoku.c"
}


static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_about_cb ((Sudoku*) self);
#line 295 "gnome-sudoku.c"
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_application_quit ((GApplication*) self);
#line 302 "gnome-sudoku.c"
}


Sudoku* sudoku_construct (GType object_type) {
	Sudoku * self = NULL;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	setlocale (LC_ALL, "");
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	textdomain (GETTEXT_PACKAGE);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) g_object_new (object_type, "application-id", "org.gnome.sudoku", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_application_add_main_option_entries ((GApplication*) self, SUDOKU_option_entries);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return self;
#line 322 "gnome-sudoku.c"
}


Sudoku* sudoku_new (void) {
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return sudoku_construct (TYPE_SUDOKU);
#line 329 "gnome-sudoku.c"
}


static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Sudoku * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GVariantDict* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = options;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp1_) {
#line 350 "gnome-sudoku.c"
		FILE* _tmp2_ = NULL;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = stderr;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		fprintf (_tmp2_, "gnome-sudoku %s\n", VERSION);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		result = EXIT_SUCCESS;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return result;
#line 360 "gnome-sudoku.c"
	}
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = options;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = g_variant_dict_contains (_tmp3_, "show-possible-values");
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp4_) {
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->show_possibilities = TRUE;
#line 370 "gnome-sudoku.c"
	}
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = -1;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 376 "gnome-sudoku.c"
}


static void __lambda21_ (Sudoku* self) {
	SudokuView* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->view;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->settings;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = g_settings_get_boolean (_tmp1_, "show-warnings");
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_show_warnings (_tmp0_, _tmp2_);
#line 392 "gnome-sudoku.c"
}


static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda21_ ((Sudoku*) self);
#line 399 "gnome-sudoku.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return self ? g_object_ref (self) : NULL;
#line 406 "gnome-sudoku.c"
}


static gboolean _sudoku_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = sudoku_window_configure_event_cb ((Sudoku*) self, event);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 415 "gnome-sudoku.c"
}


static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = sudoku_window_state_event_cb ((Sudoku*) self, event);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 424 "gnome-sudoku.c"
}


static void sudoku_real_startup (GApplication* base) {
	Sudoku * self;
	GSettings* _tmp0_ = NULL;
	GAction* action = NULL;
	GSettings* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gchar* _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp24_ = NULL;
	GdkScreen* _tmp30_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp31_ = NULL;
	GtkBuilder* _tmp32_ = NULL;
	GObject* _tmp33_ = NULL;
	GtkApplicationWindow* _tmp34_ = NULL;
	GtkApplicationWindow* _tmp35_ = NULL;
	GtkApplicationWindow* _tmp36_ = NULL;
	GtkApplicationWindow* _tmp37_ = NULL;
	GSettings* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	GSettings* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	GSettings* _tmp42_ = NULL;
	gboolean _tmp43_ = FALSE;
	GtkApplicationWindow* _tmp45_ = NULL;
	GtkBuilder* _tmp46_ = NULL;
	GObject* _tmp47_ = NULL;
	GtkHeaderBar* _tmp48_ = NULL;
	GtkBuilder* _tmp49_ = NULL;
	GObject* _tmp50_ = NULL;
	GtkStack* _tmp51_ = NULL;
	GtkBuilder* _tmp52_ = NULL;
	GObject* _tmp53_ = NULL;
	GtkBox* _tmp54_ = NULL;
	GtkBuilder* _tmp55_ = NULL;
	GObject* _tmp56_ = NULL;
	GtkBox* _tmp57_ = NULL;
	GtkBuilder* _tmp58_ = NULL;
	GObject* _tmp59_ = NULL;
	GtkButton* _tmp60_ = NULL;
	GAction* _tmp61_ = NULL;
	GSimpleAction* _tmp62_ = NULL;
	GAction* _tmp63_ = NULL;
	GSimpleAction* _tmp64_ = NULL;
	GAction* _tmp65_ = NULL;
	GSimpleAction* _tmp66_ = NULL;
	GAction* _tmp67_ = NULL;
	GSimpleAction* _tmp68_ = NULL;
	GAction* _tmp69_ = NULL;
	GSimpleAction* _tmp70_ = NULL;
	const gchar* _tmp71_ = NULL;
	gchar* _tmp72_ = NULL;
	gboolean _tmp73_ = FALSE;
	const gchar* _tmp74_ = NULL;
	SudokuSaver* _tmp84_ = NULL;
	SudokuGame* savegame = NULL;
	SudokuSaver* _tmp85_ = NULL;
	SudokuGame* _tmp86_ = NULL;
	SudokuGame* _tmp87_ = NULL;
	GError * _inner_error_ = NULL;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_APPLICATION_CLASS (sudoku_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action_entries ((GActionMap*) self, SUDOKU_action_entries, G_N_ELEMENTS (SUDOKU_action_entries), self);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = g_settings_new ("org.gnome.sudoku");
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->settings);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->settings = _tmp0_;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->settings;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = g_settings_create_action (_tmp1_, "show-warnings");
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	action = _tmp2_;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GObject*) action, "notify::state", (GCallback) ___lambda21__g_object_notify, self, 0);
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action ((GActionMap*) self, action);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = g_strdup ("<Primary>n");
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = g_new0 (gchar*, 1 + 1);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_[0] = _tmp3_;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _tmp4_;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5__length1 = 1;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp5_);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = g_strdup ("<Primary>p");
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = g_new0 (gchar*, 1 + 1);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_[0] = _tmp6_;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = _tmp7_;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8__length1 = 1;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.print", _tmp8_);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = g_strdup ("<Primary>q");
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = g_new0 (gchar*, 1 + 1);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_[0] = _tmp9_;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = _tmp10_;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11__length1 = 1;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp11_);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = g_strdup ("<Primary>r");
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = g_new0 (gchar*, 1 + 1);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_[0] = _tmp12_;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = _tmp13_;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14__length1 = 1;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.reset", _tmp14_);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = g_strdup ("<Primary>z");
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_ = g_new0 (gchar*, 1 + 1);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_[0] = _tmp15_;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = _tmp16_;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17__length1 = 1;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo", _tmp17_);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = g_strdup ("<Primary><Shift>z");
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = g_new0 (gchar*, 1 + 1);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_[0] = _tmp18_;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = _tmp19_;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20__length1 = 1;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.redo", _tmp20_);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = g_strdup ("F1");
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = g_new0 (gchar*, 1 + 1);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_[0] = _tmp21_;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = _tmp22_;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23__length1 = 1;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp23_);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_set_default_icon_name ("gnome-sudoku");
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = gtk_css_provider_new ();
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	css_provider = _tmp24_;
#line 641 "gnome-sudoku.c"
	{
		gchar* data = NULL;
		gchar* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp25_ = g_strdup ("GtkButtonBox { -GtkButtonBox-child-internal-pad-x:0; }\n" \
"                          GtkBox#start_box { margin:0 80px 0 80px; }");
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		data = _tmp25_;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp26_ = strlen (data);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp27_ = _tmp26_;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_css_provider_load_from_data (css_provider, data, (gssize) _tmp27_, &_inner_error_);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_free0 (data);
#line 661 "gnome-sudoku.c"
			goto __catch0_g_error;
		}
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (data);
#line 666 "gnome-sudoku.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp28_ = e;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp29_ = _tmp28_->message;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_warning ("gnome-sudoku.vala:142: Error loading css styles: %s", _tmp29_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 686 "gnome-sudoku.c"
	}
	__finally0:
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (css_provider);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (action);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 701 "gnome-sudoku.c"
	}
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp30_ = gdk_screen_get_default ();
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_style_context_add_provider_for_screen (_tmp30_, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp31_ = gtk_builder_new_from_resource ("/org/gnome/sudoku/ui/gnome-sudoku.ui");
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	builder = _tmp31_;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp32_ = builder;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp33_ = gtk_builder_get_object (_tmp32_, "sudoku_app");
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_application_window_get_type (), GtkApplicationWindow));
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->window);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->window = _tmp34_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp35_ = self->priv->window;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GtkWidget*) _tmp35_, "configure-event", (GCallback) _sudoku_window_configure_event_cb_gtk_widget_configure_event, self, 0);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp36_ = self->priv->window;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GtkWidget*) _tmp36_, "window-state-event", (GCallback) _sudoku_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp37_ = self->priv->window;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp38_ = self->priv->settings;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp39_ = g_settings_get_int (_tmp38_, "window-width");
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp40_ = self->priv->settings;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp41_ = g_settings_get_int (_tmp40_, "window-height");
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_set_default_size ((GtkWindow*) _tmp37_, _tmp39_, _tmp41_);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp42_ = self->priv->settings;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp43_ = g_settings_get_boolean (_tmp42_, "window-is-maximized");
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp43_) {
#line 747 "gnome-sudoku.c"
		GtkApplicationWindow* _tmp44_ = NULL;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp44_ = self->priv->window;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_window_maximize ((GtkWindow*) _tmp44_);
#line 753 "gnome-sudoku.c"
	}
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp45_ = self->priv->window;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp45_);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp46_ = builder;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp47_ = gtk_builder_get_object (_tmp46_, "headerbar");
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_header_bar_get_type (), GtkHeaderBar));
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->headerbar = _tmp48_;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp49_ = builder;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp50_ = gtk_builder_get_object (_tmp49_, "main_stack");
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_stack_get_type (), GtkStack));
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->main_stack = _tmp51_;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp52_ = builder;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp53_ = gtk_builder_get_object (_tmp52_, "game_box");
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_box_get_type (), GtkBox));
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game_box);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->game_box = _tmp54_;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp55_ = builder;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp56_ = gtk_builder_get_object (_tmp55_, "undo_redo_box");
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_box_get_type (), GtkBox));
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_redo_box);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->undo_redo_box = _tmp57_;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp58_ = builder;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp59_ = gtk_builder_get_object (_tmp58_, "back_button");
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_button_get_type (), GtkButton));
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->back_button);
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->back_button = _tmp60_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp61_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, g_simple_action_get_type (), GSimpleAction));
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_action);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->undo_action = _tmp62_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp63_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp64_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, g_simple_action_get_type (), GSimpleAction));
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->redo_action);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->redo_action = _tmp64_;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp65_ = g_action_map_lookup_action ((GActionMap*) self, "reset");
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, g_simple_action_get_type (), GSimpleAction));
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clear_action);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->clear_action = _tmp66_;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp67_ = g_action_map_lookup_action ((GActionMap*) self, "print");
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, g_simple_action_get_type (), GSimpleAction));
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_action);
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->print_action = _tmp68_;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp69_ = g_action_map_lookup_action ((GActionMap*) self, "print-multiple");
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp70_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, g_simple_action_get_type (), GSimpleAction));
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_multiple_action);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->print_multiple_action = _tmp70_;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp71_ = g_getenv ("XDG_CURRENT_DESKTOP");
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp72_ = g_strdup (_tmp71_);
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (self->priv->desktop);
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->desktop = _tmp72_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp74_ = self->priv->desktop;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp74_ == NULL) {
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp73_ = TRUE;
#line 863 "gnome-sudoku.c"
	} else {
		const gchar* _tmp75_ = NULL;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp75_ = self->priv->desktop;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp73_ = g_strcmp0 (_tmp75_, "Unity") != 0;
#line 870 "gnome-sudoku.c"
	}
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp73_) {
#line 874 "gnome-sudoku.c"
		GtkHeaderBar* _tmp76_ = NULL;
		GtkApplicationWindow* _tmp77_ = NULL;
		GtkHeaderBar* _tmp78_ = NULL;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp76_ = self->priv->headerbar;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_show_close_button (_tmp76_, TRUE);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp77_ = self->priv->window;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp78_ = self->priv->headerbar;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_window_set_titlebar ((GtkWindow*) _tmp77_, (GtkWidget*) _tmp78_);
#line 888 "gnome-sudoku.c"
	} else {
		GtkBox* vbox = NULL;
		GtkBuilder* _tmp79_ = NULL;
		GObject* _tmp80_ = NULL;
		GtkBox* _tmp81_ = NULL;
		GtkBox* _tmp82_ = NULL;
		GtkHeaderBar* _tmp83_ = NULL;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp79_ = builder;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp80_ = gtk_builder_get_object (_tmp79_, "vbox");
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp81_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, gtk_box_get_type (), GtkBox));
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		vbox = _tmp81_;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp82_ = vbox;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp83_ = self->priv->headerbar;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_box_pack_start (_tmp82_, (GtkWidget*) _tmp83_, FALSE, FALSE, (guint) 0);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (vbox);
#line 912 "gnome-sudoku.c"
	}
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp84_ = sudoku_saver_new ();
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->saver);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->saver = _tmp84_;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp85_ = self->priv->saver;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp86_ = sudoku_saver_get_savedgame (_tmp85_);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	savegame = _tmp86_;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp87_ = savegame;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp87_ != NULL) {
#line 930 "gnome-sudoku.c"
		SudokuGame* _tmp88_ = NULL;
		SudokuBoard* _tmp89_ = NULL;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp88_ = savegame;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp89_ = _tmp88_->board;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_game (self, _tmp89_);
#line 939 "gnome-sudoku.c"
	} else {
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_show_new_game_screen (self);
#line 943 "gnome-sudoku.c"
	}
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (savegame);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (builder);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (css_provider);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (action);
#line 953 "gnome-sudoku.c"
}


static void sudoku_real_activate (GApplication* base) {
	Sudoku * self;
	GtkApplicationWindow* _tmp0_ = NULL;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 966 "gnome-sudoku.c"
}


static void sudoku_real_shutdown (GApplication* base) {
	Sudoku * self;
	SudokuGame* _tmp0_ = NULL;
	GSettings* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GSettings* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	GSettings* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	GError * _inner_error_ = NULL;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ != NULL) {
#line 986 "gnome-sudoku.c"
		gboolean _tmp1_ = FALSE;
		SudokuGame* _tmp2_ = NULL;
		SudokuBoard* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp11_ = FALSE;
		SudokuGame* _tmp12_ = NULL;
		SudokuBoard* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->game;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = _tmp2_->board;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = sudoku_board_is_empty (_tmp3_);
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (!_tmp4_) {
#line 1003 "gnome-sudoku.c"
			SudokuGame* _tmp5_ = NULL;
			SudokuBoard* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp5_ = self->priv->game;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp6_ = _tmp5_->board;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp7_ = sudoku_board_get_complete (_tmp6_);
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp8_ = _tmp7_;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp1_ = !_tmp8_;
#line 1018 "gnome-sudoku.c"
		} else {
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp1_ = FALSE;
#line 1022 "gnome-sudoku.c"
		}
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp1_) {
#line 1026 "gnome-sudoku.c"
			SudokuSaver* _tmp9_ = NULL;
			SudokuGame* _tmp10_ = NULL;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp9_ = self->priv->saver;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp10_ = self->priv->game;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			sudoku_saver_save_game (_tmp9_, _tmp10_);
#line 1035 "gnome-sudoku.c"
		}
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = self->priv->game;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = _tmp12_->board;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = sudoku_board_is_empty (_tmp13_);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp14_) {
#line 1045 "gnome-sudoku.c"
			SudokuSaver* _tmp15_ = NULL;
			SudokuGame* _tmp16_ = NULL;
			SudokuGame* _tmp17_ = NULL;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp15_ = self->priv->saver;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp16_ = sudoku_saver_get_savedgame (_tmp15_);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp17_ = _tmp16_;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp11_ = _tmp17_ != NULL;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (_tmp17_);
#line 1059 "gnome-sudoku.c"
		} else {
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp11_ = FALSE;
#line 1063 "gnome-sudoku.c"
		}
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp11_) {
#line 1067 "gnome-sudoku.c"
			GFile* file = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			GFile* _tmp20_ = NULL;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp18_ = sudoku_saver_get_savegame_file ();
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp19_ = _tmp18_;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp20_ = g_file_new_for_path (_tmp19_);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			file = _tmp20_;
#line 1080 "gnome-sudoku.c"
			{
				GFile* _tmp21_ = NULL;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp21_ = file;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_file_delete (_tmp21_, NULL, &_inner_error_);
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1089 "gnome-sudoku.c"
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				e = _inner_error_;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_inner_error_ = NULL;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp22_ = e;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp23_ = _tmp22_->message;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_warning ("gnome-sudoku.vala:211: Failed to delete saved game: %s", _tmp23_);
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_g_error_free0 (e);
#line 1111 "gnome-sudoku.c"
			}
			__finally1:
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_g_object_unref0 (file);
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_clear_error (&_inner_error_);
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				return;
#line 1124 "gnome-sudoku.c"
			}
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (file);
#line 1128 "gnome-sudoku.c"
		}
	}
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = self->priv->settings;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = self->priv->window_width;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_int (_tmp24_, "window-width", _tmp25_);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = self->priv->settings;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = self->priv->window_height;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_int (_tmp26_, "window-height", _tmp27_);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_ = self->priv->settings;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = self->priv->is_maximized;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_boolean (_tmp28_, "window-is-maximized", _tmp29_);
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_APPLICATION_CLASS (sudoku_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 1151 "gnome-sudoku.c"
}


static gboolean sudoku_window_configure_event_cb (Sudoku* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->is_maximized;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (!_tmp0_) {
#line 1166 "gnome-sudoku.c"
		GdkEventConfigure* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = event;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = _tmp1_->width;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->window_width = _tmp2_;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = event;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = _tmp3_->height;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->window_height = _tmp4_;
#line 1183 "gnome-sudoku.c"
	}
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = FALSE;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 1189 "gnome-sudoku.c"
}


static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = event;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1207 "gnome-sudoku.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = event;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1216 "gnome-sudoku.c"
	}
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = FALSE;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 1222 "gnome-sudoku.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data1_;
#line 1231 "gnome-sudoku.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1240 "gnome-sudoku.c"
		Sudoku* self;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data1_->self;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data1_->board);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block1Data, _data1_);
#line 1250 "gnome-sudoku.c"
	}
}


static void __lambda14_ (Sudoku* self) {
	GSimpleAction* _tmp0_ = NULL;
	SudokuGame* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSimpleAction* _tmp6_ = NULL;
	SudokuGame* _tmp7_ = NULL;
	SudokuBoard* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->undo_action;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->game;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = sudoku_game_is_undostack_null (_tmp1_);
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, !_tmp2_);
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->redo_action;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->clear_action;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->game;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = _tmp7_->board;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = sudoku_board_is_empty (_tmp8_);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp6_, !_tmp9_);
#line 1292 "gnome-sudoku.c"
}


static void ___lambda14__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self) {
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda14_ ((Sudoku*) self);
#line 1299 "gnome-sudoku.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data2_;
#line 1308 "gnome-sudoku.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1317 "gnome-sudoku.c"
		Sudoku* self;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data2_->_data1_->self;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data2_->dialog);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		block1_data_unref (_data2_->_data1_);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_data2_->_data1_ = NULL;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block2Data, _data2_);
#line 1329 "gnome-sudoku.c"
	}
}


static void __lambda16_ (Block2Data* _data2_, gint response_id) {
	Block1Data* _data1_;
	Sudoku* self;
	gint _tmp0_ = 0;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_ = _data2_->_data1_;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data1_->self;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = response_id;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	switch (_tmp0_) {
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		case 0:
#line 1348 "gnome-sudoku.c"
		{
			SudokuBoard* _tmp1_ = NULL;
			DifficultyCategory _tmp2_ = 0;
			DifficultyCategory _tmp3_ = 0;
			SudokuBoard* _tmp4_ = NULL;
			SudokuBoard* _tmp5_ = NULL;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp1_ = _data1_->board;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp2_ = sudoku_board_get_difficulty_category (_tmp1_);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp3_ = _tmp2_;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp4_ = sudoku_generator_generate_board (_tmp3_);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp5_ = _tmp4_;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			sudoku_start_game (self, _tmp5_);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (_tmp5_);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			break;
#line 1371 "gnome-sudoku.c"
		}
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		case 1:
#line 1375 "gnome-sudoku.c"
		{
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			sudoku_show_new_game_screen (self);
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			break;
#line 1381 "gnome-sudoku.c"
		}
		default:
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		break;
#line 1386 "gnome-sudoku.c"
	}
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data2_->dialog);
#line 1390 "gnome-sudoku.c"
}


static void ___lambda16__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda16_ (self, response_id);
#line 1397 "gnome-sudoku.c"
}


static void __lambda15_ (Block1Data* _data1_) {
	Sudoku* self;
	Block2Data* _data2_;
	SudokuSaver* _tmp15_ = NULL;
	SudokuGame* _tmp16_ = NULL;
	gint minutes = 0;
	SudokuGame* _tmp17_ = NULL;
	gdouble _tmp18_ = 0.0;
	gint _tmp19_ = 0;
	gchar* time_str = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkApplicationWindow* _tmp22_ = NULL;
	GtkMessageDialog* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data1_->self;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->_ref_count_ = 1;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->_data1_ = block1_data_ref (_data1_);
#line 1425 "gnome-sudoku.c"
	{
		gint i = 0;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		i = 0;
#line 1430 "gnome-sudoku.c"
		{
			gboolean _tmp0_ = FALSE;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp0_ = TRUE;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			while (TRUE) {
#line 1437 "gnome-sudoku.c"
				gint _tmp2_ = 0;
				SudokuGame* _tmp3_ = NULL;
				SudokuBoard* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (!_tmp0_) {
#line 1445 "gnome-sudoku.c"
					gint _tmp1_ = 0;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					_tmp1_ = i;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					i = _tmp1_ + 1;
#line 1451 "gnome-sudoku.c"
				}
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp0_ = FALSE;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp2_ = i;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp3_ = self->priv->game;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp4_ = _tmp3_->board;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp6_ = _tmp5_;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (!(_tmp2_ < _tmp6_)) {
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					break;
#line 1469 "gnome-sudoku.c"
				}
				{
					gint j = 0;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					j = 0;
#line 1475 "gnome-sudoku.c"
					{
						gboolean _tmp7_ = FALSE;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
						_tmp7_ = TRUE;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
						while (TRUE) {
#line 1482 "gnome-sudoku.c"
							gint _tmp9_ = 0;
							SudokuGame* _tmp10_ = NULL;
							SudokuBoard* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							SudokuView* _tmp14_ = NULL;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							if (!_tmp7_) {
#line 1491 "gnome-sudoku.c"
								gint _tmp8_ = 0;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								_tmp8_ = j;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								j = _tmp8_ + 1;
#line 1497 "gnome-sudoku.c"
							}
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp7_ = FALSE;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp9_ = j;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp10_ = self->priv->game;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp11_ = _tmp10_->board;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp13_ = _tmp12_;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							if (!(_tmp9_ < _tmp13_)) {
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								break;
#line 1515 "gnome-sudoku.c"
							}
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp14_ = self->priv->view;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							g_object_set ((GtkWidget*) _tmp14_, "can-focus", FALSE, NULL);
#line 1521 "gnome-sudoku.c"
						}
					}
				}
			}
		}
	}
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->saver;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_ = self->priv->game;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_saver_add_game_to_finished (_tmp15_, _tmp16_, TRUE);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = self->priv->game;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = sudoku_game_get_total_time_played (_tmp17_);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = MAX (1, ((gint) _tmp18_) / 60);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	minutes = _tmp19_;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = ngettext ("Well done, you completed the puzzle in %d minute", "Well done, you completed the puzzle in %d minutes", (gulong) minutes);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = g_strdup_printf (_tmp20_, minutes);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	time_str = _tmp21_;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = self->priv->window;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp22_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, time_str);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp23_);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->dialog = _tmp23_;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = _ ("Same difficulty again");
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_add_button ((GtkDialog*) _data2_->dialog, _tmp24_, 0);
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = _ ("New difficulty");
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_add_button ((GtkDialog*) _data2_->dialog, _tmp25_, 1);
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data ((GtkDialog*) _data2_->dialog, "response", (GCallback) ___lambda16__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _data2_->dialog);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (time_str);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block2_data_unref (_data2_);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_ = NULL;
#line 1574 "gnome-sudoku.c"
}


static void ___lambda15__sudoku_board_completed (SudokuBoard* _sender, gpointer self) {
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda15_ (self);
#line 1581 "gnome-sudoku.c"
}


static void sudoku_start_game (Sudoku* self, SudokuBoard* board) {
	Block1Data* _data1_;
	SudokuBoard* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuView* _tmp4_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_ = NULL;
	GtkHeaderBar* _tmp22_ = NULL;
	SudokuBoard* _tmp23_ = NULL;
	SudokuGame* _tmp24_ = NULL;
	SudokuGame* _tmp25_ = NULL;
	GTimer* _tmp26_ = NULL;
	SudokuGame* _tmp27_ = NULL;
	SudokuView* _tmp28_ = NULL;
	SudokuView* _tmp29_ = NULL;
	SudokuView* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	SudokuView* _tmp32_ = NULL;
	GSettings* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	SudokuView* _tmp35_ = NULL;
	GtkBox* _tmp36_ = NULL;
	SudokuView* _tmp37_ = NULL;
	SudokuGame* _tmp38_ = NULL;
	SudokuGame* _tmp39_ = NULL;
	SudokuBoard* _tmp40_ = NULL;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (board != NULL);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_->_ref_count_ = 1;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_->self = g_object_ref (self);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = board;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (_data1_->board);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_->board = _tmp1_;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->undo_action;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp2_, FALSE);
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->redo_action;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, FALSE);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->view;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp4_ != NULL) {
#line 1643 "gnome-sudoku.c"
		GtkBox* _tmp5_ = NULL;
		SudokuView* _tmp6_ = NULL;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = self->priv->game_box;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = self->priv->view;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_container_remove ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
#line 1652 "gnome-sudoku.c"
	}
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = self->priv->desktop;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp8_ == NULL) {
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = TRUE;
#line 1660 "gnome-sudoku.c"
	} else {
		const gchar* _tmp9_ = NULL;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = self->priv->desktop;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = g_strcmp0 (_tmp9_, "Unity") != 0;
#line 1667 "gnome-sudoku.c"
	}
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp7_) {
#line 1671 "gnome-sudoku.c"
		GtkHeaderBar* _tmp10_ = NULL;
		SudokuBoard* _tmp11_ = NULL;
		DifficultyCategory _tmp12_ = 0;
		DifficultyCategory _tmp13_ = 0;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = self->priv->headerbar;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = _data1_->board;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = sudoku_board_get_difficulty_category (_tmp11_);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = _tmp12_;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = difficulty_category_to_string (_tmp13_);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp15_ = _tmp14_;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_subtitle (_tmp10_, _tmp15_);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp15_);
#line 1694 "gnome-sudoku.c"
	} else {
		GtkHeaderBar* _tmp16_ = NULL;
		SudokuBoard* _tmp17_ = NULL;
		DifficultyCategory _tmp18_ = 0;
		DifficultyCategory _tmp19_ = 0;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp16_ = self->priv->headerbar;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp17_ = _data1_->board;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp18_ = sudoku_board_get_difficulty_category (_tmp17_);
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp19_ = _tmp18_;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp20_ = difficulty_category_to_string (_tmp19_);
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp21_ = _tmp20_;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_title (_tmp16_, _tmp21_);
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp21_);
#line 1718 "gnome-sudoku.c"
	}
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = self->priv->headerbar;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp22_, TRUE);
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = _data1_->board;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = sudoku_game_new (_tmp23_);
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game);
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->game = _tmp24_;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_back_cb (self);
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = self->priv->game;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = _tmp25_->timer;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_timer_start (_tmp26_);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = self->priv->game;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_ = sudoku_view_new (_tmp27_);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp28_);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->view);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->view = _tmp28_;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = self->priv->view;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp29_, 480, 480);
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp30_ = self->priv->view;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp31_ = self->priv->show_possibilities;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_show_possibilities (_tmp30_, _tmp31_);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp32_ = self->priv->view;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp33_ = self->priv->settings;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp34_ = g_settings_get_boolean (_tmp33_, "show-warnings");
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_show_warnings (_tmp32_, _tmp34_);
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp35_ = self->priv->view;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp35_);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp36_ = self->priv->game_box;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp37_ = self->priv->view;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_box_pack_start (_tmp36_, (GtkWidget*) _tmp37_, TRUE, TRUE, (guint) 0);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp38_ = self->priv->game;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp38_, "cell-changed", (GCallback) ___lambda14__sudoku_game_cell_changed, self, 0);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp39_ = self->priv->game;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp40_ = _tmp39_->board;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data (_tmp40_, "completed", (GCallback) ___lambda15__sudoku_board_completed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block1_data_unref (_data1_);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_ = NULL;
#line 1792 "gnome-sudoku.c"
}


static void sudoku_show_new_game_screen (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	SudokuGame* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "start_box");
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->clear_action;
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp1_, FALSE);
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->back_button;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->game;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, _tmp3_ != NULL);
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->undo_redo_box;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, FALSE);
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->print_action;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp5_, FALSE);
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->desktop;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp7_ == NULL) {
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = TRUE;
#line 1835 "gnome-sudoku.c"
	} else {
		const gchar* _tmp8_ = NULL;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = self->priv->desktop;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = g_strcmp0 (_tmp8_, "Unity") != 0;
#line 1842 "gnome-sudoku.c"
	}
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp6_) {
#line 1846 "gnome-sudoku.c"
		GtkHeaderBar* _tmp9_ = NULL;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = self->priv->headerbar;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_subtitle (_tmp9_, NULL);
#line 1852 "gnome-sudoku.c"
	} else {
		GtkHeaderBar* _tmp10_ = NULL;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = self->priv->headerbar;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp10_, FALSE);
#line 1859 "gnome-sudoku.c"
	}
}


static void sudoku_new_game_cb (Sudoku* self) {
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_show_new_game_screen (self);
#line 1869 "gnome-sudoku.c"
}


static void __lambda13_ (Sudoku* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (res != NULL);
#line 1877 "gnome-sudoku.c"
	{
		GeeList* gen_boards = NULL;
		GAsyncResult* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		GtkButton* _tmp2_ = NULL;
		gpointer _tmp3_ = NULL;
		SudokuBoard* _tmp4_ = NULL;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = res;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = sudoku_generator_generate_boards_finish (_tmp0_, &_inner_error_);
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gen_boards = _tmp1_;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			if (_inner_error_->domain == G_THREAD_ERROR) {
#line 1895 "gnome-sudoku.c"
				goto __catch2_g_thread_error;
			}
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_clear_error (&_inner_error_);
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			return;
#line 1904 "gnome-sudoku.c"
		}
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->back_button;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = gee_list_get (gen_boards, 0);
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = (SudokuBoard*) _tmp3_;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_game (self, _tmp4_);
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_tmp4_);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (gen_boards);
#line 1920 "gnome-sudoku.c"
	}
	goto __finally2;
	__catch2_g_thread_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_ = NULL;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = e->message;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_error ("gnome-sudoku.vala:345: Thread error: %s", _tmp5_);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 1937 "gnome-sudoku.c"
	}
	__finally2:
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 1948 "gnome-sudoku.c"
	}
}


static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda13_ ((Sudoku*) self, source_object, res);
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_unref (self);
#line 1958 "gnome-sudoku.c"
}


static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty) {
	DifficultyCategory selected_difficulty = 0;
	GVariant* _tmp0_ = NULL;
	gint32 _tmp1_ = 0;
	GtkButton* _tmp2_ = NULL;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (action != NULL);
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = difficulty;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_variant_get_int32 (_tmp0_);
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	selected_difficulty = (DifficultyCategory) _tmp1_;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->back_button;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_generator_generate_boards_async (1, selected_difficulty, ___lambda13__gasync_ready_callback, g_object_ref (self));
#line 1983 "gnome-sudoku.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data3_;
#line 1992 "gnome-sudoku.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 2001 "gnome-sudoku.c"
		Sudoku* self;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data3_->self;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data3_->dialog);
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block3Data, _data3_);
#line 2011 "gnome-sudoku.c"
	}
}


static void __lambda17_ (Block3Data* _data3_, gint response_id) {
	Sudoku* self;
	gint _tmp0_ = 0;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data3_->self;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = response_id;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 2025 "gnome-sudoku.c"
		SudokuView* _tmp1_ = NULL;
		SudokuGame* _tmp2_ = NULL;
		GSimpleAction* _tmp3_ = NULL;
		GSimpleAction* _tmp4_ = NULL;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->view;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_clear (_tmp1_);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->game;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_reset (_tmp2_);
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->undo_action;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp3_, FALSE);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->redo_action;
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp4_, FALSE);
#line 2046 "gnome-sudoku.c"
	}
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data3_->dialog);
#line 2050 "gnome-sudoku.c"
}


static void ___lambda17__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda17_ (self, response_id);
#line 2057 "gnome-sudoku.c"
}


static void sudoku_reset_cb (Sudoku* self) {
	Block3Data* _data3_;
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMessageDialog* _tmp2_ = NULL;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->_ref_count_ = 1;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->self = g_object_ref (self);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _ ("Reset the board to its original state?");
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_OK_CANCEL, _tmp1_);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp2_);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->dialog = _tmp2_;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data ((GtkDialog*) _data3_->dialog, "response", (GCallback) ___lambda17__gtk_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _data3_->dialog);
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block3_data_unref (_data3_);
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_ = NULL;
#line 2092 "gnome-sudoku.c"
}


static void sudoku_back_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	SudokuBoard* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GtkButton* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "frame");
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->clear_action;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = _tmp2_->board;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = sudoku_board_is_empty (_tmp3_);
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp1_, !_tmp4_);
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->back_button;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, FALSE);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->undo_redo_box;
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, TRUE);
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->print_action;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp7_, TRUE);
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = self->priv->desktop;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp9_ == NULL) {
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = TRUE;
#line 2141 "gnome-sudoku.c"
	} else {
		const gchar* _tmp10_ = NULL;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = self->priv->desktop;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = g_strcmp0 (_tmp10_, "Unity") != 0;
#line 2148 "gnome-sudoku.c"
	}
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp8_) {
#line 2152 "gnome-sudoku.c"
		GtkHeaderBar* _tmp11_ = NULL;
		SudokuGame* _tmp12_ = NULL;
		SudokuBoard* _tmp13_ = NULL;
		DifficultyCategory _tmp14_ = 0;
		DifficultyCategory _tmp15_ = 0;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = self->priv->headerbar;
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = self->priv->game;
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = _tmp12_->board;
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = sudoku_board_get_difficulty_category (_tmp13_);
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp15_ = _tmp14_;
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp16_ = difficulty_category_to_string (_tmp15_);
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp17_ = _tmp16_;
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_subtitle (_tmp11_, _tmp17_);
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp17_);
#line 2178 "gnome-sudoku.c"
	} else {
		GtkHeaderBar* _tmp18_ = NULL;
		SudokuGame* _tmp19_ = NULL;
		SudokuBoard* _tmp20_ = NULL;
		DifficultyCategory _tmp21_ = 0;
		DifficultyCategory _tmp22_ = 0;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp18_ = self->priv->headerbar;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp19_ = self->priv->game;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp20_ = _tmp19_->board;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp21_ = sudoku_board_get_difficulty_category (_tmp20_);
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp22_ = _tmp21_;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp23_ = difficulty_category_to_string (_tmp22_);
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp24_ = _tmp23_;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_title (_tmp18_, _tmp24_);
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp24_);
#line 2205 "gnome-sudoku.c"
	}
}


static void sudoku_undo_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SudokuView* _tmp6_ = NULL;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2228 "gnome-sudoku.c"
	}
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_undo (_tmp2_);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->undo_action;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_undostack_null (_tmp4_);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->view;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
#line 2246 "gnome-sudoku.c"
}


static void sudoku_redo_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SudokuView* _tmp6_ = NULL;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2268 "gnome-sudoku.c"
	}
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_redo (_tmp2_);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->redo_action;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->view;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
#line 2286 "gnome-sudoku.c"
}


static void sudoku_print_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
	SudokuGame* _tmp6_ = NULL;
	SudokuBoard* _tmp7_ = NULL;
	SudokuBoard* _tmp8_ = NULL;
	SudokuBoard* _tmp9_ = NULL;
	SudokuPrinter* printer = NULL;
	GeeArrayList* _tmp10_ = NULL;
	GtkApplicationWindow* _tmp11_ = NULL;
	SudokuPrinter* _tmp12_ = NULL;
	SudokuPrinter* _tmp13_ = NULL;
	GSimpleAction* _tmp14_ = NULL;
	GSimpleAction* _tmp15_ = NULL;
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2319 "gnome-sudoku.c"
	}
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->print_action;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp2_, FALSE);
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_multiple_action;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, FALSE);
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	list = _tmp4_;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = list;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->game;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = _tmp6_->board;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = sudoku_board_clone (_tmp7_);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = _tmp8_;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp9_);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (_tmp9_);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = list;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = self->priv->window;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = sudoku_printer_new ((GeeList*) _tmp10_, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_window_get_type (), GtkWindow));
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	printer = _tmp12_;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = printer;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_printer_print_sudoku (_tmp13_);
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = self->priv->print_action;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp14_, TRUE);
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->print_multiple_action;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp15_, TRUE);
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (printer);
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (list);
#line 2371 "gnome-sudoku.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data4_;
#line 2380 "gnome-sudoku.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 2389 "gnome-sudoku.c"
		Sudoku* self;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data4_->self;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data4_->print_dialog);
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block4Data, _data4_);
#line 2399 "gnome-sudoku.c"
	}
}


static void __lambda20_ (Block4Data* _data4_) {
	Sudoku* self;
	GSimpleAction* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data4_->self;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data4_->print_dialog);
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->print_action;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->main_stack;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, g_strcmp0 (_tmp2_, "frame") == 0);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_multiple_action;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, TRUE);
#line 2426 "gnome-sudoku.c"
}


static void ___lambda20__print_dialog_finished (PrintDialog* _sender, gpointer self) {
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda20_ (self);
#line 2433 "gnome-sudoku.c"
}


static void sudoku_print_multiple_cb (Sudoku* self) {
	Block4Data* _data4_;
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	SudokuSaver* _tmp2_ = NULL;
	GtkApplicationWindow* _tmp3_ = NULL;
	PrintDialog* _tmp4_ = NULL;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data4_->_ref_count_ = 1;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data4_->self = g_object_ref (self);
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->print_action;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, FALSE);
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->print_multiple_action;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp1_, FALSE);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->saver;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->window;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = print_dialog_new (_tmp2_, (GtkWindow*) _tmp3_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp4_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data4_->print_dialog = _tmp4_;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data (_data4_->print_dialog, "finished", (GCallback) ___lambda20__print_dialog_finished, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_run ((GtkDialog*) _data4_->print_dialog);
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block4_data_unref (_data4_);
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data4_ = NULL;
#line 2478 "gnome-sudoku.c"
}


static void sudoku_help_cb (Sudoku* self) {
	GError * _inner_error_ = NULL;
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 2486 "gnome-sudoku.c"
	{
		GtkApplicationWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = self->priv->window;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_show_uri (_tmp1_, "help:gnome-sudoku", _tmp2_, &_inner_error_);
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2501 "gnome-sudoku.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = e;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = _tmp3_->message;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_warning ("gnome-sudoku.vala:437: Unable to open help: %s", _tmp4_);
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 2523 "gnome-sudoku.c"
	}
	__finally3:
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2534 "gnome-sudoku.c"
	}
}


static void sudoku_about_cb (Sudoku* self) {
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _ ("Sudoku");
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = sudoku_generator_qqwing_version ();
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = _tmp2_;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = g_strdup_printf ("The popular Japanese logic puzzle\n\nPuzzles generated by QQwing %s", _tmp3_);
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _tmp4_;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = _ (_tmp5_);
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = _ ("translator-credits");
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp0_, "program-name", _tmp1_, "logo-icon-name", "gnome-sudoku", "version", VERSION, "comments", _tmp6_, "copyright", "Copyright © 2005–2008 Thomas M. Hinkle\n" \
"Copyright © 2010–2011 Robert Ancell\n" \
"Copyright © 2014 Parin Porecha", "license-type", GTK_LICENSE_GPL_2_0, "authors", SUDOKU_authors, "artists", NULL, "translator-credits", _tmp7_, "website", "https://wiki.gnome.org/Apps/Sudoku/", NULL);
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (_tmp5_);
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (_tmp3_);
#line 2572 "gnome-sudoku.c"
}


gint sudoku_main (gchar** args, int args_length1) {
	gint result = 0;
	Sudoku* _tmp0_ = NULL;
	Sudoku* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = sudoku_new ();
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _tmp0_;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = args;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2__length1 = args_length1;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = g_application_run ((GApplication*) _tmp1_, _tmp2__length1, _tmp2_);
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = _tmp3_;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (_tmp1_);
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = _tmp4_;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 2602 "gnome-sudoku.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return sudoku_main (argv, argc);
#line 2612 "gnome-sudoku.c"
}


static void sudoku_class_init (SudokuClass * klass) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_type_class_add_private (klass, sizeof (SudokuPrivate));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->handle_local_options = sudoku_real_handle_local_options;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->startup = sudoku_real_startup;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->activate = sudoku_real_activate;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->shutdown = sudoku_real_shutdown;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_finalize;
#line 2631 "gnome-sudoku.c"
}


static void sudoku_instance_init (Sudoku * self) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv = SUDOKU_GET_PRIVATE (self);
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->show_possibilities = FALSE;
#line 2640 "gnome-sudoku.c"
}


static void sudoku_finalize (GObject* obj) {
	Sudoku * self;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU, Sudoku);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->settings);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->window);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game);
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->view);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game_box);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_redo_box);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->back_button);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->saver);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_action);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->redo_action);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clear_action);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_action);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_multiple_action);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (self->priv->desktop);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_OBJECT_CLASS (sudoku_parent_class)->finalize (obj);
#line 2682 "gnome-sudoku.c"
}


GType sudoku_get_type (void) {
	static volatile gsize sudoku_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sudoku), 0, (GInstanceInitFunc) sudoku_instance_init, NULL };
		GType sudoku_type_id;
		sudoku_type_id = g_type_register_static (gtk_application_get_type (), "Sudoku", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_type_id__volatile, sudoku_type_id);
	}
	return sudoku_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



