/* taquin-view.c generated by valac 0.34.0, the Vala compiler
 * generated from taquin-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2014-2016 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of Taquin.
 *
 * Taquin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Taquin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Taquin. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_TAQUIN_VIEW (taquin_view_get_type ())
#define TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAQUIN_VIEW, TaquinView))
#define TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAQUIN_VIEW, TaquinViewClass))
#define IS_TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAQUIN_VIEW))
#define IS_TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAQUIN_VIEW))
#define TAQUIN_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAQUIN_VIEW, TaquinViewClass))

typedef struct _TaquinView TaquinView;
typedef struct _TaquinViewClass TaquinViewClass;
typedef struct _TaquinViewPrivate TaquinViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_GAME_TYPE (game_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	DIRECTION_TOP,
	DIRECTION_LEFT,
	DIRECTION_RIGHT,
	DIRECTION_BOTTOM,
	DIRECTION_NONE
} Direction;

struct _TaquinView {
	GtkDrawingArea parent_instance;
	TaquinViewPrivate * priv;
};

struct _TaquinViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _TaquinViewPrivate {
	gint grid_border_main;
	gint grid_border_thin;
	gint arrows;
	gint tile_size;
	gint board_size;
	gint x_arrow;
	gint y_arrow;
	gboolean draw_lights;
	gint render_size;
	cairo_pattern_t* tiles_pattern;
	gboolean animate;
	gint animation_offset;
	gboolean x_axis;
	gint number;
	gint x_gap;
	gint y_gap;
	gboolean animate_end;
	gboolean finished;
	gdouble animation_end_offset;
	Game* _game;
	gchar* _theme;
};

typedef enum  {
	GAME_TYPE_FIFTEEN,
	GAME_TYPE_SIXTEEN
} GameType;


static gpointer taquin_view_parent_class = NULL;

GType direction_get_type (void) G_GNUC_CONST;
GType taquin_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define TAQUIN_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TAQUIN_VIEW, TaquinViewPrivate))
enum  {
	TAQUIN_VIEW_DUMMY_PROPERTY,
	TAQUIN_VIEW_GAME,
	TAQUIN_VIEW_THEME
};
#define TAQUIN_VIEW_GRID_SPACING 1
static void taquin_view_calculate (TaquinView* self);
Game* taquin_view_get_game (TaquinView* self);
gint game_get_size (Game* self);
TaquinView* taquin_view_new (void);
TaquinView* taquin_view_construct (GType object_type);
static gboolean taquin_view_real_draw (GtkWidget* base, cairo_t* cr);
static void taquin_view_load_image (TaquinView* self, cairo_t* c);
static gint taquin_view_get_x_offset (TaquinView* self);
static gint taquin_view_get_y_offset (TaquinView* self);
GType game_type_get_type (void) G_GNUC_CONST;
GameType game_get_game_type (Game* self);
static void taquin_view_draw_movable_lights (TaquinView* self, cairo_t* cr);
static void taquin_view_draw_fixed_arrows (TaquinView* self, cairo_t* cr);
static void taquin_view_draw_movable_arrows (TaquinView* self, cairo_t* cr);
gint* game_get_tiles (Game* self, int* result_length1, int* result_length2);
const gchar* taquin_view_get_theme (TaquinView* self);
static void taquin_view_draw_light (TaquinView* self, cairo_t* cr, gboolean horizontal);
static void taquin_view_draw_vertical_arrow (TaquinView* self, cairo_t* cr, gboolean inside, gint number);
static void taquin_view_draw_horizontal_arrow (TaquinView* self, cairo_t* cr, gboolean inside, gint number);
static void taquin_view_move_cb (TaquinView* self, gboolean x_axis, gint number, gint x_gap, gint y_gap);
static void taquin_view_complete_cb (TaquinView* self);
static gboolean __lambda4_ (TaquinView* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean taquin_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
void game_request_move (Game* self, gint x, gint y);
static gboolean taquin_view_real_key_press_event (GtkWidget* base, GdkEventKey* event);
void taquin_view_set_game (TaquinView* self, Game* value);
static void _taquin_view_move_cb_game_move (Game* _sender, gboolean x_axis, gint number, gint x_gap, gint y_gap, gpointer self);
static void _taquin_view_complete_cb_game_complete (Game* _sender, gpointer self);
void taquin_view_set_theme (TaquinView* self, const gchar* value);
static void taquin_view_finalize (GObject* obj);
static void _vala_taquin_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_taquin_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType direction_get_type (void) {
	static volatile gsize direction_type_id__volatile = 0;
	if (g_once_init_enter (&direction_type_id__volatile)) {
		static const GEnumValue values[] = {{DIRECTION_TOP, "DIRECTION_TOP", "top"}, {DIRECTION_LEFT, "DIRECTION_LEFT", "left"}, {DIRECTION_RIGHT, "DIRECTION_RIGHT", "right"}, {DIRECTION_BOTTOM, "DIRECTION_BOTTOM", "bottom"}, {DIRECTION_NONE, "DIRECTION_NONE", "none"}, {0, NULL, NULL}};
		GType direction_type_id;
		direction_type_id = g_enum_register_static ("Direction", values);
		g_once_init_leave (&direction_type_id__volatile, direction_type_id);
	}
	return direction_type_id__volatile;
}


static void taquin_view_calculate (TaquinView* self) {
	gint size = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	Game* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
#line 46 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (self != NULL);
#line 48 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 48 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 48 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp2_ = MIN (_tmp0_, _tmp1_);
#line 48 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	size = _tmp2_;
#line 50 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp3_ = taquin_view_get_game (self);
#line 50 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp4_ = _tmp3_;
#line 50 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp5_ = game_get_size (_tmp4_);
#line 50 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp6_ = _tmp5_;
#line 50 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->tile_size = ((size * 10) / 12) / _tmp6_;
#line 51 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp7_ = self->priv->tile_size;
#line 51 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp8_ = taquin_view_get_game (self);
#line 51 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp9_ = _tmp8_;
#line 51 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp10_ = game_get_size (_tmp9_);
#line 51 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp11_ = _tmp10_;
#line 51 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->board_size = (_tmp7_ * _tmp11_) - TAQUIN_VIEW_GRID_SPACING;
#line 52 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp12_ = self->priv->board_size;
#line 52 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->grid_border_main = (size - _tmp12_) / 2;
#line 53 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->arrows = size / 100;
#line 227 "taquin-view.c"
}


TaquinView* taquin_view_construct (GType object_type) {
	TaquinView * self = NULL;
#line 76 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self = (TaquinView*) g_object_new (object_type, NULL);
#line 78 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
#line 79 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_KEY_PRESS_MASK));
#line 80 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 350, 350);
#line 76 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	return self;
#line 243 "taquin-view.c"
}


TaquinView* taquin_view_new (void) {
#line 76 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	return taquin_view_construct (TYPE_TAQUIN_VIEW);
#line 250 "taquin-view.c"
}


static gboolean taquin_view_real_draw (GtkWidget* base, cairo_t* cr) {
	TaquinView * self;
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	cairo_pattern_t* _tmp3_ = NULL;
	cairo_t* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	cairo_t* _tmp22_ = NULL;
	cairo_t* _tmp23_ = NULL;
	cairo_t* _tmp24_ = NULL;
	cairo_t* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	cairo_t* _tmp32_ = NULL;
	cairo_t* _tmp33_ = NULL;
	cairo_t* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	cairo_t* _tmp36_ = NULL;
	cairo_t* _tmp37_ = NULL;
	cairo_t* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	cairo_t* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	cairo_t* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gint _tmp50_ = 0;
	cairo_t* _tmp51_ = NULL;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	gint _tmp54_ = 0;
	gint _tmp55_ = 0;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	cairo_t* _tmp58_ = NULL;
	gint _tmp59_ = 0;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	gint _tmp62_ = 0;
	gint _tmp63_ = 0;
	cairo_t* _tmp64_ = NULL;
	gint _tmp65_ = 0;
	gint _tmp66_ = 0;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	cairo_t* _tmp69_ = NULL;
	cairo_t* _tmp70_ = NULL;
	gdouble _tmp71_ = 0.0;
	cairo_t* _tmp72_ = NULL;
	gint _tmp73_ = 0;
	Game* _tmp74_ = NULL;
	Game* _tmp75_ = NULL;
	GameType _tmp76_ = 0;
	GameType _tmp77_ = 0;
	cairo_t* _tmp82_ = NULL;
	cairo_t* _tmp83_ = NULL;
	cairo_t* _tmp84_ = NULL;
	gint _tmp85_ = 0;
	gint _tmp86_ = 0;
	gboolean _tmp87_ = FALSE;
	gboolean _tmp88_ = FALSE;
	gboolean _tmp291_ = FALSE;
	cairo_t* _tmp299_ = NULL;
	gboolean _tmp300_ = FALSE;
#line 112 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self = (TaquinView*) base;
#line 112 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 114 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp0_ = taquin_view_get_game (self);
#line 114 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp1_ = _tmp0_;
#line 114 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp1_ == NULL) {
#line 115 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		result = FALSE;
#line 115 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		return result;
#line 346 "taquin-view.c"
	}
#line 117 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	taquin_view_calculate (self);
#line 119 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp3_ = self->priv->tiles_pattern;
#line 119 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp3_ == NULL) {
#line 119 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp2_ = TRUE;
#line 356 "taquin-view.c"
	} else {
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 119 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp4_ = self->priv->render_size;
#line 119 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp5_ = self->priv->tile_size;
#line 119 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp2_ = _tmp4_ != _tmp5_;
#line 366 "taquin-view.c"
	}
#line 119 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp2_) {
#line 370 "taquin-view.c"
		gint _tmp6_ = 0;
		cairo_surface_t* surface = NULL;
		cairo_t* _tmp7_ = NULL;
		cairo_surface_t* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		cairo_surface_t* _tmp11_ = NULL;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp12_ = NULL;
		cairo_t* _tmp13_ = NULL;
		cairo_t* _tmp14_ = NULL;
		cairo_surface_t* _tmp15_ = NULL;
		cairo_pattern_t* _tmp16_ = NULL;
#line 121 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp6_ = self->priv->tile_size;
#line 121 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		self->priv->render_size = _tmp6_;
#line 122 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp7_ = cr;
#line 122 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp8_ = cairo_get_target (_tmp7_);
#line 122 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp9_ = self->priv->board_size;
#line 122 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp10_ = self->priv->board_size;
#line 122 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp11_ = cairo_surface_create_similar (_tmp8_, CAIRO_CONTENT_COLOR_ALPHA, _tmp9_, _tmp10_);
#line 122 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		surface = _tmp11_;
#line 123 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp12_ = surface;
#line 123 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp13_ = cairo_create (_tmp12_);
#line 123 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		c = _tmp13_;
#line 124 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp14_ = c;
#line 124 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		taquin_view_load_image (self, _tmp14_);
#line 125 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp15_ = surface;
#line 125 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp16_ = cairo_pattern_create_for_surface (_tmp15_);
#line 125 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 125 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		self->priv->tiles_pattern = _tmp16_;
#line 119 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_cairo_destroy0 (c);
#line 119 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_cairo_surface_destroy0 (surface);
#line 422 "taquin-view.c"
	}
#line 128 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp17_ = cr;
#line 128 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp18_ = taquin_view_get_x_offset (self);
#line 128 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp19_ = _tmp18_;
#line 128 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp20_ = taquin_view_get_y_offset (self);
#line 128 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp21_ = _tmp20_;
#line 128 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_translate (_tmp17_, (gdouble) _tmp19_, (gdouble) _tmp21_);
#line 129 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp22_ = cr;
#line 129 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_set_line_cap (_tmp22_, CAIRO_LINE_CAP_ROUND);
#line 130 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp23_ = cr;
#line 130 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_set_line_join (_tmp23_, CAIRO_LINE_JOIN_ROUND);
#line 133 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp24_ = cr;
#line 133 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_set_source_rgb (_tmp24_, 0.8, 0.8, 0.8);
#line 134 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp25_ = cr;
#line 134 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp26_ = self->priv->grid_border_main;
#line 134 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp27_ = self->priv->grid_border_main;
#line 134 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp28_ = self->priv->board_size;
#line 134 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp29_ = self->priv->grid_border_main;
#line 134 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp30_ = self->priv->board_size;
#line 134 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp31_ = self->priv->grid_border_main;
#line 134 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_rectangle (_tmp25_, _tmp26_ / 2.0, _tmp27_ / 2.0, (gdouble) (_tmp28_ + _tmp29_), (gdouble) (_tmp30_ + _tmp31_));
#line 135 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp32_ = cr;
#line 135 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_fill_preserve (_tmp32_);
#line 136 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp33_ = cr;
#line 136 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_set_source_rgb (_tmp33_, 0.3, 0.3, 0.3);
#line 137 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp34_ = cr;
#line 137 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp35_ = self->priv->grid_border_main;
#line 137 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_set_line_width (_tmp34_, (gdouble) _tmp35_);
#line 138 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp36_ = cr;
#line 138 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_stroke (_tmp36_);
#line 141 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp37_ = cr;
#line 141 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_set_source_rgb (_tmp37_, 0.1, 0.1, 0.1);
#line 142 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp38_ = cr;
#line 142 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp39_ = self->priv->grid_border_thin;
#line 142 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_set_line_width (_tmp38_, (gdouble) _tmp39_);
#line 143 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp40_ = cr;
#line 143 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp41_ = self->priv->grid_border_main;
#line 143 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp42_ = self->priv->grid_border_main;
#line 143 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp43_ = self->priv->grid_border_main;
#line 143 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp44_ = self->priv->grid_border_thin;
#line 143 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_arc (_tmp40_, _tmp41_ / 2.0, _tmp42_ / 2.0, (_tmp43_ - _tmp44_) / 2.0, G_PI, (G_PI * 3) / 2.0);
#line 144 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp45_ = cr;
#line 144 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp46_ = self->priv->grid_border_main;
#line 144 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp47_ = self->priv->board_size;
#line 144 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp48_ = self->priv->grid_border_main;
#line 144 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp49_ = self->priv->grid_border_main;
#line 144 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp50_ = self->priv->grid_border_thin;
#line 144 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_arc (_tmp45_, ((_tmp46_ * 3) / 2.0) + _tmp47_, _tmp48_ / 2.0, (_tmp49_ - _tmp50_) / 2.0, (G_PI * 3) / 2.0, (gdouble) 0);
#line 145 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp51_ = cr;
#line 145 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp52_ = self->priv->grid_border_main;
#line 145 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp53_ = self->priv->board_size;
#line 145 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp54_ = self->priv->grid_border_main;
#line 145 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp55_ = self->priv->board_size;
#line 145 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp56_ = self->priv->grid_border_main;
#line 145 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp57_ = self->priv->grid_border_thin;
#line 145 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_arc (_tmp51_, ((_tmp52_ * 3) / 2.0) + _tmp53_, ((_tmp54_ * 3) / 2.0) + _tmp55_, (_tmp56_ - _tmp57_) / 2.0, (gdouble) 0, G_PI / 2.0);
#line 146 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp58_ = cr;
#line 146 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp59_ = self->priv->grid_border_main;
#line 146 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp60_ = self->priv->grid_border_main;
#line 146 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp61_ = self->priv->board_size;
#line 146 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp62_ = self->priv->grid_border_main;
#line 146 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp63_ = self->priv->grid_border_thin;
#line 146 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_arc (_tmp58_, _tmp59_ / 2.0, ((_tmp60_ * 3) / 2.0) + _tmp61_, (_tmp62_ - _tmp63_) / 2.0, G_PI / 2.0, G_PI);
#line 147 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp64_ = cr;
#line 147 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp65_ = self->priv->grid_border_main;
#line 147 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp66_ = self->priv->grid_border_main;
#line 147 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp67_ = self->priv->grid_border_main;
#line 147 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp68_ = self->priv->grid_border_thin;
#line 147 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_arc (_tmp64_, _tmp65_ / 2.0, _tmp66_ / 2.0, (_tmp67_ - _tmp68_) / 2.0, G_PI, (G_PI * 3) / 2.0);
#line 148 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp69_ = cr;
#line 148 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_stroke (_tmp69_);
#line 151 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp70_ = cr;
#line 151 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp71_ = self->priv->animation_end_offset;
#line 151 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_set_source_rgba (_tmp70_, 0.25, 0.25, 0.25, 1.0 - _tmp71_);
#line 152 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp72_ = cr;
#line 152 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp73_ = self->priv->arrows;
#line 152 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_set_line_width (_tmp72_, (gdouble) _tmp73_);
#line 153 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp74_ = taquin_view_get_game (self);
#line 153 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp75_ = _tmp74_;
#line 153 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp76_ = game_get_game_type (_tmp75_);
#line 153 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp77_ = _tmp76_;
#line 153 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp77_ == GAME_TYPE_SIXTEEN) {
#line 586 "taquin-view.c"
		gboolean _tmp78_ = FALSE;
		cairo_t* _tmp80_ = NULL;
#line 155 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp78_ = self->priv->draw_lights;
#line 155 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		if (_tmp78_) {
#line 593 "taquin-view.c"
			cairo_t* _tmp79_ = NULL;
#line 156 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp79_ = cr;
#line 156 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			taquin_view_draw_movable_lights (self, _tmp79_);
#line 599 "taquin-view.c"
		}
#line 157 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp80_ = cr;
#line 157 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		taquin_view_draw_fixed_arrows (self, _tmp80_);
#line 605 "taquin-view.c"
	} else {
		cairo_t* _tmp81_ = NULL;
#line 160 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp81_ = cr;
#line 160 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		taquin_view_draw_movable_arrows (self, _tmp81_);
#line 612 "taquin-view.c"
	}
#line 161 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp82_ = cr;
#line 161 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_stroke (_tmp82_);
#line 164 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp83_ = cr;
#line 164 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_save (_tmp83_);
#line 165 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp84_ = cr;
#line 165 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp85_ = self->priv->grid_border_main;
#line 165 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp86_ = self->priv->grid_border_main;
#line 165 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_translate (_tmp84_, (gdouble) _tmp85_, (gdouble) _tmp86_);
#line 167 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp88_ = self->priv->animate;
#line 167 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp88_) {
#line 634 "taquin-view.c"
		Game* _tmp89_ = NULL;
		Game* _tmp90_ = NULL;
		GameType _tmp91_ = 0;
		GameType _tmp92_ = 0;
#line 167 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp89_ = taquin_view_get_game (self);
#line 167 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp90_ = _tmp89_;
#line 167 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp91_ = game_get_game_type (_tmp90_);
#line 167 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp92_ = _tmp91_;
#line 167 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp87_ = _tmp92_ == GAME_TYPE_SIXTEEN;
#line 649 "taquin-view.c"
	} else {
#line 167 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp87_ = FALSE;
#line 653 "taquin-view.c"
	}
#line 167 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp87_) {
#line 657 "taquin-view.c"
		gint texture_x = 0;
		Game* _tmp93_ = NULL;
		Game* _tmp94_ = NULL;
		gint* _tmp95_ = NULL;
		gint _tmp95__length1 = 0;
		gint _tmp95__length2 = 0;
		gint* _tmp96_ = NULL;
		gint _tmp96__length1 = 0;
		gint _tmp96__length2 = 0;
		gint _tmp97_ = 0;
		gint _tmp98_ = 0;
		gint _tmp99_ = 0;
		Game* _tmp100_ = NULL;
		Game* _tmp101_ = NULL;
		gint _tmp102_ = 0;
		gint _tmp103_ = 0;
		gint _tmp104_ = 0;
		gint texture_y = 0;
		Game* _tmp105_ = NULL;
		Game* _tmp106_ = NULL;
		gint* _tmp107_ = NULL;
		gint _tmp107__length1 = 0;
		gint _tmp107__length2 = 0;
		gint* _tmp108_ = NULL;
		gint _tmp108__length1 = 0;
		gint _tmp108__length2 = 0;
		gint _tmp109_ = 0;
		gint _tmp110_ = 0;
		gint _tmp111_ = 0;
		Game* _tmp112_ = NULL;
		Game* _tmp113_ = NULL;
		gint _tmp114_ = 0;
		gint _tmp115_ = 0;
		gint _tmp116_ = 0;
		gint tile_x = 0;
		gint _tmp117_ = 0;
		gint _tmp118_ = 0;
		gint tile_y = 0;
		gint _tmp119_ = 0;
		gint _tmp120_ = 0;
		cairo_matrix_t matrix = {0};
		gint _tmp121_ = 0;
		gint _tmp122_ = 0;
		gint _tmp123_ = 0;
		gint _tmp124_ = 0;
		cairo_pattern_t* _tmp125_ = NULL;
		cairo_matrix_t _tmp126_ = {0};
		cairo_t* _tmp127_ = NULL;
		cairo_pattern_t* _tmp128_ = NULL;
		cairo_t* _tmp129_ = NULL;
		gint _tmp130_ = 0;
		gint _tmp131_ = 0;
		gint _tmp132_ = 0;
		gint _tmp133_ = 0;
		cairo_t* _tmp134_ = NULL;
		gint _tmp135_ = 0;
		gboolean _tmp136_ = FALSE;
		gint _tmp144_ = 0;
		gint _tmp145_ = 0;
		gboolean _tmp146_ = FALSE;
		gint _tmp154_ = 0;
		gint _tmp155_ = 0;
		gint _tmp156_ = 0;
		gint _tmp157_ = 0;
		gint _tmp158_ = 0;
		cairo_pattern_t* _tmp159_ = NULL;
		cairo_matrix_t _tmp160_ = {0};
		cairo_t* _tmp161_ = NULL;
		cairo_pattern_t* _tmp162_ = NULL;
		cairo_t* _tmp163_ = NULL;
		gint _tmp164_ = 0;
		gint _tmp165_ = 0;
		gint _tmp166_ = 0;
		gint _tmp167_ = 0;
		cairo_t* _tmp168_ = NULL;
#line 169 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp93_ = taquin_view_get_game (self);
#line 169 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp94_ = _tmp93_;
#line 169 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp95_ = game_get_tiles (_tmp94_, &_tmp95__length1, &_tmp95__length2);
#line 169 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp96_ = _tmp95_;
#line 169 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp96__length1 = _tmp95__length1;
#line 169 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp96__length2 = _tmp95__length2;
#line 169 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp97_ = self->priv->x_gap;
#line 169 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp98_ = self->priv->y_gap;
#line 169 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp99_ = _tmp96_[(_tmp97_ * _tmp96__length2) + _tmp98_];
#line 169 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp100_ = taquin_view_get_game (self);
#line 169 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp101_ = _tmp100_;
#line 169 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp102_ = game_get_size (_tmp101_);
#line 169 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp103_ = _tmp102_;
#line 169 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp104_ = self->priv->tile_size;
#line 169 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		texture_x = (_tmp99_ % _tmp103_) * _tmp104_;
#line 170 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp105_ = taquin_view_get_game (self);
#line 170 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp106_ = _tmp105_;
#line 170 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp107_ = game_get_tiles (_tmp106_, &_tmp107__length1, &_tmp107__length2);
#line 170 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp108_ = _tmp107_;
#line 170 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp108__length1 = _tmp107__length1;
#line 170 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp108__length2 = _tmp107__length2;
#line 170 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp109_ = self->priv->x_gap;
#line 170 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp110_ = self->priv->y_gap;
#line 170 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp111_ = _tmp108_[(_tmp109_ * _tmp108__length2) + _tmp110_];
#line 170 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp112_ = taquin_view_get_game (self);
#line 170 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp113_ = _tmp112_;
#line 170 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp114_ = game_get_size (_tmp113_);
#line 170 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp115_ = _tmp114_;
#line 170 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp116_ = self->priv->tile_size;
#line 170 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		texture_y = (_tmp111_ / _tmp115_) * _tmp116_;
#line 173 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp117_ = self->priv->x_gap;
#line 173 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp118_ = self->priv->tile_size;
#line 173 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		tile_x = _tmp117_ * _tmp118_;
#line 174 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp119_ = self->priv->y_gap;
#line 174 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp120_ = self->priv->tile_size;
#line 174 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		tile_y = _tmp119_ * _tmp120_;
#line 176 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		cairo_matrix_init_identity (&matrix);
#line 177 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp121_ = texture_x;
#line 177 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp122_ = tile_x;
#line 177 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp123_ = texture_y;
#line 177 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp124_ = tile_y;
#line 177 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		cairo_matrix_translate (&matrix, (gdouble) (_tmp121_ - _tmp122_), (gdouble) (_tmp123_ - _tmp124_));
#line 178 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp125_ = self->priv->tiles_pattern;
#line 178 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp126_ = matrix;
#line 178 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		cairo_pattern_set_matrix (_tmp125_, &_tmp126_);
#line 179 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp127_ = cr;
#line 179 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp128_ = self->priv->tiles_pattern;
#line 179 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		cairo_set_source (_tmp127_, _tmp128_);
#line 180 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp129_ = cr;
#line 180 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp130_ = tile_x;
#line 180 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp131_ = tile_y;
#line 180 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp132_ = self->priv->tile_size;
#line 180 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp133_ = self->priv->tile_size;
#line 180 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		cairo_rectangle (_tmp129_, (gdouble) _tmp130_, (gdouble) _tmp131_, (gdouble) (_tmp132_ - TAQUIN_VIEW_GRID_SPACING), (gdouble) (_tmp133_ - TAQUIN_VIEW_GRID_SPACING));
#line 181 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp134_ = cr;
#line 181 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		cairo_fill (_tmp134_);
#line 184 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp136_ = self->priv->x_axis;
#line 184 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		if (_tmp136_) {
#line 849 "taquin-view.c"
			gint _tmp137_ = 0;
			gint _tmp138_ = 0;
#line 184 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp138_ = self->priv->x_gap;
#line 184 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			if (_tmp138_ == 0) {
#line 856 "taquin-view.c"
				Game* _tmp139_ = NULL;
				Game* _tmp140_ = NULL;
				gint _tmp141_ = 0;
				gint _tmp142_ = 0;
#line 184 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp139_ = taquin_view_get_game (self);
#line 184 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp140_ = _tmp139_;
#line 184 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp141_ = game_get_size (_tmp140_);
#line 184 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp142_ = _tmp141_;
#line 184 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp137_ = _tmp142_ - 1;
#line 871 "taquin-view.c"
			} else {
#line 184 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp137_ = 0;
#line 875 "taquin-view.c"
			}
#line 184 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp135_ = _tmp137_;
#line 879 "taquin-view.c"
		} else {
			gint _tmp143_ = 0;
#line 184 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp143_ = self->priv->x_gap;
#line 184 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp135_ = _tmp143_;
#line 886 "taquin-view.c"
		}
#line 184 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp144_ = self->priv->tile_size;
#line 184 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		tile_x = _tmp144_ * _tmp135_;
#line 185 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp146_ = self->priv->x_axis;
#line 185 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		if (_tmp146_) {
#line 896 "taquin-view.c"
			gint _tmp147_ = 0;
#line 185 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp147_ = self->priv->y_gap;
#line 185 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp145_ = _tmp147_;
#line 902 "taquin-view.c"
		} else {
			gint _tmp148_ = 0;
			gint _tmp149_ = 0;
#line 185 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp149_ = self->priv->y_gap;
#line 185 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			if (_tmp149_ == 0) {
#line 910 "taquin-view.c"
				Game* _tmp150_ = NULL;
				Game* _tmp151_ = NULL;
				gint _tmp152_ = 0;
				gint _tmp153_ = 0;
#line 185 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp150_ = taquin_view_get_game (self);
#line 185 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp151_ = _tmp150_;
#line 185 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp152_ = game_get_size (_tmp151_);
#line 185 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp153_ = _tmp152_;
#line 185 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp148_ = _tmp153_ - 1;
#line 925 "taquin-view.c"
			} else {
#line 185 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp148_ = 0;
#line 929 "taquin-view.c"
			}
#line 185 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp145_ = _tmp148_;
#line 933 "taquin-view.c"
		}
#line 185 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp154_ = self->priv->tile_size;
#line 185 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		tile_y = _tmp154_ * _tmp145_;
#line 187 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		cairo_matrix_init_identity (&matrix);
#line 188 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp155_ = texture_x;
#line 188 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp156_ = tile_x;
#line 188 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp157_ = texture_y;
#line 188 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp158_ = tile_y;
#line 188 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		cairo_matrix_translate (&matrix, (gdouble) (_tmp155_ - _tmp156_), (gdouble) (_tmp157_ - _tmp158_));
#line 189 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp159_ = self->priv->tiles_pattern;
#line 189 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp160_ = matrix;
#line 189 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		cairo_pattern_set_matrix (_tmp159_, &_tmp160_);
#line 190 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp161_ = cr;
#line 190 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp162_ = self->priv->tiles_pattern;
#line 190 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		cairo_set_source (_tmp161_, _tmp162_);
#line 191 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp163_ = cr;
#line 191 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp164_ = tile_x;
#line 191 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp165_ = tile_y;
#line 191 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp166_ = self->priv->tile_size;
#line 191 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp167_ = self->priv->tile_size;
#line 191 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		cairo_rectangle (_tmp163_, (gdouble) _tmp164_, (gdouble) _tmp165_, (gdouble) (_tmp166_ - TAQUIN_VIEW_GRID_SPACING), (gdouble) (_tmp167_ - TAQUIN_VIEW_GRID_SPACING));
#line 192 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp168_ = cr;
#line 192 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		cairo_fill (_tmp168_);
#line 979 "taquin-view.c"
	}
	{
		gint y = 0;
#line 195 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		y = 0;
#line 985 "taquin-view.c"
		{
			gboolean _tmp169_ = FALSE;
#line 195 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp169_ = TRUE;
#line 195 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			while (TRUE) {
#line 992 "taquin-view.c"
				gint _tmp171_ = 0;
				Game* _tmp172_ = NULL;
				Game* _tmp173_ = NULL;
				gint _tmp174_ = 0;
				gint _tmp175_ = 0;
#line 195 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				if (!_tmp169_) {
#line 1000 "taquin-view.c"
					gint _tmp170_ = 0;
#line 195 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp170_ = y;
#line 195 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					y = _tmp170_ + 1;
#line 1006 "taquin-view.c"
				}
#line 195 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp169_ = FALSE;
#line 195 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp171_ = y;
#line 195 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp172_ = taquin_view_get_game (self);
#line 195 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp173_ = _tmp172_;
#line 195 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp174_ = game_get_size (_tmp173_);
#line 195 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp175_ = _tmp174_;
#line 195 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				if (!(_tmp171_ < _tmp175_)) {
#line 195 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					break;
#line 1024 "taquin-view.c"
				}
				{
					gint x = 0;
#line 197 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					x = 0;
#line 1030 "taquin-view.c"
					{
						gboolean _tmp176_ = FALSE;
#line 197 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
						_tmp176_ = TRUE;
#line 197 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
						while (TRUE) {
#line 1037 "taquin-view.c"
							gint _tmp178_ = 0;
							Game* _tmp179_ = NULL;
							Game* _tmp180_ = NULL;
							gint _tmp181_ = 0;
							gint _tmp182_ = 0;
							gboolean _tmp183_ = FALSE;
							gboolean _tmp184_ = FALSE;
							gboolean _tmp185_ = FALSE;
							gint tile_x = 0;
							gint _tmp190_ = 0;
							gint _tmp191_ = 0;
							gint tile_y = 0;
							gint _tmp192_ = 0;
							gint _tmp193_ = 0;
							gboolean _tmp194_ = FALSE;
							gboolean _tmp195_ = FALSE;
							gint texture_x = 0;
							Game* _tmp253_ = NULL;
							Game* _tmp254_ = NULL;
							gint* _tmp255_ = NULL;
							gint _tmp255__length1 = 0;
							gint _tmp255__length2 = 0;
							gint* _tmp256_ = NULL;
							gint _tmp256__length1 = 0;
							gint _tmp256__length2 = 0;
							gint _tmp257_ = 0;
							gint _tmp258_ = 0;
							gint _tmp259_ = 0;
							Game* _tmp260_ = NULL;
							Game* _tmp261_ = NULL;
							gint _tmp262_ = 0;
							gint _tmp263_ = 0;
							gint _tmp264_ = 0;
							gint texture_y = 0;
							Game* _tmp265_ = NULL;
							Game* _tmp266_ = NULL;
							gint* _tmp267_ = NULL;
							gint _tmp267__length1 = 0;
							gint _tmp267__length2 = 0;
							gint* _tmp268_ = NULL;
							gint _tmp268__length1 = 0;
							gint _tmp268__length2 = 0;
							gint _tmp269_ = 0;
							gint _tmp270_ = 0;
							gint _tmp271_ = 0;
							Game* _tmp272_ = NULL;
							Game* _tmp273_ = NULL;
							gint _tmp274_ = 0;
							gint _tmp275_ = 0;
							gint _tmp276_ = 0;
							cairo_matrix_t matrix = {0};
							gint _tmp277_ = 0;
							gint _tmp278_ = 0;
							gint _tmp279_ = 0;
							gint _tmp280_ = 0;
							cairo_pattern_t* _tmp281_ = NULL;
							cairo_matrix_t _tmp282_ = {0};
							cairo_t* _tmp283_ = NULL;
							cairo_pattern_t* _tmp284_ = NULL;
							cairo_t* _tmp285_ = NULL;
							gint _tmp286_ = 0;
							gint _tmp287_ = 0;
							gint _tmp288_ = 0;
							gint _tmp289_ = 0;
							cairo_t* _tmp290_ = NULL;
#line 197 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							if (!_tmp176_) {
#line 1105 "taquin-view.c"
								gint _tmp177_ = 0;
#line 197 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								_tmp177_ = x;
#line 197 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								x = _tmp177_ + 1;
#line 1111 "taquin-view.c"
							}
#line 197 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp176_ = FALSE;
#line 197 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp178_ = x;
#line 197 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp179_ = taquin_view_get_game (self);
#line 197 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp180_ = _tmp179_;
#line 197 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp181_ = game_get_size (_tmp180_);
#line 197 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp182_ = _tmp181_;
#line 197 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							if (!(_tmp178_ < _tmp182_)) {
#line 197 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								break;
#line 1129 "taquin-view.c"
							}
#line 199 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp185_ = self->priv->animate;
#line 199 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							if (_tmp185_) {
#line 1135 "taquin-view.c"
								gint _tmp186_ = 0;
								gint _tmp187_ = 0;
#line 199 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								_tmp186_ = x;
#line 199 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								_tmp187_ = self->priv->x_gap;
#line 199 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								_tmp184_ = _tmp186_ == _tmp187_;
#line 1144 "taquin-view.c"
							} else {
#line 199 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								_tmp184_ = FALSE;
#line 1148 "taquin-view.c"
							}
#line 199 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							if (_tmp184_) {
#line 1152 "taquin-view.c"
								gint _tmp188_ = 0;
								gint _tmp189_ = 0;
#line 199 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								_tmp188_ = y;
#line 199 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								_tmp189_ = self->priv->y_gap;
#line 199 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								_tmp183_ = _tmp188_ == _tmp189_;
#line 1161 "taquin-view.c"
							} else {
#line 199 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								_tmp183_ = FALSE;
#line 1165 "taquin-view.c"
							}
#line 199 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							if (_tmp183_) {
#line 200 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								continue;
#line 1171 "taquin-view.c"
							}
#line 202 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp190_ = x;
#line 202 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp191_ = self->priv->tile_size;
#line 202 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							tile_x = _tmp190_ * _tmp191_;
#line 203 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp192_ = y;
#line 203 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp193_ = self->priv->tile_size;
#line 203 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							tile_y = _tmp192_ * _tmp193_;
#line 205 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp195_ = self->priv->animate;
#line 205 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							if (_tmp195_) {
#line 1189 "taquin-view.c"
								gboolean _tmp196_ = FALSE;
								gint _tmp197_ = 0;
								gint _tmp198_ = 0;
#line 205 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								_tmp197_ = x;
#line 205 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								_tmp198_ = self->priv->x_gap;
#line 205 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								if (_tmp197_ != _tmp198_) {
#line 205 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
									_tmp196_ = TRUE;
#line 1201 "taquin-view.c"
								} else {
									gint _tmp199_ = 0;
									gint _tmp200_ = 0;
#line 205 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
									_tmp199_ = y;
#line 205 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
									_tmp200_ = self->priv->y_gap;
#line 205 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
									_tmp196_ = _tmp199_ != _tmp200_;
#line 1211 "taquin-view.c"
								}
#line 205 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								_tmp194_ = _tmp196_;
#line 1215 "taquin-view.c"
							} else {
#line 205 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								_tmp194_ = FALSE;
#line 1219 "taquin-view.c"
							}
#line 205 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							if (_tmp194_) {
#line 1223 "taquin-view.c"
								gboolean _tmp201_ = FALSE;
								gboolean _tmp202_ = FALSE;
#line 207 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								_tmp202_ = self->priv->x_axis;
#line 207 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								if (_tmp202_) {
#line 1230 "taquin-view.c"
									gint _tmp203_ = 0;
									gint _tmp204_ = 0;
#line 207 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
									_tmp203_ = y;
#line 207 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
									_tmp204_ = self->priv->y_gap;
#line 207 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
									_tmp201_ = _tmp203_ == _tmp204_;
#line 1239 "taquin-view.c"
								} else {
#line 207 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
									_tmp201_ = FALSE;
#line 1243 "taquin-view.c"
								}
#line 207 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
								if (_tmp201_) {
#line 1247 "taquin-view.c"
									gboolean _tmp205_ = FALSE;
									gboolean _tmp206_ = FALSE;
									gint _tmp207_ = 0;
#line 209 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
									_tmp207_ = self->priv->number;
#line 209 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
									if (_tmp207_ > 0) {
#line 1255 "taquin-view.c"
										gint _tmp208_ = 0;
										gint _tmp209_ = 0;
										gint _tmp210_ = 0;
#line 209 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp208_ = x;
#line 209 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp209_ = self->priv->x_gap;
#line 209 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp210_ = self->priv->number;
#line 209 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp206_ = _tmp208_ <= (_tmp209_ + _tmp210_);
#line 1267 "taquin-view.c"
									} else {
#line 209 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp206_ = FALSE;
#line 1271 "taquin-view.c"
									}
#line 209 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
									if (_tmp206_) {
#line 1275 "taquin-view.c"
										gint _tmp211_ = 0;
										gint _tmp212_ = 0;
#line 209 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp211_ = x;
#line 209 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp212_ = self->priv->x_gap;
#line 209 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp205_ = _tmp211_ >= _tmp212_;
#line 1284 "taquin-view.c"
									} else {
#line 209 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp205_ = FALSE;
#line 1288 "taquin-view.c"
									}
#line 209 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
									if (_tmp205_) {
#line 1292 "taquin-view.c"
										gint _tmp213_ = 0;
										gint _tmp214_ = 0;
										gint _tmp215_ = 0;
#line 210 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp213_ = tile_x;
#line 210 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp214_ = self->priv->tile_size;
#line 210 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp215_ = self->priv->animation_offset;
#line 210 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										tile_x = _tmp213_ - (_tmp214_ - _tmp215_);
#line 1304 "taquin-view.c"
									} else {
										gboolean _tmp216_ = FALSE;
										gboolean _tmp217_ = FALSE;
										gint _tmp218_ = 0;
#line 211 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp218_ = self->priv->number;
#line 211 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										if (_tmp218_ < 0) {
#line 1313 "taquin-view.c"
											gint _tmp219_ = 0;
											gint _tmp220_ = 0;
											gint _tmp221_ = 0;
#line 211 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp219_ = x;
#line 211 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp220_ = self->priv->x_gap;
#line 211 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp221_ = self->priv->number;
#line 211 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp217_ = _tmp219_ >= (_tmp220_ + _tmp221_);
#line 1325 "taquin-view.c"
										} else {
#line 211 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp217_ = FALSE;
#line 1329 "taquin-view.c"
										}
#line 211 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										if (_tmp217_) {
#line 1333 "taquin-view.c"
											gint _tmp222_ = 0;
											gint _tmp223_ = 0;
#line 211 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp222_ = x;
#line 211 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp223_ = self->priv->x_gap;
#line 211 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp216_ = _tmp222_ <= _tmp223_;
#line 1342 "taquin-view.c"
										} else {
#line 211 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp216_ = FALSE;
#line 1346 "taquin-view.c"
										}
#line 211 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										if (_tmp216_) {
#line 1350 "taquin-view.c"
											gint _tmp224_ = 0;
											gint _tmp225_ = 0;
											gint _tmp226_ = 0;
#line 212 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp224_ = tile_x;
#line 212 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp225_ = self->priv->tile_size;
#line 212 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp226_ = self->priv->animation_offset;
#line 212 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											tile_x = _tmp224_ + (_tmp225_ - _tmp226_);
#line 1362 "taquin-view.c"
										}
									}
								} else {
									gboolean _tmp227_ = FALSE;
									gboolean _tmp228_ = FALSE;
#line 214 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
									_tmp228_ = self->priv->x_axis;
#line 214 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
									if (!_tmp228_) {
#line 1372 "taquin-view.c"
										gint _tmp229_ = 0;
										gint _tmp230_ = 0;
#line 214 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp229_ = x;
#line 214 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp230_ = self->priv->x_gap;
#line 214 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp227_ = _tmp229_ == _tmp230_;
#line 1381 "taquin-view.c"
									} else {
#line 214 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp227_ = FALSE;
#line 1385 "taquin-view.c"
									}
#line 214 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
									if (_tmp227_) {
#line 1389 "taquin-view.c"
										gboolean _tmp231_ = FALSE;
										gboolean _tmp232_ = FALSE;
										gint _tmp233_ = 0;
#line 216 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										_tmp233_ = self->priv->number;
#line 216 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										if (_tmp233_ > 0) {
#line 1397 "taquin-view.c"
											gint _tmp234_ = 0;
											gint _tmp235_ = 0;
											gint _tmp236_ = 0;
#line 216 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp234_ = y;
#line 216 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp235_ = self->priv->y_gap;
#line 216 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp236_ = self->priv->number;
#line 216 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp232_ = _tmp234_ <= (_tmp235_ + _tmp236_);
#line 1409 "taquin-view.c"
										} else {
#line 216 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp232_ = FALSE;
#line 1413 "taquin-view.c"
										}
#line 216 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										if (_tmp232_) {
#line 1417 "taquin-view.c"
											gint _tmp237_ = 0;
											gint _tmp238_ = 0;
#line 216 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp237_ = y;
#line 216 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp238_ = self->priv->y_gap;
#line 216 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp231_ = _tmp237_ >= _tmp238_;
#line 1426 "taquin-view.c"
										} else {
#line 216 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp231_ = FALSE;
#line 1430 "taquin-view.c"
										}
#line 216 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
										if (_tmp231_) {
#line 1434 "taquin-view.c"
											gint _tmp239_ = 0;
											gint _tmp240_ = 0;
											gint _tmp241_ = 0;
#line 217 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp239_ = tile_y;
#line 217 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp240_ = self->priv->tile_size;
#line 217 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp241_ = self->priv->animation_offset;
#line 217 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											tile_y = _tmp239_ - (_tmp240_ - _tmp241_);
#line 1446 "taquin-view.c"
										} else {
											gboolean _tmp242_ = FALSE;
											gboolean _tmp243_ = FALSE;
											gint _tmp244_ = 0;
#line 218 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											_tmp244_ = self->priv->number;
#line 218 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											if (_tmp244_ < 0) {
#line 1455 "taquin-view.c"
												gint _tmp245_ = 0;
												gint _tmp246_ = 0;
												gint _tmp247_ = 0;
#line 218 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
												_tmp245_ = y;
#line 218 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
												_tmp246_ = self->priv->y_gap;
#line 218 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
												_tmp247_ = self->priv->number;
#line 218 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
												_tmp243_ = _tmp245_ >= (_tmp246_ + _tmp247_);
#line 1467 "taquin-view.c"
											} else {
#line 218 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
												_tmp243_ = FALSE;
#line 1471 "taquin-view.c"
											}
#line 218 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											if (_tmp243_) {
#line 1475 "taquin-view.c"
												gint _tmp248_ = 0;
												gint _tmp249_ = 0;
#line 218 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
												_tmp248_ = y;
#line 218 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
												_tmp249_ = self->priv->y_gap;
#line 218 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
												_tmp242_ = _tmp248_ <= _tmp249_;
#line 1484 "taquin-view.c"
											} else {
#line 218 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
												_tmp242_ = FALSE;
#line 1488 "taquin-view.c"
											}
#line 218 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
											if (_tmp242_) {
#line 1492 "taquin-view.c"
												gint _tmp250_ = 0;
												gint _tmp251_ = 0;
												gint _tmp252_ = 0;
#line 219 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
												_tmp250_ = tile_y;
#line 219 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
												_tmp251_ = self->priv->tile_size;
#line 219 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
												_tmp252_ = self->priv->animation_offset;
#line 219 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
												tile_y = _tmp250_ + (_tmp251_ - _tmp252_);
#line 1504 "taquin-view.c"
											}
										}
									}
								}
							}
#line 223 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp253_ = taquin_view_get_game (self);
#line 223 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp254_ = _tmp253_;
#line 223 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp255_ = game_get_tiles (_tmp254_, &_tmp255__length1, &_tmp255__length2);
#line 223 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp256_ = _tmp255_;
#line 223 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp256__length1 = _tmp255__length1;
#line 223 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp256__length2 = _tmp255__length2;
#line 223 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp257_ = x;
#line 223 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp258_ = y;
#line 223 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp259_ = _tmp256_[(_tmp257_ * _tmp256__length2) + _tmp258_];
#line 223 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp260_ = taquin_view_get_game (self);
#line 223 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp261_ = _tmp260_;
#line 223 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp262_ = game_get_size (_tmp261_);
#line 223 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp263_ = _tmp262_;
#line 223 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp264_ = self->priv->tile_size;
#line 223 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							texture_x = (_tmp259_ % _tmp263_) * _tmp264_;
#line 224 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp265_ = taquin_view_get_game (self);
#line 224 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp266_ = _tmp265_;
#line 224 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp267_ = game_get_tiles (_tmp266_, &_tmp267__length1, &_tmp267__length2);
#line 224 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp268_ = _tmp267_;
#line 224 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp268__length1 = _tmp267__length1;
#line 224 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp268__length2 = _tmp267__length2;
#line 224 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp269_ = x;
#line 224 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp270_ = y;
#line 224 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp271_ = _tmp268_[(_tmp269_ * _tmp268__length2) + _tmp270_];
#line 224 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp272_ = taquin_view_get_game (self);
#line 224 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp273_ = _tmp272_;
#line 224 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp274_ = game_get_size (_tmp273_);
#line 224 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp275_ = _tmp274_;
#line 224 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp276_ = self->priv->tile_size;
#line 224 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							texture_y = (_tmp271_ / _tmp275_) * _tmp276_;
#line 226 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							cairo_matrix_init_identity (&matrix);
#line 227 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp277_ = texture_x;
#line 227 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp278_ = tile_x;
#line 227 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp279_ = texture_y;
#line 227 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp280_ = tile_y;
#line 227 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							cairo_matrix_translate (&matrix, (gdouble) (_tmp277_ - _tmp278_), (gdouble) (_tmp279_ - _tmp280_));
#line 228 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp281_ = self->priv->tiles_pattern;
#line 228 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp282_ = matrix;
#line 228 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							cairo_pattern_set_matrix (_tmp281_, &_tmp282_);
#line 229 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp283_ = cr;
#line 229 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp284_ = self->priv->tiles_pattern;
#line 229 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							cairo_set_source (_tmp283_, _tmp284_);
#line 230 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp285_ = cr;
#line 230 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp286_ = tile_x;
#line 230 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp287_ = tile_y;
#line 230 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp288_ = self->priv->tile_size;
#line 230 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp289_ = self->priv->tile_size;
#line 230 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							cairo_rectangle (_tmp285_, (gdouble) _tmp286_, (gdouble) _tmp287_, (gdouble) (_tmp288_ - TAQUIN_VIEW_GRID_SPACING), (gdouble) (_tmp289_ - TAQUIN_VIEW_GRID_SPACING));
#line 231 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							_tmp290_ = cr;
#line 231 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
							cairo_fill (_tmp290_);
#line 1610 "taquin-view.c"
						}
					}
				}
			}
		}
	}
#line 235 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp291_ = self->priv->animate_end;
#line 235 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp291_) {
#line 1621 "taquin-view.c"
		gdouble _tmp292_ = 0.0;
		gdouble _tmp293_ = 0.0;
		cairo_matrix_t matrix = {0};
		cairo_pattern_t* _tmp294_ = NULL;
		cairo_matrix_t _tmp295_ = {0};
		cairo_t* _tmp296_ = NULL;
		gdouble _tmp297_ = 0.0;
		gdouble _tmp298_ = 0.0;
#line 237 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp292_ = self->priv->animation_end_offset;
#line 237 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		self->priv->animation_end_offset = _tmp292_ + 0.01;
#line 238 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp293_ = self->priv->animation_end_offset;
#line 238 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		if (_tmp293_ >= ((gdouble) 1)) {
#line 239 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			self->priv->animation_end_offset = (gdouble) 1;
#line 1640 "taquin-view.c"
		}
#line 240 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		cairo_matrix_init_identity (&matrix);
#line 241 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp294_ = self->priv->tiles_pattern;
#line 241 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp295_ = matrix;
#line 241 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		cairo_pattern_set_matrix (_tmp294_, &_tmp295_);
#line 242 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp296_ = cr;
#line 242 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp297_ = self->priv->animation_end_offset;
#line 242 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		cairo_paint_with_alpha (_tmp296_, _tmp297_);
#line 243 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp298_ = self->priv->animation_end_offset;
#line 243 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		if (_tmp298_ != ((gdouble) 1)) {
#line 244 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			gtk_widget_queue_draw ((GtkWidget*) self);
#line 1662 "taquin-view.c"
		}
	}
#line 246 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp299_ = cr;
#line 246 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_restore (_tmp299_);
#line 248 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp300_ = self->priv->animate;
#line 248 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp300_) {
#line 1673 "taquin-view.c"
		gint _tmp301_ = 0;
		gboolean _tmp302_ = FALSE;
		gint _tmp337_ = 0;
		gint _tmp338_ = 0;
#line 250 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp301_ = self->priv->animation_offset;
#line 250 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		self->priv->animation_offset = _tmp301_ + 8;
#line 251 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp302_ = self->priv->x_axis;
#line 251 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		if (_tmp302_) {
#line 1686 "taquin-view.c"
			gint _tmp303_ = 0;
			gint _tmp304_ = 0;
			gint _tmp305_ = 0;
			gint _tmp306_ = 0;
			gint _tmp307_ = 0;
			gint _tmp308_ = 0;
			gint _tmp309_ = 0;
			gint _tmp310_ = 0;
			gint _tmp311_ = 0;
			gint _tmp312_ = 0;
			gint _tmp313_ = 0;
			gint _tmp314_ = 0;
			gint _tmp315_ = 0;
			gint _tmp316_ = 0;
			gint _tmp317_ = 0;
			gint _tmp318_ = 0;
			gint _tmp319_ = 0;
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp303_ = taquin_view_get_x_offset (self);
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp304_ = _tmp303_;
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp305_ = self->priv->grid_border_main;
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp306_ = self->priv->tile_size;
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp307_ = self->priv->x_gap;
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp308_ = self->priv->x_gap;
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp309_ = self->priv->number;
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp310_ = MIN (_tmp307_, _tmp308_ + _tmp309_);
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp311_ = taquin_view_get_y_offset (self);
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp312_ = _tmp311_;
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp313_ = self->priv->grid_border_main;
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp314_ = self->priv->tile_size;
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp315_ = self->priv->y_gap;
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp316_ = self->priv->tile_size;
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp317_ = self->priv->number;
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp318_ = abs (_tmp317_);
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp319_ = self->priv->tile_size;
#line 252 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			gtk_widget_queue_draw_area ((GtkWidget*) self, (_tmp304_ + _tmp305_) + (_tmp306_ * _tmp310_), (_tmp312_ + _tmp313_) + (_tmp314_ * _tmp315_), _tmp316_ * (_tmp318_ + 1), _tmp319_);
#line 1740 "taquin-view.c"
		} else {
			gint _tmp320_ = 0;
			gint _tmp321_ = 0;
			gint _tmp322_ = 0;
			gint _tmp323_ = 0;
			gint _tmp324_ = 0;
			gint _tmp325_ = 0;
			gint _tmp326_ = 0;
			gint _tmp327_ = 0;
			gint _tmp328_ = 0;
			gint _tmp329_ = 0;
			gint _tmp330_ = 0;
			gint _tmp331_ = 0;
			gint _tmp332_ = 0;
			gint _tmp333_ = 0;
			gint _tmp334_ = 0;
			gint _tmp335_ = 0;
			gint _tmp336_ = 0;
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp320_ = taquin_view_get_x_offset (self);
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp321_ = _tmp320_;
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp322_ = self->priv->grid_border_main;
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp323_ = self->priv->tile_size;
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp324_ = self->priv->x_gap;
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp325_ = taquin_view_get_y_offset (self);
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp326_ = _tmp325_;
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp327_ = self->priv->grid_border_main;
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp328_ = self->priv->tile_size;
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp329_ = self->priv->y_gap;
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp330_ = self->priv->y_gap;
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp331_ = self->priv->number;
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp332_ = MIN (_tmp329_, _tmp330_ + _tmp331_);
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp333_ = self->priv->tile_size;
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp334_ = self->priv->tile_size;
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp335_ = self->priv->number;
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp336_ = abs (_tmp335_);
#line 257 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			gtk_widget_queue_draw_area ((GtkWidget*) self, (_tmp321_ + _tmp322_) + (_tmp323_ * _tmp324_), (_tmp326_ + _tmp327_) + (_tmp328_ * _tmp332_), _tmp333_, _tmp334_ * (_tmp336_ + 1));
#line 1795 "taquin-view.c"
		}
#line 261 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp337_ = self->priv->animation_offset;
#line 261 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp338_ = self->priv->tile_size;
#line 261 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		if (_tmp337_ > _tmp338_) {
#line 262 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			self->priv->animate = FALSE;
#line 1805 "taquin-view.c"
		}
	}
#line 265 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	result = FALSE;
#line 265 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	return result;
#line 1812 "taquin-view.c"
}


static void taquin_view_load_image (TaquinView* self, cairo_t* c) {
	GError * _inner_error_ = NULL;
#line 268 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (self != NULL);
#line 268 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (c != NULL);
#line 1822 "taquin-view.c"
	{
		GdkPixbuf* p = NULL;
		const gchar* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		GdkPixbuf* _tmp4_ = NULL;
		cairo_t* _tmp5_ = NULL;
		cairo_t* _tmp6_ = NULL;
#line 288 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp0_ = taquin_view_get_theme (self);
#line 288 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp1_ = _tmp0_;
#line 288 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp2_ = self->priv->board_size;
#line 288 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp3_ = self->priv->board_size;
#line 288 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp4_ = gdk_pixbuf_new_from_file_at_scale (_tmp1_, _tmp2_, _tmp3_, FALSE, &_inner_error_);
#line 288 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		p = _tmp4_;
#line 288 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1846 "taquin-view.c"
			goto __catch2_g_error;
		}
#line 289 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp5_ = c;
#line 289 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		gdk_cairo_set_source_pixbuf (_tmp5_, p, (gdouble) 0, (gdouble) 0);
#line 290 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp6_ = c;
#line 290 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		cairo_paint (_tmp6_);
#line 286 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_g_object_unref0 (p);
#line 1859 "taquin-view.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 286 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		e = _inner_error_;
#line 286 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_inner_error_ = NULL;
#line 294 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp7_ = taquin_view_get_theme (self);
#line 294 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp8_ = _tmp7_;
#line 294 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp9_ = e;
#line 294 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp10_ = _tmp9_->message;
#line 294 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		g_warning ("taquin-view.vala:294: Failed to load theme %s: %s\n" \
"\n" \
"If you were trying to launch an unusual size, retry, it may work. But " \
"it probably implies that you have not an image adapted to the requeste" \
"d size in the current theme. If that's not the case, file a bug please" \
".\n", _tmp8_, _tmp10_);
#line 286 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_g_error_free0 (e);
#line 1885 "taquin-view.c"
	}
	__finally2:
#line 286 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 286 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 286 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		g_clear_error (&_inner_error_);
#line 286 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		return;
#line 1896 "taquin-view.c"
	}
}


static void taquin_view_draw_movable_lights (TaquinView* self, cairo_t* cr) {
	cairo_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	cairo_t* _tmp3_ = NULL;
	cairo_t* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	cairo_t* _tmp10_ = NULL;
	cairo_t* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	cairo_t* _tmp15_ = NULL;
	cairo_t* _tmp16_ = NULL;
	cairo_t* _tmp17_ = NULL;
	cairo_t* _tmp18_ = NULL;
	cairo_t* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	cairo_t* _tmp25_ = NULL;
	cairo_t* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	cairo_t* _tmp30_ = NULL;
	cairo_t* _tmp31_ = NULL;
	cairo_t* _tmp32_ = NULL;
	cairo_t* _tmp33_ = NULL;
#line 298 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (self != NULL);
#line 298 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (cr != NULL);
#line 300 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp0_ = cr;
#line 300 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_save (_tmp0_);
#line 301 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp1_ = cr;
#line 301 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp2_ = self->priv->animation_end_offset;
#line 301 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_set_source_rgba (_tmp1_, 0.8, 0.8, 0.8, 0.3 - (0.3 * _tmp2_));
#line 303 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp3_ = cr;
#line 303 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_save (_tmp3_);
#line 304 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp4_ = cr;
#line 304 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp5_ = self->priv->grid_border_main;
#line 304 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp6_ = self->priv->tile_size;
#line 304 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp7_ = self->priv->x_arrow;
#line 304 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp8_ = self->priv->grid_border_main;
#line 304 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp9_ = self->priv->grid_border_thin;
#line 304 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_translate (_tmp4_, _tmp5_ + (_tmp6_ * (_tmp7_ + 0.5)), (_tmp8_ + _tmp9_) / 2.0);
#line 305 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp10_ = cr;
#line 305 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	taquin_view_draw_light (self, _tmp10_, TRUE);
#line 306 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp11_ = cr;
#line 306 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp12_ = self->priv->board_size;
#line 306 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp13_ = self->priv->grid_border_main;
#line 306 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp14_ = self->priv->grid_border_thin;
#line 306 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_translate (_tmp11_, (gdouble) 0, (gdouble) ((_tmp12_ + _tmp13_) - _tmp14_));
#line 307 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp15_ = cr;
#line 307 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	taquin_view_draw_light (self, _tmp15_, TRUE);
#line 308 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp16_ = cr;
#line 308 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_restore (_tmp16_);
#line 309 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp17_ = cr;
#line 309 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_fill (_tmp17_);
#line 311 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp18_ = cr;
#line 311 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_save (_tmp18_);
#line 312 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp19_ = cr;
#line 312 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp20_ = self->priv->grid_border_main;
#line 312 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp21_ = self->priv->grid_border_thin;
#line 312 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp22_ = self->priv->grid_border_main;
#line 312 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp23_ = self->priv->tile_size;
#line 312 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp24_ = self->priv->y_arrow;
#line 312 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_translate (_tmp19_, (_tmp20_ + _tmp21_) / 2.0, _tmp22_ + (_tmp23_ * (_tmp24_ + 0.5)));
#line 313 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp25_ = cr;
#line 313 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	taquin_view_draw_light (self, _tmp25_, FALSE);
#line 314 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp26_ = cr;
#line 314 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp27_ = self->priv->board_size;
#line 314 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp28_ = self->priv->grid_border_main;
#line 314 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp29_ = self->priv->grid_border_thin;
#line 314 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_translate (_tmp26_, (gdouble) ((_tmp27_ + _tmp28_) - _tmp29_), (gdouble) 0);
#line 315 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp30_ = cr;
#line 315 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	taquin_view_draw_light (self, _tmp30_, FALSE);
#line 316 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp31_ = cr;
#line 316 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_restore (_tmp31_);
#line 317 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp32_ = cr;
#line 317 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_fill (_tmp32_);
#line 318 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp33_ = cr;
#line 318 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_restore (_tmp33_);
#line 2042 "taquin-view.c"
}


static void taquin_view_draw_light (TaquinView* self, cairo_t* cr, gboolean horizontal) {
	cairo_t* _tmp0_ = NULL;
	gdouble size = 0.0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gdouble _tmp3_ = 0.0;
	gboolean _tmp4_ = FALSE;
	gdouble _tmp6_ = 0.0;
	gboolean _tmp7_ = FALSE;
	cairo_t* _tmp9_ = NULL;
	cairo_t* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	cairo_t* _tmp12_ = NULL;
#line 320 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (self != NULL);
#line 320 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (cr != NULL);
#line 322 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp0_ = cr;
#line 322 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_save (_tmp0_);
#line 323 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp1_ = self->priv->tile_size;
#line 323 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp2_ = self->priv->grid_border_main;
#line 323 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	size = (0.3 * _tmp1_) / _tmp2_;
#line 324 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp4_ = horizontal;
#line 324 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp4_) {
#line 2077 "taquin-view.c"
		gdouble _tmp5_ = 0.0;
#line 324 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp5_ = size;
#line 324 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp3_ = _tmp5_;
#line 2083 "taquin-view.c"
	} else {
#line 324 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp3_ = 0.3;
#line 2087 "taquin-view.c"
	}
#line 324 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp7_ = horizontal;
#line 324 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp7_) {
#line 324 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp6_ = 0.3;
#line 2095 "taquin-view.c"
	} else {
		gdouble _tmp8_ = 0.0;
#line 324 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp8_ = size;
#line 324 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp6_ = _tmp8_;
#line 2102 "taquin-view.c"
	}
#line 324 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp9_ = cr;
#line 324 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_scale (_tmp9_, _tmp3_, _tmp6_);
#line 325 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp10_ = cr;
#line 325 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp11_ = self->priv->grid_border_main;
#line 325 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_arc (_tmp10_, 0.0, 0.0, (gdouble) _tmp11_, 0.0, 2.0 * G_PI);
#line 326 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp12_ = cr;
#line 326 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_restore (_tmp12_);
#line 2118 "taquin-view.c"
}


static void taquin_view_draw_fixed_arrows (TaquinView* self, cairo_t* cr) {
#line 329 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (self != NULL);
#line 329 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (cr != NULL);
#line 2127 "taquin-view.c"
	{
		gint i = 0;
#line 331 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		i = 0;
#line 2132 "taquin-view.c"
		{
			gboolean _tmp0_ = FALSE;
#line 331 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp0_ = TRUE;
#line 331 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			while (TRUE) {
#line 2139 "taquin-view.c"
				gint _tmp2_ = 0;
				Game* _tmp3_ = NULL;
				Game* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				cairo_t* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				cairo_t* _tmp9_ = NULL;
				gint _tmp10_ = 0;
#line 331 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				if (!_tmp0_) {
#line 2151 "taquin-view.c"
					gint _tmp1_ = 0;
#line 331 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp1_ = i;
#line 331 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					i = _tmp1_ + 1;
#line 2157 "taquin-view.c"
				}
#line 331 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp0_ = FALSE;
#line 331 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp2_ = i;
#line 331 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp3_ = taquin_view_get_game (self);
#line 331 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp4_ = _tmp3_;
#line 331 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp5_ = game_get_size (_tmp4_);
#line 331 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp6_ = _tmp5_;
#line 331 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				if (!(_tmp2_ < _tmp6_)) {
#line 331 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					break;
#line 2175 "taquin-view.c"
				}
#line 333 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp7_ = cr;
#line 333 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp8_ = i;
#line 333 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				taquin_view_draw_vertical_arrow (self, _tmp7_, FALSE, _tmp8_);
#line 334 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp9_ = cr;
#line 334 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp10_ = i;
#line 334 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				taquin_view_draw_horizontal_arrow (self, _tmp9_, FALSE, _tmp10_);
#line 2189 "taquin-view.c"
			}
		}
	}
}


static void taquin_view_draw_movable_arrows (TaquinView* self, cairo_t* cr) {
	cairo_t* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	cairo_t* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 338 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (self != NULL);
#line 338 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (cr != NULL);
#line 340 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp0_ = cr;
#line 340 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp1_ = self->priv->x_arrow;
#line 340 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	taquin_view_draw_vertical_arrow (self, _tmp0_, TRUE, _tmp1_);
#line 341 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp2_ = cr;
#line 341 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp3_ = self->priv->y_arrow;
#line 341 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	taquin_view_draw_horizontal_arrow (self, _tmp2_, TRUE, _tmp3_);
#line 2217 "taquin-view.c"
}


static void taquin_view_draw_horizontal_arrow (TaquinView* self, cairo_t* cr, gboolean inside, gint number) {
	gdouble x1 = 0.0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gdouble x2 = 0.0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gdouble _tmp4_ = 0.0;
	gboolean _tmp5_ = FALSE;
	cairo_t* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gdouble _tmp12_ = 0.0;
	gboolean _tmp13_ = FALSE;
	cairo_t* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gdouble _tmp20_ = 0.0;
	gboolean _tmp21_ = FALSE;
	cairo_t* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gdouble _tmp34_ = 0.0;
	gboolean _tmp35_ = FALSE;
	cairo_t* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	gdouble _tmp42_ = 0.0;
	gboolean _tmp43_ = FALSE;
	cairo_t* _tmp46_ = NULL;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gdouble _tmp50_ = 0.0;
	gboolean _tmp51_ = FALSE;
	cairo_t* _tmp54_ = NULL;
	gint _tmp55_ = 0;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
#line 344 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (self != NULL);
#line 344 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (cr != NULL);
#line 346 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp0_ = self->priv->grid_border_main;
#line 346 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp1_ = self->priv->grid_border_thin;
#line 346 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	x1 = ((_tmp0_ * 1.0) / 3) + ((_tmp1_ * 2.0) / 3);
#line 347 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp2_ = self->priv->grid_border_main;
#line 347 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp3_ = self->priv->grid_border_thin;
#line 347 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	x2 = ((_tmp2_ * 2.0) / 3) + ((_tmp3_ * 1.0) / 3);
#line 348 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp5_ = inside;
#line 348 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp5_) {
#line 2290 "taquin-view.c"
		gdouble _tmp6_ = 0.0;
#line 348 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp6_ = x1;
#line 348 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp4_ = _tmp6_;
#line 2296 "taquin-view.c"
	} else {
		gdouble _tmp7_ = 0.0;
#line 348 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp7_ = x2;
#line 348 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp4_ = _tmp7_;
#line 2303 "taquin-view.c"
	}
#line 348 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp8_ = cr;
#line 348 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp9_ = self->priv->grid_border_main;
#line 348 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp10_ = self->priv->tile_size;
#line 348 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp11_ = number;
#line 348 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_move_to (_tmp8_, _tmp4_, _tmp9_ + (_tmp10_ * (_tmp11_ + (1.0 / 3))));
#line 349 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp13_ = inside;
#line 349 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp13_) {
#line 2319 "taquin-view.c"
		gdouble _tmp14_ = 0.0;
#line 349 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp14_ = x2;
#line 349 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp12_ = _tmp14_;
#line 2325 "taquin-view.c"
	} else {
		gdouble _tmp15_ = 0.0;
#line 349 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp15_ = x1;
#line 349 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp12_ = _tmp15_;
#line 2332 "taquin-view.c"
	}
#line 349 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp16_ = cr;
#line 349 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp17_ = self->priv->grid_border_main;
#line 349 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp18_ = self->priv->tile_size;
#line 349 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp19_ = number;
#line 349 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_line_to (_tmp16_, _tmp12_, _tmp17_ + (_tmp18_ * (_tmp19_ + (1.0 / 2))));
#line 350 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp21_ = inside;
#line 350 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp21_) {
#line 2348 "taquin-view.c"
		gdouble _tmp22_ = 0.0;
#line 350 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp22_ = x1;
#line 350 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp20_ = _tmp22_;
#line 2354 "taquin-view.c"
	} else {
		gdouble _tmp23_ = 0.0;
#line 350 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp23_ = x2;
#line 350 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp20_ = _tmp23_;
#line 2361 "taquin-view.c"
	}
#line 350 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp24_ = cr;
#line 350 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp25_ = self->priv->grid_border_main;
#line 350 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp26_ = self->priv->tile_size;
#line 350 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp27_ = number;
#line 350 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_line_to (_tmp24_, _tmp20_, _tmp25_ + (_tmp26_ * (_tmp27_ + (2.0 / 3))));
#line 351 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp28_ = self->priv->board_size;
#line 351 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp29_ = self->priv->grid_border_main;
#line 351 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp30_ = self->priv->grid_border_thin;
#line 351 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	x1 = (_tmp28_ + ((_tmp29_ * 5.0) / 3)) - ((_tmp30_ * 2.0) / 3);
#line 352 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp31_ = self->priv->board_size;
#line 352 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp32_ = self->priv->grid_border_main;
#line 352 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp33_ = self->priv->grid_border_thin;
#line 352 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	x2 = (_tmp31_ + ((_tmp32_ * 4.0) / 3)) - ((_tmp33_ * 1.0) / 3);
#line 353 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp35_ = inside;
#line 353 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp35_) {
#line 2393 "taquin-view.c"
		gdouble _tmp36_ = 0.0;
#line 353 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp36_ = x1;
#line 353 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp34_ = _tmp36_;
#line 2399 "taquin-view.c"
	} else {
		gdouble _tmp37_ = 0.0;
#line 353 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp37_ = x2;
#line 353 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp34_ = _tmp37_;
#line 2406 "taquin-view.c"
	}
#line 353 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp38_ = cr;
#line 353 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp39_ = self->priv->grid_border_main;
#line 353 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp40_ = self->priv->tile_size;
#line 353 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp41_ = number;
#line 353 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_move_to (_tmp38_, _tmp34_, _tmp39_ + (_tmp40_ * (_tmp41_ + (1.0 / 3))));
#line 354 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp43_ = inside;
#line 354 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp43_) {
#line 2422 "taquin-view.c"
		gdouble _tmp44_ = 0.0;
#line 354 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp44_ = x2;
#line 354 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp42_ = _tmp44_;
#line 2428 "taquin-view.c"
	} else {
		gdouble _tmp45_ = 0.0;
#line 354 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp45_ = x1;
#line 354 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp42_ = _tmp45_;
#line 2435 "taquin-view.c"
	}
#line 354 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp46_ = cr;
#line 354 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp47_ = self->priv->grid_border_main;
#line 354 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp48_ = self->priv->tile_size;
#line 354 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp49_ = number;
#line 354 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_line_to (_tmp46_, _tmp42_, _tmp47_ + (_tmp48_ * (_tmp49_ + (1.0 / 2))));
#line 355 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp51_ = inside;
#line 355 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp51_) {
#line 2451 "taquin-view.c"
		gdouble _tmp52_ = 0.0;
#line 355 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp52_ = x1;
#line 355 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp50_ = _tmp52_;
#line 2457 "taquin-view.c"
	} else {
		gdouble _tmp53_ = 0.0;
#line 355 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp53_ = x2;
#line 355 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp50_ = _tmp53_;
#line 2464 "taquin-view.c"
	}
#line 355 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp54_ = cr;
#line 355 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp55_ = self->priv->grid_border_main;
#line 355 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp56_ = self->priv->tile_size;
#line 355 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp57_ = number;
#line 355 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_line_to (_tmp54_, _tmp50_, _tmp55_ + (_tmp56_ * (_tmp57_ + (2.0 / 3))));
#line 2476 "taquin-view.c"
}


static void taquin_view_draw_vertical_arrow (TaquinView* self, cairo_t* cr, gboolean inside, gint number) {
	gdouble y1 = 0.0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gdouble y2 = 0.0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gdouble _tmp4_ = 0.0;
	gboolean _tmp5_ = FALSE;
	cairo_t* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gdouble _tmp12_ = 0.0;
	gboolean _tmp13_ = FALSE;
	cairo_t* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gdouble _tmp20_ = 0.0;
	gboolean _tmp21_ = FALSE;
	cairo_t* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gdouble _tmp34_ = 0.0;
	gboolean _tmp35_ = FALSE;
	cairo_t* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	gdouble _tmp42_ = 0.0;
	gboolean _tmp43_ = FALSE;
	cairo_t* _tmp46_ = NULL;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gdouble _tmp50_ = 0.0;
	gboolean _tmp51_ = FALSE;
	cairo_t* _tmp54_ = NULL;
	gint _tmp55_ = 0;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
#line 358 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (self != NULL);
#line 358 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (cr != NULL);
#line 360 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp0_ = self->priv->grid_border_main;
#line 360 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp1_ = self->priv->grid_border_thin;
#line 360 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	y1 = ((_tmp0_ * 1.0) / 3) + ((_tmp1_ * 2.0) / 3);
#line 361 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp2_ = self->priv->grid_border_main;
#line 361 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp3_ = self->priv->grid_border_thin;
#line 361 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	y2 = ((_tmp2_ * 2.0) / 3) + ((_tmp3_ * 1.0) / 3);
#line 362 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp5_ = inside;
#line 362 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp5_) {
#line 2549 "taquin-view.c"
		gdouble _tmp6_ = 0.0;
#line 362 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp6_ = y1;
#line 362 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp4_ = _tmp6_;
#line 2555 "taquin-view.c"
	} else {
		gdouble _tmp7_ = 0.0;
#line 362 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp7_ = y2;
#line 362 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp4_ = _tmp7_;
#line 2562 "taquin-view.c"
	}
#line 362 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp8_ = cr;
#line 362 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp9_ = self->priv->grid_border_main;
#line 362 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp10_ = self->priv->tile_size;
#line 362 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp11_ = number;
#line 362 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_move_to (_tmp8_, _tmp9_ + (_tmp10_ * (_tmp11_ + (1.0 / 3))), _tmp4_);
#line 363 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp13_ = inside;
#line 363 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp13_) {
#line 2578 "taquin-view.c"
		gdouble _tmp14_ = 0.0;
#line 363 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp14_ = y2;
#line 363 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp12_ = _tmp14_;
#line 2584 "taquin-view.c"
	} else {
		gdouble _tmp15_ = 0.0;
#line 363 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp15_ = y1;
#line 363 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp12_ = _tmp15_;
#line 2591 "taquin-view.c"
	}
#line 363 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp16_ = cr;
#line 363 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp17_ = self->priv->grid_border_main;
#line 363 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp18_ = self->priv->tile_size;
#line 363 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp19_ = number;
#line 363 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_line_to (_tmp16_, _tmp17_ + (_tmp18_ * (_tmp19_ + (1.0 / 2))), _tmp12_);
#line 364 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp21_ = inside;
#line 364 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp21_) {
#line 2607 "taquin-view.c"
		gdouble _tmp22_ = 0.0;
#line 364 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp22_ = y1;
#line 364 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp20_ = _tmp22_;
#line 2613 "taquin-view.c"
	} else {
		gdouble _tmp23_ = 0.0;
#line 364 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp23_ = y2;
#line 364 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp20_ = _tmp23_;
#line 2620 "taquin-view.c"
	}
#line 364 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp24_ = cr;
#line 364 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp25_ = self->priv->grid_border_main;
#line 364 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp26_ = self->priv->tile_size;
#line 364 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp27_ = number;
#line 364 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_line_to (_tmp24_, _tmp25_ + (_tmp26_ * (_tmp27_ + (2.0 / 3))), _tmp20_);
#line 365 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp28_ = self->priv->board_size;
#line 365 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp29_ = self->priv->grid_border_main;
#line 365 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp30_ = self->priv->grid_border_thin;
#line 365 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	y1 = (_tmp28_ + ((_tmp29_ * 5.0) / 3)) - ((_tmp30_ * 2.0) / 3);
#line 366 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp31_ = self->priv->board_size;
#line 366 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp32_ = self->priv->grid_border_main;
#line 366 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp33_ = self->priv->grid_border_thin;
#line 366 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	y2 = (_tmp31_ + ((_tmp32_ * 4.0) / 3)) - ((_tmp33_ * 1.0) / 3);
#line 367 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp35_ = inside;
#line 367 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp35_) {
#line 2652 "taquin-view.c"
		gdouble _tmp36_ = 0.0;
#line 367 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp36_ = y1;
#line 367 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp34_ = _tmp36_;
#line 2658 "taquin-view.c"
	} else {
		gdouble _tmp37_ = 0.0;
#line 367 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp37_ = y2;
#line 367 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp34_ = _tmp37_;
#line 2665 "taquin-view.c"
	}
#line 367 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp38_ = cr;
#line 367 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp39_ = self->priv->grid_border_main;
#line 367 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp40_ = self->priv->tile_size;
#line 367 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp41_ = number;
#line 367 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_move_to (_tmp38_, _tmp39_ + (_tmp40_ * (_tmp41_ + (1.0 / 3))), _tmp34_);
#line 368 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp43_ = inside;
#line 368 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp43_) {
#line 2681 "taquin-view.c"
		gdouble _tmp44_ = 0.0;
#line 368 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp44_ = y2;
#line 368 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp42_ = _tmp44_;
#line 2687 "taquin-view.c"
	} else {
		gdouble _tmp45_ = 0.0;
#line 368 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp45_ = y1;
#line 368 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp42_ = _tmp45_;
#line 2694 "taquin-view.c"
	}
#line 368 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp46_ = cr;
#line 368 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp47_ = self->priv->grid_border_main;
#line 368 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp48_ = self->priv->tile_size;
#line 368 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp49_ = number;
#line 368 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_line_to (_tmp46_, _tmp47_ + (_tmp48_ * (_tmp49_ + (1.0 / 2))), _tmp42_);
#line 369 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp51_ = inside;
#line 369 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp51_) {
#line 2710 "taquin-view.c"
		gdouble _tmp52_ = 0.0;
#line 369 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp52_ = y1;
#line 369 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp50_ = _tmp52_;
#line 2716 "taquin-view.c"
	} else {
		gdouble _tmp53_ = 0.0;
#line 369 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp53_ = y2;
#line 369 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp50_ = _tmp53_;
#line 2723 "taquin-view.c"
	}
#line 369 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp54_ = cr;
#line 369 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp55_ = self->priv->grid_border_main;
#line 369 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp56_ = self->priv->tile_size;
#line 369 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp57_ = number;
#line 369 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	cairo_line_to (_tmp54_, _tmp55_ + (_tmp56_ * (_tmp57_ + (2.0 / 3))), _tmp50_);
#line 2735 "taquin-view.c"
}


static void taquin_view_move_cb (TaquinView* self, gboolean x_axis, gint number, gint x_gap, gint y_gap) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	GameType _tmp6_ = 0;
	GameType _tmp7_ = 0;
#line 372 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (self != NULL);
#line 374 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp0_ = x_axis;
#line 374 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->x_axis = _tmp0_;
#line 375 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp1_ = number;
#line 375 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->number = _tmp1_;
#line 376 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp2_ = x_gap;
#line 376 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->x_gap = _tmp2_;
#line 377 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp3_ = y_gap;
#line 377 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->y_gap = _tmp3_;
#line 379 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp4_ = taquin_view_get_game (self);
#line 379 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp5_ = _tmp4_;
#line 379 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp6_ = game_get_game_type (_tmp5_);
#line 379 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp7_ = _tmp6_;
#line 379 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp7_ == GAME_TYPE_FIFTEEN) {
#line 2776 "taquin-view.c"
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 381 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp8_ = x_gap;
#line 381 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		self->priv->x_arrow = _tmp8_;
#line 382 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp9_ = y_gap;
#line 382 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		self->priv->y_arrow = _tmp9_;
#line 2787 "taquin-view.c"
	}
#line 384 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->animation_offset = 0;
#line 385 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->animate = TRUE;
#line 386 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 2795 "taquin-view.c"
}


static gboolean __lambda4_ (TaquinView* self) {
	gboolean result = FALSE;
#line 394 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->animation_end_offset = (gdouble) 0;
#line 395 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->animate_end = TRUE;
#line 396 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 398 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	result = FALSE;
#line 398 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	return result;
#line 2811 "taquin-view.c"
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ ((TaquinView*) self);
#line 392 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	return result;
#line 2820 "taquin-view.c"
}


static void taquin_view_complete_cb (TaquinView* self) {
#line 389 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (self != NULL);
#line 391 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->finished = TRUE;
#line 392 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
#line 2831 "taquin-view.c"
}


static gboolean taquin_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	TaquinView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GdkEventButton* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
#line 402 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self = (TaquinView*) base;
#line 402 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 404 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp1_ = self->priv->animate;
#line 404 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp1_) {
#line 404 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp0_ = TRUE;
#line 2853 "taquin-view.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 404 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp2_ = self->priv->animate_end;
#line 404 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp0_ = _tmp2_;
#line 2860 "taquin-view.c"
	}
#line 404 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp0_) {
#line 405 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		result = TRUE;
#line 405 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		return result;
#line 2868 "taquin-view.c"
	}
#line 406 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp4_ = event;
#line 406 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp5_ = _tmp4_->button;
#line 406 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp5_ == ((guint) GDK_BUTTON_PRIMARY)) {
#line 406 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp3_ = TRUE;
#line 2878 "taquin-view.c"
	} else {
		GdkEventButton* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
#line 406 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp6_ = event;
#line 406 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp7_ = _tmp6_->button;
#line 406 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp3_ = _tmp7_ == ((guint) GDK_BUTTON_SECONDARY);
#line 2888 "taquin-view.c"
	}
#line 406 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp3_) {
#line 2892 "taquin-view.c"
		Game* _tmp8_ = NULL;
		Game* _tmp9_ = NULL;
		GdkEventButton* _tmp10_ = NULL;
		gdouble _tmp11_ = 0.0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		GdkEventButton* _tmp17_ = NULL;
		gdouble _tmp18_ = 0.0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 408 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		self->priv->draw_lights = FALSE;
#line 409 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp8_ = taquin_view_get_game (self);
#line 409 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp9_ = _tmp8_;
#line 409 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp10_ = event;
#line 409 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp11_ = _tmp10_->x;
#line 409 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp12_ = taquin_view_get_x_offset (self);
#line 409 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp13_ = _tmp12_;
#line 409 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp14_ = self->priv->grid_border_main;
#line 409 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp15_ = self->priv->tile_size;
#line 409 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp16_ = self->priv->tile_size;
#line 409 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp17_ = event;
#line 409 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp18_ = _tmp17_->y;
#line 409 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp19_ = taquin_view_get_y_offset (self);
#line 409 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp20_ = _tmp19_;
#line 409 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp21_ = self->priv->grid_border_main;
#line 409 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp22_ = self->priv->tile_size;
#line 409 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp23_ = self->priv->tile_size;
#line 409 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		game_request_move (_tmp9_, (((gint) (((_tmp11_ - _tmp13_) - _tmp14_) + _tmp15_)) / _tmp16_) - 1, (((gint) (((_tmp18_ - _tmp20_) - _tmp21_) + _tmp22_)) / _tmp23_) - 1);
#line 2945 "taquin-view.c"
	}
#line 412 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	result = TRUE;
#line 412 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	return result;
#line 2951 "taquin-view.c"
}


static gboolean taquin_view_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	TaquinView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* k_name = NULL;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	Game* _tmp6_ = NULL;
	Game* _tmp7_ = NULL;
	GameType _tmp8_ = 0;
	GameType _tmp9_ = 0;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	const gchar* _tmp41_ = NULL;
	const gchar* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	GQuark _tmp51_ = 0U;
#line 436 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	static GQuark _tmp50_label0 = 0;
#line 436 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	static GQuark _tmp50_label1 = 0;
#line 436 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	static GQuark _tmp50_label2 = 0;
#line 436 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	static GQuark _tmp50_label3 = 0;
#line 415 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self = (TaquinView*) base;
#line 415 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 417 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp0_ = self->priv->finished;
#line 417 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp0_) {
#line 418 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		result = FALSE;
#line 418 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		return result;
#line 2995 "taquin-view.c"
	}
#line 419 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp1_ = event;
#line 419 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp2_ = _tmp1_->keyval;
#line 419 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp3_ = gdk_keyval_name (_tmp2_);
#line 419 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 419 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	k_name = _tmp4_;
#line 421 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp6_ = taquin_view_get_game (self);
#line 421 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp7_ = _tmp6_;
#line 421 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp8_ = game_get_game_type (_tmp7_);
#line 421 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp9_ = _tmp8_;
#line 421 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp9_ == GAME_TYPE_SIXTEEN) {
#line 3017 "taquin-view.c"
		gboolean _tmp10_ = FALSE;
		GdkEventKey* _tmp11_ = NULL;
		GdkModifierType _tmp12_ = 0;
#line 421 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp11_ = event;
#line 421 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp12_ = _tmp11_->state;
#line 421 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		if ((_tmp12_ & GDK_SHIFT_MASK) > 0) {
#line 421 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp10_ = TRUE;
#line 3029 "taquin-view.c"
		} else {
			GdkEventKey* _tmp13_ = NULL;
			GdkModifierType _tmp14_ = 0;
#line 421 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp13_ = event;
#line 421 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp14_ = _tmp13_->state;
#line 421 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			_tmp10_ = (_tmp14_ & GDK_CONTROL_MASK) > 0;
#line 3039 "taquin-view.c"
		}
#line 421 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp5_ = _tmp10_;
#line 3043 "taquin-view.c"
	} else {
#line 421 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp5_ = FALSE;
#line 3047 "taquin-view.c"
	}
#line 421 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp5_) {
#line 3051 "taquin-view.c"
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		GQuark _tmp18_ = 0U;
#line 423 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		static GQuark _tmp17_label0 = 0;
#line 423 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		static GQuark _tmp17_label1 = 0;
#line 423 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		static GQuark _tmp17_label2 = 0;
#line 423 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		static GQuark _tmp17_label3 = 0;
#line 423 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp15_ = k_name;
#line 423 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp16_ = _tmp15_;
#line 423 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp18_ = (NULL == _tmp16_) ? 0 : g_quark_from_string (_tmp16_);
#line 423 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		if (_tmp18_ == ((0 != _tmp17_label0) ? _tmp17_label0 : (_tmp17_label0 = g_quark_from_static_string ("Left")))) {
#line 423 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			switch (0) {
#line 3073 "taquin-view.c"
				default:
				{
					Game* _tmp19_ = NULL;
					Game* _tmp20_ = NULL;
					gint _tmp21_ = 0;
#line 424 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp19_ = taquin_view_get_game (self);
#line 424 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp20_ = _tmp19_;
#line 424 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp21_ = self->priv->y_arrow;
#line 424 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					game_request_move (_tmp20_, -1, _tmp21_);
#line 424 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					break;
#line 3089 "taquin-view.c"
				}
			}
		} else if (_tmp18_ == ((0 != _tmp17_label1) ? _tmp17_label1 : (_tmp17_label1 = g_quark_from_static_string ("Right")))) {
#line 423 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			switch (0) {
#line 3095 "taquin-view.c"
				default:
				{
					Game* _tmp22_ = NULL;
					Game* _tmp23_ = NULL;
					Game* _tmp24_ = NULL;
					Game* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					gint _tmp28_ = 0;
#line 425 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp22_ = taquin_view_get_game (self);
#line 425 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp23_ = _tmp22_;
#line 425 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp24_ = taquin_view_get_game (self);
#line 425 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp25_ = _tmp24_;
#line 425 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp26_ = game_get_size (_tmp25_);
#line 425 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp27_ = _tmp26_;
#line 425 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp28_ = self->priv->y_arrow;
#line 425 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					game_request_move (_tmp23_, _tmp27_, _tmp28_);
#line 425 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					break;
#line 3123 "taquin-view.c"
				}
			}
		} else if (_tmp18_ == ((0 != _tmp17_label2) ? _tmp17_label2 : (_tmp17_label2 = g_quark_from_static_string ("Up")))) {
#line 423 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			switch (0) {
#line 3129 "taquin-view.c"
				default:
				{
					Game* _tmp29_ = NULL;
					Game* _tmp30_ = NULL;
					gint _tmp31_ = 0;
#line 426 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp29_ = taquin_view_get_game (self);
#line 426 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp30_ = _tmp29_;
#line 426 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp31_ = self->priv->x_arrow;
#line 426 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					game_request_move (_tmp30_, _tmp31_, -1);
#line 426 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					break;
#line 3145 "taquin-view.c"
				}
			}
		} else if (_tmp18_ == ((0 != _tmp17_label3) ? _tmp17_label3 : (_tmp17_label3 = g_quark_from_static_string ("Down")))) {
#line 423 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			switch (0) {
#line 3151 "taquin-view.c"
				default:
				{
					Game* _tmp32_ = NULL;
					Game* _tmp33_ = NULL;
					gint _tmp34_ = 0;
					Game* _tmp35_ = NULL;
					Game* _tmp36_ = NULL;
					gint _tmp37_ = 0;
					gint _tmp38_ = 0;
#line 427 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp32_ = taquin_view_get_game (self);
#line 427 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp33_ = _tmp32_;
#line 427 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp34_ = self->priv->x_arrow;
#line 427 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp35_ = taquin_view_get_game (self);
#line 427 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp36_ = _tmp35_;
#line 427 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp37_ = game_get_size (_tmp36_);
#line 427 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp38_ = _tmp37_;
#line 427 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					game_request_move (_tmp33_, _tmp34_, _tmp38_);
#line 427 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					break;
#line 3179 "taquin-view.c"
				}
			}
		} else {
#line 423 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
			switch (0) {
#line 3185 "taquin-view.c"
				default:
				{
#line 428 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					result = FALSE;
#line 428 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_g_free0 (k_name);
#line 428 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					return result;
#line 3194 "taquin-view.c"
				}
			}
		}
	}
#line 431 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp41_ = k_name;
#line 431 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (g_strcmp0 (_tmp41_, "space") == 0) {
#line 431 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp40_ = TRUE;
#line 3205 "taquin-view.c"
	} else {
		const gchar* _tmp42_ = NULL;
#line 431 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp42_ = k_name;
#line 431 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp40_ = g_strcmp0 (_tmp42_, "KP_Enter") == 0;
#line 3212 "taquin-view.c"
	}
#line 431 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp40_) {
#line 431 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp39_ = TRUE;
#line 3218 "taquin-view.c"
	} else {
		const gchar* _tmp43_ = NULL;
#line 431 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp43_ = k_name;
#line 431 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp39_ = g_strcmp0 (_tmp43_, "Return") == 0;
#line 3225 "taquin-view.c"
	}
#line 431 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp39_) {
#line 3229 "taquin-view.c"
		Game* _tmp44_ = NULL;
		Game* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gint _tmp47_ = 0;
#line 433 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp44_ = taquin_view_get_game (self);
#line 433 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp45_ = _tmp44_;
#line 433 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp46_ = self->priv->x_arrow;
#line 433 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp47_ = self->priv->y_arrow;
#line 433 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		game_request_move (_tmp45_, _tmp46_, _tmp47_);
#line 434 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		result = TRUE;
#line 434 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_g_free0 (k_name);
#line 434 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		return result;
#line 3250 "taquin-view.c"
	}
#line 436 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp48_ = k_name;
#line 436 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp49_ = _tmp48_;
#line 436 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp51_ = (NULL == _tmp49_) ? 0 : g_quark_from_string (_tmp49_);
#line 436 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp51_ == ((0 != _tmp50_label0) ? _tmp50_label0 : (_tmp50_label0 = g_quark_from_static_string ("Left")))) {
#line 436 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		switch (0) {
#line 3262 "taquin-view.c"
			default:
			{
				gint _tmp52_ = 0;
#line 437 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp52_ = self->priv->x_arrow;
#line 437 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				if (_tmp52_ > 0) {
#line 3270 "taquin-view.c"
					gint _tmp53_ = 0;
#line 437 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp53_ = self->priv->x_arrow;
#line 437 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					self->priv->x_arrow = _tmp53_ - 1;
#line 3276 "taquin-view.c"
				}
#line 437 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				break;
#line 3280 "taquin-view.c"
			}
		}
	} else if (_tmp51_ == ((0 != _tmp50_label1) ? _tmp50_label1 : (_tmp50_label1 = g_quark_from_static_string ("Right")))) {
#line 436 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		switch (0) {
#line 3286 "taquin-view.c"
			default:
			{
				gint _tmp54_ = 0;
				Game* _tmp55_ = NULL;
				Game* _tmp56_ = NULL;
				gint _tmp57_ = 0;
				gint _tmp58_ = 0;
#line 438 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp54_ = self->priv->x_arrow;
#line 438 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp55_ = taquin_view_get_game (self);
#line 438 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp56_ = _tmp55_;
#line 438 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp57_ = game_get_size (_tmp56_);
#line 438 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp58_ = _tmp57_;
#line 438 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				if (_tmp54_ < (_tmp58_ - 1)) {
#line 3306 "taquin-view.c"
					gint _tmp59_ = 0;
#line 438 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp59_ = self->priv->x_arrow;
#line 438 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					self->priv->x_arrow = _tmp59_ + 1;
#line 3312 "taquin-view.c"
				}
#line 438 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				break;
#line 3316 "taquin-view.c"
			}
		}
	} else if (_tmp51_ == ((0 != _tmp50_label2) ? _tmp50_label2 : (_tmp50_label2 = g_quark_from_static_string ("Up")))) {
#line 436 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		switch (0) {
#line 3322 "taquin-view.c"
			default:
			{
				gint _tmp60_ = 0;
#line 439 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp60_ = self->priv->y_arrow;
#line 439 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				if (_tmp60_ > 0) {
#line 3330 "taquin-view.c"
					gint _tmp61_ = 0;
#line 439 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp61_ = self->priv->y_arrow;
#line 439 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					self->priv->y_arrow = _tmp61_ - 1;
#line 3336 "taquin-view.c"
				}
#line 439 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				break;
#line 3340 "taquin-view.c"
			}
		}
	} else if (_tmp51_ == ((0 != _tmp50_label3) ? _tmp50_label3 : (_tmp50_label3 = g_quark_from_static_string ("Down")))) {
#line 436 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		switch (0) {
#line 3346 "taquin-view.c"
			default:
			{
				gint _tmp62_ = 0;
				Game* _tmp63_ = NULL;
				Game* _tmp64_ = NULL;
				gint _tmp65_ = 0;
				gint _tmp66_ = 0;
#line 440 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp62_ = self->priv->y_arrow;
#line 440 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp63_ = taquin_view_get_game (self);
#line 440 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp64_ = _tmp63_;
#line 440 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp65_ = game_get_size (_tmp64_);
#line 440 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_tmp66_ = _tmp65_;
#line 440 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				if (_tmp62_ < (_tmp66_ - 1)) {
#line 3366 "taquin-view.c"
					gint _tmp67_ = 0;
#line 440 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					_tmp67_ = self->priv->y_arrow;
#line 440 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
					self->priv->y_arrow = _tmp67_ + 1;
#line 3372 "taquin-view.c"
				}
#line 440 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				break;
#line 3376 "taquin-view.c"
			}
		}
	} else {
#line 436 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		switch (0) {
#line 3382 "taquin-view.c"
			default:
			{
#line 441 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				result = FALSE;
#line 441 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				_g_free0 (k_name);
#line 441 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
				return result;
#line 3391 "taquin-view.c"
			}
		}
	}
#line 443 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->draw_lights = TRUE;
#line 444 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 445 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	result = TRUE;
#line 445 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_g_free0 (k_name);
#line 445 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	return result;
#line 3405 "taquin-view.c"
}


static gint taquin_view_get_x_offset (TaquinView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 43 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 43 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 43 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp1_ = self->priv->board_size;
#line 43 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp2_ = self->priv->grid_border_main;
#line 43 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	result = ((_tmp0_ - _tmp1_) / 2) - _tmp2_;
#line 43 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	return result;
#line 3426 "taquin-view.c"
}


static gint taquin_view_get_y_offset (TaquinView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 44 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 44 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp0_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 44 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp1_ = self->priv->board_size;
#line 44 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp2_ = self->priv->grid_border_main;
#line 44 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	result = ((_tmp0_ - _tmp1_) / 2) - _tmp2_;
#line 44 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	return result;
#line 3447 "taquin-view.c"
}


Game* taquin_view_get_game (TaquinView* self) {
	Game* result;
	Game* _tmp0_ = NULL;
#line 86 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 86 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp0_ = self->priv->_game;
#line 86 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	result = _tmp0_;
#line 86 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	return result;
#line 3462 "taquin-view.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 98 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 3469 "taquin-view.c"
}


static void _taquin_view_move_cb_game_move (Game* _sender, gboolean x_axis, gint number, gint x_gap, gint y_gap, gpointer self) {
#line 99 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	taquin_view_move_cb ((TaquinView*) self, x_axis, number, x_gap, y_gap);
#line 3476 "taquin-view.c"
}


static void _taquin_view_complete_cb_game_complete (Game* _sender, gpointer self) {
#line 100 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	taquin_view_complete_cb ((TaquinView*) self);
#line 3483 "taquin-view.c"
}


void taquin_view_set_game (TaquinView* self, Game* value) {
	Game* _tmp0_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
#line 87 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (self != NULL);
#line 89 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp0_ = self->priv->_game;
#line 89 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	if (_tmp0_ != NULL) {
#line 3499 "taquin-view.c"
		Game* _tmp1_ = NULL;
#line 90 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		_tmp1_ = self->priv->_game;
#line 90 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 3505 "taquin-view.c"
	}
#line 91 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->animate = FALSE;
#line 92 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->finished = FALSE;
#line 93 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->animate_end = FALSE;
#line 94 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->animation_end_offset = (gdouble) 0;
#line 95 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->draw_lights = FALSE;
#line 96 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->x_arrow = 0;
#line 97 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->y_arrow = 0;
#line 98 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp2_ = value;
#line 98 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 98 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 98 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->_game = _tmp3_;
#line 99 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp4_ = self->priv->_game;
#line 99 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_signal_connect_object (_tmp4_, "move", (GCallback) _taquin_view_move_cb_game_move, self, 0);
#line 100 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp5_ = self->priv->_game;
#line 100 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_signal_connect_object (_tmp5_, "complete", (GCallback) _taquin_view_complete_cb_game_complete, self, 0);
#line 101 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 87 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_object_notify ((GObject *) self, "game");
#line 3541 "taquin-view.c"
}


const gchar* taquin_view_get_theme (TaquinView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 108 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 108 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp0_ = self->priv->_theme;
#line 108 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	result = _tmp0_;
#line 108 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	return result;
#line 3556 "taquin-view.c"
}


void taquin_view_set_theme (TaquinView* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 109 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_return_if_fail (self != NULL);
#line 109 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp0_ = value;
#line 109 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 109 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_g_free0 (self->priv->_theme);
#line 109 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->_theme = _tmp1_;
#line 109 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 109 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->tiles_pattern = NULL;
#line 109 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 109 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_object_notify ((GObject *) self, "theme");
#line 3581 "taquin-view.c"
}


static void taquin_view_class_init (TaquinViewClass * klass) {
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	taquin_view_parent_class = g_type_class_peek_parent (klass);
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_type_class_add_private (klass, sizeof (TaquinViewPrivate));
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	((GtkWidgetClass *) klass)->draw = taquin_view_real_draw;
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = taquin_view_real_button_press_event;
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	((GtkWidgetClass *) klass)->key_press_event = taquin_view_real_key_press_event;
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_taquin_view_get_property;
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_taquin_view_set_property;
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	G_OBJECT_CLASS (klass)->finalize = taquin_view_finalize;
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAQUIN_VIEW_GAME, g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAQUIN_VIEW_THEME, g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3606 "taquin-view.c"
}


static void taquin_view_instance_init (TaquinView * self) {
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv = TAQUIN_VIEW_GET_PRIVATE (self);
#line 37 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->grid_border_thin = 6;
#line 57 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->x_arrow = 0;
#line 58 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->y_arrow = 0;
#line 59 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->draw_lights = FALSE;
#line 62 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->render_size = 0;
#line 63 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->tiles_pattern = NULL;
#line 66 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->animate = FALSE;
#line 72 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->animate_end = FALSE;
#line 73 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->finished = FALSE;
#line 83 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->_game = NULL;
#line 105 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self->priv->_theme = NULL;
#line 3635 "taquin-view.c"
}


static void taquin_view_finalize (GObject* obj) {
	TaquinView * self;
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAQUIN_VIEW, TaquinView);
#line 63 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 83 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 105 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	_g_free0 (self->priv->_theme);
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	G_OBJECT_CLASS (taquin_view_parent_class)->finalize (obj);
#line 3651 "taquin-view.c"
}


GType taquin_view_get_type (void) {
	static volatile gsize taquin_view_type_id__volatile = 0;
	if (g_once_init_enter (&taquin_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaquinViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) taquin_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TaquinView), 0, (GInstanceInitFunc) taquin_view_instance_init, NULL };
		GType taquin_view_type_id;
		taquin_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "TaquinView", &g_define_type_info, 0);
		g_once_init_leave (&taquin_view_type_id__volatile, taquin_view_type_id);
	}
	return taquin_view_type_id__volatile;
}


static void _vala_taquin_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TaquinView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TAQUIN_VIEW, TaquinView);
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	switch (property_id) {
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		case TAQUIN_VIEW_GAME:
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		g_value_set_object (value, taquin_view_get_game (self));
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		break;
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		case TAQUIN_VIEW_THEME:
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		g_value_set_string (value, taquin_view_get_theme (self));
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		break;
#line 3684 "taquin-view.c"
		default:
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		break;
#line 3690 "taquin-view.c"
	}
}


static void _vala_taquin_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TaquinView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TAQUIN_VIEW, TaquinView);
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
	switch (property_id) {
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		case TAQUIN_VIEW_GAME:
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		taquin_view_set_game (self, g_value_get_object (value));
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		break;
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		case TAQUIN_VIEW_THEME:
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		taquin_view_set_theme (self, g_value_get_string (value));
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		break;
#line 3712 "taquin-view.c"
		default:
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/mnt/test/jhbuild/jhbuild/gnome-taquin/src/taquin-view.vala"
		break;
#line 3718 "taquin-view.c"
	}
}



