// Generated by gmmproc 2.50.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_PAD_H
#define _GSTREAMERMM_PAD_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/object.h>
#include <gstreamermm/miniobject.h>
#include <gstreamermm/format.h>
#include <gstreamermm/event.h>
#include <gstreamermm/bufferlist.h>
#include <glibmm/arrayhandle.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GstPad = struct _GstPad;
using GstPadClass = struct _GstPadClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gst
{ class Pad_Class; } // namespace Gst
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gst
{

class Buffer;
class Caps;
class Element;
class Event;
class PadTemplate;
class Query;
class PadProbeInfo;

//Gst::Iterator<> forward declaration.
template <class CppType>
class Iterator;

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var PadMode PAD_MODE_NONE
 * Pad will not handle dataflow.
 * 
 *  @var PadMode PAD_MODE_PUSH
 * Pad handles dataflow in downstream push mode.
 * 
 *  @var PadMode PAD_MODE_PULL
 * Pad handles dataflow in upstream pull mode.
 * 
 *  @enum PadMode
 * 
 * The status of a GstPad. After activating a pad, which usually happens when the
 * parent element goes from READY to PAUSED, the GstPadMode defines if the
 * pad operates in push or pull mode.
 *
 * @ingroup gstreamermmEnums
 */
enum PadMode
{
  PAD_MODE_NONE,
  PAD_MODE_PUSH,
  PAD_MODE_PULL
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::PadMode> : public Glib::Value_Enum<Gst::PadMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var FlowReturn FLOW_OK
 * Data passing was ok.
 * 
 *  @var FlowReturn FLOW_NOT_LINKED
 * Pad is not linked.
 * 
 *  @var FlowReturn FLOW_FLUSHING
 * Pad is flushing.
 * 
 *  @var FlowReturn FLOW_EOS
 * Pad is EOS.
 * 
 *  @var FlowReturn FLOW_NOT_NEGOTIATED
 * Pad is not negotiated.
 * 
 *  @var FlowReturn FLOW_ERROR
 * Some (fatal) error occurred. Element generating
 * this error should post an error message with more
 * details.
 * 
 *  @var FlowReturn FLOW_NOT_SUPPORTED
 * This operation is not supported.
 * 
 *  @var FlowReturn FLOW_CUSTOM_SUCCESS
 * Elements can use values starting from
 * this (and higher) to define custom success
 * codes.
 * 
 *  @var FlowReturn FLOW_CUSTOM_SUCCESS_1
 * Pre-defined custom success code (define your
 * custom success code to this to avoid compiler
 * warnings).
 * 
 *  @var FlowReturn FLOW_CUSTOM_SUCCESS_2
 * Pre-defined custom success code.
 * 
 *  @var FlowReturn FLOW_CUSTOM_ERROR
 * Elements can use values starting from
 * this (and lower) to define custom error codes.
 * 
 *  @var FlowReturn FLOW_CUSTOM_ERROR_1
 * Pre-defined custom error code (define your
 * custom error code to this to avoid compiler
 * warnings).
 * 
 *  @var FlowReturn FLOW_CUSTOM_ERROR_2
 * Pre-defined custom error code.
 * 
 *  @enum FlowReturn
 * 
 * The result of passing data to a pad.
 * 
 * Note that the custom return values should not be exposed outside of the
 * element scope.
 *
 * @ingroup gstreamermmEnums
 */
enum FlowReturn
{
  FLOW_CUSTOM_SUCCESS_2 = 102,
  FLOW_CUSTOM_SUCCESS_1 = 101,
  FLOW_CUSTOM_SUCCESS = 100,
  FLOW_OK = 0,
  FLOW_NOT_LINKED = -1,
  FLOW_FLUSHING = -2,
  FLOW_EOS = -3,
  FLOW_NOT_NEGOTIATED = -4,
  FLOW_ERROR = -5,
  FLOW_NOT_SUPPORTED = -6,
  FLOW_CUSTOM_ERROR = -100,
  FLOW_CUSTOM_ERROR_1 = -101,
  FLOW_CUSTOM_ERROR_2 = -102
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::FlowReturn> : public Glib::Value_Enum<Gst::FlowReturn>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var PadDirection PAD_UNKNOWN
 * Direction is unknown.
 * 
 *  @var PadDirection PAD_SRC
 * The pad is a source pad.
 * 
 *  @var PadDirection PAD_SINK
 * The pad is a sink pad.
 * 
 *  @enum PadDirection
 * 
 * The direction of a pad.
 *
 * @ingroup gstreamermmEnums
 */
enum PadDirection
{
  PAD_UNKNOWN,
  PAD_SRC,
  PAD_SINK
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::PadDirection> : public Glib::Value_Enum<Gst::PadDirection>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var PadFlags PAD_FLAG_BLOCKED
 * Is dataflow on a pad blocked.
 * 
 *  @var PadFlags PAD_FLAG_FLUSHING
 * Is pad flushing.
 * 
 *  @var PadFlags PAD_FLAG_EOS
 * Is pad in EOS state.
 * 
 *  @var PadFlags PAD_FLAG_BLOCKING
 * Is pad currently blocking on a buffer or event.
 * 
 *  @var PadFlags PAD_FLAG_NEED_PARENT
 * Ensure that there is a parent object before calling
 * into the pad callbacks.
 * 
 *  @var PadFlags PAD_FLAG_NEED_RECONFIGURE
 * The pad should be reconfigured/renegotiated.
 * The flag has to be unset manually after
 * reconfiguration happened.
 * 
 *  @var PadFlags PAD_FLAG_PENDING_EVENTS
 * The pad has pending events.
 * 
 *  @var PadFlags PAD_FLAG_FIXED_CAPS
 * The pad is using fixed caps. This means that
 * once the caps are set on the pad, the default caps query function
 * will only return those caps.
 * 
 *  @var PadFlags PAD_FLAG_PROXY_CAPS
 * The default event and query handler will forward
 * all events and queries to the internally linked pads
 * instead of discarding them.
 * 
 *  @var PadFlags PAD_FLAG_PROXY_ALLOCATION
 * The default query handler will forward
 * allocation queries to the internally linked pads
 * instead of discarding them.
 * 
 *  @var PadFlags PAD_FLAG_PROXY_SCHEDULING
 * The default query handler will forward
 * scheduling queries to the internally linked pads
 * instead of discarding them.
 * 
 *  @var PadFlags PAD_FLAG_ACCEPT_INTERSECT
 * The default accept-caps handler will check
 * it the caps intersect the query-caps result instead
 * of checking for a subset. This is interesting for
 * parsers that can accept incompletely specified caps.
 * 
 *  @var PadFlags PAD_FLAG_ACCEPT_TEMPLATE
 * The default accept-caps handler will use
 * the template pad caps instead of query caps to
 * compare with the accept caps. Use this in combination
 * with Gst::PAD_FLAG_ACCEPT_INTERSECT. (Since 1.6).
 * 
 *  @var PadFlags PAD_FLAG_LAST
 * Offset to define more flags.
 * 
 *  @enum PadFlags
 * 
 * Pad state flags
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%PadFlags operator|(PadFlags, PadFlags)</tt><br>
 * <tt>%PadFlags operator&(PadFlags, PadFlags)</tt><br>
 * <tt>%PadFlags operator^(PadFlags, PadFlags)</tt><br>
 * <tt>%PadFlags operator~(PadFlags)</tt><br>
 * <tt>%PadFlags& operator|=(PadFlags&, PadFlags)</tt><br>
 * <tt>%PadFlags& operator&=(PadFlags&, PadFlags)</tt><br>
 * <tt>%PadFlags& operator^=(PadFlags&, PadFlags)</tt><br>
 */
enum PadFlags
{
  PAD_FLAG_BLOCKED = 0x10,
  PAD_FLAG_FLUSHING = 0x20,
  PAD_FLAG_EOS = 0x40,
  PAD_FLAG_BLOCKING = 0x80,
  PAD_FLAG_NEED_PARENT = 0x100,
  PAD_FLAG_NEED_RECONFIGURE = 0x200,
  PAD_FLAG_PENDING_EVENTS = 0x400,
  PAD_FLAG_FIXED_CAPS = 0x800,
  PAD_FLAG_PROXY_CAPS = 0x1000,
  PAD_FLAG_PROXY_ALLOCATION = 0x2000,
  PAD_FLAG_PROXY_SCHEDULING = 0x4000,
  PAD_FLAG_ACCEPT_INTERSECT = 0x8000,
  PAD_FLAG_ACCEPT_TEMPLATE = 0x10000,
  PAD_FLAG_LAST = 0x100000
};

/** @ingroup gstreamermmEnums */
inline PadFlags operator|(PadFlags lhs, PadFlags rhs)
  { return static_cast<PadFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline PadFlags operator&(PadFlags lhs, PadFlags rhs)
  { return static_cast<PadFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline PadFlags operator^(PadFlags lhs, PadFlags rhs)
  { return static_cast<PadFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline PadFlags operator~(PadFlags flags)
  { return static_cast<PadFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline PadFlags& operator|=(PadFlags& lhs, PadFlags rhs)
  { return (lhs = static_cast<PadFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline PadFlags& operator&=(PadFlags& lhs, PadFlags rhs)
  { return (lhs = static_cast<PadFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline PadFlags& operator^=(PadFlags& lhs, PadFlags rhs)
  { return (lhs = static_cast<PadFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::PadFlags> : public Glib::Value_Flags<Gst::PadFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var PadLinkReturn PAD_LINK_OK
 * Link succeeded.
 * 
 *  @var PadLinkReturn PAD_LINK_WRONG_HIERARCHY
 * Pads have no common grandparent.
 * 
 *  @var PadLinkReturn PAD_LINK_WAS_LINKED
 * Pad was already linked.
 * 
 *  @var PadLinkReturn PAD_LINK_WRONG_DIRECTION
 * Pads have wrong direction.
 * 
 *  @var PadLinkReturn PAD_LINK_NOFORMAT
 * Pads do not have common format.
 * 
 *  @var PadLinkReturn PAD_LINK_NOSCHED
 * Pads cannot cooperate in scheduling.
 * 
 *  @var PadLinkReturn PAD_LINK_REFUSED
 * Refused for some reason.
 * 
 *  @enum PadLinkReturn
 * 
 * Result values from gst_pad_link and friends.
 *
 * @ingroup gstreamermmEnums
 */
enum PadLinkReturn
{
  PAD_LINK_OK = 0,
  PAD_LINK_WRONG_HIERARCHY = -1,
  PAD_LINK_WAS_LINKED = -2,
  PAD_LINK_WRONG_DIRECTION = -3,
  PAD_LINK_NOFORMAT = -4,
  PAD_LINK_NOSCHED = -5,
  PAD_LINK_REFUSED = -6
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::PadLinkReturn> : public Glib::Value_Enum<Gst::PadLinkReturn>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var PadLinkCheck PAD_LINK_CHECK_NOTHING
 * Don't check hierarchy or caps compatibility.
 * 
 *  @var PadLinkCheck PAD_LINK_CHECK_HIERARCHY
 * Check the pads have same parents/grandparents.
 * Could be omitted if it is already known that the two elements that own the
 * pads are in the same bin.
 * 
 *  @var PadLinkCheck PAD_LINK_CHECK_TEMPLATE_CAPS
 * Check if the pads are compatible by using
 * their template caps. This is much faster than @a GST_PAD_LINK_CHECK_CAPS, but
 * would be unsafe e.g. if one pad has Gst::CAPS_ANY.
 * 
 *  @var PadLinkCheck PAD_LINK_CHECK_CAPS
 * Check if the pads are compatible by comparing the
 * caps returned by Gst::Pad::query_caps().
 * 
 *  @var PadLinkCheck PAD_LINK_CHECK_DEFAULT
 * The default checks done when linking
 * pads (i.e. the ones used by Gst::Pad::link()).
 * 
 *  @enum PadLinkCheck
 * 
 * The amount of checking to be done when linking pads. @a GST_PAD_LINK_CHECK_CAPS
 * and @a GST_PAD_LINK_CHECK_TEMPLATE_CAPS are mutually exclusive. If both are
 * specified, expensive but safe @a GST_PAD_LINK_CHECK_CAPS are performed.
 * 
 * <warning>
 * Only disable some of the checks if you are 100% certain you know the link
 * will not fail because of hierarchy/caps compatibility failures. If uncertain,
 * use the default checks (Gst::PAD_LINK_CHECK_DEFAULT) or the regular methods
 * for linking the pads.
 * </warning>
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%PadLinkCheck operator|(PadLinkCheck, PadLinkCheck)</tt><br>
 * <tt>%PadLinkCheck operator&(PadLinkCheck, PadLinkCheck)</tt><br>
 * <tt>%PadLinkCheck operator^(PadLinkCheck, PadLinkCheck)</tt><br>
 * <tt>%PadLinkCheck operator~(PadLinkCheck)</tt><br>
 * <tt>%PadLinkCheck& operator|=(PadLinkCheck&, PadLinkCheck)</tt><br>
 * <tt>%PadLinkCheck& operator&=(PadLinkCheck&, PadLinkCheck)</tt><br>
 * <tt>%PadLinkCheck& operator^=(PadLinkCheck&, PadLinkCheck)</tt><br>
 */
enum PadLinkCheck
{
  PAD_LINK_CHECK_NOTHING = 0x0,
  PAD_LINK_CHECK_HIERARCHY = 1 << 0,
  PAD_LINK_CHECK_TEMPLATE_CAPS = 1 << 1,
  PAD_LINK_CHECK_CAPS = 1 << 2,
  PAD_LINK_CHECK_DEFAULT = 0x5
};

/** @ingroup gstreamermmEnums */
inline PadLinkCheck operator|(PadLinkCheck lhs, PadLinkCheck rhs)
  { return static_cast<PadLinkCheck>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline PadLinkCheck operator&(PadLinkCheck lhs, PadLinkCheck rhs)
  { return static_cast<PadLinkCheck>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline PadLinkCheck operator^(PadLinkCheck lhs, PadLinkCheck rhs)
  { return static_cast<PadLinkCheck>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline PadLinkCheck operator~(PadLinkCheck flags)
  { return static_cast<PadLinkCheck>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline PadLinkCheck& operator|=(PadLinkCheck& lhs, PadLinkCheck rhs)
  { return (lhs = static_cast<PadLinkCheck>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline PadLinkCheck& operator&=(PadLinkCheck& lhs, PadLinkCheck rhs)
  { return (lhs = static_cast<PadLinkCheck>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline PadLinkCheck& operator^=(PadLinkCheck& lhs, PadLinkCheck rhs)
  { return (lhs = static_cast<PadLinkCheck>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::PadLinkCheck> : public Glib::Value_Flags<Gst::PadLinkCheck>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var PadProbeType PAD_PROBE_TYPE_INVALID
 * Invalid probe type.
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_IDLE
 * Probe idle pads and block.
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_BLOCK
 * Probe and block pads.
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_BUFFER
 * Probe buffers.
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_BUFFER_LIST
 * Probe buffer lists.
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_EVENT_DOWNSTREAM
 * Probe downstream events.
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_EVENT_UPSTREAM
 * Probe upstream events.
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_EVENT_FLUSH
 * Probe flush events. This probe has to be
 * explicitly enabled and is not included in the
 * @ @a GST_PAD_PROBE_TYPE_EVENT_DOWNSTREAM or
 * @ @a GST_PAD_PROBE_TYPE_EVENT_UPSTREAM probe types.
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_QUERY_DOWNSTREAM
 * Probe downstream queries.
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_QUERY_UPSTREAM
 * Probe upstream queries.
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_PUSH
 * Probe push.
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_PULL
 * Probe pull.
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_BLOCKING
 * Probe and block at the next opportunity, at data flow or when idle.
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_DATA_DOWNSTREAM
 * Probe downstream data (buffers, buffer lists, and events).
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_DATA_UPSTREAM
 * Probe upstream data (events).
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_DATA_BOTH
 * Probe upstream and downstream data (buffers, buffer lists, and events).
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_BLOCK_DOWNSTREAM
 * Probe and block downstream data (buffers, buffer lists, and events).
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_BLOCK_UPSTREAM
 * Probe and block upstream data (events).
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_EVENT_BOTH
 * Probe upstream and downstream events.
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_QUERY_BOTH
 * Probe upstream and downstream queries.
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_ALL_BOTH
 * Probe upstream events and queries and downstream buffers, buffer lists, events and queries.
 * 
 *  @var PadProbeType PAD_PROBE_TYPE_SCHEDULING
 * Probe push and pull.
 * 
 *  @enum PadProbeType
 * 
 * The different probing types that can occur. When either one of
 *  @a GST_PAD_PROBE_TYPE_IDLE or @a GST_PAD_PROBE_TYPE_BLOCK is used, the probe will be a
 * blocking probe.
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%PadProbeType operator|(PadProbeType, PadProbeType)</tt><br>
 * <tt>%PadProbeType operator&(PadProbeType, PadProbeType)</tt><br>
 * <tt>%PadProbeType operator^(PadProbeType, PadProbeType)</tt><br>
 * <tt>%PadProbeType operator~(PadProbeType)</tt><br>
 * <tt>%PadProbeType& operator|=(PadProbeType&, PadProbeType)</tt><br>
 * <tt>%PadProbeType& operator&=(PadProbeType&, PadProbeType)</tt><br>
 * <tt>%PadProbeType& operator^=(PadProbeType&, PadProbeType)</tt><br>
 */
enum PadProbeType
{
  PAD_PROBE_TYPE_INVALID = 0x0,
  PAD_PROBE_TYPE_IDLE = (1 << 0),
  PAD_PROBE_TYPE_BLOCK = (1 << 1),
  PAD_PROBE_TYPE_BUFFER = (1 << 4),
  PAD_PROBE_TYPE_BUFFER_LIST = (1 << 5),
  PAD_PROBE_TYPE_EVENT_DOWNSTREAM = (1 << 6),
  PAD_PROBE_TYPE_EVENT_UPSTREAM = (1 << 7),
  PAD_PROBE_TYPE_EVENT_FLUSH = (1 << 8),
  PAD_PROBE_TYPE_QUERY_DOWNSTREAM = (1 << 9),
  PAD_PROBE_TYPE_QUERY_UPSTREAM = (1 << 10),
  PAD_PROBE_TYPE_PUSH = (1 << 12),
  PAD_PROBE_TYPE_PULL = (1 << 13),
  PAD_PROBE_TYPE_BLOCKING = 0x3,
  PAD_PROBE_TYPE_DATA_DOWNSTREAM = 0x70,
  PAD_PROBE_TYPE_DATA_UPSTREAM = 0x80,
  PAD_PROBE_TYPE_DATA_BOTH = 0xF0,
  PAD_PROBE_TYPE_BLOCK_DOWNSTREAM = 0x72,
  PAD_PROBE_TYPE_BLOCK_UPSTREAM = 0x82,
  PAD_PROBE_TYPE_EVENT_BOTH = 0xC0,
  PAD_PROBE_TYPE_QUERY_BOTH = 0x600,
  PAD_PROBE_TYPE_ALL_BOTH = 0x6F0,
  PAD_PROBE_TYPE_SCHEDULING = 0x3000
};

/** @ingroup gstreamermmEnums */
inline PadProbeType operator|(PadProbeType lhs, PadProbeType rhs)
  { return static_cast<PadProbeType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline PadProbeType operator&(PadProbeType lhs, PadProbeType rhs)
  { return static_cast<PadProbeType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline PadProbeType operator^(PadProbeType lhs, PadProbeType rhs)
  { return static_cast<PadProbeType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline PadProbeType operator~(PadProbeType flags)
  { return static_cast<PadProbeType>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline PadProbeType& operator|=(PadProbeType& lhs, PadProbeType rhs)
  { return (lhs = static_cast<PadProbeType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline PadProbeType& operator&=(PadProbeType& lhs, PadProbeType rhs)
  { return (lhs = static_cast<PadProbeType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline PadProbeType& operator^=(PadProbeType& lhs, PadProbeType rhs)
  { return (lhs = static_cast<PadProbeType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::PadProbeType> : public Glib::Value_Flags<Gst::PadProbeType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var PadProbeReturn PAD_PROBE_OK
 * Normal probe return value. This leaves the probe in
 * place, and defers decisions about dropping or passing data to other
 * probes, if any. If there are no other probes, the default behaviour
 * for the probe type applies (block for blocking probes, and pass for
 * non-blocking probes).
 * 
 *  @var PadProbeReturn PAD_PROBE_DROP
 * Drop data in data probes. For push mode this means that
 * the data item is not sent downstream. For pull mode, it means that
 * the data item is not passed upstream. In both cases, no more probes
 * are called and Gst::FLOW_OK or <tt>true</tt> is returned to the caller.
 * 
 *  @var PadProbeReturn PAD_PROBE_REMOVE
 * Remove this probe.
 * 
 *  @var PadProbeReturn PAD_PROBE_PASS
 * Pass the data item in the block probe and block on the
 * next item.
 * 
 *  @var PadProbeReturn PAD_PROBE_HANDLED
 * Data has been handled in the probe and will not be
 * forwarded further. For events and buffers this is the same behaviour as
 *  @a GST_PAD_PROBE_DROP (except that in this case you need to unref the buffer
 * or event yourself). For queries it will also return <tt>true</tt> to the caller.
 * The probe can also modify the Gst::FlowReturn value by using the
 * Gst::PAD_PROBE_INFO_FLOW_RETURN() accessor.
 * Note that the resulting query must contain valid entries.
 * @newin{1,6}
 * 
 *  @enum PadProbeReturn
 * 
 * Different return values for the Gst::SlotPadProbe.
 *
 * @ingroup gstreamermmEnums
 */
enum PadProbeReturn
{
  PAD_PROBE_DROP,
  PAD_PROBE_OK,
  PAD_PROBE_REMOVE,
  PAD_PROBE_PASS,
  PAD_PROBE_HANDLED
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::PadProbeReturn> : public Glib::Value_Enum<Gst::PadProbeReturn>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{


/** A class that represents objects contained by elements that allows links to
 * other elements.
 * A Gst::Element is linked to other elements via "pads", which are extremely
 * light-weight generic link points. After two pads are retrieved from an
 * element with Element::get_pad(), the pads can be link with link(). (For
 * quick links, you can also use Element::link(), which will make the obvious
 * link for you if it's straightforward.)
 *
 * Pads are typically created from a Gst::PadTemplate with the create() method
 * that takes a Gst::PadTemplate.
 *
 * Pads without pad templates can be created with create(), which takes a
 * direction and a name as an argument.
 *
 * get_parent_element() will retrieve the Gst::Element that owns the pad.
 *
 * A Gst::Element creating a pad will typically use the underlying C API to
 * register callbacks for various events on the pads.
 *
 * Elements will use push() and pull_range() to push out or pull in a buffer.
 *
 * To send a Gst::Event on a pad, use send_event() and push_event().
 *
 * Last reviewed on 2016-06-06 (1.8.0)
 */

class Pad : public Object 
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Pad;
  using CppClassType = Pad_Class;
  using BaseObjectType = GstPad;
  using BaseClassType = GstPadClass;

  // noncopyable
  Pad(const Pad&) = delete;
  Pad& operator=(const Pad&) = delete;

private:  friend class Pad_Class;
  static CppClassType pad_class_;

protected:
  explicit Pad(const Glib::ConstructParams& construct_params);
  explicit Pad(GstPad* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Pad(Pad&& src) noexcept;
  Pad& operator=(Pad&& src) noexcept;

  ~Pad() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstPad*       gobj()       { return reinterpret_cast<GstPad*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstPad* gobj() const { return reinterpret_cast<GstPad*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstPad* gobj_copy();

private:


protected:
  /** Constructs a Pad given a name and a direction.
   * @param name The desired name of the pad.
   * @param direction The desired direction of the pad.
   */
    explicit Pad(const Glib::ustring& name, PadDirection direction);


  /** Constructs a Pad given a direction without specifying a name.  A unique
   * name will be assigned to the pad.
   * @param direction the direction of the pad.
   */
  explicit Pad(PadDirection direction);

  /** Constructs a Pad from a PadTemplate with the specified name.
   * @param templ The PadTemplate.
   * @param name The desired name of the pad.
   * @throw std::runtime_error if construction fails.
   */
  Pad(const Glib::RefPtr<const Gst::PadTemplate>& templ,
    const Glib::ustring& name);

  /** Constructs a Pad from a PadTemplate without specifying a name.  A unique
   * name will ge assigned to the pad.
   * @param templ The PadTemplate.
   * @throw std::runtime_error if construction fails.
   */
  explicit Pad(const Glib::RefPtr<const Gst::PadTemplate>& templ);

public:
  /** For example,
   * bool on_have_data(const Glib::RefPtr<Gst::Pad>& pad, const
   * Glib::RefPtr<Gst::MiniObjec>& data);.
   */
  typedef sigc::slot< PadProbeReturn, const Glib::RefPtr<Gst::Pad>&, const Gst::PadProbeInfo& > SlotProbe;

  typedef sigc::slot< Gst::FlowReturn, const Glib::RefPtr<Gst::Pad>&, /*transfer full*/ Glib::RefPtr<Gst::Buffer>& > SlotChain;

  typedef sigc::slot< gboolean, const Glib::RefPtr<Gst::Pad>&, /*transfer full*/Glib::RefPtr<Gst::Event>& > SlotEvent;

  typedef sigc::slot< gboolean, const Glib::RefPtr<Gst::Pad>&, /*transfer none*/ Glib::RefPtr<Gst::Query>& > SlotQuery;

  typedef sigc::slot< bool, const Glib::RefPtr<Gst::Pad>& > SlotActivate;

  typedef sigc::slot< bool, const Glib::RefPtr<Gst::Pad>&, Gst::PadMode, bool > SlotActivatemode;

  typedef sigc::slot< Gst::FlowReturn, const Glib::RefPtr<Gst::Pad>&, guint64, guint, Glib::RefPtr<Gst::Buffer>& > SlotGetrange;

  /** Creates a new pad with the given name in the given direction.
   *
   * @param name The name of the new pad.
   * @param dir The PadDirection of the pad.
   * @return A new Gst::Pad, or a null RefPtr<> in case of an error. MT safe.
   */
  
  static Glib::RefPtr<Pad> create(const Glib::ustring& name, PadDirection dir);


  /** Creates a new pad with a guaranteed unique name (across all pads) in the
   * given direction.
   *
   * @param dir The PadDirection of the pad.
   * @return A new Gst::Pad, or a null RefPtr<> in case of an error. MT safe.
   */
  
  static Glib::RefPtr<Pad> create(PadDirection dir);


  /** Creates a new pad with the given name from the given template.
   *
   * @param pad_template The pad template to use.
   *
   * @return A new Gst::Pad, or a null RefPtr<> in case of an error.
   * @throw std::runtime_error if construction fails.
   */
  
  static Glib::RefPtr<Pad> create(const Glib::RefPtr<const Gst::PadTemplate>& pad_template);


  /** Creates a new pad with a guaranteed unique name (across all pads) from
   * the given template.
   *
   * @param pad_template The pad template to use.
   * @param name The name of the pad.
   * 
   * @return A new Gst::Pad, or a null RefPtr<> in case of an error.
   * @throw std::runtime_error if construction fails.
   */
  
  static Glib::RefPtr<Pad> create(const Glib::RefPtr<const Gst::PadTemplate>& pad_template, const Glib::ustring& name);


  Gst::PadMode get_mode() const;

  
  /** Gets the capabilities this pad can produce or consume.
   * Note that this method doesn't necessarily return the caps set by sending a
   * Gst::Event::new_caps() - use get_current_caps() for that instead.
   * gst_pad_query_caps returns all possible caps a pad can operate with, using
   * the pad's CAPS query function, If the query fails, this function will return
   *  @a caps, if not <tt>nullptr</tt>, otherwise ANY.
   * 
   * When called on sinkpads @a caps contains the caps that
   * upstream could produce in the order preferred by upstream. When
   * called on srcpads @a caps contains the caps accepted by
   * downstream in the preferred order. @a caps might be <tt>nullptr</tt> but
   * if it is not <tt>nullptr</tt> the returned caps will be a subset of @a caps.
   * 
   * Note that this function does not return writable Gst::Caps, use
   * gst_caps_make_writable() before modifying the caps.
   * 
   * @param caps Suggested Gst::Caps, or <tt>nullptr</tt>.
   * @return The caps of the pad with incremented ref-count.
   */
  Glib::RefPtr<Gst::Caps> query_caps(Glib::RefPtr<Gst::Caps> caps);
  
  /** Gets the capabilities this pad can produce or consume.
   * Note that this method doesn't necessarily return the caps set by sending a
   * Gst::Event::new_caps() - use get_current_caps() for that instead.
   * gst_pad_query_caps returns all possible caps a pad can operate with, using
   * the pad's CAPS query function, If the query fails, this function will return
   *  @a caps, if not <tt>nullptr</tt>, otherwise ANY.
   * 
   * When called on sinkpads @a caps contains the caps that
   * upstream could produce in the order preferred by upstream. When
   * called on srcpads @a caps contains the caps accepted by
   * downstream in the preferred order. @a caps might be <tt>nullptr</tt> but
   * if it is not <tt>nullptr</tt> the returned caps will be a subset of @a caps.
   * 
   * Note that this function does not return writable Gst::Caps, use
   * gst_caps_make_writable() before modifying the caps.
   * 
   * @param caps Suggested Gst::Caps, or <tt>nullptr</tt>.
   * @return The caps of the pad with incremented ref-count.
   */
  Glib::RefPtr<const Gst::Caps> query_caps(Glib::RefPtr<Gst::Caps> caps) const;

  
  /** Gets the direction of the pad. The direction of the pad is
   * decided at construction time so this function does not take
   * the LOCK.
   * 
   * @return The Gst::PadDirection of the pad.
   * 
   * MT safe.
   */
  PadDirection get_direction() const;
  
  /** Gets the parent of @a pad, cast to a Gst::Element. If a @a pad has no parent or
   * its parent is not an element, return <tt>nullptr</tt>.
   * 
   * @return The parent of the pad. The
   * caller has a reference on the parent, so unref when you're finished
   * with it.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::Element> get_parent_element();
  
  /** Gets the parent of @a pad, cast to a Gst::Element. If a @a pad has no parent or
   * its parent is not an element, return <tt>nullptr</tt>.
   * 
   * @return The parent of the pad. The
   * caller has a reference on the parent, so unref when you're finished
   * with it.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Gst::Element> get_parent_element() const;
  
  /** Gets the template for @a pad.
   * 
   * @return The Gst::PadTemplate from which
   * this pad was instantiated, or <tt>nullptr</tt> if this pad has no
   * template. Unref after usage.
   */
  Glib::RefPtr<Gst::PadTemplate> get_pad_template();
  
  /** Gets the template for @a pad.
   * 
   * @return The Gst::PadTemplate from which
   * this pad was instantiated, or <tt>nullptr</tt> if this pad has no
   * template. Unref after usage.
   */
  Glib::RefPtr<const Gst::PadTemplate> get_pad_template() const;
  
  /** Links the source pad and the sink pad.
   * 
   * @param sink_pad The sink Gst::Pad to link.
   * @return A result code indicating if the connection worked or
   * what went wrong.
   * 
   * MT Safe.
   */
  PadLinkReturn link(const Glib::RefPtr<Gst::Pad>& sink_pad);
  
  /** Unlinks the source pad from the sink pad. Will emit the Gst::Pad::signal_unlinked()
   * signal on both pads.
   * 
   * @param sink_pad The sink Gst::Pad to unlink.
   * @return <tt>true</tt> if the pads were unlinked. This function returns <tt>false</tt> if
   * the pads were not linked together.
   * 
   * MT safe.
   */
  bool unlink(const Glib::RefPtr<Gst::Pad>& sink_pad);
  
  /** Checks if a @a pad is linked to another pad or not.
   * 
   * @return <tt>true</tt> if the pad is linked, <tt>false</tt> otherwise.
   * 
   * MT safe.
   */
  bool is_linked() const;
  
  /** Checks if the source pad and the sink pad are compatible so they can be
   * linked.
   * 
   * @param other_pad The sink Gst::Pad.
   * @return <tt>true</tt> if the pads can be linked.
   */
  bool can_link(const Glib::RefPtr<const Gst::Pad>& other_pad) const;

  
  /** Gets the capabilities of the allowed media types that can flow through
   *  @a pad and its peer.
   * 
   * The allowed capabilities is calculated as the intersection of the results of
   * calling query_caps() on @a pad and its peer. The caller owns a reference
   * on the resulting caps.
   * 
   * @return The allowed Gst::Caps of the
   * pad link. Unref the caps when you no longer need it. This
   * function returns <tt>nullptr</tt> when @a pad has no peer.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::Caps> get_allowed_caps();
  
  /** Gets the capabilities of the allowed media types that can flow through
   *  @a pad and its peer.
   * 
   * The allowed capabilities is calculated as the intersection of the results of
   * calling query_caps() on @a pad and its peer. The caller owns a reference
   * on the resulting caps.
   * 
   * @return The allowed Gst::Caps of the
   * pad link. Unref the caps when you no longer need it. This
   * function returns <tt>nullptr</tt> when @a pad has no peer.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Gst::Caps> get_allowed_caps() const;

  
  /** Gets the capabilities for @a pad's template.
   * 
   * @return The Gst::Caps of this pad template.
   * Unref after usage.
   */
  Glib::RefPtr<Gst::Caps> get_pad_template_caps();
  
  /** Gets the capabilities for @a pad's template.
   * 
   * @return The Gst::Caps of this pad template.
   * Unref after usage.
   */
  Glib::RefPtr<const Gst::Caps> get_pad_template_caps() const;

  gulong add_probe(PadProbeType mask, const SlotProbe& slot);
  
  
  /** Remove the probe with @a id from @a pad.
   * 
   * MT safe.
   * 
   * @param id The probe id to remove.
   */
  void remove_probe(gulong id);

  
  /** Gets the peer of @a pad. This function refs the peer pad so
   * you need to unref it after use.
   * 
   * @return The peer Gst::Pad. Unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::Pad> get_peer();
  
  /** Gets the peer of @a pad. This function refs the peer pad so
   * you need to unref it after use.
   * 
   * @return The peer Gst::Pad. Unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Gst::Pad> get_peer() const;

  
  /** A helper function you can use that sets the FIXED_CAPS flag
   * This way the default CAPS query will always return the negotiated caps
   * or in case the pad is not negotiated, the padtemplate caps.
   * 
   * The negotiated caps are the caps of the last CAPS event that passed on the
   * pad. Use this function on a pad that, once it negotiated to a CAPS, cannot
   * be renegotiated to something else.
   */
  void use_fixed_caps();
  
  /** Query if a pad is active
   * 
   * @return <tt>true</tt> if the pad is active.
   * 
   * MT safe.
   */
  bool is_active() const;


  /** Checks if the pad is blocked or not. This function returns the
   * last requested state of the pad. It is not certain that the pad
   * is actually blocking at this point (see is_blocking()).
   * 
   * @return <tt>true</tt> if the pad is blocked.
   * 
   * MT safe.
   */
  bool is_blocked() const;
  
  /** Checks if the pad is blocking or not. This is a guaranteed state
   * of whether the pad is actually blocking on a Gst::Buffer or a Gst::Event.
   * 
   * @return <tt>true</tt> if the pad is blocking.
   * 
   * MT safe.
   */
  bool is_blocking() const;

  
  /** Mark a pad for needing reconfiguration. The next call to
   * check_reconfigure() will return <tt>true</tt> after this call.
   */
  void mark_reconfigure();
  
  /** Check the Gst::PAD_FLAG_NEED_RECONFIGURE flag on @a pad and return <tt>true</tt>
   * if the flag was set.
   * 
   * @return <tt>true</tt> is the GST_PAD_FLAG_NEED_RECONFIGURE flag is set on @a pad.
   */
  bool needs_reconfigure() const;
  
  /** Check and clear the Gst::PAD_FLAG_NEED_RECONFIGURE flag on @a pad and return <tt>true</tt>
   * if the flag was set.
   * 
   * @return <tt>true</tt> is the GST_PAD_FLAG_NEED_RECONFIGURE flag was set on @a pad.
   */
  bool check_reconfigure();

  
  /** Check if @a pad has caps set on it with a Gst::EVENT_CAPS event.
   * 
   * @return <tt>true</tt> when @a pad has caps associated with it.
   */
  bool has_current_caps() const;

  
  /** Creates a stream-id for the source Gst::Pad @a pad by combining the
   * upstream information with the optional @a stream_id of the stream
   * of @a pad. @a pad must have a parent Gst::Element and which must have zero
   * or one sinkpad. @a stream_id can only be <tt>nullptr</tt> if the parent element
   * of @a pad has only a single source pad.
   * 
   * This function generates an unique stream-id by getting the upstream
   * stream-start event stream ID and appending @a stream_id to it. If the
   * element has no sinkpad it will generate an upstream stream-id by
   * doing an URI query on the element and in the worst case just uses
   * a random number. Source elements that don't implement the URI
   * handler interface should ideally generate a unique, deterministic
   * stream-id manually instead.
   * 
   * Since stream IDs are sorted alphabetically, any numbers in the
   * stream ID should be printed with a fixed number of characters,
   * preceded by 0's, such as by using the format \\%03u instead of \\%u.
   * 
   * @param parent Parent Gst::Element of @a pad.
   * @param stream_id The stream-id.
   * @return A stream-id for @a pad.
   */
  Glib::ustring create_stream_id(const Glib::RefPtr<Gst::Element>& parent, const Glib::ustring& stream_id);
  
  /** Returns the current stream-id for the @a pad, or <tt>nullptr</tt> if none has been
   * set yet, i.e.\ the pad has not received a stream-start event yet.
   * 
   * This is a convenience wrapper around get_sticky_event() and
   * Gst::Event::parse_stream_start().
   * 
   * The returned stream-id string should be treated as an opaque string, its
   * contents should not be interpreted.
   * 
   * @return A newly-allocated copy of the stream-id for
   *  @a pad, or <tt>nullptr</tt>.
   */
  Glib::ustring get_stream_id() const;

  
  /** Set the offset that will be applied to the running time of @a pad.
   * 
   * @param offset The offset.
   */
  void set_offset(gint64 offset);
  
  /** Get the offset applied to the running time of @a pad. @a pad has to be a source
   * pad.
   * 
   * @return The offset.
   */
  gint64 get_offset() const;

  
  /** Set the given private data gpointer on the pad.
   * This function can only be used by the element that owns the pad.
   * No locking is performed in this function.
   * 
   * @param priv The private data to attach to the pad.
   */
  void set_element_private(gpointer priv);
  
  /** Gets the private data of a pad.
   * No locking is performed in this function.
   * 
   * @return A #gpointer to the private data.
   */
  gpointer get_element_private();


  //This is handwritten because conversion from Glib::RefPtr<Gst::Buffer>& to
  //GstBuffer** is difficult.
  /** When pad is flushing this function returns Gst::FLOW_WRONG_STATE
   * immediatly.  Calls the getrange function of pad.  If pad has no getrange
   * function installed this function returns Gst::FLOW_NOT_SUPPORTED.
   *
   * This is a lowlevel function. Usually pull_range() is used.  This function
   * is designed to be used with a source pad only.
   *
   * @param offset The start offset of the buffer.
   * @param size The length of the buffer.
   * @param buffer An unitialized Glib::RefPtr<> in which to store the
   * Gst::Buffer.
   * @return A Gst::FlowReturn from the pad (Gst::FLOW_NOT_SUPPORTED if pad is
   * not a source pad). MT safe.
   */
  FlowReturn get_range(guint64 offset, guint size, Glib::RefPtr<Gst::Buffer>& buffer);
  

  /** Check if the given pad accepts the caps.
   * 
   * @param caps A Gst::Caps to check on the pad.
   * @return <tt>true</tt> if the pad can accept the caps.
   */
  bool query_accept_caps(const Glib::RefPtr<const Gst::Caps>& caps) const;
  
  /** Calls query_caps() for all internally linked pads of @a pad and returns
   * the intersection of the results.
   * 
   * This function is useful as a default caps query function for an element
   * that can handle any stream format, but requires all its pads to have
   * the same caps.  Two such elements are tee and adder.
   * 
   * @param query A CAPS Gst::Query.
   * @return <tt>true</tt> if @a query could be executed.
   */
  bool proxy_query_caps(const Glib::RefPtr<Gst::Query>& query) const;
  //gtkmmproc error: gst_pad_proxy_accept_caps : method defs lookup failed (1)
  
  /** Check if the peer of @a pad accepts @a caps. If @a pad has no peer, this function
   * returns <tt>true</tt>.
   * 
   * @param caps A Gst::Caps to check on the pad.
   * @return <tt>true</tt> if the peer of @a pad can accept the caps or @a pad has no peer.
   */
  bool peer_query_accept_caps(const Glib::RefPtr<const Gst::Caps>& caps) const;
  
  /** Queries the peer of a given sink pad for the stream position.
   * 
   * @param format The Gst::Format requested.
   * @param cur A location in which to store the current
   * position, or <tt>nullptr</tt>.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool peer_query_position(Gst::Format format, gint64& cur) const;
  
  /** Queries the peer pad of a given sink pad for the total stream duration.
   * 
   * @param format The Gst::Format requested.
   * @param duration A location in which to store the total
   * duration, or <tt>nullptr</tt>.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool peer_query_duration(Gst::Format format, gint64& duration) const;
  
  /** Pushes a buffer to the peer of @a pad.
   * 
   * This function will call installed block probes before triggering any
   * installed data probes.
   * 
   * The function proceeds calling chain() on the peer pad and returns
   * the value from that function. If @a pad has no peer, Gst::FLOW_NOT_LINKED will
   * be returned.
   * 
   * In all cases, success or failure, the caller loses its reference to @a buffer
   * after calling this function.
   * 
   * @param buffer The Gst::Buffer to push returns GST_FLOW_ERROR
   * if not.
   * @return A Gst::FlowReturn from the peer pad.
   * 
   * MT safe.
   */
  FlowReturn push(Glib::RefPtr<Gst::Buffer>&& buffer);

  
  /** Sends the event to the peer of the given pad. This function is
   * mainly used by elements to send events to their peer
   * elements.
   * 
   * This function takes ownership of the provided event so you should
   * Gst::Event::ref() it if you want to reuse the event after this call.
   * 
   * @param event The Gst::Event to send to the pad.
   * @return <tt>true</tt> if the event was handled.
   * 
   * MT safe.
   */
  bool push_event(Glib::RefPtr<Gst::Event>&& event);

  /// A push_event() convenience overload. Allows to re-use @a event parameter after function call.
  bool push_event(const Glib::RefPtr<Gst::Event>& event);

  /** Pulls a buffer from the peer pad.  This function will first trigger the
   * pad block signal if it was installed.  This method works only on sink
   * pads.
   *
   * When pad is not linked Gst::FLOW_NOT_LINKED is returned else this function
   * returns the result of get_range() on the peer pad.
   *
   * @a buffer's caps must either be unset or the same as what is already
   * configured on pad. Renegotiation within a running pull-mode pipeline is
   * not supported.
   *
   * @param offset The start offset of the buffer.
   * @param size The length of the buffer.
   * @param buffer An uninitialized Glib::RefPtr<> in which to hold the
   * Gst::Buffer.
   * @return A Gst::FlowReturn from the peer pad (Gst::FLOW_ERROR if pad is not
   * a sink pad). When this function returns Gst::FLOW_OK, buffer will contain
   * a valid Gst::Buffer. @a buffer may not be used when any other return value
   * than Gst::FLOW_OK is returned. MT safe.
   */
  FlowReturn pull_range(guint64 offset, guint size, Glib::RefPtr<Gst::Buffer>& buffer);
  

  /** Sends the event to the pad. This function can be used
   * by applications to send events in the pipeline.
   * 
   * If @a pad is a source pad, @a event should be an upstream event. If @a pad is a
   * sink pad, @a event should be a downstream event. For example, you would not
   * send a Gst::EVENT_EOS on a src pad; EOS events only propagate downstream.
   * Furthermore, some downstream events have to be serialized with data flow,
   * like EOS, while some can travel out-of-band, like Gst::EVENT_FLUSH_START. If
   * the event needs to be serialized with data flow, this function will take the
   * pad's stream lock while calling its event function.
   * 
   * To find out whether an event type is upstream, downstream, or downstream and
   * serialized, see Gst::EventTypeFlags, Gst::Event::type_get_flags(),
   * Gst::EVENT_IS_UPSTREAM, Gst::EVENT_IS_DOWNSTREAM, and
   * Gst::EVENT_IS_SERIALIZED. Note that in practice that an application or
   * plugin doesn't need to bother itself with this information; the core handles
   * all necessary locks and checks.
   * 
   * This function takes ownership of the provided event so you should
   * Gst::Event::ref() it if you want to reuse the event after this call.
   * 
   * @param event The Gst::Event to send to the pad.
   * @return <tt>true</tt> if the event was handled.
   */
  bool send_event(Glib::RefPtr<Gst::Event>&& event);

  /// A send_event() convenience overload. Allows to re-use @a event parameter after function call.
  bool send_event(const Glib::RefPtr<Gst::Event>& event);

  
  /** Activates or deactivates the given pad in @a mode via dispatching to the
   * pad's activatemodefunc. For use from within pad activation functions only.
   * 
   * If you don't know what this is, you probably don't want to call it.
   * 
   * @param mode The requested activation mode.
   * @param active Whether or not the pad should be active.
   * @return <tt>true</tt> if the operation was successful.
   * 
   * MT safe.
   */
  bool activate_mode(Gst::PadMode mode, bool active =  true);
  
  /** Invokes the default event handler for the given pad.
   * 
   * The EOS event will pause the task associated with @a pad before it is forwarded
   * to all internally linked pads,
   * 
   * The event is sent to all pads internally linked to @a pad. This function
   * takes ownership of @a event.
   * 
   * @param parent The parent of @a pad or <tt>nullptr</tt>.
   * @param event The Gst::Event to handle.
   * @return <tt>true</tt> if the event was sent successfully.
   */
  bool event_default(const Glib::RefPtr<Gst::Object>& parent, Glib::RefPtr<Gst::Event>&& event);

  /// A event_default() convenience overload.
  bool event_default(Glib::RefPtr<Gst::Event>&& event);
  
  /** Dispatches a query to a pad. The query should have been allocated by the
   * caller via one of the type-specific allocation functions. The element that
   * the pad belongs to is responsible for filling the query with an appropriate
   * response, which should then be parsed with a type-specific query parsing
   * function.
   * 
   * Again, the caller is responsible for both the allocation and deallocation of
   * the query structure.
   * 
   * Please also note that some queries might need a running pipeline to work.
   * 
   * @param query The Gst::Query to perform.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query(const Glib::RefPtr<Gst::Query>& query) const;
  
  /** Performs query() on the peer of @a pad.
   * 
   * The caller is responsible for both the allocation and deallocation of
   * the query structure.
   * 
   * @param query The Gst::Query to perform.
   * @return <tt>true</tt> if the query could be performed. This function returns <tt>false</tt>
   * if @a pad has no peer.
   */
  bool peer_query(const Glib::RefPtr<Gst::Query>& query) const;
  
  /** Gets the capabilities of the peer connected to this pad. Similar to
   * query_caps().
   * 
   * When called on srcpads @a filter contains the caps that
   * upstream could produce in the order preferred by upstream. When
   * called on sinkpads @a filter contains the caps accepted by
   * downstream in the preferred order. @a filter might be <tt>nullptr</tt> but
   * if it is not <tt>nullptr</tt> the returned caps will be a subset of @a filter.
   * 
   * @param filter A Gst::Caps filter, or <tt>nullptr</tt>.
   * @return The caps of the peer pad with incremented
   * ref-count. When there is no peer pad, this function returns @a filter or,
   * when @a filter is <tt>nullptr</tt>, ANY caps.
   */
  Glib::RefPtr<Gst::Caps> peer_query_caps(const Glib::RefPtr<Gst::Caps>& filter) const;
  
  /** Invokes the default query handler for the given pad.
   * The query is sent to all pads internally linked to @a pad. Note that
   * if there are many possible sink pads that are internally linked to
   *  @a pad, only one will be sent the query.
   * Multi-sinkpad elements should implement custom query handlers.
   * 
   * @param parent The parent of @a pad or <tt>nullptr</tt>.
   * @param query The Gst::Query to handle.
   * @return <tt>true</tt> if the query was performed successfully.
   */
  bool query_default(const Glib::RefPtr<Gst::Object>& parent, const Glib::RefPtr<Gst::Query>& query) const;

  /// A query_default() convenience overload.
  bool query_default(const Glib::RefPtr<Gst::Query>& query) const;
  
  /** Queries a pad for the stream position.
   * 
   * @param format The Gst::Format requested.
   * @param position A location in which to store the current position, or <tt>nullptr</tt>.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query_position(Format format, gint64& position) const;

  /** Queries a pad for the stream position parsing only the format.
   * @param format A reference to the Gst::Format asked for. On return contains
   * the Gst::Format used.
   * @return true if the query could be performed.
   */
  bool query_position(Format& format) const;

  
  /** Queries a pad for the total stream duration.
   * 
   * @param format The Gst::Format requested.
   * @param duration A location in which to store the total
   * duration, or <tt>nullptr</tt>.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query_duration(Format format, gint64& duration) const;

  /** Queries a pad for the total stream duration parsing only the format.
   * @param format A reference to the Gst::Format asked for. On return contains
   * the GstFormat used.
   * @return true if the query could be performed.
   */
  bool query_duration(Format& format) const;

  
  /** Queries a pad to convert @a src_value in @a src_format to @a dst_format.
   * 
   * @param src_format A Gst::Format to convert from.
   * @param src_value A value to convert.
   * @param dst_format The Gst::Format to convert to.
   * @param dst_value A pointer to the result.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query_convert(Format src_format, gint64 src_value, Format dst_format, gint64& dst_value) const;


  /** Queries the peer pad of a given sink pad to convert @a src_value in @a src_format
   * to @a dst_format.
   * 
   * @param src_format A Gst::Format to convert from.
   * @param src_value A value to convert.
   * @param dst_format The Gst::Format to convert to.
   * @param dst_value A pointer to the result.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool peer_query_convert(Format src_format, gint64 src_value, Format dst_format, gint64& dst_value) const;

  
  /** Gets an iterator for the pads to which the given pad is linked to inside
   * of the parent element.
   * 
   * Each Gst::Pad element yielded by the iterator will have its refcount increased,
   * so unref after use.
   * 
   * Free-function: gst_iterator_free
   * 
   * @return A new Gst::Iterator of Gst::Pad
   * or <tt>nullptr</tt> when the pad does not have an iterator function
   * configured. Use Gst::Iterator::free() after usage.
   */
  Gst::Iterator<Gst::Pad> iterate_internal_links();
  
  /** Gets an iterator for the pads to which the given pad is linked to inside
   * of the parent element.
   * 
   * Each Gst::Pad element yielded by the iterator will have its refcount increased,
   * so unref after use.
   * 
   * Free-function: gst_iterator_free
   * 
   * @return A new Gst::Iterator of Gst::Pad
   * or <tt>nullptr</tt> when the pad does not have an iterator function
   * configured. Use Gst::Iterator::free() after usage.
   */
  Gst::Iterator<const Gst::Pad> iterate_internal_links() const;
  
  /** Iterate the list of pads to which the given pad is linked to inside of
   * the parent element.
   * This is the default handler, and thus returns an iterator of all of the
   * pads inside the parent element with opposite direction.
   * 
   * The caller must free this iterator after use with Gst::Iterator::free().
   * 
   * @param parent The parent of @a pad or <tt>nullptr</tt>.
   * @return A Gst::Iterator of Gst::Pad, or <tt>nullptr</tt> if @a pad
   * has no parent. Unref each returned pad with Gst::Object::unref().
   */
  Gst::Iterator<Gst::Pad> iterate_internal_links_default(const Glib::RefPtr<Gst::Object>& parent);

  /// A iterate_internal_links_default() convenience overload.
  Gst::Iterator<Gst::Pad> iterate_internal_links_default();
  
  /** Iterate the list of pads to which the given pad is linked to inside of
   * the parent element.
   * This is the default handler, and thus returns an iterator of all of the
   * pads inside the parent element with opposite direction.
   * 
   * The caller must free this iterator after use with Gst::Iterator::free().
   * 
   * @param parent The parent of @a pad or <tt>nullptr</tt>.
   * @return A Gst::Iterator of Gst::Pad, or <tt>nullptr</tt> if @a pad
   * has no parent. Unref each returned pad with Gst::Object::unref().
   */
  Gst::Iterator<const Gst::Pad> iterate_internal_links_default(const Glib::RefPtr<Gst::Object>& parent) const;

  /// A iterate_internal_links_default() convenience overload.
  Gst::Iterator<const Gst::Pad> iterate_internal_links_default() const;
  
  /** Chain a buffer to @a pad.
   * 
   * The function returns Gst::FLOW_FLUSHING if the pad was flushing.
   * 
   * If the buffer type is not acceptable for @a pad (as negotiated with a
   * preceding GST_EVENT_CAPS event), this function returns
   * Gst::FLOW_NOT_NEGOTIATED.
   * 
   * The function proceeds calling the chain function installed on @a pad (see
   * gst_pad_set_chain_function()) and the return value of that function is
   * returned to the caller. Gst::FLOW_NOT_SUPPORTED is returned if @a pad has no
   * chain function.
   * 
   * In all cases, success or failure, the caller loses its reference to @a buffer
   * after calling this function.
   * 
   * @param buffer The Gst::Buffer to send, return GST_FLOW_ERROR
   * if not.
   * @return A Gst::FlowReturn from the pad.
   * 
   * MT safe.
   */
  Gst::FlowReturn chain(Glib::RefPtr<Gst::Buffer>&& buffer);

  
  /** Gets the capabilities currently configured on @a pad with the last
   * Gst::EVENT_CAPS event.
   * 
   * @return The current caps of the pad with
   * incremented ref-count or <tt>nullptr</tt> when pad has no caps. Unref after usage.
   */
  Glib::RefPtr<Gst::Caps> get_current_caps();
  
  /** Pause the task of @a pad. This function will also wait until the
   * function executed by the task is finished if this function is not
   * called from the task function.
   * 
   * @return A <tt>true</tt> if the task could be paused or <tt>false</tt> when the pad
   * has no task.
   */
  bool pause_task();
  
  /** Stop the task of @a pad. This function will also make sure that the
   * function executed by the task will effectively stop if not called
   * from the GstTaskFunction.
   * 
   * This function will deadlock if called from the GstTaskFunction of
   * the task. Use Gst::Task::pause() instead.
   * 
   * Regardless of whether the pad has a task, the stream lock is acquired and
   * released so as to ensure that streaming through this pad has finished.
   * 
   * @return A <tt>true</tt> if the task could be stopped or <tt>false</tt> on error.
   */
  bool stop_task();
  
  /** Activates or deactivates the given pad.
   * Normally called from within core state change functions.
   * 
   * If @a active, makes sure the pad is active. If it is already active, either in
   * push or pull mode, just return. Otherwise dispatches to the pad's activate
   * function to perform the actual activation.
   * 
   * If not @a active, calls activate_mode() with the pad's current mode
   * and a <tt>false</tt> argument.
   * 
   * @param active Whether or not the pad should be active.
   * @return <tt>true</tt> if the operation was successful.
   * 
   * MT safe.
   */
  bool set_active(bool active =  true);

  
  /** Gets the Gst::FlowReturn return from the last data passed by this pad.
   */
  Gst::FlowReturn get_last_flow_return() const;

  
  /** Returns a new reference of the sticky event of type @a event_type
   * from the event.
   * 
   * @param event_type The Gst::EventType that should be retrieved.
   * @param idx The index of the event.
   * @return A Gst::Event of type
   *  @a event_type or <tt>nullptr</tt> when no event of @a event_type was on
   *  @a pad. Unref after usage.
   */
  Glib::RefPtr<Gst::Event> get_sticky_event(Gst::EventType event_type, guint idx) const;

  static GstFlowReturn Pad_Chain_gstreamermm_callback(GstPad* pad, GstObject* parent, GstBuffer *buffer);
  void set_chain_function(const SlotChain& slot);
  
  static gboolean Pad_Event_gstreamermm_callback(GstPad* pad, GstObject* parent, GstEvent* event);
  void set_event_function(const SlotEvent& slot);
  
  static gboolean Pad_Query_gstreamermm_callback(GstPad* pad, GstObject* parent, GstQuery* query);
  void set_query_function(const SlotQuery& slot);
  
  static gboolean Pad_Activate_gstreamermm_callback(GstPad* pad, GstObject* parent);
  void set_activate_function(const SlotActivate& slot);
  
  static gboolean Pad_Activatemode_gstreamermm_callback(GstPad* pad, GstObject* parent, GstPadMode mode, gboolean active);
  void set_activatemode_function(const SlotActivatemode& slot);
  
  static GstFlowReturn Pad_Getrange_gstreamermm_callback(GstPad* pad, GstObject* parent, guint64 offset, guint length, GstBuffer **buffer);
  void set_getrange_function(const SlotGetrange& slot);
  

    //C API specific pad callback setting functions are ignored.
    

  /**
   * @par Slot Prototype:
   * <tt>void on_my_%linked(const Glib::RefPtr<Gst::Pad>& peer_pad)</tt>
   *
   * Signals that a pad has been linked to the peer pad.
   * 
   * @param peer_pad The peer pad that has been connected.
   */

  Glib::SignalProxy< void,const Glib::RefPtr<Gst::Pad>& > signal_linked();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%unlinked(const Glib::RefPtr<Gst::Pad>& peer_pad)</tt>
   *
   * Signals that a pad has been unlinked from the peer pad.
   * 
   * @param peer_pad The peer pad that has been disconnected.
   */

  Glib::SignalProxy< void,const Glib::RefPtr<Gst::Pad>& > signal_unlinked();


  /** The capabilities of the pad.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gst::Caps> > property_caps() const;


  /** The direction of the pad.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< PadDirection > property_direction() const;


  /** The GstPadTemplate of this pad.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< PadTemplate > property_template() ;

/** The GstPadTemplate of this pad.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< PadTemplate > property_template() const;

  /** The running time offset of the pad.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< gint64 > property_offset() ;

/** The running time offset of the pad.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< gint64 > property_offset() const;


  /**
   * Checks whether pad is a ghostpad.
   */
  bool is_ghost_pad() const;
  bool is_proxy_pad() const;

  /**
   * Handle exceptions occuring in callback methods
   */
  void exception_handler();

private:
  SlotChain slot_chain;
  SlotEvent slot_event;
  SlotQuery slot_query;
  SlotActivate slot_activate;
  SlotActivatemode slot_activatemode;
  SlotGetrange slot_getrange;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_linked().
  virtual void on_linked(const Glib::RefPtr<Gst::Pad>& peer_pad);
  /// This is a default handler for the signal signal_unlinked().
  virtual void on_unlinked(const Glib::RefPtr<Gst::Pad>& peer_pad);


};

/*! A gstreamermm dynamic Gst::Pad example.
 * @example basics/dynamic_pads.cc
 */

class PadProbeInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = PadProbeInfo;
  using BaseObjectType = GstPadProbeInfo;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:


public:
  PadProbeInfo();
  explicit PadProbeInfo(GstPadProbeInfo& castitem,
      bool take_ownership = false);
  explicit PadProbeInfo(GstPadProbeInfo* castitem,
        bool take_copy = false);
  PadProbeInfo(const PadProbeInfo& other);
  virtual ~PadProbeInfo();

  GstPadProbeInfo* gobj() { return gobj_; };

  const GstPadProbeInfo* gobj() const { return gobj_; };

  gulong get_id() const;
  
  /** @return The Gst::Event from the probe.
   */
  Glib::RefPtr<Gst::Event> get_event();
  
  /** @return The Gst::Event from the probe.
   */
  const Glib::RefPtr<Gst::Event> get_event() const;
  
  /** @return The Gst::Query from the probe.
   */
  Glib::RefPtr<Gst::Query> get_query();
  
  /** @return The Gst::Query from the probe.
   */
  const Glib::RefPtr<Gst::Query> get_query() const;
  
  /** @return The Gst::Buffer from the probe.
   */
  Glib::RefPtr<Gst::Buffer> get_buffer();
  
  /** @return The Gst::Buffer from the probe.
   */
  const Glib::RefPtr<Gst::Buffer> get_buffer() const;
  
  /** @return The Gst::BufferList from the probe.
   */
  Glib::RefPtr<Gst::BufferList> get_buffer_list();
  
  /** @return The Gst::BufferList from the probe.
   */
  const Glib::RefPtr<Gst::BufferList> get_buffer_list() const;
  
  PadProbeType get_type() const;
protected:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  GstPadProbeInfo* gobj_;
  bool take_ownership;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


};

} // namespace Gst

namespace Glib
{
Gst::PadProbeInfo wrap(GstPadProbeInfo* probe_info, bool take_copy);

} // namespace Glib


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Pad
   */
  Glib::RefPtr<Gst::Pad> wrap(GstPad* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_PAD_H */

