## gthumb.m4 - Help macros for gthumb extensions. -*-Shell-script-*-
## Copyright © Paolo Bacchilega <paobac@src.gnome.org>
##
## Started from epiphany.m4, which contains the following copyright note:
## Copyright © Crispin Flowerday <crispin@gnome.org>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
##
## As a special exception to the GNU General Public License, if you
## distribute this file as part of a program that contains a
## configuration script generated by Autoconf, you may include it under
## the same distribution terms that you use for the rest of that program.

# Usage:
#   GTHUMB_EXTENSION_INIT(gthumb-api-version, [gthumb-minimum-version])
#
AC_DEFUN([GTHUMB_EXTENSION_INIT],
[
dnl Check we have an api-version
ifelse([$1], [], [AC_MSG_ERROR([Required gthumb API version not supplied])], [])

_gthumb_api_version=$1

AC_MSG_CHECKING([whether gthumb-$_gthumb_api_version is available])
PKG_CHECK_EXISTS([gthumb-$_gthumb_api_version], [result=yes],[result=no]) 
AC_MSG_RESULT([$result])

if test $result = "no" ; then
    AC_MSG_ERROR([gthumb API version $_gthumb_api_version is required

This API version is used in the $_gthumb_api_version stable series, and
the preceeding development series. Please ensure you have the appropriate
gthumb version installed.])
fi

dnl Check the minimum version
ifelse([$2], [], [],
[
  AC_MSG_CHECKING([whether minimum gthumb version $2 is available])
  PKG_CHECK_EXISTS([gthumb-$_gthumb_api_version >= $2], [result=yes], [result=no])
  AC_MSG_RESULT([$result])

  if test $result = "no" ; then
      AC_MSG_ERROR([The minimum gthumb version supported by this application is $2.

Please upgrade to at least $2. If you have compiled a later version it is
possible pkg-config isn't finding it, in which case set the PKG_CONFIG_PATH
environment variable.])
  fi
])

dnl set the GTHUMB_EXTENSIONS_DIR variable
GTHUMB_EXTENSIONS_DIR="`$PKG_CONFIG --variable=extensionsdir gthumb-$_gthumb_api_version`"
AC_SUBST([GTHUMB_EXTENSIONS_DIR])

GTHUMB_EXTENSION_RULES

])


AC_DEFUN([GTHUMB_EXTENSION_RULES],
[

dnl Add a rule that auto-translates the .extension files
dnl like the INTLTOOL_XML_RULE does for xml files
GTHUMB_EXTENSION_RULE='%.extension: %.extension.in $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*po) ; LC_ALL=C $(INTLTOOL_MERGE) -d -u -c $(top_builddir)/po/.intltool-merge-cache $(top_srcdir)/po $< [$]@'
AC_SUBST(GTHUMB_EXTENSION_RULE)

GTHUMB_EXTENSION_IN_RULE='%.extension.in: %.extension.in.in $(extension_LTLIBRARIES) ; sed -e "s|%LIBRARY%|`. ./$(extension_LTLIBRARIES) && echo $$dlname`|" -e "s|%VERSION%|$(VERSION)|" -e "s|%GTHUMB_API_VERSION%|$(GTHUMB_API_VERSION)|" $< > [$]@'
AC_SUBST(GTHUMB_EXTENSION_IN_RULE)

])