// -*- c++ -*-
// Generated by gmmproc 2.42.0 -- DO NOT MODIFY!
#ifndef _GTKMM_TEXTBUFFER_H
#define _GTKMM_TEXTBUFFER_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright(C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

// This is for including the config header before any code (such as
// the #ifndef GTKMM_DISABLE_DEPRECATED in deprecated classes) is generated:


#include <vector>

#include <gtkmm/texttagtable.h>
#include <gtkmm/textchildanchor.h>
#include <gtkmm/textmark.h>
#include <gtkmm/textiter.h>
#include <gtkmm/clipboard.h>
#include <gdkmm/pixbuf.h>
#include <gtkmmconfig.h>
#include <utility>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTextBuffer GtkTextBuffer;
typedef struct _GtkTextBufferClass GtkTextBufferClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class TextBuffer_Class; } // namespace Gtk
namespace Gtk
{

class TextMark;
class TextIter;

/** Multi-line attributed text that can be displayed by one or more Gtk::TextView widgets.
 *
 * Text in a buffer can be marked with tags. A @link Gtk::TextTag Gtk::TextBuffer::Tag@endlink is an attribute that can be applied to some range of text. For example, a tag
 * might be called "bold" and make the text inside the tag bold. However, the tag concept is more general than that; tags don't
 * have to affect appearance. They can instead affect the behavior of mouse and key presses, "lock" a range of text so the user
 * can't edit it, or countless other things. A tag is represented by a @link Gtk::TextTag Gtk::TextBuffer::Tag@endlink object.
 * One @link Gtk::TextTag Gtk::TextBuffer::Tag@endlink can be applied to any number of text ranges in any number of @link Gtk::TextBuffer Gtk::TextBuffers@endlink.
 *
 * Each tag is stored in a @link Gtk::TextTagTable Gtk::TextBuffer::TagTable@endlink. A tag table defines a set of tags that can be used together. Each buffer has one tag
 * table associated with it; only tags from that tag table can be used with the buffer. A single tag table can be shared between
 * multiple buffers, however.
 *
 * Most text manipulation is accomplished with iterators, represented by an @link Gtk::TextIter iterator@endlink. The iterator can
 * be used to navigate over characters, words, lines, and sentences.
 *
 * But iterators can't be used to preserve positions across buffer modifications. To preserve a position, the
 * @link Gtk::TextMark Gtk::TextBuffer::Mark@endlink object is ideal. There are two marks built-in to GtkTextBuffer; these are
 * named "insert" and "selection_bound" and refer to the insertion point and the boundary of the selection which is not the
 * insertion point. If no text is selected, these two marks will be in the same position. You can manipulate what is selected and
 * where the cursor appears by moving these marks around.
 *
 * Text buffers always contain at least one line, but may be empty (that is, buffers can contain zero characters). The last line
 * in the text buffer never ends in a line separator (such as newline); the other lines in the buffer always end in a line
 * separator. Line separators count as characters when computing character counts and character offsets. Note that some Unicode
 * line separators are represented with multiple bytes in UTF-8, and the two-character sequence "\r\n" is also considered a line
 * separator.
 *
 * @ingroup TextView
 */

class TextBuffer : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef TextBuffer CppObjectType;
  typedef TextBuffer_Class CppClassType;
  typedef GtkTextBuffer BaseObjectType;
  typedef GtkTextBufferClass BaseClassType;

private:  friend class TextBuffer_Class;
  static CppClassType textbuffer_class_;

private:
  // noncopyable
  TextBuffer(const TextBuffer&);
  TextBuffer& operator=(const TextBuffer&);

protected:
  explicit TextBuffer(const Glib::ConstructParams& construct_params);
  explicit TextBuffer(GtkTextBuffer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~TextBuffer();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkTextBuffer*       gobj()       { return reinterpret_cast<GtkTextBuffer*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkTextBuffer* gobj() const { return reinterpret_cast<GtkTextBuffer*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkTextBuffer* gobj_copy();

private:

   
public:
  typedef TextIter iterator;
  typedef TextTag Tag;
  typedef TextTagTable TagTable;
  typedef TextMark Mark;
  typedef TextChildAnchor ChildAnchor;

protected:
  TextBuffer();
  explicit TextBuffer(const Glib::RefPtr<TagTable>& tag_table);

public:
  
  static Glib::RefPtr<TextBuffer> create();

  
  static Glib::RefPtr<TextBuffer> create(const Glib::RefPtr<TagTable>& tag_table);


  /** Obtains the number of lines in the buffer. This value is cached, so
   * the function is very fast.
   * 
   * @return Number of lines in the buffer.
   */
  int get_line_count() const;
  
  /** Gets the number of characters in the buffer; note that characters
   * and bytes are not the same, you can’t e.g.\ expect the contents of
   * the buffer in string form to be this many bytes long. The character
   * count is cached, so this function is very fast.
   * 
   * @return Number of characters in the buffer.
   */
  int get_char_count() const;

  /// See get_char_count().
  int size() const;

  
  /** Get the Gtk::TextTagTable associated with this buffer.
   * 
   * @return The buffer’s tag table.
   */
  Glib::RefPtr<TextBuffer::TagTable> get_tag_table();
  
  /** Get the Gtk::TextTagTable associated with this buffer.
   * 
   * @return The buffer’s tag table.
   */
  Glib::RefPtr<const TextBuffer::TagTable> get_tag_table() const;

  /** Removes the current contents of the buffer, and inserts @a text instead.
   * @param text The text to put in the buffer.
   */
  void set_text(const Glib::ustring& text);

  /** Removes the current contents of the buffer, and inserts @a text instead.
   * @param text_begin The start of a UTF8 character array.
   * @param text_end The end of the UTF8 character array.
   */
  void set_text(const char* text_begin, const char* text_end);
  

  //TODO: Make all insert() methods have the same return type:

  /** Inserts @a text at position @a pos.
   * Emits the "insert_text" signal; insertion actually occurs in the default handler for the signal.
   * The @a pos iterator is invalidated when insertion occurs (because the buffer contents change).
   *
   * @param pos An iterator pointing to the position at which the text should be inserted.
   * @param text The text to be inserted in the buffer.
   * @result An iterator that points to the end of the inserted text.
   */
  iterator insert(const iterator& pos, const Glib::ustring& text);

  /** Inserts text at position @a pos.
   * Emits the "insert_text" signal; insertion actually occurs in the default handler for the signal.
   * The @a pos iterator is invalidated when insertion occurs (because the buffer contents change).
   *
   * @param pos An iterator pointing to the position at which the text should be inserted.
   * @param text_begin The start of a UTF8 character array.
   * @param text_end The end of the UTF8 character array.
   * @result An iterator that points to the end of the inserted text.
   */
  iterator insert(const iterator& pos, const char* text_begin, const char* text_end);

  /** Inserts @a text, using the current cursor position as the insertion point.
   * Emits the "insert_text" signal; insertion actually occurs in the default handler for the signal.
   *
   * @param text The text to be inserted in the buffer.
   * @result An iterator that points to the end of the inserted text.
   */
  void insert_at_cursor(const Glib::ustring& text);

  /** Inserts text, using the current cursor position as the insertion point.
   * Emits the "insert_text" signal; insertion actually occurs in the default handler for the signal.
   *
   * @param text_begin The start of a UTF8 character array.
   * @param text_end The end of the UTF8 character array.
   * @result An iterator that points to the end of the inserted text.
   */
  void insert_at_cursor(const char* text_begin, const char* text_end);

  /** Like insert(), but the insertion will not occur if @a iter is at a non-editable location in the buffer.
   * Usually you want to prevent insertions at ineditable locations if the insertion results from a user action (is interactive).
   *
   * @a default_editable indicates the editability of text that doesn't have a tag affecting editability applied to it.
   * Typically the result of Gtk::TextView::get_editable() is appropriate here.
   *
   * @param pos An iterator pointing to the position at which the text should be inserted.
   * @param text The text to be inserted in the buffer.
   * @param default_editable Default editability of buffer
   * @result Whether text was actually inserted
   */
  std::pair<iterator,bool> insert_interactive(
      const iterator& pos, const Glib::ustring& text, bool default_editable = true);

  /** Like insert(), but the insertion will not occur if @a pos is at a non-editable location in the buffer.
   * Usually you want to prevent insertions at ineditable locations if the insertion results from a user action (is interactive).
   *
   * @a default_editable indicates the editability of text that doesn't have a tag affecting editability applied to it.
   * Typically the result of Gtk::TextView::get_editable() is appropriate here.
   *
   * @param pos An iterator pointing to the position at which the text should be inserted.
   * @param text_begin The start of a UTF8 character array.
   * @param text_end The end of the UTF8 character array.
   * @param default_editable Default editability of buffer.
   * @result Whether text was actually inserted
   */
  std::pair<iterator,bool> insert_interactive(
      const iterator& pos, const char* text_begin, const char* text_end, bool default_editable = true);

  /** Calls insert_interactive() at the cursor position.
   *
   * @a default_editable indicates the editability of text that doesn't have a tag affecting editability applied to it.
   * Typically the result of Gtk::TextView::get_editable() is appropriate here.
   *
   * @param text The text to be inserted in the buffer.
   * @param default_editable Default editability of buffer
   * @result Whether text was actually inserted
   */
  bool insert_interactive_at_cursor(const Glib::ustring& text, bool default_editable = true);

  /** Calls insert_interactive() at the cursor position.
   *
   * @a default_editable indicates the editability of text that doesn't have a tag affecting editability applied to it.
   * Typically the result of Gtk::TextView::get_editable() is appropriate here.
   *
   * @param text_begin The start of a UTF8 character array.
   * @param text_end The end of the UTF8 character array.
   * @param default_editable Default editability of buffer
   * @result Whether text was actually inserted
   */
  bool insert_interactive_at_cursor(const char* text_begin, const char* text_end,
                                    bool default_editable = true);

  /** Copies text, tags, and pixbufs between @a range_begin and @a range_end (the order of range_begin and range_begin doesn't
   * matter) and inserts the copy at @a pos. Used instead of simply getting/inserting text because it preserves images and tags.
   * If range_begin and range_end are in a different buffer, the two buffers must share the same tag table.
   *
   * Implemented via emissions of the insert_text and apply_tag signals, so expect those.
   *
   * @param pos An iterator pointing to the position at which the text should be inserted.
   * @param range_begin A position in a buffer.
   * @param range_end Another position in the same buffer as @a range_begin.
   * @result Whether text was actually inserted
   */
  iterator insert(const iterator& pos, const iterator& range_begin, const iterator& range_end);
  

  /** Same as insert_range(), but does nothing if the insertion point isn't editable.
   *
   * The @a default_editable parameter indicates whether the text is editable at @a pos if no tags enclosing @a pos affect editability.
   * Typically the result of Gtk::TextView::get_editable() is appropriate here.
   *
   * @param pos An iterator pointing to the position at which the text should be inserted.
   * @param range_begin A position in a buffer.
   * @param range_end Another position in the same buffer as @a range_begin.
   * @param default_editable Default editability of buffer.
   * @result Whether text was actually inserted
   */
  std::pair<iterator,bool> insert_interactive(const iterator& pos, const iterator& range_begin, const iterator& range_end, bool default_editable = true);
  

  iterator insert_with_tag(const iterator& pos, const Glib::ustring& text, const Glib::RefPtr<Tag>& tag);
  iterator insert_with_tag(const iterator& pos, const char* text_begin, const char* text_end, const Glib::RefPtr<Tag>& tag);

  iterator insert_with_tag(const iterator& pos, const Glib::ustring& text, const Glib::ustring& tag_name);
  iterator insert_with_tag(const iterator& pos, const char* text_begin, const char* text_end, const Glib::ustring& tag_name);

  /** Inserts text into buffer at @a pos, applying the list of tags to the newly-inserted text.
   * Equivalent to calling insert(), then apply_tag() on the inserted text; This is just a convenience function.
   *
   * @param pos An iterator pointing to the position at which the text should be inserted.
   * @param text The text to be inserted in the buffer.
   * @param tags A standard C++ container of @link Gtk::TextTag Gtk::TextBuffer::Tags@endlink.
   * @result Whether text was actually inserted
   */
  iterator insert_with_tags(const iterator& pos, const Glib::ustring& text,
                            const std::vector< Glib::RefPtr<Tag> >& tags);

  /** Inserts text into buffer at @a pos, applying the list of tags to the newly-inserted text.
   * Equivalent to calling insert(), then apply_tag() on the inserted text; This is just a convenience function.
   *
   * @param pos An iterator pointing to the position at which the text should be inserted.
   * @param text_begin The start of a UTF8 character array.
   * @param text_end The end of the UTF8 character array.
   * @param tags A standard C++ container of @link Gtk::TextTag Gtk::TextBuffer::Tags@endlink.
   * @result Whether text was actually inserted
   */
  iterator insert_with_tags(const iterator& pos, const char* text_begin, const char* text_end,
                            const std::vector< Glib::RefPtr<Tag> >& tags);

  /** Inserts text into buffer at @a pos, applying the list of tags to the newly-inserted text.
   * Equivalent to calling insert(), then apply_tag() on the inserted text; This is just a convenience function.
   *
   * @param pos An iterator pointing to the position at which the text should be inserted.
   * @param text The text to be inserted in the buffer.
   * @param tag_names A standard C++ container of tag names.
   * @result Whether text was actually inserted
   */
  iterator insert_with_tags_by_name(const iterator& pos, const Glib::ustring& text,
                                    const std::vector<Glib::ustring>& tag_names);


  /** Equivalent to calling insert(), then apply_tag() on the inserted text; This is just a convenience function.
   *
   * @param pos An iterator pointing to the position at which the text should be inserted.
   * @param text_begin The start of a UTF8 character array.
   * @param text_end The end of the UTF8 character array.
   * @param tag_names A standard C++ container of tag names.
   * @result Whether text was actually inserted
   */
  iterator insert_with_tags_by_name(const iterator& pos, const char* text_begin, const char* text_end,
                                    const std::vector<Glib::ustring>& tag_names);

  /* Deletes all text between @a range_begin and @a range_end. The order of range_begin and range_end is not actually relevant.
   * This function actually emits the "delete_range" signal, and the default handler of that signal deletes the text.
   * Because the buffer is modified, all outstanding iterators become invalid after calling this function.
   * @param range_begin
   * @param range_end
   * @result An iterator that points to the location where text was deleted.
   */
  iterator erase(const iterator& range_begin, const iterator& range_end);
  

   /* Deletes all editable text between @a range_begin and @a range_end. The order of range_begin and range_end is not actually relevant.
   * This function actually emits the "delete_range" signal, and the default handler of that signal deletes the text.
   * Because the buffer is modified, all outstanding iterators become invalid after calling this function.
   *
   * @a default_editable indicates the editability of text that doesn't have a tag affecting editability applied to it.
   * Typically the result of Gtk::TextView::get_editable() is appropriate here.
   *
   * @param range_begin
   * @param range_end
   * @param default_editable Default editability of buffer
   * @result An iterator that points to the location where text was deleted, or end() is no text was deleted.
   */
  std::pair<iterator,bool> erase_interactive(const iterator& range_begin, const iterator& range_end, bool default_editable = true);
  

  /** Performs the appropriate action as if the user hit the delete
   * key with the cursor at the position specified by @a iter. In the
   * normal case a single character will be deleted, but when
   * combining accents are involved, more than one character can
   * be deleted, and when precomposed character and accent combinations
   * are involved, less than one character will be deleted.
   *
   * Because the buffer is modified, all outstanding iterators become
   * invalid after calling this method; however, this method returns
   * a valid iterator that points to the location where text was deleted.
   *
   * @param iter A position in the buffer.
   * @param interactive Whether the deletion is caused by user interaction.
   * @param default_editable Whether the buffer is editable by default.
   * @result An iterator to the location where text was deleted, if the buffer was modified.
   *
   * @newin{2,6}
   */
  iterator backspace(const iterator& iter, bool interactive = true, bool default_editable = true);
  

  /** Returns the text in the range [ @a start, @a end). Excludes undisplayed
   * text (text marked with tags that set the invisibility attribute) if
   *  @a include_hidden_chars is <tt>false</tt>. Does not include characters
   * representing embedded images, so byte and character indexes into
   * the returned string do not correspond to byte
   * and character indexes into the buffer. Contrast with
   * get_slice().
   * 
   * @param start Start of a range.
   * @param end End of a range.
   * @param include_hidden_chars Whether to include invisible text.
   * @return An allocated UTF-8 string.
   */
  Glib::ustring get_text(const iterator& start, const iterator& end, bool include_hidden_chars =  true) const;

  /** Returns all the text in the buffer. Excludes undisplayed
   * text (text marked with tags that set the invisibility attribute) if
   *  @a include_hidden_chars  is <tt>false</tt>. Does not include characters
   * representing embedded images, so byte and character indexes into
   * the returned string do <em>not</em> correspond to byte
   * and character indexes into the buffer. Contrast with
   * get_slice().
   *
   * @param include_hidden_chars Whether to include invisible text.
   * @return An allocated UTF-8 string.
   */
  Glib::ustring get_text(bool include_hidden_chars = true) const;

  
  /** Returns the text in the range [ @a start, @a end). Excludes undisplayed
   * text (text marked with tags that set the invisibility attribute) if
   *  @a include_hidden_chars is <tt>false</tt>. The returned string includes a
   * 0xFFFC character whenever the buffer contains
   * embedded images, so byte and character indexes into
   * the returned string do correspond to byte
   * and character indexes into the buffer. Contrast with
   * get_text(). Note that 0xFFFC can occur in normal
   * text as well, so it is not a reliable indicator that a pixbuf or
   * widget is in the buffer.
   * 
   * @param start Start of a range.
   * @param end End of a range.
   * @param include_hidden_chars Whether to include invisible text.
   * @return An allocated UTF-8 string.
   */
  Glib::ustring get_slice(const iterator& start, const iterator& end, bool include_hidden_chars =  true) const;

  iterator insert_pixbuf(const iterator& pos, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  

  iterator insert_child_anchor(const iterator& pos, const Glib::RefPtr<ChildAnchor>& anchor);
  

  Glib::RefPtr<ChildAnchor> create_child_anchor(const iterator& pos);
  

  /** Adds the mark at position @a where. The mark must not be added to
   * another buffer, and if its name is not <tt>0</tt> then there must not
   * be another mark in the buffer with the same name.
   * 
   * Emits the Gtk::TextBuffer::signal_mark_set() signal as notification of the mark's
   * initial placement.
   * 
   * @newin{2,12}
   * 
   * @param mark The mark to add.
   * @param where Location to place mark.
   */
  void add_mark(const Glib::RefPtr<TextBuffer::Mark>& mark, const iterator& where);

  
  /** Creates a mark at position @a where. The mark can be retrieved by name using
   * get_mark(). If a mark has left gravity, and text is
   * inserted at the mark's current location, the mark will be moved to
   * the left of the newly-inserted text. If the mark has right gravity
   * ( @a left_gravity = <tt>false</tt>), the mark will end up on the right of
   * newly-inserted text. The standard left-to-right cursor is a mark
   * with right gravity (when you type, the cursor stays on the right
   * side of the text you're typing).
   * 
   * Emits the "mark_set" signal as notification of the mark's initial
   * placement.
   * 
   * @param mark_name Name for mark, or <tt>0</tt>.
   * @param where Location to place mark.
   * @param left_gravity Whether the mark has left gravity.
   * @return The new Gtk::TextMark object.
   */
  Glib::RefPtr<TextBuffer::Mark> create_mark(const Glib::ustring& mark_name, const iterator& where, bool left_gravity =  true);

  /** Create an anonymous mark. */
  /** Creates an anonymous mark at position @a where.
   *
   * If a mark has left gravity, and text is
   * inserted at the mark's current location, the mark will be moved to
   * the left of the newly-inserted text. If the mark has right gravity
   * ( @a left_gravity  = <tt>false</tt>), the mark will end up on the right of
   * newly-inserted text. The standard left-to-right cursor is a mark
   * with right gravity (when you type, the cursor stays on the right
   * side of the text you're typing).
   *
   * Emits the "mark_set" signal as notification of the mark's initial
   * placement.
   * @param where Location to place mark.
   * @param left_gravity Whether the mark has left gravity.
   * @return The new Gtk::TextMark object.
   */
  Glib::RefPtr<Mark> create_mark(const iterator& where, bool left_gravity = true);

  
  /** Moves @a mark to the new location @a where. Emits the Gtk::TextBuffer::signal_mark_set()
   * signal as notification of the move.
   * 
   * @param mark A Gtk::TextMark.
   * @param where New location for @a mark in @a buffer.
   */
  void move_mark(const Glib::RefPtr<Mark>& mark, const iterator& where);
  
  /** Deletes @a mark, so that it's no longer located anywhere in the
   * buffer. Removes the reference the buffer holds to the mark, so if
   * you don't keep a Glib::RefPtr to the mark, it will be freed. Even
   * if the mark isn't freed, most operations on @a mark become
   * invalid. There is no way to undelete a
   * mark. Gtk::TextMark::get_deleted() will return <tt>true</tt> after this
   * function has been called on a mark; Gtk::TextMark::get_deleted()
   * indicates that a mark no longer belongs to a buffer. The "mark_deleted"
   * signal will be emitted as notification after the mark is deleted.
   * 
   * @param mark A Gtk::TextMark in @a buffer.
   */
  void delete_mark(const Glib::RefPtr<Mark>& mark);

  
  /** Returns the mark named @a name in buffer @a buffer, or <tt>0</tt> if no such
   * mark exists in the buffer.
   * 
   * @param name A mark name.
   * @return A Gtk::TextMark, or <tt>0</tt>.
   */
  Glib::RefPtr<TextBuffer::Mark> get_mark(const Glib::ustring& name);
  
  /** Returns the mark named @a name in buffer @a buffer, or <tt>0</tt> if no such
   * mark exists in the buffer.
   * 
   * @param name A mark name.
   * @return A Gtk::TextMark, or <tt>0</tt>.
   */
  Glib::RefPtr<const TextBuffer::Mark> get_mark(const Glib::ustring& name) const;

  
  /** Moves the mark named @a name (which must exist) to location @a where.
   * See move_mark() for details.
   * 
   * @param name Name of a mark.
   * @param where New location for mark.
   */
  void move_mark_by_name(const Glib::ustring& name, const iterator& where);
  
  /** Deletes the mark named @a name; the mark must exist. See
   * delete_mark() for details.
   * 
   * @param name Name of a mark in @a buffer.
   */
  void delete_mark_by_name(const Glib::ustring& name);

  
  /** Returns the mark that represents the cursor (insertion point).
   * Equivalent to calling get_mark() to get the mark
   * named “insert”, but very slightly more efficient, and involves less
   * typing.
   * 
   * @return Insertion point mark.
   */
  Glib::RefPtr<TextBuffer::Mark> get_insert();
  
  /** Returns the mark that represents the selection bound.  Equivalent
   * to calling get_mark() to get the mark named
   * “selection_bound”, but very slightly more efficient, and involves
   * less typing.
   * 
   * The currently-selected text in @a buffer is the region between the
   * “selection_bound” and “insert” marks. If “selection_bound” and
   * “insert” are in the same place, then there is no current selection.
   * get_selection_bounds() is another convenient function
   * for handling the selection, if you just want to know whether there’s a
   * selection and what its bounds are.
   * 
   * @return Selection bound mark.
   */
  Glib::RefPtr<TextBuffer::Mark> get_selection_bound();

  
  /** This function moves the “insert” and “selection_bound” marks
   * simultaneously.  If you move them to the same place in two steps
   * with move_mark(), you will temporarily select a
   * region in between their old and new locations, which can be pretty
   * inefficient since the temporarily-selected region will force stuff
   * to be recalculated. This function moves them as a unit, which can
   * be optimized.
   * 
   * @param where Where to put the cursor.
   */
  void place_cursor(const iterator& where);
  
  /** Emits the “apply-tag” signal on @a buffer. The default
   * handler for the signal applies @a tag to the given range.
   *  @a start and @a end do not have to be in order.
   * 
   * @param tag A Gtk::TextTag.
   * @param start One bound of range to be tagged.
   * @param end Other bound of range to be tagged.
   */
  void apply_tag(const Glib::RefPtr<Tag>& tag, const iterator& start, const iterator& end);
  
  /** Emits the “remove-tag” signal. The default handler for the signal
   * removes all occurrences of @a tag from the given range. @a start and
   *  @a end don’t have to be in order.
   * 
   * @param tag A Gtk::TextTag.
   * @param start One bound of range to be untagged.
   * @param end Other bound of range to be untagged.
   */
  void remove_tag(const Glib::RefPtr<Tag>& tag, const iterator& start, const iterator& end);
  
  /** Calls Gtk::TextTagTable::lookup() on the buffer’s tag table to
   * get a Gtk::TextTag, then calls apply_tag().
   * 
   * @param name Name of a named Gtk::TextTag.
   * @param start One bound of range to be tagged.
   * @param end Other bound of range to be tagged.
   */
  void apply_tag_by_name(const Glib::ustring& name, const iterator& start, const iterator& end);
  
  /** Calls Gtk::TextTagTable::lookup() on the buffer’s tag table to
   * get a Gtk::TextTag, then calls remove_tag().
   * 
   * @param name Name of a Gtk::TextTag.
   * @param start One bound of range to be untagged.
   * @param end Other bound of range to be untagged.
   */
  void remove_tag_by_name(const Glib::ustring& name, const iterator& start, const iterator& end);
  
  /** Removes all tags in the range between @a start and @a end.  Be careful
   * with this function; it could remove tags added in code unrelated to
   * the code you’re currently writing. That is, using this function is
   * probably a bad idea if you have two or more unrelated code sections
   * that add tags.
   * 
   * @param start One bound of range to be untagged.
   * @param end Other bound of range to be untagged.
   */
  void remove_all_tags(const iterator& start, const iterator& end);

  /** Creates a tag and adds it to the tag table for buffer. Equivalent to calling Gtk::TextBuffer::Tag::create() and then adding
   * the tag to the buffer's tag table.
   * A tag called @a tag_name must not already exist in the tag table for this buffer.
   *
   * @param tag_name The name for the new tag.
   * @result The new tag.
   */
  Glib::RefPtr<Tag> create_tag(const Glib::ustring& tag_name);
  

  /** Creates an anoymous tag and adds it to the tag table for buffer. Equivalent to calling Gtk::TextBuffer::Tag::create() and then adding
   * the tag to the buffer's tag table.
   *
   * @result The new tag.
   */
  Glib::RefPtr<Tag> create_tag();

  iterator get_iter_at_line_offset(int line_number, int char_offset);
  iterator get_iter_at_line_index(int line_number, int byte_index);
  iterator get_iter_at_offset(int char_offset);
  iterator get_iter_at_line(int line_number);
  iterator begin();
  iterator end();
  void get_bounds(iterator& range_begin, iterator& range_end);

  /** Get the current position of a mark.
   * @param mark The @link Gtk::TextMark Gtk::TextBuffer::Mark@endlink
   * @result An iterator that points to the position of the @a mark.
   */
  iterator get_iter_at_mark(const Glib::RefPtr<Mark>& mark);

  /** Get the current position of an anchor.
   * @param anchor A @link Gtk::TextChildAnchor Gtk::TextBuffer::Anchor@endlink that appears in the buffer.
   * @result An iterator that points to the position of the @a anchor.
   */
  iterator get_iter_at_child_anchor(const Glib::RefPtr<ChildAnchor>& anchor);

  
  /** Indicates whether the buffer has been modified since the last call
   * to set_modified() set the modification flag to
   * <tt>false</tt>. Used for example to enable a “save” function in a text
   * editor.
   * 
   * @return <tt>true</tt> if the buffer has been modified.
   */
  bool get_modified() const;
  
  /** Used to keep track of whether the buffer has been modified since the
   * last time it was saved. Whenever the buffer is saved to disk, call
   * gtk_text_buffer_set_modified ( @a buffer, <tt>false</tt>). When the buffer is modified,
   * it will automatically toggled on the modified bit again. When the modified
   * bit flips, the buffer emits the Gtk::TextBuffer::signal_modified_changed() signal.
   * 
   * @param setting Modification flag setting.
   */
  void set_modified(bool setting =  true);

  
  /** Indicates whether the buffer has some text currently selected.
   * 
   * @newin{2,10}
   * 
   * @return <tt>true</tt> if the there is text selected.
   */
  bool get_has_selection() const;

  
  /** Adds @a clipboard to the list of clipboards in which the selection 
   * contents of @a buffer are available. In most cases, @a clipboard will be 
   * the Gtk::Clipboard of type Gdk::SELECTION_PRIMARY for a view of @a buffer.
   * 
   * @param clipboard A Gtk::Clipboard.
   */
  void add_selection_clipboard(const Glib::RefPtr<Clipboard>& clipboard);
  
  /** Removes a Gtk::Clipboard added with 
   * add_selection_clipboard().
   * 
   * @param clipboard A Gtk::Clipboard added to @a buffer by 
   * add_selection_clipboard().
   */
  void remove_selection_clipboard(const Glib::RefPtr<Clipboard>& clipboard);
  
  /** Copies the currently-selected text to a clipboard, then deletes
   * said text if it’s editable.
   * 
   * @param clipboard The Gtk::Clipboard object to cut to.
   * @param default_editable Default editability of the buffer.
   */
  void cut_clipboard(const Glib::RefPtr<Clipboard>& clipboard, bool default_editable =  true);
  
  /** Copies the currently-selected text to a clipboard.
   * 
   * @param clipboard The Gtk::Clipboard object to copy to.
   */
  void copy_clipboard(const Glib::RefPtr<Clipboard>& clipboard);
  void paste_clipboard(const Glib::RefPtr<Clipboard>& clipboard, const iterator& override_location, bool default_editable = true);
  void paste_clipboard(const Glib::RefPtr<Clipboard>& clipboard, bool default_editable = true);
  

  /** Returns <tt>true</tt> if some text is selected; places the bounds
   * of the selection in @a start and @a end (if the selection has length 0,
   * then @a start and @a end are filled in with the same value).
   *  @a start and @a end will be in ascending order. If @a start and @a end are
   * <tt>0</tt>, then they are not filled in, but the return value still indicates
   * whether text is selected.
   * 
   * @param start Iterator to initialize with selection start.
   * @param end Iterator to initialize with selection end.
   * @return Whether the selection has nonzero length.
   */
  bool get_selection_bounds(iterator& start, iterator& end) const;
  
  /** Deletes the range between the “insert” and “selection_bound” marks,
   * that is, the currently-selected text. If @a interactive is <tt>true</tt>,
   * the editability of the selection will be considered (users can’t delete
   * uneditable text).
   * 
   * @param interactive Whether the deletion is caused by user interaction.
   * @param default_editable Whether the buffer is editable by default.
   * @return Whether there was a non-empty selection to delete.
   */
  bool erase_selection(bool interactive =  true, bool default_editable =  true);

  
  /** This function moves the “insert” and “selection_bound” marks
   * simultaneously.  If you move them in two steps
   * with move_mark(), you will temporarily select a
   * region in between their old and new locations, which can be pretty
   * inefficient since the temporarily-selected region will force stuff
   * to be recalculated. This function moves them as a unit, which can
   * be optimized.
   * 
   * @newin{2,4}
   * 
   * @param ins Where to put the “insert” mark.
   * @param bound Where to put the “selection_bound” mark.
   */
  void select_range(const iterator& ins, const iterator& bound);

/* Called to specify atomic user actions, used to implement undo */
  
  /** Called to indicate that the buffer operations between here and a
   * call to end_user_action() are part of a single
   * user-visible operation. The operations between
   * begin_user_action() and
   * end_user_action() can then be grouped when creating
   * an undo stack. Gtk::TextBuffer maintains a count of calls to
   * begin_user_action() that have not been closed with
   * a call to end_user_action(), and emits the 
   * “begin-user-action” and “end-user-action” signals only for the 
   * outermost pair of calls. This allows you to build user actions 
   * from other user actions.
   * 
   * The “interactive” buffer mutation functions, such as
   * insert_interactive(), automatically call begin/end
   * user action around the buffer operations they perform, so there's
   * no need to add extra calls if you user action consists solely of a
   * single call to one of those functions.
   * 
   */
  void begin_user_action();
  
  /** Should be paired with a call to begin_user_action().
   * See that function for a full explanation.
   * 
   */
  void end_user_action();

  
  /** This function returns the list of targets this text buffer can
   * provide for copying and as DND source. The targets in the list are
   * added with @a info values from the Gtk::TextBufferTargetInfo enum,
   * using Gtk::TargetList::add_rich_text_targets() and
   * Gtk::TargetList::add_text_targets().
   * 
   * @newin{2,10}
   * 
   * @return The Gtk::TargetList.
   */
  Glib::RefPtr<TargetList> get_copy_target_list() const;
  
  /** This function returns the list of targets this text buffer supports
   * for pasting and as DND destination. The targets in the list are
   * added with @a info values from the Gtk::TextBufferTargetInfo enum,
   * using Gtk::TargetList::add_rich_text_targets() and
   * Gtk::TargetList::add_text_targets().
   * 
   * @newin{2,10}
   * 
   * @return The Gtk::TargetList.
   */
  Glib::RefPtr<TargetList> get_paste_target_list() const;

//TODO: I have commented these out for now because I don't understand what the register_buffer and content_buffer are. murrayc.
 //TODO: Documentation.
 // typedef sigc::slot<guint8*, const Glib::RefPtr<TextBuffer>& /* content_buffer */, const iterator& /* start */, const iterator& /* end */, gsize& /* length */> SlotSerialize;


//TODO: Use ArrayHandle, or just use guint8* to be more efficient?
// TODO: Or rather - vector utils.
  // typedef sigc::slot<bool, const Glib::RefPtr<TextBuffer>& /* content_buffer */, iterator& /* iter */, const guint8*  /* data */, gsize /* length */, bool /* create_tags */> SlotDeserialize;

/*
  Glib::ustring register_serialize_format(const Glib::ustring& mime_type, const SlotSerialize& slot);
  _IGNORE(gtk_text_buffer_register_serialize_format)
*/

  
  /** This function registers GTK+’s internal rich text serialization
   * format with the passed @a buffer. The internal format does not comply
   * to any standard rich text format and only works between Gtk::TextBuffer
   * instances. It is capable of serializing all of a text buffer’s tags
   * and embedded pixbufs.
   * 
   * This function is just a wrapper around
   * register_serialize_format(). The mime type used
   * for registering is “application/x-gtk-text-buffer-rich-text”, or
   * “application/x-gtk-text-buffer-rich-text;format= @a tagset_name” if a
   *  @a tagset_name was passed.
   * 
   * The @a tagset_name can be used to restrict the transfer of rich text
   * to buffers with compatible sets of tags, in order to avoid unknown
   * tags from being pasted. It is probably the common case to pass an
   * identifier != <tt>0</tt> here, since the <tt>0</tt> tagset requires the
   * receiving buffer to deal with with pasting of arbitrary tags.
   * 
   * @newin{2,10}
   * 
   * @param tagset_name An optional tagset name, on <tt>0</tt>.
   * @return The Gdk::Atom that corresponds to the
   * newly registered format’s mime-type.
   */
  Glib::ustring register_serialize_tagset(const Glib::ustring& tagset_name);

/*
  Glib::ustring register_deserialize_format(const Glib::ustring& mime_type, const SlotDeserialize& slot);
  _IGNORE(gtk_text_buffer_register_deserialize_format)
*/
  
  /** This function registers GTK+’s internal rich text serialization
   * format with the passed @a buffer. See
   * register_serialize_tagset() for details.
   * 
   * @newin{2,10}
   * 
   * @param tagset_name An optional tagset name, on <tt>0</tt>.
   * @return The Gdk::Atom that corresponds to the
   * newly registered format’s mime-type.
   */
  Glib::ustring register_deserialize_tagset(const Glib::ustring& tagset_name);

  
  /** This function unregisters a rich text format that was previously
   * registered using register_serialize_format() or
   * register_serialize_tagset()
   * 
   * @newin{2,10}
   * 
   * @param format A Gdk::Atom representing a registered rich text format.
   */
  void unregister_serialize_format(const Glib::ustring& format);
  
  /** This function unregisters a rich text format that was previously
   * registered using register_deserialize_format() or
   * register_deserialize_tagset().
   * 
   * @newin{2,10}
   * 
   * @param format A Gdk::Atom representing a registered rich text format.
   */
  void unregister_deserialize_format(const Glib::ustring& format);

  
  /** Use this function to allow a rich text deserialization function to
   * create new tags in the receiving buffer. Note that using this
   * function is almost always a bad idea, because the rich text
   * functions you register should know how to map the rich text format
   * they handler to your text buffers set of tags.
   * 
   * The ability of creating new (arbitrary!) tags in the receiving buffer
   * is meant for special rich text formats like the internal one that
   * is registered using register_deserialize_tagset(),
   * because that format is essentially a dump of the internal structure
   * of the source buffer, including its tag names.
   * 
   * You should allow creation of tags only if you know what you are
   * doing, e.g. if you defined a tagset name for your application
   * suite’s text buffers and you know that it’s fine to receive new
   * tags from these buffers, because you know that your application can
   * handle the newly created tags.
   * 
   * @newin{2,10}
   * 
   * @param format A Gdk::Atom representing a registered rich text format.
   * @param can_create_tags Whether deserializing this format may create tags.
   */
  void set_can_create_tags(const Glib::ustring& format, bool can_create_tags =  true);
  
  /** This functions returns the value set with
   * deserialize_set_can_create_tags()
   * 
   * @newin{2,10}
   * 
   * @param format A Gdk::Atom representing a registered rich text format.
   * @return Whether deserializing this format may create tags.
   */
  bool get_can_create_tags(const Glib::ustring& format) const;


  std::vector<Glib::ustring> get_serialize_formats() const;
  
  std::vector<Glib::ustring> get_deserialize_formats() const;
  

/*
//TODO: I have commented these out for now because I don't understand what the register_buffer and content_buffer are. murrayc.

//TODO: Use something other than gsize?
#m4 _CONVERSION(`const iterator&', `GtkTextIter*',`($3).gobj()')
  _WRAP_METHOD(guint8* serialize(const Glib::RefPtr<TextBuffer>& content_buffer,
                                                       const Glib::ustring& format,
                                                       const iterator& iterstart,
                                                       const iterator& iterend,
                                                       gsize& length), gtk_text_buffer_serialize)

//TODO: Is the bool superfluous?
//TODO: Use an ArrayHandle? Or rather - vector utils.
  _WRAP_METHOD(bool deserialize(const Glib::RefPtr<TextBuffer>& content_buffer,
                                                       const Glib::ustring& format,
                                                       const iterator& iter, const guint8* data,
                                                       gsize length), gtk_text_buffer_deserialize, errthrow)
*/


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%insert(const TextBuffer::iterator& pos, const Glib::ustring& text, int bytes)</tt>
   *
   * The signal_insert_text() signal is emitted to insert text in a Gtk::TextBuffer.
   * Insertion actually occurs in the default handler.  
   * 
   * Note that if your handler runs before the default handler it must not 
   * invalidate the @a location iter (or has to revalidate it). 
   * The default signal handler revalidates it to point to the end of the 
   * inserted text.
   * 
   * See also: 
   * Gtk::TextBuffer::insert(), 
   * Gtk::TextBuffer::insert_range().
   * 
   * @param location Position to insert @a text in @a textbuffer.
   * @param text The UTF-8 text to be inserted.
   * @param len Length of the inserted text in bytes.
   */

  Glib::SignalProxy3< void,const TextBuffer::iterator&,const Glib::ustring&,int > signal_insert();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%insert_pixbuf(const TextBuffer::iterator& pos, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf)</tt>
   *
   * The signal_insert_pixbuf() signal is emitted to insert a Gdk::Pixbuf 
   * in a Gtk::TextBuffer. Insertion actually occurs in the default handler.
   * 
   * Note that if your handler runs before the default handler it must not 
   * invalidate the @a location iter (or has to revalidate it). 
   * The default signal handler revalidates it to be placed after the 
   * inserted @a pixbuf.
   * 
   * See also: Gtk::TextBuffer::insert_pixbuf().
   * 
   * @param location Position to insert @a pixbuf in @a textbuffer.
   * @param pixbuf The Gdk::Pixbuf to be inserted.
   */

  Glib::SignalProxy2< void,const TextBuffer::iterator&,const Glib::RefPtr<Gdk::Pixbuf>& > signal_insert_pixbuf();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%insert_child_anchor(const TextBuffer::iterator& pos, const Glib::RefPtr<ChildAnchor>& anchor)</tt>
   *
   * The signal_insert_child_anchor() signal is emitted to insert a
   * Gtk::TextChildAnchor in a Gtk::TextBuffer.
   * Insertion actually occurs in the default handler.
   * 
   * Note that if your handler runs before the default handler it must
   * not invalidate the @a location iter (or has to revalidate it). 
   * The default signal handler revalidates it to be placed after the 
   * inserted @a anchor.
   * 
   * See also: Gtk::TextBuffer::insert_child_anchor().
   * 
   * @param location Position to insert @a anchor in @a textbuffer.
   * @param anchor The Gtk::TextChildAnchor to be inserted.
   */

  Glib::SignalProxy2< void,const TextBuffer::iterator&,const Glib::RefPtr<ChildAnchor>& > signal_insert_child_anchor();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%erase(const TextBuffer::iterator& start, const TextBuffer::iterator& end)</tt>
   *
   * The signal_delete_range() signal is emitted to delete a range 
   * from a Gtk::TextBuffer. 
   * 
   * Note that if your handler runs before the default handler it must not 
   * invalidate the @a start and @a end iters (or has to revalidate them). 
   * The default signal handler revalidates the @a start and @a end iters to 
   * both point to the location where text was deleted. Handlers
   * which run after the default handler (see Glib::signal_connect_after())
   * do not have access to the deleted text.
   * 
   * See also: Gtk::TextBuffer::delete().
   * 
   * @param start The start of the range to be deleted.
   * @param end The end of the range to be deleted.
   */

  Glib::SignalProxy2< void,const TextBuffer::iterator&,const TextBuffer::iterator& > signal_erase();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%changed()</tt>
   *
   * The signal_changed() signal is emitted when the content of a Gtk::TextBuffer 
   * has changed.
   * 
   */

  Glib::SignalProxy0< void > signal_changed();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%modified_changed()</tt>
   *
   * The signal_modified_changed() signal is emitted when the modified bit of a 
   * Gtk::TextBuffer flips.
   * 
   * See also:
   * Gtk::TextBuffer::set_modified().
   * 
   */

  Glib::SignalProxy0< void > signal_modified_changed();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%mark_set(const TextBuffer::iterator& location, const Glib::RefPtr<TextBuffer::Mark>& mark)</tt>
   *
   * The signal_mark_set() signal is emitted as notification
   * after a Gtk::TextMark is set.
   * 
   * See also: 
   * Gtk::TextBuffer::create_mark(),
   * Gtk::TextBuffer::move_mark().
   * 
   * @param location The location of @a mark in @a textbuffer.
   * @param mark The mark that is set.
   */

  Glib::SignalProxy2< void,const TextBuffer::iterator&,const Glib::RefPtr<TextBuffer::Mark>& > signal_mark_set();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%mark_deleted(const Glib::RefPtr<TextBuffer::Mark>& mark)</tt>
   *
   * The signal_mark_deleted() signal is emitted as notification
   * after a Gtk::TextMark is deleted. 
   * 
   * See also:
   * Gtk::TextBuffer::delete_mark().
   * 
   * @param mark The mark that was deleted.
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<TextBuffer::Mark>& > signal_mark_deleted();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%apply_tag(const Glib::RefPtr<TextBuffer::Tag>& tag, const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end)</tt>
   *
   * The signal_apply_tag() signal is emitted to apply a tag to a
   * range of text in a Gtk::TextBuffer. 
   * Applying actually occurs in the default handler.
   * 
   * Note that if your handler runs before the default handler it must not 
   * invalidate the @a start and @a end iters (or has to revalidate them). 
   * 
   * See also: 
   * Gtk::TextBuffer::apply_tag(),
   * Gtk::TextBuffer::insert_with_tags(),
   * Gtk::TextBuffer::insert_range().
   * 
   * @param tag The applied tag.
   * @param start The start of the range the tag is applied to.
   * @param end The end of the range the tag is applied to.
   */

  Glib::SignalProxy3< void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator& > signal_apply_tag();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%remove_tag(const Glib::RefPtr<TextBuffer::Tag>& tag, const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end)</tt>
   *
   * The signal_remove_tag() signal is emitted to remove all occurrences of @a tag from
   * a range of text in a Gtk::TextBuffer. 
   * Removal actually occurs in the default handler.
   * 
   * Note that if your handler runs before the default handler it must not 
   * invalidate the @a start and @a end iters (or has to revalidate them). 
   * 
   * See also: 
   * Gtk::TextBuffer::remove_tag().
   * 
   * @param tag The tag to be removed.
   * @param start The start of the range the tag is removed from.
   * @param end The end of the range the tag is removed from.
   */

  Glib::SignalProxy3< void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator& > signal_remove_tag();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%begin_user_action()</tt>
   *
   * The signal_begin_user_action() signal is emitted at the beginning of a single
   * user-visible operation on a Gtk::TextBuffer.
   * 
   * See also: 
   * Gtk::TextBuffer::begin_user_action(),
   * Gtk::TextBuffer::insert_interactive(),
   * Gtk::TextBuffer::insert_range_interactive(),
   * Gtk::TextBuffer::delete_interactive(),
   * Gtk::TextBuffer::backspace(),
   * Gtk::TextBuffer::delete_selection().
   * 
   */

  Glib::SignalProxy0< void > signal_begin_user_action();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%end_user_action()</tt>
   *
   * The signal_end_user_action() signal is emitted at the end of a single
   * user-visible operation on the Gtk::TextBuffer.
   * 
   * See also: 
   * Gtk::TextBuffer::end_user_action(),
   * Gtk::TextBuffer::insert_interactive(),
   * Gtk::TextBuffer::insert_range_interactive(),
   * Gtk::TextBuffer::delete_interactive(),
   * Gtk::TextBuffer::backspace(),
   * Gtk::TextBuffer::delete_selection(),
   * Gtk::TextBuffer::backspace().
   * 
   */

  Glib::SignalProxy0< void > signal_end_user_action();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%paste_done(const Glib::RefPtr<Gtk::Clipboard>& clipboard)</tt>
   *
   * The paste-done signal is emitted after paste operation has been completed.
   * This is useful to properly scroll the view to the end of the pasted text.
   * See Gtk::TextBuffer::paste_clipboard() for more details.
   * 
   * @newin{2,16}
   * 
   * @param clipboard The Gtk::Clipboard pasted from.
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Gtk::Clipboard>& > signal_paste_done();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Text Tag Table.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<TextBuffer::TagTable> > property_tag_table() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Current text of the buffer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_text() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Current text of the buffer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_text() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the buffer has some text currently selected.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_selection() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The position of the insert mark (as offset from the beginning of the buffer).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_cursor_position() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  //TODO: Check the ref-counting/conversion for these: _WRAP_PROPERTY("copy-target-list", Glib::ListHandle< Glib::RefPtr<TargetList> >)
  //TODO: _WRAP_PROPERTY("paste-target-list", Glib::ListHandle< Glib::RefPtr<TargetList> >)


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_insert().
  virtual void on_insert(const TextBuffer::iterator& pos, const Glib::ustring& text, int bytes);
  /// This is a default handler for the signal signal_insert_pixbuf().
  virtual void on_insert_pixbuf(const TextBuffer::iterator& pos, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  /// This is a default handler for the signal signal_insert_child_anchor().
  virtual void on_insert_child_anchor(const TextBuffer::iterator& pos, const Glib::RefPtr<ChildAnchor>& anchor);
  /// This is a default handler for the signal signal_erase().
  virtual void on_erase(const TextBuffer::iterator& start, const TextBuffer::iterator& end);
  /// This is a default handler for the signal signal_changed().
  virtual void on_changed();
  /// This is a default handler for the signal signal_modified_changed().
  virtual void on_modified_changed();
  /// This is a default handler for the signal signal_mark_set().
  virtual void on_mark_set(const TextBuffer::iterator& location, const Glib::RefPtr<TextBuffer::Mark>& mark);
  /// This is a default handler for the signal signal_mark_deleted().
  virtual void on_mark_deleted(const Glib::RefPtr<TextBuffer::Mark>& mark);
  /// This is a default handler for the signal signal_apply_tag().
  virtual void on_apply_tag(const Glib::RefPtr<TextBuffer::Tag>& tag, const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end);
  /// This is a default handler for the signal signal_remove_tag().
  virtual void on_remove_tag(const Glib::RefPtr<TextBuffer::Tag>& tag, const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end);
  /// This is a default handler for the signal signal_begin_user_action().
  virtual void on_begin_user_action();
  /// This is a default handler for the signal signal_end_user_action().
  virtual void on_end_user_action();
  /// This is a default handler for the signal signal_paste_done().
  virtual void on_paste_done(const Glib::RefPtr<Gtk::Clipboard>& clipboard);


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::TextBuffer
   */
  Glib::RefPtr<Gtk::TextBuffer> wrap(GtkTextBuffer* object, bool take_copy = false);
}


#endif /* _GTKMM_TEXTBUFFER_H */

