/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*****************************************************************************/
/* This is an automatically generated file. If you're not                    */
/* nsSiteSecurityService.cpp, you shouldn't be #including it.     */
/*****************************************************************************/

#include <stdint.h>
const PRTime gPreloadListExpirationTime = INT64_C(1499269534899000);

class nsSTSPreload
{
  public:
    const char *mHost;
    const bool mIncludeSubdomains;
};

static const nsSTSPreload kSTSPreloadList[] = {
  { "0.me.uk", true },
  { "007-preisvergleich.de", true },
  { "0100dev.com", true },
  { "0100dev.nl", true },
  { "01electronica.com.ar", true },
  { "01seguridad.com.ar", true },
  { "040fit.nl", true },
  { "050media.nl", true },
  { "0513c.com", true },
  { "0au.de", true },
  { "0day.su", true },
  { "0i0.nl", true },
  { "0ik.de", true },
  { "0knowledge.de", true },
  { "0o0.ooo", true },
  { "0paste.com", true },
  { "0x.cx", true },
  { "0x.sk", true },
  { "0x0a.net", true },
  { "0x1337.eu", true },
  { "0x17.de", true },
  { "0x52.net", true },
  { "0x539.pw", true },
  { "0x65.net", true },
  { "0x90.fi", true },
  { "0x90.io", true },
  { "0xAA55.me", true },
  { "0xa.in", true },
  { "0xaa55.me", true },
  { "0xacab.org", true },
  { "0xda.de", true },
  { "0xdefaced.de", true },
  { "0xee.eu", true },
  { "0xfc.de", true },
  { "0xn.de", true },
  { "10000v.ru", true },
  { "1000minds.com", true },
  { "1000serien.com", true },
  { "1001.best", true },
  { "1001kerstpakketten.com", false },
  { "100onrainkajino.com", true },
  { "1011100.com", true },
  { "1017scribes.com", true },
  { "1022996493.rsc.cdn77.org", true },
  { "1066.io", true },
  { "10hz.de", true },
  { "10tacle.io", true },
  { "112app.nl", true },
  { "11urss.com", true },
  { "123.gg", true },
  { "123comparer.fr", true },
  { "123djdrop.com", true },
  { "123test.com", true },
  { "123test.es", true },
  { "123test.fr", true },
  { "123test.nl", true },
  { "126ium.moe", true },
  { "12vpn.net", true },
  { "12vpn.org", true },
  { "1464424382.rsc.cdn77.org", true },
  { "14it.de", true },
  { "15-10.com", true },
  { "1536.cf", true },
  { "1600esplanade.com", true },
  { "16packets.com", true },
  { "174.net.nz", true },
  { "1750studios.com", false },
  { "17hats.com", true },
  { "188betwarriors.co.uk", true },
  { "188trafalgar.ca", true },
  { "18f.gov", true },
  { "18f.gsa.gov", false },
  { "1972969867.rsc.cdn77.org", true },
  { "1a-diamantscheiben.de", true },
  { "1a-vermessung.at", true },
  { "1a-werkstattgeraete.de", true },
  { "1atic.com", true },
  { "1co-jp.net", true },
  { "1cover.com", true },
  { "1cover.com.au", true },
  { "1hourproofreading.com", true },
  { "1item.co.il", true },
  { "1js.de", true },
  { "1k8b.com", true },
  { "1kando.com", true },
  { "1km.ro", true },
  { "1on1on1.de", true },
  { "1on1on1.tv", true },
  { "1p.ro", true },
  { "1pw.ca", true },
  { "1px.tv", true },
  { "1q365a.com", true },
  { "1rs.nl", true },
  { "1se2or3.com", true },
  { "1st-community.de", true },
  { "1stcapital.com.sg", true },
  { "1ststop.co.uk", true },
  { "1three1.net", true },
  { "1whw.co.uk", true },
  { "2-cpu.de", true },
  { "2.wtf", true },
  { "2048game.co.uk", true },
  { "20hs.cn", true },
  { "21.co.uk", true },
  { "21lg.co", true },
  { "21stnc.com", true },
  { "246060.ru", true },
  { "247healthshop.com", true },
  { "24hourpaint.com", true },
  { "24ip.com", true },
  { "24ip.de", true },
  { "24ip.fr", true },
  { "24sihu.com", true },
  { "2600edinburgh.org", true },
  { "2600hq.com", true },
  { "263.info", true },
  { "28spots.net", true },
  { "2acbi-asso.fr", true },
  { "2bas.nl", true },
  { "2bis10.de", true },
  { "2brokegirls.org", true },
  { "2carpros.com", false },
  { "2cash.ru", true },
  { "2cv-fahrer.de", true },
  { "2gen.com", true },
  { "2hypeenterprises.com", true },
  { "2intermediate.co.uk", true },
  { "2kgwf.fi", true },
  { "2nains.ch", true },
  { "2nerds1bit.com", true },
  { "2or3.tk", true },
  { "2pay.fr", true },
  { "2programmers.net", true },
  { "2ulcceria.nl", true },
  { "301.website", true },
  { "314chan.org", false },
  { "31tv.ru", true },
  { "321live.nl", true },
  { "32h.de", true },
  { "32ph.com", true },
  { "33-km.ru", true },
  { "3473-wiki.de", true },
  { "35792.de", true },
  { "365beautyworld.com", true },
  { "365healthworld.com", true },
  { "365maya.com", true },
  { "365skulls.com", true },
  { "368mibn.com", true },
  { "38sihu.com", true },
  { "398.info", true },
  { "39sihu.com", true },
  { "3bigking.com", true },
  { "3c-d.de", true },
  { "3chit.cf", true },
  { "3delivered.com", true },
  { "3dmedium.de", true },
  { "3do3dont.com", true },
  { "3r.org.uk", true },
  { "3s-hosting.de", true },
  { "3timegear.com", true },
  { "4-1-where.com", true },
  { "4-it.de", true },
  { "403.ch", true },
  { "404404.info", true },
  { "4096bit.de", true },
  { "41-where.com", true },
  { "41844.de", true },
  { "41where.com", true },
  { "420dongstorm.com", true },
  { "42ms.org", true },
  { "439191.com", true },
  { "441jj.com", true },
  { "4500.co.il", true },
  { "4679.space", false },
  { "491mhz.net", true },
  { "4azino777.ru", true },
  { "4cclothing.com", true },
  { "4d2.xyz", true },
  { "4g-server.eu", false },
  { "4loc.us", true },
  { "4miners.net", true },
  { "4ourty2.org", true },
  { "4project.co.il", true },
  { "4sqsu.eu", true },
  { "4th-ave-studio.com", true },
  { "4vf.de", true },
  { "4w-performers.link", false },
  { "4winds.pt", true },
  { "4x.fi", true },
  { "500p.xyz", true },
  { "50plusnet.nl", true },
  { "54below.com", true },
  { "54bf.com", true },
  { "57aromas.com", true },
  { "5apps.com", true },
  { "646.io", false },
  { "6660111.ru", true },
  { "692b8c32.de", true },
  { "6969.us", true },
  { "69square.com", true },
  { "700.az", true },
  { "7183.org", true },
  { "777coin.com", true },
  { "7sons.de", true },
  { "7thcircledesigns.com", true },
  { "7thheavenrestaurant.com", true },
  { "7x24servis.com", true },
  { "83i.net", true },
  { "86metro.ru", true },
  { "88.to", true },
  { "888azino.com", true },
  { "888sport.dk", true },
  { "888sport.it", true },
  { "8ack.de", true },
  { "8mpay.com", true },
  { "8pecxstudios.com", true },
  { "8t8.eu", true },
  { "8t88.biz", true },
  { "8thportsmouth.org.uk", true },
  { "90smthng.com", true },
  { "911911.pw", true },
  { "91tianmi.com", false },
  { "922.be", true },
  { "92url.com", true },
  { "9449-27a1-22a1-e0d9-4237-dd99-e75e-ac85-2f47-9d34.de", true },
  { "960news.ca", true },
  { "9906753.net", true },
  { "99511.fi", true },
  { "99599.fi", true },
  { "99599.net", true },
  { "99rst.org", true },
  { "9point6.com", true },
  { "9tolife.be", true },
  { "9vx.org", true },
  { "a-allard.be", true },
  { "a-plus.space", true },
  { "a-theme.com", true },
  { "a200k.xyz", true },
  { "a2c-co.net", true },
  { "a2nutrition.com.au", true },
  { "aa-tour.ru", true },
  { "aamwa.com", true },
  { "aanmpc.com", true },
  { "aaoo.net", true },
  { "aapas.org.ar", true },
  { "aapp.space", true },
  { "aaron-gustafson.com", true },
  { "aaronkimmig.de", true },
  { "aaronsilber.me", true },
  { "aatf.us", true },
  { "aati.info", true },
  { "abacustech.co.jp", true },
  { "abareplace.com", true },
  { "abborsjo.fi", true },
  { "abbruch-star.de", true },
  { "abc-rz.de", true },
  { "abc.li", true },
  { "abcheck.se", true },
  { "abe-elektro.de", true },
  { "abe.cloud", true },
  { "abenteuer-ahnenforschung.de", true },
  { "aberdeenjudo.co.uk", true },
  { "abeus.com", true },
  { "abiapp.net", true },
  { "abilitynet.org.uk", true },
  { "abilma.com", true },
  { "abilymp06.net", true },
  { "abioniere.de", true },
  { "abiturma.de", true },
  { "ablak-nyilaszaro.info", true },
  { "ablogagency.net", true },
  { "abloop.com", true },
  { "abmahnhelfer.de", false },
  { "abmgood.com", false },
  { "abnerchou.me", true },
  { "abolitionism.com", true },
  { "abolitionist-society.com", true },
  { "abolitionist.com", true },
  { "abolitionistsociety.com", true },
  { "abou.to", false },
  { "about.ge", true },
  { "aboutassistedliving.org", true },
  { "aboutmyproperty.ca", true },
  { "abrilect.com", true },
  { "abseits.org", true },
  { "absolem.cc", true },
  { "abstraction21.com", true },
  { "absynthe-inquisition.fr", true },
  { "abt.de", true },
  { "abthorpe.org", true },
  { "abulanov.com", true },
  { "abuse.io", true },
  { "abyssproject.net", true },
  { "ac-town.com", true },
  { "acabadosboston.com", true },
  { "academialowcost.com.br", true },
  { "acara-yoga.de", true },
  { "accelerateyourworld.org", true },
  { "accelight.co.jp", true },
  { "accelight.jp", true },
  { "access-sofia.org", true },
  { "accessacademies.org", true },
  { "accessmy.net", true },
  { "accordiondoor.com", true },
  { "accounts-p.com", true },
  { "accounts.firefox.com", true },
  { "accounts.google.com", true },
  { "accudraftpaintbooths.com", true },
  { "accwing.com", true },
  { "acelpb.com", true },
  { "acessoeducacao.com", true },
  { "acg.sb", false },
  { "acheconcursos.com.br", true },
  { "achenar.net", true },
  { "acheritage.co.uk", true },
  { "achow101.com", true },
  { "achromatisch.de", true },
  { "achtzehn.eu", true },
  { "aciksite.com", true },
  { "aclu.org", false },
  { "acmle.com", false },
  { "acnpacific.com", true },
  { "acoffeeshops.com", true },
  { "acr.im", true },
  { "acritelli.com", true },
  { "acrossgw.com", true },
  { "acrylicwifi.com", true },
  { "acsemb.org", true },
  { "acsports.ca", true },
  { "activatemyiphone.com", true },
  { "active.hu", false },
  { "actorsroom.com", true },
  { "actserv.co.ke", true },
  { "actualite-videos.com", true },
  { "acuica.co.uk", false },
  { "acus.gov", true },
  { "acwcerts.co.uk", true },
  { "ad-notam.asia", true },
  { "ad-notam.ch", true },
  { "ad-notam.co.uk", true },
  { "ad-notam.com", true },
  { "ad-notam.de", true },
  { "ad-notam.fr", true },
  { "ad-notam.it", true },
  { "ad-notam.pt", true },
  { "ad-notam.us", true },
  { "ada.gov", true },
  { "adajwells.me", true },
  { "adalis.org", true },
  { "adam-kostecki.de", true },
  { "adambyers.com", true },
  { "adamdixon.co.uk", true },
  { "adamgold.net", true },
  { "adamkaminski.com", true },
  { "adamkostecki.de", true },
  { "adamoutler.com", true },
  { "adamradocz.com", true },
  { "adamricheimer.com", true },
  { "adams.dk", true },
  { "adamstas.com", true },
  { "adapt-elektronik.com", true },
  { "adapt.de", true },
  { "adapti.de", true },
  { "adaptivemechanics.edu.au", true },
  { "adastra.re", true },
  { "adayinthelifeof.nl", true },
  { "adblock.ovh", true },
  { "adblockextreme.com", true },
  { "adblockextreme.net", true },
  { "adblockextreme.org", true },
  { "adboos.com", true },
  { "addaxpetroleum.com", true },
  { "addeekt.com", true },
  { "adderall.space", true },
  { "addstar.jp", true },
  { "addtoany.com", true },
  { "adduono.com", true },
  { "addvocate.com", true },
  { "adec-emsa.ae", true },
  { "adelaides.com", true },
  { "adelevie.com", true },
  { "adelinlydia-coach.com", true },
  { "adequatetechnology.com", true },
  { "aderal.io", true },
  { "adevel.eu", true },
  { "adhesivelaundry.co.uk", true },
  { "adhoc.is", true },
  { "adhosting.nl", true },
  { "adigitali.biz", true },
  { "adimaja.com", true },
  { "adindexr.com", true },
  { "adiponectinsupplement.info", true },
  { "adiponectinsupplement.net", true },
  { "adjagu.org", true },
  { "adlershop.ch", true },
  { "adme.co.il", true },
  { "admin.fedoraproject.org", true },
  { "admin.google.com", true },
  { "admin.stg.fedoraproject.org", true },
  { "admsel.ec", true },
  { "adnot.am", true },
  { "adoal.net", true },
  { "adonnante.com", true },
  { "adoptionlink.co.uk", true },
  { "adorai.tk", true },
  { "adquisitio.co.uk", true },
  { "adquisitio.de", true },
  { "adquisitio.es", true },
  { "adquisitio.fr", true },
  { "adquisitio.in", true },
  { "adquisitio.it", true },
  { "adr.gov", true },
  { "adrenaline-gaming.ru", false },
  { "adrianajewelry.my", true },
  { "adrinet.tk", true },
  { "adrl.ca", true },
  { "adsfund.org", true },
  { "aduvi.de", true },
  { "advanced-online.eu", true },
  { "advanced-scribes.com", true },
  { "advanced.info", true },
  { "advancedseotool.it", true },
  { "advancis.net", true },
  { "advelty.cz", true },
  { "adventistdeploy.org", true },
  { "adventure-inn.com", true },
  { "adventureally.com", true },
  { "adventureforest.de", false },
  { "adventures.de", true },
  { "adver.top", true },
  { "advocatenalkmaar.org", true },
  { "adxperience.com", true },
  { "adzuna.ca", true },
  { "adzuna.co.uk", true },
  { "adzuna.co.za", true },
  { "adzuna.com.au", true },
  { "adzuna.com.br", true },
  { "adzuna.de", true },
  { "adzuna.fr", true },
  { "adzuna.in", true },
  { "adzuna.nl", true },
  { "adzuna.pl", true },
  { "adzuna.ru", true },
  { "aegee-utrecht.nl", true },
  { "aegrel.ee", true },
  { "aeon.co", false },
  { "aerelon.de", true },
  { "aerialmediapro.net", true },
  { "aerolog.co", true },
  { "aeyoun.com", true },
  { "af-fotografie.net", true },
  { "afb24.de", true },
  { "affiliateroyale.com", true },
  { "affilie.de", true },
  { "affinitysync.com", true },
  { "affordableazdivorce.com", true },
  { "afghan.dating", true },
  { "aficionados.com.br", true },
  { "afinadoronline.com.br", true },
  { "afiru.net", true },
  { "aflattr.com", true },
  { "afmchandler.com", true },
  { "afp548.com", true },
  { "africa.dating", true },
  { "africatravel.de", true },
  { "afrodigital.uk", true },
  { "afuh.de", true },
  { "afva.net", true },
  { "afvallendoeje.nu", true },
  { "afyou.co.kr", false },
  { "agalaxyfarfaraway.co.uk", false },
  { "agatheetraphael.fr", true },
  { "agdalieso.com.ba", true },
  { "ageg.ca", true },
  { "agenda-loto.net", false },
  { "agenda21senden.de", true },
  { "agevio.com", true },
  { "agfmedia.com", true },
  { "aggr.pw", true },
  { "agilebits.com", true },
  { "agilebits.net", false },
  { "agileui.com", true },
  { "aging.gov", true },
  { "agonswim.com", false },
  { "agotnes.com", true },
  { "agowa338.de", true },
  { "agrias.com.br", true },
  { "agroline.by", true },
  { "agwa.name", true },
  { "ahd.com", true },
  { "ahelos.tk", true },
  { "ahero4all.org", true },
  { "ahkubiak.ovh", true },
  { "ahmad.works", true },
  { "ahmerjamilkhan.org", true },
  { "ahoyconference.com", true },
  { "ahoynetwork.com", true },
  { "ahri.ovh", true },
  { "ahwatukeefoothillsmontessori.com", true },
  { "ahxxm.com", true },
  { "ai-english.jp", true },
  { "aia.de", true },
  { "aidanmontare.net", true },
  { "aidikofflaw.com", true },
  { "aids.gov", true },
  { "aie.de", true },
  { "aiesecarad.ro", true },
  { "aify.eu", true },
  { "aigcev.org", true },
  { "aikido-linz.at", true },
  { "aikido-wels.at", true },
  { "aimeeandalec.com", true },
  { "aimotive.com", true },
  { "aiois.com", true },
  { "airbly.com", true },
  { "airbnbopen.com", true },
  { "airedaleterrier.com.br", true },
  { "airhart.me", true },
  { "airhelp.com", true },
  { "airlea.com", true },
  { "airlinecheckins.com", true },
  { "airnow.gov", true },
  { "airpbx.com", true },
  { "airsoft.ch", true },
  { "airvuz.com", true },
  { "aishnair.com", true },
  { "aisle3.space", true },
  { "aistockcharts.com", true },
  { "aiticon.com", true },
  { "aitosoftware.com", true },
  { "aivd.lol", true },
  { "aiwdirect.com", true },
  { "ajouin.com", true },
  { "akachanikuji.com", true },
  { "akaoma.com", true },
  { "akay.me", true },
  { "akboy.pw", true },
  { "akdigitalegesellschaft.de", false },
  { "akelius.de", false },
  { "akhilindurti.com", false },
  { "akhras.at", true },
  { "akostecki.de", true },
  { "akovana.com", true },
  { "akoww.de", true },
  { "akpwebdesign.com", true },
  { "akr.io", true },
  { "akropolis-ravensburg.de", true },
  { "akselinurmio.fi", true },
  { "akstudentsfirst.org", true },
  { "aktiv-naturheilmittel.at", true },
  { "aktiv-naturheilmittel.ch", true },
  { "aktiv-naturheilmittel.de", true },
  { "aktivist.in", true },
  { "akutun.cl", true },
  { "akvorrat.at", true },
  { "al-f.net", true },
  { "aladdinschools.appspot.com", true },
  { "alainwolf.ch", true },
  { "alainwolf.net", true },
  { "alair.cn", false },
  { "alaninkenya.org", true },
  { "alanlee.net", true },
  { "alanrickmanflipstable.com", true },
  { "alaricfavier.eu", true },
  { "alasta.info", true },
  { "alaundeil.xyz", true },
  { "alberguecimballa.es", true },
  { "albersdruck.de", true },
  { "albertbogdanowicz.pl", true },
  { "alboweb.nl", true },
  { "albuic.tk", true },
  { "alcazaar.com", true },
  { "alcorao.org", true },
  { "aldes.co.za", true },
  { "aleax.me", true },
  { "alecpap.com", true },
  { "alecpapierniak.com", true },
  { "alecrust.com", true },
  { "aleksib.fi", true },
  { "alela.fr", true },
  { "alenan.org", true },
  { "alertaenlinea.gov", true },
  { "alertboxx.com", true },
  { "alertwire.com", true },
  { "alex-ross.co.uk", true },
  { "alexanderschimpf.de", true },
  { "alexandra-schulze.de", true },
  { "alexbaker.org", true },
  { "alexberts.ch", true },
  { "alexdaniel.org", true },
  { "alexei.su", true },
  { "alexey-shamara.ru", true },
  { "alexgaynor.net", true },
  { "alexhaydock.co.uk", true },
  { "alexhd.de", true },
  { "alexismeza.com", true },
  { "alexismeza.com.mx", true },
  { "alexismeza.dk", true },
  { "alexismeza.es", true },
  { "alexismeza.nl", true },
  { "alexmak.net", true },
  { "alexmerkel.com", true },
  { "alexmerkel.me", true },
  { "alexmerkel.xyz", true },
  { "alexn.org", true },
  { "alexpavel.com", true },
  { "alexsergeyev.com", true },
  { "alexsexton.com", true },
  { "alextsang.net", true },
  { "alexvetter.de", true },
  { "alexwardweb.com", true },
  { "alexyang.me", true },
  { "alfa-tech.su", true },
  { "alfa24.pro", true },
  { "alfredxing.com", false },
  { "algarmatic-automatismos.pt", true },
  { "algolia.com", true },
  { "alicestudio.it", true },
  { "alienstat.com", true },
  { "alinasmusicstudio.com", true },
  { "alinode.com", true },
  { "alisonisrealestate.com", true },
  { "alisonlitchfield.com", true },
  { "alisync.com", true },
  { "aljaspod.com", true },
  { "aljaspod.hu", true },
  { "aljaspod.net", true },
  { "alkamitech.com", true },
  { "alkel.info", true },
  { "all-connect.net", false },
  { "all4os.com", true },
  { "allabout.me", true },
  { "allbenjoy.de", true },
  { "allcarepharmacy.com", true },
  { "alldaymonitoring.com", true },
  { "alldewall.de", true },
  { "allforyou.at", true },
  { "allfreelancers.su", true },
  { "alliances-faq.de", true },
  { "alliedfrozenstorage.com", true },
  { "allinnote.com", true },
  { "allinonecyprus.com", true },
  { "allmbw.com", true },
  { "allmystery.de", true },
  { "allo-symo.fr", true },
  { "allrealty.co.za", true },
  { "alltheducks.com", true },
  { "allthethings.co.nz", true },
  { "allthings.me", true },
  { "allthingssquared.com", true },
  { "allthingswild.co.uk", true },
  { "alltubedownload.net", true },
  { "alluvion.studio", true },
  { "alnitech.com", false },
  { "alocato.com", true },
  { "alpca.org", true },
  { "alpencam.com", true },
  { "alpencams.com", true },
  { "alpha-force.net", true },
  { "alphabuild.io", true },
  { "alphachat.net", true },
  { "alphagamers.net", true },
  { "alphalabs.xyz", true },
  { "alphassl.de", true },
  { "alphatrash.de", true },
  { "alrait.com", true },
  { "als-hardware.co.za", true },
  { "alspolska.pl", true },
  { "alt-three.com", true },
  { "alt.org", true },
  { "alt33c3.org", true },
  { "altahrim.net", true },
  { "altedirect.com", true },
  { "alternative.bike", true },
  { "alternativet.party", true },
  { "altesses.eu", true },
  { "altestore.com", true },
  { "altfire.ca", true },
  { "altkremsmuensterer.at", true },
  { "altonblom.com", true },
  { "altopia.com", true },
  { "aluminium-scaffolding.co.uk", true },
  { "alumni-kusa.jp", true },
  { "alupferd.de", true },
  { "aluroof.eu", true },
  { "alvicom.hu", true },
  { "alwaysmine.fi", true },
  { "alyoung.com", true },
  { "alza.at", true },
  { "alza.co.uk", true },
  { "alza.cz", true },
  { "alza.de", true },
  { "alza.hu", true },
  { "alza.sk", true },
  { "alzashop.com", true },
  { "am3.se", true },
  { "ama.ne.jp", true },
  { "amadvice.com", true },
  { "amaforums.org", true },
  { "amagdic.com", true },
  { "amagical.net", true },
  { "amandaonishi.com", true },
  { "amani-kinderdorf.de", true },
  { "amartinz.at", true },
  { "amateri.com", true },
  { "amazing-gaming.fr", true },
  { "amazingfloridagulfhomes.com", true },
  { "ambiente.one", true },
  { "ambiq.nl", true },
  { "amcfirst.com", true },
  { "amcvega.com", true },
  { "amdouglas.com", true },
  { "amdouglas.uk", true },
  { "ameego.com", true },
  { "ameego.it", true },
  { "ameego.net", true },
  { "ameego.nl", true },
  { "ameego.org", true },
  { "amees.me", true },
  { "ameho.me", true },
  { "american-truck-simulator.de", true },
  { "american.dating", true },
  { "americanbio.com", true },
  { "americansportsinstitute.org", true },
  { "americkykongres.cz", true },
  { "amerigroup.com", true },
  { "amerimarkdirect.com", true },
  { "amerimex.cc", true },
  { "ameza.co.uk", true },
  { "ameza.com.mx", true },
  { "ameza.io", true },
  { "ameza.me", true },
  { "ami-de-bastanes.fr", true },
  { "amihub.com", true },
  { "amilum.org", true },
  { "amilx.com", true },
  { "amilx.org", true },
  { "amineptine.com", true },
  { "amisharingstuff.com", true },
  { "amishsecurity.com", true },
  { "amitube.com", true },
  { "amnesy.fr", true },
  { "amphetamines.org", true },
  { "amphibo.ly", true },
  { "ams.co.rs", true },
  { "amsportuk.com", true },
  { "amsterdamian.com", true },
  { "amuq.net", true },
  { "amv-crm.ru", true },
  { "amyharrisonline.com", true },
  { "amyrussellhair.com", true },
  { "amzn.rocks", true },
  { "anacruz.es", true },
  { "anadoluefessk.org", true },
  { "anadoluefessporkulubu.org", true },
  { "anagra.ms", true },
  { "anakros.me", false },
  { "analyticsinmotion.com", true },
  { "analyticsinmotion.net", true },
  { "analyticum.at", true },
  { "analyticum.com", true },
  { "analyticum.de", true },
  { "analyticum.eu", true },
  { "analyticum.net", true },
  { "analyzemyfriends.com", true },
  { "ananke.io", true },
  { "anarka.org", true },
  { "anassiriphotography.com", false },
  { "anastasia-shamara.ru", true },
  { "anastasiafond.com", true },
  { "anchorgrounds.com", true },
  { "and-stuff.nl", true },
  { "and.com", true },
  { "andbraiz.com", true },
  { "anderslind.dk", true },
  { "andiplusben.com", true },
  { "andisadhdspot.com", true },
  { "andre-ballensiefen.de", true },
  { "andre-otto.com", true },
  { "andrea-kiaora.de", true },
  { "andrea-wirthensohn.at", true },
  { "andreaboero.it", true },
  { "andreas-kluge.eu", true },
  { "andreaseracleous.com", true },
  { "andreasfeusi.ch", true },
  { "andreasfritz-fotografie.de", true },
  { "andreaskluge.eu", true },
  { "andreaskrasa.com", true },
  { "andreasolsson.se", true },
  { "andreastoneman.com", true },
  { "andrepicard.de", true },
  { "andrewbroekman.com", true },
  { "andrewdaws.tv", true },
  { "andrewhowden.com", true },
  { "andrewimeson.com", true },
  { "andrewin.ru", true },
  { "andrewmichaud.beer", true },
  { "andrewmichaud.com", true },
  { "andrewmichaud.me", true },
  { "andrewregan.me", true },
  { "andrewsun.com", true },
  { "andrewtebert.com", true },
  { "andrewthelott.net", true },
  { "andrewvoce.com", true },
  { "andrewx.net", true },
  { "andreypopp.com", true },
  { "andrezadnik.com", true },
  { "androide.com", true },
  { "andromedacenter.com", true },
  { "androticsdirect.com", true },
  { "andsat.org", true },
  { "anduril.de", true },
  { "anduril.eu", true },
  { "andymoore.info", true },
  { "andyuk.org", true },
  { "anecuni-club.com", true },
  { "anecuni-rec.com", true },
  { "anedot.com", true },
  { "anedot.xyz", true },
  { "anetaben.nl", true },
  { "anfsanchezo.me", true },
  { "anglesya.win", true },
  { "anglictinatabor.cz", true },
  { "angrapa.ru", true },
  { "angristan.fr", true },
  { "angularjs.org", true },
  { "animal-rights.com", true },
  { "animalnet.de", false },
  { "anime.my", false },
  { "animesfusion.com.br", true },
  { "animesharp.com", true },
  { "aniplus.cf", true },
  { "aniplus.gq", true },
  { "aniplus.ml", true },
  { "anita-mukorom.hu", true },
  { "anitaalbersen.nl", true },
  { "anitube-nocookie.ch", true },
  { "anitube.ch", true },
  { "anivar.net", true },
  { "ankakaak.com", true },
  { "ankarakart.com.tr", true },
  { "ankaraprofesyonelwebtasarim.com", true },
  { "ankarauzmanlarnakliyat.com", true },
  { "ankiweb.net", true },
  { "anna.info", true },
  { "annahmeschluss.de", true },
  { "annarokina.com", true },
  { "annejan.com", true },
  { "annetta.com", true },
  { "annevankesteren.com", true },
  { "annevankesteren.nl", true },
  { "annevankesteren.org", true },
  { "anniversary-cruise.com", true },
  { "annuaire-photographe.fr", false },
  { "anohana.org", true },
  { "anojan.com", true },
  { "anoncom.net", true },
  { "anoneko.com", true },
  { "anonukradio.org", true },
  { "anonym-surfen.de", true },
  { "anonyme-spieler.at", true },
  { "anonymo.co.uk", true },
  { "anonymo.uk", true },
  { "anonymousstatecollegelulzsec.com", true },
  { "another.ch", true },
  { "anotherchef.com", true },
  { "anotherfatgeek.net", true },
  { "ans-delft.nl", true },
  { "ansdell.info", true },
  { "ansdell.net", true },
  { "anshuman-chatterjee.com", false },
  { "ansogning-sg.dk", true },
  { "anstoncs.com.au", true },
  { "antarcti.co", true },
  { "anthenor.co.uk", true },
  { "anthonyavon.com", true },
  { "anthonygaidot.fr", true },
  { "anthropoid.ca", true },
  { "anti-radar.org", true },
  { "antikvariat.ru", true },
  { "antiled.by", true },
  { "antipolygraph.org", true },
  { "antoine-roux.fr", true },
  { "antoinedeschenes.com", true },
  { "antonchen.com", true },
  { "antonellabb.eu", true },
  { "antons.io", true },
  { "anvartay.com", true },
  { "anxietyspace.com", true },
  { "any.pm", false },
  { "anyprime.net", true },
  { "anystack.xyz", true },
  { "anytonetech.com", true },
  { "anyways.at", true },
  { "anzeiger.ag", true },
  { "ao-dev.com", true },
  { "ao2.it", true },
  { "aojf.fr", true },
  { "aojiao.org", false },
  { "aoku3d.com", true },
  { "aopedeure.nl", true },
  { "aosc.io", false },
  { "aosus.org", true },
  { "aov.io", true },
  { "aovcentrum.nl", true },
  { "apachehaus.de", false },
  { "apadvantage.com", true },
  { "aparaatti.org", true },
  { "apbox.de", true },
  { "aperture-laboratories.science", true },
  { "aperturesciencelabs.de", true },
  { "apervita.net", true },
  { "apexitsolutions.ca", true },
  { "api-geek.com", true },
  { "api.cloudflare.com", false },
  { "api.intercom.io", true },
  { "api.lookout.com", false },
  { "api.recurly.com", true },
  { "api.simple.com", false },
  { "api.xero.com", false },
  { "apis.google.com", true },
  { "apk4fun.com", true },
  { "aplpackaging.co.uk", true },
  { "apn-einstellungen.de", true },
  { "apolloyl.com", true },
  { "aponkral.net", true },
  { "aponow.de", true },
  { "aposke.com", true },
  { "apothes.is", true },
  { "app-arena.com", true },
  { "app.manilla.com", true },
  { "app.recurly.com", true },
  { "app.simpletax.ca", true },
  { "app.yinxiang.com", false },
  { "appart.ninja", true },
  { "appartementhaus-badria.de", true },
  { "appchive.net", true },
  { "appdrinks.com", true },
  { "appelboomdefilm.nl", true },
  { "appengine.google.com", true },
  { "apperio.com", true },
  { "appharbor.com", true },
  { "apple-watch-zubehoer.de", true },
  { "apple.ax", true },
  { "applelife.ru", true },
  { "applemon.com", true },
  { "appleoosa.com", true },
  { "applez.xyz", true },
  { "applian.jp", true },
  { "apply.eu", true },
  { "appmobile.io", true },
  { "appointed.at", true },
  { "appreciationkards.com", true },
  { "approbo.com", true },
  { "approvedtreecare.com", true },
  { "apps-for-fishing.com", true },
  { "apps.facebook.com", false },
  { "apps.fedoraproject.org", true },
  { "apps.stg.fedoraproject.org", true },
  { "appsbystudio.co.uk", true },
  { "appsdash.io", true },
  { "appui-de-fenetre.fr", true },
  { "appuro.com", true },
  { "apretatuercas.es", true },
  { "aprovpn.com", true },
  { "aprsdroid.org", true },
  { "aprz.de", true },
  { "apstudynotes.org", true },
  { "aptive.co.uk", true },
  { "aqqrate.com", true },
  { "aquapoint.kiev.ua", true },
  { "aquavitaedayspa.com.au", true },
  { "aquilaguild.com", true },
  { "ar.al", true },
  { "arab.dating", true },
  { "arados.de", true },
  { "aradulconteaza.ro", true },
  { "aramado.com", true },
  { "aramido.de", true },
  { "aranel.me", true },
  { "aranycsillag.net", true },
  { "araseifudousan.com", true },
  { "arawaza.biz", true },
  { "arawaza.com", true },
  { "arawaza.info", true },
  { "arbeitskreis-asyl-eningen.de", true },
  { "arbeitslosenverwaltung.de", true },
  { "arbitrarion.com", true },
  { "arbitrary.ch", true },
  { "arboworks.com", true },
  { "archimedicx.com", true },
  { "architectdirect.nl", true },
  { "architecte-interieur.be", true },
  { "archlinux.de", true },
  { "arctic.gov", true },
  { "ardao.me", true },
  { "ardtrade.ru", true },
  { "areafiftylan.nl", true },
  { "areatrend.com", true },
  { "arendburgers.nl", true },
  { "arewedubstepyet.com", true },
  { "argekultur.at", true },
  { "argh.io", true },
  { "arguggi.co.uk", true },
  { "ariacreations.net", true },
  { "ariege-pyrenees.net", true },
  { "arigato-java.download", true },
  { "arima.co.ke", true },
  { "aristocrates.co", true },
  { "aritec-la.com", true },
  { "arivo.com.br", false },
  { "arjandejong.eu", true },
  { "arkaic.dyndns.org", true },
  { "arksan.com.tr", true },
  { "arlen.io", true },
  { "arlen.se", true },
  { "arlet.click", true },
  { "armadaquadrat.com", true },
  { "armandsdiscount.com", true },
  { "armingrodon.de", false },
  { "arminpech.de", true },
  { "armor.com", true },
  { "armored.ninja", true },
  { "armory.consulting", true },
  { "armory.supplies", false },
  { "armstrongsengineering.com", true },
  { "army24.cz", true },
  { "armyprodej.cz", true },
  { "arnaudb.net", true },
  { "arnaudfeld.de", true },
  { "arne-petersen.net", true },
  { "arnesolutions.com", true },
  { "arnetdigital.eu", false },
  { "arnor.org", true },
  { "arokha.com", true },
  { "aromaclub.nl", true },
  { "aroonchande.com", true },
  { "arpa.ph", true },
  { "arrakis.se", true },
  { "arrive.by", true },
  { "arrmaforum.com", true },
  { "arrow-analytics.nl", true },
  { "arrow-api.nl", true },
  { "arrowfunction.com", true },
  { "arrowgrove.com", false },
  { "arrowwebprojects.nl", true },
  { "ars-design.net", true },
  { "arsenal.ru", true },
  { "art2web.net", true },
  { "artegusto.ru", true },
  { "arteseideias.com.pt", true },
  { "artetrama.com", false },
  { "arthurlaw.ca", true },
  { "articaexports.com", true },
  { "artifex21.com", true },
  { "artifex21.fr", true },
  { "artiming.com", true },
  { "artioml.net", true },
  { "artisanhd.com", true },
  { "artisense.de", true },
  { "artisphere.ch", true },
  { "artlego.com", true },
  { "artlifeisgood.com", true },
  { "artlogo.biz", true },
  { "artlogo.cz", true },
  { "artlogo.sk", true },
  { "artmoney.com", true },
  { "artofeyes.nl", true },
  { "artofwhere.com", true },
  { "artroot.jp", true },
  { "artspac.es", true },
  { "arturkohut.com", true },
  { "artweby.cz", true },
  { "arty.name", true },
  { "arubasunsetbeach.com", true },
  { "arvamus.eu", true },
  { "arvid.io", true },
  { "arw.me", true },
  { "aryasenna.net", true },
  { "arzid.com", true },
  { "as.se", true },
  { "as200753.com", true },
  { "as200753.net", true },
  { "as9178.net", true },
  { "asadatec.de", true },
  { "asadzulfahri.com", true },
  { "asafilm.co", true },
  { "asahikoji.net", true },
  { "asandu.eu", true },
  { "asasuou.pw", true },
  { "asato-jewelry.com", true },
  { "asbito.de", true },
  { "ascamso.com", true },
  { "ascension.run", true },
  { "ascgathering.com", true },
  { "ascii.moe", true },
  { "asciitable.tips", true },
  { "aserver.co", true },
  { "ashlane-cottages.com", true },
  { "ashleymedway.com", true },
  { "asia.dating", true },
  { "asianodor.com", true },
  { "ask.fedoraproject.org", true },
  { "ask.stg.fedoraproject.org", true },
  { "askizzy.org.au", true },
  { "askkaren.gov", true },
  { "askmagicconch.com", true },
  { "askme24.de", true },
  { "askwhy.cz", true },
  { "askwhy.eu", true },
  { "asm-x.com", true },
  { "asmui.ga", true },
  { "asmui.ml", true },
  { "aspargesgaarden.no", true },
  { "asphaltfruehling.de", true },
  { "asphyxia.su", true },
  { "aspires.co.jp", true },
  { "asr.li", true },
  { "asr.rocks", true },
  { "asr.solar", true },
  { "asrob.eu", true },
  { "assdecoeur.org", true },
  { "assekuranzjobs.de", true },
  { "assemble-together.org", true },
  { "assurancesmons.be", true },
  { "asta-bar.de", true },
  { "astengox.com", true },
  { "astrea-voetbal-groningen.nl", true },
  { "astrolpost.com", true },
  { "asuhe.cc", true },
  { "asuhe.xyz", true },
  { "asun.co", true },
  { "asurepay.cc", true },
  { "at.search.yahoo.com", false },
  { "atc.io", true },
  { "atchleyjazz.com", true },
  { "atchleyjazz.org", true },
  { "atchleylab.org", true },
  { "ateli.com", true },
  { "atelier-naruby.cz", true },
  { "atelier-rk.com", true },
  { "atelierdesflammesnoires.fr", true },
  { "ateliernaruby.cz", true },
  { "atencionbimbo.com", true },
  { "atg.soy", true },
  { "atgseed.co.uk", true },
  { "atgseed.uk", true },
  { "ath0.org", true },
  { "athenelive.com", true },
  { "athensbusinessresources.us", true },
  { "athi.pl", true },
  { "athlin.de", true },
  { "atishchenko.com", true },
  { "atisoft.biz", true },
  { "atisoft.com.tr", true },
  { "atisoft.net", true },
  { "atisoft.net.tr", true },
  { "atisoft.web.tr", true },
  { "atitude.com", true },
  { "atlantichomes.com.au", true },
  { "atlantischild.hu", true },
  { "atlassian.net", true },
  { "atletika.hu", true },
  { "atlseccon.com", true },
  { "atnis.com", true },
  { "atolm.net", true },
  { "atom-china.org", true },
  { "atom.solutions", true },
  { "atom86.net", true },
  { "atombase.org", true },
  { "atop.io", true },
  { "atraining.ru", true },
  { "atrinik.org", true },
  { "atte.fi", true },
  { "attic118.com", true },
  { "attilagyorffy.com", true },
  { "attogproductions.com", true },
  { "attogtech.com", true },
  { "attorney.org.il", true },
  { "atypicom.es", true },
  { "atypicom.fr", true },
  { "atypicom.it", true },
  { "atypicom.pt", true },
  { "au2pb.net", true },
  { "aubio.org", true },
  { "aucubin.de", true },
  { "aucubin.moe", true },
  { "audiblox.co.za", true },
  { "audiense.com", true },
  { "audio-detector.com", true },
  { "audisto.com", true },
  { "auditmatrix.com", true },
  { "auditos.com", true },
  { "auditsquare.com", true },
  { "auf-feindgebiet.de", true },
  { "aufmerksamkeitsstudie.com", true },
  { "augaware.org", true },
  { "augias.org", true },
  { "augiero.it", true },
  { "augustian-life.cz", true },
  { "augustiner-kantorei-erfurt.de", true },
  { "augustiner-kantorei.de", true },
  { "aujapan.ru", true },
  { "aukaraoke.su", true },
  { "aulo.in", false },
  { "aunali1.com", true },
  { "aur.rocks", true },
  { "aurainfosec.com.au", true },
  { "aureus.pw", true },
  { "auricblue.com", true },
  { "auriko-games.de", true },
  { "auroratownshipfd.org", true },
  { "ausnah.me", true },
  { "ausschreibungen-suedtirol.it", true },
  { "aussiecable.org", true },
  { "aussiehq.com.au", true },
  { "australian.dating", true },
  { "australiancattle.dog", true },
  { "auszeit.bio", true },
  { "auth.adult", true },
  { "authentication.io", true },
  { "authint.com", true },
  { "author24.ru", true },
  { "autimatisering.nl", true },
  { "auto-anleitung.de", true },
  { "autoauctionsohio.com", true },
  { "autoauctionsvirginia.com", true },
  { "autodalmacija.com", true },
  { "autodeploy.it", true },
  { "autoentrepreneurinfo.com", true },
  { "autoledky.sk", true },
  { "automacity.com", true },
  { "autoosijek.com", true },
  { "autoparts.im", true },
  { "autoparts.sh", true },
  { "autoparts.wf", true },
  { "autosiero.nl", true },
  { "autoskola.hr", true },
  { "autoskole.hr", true },
  { "autotsum.com", true },
  { "autumnwindsagility.com", true },
  { "auxetek.se", true },
  { "auxiliumincrementum.co.uk", true },
  { "av.de", true },
  { "ava-creative.de", true },
  { "avaaz.org", true },
  { "avacariu.me", true },
  { "avalon-island.ru", true },
  { "avanovum.de", true },
  { "avantmfg.com", true },
  { "avaq.fr", true },
  { "avarty.com", true },
  { "avarty.net", true },
  { "avastantivirus.ro", true },
  { "avdelivers.com", true },
  { "avenueeyecare.com", true },
  { "avg.club", true },
  { "aviationstrategy.aero", true },
  { "aviodeals.com", true },
  { "avmemo.com", true },
  { "avmo.pw", true },
  { "avmoo.com", true },
  { "avotoma.com", true },
  { "avso.pw", true },
  { "avsox.com", true },
  { "avtovokzaly.ru", true },
  { "avxo.pw", true },
  { "awanderlustadventure.com", true },
  { "awaremi-tai.com", true },
  { "awccanadianpharmacy.com", true },
  { "awk.tw", true },
  { "aww.moe", true },
  { "awxg.com", true },
  { "axg.io", true },
  { "axiomer.com", true },
  { "axiomer.es", true },
  { "axiomer.me", true },
  { "axiomer.net", true },
  { "axiomer.org", true },
  { "axka.com", false },
  { "axolotlfarm.org", true },
  { "axolsoft.com", true },
  { "axrec.de", true },
  { "ayesh.me", true },
  { "aykutcevik.com", true },
  { "aylak.com", true },
  { "aymerick.fr", true },
  { "aymericlagier.com", true },
  { "ayurveda101.com", false },
  { "azabani.com", true },
  { "azazy.net", true },
  { "azbuki.by", true },
  { "azimut.fr", true },
  { "azino777.ru", true },
  { "azirevpn.com", true },
  { "azlk-team.ru", true },
  { "azort.com", true },
  { "aztrix.me", true },
  { "azun.pl", true },
  { "azuxul.fr", true },
  { "azzag.co.uk", true },
  { "azzorti.com", true },
  { "b-landia.net", true },
  { "b-root-force.de", true },
  { "b1c1l1.com", true },
  { "b2and.com", false },
  { "b2bmuzikbank.com", true },
  { "b303.me", true },
  { "b64.club", true },
  { "baalsworld.de", true },
  { "baas-becking.biology.utah.edu", true },
  { "babacasino.net", true },
  { "babak.de", false },
  { "babarkata.com", true },
  { "babelfisch.eu", true },
  { "babettelandmesser.de", true },
  { "babybee.ie", true },
  { "babycs.house", true },
  { "babyfotograf-schweiz.ch", true },
  { "babypibu.com", true },
  { "babystep.tv", true },
  { "bacgrouppublishing.com", true },
  { "backeby.eu", true },
  { "backmountaingas.com", true },
  { "backpacker.dating", true },
  { "backscattering.de", true },
  { "backschues.com", true },
  { "backschues.net", true },
  { "bacon-monitoring.org", true },
  { "bacontreeconsulting.com", true },
  { "bacula.jp", true },
  { "bad.horse", true },
  { "badbee.cc", true },
  { "badcronjob.com", true },
  { "badenhard.eu", true },
  { "badf00d.de", true },
  { "badges.fedoraproject.org", true },
  { "badges.stg.fedoraproject.org", true },
  { "badhusky.com", true },
  { "badkamergigant.com", true },
  { "badlink.org", true },
  { "badoo.com", true },
  { "baer.im", true },
  { "baer.one", true },
  { "baffinlee.com", true },
  { "bagelsbakery.com", false },
  { "baggy.me.uk", true },
  { "bagheera.me.uk", true },
  { "bah.im", true },
  { "baifubao.com", true },
  { "baiker.info", true },
  { "baileebee.com", true },
  { "bair.io", true },
  { "baiyangliu.com", true },
  { "bajic.ch", true },
  { "baka.network", true },
  { "bakabt.info", true },
  { "bakaweb.fr", true },
  { "bakingstone.com", true },
  { "balboa.io", true },
  { "balcan-underground.net", true },
  { "baleares.party", true },
  { "balicekzdravi.cz", true },
  { "balikonos.cz", true },
  { "balist.es", true },
  { "baliyano.com", true },
  { "balkonien.org", true },
  { "ball.holdings", true },
  { "ballarin.cc", true },
  { "ballejaune.com", true },
  { "ballmerpeak.org", true },
  { "balloonphp.com", true },
  { "ballotapi.com", true },
  { "balonmano.co", true },
  { "bananabandy.com", true },
  { "bananium.fr", true },
  { "banbanchs.com", true },
  { "bancacrs.it", true },
  { "bancoctt.pt", true },
  { "bandb.xyz", true },
  { "bandgap.io", true },
  { "bandiga.it", true },
  { "bandrcrafts.com", true },
  { "bangkok.dating", true },
  { "bangzafran.com", false },
  { "bank.simple.com", false },
  { "bankbranchlocator.com", true },
  { "bankcardoffer.com", true },
  { "bankcircle.co.in", true },
  { "bankersonline.com", true },
  { "bankin.com", true },
  { "bankinter.pt", true },
  { "bankofdenton.com", true },
  { "bannisbierblog.de", true },
  { "banqingdiao.com", false },
  { "baofengtech.com", true },
  { "baptiste-peugnez.fr", true },
  { "barans2239.com", true },
  { "barbarians.com", true },
  { "barbaros.info", true },
  { "barbate.fr", true },
  { "barbosha.ru", true },
  { "barbu.family", true },
  { "barburas.com", true },
  { "barcel.com.mx", true },
  { "barclays.net", true },
  { "barcodeberlin.com", true },
  { "barcoderealty.com", true },
  { "bardiharborow.com", true },
  { "bardiharborow.tk", true },
  { "barisi.me", true },
  { "barkerjr.xyz", true },
  { "barqo.co", true },
  { "barrelhead.org", true },
  { "barrett.ag", true },
  { "barrut.me", false },
  { "bars.kh.ua", true },
  { "barslecht.com", true },
  { "barslecht.nl", true },
  { "bartel.ws", true },
  { "bartelt.name", true },
  { "bartlamboo.nl", true },
  { "bartula.de", true },
  { "baruch.me", true },
  { "barunisystems.com", true },
  { "bashc.at", true },
  { "bashcode.ninja", true },
  { "basilisk.io", true },
  { "baskettemple.com", true },
  { "basnieuwenhuizen.nl", true },
  { "basnoslovno.com.ua", true },
  { "basnoslovno.ru", true },
  { "bastelzauberwelt.de", true },
  { "bastianstalder.ch", true },
  { "bastiv.com", true },
  { "basyspro.net", true },
  { "batfoundry.com", true },
  { "batonger.com", true },
  { "batschu.de", true },
  { "batten.eu.org", true },
  { "battleofthegridiron.com", true },
  { "baud.ninja", true },
  { "baudairenergyservices.com", true },
  { "baum.ga", true },
  { "bausep.de", true },
  { "bautied.de", true },
  { "bayden.com", true },
  { "bayrisch-fuer-anfaenger.de", true },
  { "baysse.eu", true },
  { "baywatch.io", true },
  { "bazdell.com", true },
  { "bazos.at", true },
  { "bazos.cz", true },
  { "bazos.sk", true },
  { "bb-shiokaze.jp", true },
  { "bbb1991.me", true },
  { "bbdos.ru", true },
  { "bblovess.cn", true },
  { "bbnx.net", true },
  { "bbuio.com", true },
  { "bbw.dating", true },
  { "bbwcs.co.uk", true },
  { "bc-bd.org", true },
  { "bcbsmagentprofile.com", true },
  { "bcchack.com", true },
  { "bccx.com", true },
  { "bcdonadio.com", true },
  { "bcheng.cf", true },
  { "bchep.com", true },
  { "bcmguide.com", true },
  { "bcmlu.org", true },
  { "bcrook.com", false },
  { "bcswampcabins.com", true },
  { "bcsytv.com", true },
  { "bcvps.com", true },
  { "bcweightlifting.ca", true },
  { "bdd.fi", true },
  { "bddemir.com", true },
  { "bde-epitech.fr", true },
  { "bdikaros-network.net", true },
  { "be-ka-tec.de", true },
  { "be-real.life", true },
  { "be-webdesign.com", true },
  { "be2cloud.de", true },
  { "beachi.es", true },
  { "beamitapp.com", true },
  { "beanjuice.me", true },
  { "beans-one.com", false },
  { "beastlog.tk", true },
  { "beastowner.li", true },
  { "beatnikbreaks.com", true },
  { "beauty24.de", true },
  { "beautykat.ru", true },
  { "bebef.de", true },
  { "bebefofuxo.com.br", true },
  { "bebesurdoue.com", true },
  { "becoast.fr", true },
  { "becubed.co", true },
  { "bedeta.de", true },
  { "bedlingtonterrier.com.br", true },
  { "beehive42.com", true },
  { "beehive42.eu", true },
  { "beehive42.net", true },
  { "beehive42.nl", true },
  { "beehive42.org", true },
  { "beekbier.nl", true },
  { "beeksnetwork.nl", true },
  { "beepan.com", false },
  { "beercandle.com", true },
  { "beerians.com", true },
  { "beerradar.no", true },
  { "beerradar.party", true },
  { "beetleroadstories.com", true },
  { "beetman.net", true },
  { "beeznest.com", true },
  { "befoodsafe.gov", true },
  { "beframed.ch", true },
  { "befundonline.de", true },
  { "befundup.com", true },
  { "behere.be", true },
  { "behoerden-online-dienste.de", true },
  { "beholdthehurricane.com", true },
  { "beijing.dating", true },
  { "beijinglug.club", true },
  { "beikeil.de", true },
  { "beinad.com", true },
  { "beinad.ru", true },
  { "belanglos.de", true },
  { "belani.eu", true },
  { "belcompany.nl", false },
  { "belge.rs", true },
  { "belgers.com", true },
  { "believablebook.com", false },
  { "belltower.io", true },
  { "belly-button-piercings.com", true },
  { "belmontgoessolar.org", true },
  { "belmontprom.com", true },
  { "belt.black", true },
  { "belwederczykow.eu", true },
  { "bely-mishka.by", true },
  { "bemsoft.pl", true },
  { "bemyvictim.com", true },
  { "ben-energy.com", false },
  { "ben.ninja", true },
  { "benchling.com", true },
  { "benchmarkmonument.com", true },
  { "bencorby.com", true },
  { "bendechrai.com", true },
  { "bendemaree.com", true },
  { "bendingtheending.com", true },
  { "bendix.co", true },
  { "beneathvt.com", true },
  { "benhaney.com", true },
  { "benhartmann.de", true },
  { "benhavenarchives.org", true },
  { "benjamin-suess.de", true },
  { "benjamin.pe", true },
  { "benjaminblack.net", true },
  { "benjaminjurke.net", true },
  { "benjamins.com", true },
  { "benk.press", true },
  { "benmatthews.com.au", true },
  { "benmillett.us", false },
  { "benni1.eu", true },
  { "bennink.me", true },
  { "benno.frl", true },
  { "benohead.com", true },
  { "benschnarr.com", true },
  { "bentertain.de", true },
  { "bentley.link", true },
  { "bentrask.com", true },
  { "benzkosmetik.de", true },
  { "benzou-space.com", true },
  { "beourvictim.com", true },
  { "bep362.vn", true },
  { "beranovi.com", true },
  { "berasavocate.com", true },
  { "bergenhave.nl", true },
  { "bergstoneware.com", true },
  { "berlatih.com", true },
  { "berlin-kohlefrei.de", true },
  { "berlin.dating", true },
  { "berlinleaks.com", true },
  { "bermeitinger.eu", true },
  { "bermytraq.bm", true },
  { "berna.fr", true },
  { "berr.yt", true },
  { "berra.se", true },
  { "berst.cz", true },
  { "berthabailey.com", true },
  { "bertrand.bio", true },
  { "beryl.net", true },
  { "besnik.de", true },
  { "besola.de", true },
  { "bespokestraps.com", true },
  { "best-wallpaper.net", true },
  { "best-wedding-quotes.com", true },
  { "bestbeards.ca", true },
  { "bestbrakes.com", true },
  { "bestessayhelp.com", true },
  { "bestgiftever.ca", true },
  { "bestgifts4you.com", true },
  { "bestlashesandbrows.com", true },
  { "bestlashesandbrows.hu", true },
  { "bestmotherfucking.website", true },
  { "bestorangeseo.com", true },
  { "bestperfumebrands.com", true },
  { "bestseries.tv", true },
  { "betaclean.fr", true },
  { "betafive.net", true },
  { "betaworx.de", true },
  { "betaworx.eu", true },
  { "betlander.com", true },
  { "betobaccofree.gov", true },
  { "betonmoney.com", true },
  { "betpamm.com", true },
  { "betterbabyshop.com.au", true },
  { "bettercrypto.org", true },
  { "betterhelp.com", true },
  { "betterlifemakers.com", true },
  { "bettertest.it", true },
  { "bettingbusiness.ru", true },
  { "bettolinokitchen.com", true },
  { "bettrlifeapp.com", true },
  { "betulashop.ch", true },
  { "beulahtabernacle.com", true },
  { "beulen.email", true },
  { "bevinco2020.com", true },
  { "bevinsco.org", true },
  { "bewerbungsfibel.de", true },
  { "bexit-hosting.nl", true },
  { "bexit-security.eu", true },
  { "bexit-security.nl", true },
  { "bexit.nl", true },
  { "bexithosting.nl", true },
  { "beyond-edge.com", true },
  { "beyondalderaan.net", true },
  { "beyondpricing.com", true },
  { "beyondtrust.com", true },
  { "beyondweb.net", true },
  { "beyonic.com", true },
  { "beyours.be", true },
  { "bezprawnik.pl", true },
  { "bfear.com", true },
  { "bfelob.gov", true },
  { "bffm.biz", true },
  { "bfi.wien", false },
  { "bftbradio.com", true },
  { "bfw-online.de", true },
  { "bgdaddy.com", true },
  { "bgenlisted.com", true },
  { "bgkoleda.bg", true },
  { "bgmn.net", true },
  { "bgneuesheim.de", true },
  { "bhatia.at", true },
  { "bhtelecom.ba", true },
  { "bhuntr.com", true },
  { "bianinapiccanovias.com", true },
  { "biasmath.es", true },
  { "biathloncup.ru", true },
  { "bible-maroc.com", true },
  { "bible.ru", true },
  { "bibleonline.ru", true },
  { "biblerhymes.com", true },
  { "bibliaon.com", true },
  { "biblionaut.net", true },
  { "biboumail.fr", true },
  { "bicha.net", true },
  { "bichonmaltes.com.br", true },
  { "bicranial.io", true },
  { "bicycle-events.com", true },
  { "biddl.com", true },
  { "bielsa.me", true },
  { "bienenblog.cc", true },
  { "bienici.com", true },
  { "bierbaumer.net", true },
  { "bierbringer.at", true },
  { "biergaizi.info", true },
  { "bieser.ch", true },
  { "big-andy.co.uk", true },
  { "bigbluedoor.net", true },
  { "bigclassaction.com", true },
  { "bight.ca", true },
  { "bigskymontanalandforsale.com", true },
  { "biguixhe.net", true },
  { "bijuteriicualint.ro", true },
  { "bike-shack.com", true },
  { "biker.dating", true },
  { "bikermusic.net", true },
  { "bikiniseli.com", true },
  { "bildermachr.de", true },
  { "bilgo.com", true },
  { "bilke.org", true },
  { "billaud.eu.org", true },
  { "billiger-mietwagen.de", true },
  { "billigpoker.dk", true },
  { "billigssl.dk", true },
  { "billionairemailinglist.com", true },
  { "billogram.com", true },
  { "billpro.com", true },
  { "billpro.com.au", true },
  { "biltullen.com", true },
  { "bimbo.com", true },
  { "bimbobakeriesusa.com", true },
  { "binarization.com", true },
  { "binaryabstraction.com", true },
  { "binaryevolved.com", true },
  { "binaryfigments.com", false },
  { "binarystud.io", true },
  { "binfind.com", true },
  { "bingofriends.com", true },
  { "bingostars.com", true },
  { "binimo.com", true },
  { "binsp.net", true },
  { "biocrafting.net", true },
  { "biodieseldata.com", true },
  { "bioemsan.cz", true },
  { "biogeniq.ca", true },
  { "biointelligence-explosion.com", true },
  { "bioknowme.com", true },
  { "biolindo.com", false },
  { "bionicspirit.com", true },
  { "biopsychiatry.com", true },
  { "biosbits.org", true },
  { "bioshome.de", true },
  { "biosignalanalytics.com", true },
  { "biospeak.solutions", true },
  { "biosphere.cc", true },
  { "biou.me", true },
  { "bip.gov.sa", false },
  { "birdfeeder.online", true },
  { "birdymanbestreviews.com", true },
  { "birgit-rydlewski.de", true },
  { "birkhoff.me", true },
  { "birminghamsunset.com", true },
  { "birzan.org", true },
  { "biscuits-rec.com", true },
  { "biscuits-shop.com", true },
  { "bismarck.moe", true },
  { "bisterfeldt.com", true },
  { "bit-rapid.com", true },
  { "bit-sentinel.com", true },
  { "bit.voyage", true },
  { "bit8.com", true },
  { "bitbeans.de", true },
  { "bitbit.org", true },
  { "bitbr.net", true },
  { "bitbucket.org", true },
  { "bitchan.it", true },
  { "bitcoin-india.org", true },
  { "bitcoin.asia", true },
  { "bitcoin.ch", true },
  { "bitcoin.co.nz", true },
  { "bitcoin.com", true },
  { "bitcoin.de", true },
  { "bitcoin.im", true },
  { "bitcoin.info", true },
  { "bitcoin.org", true },
  { "bitcoin.us", true },
  { "bitcoinbitcoin.com", true },
  { "bitcoincore.org", true },
  { "bitcoinhk.org", true },
  { "bitcoinworld.me", true },
  { "bitcoinx.ro", true },
  { "bitconcepts.co.uk", true },
  { "biteoftech.com", true },
  { "bitex.la", true },
  { "bitf.ly", true },
  { "bitfactory.ws", true },
  { "bitfasching.de", true },
  { "bitfehler.net", true },
  { "bitfinder.nl", true },
  { "bitfuse.net", true },
  { "bitgo.com", true },
  { "bitheus.com", true },
  { "bitlish.com", true },
  { "bitmessage.ch", true },
  { "bitmex.com", true },
  { "bitminter.com", true },
  { "bitmoe.com", true },
  { "bitmon.net", true },
  { "bitok.com", true },
  { "bitpod.de", true },
  { "bitrage.de", true },
  { "bitraum.io", true },
  { "bitref.com", true },
  { "bitsensor.io", true },
  { "bitshaker.net", true },
  { "bitskins.co", true },
  { "bitskrieg.net", true },
  { "bitstorm.nl", true },
  { "bitstorm.org", true },
  { "bittersweetcandybowl.com", true },
  { "bittmann.me", true },
  { "bittylicious.com", true },
  { "bitvest.io", true },
  { "bitwolk.nl", true },
  { "bityes.org", true },
  { "biurokarier.edu.pl", true },
  { "bivsi.com", true },
  { "biyou-homme.com", true },
  { "biz4x.com", true },
  { "biznpro.ru", true },
  { "biztera.com", true },
  { "bizzartech.com", true },
  { "bjornhelmersson.se", true },
  { "bjornjohansen.no", true },
  { "bk-bund-berlin.de", true },
  { "bk99.de", false },
  { "bl4ckb0x.com", true },
  { "bl4ckb0x.de", true },
  { "bl4ckb0x.eu", true },
  { "bl4ckb0x.info", true },
  { "bl4ckb0x.net", true },
  { "bl4ckb0x.org", true },
  { "blablacar.co.uk", true },
  { "blablacar.com", true },
  { "blablacar.com.tr", true },
  { "blablacar.com.ua", true },
  { "blablacar.de", true },
  { "blablacar.es", true },
  { "blablacar.fr", true },
  { "blablacar.hr", true },
  { "blablacar.hu", true },
  { "blablacar.in", true },
  { "blablacar.it", true },
  { "blablacar.mx", true },
  { "blablacar.nl", true },
  { "blablacar.pl", true },
  { "blablacar.pt", true },
  { "blablacar.ro", true },
  { "blablacar.rs", true },
  { "blablacar.ru", true },
  { "black-armada.com", true },
  { "black-armada.com.pl", true },
  { "black-armada.pl", true },
  { "black-khat.com", true },
  { "black-octopus.ru", true },
  { "black.dating", true },
  { "blackbag.nl", true },
  { "blackberrycentral.com", true },
  { "blackcat.ca", true },
  { "blackcatinformatics.ca", true },
  { "blackcatinformatics.com", true },
  { "blackdesertsp.com", true },
  { "blackdown.de", true },
  { "blackdragoninc.org", true },
  { "blackhelicopters.net", true },
  { "blacknova.io", true },
  { "blackonion.com", true },
  { "blackpapermoon.de", true },
  { "blackpayment.ru", true },
  { "blackphantom.de", true },
  { "blackphoenix.de", true },
  { "blackscytheconsulting.com", true },
  { "blackunicorn.wtf", true },
  { "blaise.io", true },
  { "blakerandall.xyz", true },
  { "blameomar.com", true },
  { "blancodent.com", true },
  { "blankersfamily.com", true },
  { "blantik.net", true },
  { "blastersklan.com", true },
  { "blaudev.es", true },
  { "blauerhunger.de", true },
  { "blauwwit.be", true },
  { "blayne.me", true },
  { "blayneallan.com", true },
  { "blazor.nl", true },
  { "bleche-onlineshop.de", true },
  { "blechschmidt.saarland", true },
  { "blendle.com", true },
  { "blendle.nl", true },
  { "blendlecdn.com", true },
  { "blendr.com", true },
  { "blessedguy.com", true },
  { "blessedguy.net", true },
  { "blessnet.jp", true },
  { "blewebprojects.com", true },
  { "blha303.com.au", true },
  { "blichmann.eu", true },
  { "blieque.co.uk", true },
  { "blindsexdate.nl", true },
  { "blingsparkleshine.com", true },
  { "blinkenlight.co.uk", true },
  { "blinkenlight.com.au", true },
  { "blio.tk", true },
  { "blissjoe.com", true },
  { "blissplan.com", true },
  { "blitzprog.org", true },
  { "blizz.news", true },
  { "blmiller.com", true },
  { "block-this.com", true },
  { "blockchain.info", true },
  { "blockmetry.com", true },
  { "bloemendal.me", true },
  { "blog.gov.uk", true },
  { "blog.gparent.org", true },
  { "blog.linode.com", false },
  { "blog.torproject.org", false },
  { "blogarts.net", true },
  { "blogcuaviet.com", true },
  { "bloggingwithchildren.com", true },
  { "bloglikepro.com", true },
  { "blognone.com", true },
  { "blogreen.org", true },
  { "blowjs.com", true },
  { "bltc.com", true },
  { "bltc.org", true },
  { "blubbablasen.de", true },
  { "blubberladen.de", true },
  { "blue-labs.org", true },
  { "blue-leaf81.net", true },
  { "blue42.net", true },
  { "bluebill.net", true },
  { "bluechilli.com", true },
  { "blueflare.org", true },
  { "bluefuzz.nl", true },
  { "blueimp.net", true },
  { "bluemoonroleplaying.com", true },
  { "bluemosh.com", true },
  { "blueperil.de", true },
  { "bluepoint.foundation", true },
  { "bluepoint.institute", true },
  { "bluepoint.one", true },
  { "bluepostbox.de", true },
  { "bluescloud.xyz", true },
  { "bluex.im", true },
  { "bluex.info", true },
  { "bluex.net", true },
  { "bluex.org", true },
  { "blumenfeldart.com", true },
  { "blumiges-fischbachtal.de", true },
  { "blurringexistence.net", true },
  { "blusmurf.net", true },
  { "blutroyal.de", true },
  { "blvdmb.com", true },
  { "bmet.de", true },
  { "bmoattachments.org", true },
  { "bmone.net", true },
  { "bmros.com.ar", true },
  { "bn1digital.co.uk", true },
  { "bobancoamigo.com", true },
  { "bobcopeland.com", true },
  { "bobobox.net", true },
  { "boboolo.com", true },
  { "bochs.info", true },
  { "bockenauer.at", true },
  { "bodhi.fedoraproject.org", true },
  { "bodo-wolff.de", false },
  { "bodrumfarm.com", true },
  { "bodybuilding-legends.com", true },
  { "boeddhashop.nl", true },
  { "boernecancerfonden.dk", true },
  { "bogner.sh", true },
  { "bohaishibei.com", true },
  { "bohramt.de", true },
  { "boiadeirodeberna.com", true },
  { "boilesen.com", true },
  { "boiseonlinemall.com", true },
  { "bokeyy.com", true },
  { "bolt.cm", true },
  { "boltdata.io", false },
  { "bombsquad.studio", true },
  { "bonapp.restaurant", true },
  { "bondpro.gov", true },
  { "bondskampeerder.nl", true },
  { "bonifacius.be", true },
  { "bonnyprints.at", true },
  { "bonnyprints.ch", true },
  { "bonnyprints.es", true },
  { "bonnyprints.fr", true },
  { "bonobo.cz", true },
  { "bonop.com", true },
  { "bonqoeur.ca", true },
  { "boof.com", false },
  { "bookingapp.nl", true },
  { "bookmein.in", true },
  { "bookofraonlinecasinos.com", true },
  { "bookourdjs.com", true },
  { "bool.be", true },
  { "boomersurf.com", true },
  { "boonbox.com", true },
  { "booth.in.th", true },
  { "borchers-media.de", true },
  { "borderlinegroup.com", true },
  { "boringsecurity.net", true },
  { "boringsmith.com", true },
  { "boris64.net", true },
  { "borisbesemer.com", true },
  { "bornandgrazed.com", true },
  { "borowski.pw", true },
  { "borrelioz.com", true },
  { "borscheid-wenig.com", true },
  { "borysek.net", true },
  { "borzoi.com.br", true },
  { "bostadsportal.se", true },
  { "bosun.io", true },
  { "boudah.pl", true },
  { "bougeret.fr", true },
  { "bouncourseplanner.net", true },
  { "bouncyball.eu", false },
  { "bouncyballs.org", true },
  { "bountyfactory.io", true },
  { "bourasse.fr", true },
  { "bourdon.fr.eu.org", true },
  { "bourse-aux-jouets.org", false },
  { "bourse-aux-vetements.org", false },
  { "bourse-puericulture.org", false },
  { "bowling.com", true },
  { "bownty.be", true },
  { "bownty.co.uk", true },
  { "bownty.de", true },
  { "bownty.dk", true },
  { "bownty.es", true },
  { "bownty.fr", true },
  { "bownty.it", true },
  { "bownty.nl", true },
  { "bownty.pt", true },
  { "bowntycdn.net", true },
  { "boxing-austria.eu", true },
  { "boxintense.com", true },
  { "boxpirates.to", true },
  { "boxview.com", true },
  { "boypoint.de", true },
  { "bp-wahl.at", true },
  { "bpadvisors.eu", true },
  { "bpastudies.org", true },
  { "bpol-forum.de", true },
  { "bqp.io", true },
  { "bqtoolbox.com", true },
  { "br.search.yahoo.com", false },
  { "bracoitaliano.com.br", true },
  { "bradbrockmeyer.com", true },
  { "bradkovach.com", true },
  { "bradler.net", true },
  { "braemer-it-consulting.de", true },
  { "brage.info", true },
  { "brain-e.co", true },
  { "brainfork.ml", true },
  { "brainhub.nl", true },
  { "brainlag.org", true },
  { "brainster.co", false },
  { "braintensive.com", true },
  { "brakemanpro.com", true },
  { "brakstad.org", true },
  { "bralnik.com", true },
  { "bramvanaken.be", true },
  { "bran.cc", true },
  { "bran.land", true },
  { "brandbuilderwebsites.com", true },
  { "brandnewdays.nl", true },
  { "brandon.so", true },
  { "brandongomez.me", true },
  { "brandons.site", true },
  { "brandonwalker.me", true },
  { "brandtrapselfie.nl", true },
  { "branw.xyz", true },
  { "brasalcosmetics.com", true },
  { "brashear.me", true },
  { "brasilmorar.com", true },
  { "bratislava-airport-taxi.com", true },
  { "bratteng.me", false },
  { "bratteng.xyz", true },
  { "brauingenieur.de", true },
  { "braunsteinpc.com", true },
  { "brava.bg", true },
  { "brave.com", true },
  { "bravz.de", true },
  { "brazilian.dating", true },
  { "brb.city", true },
  { "brd.ro", true },
  { "breckle.com.ua", true },
  { "bredvid.no", true },
  { "breechdepot.com", false },
  { "breeethretail.ru", true },
  { "breeswish.org", true },
  { "brefy.com", true },
  { "brege.org", true },
  { "bregnedalsystems.dk", true },
  { "breitbild-beamer.de", true },
  { "brejoc.com", true },
  { "brettcornwall.com", true },
  { "bretz-hufer.de", true },
  { "brevboxar.se", true },
  { "brewtrackr.com", true },
  { "brianalaway.com", true },
  { "brianalawayconsulting.com", true },
  { "brianmwaters.net", true },
  { "brianpcurran.com", true },
  { "brickftp.com", true },
  { "brickoo.com", true },
  { "brid.gy", true },
  { "brideandgroomdirect.ie", true },
  { "bridgeout.com", true },
  { "bridholm.se", true },
  { "brie.tech", true },
  { "brightfuturemadebyme.com", true },
  { "brightonbank.com", true },
  { "brightstarkids.co.uk", false },
  { "brightstarkids.com.au", false },
  { "brightstarkids.net", false },
  { "brightstarkids.sg", false },
  { "brigidaarie.com", true },
  { "brilliantbuilders.co.uk", true },
  { "brilliantdecisionmaking.com", true },
  { "brinkhu.is", true },
  { "bristebein.com", true },
  { "britishgroupsg.com", true },
  { "britishscienceweek.org", true },
  { "britton-photography.com", true },
  { "brivadois.ovh", true },
  { "brix.ninja", true },
  { "brks.xyz", true },
  { "brmsalescommunity.com", true },
  { "broadsheet.com.au", true },
  { "brockmeyer.net", true },
  { "brockmeyer.org", true },
  { "broersma.com", true },
  { "broeselei.at", true },
  { "broken-oak.com", true },
  { "brokenhands.io", true },
  { "bronevichok.ru", true },
  { "brooke-fan.com", true },
  { "brooklynrealestateblog.com", true },
  { "brossman.it", true },
  { "brossmanit.com", true },
  { "brownfieldstsc.org", true },
  { "brownlawoffice.us", true },
  { "brrr.fr", true },
  { "bru6.de", true },
  { "bruckner.li", true },
  { "brunn.email", true },
  { "brunner.ninja", true },
  { "brunohenc.from.hr", true },
  { "brunoonline.co.uk", true },
  { "brunoramos.com", true },
  { "brunoramos.org", true },
  { "brunosouza.org", true },
  { "bryankaplan.com", true },
  { "bryanquigley.com", true },
  { "bryn.xyz", true },
  { "brztec.com", true },
  { "bsagan.fr", true },
  { "bsalyzer.com", true },
  { "bsdug.org", true },
  { "bsidessf.com", true },
  { "bsklabels.com", false },
  { "bsquared.org", true },
  { "bstoked.net", true },
  { "bsuess.de", true },
  { "bsw-solution.de", true },
  { "bta.lv", false },
  { "btc-e.com", true },
  { "btcarmory.com", true },
  { "btcdlc.com", true },
  { "btcontract.com", true },
  { "btio.pw", true },
  { "btorrent.xyz", true },
  { "btrb.ml", true },
  { "btsoft.eu", true },
  { "bubblegumblog.com", true },
  { "bubblespetspa.com", true },
  { "buben.tech", true },
  { "bubulazi.com", true },
  { "bubulazy.com", true },
  { "buch-cuber.de", true },
  { "buck.com", true },
  { "bucket.tk", true },
  { "budaev-shop.ru", true },
  { "buddhistische-weisheiten.org", true },
  { "buddlycrafts.com", true },
  { "buderus-family.be", true },
  { "budger.nl", true },
  { "budgetalk.com", true },
  { "bueltge.de", true },
  { "buenosairesestetica.com.ar", true },
  { "buergerhaushalt.com", true },
  { "buero-stempel.de", true },
  { "buettgens.net", true },
  { "buffaloautomation.com", true },
  { "buffalodrinkinggame.beer", true },
  { "buffhack.com", true },
  { "bugcrowd.com", true },
  { "bugginslab.co.uk", true },
  { "bugs.chromium.org", true },
  { "bugsmashed.com", true },
  { "bugtrack.co.uk", true },
  { "bugwie.com", true },
  { "bugzil.la", true },
  { "bugzilla.mozilla.org", true },
  { "buiko.com", true },
  { "build.chromium.org", false },
  { "buildbox.io", true },
  { "buildci.asia", true },
  { "building-cost-estimators.com", true },
  { "buildingclouds.ch", true },
  { "buildingclouds.de", true },
  { "buildingclouds.es", true },
  { "builditsolutions.net", true },
  { "buildkite.com", true },
  { "builtwith.com", true },
  { "buka.jp", true },
  { "bukatv.cz", true },
  { "bukkenfan.jp", true },
  { "bul3seas.eu", true },
  { "bulario.com", true },
  { "bulbcompare.com", true },
  { "bulbgenie.com", true },
  { "buldogueingles.com.br", true },
  { "bulkcandystore.com", true },
  { "bulktrade.de", true },
  { "bullbits.com", true },
  { "bulldog-hosting.de", true },
  { "bullterrier.me", true },
  { "bulmafox.com", true },
  { "bulmastife.com.br", true },
  { "bunbomenu.de", true },
  { "bunbun.be", false },
  { "bund-von-theramore.de", true },
  { "bundaberg.com", true },
  { "bundespolizei-forum.de", true },
  { "bunkyo-life.com", true },
  { "bunsenlabs.org", true },
  { "buonventosbt.eu", true },
  { "bureaubolster.nl", true },
  { "burgers.io", true },
  { "buri.be", false },
  { "burian-server.cz", true },
  { "burningcrash.de", true },
  { "burningflipside.com", true },
  { "burnworks.com", true },
  { "burpsuite.site", true },
  { "burr.is", true },
  { "burrow.ovh", true },
  { "burtrum.family", true },
  { "burtrum.me", true },
  { "burtrum.name", true },
  { "burtrum.org", true },
  { "burtrum.top", true },
  { "burzmali.com", true },
  { "busindre.com", true },
  { "business.facebook.com", false },
  { "business.lookout.com", false },
  { "business.medbank.com.mt", true },
  { "businessesdirectory.eu", true },
  { "businessfurs.info", true },
  { "businesshub.cz", true },
  { "businessimmigration-eu.com", true },
  { "businessimmigration-eu.ru", true },
  { "businessloanconnection.org", true },
  { "busold.ws", true },
  { "bustimes.org", true },
  { "bustimes.org.uk", true },
  { "buyaccessible.gov", true },
  { "buyinginvestmentproperty.com", true },
  { "buytheway.co.za", true },
  { "buzzconcert.com", true },
  { "buzzconf.io", true },
  { "buzzdeck.com", true },
  { "bvalle.com", true },
  { "bvexplained.co.uk", true },
  { "bvionline.eu", true },
  { "bw.codes", true },
  { "bw81.xyz", true },
  { "bwcscorecard.org", true },
  { "bwear4all.de", true },
  { "bwh1.net", true },
  { "bwilkinson.co.uk", true },
  { "bx-n.de", true },
  { "bxdev.me", true },
  { "bxp40.at", true },
  { "by4cqb.cn", true },
  { "bydisk.com", false },
  { "bygningsregistrering.dk", true },
  { "bymark.co", true },
  { "bymike.co", true },
  { "bynet.cz", true },
  { "bynumlaw.net", true },
  { "bypassed.bid", true },
  { "bypassed.cc", true },
  { "bypassed.club", true },
  { "bypassed.date", true },
  { "bypassed.download", true },
  { "bypassed.faith", true },
  { "bypassed.host", true },
  { "bypassed.me", true },
  { "bypassed.online", true },
  { "bypassed.org", true },
  { "bypassed.party", true },
  { "bypassed.press", true },
  { "bypassed.pw", true },
  { "bypassed.rocks", true },
  { "bypassed.site", true },
  { "bypro.xyz", true },
  { "byrko.cz", true },
  { "byrko.sk", true },
  { "byronwade.com", true },
  { "byrtz.de", true },
  { "byte-time.com", true },
  { "byte.chat", true },
  { "bytejail.com", true },
  { "bytema.cz", true },
  { "bytesatwork.de", true },
  { "bytesatwork.eu", true },
  { "byteshark.org", true },
  { "bytesofcode.de", true },
  { "bytesund.biz", true },
  { "bytesunlimited.com", true },
  { "bytesystems.com", true },
  { "byteturtle.eu", true },
  { "bythisverse.com", true },
  { "bziaks.xyz", true },
  { "bztech.com.br", true },
  { "bzv-fr.eu", true },
  { "c-path.org", true },
  { "c-shock.org", true },
  { "c-webdesign.net", true },
  { "c-world.co.uk", true },
  { "c.cc", true },
  { "c0rn3j.com", true },
  { "c16t.uk", true },
  { "c1yd3i.me", true },
  { "c3b.info", false },
  { "c3vo.de", true },
  { "c3w.at", true },
  { "c4.hk", true },
  { "c4539.com", true },
  { "c4k3.net", true },
  { "ca-key.de", true },
  { "ca-terminal-multiservices.fr", true },
  { "ca.gparent.org", true },
  { "ca.search.yahoo.com", false },
  { "caasd.org", true },
  { "cabarave.com", true },
  { "cablemod.com", true },
  { "cablesandkits.com", true },
  { "cabsites.com", true },
  { "cabusar.fr", true },
  { "cacao-chocolate.com", true },
  { "cacaolalina.com", true },
  { "caceis.bank", true },
  { "cachethq.io", true },
  { "cackette.com", true },
  { "caconnect.org", true },
  { "cadmail.nl", true },
  { "cadoth.net", true },
  { "cadusilva.com", true },
  { "caesarkabalan.com", true },
  { "caesreon.com", true },
  { "cafe-murr.de", true },
  { "cafe-scientifique.org.ec", true },
  { "cafe-service.ru", true },
  { "caffeinatedcode.com", true },
  { "cairnterrier.com.br", true },
  { "cais.de", true },
  { "caitcs.com", true },
  { "caizx.com", false },
  { "caja-pdf.es", true },
  { "cajio.ru", true },
  { "cajunuk.co.uk", true },
  { "calaborlawnews.com", true },
  { "calc.pw", true },
  { "calcularpagerank.com.br", true },
  { "calculator-imt.com", true },
  { "calculator.tf", true },
  { "calebmorris.com", false },
  { "caletka.cz", true },
  { "calgoty.com", true },
  { "calibreapp.com", false },
  { "calibso.net", true },
  { "calixte-concept.fr", true },
  { "callabs.net", true },
  { "callaction.co", true },
  { "callear.org", true },
  { "callhub.io", true },
  { "callision.com", true },
  { "callsigns.ca", true },
  { "calltrackingreports.com", true },
  { "calomel.org", true },
  { "calories.org", true },
  { "caltonnutrition.com", true },
  { "calvin.my", true },
  { "calyxengineers.com", true },
  { "camashop.de", true },
  { "camaya.net", true },
  { "cambier.org", true },
  { "cambodian.dating", true },
  { "cambridgeanalytica.net", true },
  { "cambridgeanalytica.org", true },
  { "camconn.cc", true },
  { "camerweb.es", true },
  { "camjackson.net", true },
  { "camolist.com", true },
  { "camp.co.uk", true },
  { "campaign-ad.com", true },
  { "campaign.gov.uk", true },
  { "campaignelves.com", true },
  { "campbellsoftware.co.uk", false },
  { "campbrainybunch.com", true },
  { "camperdays.de", true },
  { "camperlist.com", true },
  { "campermanaustralia.com", true },
  { "camperverzekerd.nl", true },
  { "campfire.co.il", true },
  { "campfiretails.org", true },
  { "campfourpaws.com", true },
  { "campus-cybersecurity.team", true },
  { "campus-finance.com", true },
  { "canadabread.com", true },
  { "canadalife.de", true },
  { "canadasmotorcycle.ca", true },
  { "canadian.dating", true },
  { "canadianchristianity.com", true },
  { "canarymod.net", true },
  { "cancerdata.nhs.uk", true },
  { "cando.eu", true },
  { "candratech.com", true },
  { "candy-it.de", true },
  { "canfly.org", false },
  { "canhazip.com", true },
  { "canifis.net", true },
  { "cannabis-marijuana.com", true },
  { "cannyfoxx.me", true },
  { "canoonic.se", true },
  { "canterberry.cc", true },
  { "cantrack.com", true },
  { "canva-dev.com", true },
  { "canva.com", true },
  { "canyoupwn.me", true },
  { "cao.gov", true },
  { "cao.la", true },
  { "caodecristachines.com.br", true },
  { "caodesantohumberto.com.br", true },
  { "capacent.is", true },
  { "caphane.com", true },
  { "capitalcap.com", true },
  { "capitalonecardservice.com", true },
  { "capitalquadatv.org.nz", true },
  { "capitaltg.com", true },
  { "capogna.com", true },
  { "capper.de", true },
  { "capriccio.to", true },
  { "caps.is", true },
  { "captchatheprize.com", true },
  { "captianseb.de", true },
  { "captivatedbytabrett.com", true },
  { "capturapp.com", true },
  { "captured-symphonies.com", true },
  { "capturethepen.co.uk", true },
  { "caputo.com", true },
  { "caputodesign.com", true },
  { "car.info", true },
  { "car24portal.de", true },
  { "carauctionnetwork.com", true },
  { "carauctionsalabama.com", true },
  { "carauctionscarolina.com", true },
  { "carauctionsgeorgia.com", true },
  { "caraudio69.cz", true },
  { "carboneselectricosnettosl.info", false },
  { "carbonmade.com", false },
  { "card-toka.jp", true },
  { "cardloan-manual.net", true },
  { "cardranking.jp", true },
  { "cardrecovery.fr", true },
  { "cardse.net", true },
  { "careerstuds.com", true },
  { "caremad.io", true },
  { "caretta.co.uk", true },
  { "carey.bio", true },
  { "carey.li", true },
  { "carezone.com", false },
  { "cargobay.net", true },
  { "caribbean.dating", true },
  { "caribbeanexams.com", true },
  { "carif-idf.net", true },
  { "carif-idf.org", true },
  { "carigami.fr", true },
  { "caringladies.org", true },
  { "cariocacooking.com", true },
  { "carlgo11.com", true },
  { "carlmjohnson.net", true },
  { "carlo.mx", true },
  { "carlosalves.info", true },
  { "carlosjeurissen.com", true },
  { "carnaticalifornia.com", true },
  { "carnildo.com", true },
  { "carolcappelletti.com", true },
  { "caroli.com", true },
  { "carriedin.com", true },
  { "carsforbackpackers.com", true },
  { "carsten.pw", true },
  { "carstenfeuls.de", true },
  { "carterorland.com", true },
  { "carto.la", true },
  { "cartouche24.eu", true },
  { "cartucce24.it", true },
  { "carusorealestate.com", true },
  { "casa-due-pur.com", true },
  { "casa-due-pur.de", true },
  { "casa-due.com", true },
  { "casa-su.casa", true },
  { "casbuijs.nl", true },
  { "cash-pos.com", true },
  { "cashew3d.com", true },
  { "cashplk.com", true },
  { "casinolistings.com", true },
  { "casinoreal.com", true },
  { "casioshop.eu", true },
  { "casovi.cf", true },
  { "casperpanel.com", true },
  { "castagnonavocats.com", true },
  { "castlejackpot.com", true },
  { "cat-box.de", true },
  { "cat.net", true },
  { "catalyst-ecommerce.com", false },
  { "catcontent.cloud", true },
  { "catenacondos.com", true },
  { "catgirl.pics", true },
  { "catholics.dating", true },
  { "cativa.net", true },
  { "catmoose.ca", true },
  { "catnapstudios.com", true },
  { "catnet.dk", false },
  { "catsmagic.pp.ua", true },
  { "cattivo.nl", false },
  { "caulong-ao.net", true },
  { "cavac.at", true },
  { "cavaleria.ro", true },
  { "cavalierkingcharlesspaniel.com.br", true },
  { "cavedroid.xyz", true },
  { "cavzodiaco.com.br", true },
  { "caylercapital.com", true },
  { "cazes.info", true },
  { "cbamo.org", true },
  { "cbbank.com", true },
  { "cbecrft.net", true },
  { "cbhq.net", true },
  { "cbintermountainrealty.com", true },
  { "cbtistexcalac.mx", true },
  { "ccac.gov", true },
  { "ccayearbook.com", true },
  { "ccblog.de", true },
  { "ccgn.co", true },
  { "ccja.ro", false },
  { "ccsys.com", true },
  { "cctld.com", true },
  { "cda-aigle.ch", true },
  { "cdepot.eu", true },
  { "cdkeykopen.com", true },
  { "cdkeyworld.de", true },
  { "cdlcenter.com", true },
  { "cdnb.co", true },
  { "cdnjs.com", true },
  { "cdt.org", true },
  { "ce-agentur.de", true },
  { "ceciliacolombara.com", true },
  { "cecipu.gob.cl", true },
  { "ced-services.nl", true },
  { "cee.io", true },
  { "cegfw.com", true },
  { "ceilingpac.org", true },
  { "cejhon.cz", false },
  { "cekaja.com", true },
  { "celec.gob.ec", false },
  { "celina-reads.de", true },
  { "cellsites.nz", true },
  { "celltek-server.de", true },
  { "celti.ie.eu.org", true },
  { "celti.name", true },
  { "cementscience.com", true },
  { "centennialrewards.com", true },
  { "centerpereezd.ru", false },
  { "central4.me", true },
  { "centrallead.net", true },
  { "centralpoint.be", true },
  { "centralpoint.nl", true },
  { "centralstatecu.org", true },
  { "centralvoice.org", true },
  { "centralync.com", true },
  { "centrationgame.com", true },
  { "centrepoint-community.com", false },
  { "centricweb.com", true },
  { "centrobill.com", true },
  { "centrojovencuenca.es", true },
  { "centrumhodinek.cz", true },
  { "ceoimon.com", true },
  { "ceopedia.org", true },
  { "cerastar.com", true },
  { "cerebelo.info", true },
  { "ceritamalam.net", false },
  { "cerize.love", true },
  { "cerstve-korenie.sk", true },
  { "cerstvekorenie.sk", true },
  { "certcenter.com", true },
  { "certcenter.de", true },
  { "certible.com", true },
  { "certifi.io", true },
  { "certly.io", true },
  { "certmgr.org", true },
  { "certnazionale.it", true },
  { "certspotter.com", true },
  { "certspotter.org", true },
  { "cervejista.com", true },
  { "cesal.net", true },
  { "cesdb.com", true },
  { "cesidianroot.eu", true },
  { "cesipagano.com", true },
  { "cesobaly.cz", true },
  { "cestlav.it", true },
  { "cetamol.com", true },
  { "ceu.edu", false },
  { "cevrimici.com", true },
  { "ceyizlikelisleri.com", true },
  { "cfa.gov", true },
  { "cfan.space", true },
  { "cfcnexus.org", true },
  { "cfetengineering.com", true },
  { "cfh.com", true },
  { "cfo.gov", true },
  { "cfoitplaybook.com", true },
  { "cfxdesign.com", true },
  { "cg-systems.hu", true },
  { "cgan.de", true },
  { "cgan.pw", true },
  { "cganx.org", true },
  { "cgat.no", true },
  { "cgbilling.com", true },
  { "cgcookiemarkets.com", true },
  { "cgtx.us", true },
  { "ch-sc.de", true },
  { "ch.search.yahoo.com", false },
  { "chabaudparfum.com", true },
  { "chahub.com", true },
  { "chainmonitor.com", true },
  { "chaletmanager.com", true },
  { "chalkfestival.org", true },
  { "chamathellawala.com", true },
  { "chameth.com", true },
  { "chamilo.org", true },
  { "champicreuse.fr", true },
  { "chanissue.com", true },
  { "channelcards.com", true },
  { "chaos-inc.de", true },
  { "chaoschemnitz.de", true },
  { "chaosdorf.de", true },
  { "chaosfield.at", true },
  { "chaoslab.org", true },
  { "chaoswebs.net", true },
  { "charcoalvenice.com", true },
  { "charge.co", true },
  { "charitystreet.co.uk", true },
  { "charl.eu", true },
  { "charlenevondell.com", true },
  { "charlesbwise.com", true },
  { "charlesrogers.co.uk", true },
  { "charliehr.com", true },
  { "charlierogers.co.uk", true },
  { "charlierogers.com", true },
  { "charlottesvillegolfcommunities.com", true },
  { "charmander.me", true },
  { "charmyadesara.com", true },
  { "charr.xyz", true },
  { "charta-digitale-vernetzung.de", true },
  { "charteroak.org", true },
  { "chaska.co.za", true },
  { "chat-porc.eu", true },
  { "chatbelgie.eu", true },
  { "chatear.social", true },
  { "chateau-belvoir.com", true },
  { "chatme.im", false },
  { "chatnederland.eu", true },
  { "chatup.cf", true },
  { "chatxp.com", true },
  { "chaulootz.com", true },
  { "chaz6.com", true },
  { "chazay.net", false },
  { "chch.it", true },
  { "cheapdns.org", true },
  { "cheapestgamecards.de", true },
  { "cheapestgamecards.nl", true },
  { "cheapestgamecards.se", true },
  { "cheapgeekts.com", false },
  { "cheapgoa.com", true },
  { "cheapticket.in", true },
  { "cheazey.net", true },
  { "check.torproject.org", false },
  { "checkout.google.com", true },
  { "checkpoint-tshirt.com", true },
  { "checktype.com", true },
  { "checkyourmath.com", true },
  { "cheddarpayments.com", true },
  { "cheerflow.com", true },
  { "cheesetart.my", false },
  { "cheetah85.de", true },
  { "cheetahwerx.com", true },
  { "cheez.systems", true },
  { "chelseafs.co.uk", true },
  { "chenapartment.com", true },
  { "chengl.com", true },
  { "chenky.com", true },
  { "chennien.com", true },
  { "chenzhekl.me", true },
  { "chepaofen.com", true },
  { "cherryonit.com", true },
  { "cherrywoodtech.com", true },
  { "chesterbrass.uk", true },
  { "chestnut.cf", true },
  { "chewey.de", true },
  { "chewey.org", true },
  { "chfr.search.yahoo.com", false },
  { "chhy.at", true },
  { "chiaramail.com", true },
  { "chic-leather.com", true },
  { "chicisimo.com", true },
  { "chicorycom.net", true },
  { "chihiro.xyz", true },
  { "chikan-beacon.net", true },
  { "childno.de", true },
  { "childreninadversity.gov", true },
  { "chilihosting.eu", true },
  { "chimeratool.com", true },
  { "china-line.org", true },
  { "chinacdn.org", true },
  { "chinaspaceflight.com", true },
  { "chint.ai", true },
  { "chinternet.xyz", true },
  { "chiphell.com", true },
  { "chippy.ch", false },
  { "chiralsoftware.com", true },
  { "chireiden.net", true },
  { "chirgui.eu", true },
  { "chiropracticwpb.com", true },
  { "chirpstory.com", true },
  { "chiru.no", true },
  { "chiryotaisaku.com", true },
  { "chit.search.yahoo.com", false },
  { "chloe.re", true },
  { "chloeallison.co.uk", true },
  { "chocolah.com.au", false },
  { "chocotough.nl", false },
  { "choiralberta.ca", true },
  { "chokladfantasi.net", true },
  { "chonghe.org", true },
  { "choosemypc.net", true },
  { "chorkley.co.uk", true },
  { "chorkley.uk", true },
  { "chorpinkpoemps.de", true },
  { "chosenplaintext.org", true },
  { "chotu.net", true },
  { "chourishi-shigoto.com", true },
  { "chris-edwards.net", true },
  { "chrisbrown.id.au", true },
  { "chriscarey.com", true },
  { "chrisebert.net", true },
  { "chrisfaber.com", true },
  { "chrisfinazzo.com", true },
  { "chrisirwin.ca", true },
  { "chrisjean.com", true },
  { "chriskyrouac.com", true },
  { "chrismcclendon.com", true },
  { "chrismckee.co.uk", true },
  { "chrisopperwall.com", true },
  { "chrisshort.net", true },
  { "christadelphiananswers.org", true },
  { "christensenplace.us", true },
  { "christiaanconover.com", true },
  { "christiaandruif.nl", true },
  { "christianbro.gq", true },
  { "christiangaetano.com", true },
  { "christianhoffmann.info", true },
  { "christianliebel.com", true },
  { "christianpusch.de", true },
  { "christians.dating", true },
  { "christianscholz.eu", true },
  { "christiesantiques.com", true },
  { "christina-quast.de", true },
  { "christophercolumbusfoundation.gov", true },
  { "christophersole.com", true },
  { "christophertruncer.com", true },
  { "christophkreileder.com", true },
  { "chrisu3050.at", true },
  { "chrisupjohn.com", true },
  { "chriswarrick.com", true },
  { "chriswells.io", true },
  { "chromaryu.net", true },
  { "chromaxa.com", true },
  { "chrome-devtools-frontend.appspot.com", true },
  { "chrome.com", false },
  { "chrome.google.com", true },
  { "chromebookchart.com", true },
  { "chromebooksforwork.com", true },
  { "chromiumbugs.appspot.com", true },
  { "chromiumcodereview.appspot.com", false },
  { "chronoshop.cz", true },
  { "chrst.ph", true },
  { "chsterz.de", true },
  { "chua.cf", true },
  { "chua.family", true },
  { "chuckame.fr", true },
  { "chun.pro", true },
  { "chunche.net", true },
  { "churchthemes.com", true },
  { "chxdf.net", true },
  { "cianmawhinney.xyz", true },
  { "ciat.no", false },
  { "cidbot.com", true },
  { "ciderclub.com", true },
  { "cienbeaute-lidl.fr", true },
  { "cieslar.io", true },
  { "cig-dem.com", true },
  { "cigarblogs.net", true },
  { "cigarterminal.com", false },
  { "cigi.site", true },
  { "cigoteket.se", true },
  { "cim2b.de", true },
  { "cimalando.eu", false },
  { "cimballa.com", true },
  { "cinartelorgu.com", true },
  { "cine-music.de", true },
  { "cinefilzonen.se", true },
  { "cinema5.ru", true },
  { "cinemaclub.co", true },
  { "cinsects.de", true },
  { "cintdirect.com", true },
  { "cio.gov", true },
  { "cipherboy.com", true },
  { "cipherli.st", true },
  { "ciphrex.com", true },
  { "cirfi.com", true },
  { "cirope.com", true },
  { "cirrus0.de", true },
  { "ciscodude.net", true },
  { "ciscohomeanalytics.com", true },
  { "ciscommerce.net", true },
  { "cisy.me", true },
  { "citationgurus.com", true },
  { "citizen-cam.de", true },
  { "citizensbankal.com", true },
  { "citizenscience.gov", false },
  { "citrusui.me", true },
  { "cittadesign.com", true },
  { "citya.com", true },
  { "citybusexpress.com", true },
  { "ciubotaru.tk", true },
  { "ciuciucadou.ro", true },
  { "cium.ru", true },
  { "cj-jackson.com", true },
  { "cjcaron.org", true },
  { "cjey.me", true },
  { "ck.cx", true },
  { "ckleemann.de", true },
  { "cklie.de", true },
  { "ckliemann.com", true },
  { "ckliemann.net", true },
  { "cktennis.com", true },
  { "cl.search.yahoo.com", false },
  { "claimconnect.us", true },
  { "claimit.ml", true },
  { "clan-ww.com", true },
  { "clanrose.org.uk", true },
  { "clanthor.com", true },
  { "clapping-rhymes.com", true },
  { "clara-baumert.de", true },
  { "claralabs.com", true },
  { "clarkeaward.com", true },
  { "classdojo.com", true },
  { "classicalpilates.ca", true },
  { "classicday.nl", true },
  { "classicshop.ua", true },
  { "classicspublishing.com", true },
  { "classifiedssa.co.za", true },
  { "classpoint.cz", true },
  { "claudio4.com", true },
  { "clawe.de", true },
  { "cldly.com", true },
  { "cleanexperts.co.uk", true },
  { "cleanmta.com", true },
  { "clearc.tk", false },
  { "clearkonjac.com", true },
  { "clearsettle-admin.com", true },
  { "clearviewwealthprojector.com.au", true },
  { "clemovementlaw.com", true },
  { "clerkendweller.uk", true },
  { "clevertarget.ru", true },
  { "cleververmarkten.com", true },
  { "cleververmarkten.de", true },
  { "clevisto.com", true },
  { "clickclickphish.com", true },
  { "clickclock.cc", true },
  { "clickenergy.com.au", true },
  { "clickforclever.com", true },
  { "clickgram.biz", true },
  { "clickphish.com", true },
  { "clicks.co.za", true },
  { "clicn.bio", true },
  { "clicnbio.com", true },
  { "clientboss.com", true },
  { "clientsecure.me", true },
  { "clifflu.net", true },
  { "climaprecio.es", true },
  { "climateinteractive.org", true },
  { "climatestew.com", true },
  { "clinicaltrials.gov", true },
  { "cliniko.com", true },
  { "cliniquepariseau.com", false },
  { "clintonbloodworth.com", true },
  { "clip.ovh", true },
  { "clipclip.com", true },
  { "clipped4u.com", true },
  { "clmde.de", true },
  { "clochix.net", true },
  { "clockcaster.com", true },
  { "clockworksms.com", true },
  { "close.com", false },
  { "closeli.cn", true },
  { "closeli.com", true },
  { "closient.com", true },
  { "cloud-crowd.com.au", true },
  { "cloud-project.com", true },
  { "cloud-surfer.net", true },
  { "cloud.google.com", true },
  { "cloud.gov", false },
  { "cloud.wtf", true },
  { "cloudapi.vc", true },
  { "cloudapps.digital", true },
  { "cloudbasedsite.com", true },
  { "cloudbolin.es", true },
  { "cloudcaprice.net", true },
  { "cloudflareonazure.com", true },
  { "cloudia.org", true },
  { "cloudily.com", true },
  { "cloudimag.es", true },
  { "cloudlink.club", true },
  { "cloudmigrator365.com", true },
  { "cloudns.com.au", true },
  { "cloudpagesforwork.com", true },
  { "cloudpebble.net", true },
  { "cloudpipes.com", true },
  { "clouds.webcam", true },
  { "cloudsecurityalliance.org", true },
  { "cloudspace-analytics.com", true },
  { "cloudstoragemaus.com", true },
  { "cloudstorm.me", true },
  { "cloudstrike.co", true },
  { "cloudteam.de", true },
  { "cloudup.com", true },
  { "clowde.in", true },
  { "clownish.co.il", true },
  { "cloxy.com", true },
  { "clr3.com", true },
  { "clsimplex.com", true },
  { "clu-in.org", true },
  { "club-is.ru", true },
  { "clubeohara.com", true },
  { "clubmate.rocks", true },
  { "clubmini.jp", true },
  { "clubmix.co.kr", true },
  { "clubon.space", true },
  { "cluster.id", true },
  { "clustermaze.net", true },
  { "clvs7.com", true },
  { "clycat.ru", true },
  { "clywedogmaths.co.uk", true },
  { "cmahy.be", true },
  { "cmdline.org", true },
  { "cmsbattle.com", true },
  { "cmylife.nl", true },
  { "cnam.net", true },
  { "cnc-lehrgang.de", true },
  { "cncn.us", true },
  { "cnlic.com", true },
  { "cnwage.com", true },
  { "cnwarn.com", true },
  { "co.search.yahoo.com", false },
  { "coachingconsultancy.com", true },
  { "coalpointcottage.com", true },
  { "coam.co", true },
  { "coatl-industries.com", true },
  { "cobalt.io", true },
  { "cobrasystems.nl", true },
  { "cocaine-import.agency", true },
  { "cocaine.ninja", true },
  { "coccolebenessere.it", true },
  { "cockedey.in", true },
  { "cocker.cc", false },
  { "cockerspanielamericano.com.br", true },
  { "cockerspanielingles.com.br", true },
  { "cocktailfuture.fr", true },
  { "cocoaheads.at", true },
  { "cocodemy.com", true },
  { "cocolovesdaddy.com", true },
  { "codabix.net", true },
  { "code-poets.co.uk", true },
  { "code-well.com", true },
  { "code.facebook.com", false },
  { "code.fm", true },
  { "code.google.com", true },
  { "code67.com", true },
  { "codebrahma.com", true },
  { "codeco.pw", true },
  { "codecontrollers.de", true },
  { "codedump.net", true },
  { "codeferm.com", true },
  { "codefordus.nrw", true },
  { "codeforhakodate.org", true },
  { "codefoundry.it", false },
  { "codeit.guru", true },
  { "codelayer.ca", true },
  { "codelove.de", true },
  { "codenode.io", true },
  { "codeplay.org", true },
  { "codepoet.de", true },
  { "codepoints.net", true },
  { "codepref.com", true },
  { "codepult.com", true },
  { "codera.co.uk", true },
  { "codereview.appspot.com", false },
  { "codereview.chromium.org", false },
  { "coderhangout.com", true },
  { "codesport.io", true },
  { "codeux.com", true },
  { "codewild.de", true },
  { "codewiththepros.org", true },
  { "codewiz.xyz", true },
  { "codeyellow.nl", true },
  { "codigosddd.com.br", true },
  { "coding.net", true },
  { "codingforspeed.com", true },
  { "codingrobots.com", true },
  { "codyevanscomputer.com", true },
  { "codymoniz.com", true },
  { "coffee-mamenoki.jp", true },
  { "cogent.cc", true },
  { "cogitoltd.com", true },
  { "cognitivecomputingconsortium.com", true },
  { "cogumelosmagicos.org", true },
  { "cohesive.io", true },
  { "coi-verify.com", true },
  { "coimmvest.com", true },
  { "coin.dance", true },
  { "coinapult.com", true },
  { "coinbase.com", true },
  { "coincoin.eu.org", true },
  { "coindam.com", false },
  { "coinessa.com", true },
  { "coinjar-sandbox.com", true },
  { "cojo.eu", true },
  { "coldawn.com", true },
  { "coldfff.com", false },
  { "coldhak.ca", true },
  { "coldlostsick.net", true },
  { "coldwatericecream.com", true },
  { "colearnr.com", true },
  { "colegiocierp.com.br", true },
  { "colemak.com", true },
  { "colengo.com", true },
  { "colinchartier.com", true },
  { "colinstark.ca", true },
  { "colinwolff.com", true },
  { "collabornation.net", true },
  { "collabra.email", true },
  { "collaction.hk", true },
  { "collada.org", true },
  { "collectdocs.com", true },
  { "collectfood.com", true },
  { "collectiblebeans.com", true },
  { "collectosaurus.com", true },
  { "collegepulse.org", false },
  { "collinghammethodist.org.uk", true },
  { "collinmbarrett.com", true },
  { "collinsartworks.com", true },
  { "colo-tech.com", true },
  { "colognegaming.net", true },
  { "colombian.dating", true },
  { "coloradocomputernetworking.net", true },
  { "coloradolottery.com", true },
  { "coloraid.net", true },
  { "colorbrush.ru", true },
  { "colorcodedlyrics.com", true },
  { "coloringnotebook.com", true },
  { "colorlib.com", true },
  { "com.cc", true },
  { "comalia.com", true },
  { "comarkinstruments.net", true },
  { "combatshield.cz", true },
  { "combron.nl", true },
  { "comchezmeme.com", true },
  { "comdotgame.com", true },
  { "comdurav.com", true },
  { "comercialtrading.eu", true },
  { "comerford.net", true },
  { "cometcache.com", true },
  { "comff.net", true },
  { "comfy.moe", true },
  { "comhack.com", true },
  { "comico.info", true },
  { "comicspines.com", true },
  { "comitesaustria.at", true },
  { "comiteshopping.com", true },
  { "commania.co.kr", true },
  { "commencepayments.com", true },
  { "commerciallocker.com", false },
  { "commoncore4kids.com", true },
  { "commune-preuilly.fr", true },
  { "communityblog.fedoraproject.org", true },
  { "comodo.nl", true },
  { "comotalk.com", true },
  { "compagnia-buffo.de", true },
  { "compalytics.com", true },
  { "comparamejor.com", true },
  { "compareandrecycle.co.uk", false },
  { "compareandrecycle.com", false },
  { "compareinsurance.com.au", true },
  { "comparejewelleryprices.co.uk", true },
  { "comparetravelinsurance.com.au", true },
  { "comparexcloudcenter.com", true },
  { "compartir.party", true },
  { "compeuphoria.com", true },
  { "compibus.fr", true },
  { "compiledworks.com", true },
  { "compilenix.org", true },
  { "completionist.audio", true },
  { "completionist.me", true },
  { "complexart.ro", true },
  { "compliance-systeme.de", true },
  { "compliancedictionary.com", true },
  { "complymd.com", true },
  { "compraneta.com", true },
  { "compucorner.com.mx", true },
  { "compucorner.mx", true },
  { "computer-acquisti.com", true },
  { "computerbase.de", true },
  { "computerhilfe-feucht.de", true },
  { "computerslotopschool.nl", true },
  { "comssa.org.au", true },
  { "concentrade.de", true },
  { "conclave.global", true },
  { "concretehermit.com", true },
  { "condepenalba.com", true },
  { "condosforcash.com", true },
  { "confiancefoundation.org", true },
  { "config.schokokeks.org", false },
  { "confirm365.com", true },
  { "confiwall.de", true },
  { "conflux.tw", true },
  { "conformal.com", true },
  { "confucio.cl", true },
  { "congineer.com", true },
  { "conjugacao.com.br", true },
  { "connect-ed.network", true },
  { "connect.dating", true },
  { "connectfss.com", true },
  { "connectingconcepts.com", true },
  { "connectum.eu", true },
  { "connext.de", true },
  { "connyduck.at", true },
  { "conrad-kostecki.de", true },
  { "consciousandglamorous.com", true },
  { "consciousbrand.co", true },
  { "consciousbrand.org.au", true },
  { "consciousbranding.org.au", true },
  { "consciousbrands.net.au", true },
  { "console.ninja", true },
  { "console.rest", true },
  { "console.support", true },
  { "consonare.de", true },
  { "constant-rough.de", true },
  { "consul.io", true },
  { "consumer.gov", true },
  { "consumeractionlawgroup.com", true },
  { "consumerfiles.com", true },
  { "consumersentinel.gov", true },
  { "consumidor.gov", true },
  { "contarkos.xyz", true },
  { "content-api-dev.azurewebsites.net", true },
  { "content-design.de", true },
  { "contessa32experience.com", true },
  { "continuumgaming.com", false },
  { "contrabass.net", true },
  { "contributor.google.com", false },
  { "conve.eu", false },
  { "convergemagazine.com", true },
  { "conversiones.com", true },
  { "convert.im", true },
  { "convert.zone", true },
  { "converter.ml", true },
  { "convocatoriafundacionpepsicomexico.org", false },
  { "cooink.net", true },
  { "cookicons.co", true },
  { "cookie4.com", true },
  { "cookiecrook.com", true },
  { "cookiesoft.de", true },
  { "cookinglife.nl", false },
  { "cookingreporter.com", true },
  { "cookmedical.com", false },
  { "cool-wallpapers.jp", true },
  { "cool110.tk", true },
  { "coolaj86.com", true },
  { "cooldan.com", true },
  { "coolviewthermostat.com", true },
  { "coopens.com", true },
  { "coore.jp", true },
  { "cooxa.com", true },
  { "copperhead.co", true },
  { "copypoison.com", true },
  { "copytrack.com", true },
  { "cor-ser.es", true },
  { "coralrosado.com.br", true },
  { "corbinhesse.com", true },
  { "cordlessdog.com", true },
  { "core-networks.de", true },
  { "core.mx", true },
  { "corecdn.org", true },
  { "coredump.gr", true },
  { "coreinfrastructure.org", true },
  { "coreless-stretchfilm.com", true },
  { "corepartners.com.ua", true },
  { "coresolutions.ca", true },
  { "corex.io", true },
  { "coreyjmahler.com", true },
  { "corgi.party", true },
  { "corgicloud.com", true },
  { "cormactagging.ie", true },
  { "cornercircle.co.uk", true },
  { "corniche.com", true },
  { "cornishcamels.com", true },
  { "cornodo.com", true },
  { "corona-academy.com", true },
  { "coronelpicanha.com.br", true },
  { "corpfin.net", true },
  { "corporatesubscriptions.com.au", true },
  { "correct.horse", true },
  { "corruption-mc.net", true },
  { "corruption-rsps.net", true },
  { "corruption-server.net", true },
  { "cortexitrecruitment.com", true },
  { "cortisolsupplement.com", true },
  { "corvus.eu.org", true },
  { "coryadum.com", true },
  { "corzntin.fr", true },
  { "cosmeticappraisal.com", true },
  { "cosmeticasimple.com", true },
  { "cosmeticos-naturales.com", true },
  { "cosmundi.de", true },
  { "costablancavoorjou.com", true },
  { "costreportdata.com", true },
  { "cotonea.de", true },
  { "cougar.dating", true },
  { "coughlan.de", true },
  { "count.sh", false },
  { "counterglobal.com", true },
  { "countermail.com", true },
  { "countryattire.com", true },
  { "countryoutlaws.ca", true },
  { "countybankdel.com", true },
  { "couponcodeq.com", true },
  { "couragefound.org", true },
  { "courageousparentsnetwork.org", true },
  { "coursdeprogrammation.com", true },
  { "coursera.org", true },
  { "courses.nl", true },
  { "courtlistener.com", true },
  { "cousincouples.com", true },
  { "covenantoftheriver.org", true },
  { "coverduck.ru", true },
  { "covershousing.nl", true },
  { "covoiturage.fr", false },
  { "covybrat.cz", true },
  { "cowbird.org", true },
  { "cowboyim.com", true },
  { "coweo.cz", true },
  { "cozmaadrian.ro", true },
  { "cozyeggdesigns.com", true },
  { "cprnearme.com", true },
  { "cpuvinf.eu.org", true },
  { "cpvmatch.eu", true },
  { "cqchome.com", true },
  { "cracker.in.th", true },
  { "crackingking.com", false },
  { "crackle.io", true },
  { "crackpfer.de", true },
  { "crackstation.net", true },
  { "cradlepointecm.com", true },
  { "craftbeerbarn.co.uk", true },
  { "craftcms.com", false },
  { "craftcommerce.com", true },
  { "craftinginredlipstick.com", true },
  { "craigbates.co.uk", true },
  { "craigfrancis.co.uk", true },
  { "craigrouse.com", true },
  { "cranems.com.ua", true },
  { "cranesafe.com", true },
  { "crazifyngers.com", true },
  { "crazydomains.ae", true },
  { "crazydomains.co.nz", true },
  { "crazydomains.co.uk", true },
  { "crazydomains.com.au", true },
  { "crazydomains.in", true },
  { "crazymeeshu.com", true },
  { "crazypaul.com", true },
  { "crbug.com", true },
  { "crea.me", true },
  { "create-test-publish.co.uk", true },
  { "creative-wave.fr", true },
  { "creativeartifice.com", true },
  { "creativecaptiv.es", true },
  { "creativeliquid.com", true },
  { "credential.eu", true },
  { "creditclear.com.au", true },
  { "crediteo.pl", true },
  { "creditkarma.com", true },
  { "creditproautos.com", false },
  { "creditstar.lt", true },
  { "creep.im", true },
  { "creepypastas.com", true },
  { "crefelder.com", true },
  { "crendontech.com", true },
  { "crepererum.net", true },
  { "crescent.gr.jp", true },
  { "crestasantos.com", true },
  { "crestoncottage.com", true },
  { "criena.net", true },
  { "crimewatch.net.za", true },
  { "criminal.enterprises", true },
  { "crimson.no", true },
  { "crisp.im", true },
  { "cristiandeluxe.com", true },
  { "critcola.com", true },
  { "critical.today", true },
  { "criticalaim.com", true },
  { "criticalsurveys.co.uk", true },
  { "crizk.com", true },
  { "crl-autos.com", true },
  { "crm.onlime.ch", false },
  { "crmdemo.website", true },
  { "crockett.io", true },
  { "croome.no-ip.org", true },
  { "crosbug.com", true },
  { "cross-view.com", true },
  { "cross-x.com", true },
  { "crossborderreturns.com", true },
  { "crosscom.ch", true },
  { "crossfitblackwater.com", true },
  { "crosssellguide.com", true },
  { "crow.tw", true },
  { "crowdjuris.com", true },
  { "crowdsupply.com", true },
  { "crownruler.com", true },
  { "crrev.com", true },
  { "crstat.ru", true },
  { "crt.sh", true },
  { "crtvmgmt.com", false },
  { "crudysql.com", true },
  { "crumbcontrol.com", true },
  { "crushroom.com", true },
  { "crustytoothpaste.net", true },
  { "crute.me", true },
  { "cruzr.xyz", true },
  { "crvv.me", true },
  { "crypt.guru", true },
  { "crypticshell.co.uk", true },
  { "crypto.cat", false },
  { "crypto.graphics", true },
  { "crypto.is", false },
  { "cryptobells.com", false },
  { "cryptobin.co", true },
  { "cryptobin.org", true },
  { "cryptocon.org", true },
  { "cryptodash.net", true },
  { "cryptography.io", true },
  { "cryptoisnotacrime.org", true },
  { "cryptolab.pro", true },
  { "cryptolab.tk", true },
  { "cryptonit.net", true },
  { "cryptonym.com", true },
  { "cryptoparty.at", true },
  { "cryptoparty.dk", true },
  { "cryptopartyatx.org", true },
  { "cryptopartynewcastle.org", true },
  { "cryptopartyutah.org", true },
  { "cryptophobia.nl", true },
  { "cryptoseb.pw", true },
  { "cryptoshot.pw", true },
  { "cryptract.co", true },
  { "crystalchandelierservices.com", true },
  { "crystone.me", true },
  { "cs-ubladego.pl", true },
  { "csabg.org", true },
  { "csacongress.org", true },
  { "csbs.fr", true },
  { "cselzer.com", false },
  { "csengle.de", true },
  { "csfm.com", true },
  { "csfs.org.uk", true },
  { "csgo.help", true },
  { "csgoelemental.com", true },
  { "csgogamers.com", true },
  { "csgohandouts.com", true },
  { "csgokings.eu", true },
  { "csgotwister.com", true },
  { "cshopify.com", true },
  { "csmainframe.com", true },
  { "csokolade.hu", true },
  { "cspbuilder.info", true },
  { "cspvalidator.org", true },
  { "csru.net", true },
  { "css.net", true },
  { "cssu.in", true },
  { "cstkit.com", true },
  { "csuw.net", true },
  { "ct-status.org", true },
  { "cthomas.work", true },
  { "cthulhuden.com", true },
  { "ctns.de", true },
  { "ctoforhire.com.au", true },
  { "ctpe.net", true },
  { "ctrld.me", true },
  { "ctyi.me", true },
  { "cube-cloud.com", true },
  { "cube.de", true },
  { "cubecart-demo.co.uk", true },
  { "cubecart-hosting.co.uk", true },
  { "cubecart.net", true },
  { "cubecraft.net", true },
  { "cubecraftstore.com", true },
  { "cubecraftstore.net", true },
  { "cubewano.com", true },
  { "cubos.io", true },
  { "cubostecnologia.com", true },
  { "cubostecnologia.com.br", true },
  { "cubua.com", true },
  { "cucc.date", true },
  { "cuddlecomfort.com", true },
  { "cuecasonline.com.br", true },
  { "cuetoems.com", true },
  { "cuibonobo.com", true },
  { "cuisinezest.com", true },
  { "cujba.com", true },
  { "culinae.nl", true },
  { "cultiv.nl", true },
  { "culturedcode.com", true },
  { "cultureroll.com", true },
  { "cumshots-video.ru", true },
  { "cun.lu", true },
  { "cunha.be", true },
  { "cuni-cuni-club.com", true },
  { "cuni-rec.com", true },
  { "cuonic.com", true },
  { "cup.al", true },
  { "cupcake.io", true },
  { "cupcake.is", true },
  { "cupi.co", true },
  { "cuppycakes.fi", true },
  { "curacao-license.com", true },
  { "curiosity-driven.org", true },
  { "curlybracket.co.uk", true },
  { "currency-strength.com", true },
  { "current.com", true },
  { "curroapp.com", true },
  { "curtacircuitos.com.br", false },
  { "curtis-smith.me.uk", true },
  { "curtis-smith.uk", true },
  { "curtissmith.me.uk", true },
  { "curtissmith.uk", true },
  { "curveprotect.org", true },
  { "custe.rs", true },
  { "custodyxchange.com", true },
  { "customd.com", true },
  { "customfilmworks.com", true },
  { "customshort.link", true },
  { "cutorrent.com", true },
  { "cuvva.co", true },
  { "cuvva.co.uk", true },
  { "cuvva.com", true },
  { "cuvva.eu", true },
  { "cuvva.io", true },
  { "cuvva.it", true },
  { "cuvva.me", true },
  { "cuvva.net", true },
  { "cuvva.org", true },
  { "cuvva.uk", true },
  { "cuvva.us", true },
  { "cvjm-memmingen.de", true },
  { "cvlibrary.co.uk", true },
  { "cvmu.jp", true },
  { "cvr.dk", true },
  { "cvsoftub.com", true },
  { "cvtparking.co.uk", true },
  { "cvursache.com", true },
  { "cvv.cn", true },
  { "cwage.com", true },
  { "cwagner.me", true },
  { "cyanogenmod.xxx", true },
  { "cyber-konzept.de", true },
  { "cyberfrancais.ro", true },
  { "cyberguerrilla.info", true },
  { "cyberguerrilla.org", true },
  { "cyberhouse.at", false },
  { "cyberianhusky.com", true },
  { "cyberkov.com", true },
  { "cyberlab.kiev.ua", true },
  { "cyberoptic.de", true },
  { "cyberpeace.nl", true },
  { "cyberpunk.ca", true },
  { "cybersecurity.nz", true },
  { "cybersecuritychallenge.be", true },
  { "cybershambles.com", true },
  { "cybersins.com", true },
  { "cybersmart.co.uk", true },
  { "cyberspect.com", true },
  { "cyberspect.io", true },
  { "cybertorsk.org", true },
  { "cybertu.be", true },
  { "cyberwire.nl", true },
  { "cyberxpert.nl", true },
  { "cybozu.cn", true },
  { "cybozu.com", true },
  { "cybozulive-dev.com", true },
  { "cybozulive.com", true },
  { "cyclebeads.com", true },
  { "cyclehackluxembourgcity.lu", true },
  { "cydia-search.io", true },
  { "cyfly.org", true },
  { "cygnius.net", true },
  { "cyhour.com", true },
  { "cymtech.net", true },
  { "cyon.ch", true },
  { "cyph.audio", true },
  { "cyph.com", true },
  { "cyph.im", true },
  { "cyph.video", true },
  { "cyphertite.com", true },
  { "cyprus-company-service.com", true },
  { "cysec.biz", true },
  { "czakey.net", true },
  { "czbix.com", true },
  { "czechamlp.com", true },
  { "czechvirus.cz", true },
  { "czerno.com", true },
  { "czk.mk", true },
  { "czlx.co", false },
  { "d-20.fr", true },
  { "d-designerin.de", true },
  { "d-quantum.com", true },
  { "d-training.de", true },
  { "d0xq.net", true },
  { "d3xt3r01.tk", true },
  { "d42.no", true },
  { "d66.nl", true },
  { "daallexx.eu", true },
  { "dachb0den.net", true },
  { "dad256.tk", true },
  { "dadons-laserdiscs.com", true },
  { "dadrian.io", true },
  { "dadtheimpaler.com", true },
  { "daduke.org", true },
  { "daemen.org", true },
  { "daemon.xin", true },
  { "dahlberg.cologne", true },
  { "dailybits.be", true },
  { "dailyenglishchallenge.com", true },
  { "dailylifefinancial.com", false },
  { "daimadi.com", true },
  { "dairyshrine.org", true },
  { "daiwai.de", true },
  { "daiweihu.com", true },
  { "dakerealestate.com", true },
  { "dakl-shop.de", true },
  { "daknob.net", true },
  { "dakrib.net", true },
  { "daladubbeln.se", true },
  { "dale-electric.com", true },
  { "dalek.co.nz", true },
  { "dalfiume.it", false },
  { "dalfsennet.nl", true },
  { "dalingk.co", true },
  { "dalingk.com", true },
  { "dallmeier.net", true },
  { "damedrogy.cz", true },
  { "damienoreilly.org", true },
  { "dammekens.be", true },
  { "damngoodpepper.com", true },
  { "dan.me.uk", true },
  { "dan.org.nz", true },
  { "danaketh.com", true },
  { "danarozmarin.com", true },
  { "danbarrett.com.au", true },
  { "dancerdates.net", true },
  { "dane-bre.net", true },
  { "dango.in", true },
  { "daniel-baumann.ch", true },
  { "daniel-ruf.de", true },
  { "daniel-seifert.com", true },
  { "daniel-steuer.de", true },
  { "danielalvarez.net", true },
  { "danielcowie.me", true },
  { "danielheal.net", true },
  { "danielhochleitner.de", true },
  { "danieliancu.com", true },
  { "danieljamesscott.org", true },
  { "danieljireh.com", true },
  { "danielkoster.nl", true },
  { "danielmarquard.com", true },
  { "danielmostertman.com", false },
  { "danielmostertman.nl", false },
  { "danielrozenberg.com", true },
  { "danielthompson.info", true },
  { "danieltollot.de", true },
  { "danielverlaan.nl", true },
  { "danielvoogsgerd.nl", true },
  { "danilapisarev.com", true },
  { "danishenanigans.com", true },
  { "danjesensky.com", true },
  { "dank.ninja", true },
  { "dankim.de", false },
  { "danny.fm", true },
  { "dannycrichton.com", true },
  { "dannyrohde.de", true },
  { "danonsecurity.com", true },
  { "danpiel.net", false },
  { "danscomp.com", true },
  { "danseressen.nl", true },
  { "dansk-skole.de", true },
  { "danskoferie.dk", true },
  { "danw.io", true },
  { "danwillenberg.com", true },
  { "daphne.informatik.uni-freiburg.de", true },
  { "daplie.com", true },
  { "darbtech.net", true },
  { "darchoods.net", false },
  { "darcymarshall.com", true },
  { "dargasia.is", true },
  { "dario.im", true },
  { "darioturchetti.me", true },
  { "darisni.me", true },
  { "dark-vision.cz", true },
  { "dark-x.cf", true },
  { "darkag.ovh", true },
  { "darkcores.net", true },
  { "darkdestiny.ch", true },
  { "darkengine.io", true },
  { "darkishgreen.com", true },
  { "darknebula.space", false },
  { "darknode.in", true },
  { "darkpony.ru", true },
  { "darkserver.fedoraproject.org", true },
  { "darkserver.stg.fedoraproject.org", true },
  { "darkshop.nl", true },
  { "darkside.re", true },
  { "darksideof.it", true },
  { "darkspacelab.com", true },
  { "darkstance.org", true },
  { "darktime.ru", true },
  { "darktree.in", true },
  { "darkwater.info", true },
  { "darlo.co.uk", false },
  { "darom.jp", true },
  { "darrenellis.xyz", true },
  { "darrenm.net", true },
  { "darrienworth.com", true },
  { "darth-sonic.de", true },
  { "darwinkel.net", false },
  { "das-mediale-haus.de", true },
  { "das-sommercamp.de", true },
  { "dash-board.jp", false },
  { "dash.rocks", true },
  { "dashboard.yt", true },
  { "data-abundance.com", true },
  { "data.haus", true },
  { "data.qld.gov.au", false },
  { "databionix.com", true },
  { "databutlr.com", true },
  { "databutlr.net", true },
  { "datacalle.com", true },
  { "datacandy.com", true },
  { "datadit.hu", true },
  { "datadyne.technology", true },
  { "dataisme.com", true },
  { "datajapan.co.jp", true },
  { "datamatic.ru", true },
  { "datapun.ch", true },
  { "dataretention.solutions", true },
  { "datascience.cafe", true },
  { "datascomemorativas.com.br", true },
  { "datasharesystem.com", true },
  { "dataskydd.net", true },
  { "datasnitch.co.uk", true },
  { "datastream.re", false },
  { "dataswamp.org", true },
  { "datatekniikka.com", false },
  { "datatekniikka.fi", false },
  { "datedeposit.com", true },
  { "datenlast.de", true },
  { "datenschutz-individuell.de", true },
  { "datenschutztag.org", true },
  { "datorb.com", true },
  { "datortipsen.se", true },
  { "datsound.ru", true },
  { "daveaglick.com", true },
  { "daveoc64.co.uk", true },
  { "davepage.me.uk", true },
  { "davescomputertips.com", true },
  { "davevelopment.net", true },
  { "david-corry.com", true },
  { "david-pearce.com", true },
  { "david-schiffmann.de", true },
  { "david.kitchen", true },
  { "davidadrian.org", true },
  { "davidandersson.se", true },
  { "davidandkailey.com", true },
  { "davidcrx.net", true },
  { "davidglidden.eu", true },
  { "davidgouveia.net", true },
  { "davidgow.net", true },
  { "davidgreig.uk", true },
  { "davidlillo.com", true },
  { "davidlyness.com", true },
  { "davidmcevoy.org.uk", true },
  { "davidmessenger.co.uk", true },
  { "davidnadaski.com", true },
  { "davidpearce.com", true },
  { "davidreinhardt.de", true },
  { "davidscherzer.at", true },
  { "davimun.org", true },
  { "davisroi.com", true },
  { "dawson-floridavilla.co.uk", true },
  { "daylightpirates.org", true },
  { "dayman.net", false },
  { "daysoftheyear.com", true },
  { "db-sanity.com", true },
  { "db-works.nl", true },
  { "dbas.cz", true },
  { "dbcom.ru", true },
  { "dbgamestudio.com", true },
  { "dbldub.net", true },
  { "dbmteam.com", true },
  { "dbox.ga", true },
  { "dc562.org", true },
  { "dc585.info", true },
  { "dccode.gov", true },
  { "dccoffeeproducts.com", true },
  { "dcepler.net", true },
  { "dchest.org", true },
  { "dckd.nl", true },
  { "dcl.re", true },
  { "dcmt.co", true },
  { "dcpower.eu", true },
  { "dcuofriends.net", true },
  { "dd.art.pl", true },
  { "ddatsh.com", true },
  { "dden.ca", false },
  { "dden.website", true },
  { "dden.xyz", true },
  { "ddfreedish.site", true },
  { "ddhosted.com", true },
  { "ddmeportal.com", true },
  { "ddns-anbieter.de", true },
  { "ddos-mitigation.co.uk", true },
  { "ddos-mitigation.info", true },
  { "dds.mil", true },
  { "de-medici.nl", true },
  { "de-rwa.de", true },
  { "de-servers.de", true },
  { "de-spil.be", true },
  { "de.search.yahoo.com", false },
  { "deadbeef.ninja", true },
  { "deadsoul.net", true },
  { "deaf.dating", true },
  { "deaktualisierung.org", true },
  { "dealbanana.at", true },
  { "dealbanana.be", true },
  { "dealbanana.co.uk", true },
  { "dealbanana.com", true },
  { "dealbanana.de", true },
  { "dealbanana.fi", true },
  { "dealbanana.fr", true },
  { "dealbanana.it", true },
  { "dealbanana.se", true },
  { "dealcruiser.nl", true },
  { "dealpass.no", true },
  { "deamuseum.org", true },
  { "deanjerkovich.com", true },
  { "deanmorgan.org", true },
  { "deathy.ro", true },
  { "debatch.se", true },
  { "debigare.com", true },
  { "debiton.dk", true },
  { "debron-ot.nl", true },
  { "debtrecycling.com.au", true },
  { "decafu.co", true },
  { "decesus.com", true },
  { "decloverly.com", true },
  { "deco.me", true },
  { "decoboutique.com", true },
  { "decoder.link", true },
  { "decomplify.com", true },
  { "decor-d.com", true },
  { "decoratrix.com", true },
  { "decosoftware.com", true },
  { "decoyrouting.com", true },
  { "dede.ml", true },
  { "dedelta.net", true },
  { "dedeo.tk", true },
  { "dedicatutiempo.es", true },
  { "dedietrich-asia.com", true },
  { "dedimax.de", true },
  { "dedmorozrzn.ru", true },
  { "deduijventil.nl", true },
  { "dee.pe", true },
  { "deepbluecrafting.co.uk", true },
  { "deepcovelabs.net", true },
  { "deeprecce.com", true },
  { "deeprecce.link", true },
  { "deeprecce.tech", true },
  { "deepserve.info", true },
  { "deepzz.com", true },
  { "deer.team", true },
  { "deetz.nl", true },
  { "deezeno.com", true },
  { "def-pos.ru", true },
  { "defcon.org", true },
  { "defendas.com", true },
  { "defero.io", true },
  { "defi-metier.com", true },
  { "defi-metier.fr", true },
  { "defi-metier.org", true },
  { "defi-metiers.com", true },
  { "defi-metiers.org", true },
  { "defiler.tk", true },
  { "defimetier.fr", true },
  { "defimetier.org", true },
  { "defimetiers.com", true },
  { "defimetiers.fr", true },
  { "defuse.ca", true },
  { "degeberg.com", true },
  { "degeberg.dk", true },
  { "degraafschapdierenartsen.nl", true },
  { "dehopre.com", true },
  { "dehydrated.de", true },
  { "deight.co", true },
  { "deinballon.de", true },
  { "deitti.net", true },
  { "dejandayoff.com", true },
  { "dejure.org", true },
  { "dekasan.ru", true },
  { "delayrefunds.co.uk", true },
  { "delbrouck.ch", true },
  { "delfic.org", true },
  { "deliberatedigital.com", true },
  { "deliciisanatoase.ro", true },
  { "deliciousmedia.co.uk", true },
  { "delphine.dance", true },
  { "delta-data.ch", true },
  { "delta-smart.ch", true },
  { "deltasmart.ch", true },
  { "deltava.org", true },
  { "delvj.org", true },
  { "demdis.org", true },
  { "dementiapraecox.de", true },
  { "demo.swedbank.se", true },
  { "democracy.io", true },
  { "demomanca.com", true },
  { "demuzere.be", true },
  { "demuzere.com", true },
  { "demuzere.eu", true },
  { "demuzere.net", true },
  { "demuzere.org", true },
  { "denabot.pw", true },
  { "denardbrewing.com", true },
  { "dengchangdong.com", true },
  { "dengyong.org", true },
  { "denimio.com", true },
  { "denisjean.fr", true },
  { "dennisdoes.net", true },
  { "denniskoot.nl", true },
  { "dennogumi.org", true },
  { "dent.uy", true },
  { "dentallaborgeraeteservice.de", true },
  { "dentistglasgow.com", true },
  { "dentrassi.de", true },
  { "dentystabirmingham.co.uk", true },
  { "denverprophit.us", true },
  { "depechemode-live.com", true },
  { "depicus.com", true },
  { "dequehablamos.es", true },
  { "der-bank-blog.de", true },
  { "der-stein-fluesterer.de", true },
  { "derbyshire-language-scheme.co.uk", true },
  { "derchris.me", true },
  { "derechosdigitales.org", true },
  { "dereferenced.net", true },
  { "deregowski.net", true },
  { "derekkent.com", true },
  { "dergeilstestammderwelt.de", true },
  { "derivativeshub.pro", true },
  { "dermapuur.nl", true },
  { "deroo.org", true },
  { "derp.army", true },
  { "derpumpkinfuhrer.com", true },
  { "derre.fr", true },
  { "derreichesack.com", true },
  { "dersoundhunter.de", true },
  { "designed-cybersecurity.com", true },
  { "designhotel-kronjuwel.de", true },
  { "designpilot.ch", true },
  { "designsbyjanith.com", true },
  { "designville.cz", true },
  { "designville.sk", true },
  { "desmaakvanplanten.be", true },
  { "despora.de", true },
  { "desserteagleselvenar.tk", true },
  { "desterman.ru", true },
  { "destinationbijoux.fr", true },
  { "destinattorneyjohngreene.com", true },
  { "destom.be", true },
  { "desu.ne.jp", true },
  { "detectify.com", false },
  { "detector.exposed", true },
  { "detest.org", true },
  { "dethemium.com", true },
  { "detoxsinutritie.ro", true },
  { "detskysad.com", true },
  { "detteflies.com", true },
  { "detutorial.com", false },
  { "deurenfabriek.nl", true },
  { "deusu.de", true },
  { "deusu.org", true },
  { "deutsch-vietnamesisch-dolmetscher.com", true },
  { "deux.solutions", true },
  { "deuxsol.co", true },
  { "deuxsol.com", true },
  { "deuxsolutions.com", true },
  { "deuxvia.com", true },
  { "dev-tek.de", true },
  { "devb.nl", true },
  { "devct.cz", true },
  { "devcu.com", true },
  { "devdesco.com", true },
  { "devdom.io", true },
  { "devdoodle.net", true },
  { "developer.mydigipass.com", false },
  { "developerfair.com", true },
  { "developers.facebook.com", false },
  { "developfx.com", true },
  { "developmentaid.org", true },
  { "developmentsites.melbourne", true },
  { "develux.com", true },
  { "develux.net", true },
  { "devh.de", true },
  { "devh.net", true },
  { "deviant.email", true },
  { "devilshakerz.com", true },
  { "deviltracks.net", true },
  { "deviltraxxx.de", true },
  { "devincrow.me", true },
  { "devinfo.net", false },
  { "devisnow.fr", true },
  { "devistravaux.org", true },
  { "devklog.net", true },
  { "devlogr.com", true },
  { "devlux.ch", true },
  { "devmsg.com", true },
  { "devnsec.com", true },
  { "devnull.team", true },
  { "devolution.ws", true },
  { "devonsawatzky.ca", true },
  { "devopps.me", true },
  { "devops-survey.com", true },
  { "devopsconnected.com", false },
  { "devpsy.info", true },
  { "devstaff.gr", true },
  { "devzero.io", true },
  { "dewalch.net", true },
  { "dewin.io", true },
  { "dexalo.de", true },
  { "dezeregio.nl", true },
  { "dezmembrariromania.ro", true },
  { "dfctaiwan.org", true },
  { "dfekt.no", true },
  { "dfektlan.no", true },
  { "dfl.mn", true },
  { "dfranke.com", true },
  { "dgby.org", true },
  { "dgeex.eu", true },
  { "dgpot.com", true },
  { "dgt-portal.de", true },
  { "dhautefeuille.eu", true },
  { "dhauwer.nl", true },
  { "dhedegaard.dk", true },
  { "dhhs.gov", true },
  { "dhome.at", true },
  { "dhuy.net", true },
  { "diagnostix.org", true },
  { "diamante.ro", true },
  { "dianefriedli.ch", true },
  { "dianlujitao.com", true },
  { "diare-na-miru.cz", true },
  { "diasdasemana.com", true },
  { "diasp.org", true },
  { "diasporadialogues.com", true },
  { "diavo.de", true },
  { "dibiphp.com", true },
  { "diceduels.com", true },
  { "dicgaming.net", true },
  { "dicionario.org", true },
  { "dicionariodenomesproprios.com.br", true },
  { "dicionariodesimbolos.com.br", true },
  { "dicionariofinanceiro.com", true },
  { "dick.red", true },
  { "dickieslife.com", true },
  { "didacte.com", true },
  { "diddens.de", true },
  { "die-besten-weisheiten.de", true },
  { "die-blahuts.de", true },
  { "die-gruenen-teufel.de", true },
  { "die-partei-reutlingen.de", true },
  { "die-speisekammer-reutlingen.de", true },
  { "dieb.photo", true },
  { "diegelernten.de", true },
  { "diegerbers.de", true },
  { "diehl.io", true },
  { "diemogebhardt.com", true },
  { "dienstplan.cc", true },
  { "dienstplan.one", true },
  { "dierenkruiden.nl", false },
  { "dieselgalleri.com", true },
  { "dietbrand.eu", true },
  { "dieti.net", true },
  { "dietrich-spielwaren.de", true },
  { "dietrich.cx", true },
  { "dieumfrage.com", true },
  { "diezel.com", true },
  { "diferenca.com", true },
  { "diff2html.xyz", true },
  { "different.cz", true },
  { "diffnow.com", true },
  { "dighans.com", true },
  { "digiarc.net", true },
  { "digihyp.ch", true },
  { "digimagical.com", true },
  { "digimedia.cd", true },
  { "digioccumss.ddns.net", true },
  { "digired.xyz", true },
  { "digital-coach.it", false },
  { "digital-eastside.de", true },
  { "digital1st.co.uk", true },
  { "digitalbank.kz", true },
  { "digitalbitbox.com", true },
  { "digitaldeli.org", true },
  { "digitaldeli.tv", true },
  { "digitaldeli.us", true },
  { "digitaldeliarchive.com", true },
  { "digitalehandtekeningen.nl", true },
  { "digitaleoverheid.nl", true },
  { "digitalero.rip", true },
  { "digitalhurricane.io", true },
  { "digitallocker.com", false },
  { "digitalnonplus.com", true },
  { "digitalquery.com", true },
  { "digitalrights.fund", true },
  { "digitalskillswap.com", true },
  { "digitkon.com", true },
  { "digminecraft.com", true },
  { "digwp.com", true },
  { "dijkmanmuziek.nl", false },
  { "dijkmanvandoorn.nl", true },
  { "dillonkorman.com", true },
  { "dim.lighting", true },
  { "dimanss47.net", true },
  { "dime-staging.com", true },
  { "dime.io", true },
  { "dimonb.com", true },
  { "dinepont.fr", true },
  { "dinge.xyz", true },
  { "dingss.com", true },
  { "dinkum.online", true },
  { "dinmtb.dk", true },
  { "dinotv.at", true },
  { "dintillat.fr", true },
  { "dintrafic.net", true },
  { "dinube.com", true },
  { "diodeled.com", true },
  { "dipl.io", false },
  { "dipulse.it", true },
  { "dir2epub.com", true },
  { "dir2epub.org", true },
  { "directebanking.com", true },
  { "directinsure.in", true },
  { "directlinkfunding.co.uk", true },
  { "directme.ga", true },
  { "directnews.be", true },
  { "directreal.sk", true },
  { "direnv.net", true },
  { "dirk-weise.de", true },
  { "dirkwolf.de", true },
  { "disability.gov", true },
  { "disabled.dating", true },
  { "discipul.nl", true },
  { "discofitta.com", true },
  { "disconformity.net", true },
  { "discordapp.com", true },
  { "discotek.club", true },
  { "discoverhealthage.com", true },
  { "dise-online.de", true },
  { "disinclined.org", true },
  { "disking.co.uk", true },
  { "disorderboutique.com", true },
  { "disposable.link", true },
  { "disruptivelabs.net", true },
  { "disruptivelabs.org", true },
  { "dissectcyber.com", true },
  { "dissimulo.me", true },
  { "dist.torproject.org", false },
  { "distinctivephotography.com.au", true },
  { "distinguishedprisoner.com", true },
  { "distractionco.de", true },
  { "distrilogservices.com", true },
  { "ditrutoancau.vn", true },
  { "dittvertshus.no", true },
  { "diva-ey.com", true },
  { "divegearexpress.com", true },
  { "divergenz.org", true },
  { "diversity-spielzeug.de", true },
  { "diversityflags.com", true },
  { "divingwithnic.com", true },
  { "dixiediner.com", true },
  { "dixmag.com", true },
  { "diybook.at", true },
  { "diycc.org", true },
  { "dizorg.net", true },
  { "djangoproject.com", true },
  { "djangosnippets.org", true },
  { "djlive.pl", true },
  { "djlnetworks.co.uk", true },
  { "djul.net", true },
  { "djxmmx.net", false },
  { "dk.search.yahoo.com", false },
  { "dkds.us", true },
  { "dkravchenko.su", true },
  { "dl.google.com", true },
  { "dlaspania.pl", true },
  { "dlc.viasinc.com", true },
  { "dlitz.net", true },
  { "dlld.com", true },
  { "dlouwrink.nl", true },
  { "dlscomputers.com.au", true },
  { "dlzz.net", true },
  { "dm.lookout.com", false },
  { "dm.mylookout.com", false },
  { "dm7ds.de", true },
  { "dmarc.dk", false },
  { "dmcibulldog.com", true },
  { "dmeevalumate.com", true },
  { "dmfd.net", true },
  { "dmi.es", true },
  { "dmix.ca", true },
  { "dmlogic.com", true },
  { "dmtry.me", true },
  { "dmwall.cn", true },
  { "dmxledlights.com", true },
  { "dmz.ninja", true },
  { "dn3s.me", true },
  { "dn42.eu", true },
  { "dn42.us", true },
  { "dna.li", true },
  { "dnc.org.nz", true },
  { "dndtools.net", true },
  { "dne.lu", true },
  { "dnmlab.it", true },
  { "dns-control.eu", true },
  { "dns.google.com", true },
  { "dnscrypt.org", true },
  { "dnscurve.io", true },
  { "dnshallinta.fi", true },
  { "dnslog.com", true },
  { "dnsman.se", true },
  { "do67.de", true },
  { "do67.net", true },
  { "doak.io", true },
  { "dobet.in", true },
  { "dobrev.family", true },
  { "dobrisan.ro", true },
  { "doc.python.org", true },
  { "doc.to", true },
  { "docbox.ch", true },
  { "docemeldoces.com", true },
  { "docid.io", true },
  { "docket.news", true },
  { "docloh.de", true },
  { "docs.google.com", true },
  { "docs.python.org", true },
  { "docset.io", true },
  { "doctor-locks.co.uk", true },
  { "doctor.dating", true },
  { "doctorfox.co.uk", true },
  { "doctorwho.cz", true },
  { "docucopies.com", true },
  { "docufiel.com", true },
  { "doculus.io", true },
  { "docupet.com", true },
  { "doesmycodehavebugs.today", true },
  { "doeswindowssuckforeveryoneorjustme.com", true },
  { "dogan.ch", false },
  { "dogespeed.ga", true },
  { "dogfi.sh", true },
  { "doggieholic.net", true },
  { "dogmap.jp", true },
  { "dognlife.com", true },
  { "dogoodbehappyllc.com", true },
  { "doked.io", true },
  { "dokelio-idf.fr", true },
  { "doku-gilde.de", true },
  { "dokuboard.com", true },
  { "dokuraum.de", true },
  { "dolarcanadense.com.br", true },
  { "doleta.gov", true },
  { "dolevik.com", true },
  { "dolice.net", true },
  { "dollemore.com", true },
  { "dollywiki.co.uk", true },
  { "dolphin-cloud.com", true },
  { "dolphin-hosting.com", true },
  { "dolphin-it.de", true },
  { "dolphinswithlasers.com", true },
  { "dom-medicina.ru", true },
  { "doma.in", true },
  { "domadillo.com", true },
  { "domain001.info", true },
  { "domainexpress.de", false },
  { "domainkauf.de", true },
  { "domains.google.com", true },
  { "domainstaff.com", true },
  { "domenic.me", true },
  { "domfee.com", true },
  { "domhaase.me", true },
  { "dominationgame.co.uk", true },
  { "dominicpratt.de", false },
  { "dominikkulaga.pl", true },
  { "dominioanimal.com", true },
  { "dominioanimal.com.br", true },
  { "dominoknihy.cz", true },
  { "domodedovo.travel", true },
  { "donateaday.net", true },
  { "donkeytrekkingkefalonia.com", true },
  { "donmez.uk", true },
  { "donmez.ws", true },
  { "donner-reuschel.de", true },
  { "donnons.org", false },
  { "donotcall.gov", true },
  { "donotlink.it", true },
  { "donotspellitgav.in", true },
  { "donsbach-edv.de", true },
  { "dontbubble.me", true },
  { "dontcageus.org", true },
  { "donthedragonwilson.com", true },
  { "donttrustrobots.nl", true },
  { "doobydude.us", true },
  { "doodledraw.ninja", true },
  { "dooku.cz", true },
  { "dooleylabs.com", true },
  { "dooleytackaberry.com", true },
  { "doomleika.com", true },
  { "doomsworld.com", true },
  { "doooonoooob.com", true },
  { "doordecor.bg", true },
  { "doorflow.com", true },
  { "dopesoft.de", true },
  { "dopfer-fenstertechnik.de", true },
  { "doppenpost.nl", true },
  { "dopply.com", true },
  { "dorianharmans.nl", true },
  { "dorianmuthig.com", true },
  { "doridian.com", true },
  { "doridian.de", true },
  { "doridian.org", true },
  { "dormiu.com", true },
  { "dormiu.com.br", true },
  { "dot.ro", true },
  { "dot42.no", true },
  { "dotacni-parazit.cz", true },
  { "dotbigbang.com", true },
  { "dotbox.org", true },
  { "dothebangthingsalon.com", true },
  { "dotkod.com", true },
  { "dotkod.pl", true },
  { "dotphoto.com", true },
  { "dotplex.com", true },
  { "dotplex.de", true },
  { "dotrox.net", true },
  { "dotsiam.com", true },
  { "doubleavineyards.com", true },
  { "doublefun.net", true },
  { "doubleyummy.uk", true },
  { "dougferris.id.au", true },
  { "doujinshi.info", true },
  { "dounats.com", true },
  { "dovecotadmin.org", true },
  { "dovetailnow.com", true },
  { "downloadaja.com", true },
  { "downloadgamemods.com", true },
  { "downloadgram.com", true },
  { "downloadsoftwaregratisan.com", true },
  { "doyoulyft.com", true },
  { "dpd.com.pl", true },
  { "dprd-wonogirikab.go.id", false },
  { "dpsg-roden.de", false },
  { "dr2dr.ca", true },
  { "dragfiles.com", true },
  { "dragon-aspect.com", true },
  { "dragon-chem.eu", true },
  { "dragonfly.co.uk", true },
  { "dragonisles.net", true },
  { "dragons-of-highlands.cz", true },
  { "dragonschool.org", true },
  { "dragonstower.net", true },
  { "dragonteam.ninja", true },
  { "drahcro.uk", true },
  { "drainagebuizen.nl", true },
  { "drakeanddragon.com", true },
  { "drakefortreasurer.sexy", true },
  { "drakeluce.com", true },
  { "drakenprospero.com", true },
  { "dramaticpeople.com", true },
  { "dranderle.com", true },
  { "dranek.com", true },
  { "draugr.de", true },
  { "drawesome.uy", true },
  { "drawingcode.net", true },
  { "drbethanybarnes.com", true },
  { "drdevil.ru", true },
  { "drdim.ru", true },
  { "dreadbyte.com", true },
  { "dreamcatcherblog.de", true },
  { "dreamcreator108.com", true },
  { "dreaming.solutions", true },
  { "dreamlinehost.com", false },
  { "dreamsforabetterworld.com.au", true },
  { "dreamtechie.com", true },
  { "dredgepress.com", true },
  { "dreid.org", true },
  { "dreizwosechs.de", true },
  { "dress-cons.com", true },
  { "drew.red", true },
  { "dreweryinc.com", true },
  { "drewgle.net", true },
  { "drgn.no", true },
  { "drhopeson.com", true },
  { "driesjtuver.nl", true },
  { "driftdude.nl", true },
  { "drighes.com", true },
  { "drinkplanet.eu", true },
  { "drinkvabeer.com", true },
  { "drino.org", false },
  { "drishti.guru", true },
  { "drive.google.com", true },
  { "drivenes.net", true },
  { "drivercopilot.com", true },
  { "driverscollection.com", true },
  { "driving-lessons.co.uk", true },
  { "drivinghorror.com", true },
  { "drivya.com", true },
  { "drjoe.ca", true },
  { "drjuanitacollier.com", true },
  { "drkmtrx.xyz", true },
  { "drobniuch.pl", false },
  { "drogueriaelbarco.com", true },
  { "droidapp.nl", true },
  { "droidwiki.de", true },
  { "droncentrum.pl", true },
  { "dronepit.dk", true },
  { "dronexpertos.com", true },
  { "droni.cz", true },
  { "dronografia.es", true },
  { "droomhuis-in-brielle-kopen.nl", true },
  { "droomhuis-in-de-friese-meren-kopen.nl", true },
  { "droomhuis-in-delfzijl-kopen.nl", true },
  { "droomhuis-in-friesland-kopen.nl", true },
  { "droomhuis-in-laren-kopen.nl", true },
  { "droomhuis-in-rijnwaarden-kopen.nl", true },
  { "droomhuis-in-veendam-kopen.nl", true },
  { "droomhuis-in-zeeland-kopen.nl", true },
  { "droomhuis-in-zuid-holland-kopen.nl", true },
  { "droomhuisindestadverkopen.nl", true },
  { "droomhuisophetplattelandverkopen.nl", true },
  { "dropbox.com", true },
  { "dropboxer.net", true },
  { "drpetervoigt.de", true },
  { "drrr.chat", true },
  { "drrr.wiki", true },
  { "drschruefer.de", true },
  { "drsturgeonfreitas.com", true },
  { "drtroyhendrickson.com", true },
  { "drugagodba.si", true },
  { "drumbandesperanto.nl", true },
  { "drumbe.at", true },
  { "drummondframing.com", true },
  { "drupal.org", true },
  { "drweissbrot.net", true },
  { "drycreekphoto.com", true },
  { "ds67.de", true },
  { "dsbrowser.com", true },
  { "dsebastien.net", true },
  { "dsol.hu", true },
  { "dt27.org", true },
  { "dubaieveningsafari.com", true },
  { "dubrovskiy.net", true },
  { "dubrovskiy.pro", true },
  { "duch.cloud", true },
  { "duckasylum.com", true },
  { "duckduckstart.com", true },
  { "duckinc.net", true },
  { "ducohosting.com", true },
  { "duelysthub.com", true },
  { "duernberg.at", false },
  { "duesee.org", true },
  { "duijf.info", true },
  { "duijfathome.nl", true },
  { "dukan-recepty.ru", true },
  { "dukegat.de", true },
  { "dukun.de", true },
  { "dulei.si", true },
  { "dumbeartech.com", true },
  { "dumino.bg", true },
  { "dunableguitars.com", false },
  { "duncancmt.com", true },
  { "duncanwinfrey.com", true },
  { "dune.io", true },
  { "dunea.nl", true },
  { "duo.money", true },
  { "duoluodeyu.com", true },
  { "dupree.co", true },
  { "durangoenergyllc.com", true },
  { "duria.de", true },
  { "durys.be", true },
  { "dustri.org", true },
  { "dustygroove.com", true },
  { "dutch1.nl", true },
  { "dutchessuganda.com", true },
  { "dutchrank.com", true },
  { "dutchrank.nl", true },
  { "dutchwanderers.nl", true },
  { "dutchweballiance.nl", true },
  { "dutyfreeonboard.com", true },
  { "duuu.ch", true },
  { "dvbris.co.uk", true },
  { "dvbris.com", true },
  { "dvorupotocnych.sk", true },
  { "dvotx.org", true },
  { "dvwc.org", true },
  { "dwhd.org", true },
  { "dwnld.me", true },
  { "dworzak.ch", true },
  { "dwtm.ch", true },
  { "dxa.io", false },
  { "dxgl.info", true },
  { "dycontrol.de", true },
  { "dyeager.org", true },
  { "dyktig.as", true },
  { "dyn-nserve.net", true },
  { "dyn.im", true },
  { "dynaloop.net", true },
  { "dynamic-innovations.net", true },
  { "dynamicnet.net", false },
  { "dynamicsnetwork.net", true },
  { "dynamictostatic.com", true },
  { "dynamize.solutions", true },
  { "dyrenesverden.no", true },
  { "dyrkar.com", true },
  { "dziekonski.com", true },
  { "dzlibs.io", true },
  { "dzndk.com", true },
  { "dzndk.net", true },
  { "dzndk.org", true },
  { "dzyabchenko.com", true },
  { "e-biografias.net", true },
  { "e-isfa.eu", true },
  { "e-kontakti.fi", true },
  { "e-learningbs.com", true },
  { "e-lifetechnology.com", true },
  { "e-mak.eu", true },
  { "e-standardstore.org", true },
  { "e-teacher.pl", true },
  { "e-tmf.org", true },
  { "e-tresor.at", true },
  { "e-typ.eu", true },
  { "e.mail.ru", true },
  { "e3amn2l.com", true },
  { "e3kids.com", true },
  { "e5tv.hu", true },
  { "e7d.io", true },
  { "eagleridgecampground.com", true },
  { "eagletechz.com.br", true },
  { "eagleyecs.com", true },
  { "ealev.de", true },
  { "eam-gmbh.com", true },
  { "eames-clayton.us", true },
  { "earga.sm", true },
  { "earmarks.gov", true },
  { "earth-people.org", true },
  { "earthrise16.com", true },
  { "earticleblog.com", true },
  { "easez.net", true },
  { "eason-yang.com", true },
  { "eastmanbusinessinstitute.com", true },
  { "eastmontgroup.com", true },
  { "easy-rpg.org", false },
  { "easychiller.org", true },
  { "easyconstat.com", true },
  { "easycosmetic.ch", true },
  { "easyfiles.ch", true },
  { "easykonto.de", true },
  { "easyocm.hu", true },
  { "easyplane.it", true },
  { "easypv.ch", true },
  { "easysimplecrm.com", false },
  { "easystore.co", true },
  { "eatery.co.il", true },
  { "eaton-works.com", true },
  { "eatsleeprepeat.net", true },
  { "eatvisor.co.uk", true },
  { "eauclairecommerce.com", true },
  { "eb7.jp", true },
  { "ebankcbt.com", true },
  { "ebanking.indovinabank.com.vn", true },
  { "ebankingabersicher.ch", true },
  { "ebankingbutsecure.ch", true },
  { "ebankingentoutesecurite.ch", true },
  { "ebankingmasicuro.ch", true },
  { "ebas.ch", true },
  { "ebataw.com", true },
  { "ebaymotorssucks.com", true },
  { "ebcs-solutions.com", true },
  { "ebiografia.com", true },
  { "ebiografias.com.br", true },
  { "ebonyriddle.com", true },
  { "eboyer.com", true },
  { "ebraph.com", true },
  { "ecake.in", true },
  { "ecc-kaufbeuren.de", true },
  { "ecchidreams.com", true },
  { "ecco-verde.com", false },
  { "ecdn.cz", true },
  { "ecfs.link", true },
  { "ecg.fr", false },
  { "echo-security.co", true },
  { "echoactive.com", true },
  { "echomanchester.net", true },
  { "echopaper.com", true },
  { "echosixmonkey.com", true },
  { "eckel.co", true },
  { "eckro.com", true },
  { "eclipse.ws", true },
  { "ecnetworker.com", true },
  { "ecogen.com.au", true },
  { "ecogen.net.au", true },
  { "ecole-maternelle-saint-joseph.be", true },
  { "ecolesrec.ch", true },
  { "ecomlane.com", true },
  { "ecompen.co.za", true },
  { "econsumer.gov", true },
  { "ecorp.cc", true },
  { "ecos-ev.de", true },
  { "ecosystem.atlassian.net", true },
  { "ecotruck-pooling.com", true },
  { "ecrimex.net", true },
  { "ectora.com", true },
  { "ecupcafe.com", false },
  { "ed.gs", true },
  { "edakoe.ru", true },
  { "edati.lv", true },
  { "edcphenix.tk", true },
  { "edd-miles.com", true },
  { "eddmil.es", true },
  { "eddmixpanel.com", true },
  { "eddyn.net", true },
  { "edelblack.ch", true },
  { "eden-noel.at", true },
  { "edenaya.com", true },
  { "edesseglabor.hu", true },
  { "edfa3ly.co", true },
  { "edfa3ly.com", true },
  { "edge-cloud.net", true },
  { "edgereinvent.com", true },
  { "edicct.com", true },
  { "ediscomp.sk", true },
  { "edisonlee55.com", true },
  { "edit.yahoo.com", false },
  { "edited.de", true },
  { "edition-sonblom.de", true },
  { "edix.ru", true },
  { "edmundcelis.com", true },
  { "edoss.co.za", true },
  { "edpubs.gov", true },
  { "eduard-dopler.de", true },
  { "eduardnikolenko.ru", true },
  { "educationunlimited.com", true },
  { "educator-one.com", true },
  { "educourse.ga", true },
  { "eduid.se", true },
  { "eduif.nl", false },
  { "eduroam.no", true },
  { "edusantorini.com", true },
  { "edv-lehrgang.de", true },
  { "edvmesstec.de", true },
  { "edwards.me.uk", true },
  { "edwardsnowden.com", true },
  { "edxg.de", false },
  { "edyou.eu", true },
  { "edzilla.info", true },
  { "ee-terminals.com", true },
  { "eeb98.com", true },
  { "eelsden.net", true },
  { "eelzak.nl", true },
  { "eengezinswoning-in-alphen-aan-den-rijn-kopen.nl", true },
  { "eengezinswoning-in-de-friese-meren-kopen.nl", true },
  { "eengezinswoning-in-friesland-kopen.nl", true },
  { "eengezinswoning-in-leeuwarden-kopen.nl", true },
  { "eengezinswoning-in-rijnwaarden-kopen.nl", true },
  { "eengezinswoning-in-sudwest-fryslan-kopen.nl", true },
  { "eengezinswoning-in-zeeland-kopen.nl", true },
  { "eengezinswoning-in-zuid-holland-kopen.nl", true },
  { "eengezinswoning-in-zuidplas-kopen.nl", true },
  { "eengezinswoning-in-zwartewaterland-kopen.nl", true },
  { "eengezinswoningverkopen.nl", true },
  { "eenhoorn.ga", true },
  { "eeqj.com", true },
  { "eery.de", true },
  { "eewna.org", false },
  { "ef.gy", true },
  { "eff.org", true },
  { "effectiveosgi.com", true },
  { "effex.ru", true },
  { "eganassociates.com.au", true },
  { "egb.at", true },
  { "egbert.net", true },
  { "egfl.org.uk", true },
  { "egge.com", true },
  { "eggplant.today", true },
  { "egit.co", true },
  { "ego4u.com", true },
  { "ego4u.de", true },
  { "egoroof.ru", true },
  { "egretail.no", true },
  { "egumenita.ro", true },
  { "egw-ceramica.de", true },
  { "ehealthcounselor.com", true },
  { "ehipaa.com", true },
  { "ehipaadev.com", true },
  { "ehito.ovh", true },
  { "ehomusicgear.com", true },
  { "ehrenamt-skpfcw.de", true },
  { "ehrlichesbier.de", true },
  { "ehuber.info", true },
  { "eichornenterprises.com", true },
  { "eickemeyer.nl", true },
  { "eighty-aid.com", true },
  { "eimacs.com", true },
  { "eimanavicius.lt", true },
  { "einaros.is", true },
  { "einfachmaldiefressehalten.de", true },
  { "einheizpreis.de", true },
  { "einsatzstellenverwaltung.de", true },
  { "eintageinzug.de", true },
  { "eirastudios.co.uk", false },
  { "eisp.it", false },
  { "eit-web.de", false },
  { "eitler.cx", true },
  { "eiyoushi-shigoto.com", true },
  { "ejeff.org", true },
  { "ekbanden.nl", false },
  { "ekedc.com", true },
  { "ekodevices.com", true },
  { "ekokontakt.cz", true },
  { "ekostecki.de", true },
  { "eksik.com", true },
  { "eksisozluk.com", true },
  { "ekzarta.ru", true },
  { "el-cell.com", true },
  { "el-soul.com", true },
  { "elanguest.pl", true },
  { "elaon.de", true },
  { "elars.de", true },
  { "elastic7.uk", false },
  { "elaxy-online.de", true },
  { "elbetech.net", true },
  { "elblein.de", true },
  { "eldinhadzic.com", true },
  { "elearningpilot.com", true },
  { "electricant.com", true },
  { "electricant.nl", true },
  { "electricoperaduo.com", true },
  { "electronic-ignition-system.com", true },
  { "electronicfasteners.com", true },
  { "elefantevoador.com", true },
  { "eleicoes2016.com.br", true },
  { "elektro-koehl.de", true },
  { "elektronring.com", true },
  { "elektropost.org", true },
  { "element-43.com", true },
  { "elemental.software", true },
  { "elementalrobotics.com", true },
  { "elemprendedor.com.ve", true },
  { "elena-baykova.ru", true },
  { "elenag.ga", true },
  { "elenagherta.ga", true },
  { "elenorsmadness.org", true },
  { "elephpant.cz", true },
  { "elglobo.com.mx", true },
  { "elgosblanc.com", true },
  { "eligible.com", true },
  { "eligibleapi.com", true },
  { "eligrey.com", true },
  { "eliolita.com", true },
  { "eliott.be", false },
  { "elisa.ee", false },
  { "elisabeth-kostecki.de", true },
  { "elisabeth-strunz.de", true },
  { "elisabethkostecki.de", true },
  { "elite-porno.ru", true },
  { "elite12.de", true },
  { "elitefishtank.com", false },
  { "elitegameservers.net", true },
  { "elitehosting.de", true },
  { "elizabethgreenfield.com", true },
  { "ella-kwikmed.com", false },
  { "ellegaard.dk", true },
  { "elliotgluck.com", true },
  { "elliquiy.com", true },
  { "elliriehl.at", true },
  { "ellsinger.me", true },
  { "elmar-kraamzorg.nl", true },
  { "elmermx.ch", true },
  { "elnan.do", true },
  { "eloge.se", true },
  { "elohna.ch", true },
  { "elonbase.com", true },
  { "elpado.de", true },
  { "elpo.net", true },
  { "elsamakhin.com", true },
  { "elsemanario.com", true },
  { "eltagroup.co.uk", true },
  { "elternforum-birmensdorf.ch", true },
  { "eluhome.de", true },
  { "elvidence.com.au", true },
  { "em-biotek.cz", true },
  { "email2rss.net", true },
  { "emailfuermich.de", true },
  { "emailhunter.co", true },
  { "emailprivacytester.com", true },
  { "emaily.eu", true },
  { "emanatepixels.com", true },
  { "emanuelduss.ch", true },
  { "emavok.eu", true },
  { "embellir-kyujin.com", true },
  { "embracethedarkness.co.uk", true },
  { "embroideryexpress.co.uk", true },
  { "emero.de", true },
  { "emesolutions.net", true },
  { "emi-air-comprime.com", true },
  { "emielraaijmakers.nl", true },
  { "emilong.com", true },
  { "emilstahl.dk", true },
  { "emilvarga.com", true },
  { "emilyhorsman.com", true },
  { "emilyshepherd.me", true },
  { "eminovic.me", false },
  { "emirabiz.com", false },
  { "emjimadhu.com", true },
  { "emkanrecords.com", true },
  { "emkei.cz", true },
  { "emmable.com", true },
  { "empathy.ca", true },
  { "empleosentorreon.mx", true },
  { "empowerdb.com", true },
  { "emprego.pt", true },
  { "emptypath.com", true },
  { "emrenovation.com", true },
  { "emyr.net", true },
  { "en-booster.jp", true },
  { "en-maktoob.search.yahoo.com", false },
  { "enaah.de", true },
  { "enaia.fr", true },
  { "enaim.de", true },
  { "encfs.win", true },
  { "encircleapp.com", true },
  { "encnet.de", true },
  { "encode.uk.com", true },
  { "encoder.pw", true },
  { "encredible.de", false },
  { "encredible.org", false },
  { "encryptallthethings.net", true },
  { "encrypted.google.com", true },
  { "encryptedaudience.com", true },
  { "encryptio.com", true },
  { "end.pp.ua", true },
  { "endeal.nl", true },
  { "ender.co.at", true },
  { "endlessdiy.ca", true },
  { "endlesshorizon.net", true },
  { "endlessvideo.com", true },
  { "endofnet.org", true },
  { "endohaus.ca", true },
  { "endohaus.com", true },
  { "endohaus.eu", true },
  { "endohaus.us", true },
  { "endzeit-architekten.com", false },
  { "enecoshop.nl", true },
  { "enefan.jp", true },
  { "energiekeurplus.nl", true },
  { "energy-drink-magazin.de", true },
  { "energy-infra.nl", true },
  { "energy.eu", true },
  { "energyatlas.com", true },
  { "energyaupair.se", true },
  { "energydrinkblog.de", true },
  { "enersec.co.uk", true },
  { "enfoqueseguro.com", true },
  { "engaugetools.com", true },
  { "engelundlicht.ch", true },
  { "engg.ca", true },
  { "engineeryourmarketing.com", false },
  { "engineowning.com", true },
  { "enginepit.com", true },
  { "enginx.net", true },
  { "englerts.de", true },
  { "englishbulgaria.net", true },
  { "englishclub.com", true },
  { "englishforums.com", true },
  { "enjen.net", true },
  { "enlatte.com", true },
  { "enlightened.si", true },
  { "enlightenedhr.com", true },
  { "enlightenment.org", true },
  { "enloestatebank.com", true },
  { "ennori.jp", true },
  { "enorekcah.com", true },
  { "enot32.ru", true },
  { "enquos.com", true },
  { "enriquepiraces.com", true },
  { "enscosupply.com", true },
  { "ensemble-rubato.de", true },
  { "enskat.de", true },
  { "enskatson-sippe.de", true },
  { "ensured.com", true },
  { "ensured.nl", true },
  { "entabe.jp", true },
  { "entactogens.com", true },
  { "enteente.club", true },
  { "enteente.com", true },
  { "enteente.space", true },
  { "enteente.xyz", true },
  { "enterprisecarclub.co.uk", true },
  { "enterprisey.enterprises", true },
  { "entersynapse.com", false },
  { "entheogens.com", true },
  { "entourneebeetle.com", true },
  { "entrainr.com", true },
  { "entropia.de", false },
  { "enuchi.jp", true },
  { "enum.eu.org", true },
  { "enumify.com", true },
  { "envelope.co.nz", true },
  { "enveloppenopmaat.nl", true },
  { "enviam.de", true },
  { "eoldb.org", true },
  { "eopugetsound.org", false },
  { "epanurse.com", true },
  { "epay.bg", true },
  { "epaygateway.net", true },
  { "ephry.com", true },
  { "epicenter.work", true },
  { "epicenter.works", true },
  { "epicentre.works", true },
  { "epichouse.net", true },
  { "epicpages.com", true },
  { "epicsecure.de", true },
  { "epicsoft.de", true },
  { "epicwalnutcreek.com", true },
  { "epizentrum.work", true },
  { "epizentrum.works", true },
  { "epoch.com", true },
  { "epostplus.li", true },
  { "epsilon.dk", true },
  { "epublibre.org", true },
  { "eq-serve.com", true },
  { "eqim.me", true },
  { "eqorg.com", true },
  { "equalparts.eu", true },
  { "equidam.com", true },
  { "equilibre-yoga-jennifer-will.com", true },
  { "equipsupply.com", true },
  { "equitee.co", true },
  { "erdethamburgeronsdag.no", true },
  { "erepublik-deutschland.de", true },
  { "ergo-open.de", true },
  { "ericabrahamsen.net", true },
  { "ericairwin.com", true },
  { "ericbond.net", true },
  { "ericdiao.com", true },
  { "erichalv.com", true },
  { "erichorstmanshof.nl", true },
  { "ericisaweso.me", true },
  { "erick.blog", true },
  { "ericleuthardt.com", true },
  { "erico.jp", true },
  { "ericoc.com", true },
  { "ericwie.se", true },
  { "ericyl.com", true },
  { "eridanus.uk", true },
  { "erigrid.eu", true },
  { "eriix.org", true },
  { "erikhubers.nl", true },
  { "erikseth.de", true },
  { "eriner.me", true },
  { "erisrenee.com", true },
  { "ernaehrungsberatung-rapperswil.ch", true },
  { "ernaehrungsberatung-zurich.ch", true },
  { "ernest.ly", true },
  { "ernesto.at", true },
  { "erp-band.ru", true },
  { "erp.band", true },
  { "erpband.ru", true },
  { "erpcargo.com", false },
  { "errlytics.com", true },
  { "errolz.com", true },
  { "errors.zenpayroll.com", false },
  { "erstehilfeprodukte.at", true },
  { "eru.me", true },
  { "erudikum.cz", true },
  { "erwanlepape.com", true },
  { "erwinwensveen.nl", true },
  { "erythroxylum-coca.com", true },
  { "es-geenen.de", true },
  { "es.search.yahoo.com", false },
  { "esample.info", true },
  { "escalate.eu", true },
  { "escapees.com", true },
  { "escapeplaza.de", true },
  { "escargotbistro.com", true },
  { "esclear.de", true },
  { "escolaengenharia.com.br", true },
  { "escritoriodearte.com", false },
  { "escyr.top", true },
  { "eseth.de", true },
  { "esg-abi2001.de", true },
  { "eshtapay.com", true },
  { "esigmbh.de", true },
  { "esko.bar", true },
  { "eskriett.com", true },
  { "esn-ypci.com", true },
  { "esoa.net", true },
  { "esocweb.com", true },
  { "esoko.eu", true },
  { "esono.de", true },
  { "esp8285.store", true },
  { "espace-gestion.fr", true },
  { "espacemontmorency.com", true },
  { "espacetheosophie.fr", true },
  { "espanol.search.yahoo.com", false },
  { "espanova.com", true },
  { "espci.fr", true },
  { "especificosba.com.ar", true },
  { "especificosba.com.mx", true },
  { "espgg.org", true },
  { "espra.com", true },
  { "esquonic.com", true },
  { "ess-cert.ru", true },
  { "essentialoilsimports.com", true },
  { "esseriumani.com", true },
  { "essite.net", true },
  { "essoduke.org", true },
  { "estaciona.guru", true },
  { "estaleiro.org", true },
  { "estan.cn", true },
  { "estateczech-eu.ru", true },
  { "estcequonmetenprodaujourdhui.info", true },
  { "esteam.se", true },
  { "estebanborges.com", true },
  { "estilosapeca.com", true },
  { "estoic.net", true },
  { "estonoentraenelexamen.com", true },
  { "estrietoit.com", false },
  { "et-buchholz.de", true },
  { "et180.com", true },
  { "etaes.eu", true },
  { "etaoinwu.tk", true },
  { "etath.com", true },
  { "etaxi.tn", true },
  { "eteesheet.com", true },
  { "etelej.com", false },
  { "eternitylove.us", true },
  { "eth0.nl", true },
  { "etha.nz", true },
  { "ethack.org", true },
  { "ethan.pm", true },
  { "ethanfaust.com", true },
  { "ethanlew.is", true },
  { "ethercalc.com", true },
  { "ethercalc.org", true },
  { "etheria-software.tk", true },
  { "etherpad.fr", true },
  { "ethicaldata.co.uk", true },
  { "ethicalexploiting.com", true },
  { "ethicall.org.uk", true },
  { "ethil-faer.fr", true },
  { "ethiopian.dating", true },
  { "ethitter.com", true },
  { "ethlan.fr", true },
  { "ethosinfo.com", true },
  { "etidni.help", true },
  { "etkaddict.com", true },
  { "etmirror.top", true },
  { "etmirror.xyz", true },
  { "etproxy.tech", true },
  { "etrker.com", true },
  { "ets2mp.de", true },
  { "etula.ga", true },
  { "etv.cx", true },
  { "etyd.org", true },
  { "euclideanpostulates.xyz", true },
  { "eucollegetours.com", true },
  { "eugenekay.com", true },
  { "eulenleben.de", true },
  { "eulerpi.io", true },
  { "euph.eu", true },
  { "eupho.me", true },
  { "eureka.archi", true },
  { "eurekaarchi.com", true },
  { "eurekaarchitecture.com", true },
  { "euren.se", true },
  { "europapier.ba", true },
  { "europapier.com", true },
  { "europapier.cz", true },
  { "europapier.hr", true },
  { "europapier.hu", true },
  { "europapier.rs", true },
  { "europapier.si", true },
  { "europapier.sk", true },
  { "europapier.ua", true },
  { "europastudien.de", true },
  { "european-agency.org", true },
  { "europop.com", true },
  { "euroshop.or.at", true },
  { "eurostrategy.vn.ua", true },
  { "eurotramp.com", true },
  { "eurotravelstar.eu", true },
  { "ev-zertifikate.de", true },
  { "eva.cz", true },
  { "evalesc.com", true },
  { "evanhandgraaf.nl", true },
  { "evankurniawan.com", true },
  { "evantage.org", true },
  { "evantageglobal.com", true },
  { "evapp.org", true },
  { "evasion-energie.com", true },
  { "evasovova.cz", true },
  { "eve0s.com", true },
  { "evegalaxy.net", true },
  { "evelyndayman.com", false },
  { "eventaro.com", true },
  { "eventmake.es", true },
  { "events12.com", true },
  { "ever.sale", true },
  { "everhome.de", true },
  { "everling.lu", true },
  { "everpcpc.com", true },
  { "everwaking.com", false },
  { "everyarti.st", true },
  { "everylab.org", true },
  { "everymove.org", true },
  { "everything.place", true },
  { "everywhere.cloud", true },
  { "eveseat.net", true },
  { "eveshamglass.co.uk", true },
  { "evi.be", true },
  { "evilized.de", true },
  { "evilsay.com", true },
  { "evion.nl", true },
  { "evites.me", true },
  { "evlear.com", true },
  { "evodation.com", true },
  { "evoludis.net", true },
  { "evolutionexpeditions.com", true },
  { "evolutionlending.co.uk", true },
  { "evomon.com", true },
  { "evossd.tk", true },
  { "evowl.com", false },
  { "evrial.com", true },
  { "evstatus.com", true },
  { "ewe2.ninja", true },
  { "ewex.org", true },
  { "ewie.name", true },
  { "ewuchuan.com", true },
  { "ewycena.pl", true },
  { "exactlyinfinite.com", true },
  { "exactphilosophy.net", true },
  { "examenpilotos.com", true },
  { "exceptionalservers.com", true },
  { "excessamerica.com", true },
  { "exchangeworks.co", true },
  { "exehack.net", true },
  { "exekutori.com", true },
  { "exemples-de-stands.com", true },
  { "exeria.de", true },
  { "exgaywatch.com", true },
  { "exgravitus.com", true },
  { "exhalespa.com", true },
  { "exhibityour.com", true },
  { "exiahost.com", true },
  { "exno.co", true },
  { "exon.io", true },
  { "exoscale.ch", true },
  { "exoticads.com", true },
  { "exp.de", true },
  { "expancio.com", true },
  { "expatads.com", true },
  { "experienceoz.com.au", true },
  { "experteasy.com.au", true },
  { "experts-en-gestion.fr", true },
  { "explodie.org", true },
  { "exploit-db.com", true },
  { "exploit.cz", true },
  { "exploit.party", true },
  { "exploited.cz", true },
  { "expo-asia.ru", true },
  { "expo-designers.com", true },
  { "express-vpn.com", true },
  { "expressemotion.net", true },
  { "expresshosting.org", true },
  { "expressvpn.com", true },
  { "expxkcd.com", true },
  { "exs.lv", true },
  { "extendwings.com", true },
  { "extensiblewebmanifesto.org", true },
  { "extensiblewebreportcard.org", true },
  { "extensiblewebsummit.org", true },
  { "extranetpuc.com.br", true },
  { "extrapagetab.com", true },
  { "extratorrentlive.xyz", true },
  { "extratorrents.tech", true },
  { "extreme-gaming.de", true },
  { "extreme-gaming.us", true },
  { "extremenetworking.net", true },
  { "exy.pw", true },
  { "exyplis.com", true },
  { "eyasc.nl", true },
  { "eydesignguidelines.com", true },
  { "eye-carat.com", true },
  { "eyedarts.com", true },
  { "eyeonid.com", true },
  { "eynio.com", true },
  { "eytosh.net", true },
  { "eyyit.com", false },
  { "ez.fi", true },
  { "ezequiel-garzon.net", true },
  { "ezhik-din.ru", true },
  { "ezrefurb.co.uk", true },
  { "f-be.com", true },
  { "f-droid.org", true },
  { "f-s-u.co.uk", true },
  { "f-thie.de", true },
  { "f00.fr", true },
  { "f1bigpicture.com", true },
  { "f1minute.com", true },
  { "f2f.cash", true },
  { "fa-works.com", true },
  { "faber.org.ru", true },
  { "fabhub.io", true },
  { "fabian-koeppen.de", true },
  { "fabianasantiago.com", true },
  { "fabianfranke.de", true },
  { "fabienbaker.com", true },
  { "fabled.com", true },
  { "fableforge.nl", true },
  { "fabriziorocca.it", true },
  { "fabse.net", true },
  { "fabulouslyyouthfulskin.com", true },
  { "fabulouslyyouthfulskineyeserum.com", true },
  { "facebook-atom.appspot.com", true },
  { "facebook.ax", true },
  { "facebook.com", false },
  { "facerepo.com", true },
  { "fach-journalist.de", true },
  { "fachschaft-informatik.de", true },
  { "fachschaftslisten.org", true },
  { "facilitrak.com", true },
  { "factbytefactbox.com", true },
  { "factor.cc", false },
  { "factureenlinea.com", true },
  { "factuursturen.be", true },
  { "factuursturen.nl", true },
  { "factys.do", true },
  { "factys.es", true },
  { "fadednet.com", true },
  { "faeriecakes.be", true },
  { "fahrenwal.de", true },
  { "fahrenwalde.de", true },
  { "failproof.be", true },
  { "fairbill.com", true },
  { "faircom.co.za", true },
  { "faithwatch.org", true },
  { "fakturi.com", true },
  { "fakturoid.cz", true },
  { "falconfrag.com", true },
  { "falconvintners.com", true },
  { "fallenangeldrinks.co.uk", true },
  { "fallenangeldrinks.com", true },
  { "fallenangeldrinks.eu", true },
  { "fallenangelspirits.co.uk", true },
  { "fallenangelspirits.com", true },
  { "fallenangelspirits.uk", true },
  { "fallenspirits.co.uk", true },
  { "falsum.net", true },
  { "famdouma.nl", true },
  { "familie-kupschke.de", true },
  { "familie-monka.de", true },
  { "familie-sander.rocks", true },
  { "familie-sprink.de", true },
  { "familie-zimmermann.at", true },
  { "familiegrottendieck.de", true },
  { "familieholme.de", true },
  { "familjenfrodlund.se", true },
  { "familjenm.se", true },
  { "famvsomeren.nl", true },
  { "fanboi.ch", true },
  { "fancy-bridge.com", true },
  { "fandler.cz", true },
  { "fandomservices.com", true },
  { "fangs.ink", true },
  { "fanjoe.be", true },
  { "fant.dk", true },
  { "fantopia.club", true },
  { "fanvoice.com", true },
  { "fanyue123.tk", true },
  { "fanz.pro", true },
  { "fap.no", true },
  { "faq.ie", true },
  { "faq.lookout.com", false },
  { "fara.gov", true },
  { "faretravel.co.uk", true },
  { "farfetchos.com", true },
  { "fargtorget.se", true },
  { "farhood.org", true },
  { "farmacia.pt", true },
  { "farmacialaboratorio.it", true },
  { "farmer.dating", true },
  { "farmkazuto.com", true },
  { "fasdoutreach.ca", true },
  { "fashion.net", true },
  { "fashionholic.my", true },
  { "fashionunited.cl", true },
  { "fashionunited.com", true },
  { "fashionunited.com.ar", true },
  { "fashionunited.hk", true },
  { "fashionunited.hu", true },
  { "fashionunited.ie", true },
  { "fashionunited.mx", true },
  { "fashionunited.nz", true },
  { "fashionunited.se", true },
  { "faspirits.co.uk", true },
  { "faspirits.com", true },
  { "fassadenverkleidung24.de", true },
  { "fasset.jp", true },
  { "fastaim.de", true },
  { "fastcomcorp.com", true },
  { "fastcomcorp.net", true },
  { "fastconfirm.com", true },
  { "fastdigitizing.com", true },
  { "fastmail.com", false },
  { "fastograph.com", true },
  { "fastopen.ml", true },
  { "fatlossguide.xyz", true },
  { "fatox.de", true },
  { "fatwin.pw", true },
  { "fatzebra.com.au", false },
  { "faucetbox.com", true },
  { "favorit.club", true },
  { "fawkex.me", true },
  { "fawong.com", true },
  { "faxreader.net", true },
  { "fayolle.info", true },
  { "fbijobs.gov", true },
  { "fbox.li", true },
  { "fca-tools.com", true },
  { "fcburk.de", true },
  { "fdj.im", true },
  { "fdsys.gov", false },
  { "fdt.name", true },
  { "feaden.me", true },
  { "fearsomegaming.com", true },
  { "fecik.sk", true },
  { "federaljobs.gov", true },
  { "federalregister.gov", false },
  { "federicomigliavacca.it", true },
  { "fedjobs.gov", true },
  { "fedorahosted.org", true },
  { "fedoramagazine.org", true },
  { "fedorapeople.org", true },
  { "fedramp.gov", false },
  { "fedrtc.org", true },
  { "fedux.com.ar", true },
  { "feedbin.com", false },
  { "feedhq.org", true },
  { "feedkovacs.hu", true },
  { "feedthebot.com", true },
  { "feedthefuture.gov", true },
  { "feel.aero", true },
  { "feen.us", true },
  { "fehngarten.de", true },
  { "fehnladen.de", true },
  { "feirlane.org", false },
  { "feistyduck.com", true },
  { "feld.saarland", true },
  { "felisslovakia.sk", true },
  { "felixhefner.de", true },
  { "felixklein.at", false },
  { "felixrr.pro", true },
  { "felixsanz.com", true },
  { "felixseele.de", true },
  { "feminists.co", true },
  { "fenno.net", true },
  { "fenster-bank.at", true },
  { "fenster-bank.de", true },
  { "fenteo.com", true },
  { "feriahuamantla.com", true },
  { "ferien-netzwerk.de", true },
  { "ferienhaus-polchow-ruegen.de", false },
  { "fernandes.org", true },
  { "fernandob.com", true },
  { "fernandobarillas.com", true },
  { "fernseher-kauf.de", true },
  { "ferrolatino.ch", true },
  { "ferrolatino.com", true },
  { "ferrugem.org", true },
  { "festivaljapon.com", true },
  { "festivalxdentro.com", true },
  { "festrip.com", true },
  { "fetch.co.uk", true },
  { "feudalisten.de", true },
  { "feuerwehr-illmensee.de", true },
  { "feuerwehr-oberkotzau.de", true },
  { "feuerwerksmanufaktur.de", true },
  { "fewo-thueringer-wald.de", true },
  { "fexco.com", true },
  { "feyermedia.de", true },
  { "ff-bad-hoehenstadt.de", true },
  { "ff-obersunzing-niedersunzing.de", true },
  { "ffbans.org", true },
  { "ffis.me", true },
  { "fhcdn.xyz", true },
  { "fhfaoig.gov", true },
  { "fi-sanki.co.jp", true },
  { "fi.google.com", true },
  { "fi.search.yahoo.com", false },
  { "ficlab.com", true },
  { "fics-twosigma.com", true },
  { "ficus.io", true },
  { "fid.to", true },
  { "fidanza.eu", true },
  { "fidel.uk", true },
  { "fidelapp.com", true },
  { "fieldclockapp.com", true },
  { "fiendishmasterplan.com", true },
  { "fierlafijn.net", true },
  { "fierman.eu", false },
  { "fierman.net", false },
  { "fierman.us", false },
  { "fifieldtech.com", true },
  { "fiftyshadesofluca.ml", true },
  { "fightr.co", true },
  { "figurasdelinguagem.com.br", true },
  { "figuurzagers.nl", false },
  { "fiilr.com", true },
  { "fiix.io", true },
  { "fiken.no", true },
  { "fiksel.info", true },
  { "fikt.space", true },
  { "file-pdf.it", true },
  { "filedir.com", false },
  { "filemeal.com", true },
  { "filesense.com", true },
  { "filestar.io", true },
  { "filhodohomem.com", true },
  { "filip-prochazka.com", true },
  { "filippo.io", true },
  { "fillmysuitca.se", true },
  { "film.photos", true },
  { "filmatiporno.xxx", true },
  { "filoo.de", true },
  { "financier.io", true },
  { "finanzkontor.net", true },
  { "findigo.fish", true },
  { "findingmyname.com", true },
  { "finditez.com", true },
  { "findmybottleshop.com.au", true },
  { "findyour.diet", true },
  { "findyourvoice.ca", true },
  { "finenet.com.tw", true },
  { "finfev.de", true },
  { "fingent.com", true },
  { "finisron.in", true },
  { "finkelstein.fr", true },
  { "finkenberger.org", true },
  { "finn.io", true },
  { "finneas.net", true },
  { "finpt.com", true },
  { "finstererlebnis.de", true },
  { "finsterlebnis.de", true },
  { "fionamcbride.com", true },
  { "firebaseio-demo.com", true },
  { "firebaseio.com", true },
  { "firebird.io", true },
  { "firebirdrangecookers.com", true },
  { "firebounty.com", true },
  { "firecore.com", false },
  { "firefart.at", false },
  { "firefighters.dating", true },
  { "firehost.com", true },
  { "firemail.io", true },
  { "firesofheaven.org", true },
  { "firevap.org", true },
  { "firewallconsultants.com", true },
  { "firexarxa.de", true },
  { "firma-offshore.com", true },
  { "firmale.com", true },
  { "firmapi.com", true },
  { "first-time-offender.com", true },
  { "firstchoicecandy.com", true },
  { "firstderm.com", true },
  { "firstlook.org", true },
  { "firstmall.de", true },
  { "fischer-its.com", false },
  { "fischers.cc", true },
  { "fish-hook.ru", true },
  { "fishlinemedia.com", true },
  { "fistu.la", true },
  { "fit365.jp", true },
  { "fitkram.cz", true },
  { "fitness.gov", true },
  { "fitnesswerk.de", true },
  { "fitsw.com", true },
  { "fittelo.cz", true },
  { "fitzsim.org", true },
  { "fiws.net", true },
  { "fix-the-timeline.com", true },
  { "fix-the-timeline.org", true },
  { "fixate.ru", true },
  { "fixel.express", true },
  { "fixforce.nl", true },
  { "fixhotsauce.com", true },
  { "fixmycomputerdude.com", true },
  { "fixthetimeline.com", true },
  { "fixthetimeline.org", true },
  { "fizz.buzz", true },
  { "fj.simple.com", false },
  { "flaemig42.de", true },
  { "flagburningworld.com", true },
  { "flagspot.net", true },
  { "flajshans.cz", true },
  { "flam.io", true },
  { "flamer-scene.com", false },
  { "flamewall.net", false },
  { "flamingcow.tv", true },
  { "flamingkeys.com", true },
  { "flamingkeys.com.au", true },
  { "flamme-von-anor.de", true },
  { "flana.com", true },
  { "flareon.net", true },
  { "flashback.org", true },
  { "flat.io", true },
  { "flauschig.net", true },
  { "flawlesscowboy.xyz", true },
  { "flazznetworks.com", false },
  { "fleep.io", true },
  { "fleisch.club", true },
  { "fletchto99.com", true },
  { "flexapplications.se", true },
  { "fleximus.org", false },
  { "flexinvesting.fi", true },
  { "flexport.com", true },
  { "flexstart.me", true },
  { "flightschoolbooking.com", true },
  { "flightschoolcandidates.gov", true },
  { "fling.dating", true },
  { "flipagram.com", false },
  { "flipkey.com", true },
  { "flipneus.net", true },
  { "flixtor.net", true },
  { "floaternet.com", true },
  { "flocktofedora.org", true },
  { "floobits.com", true },
  { "floorball-haunwoehr.de", true },
  { "flooringnightmares.com", true },
  { "floort.net", false },
  { "florence.uk.net", true },
  { "florent-tatard.fr", true },
  { "florian-bachelet.fr", true },
  { "florian-schlachter.de", true },
  { "florian-thie.de", true },
  { "floriankeller.de", true },
  { "florianmitrea.uk", true },
  { "florida-prep.org", true },
  { "floridafieros.org", true },
  { "florismoo.nl", true },
  { "florismouwen.com", true },
  { "florispoort.nl", true },
  { "florisvdk.net", true },
  { "floseed.fr", true },
  { "floskelwolke.de", true },
  { "floth.at", true },
  { "flouartistique.ch", true },
  { "flow.pe", true },
  { "flow.su", true },
  { "flowersandclouds.com", true },
  { "floweslawncare.com", true },
  { "flowlo.me", true },
  { "flox.io", true },
  { "flra.gov", true },
  { "flucky.xyz", true },
  { "fluffycloud.de", true },
  { "fluidojobs.com", true },
  { "flukethoughts.com", true },
  { "flurrybridge.com", true },
  { "fluxent.de", false },
  { "fluxfingers.net", true },
  { "fluxforge.com", true },
  { "fluxoid.com", true },
  { "fly.moe", true },
  { "flyawayantennas.com", true },
  { "flymns.fr", true },
  { "flynn.io", true },
  { "flyserver.co.il", true },
  { "flyss.net", true },
  { "fm.ie", true },
  { "fmarchal.fr", true },
  { "fnb-griffinonline.com", true },
  { "fniephaus.com", true },
  { "fnordserver.eu", true },
  { "fnvsecurity.com", true },
  { "fnzc.co.nz", true },
  { "fobc-usa.org", true },
  { "focalforest.com", true },
  { "focanamoda.com.br", true },
  { "focusmark.jp", false },
  { "foej-aktiv.de", true },
  { "foia.gov", true },
  { "fokkusu.fi", true },
  { "folioapp.io", true },
  { "followthatpage.com", true },
  { "folv.es", true },
  { "fondanastasia.ru", true },
  { "fondy.eu", true },
  { "fonga.ch", true },
  { "font-converter.net", true },
  { "fontein.de", true },
  { "fontlibrary.org", true },
  { "foo.fo", true },
  { "foo.hamburg", true },
  { "food4health.guide", true },
  { "foodacademy.capetown", true },
  { "foodblogger.club", true },
  { "foodiebox.no", true },
  { "foodies.my", true },
  { "foodievenues.com", true },
  { "foodplantengineering.com", true },
  { "foodsafety.gov", true },
  { "foodwise.marketing", true },
  { "fooishbar.org", false },
  { "foolip.org", true },
  { "foolwealth.com", true },
  { "foorack.com", true },
  { "fooster.io", true },
  { "footballmapped.com", true },
  { "footlegende.fr", true },
  { "forafifty.co.za", true },
  { "foray-jero.me", true },
  { "forbook.net", true },
  { "forcewave.com", true },
  { "fordbydesign.com", true },
  { "foreveralone.io", true },
  { "forewordreviews.com", true },
  { "forex.ee", true },
  { "forextimes.ru", true },
  { "forgix.com", true },
  { "formationseeker.com", true },
  { "formationsfactory.co.uk", false },
  { "formbetter.com", true },
  { "formini.dz", true },
  { "formula.cf", true },
  { "foro.io", false },
  { "forodeespanol.com", true },
  { "forplanetsake.com", true },
  { "forsakringsarkivet.se", true },
  { "forschbach-janssen.de", true },
  { "forstbetrieb-hennecke.de", true },
  { "fortesanshop.it", true },
  { "fortnine.ca", true },
  { "fortress.sk", true },
  { "fortuna-loessnitz.de", true },
  { "fortuna-s.com", true },
  { "fortworth.ch", true },
  { "forum.linode.com", false },
  { "forus.be", true },
  { "fossewayflowers.co.uk", true },
  { "fossewayflowers.com", true },
  { "fossewaygardencentre.co.uk", true },
  { "fossilfreeyale.org", true },
  { "fotella.com", true },
  { "foto-janvanaefst.nl", true },
  { "foto.by", true },
  { "foto4.cz", true },
  { "fotoallerlei.com", true },
  { "fotocerita.net", false },
  { "fotofaerie.net", true },
  { "fotogiraffe.ru", true },
  { "fotografiadellalucerossa.com", true },
  { "fotopasja.info", true },
  { "fotostudio-schweiz.ch", true },
  { "fotowettbewerb.co", true },
  { "fotowolfy.com", true },
  { "foundsounds.me", true },
  { "foxbnc.co.uk", true },
  { "foxdev.co", true },
  { "foxhound.com.br", true },
  { "foxleyseeds.co.uk", true },
  { "foxontheinter.net", true },
  { "foxterrier.com.br", true },
  { "foxtrot.pw", true },
  { "fpc.gov", false },
  { "fpy.cz", true },
  { "fr.search.yahoo.com", false },
  { "fr33d0m.link", true },
  { "frack.nl", true },
  { "fraesentest.de", true },
  { "fragmentspuren.de", true },
  { "fragnic.com", true },
  { "fraho.eu", true },
  { "fralef.me", false },
  { "fran.cr", true },
  { "francescopalazzo.com", true },
  { "francevpn.xyz", true },
  { "francisli.net", true },
  { "franckgirard.net", true },
  { "francoz.me", true },
  { "frank.fyi", true },
  { "franke-chemie.de", true },
  { "franken-lehrmittel.de", true },
  { "frankhaala.com", true },
  { "frankierprofi.de", true },
  { "frankl.in", true },
  { "fransallen.com", true },
  { "frantic1048.com", true },
  { "franzt.de", true },
  { "franzt.ovh", true },
  { "frappant.cc", true },
  { "frasesparaface.com.br", true },
  { "frasys.cloud", true },
  { "frasys.net", true },
  { "fraudempire.com", true },
  { "fraurichter.net", true },
  { "fraye.net", true },
  { "frbracch.it", true },
  { "frdl.ch", true },
  { "frederik-braun.com", true },
  { "frederikschoell.de", false },
  { "fredloya.com", true },
  { "free-your-pc.com", true },
  { "free.com.tw", true },
  { "freeben666.fr", true },
  { "freeboson.org", true },
  { "freebus.org", true },
  { "freecloud.at", true },
  { "freedom.press", true },
  { "freedomrealtyoftexas.com", true },
  { "freeflow.tv", true },
  { "freeform4u.de", true },
  { "freejasongoudlock.org", true },
  { "freekdevries.nl", true },
  { "freelance.boutique", true },
  { "freelance.nl", true },
  { "freelanced.co.za", true },
  { "freelancehunt.com", true },
  { "freemanning.de", true },
  { "freemyipod.org", true },
  { "freenetproject.org", true },
  { "freeshell.de", true },
  { "freesitemapgenerator.com", true },
  { "freesounding.com", true },
  { "freesounding.ru", true },
  { "freethetv.ie", true },
  { "freethought.org.au", true },
  { "freetsa.org", true },
  { "freevps.us", true },
  { "freeweibo.com", true },
  { "freezion.com", true },
  { "freifunk-essen.de", true },
  { "freifunk-luenen.de", true },
  { "freiwurst.net", true },
  { "frenzel.dk", true },
  { "freqlabs.com", true },
  { "fresh-hotel.org", true },
  { "fresh.co.il", true },
  { "freshempire.gov", true },
  { "fretscha.com", true },
  { "fretworksec.com", true },
  { "frezbo.com", true },
  { "frickelboxx.de", true },
  { "frickenate.com", true },
  { "fridolinka.cz", true },
  { "friedhelm-wolf.de", true },
  { "friendica.ch", true },
  { "friendlyfiregameshow.com", true },
  { "friends-of-naz.com", true },
  { "friends24.cz", true },
  { "friet.org", true },
  { "frillip.com", true },
  { "frippz.se", true },
  { "fritzrepair.com", true },
  { "frly.de", true },
  { "frob.nl", true },
  { "frogatto.com", true },
  { "frogeye.fr", true },
  { "froh.co.jp", true },
  { "frokenblomma.se", true },
  { "frolov.net", true },
  { "frolova.org", true },
  { "fromix.de", true },
  { "fromlemaytoz.com", true },
  { "fromscratch.rocks", true },
  { "fronteers.nl", false },
  { "frontisme.nl", true },
  { "froot.se", true },
  { "frost-ci.xyz", true },
  { "frostbytes.net", true },
  { "frostwarning.com", true },
  { "frosty-gaming.xyz", true },
  { "frothy.coffee", true },
  { "frowin-stemmer.de", true },
  { "froxlor.support", true },
  { "frtn.com", true },
  { "frtr.gov", true },
  { "fruchthof24.de", true },
  { "frugro.be", true },
  { "fruitusers.com", true },
  { "fs-gamenet.de", true },
  { "fsapubs.gov", true },
  { "fsbpaintrock.com", true },
  { "fsbturton.com", true },
  { "fsf.moe", true },
  { "fsfi.is", true },
  { "fsinf.at", true },
  { "fsm2016.org", true },
  { "fspphoto.com", true },
  { "ftc.gov", false },
  { "ftccomplaintassistant.gov", true },
  { "fteproxy.org", true },
  { "ftrsecure.com", true },
  { "fuckav.ru", true },
  { "fuckgfw233.org", true },
  { "fuechschen.org", true },
  { "fugle.de", true },
  { "fuglede.dk", true },
  { "fukuko.biz", true },
  { "fukuko.xyz", true },
  { "fullbundle.com", true },
  { "fullyint.com", true },
  { "fumblers.ca", true },
  { "fumiware.com", true },
  { "fumo.se", true },
  { "fun-stamps.de", true },
  { "fun-stempel.de", true },
  { "funchestra.at", false },
  { "functions-online.com", true },
  { "fundacionhijosdelsol.org", true },
  { "fundays.nl", true },
  { "funderburg.me", true },
  { "fundingempire.com", true },
  { "funi4u.com", true },
  { "funktionel.co", true },
  { "funny-stamps.de", true },
  { "funnyang.com", true },
  { "funnystamps.de", true },
  { "funstamps.de", true },
  { "funstempel.de", true },
  { "funtime.kiev.ua", false },
  { "furgo.love", true },
  { "furkancaliskan.com", true },
  { "furnation.com", true },
  { "furnitureconcept.co.uk", true },
  { "furry.dk", true },
  { "fusedrops.com", true },
  { "fuseos.net", true },
  { "fushee.com", true },
  { "fusionmate.com", true },
  { "futos.de", true },
  { "futurefundapp.com", true },
  { "futurenda.com", true },
  { "futuresonline.com", true },
  { "futurestarsusa.org", true },
  { "fuvpn.com", true },
  { "fuwafuwa.moe", true },
  { "fuxwerk.de", true },
  { "fuyu.moe", true },
  { "fuzoku-sodan.com", true },
  { "fuzzing-project.org", true },
  { "fveevaete.com", true },
  { "fwei.tk", true },
  { "fws.gov", true },
  { "fwww7.com", true },
  { "fx5.de", true },
  { "fxopen.co.uk", true },
  { "fxopen.com", true },
  { "fxopen.com.au", true },
  { "fxopen.com.br", true },
  { "fxopen.com.mx", true },
  { "fxopen.ru", true },
  { "fxp.co.il", true },
  { "fxpig-ib.com", true },
  { "fxtalk.cn", true },
  { "fyfywka.com", true },
  { "fyn.nl", true },
  { "fyrkat.no", true },
  { "fzn.io", true },
  { "g-m-w.eu", true },
  { "g-marketing.ro", true },
  { "g-o.pl", true },
  { "g01.in.ua", true },
  { "g2links.com", true },
  { "g2pla.net", true },
  { "g2soft.net", true },
  { "g3rv4.com", true },
  { "g4w.co", true },
  { "g5led.nl", true },
  { "gabber.scot", true },
  { "gabi.com.es", true },
  { "gabi.soy", true },
  { "gabi.uno", true },
  { "gablaxian.com", true },
  { "gabriele-kluge.de", true },
  { "gaestehaus-monika.com", true },
  { "gafachi.com", true },
  { "gagniard.org", true },
  { "gagor.pl", true },
  { "gagstempel.de", true },
  { "gaichon.com", true },
  { "gaiserik.com", false },
  { "gaite.me", true },
  { "gakkainavi-epsilon.jp", true },
  { "gakkainavi-epsilon.net", true },
  { "gakkainavi.net", true },
  { "gakkainavi4.com", true },
  { "gakkainavi4.jp", true },
  { "galactic-crew.org", true },
  { "galena.io", true },
  { "galgoafegao.com.br", true },
  { "galgoingles.com.br", true },
  { "galgopersa.com.br", true },
  { "galletasgabi.com.mx", true },
  { "galoisvpn.xyz", true },
  { "gam3rs.de", true },
  { "gamajo.com", true },
  { "gamberorosso.menu", true },
  { "gambetti.fr", true },
  { "gambit.pro", true },
  { "gambitcloud.net", true },
  { "gambitnash.co.uk", true },
  { "gambitnash.com", true },
  { "gambitprint.com", true },
  { "game-gentle.com", true },
  { "game.yt", true },
  { "game7.de", true },
  { "gamecard-shop.nl", true },
  { "gamechasm.com", true },
  { "gameclue.jp", true },
  { "gamecollector.be", true },
  { "gamedevelopers.pl", true },
  { "gamegix.com", true },
  { "gameguardian.net", true },
  { "gamehacks.me", true },
  { "gameisbest.jp", true },
  { "gamek.es", true },
  { "gamenected.com", true },
  { "gamenected.de", true },
  { "gameofbay.org", true },
  { "gamepad.com.br", true },
  { "gamepad.vg", true },
  { "gamepader.com", true },
  { "gameparade.de", true },
  { "gamepiece.com", true },
  { "gamercredo.com", true },
  { "gamercredo.net", true },
  { "gamers-life.fr", true },
  { "gameserver-sponsor.de", true },
  { "gamesurferapp.com", true },
  { "gametium.com", true },
  { "gametium.es", true },
  { "gamingexodus.com", true },
  { "gamingreinvented.com", true },
  { "gamingwithcromulent.com", true },
  { "gamingzoneservers.com", true },
  { "gamishou.fr", true },
  { "gamoloco.com", true },
  { "gancedo.com.es", true },
  { "ganhonet.com.br", true },
  { "gapdirect.com", true },
  { "gar-nich.net", true },
  { "garagegoossens.be", true },
  { "garagemhermetica.org", true },
  { "garageon.net", true },
  { "garantieabschluss.de", false },
  { "garbage-juice.com", true },
  { "garciamartin.me", true },
  { "garden-life.org", true },
  { "garden.trade", true },
  { "garderobche.eu", true },
  { "garedtech.com", true },
  { "garron.net", true },
  { "gartenplanung-brendes.de", true },
  { "garyjones.co.uk", true },
  { "garystallman.com", true },
  { "gasbarkenora.com", true },
  { "gasnews.net", true },
  { "gasser-daniel.ch", false },
  { "gatapro.net", true },
  { "gateworld.fr", true },
  { "gaussorgues.me", true },
  { "gautvedt.no", true },
  { "gavick.com", false },
  { "gaytorrent.ru", true },
  { "gazee.net", true },
  { "gbcsummercamps.com", true },
  { "gc-mc.de", true },
  { "gc.net", true },
  { "gchoic.com", true },
  { "gchq.wtf", true },
  { "gcs-ventures.com", true },
  { "gcsepod.com", true },
  { "gdax.com", true },
  { "gdegem.org", true },
  { "gdutnic.com", true },
  { "gdv.me", true },
  { "ge1.me", false },
  { "ge3k.net", false },
  { "gearset.com", true },
  { "geblitzt.de", true },
  { "gebn.co.uk", true },
  { "geboortestoeltje.com", true },
  { "gebruikershandleiding.com", true },
  { "gecem.org", true },
  { "gechr.io", true },
  { "geder.at", true },
  { "gee.is", true },
  { "geek-hub.de", true },
  { "geek.com.tw", false },
  { "geek.tw", false },
  { "geekabit.nl", true },
  { "geekandi.com", true },
  { "geekariom.com", true },
  { "geekbundle.org", false },
  { "geeklair.net", true },
  { "geeknik.com", true },
  { "geekwhack.org", true },
  { "geekwithabudget.com", true },
  { "geekwu.org", true },
  { "geeky.software", true },
  { "geemo.top", true },
  { "geeq.ch", true },
  { "geertswei.nl", true },
  { "gehaowu.com", true },
  { "gehrke.nrw", true },
  { "gehsicht.de", true },
  { "geiser.io", true },
  { "gelog-software.de", false },
  { "geluidsstudio.com", true },
  { "gemeentemolenwaard.nl", true },
  { "gemeinfreie-lieder.de", true },
  { "gemini.com", true },
  { "gendrin.com", true },
  { "gene-drive.com", true },
  { "gene-drives.com", true },
  { "geneau.net", true },
  { "genehome.com.au", true },
  { "general-anaesthesia.com", true },
  { "generali-worldwide.com", true },
  { "generationnext.pl", true },
  { "generic.cx", true },
  { "genesiseureka.com", true },
  { "genie-seiner-generation.de", true },
  { "genomequestlive.com", true },
  { "genossen.ru", true },
  { "genshiken-itb.org", true },
  { "genshiken.org", true },
  { "genslerapps.com", true },
  { "genslerwisp.com", true },
  { "genuu.com", true },
  { "genuxation.com", true },
  { "genuxtsg.com", true },
  { "genxbeats.com", true },
  { "genxnotes.com", true },
  { "geoip.fedoraproject.org", true },
  { "geoip.stg.fedoraproject.org", true },
  { "geolad.com", false },
  { "geoport.al", true },
  { "georgemaschke.com", true },
  { "georgemaschke.net", true },
  { "georgioskontaxis.com", true },
  { "georgioskontaxis.net", true },
  { "georgioskontaxis.org", true },
  { "georgmayer.eu", true },
  { "geoscan.aero", true },
  { "geraintwhite.co.uk", true },
  { "gerardozamudio.mx", true },
  { "gereon.ch", true },
  { "germandarknes.net", true },
  { "gernert-server.de", true },
  { "gerritcodereview.com", true },
  { "gersting.net", true },
  { "gerwinvanderkamp.nl", true },
  { "ges-bo.de", true },
  { "geschmacksache.online", true },
  { "geschwinder.net", true },
  { "gesiwista.net", true },
  { "gesunde-smoothies.de", true },
  { "get-asterisk.ru", true },
  { "get-erp.ru", true },
  { "get-on.bid", true },
  { "get4x.com", true },
  { "getbox.me", true },
  { "getbutterfly.com", true },
  { "getcarina.com", true },
  { "getcloak.com", false },
  { "getcolq.com", true },
  { "getdash.io", true },
  { "getdigitized.net", true },
  { "geterp.ru", true },
  { "getfedora.org", true },
  { "getfestify.com", true },
  { "getfittedstore.com", true },
  { "getflorence.co.uk", true },
  { "gethttpsforfree.com", true },
  { "geti2p.com", true },
  { "getidmcc.com", true },
  { "getlittleapps.com", true },
  { "getlolaccount.com", true },
  { "getmango.com", true },
  { "getmdl.io", true },
  { "getmondo.co.uk", true },
  { "getnikola.com", true },
  { "getpake.com", true },
  { "getpublii.com", true },
  { "getremembrall.com", true },
  { "getronics.care", true },
  { "getsecure.nl", true },
  { "getsensibill.com", true },
  { "getsetupfile.com", true },
  { "getshifter.io", true },
  { "getspire.com", true },
  { "getsport.mobi", true },
  { "getts.ro", true },
  { "getvdownloader.com", true },
  { "gfhgiro.nl", false },
  { "gflclan.ru", true },
  { "gfm.tech", true },
  { "gfournier.ca", true },
  { "ggmmontascale.it", true },
  { "ggp2.com", true },
  { "ggservers.com", true },
  { "ggss.cf", true },
  { "ggss.ml", true },
  { "ggx.us", true },
  { "gh16.com.ar", true },
  { "gha.st", true },
  { "ghcif.de", true },
  { "gheorghe-sarcov.ga", true },
  { "gheorghesarcov.ga", true },
  { "gheorghesarcov.tk", true },
  { "ghostblog.info", true },
  { "ghostcir.com", true },
  { "ghostwritershigh.com", true },
  { "ghrelinblocker.info", true },
  { "giacomodrago.com", true },
  { "giacomodrago.it", true },
  { "giacomopelagatti.it", true },
  { "giakki.eu", true },
  { "gianproperties.com", true },
  { "giant-powerfit.co.uk", true },
  { "giantmicrobes.de", true },
  { "gianttree.de", true },
  { "gibraltar.at", true },
  { "giddyaunt.net", true },
  { "giftgofers.com", true },
  { "giftking.nl", true },
  { "giftservices.nl", true },
  { "giftsn.com.sg", false },
  { "gifzilla.net", false },
  { "gig.ru", false },
  { "giga.nl", true },
  { "gigacog.com", true },
  { "gigawa.lt", true },
  { "gijsbertus.com", true },
  { "gilcloud.com", true },
  { "gillet-cros.fr", true },
  { "gillmanandsoame.co.uk", true },
  { "gilroywestwood.org", true },
  { "gincher.net", true },
  { "ginja.co.th", true },
  { "ginkel.com", true },
  { "ginnegappen.nl", true },
  { "ginzadelunch.jp", true },
  { "gip-carif-idf.net", true },
  { "gip-carif-idf.org", true },
  { "giri.co", true },
  { "girlsnet.work", true },
  { "gis3m.org", true },
  { "git.co", true },
  { "github.com", true },
  { "github.party", false },
  { "giunchi.net", true },
  { "giveattheoffice.org", false },
  { "givingnexus.org", false },
  { "gix.net.pl", true },
  { "gixtools.co.uk", true },
  { "gixtools.com", true },
  { "gixtools.net", true },
  { "gixtools.uk", true },
  { "gizzo.sk", true },
  { "gj-bochum.de", true },
  { "gjcampbell.co.uk", true },
  { "gjspunk.de", false },
  { "gjung.com", false },
  { "gkralik.eu", true },
  { "glamguru.co.il", true },
  { "glamguru.world", true },
  { "glasen-hardt.de", true },
  { "glasfaser-im-hanseviertel.de", true },
  { "glasgestaltung.biz", true },
  { "glasner.photo", true },
  { "glass.google.com", true },
  { "glasschmuck-millefiori.de", true },
  { "glidingshop.cz", true },
  { "glidingshop.de", true },
  { "glidingshop.eu", true },
  { "glitchsys.com", true },
  { "glittersjabloon.nl", true },
  { "glitzmirror.com", true },
  { "global-lights.ma", true },
  { "globalado.com", true },
  { "globalcomix.com", true },
  { "globalexpert.co.nz", true },
  { "globalgivingtime.com", true },
  { "globalhealth.gov", true },
  { "globalinstitutefortraining.org.au", true },
  { "globalittech.com", false },
  { "globalmusic.ga", false },
  { "globalonetechnology.com", true },
  { "globalperspectivescanada.com", true },
  { "globuli-info.de", true },
  { "glossopnorthendafc.co.uk", true },
  { "glotter.com", true },
  { "glubbforum.de", true },
  { "glyph.ws", true },
  { "gm-assicurazioni.it", true },
  { "gmail.com", false },
  { "gmbh-kiekin.de", true },
  { "gmcd.co", true },
  { "gmdu.net", true },
  { "gmod.de", true },
  { "gmta.nl", true },
  { "gmw-hannover.de", true },
  { "gmw-ingenieurbuero.de", true },
  { "gnetion.com", true },
  { "gnetwork.eu", true },
  { "gnom.me", true },
  { "gnunet.org", true },
  { "gnylf.com", true },
  { "go-zh.org", true },
  { "go.xero.com", false },
  { "go4it.solutions", true },
  { "goabonga.com", true },
  { "goalbookapp.com", true },
  { "goalsetup.com", true },
  { "goanalyse.co.uk", true },
  { "goben.ch", true },
  { "gocardless.com", true },
  { "godesigner.ru", true },
  { "godrive.ga", true },
  { "godsofhell.com", true },
  { "goerres2014.de", true },
  { "goetemp.de", true },
  { "gofigure.fr", false },
  { "gogenenglish.com", true },
  { "gogoodyear.eu", true },
  { "gogsat.com", true },
  { "gohon.org", true },
  { "gokhankesici.com", true },
  { "gokmenguresci.com", true },
  { "gold24.ru", true },
  { "goldendata.io", true },
  { "goldenhillsoftware.com", true },
  { "goldenhost.ca", true },
  { "goldmark.com.au", true },
  { "goldminer.ga", true },
  { "goldpreisfinder.at", true },
  { "goldpros.com", true },
  { "goldsecurity.com", true },
  { "golf18network.com", true },
  { "golfburn.com", false },
  { "golfhausmallorca.com", true },
  { "golfscape.com", true },
  { "gong8.win", true },
  { "gonkar.com", true },
  { "goo.gl", true },
  { "gooby.co", false },
  { "goodmengroup.de", true },
  { "goodtech.com.br", true },
  { "google", true },
  { "google-analytics.com", true },
  { "google.ax", true },
  { "googlemail.com", false },
  { "googleplex.com", true },
  { "googlesource.com", true },
  { "goombi.fr", true },
  { "goozz.nl", true },
  { "gopay.cz", true },
  { "gopokego.cz", true },
  { "gordonobrecht.com", true },
  { "gorf.chat", true },
  { "gorf.club", true },
  { "gorgiaxx.com", true },
  { "gorod74.ru", true },
  { "gorschenin.com", true },
  { "gosccs.com", true },
  { "gosharewood.com", true },
  { "goshawkdb.io", true },
  { "goshop.cz", true },
  { "gospelfollower.com", true },
  { "gospelofmark.ch", true },
  { "gospelvestcination.de", true },
  { "gostudy.net", true },
  { "gosuland.org", true },
  { "gotech.com.eg", false },
  { "gotgenes.com", true },
  { "gothamlimo.com", true },
  { "gothic.dating", true },
  { "gotirupati.com", true },
  { "goto.google.com", true },
  { "goto.world", true },
  { "gotocloud.ru", false },
  { "gotomi.info", true },
  { "gotspot.com", true },
  { "goudenharynck.be", true },
  { "gov.ax", true },
  { "goverage.org", true },
  { "governmentjobs.gov", true },
  { "governorhub.com", true },
  { "govtrack.us", true },
  { "gowe.wang", false },
  { "gpcsolutions.fr", true },
  { "gpfclan.de", true },
  { "gplintegratedit.com", true },
  { "gpo.gov", false },
  { "gprs.uk.com", true },
  { "gps.com.br", true },
  { "gpsfix.cz", true },
  { "gpsvideocanada.com", true },
  { "gr.search.yahoo.com", false },
  { "gra2.com", true },
  { "graasp.net", true },
  { "graavaapi.elasticbeanstalk.com", true },
  { "grabi.ga", true },
  { "grace-wan.com", true },
  { "gracedays.org", true },
  { "graceful-project.eu", true },
  { "gracethrufaith.com", true },
  { "gracetini.com", true },
  { "graciousmay.com", true },
  { "grademymac.com", true },
  { "grademypc.com", true },
  { "gradients.com", true },
  { "graf.re", true },
  { "grafcaps.com", true },
  { "graffen.dk", true },
  { "grafitec.ru", true },
  { "grafmurr.de", true },
  { "graingert.co.uk", true },
  { "graliv.net", true },
  { "gramati.com.br", true },
  { "granary-demo.appspot.com", true },
  { "grandcapital.id", true },
  { "grandcapital.ru", true },
  { "grandchamproofing.com", true },
  { "grandlinecsk.ru", true },
  { "grandmasfridge.org", true },
  { "grandpadusercontent.com", true },
  { "grandwailea.com", true },
  { "grannyshouse.de", true },
  { "grantedby.me", false },
  { "granth.io", true },
  { "granular.ag", true },
  { "graphire.io", true },
  { "graphsearchengine.com", true },
  { "grassenberg.de", true },
  { "grasshoppervape.com", true },
  { "gratisonlinesex.com", true },
  { "gravitascreative.net", true },
  { "gravitation.pro", false },
  { "gravitechthai.com", true },
  { "gravito.nl", true },
  { "gravity-dev.de", true },
  { "gravity-net.de", true },
  { "graycell.net", true },
  { "graymalk.in", true },
  { "grazetech.com", true },
  { "grc.com", false },
  { "grcnode.co.uk", true },
  { "greatfire.org", true },
  { "greboid.co.uk", true },
  { "greboid.com", true },
  { "greedbutt.com", true },
  { "greek.dating", true },
  { "green-attitude.be", true },
  { "green-care.nl", true },
  { "greenaddress.it", true },
  { "greencardtalent.com", true },
  { "greencircleplantnursery.com.au", true },
  { "greencircleplantnursery.net.au", true },
  { "greenpeace-magazin.de", true },
  { "greenpeace.berlin", true },
  { "greenroach.ru", true },
  { "greensdictofslang.com", true },
  { "greensolid.biz", true },
  { "greenteamtwente.nl", true },
  { "greg.red", true },
  { "greger.me", true },
  { "gregmilton.com", true },
  { "gregmilton.org", true },
  { "gregorians.org", true },
  { "gregorywiest.com", true },
  { "greiners.net", true },
  { "grepmaste.rs", true },
  { "grepular.com", true },
  { "gresak.io", true },
  { "gretchelizartistry.com", true },
  { "grey.house", true },
  { "greyline.se", true },
  { "greyskymedia.com", true },
  { "greysolutions.it", true },
  { "greywizard.com", true },
  { "grh.am", true },
  { "gribani.com", true },
  { "grid2osm.org", true },
  { "grieg-gaarden.no", true },
  { "grieg.com", true },
  { "grieg.net", true },
  { "grieg.no", true },
  { "griegfoundation.no", true },
  { "grieglogistics.no", true },
  { "griegshipbrokers.com", true },
  { "griegshipbrokers.no", true },
  { "griesser2.de", true },
  { "grigalanzsoftware.com", true },
  { "grillinfools.com", true },
  { "grimcalc.com", true },
  { "grimm-gastrobedarf.de", true },
  { "grimneko.de", true },
  { "gripopgriep.net", true },
  { "gritte.ch", true },
  { "grizzlys.com", true },
  { "groben-itsolutions.de", true },
  { "grocock.me.uk", true },
  { "groenaquasolutions.nl", true },
  { "groenemeijer.frl", true },
  { "groetzner.net", true },
  { "grog.pw", true },
  { "grokker.com", true },
  { "groovydisk.com", true },
  { "gropp.org", true },
  { "groseb.net", true },
  { "grossell.ru", true },
  { "grossmann.gr", true },
  { "groszek.pl", true },
  { "groth.im", true },
  { "groth.xyz", true },
  { "group4layers.net", true },
  { "groupe-cassous.com", true },
  { "groupebaillargeon.com", true },
  { "groupme.com", true },
  { "groups.google.com", true },
  { "grow-shop.lt", true },
  { "grozip.com", true },
  { "grsecurity.net", true },
  { "gruelang.org", true },
  { "gruene-wattenscheid.de", true },
  { "gruenes-wp.de", true },
  { "grumpy.fr", true },
  { "grunwasser.fr", true },
  { "grupopgn.com.br", true },
  { "grusig-geil.ch", true },
  { "gryffin.ga", true },
  { "gryffin.ml", true },
  { "gryffin.tk", true },
  { "grytics.com", true },
  { "gs-net.at", true },
  { "gsi-network.com", true },
  { "gsimagebank.co.uk", true },
  { "gsmkungen.com", true },
  { "gsrc.io", true },
  { "gswtech.eu", true },
  { "gta-arabs.com", true },
  { "gtamodshop.org", true },
  { "gtanda.tk", true },
  { "gtchipsi.org", true },
  { "gtdgo.com", true },
  { "gtech.work", true },
  { "gtldna.com", true },
  { "gtmasterclub.it", false },
  { "gtmetrix.com", true },
  { "gtraxapp.com", true },
  { "guardian360.nl", true },
  { "gudini.net", true },
  { "guenthereder.at", true },
  { "guentherhouse.com", true },
  { "guenthernoack.de", true },
  { "guerrilla.technology", true },
  { "guevener.de", true },
  { "guffr.it", true },
  { "guffrits.com", true },
  { "gugaltika-ipb.org", false },
  { "guguke.net", true },
  { "guhenry3.tk", true },
  { "guideo.ch", true },
  { "guidetoiceland.is", false },
  { "guildgearscore.cf", true },
  { "guillaume-leduc.fr", true },
  { "guillaumeperrin.io", true },
  { "guinea-pig.co", true },
  { "guineapigmustach.es", true },
  { "guitarmarketing.com", false },
  { "gulch.in.ua", false },
  { "gulenbase.no", true },
  { "gummibande.noip.me", true },
  { "gunnaro.com", true },
  { "guntbert.net", true },
  { "gunwatch.co.uk", true },
  { "guoqiang.info", true },
  { "guphi.net", true },
  { "gurkan.in", true },
  { "gurmel.ru", true },
  { "gurochan.ch", true },
  { "gurom.lv", true },
  { "guru-naradi.cz", true },
  { "gurueffect.com", true },
  { "gurusupe.com", true },
  { "gus.host", true },
  { "gus.moe", true },
  { "guscaplan.me", true },
  { "guso.gq", true },
  { "guso.ml", true },
  { "guso.site", true },
  { "guso.tech", true },
  { "guthabenkarten-billiger.de", true },
  { "guts.me", true },
  { "guvernalternativa.ro", true },
  { "gv-neumann.de", true },
  { "gvatas.in", true },
  { "gveh.de", true },
  { "gvt2.com", true },
  { "gvt3.com", true },
  { "gw2reload.eu", true },
  { "gw2treasures.com", true },
  { "gwerder.net", true },
  { "gwtest.us", true },
  { "gxlrx.net", true },
  { "gyas.nl", true },
  { "gyboche.com", true },
  { "gyboche.science", true },
  { "gycis.me", true },
  { "gymnasium-farmsen.de", true },
  { "gypsycatdreams.com", true },
  { "gyu-raku.jp", true },
  { "gyz.io", true },
  { "gz-architekten.de", true },
  { "gz-benz.com", true },
  { "gz-bmw.com", true },
  { "gza.jp", true },
  { "gzitech.com", true },
  { "h-jo.net", true },
  { "h-og.com", true },
  { "h11.io", true },
  { "h11.moe", true },
  { "h2check.org", true },
  { "h404bi.com", false },
  { "haavard.me", true },
  { "habarisoft.com", true },
  { "habbos.es", true },
  { "habbotalk.nl", true },
  { "hablemosdetecnologia.com.ve", false },
  { "habtium.com", true },
  { "habtium.es", true },
  { "hac30.com", true },
  { "hachre.de", false },
  { "hack.cz", true },
  { "hackcraft.net", true },
  { "hackenkunjeleren.nl", true },
  { "hackenturet.dk", true },
  { "hacker.one", true },
  { "hacker.parts", true },
  { "hacker1.com", true },
  { "hackerchai.com", true },
  { "hackernet.se", true },
  { "hackerone-ext-adroll.com", true },
  { "hackerone-user-content.com", true },
  { "hackerone.com", true },
  { "hackerone.net", true },
  { "hackerpoints.com", true },
  { "hackerspace-ntnu.no", true },
  { "hackerstxt.org", true },
  { "hackit.im", true },
  { "hackmd.io", true },
  { "hacksnack.io", true },
  { "hackthissite.org", true },
  { "hacktivis.me", true },
  { "hadaf.pro", true },
  { "hadleighswimmingclub.co.uk", true },
  { "hadzic.co", true },
  { "haeckl.eu", true },
  { "haens.li", true },
  { "haf.gr", true },
  { "hafniatimes.com", true },
  { "hail2u.net", true },
  { "hailer.com", true },
  { "haircrazy.com", true },
  { "haitschi.com", true },
  { "haitschi.net", true },
  { "haitschi.org", true },
  { "hajnzic.at", true },
  { "hakase.kr", true },
  { "hakatabijin-mind.com", true },
  { "haktec.de", true },
  { "haku.moe", false },
  { "hakugin.me", true },
  { "hakugin.org", true },
  { "halcyonsbastion.com", true },
  { "halkyon.net", true },
  { "hallelujahsoftware.com", true },
  { "hallhuber.com", true },
  { "hallmarkestates.ca", true },
  { "hallucinogen.com", true },
  { "halo.fr", true },
  { "halongbaybackpackertour.com", true },
  { "hamacho-kyudo.com", true },
  { "hamali.bg", true },
  { "haman.nl", true },
  { "hammer-corp.com", true },
  { "hana.ondemand.com", true },
  { "handenafvanhetmedischdossier.nl", true },
  { "handiworker.com", true },
  { "handmadetutorials.ro", true },
  { "handycommerce.co", true },
  { "handysex.live", true },
  { "hanfu.la", true },
  { "hangouts.google.com", true },
  { "hanimalis.fr", true },
  { "hannah.link", true },
  { "hannover-banditen.de", true },
  { "hans-natur.de", true },
  { "hansen.hn", true },
  { "hansvaneijsden.com", true },
  { "hansvaneijsden.nl", true },
  { "hantse.com", true },
  { "hanu.la", true },
  { "hanzubon.jp", true },
  { "hao-zhang.com", true },
  { "haomwei.com", true },
  { "haoyugao.com", true },
  { "haozhang.org", true },
  { "haozi.me", true },
  { "hapijs.cn", true },
  { "hapissl.com", true },
  { "hapivm.com", true },
  { "happist.com", true },
  { "happix.nl", true },
  { "happyandrelaxeddogs.eu", true },
  { "happycoder.net", false },
  { "happygadget.me", true },
  { "happygastro.com", true },
  { "happylifestyle.com", true },
  { "happyteamlabs.com", true },
  { "happytiger.eu", true },
  { "happyukgo.com", true },
  { "hapvm.com", true },
  { "haraj.com.sa", true },
  { "harambe.site", true },
  { "harbor-light.net", true },
  { "hardeman.nu", true },
  { "hardenize.com", true },
  { "hardertimes.com", true },
  { "hardfalcon.net", true },
  { "hardh.at", true },
  { "hardline.xyz", true },
  { "hardtfrieden.de", true },
  { "haribosupermix.com", true },
  { "harlentimberproducts.co.uk", true },
  { "harmoney.co.nz", true },
  { "harmoney.com", true },
  { "harmoney.com.au", true },
  { "harringtonca.com", true },
  { "harrisonsand.com", false },
  { "harrisonsdirect.co.uk", true },
  { "harrisonswebsites.com", true },
  { "harristony.com", true },
  { "harrysmallbones.co.uk", true },
  { "hartie95.de", true },
  { "hartlep.email", true },
  { "harvestapp.com", true },
  { "harvester.fr", true },
  { "hasdf.de", true },
  { "haselsteiner.me", true },
  { "hash-archive.org", true },
  { "hashiconf.com", true },
  { "hashiconf.eu", true },
  { "hashicorp.com", true },
  { "hashimah.ca", true },
  { "hashnode.com", true },
  { "hashplex.com", true },
  { "hashru.nl", true },
  { "hashworks.net", true },
  { "hasinase.de", false },
  { "haskovec.com", true },
  { "hasselbach-dellwig.de", true },
  { "haste.ch", true },
  { "hastherebeenamassshooting.today", true },
  { "hatcherlawgroupnm.com", true },
  { "hatethe.uk", true },
  { "hatisenang.com", false },
  { "hatoko.net", true },
  { "haucke.xyz", true },
  { "haufschild.de", true },
  { "hauntedfishtank.com", false },
  { "hausverbrauch.de", true },
  { "hautarztzentrum.ch", true },
  { "haveeruexaminer.com", true },
  { "haveforeningen-enghaven.dk", true },
  { "haveibeenpwned.com", true },
  { "havellab.de", true },
  { "havelland-obstler.de", true },
  { "havenswift-hosting.co.uk", true },
  { "hawkeyeinsight.com", true },
  { "hawksguild.com", true },
  { "hawthornharpist.com", true },
  { "haxo.nl", false },
  { "hazyrom.net", true },
  { "hbdesign.work", true },
  { "hboeck.de", true },
  { "hbpowell.com", true },
  { "hcfhomelottery.ca", true },
  { "hcie.pl", true },
  { "hd-gaming.com", true },
  { "hd-offensive.at", true },
  { "hda.me", true },
  { "hdc.cz", true },
  { "hdcenter.cc", true },
  { "hdeaves.uk", true },
  { "hdfgroup.org", true },
  { "hdhoang.space", true },
  { "hdm.io", true },
  { "hdrboundless.com", true },
  { "hdrsource.com", true },
  { "hdrtranscon.com", true },
  { "hds-lan.de", true },
  { "hdsmigrationtool.com", true },
  { "hdy.nz", true },
  { "head-shop.lt", true },
  { "head-shop.lv", true },
  { "head.org", true },
  { "headjapan.com", true },
  { "headshotharp.de", true },
  { "healthcare.gov", false },
  { "healtheffectsofasbestos.com", true },
  { "healthfoam.com", true },
  { "healthiercompany.com", true },
  { "healthjoy.com", true },
  { "heartgames.pl", true },
  { "heartmdinstitute.com", true },
  { "heartsucker.com", true },
  { "hearty.blog", true },
  { "hearty.ga", true },
  { "hearty.ink", true },
  { "hearty.me", true },
  { "hearty.space", true },
  { "hearty.tw", true },
  { "heartyme.net", true },
  { "heathmanners.com", true },
  { "heavensattic.co.uk", true },
  { "heavensinferno.net", true },
  { "heavystresser.com", true },
  { "hebaus.com", true },
  { "hebikhiv.nl", true },
  { "hebriff.com", true },
  { "hec.global", true },
  { "hectorj.net", true },
  { "hedgeschool.ie", true },
  { "hedonistic-imperative.com", true },
  { "hedweb.com", true },
  { "hedweb.net", true },
  { "hedweb.org", true },
  { "heeler.blue", true },
  { "heeler.red", true },
  { "heftkaufen.de", true },
  { "hegen.com.pl", true },
  { "hegen.cz", true },
  { "hegen.sk", true },
  { "hegenshop.de", true },
  { "heh.ee", true },
  { "heha.co", false },
  { "heid.ws", true },
  { "heidilein.info", true },
  { "heijblok.com", true },
  { "heiland.io", true },
  { "heimprofis.de", true },
  { "heinpost.nl", false },
  { "heissluft-fritteuse.com", true },
  { "heitland-it.de", true },
  { "hejahanif.se", true },
  { "hejsupport.se", true },
  { "helden-spielen.de", true },
  { "hele.cz", true },
  { "helencrump.co.uk", true },
  { "helenkellersimulator.org", true },
  { "helgakristoffer.com", true },
  { "helgakristoffer.wedding", true },
  { "helichat.de", true },
  { "helingqi.com", true },
  { "helioanodyne.eu", true },
  { "helix.am", true },
  { "helixflight.com", true },
  { "hellenicaward.com", true },
  { "hellersgas.com", true },
  { "helles-koepfchen.de", true },
  { "helloacm.com", true },
  { "helloanselm.com", true },
  { "hellomouse.cf", true },
  { "hellotandem.com", true },
  { "hellscanyonraft.com", true },
  { "help.simpletax.ca", true },
  { "helpadmin.net", true },
  { "helpconnect.com.au", true },
  { "helpgoabroad.com", true },
  { "helpium.de", true },
  { "helsinki.dating", true },
  { "helup.com", true },
  { "hemlockhillscabinrentals.com", true },
  { "hencagon.com", true },
  { "hengelsportdeal.com", true },
  { "hennadesigns.org", true },
  { "hennymerkel.com", true },
  { "henok.eu", true },
  { "henriknoerr.com", true },
  { "henriksen.is", true },
  { "henrock.net", true },
  { "henry.gg", true },
  { "henryphan.com", false },
  { "hentschke-bau.de", true },
  { "hentschke-betonfertigteilwerk.de", true },
  { "hentschke-invest.de", true },
  { "heppler.net", true },
  { "hepteract.us", true },
  { "heptner24.de", true },
  { "herbandpat.org", true },
  { "herbert.io", true },
  { "herbertmouwen.nl", true },
  { "herbweb.net", true },
  { "herbweb.org", true },
  { "herculex.fi", true },
  { "herds.eu", true },
  { "herebedragons.io", true },
  { "herecsrymy.cz", true },
  { "heritagedentistry.ca", true },
  { "herocentral.de", true },
  { "herpaderp.net", true },
  { "herr-webdesign.de", true },
  { "herringsresidence.be", true },
  { "herrsmith.com", true },
  { "hesaplama.net", true },
  { "hethely.ch", true },
  { "hetmer.com", true },
  { "heute-kaufen.de", true },
  { "hex2013.com", true },
  { "hexacon.io", true },
  { "hexagon-e.com", true },
  { "hexe.net", true },
  { "hexed.it", true },
  { "hexicurity.com", true },
  { "hexid.me", true },
  { "hexo.io", true },
  { "hexony.com", true },
  { "heycms.com", true },
  { "heyfringe.com", true },
  { "heyguevara.com", true },
  { "heywoodtown.co.uk", true },
  { "hg.python.org", true },
  { "hhhdb.com", true },
  { "hhmmmm.de", true },
  { "hhs.gov", true },
  { "hibilog.com", true },
  { "hicl.org", true },
  { "hicn.gq", true },
  { "hicoria.com", true },
  { "hidbo.de", true },
  { "hiddenmail.xyz", true },
  { "hiddenrefuge.eu.org", true },
  { "hiexmerida-mailing.com", true },
  { "higgstools.org", true },
  { "highvelocitydesign.com", true },
  { "higp.de", true },
  { "hiisukun.com", true },
  { "hikariempire.com", true },
  { "hilahdih.cz", true },
  { "hilaolu.com", true },
  { "hilchenba.ch", true },
  { "hilnu.com", true },
  { "hilnu.tk", true },
  { "hilti.ee", false },
  { "hilti.kz", false },
  { "hilti.lv", false },
  { "hiltonhyland.com", true },
  { "hintergedanken.com", true },
  { "hintergrundbewegung.de", true },
  { "hintermeier-rae.at", true },
  { "hiphop.ren", true },
  { "hiphopconvention.nl", true },
  { "hippies.com.br", true },
  { "hipstercat.fr", true },
  { "hiqfleet.co.uk", true },
  { "hiqfranchise.co.uk", true },
  { "hiqhub.co.uk", true },
  { "hiqonline.co.uk", true },
  { "hirake55.com", true },
  { "hirte-digital.de", true },
  { "hirzaconsult.ro", true },
  { "hisbrucker.net", true },
  { "hisnet.de", true },
  { "hispanic.dating", true },
  { "history.google.com", true },
  { "hitchunion.org", true },
  { "hititgunesi-tr.com", true },
  { "hiv.gov", true },
  { "hiverlune.net", true },
  { "hiyacar.co.uk", true },
  { "hjortland.org", true },
  { "hjw-kunstwerk.de", true },
  { "hk.search.yahoo.com", false },
  { "hkdobrev.com", true },
  { "hlavacek.us", true },
  { "hledejlevne.cz", true },
  { "hledejpravnika.cz", true },
  { "hlfh.space", true },
  { "hm1ch.com", true },
  { "hmhotelec.com", true },
  { "hmm.nyc", false },
  { "hmoegirl.com", true },
  { "hms-waldmann.de", true },
  { "hmsseahawk.com", true },
  { "hobbiesandotherstuff.com", true },
  { "hobby-gamerz-community.de", true },
  { "hobbyspeed.com", true },
  { "hochhaus.us", true },
  { "hochzeit-dana-laurens.de", true },
  { "hodne.io", false },
  { "hoe.re", true },
  { "hoekwoningverkopen.nl", true },
  { "hogl.dk", true },
  { "hohm.in", true },
  { "hohnet.com", true },
  { "hoiku-map.tokyo", true },
  { "hokieprivacy.org", true },
  { "holifestival-freyung.de", true },
  { "holisticon.de", true },
  { "hollowrap.com", true },
  { "hollyforrest.ca", true },
  { "hollyforrestphotography.ca", true },
  { "holmesian.org", true },
  { "holo.ovh", true },
  { "holofono.com", true },
  { "holowaty.me", true },
  { "holyhiphopdatabase.com", true },
  { "holzheizer-forum.de", true },
  { "holzheizerforum.de", true },
  { "holzvergaser-forum.de", true },
  { "homads.com", false },
  { "home-v.ind.in", true },
  { "homebodyalberta.com", true },
  { "homecareassociatespa.com", true },
  { "homecoming.city", true },
  { "homedna.com", true },
  { "homeexx.com", true },
  { "homehuntertoronto.com", true },
  { "homehunting.pt", true },
  { "homeprivate.de", true },
  { "homeseller.co.uk", true },
  { "homeseller.com", true },
  { "hometownmall.com", true },
  { "homewatt.co.uk", true },
  { "homeyantra.com", true },
  { "homeyou.com", true },
  { "homophoni.com", true },
  { "hompus.nl", false },
  { "honda-centrum.cz", true },
  { "hondart.cz", true },
  { "honeybadger.io", false },
  { "honeybeard.co.uk", true },
  { "honeycome.net", true },
  { "honeypot.net", true },
  { "hongzhaxiaofendui.com", true },
  { "honkhonk.net", true },
  { "honkion.net", true },
  { "honovere.de", true },
  { "hoodoo.io", true },
  { "hoodoo.tech", true },
  { "hoodtrader.com", true },
  { "hookbin.com", true },
  { "hooowl.com", true },
  { "hoopsacademyusa.com", true },
  { "hooray.beer", true },
  { "hopesb.org", true },
  { "hopewellproperties.co.uk", true },
  { "hopps.me", true },
  { "hord.ca", true },
  { "horeizai.net", true },
  { "horizonhomes-samui.com", true },
  { "hornblasters.com", true },
  { "horning.co", true },
  { "horstmanshof.eu", true },
  { "horvathd.eu", false },
  { "horvathtom.com", true },
  { "hory.me", true },
  { "horza.org", true },
  { "hoshinplan.com", true },
  { "hoshisato.com", true },
  { "hosiet.me", true },
  { "hosmussynergie.nl", false },
  { "hospitalhomelottery.org", true },
  { "hostam.link", true },
  { "hostanalyticsconsulting.com", true },
  { "hosted-oswa.org", true },
  { "hosted4u.de", true },
  { "hostedbgp.net", true },
  { "hostedtalkgadget.google.com", true },
  { "hostelite.com", true },
  { "hostfission.com", true },
  { "hostingactive.it", true },
  { "hostingfj.com", true },
  { "hostinghelp.guru", true },
  { "hostinginnederland.nl", true },
  { "hostix.de", true },
  { "hostma.ma", true },
  { "hostmijnpagina.nl", true },
  { "hotchillibox.co.za", true },
  { "hotel-kronjuwel.de", true },
  { "hotel-pension-sonnalp.eu", true },
  { "hotel-tongruben.de", true },
  { "hotelflow.com.br", true },
  { "hotelident.de", true },
  { "hotelmap.com", true },
  { "hotelvictoriaoax-mailing.com", true },
  { "hotelvillahermosa-mailing.com", true },
  { "hotelvue.nl", true },
  { "hoton.in", true },
  { "hotornot.com", true },
  { "hotplug.gr", true },
  { "hotpoint-training.com", true },
  { "hotting.nl", true },
  { "houser.lu", true },
  { "housingstudents.org.uk", true },
  { "howardtyson.com", true },
  { "howbehealthy.com", true },
  { "howbigismybuilding.com", true },
  { "howlongtobeatsteam.com", true },
  { "howrandom.org", true },
  { "howsecureismypassword.net", true },
  { "howsmyssl.com", true },
  { "howsmytls.com", true },
  { "howsyourhealth.org", true },
  { "howtocuremysciatica.com", true },
  { "hozana.si", false },
  { "hp-work.net", true },
  { "hpac-portal.com", true },
  { "hpbn.co", true },
  { "hpisavageforum.com", true },
  { "hpkp-faq.de", true },
  { "hqhost.net", false },
  { "hr98.tk", true },
  { "hrackydomino.cz", true },
  { "hraesvelg.net", true },
  { "hranicka.cz", true },
  { "hrbatypes.cz", true },
  { "hrfhomelottery.com", true },
  { "hrndz.io", true },
  { "hrobert.hu", true },
  { "hroschyk.cz", true },
  { "hs-group.net", true },
  { "hscorp.de", true },
  { "hsir.me", true },
  { "hsivonen.com", true },
  { "hsivonen.fi", true },
  { "hsivonen.iki.fi", true },
  { "hsmr.cc", true },
  { "hsr.gov", false },
  { "hsts-preload-test.xyz", true },
  { "hsts.com.br", true },
  { "hsts.date", true },
  { "hsts.eu", true },
  { "hstsfail.appspot.com", true },
  { "hstspreload.appspot.com", true },
  { "hstspreload.com", true },
  { "hstspreload.org", true },
  { "hszemi.de", true },
  { "hszhyy120.com", true },
  { "htaccessbook.com", true },
  { "html-lab.tk", true },
  { "html5.org", true },
  { "htmlacademy.ru", true },
  { "htmue.net", true },
  { "htmue.org", true },
  { "http2.pro", true },
  { "http418.xyz", true },
  { "https.jetzt", true },
  { "httpsecurityreport.com", true },
  { "httpstatuscode418.xyz", true },
  { "httpswatch.ca", true },
  { "httpswatch.com", true },
  { "httptest.net", true },
  { "huagati.com", true },
  { "huang.nu", true },
  { "huangh.com", true },
  { "huaxueba.com", true },
  { "hubert.systems", true },
  { "huberulrich.de", true },
  { "huchet.me", true },
  { "hudhaifahgoga.co.za", true },
  { "hudingyuan.cn", true },
  { "huendeleskopfhuette.de", true },
  { "huersch.com", true },
  { "huffduffer.com", true },
  { "hugocollignon.fr", false },
  { "hugofs.com", true },
  { "huguesblanchard.paris", true },
  { "huihui.moe", true },
  { "huiser.nl", true },
  { "humankode.com", true },
  { "humblefinances.com", true },
  { "humeurs.net", true },
  { "hump.dk", true },
  { "humpi.at", true },
  { "hund.io", true },
  { "hundeformel.de", true },
  { "hunger.im", true },
  { "hunter.io", true },
  { "huntshomeinspections.com", true },
  { "huodongweb.com", true },
  { "hup.blue", true },
  { "hupp.se", true },
  { "hurd.is", true },
  { "huren.nl", true },
  { "huroji.com", true },
  { "husakbau.at", true },
  { "hushfile.it", true },
  { "husic.net", true },
  { "husky.xyz", true },
  { "huskybutt.dog", true },
  { "huskyinc.us", true },
  { "hussam.eu.org", true },
  { "huutonauru.net", true },
  { "huwcbjones.co.uk", true },
  { "huwjones.me", true },
  { "huxley.net", true },
  { "hvh.no", true },
  { "hvtuananh.com", true },
  { "hwag-pb.de", true },
  { "hwinfo.com", true },
  { "hx53.de", true },
  { "hxying.com", true },
  { "hybridworx.com", true },
  { "hybridworx.de", true },
  { "hybridworx.eu", true },
  { "hybridworx.net", true },
  { "hybridworx.org", true },
  { "hycken.com", true },
  { "hydra.zone", true },
  { "hydrocloud.net", true },
  { "hydronium.cf", true },
  { "hydronium.ga", true },
  { "hydronium.me", true },
  { "hydronium.ml", true },
  { "hydronium.tk", true },
  { "hydrozone.fr", true },
  { "hyk.me", true },
  { "hymerscollege.co.uk", true },
  { "hynek.me", true },
  { "hypa.net.au", true },
  { "hypemgmt.com", true },
  { "hyper-matrix.org", true },
  { "hyper-text.org", true },
  { "hyperreal.info", true },
  { "hypnoresults.com.au", true },
  { "hypotecnicentrum.cz", true },
  { "i--b.com", true },
  { "i-jp.net", true },
  { "i-stats.net", true },
  { "i10z.com", true },
  { "i1314.gdn", true },
  { "i28s.com", true },
  { "i5y.co.uk", true },
  { "i95.me", false },
  { "iactu.info", true },
  { "iainsimms.me", true },
  { "iamcarrico.com", true },
  { "iamjoshellis.com", true },
  { "iamreubin.co.uk", true },
  { "iamusingtheinter.net", true },
  { "ian.sh", true },
  { "iandouglasscott.com", true },
  { "ianix.com", true },
  { "iavian.com", true },
  { "ib-wedler.de", false },
  { "iba.community", true },
  { "iban.is", true },
  { "ibase.com", true },
  { "ibenchu.com", true },
  { "ibizatopcharter.com", true },
  { "ibnuwebhost.com", false },
  { "ibox.ovh", true },
  { "ibron.co", false },
  { "ic3.gov", true },
  { "icarlos.net", true },
  { "ice.yt", true },
  { "icebat.dyndns.org", true },
  { "iceloch.com", true },
  { "icfl.com.br", true },
  { "ich-find-den-g.net", true },
  { "ich-tanke.de", true },
  { "ichnichtskaufmann.de", true },
  { "ichoosebtec.com", true },
  { "ichronos.net", true },
  { "icij.org", false },
  { "icity.ly", true },
  { "icloud.net", true },
  { "icntorrent.download", true },
  { "icodeconnect.com", true },
  { "icodesign.me", true },
  { "icpc2016.in.th", true },
  { "icq-project.net", true },
  { "ict-concept.nl", false },
  { "ict-radar.com", true },
  { "ict-radar.nl", true },
  { "ictinforensics.org", true },
  { "ictradar.com", true },
  { "icusignature.com", true },
  { "icymint.me", true },
  { "id-co.in", true },
  { "id.atlassian.com", true },
  { "id.fedoraproject.org", false },
  { "id.mayfirst.org", false },
  { "id.search.yahoo.com", false },
  { "id0-rsa.pub", true },
  { "idahoansforliberty.net", true },
  { "idaspis.com", true },
  { "idconsult.nl", true },
  { "idcrane.com", true },
  { "ideadozz.hu", true },
  { "ideasmeetingpoint.com", true },
  { "ideaweb.de", false },
  { "idecode.net", true },
  { "idedr.com", true },
  { "idemo.in", true },
  { "idensys.nl", true },
  { "identifyme.net", true },
  { "identitytheft.gov", true },
  { "idexxpublicationportal.com", true },
  { "idgard.de", true },
  { "idgsupply.com", true },
  { "idid.tk", true },
  { "idiopolis.org", true },
  { "idisplay.es", true },
  { "idlekernel.com", true },
  { "idmobile.co.uk", true },
  { "idndx.com", true },
  { "idoc24.com", true },
  { "idolf.dk", true },
  { "idontplaydarts.com", true },
  { "idsafe.co.za", true },
  { "idubaj.cz", true },
  { "idvl.de", true },
  { "iec.pe", true },
  { "ieeespmb.org", true },
  { "ierna.com", true },
  { "ies.id.lv", true },
  { "ieval.ro", true },
  { "ifasec.de", false },
  { "ifcfg.me", true },
  { "ifconfig.co", true },
  { "ifengge.cn", true },
  { "ifengge.me", true },
  { "iflare.de", true },
  { "ifleurs.com", true },
  { "iformbuilder.com", false },
  { "ifoss.me", true },
  { "ifsac.org", true },
  { "ifsr.de", true },
  { "iftrue.de", true },
  { "ifx.ee", true },
  { "ifxor.com", true },
  { "igforums.com", true },
  { "igglabs.com", true },
  { "iggprivate.com", true },
  { "iggsoft.com", true },
  { "iggsoftware.com", true },
  { "igiftcards.de", true },
  { "igiftcards.nl", true },
  { "igk.de", true },
  { "ignace72.eu", true },
  { "ignat.by", true },
  { "ignitedmindz.in", true },
  { "igotoffer.com", true },
  { "igrivi.com", true },
  { "igule.net", true },
  { "ihkk.net", true },
  { "ihopeit.works", true },
  { "ihostup.net", true },
  { "ihrhost.com", true },
  { "ihrlotto.de", true },
  { "ihrnationalrat.ch", true },
  { "ihsbsd.me", true },
  { "ihsbsd.tk", true },
  { "iiong.com", true },
  { "iirii.com", true },
  { "iispeed.com", true },
  { "ijoda.com", true },
  { "ijohan.nl", true },
  { "ijsclubtilburg.nl", true },
  { "ikachalife.com", true },
  { "ikarate.ru", true },
  { "ikeyless.com", true },
  { "ikk.me", true },
  { "ikkatsu-satei.jp", true },
  { "iklive.org", false },
  { "ikocik.sk", true },
  { "ikon.name", true },
  { "ikulist.me", true },
  { "ikvts.de", true },
  { "ikwilthepiratebay.org", true },
  { "ikzoekeengoedkopeauto.nl", true },
  { "ikzoekjeugdhulp.nl", true },
  { "ila.fi", true },
  { "ilamparas.com", true },
  { "ile-kalorii.pl", true },
  { "ilgi.work", true },
  { "ilhadocaranguejo.com.br", true },
  { "ilhansubasi.com", true },
  { "ilikerainbows.co", true },
  { "ilikerainbows.co.uk", false },
  { "illegalpornography.me", true },
  { "illicitart.ca", true },
  { "illjinx.info", true },
  { "illorenese.fr", true },
  { "ilmiobusinessonline.it", true },
  { "ilprof.com", true },
  { "ilrg.com", true },
  { "iltisim.ch", true },
  { "im-c-shop.com", true },
  { "im2net.com", true },
  { "imagefu.com", true },
  { "imagescostumes.com", true },
  { "imaginary.ca", true },
  { "imagr.io", true },
  { "imakepoems.net", true },
  { "imanolbarba.net", true },
  { "imanudin.net", true },
  { "imbrian.org", true },
  { "imbushuo.net", true },
  { "imed.pt", true },
  { "imedi.co.uk", true },
  { "imedi.it", true },
  { "imedikament.de", true },
  { "imeds.pl", true },
  { "imforza.com", true },
  { "imgaa.com", true },
  { "imgencrypt.com", true },
  { "imgg.es", true },
  { "imguoguo.com", true },
  { "imguploaden.nl", true },
  { "imirhil.fr", true },
  { "imitza.com", true },
  { "imjad.cn", true },
  { "imjiangtao.com", true },
  { "imlonghao.com", true },
  { "immaterium.de", true },
  { "immersionwealth.com", true },
  { "immersivewebportal.com", true },
  { "immigrationdirect.com.au", true },
  { "immobilier-nice.fr", true },
  { "immunicity.cc", true },
  { "immunicity.date", true },
  { "immunicity.eu", true },
  { "immunicity.host", true },
  { "immunicity.info", true },
  { "immunicity.online", true },
  { "immunicity.press", true },
  { "immunicity.rocks", true },
  { "immunicity.top", true },
  { "immunicity.win", true },
  { "imoni-blog.net", true },
  { "imoto.me", true },
  { "imouyang.com", true },
  { "impact.health.nz", true },
  { "impex.com.bd", true },
  { "imppac.de", true },
  { "impyus.com", true },
  { "imququ.com", true },
  { "imreh.net", true },
  { "imrejonk.nl", true },
  { "in-depthoutdoors.com", true },
  { "in-flames.com", true },
  { "in.search.yahoo.com", false },
  { "in.xero.com", false },
  { "in10tion.com", true },
  { "inabox.ro", true },
  { "inb4.us", true },
  { "inbitcoin.it", true },
  { "inbounder.io", true },
  { "inbox-group.com", true },
  { "inbox.google.com", true },
  { "inboxen.org", true },
  { "incendiary-arts.com", true },
  { "inche-ali.com", true },
  { "inconcerts.de", true },
  { "incparadise.net", true },
  { "incubos.org", true },
  { "independent-operators.com", true },
  { "indesit-training.com", true },
  { "indicateurs-flash.fr", true },
  { "indiecert.net", false },
  { "indievelopment.nl", true },
  { "indigosakura.com", true },
  { "inditip.com", true },
  { "indovinabank.com.vn", true },
  { "indredouglas.me", true },
  { "indusap.com", true },
  { "indusfastremit-ca.com", true },
  { "indusfastremit-us.com", true },
  { "indusfastremit.com", true },
  { "industreiler.com", true },
  { "indybay.org", true },
  { "inebula.it", true },
  { "ineed.coffee", true },
  { "inertianetworks.com", true },
  { "inetpub.cn", true },
  { "inexpensivecomputers.net", true },
  { "infilock.com", true },
  { "infinether.net", true },
  { "infinitude.me.uk", true },
  { "infinitudecloud.com", true },
  { "infinitusgaming.eu", true },
  { "infinity-freedom.com", true },
  { "infinity-freedom.de", true },
  { "infinity-lifestyle.de", true },
  { "influxus.com", false },
  { "infmed.com", true },
  { "info-beamer.com", true },
  { "info-screen.me", true },
  { "info-screw.com", true },
  { "infocommsociety.com", true },
  { "infopier.sg", true },
  { "inforichjapan.com", true },
  { "informatiebeveiliging.nl", true },
  { "informatik-handwerk.de", true },
  { "informatik.zone", true },
  { "informnapalm.org", true },
  { "infosec.ch", true },
  { "infosec.rip", true },
  { "infosenior.ch", true },
  { "infovae-idf.com", true },
  { "infra-con.dk", false },
  { "infura.co.th", true },
  { "ingalls.run", true },
  { "ingesol.fr", true },
  { "inhaltsangabe.de", true },
  { "iniiter.com", true },
  { "inima.org", true },
  { "inios.fr", false },
  { "initq.net", true },
  { "initrd.net", true },
  { "injertoshorticolas.com", true },
  { "inkbunny.net", true },
  { "inked-guy.de", false },
  { "inksay.com", true },
  { "inkthemes.com", true },
  { "inleaked.com", true },
  { "inline-sport.cz", true },
  { "inme.ga", true },
  { "innermostparts.org", true },
  { "innoloop.com", true },
  { "innophate-security.com", true },
  { "innophate-security.nl", true },
  { "innovaptor.at", true },
  { "innovaptor.com", true },
  { "inoa8.com", true },
  { "inovatec.com", true },
  { "inquisitive.io", true },
  { "insane-bullets.com", true },
  { "insane.zone", true },
  { "insertcoins.net", true },
  { "insideaudit.com", true },
  { "insightera.co.th", true },
  { "insighti.com", true },
  { "insighti.eu", true },
  { "insighti.org", true },
  { "insighti.sk", true },
  { "insouciant.org", true },
  { "inspired-lua.org", true },
  { "inspiroinc.com", true },
  { "inspy.me", true },
  { "instagram-atom.appspot.com", true },
  { "instagrammernews.com", true },
  { "installgentoo.net", true },
  { "instant-hack.com", true },
  { "instant.io", true },
  { "instantdev.io", true },
  { "instantkhabar.com", false },
  { "instantsubs.de", true },
  { "instasex.ch", true },
  { "instela.com", true },
  { "instics.com", true },
  { "instinctiveads.com", true },
  { "institut-confucius-montpellier.org", true },
  { "institutoflordelavida.com", true },
  { "institutolancaster.com", true },
  { "institutulcultural.ro", true },
  { "instruktor.io", true },
  { "insurance321.com", true },
  { "intafe.co.jp", true },
  { "intarweb.ca", true },
  { "integraelchen.de", true },
  { "integralblue.com", true },
  { "integrationinc.com", false },
  { "integraxor.com.tw", true },
  { "integrityingovernmentidaho.com", true },
  { "integromat.com", true },
  { "intel.li", true },
  { "intelevo.com", true },
  { "intelldynamics.com", true },
  { "intellectdynamics.com", true },
  { "intencje.pl", true },
  { "interaffairs.com", true },
  { "interasistmen.se", true },
  { "interchangedesign.com", true },
  { "interchanges.io", true },
  { "intercom.com", true },
  { "intercom.io", true },
  { "interessiert-uns.net", true },
  { "interflores.com.br", true },
  { "interfug.de", true },
  { "interhosts.co.za", true },
  { "interim-cto.de", true },
  { "interisaudit.com", true },
  { "interleucina.org", true },
  { "intermedinet.nl", true },
  { "internaldh.com", true },
  { "internaut.co.za", true },
  { "internect.co.za", true },
  { "internet-pornografie.de", true },
  { "internetbank.swedbank.se", true },
  { "internetbugbounty.org", true },
  { "internetcom.jp", true },
  { "internetdentalalliance.com", true },
  { "internethering.de", true },
  { "internetofdon.gs", true },
  { "internetovehazardnihry.cz", true },
  { "internetpro.me", true },
  { "internetstaff.com", true },
  { "internetzentrale.net", true },
  { "interociter-enterprises.com", true },
  { "interracial.dating", true },
  { "interviewpipeline.co.uk", true },
  { "intervisteperstrada.com", true },
  { "interways.de", true },
  { "intheater.de", true },
  { "inthepicture.com", true },
  { "inthouse.cloud", true },
  { "intim-uslugi-kazan.net", true },
  { "intimateperrierjouet.com", true },
  { "intocities.de", false },
  { "inton.biz", true },
  { "intramanager.co.uk", true },
  { "intramanager.dk", true },
  { "intranetsec-regionra.fr", true },
  { "intranetsec.fr", true },
  { "intrasoft.com.au", true },
  { "intux.be", false },
  { "intvonline.com", true },
  { "intxt.net", true },
  { "inusasha.de", true },
  { "inuyasha-petition.tk", true },
  { "invasion.com", true },
  { "investor.gov", true },
  { "investorforms.com", true },
  { "investpay.ru", true },
  { "invictusmc.uk", true },
  { "inviosolutions.com", true },
  { "invis.net", true },
  { "invisionita.com", true },
  { "invite24.pro", true },
  { "invitescene.com", true },
  { "invoiced.com", true },
  { "invoicefinance.com", true },
  { "invoicefinance.nl", true },
  { "inwestcorp.se", true },
  { "inzdr.com", true },
  { "iocheck.com", false },
  { "iodu.re", true },
  { "ioiart.eu", true },
  { "iolife.dk", true },
  { "iompost.com", true },
  { "iomstamps.com", true },
  { "ionas-law.ro", false },
  { "ionc.ca", true },
  { "ionlabs.kr", true },
  { "ioover.net", true },
  { "iora.fr", true },
  { "iossifovlab.com", true },
  { "iotsms.io", true },
  { "ip-life.net", true },
  { "ip.or.at", true },
  { "ip2country.info", true },
  { "ip6.li", false },
  { "ipal.im", true },
  { "ipal.name", true },
  { "ipawind.com", true },
  { "ipcareers.net", true },
  { "ipcfg.me", true },
  { "ipconsulting.se", true },
  { "ipfp.pl", true },
  { "ipfs.ink", true },
  { "iphoneunlock.nu", true },
  { "iplabs.de", true },
  { "ipledgeonline.org", false },
  { "ipmotion.ca", true },
  { "ipokabu.net", true },
  { "ipomue.com", false },
  { "iprice.co.id", true },
  { "iprice.hk", true },
  { "iprice.my", true },
  { "iprice.ph", true },
  { "iprice.sg", true },
  { "iprice.vn", true },
  { "ipricethailand.com", true },
  { "iprim.ru", true },
  { "iprody.com", true },
  { "ipsec.pl", true },
  { "ipsilon-project.org", true },
  { "ipswitch.com.tw", true },
  { "iptel.ro", true },
  { "ipty.de", true },
  { "ipuservicedesign.com", true },
  { "ipv4.gr", true },
  { "ipv6-adresse.dk", true },
  { "ipv6-handbuch.de", true },
  { "ipv6.gr", true },
  { "ipv6.watch", true },
  { "ipv6cloud.club", true },
  { "ipv6vpn.net", true },
  { "iqboxy.com", true },
  { "ir-saitama.com", true },
  { "iranianlawschool.com", true },
  { "ircmett.de", true },
  { "iready.ro", true },
  { "ireef.tv", true },
  { "irgit.pl", true },
  { "iridiumbrowser.de", true },
  { "iridiumflare.de", true },
  { "iris-insa.com", true },
  { "irische-segenswuensche.info", true },
  { "irish.dating", true },
  { "irmag.ru", true },
  { "irmgard-woelfle.de", true },
  { "iron-guard.net", true },
  { "ironcarnival.com", true },
  { "irondaleirregulars.com", true },
  { "ironfistdesign.com", true },
  { "iruca.co", true },
  { "irukandjilabs.com", true },
  { "isaacman.tech", true },
  { "isaacpartnership.co.uk", true },
  { "isabellehogarth.co.uk", true },
  { "isara.com", true },
  { "isbc-telecom.ru", true },
  { "isbengrumpy.com", true },
  { "isdf.me", true },
  { "isdown.cz", true },
  { "isef-eg.com", true },
  { "iservicio.mx", true },
  { "iseulde.com", true },
  { "isgp-studies.com", true },
  { "ishangirdhar.com", true },
  { "ishillaryclintoninprisonyet.com", true },
  { "ishome.org", true },
  { "isimonbrown.co.uk", true },
  { "isincheck.com", true },
  { "isistomie.com", true },
  { "isitamor.pm", true },
  { "isitchristmas.com", true },
  { "isitcoffeetime.com", true },
  { "isitdoneyet.gov", true },
  { "isitup.org", true },
  { "iskaron.de", true },
  { "islandhosting.com", true },
  { "isletech.net", true },
  { "isntall.us", true },
  { "isocom.eu", true },
  { "isoface33.fr", true },
  { "isogen5.com", true },
  { "isogram.nl", true },
  { "isondo.com", true },
  { "isopres.de", true },
  { "ispweb.es", true },
  { "isqrl.de", true },
  { "israelbizreg.com", true },
  { "isreedyintheuk.com", true },
  { "issforum.org", true },
  { "isslshop.com", true },
  { "issuesofconcern.in", true },
  { "istanbul.systems", true },
  { "istanbultravelguide.info", true },
  { "istdieweltschonuntergegangen.de", true },
  { "isteinbaby.de", true },
  { "istgame.com", true },
  { "istheapplestoredown.com", true },
  { "istheapplestoredown.de", true },
  { "isthefieldcontrolsystemdown.com", true },
  { "istherrienstillcoach.com", true },
  { "istorrent.is", true },
  { "istschonsolangeinrente.de", true },
  { "isvbscriptdead.com", true },
  { "it-adminio.ru", true },
  { "it-fernau.com", true },
  { "it-rotter.de", true },
  { "it-schamans.de", true },
  { "it-schwerin.de", true },
  { "it-shamans.eu", true },
  { "it-sysoft.com", true },
  { "it.search.yahoo.com", false },
  { "itactiq.info", true },
  { "italia-store.com", true },
  { "italian.dating", true },
  { "itb-online.co.uk", true },
  { "itchy.nl", true },
  { "itcko.sk", true },
  { "itdashboard.gov", true },
  { "itds-consulting.com", true },
  { "itds-consulting.cz", true },
  { "iteli.eu", true },
  { "items.lv", true },
  { "iterror.co", true },
  { "itfaq.nl", true },
  { "itfh.eu", true },
  { "itfix.cz", true },
  { "itforge.nl", true },
  { "ithenrik.com", true },
  { "itilo.de", true },
  { "itinsight.hu", true },
  { "itis4u.ch", true },
  { "itludens.com", true },
  { "itneeds.tech", true },
  { "itnota.com", true },
  { "itochan.jp", true },
  { "itooky.com", true },
  { "itpol.dk", true },
  { "itpro.ua", true },
  { "itpros.ru", true },
  { "itriskltd.com", true },
  { "its-gutachten.de", true },
  { "its-schindler.de", true },
  { "its-v.de", true },
  { "its4living.com", true },
  { "itsanicedoor.co.uk", true },
  { "itsatrap.nl", false },
  { "itsecguy.com", true },
  { "itsg-faq.de", true },
  { "itsgoingdown.org", true },
  { "itshost.ru", true },
  { "itskayla.com", false },
  { "itsok.de", true },
  { "itspawned.com", true },
  { "itspersonaltraining.nl", true },
  { "itsryan.com", false },
  { "itu2015.de", true },
  { "iuscommunity.org", true },
  { "ivaoru.org", true },
  { "ivi-fertilite.fr", true },
  { "ivi-fruchtbarkeit.de", true },
  { "ivi.com.ar", true },
  { "ivi.com.pa", true },
  { "ivi.mx", true },
  { "ivi.net.br", true },
  { "ivi.pt", true },
  { "ivinet.cl", true },
  { "ivitalia.it", true },
  { "ivk.website", true },
  { "ivo.co.za", true },
  { "ivpn.net", true },
  { "iwader.co.uk", true },
  { "iwalton.com", true },
  { "iwannarefill.com", true },
  { "iwilcox.me.uk", true },
  { "iwizerunek.pl", true },
  { "iww.me", true },
  { "iww.mx", true },
  { "ix8.ru", true },
  { "ixds.org", true },
  { "ixio.cz", true },
  { "ixnext.de", true },
  { "ixquick-proxy.com", true },
  { "ixquick.co.uk", true },
  { "ixquick.com", true },
  { "ixquick.de", true },
  { "ixquick.eu", true },
  { "ixquick.fr", true },
  { "ixquick.info", true },
  { "ixquick.nl", true },
  { "izdiwho.com", true },
  { "izevg.ru", true },
  { "izolight.ch", false },
  { "izzzorgconcerten.nl", true },
  { "j-lsolutions.com", true },
  { "j-navi.com", true },
  { "j0s.at", true },
  { "j0s.eu", true },
  { "j15t98j.co.uk", true },
  { "j2ee.cz", true },
  { "j3e.de", true },
  { "ja-dyck.de", true },
  { "ja.md", true },
  { "jaaxypro.com", true },
  { "jaba.hosting", true },
  { "jabbas.eu", true },
  { "jabber.at", true },
  { "jabberfr.org", true },
  { "jabberzac.org", true },
  { "jacekowski.org", true },
  { "jackalworks.com", true },
  { "jackdelik.de", true },
  { "jackf.me", true },
  { "jackfahnestock.com", true },
  { "jackrusselterrier.com.br", true },
  { "jackyyf.com", false },
  { "jaco.by", true },
  { "jacobhaug.com", true },
  { "jacobian.org", true },
  { "jacobphono.com", true },
  { "jacuzziprozone.com", true },
  { "jadopado.com", true },
  { "jaegerlacke.de", true },
  { "jagerman.com", true },
  { "jahliveradio.com", false },
  { "jahner.xyz", true },
  { "jahofmann.de", true },
  { "jaimechanaga.com", true },
  { "jaispirit.com", true },
  { "jaitnetworking.com", false },
  { "jakarta.dating", true },
  { "jakecurtis.de", true },
  { "jakereynolds.co", true },
  { "jaketremper.com", true },
  { "jakobejitblokaci.cz", true },
  { "jakobssystems.net", true },
  { "jaksel.id", true },
  { "jaksi.io", true },
  { "jakub-boucek.cz", true },
  { "jakubboucek.cz", true },
  { "jakubtopic.cz", true },
  { "james.je", true },
  { "jamesandpame.la", true },
  { "jamesbillingham.com", true },
  { "jamesbywater.co.uk", true },
  { "jamesbywater.com", true },
  { "jamesbywater.me", true },
  { "jamesbywater.me.uk", true },
  { "jamesbywater.uk", true },
  { "jamesdoell.com", true },
  { "jamesgreenfield.com", true },
  { "jameshale.me", true },
  { "jameshost.net", true },
  { "jameshunt.us", false },
  { "jamesj.me", true },
  { "jamesknd.uk", true },
  { "jamesmilazzo.com", true },
  { "jamesrains.com", true },
  { "jamesrussellward.co.uk", true },
  { "jamessmith.me.uk", true },
  { "jameswarp.com", true },
  { "jamhost.org", true },
  { "jamielinux.com", true },
  { "jamiemagee.co.uk", true },
  { "jamiemagee.dk", true },
  { "jamiepeters.nl", true },
  { "jamon.ca", true },
  { "jamonsilva.com", true },
  { "jamourtney.com", true },
  { "jan-and-maaret.de", true },
  { "jan-cermak.cz", true },
  { "jan-roenspies.de", true },
  { "janario.me", true },
  { "jangho.me", true },
  { "jani.media", true },
  { "janik.xyz", true },
  { "jankoepsel.com", true },
  { "janoberst.com", true },
  { "janokacer.sk", true },
  { "janosh.com", true },
  { "janssenwigman.nl", true },
  { "janverlaan.nl", true },
  { "jaot.info", true },
  { "jap-nope.de", true },
  { "japan-foods.co.uk", true },
  { "japan4you.org", true },
  { "japaniac.de", true },
  { "japlex.com", true },
  { "jaqen.ch", true },
  { "jardins-utopie.net", true },
  { "jaredbates.net", false },
  { "jaredfernandez.com", true },
  { "jarl.ninja", true },
  { "jarondl.net", true },
  { "jarrettgraham.com", true },
  { "jarsater.com", true },
  { "jasonamorrow.com", true },
  { "jasoncosper.com", true },
  { "jasonian-photo.com", true },
  { "jasonrobinson.me", true },
  { "jasonsansone.com", true },
  { "jasperespejo.com", true },
  { "jasperhammink.com", true },
  { "jasperhuttenmedia.com", true },
  { "jav-collective.com", true },
  { "javachip.win", true },
  { "javalestari.com", true },
  { "javamilk.com", true },
  { "javelinsms.com", true },
  { "jayf.de", true },
  { "jayharris.ca", true },
  { "jaylen.com.ar", true },
  { "jaymecd.rocks", true },
  { "jayxon.com", true },
  { "jayxu.com", true },
  { "jazz-alliance.com", true },
  { "jazz-alliance.org", true },
  { "jazzanet.com", true },
  { "jazzinutrecht.info", true },
  { "jazzncheese.com", true },
  { "jbbd.fr", true },
  { "jbfp.dk", true },
  { "jbn.mx", true },
  { "jbradaric.me", true },
  { "jcaicedo.tk", true },
  { "jccrew.org", true },
  { "jcf-office.com", true },
  { "jcoscia.com", true },
  { "jcraft.us", true },
  { "jctf.io", true },
  { "jcwodan.nl", true },
  { "jcyz.cf", true },
  { "jd-group.co.uk", true },
  { "jd1.de", true },
  { "jdav-leipzig.de", true },
  { "jdcdirectsales.com.ph", true },
  { "jdcgroup.com.ph", true },
  { "jdh8.org", true },
  { "jdtic.com", true },
  { "jdubya.info", true },
  { "jean-remy.ch", true },
  { "jeannelucienne.fr", true },
  { "jedipedia.net", true },
  { "jedwarddurrett.com", true },
  { "jeepmafia.com", true },
  { "jeff.forsale", true },
  { "jeff393.com", true },
  { "jeffanderson.me", true },
  { "jeffcasavant.com", false },
  { "jeffersonregan.co.uk", true },
  { "jeffersonregan.com", true },
  { "jeffersonregan.net", true },
  { "jeffersonregan.org", true },
  { "jeffsanders.com", true },
  { "jefftickle.com", true },
  { "jekkt.com", true },
  { "jellow.nl", true },
  { "jelly.cz", true },
  { "jelmer.co.uk", true },
  { "jelmer.uk", true },
  { "jenjoit.de", true },
  { "jennedebleser.com", false },
  { "jennifercherniack.com", true },
  { "jennifersauer.nl", true },
  { "jennybeaned.com", true },
  { "jennythebaker.com", true },
  { "jensenbanden.no", true },
  { "jensrex.dk", true },
  { "jeproteste.info", true },
  { "jeremiahbenes.com", true },
  { "jeremyness.com", true },
  { "jerodslay.com", false },
  { "jeroendeneef.com", true },
  { "jeroenseegers.com", true },
  { "jeroenvanderwal.nl", true },
  { "jerryyu.ca", true },
  { "jesseerbach.com", true },
  { "jessevictors.com", true },
  { "jessgranger.com", true },
  { "jessicabenedictus.nl", true },
  { "jessicah.org", true },
  { "jesters-court.net", true },
  { "jesuisformidable.nl", true },
  { "jetbbs.com", true },
  { "jetkittens.co.uk", true },
  { "jetlagphotography.com", true },
  { "jetmirshatri.com", false },
  { "jetsetcharge.com", true },
  { "jetsetpay.com", true },
  { "jetsieswerda.nl", true },
  { "jettlarue.com", true },
  { "jettshome.org", true },
  { "jetwhiz.com", true },
  { "jetzt-elektromobil.de", true },
  { "jf-projects.de", false },
  { "jfreitag.de", true },
  { "jgid.de", true },
  { "jh-media.eu", false },
  { "jhalderm.com", true },
  { "jhburton.co.uk", true },
  { "jhburton.uk", true },
  { "jhejderup.me", true },
  { "jhermsmeier.de", true },
  { "jhuang.me", true },
  { "jia1hao.com", true },
  { "jiaidu.com", true },
  { "jiangzm.com", true },
  { "jichi.io", true },
  { "jie.dance", true },
  { "jikken.de", true },
  { "jimgao.tk", true },
  { "jimmehcai.com", true },
  { "jimshaver.net", true },
  { "jinancy.fr", true },
  { "jinbo123.com", false },
  { "jing.su", true },
  { "jingyuesi.com", true },
  { "jinja.ai", true },
  { "jinshuju.net", true },
  { "jira.com", true },
  { "jirav.com", true },
  { "jirav.io", true },
  { "jiripudil.cz", true },
  { "jisaku-homepage.com", true },
  { "jitsi.org", false },
  { "jiveiaktivno.bg", true },
  { "jiyuu-ni.com", true },
  { "jiyuu-ni.net", true },
  { "jjf.org.au", true },
  { "jjj.blog", true },
  { "jka.io", true },
  { "jkb.pics", true },
  { "jkbuster.com", true },
  { "jkchocolate.com", true },
  { "jkirsche.com", true },
  { "jkrippen.com", true },
  { "jlhmedia.com", true },
  { "jlkhosting.com", true },
  { "jm-bea.net", true },
  { "jmcleaning.services", true },
  { "jmdekker.it", true },
  { "jmedved.com", true },
  { "jmk.hu", true },
  { "jn1.me", true },
  { "jncde.de", true },
  { "jncie.eu", true },
  { "jncip.de", true },
  { "joakimalgroy.com", true },
  { "jobbkk.com", true },
  { "jobflyapp.com", true },
  { "jobmob.co.il", true },
  { "jobs.at", true },
  { "jobseekeritalia.it", true },
  { "jobshq.com", true },
  { "jodlajodla.si", true },
  { "joduska.me", true },
  { "jodyboucher.com", true },
  { "joe-pagan.com", true },
  { "joedavison.me", true },
  { "joehenry.co.uk", true },
  { "joelj.org", true },
  { "joepitt.co.uk", false },
  { "joerss.at", true },
  { "joestead.codes", true },
  { "jogi-server.de", true },
  { "jogorama.com.br", false },
  { "johannes-sprink.de", true },
  { "johannes.io", true },
  { "johannes.wtf", true },
  { "johnblackbourn.com", true },
  { "johnbrownphotography.ch", true },
  { "johndong.net", false },
  { "johners.me", true },
  { "johngallias.com", true },
  { "johnguant.com", true },
  { "johnhgaunt.com", true },
  { "johnmalloneemd.com", true },
  { "johnmcgovern.com", true },
  { "johnmcintosh.pro", true },
  { "johnmh.me", true },
  { "johnmichel.org", true },
  { "johnnybet.com", true },
  { "johnroach.io", true },
  { "johnsegovia.com", true },
  { "johnvanhese.nl", true },
  { "johnverkerk.com", true },
  { "jointoweb.com", true },
  { "jokewignand.nl", true },
  { "jollausers.de", true },
  { "jonarcher.info", true },
  { "jonas-thelemann.de", true },
  { "jonaskjodt.com", true },
  { "jonaswitmer.ch", true },
  { "jonathan-apps.com", true },
  { "jonathancarter.org", true },
  { "jonathandowning.uk", true },
  { "jondarby.com", true },
  { "jondevin.com", true },
  { "jonesborostatebank.com", false },
  { "jonferwerda.net", true },
  { "jonfor.net", true },
  { "jongbloed.nl", true },
  { "jonirrings.com", true },
  { "jonlabelle.com", true },
  { "jonn.me", true },
  { "jonnichols.info", true },
  { "jonnybarnes.uk", true },
  { "jonnystoten.com", true },
  { "jonoalderson.com", true },
  { "jonpads.com", true },
  { "jonsno.ws", true },
  { "joostrijneveld.nl", true },
  { "jooto.com", true },
  { "jopsens.de", true },
  { "joran.org", true },
  { "jordanhamilton.me", true },
  { "jordans.co.uk", true },
  { "jorgemesa.me", true },
  { "jornadasciberdefensa2016.es", true },
  { "jornane.me", true },
  { "jornane.nl", true },
  { "jornane.no", true },
  { "josahrens.me", true },
  { "joscares.com", true },
  { "josecage.com", true },
  { "josefjanosec.com", true },
  { "josephrees.uk", true },
  { "joshgrancell.com", false },
  { "joshharmon.me", true },
  { "joshi.su", true },
  { "joshtriplett.org", true },
  { "joshuarogers.net", true },
  { "josip.at", true },
  { "jotpics.com", true },
  { "joviam.com", true },
  { "jovic.hamburg", true },
  { "joworld.net", true },
  { "joyceclerkx.com", true },
  { "joyofcookingandbaking.com", true },
  { "joyqi.com", true },
  { "jpaglier.com", true },
  { "jpbike.cz", true },
  { "jpcdi.com", true },
  { "jpeaches.xyz", true },
  { "jpeg.io", true },
  { "jproxx.com", true },
  { "jps-selection.co.uk", true },
  { "jps-selection.com", true },
  { "jps-selection.eu", true },
  { "jr5devdoug.xyz", true },
  { "jr5devdouglas.xyz", true },
  { "jr5proxdoug.xyz", true },
  { "jrgold.me", true },
  { "jrmd.io", true },
  { "js-online.net", true },
  { "jschumacher.info", true },
  { "jslay.net", true },
  { "json-viewer.com", true },
  { "jsteward.moe", true },
  { "jstore.ch", true },
  { "jthackery.com", false },
  { "jtslay.com", true },
  { "jualssh.com", true },
  { "jubileum.online", true },
  { "juch.cc", true },
  { "juchit.at", true },
  { "judoprodeti.cz", true },
  { "juergenhecht.de", true },
  { "jugendsuenden.info", true },
  { "juhakoho.com", true },
  { "juliangonggrijp.com", true },
  { "julianmeyer.de", true },
  { "juliansimioni.com", true },
  { "julibear.com", true },
  { "julido.de", true },
  { "juliekoubova.net", true },
  { "juliemaurel.fr", true },
  { "julienc.io", true },
  { "julio.jamil.nom.br", true },
  { "jultube.de", true },
  { "jumba.com.au", true },
  { "jumbox.xyz", true },
  { "jump.bg", true },
  { "jump.wtf", true },
  { "junaos.com", true },
  { "junethack.net", true },
  { "jungaa.fr", true },
  { "junge-selbsthilfe.info", true },
  { "jungesforumkonstanz.de", true },
  { "junglist.org", true },
  { "juniwalk.cz", true },
  { "junjung.me", false },
  { "junkdrome.org", true },
  { "junqtion.com", false },
  { "jurassicbarkharrogate.co.uk", true },
  { "jurko.cz", true },
  { "jurriaan.ninja", true },
  { "just-a-clanpage.de", true },
  { "justanothercompany.name", true },
  { "justchunks.net", true },
  { "justice4assange.com", true },
  { "justinharrison.ca", true },
  { "justinho.com", true },
  { "justinlemay.com", true },
  { "justmy.website", true },
  { "justnaw.co.uk", true },
  { "justpaste.it", true },
  { "justupdate.me", true },
  { "justyy.com", true },
  { "jutella.de", true },
  { "juxstempel.de", true },
  { "juzgalo.com", true },
  { "jva-wuerzburg.de", true },
  { "jvoice.net", true },
  { "jvwdev.nl", true },
  { "jwilsson.com", true },
  { "jwilsson.me", true },
  { "jwnotifier.org", true },
  { "jym.fit", true },
  { "jyoti-fairworks.org", true },
  { "jysperm.me", true },
  { "k-dev.de", true },
  { "k-netz.de", true },
  { "k-scr.me", true },
  { "k-tube.com", true },
  { "k-wallet.com", true },
  { "k2mts.org", true },
  { "ka-clan.com", true },
  { "kaangenc.me", true },
  { "kaasbijwijn.nl", true },
  { "kab-s.de", true },
  { "kabat-fans.cz", true },
  { "kabeuchi.com", true },
  { "kabus.org", true },
  { "kachlikova2.cz", true },
  { "kackscharf.de", true },
  { "kadmec.com", true },
  { "kaffeekrone.de", true },
  { "kafoom.de", true },
  { "kaheim.de", false },
  { "kahopoon.net", true },
  { "kaileymslusser.com", true },
  { "kainz.bayern", true },
  { "kainz.be", true },
  { "kairion.de", true },
  { "kaiusaltd.com", true },
  { "kaizenreporting.com", true },
  { "kaizeronion.com", true },
  { "kajak.land", true },
  { "kakao-karten.de", true },
  { "kakaomilchkuh.de", true },
  { "kakaravaara.fi", true },
  { "kaleidomarketing.com", true },
  { "kalender.com", true },
  { "kalevlamps.co.uk", true },
  { "kaliaa.fi", true },
  { "kalian.cz", true },
  { "kall.is", true },
  { "kalmar.com", true },
  { "kaloix.de", true },
  { "kalterersee.ch", true },
  { "kamcvicit.sk", true },
  { "kamikatse.net", true },
  { "kamisama.xyz", true },
  { "kamitech.ch", true },
  { "kamixa.se", true },
  { "kana.me", true },
  { "kanaete-uranai.com", true },
  { "kanal-tv-haensch.de", true },
  { "kanar.nl", true },
  { "kandalife.com", true },
  { "kanehusky.com", true },
  { "kangarooislandholidayaccommodation.com.au", true },
  { "kaniklani.co.za", true },
  { "kanna.cf", true },
  { "kannchen.de", true },
  { "kanotijd.nl", true },
  { "kantankye.nl", true },
  { "kantanmt.com", true },
  { "kantorosobisty.pl", true },
  { "kany.me", true },
  { "kanzashi.com", true },
  { "kaohub.com", true },
  { "kap-genial.de", true },
  { "kaplatz.is", true },
  { "kapo.info", true },
  { "kappit.dk", true },
  { "kapseli.net", true },
  { "kaputt.com", true },
  { "karabijnhaken.nl", true },
  { "karachi.dating", true },
  { "karamna.com", true },
  { "karaoketonight.com", true },
  { "karateka.org", true },
  { "karateka.ru", true },
  { "karatorian.org", true },
  { "kardize24.pl", true },
  { "karguine.in", true },
  { "karhm.com", true },
  { "karhukamera.com", true },
  { "karit.nz", true },
  { "karlis-kavacis.id.lv", true },
  { "karlstabo.se", true },
  { "karmaassurance.ca", true },
  { "karmabaker.com", true },
  { "karmaflux.com", true },
  { "karmainsurance.ca", true },
  { "karmaplatform.com", true },
  { "karmaspa.se", true },
  { "karmic.com", true },
  { "karsofsystems.com", true },
  { "kartec.com", true },
  { "karting34.com", true },
  { "kartonmodellbau.org", true },
  { "kasadara.com", true },
  { "kashdash.ca", true },
  { "kashmirobserver.net", true },
  { "kasko.io", true },
  { "kassa.at", true },
  { "kat.al", true },
  { "katekligys.com", true },
  { "katericke.com", true },
  { "kati-raumplaner.de", true },
  { "katiaetdavid.fr", true },
  { "katja-nikolic-design.de", true },
  { "katka.info", true },
  { "katnunn.co.uk", true },
  { "katproxy.al", true },
  { "katproxy.online", true },
  { "katproxy.site", true },
  { "katproxy.tech", true },
  { "katproxy.top", true },
  { "kattelans.eu", true },
  { "katyl.info", true },
  { "kau-boys.com", true },
  { "kau-boys.de", true },
  { "kaufberatung.community", true },
  { "kaufkraftkiel.de", true },
  { "kavik.no", true },
  { "kavovary-kava.cz", true },
  { "kawaii.io", true },
  { "kawaiii.link", true },
  { "kawaiiku.com", true },
  { "kawaiiku.de", true },
  { "kayleen.net", true },
  { "kaylyn.ink", true },
  { "kayon.cf", true },
  { "kazandaemon.ru", true },
  { "kazenojiyu.fr", true },
  { "kb3.net", true },
  { "kba-online.de", true },
  { "kbcequitas.hu", true },
  { "kbit.dk", true },
  { "kbjorklu.com", true },
  { "kc5mpk.com", true },
  { "kcluster.io", true },
  { "kcptun.com", true },
  { "kcsordparticipation.org", true },
  { "kd-plus.pp.ua", true },
  { "kdex.de", true },
  { "kdyby.org", true },
  { "ke7tlf.us", true },
  { "keaneokelley.com", true },
  { "keaysmillwork.com", true },
  { "kedarastudios.com", true },
  { "keeleysam.com", true },
  { "keeleysam.me", true },
  { "keepa.com", true },
  { "keepclean.me", true },
  { "keepcoalintheground.org", true },
  { "keeperapp.com", true },
  { "keepersecurity.com", true },
  { "keeweb.info", true },
  { "kefaloniatoday.com", true },
  { "keganthorrez.com", true },
  { "keifel.de", true },
  { "kein-design.de", true },
  { "keinefilterblase.de", true },
  { "keisaku.org", true },
  { "keithws.net", true },
  { "keke-shop.ch", true },
  { "kekku.li", true },
  { "keksi.io", true },
  { "kekz.org", true },
  { "kellyandantony.com", true },
  { "kempkens.io", true },
  { "ken.fm", true },
  { "kendra.io", true },
  { "kendu.si", true },
  { "kengilmour.com", true },
  { "kenguntokku.jp", true },
  { "kenkoelectric.com", false },
  { "kennedy.ie", true },
  { "kenners.org", true },
  { "kennethaasan.no", true },
  { "kennethlim.me", true },
  { "kenny-peck.com", true },
  { "kenoschwalb.com", true },
  { "kentacademiestrust.org.uk", true },
  { "kentec.net", true },
  { "keops-spine.fr", true },
  { "keops-spine.us", true },
  { "kepkonyvtar.hu", true },
  { "kepler-seminar.de", true },
  { "kerem.xyz", true },
  { "kerforhome.com", true },
  { "kerijacoby.com", true },
  { "kermadec.com", true },
  { "kernel-error.de", true },
  { "kerrfrequencycombs.org", true },
  { "keskeces.com", true },
  { "kesteren.com", true },
  { "kesteren.org", true },
  { "ketosecology.co.uk", true },
  { "kevinapease.com", true },
  { "kevinbowers.me", true },
  { "kevinbusse.de", true },
  { "kevincox.ca", true },
  { "kevindekoninck.com", false },
  { "kevinmeijer.nl", true },
  { "kevinratcliff.com", true },
  { "keybase.io", true },
  { "keybored.me", true },
  { "keycdn.com", true },
  { "keyerror.com", true },
  { "keys.fedoraproject.org", true },
  { "keyserver.sexy", true },
  { "keysupport.org", true },
  { "kfbrussels.be", true },
  { "kfz-hantschel.de", true },
  { "kg-rating.com", false },
  { "kgm-irm.be", true },
  { "kgnk.ru", true },
  { "khanovaskola.cz", true },
  { "khetzal.info", true },
  { "khipu.com", true },
  { "khmath.com", true },
  { "khmb.ru", true },
  { "kiadoapartman.hu", true },
  { "kiahoriane.com", true },
  { "kialo.com", true },
  { "kiano.net", true },
  { "kiapps.ovh", true },
  { "kick-in.nl", true },
  { "kickass-proxies.org", true },
  { "kickass.al", true },
  { "kickerplaza.nl", true },
  { "kickstart.com.pk", true },
  { "kidbacker.com", true },
  { "kids-at-home.ch", true },
  { "kiebel.de", true },
  { "kiedys.net", true },
  { "kiefer-networks.de", true },
  { "kiekin.org", true },
  { "kielderweather.org.uk", true },
  { "kienlen.org", true },
  { "kiffmarks.com", true },
  { "kigmbh.com", true },
  { "kikuzuki.org", true },
  { "kilerd.me", true },
  { "kilianvalkhof.com", true },
  { "killerrobots.com", true },
  { "kilobyte22.de", true },
  { "kilogram.nl", true },
  { "kilometertje.nl", true },
  { "kimberg.co.uk", true },
  { "kimmel.com", true },
  { "kimmel.in", true },
  { "kimoota.net", true },
  { "kimpost.org", true },
  { "kinderbasar-luhe.de", true },
  { "kinderbuecher-kostenlos.de", true },
  { "kindleworth.com", true },
  { "kindlyfire.com", true },
  { "kindof.ninja", true },
  { "kingant.net", true },
  { "kinganywhere.eu", true },
  { "kingbird.me", true },
  { "kingmanhall.org", true },
  { "kingqueen.org.uk", true },
  { "kingtecservices.com", true },
  { "kini24.ru", true },
  { "kinkdr.com", true },
  { "kinkenonline.com", true },
  { "kinmunity.com", true },
  { "kinniyaonlus.com", true },
  { "kinomoto.me", true },
  { "kinomoto.ovh", true },
  { "kinsights.com", false },
  { "kinsmenhomelottery.com", true },
  { "kintawifi.com", false },
  { "kintone.com", true },
  { "kintore.tv", true },
  { "kintrip.com", true },
  { "kintzingerfilm.de", true },
  { "kiocloud.com", true },
  { "kionetworks.es", true },
  { "kipira.com", true },
  { "kiragameforum.net", true },
  { "kirara.eu", true },
  { "kirbear.com", true },
  { "kirchengemeinde-markt-erlbach.de", true },
  { "kircp.com", true },
  { "kirei.se", true },
  { "kirillpokrovsky.de", true },
  { "kirinas.com", true },
  { "kirkovsky.com", true },
  { "kirsch-gestaltung.de", true },
  { "kirschbaum.me", true },
  { "kirstenbos.ca", true },
  { "kirstin-peters.de", true },
  { "kis-toitoidixi.de", true },
  { "kisa.io", true },
  { "kiss-register.org", true },
  { "kisskiss.ch", true },
  { "kisstyle.ru", true },
  { "kisun.co.jp", true },
  { "kita.id", true },
  { "kitabgaul.com", true },
  { "kitakemon.com", true },
  { "kitchenchaos.de", true },
  { "kitestar.co.uk", true },
  { "kitk.at", true },
  { "kitsostech.com", true },
  { "kitsta.com", true },
  { "kittmedia.com", true },
  { "kjaer.io", true },
  { "kjarni.cc", true },
  { "kjarrval.is", true },
  { "kjchernov.info", true },
  { "kk-neudorf-duissern.de", true },
  { "kkaefer.com", true },
  { "kkaufmann.de", true },
  { "kki.org", true },
  { "kkovacs.eu", true },
  { "kksg.com", true },
  { "kkyy.me", true },
  { "kkzxak47.com", true },
  { "klamathrestoration.gov", true },
  { "klangnok.de", true },
  { "klares-licht.de", true },
  { "klarmobil-empfehlen.de", true },
  { "klas.or.id", true },
  { "klasfauseweh.de", true },
  { "klatschreime.de", true },
  { "klausbrinch.dk", true },
  { "klausimas.lt", true },
  { "klaver.it", true },
  { "klaxn.com", true },
  { "kle.cz", true },
  { "klebetape.de", true },
  { "kledingrekken.nl", true },
  { "kleidertauschpartys.de", true },
  { "kleine-dingen.nl", true },
  { "kleineanfragen.de", true },
  { "kleinerarchitekturfuehrer.de", true },
  { "kleinholding.com", true },
  { "klempnershop.eu", true },
  { "kleppe.co", true },
  { "kleteckova.cz", true },
  { "klickstdu.com", true },
  { "klicktojob.de", true },
  { "kliemann.me", true },
  { "klif1.nl", true },
  { "klimapartner.de", true },
  { "klimapartner.net", true },
  { "klingeletest.de", true },
  { "klinikac.co.id", false },
  { "klinknetz.de", true },
  { "klosko.net", true },
  { "kls-agency.com.ua", true },
  { "klugemedia.de", true },
  { "klunkergarten.org", true },
  { "klustekeningen.nl", true },
  { "km-net.pl", true },
  { "kmkz.jp", true },
  { "kn007.net", true },
  { "knaake.net", true },
  { "knapen.io", true },
  { "knapp.noip.me", true },
  { "kncg.pw", true },
  { "kngk-azs.ru", true },
  { "kngk-group.ru", true },
  { "kngk-transavto.ru", true },
  { "kngk.org", true },
  { "knightsblog.de", true },
  { "knightsbridgegroup.org", true },
  { "knip.ch", true },
  { "knot-store.com", true },
  { "knowledgehook.com", true },
  { "knowledgesnap.com", true },
  { "knowledgesnapsites.com", true },
  { "knthost.com", true },
  { "knygos.lt", true },
  { "ko-sys.com", true },
  { "kodak-ism.com", true },
  { "kodakit.com", true },
  { "kodokushi.fr", true },
  { "koebbes.de", true },
  { "koenvdheuvel.me", false },
  { "koerper-wie-seele.de", false },
  { "koerperimpuls.ch", true },
  { "koertner-muth.com", true },
  { "koertner-muth.de", true },
  { "koethen-markt.de", true },
  { "koezmangal.ch", true },
  { "kofler.info", true },
  { "kohlistkool.tk", true },
  { "koho.fi", true },
  { "koi-sama.net", true },
  { "kojima-life.co.jp", true },
  { "kojipkgs.fedoraproject.org", true },
  { "kokenmetaanbiedingen.nl", true },
  { "kokensupport.com", true },
  { "koketteriet.se", true },
  { "kokumoto.com", true },
  { "kolaykaydet.com", false },
  { "kolba.design", true },
  { "koldanews.com", true },
  { "kollawat.me", true },
  { "kolmann.at", true },
  { "kolmann.eu", true },
  { "koluke.co", true },
  { "koluke.com", true },
  { "komandakovalchuk.com", false },
  { "komget.net", false },
  { "komicloud.com", true },
  { "komidoc.com", true },
  { "komiksbaza.pl", true },
  { "komischkeszeug.de", true },
  { "kommune42.org", true },
  { "komoju.com", true },
  { "kompetenzkurs.de", true },
  { "kon-sil.de", true },
  { "konata.us", true },
  { "kondou-butsudan.com", true },
  { "kongar.org", true },
  { "koniecfica.sk", true },
  { "konijntjes.nl", true },
  { "konklone.com", true },
  { "konkurs.ba", true },
  { "konsertoversikt.no", true },
  { "kontakthuman.hu", true },
  { "kontaxis.org", true },
  { "koop-bremen.de", true },
  { "koordinate.net", true },
  { "koot.nl", true },
  { "kopfkrieg.org", true },
  { "kopfsalat.eu", false },
  { "kopular.com", true },
  { "korea.dating", true },
  { "koretech.nl", true },
  { "korinar.com", true },
  { "kornersafe.com", true },
  { "korobi.io", true },
  { "korobkovsky.ru", true },
  { "korrelzout.nl", true },
  { "korsanparti.org", true },
  { "kortgebyr.dk", true },
  { "kosho.org", true },
  { "kostya.net", false },
  { "kotelezobiztositas.eu", true },
  { "kotilinkki.fi", true },
  { "kotitesti.fi", true },
  { "kotonehoko.net", true },
  { "kotovstyle.ru", true },
  { "kottur.is", true },
  { "koukni.cz", true },
  { "kourpe.online", true },
  { "kovnsk.net", true },
  { "kozmik.co", true },
  { "kozuch.biz", true },
  { "kpdyer.com", true },
  { "kpebetka.net", true },
  { "kpinvest.eu", true },
  { "kprog.net", true },
  { "kpumuk.info", true },
  { "kpvpn.com", true },
  { "kpx1.de", true },
  { "krachtinverbinding.nl", true },
  { "kradalby.no", true },
  { "kraft.im", true },
  { "kraftfleisch.de", true },
  { "kraga.sk", true },
  { "kraiwan.com", true },
  { "kraiwon.com", true },
  { "kraken.io", true },
  { "kralik.io", true },
  { "kralik.xyz", true },
  { "kramsj.uk", true },
  { "krang.org.uk", true },
  { "krasota.ru", false },
  { "krasovsky.me", true },
  { "kravelindo-adventure.com", false },
  { "kraynik.com", true },
  { "krayx.com", true },
  { "krc.link", true },
  { "kream.io", true },
  { "kreationnext.com", true },
  { "kreativstrecke.de", true },
  { "kreb.io", true },
  { "kredietpaspoort.nl", true },
  { "kredite.sale", true },
  { "kredite24.de", true },
  { "kreditkacs.cz", true },
  { "kreen.org", true },
  { "kriechel.de", true },
  { "kriegskindernothilfe.de", true },
  { "kriegt.es", true },
  { "kriptosec.com", true },
  { "krislamoureux.com", true },
  { "krisstarkey.co.uk", true },
  { "kristikala.nl", true },
  { "kristinbailey.com", true },
  { "kristjanrang.eu", true },
  { "kristofferkoch.com", true },
  { "krizek.cc", true },
  { "krizevackapajdasija.hr", true },
  { "krizevci.info", true },
  { "krk-media.pl", false },
  { "krmela.com", true },
  { "krmeni.cz", true },
  { "kroetenfuchs.de", true },
  { "kromonos.net", true },
  { "krony.de", true },
  { "kroodle.nl", true },
  { "kroon.email", true },
  { "kropkait.pl", true },
  { "krupa.net.pl", false },
  { "krutka.cz", true },
  { "kruu.de", true },
  { "krypsys.com", true },
  { "krypteia.org", true },
  { "kryptera.se", true },
  { "kryptomech.com", true },
  { "kryx.de", true },
  { "ks-watch.de", true },
  { "kschv-rdeck.de", true },
  { "ksfh-mail.de", true },
  { "kshlm.in", true },
  { "kstan.me", true },
  { "kswriter.com", true },
  { "ku.io", true },
  { "kualo.co.uk", true },
  { "kualo.com", true },
  { "kualo.in", true },
  { "kuaza.com", true },
  { "kub.hr", true },
  { "kubik-rubik.de", false },
  { "kubusadvocaten.nl", true },
  { "kuchentraum.eu", true },
  { "kuehndel.org", true },
  { "kuehnel-bs.de", true },
  { "kuehnel.org", true },
  { "kuemmerlin.eu", true },
  { "kuemmling.eu", true },
  { "kujadin.de", true },
  { "kukal.cz", true },
  { "kuketz-blog.de", true },
  { "kuketz-security.de", true },
  { "kulde.net", true },
  { "kultmobil.se", true },
  { "kum.com", true },
  { "kumachan.biz", true },
  { "kumalog.com", true },
  { "kumasanda.jp", true },
  { "kundenerreichen.com", true },
  { "kundenerreichen.de", true },
  { "kunstundunrat.de", true },
  { "kuoruan.com", true },
  { "kuponrazzi.com", true },
  { "kupschke.net", true },
  { "kura.io", true },
  { "kurehun.org", true },
  { "kurofuku.me", true },
  { "kurswahl-online.de", true },
  { "kurz.pw", true },
  { "kuschelmikroben.de", true },
  { "kuschelmonster.de", true },
  { "kuschelmonstershop.de", true },
  { "kuschelviren.de", true },
  { "kuschku.de", true },
  { "kutukupret.com", true },
  { "kuwago.io", true },
  { "kvalita-1a.cz", true },
  { "kvetinymilt.cz", true },
  { "kvhile.com", false },
  { "kwbresidential.com", true },
  { "kwidz.fr", true },
  { "kwikmed.eu", false },
  { "kwmr.me", true },
  { "kwok.cc", true },
  { "kwok.tv", true },
  { "kwondratsch.com", true },
  { "kxind.cn", true },
  { "kyanite.co", true },
  { "kybi.sk", true },
  { "kydara.com", true },
  { "kykoonn.net", true },
  { "kylelaker.com", true },
  { "kyliehunt.com", true },
  { "kylinj.com", true },
  { "kylling.io", true },
  { "kymo.org", true },
  { "kynaston.org.uk", true },
  { "kynastonwedding.co.uk", true },
  { "kyochon.fr", true },
  { "kyosaku.org", true },
  { "kyujin-office.net", true },
  { "kyy.me", true },
  { "kzjnet.com", true },
  { "kzsdabas.hu", true },
  { "l-lab.org", true },
  { "l2guru.ru", true },
  { "l4n-clan.de", true },
  { "la-cave-a-nodo.fr", true },
  { "la-flora-negra.de", true },
  { "la-grande-jaugue.fr", true },
  { "labfox.de", true },
  { "labourreedevergheas.fr", true },
  { "labradorpuppiesforsalebyregisteredlabradorbreeders.com", true },
  { "labrat.mobi", true },
  { "labs.directory", true },
  { "lacasa.fr", true },
  { "lacasabelucci.com", true },
  { "lacasseroy.com", true },
  { "lacaverne.nl", true },
  { "lacentral.com", false },
  { "lacicloud.net", true },
  { "lacledeslan.com", false },
  { "lacledeslan.ninja", true },
  { "lacliniquefinanciere.com", true },
  { "lacyc3.eu", true },
  { "laextra.mx", true },
  { "lafeemam.fr", true },
  { "lafillepolyvalente.ca", true },
  { "lafillepolyvalente.com", true },
  { "lafka.org", true },
  { "lafkor.de", true },
  { "lafosseobservatoire.be", true },
  { "lafr4nc3.xyz", true },
  { "lagarderob.ru", false },
  { "lagerauftrag.info", true },
  { "lagier.xyz", true },
  { "laglab.org", true },
  { "lagoza.name", true },
  { "laguiadelvaron.com", true },
  { "laguinguette.fr", true },
  { "lainchan.org", true },
  { "lajijonencadebarbera.com", true },
  { "lak-berlin.de", true },
  { "lakatrop.com", true },
  { "lakewoodcomputerservices.com", true },
  { "lakhesis.net", true },
  { "lalaya.fr", true },
  { "lamaland.ru", true },
  { "lamapoll.de", true },
  { "lambda-complex.org", true },
  { "lamboo.be", true },
  { "laminine.info", true },
  { "lampegiganten.dk", true },
  { "lampegiganten.no", true },
  { "lampen24.be", true },
  { "lampenwelt.at", true },
  { "lampenwelt.ch", true },
  { "lan2k.org", true },
  { "lana.swedbank.se", true },
  { "lanboll.com", true },
  { "lanbyte.se", true },
  { "lancehoteis.com", true },
  { "lancehoteis.com.br", true },
  { "lancejames.com", true },
  { "lancork.net", true },
  { "land.nrw", false },
  { "landgoedverkopen.nl", true },
  { "landhuisverkopen.nl", true },
  { "landofelves.net", true },
  { "langatang.com", true },
  { "langbein.org", true },
  { "langendries.eu", true },
  { "langguth.io", true },
  { "langly.fr", true },
  { "languageterminal.com", true },
  { "langworth.com", true },
  { "laniakean.com", true },
  { "lansechensilu.com", true },
  { "lansinoh.co.uk", true },
  { "lantian.pub", true },
  { "lanuovariviera.it", true },
  { "lanyang.tk", true },
  { "lanzainc.xyz", true },
  { "laobox.fr", true },
  { "laos.dating", true },
  { "lapetition.be", true },
  { "lapidge.net", true },
  { "laplanetebleue.com", true },
  { "lapolla.com", true },
  { "laposte.net", true },
  { "largescaleforums.com", true },
  { "largeviewer.com", true },
  { "larptreff.de", true },
  { "larrysalibra.com", true },
  { "lars-ewald.com", true },
  { "lars-mense.de", true },
  { "larsklene.nl", true },
  { "larsmerke.de", true },
  { "lasercloud.ml", true },
  { "lasereyess.net", true },
  { "laserpc.net", true },
  { "lasnaves.com", true },
  { "lasst-uns-beten.de", true },
  { "lastchancetraveler.com", true },
  { "lastpass.com", false },
  { "late.am", true },
  { "latelierdekathy.com", true },
  { "latenitefilms.com", false },
  { "lateralsecurity.com", true },
  { "latetrain.cn", true },
  { "lathamlabs.com", true },
  { "lathamlabs.net", true },
  { "lathamlabs.org", true },
  { "latino.dating", true },
  { "latinphone.com", true },
  { "latinred.com", true },
  { "latitude42technology.com", true },
  { "latrine.cz", true },
  { "lattyware.co.uk", true },
  { "lattyware.com", true },
  { "laufseminare-laufreisen.com", true },
  { "lauftrainer-ausbildung.com", true },
  { "lauftreff-himmelgeist.de", true },
  { "laughinggrapepublishing.com", true },
  { "laukstein.com", true },
  { "launchkey.com", true },
  { "laurel4th.org", true },
  { "laurelblack.com", true },
  { "laureltv.org", true },
  { "lauriuc.sk", true },
  { "laussat.de", true },
  { "lavabit.no", true },
  { "lavalite.de", true },
  { "laventainnhotel-mailing.com", true },
  { "lavinya.net", false },
  { "lavita.de", true },
  { "lavoieducoeur.be", true },
  { "lavoiepharmd.com", true },
  { "lavval.com", true },
  { "lawformt.com", true },
  { "lawly.org", true },
  { "lawrencemurgatroyd.com", true },
  { "layer8.tk", true },
  { "laylo.nl", true },
  { "layoutsatzunddruck.de", true },
  { "lazerus.net", true },
  { "lazowik.pl", true },
  { "lazurit.com", true },
  { "lb-toner.de", true },
  { "lbayer.com", true },
  { "lbihrhelpdesk.com", true },
  { "lbrt.xyz", true },
  { "lbs-logics.com", true },
  { "lca-pv.de", true },
  { "lcti.biz", true },
  { "ld-begunjscica.si", true },
  { "ldarby.me.uk", true },
  { "ldc.com.br", false },
  { "le-bar.org", true },
  { "le-dev.de", false },
  { "le-h.de", true },
  { "le-hosting.de", true },
  { "le42mars.fr", true },
  { "leadbook.ru", true },
  { "leadership9.com", true },
  { "leadingsalons.com", true },
  { "leakedminecraft.net", true },
  { "leakforums.net", true },
  { "leakreporter.net", true },
  { "leaks.directory", true },
  { "leanclub.org", true },
  { "leandre.cn", true },
  { "leanplando.com", true },
  { "leaodarodesia.com.br", true },
  { "leardev.de", false },
  { "learnedovo.com", true },
  { "learnflakes.net", true },
  { "learningorder.com", true },
  { "learntube.cz", true },
  { "leatherfurnitureexpo.com", true },
  { "leaversmith.com", true },
  { "lebal.se", true },
  { "lebanesearmy.gov.lb", true },
  { "lebarmy.gov.lb", true },
  { "lebihan.pl", true },
  { "leblanc.io", true },
  { "lecourtier.fr", true },
  { "ledgerscope.net", false },
  { "ledhouse.sk", true },
  { "lee-fuller.co.uk", true },
  { "leedev.org", true },
  { "leen.io", true },
  { "leerliga.de", true },
  { "leertipp.de", true },
  { "leesilvey.com", true },
  { "leetsaber.com", true },
  { "lefebvristes.com", true },
  { "lefebvristes.fr", true },
  { "leftclick.cloud", true },
  { "lega-dental.com", true },
  { "legalrobot-uat.com", true },
  { "legalrobot.com", true },
  { "legaltip.eu", true },
  { "legendary.camera", true },
  { "legendofkrystal.com", false },
  { "legends-game.ru", true },
  { "legible.es", true },
  { "legoutdesplantes.be", true },
  { "lehighmathcircle.org", true },
  { "leibniz-remscheid.de", true },
  { "leifdreizler.com", false },
  { "leighneithardt.com", true },
  { "leilonorte.com", true },
  { "leiming.co", true },
  { "leisure-blog.com", true },
  { "lel.ovh", true },
  { "lellyboi.ml", true },
  { "lemarcheelagrandeguerra.it", true },
  { "lemoine.at", true },
  { "lemuslimpost.com", true },
  { "lence.net", true },
  { "lenders.direct", true },
  { "lengzzz.com", true },
  { "leninalbertop.com.ve", true },
  { "lenn1.de", true },
  { "lennier.info", true },
  { "lennyobez.be", true },
  { "lenuagebauche.org", true },
  { "lenzw.de", true },
  { "leola.cz", true },
  { "leola.sk", true },
  { "leominstercu.com", false },
  { "leonard.io", false },
  { "leonardcamacho.me", true },
  { "leonax.net", true },
  { "leondenard.com", true },
  { "leonhooijer.nl", true },
  { "leonklingele.de", true },
  { "leonmahler.consulting", true },
  { "leopoldina.net", true },
  { "lep.gov", true },
  { "lepont.pl", true },
  { "leppis-it.de", true },
  { "leprado.com", true },
  { "lerasenglish.com", true },
  { "lereporter.ma", true },
  { "lerku.com", true },
  { "lernorteuropa.com", true },
  { "lernorteuropa.de", true },
  { "lernorteuropa.eu", true },
  { "lerp.me", true },
  { "les-corsaires.net", true },
  { "lesdouceursdeliyana.com", true },
  { "leseditionsbraquage.com", true },
  { "lesformations.net", true },
  { "lesharris.com", true },
  { "lesliekearney.com", true },
  { "lesnet.co.uk", true },
  { "lesperlesdunet.fr", true },
  { "lesquerda.cat", true },
  { "lesscloud.com", true },
  { "lessing.consulting", true },
  { "let-go.cc", true },
  { "leticiagomeztagle.com", true },
  { "letitfly.me", true },
  { "lets.ninja", true },
  { "letsencrypt-for-cpanel.com", true },
  { "letsgame.nl", true },
  { "letstox.com", true },
  { "lettersblogatory.com", true },
  { "lettori.club", true },
  { "letustravel.tk", true },
  { "leu.to", true },
  { "leuthardtfamily.com", true },
  { "levans.fr", true },
  { "levendwater.org", true },
  { "levert.ch", true },
  { "levindesalpes.fr", false },
  { "levinus.de", true },
  { "lew.im", true },
  { "lewis.li", true },
  { "lewisjuggins.co.uk", true },
  { "lewislaw.com", true },
  { "lexico.pt", true },
  { "lexicography.online", true },
  { "lexway.pk", true },
  { "lfgss.com", true },
  { "lg21.co", true },
  { "lhalbert.xyz", true },
  { "lhasaapso.com.br", true },
  { "li-ke.co.jp", true },
  { "liamjack.fr", true },
  { "liangji.com.tw", false },
  { "lianye.in", true },
  { "lianye1.cc", true },
  { "lianye2.cc", true },
  { "lianye3.cc", true },
  { "lianye4.cc", true },
  { "lianye5.cc", true },
  { "lianye6.cc", true },
  { "lianyexiuchang.in", true },
  { "liaoshuma.com", true },
  { "libanco.com", true },
  { "libbitcoin.org", true },
  { "libble.eu", true },
  { "libertas-tech.com", true },
  { "libertyrp.org", true },
  { "libfte.org", true },
  { "libnull.com", true },
  { "libraryextension.com", true },
  { "libraryfreedomproject.org", false },
  { "libreboot.org", true },
  { "librechan.net", true },
  { "libreduca.com", true },
  { "librelamp.com", true },
  { "librends.org", true },
  { "librervac.org", true },
  { "libscode.com", false },
  { "libskia.so", true },
  { "libsodium.org", true },
  { "liceserv.com", true },
  { "lichess.org", true },
  { "lichtspot.de", true },
  { "lichttraeumer.de", true },
  { "liderwalut.pl", false },
  { "lidl-selection.at", true },
  { "lidl-shop.be", true },
  { "lidl-shop.nl", true },
  { "lidl-tour.ro", true },
  { "lidlovajogurteka.si", true },
  { "lidong.me", true },
  { "lidow.eu", true },
  { "liduan.com", true },
  { "liduan.net", true },
  { "liebel.org", true },
  { "lifanov.com", true },
  { "life-time.nl", true },
  { "lifebetweenlives.com.au", true },
  { "lifekiss.ru", true },
  { "lifi.digital", true },
  { "lifi.is", true },
  { "liftie.info", true },
  { "light.mail.ru", true },
  { "lightarmory.com", true },
  { "lightcloud.com", true },
  { "lighting-centres.co.uk", true },
  { "lightme.us", true },
  { "lightpaste.com", true },
  { "lightpics.net", true },
  { "lights.co.uk", true },
  { "lightspeed.com", false },
  { "lighttp.com", true },
  { "lijero.co", true },
  { "likeablehub.com", true },
  { "likeabox.de", true },
  { "likeaross.com", false },
  { "lila.pink", true },
  { "liliang13.com", true },
  { "lillepuu.com", true },
  { "lilpwny.com", true },
  { "lily-inn.com", true },
  { "lim-light.com", true },
  { "limawi.io", true },
  { "limeyeti.com", true },
  { "limiteddata.co.uk", true },
  { "limitededitioncomputers.com", true },
  { "limitededitionsolutions.com", true },
  { "limix.com", true },
  { "limpens.net", true },
  { "limpid.nl", true },
  { "limpido.it", true },
  { "lincolnwayflorist.com", true },
  { "linden.me", true },
  { "lindeskar.se", true },
  { "lingerie.com.br", true },
  { "lingolia.com", true },
  { "lingotaxi.com", true },
  { "lingros-test.tk", true },
  { "linguamilla.com", true },
  { "linguatrip.com", false },
  { "lingvo-svoboda.ru", true },
  { "link-sanitizer.com", true },
  { "link.ba", true },
  { "linkages.org", true },
  { "linkenheil.org", true },
  { "linklocker.co", true },
  { "linkmaker.co.uk", true },
  { "linkonaut.net", true },
  { "linksanitizer.com", true },
  { "linley.de", true },
  { "linno.me", true },
  { "linode.com", false },
  { "linorman1997.me", true },
  { "linost.com", true },
  { "linpx.com", true },
  { "linqhost.nl", true },
  { "linss.com", true },
  { "lintmx.com", true },
  { "linux-admin-california.com", true },
  { "linux-florida.com", true },
  { "linux-mint.cz", true },
  { "linux.army", true },
  { "linux.cn", true },
  { "linux.fi", true },
  { "linuxandstuff.de", true },
  { "linuxbabe.com", false },
  { "linuxbierwanderung.com", true },
  { "linuxcommand.ru", true },
  { "linuxfixed.it", true },
  { "linuxforyou.com", true },
  { "linuxgeek.ro", true },
  { "linuxhostsupport.com", true },
  { "linuxlounge.net", true },
  { "linuxmint.cz", true },
  { "linuxwebservertips.in", true },
  { "linvx.org", true },
  { "linx.li", true },
  { "linx.net", true },
  { "linzgau.de", true },
  { "lionlyrics.com", true },
  { "liornavok.com", true },
  { "liquid.cz", true },
  { "liquid.solutions", true },
  { "liquidcomm.net", true },
  { "liquidhost.co", true },
  { "liquorsanthe.in", true },
  { "lirion.de", true },
  { "liris-beautywelt.de", true },
  { "lisaco.de", true },
  { "lislan.org.uk", true },
  { "listahu.org", true },
  { "lister-kirchweg.de", true },
  { "listminut.be", true },
  { "lists.fedoraproject.org", true },
  { "lists.mayfirst.org", false },
  { "lists.stg.fedoraproject.org", true },
  { "litchidova.nl", true },
  { "litespeed.io", true },
  { "litevault.net", true },
  { "litfin.name", true },
  { "lithesalar.se", true },
  { "little.pw", true },
  { "littlefreelibrary.org", true },
  { "littleswitch.co.jp", true },
  { "litvideoserver.de", true },
  { "litz.ca", true },
  { "litzenberger.ca", true },
  { "liuboznaiko.eu", true },
  { "liud.im", true },
  { "liudon.org", true },
  { "liukang.tech", true },
  { "livecards.co.uk", true },
  { "livedemo.io", true },
  { "livedesign.at", true },
  { "liveforspeed.se", true },
  { "livej.am", true },
  { "livejasmin.dk", true },
  { "livekaarten.be", true },
  { "livekaarten.nl", true },
  { "livekort.dk", true },
  { "livekort.se", true },
  { "liveregistratie.nl", true },
  { "liverewrite.com", true },
  { "liverpoolmutualhomes.org", false },
  { "living-space.co.nz", true },
  { "livingworduk.org", true },
  { "livnev.me", true },
  { "livnev.xyz", true },
  { "livolett.de", true },
  { "lixingcong.com", false },
  { "lizardsystems.com", true },
  { "lizhi.io", true },
  { "ljs.io", true },
  { "lkummer.cz", true },
  { "llamacuba.com", true },
  { "lloyd-day.me", true },
  { "lm-pumpen.de", true },
  { "lmddgtfy.net", true },
  { "lmerza.com", true },
  { "lmintlcx.com", true },
  { "lmkts.com", true },
  { "lmmtfy.io", true },
  { "lmsptfy.com", true },
  { "lmtm.eu", true },
  { "lnoldan.com", true },
  { "lntu.org", true },
  { "lnx.li", true },
  { "loacg.com", true },
  { "loadlow.me", true },
  { "loadso.me", true },
  { "loancompare.co.za", true },
  { "loansonline.today", true },
  { "loanstreet.be", true },
  { "loanstreet.nl", true },
  { "lobosdomain.no-ip.info", true },
  { "lobste.rs", true },
  { "localbandz.com", true },
  { "localbitcoins.com", true },
  { "localblock.co.za", true },
  { "localchum.com", true },
  { "localdrive.me", true },
  { "localhorst.xyz", true },
  { "localnetwork.nz", true },
  { "localspot.pl", true },
  { "locauxrama.fr", true },
  { "locchat.com", true },
  { "lockify.com", true },
  { "lockpick.nl", true },
  { "lockpicks.se", true },
  { "locomore.com", true },
  { "lodash.com", false },
  { "loenshotel.de", true },
  { "loforo.com", true },
  { "loftboard.eu", true },
  { "lofttravel.com", true },
  { "log.my", true },
  { "logaldeveloper.com", true },
  { "loganmarchione.com", true },
  { "logario.com.br", true },
  { "logement-saisonnier.com", true },
  { "logentries.com", false },
  { "logfile.at", true },
  { "logicaladvertising.com", true },
  { "logicio.ch", false },
  { "logicio.de", false },
  { "logicio.net", false },
  { "logicsale.com", true },
  { "logicsale.de", true },
  { "logicsale.fr", true },
  { "logicsale.it", true },
  { "login.corp.google.com", true },
  { "login.gov", true },
  { "login.launchpad.net", true },
  { "login.persona.org", true },
  { "login.sapo.pt", true },
  { "login.ubuntu.com", true },
  { "login.xero.com", false },
  { "login.yahoo.com", false },
  { "loginseite.com", true },
  { "logistify.com.mx", true },
  { "lognot.net", true },
  { "logopaediereinhard.de", true },
  { "logopoeia.com", true },
  { "lojadoprazer.com.br", true },
  { "lojix.com", true },
  { "lokaal.org", true },
  { "loli.bz", true },
  { "loli.pet", true },
  { "lolicon.eu", true },
  { "lolicore.ch", true },
  { "lolkot.ru", true },
  { "lolmegafroi.de", true },
  { "lolpatrol.de", true },
  { "lolpatrol.wtf", true },
  { "lona.io", true },
  { "lonal.com", true },
  { "lonasdigital.com", true },
  { "london-transfers.com", true },
  { "london.dating", true },
  { "londonlanguageexchange.com", true },
  { "lone-gunman.be", true },
  { "lonerwolf.com", true },
  { "longboarding-ulm.de", true },
  { "longhorn.id.au", true },
  { "look-at-my.site", true },
  { "look.co.il", true },
  { "lookasik.eu", true },
  { "lookastic.co.uk", true },
  { "lookastic.com", true },
  { "lookastic.de", true },
  { "lookastic.es", true },
  { "lookastic.fr", true },
  { "lookastic.mx", true },
  { "lookastic.ru", true },
  { "looktothestars.org", true },
  { "lookyman.net", true },
  { "loongsg.xyz", true },
  { "loony.info", true },
  { "loophost.com.br", false },
  { "loopower.com", true },
  { "loopstart.org", true },
  { "loothole.com", true },
  { "loqu8.com", true },
  { "lordjevington.co.uk", true },
  { "lore.azurewebsites.net", true },
  { "lorenadumitrascu.ro", true },
  { "losless.fr", true },
  { "lost.host", true },
  { "lostg.com", true },
  { "lostinsecurity.com", true },
  { "lostinweb.eu", true },
  { "lostserver.com", true },
  { "loteks.de", true },
  { "lothai.re", false },
  { "lottosonline.com", true },
  { "loucanfixit.com", true },
  { "louiewatch.com", true },
  { "louisvillevmug.info", true },
  { "loune.net", true },
  { "love-schna.jp", true },
  { "loveable.de", true },
  { "loveandadoreboutique.com", true },
  { "loveismore.de", true },
  { "loveismore.es", true },
  { "loveismore.eu", true },
  { "loveismore.fr", true },
  { "loveismore.it", true },
  { "loveismore.org", true },
  { "loveismore.pl", true },
  { "loveismore.ru", true },
  { "loveismore.sk", true },
  { "loveisourweapon.com", true },
  { "lovelifelovelive.com", true },
  { "lovelivewiki.com", true },
  { "lovemomiji.com", true },
  { "loveph.one", true },
  { "lover-bg.com", true },
  { "loveto.at", true },
  { "loveyounastya.com", true },
  { "lovingearth.co", true },
  { "lovingearth.net", true },
  { "lovizaim.ru", true },
  { "lowhangingfruitgrabber.com", true },
  { "lowmagnitude.com", true },
  { "lowsec.space", true },
  { "lowsidetna.com", true },
  { "loxis.be", true },
  { "lpak.nl", true },
  { "lpbk-bethel.de", false },
  { "lpm-uk.com", true },
  { "lrhsclubs.com", true },
  { "lrhstsa.com", true },
  { "lrssystems.com", true },
  { "ls-alarm.de", true },
  { "lsc-dillingen.de", true },
  { "ltba.org", true },
  { "ltbytes.com", false },
  { "ltecode.com", true },
  { "ltn-tom-morel.fr", true },
  { "lubot.net", false },
  { "lucasantarella.com", true },
  { "lucaterzini.com", true },
  { "luce.life", true },
  { "luchscheider.de", true },
  { "lucidframeworks.com", true },
  { "lucidlight.de", true },
  { "lucidlogs.com", true },
  { "lucielavickova.com", true },
  { "lucyparsonslabs.com", true },
  { "lucysan.net", true },
  { "ludikovsky.name", true },
  { "ludwig.im", true },
  { "ludwiggrill.de", true },
  { "luehne.de", true },
  { "luelistan.net", true },
  { "lugbb.org", true },
  { "luis-checa.com", true },
  { "luisv.me", true },
  { "lukas-oppermann.de", true },
  { "lukas-schauer.de", true },
  { "lukas.im", true },
  { "lukas2511.de", true },
  { "lukasberan.com", true },
  { "lukasberan.cz", true },
  { "lukasoppermann.com", true },
  { "lukasoppermann.de", true },
  { "lukasunger.cz", true },
  { "lukasunger.net", true },
  { "lukaszdolan.com", true },
  { "lukasztkacz.com", true },
  { "luke.ch", true },
  { "lukeng.me", true },
  { "lukeng.net", true },
  { "luludapomerania.com", true },
  { "lumd.me", true },
  { "lumiere.com", true },
  { "lunakit.org", true },
  { "lunapps.com", true },
  { "lunarift.com", true },
  { "lunarlog.com", true },
  { "lunarrift.net", true },
  { "lunarshark.com", true },
  { "lunarsoft.net", true },
  { "lunchbunch.me", true },
  { "luneta.nearbuysystems.com", false },
  { "lungdoc.us", true },
  { "lunix.io", true },
  { "luno.io", true },
  { "luoe.me", true },
  { "luoe.ml", true },
  { "luoh.cc", true },
  { "luoh.me", true },
  { "luohua.im", true },
  { "luom.net", true },
  { "luongvu.com", true },
  { "luripump.se", true },
  { "lustige-zitate.com", true },
  { "lustin.fr", true },
  { "lustrum.ch", true },
  { "luukdebruincv.nl", true },
  { "luukklene.nl", true },
  { "luuppi.fi", true },
  { "luxe-it.co.uk", true },
  { "luxsci.com", true },
  { "luxusnivoucher.cz", true },
  { "luxusnyvoucher.sk", true },
  { "luxvacuos.net", true },
  { "luxwatch.com", true },
  { "luzat.com", true },
  { "luzfaltex.com", true },
  { "lv0.it", true },
  { "lvmoo.com", true },
  { "lvrsystems.com", true },
  { "lwl-foej-bewerbung.de", true },
  { "lwl.moe", true },
  { "lwl12.com", true },
  { "lydia-und-simon.de", true },
  { "lyfbits.com", true },
  { "lymia.moe", true },
  { "lynero.dk", true },
  { "lyness.io", true },
  { "lynkos.com", true },
  { "lynthium.com", true },
  { "lynx.nl", true },
  { "lynxbroker.de", true },
  { "lyonl.com", true },
  { "lyst.co.uk", true },
  { "lyx.dk", true },
  { "lzzr.me", true },
  { "m-edmondson.co.uk", true },
  { "m-plan.com", true },
  { "m.facebook.com", false },
  { "m.mail.ru", true },
  { "m0wef.uk", true },
  { "m132.eu", true },
  { "m2epro.com", true },
  { "m2os.com", true },
  { "m2tc.fr", true },
  { "ma2t.com", true },
  { "maartenterpstra.xyz", true },
  { "mac1.net", true },
  { "macbolo.com", true },
  { "macchaberrycream.com", true },
  { "macchedil.com", false },
  { "macdj.tk", true },
  { "mach-politik.ch", true },
  { "machbach.com", true },
  { "machon.biz", false },
  { "machtweb.de", true },
  { "macinyasha.net", true },
  { "macker.io", true },
  { "mackey7.net", true },
  { "maclemon.at", true },
  { "macleod.io", true },
  { "macnemo.de", true },
  { "maco.org.uk", true },
  { "macoun.de", true },
  { "maddi.biz", true },
  { "madebyshore.com", true },
  { "madeglobal.com", true },
  { "madeitwor.se", true },
  { "madin.ru", true },
  { "madnetwork.org", true },
  { "madokami.net", true },
  { "madrants.net", true },
  { "madreacqua.org", true },
  { "madtec.de", true },
  { "madusecurity.com", true },
  { "mae-berlinistanbul.com", true },
  { "maelstrom.ninja", true },
  { "maestrano.com", true },
  { "mafamane.com", true },
  { "maff.scot", false },
  { "mafiaforum.de", true },
  { "mafiasi.de", true },
  { "magdic.eu", true },
  { "magenbrot.net", true },
  { "magenda.sk", true },
  { "magia360.com", true },
  { "magicball.co", true },
  { "magicbroccoli.de", true },
  { "magilio.com", true },
  { "magnacumlaude.co", true },
  { "magneticanvil.com", true },
  { "magnets.jp", true },
  { "mahamed91.pw", true },
  { "mahefa.co.uk", true },
  { "mahfouzadedimeji.com", true },
  { "mahrer.net", true },
  { "maidofhonorcleaning.net", true },
  { "mail-rotter.de", true },
  { "mail-settings.google.com", true },
  { "mail.de", true },
  { "mail.google.com", true },
  { "mail.yahoo.com", false },
  { "mail4you.in", true },
  { "mailbox.org", true },
  { "mailchuck.com", true },
  { "mailer-dot.de", true },
  { "mailfence.com", true },
  { "mailgarant.nl", true },
  { "mailhost.it", true },
  { "mailinabox.email", true },
  { "mailing-femprendedores.com", true },
  { "mailing-jbgg.com", true },
  { "maillady-susume.com", true },
  { "mailmag.net", true },
  { "mailon.ga", true },
  { "mailpenny.com", true },
  { "mainframeserver.space", true },
  { "mainlined.org", true },
  { "mainlywrenches.co", true },
  { "mainzelmaennchen.net", true },
  { "maisgasolina.com", true },
  { "majaweb.cz", true },
  { "majemedia.com", true },
  { "majesnix.org", true },
  { "make-pizza.info", true },
  { "makedin.net", true },
  { "makeitdynamic.com", true },
  { "makeuplove.nl", true },
  { "makeyourank.com", true },
  { "makeyourlaws.org", true },
  { "makkusu.photo", true },
  { "makowitz.cz", true },
  { "maktoob.search.yahoo.com", false },
  { "malamutedoalasca.com.br", true },
  { "malash.me", true },
  { "malaysia.search.yahoo.com", false },
  { "malaysian.dating", true },
  { "maldiverna.guide", true },
  { "malena.com.ua", true },
  { "malfait.nl", true },
  { "malibubeachrecoverycenter.com", true },
  { "malinator.net", false },
  { "malinheadview.ie", true },
  { "maliskovik.si", true },
  { "maljaars-fotografie.nl", true },
  { "maljaars-media.nl", true },
  { "malkaso.com.ua", true },
  { "mall.cz", true },
  { "mall.hr", true },
  { "mall.hu", true },
  { "mall.pl", true },
  { "mall.sk", true },
  { "mallner.me", true },
  { "malnex.de", true },
  { "maltes.website", true },
  { "malware.watch", true },
  { "malwarekillers.com", true },
  { "malwaretips.com", true },
  { "malwre.io", true },
  { "mammaw.com", true },
  { "mammeitalianeavienna.com", true },
  { "mammooc.org", true },
  { "mammothmail.com", true },
  { "mammothmail.net", true },
  { "mammothmail.org", true },
  { "man3s.jp", true },
  { "manaboutahor.se", false },
  { "manage.cm", true },
  { "manage.zenpayroll.com", false },
  { "manage4all.com", true },
  { "manage4all.de", true },
  { "manageall.de", true },
  { "manageforall.com", true },
  { "manageforall.de", true },
  { "management-companie.ro", true },
  { "management-ethics.com", true },
  { "managementboek.nl", true },
  { "managemynetsuite.com", true },
  { "manageprojects.com", true },
  { "manager.linode.com", false },
  { "managewp.org", true },
  { "manantial.mx", true },
  { "mandala-ausmalbilder.de", true },
  { "manesht.ir", true },
  { "manfredimatteo.com", true },
  { "manhattanchoralensemble.org", true },
  { "maniadeprazer.com.br", true },
  { "manicode.com", true },
  { "manja-und-martin.de", true },
  { "manoirdecontres.com", true },
  { "manowarus.com", true },
  { "mansdell.net", true },
  { "mansfieldplacevt.com", true },
  { "mantor.org", false },
  { "manuel-herrmann.de", true },
  { "manueli.de", true },
  { "manufacturing.gov", false },
  { "manuth.life", true },
  { "manyue.org", true },
  { "maomaofuli.vip", true },
  { "maosensanguentadasdejesus.net", true },
  { "maowtm.org", true },
  { "maozedong.red", true },
  { "map4erfurt.de", true },
  { "map4jena.de", true },
  { "mapletime.com", true },
  { "mapresidentielle.fr", true },
  { "marbinvest.com", true },
  { "marble.com", true },
  { "marbogardenlidkoping.se", true },
  { "marc-schlagenhauf.de", true },
  { "marcdorka.de", true },
  { "marcel-preuss.de", true },
  { "marcelpreuss.de", true },
  { "marcelsiegert.com", true },
  { "marco-polo-reisen.com", true },
  { "marcoececilia.it", true },
  { "marcofinke.de", true },
  { "marcohager.de", true },
  { "marcoslater.com", true },
  { "marcschlagenhauf.de", true },
  { "marcush.de", true },
  { "mareklecian.cz", true },
  { "margagriesser.de", true },
  { "margaretrosefashions.co.uk", true },
  { "marianatherapy.com", true },
  { "mariannematthew.com", true },
  { "mariaolesen.dk", true },
  { "marie-curie.fr", true },
  { "marie.club", true },
  { "mariehane.com", true },
  { "mariemiramont.fr", true },
  { "marikafranke.de", true },
  { "marilsnijders.nl", true },
  { "marinazarza.es", true },
  { "marine.gov", true },
  { "marinela.com.mx", true },
  { "marinelausa.com", true },
  { "marines-shop.com", true },
  { "mariushubatschek.de", true },
  { "mariviolin.com", true },
  { "mark-a-hydrant.com", true },
  { "mark-semmler.de", true },
  { "markaconnor.com", true },
  { "markcp.me", true },
  { "markepps.com", true },
  { "market.android.com", true },
  { "marketespace.fr", true },
  { "marketingdesignu.cz", true },
  { "marketio.co", true },
  { "marketnsight.com", true },
  { "markhaehnel.de", false },
  { "markido.com", true },
  { "markoh.co.uk", true },
  { "markom.rs", true },
  { "markorszulak.com", true },
  { "markprof.ru", true },
  { "markri.nl", false },
  { "marksill.com", true },
  { "marksouthall.com", true },
  { "markt-heiligenstadt.de", true },
  { "marktcontact.com", true },
  { "marktissink.nl", false },
  { "markusehrlicher.de", true },
  { "markuskeppeler.no-ip.biz", true },
  { "markusueberallassetmanagement.de", true },
  { "marlen.cz", true },
  { "marmotte.love", true },
  { "marquiseclub.se", true },
  { "marriage-shrine.jp", true },
  { "marriottvetcareers.com", false },
  { "marsanvet.com", true },
  { "marsatapp.com", true },
  { "marsble.com", true },
  { "marshut.net", true },
  { "martelange.ovh", true },
  { "martensmxservice.nl", true },
  { "martialc.be", true },
  { "martiestrimsalon.nl", true },
  { "martin-smith.info", true },
  { "martine.nu", true },
  { "martinec.co.uk", true },
  { "martinkup.cz", true },
  { "martinkus.eu", true },
  { "martinmuc.de", true },
  { "martinp.no", true },
  { "martinreed.net", true },
  { "martins.im", true },
  { "martinsfamilyappliance.com", false },
  { "martonmihaly.hu", true },
  { "maru-life.com", true },
  { "maruhoi.com", true },
  { "masa-yoga.com", true },
  { "masa.li", true },
  { "mascosolutions.com", true },
  { "maservant.net", true },
  { "masiniunelte.store.ro", true },
  { "maskinkultur.com", true },
  { "maskt.pw", true },
  { "massdrop.com", true },
  { "masse.org", true },
  { "massivum.de", false },
  { "massoni.pl", true },
  { "massot.eu", true },
  { "massotherapeutique.com", true },
  { "mastellone.us", true },
  { "master-net.org", true },
  { "masterdemolitioninc.com", true },
  { "masterdigitale.com", true },
  { "masterhaus.bg", true },
  { "masters.black", true },
  { "mastiffingles.com.br", true },
  { "mastimtibetano.com", true },
  { "matanz.de", true },
  { "matchneedle.com", true },
  { "materialism.com", true },
  { "mathembedded.com", true },
  { "mathhire.org", true },
  { "mathiasbynens.be", true },
  { "mathiasgarbe.de", true },
  { "mathieuguimond.com", true },
  { "mathieui.net", true },
  { "matrict.com", true },
  { "matrip.de", true },
  { "matrixcheats.net", true },
  { "matsuz.com", true },
  { "matt.tf", true },
  { "mattandreko.com", true },
  { "mattandyana.com", true },
  { "matteomarescotti.it", true },
  { "matterconcern.com", true },
  { "mattfin.ch", true },
  { "matthecat.com", true },
  { "matthewgrill.com", false },
  { "matthewkenny.co.uk", true },
  { "matthewohare.com", true },
  { "matthi.coffee", true },
  { "matthias-muenzner.de", true },
  { "matthiasadler.info", true },
  { "matthiasschwab.de", true },
  { "mattia98.org", true },
  { "mattli.us", true },
  { "mattmccutchen.net", true },
  { "mattwservices.co.uk", true },
  { "matze.co", true },
  { "maultrom.ml", true },
  { "maupiknik.com", true },
  { "mauriciog.com.ar", true },
  { "mauricioghiorzi.com.ar", true },
  { "mausi.co", true },
  { "mavenclinic.com", true },
  { "mavensecurity.com", true },
  { "maveris.com", true },
  { "mawe.red", true },
  { "mawidabp.com", true },
  { "mawidaca.com", true },
  { "max-moeglich.de", true },
  { "max.gov", true },
  { "maxbytes.nl", false },
  { "maxfox.me", true },
  { "maxhoechtl.at", true },
  { "maxima.at", true },
  { "maximdeboiserie.be", true },
  { "maximeferon.fr", true },
  { "maximelouet.me", true },
  { "maximilian-graf.de", true },
  { "maximilian-greger.com", true },
  { "maximiliankrieg.de", true },
  { "maxmilton.com", true },
  { "maxr1998.de", true },
  { "maxserver.com", true },
  { "maxtruxa.com", true },
  { "maxwell-english.co.jp", false },
  { "maxwellflynn.com", true },
  { "mayerbrownllz.com", true },
  { "mazda-mps.de", true },
  { "mazz-tech.com", true },
  { "mb-is.info", true },
  { "mbaestlein.de", true },
  { "mbasic.facebook.com", false },
  { "mbilker.us", true },
  { "mbinf.de", false },
  { "mbinformatik.de", false },
  { "mblankhorst.nl", true },
  { "mbp.banking.co.at", false },
  { "mbrooks.info", true },
  { "mbsec.net", true },
  { "mbweir.com", true },
  { "mc-venture.net", false },
  { "mc81.com", true },
  { "mcadmin.net", true },
  { "mcard.vn", true },
  { "mcatnnlo.org", true },
  { "mcb-bank.com", true },
  { "mcc.re", true },
  { "mccarty.io", true },
  { "mccrackon.com", true },
  { "mcdonalds.be", true },
  { "mcdonalds.design", true },
  { "mcdonaldwhsl.com", false },
  { "mce.eu", true },
  { "mce.nyc", true },
  { "mce55.eu", true },
  { "mcea-hld.jp", true },
  { "mceconferencecentre.eu", true },
  { "mcgarderen.nl", true },
  { "mchopkins.net", true },
  { "mchristopher.com", true },
  { "mcjackk77.com", true },
  { "mckinley.school", false },
  { "mckinley1.com", false },
  { "mcl.gg", true },
  { "mclab.su", false },
  { "mclist.it", true },
  { "mcnext.net", true },
  { "mcooperlaw.com", true },
  { "mcpart.land", true },
  { "mcrn.jp", true },
  { "mcsniper.co", true },
  { "mctherealm.net", true },
  { "mcuong.tk", false },
  { "mcyukon.com", true },
  { "md5file.com", true },
  { "md5hashing.net", true },
  { "mdcloudpracticesolutions.com", true },
  { "mdcloudps.com", true },
  { "mdek.at", true },
  { "mdewendt.de", true },
  { "mdkr.nl", true },
  { "mdma.net", true },
  { "mdmed.clinic", true },
  { "mdns.eu", true },
  { "mdpraha.cz", true },
  { "mdwftw.com", true },
  { "mdx.no", true },
  { "mdxn.org", true },
  { "me.net.nz", true },
  { "meadowviewfarms.org", true },
  { "mealgoo.com", true },
  { "meanevo.com", true },
  { "meap.xyz", true },
  { "mebio.us", false },
  { "mecenat-cassous.com", true },
  { "mechanixdirect.co.uk", false },
  { "mechmk1.me", true },
  { "med-otzyv.ru", true },
  { "medallia.io", true },
  { "medba.se", true },
  { "meddelare.com", true },
  { "medexpress.co.uk", true },
  { "medi-link.co.il", true },
  { "media-instance.ru", true },
  { "mediaarea.net", true },
  { "mediaburst.co.uk", true },
  { "mediadex.be", true },
  { "medialab.nrw", true },
  { "mediamag.am", true },
  { "mediamarkt.pl", true },
  { "mediaselection.eu", true },
  { "mediastorm.us", true },
  { "mediawiki.org", true },
  { "mediawikicn.org", true },
  { "medic-world.com", true },
  { "medicinesfast.com", false },
  { "medicinia.com.br", true },
  { "medicoresponde.com.br", true },
  { "medienservice-fritz.de", true },
  { "medifi.com", true },
  { "medirich.co", true },
  { "meditek-dv.ru", true },
  { "medium.com", true },
  { "medm-test.com", true },
  { "medo64.com", true },
  { "medovea.ru", true },
  { "medpics.com", true },
  { "medtehnika.ua", true },
  { "medusa.wtf", true },
  { "medy-me.com", true },
  { "medzinenews.com", true },
  { "meedoenhartvanwestbrabant.nl", true },
  { "meedoennoordkop.nl", false },
  { "meet.google.com", true },
  { "meetbot.fedoraproject.org", true },
  { "meetfinch.com", true },
  { "meetingmanage.nl", true },
  { "meetingmanager.ovh", true },
  { "meetmibaby.co.uk", true },
  { "mega-feeling.de", true },
  { "mega.co.nz", true },
  { "mega.nz", true },
  { "mega.online", true },
  { "megablogging.org", true },
  { "megadrol.com", true },
  { "megaflowers.ru", true },
  { "megakiste.de", true },
  { "megamisja.pl", true },
  { "meganreel.com", true },
  { "megaplan.cz", true },
  { "megaplan.ru", true },
  { "megaplonk.com", true },
  { "megasslstore.com", true },
  { "meghudson.com", true },
  { "megumico.net", true },
  { "mehmetince.net", true },
  { "mehostdd.com", true },
  { "mehrwert.de", true },
  { "meifrench.com", true },
  { "meikan.moe", true },
  { "meillard-auto-ecole.ch", true },
  { "mein-webportal.de", true },
  { "meincloudspeicher.de", true },
  { "meine-email-im.net", true },
  { "meinebo.it", true },
  { "meizufans.eu", true },
  { "melangebrasil.com", true },
  { "melaniegruber.de", true },
  { "melbourne.dating", true },
  { "melcher.it", true },
  { "meldcode-assistent.nl", true },
  { "melearning.university", true },
  { "meledia.com", true },
  { "melf.nl", true },
  { "melhoresdominios.com", true },
  { "melhoresdominios.net", true },
  { "melhorproduto.com.br", true },
  { "melissaadkins.com", true },
  { "melitopol.co.ua", true },
  { "melnikov.ch", true },
  { "melodrom.de", true },
  { "melody-lyrics.com", true },
  { "melted.me", true },
  { "melted.pw", true },
  { "melvinlow.com", true },
  { "memberpress.com", true },
  { "members-only-shopping.com", true },
  { "members.nearlyfreespeech.net", false },
  { "memdoc.org", true },
  { "meme.institute", true },
  { "memeblast.ninja", true },
  { "memo-linux.com", true },
  { "menchez.me", true },
  { "menielias.com", true },
  { "mensagemaniversario.com.br", true },
  { "mensagemdaluz.com", true },
  { "mentalhealth.gov", true },
  { "mentax.net", false },
  { "mentiq.az", true },
  { "mentorithm.com", true },
  { "mentz.info", true },
  { "menudrivetest.com", true },
  { "menuonlineordering.com", true },
  { "menzel-motors.com", true },
  { "menzietti.it", true },
  { "meow.cloud", true },
  { "meozcraft.com", false },
  { "mercadobitcoin.com.br", true },
  { "mercadobitcoin.net", true },
  { "mercamaris.es", true },
  { "merccorp.de", true },
  { "mercuryamericas.com", false },
  { "mercurystorm.co.za", true },
  { "meredithkm.info", true },
  { "meritz.rocks", true },
  { "merkel.me", true },
  { "meronberry.jp", true },
  { "merson.me", true },
  { "mertcangokgoz.com", true },
  { "mescaline.com", true },
  { "mesicka.com", true },
  { "mesvt.com", true },
  { "meta-db.com", true },
  { "meta.sc", true },
  { "metadatawiki.com", true },
  { "metaether.net", true },
  { "metalsculpture.co.uk", true },
  { "metapeen.nl", true },
  { "metasyntactic.xyz", true },
  { "meteenonline.nl", true },
  { "meteobox.co", true },
  { "meteobox.cz", true },
  { "meteobox.de", true },
  { "meteobox.es", true },
  { "meteobox.fr", true },
  { "meteobox.mx", true },
  { "meteobox.pl", true },
  { "meteobox.sk", true },
  { "meteorapp.space", true },
  { "meteosherbrooke.com", false },
  { "meteosky.net", true },
  { "meter.md", true },
  { "metis.pw", true },
  { "metricaid.com", true },
  { "metrobriefs.com", true },
  { "metronaut.de", true },
  { "metsasta.com", true },
  { "metzgerei-birkenhof.de", true },
  { "meuemail.pro", true },
  { "meusigno.com", true },
  { "mevs.cz", true },
  { "mexbt.com", true },
  { "mexican.dating", true },
  { "mexicansbook.ru", false },
  { "mexior.nl", true },
  { "meyeraviation.com", true },
  { "meyercloud.de", true },
  { "mfcatalin.com", true },
  { "mfiles.pl", true },
  { "mfxbe.de", true },
  { "mgdigital.fr", true },
  { "mghiorzi.com.ar", true },
  { "mgrossklaus.de", true },
  { "mh-bloemen.co.jp", true },
  { "mhealthdemocamp.com", true },
  { "mheistermann.de", true },
  { "mhermans.nl", true },
  { "mhjuma.com", true },
  { "mhx.pw", true },
  { "mia.to", true },
  { "miagexport.com", true },
  { "miasarafina.de", true },
  { "micbase.com", true },
  { "michael-rigart.be", true },
  { "michaelcullen.name", true },
  { "michaeleichorn.com", true },
  { "michaelleibundgut.com", true },
  { "michaelmorpurgo.com", true },
  { "michaelpfrommer.de", true },
  { "michaelrigart.be", true },
  { "michaelscrivo.com", true },
  { "michaelsulzer.com", true },
  { "michaeltroger.com", true },
  { "michaeltruskowski.com", true },
  { "michaelwaite.org", true },
  { "michal-kral.cz", true },
  { "michalborka.cz", true },
  { "michalkral.tk", true },
  { "michalspacek.cz", true },
  { "michalwiglasz.cz", true },
  { "michasfahrschule.com", true },
  { "michel-wein.de", true },
  { "michelledonelan.co.uk", true },
  { "michiganunionoptout.com", true },
  { "miconcinemas.com", true },
  { "microco.sm", true },
  { "microdots.de", true },
  { "microlog.org", true },
  { "microme.ga", true },
  { "microtalk.org", true },
  { "microvb.com", true },
  { "midair.io", true },
  { "midirs.org", true },
  { "midlandgate.de", true },
  { "midlgx.com", true },
  { "midonet.org", true },
  { "miegl.cz", true },
  { "miemie.jp", true },
  { "mig5.net", true },
  { "mightydicks.io", true },
  { "mightydicks.tech", true },
  { "mightymillionsraffle.com", true },
  { "migrator.co", true },
  { "migueldemoura.com", true },
  { "miguelmoura.com", true },
  { "mihnea.net", true },
  { "mijn-email.org", true },
  { "mijnetickets.nl", true },
  { "mijnkredietpaspoort.nl", true },
  { "mijnreisoverzicht.nl", true },
  { "mijnstembureau.nl", true },
  { "mijntransacties.nl", true },
  { "mika.moe", true },
  { "mikadesign.se", false },
  { "mikadoe.nl", true },
  { "mikaela.info", true },
  { "mikalikes.men", true },
  { "mike-bland.com", true },
  { "mikecb.org", true },
  { "mikek.work", true },
  { "mikeology.org", true },
  { "mikepair.net", true },
  { "mikes.tk", true },
  { "miketabor.com", true },
  { "mikewest.org", true },
  { "mikewillia.ms", true },
  { "mikeybot.com", true },
  { "mikii.club", true },
  { "miknight.com", true },
  { "mikonmaa.fi", true },
  { "mikori.sk", true },
  { "mikroskeem.eu", true },
  { "mil0.com", true },
  { "milahendri.com", true },
  { "milang.xyz", true },
  { "milanpala.cz", true },
  { "milatrans.pl", true },
  { "milcoresonline.com", true },
  { "milldyke.com", true },
  { "millenniumweb.com", true },
  { "millistream.com", true },
  { "millstep.de", true },
  { "milonga.tips", true },
  { "mim.properties", true },
  { "mimeit.de", true },
  { "mimemo.io", true },
  { "mimocad.io", true },
  { "mimovrste.com", true },
  { "minami.xyz", true },
  { "mind-hochschul-netzwerk.de", true },
  { "mind-moves.es", true },
  { "mind.sh", true },
  { "mindbodycontinuum.com", true },
  { "mindcoding.ro", true },
  { "mindcraft.ga", true },
  { "mindwerks.net", true },
  { "mine.world", true },
  { "minecraft-forum.cf", true },
  { "minecraft-forum.ga", true },
  { "minecraft-forum.gq", true },
  { "minecraft-forum.ml", true },
  { "minecraft-forums.cf", true },
  { "minecraft-forums.ga", true },
  { "minecraft-forums.gq", true },
  { "minecraftforum.de", true },
  { "minecraftforum.ovh", true },
  { "minecraftforums.cf", true },
  { "minecraftforums.gq", true },
  { "minecraftforums.ml", true },
  { "minecraftvoter.com", true },
  { "minecrell.net", true },
  { "minenash.com", true },
  { "mineover.es", true },
  { "minepay.net", true },
  { "minesouls.fr", true },
  { "minez-nightswatch.com", false },
  { "minf3-games.de", true },
  { "mingram.net", true },
  { "minh.at", true },
  { "minhanossasenhora.com.br", true },
  { "mini-piraten.de", true },
  { "mini2.fi", true },
  { "minikneet.com", true },
  { "minimvc.com", true },
  { "minipainting.net", true },
  { "minis-hip.de", true },
  { "miniskipper.at", true },
  { "minitruckin.net", true },
  { "minitrucktalk.com", true },
  { "minkondom.nu", true },
  { "minnesotadata.com", true },
  { "minobar.com", true },
  { "minora.io", true },
  { "minoris.se", true },
  { "minpingvin.dk", true },
  { "mintea-noua.ro", true },
  { "mintrak2.com", true },
  { "minux.info", true },
  { "mipiaci.co.nz", true },
  { "mipiaci.com.au", true },
  { "mipla.ch", true },
  { "miragrow.com", true },
  { "miraheze.org", true },
  { "miraidenshi.com", true },
  { "mireservaonline.es", true },
  { "mirkofranz.de", true },
  { "mirodasilva.be", true },
  { "mironet.cz", true },
  { "mirtes.cz", true },
  { "mirucon.com", true },
  { "misakiya.co.jp", true },
  { "misconfigured.io", true },
  { "misiondelosangeles-mailing.com", true },
  { "miskatonic.org", true },
  { "misoji-resist.com", true },
  { "miss-inventory.co.uk", true },
  { "missdream.org", true },
  { "mission-orange.de", true },
  { "missip.nl", true },
  { "misskey.xyz", true },
  { "missoy.me", true },
  { "missrain.tw", true },
  { "mist.ink", true },
  { "mistacms.com", true },
  { "mister.hosting", true },
  { "mistreaded.com", true },
  { "misupport.dk", true },
  { "mit-uns.org", true },
  { "mita.me", true },
  { "mitarbeiter-pc.de", true },
  { "mitnetz-gas.de", true },
  { "mitnetz-strom.de", true },
  { "mitrecaasd.org", true },
  { "mitremai.org", true },
  { "mitsign.com", true },
  { "mitsukabose.com", true },
  { "mittelunsachlich.de", true },
  { "mittenhacks.com", true },
  { "mitzpettel.com", true },
  { "miui-germany.de", true },
  { "mivcon.net", true },
  { "mixposure.com", true },
  { "mixtape.moe", true },
  { "miyatore.com", true },
  { "mizd.at", true },
  { "mizque.ch", true },
  { "mjacobson.net", true },
  { "mjanja.ch", true },
  { "mjcaffarattilaw.com", true },
  { "mjec.net", true },
  { "mkasu.org", true },
  { "mkcert.org", true },
  { "mkoppmann.at", true },
  { "mkp-deutschland.de", true },
  { "mkpef.org", true },
  { "mktemp.org", true },
  { "mkuznets.com", true },
  { "mkw.st", true },
  { "mlcdn.co", true },
  { "mlcnfriends.com", true },
  { "mlemay.com", true },
  { "mlp.ee", true },
  { "mlpepilepsy.org", true },
  { "mlrslateroofing.com.au", true },
  { "mlsrv.de", true },
  { "mlvbphotography.com", true },
  { "mm13.at", true },
  { "mm404.com", true },
  { "mma-acareporting.com", true },
  { "mmalisz.com", true },
  { "mmbb.org", true },
  { "mmin.us", true },
  { "mmmm.com", true },
  { "mmonit.com", true },
  { "mmucha.de", true },
  { "mncloud.de", true },
  { "mnd.sc", true },
  { "mnium.de", true },
  { "mnmt.no", true },
  { "mnsure.org", true },
  { "mnt-tech.fr", true },
  { "mnwt.nl", true },
  { "moar.so", true },
  { "mobaircon.com", true },
  { "mobal.com", true },
  { "mobeforlife.com", true },
  { "mobidea.com", true },
  { "mobilcom-debitel-empfehlen.de", true },
  { "mobilcom-debitel.de", true },
  { "mobile.eti.br", true },
  { "mobile.united.com", false },
  { "mobile.usaa.com", false },
  { "mobilekey.co", true },
  { "mobileread.com", true },
  { "mobilesector.de", true },
  { "mobiletraff.co", true },
  { "mobilewikiserver.com", true },
  { "mobilinnov.it", true },
  { "mobility-events.ch", true },
  { "mobilpass.no", true },
  { "mobilux.lv", true },
  { "mobio.net", true },
  { "mobisaar-cloud.de", true },
  { "mobix5.com", true },
  { "mobobe.com", true },
  { "mockmyapp.com", true },
  { "mocloud.eu", true },
  { "modafinil.com", true },
  { "modded-minecraft-server-list.com", true },
  { "moddedark.com", true },
  { "mode-individuell.de", true },
  { "modecaso.com", true },
  { "modelcase.co.jp", false },
  { "modelcube.com", true },
  { "modeldimension.com", true },
  { "modernapprenticeships.org", true },
  { "modernibytovytextil.cz", true },
  { "modifiedmind.com", true },
  { "modistry.com", true },
  { "modmountain.com", true },
  { "modx.io", true },
  { "modydev.club", true },
  { "moe.pe", true },
  { "moe4sale.in", true },
  { "moechel.com", true },
  { "moefactory.com", true },
  { "moefi.xyz", true },
  { "moegirl.org", true },
  { "moehrke.cc", true },
  { "moevenpick-cafe.com", true },
  { "moho.kr", true },
  { "mojaknjiznica.com", false },
  { "mojapraca.sk", true },
  { "mojzis.com", true },
  { "mojzis.cz", true },
  { "mojzisova.com", true },
  { "mokadev.com", true },
  { "mokhtarmial.com", false },
  { "mokote.com", true },
  { "molb.org", true },
  { "molinero.xyz", true },
  { "mols.me", true },
  { "molun.net", true },
  { "momentumdash.com", true },
  { "mommel.com", true },
  { "mommelonline.de", true },
  { "momozeit.de", true },
  { "momut.org", true },
  { "mon-agenda.org", false },
  { "mon-partage.fr", true },
  { "mona-dress.com", true },
  { "monautoneuve.fr", true },
  { "mondedie.fr", true },
  { "mondwandler.de", true },
  { "moneromerchant.com", true },
  { "moneycrownmedia.com", true },
  { "moneygo.se", true },
  { "moneyhouse.de", true },
  { "monika-sokol.de", true },
  { "moniquedekermadec.com", true },
  { "monitaure.io", true },
  { "monitman.solutions", true },
  { "monitzer.com", true },
  { "monix.io", true },
  { "monkeydust.net", true },
  { "monnyonle.hu", true },
  { "monobank.no", true },
  { "monolithapps.com", true },
  { "monolithinteractive.com", true },
  { "monpc-pro.fr", true },
  { "monstrus.de", true },
  { "montanacures.org", true },
  { "montand.com", true },
  { "montarfotoaki.com", true },
  { "montazer.net", true },
  { "montenero.pl", true },
  { "montonicms.com", true },
  { "moo.la", true },
  { "moobo.co.jp", true },
  { "moobo.xyz", true },
  { "moodfoods.com", true },
  { "moon.lc", true },
  { "moonagic.com", true },
  { "moonless.net", true },
  { "moonloupe.com", true },
  { "moonraptor.co.uk", true },
  { "moonraptor.com", true },
  { "moonshyne.org", true },
  { "moonvpn.org", true },
  { "mooselook.de", true },
  { "moovablestorage.com", true },
  { "moparcraft.com", true },
  { "moparcraft.net", true },
  { "moparcraft.org", true },
  { "moparisthebest.biz", true },
  { "moparisthebest.com", true },
  { "moparisthebest.info", true },
  { "moparisthebest.net", true },
  { "moparisthebest.org", true },
  { "moparscape.net", true },
  { "mople71.cz", true },
  { "mor.cloud", true },
  { "mor.gl", true },
  { "morbatex.com", true },
  { "morbitzer.de", false },
  { "moreapp.co.uk", true },
  { "morenci.ch", true },
  { "morethanadream.lv", true },
  { "morfitronik.pl", true },
  { "morganestes.com", true },
  { "morganino.eu", true },
  { "morganino.it", true },
  { "moritz-baestlein.de", true },
  { "moriz.de", true },
  { "morningcalculation.com", true },
  { "morninglory.com", true },
  { "mornings.com", true },
  { "morotech.com.br", true },
  { "morteruelo.net", true },
  { "moscow.dating", true },
  { "mosfet.cz", true },
  { "mosstier.com", true },
  { "mostlyharmless.at", true },
  { "mostwuat.com", true },
  { "motd.ch", true },
  { "motherbase.io", true },
  { "mothereff.in", false },
  { "motionfreight.com", true },
  { "motorbiketourhanoi.com", true },
  { "mottvd.com", true },
  { "moulinaparoles.ca", true },
  { "mountainactivitysection.org.uk", true },
  { "mountainadventureseminars.com", true },
  { "mountainroseherbs.com", true },
  { "movabletype.net", true },
  { "moveek.com", true },
  { "movember.com", false },
  { "movepin.com", true },
  { "movie4kto.site", true },
  { "moviedollars.com", true },
  { "movinglogistics.nl", false },
  { "movlib.org", true },
  { "moylen.eu", true },
  { "moyoo.net", true },
  { "mozart-game.cz", true },
  { "mozartgame.cz", true },
  { "mozoa.net", true },
  { "mozzilla.cz", true },
  { "mp3gratuiti.com", true },
  { "mp3juices.is", true },
  { "mpc-hc.org", true },
  { "mpcompliance.com", true },
  { "mpetroff.net", true },
  { "mpintaamalabanna.it", true },
  { "mplant.io", true },
  { "mplicka.cz", true },
  { "mplusm.eu", true },
  { "mpreserver.com", false },
  { "mpserver12.org", true },
  { "mpsgarage.com.au", true },
  { "mqas.net", true },
  { "mr-hosting.com", true },
  { "mrdani.net", true },
  { "mrdayman.com", false },
  { "mremallin.ca", true },
  { "mrhee.com", true },
  { "mrinalpurohit.in", true },
  { "mrizzio.com", true },
  { "mrmoregame.de", true },
  { "mrserge.lv", true },
  { "ms-alternativ.de", true },
  { "msa-aesch.ch", true },
  { "mscc.org", true },
  { "msebera.cz", true },
  { "msh100.uk", true },
  { "msiegmund.com", true },
  { "msmails.de", true },
  { "mssys.de", true },
  { "mstiles92.com", true },
  { "msuna.net", true },
  { "msv-limpezas.pt", true },
  { "mt.me.uk", true },
  { "mt2414.com", true },
  { "mtamaki.com", true },
  { "mtasa.com", true },
  { "mtau.com", true },
  { "mtg-tutor.de", true },
  { "mthode.org", true },
  { "mths.be", false },
  { "mticareportal.com", true },
  { "mtn.cc", true },
  { "mtnz.co.za", true },
  { "mtouch.facebook.com", false },
  { "mtr.md", true },
  { "muabannhanh.com", false },
  { "muckingabout.eu", true },
  { "muehlemann.net", true },
  { "muenzubi.de", true },
  { "muevetumundo.com.mx", true },
  { "muguayuan.com", true },
  { "muk-kobetsu.com", true },
  { "muling.lu", true },
  { "multibit.org", true },
  { "multigamecard.com", true },
  { "multigeist.de", true },
  { "multimarques.com", true },
  { "multiplayernow.com", true },
  { "multiplexcy.com", true },
  { "multitheftauto.com", true },
  { "multiworldsoftware.com", true },
  { "mumei.space", true },
  { "mundodasmensagens.com", true },
  { "mundschenk.at", true },
  { "munduch.cz", true },
  { "munki.org", true },
  { "munkiepus.com", true },
  { "munuc.org", true },
  { "muonium.ch", true },
  { "murdercube.com", true },
  { "murfy.nz", true },
  { "murgi.de", true },
  { "muriburi.land", true },
  { "muriburiland.com", true },
  { "murraycoin.org", true },
  { "muscleangels.com", true },
  { "museminder2.com", true },
  { "musewearflipflops.com", true },
  { "mush-room.co.jp", true },
  { "mushikabu.net", true },
  { "mushroomandfern.com", true },
  { "musi.cx", true },
  { "music-project.eu", true },
  { "music.amazon.com", true },
  { "musicchris.de", true },
  { "musicgamegalaxy.de", true },
  { "musician.dating", true },
  { "musicstore.de", false },
  { "musicwear.cz", true },
  { "musketonhaken.nl", true },
  { "muslim.singles", true },
  { "muslimbanter.co.za", true },
  { "musmann.io", true },
  { "muspla.com", true },
  { "muspla.com.br", true },
  { "mustard.co.uk", true },
  { "mustardking.me", true },
  { "musthavesforreal.com", true },
  { "mutamatic.com", true },
  { "mutantmonkey.in", true },
  { "mutantmonkey.info", true },
  { "mutantmonkey.sexy", true },
  { "mutuals.cool", true },
  { "mutuelle-obligatoire-pme.fr", true },
  { "mutuelle.fr", true },
  { "muusikoiden.net", true },
  { "mvanmarketing.nl", true },
  { "mvbits.com", true },
  { "mvno.io", true },
  { "mvp-stars.com", true },
  { "mvsecurity.nl", true },
  { "mwavuli.co.ke", true },
  { "mwba.org", false },
  { "mwe.st", true },
  { "mx.org.ua", false },
  { "mx.search.yahoo.com", false },
  { "mxihan.xyz", true },
  { "my-cdn.de", true },
  { "my-dick.ru", true },
  { "my-hps.de", true },
  { "my-owncloud.com", true },
  { "my-pawnshop.com.ua", false },
  { "my.onlime.ch", false },
  { "my.xero.com", false },
  { "myaccount.google.com", false },
  { "myactivity.google.com", true },
  { "myadself.com", true },
  { "myairshop.gr", true },
  { "myandroidtools.cc", true },
  { "myanimelist.net", true },
  { "myartsjournal.com", true },
  { "mybb.com", true },
  { "mybboard.pl", true },
  { "mybeautyjobs.de", true },
  { "mybicc.org", true },
  { "mybon.at", true },
  { "mybudget.xyz", true },
  { "mybuilderinlondon.co.uk", true },
  { "mycard.moe", true },
  { "mycieokien.info", false },
  { "myclientsplus.com", true },
  { "mycompanion.cz", true },
  { "myconan.net", true },
  { "mydebian.in.ua", true },
  { "mydeos.com", false },
  { "mydnaresults.com", true },
  { "mydnatest.com", true },
  { "mydocserve.com", true },
  { "myeberspaecher.com", true },
  { "myepass.de", true },
  { "myfedloan.org", true },
  { "myfrenchtattoo.fr", true },
  { "myg21.com", true },
  { "mygadgetguardian.lookout.com", false },
  { "mygalgame.com", true },
  { "mygallery.homelinux.net", true },
  { "mygate.at", true },
  { "mygivingcircle.org", true },
  { "mygpsite.com", true },
  { "mygreatjobs.de", true },
  { "mygretchen.de", true },
  { "myhostname.net", true },
  { "myimmitracker.com", true },
  { "myiocc.org", true },
  { "myip.tech", true },
  { "mykeepsake.xyz", false },
  { "myki.co", true },
  { "mykontool.de", true },
  { "mylookout.com", false },
  { "mymotor.nl", true },
  { "myms.eu", true },
  { "mymx.lu", true },
  { "mynetblog.com", true },
  { "mynetworkingbuddy.com", true },
  { "myni.io", true },
  { "mynigma.org", true },
  { "mynook.info", true },
  { "myonline.hu", true },
  { "myoukochou.com", true },
  { "myownconference.com", true },
  { "myownconference.com.ua", true },
  { "myownconference.de", true },
  { "myownconference.es", true },
  { "myownconference.fr", true },
  { "myownconference.lt", true },
  { "myownconference.lv", true },
  { "myownconference.pl", true },
  { "myownconference.ru", true },
  { "myownwebinar.com", true },
  { "mypagella.com", true },
  { "mypagella.eu", true },
  { "mypagella.it", true },
  { "mypaperwriter.com", true },
  { "mypayoffloan.com", true },
  { "mypension.ca", true },
  { "myphonebox.de", true },
  { "mypillcard.com", true },
  { "myplaceonline.com", true },
  { "myprintcard.de", true },
  { "myptsite.com", true },
  { "myrealestatemate.com.au", true },
  { "myrepublic.co.id", true },
  { "myresearchapp.com", true },
  { "myruststats.com", true },
  { "myschoolphoto.org", true },
  { "mysecretcase.com", true },
  { "myshirtsize.com", true },
  { "mysignal.com", true },
  { "mysmelly.com", true },
  { "mysoundtalks.com", true },
  { "mysqldump-secure.org", true },
  { "mysterysear.ch", true },
  { "mysticplumes.com", true },
  { "mystown.org", true },
  { "mystudy.me", true },
  { "mytc.fr", true },
  { "mythengay.ch", true },
  { "mythlogic.com", true },
  { "mythslegendscollection.com", true },
  { "mytraiteurs.com", true },
  { "mytripcar.co.uk", true },
  { "mytripcar.de", true },
  { "mytripcar.es", true },
  { "mytty.net", true },
  { "myvoipnews.com", true },
  { "myvpl.com", true },
  { "mywari.com", true },
  { "myworkinfo.com", true },
  { "myworth.com.au", true },
  { "myzina.cz", false },
  { "mziulu.me", false },
  { "n-pix.com", false },
  { "n-soft.info", true },
  { "n-un.de", true },
  { "n0paste.tk", false },
  { "n0psled.nl", true },
  { "n2x.in", false },
  { "n4l.pw", true },
  { "n6a.net", true },
  { "n8ch.net", true },
  { "nabankco.com", true },
  { "nabu-bad-nauheim.de", true },
  { "nabytko.cz", true },
  { "nachsendeauftrag.net", true },
  { "nachsenden.info", true },
  { "nachtmuziek.info", true },
  { "nacktetatsachen.at", true },
  { "nadia.pt", true },
  { "nadyaolcer.fr", true },
  { "nafod.net", true },
  { "nagaya.biz", true },
  { "nagb.gov", true },
  { "nagb.org", true },
  { "nagelfam.com", true },
  { "nagoya-kyuyo.com", true },
  { "nakamastreamingcommunity.com", true },
  { "nakedalarmclock.me", true },
  { "nakedfacts.co.uk", true },
  { "nakliyatsirketi.biz.tr", true },
  { "nako.no", true },
  { "nakuro.de", true },
  { "nalao-company.com", true },
  { "nalinux.cz", true },
  { "nallon.com.br", false },
  { "namaho.com", false },
  { "namegrep.com", true },
  { "nameid.org", true },
  { "namepros.com", true },
  { "namereel.com", true },
  { "namethatbone.com", true },
  { "nametiles.co", true },
  { "naminam.de", true },
  { "namu.moe", true },
  { "namu.wiki", true },
  { "nan.zone", true },
  { "nanch.com", true },
  { "nanderson.me", true },
  { "nandex.org", true },
  { "nanogeneinc.com", true },
  { "nanogi.ga", true },
  { "nanokamo.com", true },
  { "nansay.cn", true },
  { "nanto.eu", true },
  { "naphex.rocks", true },
  { "napisynapomniky.cz", true },
  { "narach.com", true },
  { "narada.com.ua", true },
  { "naralogics.com", true },
  { "narfation.org", true },
  { "nargele.eu", true },
  { "nargileh.nl", true },
  { "naro.se", true },
  { "narodniki.com", true },
  { "narthollis.net", true },
  { "nartuk.com.ua", false },
  { "nascher.org", false },
  { "nasreddine.xyz", false },
  { "nasrsolar.com", true },
  { "nassi.me", true },
  { "natalia-fadeeva.ru", true },
  { "natalieandjoshua.com", true },
  { "natanaelys.com", true },
  { "natenom.com", true },
  { "natenom.de", true },
  { "natenom.name", true },
  { "nathan.io", true },
  { "nathancheek.com", false },
  { "nathankonopinski.com", true },
  { "nathansmetana.com", true },
  { "nationalcentereg.org", true },
  { "nationalcrimecheck.com.au", true },
  { "nationalpriorities.org", true },
  { "nationwidevehiclecontracts.co.uk", true },
  { "natsumihoshino.com", true },
  { "naturesharvestbread.com", true },
  { "natuurbehangnederland.nl", true },
  { "nauck.org", false },
  { "naudles.me", true },
  { "naughty.audio", true },
  { "nav.jobs", true },
  { "naval.tf", true },
  { "navdeep.ca", true },
  { "navigate-it-services.de", false },
  { "naviteq.eu", true },
  { "navstevnik.sk", true },
  { "navycs.com", true },
  { "nayahe.ru", true },
  { "nb.zone", true },
  { "nb6.de", true },
  { "nbaimg.com", true },
  { "nbg-ha.de", false },
  { "nbl.org.tw", true },
  { "nbp.com.pk", true },
  { "nbrown.us", true },
  { "ncands.net", true },
  { "ncaq.net", true },
  { "ncc60205.info", true },
  { "ncconsumer.org", true },
  { "nchangfong.com", true },
  { "ncoding.at", true },
  { "ncpc.gov", true },
  { "ncpw.gov", true },
  { "ncrmnt.org", true },
  { "ncstep.org", true },
  { "ndarville.com", true },
  { "ndbt.com", true },
  { "ndeoffshore.com", true },
  { "nder.be", true },
  { "ndmath.club", true },
  { "ndtblog.com", true },
  { "ndtmarket.place", true },
  { "ndy.sex", true },
  { "ne-on.org", true },
  { "ne1home.dyndns.org", true },
  { "neap.io", true },
  { "nearby.in.th", true },
  { "neartothesky.com", true },
  { "neatous.cz", true },
  { "neatous.net", true },
  { "nebra.io", true },
  { "nebulousenhanced.com", true },
  { "necesitodinero.org", true },
  { "necormansir.com", true },
  { "nectarleaf.com", true },
  { "nedcdata.org", true },
  { "nedim-accueil.fr", true },
  { "nedlinin.com", true },
  { "nedraconsult.ru", true },
  { "nedzad.me", true },
  { "neel.ch", true },
  { "neels.ch", true },
  { "neer.io", true },
  { "nefertitis.cz", true },
  { "neftebitum-kngk.ru", true },
  { "neg9.org", false },
  { "negai.moe", true },
  { "negativecurvature.net", true },
  { "neglecteddiseases.gov", true },
  { "neillans.co.uk", true },
  { "neillans.com", true },
  { "neilwynne.com", true },
  { "neko.li", true },
  { "nekomimi.pl", true },
  { "nekosc.com", true },
  { "nelhage.com", true },
  { "nella-project.org", true },
  { "nellacms.com", true },
  { "nellacms.org", true },
  { "nellafw.org", true },
  { "nemecl.eu", true },
  { "nemno.de", true },
  { "nemo.run", true },
  { "nemumu.com", true },
  { "nemunai.re", true },
  { "neo19.com", false },
  { "neo2shyalien.eu", false },
  { "neoani.me", true },
  { "neofelhz.space", true },
  { "neons.org", true },
  { "neophilus.net", true },
  { "neosolution.ca", true },
  { "neoxcrf.com", true },
  { "nephos.xyz", true },
  { "nephy.jp", true },
  { "nercp.org.uk", true },
  { "nerd42.de", true },
  { "nerdjokes.de", true },
  { "nerdpol.ch", true },
  { "nerds-gegen-stephan.de", true },
  { "nerds.company", false },
  { "nerdtime.de", true },
  { "nerdydev.net", true },
  { "neris.io", true },
  { "nerull7.info", true },
  { "nerven.se", false },
  { "nestedquotes.ca", true },
  { "nestone.ru", true },
  { "neswec.org.uk", true },
  { "net-safe.info", true },
  { "net2o.com", true },
  { "net2o.de", true },
  { "net2o.net", true },
  { "netba.net", true },
  { "netbank.com.au", true },
  { "netbox.cc", true },
  { "netbrief.ml", true },
  { "netbulls.io", true },
  { "netconnect.at", true },
  { "netcoolusers.org", true },
  { "netera.se", true },
  { "netfs.pl", false },
  { "netfxharmonics.com", false },
  { "nethackwiki.com", true },
  { "nethruster.com", true },
  { "netica.fr", false },
  { "netlilo.com", true },
  { "netlocal.ru", true },
  { "netmazk.net", false },
  { "netnodes.net", true },
  { "netprofile.com.au", true },
  { "netraising.com", true },
  { "netrelay.email", true },
  { "netrider.net.au", false },
  { "netronix.be", true },
  { "netsight.org", true },
  { "netsigna.de", true },
  { "netsite.dk", true },
  { "netsoins.org", true },
  { "netsparker.com", false },
  { "netsystems.pro", true },
  { "nette.org", true },
  { "nettefoundation.com", true },
  { "nettia.fi", true },
  { "nettools.link", true },
  { "nettopower.dk", true },
  { "nettx.co.uk", true },
  { "netulo.com", true },
  { "netvizura.co.uk", true },
  { "netwarc.eu", true },
  { "netwarc.nl", true },
  { "netwerkmanager.nl", true },
  { "network-notes.com", true },
  { "network23.nl", true },
  { "networkalarmcorp.com", true },
  { "networking4all.com", false },
  { "networkingnexus.net", true },
  { "networkingphoenix.com", true },
  { "networth.at", true },
  { "networx-online.de", true },
  { "netzfrauen.org", true },
  { "netzvieh.de", true },
  { "netzwerkwerk.de", true },
  { "neueonlinecasino2016.com", true },
  { "neuflizeobc.net", true },
  { "neuhaus-city.de", true },
  { "neuralgic.net", true },
  { "neurobiology.com", true },
  { "neuroethics.com", true },
  { "neurogroove.info", true },
  { "neuronasdigitales.com", true },
  { "neuronfactor.com", true },
  { "neuropharmacology.com", true },
  { "neuwal.com", true },
  { "nevadafiber.net", true },
  { "new-black-order.com", true },
  { "new-ms.com", true },
  { "new-process.ch", true },
  { "new-process.com", true },
  { "new-process.de", true },
  { "new-process.eu", true },
  { "new.travel.pl", true },
  { "newantiagingcreams.com", true },
  { "newday.host", true },
  { "newedivideo.it", true },
  { "newfacialbeautycream.com", true },
  { "newind.info", true },
  { "newline.online", true },
  { "newmediaone.net", true },
  { "newodesign.com", true },
  { "newpathintegratedtherapy.com", true },
  { "newportpropertygroup.com", true },
  { "newstarnootropics.com", true },
  { "newstone-tech.com", true },
  { "newsyslog.org", true },
  { "newtnote.com", true },
  { "newtonhaus.com", true },
  { "newtonwarp.com", true },
  { "newtrackon.com", true },
  { "nex.sx", true },
  { "nexicafiles.com", true },
  { "nexlab.org", true },
  { "next176.sk", true },
  { "next24.io", true },
  { "next47.com", true },
  { "nextcairn.com", true },
  { "nextcloud.com", true },
  { "nextend.net", true },
  { "nextend.org", true },
  { "nextgen.sk", true },
  { "nextgencel.com", true },
  { "nextpages.de", true },
  { "nexusconnectinternational.eu", true },
  { "nf9q.com", true },
  { "nfe-elektro.de", true },
  { "nfo.so", true },
  { "nframe.io", true },
  { "nfrost.me", true },
  { "nfsec.pl", true },
  { "ng-firewall.com", true },
  { "ng-security.com", true },
  { "nghe.net", true },
  { "nginxnudes.com", true },
  { "nglr.org", true },
  { "nhome.ba", true },
  { "ni-mate.com", true },
  { "niagarafalls.ca", true },
  { "niagaraschoice.org", true },
  { "nibb13.tech", true },
  { "nibiisclaim.com", true },
  { "nicestudio.co.il", false },
  { "nichteinschalten.de", false },
  { "nichthelfer.de", true },
  { "nickdekruijk.nl", true },
  { "nickloose.de", true },
  { "nickrickard.co.uk", true },
  { "nickstories.de", true },
  { "nico.one", true },
  { "nicoborghuis.nl", true },
  { "nicocourts.com", true },
  { "nicoknibbe.nl", true },
  { "nicolaeiotcu.ro", true },
  { "nicolaelmer.ch", true },
  { "nicolas-dumermuth.com", true },
  { "nicolas-hoffmann.net", true },
  { "nicolas-hoizey.com", true },
  { "nicolas-simond.com", true },
  { "nicolasklotz.de", true },
  { "nicolaw.uk", true },
  { "nidro.de", true },
  { "nidux.com", true },
  { "niduxcomercial.com", true },
  { "niederohmig.de", true },
  { "niedersetz.de", true },
  { "niehage.name", true },
  { "nien.cf", true },
  { "nien.chat", true },
  { "nien.co", true },
  { "nien.com", true },
  { "nien.com.tw", true },
  { "nien.eu.org", true },
  { "nien.org", true },
  { "nien.taipei", true },
  { "nien.tk", true },
  { "nienfun.com", true },
  { "nierenpraxis-dr-merkel.de", true },
  { "nierenpraxis-merkel.de", true },
  { "nieselregen.com", false },
  { "nietzsche.com", true },
  { "nieuwsoverijssel.nl", true },
  { "nifpnet.nl", true },
  { "niftiestsoftware.com", true },
  { "nigelwakefield.com", true },
  { "niggemeier.cc", true },
  { "nightfirec.at", true },
  { "nightfirecat.com", true },
  { "nightsnack.cf", true },
  { "nightwinds.tk", true },
  { "nightx.uk", true },
  { "nijiero-ch.com", false },
  { "nijm.nl", true },
  { "nikandcara.com", true },
  { "nikao-tech.com", true },
  { "nikcub.com", false },
  { "nikklassen.ca", true },
  { "niklas.pw", true },
  { "niklaslindblad.se", true },
  { "nikobradshaw.com", true },
  { "nikolasbradshaw.com", true },
  { "nikolasgrottendieck.com", true },
  { "nikomo.fi", true },
  { "nil.gs", true },
  { "niloxy.com", true },
  { "nilrem.org", true },
  { "nimeshjm.com", true },
  { "ninchat.com", true },
  { "nine-hells.net", false },
  { "ninebennink.com", true },
  { "ninespec.com", true },
  { "ning.so", true },
  { "ninjan.co", true },
  { "ninthfloor.org", true },
  { "ninux.ch", false },
  { "niouininon.eu", true },
  { "nippon-oku.com", true },
  { "nippon.fr", true },
  { "nirada.info", true },
  { "nitrix.me", true },
  { "nitropur.com", true },
  { "nitropur.de", true },
  { "nivi.ca", true },
  { "nixien.fr", true },
  { "nixmag.net", true },
  { "njpjanssen.nl", true },
  { "nkadvertising.online", true },
  { "nkp-media.de", true },
  { "nl-ix.net", true },
  { "nl.search.yahoo.com", false },
  { "nll.fi", true },
  { "nmctest.net", true },
  { "nmd.so", true },
  { "nmsnj.com", true },
  { "nn.cz", true },
  { "nnote.net", true },
  { "nnqc.nl", true },
  { "no.search.yahoo.com", false },
  { "nobly.de", true },
  { "nocit.dk", true },
  { "nocs.cn", true },
  { "noctinus.tk", true },
  { "nodari.com.ar", true },
  { "nodebrewery.com", true },
  { "nodecompat.com", true },
  { "nodelia.com", true },
  { "nodespin.com", true },
  { "nodi.at", true },
  { "noedidacticos.com", true },
  { "noemax.com", true },
  { "noez.de", true },
  { "nohats.ca", true },
  { "nohm.eu", true },
  { "nohttps.org", true },
  { "nohup.se", true },
  { "noisetrap.cz", true },
  { "noisky.cn", true },
  { "noisyfox.cn", true },
  { "nojestorget.se", true },
  { "nolaviz.org", true },
  { "nolte.work", false },
  { "noma-film.com", true },
  { "nomadproject.io", true },
  { "nomesbiblicos.com", true },
  { "nomial.co.uk", true },
  { "noname-ev.de", true },
  { "noob-box.net", false },
  { "noodlesandwich.com", true },
  { "noodplan.co.za", true },
  { "noop.ch", true },
  { "noordsee.de", true },
  { "nootropic.com", true },
  { "nootropicsource.com", true },
  { "nopex.no", true },
  { "norandom.com", true },
  { "norb.at", true },
  { "nord-sud.be", true },
  { "nordiccasinocommunity.com", true },
  { "nordor.homeip.net", true },
  { "nordseeblicke.de", true },
  { "nordwaldzendo.de", true },
  { "noreply.mx", true },
  { "normaculta.com.br", true },
  { "norrkemi.se", true },
  { "norrliden.de", true },
  { "norskpensjon.no", true },
  { "northcutt.com", true },
  { "northernmuscle.ca", true },
  { "northpole.dance", true },
  { "northumbriagames.co.uk", true },
  { "northwoodsfish.com", true },
  { "nos-medias.fr", true },
  { "nos-oignons.net", true },
  { "nosfermiers.com", true },
  { "nossasenhora.net", true },
  { "nossasenhoradaconceicao.com.br", true },
  { "nossasenhoradodesterro.com.br", true },
  { "nostraforma.com", false },
  { "not-a.link", true },
  { "notabug.org", true },
  { "notalone.gov", true },
  { "notarvysocina.cz", true },
  { "notbolaget.se", true },
  { "notcompletelycorrect.com", true },
  { "note7forever.com", true },
  { "notenoughtime.de", true },
  { "notesforpebble.com", true },
  { "nothing.net.nz", true },
  { "noticiasdehumor.com", true },
  { "notificami.com", true },
  { "notify.moe", true },
  { "notinglife.com", true },
  { "notjustbitchy.com", true },
  { "notjustvacs.com", true },
  { "notnize.net", true },
  { "notnl.com", true },
  { "notoriousdev.com", true },
  { "nottres.com", true },
  { "notypiesni.sk", false },
  { "nou.si", true },
  { "nourishorganicwholefoods.com.au", false },
  { "novabench.com", true },
  { "novaco.in", true },
  { "novafreixo.pt", true },
  { "novascan.net", true },
  { "novavoidhowl.com", true },
  { "novawave.ca", true },
  { "novelfeed.com", true },
  { "novelshouse.com", true },
  { "novoresume.com", false },
  { "novurania.com", true },
  { "nowhere.dk", true },
  { "nowlas.org", true },
  { "noxlogic.nl", true },
  { "npath.de", true },
  { "npm.li", true },
  { "npmcdn.com", true },
  { "npw.net", true },
  { "nq7.pl", true },
  { "nrechn.de", true },
  { "nrizzio.me", true },
  { "nrkn.fr", true },
  { "nsa.lol", true },
  { "nsa.wtf", true },
  { "nsboston.org", true },
  { "nsboutique.com", true },
  { "nscnet.jp", true },
  { "nshost.ro", true },
  { "nsm.ee", true },
  { "nspeaks.com", true },
  { "nsure.us", true },
  { "nsweb.solutions", true },
  { "nsworks.com", true },
  { "ntbs.pro", true },
  { "ntotten.com", true },
  { "ntppool.org", true },
  { "ntse.xyz", true },
  { "nube.ninja", true },
  { "nubu.at", true },
  { "nukenet.se", true },
  { "nukute.com", true },
  { "null-life.com", true },
  { "null-pointer.eu", true },
  { "null-sec.ru", true },
  { "null.cat", true },
  { "null.tips", true },
  { "nullpro.com", true },
  { "nullroute.com", true },
  { "numatic.co.uk", true },
  { "numberoneshoes.co.nz", true },
  { "numberzero.org", true },
  { "numero-aleatorio.com", true },
  { "numero-di-telefono.it", true },
  { "numm.fr", true },
  { "nunomoura.com", true },
  { "nuos.org", true },
  { "nup.pw", true },
  { "nursejj.com", true },
  { "nurses.dating", true },
  { "nusatrip-api.com", true },
  { "nutikell.com", true },
  { "nutricuerpo.com", true },
  { "nutrienti.eu", false },
  { "nutritionculture.com", true },
  { "nuttyveg.com", true },
  { "nuvechtdal.nl", true },
  { "nuvini.com", true },
  { "nuxer.fr", true },
  { "nvlop.xyz", true },
  { "nvr.bz", true },
  { "nwa.xyz", true },
  { "nwk1.com", true },
  { "nwra.com", true },
  { "nwwc.dk", true },
  { "nwwnetwork.net", true },
  { "nyan.it", true },
  { "nycroth.com", true },
  { "nyffo.com", false },
  { "nyiad.edu", true },
  { "nyip.co.uk", true },
  { "nyip.edu", true },
  { "nymphetomania.net", true },
  { "nynex.net", true },
  { "nyphox.net", true },
  { "nyronet.de", false },
  { "nys-hk.com", true },
  { "nysifclaimcentral.com", true },
  { "nyxi.eu", true },
  { "nyyu.tk", true },
  { "nzbs.io", false },
  { "nzmk.cz", true },
  { "o2careers.co.uk", true },
  { "o3wallet.com", true },
  { "o6asan.com", true },
  { "oaic.gov.au", true },
  { "oakslighting.co.uk", true },
  { "oasisim.net", true },
  { "oauth-dropins.appspot.com", true },
  { "obdolbacca.ru", true },
  { "obermeiers.eu", true },
  { "obfuscate.xyz", true },
  { "obg-global.com", true },
  { "obscuredfiles.com", false },
  { "obsidianirc.net", true },
  { "obsproject.com", true },
  { "obsydian.org", false },
  { "obtima.org", true },
  { "ocad.com.au", true },
  { "ocapic.com", true },
  { "occasion-impro.com", true },
  { "occupymedia.org", true },
  { "ocd2016.com", true },
  { "ocf.io", true },
  { "ocg-card.com", true },
  { "ochsundjunior.ch", true },
  { "ockendenhemming.co.uk", true },
  { "ocotg.com", true },
  { "ocrami.us", true },
  { "octanio.com", true },
  { "octav.name", false },
  { "octocat.ninja", true },
  { "octod.tk", true },
  { "octofox.de", true },
  { "octolopagon.games", true },
  { "octopus-agents.com", true },
  { "octothorpe.club", true },
  { "oddnumber.ca", true },
  { "oddsandevens.ca", true },
  { "oddsandevensbookkeeping.ca", true },
  { "oddtime.net", true },
  { "odifi.com", true },
  { "odinoffice.no", true },
  { "odtu.lu", true },
  { "oe8.bet", true },
  { "oec-music.com", true },
  { "oeh.ac.at", true },
  { "oeko-bundesfreiwilligendienst-sh.de", true },
  { "oeko-bundesfreiwilligendienst.de", true },
  { "oeko-jahr-jubilaeum.de", true },
  { "oeko-jahr.de", true },
  { "ofcourselanguages.com", true },
  { "ofda.gov", true },
  { "offenedialoge.de", true },
  { "office-de-tourisme.net", false },
  { "office-ruru.com", true },
  { "officeclub.com.mx", true },
  { "offshoot.rentals", true },
  { "offshore-firma.org", true },
  { "offshoremarineparts.com", true },
  { "ofggolf.com", true },
  { "oflow.me", true },
  { "oftn.org", true },
  { "ogocare.com", true },
  { "ogogoshop.com", true },
  { "oguya.ch", true },
  { "oh14.de", true },
  { "ohayosoro.me", true },
  { "oheila.com", true },
  { "ohiohealthfortune100.com", true },
  { "ohling.org", true },
  { "ohlmeier.com", true },
  { "ohnemusik.com", true },
  { "ohsocool.org", true },
  { "oiepoie.nl", false },
  { "ojls.co", true },
  { "okad.eu", true },
  { "okane.love", true },
  { "okay.coffee", true },
  { "okaz.de", true },
  { "okchicas.com", true },
  { "oke.com.tw", false },
  { "okhrana.agency", true },
  { "oklahomatickets.com", true },
  { "okmx.de", true },
  { "okok-rent.com", true },
  { "okok.rent", true },
  { "okonetwork.org.uk", true },
  { "oktoberfeststore.nl", true },
  { "okusiassociates.com", true },
  { "okutama.in.th", true },
  { "olafnorge.de", false },
  { "olanderflorist.com", true },
  { "olcso-vps-szerver.hu", true },
  { "oldchaphome.nl", true },
  { "oldenglishsheepdog.com.br", true },
  { "oldoakflorist.com", true },
  { "olegon.ru", true },
  { "oleksii.name", true },
  { "oliver-pietsch.de", false },
  { "oliveraiedelabastideblanche.fr", true },
  { "oliverfaircliff.com", true },
  { "olivierlemoal.fr", true },
  { "olivierpieters.be", true },
  { "ollehbizev.co.kr", true },
  { "ollies.cloud", true },
  { "olliespage.net", true },
  { "ollning.com", true },
  { "olmari.fi", true },
  { "ols.io", true },
  { "olswangtrainees.com", true },
  { "olygazoo.com", true },
  { "olymp-arts.world", true },
  { "omacostudio.com", true },
  { "omgaanmetidealen.com", false },
  { "omifind.com", true },
  { "omitech.co.uk", true },
  { "omniasl.com", true },
  { "omnienviro.com", true },
  { "omnienviro.com.au", true },
  { "omniverse.ru", true },
  { "omquote.gq", true },
  { "onaboat.se", true },
  { "onarto.com", true },
  { "ondrej.org", true },
  { "one---line.com", true },
  { "one-pe.com", true },
  { "onearth.one", true },
  { "oneazcu.com", false },
  { "onecycling.my", true },
  { "onecycling.world", true },
  { "onedot.nl", true },
  { "onedrive.com", true },
  { "onedrive.live.com", false },
  { "onefour.ga", false },
  { "onehourloan.com", true },
  { "onehourloan.sg", true },
  { "oneminutefilm.tv", true },
  { "oneononeonone.de", true },
  { "oneononeonone.tv", true },
  { "onet.space", true },
  { "oneway.ga", true },
  { "onewaymail.com", true },
  { "oneweb.hu", true },
  { "onewebdev.info", true },
  { "oneworldbank.com", true },
  { "onewpst.com", true },
  { "onfarma.it", true },
  { "onguardonline.gov", true },
  { "onioncloud.org", true },
  { "onixcco.com.br", true },
  { "online-bouwmaterialen.nl", true },
  { "online-eikaiwa-guide.com", true },
  { "online-pr.at", true },
  { "online.marketing", true },
  { "online.swedbank.se", true },
  { "onlinebiller.com", true },
  { "onlinebizdirect.com", true },
  { "onlinecensorship.org", true },
  { "onlinedemo.hu", true },
  { "onlinedeposit.us", true },
  { "onlinelegalmarketing.com", true },
  { "onlinelegalmedia.com", true },
  { "onlinelighting.com.au", true },
  { "onlinemarketingtraining.co.uk", true },
  { "onlinetravelmoney.co.uk", true },
  { "onlinewetten.de", true },
  { "only-roses.com", true },
  { "onlyzero.net", true },
  { "onmaps.de", true },
  { "onmarketbookbuilds.com", true },
  { "onmuvo.com", true },
  { "ono.es", true },
  { "onovlena.dn.ua", true },
  { "onqproductions.com", true },
  { "onrr.gov", true },
  { "ons.ca", true },
  { "onstud.com", true },
  { "onthebriteside.com", true },
  { "ontimestamp.com", true },
  { "ontras.com", true },
  { "onviga.de", true },
  { "onvori.com", true },
  { "onvori.de", true },
  { "onysix.net", true },
  { "onyxwall.com", true },
  { "onyxwall.link", true },
  { "onyxwall.net", true },
  { "oogami.name", true },
  { "oogartsennet.nl", true },
  { "ooonja.de", true },
  { "oopsmycase.com", true },
  { "ooyo.be", true },
  { "oparl.org", true },
  { "opatut.de", true },
  { "open-bs.com", true },
  { "open-bs.ru", true },
  { "open-coding.org", true },
  { "open-future.be", true },
  { "open-infrastructure.net", true },
  { "open-mesh.org", true },
  { "open-mx.de", true },
  { "open.gl", true },
  { "openacademies.com", true },
  { "openas.org", true },
  { "openblox.org", true },
  { "openbsd.id", true },
  { "openconnect.com.au", true },
  { "openkim.org", true },
  { "openkvk.nl", true },
  { "openmtbmap.org", true },
  { "opennippon.com", true },
  { "opennippon.ru", true },
  { "openrtv.com", true },
  { "opensource-cms.nl", true },
  { "opensourcehouse.net", true },
  { "openssl.org", true },
  { "openstreetmap.is", true },
  { "opentrack.info", true },
  { "opentrash.org", true },
  { "openverse.com", true },
  { "openvz.org", true },
  { "openxmpp.com", false },
  { "opic.gov", true },
  { "opinello.com", true },
  { "opium.io", true },
  { "oplop.appspot.com", true },
  { "oppaiti.me", true },
  { "oppejoud.ee", true },
  { "opperwall.net", true },
  { "opq.pw", true },
  { "oprbox.com", true },
  { "oprechtgezegd.nl", true },
  { "opreismetingvoorunicef.nl", false },
  { "opsafewinter.net", true },
  { "opsmate.com", false },
  { "opstacks.com", true },
  { "optimista.soy", true },
  { "optimus.io", true },
  { "optimuscrime.net", true },
  { "optmos.at", true },
  { "optoutday.de", true },
  { "opus-codium.fr", true },
  { "oracaodocredo.com.br", true },
  { "orangefinanse.com.pl", true },
  { "orangetravel.eu", true },
  { "orangutan-appeal.org.uk", true },
  { "orbiosales.com", true },
  { "orbitsoft.com", true },
  { "orcahq.com", true },
  { "orcamoney.com", true },
  { "orchidspaper.com", true },
  { "ordereat.fr", true },
  { "ordernow.at", true },
  { "orderswift.com", true },
  { "ordr.mobi", true },
  { "oref-idf.com", true },
  { "oref-idf.net", true },
  { "oref-idf.org", true },
  { "orf-digitalsatkarte.at", true },
  { "orf-kartentausch.at", true },
  { "organic-superfood.net", true },
  { "organicae.com", true },
  { "organiplan.com", true },
  { "orhideous.name", true },
  { "oricejoc.com", false },
  { "orientalart.nl", true },
  { "origami.to", true },
  { "originalmockups.com", true },
  { "orioncustompcs.com", false },
  { "orkestar-krizevci.hr", true },
  { "orlives.de", true },
  { "oroweatorganic.com", true },
  { "orro.ro", true },
  { "orrs.de", true },
  { "orwell1984.today", true },
  { "osacrypt.studio", true },
  { "osaiyuwu.com", true },
  { "osao.org", true },
  { "osborneinn.com", true },
  { "osburn.com", true },
  { "oscarvk.ch", true },
  { "oscsdp.cz", true },
  { "oses.mobi", true },
  { "oshayr.com", true },
  { "oskuro.net", true },
  { "oslfoundation.org", true },
  { "osm.is", true },
  { "osmanlitorunu.com", true },
  { "osmosis.org", true },
  { "osp.cx", true },
  { "osquery.io", true },
  { "ossbinaries.com", true },
  { "ostan-collections.net", true },
  { "ostendorf.com", true },
  { "osterkraenzchen.de", true },
  { "ostr.io", true },
  { "osusume-houhou.com", true },
  { "osxentwicklerforum.de", true },
  { "oszri.hu", true },
  { "otakubox.de", true },
  { "otakurepublic.com", true },
  { "otchecker.com", true },
  { "oticasvisao.net.br", true },
  { "otmns.net", true },
  { "otoy.com", true },
  { "otpsmart.com.ua", true },
  { "otrm.de", true },
  { "otrsdemo.hu", true },
  { "ottoproject.io", true },
  { "otvaracie-hodiny.sk", true },
  { "otya.me", true },
  { "ouaibe.qc.ca", true },
  { "ourai.ws", true },
  { "ourchoice2016.com", true },
  { "ourcloud.at", true },
  { "ourcodinglives.com", true },
  { "ourevents.net", true },
  { "outerlimitsdigital.com", true },
  { "outetc.com", true },
  { "outgress.com", true },
  { "outline.ski", true },
  { "outlookonthedesktop.com", true },
  { "outofcontrol.ca", true },
  { "outreachbuddy.com", true },
  { "outurnate.com", true },
  { "overalglas.nl", true },
  { "overclockers.ge", true },
  { "overkillshop.com", true },
  { "overseamusic.de", true },
  { "oversight.garden", true },
  { "oversight.io", true },
  { "overthinkingit.com", true },
  { "overture.london", true },
  { "ovpn.to", true },
  { "owensmith.website", true },
  { "own3d.ch", true },
  { "owncloud.help", true },
  { "ownit.se", false },
  { "ownmovies.fr", true },
  { "ownspec.com", true },
  { "oxygaming.com", true },
  { "oxymc.com", true },
  { "oxynux.fr", true },
  { "oxynux.xyz", true },
  { "oxytocin.org", true },
  { "oyste.in", true },
  { "oznamovacipovinnost.cz", true },
  { "ozvolvo.org", true },
  { "p-s-b.com", true },
  { "p.linode.com", false },
  { "p1984.nl", false },
  { "p1c.pw", true },
  { "p3in.com", true },
  { "pa-w.de", true },
  { "pace.car", true },
  { "pacelink.de", true },
  { "packagist.org", false },
  { "packaware.com", true },
  { "packer.io", true },
  { "pacoda.de", true },
  { "pactf.com", true },
  { "paddy.rocks", true },
  { "pader-deko.de", true },
  { "paedlink.ca", true },
  { "paestbin.com", true },
  { "pagefulloflies.io", true },
  { "pagetoimage.com", true },
  { "pagewizz.com", false },
  { "pagiamtzis.com", true },
  { "paginapolitica.ro", true },
  { "pagure.io", true },
  { "pagure.org", true },
  { "paino.cloud", true },
  { "painosso.org", true },
  { "paint-it.pink", true },
  { "paintingat.com", true },
  { "paio2-rec.com", true },
  { "paio2.com", true },
  { "pajonzeck.de", true },
  { "pajowu.de", true },
  { "pajuvuo.fi", true },
  { "paket.io", true },
  { "pakistani.dating", true },
  { "pakke.de", true },
  { "pakremit.com", true },
  { "paku.me", true },
  { "palatin.at", true },
  { "palationtrade.com", true },
  { "palava.tv", true },
  { "palmer.im", true },
  { "pamaniqu.nl", true },
  { "pamplona.tv", true },
  { "pan.digital", true },
  { "panaceallc.net", true },
  { "panaxis.ch", true },
  { "pandoraflora.com", true },
  { "pandymic.com", true },
  { "panelomix.net", true },
  { "paneu.de", true },
  { "panmetro.com", true },
  { "panni.me", false },
  { "panoranordic.net", true },
  { "panoti.com", false },
  { "panpsychism.com", true },
  { "pansu.space", true },
  { "panthur.com.au", false },
  { "pantou.org", false },
  { "pants-off.xyz", true },
  { "pap.la", false },
  { "papa-webzeit.de", true },
  { "papalytics.com", true },
  { "papayapythons.com", true },
  { "paper-republic.org", true },
  { "papercrunch.io", true },
  { "papermasters.com", true },
  { "paperturn.com", true },
  { "paperwork.co.za", true },
  { "papygeek.com", true },
  { "parabhairavayoga.com", true },
  { "paraborsa.net", true },
  { "paradise-engineering.com", true },
  { "paradiselost.com", true },
  { "paradoxdesigns.org", true },
  { "paragon.com.sg", true },
  { "paragonie.com", false },
  { "paragreen.net", true },
  { "paranoxer.hu", true },
  { "parasitologyclub.org", true },
  { "paratlan.hu", true },
  { "parckwart.de", true },
  { "parcon.it", true },
  { "parent5446.us", true },
  { "parentinterview.com", true },
  { "pariga.co.uk", true },
  { "parithy.net", true },
  { "parkingpoint.co.uk", true },
  { "parkwithark.com", true },
  { "parlamento.gub.uy", true },
  { "parleu2016.nl", true },
  { "parleur.net", false },
  { "parodybit.net", true },
  { "parolu.io", true },
  { "parpaing-paillette.net", true },
  { "parsemail.org", true },
  { "parser.nu", true },
  { "partecipa.tn.it", true },
  { "participatorybudgeting.de", true },
  { "participatorybudgeting.info", true },
  { "partiono.com", true },
  { "partirkyoto.jp", true },
  { "partnerbeam.com", true },
  { "partnercardservices.com", true },
  { "partnersfcu.org", true },
  { "partridge.tech", true },
  { "partyhaus.ovh", true },
  { "partyvan.eu", true },
  { "partyvan.io", true },
  { "partyvan.it", true },
  { "partyvan.moe", true },
  { "partyvan.nl", true },
  { "partyvan.se", true },
  { "pasadenapooch.org", false },
  { "pasarella.eu", true },
  { "pascal-wittmann.de", true },
  { "pascalleguern.com", true },
  { "passieposse.nl", true },
  { "passionatefoodie.co.uk", true },
  { "passphrase.today", true },
  { "passport.yandex.by", true },
  { "passport.yandex.com", true },
  { "passport.yandex.com.tr", true },
  { "passport.yandex.kz", true },
  { "passport.yandex.ru", true },
  { "passport.yandex.ua", true },
  { "passthepopcorn.me", true },
  { "passumpsicbank.com", true },
  { "passvau.lt", true },
  { "passwd.io", true },
  { "password.codes", true },
  { "passwords.google.com", true },
  { "pasta-factory.co.il", true },
  { "pastaenprosecco.nl", true },
  { "pastaf.com", true },
  { "paste.fedoraproject.org", true },
  { "paste.linode.com", false },
  { "pastebin.linode.com", false },
  { "pastenib.com", true },
  { "pasternok.org", true },
  { "pasteros.io", true },
  { "pastie.se", true },
  { "pastorbelgagroenendael.com.br", true },
  { "pastorcanadense.com.br", true },
  { "pastordocaucaso.com.br", true },
  { "pastormaremanoabruzes.com.br", true },
  { "patechmasters.com", true },
  { "patentfamily.de", true },
  { "paternitydnatest.com", true },
  { "paterno-gaming.com", true },
  { "patflix.com", true },
  { "patfs.com", true },
  { "patientinsight.net", true },
  { "patikabiztositas.hu", true },
  { "patralos.at", false },
  { "patriaco.net", true },
  { "patrickaudley.ca", true },
  { "patrickaudley.com", true },
  { "patrickschneider.me", true },
  { "patriksimek.cz", true },
  { "patrz.eu", true },
  { "pattuka.com", true },
  { "paudley.ca", true },
  { "paudley.com", true },
  { "paudley.org", true },
  { "paul-kerebel.pro", false },
  { "paul.reviews", true },
  { "pauladamsmith.com", true },
  { "paulbakaus.com", true },
  { "paulbdelaat.nl", true },
  { "paulchen.at", true },
  { "paulerhof.com", true },
  { "paulewen.ca", true },
  { "paulinewesterman.nl", true },
  { "paulov.info", true },
  { "paulproell.at", true },
  { "paulrobertlloyd.com", true },
  { "paulrotter.de", true },
  { "paulschreiber.com", true },
  { "paulshir.com", true },
  { "paulswartz.net", true },
  { "paultibbetts.uk", true },
  { "paulwatabe.com", true },
  { "pauspam.net", true },
  { "pavelrebrov.com", true },
  { "paw.cloud", true },
  { "paw.pt", true },
  { "pay.ubuntu.com", true },
  { "payclixpayments.com", true },
  { "payfreez.com", true },
  { "paylike.io", true },
  { "payload.tech", true },
  { "payme.uz", true },
  { "payment-network.com", true },
  { "paymentaccuracy.gov", true },
  { "payments-reference.org", true },
  { "payments.google.com", true },
  { "paymill.com", true },
  { "paymill.de", true },
  { "payoff.com", true },
  { "paypal.com", false },
  { "paypaq.com", true },
  { "paypod.org", true },
  { "paypro.nl", false },
  { "payroll.xero.com", false },
  { "paysera.com", true },
  { "payslipview.com", true },
  { "paystack.com", true },
  { "paytm.in", true },
  { "paytwopay.com", true },
  { "payupay.ru", true },
  { "payzang.com", true },
  { "pbraunschdash.com", true },
  { "pbscreens.com", true },
  { "pc-rescue.me", true },
  { "pccentral.nl", true },
  { "pcel.com", true },
  { "pcfeuerwehr.de", true },
  { "pcforum.sk", true },
  { "pciconcursos.com.br", true },
  { "pclaeuft.de", true },
  { "pclob.gov", true },
  { "pcloud.com", true },
  { "pcnotdienst-oldenburg-rastede.de", true },
  { "pctonic.net", true },
  { "pcxserver.com", true },
  { "pdamsidoarjo.co.id", true },
  { "pdevio.com", true },
  { "pdf.yt", true },
  { "pdfresizer.com", true },
  { "pe-bank.co.jp", true },
  { "pe-kyousai.jp", true },
  { "pe.search.yahoo.com", false },
  { "peaceandwool.com", true },
  { "peakapp.nl", true },
  { "pear2pear.de", true },
  { "pebbles.net.in", true },
  { "pebblesdemo.com", true },
  { "pedicureduiven.nl", true },
  { "pedrosluiter.nl", true },
  { "pedroventura.com", true },
  { "peekier.com", true },
  { "peercraft.com", true },
  { "peerherrmann.de", true },
  { "peername.com", true },
  { "peervpn.net", true },
  { "peetah.com", true },
  { "peg.nu", true },
  { "pegas-studio.net", true },
  { "pehapkari.cz", true },
  { "peifi.de", true },
  { "peirong.me", true },
  { "pekkarik.ru", true },
  { "pekoe.se", true },
  { "pelanucto.cz", true },
  { "peliculasaudiolatinoonline.com", true },
  { "pemagrid.org", true },
  { "penablog.com", true },
  { "pencepay.com", true },
  { "penfold.fr", true },
  { "pengi.me", true },
  { "pennergold.net", true },
  { "pennyapp.io", true },
  { "pennylane.me.uk", true },
  { "pensacolawinterfest.org", true },
  { "pension-waldesruh.de", true },
  { "pensiunealido.ro", true },
  { "pentagram.me", false },
  { "pentandra.com", true },
  { "pentano.net", true },
  { "pentest.blog", true },
  { "pentest.nl", true },
  { "pentesterlab.com", true },
  { "penz.media", true },
  { "people-mozilla.org", true },
  { "peoplesbankal.com", true },
  { "pepchid.com", false },
  { "peplog.nl", true },
  { "pepperhead.com", true },
  { "pepsicoemployeepreferencesurvey.com", true },
  { "per-pedes.at", true },
  { "percolate.com", true },
  { "percy.io", true },
  { "perdel.cn", false },
  { "pereuda.com", true },
  { "perezdecastro.org", true },
  { "perfect.in.th", true },
  { "perfectionis.me", true },
  { "perfectseourl.com", true },
  { "perfektesgewicht.com", true },
  { "perfektesgewicht.de", true },
  { "performancesantafe.org", true },
  { "performaterm.ro", true },
  { "perfumeaz.com", true },
  { "perfumes.com.br", true },
  { "periscope.tv", true },
  { "periscopeliveweb.com", true },
  { "perishablepress.com", true },
  { "peromsik.com", true },
  { "perot.me", true },
  { "personalcommunicationsecurity.com", true },
  { "personalizedtouch.co", true },
  { "perspectivum.com", true },
  { "persson.im", true },
  { "perzeidi.hr", true },
  { "pestici.de", true },
  { "pet-hotel-mura.net", true },
  { "pet-nsk.ru", true },
  { "petabits.de", true },
  { "petchart.net", true },
  { "peter.org.ua", true },
  { "peterboers.info", true },
  { "peterdavehello.org", true },
  { "peterfolta.net", true },
  { "peterhuetz.at", true },
  { "peterhuetz.com", true },
  { "peterkshultz.com", true },
  { "petersmark.com", false },
  { "petersontoscano.com", true },
  { "pethub.com", true },
  { "petit.site", true },
  { "petitsfrenchies.com", true },
  { "petja.me", false },
  { "petko.me", true },
  { "petmall.bg", true },
  { "petplus.com", true },
  { "petpost.co.nz", true },
  { "petrasestakova.cz", true },
  { "petrovsky.pro", true },
  { "petruzz.net", true },
  { "petsittersservices.com", true },
  { "pettitcoat.com", true },
  { "pettsy.com", true },
  { "pexieapp.com", true },
  { "peyote.com", true },
  { "peytonfarrar.com", false },
  { "pfa.or.jp", true },
  { "pfadfinder-aurich.de", true },
  { "pfarchimedes-pensioen123.nl", true },
  { "pfd-nz.com", false },
  { "pfo.io", true },
  { "pfolta.net", true },
  { "pfudor.tk", true },
  { "pgmann.cf", true },
  { "pgmsource.com", true },
  { "pgpm.io", true },
  { "pgpmail.cc", true },
  { "pgregg.com", false },
  { "pgtb.be", true },
  { "ph.search.yahoo.com", false },
  { "phalconist.com", true },
  { "phantasie.cc", true },
  { "phantastikon.de", true },
  { "pharmaboard.de", true },
  { "pharmgkb.org", true },
  { "pharynks.com", true },
  { "phcnetworks.net", true },
  { "phcorner.net", true },
  { "phenomeno-porto.com", true },
  { "phenomeno.nl", true },
  { "phenomenoporto.com", true },
  { "phenomenoporto.nl", true },
  { "phget.com", true },
  { "phi-works.com", true },
  { "phil-phillies.com", true },
  { "phil.tw", true },
  { "philadelphia.com.mx", true },
  { "philadelphiadancefoundation.org", true },
  { "philipkohn.com", true },
  { "philipmordue.co.uk", true },
  { "phillippi.me", true },
  { "phillmoore.com", true },
  { "phillprice.com", true },
  { "philosopherswool.com", true },
  { "philosophyguides.org", true },
  { "philphonic.de", true },
  { "philpropertygroup.com", true },
  { "philsturgeon.uk", true },
  { "phishingusertraining.com", true },
  { "phocean.net", true },
  { "phoenix.dj", true },
  { "phone-service-center.de", true },
  { "phonenumberinfo.co.uk", true },
  { "phormance.com", true },
  { "phosagro.biz", true },
  { "phosagro.com", true },
  { "phosagro.ru", true },
  { "photo.org.il", true },
  { "photoancestry.com", true },
  { "photoartelle.com", true },
  { "photoblogverona.com", true },
  { "photographyforchange.com", true },
  { "phototag.org", true },
  { "phoxmeh.com", true },
  { "php-bach.org", true },
  { "php-tuning.de", true },
  { "phparcade.com", true },
  { "phpbbchinese.com", true },
  { "phpdistribution.com", true },
  { "phpdorset.co.uk", true },
  { "phperformances.fr", true },
  { "phpkari.cz", true },
  { "phpmyadmin.net", true },
  { "phpprime.com", true },
  { "phpsecure.info", true },
  { "phra.gs", true },
  { "phryanjr.com", false },
  { "phryneas.de", true },
  { "phunehehe.net", true },
  { "phurl.de", true },
  { "phurl.io", true },
  { "physicalism.com", true },
  { "physicalist.com", true },
  { "physicaltherapist.com", true },
  { "pi-control.de", true },
  { "pi-eng.fr", true },
  { "pi-supply.com", true },
  { "pic.gov", true },
  { "pic2map.com", true },
  { "picallo.es", true },
  { "picardiascr.com", true },
  { "pickme.nl", true },
  { "pickr.co", true },
  { "picksin.club", true },
  { "picoauto.com", true },
  { "picone.com.au", true },
  { "piconepress.com", true },
  { "picotech.com", true },
  { "picotronic.biz", true },
  { "picotronic.de", true },
  { "picsandtours.com", true },
  { "picster.at", true },
  { "picsto.re", true },
  { "picturingjordan.com", true },
  { "pidomex.com", true },
  { "piekacz.co.uk", true },
  { "piekacz.eu.org", true },
  { "piekacz.net", true },
  { "piem.org", true },
  { "pieperhome.de", true },
  { "pieq.eu", true },
  { "pieq.eu.org", true },
  { "pier28.com", true },
  { "pierre-denoblens.net", true },
  { "pierre-schmitz.com", true },
  { "pierrejeansuau.fr", true },
  { "pieterhordijk.com", true },
  { "pieterjangeeroms.me", true },
  { "pietz.uk", true },
  { "pijuice.com", true },
  { "pileofgarbage.net", true },
  { "piligrimname.com", true },
  { "piliszek.net", true },
  { "pimhaarsma.nl", true },
  { "pimhaarsmamedia.nl", true },
  { "pimpmymac.ru", true },
  { "pims.global", true },
  { "pimspage.nl", true },
  { "pin.net.au", true },
  { "pincha.com.tw", true },
  { "pincodeit.com", true },
  { "pindanutjes.be", false },
  { "pinesandneedles.com", true },
  { "pinkcasino.co.uk", true },
  { "pinkfis.ch", true },
  { "pinkhq.com", true },
  { "pinkinked.com", true },
  { "pinkladyapples.co.uk", true },
  { "pinklecfest.org", true },
  { "pinnaclelife.co.nz", true },
  { "pinnaclelife.nz", true },
  { "pinoyonlinetv.com", true },
  { "pinpayments.com", true },
  { "pinpointengineer.co.uk", true },
  { "pinscher.com.br", true },
  { "pipenny.net", true },
  { "pir9.com", true },
  { "pirate.trade", true },
  { "piratebayproxy.tf", true },
  { "piratebit.tech", true },
  { "pirateproxy.la", true },
  { "pirateproxy.one", true },
  { "pirateproxy.pe", true },
  { "pirateproxy.pl", true },
  { "pirateproxy.pw", true },
  { "pirateproxy.red", true },
  { "pirateproxy.sx", true },
  { "pirateproxy.tf", true },
  { "pirateproxy.tv", true },
  { "pirateproxy.vip", true },
  { "piratesforums.co", true },
  { "pirman.es", true },
  { "pirxpilot.me", true },
  { "pissblau.com", true },
  { "pisupp.ly", true },
  { "pitchpinecapital.com", true },
  { "pitchup.com", true },
  { "pitfire.io", false },
  { "pitonarms.com", true },
  { "pittaya.com", true },
  { "piwko.co", true },
  { "pixdigital.net", true },
  { "pixel.facebook.com", false },
  { "pixel.google.com", true },
  { "pixelbash.de", true },
  { "pixelcubed.com", true },
  { "pixelminers.net", true },
  { "pixi.chat", true },
  { "pixi.me", true },
  { "pixipics.com", false },
  { "pixiv.moe", false },
  { "piyabute.com", true },
  { "pizala.de", true },
  { "pjili.com", true },
  { "pjuu.com", false },
  { "pkgt.de", false },
  { "pl.search.yahoo.com", false },
  { "placefade.com", true },
  { "placehold.co", true },
  { "placker.com", true },
  { "plainjs.com", false },
  { "plaintech.net.au", true },
  { "plaintray.com", true },
  { "planboardapp.com", true },
  { "planet-work.com", true },
  { "planete-cocoon.com", true },
  { "planete-lira.fr", true },
  { "planpharmacy.com", false },
  { "plass.hamburg", true },
  { "plasti-pac.ch", true },
  { "platten-nach-mass.de", true },
  { "plattner.club", true },
  { "play.google.com", true },
  { "playanka.com", true },
  { "playmaker.io", true },
  { "playsharp.com", true },
  { "playsoundevents.be", true },
  { "playsprout.industries", true },
  { "please-deny.me", true },
  { "pleasure.forsale", true },
  { "plen.io", true },
  { "plenigo.com", true },
  { "plexusmd.com", true },
  { "plfgr.eu.org", true },
  { "pliosoft.com", true },
  { "ploader.ru", false },
  { "ploxel.com", true },
  { "plueschmikrobe.de", true },
  { "plueschmikroben.de", true },
  { "plueschviren.de", true },
  { "plueschvirus.de", true },
  { "pluff.nl", true },
  { "pluga.co", true },
  { "plugcubed.net", false },
  { "plugin-planet.com", true },
  { "pluginsloaded.com", true },
  { "plumlocosoft.com", true },
  { "plus-5.com", true },
  { "plus.google.com", false },
  { "plus.sandbox.google.com", false },
  { "plushmania.de", true },
  { "plusstreamfeed.appspot.com", true },
  { "plzenskybarcamp.cz", true },
  { "pm-onboarding-external-dev.azurewebsites.net", true },
  { "pm-partners-management-dev.azurewebsites.net", true },
  { "pm13-media.cz", true },
  { "pm13.cz", true },
  { "pm13.org", true },
  { "pmalaty.com", true },
  { "pmctire.com", true },
  { "pmg-offshore-company.com", true },
  { "pmg-purchase.com", true },
  { "pmg-purchase.net", true },
  { "pmklaassen.com", true },
  { "pmnts.io", true },
  { "pmp-art.com", true },
  { "pmponline.de", true },
  { "pmsf.eu", true },
  { "pmt-documenten.nl", true },
  { "pnona.cz", true },
  { "pnut.io", false },
  { "pocketfullofapps.com", true },
  { "pocloud.homelinux.net", true },
  { "podemos.info", true },
  { "podshrink.de", true },
  { "poed.com.au", true },
  { "poedgirl.com", true },
  { "poinsot.info", false },
  { "pointaction.com", true },
  { "pointagri.com", true },
  { "pointeringles.com", true },
  { "pointiswunderland.de", true },
  { "pointpro.de", true },
  { "points4unitedway.com", true },
  { "pointsixtyfive.com", true },
  { "poitiers-ttacc-86.eu.org", true },
  { "pokeduel.me", true },
  { "pokefarm.com", true },
  { "pokeinthe.io", true },
  { "pokemori.jp", true },
  { "pol.in.th", true },
  { "polaire.org", true },
  { "pole.net.nz", true },
  { "poleartschool.com", true },
  { "policedriver.com", true },
  { "policeiwitness.sg", true },
  { "polimat.org", true },
  { "polis.or.at", true },
  { "polis.to", false },
  { "politic.org.ua", true },
  { "politiewervingshop.nl", true },
  { "politik-bei-uns.de", true },
  { "pollpodium.nl", true },
  { "polycoise.com", true },
  { "polycrypt.us", true },
  { "polymathematician.com", true },
  { "polynomapp.com", true },
  { "polypet.com.sg", true },
  { "polypho.nyc", true },
  { "pomar.club", true },
  { "pompefunebrilariviera.it", true },
  { "pompompoes.com", true },
  { "poneytelecom.org", true },
  { "ponolau.com", true },
  { "ponteencima.com", true },
  { "pontokay.com.br", false },
  { "ponythread.com", false },
  { "poollicht.be", true },
  { "poolvilla-margarita.net", false },
  { "poon.io", true },
  { "poon.tech", true },
  { "poris.web.id", false },
  { "pornbase.info", true },
  { "pornbay.org", true },
  { "porno-gif.ru", true },
  { "pornstars.me", true },
  { "porschen.fr", true },
  { "port443.hamburg", true },
  { "port80.hamburg", true },
  { "portal.tirol.gv.at", true },
  { "portalzine.de", true },
  { "portercup.com", true },
  { "portofrotterdam.com", true },
  { "portosonline.pl", true },
  { "portraitsystem.biz", true },
  { "portvaletickets.com", true },
  { "porybox.com", true },
  { "posaunenchor-senden.de", true },
  { "positivesobrietyinstitute.com", true },
  { "posobota.cz", true },
  { "post4me.at", true },
  { "postal.dk", true },
  { "postblue.info", true },
  { "postbox.life", true },
  { "postcodegarant.nl", true },
  { "posteo.de", false },
  { "posterspy.com", true },
  { "postfinance.ch", true },
  { "postmatescode.com", true },
  { "postn.eu", true },
  { "postpi.com", true },
  { "postscheduler.org", true },
  { "posttigo.com", true },
  { "potatofrom.space", false },
  { "potatoheads.net", true },
  { "potbar.com", true },
  { "potbox.com", true },
  { "pothe.com", true },
  { "pothe.de", true },
  { "potlytics.com", true },
  { "potpourrifestival.de", true },
  { "potsky.com", true },
  { "potterscraftcider.com", true },
  { "poupatempo.org", true },
  { "poussinooz.fr", true },
  { "povareschka.ru", true },
  { "povitria.net", true },
  { "power-coonies.de", true },
  { "power-of-interest.com", true },
  { "powerb.ch", true },
  { "powercloud.technology", true },
  { "powerentertainment.tv", true },
  { "powergridess.com", true },
  { "powermeter.at", true },
  { "poweroff.win", true },
  { "powershift.ne.jp", true },
  { "powerwellness-korecki.de", true },
  { "powerxequality.com", true },
  { "pozytywnyplan.pl", true },
  { "pozzo-balbi.com", true },
  { "ppipe.net", true },
  { "ppmoon.com", true },
  { "ppro.com", true },
  { "ppuu.org", false },
  { "pr1sm.com", true },
  { "pr2studio.com", true },
  { "practicallabs.com", true },
  { "practicepanther.com", true },
  { "practodev.com", true },
  { "prado.it", true },
  { "praeparation-keppner.de", true },
  { "praguepsychology.com", true },
  { "praguepsychology.cz", true },
  { "prakharprasad.com", true },
  { "pratinav.xyz", true },
  { "prattpokemon.com", true },
  { "praxis-research.info", true },
  { "prayerrequest.com", true },
  { "prazynka.pl", true },
  { "precedecaritas.com.br", true },
  { "prediksisydney.com", false },
  { "predoiu.ro", true },
  { "preezzie.com", true },
  { "preferredathlete.com", true },
  { "prefis.com", true },
  { "prefontaine.name", true },
  { "preisser-it.de", true },
  { "preisser.it", true },
  { "preissler.co.uk", true },
  { "prekladysanca.cz", true },
  { "preloaded-hsts.badssl.com", true },
  { "premierheart.com", true },
  { "premiumzweirad.de", false },
  { "prepandgo-euro.com", true },
  { "preparetheword.com", false },
  { "presbee.com", true },
  { "prescotonline.co.uk", true },
  { "prescriptiondrugs.com", true },
  { "president.bg", true },
  { "presidentials2016.com", true },
  { "prespanok.sk", true },
  { "press-anime-nenkan.com", true },
  { "presscenter.jp", true },
  { "pressrush.com", true },
  { "prestburyscouts.org.uk", true },
  { "pretix.eu", true },
  { "pretty.hu", true },
  { "prettytunesapp.com", true },
  { "pretzelx.com", true },
  { "preworkout.me", true },
  { "prgslab.net", false },
  { "prideindomination.com", true },
  { "pridetechdesign.com", true },
  { "pridoc.se", true },
  { "prielwurmjaeger.de", true },
  { "prilock.com", true },
  { "primates.com", true },
  { "primewho.org", true },
  { "princesparktouch.com", true },
  { "princessmargaretlotto.com", true },
  { "principaltoolbox.com", true },
  { "principia-journal.de", true },
  { "principia-magazin.de", true },
  { "principia-online.de", true },
  { "prinice.org", true },
  { "printeknologies.com", true },
  { "printerest.io", true },
  { "printfn.com", true },
  { "prior-it.be", true },
  { "priva.si", true },
  { "privacy-week-vienna.at", true },
  { "privacy-week.at", true },
  { "privacy.com", true },
  { "privacyinternational.org", true },
  { "privacyrup.net", true },
  { "privacyweek.at", true },
  { "privacyweekvienna.at", true },
  { "privategiant.com", true },
  { "privatepokertour.com", true },
  { "privaterelay.com", false },
  { "privatestatic.com", false },
  { "privea.fr", true },
  { "privytime.com", true },
  { "prjktruby.com", true },
  { "prnav.com", true },
  { "pro-bike.ro", true },
  { "pro-link.eu", true },
  { "pro-zone.com", true },
  { "probas.de", true },
  { "probiv.biz", true },
  { "procensus.com", true },
  { "procrastinationland.com", true },
  { "prodct.info", true },
  { "productdesignsoftware.com.au", true },
  { "productgap.com", true },
  { "production.vn", true },
  { "producto8.com", true },
  { "proefteksten.nl", true },
  { "profection.biz", true },
  { "professors.ee", true },
  { "profidea.cz", true },
  { "profiles.google.com", true },
  { "profitopia.de", true },
  { "profivps.com", true },
  { "profpay.com", true },
  { "profundr.com", true },
  { "profusion.io", true },
  { "progarm.org", true },
  { "progblog.net", true },
  { "progg.no", true },
  { "proggersession.de", true },
  { "progreso.pl", true },
  { "progress-linux.org", true },
  { "progress-technologies.com", true },
  { "progressiveplanning.com", true },
  { "prohostonline.fi", true },
  { "proitconsulting.com.au", true },
  { "proj.org.cn", true },
  { "project-sparks.eu", true },
  { "projectarmy.net", true },
  { "projectascension.io", true },
  { "projectbenson.com", false },
  { "projectblackbook.us", true },
  { "projectdp.net", true },
  { "projectmercury.space", true },
  { "projektik.cz", true },
  { "projektzentrisch.de", true },
  { "prok.pw", true },
  { "prolan.pw", true },
  { "prometheanfire.net", true },
  { "prometheanfire.org", true },
  { "promhadan.com", true },
  { "promisesaplus.com", true },
  { "promoscuola.net", true },
  { "promotiongeeks.com", false },
  { "prontocleaners.co.uk", true },
  { "prontomovers.co.uk", true },
  { "proofwiki.org", true },
  { "proos.nl", true },
  { "propactrading.com", true },
  { "propagandism.org", true },
  { "propershave.com", true },
  { "property-catalogue.eu", true },
  { "propertygroup.pl", true },
  { "propipesystem.com", true },
  { "proposalonline.com", true },
  { "proslimdiets.com", true },
  { "prosocialmachines.com", true },
  { "prospanek.cz", true },
  { "prospo.co", true },
  { "prot.ch", true },
  { "proteapower.co.za", true },
  { "protecciondelconsumidor.gov", true },
  { "proteus-tech.com", true },
  { "protonmail.ch", true },
  { "protonmail.com", true },
  { "protoxin.net", false },
  { "proust.ch", false },
  { "proust.media", false },
  { "proustmedia.de", false },
  { "proweser.de", true },
  { "prowise.com", true },
  { "proximato.com", true },
  { "proxybay.al", true },
  { "proxybay.co", true },
  { "proxybay.la", true },
  { "proxybay.one", true },
  { "proxybay.tv", true },
  { "proxyowl.pw", true },
  { "proxyportal.org", true },
  { "proxyweb.us", true },
  { "prstatic.com", true },
  { "prt.in.th", true },
  { "prtpe.com", true },
  { "pruikshop.nl", true },
  { "prvikvadrat.hr", true },
  { "prxio.date", true },
  { "przemas.pl", true },
  { "ps-provider.co.jp", true },
  { "ps-w.ru", true },
  { "ps-x.ru", true },
  { "psb1911.com", true },
  { "psbarrett.com", true },
  { "psicologia.co.ve", true },
  { "psicologoforensebarcelona.com", true },
  { "psncardplus.be", true },
  { "psncardplus.com", true },
  { "psncardplus.dk", true },
  { "psncardplus.nl", true },
  { "psncardplus.se", true },
  { "pste.pw", true },
  { "pstrozniak.com", true },
  { "pstudio.me", true },
  { "psw-group.de", true },
  { "psw.net", true },
  { "psxtr.com", true },
  { "psychedelia.com", true },
  { "psychedelics.org", true },
  { "psychoactive.com", true },
  { "psychotherapie-kp.de", true },
  { "pt-server.de", true },
  { "ptbi.org.pl", true },
  { "ptbx.co", true },
  { "pterodactylus.cz", true },
  { "ptgoldensun.com", true },
  { "ptm.ro", true },
  { "ptn.moscow", true },
  { "ptonet.com", true },
  { "puac.de", true },
  { "pubkey.is", true },
  { "publications.qld.gov.au", false },
  { "publiccarauctionscalifornia.com", true },
  { "publicidadnovagrass.com.mx", true },
  { "publicintegrity.org", true },
  { "publicspeakingcamps.com", true },
  { "publicsuffix.org", true },
  { "publimepa.it", false },
  { "pubreviews.com", true },
  { "pucchi.net", true },
  { "pucssa.org", true },
  { "puddis.de", true },
  { "pugliese.fr", true },
  { "pugovka72.ru", true },
  { "puhe.se", true },
  { "puikheid.nl", true },
  { "puiterwijk.org", true },
  { "puli.com.br", true },
  { "pulsar.guru", false },
  { "pult.co", false },
  { "pumpgames.net", true },
  { "punchkickinteractive.com", false },
  { "punitsheth.com", true },
  { "punkapoule.fr", true },
  { "punknews.org", true },
  { "pupboss.com", true },
  { "puppydns.com", true },
  { "purewebmasters.com", false },
  { "purplebricks.com", true },
  { "purplemoon.ch", true },
  { "purpleplains.net", true },
  { "purplepr.bg", true },
  { "purplestar.ch", true },
  { "purplestar.com", true },
  { "puryearlaw.com", true },
  { "push.world", true },
  { "put.re", true },
  { "puurwonengeldrop.nl", true },
  { "puyblanc.info", true },
  { "puzz.gg", true },
  { "puzz.me", true },
  { "pvcvoordeel.nl", false },
  { "pvpcraft.ca", true },
  { "pvtschlag.com", true },
  { "pwd.ovh", true },
  { "pwdgen.net", true },
  { "pwfrance.com", true },
  { "pwnies.dk", true },
  { "pwntr.com", true },
  { "pwolk.com", true },
  { "pxx.io", true },
  { "pycrypto.org", true },
  { "pygarage.com", true },
  { "pyol.org", true },
  { "pypa.io", true },
  { "pypi-mirrors.org", true },
  { "pypi.io", true },
  { "pypi.org", true },
  { "pypi.python.org", true },
  { "pyrotechnologie.de", true },
  { "pysays.net", true },
  { "pyspace.org", true },
  { "pythia.nz", true },
  { "python-hyper.org", true },
  { "python.org", false },
  { "pzme.me", true },
  { "q-inn.com", true },
  { "q-inn.nl", true },
  { "qa.fedoraproject.org", true },
  { "qa.stg.fedoraproject.org", true },
  { "qandavision.com", false },
  { "qapital.com", true },
  { "qbeing.info", true },
  { "qbiju.com.br", true },
  { "qbin.io", true },
  { "qbus.pl", true },
  { "qc.search.yahoo.com", false },
  { "qccareerschool.com", false },
  { "qccqld.org.au", true },
  { "qcdesignschool.com", false },
  { "qceventplanning.com", false },
  { "qcmakeupacademy.com", false },
  { "qcstudentcenter.com", false },
  { "qcstyleacademy.com", false },
  { "qctravelschool.com", false },
  { "qe2homelottery.com", true },
  { "qedcon.org", true },
  { "qetesh.de", true },
  { "qewc.com", true },
  { "qgustavor.tk", true },
  { "qianalysis.com", true },
  { "qikan.net", true },
  { "qiliang.wang", true },
  { "qingpei.me", false },
  { "qionglu.pw", true },
  { "qipp.com", true },
  { "qits.de", true },
  { "qivonline.pt", true },
  { "qiwi.be", true },
  { "qixxit.de", true },
  { "qkka.org", true },
  { "qkmortgage.com", true },
  { "qldconservation.org", true },
  { "qldconservation.org.au", true },
  { "qldformulaford.org", true },
  { "qlrace.com", false },
  { "qm-marzahnnordwest.de", true },
  { "qochealth.com", true },
  { "qonqa.de", true },
  { "qop.io", true },
  { "qotw.net", true },
  { "qqj.net", true },
  { "qqq.gg", true },
  { "qr-city.org", true },
  { "qrlfinancial.com", true },
  { "qtl.me", true },
  { "qto.com", true },
  { "qtpass.org", true },
  { "qtpower.co.uk", true },
  { "qtpower.net", true },
  { "qtpower.org", true },
  { "qtvr.com", true },
  { "qtxh.net", true },
  { "quaedam.org", true },
  { "quai10.org", false },
  { "quail.solutions", true },
  { "quakelive.dk", true },
  { "qualityedgarsolutions.com", true },
  { "qualityhomesystems.com", true },
  { "qualityofcourse.com", false },
  { "qualityology.com", true },
  { "quanglepro.com", true },
  { "quantacloud.ch", true },
  { "quantenteranik.eu", true },
  { "quantoras.com", true },
  { "quantum-cloud.xyz", true },
  { "quantumfurball.net", true },
  { "quarterfull.com", true },
  { "qubyte.codes", true },
  { "quchao.com", true },
  { "queercinema.ch", true },
  { "queminventou.com.br", true },
  { "quemmeliga.com", true },
  { "quera.ir", true },
  { "questionable.host", true },
  { "questsandrewards.com", true },
  { "questsocial.it", true },
  { "quickboysvrouwen2.nl", true },
  { "quickpayservice.com", true },
  { "quietapple.org", true },
  { "quikchange.net", true },
  { "quikpay.com.au", true },
  { "quinnlabs.com", true },
  { "quintessa.org", true },
  { "quire.io", true },
  { "quirino.ch", true },
  { "quizogames.com", true },
  { "qul.link", true },
  { "quotehex.com", true },
  { "quotemaster.co.za", true },
  { "quotev.com", true },
  { "quppa.net", true },
  { "quuz.org", true },
  { "qvitoo.com", true },
  { "qwant.com", true },
  { "qwant.fr", true },
  { "qwaser.fr", true },
  { "qweepi.de", true },
  { "qwikdash.com", true },
  { "r-core.org", true },
  { "r-core.ru", true },
  { "r-cut.fr", true },
  { "r0t.co", true },
  { "r0uzic.net", true },
  { "r2d2pc.com", true },
  { "r3s1stanc3.me", true },
  { "r40.us", true },
  { "r6-team.ru", true },
  { "r811.de", true },
  { "ra-micro-koeln.de", true },
  { "ra-schaal.de", true },
  { "ra4wvpn.com", true },
  { "raah.co", true },
  { "raajheshkannaa.com", true },
  { "racasdecachorro.org", true },
  { "racermaster.xyz", false },
  { "raceviewcycles.com", true },
  { "raceviewequestrian.com", true },
  { "rachaelrussell.com", true },
  { "racius.com", true },
  { "raconconsulting.co.uk", true },
  { "rad-route.de", true },
  { "radar.sx", true },
  { "radfieldhomecare.co.uk", true },
  { "radfieldhomecarefranchising.co.uk", true },
  { "radicaleducation.net", false },
  { "radioilusion.es", true },
  { "radionicabg.com", true },
  { "radiopolarniki.spb.ru", true },
  { "radiormi.com", true },
  { "radreisetraumtreibstoff.de", true },
  { "radtke.bayern", true },
  { "radyn.com", true },
  { "rafaelcz.de", true },
  { "rafting-japan.com", true },
  { "rage4.com", true },
  { "ragingserenity.com", true },
  { "raidstone.com", true },
  { "raidstone.net", true },
  { "raidstone.rocks", true },
  { "railgun.ac", true },
  { "railgun.com.cn", true },
  { "railjob.cn", true },
  { "railyardurgentcare.com", true },
  { "rainbowbay.org", true },
  { "rainforest.engineering", true },
  { "rainm.eu", true },
  { "raiseyourflag.com", true },
  { "raissarobles.com", true },
  { "raitza.de", true },
  { "rak-business-service.com", true },
  { "ralfs-zusizone.de", true },
  { "rally-base.com", true },
  { "ram-it.nl", true },
  { "ramatola.uk", true },
  { "rametrix.com", true },
  { "ramon-c.nl", true },
  { "ramonj.nl", true },
  { "ramshair.jp", false },
  { "ramsor-gaming.de", true },
  { "randc.org", true },
  { "randomcloud.net", true },
  { "randomkoalafacts.com", true },
  { "randomprecision.co.uk", true },
  { "randstaddirect.nl", true },
  { "rangde.org", true },
  { "rantanda.com", true },
  { "ranzbak.nl", true },
  { "rapenroer.com", true },
  { "rapenroer.nl", true },
  { "raphael.li", true },
  { "rapidshit.net", true },
  { "rapidthunder.io", true },
  { "rasagiline.com", true },
  { "rasebo.ro", true },
  { "raspass.me", true },
  { "raspberry.us", true },
  { "ratajczak.fr", true },
  { "ratd.net", true },
  { "rate-esport.de", true },
  { "rathorian.fr", true },
  { "rationalism.com", true },
  { "rationalops.com", true },
  { "ratuseks.com", false },
  { "ratuseks.net", false },
  { "ratuseks.us", false },
  { "raulfraile.net", true },
  { "raumzeitlabor.de", true },
  { "rauros.net", true },
  { "rautermods.net", true },
  { "ravage.fm", true },
  { "ravchat.com", true },
  { "raven.lipetsk.ru", true },
  { "ravensbuch.de", true },
  { "ravindran.me", true },
  { "ravkr.duckdns.org", true },
  { "ravse.dk", true },
  { "rawoil.com", true },
  { "rawsec.net", true },
  { "rawstorieslondon.com", true },
  { "ray-home.de", true },
  { "ray-works.de", true },
  { "raydan.space", true },
  { "raydobe.me", false },
  { "rayiris.com", true },
  { "raymd.de", true },
  { "raymii.org", true },
  { "raymondelooff.nl", true },
  { "raymondjcox.com", true },
  { "raytron.org", true },
  { "rayworks.de", true },
  { "razlaw.name", true },
  { "razzolini.com.br", true },
  { "rbensch.com", true },
  { "rbhighinc.org", true },
  { "rbose.org", true },
  { "rbqcloud.com", true },
  { "rbtvshitstorm.is", true },
  { "rburchell.com", true },
  { "rbxcatalog.com", true },
  { "rc-offi.net", true },
  { "rca.fr", true },
  { "rcafox.com", true },
  { "rcnitrotalk.com", true },
  { "rcorporation.be", true },
  { "rdh.asia", true },
  { "rdl.at", true },
  { "reachr.com", true },
  { "reaconverter.com", true },
  { "react-db.com", true },
  { "reactivarte.es", true },
  { "reader.ga", true },
  { "readism.io", true },
  { "readmeeatmedrinkme.com", true },
  { "readonly.de", true },
  { "readouble.com", false },
  { "readr.pw", true },
  { "readytongue.com", true },
  { "reaganlibrary.gov", true },
  { "real-compare.com", true },
  { "real-it.nl", true },
  { "realcapoeira.ru", true },
  { "realgarant-shop.de", false },
  { "reality0ne.com", true },
  { "reallifeforums.com", true },
  { "realloc.me", true },
  { "realmic.net", true },
  { "realmofespionage.com", true },
  { "realmofespionage.xyz", true },
  { "realwaycome.com", true },
  { "realwoo.com", true },
  { "reanimated.eu", true },
  { "reapdrive.net", true },
  { "reaper.rip", true },
  { "reardenporn.com", true },
  { "rebekaesgabor.online", true },
  { "rebootmc.com", true },
  { "recapp.ch", true },
  { "recepty.eu", true },
  { "rechenknaecht.de", true },
  { "rechenwerk.net", true },
  { "recht-freundlich.de", true },
  { "recommended.reviews", true },
  { "recompiled.org", true },
  { "recon-networks.com", true },
  { "recordeuropa.com", false },
  { "recreoviral.com", true },
  { "recurly.com", true },
  { "recyclingpromotions.us", true },
  { "red-t-shirt.ru", true },
  { "redable.hosting", true },
  { "redable.nl", true },
  { "redb.cz", true },
  { "redballoonsecurity.com", true },
  { "redburn.com", true },
  { "redd.it", true },
  { "reddingsbrigade-zwolle.nl", true },
  { "reddit2kindle.com", true },
  { "rede-reim.de", true },
  { "redheeler.com.br", true },
  { "redicabo.de", true },
  { "redigest.it", true },
  { "redirect.fedoraproject.org", true },
  { "redirect.stg.fedoraproject.org", true },
  { "rediske.me", true },
  { "redit.com", true },
  { "redletter.link", true },
  { "redlink.de", true },
  { "rednsx.org", true },
  { "redoakmedia.net", true },
  { "redports.org", false },
  { "redprice.by", true },
  { "redra.ws", true },
  { "redshield.co", true },
  { "redshiftcybersecurity.co.za", true },
  { "redstickfestival.org", true },
  { "redstoner.com", true },
  { "redteam-pentesting.de", true },
  { "redwoodpaddle.es", true },
  { "redy.host", true },
  { "redzurl.com", true },
  { "reed-sensor.com", true },
  { "reedloden.com", true },
  { "reezer.org", true },
  { "refactor.zone", true },
  { "refill-roboter.de", true },
  { "refitplanner.com", true },
  { "refreshingserum.com", true },
  { "refundo.cz", true },
  { "refundo.sk", true },
  { "reg.ru", false },
  { "regain.us", true },
  { "regalosymuestrasgratis.com", true },
  { "reganclassics.co.uk", true },
  { "reganclassics.com", true },
  { "reganparty.com", true },
  { "regar42.fr", false },
  { "regendevices.eu", true },
  { "regio-salland.nl", true },
  { "regiobeveland.nl", true },
  { "regionalcoalition.org", true },
  { "regionale.org", true },
  { "regiosalland.nl", true },
  { "regiovertrieb.de", false },
  { "register.gov.uk", true },
  { "regmyr.se", true },
  { "regolithmedia.com", true },
  { "rehabili-shigoto.com", true },
  { "rehabthailand.com", true },
  { "rei.ki", true },
  { "reiki-coaching.nl", true },
  { "reikiqueen.uk", true },
  { "reilly.io", true },
  { "reimers.de", true },
  { "reinaertvandecruys.me", true },
  { "reinaldudras.ee", true },
  { "reinencaressa.be", true },
  { "reinhardtsgrimma.de", true },
  { "reinout.nu", true },
  { "reinouthoornweg.nl", true },
  { "reishunger.de", true },
  { "reithguard-it.de", true },
  { "rejo.in", true },
  { "relatethesport.com", true },
  { "relatic.net", true },
  { "relaxhavefun.com", true },
  { "relaxpointhyncice.cz", true },
  { "relayawards.com", true },
  { "relaybox.io", true },
  { "release-monitoring.org", true },
  { "reliancebank.bank", true },
  { "rem.pe", true },
  { "rem0te.net", true },
  { "rema.site", true },
  { "remaimodern.org", true },
  { "remambo.jp", true },
  { "remedica.fr", true },
  { "rememberthemilk.com", false },
  { "rememberthis.co.za", true },
  { "remodela.com.ve", true },
  { "remonti.info", true },
  { "remote.so", true },
  { "remotestance.com", true },
  { "remoteutilities.com", true },
  { "rencaijia.com", true },
  { "renderloop.com", true },
  { "rene-schwarz.com", true },
  { "rene-stolp.de", true },
  { "renemayrhofer.com", true },
  { "renemoser.net", true },
  { "renerehelse.no", true },
  { "renewablefreedom.org", true },
  { "renideo.fr", true },
  { "renkenlaw.com", true },
  { "renkhosting.com", true },
  { "renrenche.com", false },
  { "rent-a-coder.de", true },
  { "rentacarcluj.xyz", true },
  { "rentasweb.gob.ar", true },
  { "rentbrowser.com", true },
  { "rentbrowsertrain.me", true },
  { "rentcarassist.com", false },
  { "rentinsingapore.com.sg", true },
  { "renuo.ch", true },
  { "reox.at", false },
  { "repair.by", true },
  { "repaxan.com", true },
  { "replicagunsswords.com", false },
  { "report-uri.com", true },
  { "report-uri.io", true },
  { "reporturi.com", true },
  { "reporturi.io", true },
  { "reproductive-revolution.com", true },
  { "reptrax.com", true },
  { "republique.org", true },
  { "repugnant-conclusion.com", true },
  { "repustate.com", true },
  { "reputationweaver.com", true },
  { "reqrut.net", true },
  { "resama.eu", true },
  { "resc.la", true },
  { "research.md", true },
  { "resist.ca", true },
  { "resources.flowfinity.com", true },
  { "respice.xyz", true },
  { "respon.jp", true },
  { "responer.com", true },
  { "responsibledisclosure.nl", false },
  { "restoruns.com", true },
  { "restrealitaet.de", true },
  { "restrito.org", true },
  { "retcor.net", true },
  { "reth.ch", true },
  { "reto.com", true },
  { "retroarms.com", true },
  { "retroarms.cz", true },
  { "retrofitlab.com", true },
  { "retube.ga", true },
  { "reucon.com", true },
  { "reulitz.de", true },
  { "reuter-shop.com", true },
  { "reuter.de", true },
  { "revamed.com", false },
  { "revapost.ch", true },
  { "revensoftware.com", true },
  { "revlect.com", true },
  { "revolt.tv", true },
  { "revthefox.co.uk", true },
  { "rewardingexcellence.com", true },
  { "rewrite3.com", true },
  { "rex.st", true },
  { "rex.tc", true },
  { "rezept-planer.de", true },
  { "rezexpert.com", true },
  { "rezosup.net", true },
  { "rezosup.org", true },
  { "rezun.cloud", true },
  { "rgavmf.ru", true },
  { "rgservers.com", true },
  { "rhapsodhy.hu", true },
  { "rhdigital.pro", true },
  { "rhees.nl", true },
  { "rheinneckarmetal.com", true },
  { "rheocube.com", true },
  { "rhering.de", true },
  { "rheuma-online.de", true },
  { "rhinelander.ca", true },
  { "rhodenmanorcattery.co.uk", true },
  { "rhodesianridgeback.com.br", true },
  { "rhodosdreef.nl", true },
  { "rhodri.io", true },
  { "rhymix.org", true },
  { "rhynl.io", true },
  { "riaucybersolution.net", true },
  { "ribs.com", true },
  { "riccy.org", true },
  { "riceadvice.info", true },
  { "riceglue.com", true },
  { "richardb.me", true },
  { "richardhering.de", true },
  { "richardlangworth.com", true },
  { "richardwarrender.com", true },
  { "richmtdriver.com", true },
  { "richsiciliano.com", true },
  { "richterphilipp.com", true },
  { "ricki-z.com", true },
  { "rickrongen.nl", true },
  { "rickweijers.nl", true },
  { "rickyromero.com", true },
  { "rico-brase.de", true },
  { "ricochet.im", true },
  { "ricozienke.de", true },
  { "rid-wan.com", false },
  { "ride-up.com", true },
  { "rideaudiscount.com", true },
  { "rideforwade.com", true },
  { "rideforwade.net", true },
  { "rideforwade.org", true },
  { "ridingboutique.de", true },
  { "ridwan.co", true },
  { "riesenmagnete.de", true },
  { "riesenmikrobe.de", true },
  { "riesenmikroben.de", true },
  { "riesenviren.de", true },
  { "rift.pictures", true },
  { "rigart-michael.be", true },
  { "rigartmichael.be", true },
  { "righettod.eu", true },
  { "right-to-love.name", true },
  { "right2.org", true },
  { "rightbrain.training", true },
  { "rightcapital.com", true },
  { "rightstuff.link", true },
  { "righttobuy.gov.uk", true },
  { "rigolitch.fr", true },
  { "riiconnect24.net", true },
  { "rijk-catering.nl", false },
  { "rijschoolgevonden.nl", false },
  { "rika.me", true },
  { "rileyevans.co.uk", true },
  { "rimo.site", true },
  { "ringh.am", true },
  { "ringingliberty.com", true },
  { "rinobroer.nl", true },
  { "rio-weimar.de", true },
  { "rip-sport.cz", true },
  { "ripple.com", true },
  { "riscascape.net", true },
  { "rischard.org", true },
  { "riseup.net", true },
  { "riskmgt.com.au", true },
  { "riskmitigation.ch", true },
  { "ristioja.ee", true },
  { "ristoarea.it", true },
  { "ristorantefattoamano.eu", true },
  { "rithm.ch", true },
  { "rivastation.de", true },
  { "riverbanktearooms.co.uk", true },
  { "rivermendhealthcenters.com", true },
  { "riversideauto.net", true },
  { "rivlo.com", true },
  { "rivy.org", true },
  { "rix.ninja", true },
  { "riyono.com", true },
  { "rj.gg", true },
  { "rjnutrition.consulting", true },
  { "rk6.cz", true },
  { "rlalique.com", true },
  { "rleh.de", true },
  { "rmb.li", true },
  { "rmdlingerie.com.br", true },
  { "rmf.io", true },
  { "rmmanfredi.com", true },
  { "rms.sexy", true },
  { "rmstudio.tw", true },
  { "rngmeme.com", true },
  { "ro.search.yahoo.com", false },
  { "roadfeast.com", true },
  { "roave.com", true },
  { "robandjanine.com", true },
  { "robertglastra.com", true },
  { "roberthurlbut.com", true },
  { "robertkrueger.de", true },
  { "roberto-webhosting.nl", true },
  { "robertof.ovh", false },
  { "robhorstmanshof.nl", true },
  { "robi-net.it", true },
  { "robin.info", true },
  { "robinadr.com", true },
  { "robinhoodbingo.com", true },
  { "robinsonyu.com", true },
  { "robinwinslow.uk", true },
  { "robjager-fotografie.nl", true },
  { "robodeidentidad.gov", true },
  { "robohash.org", true },
  { "robototes.com", true },
  { "robspc.repair", true },
  { "robtex.com", true },
  { "robud.info", true },
  { "robust.ga", true },
  { "rochman.id", true },
  { "rockcanyonbank.com", true },
  { "rocketr.net", true },
  { "rockeyscrivo.com", true },
  { "rocssti.net", true },
  { "rodehutskors.net", true },
  { "rodolfo.gs", true },
  { "rodrigocarvalho.blog.br", true },
  { "roeckx.be", true },
  { "roeitijd.nl", true },
  { "roelf.org", true },
  { "roelof.io", true },
  { "roeper.party", true },
  { "roerstaafjes.nl", true },
  { "roesemann.email", true },
  { "roessner-network-solutions.com", true },
  { "roffe.nu", true },
  { "roflcopter.fr", true },
  { "rogerbastien.com", true },
  { "rogerriendeau.ca", true },
  { "rogue-e.xyz", true },
  { "roguesignal.net", true },
  { "roguetechhub.org", true },
  { "rohedaten.de", true },
  { "rohitagr.com", true },
  { "rohlik.cz", true },
  { "rointe.online", true },
  { "roketix.co.uk", true },
  { "rokki.ch", true },
  { "rokort.dk", true },
  { "rokudenashi.de", true },
  { "roland.io", true },
  { "rolandreed.cn", true },
  { "rolandszabo.com", true },
  { "rolemaster.net", true },
  { "roleplayhome.com", true },
  { "rolodato.com", true },
  { "romab.com", true },
  { "romaimperator.com", true },
  { "romainmuller.xyz", true },
  { "roman-pavlik.cz", true },
  { "romanpavlodar.kz", true },
  { "romanticvillas.com.au", true },
  { "rome.dating", true },
  { "romeoferraris.com", true },
  { "rommelwood.de", true },
  { "romulusapp.com", false },
  { "ron2k.za.net", true },
  { "rondommen.nl", true },
  { "ronomon.com", true },
  { "roo.ie", true },
  { "room-checkin24.de", true },
  { "room208.org", true },
  { "room3b.eu", true },
  { "roombase.nl", true },
  { "roomhub.jp", true },
  { "roosterpgplus.nl", true },
  { "root.eu.org", true },
  { "rootrelativity.com", true },
  { "roots-example-project.com", true },
  { "roots.io", true },
  { "rootswitch.com", true },
  { "rootusers.com", true },
  { "rootwpn.com", true },
  { "rop.io", false },
  { "roquecenter.org", true },
  { "rose-prism.org", true },
  { "roseitsolutions.co.uk", true },
  { "rosemariefloydballet.com", true },
  { "rosenkeller.org", true },
  { "rosewoodranch.com", true },
  { "roslynpad.net", true },
  { "rosset.me", true },
  { "rosset.net", true },
  { "rosslug.org.uk", true },
  { "rot47.net", true },
  { "rotozen.com", true },
  { "rotterdamjazz.info", true },
  { "rottweil-hilft.de", true },
  { "rotunneling.net", true },
  { "rotzonline.com", true },
  { "roughgrain.com", true },
  { "roundcube.mayfirst.org", false },
  { "rous.se", true },
  { "rowancasting.ie", true },
  { "rowankaag.nl", true },
  { "rowlog.com", true },
  { "roxtri.cz", true },
  { "royal-rangers.de", true },
  { "royalacademy.org.uk", true },
  { "royalhop.co", true },
  { "royalmarinesassociation.org.uk", true },
  { "royalpalacenogent.fr", true },
  { "royalsignaturecruise.com", true },
  { "royalvisiongroup.com", true },
  { "royzez.com", true },
  { "rozalisbengal.ro", true },
  { "rpgmaker.es", true },
  { "rpherbig.com", true },
  { "rprimas.duckdns.org", true },
  { "rpy.xyz", true },
  { "rq-labo.jp", true },
  { "rr.in.th", true },
  { "rr105.de", true },
  { "rring.me", true },
  { "rro.rs", true },
  { "rrom.me", true },
  { "rsajeey.info", true },
  { "rsampaio.info", true },
  { "rsauget.fr", true },
  { "rsi.im", false },
  { "rssr.se", true },
  { "rsync.eu", false },
  { "rtcx.net", true },
  { "rtd.uk.com", true },
  { "rte.eu", true },
  { "rtechservices.io", true },
  { "rtejr.ie", true },
  { "rtek.se", true },
  { "rtfpessoa.xyz", true },
  { "rtho.me", true },
  { "ru-sprachstudio.ch", true },
  { "ru.search.yahoo.com", false },
  { "ruanmi.de", true },
  { "rubbermaidoutlet.com", true },
  { "rubecodeberg.com", true },
  { "rubendv.be", true },
  { "rubi-ka.net", false },
  { "rubyist.today", true },
  { "rubyquincunx.com", true },
  { "rubysecurity.org", true },
  { "rudd-o.com", true },
  { "ruderverein-gelsenkirchen.de", true },
  { "ruffbeatz.com", true },
  { "rugby.video", true },
  { "rugk.dedyn.io", true },
  { "rugstorene.co.uk", true },
  { "ruh-veit.de", true },
  { "ruhrmobil-e.de", true },
  { "ruhrnalist.de", true },
  { "ruig.jp", true },
  { "ruja.dk", true },
  { "rullzer.com", true },
  { "runawebinar.nl", true },
  { "runcarina.com", true },
  { "rundumcolumn.xyz", true },
  { "runementors.com", true },
  { "runnergrapher.com", true },
  { "runreport.fr", true },
  { "runtl.com", true },
  { "runvs.io", true },
  { "runway2street.com", false },
  { "ruobiyi.com", true },
  { "rus-trip.ru", false },
  { "rusempire.ru", true },
  { "rusl.net", true },
  { "russellandbrowns.co.uk", true },
  { "russia.dating", true },
  { "russmarshall.com", true },
  { "rustable.com", true },
  { "rustfanatic.com", true },
  { "rustyrambles.com", true },
  { "rusxakep.com", true },
  { "rutgerschimmel.nl", true },
  { "ruudkoot.nl", true },
  { "rva-asbestgroep.nl", true },
  { "rvsa2bevestigingen.nl", true },
  { "rvsa4bevestigingen.nl", true },
  { "rvsbevestigingen.nl", true },
  { "rw-solutions.tech", true },
  { "rwanderlust.com", false },
  { "rws-vertriebsportal.de", true },
  { "rww.name", true },
  { "rxbn.de", true },
  { "rxbusiness.com", true },
  { "ryan-goldstein.com", true },
  { "ryanbritton.com", true },
  { "ryanhowell.io", true },
  { "ryankearney.com", true },
  { "ryanmcdonough.co.uk", true },
  { "rylin.net", true },
  { "rynekpierwotny.pl", true },
  { "s-c.se", true },
  { "s-cubed.net", true },
  { "s-mainte.com", true },
  { "s-mdb.com", true },
  { "s007.co", true },
  { "s13d.fr", true },
  { "s16e.no", true },
  { "sa.net", true },
  { "saamhorigheidsfonds.nl", false },
  { "saba-piserver.info", true },
  { "sabahattin-gucukoglu.com", true },
  { "sacaentradas.com", true },
  { "saccani.net", true },
  { "sackers.com", true },
  { "sadbox.es", true },
  { "sadbox.org", true },
  { "sadhawkict.org", true },
  { "safar.sk", true },
  { "safcstore.com", true },
  { "safeex.com", true },
  { "safegroup.pl", true },
  { "safejourney.education", true },
  { "safelist.eu", true },
  { "safematix.com", true },
  { "safeme.ga", true },
  { "safemovescheme.co.uk", true },
  { "safer-networking.org", true },
  { "saferchildren.eu", true },
  { "saferedirectlink.com", true },
  { "saferpost.com", true },
  { "safersurfing.eu", true },
  { "safescan.com", true },
  { "safetext.me", true },
  { "safetyrisk.net", true },
  { "safing.me", true },
  { "safire.ac.za", true },
  { "sagedocumentmanager.com", true },
  { "sagemontchurch.org", true },
  { "sagerus.com", true },
  { "sagsmarseille.com", true },
  { "sahar.io", true },
  { "saharalondon.com", false },
  { "saharmassachi.com", true },
  { "saikarra.com", true },
  { "sail-nyc.com", true },
  { "sailormoonevents.org", false },
  { "sainth.de", true },
  { "saintsrobotics.com", true },
  { "saiputra.com", true },
  { "salaervergleich.com", true },
  { "salamanderpaddlegear.com", true },
  { "sale4ru.ru", true },
  { "saleaks.org", true },
  { "salesflare.com", true },
  { "saleslift.pl", true },
  { "salmo23.com.br", true },
  { "salmododia.net", true },
  { "salmonvision.com.tw", true },
  { "salmos91.com", true },
  { "salon.io", false },
  { "salsa-straubing.de", true },
  { "saltbythesea.com", true },
  { "saltercane.com", false },
  { "saltra.online", true },
  { "saltro.nl", true },
  { "saltstack.cz", true },
  { "saludsis.mil.co", true },
  { "salverainha.org", true },
  { "samaritansnet.org", true },
  { "samba.org", true },
  { "sambaash.com", true },
  { "sambeso.net", true },
  { "samegoal.com", true },
  { "samegoal.org", true },
  { "samel.de", true },
  { "samenwerkingsportaal.nl", true },
  { "samenwerkingsportaal.tk", true },
  { "sametovymesic.cz", true },
  { "samfunnet.no", false },
  { "samifar.in", true },
  { "samirnassar.com", true },
  { "samizdat.cz", true },
  { "samkelleher.com", true },
  { "saml-gateway.org", true },
  { "saml2.com", true },
  { "sampcup.com", false },
  { "samraskauskas.com", true },
  { "samuelkeeley.com", true },
  { "samwilberforce.com", true },
  { "samwu.tw", false },
  { "sanandreasstories.com", true },
  { "sanasport.cz", true },
  { "sanatfilan.com", false },
  { "sanchez.adv.br", true },
  { "sandalj.com", true },
  { "sandbagexpress.com", true },
  { "sandbox.mydigipass.com", false },
  { "sanderdorigo.nl", true },
  { "sanderknape.com", true },
  { "sandervankasteel.nl", false },
  { "sandmarc.cz", true },
  { "sandobygg.se", true },
  { "sandogruppen.se", true },
  { "sandor.wtf", true },
  { "sanglierhurlant.fr", true },
  { "sanguoxiu.com", true },
  { "sangwon.io", true },
  { "sangwon.org", true },
  { "sanhei.ch", true },
  { "sanissimo.com.mx", true },
  { "sanradon.by", true },
  { "sansdev.com", true },
  { "sansonehowell.com", true },
  { "santanderideas.com", true },
  { "santing.net", true },
  { "saorsat.ie", true },
  { "saorviewconnect.ie", true },
  { "saorviewconnected.ie", true },
  { "saotn.org", true },
  { "sapience.com", true },
  { "sapk.fr", true },
  { "sapporobeer.com", true },
  { "sarahbeckettharpist.com", true },
  { "sarahlicity.co.uk", false },
  { "sarahlicity.me.uk", true },
  { "sarahs-roestcafe.de", false },
  { "sarahsweetlife.com", true },
  { "sarahsweger.com", true },
  { "sarahvictor.co.uk", true },
  { "sarakas.com", true },
  { "saraleebread.com", true },
  { "sarangsemutbandung.com", true },
  { "sarasturdivant.com", true },
  { "sardegnatirocini.it", true },
  { "sarindia.com", true },
  { "sarindia.de", true },
  { "saro.me", true },
  { "sas-snowboarding.sk", true },
  { "sash.pw", true },
  { "saskpension.com", true },
  { "sasyabapi.com", true },
  { "sat.rent", true },
  { "sat4all.com", true },
  { "satai.dk", true },
  { "satmd.de", true },
  { "satoshicrypt.com", true },
  { "satrent.com", true },
  { "satrent.se", true },
  { "saturn.pl", true },
  { "saturne.tk", true },
  { "sauerbrey.eu", true },
  { "saulchristie.com", true },
  { "saumon.xyz", true },
  { "saunas.fr", true },
  { "sauvagebridge.nl", true },
  { "savageorgiev.com", true },
  { "save.gov", true },
  { "saveaward.gov", true },
  { "savekorea.net", true },
  { "savenet.org", true },
  { "savetheinternet.eu", true },
  { "savic.com", true },
  { "savingrecipe.com", true },
  { "savingsstoreonline.ca", true },
  { "savvysuit.com", true },
  { "savvytime.com", true },
  { "saxoncreative.com", true },
  { "say-hanabi.com", true },
  { "sayprepay.com", true },
  { "sazuz.cz", true },
  { "sb-group.dk", true },
  { "sb.im", true },
  { "sb.sb", true },
  { "sber.us", true },
  { "sbiewald.de", true },
  { "sbirecruitment.co.in", true },
  { "sbm.cloud", true },
  { "sbssoft.ru", true },
  { "sc4le.com", true },
  { "scaling.solutions", true },
  { "scandicom.fi", true },
  { "scandinavia.dating", true },
  { "scanleasing.net", true },
  { "scannabi.com", true },
  { "scanpay.dk", true },
  { "scenester.tv", true },
  { "scepticism.com", true },
  { "schachburg.de", true },
  { "schadegarant.net", true },
  { "schallert.com", false },
  { "schamlosharmlos.de", true },
  { "schauer.so", true },
  { "schawe.me", true },
  { "schd.io", true },
  { "scheidtweiler.de", true },
  { "schelberts.de", true },
  { "schenkes.de", true },
  { "scherzstempel.de", true },
  { "schildbach.de", true },
  { "schizoids.net", true },
  { "schlabbi.com", false },
  { "schlagenhauf.info", true },
  { "schlagma.de", true },
  { "schlarp.com", true },
  { "schlechtewitze.com", true },
  { "schlossereieder.at", true },
  { "schmitz.link", true },
  { "schnapke.name", true },
  { "schneids.me", true },
  { "schnellno.de", true },
  { "schnellsuche.de", true },
  { "schnouki.net", true },
  { "schoepski.de", true },
  { "schokokeks.org", true },
  { "scholierenvervoerzeeland.nl", true },
  { "schont.org", true },
  { "school.in.th", true },
  { "schoolotzyv.ru", true },
  { "schoolze.com", true },
  { "schopenhauer-institut.de", true },
  { "schorel.ovh", true },
  { "schorelweb.nl", true },
  { "schreibers.ca", true },
  { "schreibnacht.de", true },
  { "schreinerei-jahreis.de", true },
  { "schrikdraad.net", true },
  { "schritt4fit.de", true },
  { "schrodinger.io", true },
  { "schroepfglas-versand.de", true },
  { "schsrch.xyz", true },
  { "schubergphilis.com", true },
  { "schul-bar.de", true },
  { "schuler.st", true },
  { "schulterglatzen-altenwalde.de", true },
  { "schultzflorists.com", true },
  { "schumanandmonnet.eu", true },
  { "schunako.ch", true },
  { "schurkenstaat.net", true },
  { "schutznetze24.de", true },
  { "schutzwerk.com", true },
  { "schwabenhaus-ka.de", true },
  { "schwarzer.it", true },
  { "schwarztrade.cz", true },
  { "schwarzwaldcon.de", true },
  { "schweizerbolzonello.net", true },
  { "schwinabart.com", true },
  { "schwinger.me", true },
  { "schwuppengrillen.de", true },
  { "scicasts.com", true },
  { "science-questions.org", true },
  { "science-texts.de", true },
  { "science360.gov", true },
  { "sciencemonster.co.uk", true },
  { "sciencex.com", true },
  { "scivillage.com", true },
  { "sclgroup.cc", true },
  { "scoolcode.com", true },
  { "scooterservis.com", true },
  { "scootfleet.com", true },
  { "scores4schools.com", true },
  { "scottainslie.me.uk", true },
  { "scottdial.com", true },
  { "scottgruber.me", true },
  { "scottgthomas.com", true },
  { "scotthel.me", true },
  { "scotthelme.co.uk", true },
  { "scotthelme.com", true },
  { "scottstorey.co.uk", true },
  { "scourt.info", true },
  { "scourt.org.ua", true },
  { "scoutdb.ch", true },
  { "scp-trens.notaires.fr", true },
  { "scrambl.is", true },
  { "scramble.io", true },
  { "scrambler.in", false },
  { "scrap.tf", true },
  { "scrapings.net", true },
  { "scrayos.net", true },
  { "screenlight.tv", true },
  { "screenresolution.space", true },
  { "scribbleserver.com", true },
  { "scribe.systems", true },
  { "scrion.com", true },
  { "script.google.com", true },
  { "scriptict.nl", false },
  { "scriptjunkie.us", true },
  { "scrisulfacebine.ro", true },
  { "scrollstory.com", true },
  { "scrumstack.co.uk", true },
  { "scryfall.com", true },
  { "scs-simulatoren.de", true },
  { "sculpture.support", true },
  { "sd.af", true },
  { "sdcardrecovery.de", true },
  { "sdmoscow.ru", true },
  { "sdsl-speedtest.de", true },
  { "se.search.yahoo.com", false },
  { "sea-godzilla.com", true },
  { "sealbaker.com", true },
  { "seamless.no", true },
  { "seanholcroft.co.uk", true },
  { "search.yahoo.com", false },
  { "searchbrothers.com", true },
  { "seasons.nu", true },
  { "seatbeltpledge.com", true },
  { "seattlefabrication.com", true },
  { "seattlewalkinbathtubs.com", true },
  { "seb-mgl.de", true },
  { "sebastian-bair.de", true },
  { "sebastian-lutsch.de", true },
  { "sebastian.expert", true },
  { "sebastianblade.com", true },
  { "sebastianboegl.de", true },
  { "sebi.org", true },
  { "sec.ec", true },
  { "sec.gd", true },
  { "secandtech.com", true },
  { "secboom.com", true },
  { "seccom.ch", true },
  { "seccomp.ru", true },
  { "secctexasgiving.org", false },
  { "sech.me", true },
  { "secitem.at", true },
  { "secitem.de", true },
  { "secnews.gr", true },
  { "secondary-survivor.com", true },
  { "secondary-survivor.help", true },
  { "secondary-survivor.net", true },
  { "secondarysurvivor.help", true },
  { "secondarysurvivorportal.com", true },
  { "secondarysurvivorportal.help", true },
  { "secondpay.nl", true },
  { "secondspace.ca", true },
  { "seconfig.sytes.net", true },
  { "secpatrol.de", true },
  { "secretpanties.com", true },
  { "secretserveronline.com", true },
  { "sectest.ml", true },
  { "sectia22.ro", true },
  { "sectio-aurea.org", true },
  { "section.io", true },
  { "section508.gov", true },
  { "securai.de", true },
  { "secure-games.us", true },
  { "secure-graphic.de", true },
  { "secure-server-hosting.com", true },
  { "secure.advancepayroll.com.au", true },
  { "secure.chat", true },
  { "secure.co.hu", true },
  { "secure.facebook.com", false },
  { "securedevelop.net", true },
  { "securedrop.org", true },
  { "secureesolutions.com", true },
  { "secureideas.com", false },
  { "securejabber.me", true },
  { "secureobscure.com", true },
  { "secureonline.co", true },
  { "secureradio.net", true },
  { "securesuisse.ch", true },
  { "securethe.news", true },
  { "securetheorem.com", true },
  { "securetronic.ch", true },
  { "securify.nl", true },
  { "security-carpet.com", true },
  { "security-taskforce.be", true },
  { "security.google.com", true },
  { "securityglance.com", true },
  { "securityheaders.com", true },
  { "securityheaders.io", true },
  { "securitymap.wiki", true },
  { "securityprimes.in", true },
  { "securitysnobs.com", false },
  { "securitysoapbox.com", true },
  { "securitystrata.com", true },
  { "securitystreak.com", true },
  { "securitywithnick.com", true },
  { "securitywithoutborders.org", true },
  { "secuvera.de", true },
  { "sedrubal.de", true },
  { "sedussa.ro", true },
  { "sedziapilkarski.pl", true },
  { "seedalpha.com", true },
  { "seedbox.fr", true },
  { "seeks.ru", true },
  { "seele.ca", true },
  { "seemeagain.com", true },
  { "seen.life", true },
  { "seesuite.com", true },
  { "seewhatididhere.com", true },
  { "sefru.de", true },
  { "segitz.de", true },
  { "segulink.com", true },
  { "segurosbalboa.com.ec", true },
  { "segurosocial.gov", false },
  { "seguroviagem.srv.br", true },
  { "seida.at", true },
  { "seifried.org", true },
  { "seiko-dojo.com", true },
  { "seitenwaelzer.de", true },
  { "selcusters.nl", true },
  { "selecadm.name", true },
  { "selectary.com", true },
  { "selectel.ru", true },
  { "selectorders.com", true },
  { "selectruckscalltrackingreports.com", true },
  { "selegiline.com", true },
  { "selent.me", true },
  { "self-evident.org", true },
  { "self-injury.net", true },
  { "self-signed.com", true },
  { "selfdestruct.net", true },
  { "selfhosters.com", true },
  { "selfici.com", true },
  { "selfici.cz", true },
  { "selfserverx.com", false },
  { "sellme.biz", true },
  { "sellocdn.com", true },
  { "sellservs.co.za", true },
  { "semianalog.com", true },
  { "seminariruum.ee", true },
  { "semmlers.com", true },
  { "semox.de", true },
  { "semps-2fa.de", true },
  { "semps-threema.de", true },
  { "semyonov.su", true },
  { "semyonov.us", true },
  { "senarius.de", true },
  { "sendash.com", true },
  { "sendc.at", true },
  { "sendcat.com", true },
  { "sendinvoice.nl", true },
  { "sendmeback.de", true },
  { "sendonce.io", true },
  { "sendthisfile.com", true },
  { "sendway.com", true },
  { "sendya.me", true },
  { "seniors.singles", true },
  { "senmendai-reform.com", true },
  { "senorcontento.com", true },
  { "sensebridge.com", true },
  { "sensebridge.net", true },
  { "senseofnumber.co.uk", true },
  { "sensepixel.com", true },
  { "senshudo.tv", true },
  { "sensiblemn.org", true },
  { "sensualism.com", true },
  { "sentry.io", true },
  { "senzaparole.de", true },
  { "seo-linz.at", true },
  { "seo-nerd.de", true },
  { "seoarchive.org", true },
  { "seobot.com.au", true },
  { "seogeek.nl", true },
  { "seoinc.com", true },
  { "seokay.com", true },
  { "seon.me", true },
  { "seoquake.com", true },
  { "seoul.dating", true },
  { "sepalandseed.com", true },
  { "sephr.com", true },
  { "seppelec.com", true },
  { "septakkordeon.de", true },
  { "septillion.cn", true },
  { "septs.pw", true },
  { "sequencing.com", true },
  { "sequiturs.com", true },
  { "serafin.tech", true },
  { "serathius.ovh", true },
  { "serbanpaun.ro", true },
  { "serf.io", true },
  { "serized.pw", true },
  { "servdiscount.com", true },
  { "servecrypt.com", true },
  { "servecrypt.net", true },
  { "servecrypt.ru", true },
  { "servepublic.com", true },
  { "servepublic.org", true },
  { "server-bg.net", true },
  { "server-daten.de", true },
  { "server-essentials.com", true },
  { "serveradminz.com", true },
  { "serverco.com", true },
  { "serverfrog.de", true },
  { "serverlauget.no", true },
  { "servermonkey.nl", true },
  { "serveroffline.net", false },
  { "serverpedia.de", true },
  { "serverstuff.info", true },
  { "serversuit.com", true },
  { "servertastic.com", true },
  { "servethecity-karlsruhe.de", false },
  { "service.gov.uk", true },
  { "serviettenhaus.de", true },
  { "servious.org", true },
  { "seryo.moe", true },
  { "seryo.net", true },
  { "seryovpn.com", true },
  { "sesha.co.za", true },
  { "sessionslogning.dk", true },
  { "setfix.de", true },
  { "sethcaplan.com", true },
  { "seti-germany.de", true },
  { "setphaserstostun.org", true },
  { "settberg.de", true },
  { "setterirlandes.com.br", true },
  { "settleapp.co", true },
  { "setuid.de", true },
  { "setuid0.kr", false },
  { "sevenmatches.com", true },
  { "severntrentinsuranceportal.com", true },
  { "sevsey.ru", true },
  { "sevsopr.ru", true },
  { "sexpay.net", true },
  { "sexwork.net", true },
  { "sexy-store.nl", true },
  { "seyahatsagliksigortalari.com", true },
  { "seyfarth.de", true },
  { "seyr.it", true },
  { "seyr.me", true },
  { "sftool.gov", true },
  { "sg.search.yahoo.com", false },
  { "sgcaccounts.co.uk", true },
  { "sgroup-hitoduma.com", true },
  { "sgroup-rec.com", true },
  { "sgtcodfish.com", true },
  { "sh-heppelmann.de", true },
  { "sh-network.de", false },
  { "shaaaaaaaaaaaaa.com", true },
  { "shadex.net", true },
  { "shadowguardian507-irl.tk", true },
  { "shadowguardian507.tk", true },
  { "shadowkitsune.net", true },
  { "shadowplus.net", true },
  { "shadowrocket.net", true },
  { "shadowsocks.com", true },
  { "shadowsocks.net", true },
  { "shadowsworldonline.co.uk", true },
  { "shagi29.ru", true },
  { "shaitan.eu", true },
  { "shaken110.com", true },
  { "shakes4u.com", true },
  { "shakespearesolutions.com.au", false },
  { "shalott.org", true },
  { "shamara.info", true },
  { "shamariki.ru", true },
  { "shan.io", false },
  { "shanae.nl", true },
  { "shanetully.com", true },
  { "shanewadleigh.com", true },
  { "shang-yu.cn", true },
  { "shannoneichorn.com", true },
  { "shansing.cn", true },
  { "shansing.com", true },
  { "shansing.net", true },
  { "shansing.space", true },
  { "shaobin.wang", true },
  { "shapesedinburgh.co.uk", true },
  { "shareimg.xyz", true },
  { "shareoine.com", true },
  { "sharepass.pw", true },
  { "sharepic.xyz", true },
  { "sharepointdrive.com", true },
  { "sharescope.co.uk", false },
  { "sharesplitter.com", true },
  { "shareworx.net", true },
  { "sharvey.ca", true },
  { "shasso.com", true },
  { "shatorin.com", true },
  { "shauncrowley.co.uk", true },
  { "shaundanielz.com", true },
  { "shav.it", true },
  { "shawcentral.ca", true },
  { "shazbots.org", true },
  { "shazzlemd.com", true },
  { "shazzlepro.com", true },
  { "sheilasdrivingschool.com", true },
  { "shelfordsandstaplefordscouts.org.uk", true },
  { "shellfire.de", true },
  { "shellj.me", true },
  { "shellvatore.us", true },
  { "shemissed.me", true },
  { "shenghaiautoparts.com", true },
  { "shenghaiautoparts.net", true },
  { "shentengtu.idv.tw", true },
  { "shenyuqi.com", true },
  { "shep.co.il", true },
  { "sherbers.de", true },
  { "shereallyheals.com", true },
  { "shevronpatriot.ru", true },
  { "shft.cl", true },
  { "shg-pornographieabhaengigkeit.de", true },
  { "shh.sh", true },
  { "shiawasedo.co.jp", true },
  { "shibainu.com.br", true },
  { "shiftdevices.com", true },
  { "shiftj.is", true },
  { "shiftnrg.org", true },
  { "shiftplanning.com", true },
  { "shiinko.com", false },
  { "shinebijoux.com.br", true },
  { "shinju.moe", true },
  { "shinnyosangha.org", false },
  { "shinobi-fansub.ro", true },
  { "shinyuu.net", true },
  { "shipard.com", true },
  { "shipard.cz", true },
  { "shipcloud.io", true },
  { "shipping24h.com", true },
  { "shiroki-k.net", true },
  { "shirtsofholland.com", true },
  { "shishkin.link", true },
  { "shishkin.us", true },
  { "shitproductions.org", true },
  { "shitsta.in", true },
  { "shm-forum.org.uk", true },
  { "shodan.io", true },
  { "shome.de", true },
  { "shopapi.cz", true },
  { "shopbakersnook.com", true },
  { "shopherbal.co.za", true },
  { "shoplandia.co", true },
  { "shopping24.de", true },
  { "shorebreaksecurity.com", true },
  { "short-biography.com", true },
  { "shortdiary.me", true },
  { "shortpath.com", true },
  { "shortr.li", true },
  { "shota.party", true },
  { "shotbow.net", true },
  { "show-saratov.ru", true },
  { "showsonar.com", true },
  { "shrike.me", true },
  { "shrinkhub.com", true },
  { "shrub.ca", true },
  { "shtorku.com", true },
  { "shu-kin.net", true },
  { "shulan.moe", true },
  { "shuro.de", true },
  { "shux.pro", true },
  { "shv25.se", true },
  { "shwongacc.com", true },
  { "shymeck.pw", true },
  { "shyrydan.es", true },
  { "si-benelux.nl", true },
  { "si.to", true },
  { "siamojo.com", true },
  { "siamsnus.com", true },
  { "sibrenvasse.nl", true },
  { "sichere-kartenakzeptanz.de", false },
  { "siciliadigitale.pro", true },
  { "sicken.eu", true },
  { "sickfile.com", true },
  { "siconnect.us", true },
  { "siddhant.me", true },
  { "sidepodcast.com", true },
  { "sidepodcastdaily.com", true },
  { "sidepodcastextra.com", true },
  { "sideshowbarker.net", true },
  { "sidium.de", true },
  { "sidnicio.us", true },
  { "siebens.net", true },
  { "siebeve.be", true },
  { "sieh.es", false },
  { "siewert-kau.de", true },
  { "sifls.com", true },
  { "sifreuret.com", true },
  { "sift-tool.org", true },
  { "sig6.org", true },
  { "sigabrt.org", true },
  { "sightcure.jp", true },
  { "sighup.nz", true },
  { "signaltransmitter.de", true },
  { "signere.com", true },
  { "signere.no", true },
  { "significados.com.br", true },
  { "signing-milter.org", true },
  { "signix.net", true },
  { "signoracle.com", true },
  { "signosquecombinam.com.br", true },
  { "signslabelstapesandmore.com", false },
  { "signtul.com", false },
  { "sigterm.no", true },
  { "sigterm.sh", true },
  { "sijmenschoon.nl", true },
  { "sikatehtaat.fi", true },
  { "sikayetvar.com", true },
  { "sikevux.se", true },
  { "silaslova-ekb.ru", true },
  { "silent.live", true },
  { "silentexplosion.de", true },
  { "silentkernel.fr", true },
  { "silentlink.io", true },
  { "silentundo.org", true },
  { "siliconchip.me", true },
  { "silkebaekken.no", true },
  { "sillisalaatti.fi", true },
  { "silqueskineyeserum.com", true },
  { "silver-heart.co.uk", true },
  { "silverback.is", true },
  { "silverbowflyshop.com", true },
  { "silverdragonart.com", true },
  { "silvergoldbull.ca", true },
  { "silvergoldbull.com", true },
  { "silvergoldbull.de", true },
  { "silvergoldbull.kr", true },
  { "silverhome.ninja", false },
  { "silverlinkz.net", true },
  { "silverpvp.com", false },
  { "silvistefi.com", true },
  { "simbihaiti.com", false },
  { "simbolo.co.uk", false },
  { "simccorp.com", true },
  { "simeonoff.ninja", true },
  { "simfed.org", true },
  { "simlau.net", true },
  { "simnovo.net", true },
  { "simobilklub.si", true },
  { "simod.org", false },
  { "simon-hofmann.org", true },
  { "simon-pokorny.com", true },
  { "simoncommunity.org.uk", true },
  { "simoncook.org", true },
  { "simonhirscher.de", true },
  { "simonkjellberg.com", true },
  { "simonkjellberg.se", true },
  { "simonlyabonnement.nl", true },
  { "simonwessel.net", true },
  { "simonwoodside.com", true },
  { "simpan.id", true },
  { "simphony.cz", true },
  { "simple.com", false },
  { "simplecontacts.com", true },
  { "simplednscrypt.org", false },
  { "simplelearner.com", true },
  { "simplerses.com", true },
  { "simpletax.ca", true },
  { "simplexsupport.com", false },
  { "simplia.cz", true },
  { "simplicitypvp.net", true },
  { "simplixos.org", true },
  { "simplycharlottemason.com", true },
  { "simplycloud.de", true },
  { "simplyfixit.co.uk", true },
  { "simplyhelen.de", true },
  { "simplymozzo.se", true },
  { "simplystudio.com", true },
  { "simpte.com", true },
  { "simpul.nl", true },
  { "sims4hub.ga", true },
  { "simsnieuws.nl", true },
  { "simumiehet.com", true },
  { "simus.fr", true },
  { "sin30.net", true },
  { "sincron.org", true },
  { "sinful.pw", true },
  { "sinfulforums.net", true },
  { "singleuse.link", true },
  { "singlu10.org", false },
  { "singul4rity.com", true },
  { "sinktank.de", true },
  { "sinneserweiterung.de", true },
  { "sinnovate.de", true },
  { "sinonimos.com.br", true },
  { "sinonimosonline.com", true },
  { "sinonimosonline.com.br", true },
  { "sinoscandinavia.se", true },
  { "sinosky.org", true },
  { "sinquin.eu", true },
  { "siqi.wang", true },
  { "sirenslove.com", true },
  { "sirius-lee.net", true },
  { "siriuspup.com", true },
  { "sirtaptap.com", true },
  { "sistem-maklumat.com", true },
  { "sistem-maklumat.com.my", true },
  { "sistemy48.ru", true },
  { "sistersurprise.de", true },
  { "sisv.eu", true },
  { "sit.ec", true },
  { "sitc.sk", true },
  { "sitecuatui.com", true },
  { "sitehost.io", true },
  { "siterip.org", true },
  { "sites.google.com", true },
  { "sitesko.de", true },
  { "sitsy.ru", false },
  { "sizingservers.be", false },
  { "sizzle.co.uk", true },
  { "sjoorm.com", true },
  { "skalender.ch", false },
  { "skanvordoff.ru", true },
  { "skaraborgsassistans.com", false },
  { "skarrok.com", false },
  { "skatclub-beratzhausen.de", true },
  { "skatn.de", true },
  { "skeeley.com", true },
  { "skepticalsports.com", true },
  { "sketchmyroom.com", true },
  { "skhoop.cz", true },
  { "ski-insurance.com.au", true },
  { "skia.org", true },
  { "skidstresser.com", true },
  { "skigebiete-test.de", true },
  { "skile.ru", false },
  { "skilldetector.com", true },
  { "skilletfood.com", true },
  { "skillproxy.com", true },
  { "skillproxy.net", true },
  { "skillproxy.org", true },
  { "skills2services.com", true },
  { "skillseo.com", true },
  { "skimming.net", true },
  { "sking.io", true },
  { "skipfault.com", true },
  { "skipperinnovations.com", true },
  { "skk.io", true },
  { "skoda-clever-lead.de", true },
  { "skoda-im-dialog.de", true },
  { "skoda-nurdiebesten.de", true },
  { "skoda-service-team-cup.de", true },
  { "skogsbruket.fi", true },
  { "skogskultur.fi", true },
  { "skolem.de", true },
  { "skoleniphp.cz", true },
  { "skontakt.cz", true },
  { "skontorp-enterprise.no", true },
  { "skory.us", true },
  { "skou.dk", true },
  { "sktsolution.com", true },
  { "sky-aroma.com", true },
  { "skyasker.cn", true },
  { "skyasker.com", true },
  { "skydragoness.com", true },
  { "skydrive.live.com", false },
  { "skyline.link", true },
  { "skyline.tw", true },
  { "skyminds.net", true },
  { "skynetz.tk", true },
  { "skyveo.ml", true },
  { "skyway.capital", true },
  { "sl1pkn07.wtf", true },
  { "slack-files.com", true },
  { "slack.com", true },
  { "sladic.si", false },
  { "slainvet.net", true },
  { "slamdjapan.com", true },
  { "slamix.nl", true },
  { "slangbellor.com", true },
  { "slapen17.nl", true },
  { "slaps.be", true },
  { "slashdesign.it", true },
  { "slattery.co", true },
  { "slauber.de", true },
  { "slaughterhouse.fr", true },
  { "sleep10.com", true },
  { "sleeplessbeastie.eu", true },
  { "sleepstar.co.uk", true },
  { "sleepstar.com.mt", true },
  { "sleepstar.de", true },
  { "sleio.com", true },
  { "slever.cz", true },
  { "slevermann.de", true },
  { "slevomat.cz", true },
  { "sliceone.com", true },
  { "slicklines.co.uk", true },
  { "slidebatch.com", true },
  { "slightfuture.click", true },
  { "slightfuture.com", true },
  { "slimk1nd.nl", true },
  { "slimmerbouwen.be", true },
  { "slimspots.com", true },
  { "slink.hr", true },
  { "slix.io", true },
  { "slneighbors.org", true },
  { "slo-tech.com", true },
  { "sloancom.com", true },
  { "slope.haus", true },
  { "slotboss.co.uk", true },
  { "slotcar.com", false },
  { "slovoice.org", true },
  { "slow.zone", true },
  { "slowb.ro", true },
  { "slowfood.es", true },
  { "slse.ca", true },
  { "slxh.eu", true },
  { "slxh.nl", true },
  { "sm.ms", true },
  { "smablo.com", true },
  { "smallcdn.rocks", true },
  { "smallchat.nl", true },
  { "smalldata.tech", true },
  { "smalldogbreeds.net", true },
  { "smallhadroncollider.com", true },
  { "smallpath.me", true },
  { "smallplanet.ch", true },
  { "smalltalkconsulting.com", true },
  { "smares.de", true },
  { "smart-cp.jp", true },
  { "smart-ov.nl", true },
  { "smartairkey.com", true },
  { "smartbuyelectric.com", true },
  { "smartcheck.gov", true },
  { "smartcleaningcenter.nl", false },
  { "smartest-trading.com", true },
  { "smartftp.com", true },
  { "smarthdd.com", true },
  { "smarthomedna.com", true },
  { "smarthouse.de", true },
  { "smartit.pro", true },
  { "smartlend.se", true },
  { "smartlocksmith.com", true },
  { "smartmessages.net", true },
  { "smartpass.government.ae", true },
  { "smartphone.continental.com", false },
  { "smartpolicingplatform.com", true },
  { "smartrade.tech", true },
  { "smartshiftme.com", true },
  { "smartship.co.jp", true },
  { "smartsparrow.com", true },
  { "smartviewing.com", true },
  { "smartwelve.com", true },
  { "smartwurk.nl", true },
  { "smb445.com", true },
  { "smdavis.us", true },
  { "smdcn.net", true },
  { "smdev.fr", true },
  { "sme-gmbh.net", true },
  { "smeetsengraas.com", true },
  { "smiatek.name", true },
  { "smileawei.com", true },
  { "smimea.com", true },
  { "smipty.cn", true },
  { "smipty.com", true },
  { "smirkingwhorefromhighgarden.pro", true },
  { "smith.is", true },
  { "smithandcanova.co.uk", true },
  { "smittix.co.uk", true },
  { "smkw.com", true },
  { "sml.lc", true },
  { "smm.im", true },
  { "smoo.st", true },
  { "smoothgesturesplus.com", true },
  { "smoothics.at", true },
  { "smoothics.com", true },
  { "smoothics.eu", true },
  { "smoothics.mobi", true },
  { "smorgasblog.ie", true },
  { "smow.com", true },
  { "smow.de", true },
  { "smpetrey.com", true },
  { "sms1.ro", true },
  { "smskeywords.co.uk", true },
  { "smurfrp.com", true },
  { "smvfd.info", true },
  { "snailing.org", true },
  { "snapappts.com", true },
  { "snapfinance.com", true },
  { "snarf.in", true },
  { "snazel.co.uk", true },
  { "snazzie.nl", true },
  { "sneakpod.de", true },
  { "sneakynote.com", true },
  { "sneberger.cz", false },
  { "sneed.it", true },
  { "sneedit.com", true },
  { "sneedit.de", true },
  { "sneezry.com", true },
  { "snekchat.moe", true },
  { "snel4u.nl", true },
  { "snelshops.nl", true },
  { "snelwebshop.nl", true },
  { "snelxboxlivegold.nl", true },
  { "snfdata.com", true },
  { "sng.my", true },
  { "sniderman.eu.org", true },
  { "sniep.net", true },
  { "snip.host", true },
  { "snl.no", true },
  { "snod.land", true },
  { "snoupon.com", true },
  { "snow-online.com", true },
  { "snow-online.de", true },
  { "snow.dog", true },
  { "snowalerts.eu", true },
  { "snowcrestdesign.com", true },
  { "snowhaze.ch", true },
  { "snowhaze.com", true },
  { "snowplane.net", true },
  { "snughealth.org.uk", true },
  { "sny.no", true },
  { "so-healthy.co.uk", true },
  { "sobabox.ru", true },
  { "sobaya-gohei.com", true },
  { "sobie.ch", true },
  { "sobieray.dyndns.org", true },
  { "soboleva-pr.com.ua", true },
  { "sochi-sochno.ru", true },
  { "social-events.net", false },
  { "social-media-strategies.it", true },
  { "socialbillboard.com", true },
  { "socialgrowing.cl", true },
  { "socialhead.io", true },
  { "socialhub.com", true },
  { "socialnous.co", true },
  { "socialprize.com", true },
  { "socialrank.com", true },
  { "socialsecurity.gov", false },
  { "socialworkout.com", true },
  { "socialworkout.net", true },
  { "socialworkout.org", true },
  { "socialworkout.tv", true },
  { "societyhilldance.com", true },
  { "socioambiental.org", true },
  { "socketize.com", true },
  { "sockeye.cc", false },
  { "sockeye.io", true },
  { "sodacore.com", true },
  { "sodi.nl", true },
  { "sodiao.cc", true },
  { "soe-server.com", true },
  { "sofabedshop.de", true },
  { "sofort.com", true },
  { "sofortueberweisung.de", true },
  { "softanka.com", true },
  { "software.rocks", true },
  { "softwarebetrieb.de", true },
  { "softwaredesign.foundation", true },
  { "softwerk-edv.de", true },
  { "sogravatas.com.br", true },
  { "sogravatas.net.br", true },
  { "sogutma.com.tr", true },
  { "soia.ca", true },
  { "sojingle.net", true },
  { "soju.fi", true },
  { "sokche.com", true },
  { "sokietech.com", true },
  { "sokkenhoek.nl", true },
  { "sokolka.tv", true },
  { "sokolkarvina.cz", true },
  { "sol-computers.es", true },
  { "sol24.net", true },
  { "solar-ec.com", true },
  { "solariiknight.org", true },
  { "soldecom.com", true },
  { "soledadpenades.com", true },
  { "soleus.nu", false },
  { "solidshield.com", true },
  { "solidtuesday.com", true },
  { "solidus.systems", true },
  { "solihullcarnival.co.uk", true },
  { "solihulllionsclub.org.uk", true },
  { "solmek.co.uk", true },
  { "solmek.com", true },
  { "solomisael.com", true },
  { "solsocog.de", true },
  { "solsystems.ru", true },
  { "solus-project.com", true },
  { "solutionhoisthire.com.au", true },
  { "solutive.fi", true },
  { "solved.tips", true },
  { "solvops.com", true },
  { "solymar.co", true },
  { "somanao.com", true },
  { "somebodycares.org", true },
  { "somethingsimilar.com", true },
  { "sona-gaming.com", true },
  { "sonafe.info", true },
  { "sonarqube.com", true },
  { "sondergaard.de", true },
  { "sonerezh.bzh", true },
  { "songzhuolun.com", true },
  { "sonic.network", true },
  { "sonic.sk", false },
  { "sonja-daniels.com", true },
  { "sonyunlock.nu", true },
  { "soph.us", true },
  { "sopheos.com", false },
  { "sophiakligys.com", true },
  { "soply.com", true },
  { "soporte.cc", true },
  { "sor.so", true },
  { "sorcix.com", true },
  { "sorenstudios.com", true },
  { "sorincocorada.ro", true },
  { "sorn.service.gov.uk", true },
  { "sortaweird.net", false },
  { "soruly.com", true },
  { "sorz.org", true },
  { "sos.sk", false },
  { "sosaka.ml", true },
  { "sosecu.red", true },
  { "sostacancun.com", true },
  { "sotar.us", true },
  { "sotavasara.net", true },
  { "sou-co.jp", true },
  { "soucorneteiro.com.br", true },
  { "souki.cz", true },
  { "soul-source.co.uk", true },
  { "soulboy.io", false },
  { "soulema.com", false },
  { "soulfulglamour.uk", true },
  { "soulmate.dating", true },
  { "soulogic.com", false },
  { "soumikghosh.com", true },
  { "soundeo.com", true },
  { "soundeo.net", true },
  { "soundforsound.co.uk", true },
  { "soundgasm.net", true },
  { "soundhunter.xyz", true },
  { "soundtalks.be", true },
  { "soundtalks.com", true },
  { "sour.is", true },
  { "sourcebox.be", true },
  { "sourcecode.love", true },
  { "sourcely.net", true },
  { "sourceway.de", true },
  { "sourcitec.com", true },
  { "sous-surveillance.net", true },
  { "southafrican.dating", true },
  { "southamerican.dating", true },
  { "southernjamusa.com", true },
  { "southernmost.us", true },
  { "southernutahinfluencers.com", true },
  { "southmeriden-vfd.org", true },
  { "southside-crew.com", true },
  { "southside-tuning-day.de", true },
  { "southworcestershiregpservices.co.uk", true },
  { "souvik.me", true },
  { "soved.eu", true },
  { "sovereignshare.com", true },
  { "sown.dyndns.org", true },
  { "sowncloud.de", true },
  { "sozon.ca", true },
  { "sp.rw", true },
  { "space-it.de", true },
  { "spacebaseapp.com", true },
  { "spacecafe.org", true },
  { "spacedirectory.org", true },
  { "spacedust.xyz", true },
  { "spacefish.biz", true },
  { "spacehost.de", false },
  { "spacelabs.io", true },
  { "spacepage.be", true },
  { "spaceweather.live", true },
  { "spaceweatherlive.com", true },
  { "spacountryexplorer.org.au", true },
  { "spaggel.nl", false },
  { "spamloco.net", true },
  { "spamwc.de", true },
  { "sparkbase.cn", true },
  { "sparkforautism.org", true },
  { "sparklebastard.com", true },
  { "sparsa.army", true },
  { "sparta-trade.com", true },
  { "spartaconsulting.fi", true },
  { "spassstempel.de", true },
  { "spatzenwerkstatt.de", true },
  { "spauted.com", true },
  { "spawn.cz", true },
  { "spaysy.com", true },
  { "spdf.net", true },
  { "spectrosoftware.de", true },
  { "speculor.net", true },
  { "spedplus.com.br", false },
  { "speed-mailer.com", true },
  { "speeddate.it", false },
  { "speedmann.de", false },
  { "speeds.vip", true },
  { "speedtest-russia.com", true },
  { "speich.net", true },
  { "spenglerei-shop.de", true },
  { "sperohub.com", true },
  { "sperohub.io", true },
  { "sperohub.lt", true },
  { "sperrstun.de", true },
  { "sphereblur.com", true },
  { "spherenix.org", true },
  { "spibe.is", true },
  { "spicydog.org", true },
  { "spicydog.tk", true },
  { "spicymatch.com", true },
  { "spicywombat.com", true },
  { "spideroak.com", true },
  { "spielcasinos.com", true },
  { "spiet.nl", true },
  { "spilsbury.io", true },
  { "spinalien.net", true },
  { "spins.fedoraproject.org", true },
  { "spirit-dev.net", true },
  { "spiritbionic.ro", true },
  { "spiritfanfics.com", true },
  { "spiritual.dating", true },
  { "spisbilligt.dk", true },
  { "spitefultowel.com", true },
  { "spitfireuav.com", true },
  { "spititout.it", true },
  { "splikity.com", true },
  { "split.is", true },
  { "splitdna.com", true },
  { "splitreflection.com", true },
  { "splunk.net", true },
  { "spodelime.com", true },
  { "spom.net", true },
  { "sponc.de", true },
  { "spongepowered.org", true },
  { "spookbook.net", true },
  { "spornkuller.de", true },
  { "sport-in-sundern.de", true },
  { "sport-potreby.cz", true },
  { "sport-potreby.sk", true },
  { "sportflash.info", true },
  { "sporthit.ru", true },
  { "sportifik.com", true },
  { "sports.dating", true },
  { "sportsmanadvisor.com", true },
  { "sportstraineradvisor.com", true },
  { "sporttrampen.de", false },
  { "spot-events.com", true },
  { "spotifyripper.tk", true },
  { "spotlightsrule.com", true },
  { "spotlightsrule.ddns.net", true },
  { "spotupload.com", true },
  { "spreadsheets.google.com", true },
  { "spree.co.za", true },
  { "spreed.me", true },
  { "spresso.me", true },
  { "spricknet.de", true },
  { "sprigings.com", true },
  { "spron.in", true },
  { "sprueche-zum-valentinstag.de", true },
  { "sprueche-zur-geburt.info", true },
  { "sprueche-zur-hochzeit.de", true },
  { "sprueche-zur-konfirmation.de", true },
  { "sprutech.de", true },
  { "sps-lehrgang.de", true },
  { "sptk.org", true },
  { "spuffin.com", true },
  { "spydar007.com", true },
  { "spydar007.net", true },
  { "spydersec.com", true },
  { "spyprofit.ru", true },
  { "spyroszarzonis.com", true },
  { "sqlapius.net", true },
  { "sqr-training.com", true },
  { "sqshq.de", true },
  { "squaddraft.com", true },
  { "square-gaming.org", true },
  { "square-src.de", true },
  { "square.com", false },
  { "square.gs", true },
  { "squarelab.it", true },
  { "squareonebgc.com.ph", true },
  { "squareup.com", false },
  { "squawk.cc", true },
  { "squeezemetrics.com", true },
  { "squids.space", true },
  { "srandom.com", true },
  { "src.fedoraproject.org", true },
  { "srchub.org", true },
  { "sritest.io", true },
  { "sro.center", true },
  { "srpdb.com", true },
  { "srrdb.com", true },
  { "srrr.ca", true },
  { "srv47.de", true },
  { "ss-x.ru", true },
  { "ss.lv", true },
  { "ssa.gov", false },
  { "ssbkk.ru", true },
  { "ssbrm.ch", true },
  { "sscd.no", true },
  { "ssdax.com", true },
  { "ssky.cn", true },
  { "ssl-zertifikate.de", true },
  { "ssl.do", true },
  { "ssl.google-analytics.com", true },
  { "ssl.md", true },
  { "ssl.rip", true },
  { "ssl247.co.uk", true },
  { "ssl247.com.mx", true },
  { "ssl247.de", true },
  { "ssl247.dk", true },
  { "sslcertificaten.nl", true },
  { "sslcheck.nl", true },
  { "ssldecoder.org", true },
  { "ssldev.net", true },
  { "sslhosting.cz", true },
  { "sslmate.com", true },
  { "sslpoint.com", true },
  { "ssls.cz", true },
  { "sslsurvey.de", true },
  { "sslzilla.de", true },
  { "ssmato.me", true },
  { "sstewartgallus.com", true },
  { "ssworld.ga", true },
  { "st-kilian-markt-erlbach.de", true },
  { "st-news.de", true },
  { "staack.com", false },
  { "staatschutz.at", true },
  { "staatsschutz.at", true },
  { "staatsschutzgesetz.at", true },
  { "stablelib.com", true },
  { "stabletoken.com", true },
  { "stackptr.com", true },
  { "stacktile.io", true },
  { "stadionmanager.com", true },
  { "stadjerspasonline.nl", true },
  { "stadt-apotheke-muensingen.de", true },
  { "stadtbauwerk.at", true },
  { "staffjoy.com", true },
  { "staffjoystaging.com", true },
  { "stage-props-blank-guns.com", false },
  { "stage.wepay.com", false },
  { "stageirites.com", true },
  { "stageirites.fr", true },
  { "stageirites.org", true },
  { "stagingjobshq.com", true },
  { "stagstickets.co.uk", true },
  { "stahl.xyz", true },
  { "stair.ch", true },
  { "stalder.work", true },
  { "stalker-shop.com", true },
  { "stalkerhispano.com", true },
  { "stalkthe.net", true },
  { "stalschermer.nl", true },
  { "stamboommuller.nl", true },
  { "stamboomvanderwal.nl", true },
  { "stamkassa.nl", true },
  { "stammtisch.domains", true },
  { "stamonicatourandtravel.com", true },
  { "stanandjerre.org", true },
  { "standards.gov", true },
  { "standoutbooks.com", true },
  { "star-citizen.wiki", true },
  { "star-killer.net", true },
  { "starandshield.com", true },
  { "starapple.nl", true },
  { "starcomproj.com", true },
  { "stardanceacademy.net", true },
  { "starfm.de", true },
  { "stargazer.de", true },
  { "stari.co", true },
  { "starina.ru", true },
  { "starkbim.com", true },
  { "starpeak.org", true },
  { "starplatinum.jp", true },
  { "starquake.nl", true },
  { "starsam80.net", true },
  { "starstreak.net", true },
  { "startpage.com", true },
  { "startpage.info", true },
  { "startrek.in", true },
  { "starttraffic.uk", true },
  { "startuponcloud.com", true },
  { "startupsort.com", true },
  { "startupum.ru", true },
  { "starwatches.eu", true },
  { "stash.ai", true },
  { "stassi.ch", true },
  { "stat.ink", true },
  { "state-sponsored-actors.net", true },
  { "stateofexception.io", true },
  { "statgram.me", true },
  { "static.wepay.com", false },
  { "staticisnoise.com", true },
  { "stationary-traveller.eu", true },
  { "stats.g.doubleclick.net", true },
  { "status-sprueche.de", true },
  { "statuschecks.net", true },
  { "statuscode.ch", true },
  { "stav.io", true },
  { "stay.black", true },
  { "stayokhotelscdc-mailing.com", true },
  { "stbennett.org", true },
  { "stcable.net", true },
  { "stcu.org", true },
  { "stderr.cc", false },
  { "steakovercooked.com", true },
  { "stealsaga.net", true },
  { "steamdb.info", true },
  { "steckregal-super.de", true },
  { "steelephys.com.au", true },
  { "steemit.com", true },
  { "steenackers.be", true },
  { "stefanovski.io", true },
  { "stefany.eu", true },
  { "steffi-in-australien.com", true },
  { "steidlewirt.de", true },
  { "steigerplank.com", false },
  { "steklein.de", true },
  { "stellanova-planeten.de", false },
  { "stelleninserate.de", true },
  { "stellenticket.de", true },
  { "stellmacher.name", true },
  { "stemsims.com", true },
  { "stening.co", true },
  { "stephan-matthiesen.de", true },
  { "stephanieschreiber.com", true },
  { "stephenhaunts.com", true },
  { "stereo.lu", true },
  { "stereochro.me", false },
  { "stern-freunde.de", true },
  { "sternen-sitzberg.ch", true },
  { "sternplastic.com", true },
  { "stesti.cz", true },
  { "stevegrav.es", true },
  { "stevenberg.net", true },
  { "stevenhumphrey.uk", true },
  { "stevens.se", true },
  { "stevensheffey.me", true },
  { "steventress.com", true },
  { "stewonet.nl", true },
  { "stichtingscholierenvervoerzeeland.nl", true },
  { "stichtingsticky.nl", true },
  { "stick2bike.de", true },
  { "sticklerjs.org", true },
  { "stigharder.com", true },
  { "stigroom.com", true },
  { "stikonas.eu", false },
  { "stilartmoebel.de", true },
  { "stillblackhat.id", false },
  { "stillyarts.com", false },
  { "stilmobil.se", true },
  { "stinkytrashhound.com", true },
  { "stirling.co", false },
  { "stirlingpoon.xyz", true },
  { "stitchfiddle.com", true },
  { "stjohnin.com", true },
  { "stjohnmiami.org", true },
  { "stmbgr.com", true },
  { "stmsolutions.pl", true },
  { "stnl.de", true },
  { "stocktrade.de", false },
  { "stocktrader.com", true },
  { "stoffelen.nl", true },
  { "stoianlawfirm.com", true },
  { "stoick.me", true },
  { "stole-my.bike", false },
  { "stole-my.tv", false },
  { "stolina.de", true },
  { "stolkschepen.nl", true },
  { "stomt.com", true },
  { "stonefusion.org.uk", true },
  { "stonemain.eu", true },
  { "stopbullying.gov", true },
  { "stopfraud.gov", true },
  { "stopwoodfin.org", true },
  { "storeden.com", true },
  { "storedsafe.com", true },
  { "storgom.ua", false },
  { "storiesofhealth.org", true },
  { "stormhub.org", true },
  { "stormyyd.com", true },
  { "storvann.net", true },
  { "storvann.no", true },
  { "storycollective.nl", true },
  { "storyland.ie", true },
  { "storysift.news", true },
  { "stp-ip.com", true },
  { "stp-ip.net", true },
  { "stpip.com", true },
  { "stpip.net", true },
  { "strahlende-augen.info", true },
  { "strangemusicinc.net", true },
  { "strangeplace.net", true },
  { "strategie-zone.de", true },
  { "straubis.org", true },
  { "strauser.com", true },
  { "stravers.shoes", true },
  { "strbt.de", true },
  { "strchr.com", true },
  { "streamchan.org", true },
  { "streams.dyndns.org", true },
  { "streamzilla.com", true },
  { "streetdancecenter.com", true },
  { "streetspotr.com", true },
  { "streetview.wien", true },
  { "stressfreehousehold.com", true },
  { "stretchmyan.us", true },
  { "stricted.net", true },
  { "strictlynormal.com", true },
  { "strictlysudo.com", true },
  { "strife.tk", true },
  { "strijkshop.be", true },
  { "stripe.com", true },
  { "strobeltobias.de", true },
  { "strobeto.de", true },
  { "strom.family", true },
  { "strongest-privacy.com", true },
  { "structurally.net", true },
  { "strugee.net", true },
  { "stuartbaxter.co", false },
  { "stuartbell.co.uk", true },
  { "stuco.co", true },
  { "studenckiemetody.pl", true },
  { "studentloans.gov", true },
  { "studentrdh.com", true },
  { "studentrightsadvocate.org", true },
  { "studentskydenik.cz", true },
  { "studenttenant.com", true },
  { "studer.su", true },
  { "studienportal.eu", true },
  { "studio-panic.com", true },
  { "studiodewit.nl", true },
  { "studiomarcella.com", true },
  { "studiostawki.com", true },
  { "studiostudio.net", true },
  { "studlan.no", true },
  { "studyhub.cf", true },
  { "stuermer.me", true },
  { "stulda.cz", true },
  { "stumf.si", true },
  { "stuntmen.xyz", true },
  { "stupendous.net", true },
  { "sturbi.de", true },
  { "sturbock.me", true },
  { "stutelage.com", true },
  { "stuur.nl", false },
  { "stw-group.at", true },
  { "stygium.net", false },
  { "styleci.io", true },
  { "stylefast.com.au", true },
  { "stylenda.com", true },
  { "styles.pm", true },
  { "stylle.me", true },
  { "su1ph3r.io", true },
  { "suave.io", true },
  { "subdev.org", true },
  { "subeesu.com", true },
  { "sublevel.net", false },
  { "sublimebits.com", true },
  { "submedia.tv", true },
  { "subohm.com", true },
  { "suborbital.io", true },
  { "subrosa.io", false },
  { "subseq.net", false },
  { "subtitle.rip", true },
  { "suburban-landscape.net", true },
  { "subzerolosangeles.com", true },
  { "succ.in", true },
  { "suche.org", true },
  { "suckmyan.us", false },
  { "sudaraka.org", true },
  { "sudo.im", true },
  { "sudo.ws", true },
  { "sudoschool.com", true },
  { "sudosu.fr", true },
  { "suempresa.cloud", true },
  { "suevia-ka.de", true },
  { "sufix.cz", true },
  { "suite73.org", true },
  { "suitocracy.com", true },
  { "suki.moe", true },
  { "suksit.com", true },
  { "sulek.eu", true },
  { "summa.eu", true },
  { "summitbankofkc.com", true },
  { "sumthing.com", true },
  { "sunbritetv.com", true },
  { "sundayfundayjapan.com", true },
  { "suneilpatel.com", true },
  { "sunflyer.cn", false },
  { "sunjaydhama.com", true },
  { "sunsetwx.com", true },
  { "sunstar.bg", true },
  { "sunyanzi.tk", true },
  { "suos.io", true },
  { "supastuds.com", true },
  { "supcro.com", true },
  { "super-o-blog.com", true },
  { "superbabysitting.ch", true },
  { "superbart.nl", true },
  { "superbike.tw", true },
  { "superbshare.com", true },
  { "supercentenarian.com", true },
  { "superhappiness.com", true },
  { "superhome.com.au", true },
  { "superkonsult.se", true },
  { "supermarx.nl", true },
  { "supernt.lt", true },
  { "superpase.com", true },
  { "superschnappchen.de", true },
  { "supersecurefancydomain.com", true },
  { "supersonnig-festival.de", true },
  { "supersonnigfestival.de", true },
  { "supersu.kr", true },
  { "superswingtrainer.com", true },
  { "superuser.fi", true },
  { "superwally.org", true },
  { "supinbot.ovh", false },
  { "supplies24.at", true },
  { "supplies24.es", true },
  { "support.mayfirst.org", false },
  { "suprlink.net", true },
  { "sur-v.com", true },
  { "surasak.org", true },
  { "surasak.xyz", true },
  { "surgenet.nl", true },
  { "surgeongeneral.gov", true },
  { "surgicalassociateswny.com", true },
  { "surkatty.org", true },
  { "survature.com", true },
  { "surveymill.co.uk", true },
  { "survivalmonkey.com", true },
  { "susanbpilates.co", true },
  { "susanbpilates.com", true },
  { "susann-kerk.de", true },
  { "susastudentenjobs.de", true },
  { "sushi101tempe.com", false },
  { "sushifrick.de", true },
  { "suspiciousdarknet.xyz", true },
  { "sustainability.gov", true },
  { "sustsol.com", true },
  { "sutas.market", true },
  { "suwalls.com", true },
  { "sv-turm-hohenlimburg.de", true },
  { "svager.cz", true },
  { "svarovani.tk", true },
  { "svendubbeld.nl", true },
  { "sveneckelmann.de", true },
  { "svenluijten.com", true },
  { "svenskacasino.com", true },
  { "svetjakonadlani.cz", true },
  { "svijet-medija.hr", true },
  { "sw-servers.net", true },
  { "swaggerdile.com", true },
  { "swaleacademiestrust.org.uk", true },
  { "swansdoor.org", true },
  { "swapadoodle.com", true },
  { "swat4stats.com", true },
  { "sway-cdn.com", true },
  { "sway.com", true },
  { "swedishhost.com", true },
  { "swedishhost.se", true },
  { "sweep-me.net", true },
  { "sweetlegs.jp", true },
  { "sweetll.me", false },
  { "sweetstreats.ca", true },
  { "sweetvanilla.jp", true },
  { "swehack.org", true },
  { "swift-devedge.de", true },
  { "swiftqueue.com", true },
  { "swiggy.com", true },
  { "swineson.me", true },
  { "swingmonkey.com", true },
  { "swiss-cyber-experts.ch", true },
  { "swisslinux.org", true },
  { "swite.com", true },
  { "swordfeng.xyz", true },
  { "swyn.net", true },
  { "sx3.no", true },
  { "sy-anduril.de", true },
  { "syam.cc", true },
  { "sycamorememphis.org", true },
  { "sychov.pro", true },
  { "sydney.dating", true },
  { "syezd.com.au", true },
  { "sykepleien.no", false },
  { "sykl.us", true },
  { "sylaps.com", true },
  { "sylvaindurand.org", true },
  { "sylvan.me", true },
  { "sylvangarden.net", true },
  { "sylvangarden.org", true },
  { "sylvanorder.com", true },
  { "symeda.de", true },
  { "synabi.com", true },
  { "synackr.com", true },
  { "synapticconsulting.co.uk", true },
  { "synaptickz.me", true },
  { "synatra.co", true },
  { "sync-it.no", true },
  { "syncaddict.net", true },
  { "syncappate.com", true },
  { "synchrocube.com", true },
  { "synchtu.be", false },
  { "syncmylife.net", true },
  { "syncrise.co.jp", true },
  { "syndic-discount.fr", false },
  { "synfin.org", true },
  { "synony.me", true },
  { "synotna.eu", true },
  { "syntaxnightmare.com", true },
  { "syriatalk.biz", true },
  { "syriatalk.org", true },
  { "syrocon.ch", true },
  { "sys.tf", true },
  { "sysadmin.pm", true },
  { "sysadmins.ro", true },
  { "sysadminstory.com", true },
  { "sysctl.se", false },
  { "sysdb.io", true },
  { "sysert.tv", true },
  { "sysgeek.cn", true },
  { "sysmike.de", true },
  { "syso.name", true },
  { "sysrq.tech", true },
  { "syss.de", true },
  { "system.is", true },
  { "systemintegra.ru", true },
  { "systemreboot.net", true },
  { "syt3.net", true },
  { "syy.im", true },
  { "syzygy-tables.info", true },
  { "szagun.net", true },
  { "szamitogepdepo.com", true },
  { "szaydon.me", false },
  { "szechenyi2020.hu", true },
  { "szentistvanpt.sk", true },
  { "szongott.net", true },
  { "t-complex.space", true },
  { "t-hawk.com", true },
  { "t-ken.xyz", true },
  { "t-point.eu", true },
  { "t-shirts4less.nl", true },
  { "t-stonegroup.com", true },
  { "t-tz.com", false },
  { "t.facebook.com", false },
  { "t0dd.eu", false },
  { "t0ne.net", true },
  { "t23m-navi.jp", false },
  { "t3rror.net", true },
  { "t7e.de", false },
  { "ta-65.com", true },
  { "ta-sports.net", true },
  { "ta65.com", true },
  { "tabelfirme.ro", true },
  { "tabla-periodica.com", true },
  { "tablet.facebook.com", false },
  { "tablotv.com", false },
  { "taboragroup.com", false },
  { "taborsky.cz", true },
  { "tacticalsquare.com", true },
  { "tadata.me", true },
  { "tadcastercircuit.org.uk", true },
  { "tadigitalstore.com", true },
  { "tadu.de", true },
  { "taglioepiega.com", true },
  { "taglioepiega.eu", true },
  { "taglioepiega.it", true },
  { "tahakomat.cz", true },
  { "tahf.net", true },
  { "tailify.com", true },
  { "tailpuff.net", true },
  { "tails.boum.org", true },
  { "taiwan.dating", true },
  { "taiwantour.info", true },
  { "take1give1.com", false },
  { "taken.pl", true },
  { "takeshifujimoto.com", true },
  { "takk.pl", true },
  { "takkaaaaa.com", true },
  { "takumi-s.net", true },
  { "takusan.ru", true },
  { "takuto.de", true },
  { "talado.gr", false },
  { "talentcast.nl", true },
  { "talentos.pt", true },
  { "taler.net", true },
  { "talideon.com", false },
  { "talk.google.com", true },
  { "talkgadget.google.com", true },
  { "talklifestyle.nl", true },
  { "talktwincities.com", true },
  { "talldude.net", true },
  { "tallr.se", true },
  { "tallshoe.com", true },
  { "talsi.eu", true },
  { "talun.de", true },
  { "tamasszabo.net", true },
  { "tamchunho.com", true },
  { "tamex.xyz", true },
  { "tammy.pro", true },
  { "tampabaybusinesslistings.com", true },
  { "tangibilizing.com", true },
  { "tangiblesecurity.com", true },
  { "taniesianie.pl", true },
  { "tankski.co.uk", true },
  { "tannenhof-moelln.de", true },
  { "tantalos.nl", true },
  { "tante-bugil.net", false },
  { "tanto259.name", true },
  { "tantotiempo.de", true },
  { "tanze-jetzt.de", true },
  { "tanzhijun.com", true },
  { "tapfinder.ca", true },
  { "taquilla.com", true },
  { "taqun.club", true },
  { "taranis.re", true },
  { "tarantul.org.ua", true },
  { "tarsan.cz", true },
  { "tarsashaz-biztositas.hu", true },
  { "tartaneagle.org.uk", false },
  { "tartaros.fi", true },
  { "tas2580.net", false },
  { "taskforce512.de", true },
  { "taskotron.fedoraproject.org", true },
  { "taskotron.stg.fedoraproject.org", true },
  { "taskstats.com", true },
  { "taskstream.com", true },
  { "taskulu.com", true },
  { "tasmansecurity.com", true },
  { "tassup.com", true },
  { "tasta.ro", true },
  { "tastycake.net", true },
  { "tastyyy.co", true },
  { "tatilbus.com", false },
  { "tatort-fanpage.de", true },
  { "tatt.io", true },
  { "tattoo.dating", true },
  { "tauchkater.de", true },
  { "tavoittaja.fi", true },
  { "taxaroo.com", true },
  { "taxbench.com", true },
  { "taxisafmatosinhos.pt", true },
  { "taxspeaker.com", true },
  { "taxsquirrel.com", true },
  { "tazemama.biz", true },
  { "tazj.in", false },
  { "tazz.in", true },
  { "tbarter.com", false },
  { "tbitc.ch", true },
  { "tbrss.com", true },
  { "tbspace.de", true },
  { "tbuchloh.de", true },
  { "tcacademy.co.uk", true },
  { "tcao.info", true },
  { "tcgrepublic.com", true },
  { "tchebb.me", true },
  { "tcptun.com", true },
  { "tdelmas.eu", true },
  { "tdelmas.ovh", true },
  { "tdrs.info", true },
  { "tdude.co", true },
  { "teabagdesign.co.uk", true },
  { "teachercreatedmaterials.com", true },
  { "teacherph.com", true },
  { "teacherph.net", true },
  { "teachmeplease.com", true },
  { "teachmeplease.ru", true },
  { "teachpeople.org", true },
  { "teahut.net", true },
  { "tealdrones.com", true },
  { "team-bbd.com", true },
  { "team-one.racing", false },
  { "team-pancake.eu", true },
  { "team-teasers.com", true },
  { "team3482.com", true },
  { "teambeoplay.co.uk", true },
  { "teamblueridge.org", true },
  { "teamdaylo.xyz", true },
  { "teamhood.io", true },
  { "teamnetsol.com", true },
  { "teamnorthgermany.de", true },
  { "teampaddymurphy.ch", true },
  { "teampaddymurphy.ie", true },
  { "teampoint.cz", true },
  { "teamtouring.net", true },
  { "teamtrack.uk", true },
  { "teamupturn.com", true },
  { "teamx-gaming.de", true },
  { "teamzeus.cz", true },
  { "teasenetwork.com", true },
  { "tecart-cloud.de", true },
  { "tecart-system.de", true },
  { "tecartcrm.de", true },
  { "tech-clips.com", true },
  { "tech-essential.com", true },
  { "tech-rat.com", true },
  { "tech-seminar.jp", true },
  { "techace.jp", true },
  { "techademy.nl", true },
  { "techandtux.de", true },
  { "techcavern.ml", true },
  { "techcentric.com", false },
  { "techcultivation.de", true },
  { "techcultivation.net", true },
  { "techcultivation.org", true },
  { "techelements.co", false },
  { "techhipster.net", true },
  { "techhub.ml", true },
  { "techllage.com", true },
  { "techloaner.com", true },
  { "techmajesty.com", true },
  { "techmasters.io", true },
  { "techmatehq.com", true },
  { "technologysi.com", true },
  { "technoparcepsilon.fr", true },
  { "technoscoots.com", true },
  { "technosorcery.net", true },
  { "technotonic.com.au", false },
  { "techold.ru", true },
  { "techorbiter.com", true },
  { "techpivot.net", true },
  { "techpointed.com", true },
  { "techreview.link", true },
  { "techtalks.no", true },
  { "techtoy.store", true },
  { "techvalue.gr", true },
  { "techwords.io", true },
  { "tecnogaming.com", true },
  { "tecture.de", true },
  { "teddy.ch", true },
  { "tedeh.net", true },
  { "tedovo.com", true },
  { "tee-idf.net", true },
  { "teebeedee.org", true },
  { "teedb.de", true },
  { "teehaus-shila.de", true },
  { "teemo.gg", true },
  { "teemperor.de", true },
  { "teencounseling.com", true },
  { "teeworlds-friends.de", true },
  { "tege-elektronik.hu", true },
  { "tehotuotanto.net", true },
  { "tehrabbitt.com", false },
  { "teknologi.or.id", false },
  { "tektoria.de", false },
  { "tel-dithmarschen.de", true },
  { "telefisk.org", true },
  { "telefonkonferenz.ch", true },
  { "telefonnummer.online", true },
  { "telefoonabonnement.nl", true },
  { "telefoonnummerinfo.nl", true },
  { "telehealthventures.com", true },
  { "telekollektiv.org", true },
  { "teleogistic.net", true },
  { "telepass.me", true },
  { "telescam.com", true },
  { "telling.xyz", true },
  { "tellingua.com", true },
  { "teloo.pl", true },
  { "temizmama.com", true },
  { "temp.pm", true },
  { "tempcraft.net", true },
  { "tempus-aquilae.de", true },
  { "tenbos.ch", true },
  { "tendermaster.com.ua", true },
  { "tenderstem.co.uk", true },
  { "tendertool.nl", true },
  { "tendoryu-aikido.org", true },
  { "tenenz.com", true },
  { "tengroup.com", true },
  { "tenisservis.eu", true },
  { "tenkofx.com", true },
  { "tenni.xyz", true },
  { "tennisadmin.com", true },
  { "tenpolab.com", true },
  { "tenshoku-hanashi.com", true },
  { "tensionup.com", true },
  { "tent.io", true },
  { "tenta.com", true },
  { "tentations-voyages.com", true },
  { "tentins.com", true },
  { "tenyx.de", true },
  { "teodio.cl", true },
  { "teos.online", true },
  { "teoskanta.fi", true },
  { "tepid.org", true },
  { "teracloud.at", true },
  { "teriiphotography.com", true },
  { "terrab.de", false },
  { "terracloud.de", true },
  { "terraelectronica.ru", true },
  { "terraform.io", true },
  { "terragni-sarasin.ch", true },
  { "terrastaffinggroup.com", false },
  { "terravirtua.com", true },
  { "terraweb.net", true },
  { "terrax.info", true },
  { "terrax.net", true },
  { "terrty.net", true },
  { "terry.pub", true },
  { "tescoirelandpayslips.com", true },
  { "tesoro.pr", true },
  { "testadren.com", true },
  { "testadron.com", true },
  { "testandroid.xyz", true },
  { "testingbot.com", false },
  { "testnode.xyz", true },
  { "testomato.com", true },
  { "testosterone-complex.com", true },
  { "testsuite.org", true },
  { "tetramax.eu", true },
  { "tetrarch.co", true },
  { "tetsumaki.net", true },
  { "teuniz.nl", true },
  { "teunstuinposters.nl", false },
  { "texby.com", true },
  { "textburst.com", true },
  { "texter.at", true },
  { "texterseo.at", true },
  { "textoplano.xyz", true },
  { "textracer.dk", true },
  { "textualapp.com", true },
  { "texus.me", true },
  { "texy.info", true },
  { "tezcam.tk", true },
  { "tf-network.de", true },
  { "tf2b.com", true },
  { "tfcoms-sp-tracker-client.azurewebsites.net", true },
  { "tffans.com", false },
  { "tflite.com", true },
  { "tfnapps.de", true },
  { "tgbyte.com", true },
  { "tgbyte.de", true },
  { "tgr.re", true },
  { "th-bl.de", true },
  { "th.search.yahoo.com", false },
  { "thackbarth.net", true },
  { "thaedal.net", true },
  { "thagki9.com", true },
  { "thai.dating", true },
  { "thaianthro.com", true },
  { "thaicyberpoint.com", true },
  { "thaihomecooking.com", true },
  { "thalan.fr", true },
  { "thalhammer.it", true },
  { "thalskarth.com", true },
  { "thatgudstuff.com", true },
  { "thatpodcast.io", true },
  { "thca.ca", true },
  { "the-construct.com", true },
  { "the-delta.net.eu.org", true },
  { "the-earth-yui.net", false },
  { "the-gist.io", true },
  { "the-hemingway-code.de", true },
  { "the-mystery.org", true },
  { "the-paddies.de", true },
  { "theamp.com", true },
  { "theater.cf", true },
  { "thebigdatacompany.com", true },
  { "thebigfail.net", true },
  { "thebigwave.de", true },
  { "thebikeinsurer.co.uk", true },
  { "thebimhub.com", true },
  { "thebreakroom.org", true },
  { "thebrightons.co.uk", true },
  { "thebrotherswarde.com", true },
  { "thecandidforum.com", true },
  { "thechunk.net", true },
  { "theciderlink.com.au", true },
  { "thecitizens.com", true },
  { "thecitywarehouse.clothing", true },
  { "theclementinebutchers.com", true },
  { "thecloudmigrator.com", true },
  { "thecondobuyers.com", true },
  { "thecrochetcottage.net", true },
  { "thecustomizewindows.com", true },
  { "thedark1337.com", true },
  { "thedarkartsandcrafts.com", true },
  { "thedevrycommonsbrasil.com", true },
  { "thedisc.nl", true },
  { "thedocumentrefinery.com", true },
  { "thedreamtravelgroup.co.uk", true },
  { "thedronechart.com", true },
  { "thedrop.pw", true },
  { "thedutchmarketers.com", true },
  { "theescapistswiki.com", true },
  { "thefarbeyond.com", true },
  { "theflowerbasketonline.com", true },
  { "theflyingbear.net", true },
  { "thefox.co", true },
  { "thefreebirds.in", true },
  { "thego2swatking.com", false },
  { "thegoldregister.co.uk", true },
  { "thegraciousgourmet.com", true },
  { "thegrape.ro", true },
  { "thegreatplains.com", true },
  { "thegreenfields.se", true },
  { "thegreenmanpottery.com", true },
  { "thegreens.us", true },
  { "thegvoffice.net", true },
  { "thehackerblog.com", true },
  { "thehiddenbay.eu", true },
  { "thehiddenbay.info", true },
  { "thehiddenbay.me", true },
  { "thehiddenbay.net", true },
  { "thehotfix.net", true },
  { "theidiotboard.com", true },
  { "theinitium.com", true },
  { "theintercept.com", true },
  { "theinvisibletrailer.com", true },
  { "theitsage.com", true },
  { "thejacksoninstitute.com.au", true },
  { "thejserver.de", true },
  { "thekelvinliu.com", false },
  { "thekingofhate.com", true },
  { "thelaimlife.com", true },
  { "thelanscape.com", true },
  { "thelapine.ca", true },
  { "thelastsurprise.com", true },
  { "thelinuxspace.com", true },
  { "thelittlecraft.com", true },
  { "thelocals.ru", true },
  { "themanufacturingmarketingagency.com", true },
  { "themarshallproject.org", true },
  { "themathematician.uk", true },
  { "themeaudit.com", true },
  { "themecraft.studio", true },
  { "themicrocapital.com", true },
  { "themilanlife.com", true },
  { "themoderate.xyz", true },
  { "themoep.at", true },
  { "themonthly.com.au", true },
  { "themostexpensiveworkofart.com", true },
  { "themusthaves.nl", true },
  { "thenanfang.com", true },
  { "thenexwork.com", true },
  { "thenib.com", true },
  { "thenocman.com", true },
  { "thenorthschool.org.uk", true },
  { "theocharis.org", true },
  { "theojones.name", true },
  { "theoscure.eu", true },
  { "theoutline.com", true },
  { "thepasteb.in", true },
  { "thepaymentscompany.com", true },
  { "thepb.in", true },
  { "thephonecaseplace.com", true },
  { "thephp.cc", true },
  { "thepiratebay.al", true },
  { "thepiratebay.poker", true },
  { "thepiratebay.tech", true },
  { "theploughharborne.co.uk", true },
  { "theposhfudgecompany.co.uk", true },
  { "theprincegame.com", true },
  { "theramo.re", true },
  { "therapynotes.com", true },
  { "therapyportal.com", true },
  { "therealcost.gov", true },
  { "therevenge.me", true },
  { "therewill.be", true },
  { "thermity.com", true },
  { "thermolamina.nl", true },
  { "therockawaysny.com", true },
  { "thesaturdaypaper.com.au", true },
  { "theschool.jp", true },
  { "thescientists.nl", true },
  { "theseed.io", true },
  { "theseedbox.xyz", true },
  { "thesehighsandlows.com", true },
  { "theseletarmall.com", true },
  { "theseoframework.com", true },
  { "theseosystem.com", true },
  { "thesession.org", false },
  { "theshadestore.com", true },
  { "thesharepointfarm.com", true },
  { "theshopally.com", true },
  { "thesled.net", true },
  { "thesplit.is", true },
  { "thestack.xyz", true },
  { "thestory.ie", true },
  { "thetechnical.me", true },
  { "thetomharling.com", true },
  { "thetradinghall.com", true },
  { "thetrendspotter.net", true },
  { "thetruthhurvitz.com", true },
  { "thetuxkeeper.de", true },
  { "theunitedstates.io", true },
  { "thewebsitemarketingagency.com", true },
  { "theweilai.com", false },
  { "thewhitehat.club", true },
  { "thewhiterabbit.space", true },
  { "thewhitneypaige.com", true },
  { "thewindow.com", true },
  { "thewoodkid.com.au", true },
  { "theworkingeye.nl", true },
  { "theworldsend.eu", true },
  { "thexme.de", true },
  { "theyosh.nl", true },
  { "thezero.org", true },
  { "thibautcharles.net", true },
  { "thierfreund.de", true },
  { "thierryhayoz.ch", true },
  { "thijsvanderveen.net", true },
  { "thingies.site", true },
  { "thinkcash.nl", true },
  { "thinkcoding.de", true },
  { "thinkcoding.org", true },
  { "thinkdo.jp", true },
  { "thinkindifferent.net", true },
  { "thinklikeanentrepreneur.com", true },
  { "thinkrealty.com", true },
  { "thinktux.net", true },
  { "thinlyveiledcontempt.com", true },
  { "thisbrownman.com", true },
  { "thisfreelife.gov", true },
  { "thisisacompletetest.ga", true },
  { "thisishugo.com", false },
  { "thisserver.dontexist.net", true },
  { "thkb.net", true },
  { "thole.org", true },
  { "thom4s.info", true },
  { "thomas-gibertie.fr", true },
  { "thomas-grobelny.de", true },
  { "thomasbreads.com", true },
  { "thomasgriffin.io", true },
  { "thomasharvey.me", true },
  { "thomashunter.name", false },
  { "thomasmeester.nl", true },
  { "thomasnet.fr", true },
  { "thomasschweizer.net", true },
  { "thomastimepieces.com.au", true },
  { "thomasvochten.com", true },
  { "thomaswoo.com", true },
  { "thompsonfamily.cloud", true },
  { "thomspooren.nl", true },
  { "thomwiggers.nl", true },
  { "thorbis.com", true },
  { "thorbiswebsitedesign.com", true },
  { "thorgames.nl", true },
  { "thorstenschaefer.name", true },
  { "thouni.de", true },
  { "threatcentral.io", true },
  { "threecrownsllp.com", true },
  { "threedpro.me", true },
  { "threelions.ch", true },
  { "thriveta.com", true },
  { "thrivewellnesshub.co.za", true },
  { "throughtheglass.photo", true },
  { "throughthelookingglasslens.co.uk", true },
  { "throwaway.link", true },
  { "throwpass.com", true },
  { "thrx.net", true },
  { "thues.eu", true },
  { "thunderfox.nl", true },
  { "thyngster.com", false },
  { "thynx.io", true },
  { "ti-pla.net", true },
  { "ti-planet.org", true },
  { "ti.blog.br", true },
  { "tiacollection.com", true },
  { "tianeptine.com", true },
  { "tianshili.me", true },
  { "tianya.tv", true },
  { "tibbitshall.ca", true },
  { "ticfleet.com", true },
  { "ticketmates.com.au", true },
  { "ticketoplichting.nl", true },
  { "ticketsourcebeta.co.uk", true },
  { "tickopa.co.uk", true },
  { "tictactux.de", true },
  { "tid.jp", true },
  { "tidmore.us", true },
  { "tidycustoms.net", true },
  { "tiendavertigo.com", true },
  { "tiendschuurstraat.nl", true },
  { "tiens-ib.cz", true },
  { "tierarztpraxis-bogenhausen.de", true },
  { "tiernanx.com", true },
  { "tifan.net", true },
  { "tiffnix.com", true },
  { "tigerchef.com", true },
  { "tigerdile.com", true },
  { "tildebot.com", true },
  { "tilikum.io", true },
  { "tilkah.com.au", true },
  { "tillcraft.com", true },
  { "tillseasyscore.com", true },
  { "timdebruijn.nl", true },
  { "timdoug.com", true },
  { "time2060.ru", true },
  { "time22.com", true },
  { "timersuite.com", true },
  { "timetab.org", true },
  { "timetotrade.com", true },
  { "timewasters.nl", true },
  { "timmersgems.com", true },
  { "timmy.ws", true },
  { "timowi.de", true },
  { "timowi.net", true },
  { "timroes.de", true },
  { "timstoffel.net", false },
  { "timtaubert.de", true },
  { "timvandekamp.nl", true },
  { "timvivian.ca", true },
  { "timwittenberg.com", true },
  { "tinastahlschmidt.de", true },
  { "tindewen.net", true },
  { "tinfoilsecurity.com", false },
  { "tink.network", true },
  { "tinkertry.com", true },
  { "tinte24.de", true },
  { "tintencenter.com", true },
  { "tintenfix.net", true },
  { "tinylan.com", true },
  { "tinyspeck.com", true },
  { "tinyssh.com", true },
  { "tinyssh.org", true },
  { "tinyvpn.net", true },
  { "tinyvpn.org", true },
  { "tipbox.is", true },
  { "tiplanet.org", true },
  { "tipoftheday.tips", true },
  { "tipps-fuer-den-haushalt.de", true },
  { "tippspiel.cc", true },
  { "tipsyk.ru", true },
  { "tiredofeating.com", true },
  { "tism.in", true },
  { "tit.systems", true },
  { "titanleaf.com", true },
  { "titanous.com", true },
  { "titiansgirlphotography.com", true },
  { "tjc.host", true },
  { "tjenestetorvet.dk", true },
  { "tjs.me", true },
  { "tkappertjedemetamorfose.nl", true },
  { "tkat.ch", true },
  { "tlach.cz", true },
  { "tlo.hosting", true },
  { "tlo.network", true },
  { "tlo.xyz", true },
  { "tls.builders", true },
  { "tls.care", true },
  { "tls.li", true },
  { "tls1914.org", true },
  { "tlthings.net", true },
  { "tm.id.au", true },
  { "tmaward.net", true },
  { "tmdb.biz", true },
  { "tmf.ru", true },
  { "tmi-products.eu", true },
  { "tmi-produkter.se", true },
  { "tmitchell.io", true },
  { "tmm.cx", true },
  { "tmpraider.net", true },
  { "tmpsantos.com.br", true },
  { "tmtopup.com", true },
  { "tnb-plattform.de", true },
  { "tncnanet.com.br", true },
  { "tnes.dk", true },
  { "tno.io", true },
  { "tny.link", true },
  { "toast.al", true },
  { "tobacco.gov", true },
  { "tobi-mayer.de", true },
  { "tobias-haenel.de", true },
  { "tobias-kluge.de", true },
  { "tobias-picha.de", true },
  { "tobias-weidhase.de", true },
  { "tobiasconradi.com", true },
  { "tobiasmathes.com", true },
  { "tobiasmathes.name", true },
  { "tobiassachs.de", true },
  { "tobiassattler.com", true },
  { "tobyschrapel.com", true },
  { "tocaro.im", true },
  { "toccoig.com", true },
  { "tochi-urikata.net", true },
  { "todapolitica.com", true },
  { "todesschaf.org", true },
  { "todoescine.com", true },
  { "todoist.com", true },
  { "tofilmhub.com", true },
  { "tofu.im", true },
  { "togech.jp", true },
  { "togelonlinecommunity.com", false },
  { "togetter.com", true },
  { "tokage.me", true },
  { "tokaido-kun.jp", true },
  { "tokaido.com", true },
  { "tokenloan.com", true },
  { "tokio.fi", true },
  { "tokke.dk", true },
  { "tokoone.com", false },
  { "tokotamz.net", true },
  { "tokotimbangandigitalmurah.web.id", false },
  { "tokototech.com", true },
  { "tokoyo.biz", true },
  { "tokyo-powerstation.com", true },
  { "tokyo.dating", true },
  { "tolboe.com", true },
  { "toleressea.fr", true },
  { "toles-sur-mesure.fr", true },
  { "tollsjekk.no", true },
  { "tom-geiger.de", true },
  { "tom-kunze.de", true },
  { "tom.horse", true },
  { "tomabrafix.de", true },
  { "tomandshirley.com", true },
  { "tomasjacik.cz", true },
  { "tomaskavalek.cz", true },
  { "tomaspialek.cz", true },
  { "tomatenaufdenaugen.de", true },
  { "tomaw.net", true },
  { "tombaker.me", true },
  { "tombrossman.com", true },
  { "tomcort.com", true },
  { "tomeara.net", true },
  { "tomend.es", true },
  { "tomfisher.eu", true },
  { "tomharling.co.uk", true },
  { "tomharling.uk", true },
  { "tomjonsson.se", true },
  { "tomli.blog", true },
  { "tomli.me", true },
  { "tomm.yt", true },
  { "tommyads.com", true },
  { "tomnatt.com", true },
  { "tomo.gr", false },
  { "tomrei.com", true },
  { "tomrichards.net", true },
  { "tomssl.com", true },
  { "tomudding.nl", true },
  { "tomvote.com", true },
  { "tomwiggers.nl", false },
  { "tomwilson.io", true },
  { "tonabor.ru", true },
  { "tonage.de", true },
  { "toncusters.nl", true },
  { "tonegidoarchief.nl", true },
  { "toner24.at", true },
  { "toner24.co.uk", true },
  { "toner24.es", true },
  { "toner24.fr", true },
  { "toner24.it", true },
  { "toner24.nl", true },
  { "toner24.pl", true },
  { "tonerdepot.de", true },
  { "tonerjet.at", true },
  { "tonerjet.co.uk", true },
  { "tonerklick.de", true },
  { "tonerkurier.de", true },
  { "tonermaus.de", true },
  { "tonermonster.de", true },
  { "tonex.de", true },
  { "tonex.nl", true },
  { "tonkinson.com", true },
  { "tonsit.com", true },
  { "tonsit.org", true },
  { "tonyfantjr.com", true },
  { "tonymanning.com", false },
  { "tonytan.cn", true },
  { "tonytan.io", true },
  { "tonyw.xyz", true },
  { "tonywebster.com", true },
  { "toolbox.ninja", false },
  { "toomanypillows.com", true },
  { "toonpool.com", true },
  { "toool.nl", true },
  { "tooolroc.org", true },
  { "tooti.biz", true },
  { "top-stage.net", true },
  { "topaxi.ch", true },
  { "topaxi.codes", true },
  { "topbrakes.com", true },
  { "topdesk.net", true },
  { "topdeskdev.net", true },
  { "topdevbox.net", true },
  { "topfivepercent.co.uk", true },
  { "topmarine.se", true },
  { "topnewstoday.org", true },
  { "topnotepad.com", true },
  { "topnovini.com", true },
  { "topodin.com", true },
  { "toptexture.com", true },
  { "toptranslation.com", false },
  { "topyx.com", true },
  { "tor2web.org", true },
  { "torchl.it", true },
  { "toretame.jp", true },
  { "toretfaction.net", true },
  { "tormentedradio.com", true },
  { "torn1.se", true },
  { "torproject.org", false },
  { "torproject.org.uk", true },
  { "torprojects.com", true },
  { "torquato.de", false },
  { "torrent.fedoraproject.org", true },
  { "torrent.is", true },
  { "torrentdownloads.bid", true },
  { "torrentpier.me", true },
  { "torrenttop100.net", true },
  { "torrentz.website", true },
  { "torrentz2.eu", true },
  { "torretzalam.com", true },
  { "torservers.net", true },
  { "torsten-schmitz.net", true },
  { "torv.rocks", true },
  { "tosainu.com.br", true },
  { "tosecure.link", true },
  { "toshkov.com", true },
  { "toshnix.com", true },
  { "toshub.com", true },
  { "tosteberg.se", true },
  { "totalbeauty.co.uk", true },
  { "totalcarcheck.co.uk", true },
  { "totalchecklist.com", true },
  { "totallylegitimatehosting.ru", true },
  { "totalprint.hu", true },
  { "totaltriathlon.com", true },
  { "totalworkout.fitness", true },
  { "totch.de", true },
  { "totem-eshop.cz", true },
  { "totem-international.com", true },
  { "touch.facebook.com", false },
  { "touch.mail.ru", true },
  { "touchbasemail.com", true },
  { "touchoflife.in", true },
  { "touchpointidg.us", true },
  { "touchstonefms.co.uk", true },
  { "touchtable.nl", true },
  { "touhou.cc", true },
  { "tourismwithme.com", true },
  { "tourispo.com", true },
  { "toursandtransfers.it", true },
  { "tout-art.ch", true },
  { "toutart.ch", true },
  { "toutmonexam.fr", true },
  { "toverland-tickets.nl", true },
  { "towandalibrary.org", true },
  { "townhousedevelopments.com.au", true },
  { "tox.im", true },
  { "toymania.de", true },
  { "toysperiod.com", true },
  { "tp-iryuubun.com", true },
  { "tp-kabushiki.com", true },
  { "tp-kyouyufudousan.com", true },
  { "tp-law.jp", true },
  { "tpblist.xyz", true },
  { "tpbproxy.co", true },
  { "tpbunblocked.org", true },
  { "tpidg.us", true },
  { "tppleague.me", false },
  { "tr.search.yahoo.com", false },
  { "traas.org", true },
  { "trabbel.org", true },
  { "tracetracker.com", true },
  { "tracetracker.no", true },
  { "trackchair.com", true },
  { "trackdays4fun.com", true },
  { "trackmeet.io", true },
  { "trade-smart.ru", true },
  { "trade.gov.uk", true },
  { "tradedesk.co.za", true },
  { "tradeinvent.co.uk", true },
  { "trademan.ky", true },
  { "traderjoe-cloud.de", true },
  { "tradinews.com", true },
  { "tradinews.fr", true },
  { "tradiz.org", true },
  { "traeningsprojekt.dk", true },
  { "trafarm.ro", true },
  { "trafficquality.org", true },
  { "traffixdevices.com", true },
  { "tragmi.ch", true },
  { "trainex.org", true },
  { "trainhornforums.com", true },
  { "traininglist.org", true },
  { "trainline.de", true },
  { "trainline.es", true },
  { "trainline.eu", true },
  { "trainline.fr", true },
  { "trainline.it", true },
  { "trainut.com", true },
  { "traista.ru", true },
  { "trajano.net", true },
  { "trakfusion.com", true },
  { "tranos.de", true },
  { "transacid.de", true },
  { "transcendmotor.sg", true },
  { "transcricentro.pt", true },
  { "transdirect.com.au", true },
  { "transfer.pw", true },
  { "transfers.do", true },
  { "transferserver.at", true },
  { "transfigurewizard.com", true },
  { "transfile.fr", true },
  { "transformify.org", true },
  { "transitownplaza.com", true },
  { "transitpoint.us", true },
  { "translate.fedoraproject.org", true },
  { "translate.googleapis.com", true },
  { "translate.stg.fedoraproject.org", true },
  { "translatoruk.co.uk", true },
  { "transmisjeonline.pl", true },
  { "transmithe.net", true },
  { "transparentcorp.com", true },
  { "transport.eu", true },
  { "transverify.com", true },
  { "trashnothing.com", true },
  { "trauertexte.info", true },
  { "traut.cloud", true },
  { "travador.com", true },
  { "travality.ru", true },
  { "travelinsightswriter.com", true },
  { "travellers.dating", true },
  { "travelogue.jp", true },
  { "travelpricecheck.com", true },
  { "travisf.net", true },
  { "travisforte.io", true },
  { "travisfranck.com", true },
  { "travler.net", true },
  { "treebaglia.xyz", true },
  { "treeby.net", true },
  { "trees.chat", true },
  { "treeschat.com", true },
  { "trefpuntdemeent.nl", true },
  { "treinaweb.com.br", true },
  { "treino.blog.br", true },
  { "treker.us", true },
  { "trell.co.in", true },
  { "tremolosoftware.com", true },
  { "trendkraft.de", true },
  { "trenta.io", true },
  { "tresorit.com", true },
  { "tresorsecurity.com", true },
  { "tretkowski.de", true },
  { "triadwars.com", true },
  { "tribaldos.com", true },
  { "tribut.de", true },
  { "tributh.net", true },
  { "trident-online.de", true },
  { "trik.es", false },
  { "trim-a-slab.com", true },
  { "trimage.org", true },
  { "trineco.com", true },
  { "trineco.fi", true },
  { "trinnes.net", true },
  { "triop.se", true },
  { "trior.net", true },
  { "tripcombi.com", true },
  { "triple-mmm.de", true },
  { "tripseats.com", true },
  { "trixexpressweb.nl", true },
  { "trixies-wish.nz", true },
  { "trkpuls.tk", true },
  { "troi.de", true },
  { "troianet.com.br", true },
  { "trollme.me", true },
  { "trollscave.xyz", true },
  { "trommelwirbel.com", true },
  { "tronatic-studio.com", true },
  { "trondelan.no", true },
  { "troo.ly", true },
  { "trophee-discount.com", true },
  { "trotec.com", true },
  { "truckersmp.com", true },
  { "truckerswereld.nl", false },
  { "truckstop-magazin.de", false },
  { "true.ink", true },
  { "trueblueessentials.com", true },
  { "truebred-labradors.com", true },
  { "trueinstincts.ca", true },
  { "truejob.com", true },
  { "truestaradvisors.com", true },
  { "truesteamachievements.com", true },
  { "trueteaching.com", true },
  { "truetrophies.com", true },
  { "trufflemonkey.co.uk", true },
  { "truserve.org", true },
  { "trustcase.com", true },
  { "trustedinnovators.com", true },
  { "trustmeimfancy.com", true },
  { "truthmessages.pw", true },
  { "trw-reseller.com", true },
  { "tryfabulousdiet.com", true },
  { "tryfabulousskincream.com", true },
  { "tryfabulousskinserum.com", true },
  { "trynowrinkleseyeserum.com", true },
  { "trywesayyes.com", true },
  { "trzepak.pl", true },
  { "ts3.consulting", true },
  { "tsaro.io", true },
  { "tsgbit.net", true },
  { "tsrstore.gq", true },
  { "tsumegumi.net", true },
  { "tsumi.it", true },
  { "tsurimap.com", true },
  { "tsuyuzakihiroyuki.com", true },
  { "tsv-1894.de", true },
  { "ttb.gov", true },
  { "ttbonline.gov", true },
  { "ttcf.ca", true },
  { "ttchan.org", true },
  { "tts.co.nz", true },
  { "ttsoft.pl", true },
  { "ttt.tt", true },
  { "ttuwiki.ee", true },
  { "ttuwiki.org", true },
  { "tty.space", true },
  { "ttz.im", true },
  { "tuamoronline.com", true },
  { "tubbutec.de", true },
  { "tubetoon.com", true },
  { "tubex.ga", true },
  { "tubul.net", true },
  { "tucker.wales", true },
  { "tucny.com", true },
  { "tucuxi.org", true },
  { "tuingereedschappen.net", true },
  { "tuitle.com", true },
  { "tuja.hu", true },
  { "tumagiri.net", true },
  { "tumedico.es", true },
  { "tumelum.de", true },
  { "tumutanzi.com", true },
  { "tunai.id", true },
  { "tunebitfm.de", true },
  { "tunefish-entertainment.de", true },
  { "tuningblog.eu", false },
  { "tunnelblick.net", true },
  { "tunnelwatch.com", true },
  { "tuntitili.fi", true },
  { "turbobit.ch", true },
  { "turkrock.com", true },
  { "turnik-67.ru", true },
  { "turniker.ru", true },
  { "turnoffthelights.com", true },
  { "tursiae.org", true },
  { "turtle.ai", true },
  { "turtleduckstudios.com", true },
  { "turtlementors.com", true },
  { "tussengelegenwoningverkopen.nl", true },
  { "tutorialinux.com", true },
  { "tuvalie.com", true },
  { "tuxcall.de", true },
  { "tuxcloud.net", true },
  { "tuxflow.de", true },
  { "tuxgeo.com", false },
  { "tuxie.com", true },
  { "tuxlife.net", true },
  { "tuxplace.nl", true },
  { "tuxz.net", true },
  { "tuzaijidi.com", true },
  { "tv2vie.org", true },
  { "tvbeugels.nl", false },
  { "tw.search.yahoo.com", false },
  { "twaka.com", true },
  { "twarog.cc", true },
  { "twd2.me", true },
  { "twd2.net", false },
  { "tweakers.net", true },
  { "twee-onder-een-kap-woning-in-alphen-aan-den-rijn-kopen.nl", true },
  { "twee-onder-een-kap-woning-in-brielle-kopen.nl", true },
  { "twee-onder-een-kap-woning-in-de-friese-meren-kopen.nl", true },
  { "twee-onder-een-kap-woning-in-delfzijl-kopen.nl", true },
  { "twee-onder-een-kap-woning-in-leeuwarden-kopen.nl", true },
  { "twee-onder-een-kap-woning-in-pekela-kopen.nl", true },
  { "twee-onder-een-kap-woning-in-rijnwaarden-kopen.nl", true },
  { "twee-onder-een-kap-woning-in-sudwest-fryslan-kopen.nl", true },
  { "twee-onder-een-kap-woning-in-veendam-kopen.nl", true },
  { "twee-onder-een-kap-woning-in-zuidplas-kopen.nl", true },
  { "twee-onder-een-kap-woning-in-zwartewaterland-kopen.nl", true },
  { "tweeondereenkapverkopen.nl", true },
  { "tweeondereenkapwoningverkopen.nl", true },
  { "twelve.rocks", true },
  { "twelve.today", true },
  { "twelverocks.com", true },
  { "twentymilliseconds.com", true },
  { "twillionmas.com", true },
  { "twist.party", true },
  { "twistapp.com", true },
  { "twistedwave.com", true },
  { "twisto.cz", true },
  { "twitter.ax", true },
  { "twitter.com", false },
  { "twitteroauth.com", true },
  { "twodadsgames.com", true },
  { "twofactorauth.org", true },
  { "twojfaktum.pl", true },
  { "twolanedesign.com", true },
  { "twolinepassbrewing.com", true },
  { "twolivelife.com", true },
  { "twopif.net", true },
  { "twotube.ie", true },
  { "twun.io", true },
  { "twuni.org", true },
  { "txf.pw", true },
  { "txi.su", true },
  { "tyche.io", true },
  { "tyil.nl", true },
  { "tyil.work", true },
  { "tyl.io", true },
  { "tyler.rs", true },
  { "tylerfreedman.com", true },
  { "tyleromeara.com", true },
  { "tylerschmidtke.com", true },
  { "typeblog.net", true },
  { "typecodes.com", true },
  { "typehub.net", true },
  { "typeofweb.com", true },
  { "typeonejoe.com", true },
  { "typeria.net", true },
  { "typewolf.com", true },
  { "typing.com", true },
  { "typingrevolution.com", true },
  { "typo3.com", true },
  { "tysye.ca", true },
  { "tzappa.net", true },
  { "tzwe.com", true },
  { "u03.fr", true },
  { "u5b.de", true },
  { "uae-company-service.com", true },
  { "uangteman.com", true },
  { "uasmi.com", true },
  { "uat-activesg.com", true },
  { "ub3rk1tten.com", false },
  { "ubanquity.com", true },
  { "uber.com.au", true },
  { "uberboxen.net", true },
  { "uberfunction.com", true },
  { "ubertt.org", true },
  { "uberwald.de", true },
  { "uberwald.ws", true },
  { "ubicloud.de", true },
  { "ubicv.com", true },
  { "ubtce.com", true },
  { "ucfirst.nl", true },
  { "uctarna.online", true },
  { "udbhav.me", true },
  { "udo-luetkemeier.de", true },
  { "udomain.net", true },
  { "udp.sh", true },
  { "udruga-point.hr", true },
  { "uefeng.com", true },
  { "uerdingen.info", true },
  { "uesociedadlimitada.com", true },
  { "ueu.me", true },
  { "uevan.com", true },
  { "ufindme.at", true },
  { "ugcdn.com", true },
  { "uggedal.com", true },
  { "ugisgutless.com", true },
  { "uhc.gg", true },
  { "uhm.io", true },
  { "uhrenlux.de", true },
  { "uicchy.com", true },
  { "uiop.link", true },
  { "ujob.com.cn", true },
  { "uk.dating", true },
  { "uk.search.yahoo.com", false },
  { "ukchemicalresearch.org", true },
  { "ukdefencejournal.org.uk", true },
  { "ukhas.net", true },
  { "ukk.dk", false },
  { "ukpirate.org", true },
  { "ukrainians.ch", true },
  { "ukrgadget.com", true },
  { "ukrigging.net", true },
  { "ukwct.org.uk", true },
  { "ulabox.com", true },
  { "uli-eckhardt.de", true },
  { "ulmer-schneesport.de", false },
  { "ulrik.moe", true },
  { "ultieme.be", true },
  { "umassfive.coop", true },
  { "umenlisam.com", true },
  { "umgardi.ca", true },
  { "umisonoda.com", true },
  { "umwandeln-online.de", true },
  { "un-zero-un.fr", true },
  { "unapp.me", true },
  { "unart.info", true },
  { "unblockall.xyz", true },
  { "unblockat.tk", true },
  { "unblocked-networks.org", true },
  { "unblocked.date", true },
  { "unblocked.faith", true },
  { "unblocked.host", true },
  { "unblocked.ink", true },
  { "unblocked.live", true },
  { "unblocked.one", true },
  { "unblocked.party", true },
  { "unblocked.uno", true },
  { "unblocked.vip", true },
  { "unblocked.win", true },
  { "unblockedall.site", true },
  { "unblockedbay.info", true },
  { "unblockerproxy.site", true },
  { "unblockerproxy.top", true },
  { "unblockmy.party", true },
  { "unblockmy.tech", true },
  { "unblockmy.xyz", true },
  { "unblockmyproxy.site", true },
  { "unblockthe.site", true },
  { "unblockthe.top", true },
  { "unblockweb.co", true },
  { "unccdesign.club", true },
  { "unclegen.xyz", true },
  { "under30stravelinsurance.com.au", true },
  { "underskatten.tk", true },
  { "undo.co.il", true },
  { "undone.me", true },
  { "unearaigneeauplafond.fr", false },
  { "unexpected.nu", true },
  { "unfuddle.cn", true },
  { "ungegamere.dk", true },
  { "uni-games.com", true },
  { "unicef.pl", true },
  { "unicorncloud.org", true },
  { "unicredit.ba", true },
  { "unicredit.ro", true },
  { "unicreditbank.hu", true },
  { "unicreditbank.rs", true },
  { "unicreditbank.ru", false },
  { "uniekglas.nl", true },
  { "uniform-agri.com", true },
  { "unikitty-on-tour.com", true },
  { "unila.edu.br", true },
  { "unionplat.ru", true },
  { "unionstationapp.com", true },
  { "uniprimebr.com.br", true },
  { "uniq.site", true },
  { "unirenter.ru", true },
  { "unit7jazz.com", true },
  { "unit7jazz.org", true },
  { "united.com", false },
  { "unitedadmins.com", true },
  { "unitedcyberdevelopment.com", true },
  { "unitel2000.de", true },
  { "unitlabs.net", true },
  { "unitrade-425.co.za", true },
  { "universalcarremote.com", true },
  { "universalpaymentgateway.com", true },
  { "universogay.com", true },
  { "unixadm.org", true },
  { "unixattic.com", true },
  { "unixcorn.org", false },
  { "unixforum.org", true },
  { "unknownphenomena.net", true },
  { "unlax.com", true },
  { "unli.xyz", true },
  { "unlocken.nl", true },
  { "unmanaged.space", false },
  { "unmonito.red", true },
  { "uno-pizza.ru", true },
  { "unoccupyabq.org", true },
  { "unpkg.com", true },
  { "unplugg3r.dk", true },
  { "unpossible.xyz", true },
  { "unpr.dk", true },
  { "unquote.li", true },
  { "unrealircd.org", true },
  { "unrelated.net.au", true },
  { "uns.vn", true },
  { "unseen.is", true },
  { "unseen.tw", true },
  { "unser-gartenforum.de", true },
  { "unsupervised.ca", true },
  { "unsuspicious.click", true },
  { "unterfrankenclan.de", true },
  { "unterschicht.tv", true },
  { "untoldstory.eu", true },
  { "unun.fi", true },
  { "unveiledgnosis.com", true },
  { "unwiredbrain.com", true },
  { "unwomen.is", true },
  { "unxicdellum.cat", true },
  { "unyq.me", false },
  { "uonstaffhub.com", true },
  { "uow.ninja", true },
  { "up1.ca", true },
  { "upandclear.org", true },
  { "upay.ru", true },
  { "upboard.jp", true },
  { "upgauged.com", true },
  { "upitnik.rs", true },
  { "upldr.pw", true },
  { "uplinklabs.net", true },
  { "upload.facebook.com", false },
  { "uploadbeta.com", true },
  { "upmchealthsecurity.us", true },
  { "upnext.io", true },
  { "upplevelse.com", true },
  { "upr-info.org", true },
  { "upr.com.ua", true },
  { "upstats.eu", true },
  { "uptic.net", true },
  { "uptimed.com", true },
  { "uptimenotguaranteed.com", true },
  { "uptogood.org", true },
  { "uptrends.com", true },
  { "uptrends.de", true },
  { "ur-lauber.de", true },
  { "urbackups.com", true },
  { "urban-garden.lt", true },
  { "urban-garden.lv", true },
  { "urban.melbourne", true },
  { "urbanesecurity.com", true },
  { "urbanmelbourne.info", true },
  { "urbpic.com", true },
  { "ureka.org", true },
  { "uripura.de", true },
  { "url.cab", true },
  { "url.rw", false },
  { "urlchomp.com", true },
  { "urown.net", true },
  { "urspringer.de", true },
  { "ursuslibris.hu", true },
  { "usaab.org", true },
  { "usabackground.com", true },
  { "usability.gov", true },
  { "usajobs.gov", true },
  { "usakitchensandflooring.com", true },
  { "usap.gov", false },
  { "usbcraft.com", true },
  { "usbirthcertificate.com", false },
  { "usbtypeccompliant.com", true },
  { "uscloud.nl", true },
  { "uscntalk.com", true },
  { "usd.de", true },
  { "use.be", true },
  { "usedesk.ru", true },
  { "useresponse.com", true },
  { "usetypo3.com", true },
  { "usgande.com", true },
  { "ushare.ch", true },
  { "usimmigration.us", true },
  { "usitcolours.bg", true },
  { "uslab.io", true },
  { "usleep.net", true },
  { "usmint.gov", true },
  { "usparklodging.com", true },
  { "usportsgo.com", true },
  { "uspsoig.gov", true },
  { "ussm.gov", false },
  { "ust.space", true },
  { "uswitch.com", true },
  { "utdsgda.com", true },
  { "utilia.tools", true },
  { "utilitarian.com", true },
  { "utilitarianism.com", true },
  { "utilitarianism.org", true },
  { "utilityapi.com", true },
  { "utleieplassen.no", true },
  { "utonia.ch", true },
  { "utopianrealms.org", true },
  { "utopians.dk", true },
  { "utopicestudios.com", true },
  { "uttnetgroup.fr", false },
  { "uygindir.ml", true },
  { "uzmandroid.com", true },
  { "uzmandroid.top", false },
  { "v-u-z.ru", true },
  { "v0rtex.xyz", true },
  { "v0tti.com", false },
  { "v2bv.win", true },
  { "v2ex.com", true },
  { "v2ex.us", true },
  { "v4veedu.com", true },
  { "va-reitartikel.com", true },
  { "vaccines.gov", true },
  { "vaddder.com", true },
  { "vadik.me", true },
  { "vagrantup.com", true },
  { "vakuutuskanava.fi", true },
  { "val-sec.com", true },
  { "valasi.eu", true },
  { "valbonne-consulting.com", true },
  { "valentin-sundermann.de", true },
  { "valeriansaliou.name", true },
  { "validator.nu", true },
  { "validbrands.com", true },
  { "valis.sx", true },
  { "valitron.se", true },
  { "valkohattu.fi", true },
  { "valleyridgepta.org", true },
  { "valmagus.com", false },
  { "valokuva-albumi.fi", true },
  { "valopv.be", true },
  { "valordolarblue.com.ar", true },
  { "valshamar.is", true },
  { "valsk.is", true },
  { "valskis.lt", true },
  { "valtoaho.com", true },
  { "vampirism.eu", true },
  { "van11y.net", true },
  { "vanacht.co.za", true },
  { "vandalfsen.me", true },
  { "vanderkley.it", true },
  { "vanderrijt.nl", true },
  { "vanderstraeten.dynv6.net", true },
  { "vanderziel.org", true },
  { "vanestack.com", true },
  { "vanetv.com", true },
  { "vangeluwedeberlaere.be", true },
  { "vanhoutte.be", false },
  { "vanhove.biz", true },
  { "vanitas.xyz", true },
  { "vanitynailworkz.com", true },
  { "vanlaanen.com", true },
  { "vanmalland.com", true },
  { "vansieleghem.com", true },
  { "vante.me", true },
  { "vantien.com", true },
  { "vantru.is", true },
  { "vanwunnik.com", true },
  { "vapehour.com", true },
  { "vapemania.eu", true },
  { "vapeshopsupply.com", true },
  { "vapordepot.jp", true },
  { "varden.info", true },
  { "varghese.de", true },
  { "variag-group.ru", true },
  { "variag-montazh.ru", true },
  { "varicoseveinssolution.com", true },
  { "varshathacker.com", true },
  { "varunagw.com", false },
  { "varunpriolkar.com", true },
  { "varvy.com", true },
  { "vashel.us", true },
  { "vat-eu.com", true },
  { "vattulainen.fi", true },
  { "vault21.net", true },
  { "vaultproject.io", true },
  { "vaur.fr", true },
  { "vavai.net", true },
  { "vavel.com", true },
  { "vazue.com", true },
  { "vbazile.com", true },
  { "vbest.net", true },
  { "vbh2o.com", true },
  { "vbhelp.org", true },
  { "vbulletin-russia.com", true },
  { "vbulletinrussia.com", true },
  { "vcelin-na-doliku.cz", true },
  { "vcf.gov", true },
  { "vcientertainment.com", false },
  { "vcr.re", true },
  { "vcsjones.com", true },
  { "vd42.net", true },
  { "vdbongard.com", true },
  { "vdcomp.cz", true },
  { "vdemuzere.be", true },
  { "vdesc.com", true },
  { "vdhco.be", true },
  { "vdownloader.com", true },
  { "vdrpro.com", true },
  { "ve.search.yahoo.com", false },
  { "ve3oat.ca", true },
  { "vea.re", true },
  { "veblen.com", false },
  { "veblr.com", true },
  { "vecozo.nl", true },
  { "vedatkamer.com", true },
  { "veg-leiden.nl", true },
  { "vega.dyndns.info", true },
  { "vegalitarian.org", true },
  { "vegane-proteine.com", true },
  { "veganism.com", true },
  { "veggiesbourg.fr", true },
  { "vehicleenquiry.service.gov.uk", true },
  { "vehicletax.service.gov.uk", true },
  { "veii.de", true },
  { "veil-framework.com", true },
  { "velasense.com", true },
  { "velen.io", true },
  { "venicerealdeal.com", true },
  { "venixplays-stream.ml", true },
  { "ventesprivees-fr.com", true },
  { "venturepro.com", true },
  { "venzocrm.com", true },
  { "veramagazine.jp", true },
  { "verberne.nu", true },
  { "verdeandco.co.uk", true },
  { "verdict.gg", true },
  { "verein-kiekin.de", true },
  { "vereinlandwege.de", true },
  { "vereinscheck.de", true },
  { "verfassungsklage.at", true },
  { "verifiedinvesting.com", true },
  { "verifikatorindonesia.com", true },
  { "verifyos.com", true },
  { "veriny.tf", true },
  { "verizonguidelines.com", true },
  { "verliefde-jongens.nl", true },
  { "veronique-schmitz.de", true },
  { "versbeton.nl", true },
  { "versicherungskontor.net", true },
  { "verspai.de", true },
  { "vertner.net", true },
  { "veryapt.com", true },
  { "veryhax.de", true },
  { "ves.vn.ua", true },
  { "vespacascadia.com", true },
  { "vestacp.top", true },
  { "vetdnacenter.com", false },
  { "veterinaire-cazeres-foucault.fr", true },
  { "vetinte.eu", true },
  { "vetmgmt.com", true },
  { "veto.fish", true },
  { "vetofish.com", true },
  { "vets.gov", true },
  { "vfdworld.com", true },
  { "vfree.org", true },
  { "vgatest.nl", true },
  { "vgerak.com", true },
  { "vglimg.com", true },
  { "vgropp.de", true },
  { "vh.net", true },
  { "vhost.co.id", true },
  { "viadeux.com", true },
  { "viaprinto.de", true },
  { "viasinc.com", false },
  { "vibrant-america.com", true },
  { "vicenage.com", true },
  { "vician.cz", true },
  { "vicianovi.cz", true },
  { "viciousviscosity.xyz", true },
  { "victorcanera.com", true },
  { "victordiaz.me", true },
  { "victorjacobs.com", true },
  { "vid-immobilien.de", true },
  { "vid.me", true },
  { "vidbuchanan.co.uk", true },
  { "vide-dressing.org", false },
  { "vide-greniers.org", false },
  { "vide-maisons.org", false },
  { "videogamesartwork.com", true },
  { "videomail.io", true },
  { "videosqr.com", true },
  { "videotogel.net", false },
  { "vidid.net", false },
  { "vieaw.com", true },
  { "vieclam24h.vn", false },
  { "viemeister.com", true },
  { "viennan.net", true },
  { "vietnamese.dating", true },
  { "vietnamhost.vn", true },
  { "vietnamwomenveterans.org", true },
  { "viewmyrecords.com", true },
  { "viewsea.com", true },
  { "vigilantnow.com", true },
  { "vigilo.cf", true },
  { "vigilo.ga", true },
  { "vigo-krankenversicherung.de", true },
  { "vigo-tarife.de", true },
  { "vigrey.com", true },
  { "vijverbenodigdheden.nl", true },
  { "vikasbabyworld.de", false },
  { "vikashkumar.me", true },
  { "vikings.net", true },
  { "vilaydin.com", true },
  { "villa-romantica-zillertal.at", true },
  { "villasenor.online", true },
  { "villenavedornon.fr", true },
  { "villenvinkit.com", true },
  { "vimeo.com", true },
  { "vinagro.sk", true },
  { "vinasec.se", true },
  { "vincentcox.com", false },
  { "vincentpancol.com", true },
  { "vinciconps4.it", true },
  { "vincitraining.com", true },
  { "vineright.com", true },
  { "vinesauce.info", true },
  { "vinicius.sl", true },
  { "vinilosdecorativos.net", true },
  { "vinner.com.au", true },
  { "vintagetrailerbuyers.com", true },
  { "vinyculture.com", true },
  { "violenceinterrupted.org", true },
  { "violin4fun.nl", true },
  { "viosey.com", true },
  { "viperdns.com", true },
  { "viphospitality.se", true },
  { "vipi.es", true },
  { "vipmusic.ga", false },
  { "vipnettikasinoklubi.com", true },
  { "virginiacrimeanalysisnetwork.org", true },
  { "virtualdesignmedia.com", false },
  { "virtuallifestyle.nl", true },
  { "virtualperez.com", true },
  { "virtualsanity.com", true },
  { "virtualstrongbox.ca", true },
  { "visage.ch", true },
  { "visalogy.com", true },
  { "viscopic.com", true },
  { "viserproject.com", true },
  { "visibox.nl", true },
  { "visikom.de", true },
  { "visioflux-premium.com", true },
  { "visionarymedia.nl", true },
  { "visionless.me", false },
  { "visiontree-beta.eu", true },
  { "visiontree.eu", true },
  { "visitbroadstairs.com", true },
  { "vispaleistexel.nl", true },
  { "vissersgrootboek.nl", true },
  { "vistaalmar.es", true },
  { "vistb.me", true },
  { "visualideas.org", true },
  { "vitagenda.nl", true },
  { "vitalismaatjes.nl", true },
  { "vitalita.cz", true },
  { "vitalthings.de", true },
  { "vitapingu.de", true },
  { "vitastic.nl", true },
  { "vitkausk.as", true },
  { "vitrado.de", true },
  { "vitsoft.by", true },
  { "vitta.me", true },
  { "vivaldi.club", true },
  { "vivatv.com.tw", true },
  { "vivendi.de", true },
  { "vivocloud.com", true },
  { "vizeat.com", true },
  { "vizional.com", true },
  { "vizzboard.com", true },
  { "vjeff.com", true },
  { "vjirovsky.cz", false },
  { "vkox.com", true },
  { "vksportphoto.com", true },
  { "vldkn.net", true },
  { "vleij.com", true },
  { "vleij.family", true },
  { "vleij.se", true },
  { "vloeck.de", true },
  { "vlogge.com", true },
  { "vlora.city", true },
  { "vmc.co.id", true },
  { "vmem.jp", true },
  { "vmis.nl", true },
  { "vmoagents.com", false },
  { "vmrdev.com", true },
  { "vmug.pl", true },
  { "vn.search.yahoo.com", false },
  { "vnd.cloud", true },
  { "vnfs-team.com", true },
  { "vnvisa.center", true },
  { "vnvisa.ru", true },
  { "vocab.guru", true },
  { "vocaloid.my", true },
  { "vodpay.com", true },
  { "vodpay.net", true },
  { "vodpay.org", true },
  { "vogler.name", true },
  { "vogt.tech", true },
  { "voidi.ca", true },
  { "voidpay.com", true },
  { "voidpay.net", true },
  { "voidpay.org", true },
  { "voidserv.net", true },
  { "vokativy.cz", true },
  { "vokeapp.com", true },
  { "volcain.io", true },
  { "volgavibes.ru", true },
  { "voliere-info.nl", false },
  { "volkden.com", true },
  { "volker-gropp.de", true },
  { "volkergropp.de", true },
  { "volkswurst.de", true },
  { "volto.io", true },
  { "voltotc.com", true },
  { "vomitb.in", true },
  { "vonavy-cukor.sk", true },
  { "vonavycukor.sk", true },
  { "vonedelmann.de", true },
  { "voodoo-laden.de", true },
  { "voodoochile.at", true },
  { "vooreenveiligthuis.nl", true },
  { "voorjou.com", true },
  { "vop.li", true },
  { "vorangerie.com", true },
  { "vorlif.org", true },
  { "vorm2.com", true },
  { "vorodevops.com", true },
  { "voshod.org", true },
  { "vostronet.com", true },
  { "voter-info.uk", true },
  { "votocek.cz", true },
  { "votockova.cz", true },
  { "votoot.com", true },
  { "voxographe.com", false },
  { "voyageforum.com", true },
  { "vpip.net", true },
  { "vpn.black", true },
  { "vpn.ht", true },
  { "vpnhot.com", true },
  { "vpnzoom.com", true },
  { "vps-szerver-berles.hu", true },
  { "vpsmojo.com", true },
  { "vrandopulo.ru", true },
  { "vratny.space", true },
  { "vrijgezellen-feest.com", true },
  { "vrijstaandhuis-in-brielle-kopen.nl", true },
  { "vrijstaandhuis-in-delfzijl-kopen.nl", true },
  { "vrijstaandhuis-in-laren-kopen.nl", true },
  { "vrijstaandhuis-in-leeuwarden-kopen.nl", true },
  { "vrijstaandhuis-in-veendam-kopen.nl", true },
  { "vrijstaandhuis-in-zeeland-kopen.nl", true },
  { "vrijstaandhuis-in-zuid-holland-kopen.nl", true },
  { "vrijstaandhuis-in-zuidplas-kopen.nl", true },
  { "vrijstaandhuis-in-zwartewaterland-kopen.nl", true },
  { "vrijstaandhuisverkopen.nl", true },
  { "vrobert.fr", false },
  { "vrtak-cz.net", true },
  { "vrzl.pro", true },
  { "vscale.io", true },
  { "vsean.net", true },
  { "vserver-preis-vergleich.de", true },
  { "vsund.de", true },
  { "vubey.yt", true },
  { "vuljespaarpot.nl", true },
  { "vulnerability.ch", true },
  { "vulners.com", true },
  { "vulnscan.org", true },
  { "vumetric.com", true },
  { "vuosaarenmontessoritalo.fi", true },
  { "vux.li", true },
  { "vxapps.com", true },
  { "vxstream-sandbox.com", true },
  { "vyber-odhadce.cz", true },
  { "vyberodhadce.cz", true },
  { "vyplnto.cz", true },
  { "vyskocil.eu", true },
  { "vzk.io", false },
  { "vztekloun.cz", true },
  { "w-spotlight.appspot.com", true },
  { "w-w-auto.de", true },
  { "w.wiki", true },
  { "w3ctag.org", true },
  { "w3n.org", true },
  { "w4nvu.org", true },
  { "w4xzr.top", true },
  { "w4xzr.xyz", true },
  { "w7k.de", true },
  { "wa-stromerzeuger.de", true },
  { "wachter.biz", true },
  { "waelti.xxx", true },
  { "wafa4hw.com", true },
  { "waffle.at", true },
  { "wahlman.org", true },
  { "wahrnehmungswelten.de", true },
  { "wail.net", true },
  { "wait.jp", true },
  { "wait.moe", true },
  { "waits.io", true },
  { "waixingrenfuli.vip", true },
  { "waixingrenfuli7.vip", true },
  { "waka-mono.com", true },
  { "wakamiyasumiyosi.com", true },
  { "wakatime.com", true },
  { "wakened.net", true },
  { "walkeryoung.ca", true },
  { "walkingforhealth.org.uk", true },
  { "wallabag.it", true },
  { "wallace-group.net", true },
  { "wallet.google.com", true },
  { "wallethub.com", false },
  { "wallingford.cc", true },
  { "wallpapers.pub", true },
  { "walls.io", true },
  { "wallsblog.dk", true },
  { "walnutgaming.co.uk", false },
  { "walnutgaming.com", false },
  { "wan.pp.ua", false },
  { "wanban.io", true },
  { "wander.al", true },
  { "wandervoll.ch", true },
  { "wane.co", true },
  { "wangjun.me", true },
  { "wangqiliang.cn", true },
  { "wangqiliang.com", true },
  { "wangqiliang.org", true },
  { "wangqiliang.xn--fiqs8s", true },
  { "wangql.cn", true },
  { "wangql.net", true },
  { "wangqr.tk", true },
  { "wantshow.com.br", true },
  { "wanybug.cn", true },
  { "wardow.com", true },
  { "warekon.com", true },
  { "warekon.dk", true },
  { "warhaggis.com", true },
  { "warmestwishes.ca", true },
  { "warmlyyours.com", false },
  { "warmservers.com", true },
  { "warr.ath.cx", true },
  { "warrencreative.com", false },
  { "warsh.moe", true },
  { "wartorngalaxy.com", true },
  { "warumsuchen.at", true },
  { "waschpark-hantschel.de", true },
  { "wasema.com", true },
  { "wasserspucker.de", true },
  { "wassim.is", true },
  { "watchface.watch", true },
  { "watchinventory.com", true },
  { "watchstyle.com", true },
  { "watchweasel.com", true },
  { "waterfedpole.com", true },
  { "waterforlife.net.au", true },
  { "watersb.org", true },
  { "watertrails.io", true },
  { "watsonhall.uk", true },
  { "wave.is", true },
  { "wavefrontsystemstech.com", true },
  { "wavesboardshop.com", true },
  { "wawak.pl", true },
  { "waxdramatic.com", true },
  { "waylaydesign.com", true },
  { "wayne.cloud", true },
  { "wayohoo.com", true },
  { "wayohoo.net", true },
  { "waze.com", true },
  { "wbg-vs.de", true },
  { "wbt-solutions.ch", true },
  { "wbt-solutions.net", true },
  { "wbuntu.com", true },
  { "wbvb.nl", true },
  { "wcbook.ru", true },
  { "wdbgroup.co.uk", true },
  { "wdesk.com", true },
  { "wdrl.info", true },
  { "wdt.cz", false },
  { "we-bb.com", true },
  { "wealthcentral.com.au", true },
  { "wealthprojector.com", true },
  { "wealthprojector.com.au", true },
  { "wealthreport.com.au", true },
  { "wearandcare.net", true },
  { "wearegenki.com", true },
  { "wearepapermill.co", true },
  { "wearvr.com", true },
  { "weather-and-climate.com", false },
  { "weathermyway.rocks", true },
  { "web-hotel.gr", true },
  { "web-industry.fr", true },
  { "web-insider.net", true },
  { "web-vision.de", true },
  { "web2033.com", true },
  { "webandmore.de", false },
  { "webandwords.com.au", true },
  { "webapps.directory", true },
  { "webassadors.com", false },
  { "webbhuset.se", false },
  { "webcamtoy.com", true },
  { "webchat.domains", false },
  { "webcollect.org.uk", true },
  { "webcontentspinning.com", true },
  { "webdesigneauclaire.com", true },
  { "webdev.mobi", true },
  { "webdevops.io", true },
  { "webdosh.com", true },
  { "webduck.nl", true },
  { "webeau.com", true },
  { "webeconomia.it", true },
  { "webelement.sk", true },
  { "webergrillrestaurant.com", true },
  { "webfilings-eu-mirror.appspot.com", true },
  { "webfilings-eu.appspot.com", true },
  { "webfilings-mirror-hrd.appspot.com", true },
  { "webfilings.appspot.com", true },
  { "webgarten.ch", true },
  { "webhackspro.com", true },
  { "weblate.org", true },
  { "weblogic.pl", true },
  { "weblogzwolle.nl", true },
  { "webm.to", true },
  { "webmail.gigahost.dk", false },
  { "webmail.info", true },
  { "webmail.onlime.ch", false },
  { "webmail.schokokeks.org", false },
  { "webmail.xalqbank.az", true },
  { "webmandesign.eu", true },
  { "webmax.com.tr", true },
  { "webmedpharmacy.co.uk", true },
  { "webmetering.at", true },
  { "webnosql.com", true },
  { "webogram.org", false },
  { "webproject.rocks", true },
  { "webrebels.org", true },
  { "webreport.fr", true },
  { "webs4all.ro", true },
  { "webscale.nl", true },
  { "websectools.com", true },
  { "websecurity.is", true },
  { "webseitendesigner.com", false },
  { "webseitenserver.com", true },
  { "websenat.de", true },
  { "webstationservice.fr", true },
  { "webstellung.com", true },
  { "webstore.be", false },
  { "webstory.xyz", true },
  { "webstudio-n.com", true },
  { "webstylemedia.com", true },
  { "webswitch.io", true },
  { "webtalis.nl", true },
  { "webtasarim.pw", true },
  { "webtheapp.com", true },
  { "webthings.com.br", true },
  { "webtiles.co.uk", true },
  { "webtobesocial.de", true },
  { "webtorrent.io", true },
  { "webtrh.cz", true },
  { "webtropia.com", false },
  { "webwit.nl", true },
  { "webwork.pw", true },
  { "webyazilimankara.com", true },
  { "webzanem.com", true },
  { "wecanfindit.co.za", true },
  { "weddingibiza.nl", true },
  { "weddywood.ru", true },
  { "weeblr.com", true },
  { "weekdone.com", true },
  { "weekly-residence.com", true },
  { "weekly.fyi", true },
  { "weerstatistieken.nl", true },
  { "wefinanceinc.com", true },
  { "wegenaer.nl", true },
  { "weggeweest.nl", true },
  { "wegner.no", true },
  { "weibomiaopai.com", true },
  { "weicn.org", true },
  { "weiji.ga", true },
  { "weimaraner.com.br", true },
  { "wein.cc", true },
  { "weirdesigns.com", true },
  { "weisse-liste.de", true },
  { "weissman.agency", true },
  { "weiterbildung-vdz.de", true },
  { "weiyuz.com", true },
  { "weizenke.im", true },
  { "weizenspr.eu", true },
  { "welches-kinderfahrrad.de", true },
  { "welcomehelp.de", true },
  { "wellacapability.com", true },
  { "welldrake.com", true },
  { "wellensteyn.ru", true },
  { "wellproducedwines.com", true },
  { "wellsolveit.com", true },
  { "wellspringcamps.com", true },
  { "welovemail.com", true },
  { "welpy.com", true },
  { "welsh.com.br", true },
  { "welteneroberer.de", true },
  { "weltengilde.de", true },
  { "weltenhueter.de", true },
  { "weltentreff.com", true },
  { "weltmeisterschaft.net", true },
  { "wemakemenus.com", true },
  { "weme.eu", true },
  { "wendigo.pl", true },
  { "wenjs.me", true },
  { "wepay.com", false },
  { "wepay.in.th", true },
  { "wer-kommt-her.de", true },
  { "werally.com", true },
  { "werbewelt-tv.de", true },
  { "wereldkoffie.eu", true },
  { "wereldplanner.nl", true },
  { "werken-bij-inwork.nl", true },
  { "werkplaatsoost.nl", false },
  { "werktor.com", true },
  { "werktor.net", true },
  { "wernerschaeffer.de", true },
  { "wesecom.com", false },
  { "wesell.asia", true },
  { "weserv.nl", true },
  { "wesleycabus.be", true },
  { "wessner.org", true },
  { "west-wind.net", true },
  { "westcountrystalking.com", true },
  { "westeros.hu", true },
  { "westhighlandwhiteterrier.com.br", true },
  { "westsuburbanbank.com", true },
  { "westsussexconnecttosupport.org", true },
  { "wetherbymethodist.org.uk", true },
  { "wetherbyweather.org.uk", true },
  { "wetofu.top", true },
  { "wetoxic.com", true },
  { "wettbonus.info", true },
  { "wetthost.com", true },
  { "wevahoo.com", true },
  { "wevenues.com", true },
  { "wevolver.com", true },
  { "wewlad.me", true },
  { "wf-bigsky-master.appspot.com", true },
  { "wf-demo-eu.appspot.com", true },
  { "wf-demo-hrd.appspot.com", true },
  { "wf-dogfood-hrd.appspot.com", true },
  { "wf-hosting.de", true },
  { "wf-pentest.appspot.com", true },
  { "wf-staging-hr.appspot.com", true },
  { "wf-training-hrd.appspot.com", true },
  { "wf-training-master.appspot.com", true },
  { "wf-trial-hrd.appspot.com", true },
  { "wfh.ovh", true },
  { "wfh.se", true },
  { "wg-tools.de", true },
  { "wg3k.us", true },
  { "wh-guide.de", true },
  { "whatagreatwebsite.net", true },
  { "whatanime.ga", true },
  { "whatismyipaddress.ca", true },
  { "whatsapp.com", true },
  { "whatsmychaincert.com", true },
  { "whatsstalk.me", true },
  { "whatsupgold.com.tw", true },
  { "whatsyouroffer.co.uk", true },
  { "whatwebcando.today", true },
  { "whatwg.org", true },
  { "whd-guide.de", true },
  { "wheeler.kiwi.nz", true },
  { "when-release.ru", false },
  { "when.fm", true },
  { "where2trip.com", true },
  { "whereisjason.com", true },
  { "wherephoto.com", false },
  { "whey-protein.ch", true },
  { "whing.org", true },
  { "whipnic.com", true },
  { "whisker.network", true },
  { "whiskynerd.ca", true },
  { "whisp.ly", false },
  { "whispeer.de", true },
  { "whistleb.com", true },
  { "whistleblower.gov", true },
  { "whitehat.id", false },
  { "whitehouse.gov", true },
  { "whitelabelcashback.nl", true },
  { "whiterabbitcakery.com", true },
  { "whiteroom.agency", true },
  { "whitkirkartsguild.com", true },
  { "whitkirkchurch.org.uk", true },
  { "whitworth.nyc", true },
  { "whmcs.hosting", true },
  { "who.pm", true },
  { "whocalld.com", true },
  { "whocalled.us", true },
  { "wholesomeharvestbread.com", true },
  { "wholikes.us", true },
  { "whonix.org", true },
  { "whoownsmyavailability.com", true },
  { "wiberg.nu", true },
  { "wibuw.com", true },
  { "wideboxmacau.com", false },
  { "widemann.de", true },
  { "widememory.com", true },
  { "widsl.de", true },
  { "wiedmeyer.de", true },
  { "wiedu.net", true },
  { "wiegedaten.de", true },
  { "wienergyjobs.com", true },
  { "wifimask.com", true },
  { "wifirst.net", true },
  { "wigggle.it", true },
  { "wigle.net", true },
  { "wiimotion.de", true },
  { "wiire.me", true },
  { "wijnservices.nl", false },
  { "wiki.python.org", true },
  { "wikibooks.org", true },
  { "wikiclash.info", false },
  { "wikidata.org", true },
  { "wikidsystems.com", false },
  { "wikileaks.com", true },
  { "wikileaks.org", true },
  { "wikimedia.org", true },
  { "wikimediafoundation.org", true },
  { "wikimilk.org", true },
  { "wikinews.org", true },
  { "wikipedia.org", true },
  { "wikiquote.org", true },
  { "wikisource.org", true },
  { "wikisports.eu", true },
  { "wikiversity.org", true },
  { "wikivoyage.org", true },
  { "wiktionary.org", true },
  { "wiktoriaslife.com", true },
  { "wild-emotion-events.de", true },
  { "wildbee.org", true },
  { "wilddog.com", true },
  { "wilf1rst.com", true },
  { "willberg.bayern", true },
  { "willcipriano.com", true },
  { "willfarrell.ca", true },
  { "willi-graf-gymnasium.de", true },
  { "willi-graf-os.de", true },
  { "williamfeely.info", true },
  { "williamsapiens.com", true },
  { "williamsonshore.com", true },
  { "willnorris.com", true },
  { "wills.co.tt", true },
  { "willstamper.name", true },
  { "wilsonovi.com", true },
  { "wimake.solutions", true },
  { "wind.moe", true },
  { "windhaven.nl", true },
  { "windrunner.se", true },
  { "windscribe.com", true },
  { "winebid.com", true },
  { "winged.io", true },
  { "winghill.com", false },
  { "wingos.net", true },
  { "wingumd.net", true },
  { "winhistory-forum.net", true },
  { "winmodels.org", true },
  { "winmodels.ru", true },
  { "winsufi.biz", true },
  { "wint.global", true },
  { "winter.engineering", false },
  { "winterbergwebcams.com", true },
  { "winterfeldt.de", true },
  { "winterhillbank.com", true },
  { "wintodoor.com", true },
  { "wipply.com", false },
  { "wirc.gr", true },
  { "wircon-int.net", true },
  { "wireheading.com", true },
  { "wireshark.org", true },
  { "wiretrip.io", true },
  { "wirhabenspass.de", true },
  { "wirkstoffreich.de", true },
  { "wirsol.com", true },
  { "wis.no", true },
  { "wishcert.com", true },
  { "wispapp.com", true },
  { "wisv.ch", true },
  { "wisweb.no", true },
  { "witae.com", true },
  { "withgoogle.com", true },
  { "withinsecurity.com", true },
  { "withmy.beer", true },
  { "withyoutube.com", true },
  { "wittcher.com", true },
  { "witway.nl", false },
  { "wiz.at", true },
  { "wizzley.com", false },
  { "wizzr.nl", true },
  { "wje-online.de", true },
  { "wjglerum.nl", true },
  { "wkv.com", true },
  { "wkz.io", true },
  { "wlaws.com", true },
  { "wlzhiyin.cn", true },
  { "wm-talk.net", true },
  { "wmawri.com", true },
  { "wmcuk.net", true },
  { "wmfusercontent.org", true },
  { "wnmm.nl", true },
  { "wnu.com", true },
  { "wo2forum.nl", false },
  { "wobble.ninja", true },
  { "wobblylang.org", true },
  { "wochenentwicklung.com", true },
  { "wod-stavby.cz", true },
  { "wodice.com", true },
  { "wodinaz.com", true },
  { "wodka-division.de", true },
  { "wofford-ecs.org", true },
  { "woffs.de", true },
  { "wohlgemuth.rocks", false },
  { "wohnsitz-ausland.com", true },
  { "wolfachtal-alpaka.de", true },
  { "wolfemg.com", true },
  { "wolfesden.com", true },
  { "wolfeyesusa.com", true },
  { "wolfgang-kerschbaumer.at", true },
  { "wolfgang-kerschbaumer.com", true },
  { "wolfgang-kerschbaumer.net", true },
  { "wolfie.ovh", true },
  { "wolfsden.cz", true },
  { "wolfwings.us", true },
  { "wollwerk.org", true },
  { "womb.city", true },
  { "womf.org", true },
  { "wonder.com.mx", true },
  { "wonderhost.info", true },
  { "wonderlandmovies.de", true },
  { "wondermags.com", true },
  { "wondershift.biz", true },
  { "wondy.com", true },
  { "woodbury.io", true },
  { "woodlandschurch.net", true },
  { "woodlandsmetro.church", true },
  { "woodomat.com", true },
  { "woodsidepottery.ca", true },
  { "woording.com", true },
  { "wootton95.com", true },
  { "wooviet.com", true },
  { "worcesterfestival.co.uk", true },
  { "word-grabber.com", true },
  { "wordpress.com", false },
  { "wordsmart.it", true },
  { "wordxtra.net", true },
  { "work-and-jockel.de", true },
  { "workingclassmedia.com", true },
  { "workray.com", true },
  { "works-ginan.jp", true },
  { "workwithgo.com", true },
  { "world-in-my-eyes.com", true },
  { "worldcubeassociation.org", true },
  { "worldeventscalendars.com", true },
  { "worldofbelia.de", true },
  { "worldpovertysolutions.org", true },
  { "wormdisk.net", true },
  { "wormholevpn.net", true },
  { "worshapp.com", true },
  { "woufbox.com", true },
  { "woutergeraedts.nl", true },
  { "woutervdb.com", true },
  { "wow-foederation.de", true },
  { "wowhelp.it", true },
  { "wowjs.co.uk", true },
  { "wowjs.org", true },
  { "wowjs.uk", true },
  { "wownmedia.com", true },
  { "wp-fastsearch.de", true },
  { "wp-mix.com", true },
  { "wp-tao.com", true },
  { "wpac.de", true },
  { "wpcarer.pro", true },
  { "wpdublin.com", true },
  { "wphostingblog.nl", true },
  { "wpinfos.de", true },
  { "wpletter.de", false },
  { "wpmeetup-berlin.de", true },
  { "wpostats.com", true },
  { "wpruby.com", true },
  { "wpserp.com", true },
  { "wpsono.com", true },
  { "wpvulndb.com", true },
  { "wpyecom.es", true },
  { "wpzhiku.com", true },
  { "wql.zj.cn", true },
  { "wr.su", true },
  { "wrara.org", true },
  { "wrbunderwriting.com", true },
  { "wrgms.com", true },
  { "wrightdoumawedding.com", true },
  { "writeoff.me", true },
  { "wrldevelopment.com", true },
  { "wrp.gov", true },
  { "wrwg.ca", true },
  { "wsa.poznan.pl", true },
  { "wscales.com", true },
  { "wsdcapital.com", true },
  { "wsdezign.com", false },
  { "wselektro.de", true },
  { "wsgvet.com", true },
  { "wss.com.ve", true },
  { "wsv-grafenau.de", true },
  { "wt-server3.de", true },
  { "wtf.ninja", true },
  { "wtfismyip.com", true },
  { "wth.in", true },
  { "wubocong.com", true },
  { "wubthecaptain.eu", true },
  { "wuetix.de", true },
  { "wuji.cz", true },
  { "wukongmusic.us", true },
  { "wumbo.co.nz", true },
  { "wunderkarten.de", true },
  { "wunderlist.com", true },
  { "wundi.net", true },
  { "wundtherapie-schulung.de", true },
  { "wurzelzwerg.net", true },
  { "wv-n.de", true },
  { "wvg.myds.me", true },
  { "wvr-law.de", false },
  { "ww2onlineshop.com", false },
  { "www.aclu.org", false },
  { "www.airbnb.com", true },
  { "www.amazon.ca", true },
  { "www.amazon.cn", true },
  { "www.amazon.co.jp", true },
  { "www.amazon.co.uk", true },
  { "www.amazon.com", true },
  { "www.amazon.com.au", true },
  { "www.amazon.com.br", true },
  { "www.amazon.com.mx", true },
  { "www.amazon.de", true },
  { "www.amazon.es", true },
  { "www.amazon.fr", true },
  { "www.amazon.it", true },
  { "www.amazon.nl", true },
  { "www.banking.co.at", false },
  { "www.capitainetrain.com", false },
  { "www.captaintrain.com", false },
  { "www.cloudflare.com", false },
  { "www.dropbox.com", true },
  { "www.dropcam.com", false },
  { "www.entropia.de", false },
  { "www.eternalgoth.co.uk", true },
  { "www.etsy.com", true },
  { "www.evernote.com", false },
  { "www.facebook.com", false },
  { "www.fastmail.com", true },
  { "www.getcloak.com", false },
  { "www.gmail.com", false },
  { "www.googlemail.com", false },
  { "www.gov.uk", false },
  { "www.gpo.gov", false },
  { "www.grc.com", false },
  { "www.healthcare.gov", false },
  { "www.heliosnet.com", true },
  { "www.icann.org", false },
  { "www.intercom.io", true },
  { "www.irccloud.com", false },
  { "www.lastpass.com", false },
  { "www.ledgerscope.net", false },
  { "www.linode.com", false },
  { "www.lookout.com", false },
  { "www.makeyourlaws.org", true },
  { "www.mydigipass.com", false },
  { "www.mylookout.com", false },
  { "www.noisebridge.net", false },
  { "www.opsmate.com", true },
  { "www.paypal.com", false },
  { "www.python.org", true },
  { "www.rememberthemilk.com", false },
  { "www.sb", true },
  { "www.schokokeks.org", true },
  { "www.simbolo.co.uk", false },
  { "www.simple.com", false },
  { "www.theguardian.com", true },
  { "www.therapynotes.com", true },
  { "www.tinfoilsecurity.com", false },
  { "www.torproject.org", false },
  { "www.twitter.com", false },
  { "www.united.com", false },
  { "www.usaa.com", false },
  { "www.viasinc.com", true },
  { "www.vino75.com", false },
  { "www.wepay.com", false },
  { "www.wordpress.com", false },
  { "wxcafe.net", true },
  { "wxster.com", true },
  { "wy6.org", true },
  { "wyam.io", true },
  { "wybmabiity.com", true },
  { "wyday.com", true },
  { "wyeworks.com", true },
  { "wynterhill.co.uk", true },
  { "wypemagazine.se", true },
  { "wzrd.in", true },
  { "wzyboy.org", true },
  { "x-iweb.ru", true },
  { "x-ripped-hd.com", true },
  { "x.io", true },
  { "x.st", true },
  { "x3led.com", true },
  { "x509.io", true },
  { "x509.pub", true },
  { "x509.pw", true },
  { "x64architecture.com", true },
  { "xa1.uk", true },
  { "xalqbank-online.az", true },
  { "xandocs.com", true },
  { "xat.re", true },
  { "xatr0z.org", false },
  { "xbb.hk", true },
  { "xbb.li", true },
  { "xbind.io", true },
  { "xboxdownloadthat.com", true },
  { "xboxlivegoldshop.nl", true },
  { "xbrlsuccess.appspot.com", true },
  { "xbt.co", true },
  { "xbtce.com", true },
  { "xbtmusic.org", true },
  { "xcentricmold.com", true },
  { "xclirion-support.de", true },
  { "xcoop.me", true },
  { "xd.cm", true },
  { "xdd.io", true },
  { "xdeftor.com", true },
  { "xecureit.com", true },
  { "xellos.ga", true },
  { "xellos.ml", true },
  { "xenesisziarovky.sk", true },
  { "xenophile.name", true },
  { "xerhost.de", false },
  { "xetown.com", true },
  { "xfix.pw", true },
  { "xfrag-networks.com", false },
  { "xg3n1us.de", true },
  { "xgclan.com", true },
  { "xho.me", true },
  { "xiamuzi.com", true },
  { "xiangweiqing.co.uk", true },
  { "xiaody.me", true },
  { "xiaofengsky.com", true },
  { "xiaoguo.net", true },
  { "xiaolan.me", true },
  { "xiaolvmu.com", true },
  { "xiaolvmu.me", true },
  { "xiazhanjian.com", true },
  { "xichtsbuch.de", true },
  { "xichuangke.com", true },
  { "xicreative.net", true },
  { "xight.org", true },
  { "xilef.org", true },
  { "xilkoi.net", true },
  { "ximage.me", false },
  { "ximbo.net", true },
  { "xinbiji.cn", true },
  { "xing.ml", true },
  { "xiqi.us", true },
  { "xisa.it", true },
  { "xivpn.com", true },
  { "xjoin.de", true },
  { "xkbcommon.org", false },
  { "xkviz.net", true },
  { "xlange.com", true },
  { "xliu.cf", true },
  { "xmedius.com", true },
  { "xmedius.eu", true },
  { "xmerak.com", true },
  { "xmlbeam.org", true },
  { "xmonk.org", true },
  { "xmpp.dk", true },
  { "xmppwocky.net", true },
  { "xmr.my", true },
  { "xmr.to", true },
  { "xmv.cz", true },
  { "xn--3lqp21gwna.cn", true },
  { "xn--3lqp21gwna.xn--fiqs8s", true },
  { "xn--3lqp21gwna.xn--fiqz9s", true },
  { "xn--4dbjwf8c.cf", true },
  { "xn--4dbjwf8c.ga", true },
  { "xn--4dbjwf8c.gq", true },
  { "xn--4dbjwf8c.ml", true },
  { "xn--4dbjwf8c.tk", true },
  { "xn--7v8h.cf", true },
  { "xn--7xa.google.com", true },
  { "xn--80aocgsfei.xn--p1ai", true },
  { "xn--8mr166hf6s.xn--fiqs8s", true },
  { "xn--allgu-biker-o8a.de", true },
  { "xn--aviao-dra1a.pt", true },
  { "xn--detrkl13b9sbv53j.com", true },
  { "xn--detrkl13b9sbv53j.org", true },
  { "xn--dmonenjger-q5ag.net", true },
  { "xn--fischereiverein-mnsterhausen-i7c.de", true },
  { "xn--hfk-allgu-schwaben-stb.de", true },
  { "xn--jda.tk", true },
  { "xn--jobbrse-d1a.de", true },
  { "xn--jp-6l5cs1yf3ivjsglphyv.net", true },
  { "xn--kda.tk", true },
  { "xn--knstler-n2a.tips", false },
  { "xn--lgb3a8bcpn.cf", true },
  { "xn--lgb3a8bcpn.ga", true },
  { "xn--lgb3a8bcpn.gq", true },
  { "xn--lgb3a8bcpn.ml", true },
  { "xn--ls8hi7a.tk", true },
  { "xn--lsaupp-iua.se", true },
  { "xn--lsupp-mra.net", true },
  { "xn--maraa-rta.org", true },
  { "xn--mentaltraining-fr-musiker-uwc.ch", true },
  { "xn--pbt947am3ab71g.com", true },
  { "xn--pq1a637b.xn--6qq986b3xl", true },
  { "xn--qckss0j.tk", true },
  { "xn--rdiger-kuhlmann-zvb.de", true },
  { "xn--rt-cja.eu", true },
  { "xn--ruanmller-u9a.com", true },
  { "xn--spenijmazania-yhc.pl", true },
  { "xn--t8j4aa4nyhxa7duezbl49aqg5546e264d.net", true },
  { "xn--thorme-6uaf.ca", true },
  { "xn--u9jv84l7ea468b.com", true },
  { "xn--v-wfa35g.ro", true },
  { "xn--werner-schffer-fib.de", true },
  { "xn--xdtx3pfzbiw3ar8e7yedqrhui.com", true },
  { "xn--y8j148r.xn--q9jyb4c", true },
  { "xn--yoamomisuasbcn-ynb.com", true },
  { "xn5.de", true },
  { "xng.io", false },
  { "xo.tc", true },
  { "xobox.me", true },
  { "xolphin.nl", true },
  { "xom.party", true },
  { "xotika.tv", true },
  { "xp2.de", true },
  { "xpd.se", true },
  { "xperidia.com", true },
  { "xpi.fr", true },
  { "xpj.sx", true },
  { "xplore-dna.net", true },
  { "xps2pdf.co.uk", true },
  { "xqin.net", true },
  { "xrippedhd.com", true },
  { "xrockx.de", true },
  { "xroot.org", true },
  { "xscancun.com", true },
  { "xscapers.com", true },
  { "xsmobile.de", true },
  { "xss.ht", true },
  { "xss.sk", true },
  { "xsyds.cn", true },
  { "xsz.jp", true },
  { "xtarget.ru", true },
  { "xtom.com", true },
  { "xtom.email", true },
  { "xtremegaming.it", true },
  { "xtrim.ru", true },
  { "xtronics.com", true },
  { "xuc.me", true },
  { "xuexb.com", true },
  { "xunn.io", true },
  { "xuntier.ch", true },
  { "xuwei.de", true },
  { "xwalck.se", true },
  { "xwaretech.info", true },
  { "xyfun.net", true },
  { "xyndrac.net", true },
  { "xynta.ch", true },
  { "yabrt.cn", true },
  { "yachts-magazine.com", true },
  { "yacobo.com", true },
  { "yafuoku.ru", true },
  { "yagihiro.tech", true },
  { "yahoo.ax", true },
  { "yahvehyireh.com", true },
  { "yak.is", true },
  { "yakmade.com", true },
  { "yakmoo.se", true },
  { "yal.sh", true },
  { "yamadaya.tv", true },
  { "yamaken.jp", false },
  { "yamamo10.com", true },
  { "yame2.com", true },
  { "yameveo.com", false },
  { "yanaduday.com", true },
  { "yanovich.net", true },
  { "yantrasthal.com", true },
  { "yaoidreams.com", true },
  { "yapbreak.fr", true },
  { "yarchives.jp", true },
  { "yarcom.ru", false },
  { "yardbird.us", true },
  { "yarogneva.ru", true },
  { "yasutomonodokoiko.com", true },
  { "yatesun.com", true },
  { "yatorie.net", true },
  { "yaucy.win", true },
  { "yaup.tk", true },
  { "yawen.tw", true },
  { "yawnbox.com", true },
  { "yaxim.org", true },
  { "ycc.wtf", false },
  { "yclan.net", true },
  { "ydy.jp", true },
  { "yecl.net", true },
  { "yello.website", true },
  { "yellowcar.website", true },
  { "yenniferallulli.com", true },
  { "yenniferallulli.de", true },
  { "yenniferallulli.moda", true },
  { "yenniferallulli.nl", true },
  { "yesdevnull.net", true },
  { "yesiammaisey.me", true },
  { "yesonline.asia", false },
  { "yesonline.me", false },
  { "yeswehack.com", true },
  { "yetii.net", true },
  { "yetzt.me", false },
  { "yeu.io", true },
  { "yhb.io", true },
  { "yhori.xyz", true },
  { "yhrd.org", true },
  { "yii2.cc", true },
  { "yikzu.cn", true },
  { "yinfor.com", true },
  { "yingatech.com", true },
  { "yinlei.org", true },
  { "yizhu.com", true },
  { "yjsw.sh.cn", true },
  { "yksityisyydensuoja.fi", true },
  { "ylinternal.com", true },
  { "ylk.io", true },
  { "ymarion.de", true },
  { "ympl.de", true },
  { "ynode.com", true },
  { "yntongji.com", true },
  { "yobai-grouprec.jp", true },
  { "yobai28.com", true },
  { "yobst.tk", false },
  { "yoga-prive.de", true },
  { "yoga-school.xyz", true },
  { "yoga.is-an-engineer.com", true },
  { "yogeshbeniwal.com", true },
  { "yoitsu.moe", true },
  { "yolobert.de", true },
  { "yolocelebs.com", false },
  { "yoloprod.fr", true },
  { "yoloseo.com", true },
  { "yombo.net", true },
  { "yooooex.com", true },
  { "yoramvandevelde.net", true },
  { "yorcom.nl", false },
  { "yorkshireterrier.com.br", true },
  { "yorname.ml", true },
  { "yosemo.de", true },
  { "yotilab.com", true },
  { "yotilabs.com", true },
  { "yotubaiotona.net", true },
  { "youcancraft.de", true },
  { "youcontrol.ru", true },
  { "youcruit.com", true },
  { "youdowell.com", true },
  { "youkaryote.com", true },
  { "youkaryote.org", true },
  { "youkok2.com", true },
  { "youlend.com", true },
  { "youngdogs.org", true },
  { "youon.tokyo", true },
  { "youpark.no", true },
  { "youran.me", true },
  { "yourbapp.ch", true },
  { "yourciso.com", true },
  { "yourcopywriter.it", true },
  { "yourdaddy.dk", true },
  { "yourgame.co.il", true },
  { "yoursecondphone.co", true },
  { "yourself.today", true },
  { "yourstrongbox.com", true },
  { "yourznc.com", true },
  { "yout.com", true },
  { "youtous.me", true },
  { "youtubedownloader.com", true },
  { "youyoulemon.com", true },
  { "yoyoost.duckdns.org", true },
  { "ypart.eu", false },
  { "ypcs.fi", true },
  { "ypid.de", true },
  { "ypiresia.fr", false },
  { "yplanapp.com", true },
  { "ys-shop.biz", true },
  { "ytcuber.xyz", true },
  { "ytec.ca", true },
  { "ytuquelees.net", true },
  { "ytvwld.de", true },
  { "yuanben.io", true },
  { "yuanbenlian.com", true },
  { "yufan.me", true },
  { "yuka.one", true },
  { "yuki.xyz", true },
  { "yukiminami.net", true },
  { "yuko.moe", true },
  { "yukonconnector.com", true },
  { "yukonlip.com", true },
  { "yukontec.com", true },
  { "yum.beer", true },
  { "yunity.org", true },
  { "yunjishou.pro", true },
  { "yunpan.blue", true },
  { "yunzhu.org", true },
  { "yuricarlenzoli.it", true },
  { "yusa.me", true },
  { "yutabon.com", false },
  { "yutangyun.com", true },
  { "yuushou.com", true },
  { "yux.fr", true },
  { "yuzu.tk", true },
  { "yvesx.com", true },
  { "yyyy.xyz", true },
  { "yzal.io", false },
  { "z-konzept-nutrition.ru", true },
  { "z-vector.com", true },
  { "z.ai", true },
  { "z0rro.net", true },
  { "z1h.de", true },
  { "z99944x.xyz", true },
  { "zaalleatherwear.nl", false },
  { "zabszk.net", true },
  { "zacarias.com.ar", true },
  { "zachborboa.com", true },
  { "zachgibbens.org", true },
  { "zachpeters.org", true },
  { "zadroweb.com", true },
  { "zafirus.name", true },
  { "zahe.me", true },
  { "zaidan.de", true },
  { "zaidan.eu", true },
  { "zaidanfood.com", true },
  { "zaidanfood.eu", true },
  { "zaidanlebensmittelhandel.de", true },
  { "zakcutner.uk", true },
  { "zakmccrac.de", true },
  { "zakoncontrol.com", true },
  { "zakr.es", true },
  { "zalan.do", true },
  { "zandcell.com", true },
  { "zanthra.com", true },
  { "zao.fi", true },
  { "zaoshanghao-dajia.rhcloud.com", true },
  { "zap.yt", true },
  { "zapier.com", true },
  { "zappbuildapps.com", true },
  { "zary.me", true },
  { "zaufanatrzeciastrona.pl", true },
  { "zavca.com", true },
  { "zbasenem.pl", true },
  { "zbchen.com", true },
  { "zberger.com", true },
  { "zbrane-doplnky.cz", true },
  { "zbyga.cz", true },
  { "zcarot.com", true },
  { "zcarrot.com", true },
  { "zcon.nl", true },
  { "zcr.ca", true },
  { "zdbl.de", true },
  { "zdrojak.cz", true },
  { "ze3kr.com", true },
  { "zebry.nl", true },
  { "zeebrieshoekvanholland.nl", true },
  { "zeedroom.be", true },
  { "zeel.com", true },
  { "zefu.ca", true },
  { "zehdenick-bleibt-bunt.de", true },
  { "zehntner.ch", true },
  { "zeitpunkt-kulturmagazin.de", true },
  { "zeitzer-turngala.de", true },
  { "zelfrijdendeautos.com", true },
  { "zellari.ru", true },
  { "zemlova.cz", true },
  { "zen-ume.com", true },
  { "zenhaiku.com", true },
  { "zenithmedia.ca", true },
  { "zenk-security.com", true },
  { "zenlogic.com", true },
  { "zenmate.com.tr", true },
  { "zeno-system.com", true },
  { "zenvideocloud.com", true },
  { "zenycosta.com", true },
  { "zeplin.io", true },
  { "zer0-day.pw", true },
  { "zer0.de", true },
  { "zera.com.au", true },
  { "zerekin.net", true },
  { "zerocool.io", true },
  { "zerolab.org", true },
  { "zeroling.com", true },
  { "zeronet.io", true },
  { "zeropush.com", true },
  { "zerossl.com", true },
  { "zertif.info", true },
  { "zespia.tw", false },
  { "zeto365.pl", true },
  { "zetorzeszow.pl", true },
  { "zettaplan.ru", true },
  { "zewtie.com", true },
  { "zeytin.pro", true },
  { "zgrep.org", true },
  { "zh1.li", true },
  { "zhang-hao.com", true },
  { "zhangge.net", true },
  { "zhanghao.me", true },
  { "zhangruilin.com", true },
  { "zhangyuhao.com", true },
  { "zhaochen.xyz", true },
  { "zhaofeng.li", true },
  { "zhengjie.com", true },
  { "zhengzexin.com", true },
  { "zhh.in", true },
  { "zhihua-lai.com", true },
  { "zhousiru.com", false },
  { "zhovner.com", true },
  { "zi0r.com", true },
  { "zicklam.com", true },
  { "zifb.in", true },
  { "zigcore.com.br", true },
  { "zigzagmart.com", true },
  { "zihao.me", true },
  { "ziin.de", false },
  { "zilore.com", true },
  { "zima.io", true },
  { "zimiao.moe", true },
  { "zinc-x.com", true },
  { "zinenapse.info", true },
  { "zingarastore.com", true },
  { "zingjerijk.nl", true },
  { "zionvps.com", false },
  { "zippy-download.com", true },
  { "zippy-download.de", true },
  { "ziptie.com", true },
  { "zirtue.io", true },
  { "zittingskalender.be", true },
  { "zivy-ruzenec.cz", true },
  { "zivyruzenec.cz", true },
  { "zixiao.wang", true },
  { "ziyuanabc.xyz", true },
  { "zizoo.com", true },
  { "zju.tv", true },
  { "zjubtv.com", true },
  { "zjutv.com", true },
  { "zk.gd", true },
  { "zkrypt.cc", true },
  { "zlatosnadno.cz", true },
  { "zlavomat.sk", true },
  { "zlc1994.com", true },
  { "zmsastro.co.za", true },
  { "znation.nl", true },
  { "zning.net.cn", true },
  { "zockenbiszumumfallen.de", true },
  { "zoe.vc", true },
  { "zoeller.me", true },
  { "zohar.link", true },
  { "zohar.wang", true },
  { "zoigl.club", true },
  { "zojadravai.com", true },
  { "zolotoy-standart.com.ua", true },
  { "zombiesecured.com", true },
  { "zomiac.pp.ua", true },
  { "zonecb.com", true },
  { "zonemaster.net", true },
  { "zonglovani.info", true },
  { "zonky.io", true },
  { "zoom.earth", true },
  { "zooom.azurewebsites.net", true },
  { "zooparadies.eu", true },
  { "zoowiki.us", true },
  { "zopyx.com", true },
  { "zor.com", true },
  { "zorgclustertool.nl", true },
  { "zorium.org", true },
  { "zorntt.fr", true },
  { "zortium.report", true },
  { "zorz.info", true },
  { "zotero.org", true },
  { "zqjs.tk", true },
  { "zravypapir.cz", true },
  { "zrn.in", false },
  { "zscales.com", true },
  { "ztan.tk", true },
  { "zten.org", true },
  { "zubel.it", true },
  { "zuckerfloh.de", true },
  { "zulu.ro", true },
  { "zulu7.com", true },
  { "zund-app.com", true },
  { "zundapp529.nl", true },
  { "zundappachterhoek.nl", true },
  { "zunftmarke.de", true },
  { "zuolan.me", true },
  { "zup.me", true },
  { "zupago.com", true },
  { "zupago.pe", true },
  { "zuram.net", true },
  { "zuviel.space", true },
  { "zvps.uk", true },
  { "zvxr.net", true },
  { "zwerimex.com", true },
  { "zwollemag.nl", true },
  { "zx6rninja.de", true },
  { "zybbo.com", true },
  { "zyf.pw", true },
  { "zymbit.com", true },
  { "zypgr.com", true },
  { "zyria.de", true },
  { "zzsec.org", true },
  { "zzw.ca", true },
};
