/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://jwsdp.dev.java.net/CDDLv1.0.html
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * https://jwsdp.dev.java.net/CDDLv1.0.html  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 */
package testutil;

import javax.xml.namespace.QName;

import com.sun.xml.txw2.TypedXmlWriter;

import com.sun.xml.ws.api.model.CheckedException;
import com.sun.xml.ws.api.wsdl.writer.WSDLGeneratorExtension;

import java.lang.reflect.Method;


public class WSDLGeneratorExtensionImpl extends WSDLGeneratorExtension {
    private void addAttribute(TypedXmlWriter writer, String attrName, String attrValue) {
        writer._attribute(new QName("jaxws_test", attrName), attrValue);
    }

    public void addServiceExtension(TypedXmlWriter service) {
        addAttribute(service, "serviceAttr", "myService");
    }

    public void addPortExtension(TypedXmlWriter port) {
        addAttribute(port, "portAttr", "myPort");
    }

    public void addPortTypeExtension(TypedXmlWriter portType) {
        addAttribute(portType, "portTypeAttr", "myPortType");
    }

    public void addBindingExtension(TypedXmlWriter binding) {
        addAttribute(binding, "bindingAttr", "myBinding");
    }

    public void addOperationExtension(TypedXmlWriter operation, Method method) {
        addAttribute(operation, "operationAttr", "myOperation");
    }

    public void addBindingOperationExtension(TypedXmlWriter operation, Method method) {
        addAttribute(operation, "bindingOperationAttr", "myBindingOperation");
    }

    public void addInputMessageExtension(TypedXmlWriter message, Method method) {
        addAttribute(message, "inputMessageAttr", "myInputMessage");
    }

    public void addOutputMessageExtension(TypedXmlWriter message, Method method) {
        addAttribute(message, "outputMessageAttr", "myOutputMessage");
    }

    public void addOperationInputExtension(TypedXmlWriter input, Method method) {
        addAttribute(input, "operationInputAttr", "myOperationInput");
    }

    public void addOperationOutputExtension(TypedXmlWriter output, Method method) {
        addAttribute(output, "operationOutputAttr", "myOperationOutput");
    }

    public void addBindingOperationInputExtension(TypedXmlWriter input, Method method) {
        addAttribute(input, "bindingOperationInputAttr", "myBindingOperationInput");
    }

    public void addBindingOperationOutputExtension(TypedXmlWriter output, Method method) {
        addAttribute(output, "bindingOperationOutputAttr", "myBindingOperationOutput");
    }

    public void addBindingOperationFaultExtension(TypedXmlWriter fault, Method method) {
        addAttribute(fault, "bindingOperationFaultAttr", "myBindingOperationFault");
    }

    public void addFaultMessageExtension(TypedXmlWriter message, Method method) {
        addAttribute(message, "faultMessageAttr", "myFaultMessage");
    }

    public void addOperationFaultExtension(TypedXmlWriter fault, Method method, CheckedException ce) {
        addAttribute(fault, "operationFaultAttr", "myOperationFault");
    }
}
